/**************************************************************************//**
 * @file     os_systick.c
 * @brief    CMSIS OS Tick SysTick implementation
 * @version  V1.0.1
 * @date     29. November 2017
 ******************************************************************************/
/*
 * Copyright (c) 2017-2017 Arm Limited. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef GS32F00xx
#include "GS32F00xx.h"
#elif defined GS32F3xx
#include "GS32F3xx.h"
#endif
#include "os_tick.h"

#ifndef SYSTICK_IRQ_PRIORITY
#define SYSTICK_IRQ_PRIORITY    0xFFU
#endif

static uint8_t PendST;

// Setup OS Tick.
__WEAK int32_t OS_Tick_Setup (uint32_t freq, void *handler)
{
//  uint32_t load;
//  (void)handler;
//
//  if (freq == 0U) {
//    return (-1);
//  }
//
//  load = (SystemCoreClock / freq) - 1U;
//  if (load > 0x00FFFFFFU) {
//    return (-1);
//  }
//
//  NVIC_SetPriority(SysTick_IRQn, SYSTICK_IRQ_PRIORITY);
//
//  SysTick->CTRL =  SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_TICKINT_Msk;
//  SysTick->LOAD =  load;
//  SysTick->VAL  =  0U;
//
//  PendST = 0U;

  return (0);
}


// Get OS Tick interval.
__WEAK uint32_t OS_Tick_GetInterval (void)
{
  //return (SysTick->LOAD + 1U);
}

// Get OS Tick count value.
__WEAK uint32_t OS_Tick_GetCount (void)
{
//  uint32_t load = SysTick->LOAD;
//  return  (load - SysTick->VAL);
}

// Get OS Tick overflow status.
__WEAK uint32_t OS_Tick_GetOverflow (void)
{
//  return ((SysTick->CTRL >> 16) & 1U);
}

