/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    cpu.h
*   @brief   
*
*/
/*
 * commit history
 * 20240313, Jason, add ESTOP0==__EBREAK() define for DSP core.
 * 20240531, Jason, add NOP definition
 */

#ifndef DRIVERLIB_CPU_H_
#define DRIVERLIB_CPU_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "gs32_version.h"
#include "inc/hw_types.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#if IS_GS32F00xx()
#include "device_gs32f00xx/gs32f00xx.h"
#elif IS_GS32F3xx()
#include "device_gs32f3xx/gs32f3xx.h"
#else
#error Device must be defined
#endif

//
// Define to enable interrupts
//
#ifndef EINT
#define EINT   __enable_irq()
#endif

//
// Define to disable interrupts
//
#ifndef DINT
#define DINT   __disable_irq()
#endif

//
// Define for emulation stop
//
#define ESTOP0 __EBREAK()
#define NOP    __NOP()

/*
 * @brief    read CPU cycle counter
 * @param    none
 * @return   CPU cycle counter register value
 */
__STATIC_INLINE uint32_t CPU_getCycleCnt(void){
	return __RV_CSR_READ(CSR_MCYCLE);
}

/*
 * @brief    clear CPU cycle counter
 * @param    none
 * @return   none
 */
__STATIC_INLINE void CPU_clearCycleCnt(void){
	__RV_CSR_WRITE(CSR_MCYCLE, 0);
}

/*
 * @brief    read CPU instructions counter
 * @param    none
 * @return   CPU instructions counter register value
 */
__STATIC_INLINE uint32_t CPU_getInstrCnt(void){
	return __RV_CSR_READ(CSR_MINSTRET);
}

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */



#ifdef __cplusplus
}
#endif


#endif /* DEVICE_DRIVERLIB_CPU_H_ */
