/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_ints.h
*   @brief   
*
*   commit history
*   2024/03/13, Zhao Lei, add 3.0 irq number
*   2024/03/29, Zhao Lei, update 3.0 DMA/SPIA/SPIB irq number
*   2024/05/13, Zhaolei, update 3.0 JTAG/I2C/SCI/DMA/SPI/ENC/CAN interrupt.
*/

#ifndef DEVICE_DRIVERLIB_HW_INTS_GS32F00xx_H_
#define DEVICE_DRIVERLIB_HW_INTS_GS32F00xx_H_

#include "gs32_version.h"

#if  IS_GS32F00xx()

#ifdef __cplusplus
extern "C"{
#endif

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

/* demosoc's External IRQn ID is from the hard-wired persperctive, which has an offset mapped to the ECLIC IRQn.
   eg.: uart0's external interrupt id in demosoc is 32, while its ECLIC IRQn is 51 */
#define SOC_EXTERNAL_MAP_TO_ECLIC_IRQn_OFFSET      19
/* get demosoc's External IRQn from ECLIC external IRQn which indexs from 19 */
#define IRQn_MAP_TO_EXT_ID(IRQn)                   (IRQn - SOC_EXTERNAL_MAP_TO_ECLIC_IRQn_OFFSET)

typedef enum IRQn {
	Invalid_IRQn = -1,
    /* =======================================  Nuclei Core Specific Interrupt Numbers  ======================================== */

    Reserved0_IRQn            =   0,              /*!<  Internal reserved */
    Reserved1_IRQn            =   1,              /*!<  Internal reserved */
    Reserved2_IRQn            =   2,              /*!<  Internal reserved */
    SysTimerSW_IRQn           =   3,              /*!<  System Timer SW interrupt */
    Reserved3_IRQn            =   4,              /*!<  Internal reserved */
    Reserved4_IRQn            =   5,              /*!<  Internal reserved */
    Reserved5_IRQn            =   6,              /*!<  Internal reserved */
    SysTimer_IRQn             =   7,              /*!<  System Timer Interrupt */
    Reserved6_IRQn            =   8,              /*!<  Internal reserved */
    Reserved7_IRQn            =   9,              /*!<  Internal reserved */
    Reserved8_IRQn            =  10,              /*!<  Internal reserved */
    Reserved9_IRQn            =  11,              /*!<  Internal reserved */
    Reserved10_IRQn           =  12,              /*!<  Internal reserved */
    Reserved11_IRQn           =  13,              /*!<  Internal reserved */
    Reserved12_IRQn           =  14,              /*!<  Internal reserved */
    Reserved13_IRQn           =  15,              /*!<  Internal reserved */
    InterCore_IRQn            =  16,              /*!<  CIDU Inter Core Interrupt */
    Reserved15_IRQn           =  17,              /*!<  Internal reserved */
    Reserved16_IRQn           =  18,              /*!<  Internal reserved */

    /* ===========================================  demosoc Specific Interrupt Numbers  ========================================= */
    /* ToDo: add here your device specific external interrupt numbers. 19~1023 is reserved number for user. Maxmum interrupt supported
             could get from clicinfo.NUM_INTERRUPT. According the interrupt handlers defined in startup_Device.s
             eg.: Interrupt for Timer#1       eclic_tim1_handler   ->   TIM1_IRQn */
#if IS_GS32F00xx(0x30)
	INT_MCANB_ECC_NMI         = 45,
	INT_MCANB_ECC_ERR         = 46,
	INT_MCANB_TS              = 47,
	INT_MCANA_ECC_NMI         = 48,
	INT_MCANA_ECC_ERR         = 49,
	INT_MCANA_TS              = 50,

    INT_JTAG_AUTH             = 51,
    INT_JTAG_INFO             = 52,

    INT_EPG                   = 62,

    INT_RTOSINT1              = 66,

    INT_AES                   = 75,

    INT_CRC                   = 78,

    INT_EFC_DONE              = 81,
    INT_EFC_SEC               = 82,

    INT_XINT16                = 85,
    INT_XINT15                = 86,
    INT_XINT14                = 87,
    INT_XINT13                = 88,
    INT_XINT12                = 89,
    INT_XINT11                = 90,
    INT_XINT10                = 91,
    INT_XINT9                 = 92,
    INT_XINT8                 = 93,
    INT_XINT7                 = 94,
    INT_XINT6                 = 95,
    INT_XINT5                 = 96,
    INT_XINT4                 = 97,
    INT_XINT3                 = 98,

    INT_ADCC4                 = 103,
    INT_ADCC3                 = 104,
    INT_ADCC2                 = 105,
    INT_ADCC_EVT              = 106,

    INT_ADCA4                 = 111,
    INT_ADCA3                 = 112,
    INT_ADCA2                 = 113,
    INT_ADCA_EVT              = 114,

    INT_PMBUSA_ALERT          = 117,
    INT_PMBUSA                = 118,
    INT_I2CB_FIFO             = 119,
    INT_I2CA_FIFO             = 120,

	INT_GPIO             	  = 121,
    INT_FSMC                  = 122,

    INT_SCIC_TX               = 125,
    INT_SCIC_RX               = 126,
    INT_SCIB_TX               = 127,
    INT_SCIB_RX               = 128,
    INT_SCIA_TX               = 129,
    INT_SCIA_RX               = 130,

    INT_LINB                  = 131,
    INT_LINA                  = 132,
    INT_USER12                = 133,
    INT_USER11                = 134,
    INT_USER10                = 135,
    INT_USER9                 = 136,
    INT_USER8                 = 137,
    INT_USER7                 = 138,
    INT_USER6                 = 139,
    INT_USER5                 = 140,
    INT_USER4                 = 141,
    INT_USER3                 = 142,
    INT_USER2                 = 143,
    INT_USER1                 = 144,
    INT_I2CB                  = 145,
    INT_I2CA                  = 146,

    INT_DMA1_CH6              = 149,
    INT_DMA1_CH5              = 150,
    INT_DMA1_CH4              = 151,
    INT_DMA1_CH3              = 152,
    INT_DMA1_CH2              = 153,
    INT_DMA1_CH1              = 154,

    INT_SDFM1DR5              = 162,
    INT_SDFM2DR4              = 163,
    INT_SDFM2DR3              = 164,
    INT_SDFM2DR2              = 165,
    INT_SDFM2DR1              = 166,

    INT_DMAMUX1_OVERFLOW      = 169,

    INT_TIMER1                = 174,
    INT_SPIB_TX               = 175,
    INT_SPIB_RX               = 176,
    INT_SPIA_TX               = 177,
    INT_SPIA_RX               = 178,
    INT_SDFM1DR4              = 179,
    INT_SDFM1DR3              = 180,
    INT_SDFM1DR2              = 181,
    INT_SDFM1DR1              = 182,

    INT_SDFM2                 = 184,
    INT_SDFM1                 = 185,

    INT_ENC2                  = 189,
    INT_ENC1                  = 190,
    INT_CLB2                  = 191,
    INT_CLB1                  = 192,
    INT_EQEP2                 = 193,
    INT_EQEP1                 = 194,

    INT_ECAP3_2               = 197,

    INT_EQEP3                 = 200,

    INT_ECAP3                 = 208,
    INT_ECAP2                 = 209,
    INT_ECAP1                 = 210,
    INT_CANB1                 = 211,
    INT_CANB0                 = 212,
    INT_CANA1                 = 213,
    INT_CANA0                 = 214,

    INT_EPWM8                 = 219,
    INT_EPWM7                 = 220,
    INT_EPWM6                 = 221,
    INT_EPWM5                 = 222,
    INT_EPWM4                 = 223,
    INT_EPWM3                 = 224,
    INT_EPWM2                 = 225,
    INT_EPWM1                 = 226,

    INT_EPWM8_TZ              = 235,
    INT_EPWM7_TZ              = 236,
    INT_EPWM6_TZ              = 237,
    INT_EPWM5_TZ              = 238,
    INT_EPWM4_TZ              = 239,
    INT_EPWM3_TZ              = 240,
    INT_EPWM2_TZ              = 241,
    INT_EPWM1_TZ              = 242,

    INT_DSP_WWDG              = 247,

    INT_SYS_ERR               = 249,
    INT_DSP_WDG               = 250,

    INT_TIMER0                = 252,
    INT_WAKE                  = 253,
    INT_XINT2                 = 254,
    INT_XINT1                 = 255,
    INT_ADCC1                 = 256,

    INT_ADCA1                 = 258,
#elif IS_GS32F00xx(0x12)
    INT_SLV_RST_FINISH        = 55,
    INT_DSP_M_FAIL            = 56,

    INT_STC                   = 61,     //memory self-test completed
    INT_EPG                   = 62,

    INT_RTOSINT1              = 66,
    INT_FPU_IO                = 67,
    INT_FPU_DZ                = 68,
    INT_FPU_ID                = 69,
    INT_FPU_IX                = 70,
    INT_FPU_UNDERFLOW         = 71,
    INT_FPU_OVERFLOW          = 72,

    INT_AES                   = 75,
    INT_WINDOW_FFT            = 76,
    INT_FFT                   = 77,
    INT_CRC                   = 78,
    INT_DBUS                  = 79,
    INT_IBUS                  = 80,
    INT_EFC_DONE              = 81,
    INT_EFC                   = 82,

    INT_XINT16                = 85,
    INT_XINT15                = 86,
    INT_XINT14                = 87,
    INT_XINT13                = 88,
    INT_XINT12                = 89,
    INT_XINT11                = 90,
    INT_XINT10                = 91,
    INT_XINT9                 = 92,
    INT_XINT8                 = 93,
    INT_XINT7                 = 94,
    INT_XINT6                 = 95,
    INT_XINT5                 = 96,
    INT_XINT4                 = 97,
    INT_XINT3                 = 98,

    INT_ADCC4                 = 103,
    INT_ADCC3                 = 104,
    INT_ADCC2                 = 105,
    INT_ADCC_EVT              = 106,
    INT_ADCB4                 = 107,
    INT_ADCB3                 = 108,
    INT_ADCB2                 = 109,
    INT_ADCB_EVT              = 110,
    INT_ADCA4                 = 111,
    INT_ADCA3                 = 112,
    INT_ADCA2                 = 113,
    INT_ADCA_EVT              = 114,

    INT_PMBUSA_ALERT           = 117,
    INT_PMBUSA                 = 118,

    INT_GPIO                  = 121,
    INT_QSPI                  = 122,

    INT_CANB                  = 125,
    INT_CANA                  = 126,

    INT_SCIB                  = 129,
    INT_SCIA                  = 130,
    INT_LINB                  = 131,
    INT_LINA                  = 132,
    INT_USER12                = 133,
    INT_USER11                = 134,
    INT_USER10                = 135,
    INT_USER9                 = 136,
    INT_USER8                 = 137,
    INT_USER7                 = 138,
    INT_USER6                 = 139,
    INT_USER5                 = 140,
    INT_USER4                 = 141,
    INT_USER3                 = 142,
    INT_USER2                 = 143,
    INT_USER1                 = 144,
    INT_I2C1                  = 145,
    INT_I2C0                  = 146,
    INT_DMA1_CH8              = 147,        //dma
    INT_DMA1_CH7              = 148,
    INT_DMA1_CH6              = 149,
    INT_DMA1_CH5              = 150,
    INT_DMA1_CH4              = 151,
    INT_DMA1_CH3              = 152,
    INT_DMA1_CH2              = 153,
    INT_DMA1_CH1              = 154,
    INT_DMA2_CH8              = 155,
    INT_DMA2_CH7              = 156,
    INT_DMA2_CH6              = 157,
    INT_DMA2_CH5              = 158,
    INT_DMA2_CH4              = 159,
    INT_DMA2_CH3              = 160,
    INT_DMA2_CH2              = 161,
    INT_DMA2_CH1              = 162,
    INT_SDFM2DR4              = 163,
    INT_SDFM2DR3              = 164,
    INT_SDFM2DR2              = 165,
    INT_SDFM2DR1              = 166,

    INT_DMA2_MUX              = 168,    //overflow
    INT_DMA1_MUX              = 169,

    INT_TIMER3                = 172,
    INT_TIMER2                = 173,
    INT_TIMER1                = 174,

    INT_SPIB                  = 177,
    INT_SPIA                  = 178,
    INT_SDFM1DR4              = 179,
    INT_SDFM1DR3              = 180,
    INT_SDFM1DR2              = 181,
    INT_SDFM1DR1              = 182,

    INT_SDFM2                 = 184,
    INT_SDFM1                 = 185,

    INT_CLB4                  = 189,
    INT_CLB3                  = 190,
    INT_CLB2                  = 191,
    INT_CLB1                  = 192,
    INT_EQEP2                 = 193,
    INT_EQEP1                 = 194,
    INT_ECAP7_2               = 195,
    INT_ECAP6_2               = 196,
    INT_ECAP3_2               = 197,

    INT_ECAP7                 = 204,
    INT_ECAP6                 = 205,
    INT_ECAP5                 = 206,
    INT_ECAP4                 = 207,
    INT_ECAP3                 = 208,
    INT_ECAP2                 = 209,
    INT_ECAP1                 = 210,

    INT_EPWM12                = 215,
    INT_EPWM11                = 216,
    INT_EPWM10                = 217,
    INT_EPWM9                 = 218,
    INT_EPWM8                 = 219,
    INT_EPWM7                 = 220,
    INT_EPWM6                 = 221,
    INT_EPWM5                 = 222,
    INT_EPWM4                 = 223,
    INT_EPWM3                 = 224,
    INT_EPWM2                 = 225,
    INT_EPWM1                 = 226,

    INT_EPWM12_TZ             = 231,
    INT_EPWM11_TZ             = 232,
    INT_EPWM10_TZ             = 233,
    INT_EPWM9_TZ              = 234,
    INT_EPWM8_TZ              = 235,
    INT_EPWM7_TZ              = 236,
    INT_EPWM6_TZ              = 237,
    INT_EPWM5_TZ              = 238,
    INT_EPWM4_TZ              = 239,
    INT_EPWM3_TZ              = 240,
    INT_EPWM2_TZ              = 241,
    INT_EPWM1_TZ              = 242,

    INT_DSP_WWDG              = 247,
    INT_SYS_ERR               = 249,
    INT_DSP_WDG               = 250,
    INT_TIMER0                = 252,
    INT_WAKE                  = 253,
    INT_XINT2                 = 254,
    INT_XINT1                 = 255,
    INT_ADCC1                 = 256,
    INT_ADCB1                 = 257,
    INT_ADCA1                 = 258,
#endif
    SOC_INT_MAX,
} IRQn_Type;
#endif

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

#endif /* DEVICE_DRIVERLIB_HW_INTS_GS32F00xx_H_ */
