/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_memmap_gs32f00xx.h
*   @brief   
*
*   commit history
*   2024/3/12 zhaolei add 3.0 memmap
*   2024/4/17 zhaolei rename 1.2/3.0 sysctl base name
*   2024/4/26 zhaolei add special gpio ip address for 3.0 FPGA
*   2024/5/13 zhaolei update 3.0 CAN base address
*   2024/6/05 zhaolei update 3.0 memory base address
*   2024/6/05 zhaolei update 1.2 LS memory base address
*   2024/6/11 hezhiyuan amend NMI_BASE add exmc base and AES_BASE and CLB_ENCn_BASE
*   2024/6/17 zhaolei replace 3.0 WWDG_BASE / GWDG_BASE with WDG_BASE
*   2025/1/1  hezhiyuan add WWD1_BASE
*/

#ifndef DEVICE_HW_MEMMAP_GS32F00xx_H_
#define DEVICE_HW_MEMMAP_GS32F00xx_H_

#include "gs32_version.h"

#if IS_GS32F00xx()

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#if IS_GS32F00xx(0x12)

#define FLASH_INFO_SIZE                 (32*1024)
#define FLASH_MEMORY_SIZE               (1024*1024)

/* Code Base */
#define FLASH_MEMORY_BASE               (0x08000000U)
#define FLASH_BASE                      (0x08000000U)         /* Flash */
#define CCM_RAM_CODE_BASE               (0x10000000U)         /* CCM_RAM */
#define SRAM1_CODE_BASE                 (0x10008000U)
#define SYSTEM_MEM_BASE                 (0x1FFE0000U)
#define OTP_BASE                        (0x1FFF4000U)
#define OPTION_BITS_BASE                (0x1FFF6000U)
//#define FLASH_INFO_BASE                 (0x1FFF0000U)

/* SRAM Base*/
#define CCM_RAM_DATA_BASE               (0x20000000U)         /* CCM_RAM */
#define SRAM_BASE                       (0x20008000U)         /* SRAM_RAM */
#define DSP_RAM_ILM_BASE                (0x20100000U)         /* ILM_RAM */
#define DSP_RAM_DLM_BASE                (0x20140000U)         /* DLM_RAM */
#define GSRAM_BASE                      (0x20038000U)         /* GS_RAM */

/* ADC - ADCA to ADCC base addresses */
#define ADCA_BASE                       (0x40000000U)
#define ADCB_BASE                       (0x40000800U)
#define ADCC_BASE                       (0x40001000U)


#define ADCARESULT_BASE                 (ADCA_BASE + 0x400U)        
#define ADCBRESULT_BASE                 (ADCB_BASE + 0x400U)
#define ADCCRESULT_BASE                 (ADCC_BASE + 0x400U)

/* AES -  Advanced Encryption Standard */
#define AES_BASE                  		(0x40090000U)

/*AHB1 */
/* EPWM - Peripheral instance base addresses */
#define PREEPWM_BASE                    (0x40008000U)
#define EPWMTOP_BASE                    (0x40008000U)
#define EPWM1_BASE                      (0x40008800U)
#define EPWM2_BASE                      (0x40009000U)
#define EPWM3_BASE                      (0x40009800U)
#define EPWM4_BASE                      (0x4000A000U)
#define EPWM5_BASE                      (0x4000A800U)
#define EPWM6_BASE                      (0x4000B000U)
#define EPWM7_BASE                      (0x4000B800U)
#define EPWM8_BASE                      (0x4000C000U)
#define EPWM9_BASE                      (0x4000C800U)
#define EPWM10_BASE                     (0x4000D000U)
#define EPWM11_BASE                     (0x4000D800U)
#define EPWM12_BASE                     (0x4000E000U)

#define ECAP1_BASE                      (0x40028000U)         /* ECAP1 Base Address */
#define ECAP2_BASE                      (0x40028200U)         /* ECAP2 Base Address */
#define ECAP3_BASE                      (0x40028400U)         /* ECAP3 Base Address */
#define ECAP4_BASE                      (0x40028600U)         /* ECAP4 Base Address */
#define ECAP5_BASE                      (0x40028800U)         /* ECAP5 Base Address */
#define ECAP6_BASE                      (0x40028A00U)         /* ECAP6 Base Address */
#define ECAP7_BASE                      (0x40028C00U)         /* ECAP7 Base Address */

/* eQEP - Enhanced Quadrature Encoder Pulse */
#define EQEP1_BASE                      (0x40030000U)
#define EQEP2_BASE                      (0x40030200U)

#define AHB_COMM_PARA_BASE              (0x4003F000U)   /** SYNCIN/OUT select for ecap and epwm */

/*AHB2 */
/* CMPSS - The Comparator Subsystem */
#define CMPSS1_BASE                     (0x40040000U)
#define CMPSS2_BASE                     (0x40040200U)
#define CMPSS3_BASE                     (0x40040400U)
#define CMPSS4_BASE                     (0x40040600U)
#define CMPSS5_BASE                     (0x40040800U)
#define CMPSS6_BASE                     (0x40040A00U)
#define CMPSS7_BASE                     (0x40040C00U)

#define SDFM1_BASE                      (0x40043000U)
#define SDFM2_BASE                      (0x40043200U)

#define GPIO_GROUP0_BASE                (0x40045000U)
#define GPIO_GROUP1_BASE                (0x40046000U)
#define GPIO_GROUP2_BASE                (0x40047000U)
#define GPIO_GROUP3_BASE                (0x40048000U)
#define GPIO_GROUP4_BASE                (0x40049000U)
#define GPIO_GROUP5_BASE                (0x4004A000U)
#define GPIO_GROUP6_BASE                (0x4004B000U)

#define CLB1_BASE                       (0x40065000U)
#define CLB2_BASE                       (0x40065400U)
#define CLB3_BASE                       (0x40065800U)
#define CLB4_BASE                       (0x40065C00U)

/* XBAR - XBAR instance base addresses */
#define INPUTXBAR_BASE                  (0x4006D000U)
#define CLBINPUTXBAR_BASE               (0x4006D0C0U)
#define XBAR_BASE                       (0x4006D040U)
#define CLBOUTPUTXBAR_BASE              (0x4006D900U)
#define CLBOUTPUTXBAR1_BASE             (0x4006D900U)         /*Control  MUX 1~8 */
#define CLBOUTPUTXBAR2_BASE             (0x4006DA00U)         /*Control  MUX 9~12 */
#define EPWMXBAR_BASE                   (0x4006D100U)
#define OUTPUTXBAR_BASE                 (0x4006D700U)
#define OUTPUTXBAR1_BASE                (0x4006D700U)
#define OUTPUTXBAR2_BASE                (0x4006D800U)
#define CLBXBAR_BASE                    (0x4006D400U)

/*AHB3*/
#define DACA_BASE                       (0x40080000U)
#define DACB_BASE                       (0x40080200U)

#define ERAD_BASE                       (0x40081000U)
#define ERAD_GLOBAL_BASE                (0x40081000U)
#define ERAD_HWBP1_BASE                 (0x40081200U)
#define ERAD_HWBP2_BASE                 (0x40081218U)
#define ERAD_HWBP3_BASE                 (0x40081230U)
#define ERAD_HWBP4_BASE                 (0x40081248U)
#define ERAD_HWBP5_BASE                 (0x40081260U)
#define ERAD_HWBP6_BASE                 (0x40081278U)
#define ERAD_COUNTER1_BASE              (0x40081300U)
#define ERAD_COUNTER2_BASE              (0x40081320U)
#define ERAD_COUNTER3_BASE              (0x40081340U)
#define ERAD_COUNTER4_BASE              (0x40081360U)

#define DMA1_BASE                       (0x40082000U)
#define DMA1_CH1_BASE                   (0x40082000U)
#define DMA1_CH2_BASE                   (0x40082058U)
#define DMA1_CH3_BASE                   (0x400820B0U)
#define DMA1_CH4_BASE                   (0x40082108U)
#define DMA1_CH5_BASE                   (0x40082160U)
#define DMA1_CH6_BASE                   (0x400821B8U)
#define DMA1_CH7_BASE                   (0x40082210U)
#define DMA1_CH8_BASE                   (0x40082268U)

#define DMA1_MUX_BASE                   (0x40085000U)

#define EPG_BASE                        (0x40086000U)
#define SEMA_BASE                       (0x40087000U)

#define CRC_BASE                        (0x40088000U)
#define FFT_BASE                        (0x40088200U)
#define FFT_RAM_BASE                    (0x40088400U)

/* AHB3 - APB */
#define APB_COMM_PARA_BASE              (0x400C0000U)

#define SCIA_BASE                      (0x400C1000U)
#define SCIB_BASE                      (0x400C1200U)

#define I2CA_BASE                       (0x400C2000U)
#define I2CB_BASE                       (0x400C2200U)
#define I2CC_BASE                       (0x400C2400U)
#define PMBUSA_BASE                     (I2CC_BASE)

#define SPIA_BASE                       (0x400C3000U)
#define SPIB_BASE                       (0x400C3200U)

#define CANA_BASE                       (0x400C4000U)
#define CANB_BASE                       (0x400C4200U)

#define LINA_BASE                       (0x400C5000U)
#define LINB_BASE                       (0x400C5200U)

#define SUB_CRG_BASE                    (0x400C6000U)

#define CPUTIMER0_BASE                  (0x400C8000U)
#define CPUTIMER1_BASE                  (0x400C8020U)
#define CPUTIMER2_BASE                  (0x400C9000U)
#define CPUTIMER3_BASE                  (0x400C9020U)

#define GPIOCTRL_BASE                   (0x400CC000U)
#define ANALOGSUBSYS_BASE               (0x400CD000U)
#define CRG_CFG_BASE                    (0x400CE000U)
#define SYSCTL_BASE                     (0x400CF000U)

/** Watchdog base address */
#define GWDG_DSP_BASE                   (0x400D1000U)         /* DSP General Watchdog Base Address */
#define WWDG_DSP_BASE                   (0x400D1020U)         /* DSP Window Watchdog Base Address */

#define NMI_BASE						(0x400D4000U)

#define WD1_BASE                        GWDG_DSP_BASE
#define WWD1_BASE                       WWDG_DSP_BASE

#define DMA2_BASE                       (0x400FC000U)
#define DMA2_CH1_BASE                   (0x400FC000U)
#define DMA2_CH2_BASE                   (0x400FC058U)
#define DMA2_CH3_BASE                   (0x400FC0B0U)
#define DMA2_CH4_BASE                   (0x400FC108U)
#define DMA2_CH5_BASE                   (0x400FC160U)
#define DMA2_CH6_BASE                   (0x400FC1B8U)
#define DMA2_CH7_BASE                   (0x400FC210U)
#define DMA2_CH8_BASE                   (0x400FC268U)

#define DMA2_MUX_BASE                   (0x400FF000U)

#define FLASH_INTERFACE_ICACHE_BASE     (0x50000000U)
#define FLASH_INTERFACE_DCACHE_BASE     (0x50001000U)
#define FLASH_INTERFACE_EFC_BASE        (0x50002000U)
#define FLASH_INTERFACE_EFC2_BASE       (0x50003000U)

#define DSP_RSV_CFG_BASE                (0x58000000U)

#define QSPIA_BASE                      (0xA0001000u)
#define QSPI0_FLASH_MEM                 (0xB0000000u)
#define QSPI_FLASH_BASE                 (0xB0000000U)         /* QSPI_FLASH */

#define GPIODATA_BASE                   GPIO_GROUP0_BASE
#define GPIO_PORTA_BASE                 GPIO_GROUP0_BASE
#define GPIO_PORTB_BASE                 GPIO_GROUP1_BASE
#define GPIO_PORTC_BASE                 GPIO_GROUP2_BASE
#define GPIO_PORTD_BASE                 GPIO_GROUP3_BASE
#define GPIO_PORTE_BASE                 GPIO_GROUP4_BASE
#define GPIO_PORTF_BASE                 GPIO_GROUP5_BASE
#define GPIO_PORTG_BASE                 GPIO_GROUP6_BASE




#elif IS_GS32F00xx(0x30)

#define FLASH_INFO_SIZE                 (32*1024)
#define FLASH_MEMORY_SIZE               (1024*1024)


/* EXMC - External Memory Controller */
#define EXMC_CFG_BASE                      (0xA0000000U)
#define EXMC_NOR_BASE                      (0x60000000U)

/* Code Base */
#define FLASH_MEMORY_BASE               (0x08000000U)
#define FLASH_BASE                      (0x08000000U)         /* Flash */
#define SYSTEM_MEM_BASE                 (0x1FFE0000U)
#define OTP_BASE                        (0x1FFF4000U)
#define OPTION_BITS_BASE                (0x1FFF6000U)
//#define FLASH_INFO_BASE                 (0x1FFF0000U)

/* SRAM Base*/
#define DSP_RAM_ILM_BASE                (0x20100000U)         /* ILM_RAM */
#define DSP_RAM_DLM_BASE                (0x20120000U)         /* DLM_RAM */
#define GSRAM_BASE                      (0x20038000U)         /* GS_RAM */
#define SWAP_SRAM1                      (0x2003C000U)         /* Swap SRAM1 */
#define SWAP_SRAM0                      (0x2003D000U)         /* Swap SRAM0 */

#define DSP_ILM_HIGH_SHADOW_BASE        (0x20000000U)         /* ILM_HIGH64K_SHADOW */
#define DSP_DLM_HIGH_SHADOW_BASE        (0x20010000U)         /* DLM_HIGH16K_SHADOW */

/* ADC - ADCA to ADCC base addresses */
#define ADCA_BASE                       (0x40000000U)
#define ADCC_BASE                       (0x40001000U)

#define ADCARESULT_BASE                 (ADCA_BASE + 0x400U)
#define ADCCRESULT_BASE                 (ADCC_BASE + 0x400U)

/*AHB1 */
/* EPWM - Peripheral instance base addresses */
#define PREEPWM_BASE                    (0x40008000U)
#define EPWMTOP_BASE                    (0x40008000U)
#define EPWM1_BASE                      (0x40008800U)
#define EPWM2_BASE                      (0x40009000U)
#define EPWM3_BASE                      (0x40009800U)
#define EPWM4_BASE                      (0x4000A000U)
#define EPWM5_BASE                      (0x4000A800U)
#define EPWM6_BASE                      (0x4000B000U)
#define EPWM7_BASE                      (0x4000B800U)
#define EPWM8_BASE                      (0x4000C000U)

#define ECAP1_BASE                      (0x40028000U)         /* ECAP1 Base Address */
#define ECAP2_BASE                      (0x40028200U)         /* ECAP2 Base Address */
#define ECAP3_BASE                      (0x40028400U)         /* ECAP3 Base Address */
#define ECAP4_BASE                      (0x40028600U)
#define ECAP5_BASE                      (0x40028800U)
#define ECAP6_BASE                      (0x40029000U)
#define ECAP7_BASE                      (0x40029200U)

/* eQEP - Enhanced Quadrature Encoder Pulse */
#define EQEP1_BASE                      (0x40030000U)
#define EQEP2_BASE                      (0x40030200U)
#define EQEP3_BASE                      (0x40030400U)

#define AHB_COMM_PARA_BASE              (0x4003F000U)   /** SYNCIN/OUT select for ecap and epwm */

/*AHB2 */
/* CMPSS - The Comparator Subsystem */
#define CMPSS1_BASE                     (0x40040000U)
#define CMPSS2_BASE                     (0x40040200U)
#define CMPSS3_BASE                     (0x40040400U)
#define CMPSS4_BASE                     (0x40040600U)

#define SDFM1_BASE                      (0x40043000U)
#define SDFM2_BASE                      (0x40043200U)

#define CANA_BASE                       (0x40049200U)
#define CANB_BASE                       (0x4004b200U)

#define CLB1_BASE                       (0x40065000U)
#define CLB2_BASE                       (0x40065400U)
#define CLB_ENC1_BASE                   (0x40069000U)
#define CLB_ENC2_BASE                   (0x40069400U)

/* XBAR - XBAR instance base addresses */
#define INPUTXBAR_BASE                  (0x4006D000U)
#define CLBINPUTXBAR_BASE               (0x4006D0C0U)
#define XBAR_BASE                       (0x4006D040U)
#define CLBOUTPUTXBAR_BASE              (0x4006D900U)
#define CLBOUTPUTXBAR2_BASE             (0x4006DA00U)
#define EPWMXBAR_BASE                   (0x4006D100U)
#define OUTPUTXBAR_BASE                 (0x4006D700U)
#define CLBXBAR_BASE                    (0x4006D400U)
#define ICLXBAR_BASE                    (0x4006E000U)
#define MINDBXBAR_BASE                  (0x4006E040U)

/* AES -  Advanced Encryption Standard */
#define AES_BASE                  		(0x40070000U)

/*AHB3*/
#define ERAD_BASE                       (0x40081000U)
#define ERAD_GLOBAL_BASE                (0x40081000U)
#define ERAD_HWBP1_BASE                 (0x40081200U)
#define ERAD_HWBP2_BASE                 (0x40081218U)
#define ERAD_HWBP3_BASE                 (0x40081230U)
#define ERAD_HWBP4_BASE                 (0x40081248U)
#define ERAD_HWBP5_BASE                 (0x40081260U)
#define ERAD_HWBP6_BASE                 (0x40081278U)
#define ERAD_COUNTER1_BASE              (0x40081300U)
#define ERAD_COUNTER2_BASE              (0x40081320U)
#define ERAD_COUNTER3_BASE              (0x40081340U)
#define ERAD_COUNTER4_BASE              (0x40081360U)

#define EPG_BASE                        (0x40086000U)

#define CRC_BASE                        (0x40088000U)

/* AHB3 - APB */
#define APB_COMM_PARA_BASE              (0x400C0000U)

#define SCIA_BASE                       (0x400C1000U)
#define SCIB_BASE                       (0x400C1200U)
#define SCIC_BASE                       (0x400C1400U)

#define I2CA_BASE                       (0x400C2000U)
#define I2CB_BASE                       (0x400C2200U)
#define I2CC_BASE                       (0x400C2400U)
#define PMBUSA_BASE                     (I2CC_BASE)

#define SPIA_BASE                       (0x400C3000U)
#define SPIB_BASE                       (0x400C3200U)

#define LINA_BASE                       (0x400C5000U)
#define LINB_BASE                       (0x400C5200U)

#define SUB_CRG_BASE                    (0x400C6000U)

#define CPUTIMER0_BASE                  (0x400C8000U)
#define CPUTIMER1_BASE                  (0x400C8020U)

#define CRG_CFG_BASE                    (0x400CE000U)
#define SYSCTL_BASE                     (0x400CF000U)

/** Watchdog base address */
#define GWDG_DSP_BASE                   (0x400D0000U)         /* DSP General Watchdog Base Address */
#define WWDG_DSP_BASE                   (0x400D0020U)         /* DSP Window Watchdog Base Address */
#define WD1_BASE                        GWDG_DSP_BASE
#define WWD1_BASE                       WWDG_DSP_BASE

#define NMI_BASE                        (0x400D4000U)

#define IO_CFG_BASE                 	(0x400D5000U)

#if GS32_PART_NUM==0x035 || GS32_PART_NUM==0x027

#define GPIOCTRL_BASE             		(IO_CFG_BASE + 0x800U)
#define GPIODATA_BASE             		(IO_CFG_BASE + 0x880U)
#define GPIOINT_BASE             		(IO_CFG_BASE + 0x8C0U)
#define GPIOEXT_BASE             		(IO_CFG_BASE + 0x400U)

#else
#define GPIOCTRL_BASE             		IO_CFG_BASE
#define GPIOEXT_BASE             		(IO_CFG_BASE + 0x400U)
#define GPIODATA_BASE             		(IO_CFG_BASE + 0x600U)
#define GPIODATAREAD_BASE         		(IO_CFG_BASE + 0x700U)
#define GPIOINTERRUPT_BASE         		(IO_CFG_BASE + 0x900U)
#endif


#define ANALOGSUBSYS_BASE               (0x400D6000U)

#define DSP_APB_CFG_BASE                (0x400F8000U)

#define FLASH_INTERFACE_EFC_BASE        (0x400F9000U)
#define FLASH_INTERFACE_EFC2_BASE       (0x400F9400U)

#define DMA_BASE                        (0x400FA000U)
#define DMA_CH1_BASE                    (0x400FA000U)
#define DMA_CH2_BASE                    (0x400FA058U)
#define DMA_CH3_BASE                    (0x400FA0B0U)
#define DMA_CH4_BASE                    (0x400FA108U)
#define DMA_CH5_BASE                    (0x400FA160U)
#define DMA_CH6_BASE                    (0x400FA1B8U)

#define DMA_MUX_BASE                     (0x400FD000U)

#endif

#ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_HW_MEMMAP_GS32F00xx_H_ */
