/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    device_support_gs32f00xx.h
*   @brief   
*
*	commit history
*	2024/03/07, Xu Haoze, add bit field registers of CRC.
*	2024/03/12, Zhao Lei, fix typo GS32F00xx.
*	2024/03/17, Jason, add CMPSS, I2C, SPI registers.
*   2024/03/24, Jason, change EPWM ADC CMPSS to be structure at specified section.
*/

#ifndef DEVICE_SUPPORT_GS32F3xx_H_
#define DEVICE_SUPPORT_GS32F3xx_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "regs/regs_adc.h"
#include "regs/regs_cmpss.h"
#include "regs/regs_epwm.h"
#include "regs/regs_epwmxbar.h"
#include "regs/regs_clbxbar.h"
#include "regs/regs_clboutputxbar.h"
#include "regs/regs_outputxbar.h"
#include "regs/regs_input_xbar.h"
#include "regs/regs_ecap.h"
#include "regs/regs_eqep.h"
#include "regs/regs_xbar.h"
#include "regs/regs_sci.h"
#include "regs/regs_i2c.h"
#include "regs/regs_spi.h"
#include "regs/regs_dac.h"
#include "regs/regs_ptr.h"
#include "regs/regs_gpio.h"
#include "regs/regs_epg.h"
#include "regs/regs_sdfm.h"
#include "regs/regs_crc.h"
#include "regs/regs_dac.h"
#include "regs/regs_cputimer.h"
#include "regs/regs_wd.h"
//#include "regs/regs_ana_sysctrl_para.h"
//#include "regs/regs_ahb_comm_para.h"
#include "regs/regs_apb_comm_para.h"
//#include "regs/regs_dig_sysctl_para.h"
//#include "regs/regs_sysctl_para_h.h"
//#include "regs/regs_sysctl_para_l.h"
#include "regs/regs_can.h"
//#include "regs/regs_dma.h"
#include "regs/regs_xdma.h"
#include "regs/regs_eflash.h"
#include "regs/regs_lin.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

extern volatile struct ADC_REGS AdcaRegs;
extern volatile struct ADC_REGS AdcbRegs;
extern volatile struct ADC_REGS AdccRegs;
extern volatile struct ADC_REGS AdcdRegs;
extern volatile struct ADC_RESULT_REGS AdcaResultRegs;
extern volatile struct ADC_RESULT_REGS AdcbResultRegs;
extern volatile struct ADC_RESULT_REGS AdccResultRegs;
extern volatile struct ADC_RESULT_REGS AdcdResultRegs;

extern volatile struct CMPSS_REGS Cmpss1Regs;
extern volatile struct CMPSS_REGS Cmpss2Regs;
extern volatile struct CMPSS_REGS Cmpss3Regs;
extern volatile struct CMPSS_REGS Cmpss4Regs;
extern volatile struct CMPSS_REGS Cmpss5Regs;
extern volatile struct CMPSS_REGS Cmpss6Regs;
extern volatile struct CMPSS_REGS Cmpss7Regs;
extern volatile struct CMPSS_REGS Cmpss8Regs;
extern volatile struct CMPSS_REGS Cmpss9Regs;
extern volatile struct CMPSS_REGS Cmpss10Regs;
extern volatile struct CMPSS_REGS Cmpss11Regs;
extern volatile struct CMPSS_REGS Cmpss12Regs;

extern volatile struct EPWM_REGS EPwm1Regs;
extern volatile struct EPWM_REGS EPwm2Regs;
extern volatile struct EPWM_REGS EPwm3Regs;
extern volatile struct EPWM_REGS EPwm4Regs;
extern volatile struct EPWM_REGS EPwm5Regs;
extern volatile struct EPWM_REGS EPwm6Regs;
extern volatile struct EPWM_REGS EPwm7Regs;
extern volatile struct EPWM_REGS EPwm8Regs;
extern volatile struct EPWM_REGS EPwm9Regs;
extern volatile struct EPWM_REGS EPwm10Regs;
extern volatile struct EPWM_REGS EPwm11Regs;
extern volatile struct EPWM_REGS EPwm12Regs;
extern volatile struct EPWM_REGS EPwm13Regs;
extern volatile struct EPWM_REGS EPwm14Regs;
extern volatile struct EPWM_REGS EPwm15Regs;
extern volatile struct EPWM_REGS EPwm16Regs;
extern volatile struct EPWM_REGS EPwm17Regs;
extern volatile struct EPWM_REGS EPwm18Regs;
extern volatile struct EPWM_TOP_REGS EPwmTopRegs;

extern volatile struct EPWM_EXTEND_REGS EPwm1ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm2ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm3ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm4ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm5ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm6ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm7ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm8ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm9ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm10ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm11ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm12ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm13ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm14ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm15ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm16ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm17ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm18ExtRegs;

extern volatile struct EQEP_REGS EQep1Regs;
extern volatile struct EQEP_REGS EQep2Regs;
extern volatile struct EQEP_REGS EQep3Regs;

extern volatile struct ECAP_REGS ECap1Regs;
extern volatile struct ECAP_REGS ECap2Regs;
extern volatile struct ECAP_REGS ECap3Regs;
extern volatile struct ECAP_REGS ECap4Regs;
extern volatile struct ECAP_REGS ECap5Regs;
extern volatile struct ECAP_REGS ECap6Regs;
extern volatile struct ECAP_REGS ECap7Regs;

//extern volatile struct XBAR_REGS XbarRegs;
extern volatile struct INPUT_XBAR_REGS InputXbarRegs;
extern volatile struct OUTPUT_XBAR_REGS OutputXbarRegs;
//extern volatile struct INPUT_XBAR_REGS PluInputXbarRegs;
//extern volatile struct OUTPUT_XBAR_REGS PluOutputXbarRegs;
//extern volatile struct EPWM_XBAR_REGS EPwmXbarRegs;
//extern volatile struct PLU_XBAR_REGS PluXbarRegs;


#if defined(GPIO_PORTA_BASE) || defined(GPIO_GROUP0_BASE)
extern volatile struct GPIO_REGS GpioPortaRegs;
#endif
#if defined(GPIO_PORTB_BASE) || defined(GPIO_GROUP1_BASE)
extern volatile struct GPIO_REGS GpioPortbRegs;
#endif
#if defined(GPIO_PORTC_BASE) || defined(GPIO_GROUP2_BASE)
extern volatile struct GPIO_REGS GpioPortcRegs;
#endif
#if defined(GPIO_PORTD_BASE) || defined(GPIO_GROUP3_BASE)
extern volatile struct GPIO_REGS GpioPortdRegs;
#endif
#if defined(GPIO_PORTE_BASE) || defined(GPIO_GROUP4_BASE)
extern volatile struct GPIO_REGS GpioPorteRegs;
#endif
#if defined(GPIO_PORTF_BASE) || defined(GPIO_GROUP5_BASE)
extern volatile struct GPIO_REGS GpioPortfRegs;
#endif
#if defined(GPIO_PORTG_BASE) || defined(GPIO_GROUP6_BASE)
extern volatile struct GPIO_REGS GpioPortgRegs;
#endif
#if defined(GPIO_PORTH_BASE) || defined(GPIO_GROUP7_BASE)
extern volatile struct GPIO_REGS GpioPorthRegs;
#endif
#if defined(GPIO_PORTI_BASE) || defined(GPIO_GROUP8_BASE)
extern volatile struct GPIO_REGS GpioPortiRegs;
#endif
#if defined(GPIO_PORTJ_BASE) || defined(GPIO_GROUP9_BASE)
extern volatile struct GPIO_REGS GpioPortjRegs;
#endif
#if defined(GPIO_PORTK_BASE) || defined(GPIO_GROUP10_BASE)
extern volatile struct GPIO_REGS GpioPortkRegs;
#endif
#if defined(GPIO_PORTL_BASE) || defined(GPIO_GROUP11_BASE)
extern volatile struct GPIO_REGS GpioPortlRegs;
#endif
#if defined(GPIO_PORTM_BASE) || defined(GPIO_GROUP12_BASE)
extern volatile struct GPIO_REGS GpioPortmRegs;
#endif
#if defined(GPIO_PORTN_BASE) || defined(GPIO_GROUP13_BASE)
extern volatile struct GPIO_REGS GpioPortnRegs;
#endif

#if 0
#define XbarRegs (*(volatile struct XBAR_REGS *) XBAR_BASE)
#define InputXbarRegs (*(volatile struct INPUT_XBAR_REGS *) INPUTXBAR_BASE)
#define PluInputXbarRegs (*(volatile struct INPUT_XBAR_REGS *) INPUTXBAR_BASE)
#define OutputXbarRegs (*(volatile struct OUTPUT_XBAR_REGS *) OUTPUTXBAR_BASE)
#define PluOutputXbarRegs (*(volatile struct OUTPUT_XBAR_REGS *) OUTPUTXBAR_BASE)
#define EPwmXbarRegs (*(volatile struct EPWM_XBAR_REGS *) EPWMXBAR_BASE)
#define PluXbarRegs (*(volatile struct PLU_XBAR_REGS *) PLUXBAR_BASE)

#define SciaRegs (*(volatile struct SCI_REGS *) SCIA_BASE)
#define ScibRegs (*(volatile struct SCI_REGS *) SCIB_BASE)
#define ScicRegs (*(volatile struct SCI_REGS *) SCIC_BASE)
#define ScidRegs (*(volatile struct SCI_REGS *) SCID_BASE)

#define Sdfm1Regs		(* (volatile struct SDFM_REGS *) SDFM1_BASE)
#define Sdfm2Regs		(* (volatile struct SDFM_REGS *) SDFM2_BASE)
#define Sdfm3Regs		(* (volatile struct SDFM_REGS *) SDFM3_BASE)
#define Sdfm4Regs		(* (volatile struct SDFM_REGS *) SDFM4_BASE)

#define CRCRegs         (* (volatile struct CRC_REGS *) CRC_BASE)

#define I2caRegs (*(volatile struct I2C_REGS *) I2CA_BASE)
#define I2cbRegs (*(volatile struct I2C_REGS *) I2CB_BASE)
#define I2ccRegs (*(volatile struct I2C_REGS *) I2CC_BASE)

#define SpiaRegs (*(volatile struct SPI_REGS *) SPIA_BASE)
#define SpibRegs (*(volatile struct SPI_REGS *) SPIB_BASE)
#define SpicRegs (*(volatile struct SPI_REGS *) SPIC_BASE)
#define SpidRegs (*(volatile struct SPI_REGS *) SPID_BASE)
#endif


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif


#endif /* DEVICE_SUPPORT_GS32F00xx_H_ */
