/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_ints.h
*   @brief   
*
*/
/*
 * commit history
 * 20240308, LYF, change INT vector number name for chip 2.0.
 * 20240315, Jason, add comments for different group of IRQ Number.
 * 20240511, Zhaolei, INT_MUx/INT_MUx_GEN -> INT_MUx_GENERAL.
 * 20240726, Hezhiyuan, Delete interrupt on 2.2
 */


#ifndef DEVICE_DRIVERLIB_HW_INTS_GS32F00xx_H_
#define DEVICE_DRIVERLIB_HW_INTS_GS32F00xx_H_

#include "gs32_version.h"

#if IS_GS32F3xx()

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

/* demosoc's External IRQn ID is from the hard-wired persperctive, which has an offset mapped to the ECLIC IRQn.
   eg.: uart0's external interrupt id in demosoc is 32, while its ECLIC IRQn is 51 */
#define SOC_EXTERNAL_MAP_TO_ECLIC_IRQn_OFFSET      19
/* get demosoc's External IRQn from ECLIC external IRQn which indexs from 19 */
#define IRQn_MAP_TO_EXT_ID(IRQn)                   (IRQn - SOC_EXTERNAL_MAP_TO_ECLIC_IRQn_OFFSET)

typedef enum IRQn {
	Invalid_IRQn              =  -1,
    /* =======================================  Nuclei Core Specific Interrupt Numbers  ======================================== */

    Reserved0_IRQn            =   0,              /*!<  Internal reserved */
    Reserved1_IRQn            =   1,              /*!<  Internal reserved */
    Reserved2_IRQn            =   2,              /*!<  Internal reserved */
    SysTimerSW_IRQn           =   3,              /*!<  System Timer SW interrupt */
    Reserved3_IRQn            =   4,              /*!<  Internal reserved */
    Reserved4_IRQn            =   5,              /*!<  Internal reserved */
    Reserved5_IRQn            =   6,              /*!<  Internal reserved */
    SysTimer_IRQn             =   7,              /*!<  System Timer Interrupt */
    Reserved6_IRQn            =   8,              /*!<  Internal reserved */
    Reserved7_IRQn            =   9,              /*!<  Internal reserved */
    Reserved8_IRQn            =  10,              /*!<  Internal reserved */
    Reserved9_IRQn            =  11,              /*!<  Internal reserved */
    Reserved10_IRQn           =  12,              /*!<  Internal reserved */
    Reserved11_IRQn           =  13,              /*!<  Internal reserved */
    Reserved12_IRQn           =  14,              /*!<  Internal reserved */
    Reserved13_IRQn           =  15,              /*!<  Internal reserved */
    InterCore_IRQn            =  16,              /*!<  CIDU Inter Core Interrupt */
    Reserved15_IRQn           =  17,              /*!<  Internal reserved */
    Reserved16_IRQn           =  18,              /*!<  Internal reserved */

    /* ===========================================  demosoc Specific Interrupt Numbers  ========================================= */
    /* ToDo: add here your device specific external interrupt numbers. 19~1023 is reserved number for user. Maxmum interrupt supported
             could get from clicinfo.NUM_INTERRUPT. According the interrupt handlers defined in startup_Device.s
             eg.: Interrupt for Timer#1       eclic_tim1_handler   ->   TIM1_IRQn */
    /* for __riscv and 2.2CS */
#if IS_GS32F3xx(0x22)
    INT_XINT16               = 19 + 5,       //XINT16
    INT_XINT15               = 19 + 6,       //XINT15
    INT_XINT14               = 19 + 7,       //XINT14
    INT_XINT13               = 19 + 8,       //XINT13
    INT_XINT12               = 19 + 9,      //XINT12
    INT_XINT11               = 19 + 10,      //XINT11
    INT_XINT10               = 19 + 11,      //XINT10
    INT_XINT9                = 19 + 12,      //XINT9
    INT_XINT8                = 19 + 13,      //XINT8
    INT_XINT7                = 19 + 14,      //XINT7
    INT_XINT6                = 19 + 15,      //XINT6
    INT_DMA2_CH8             = 19 + 24,      //CPU2_DMA_CH8
    INT_DMA2_CH7             = 19 + 25,      //CPU2_DMA_CH7
    INT_DMA2_CH6             = 19 + 26,      //CPU2_DMA_CH6
    INT_DMA2_CH5             = 19 + 27,      //CPU2_DMA_CH5
    INT_DMA2_CH4             = 19 + 28,      //CPU2_DMA_CH4
    INT_DMA2_CH3             = 19 + 29,      //CPU2_DMA_CH3
    INT_DMA2_CH2             = 19 + 30,      //CPU2_DMA_CH2
    INT_DMA2_CH1             = 19 + 31,      //CPU2_DMA_CH1

    INT_DCACHE               = 19 + 38,      //dcache
    INT_ICACHE               = 19 + 39,      //icache
    INT_EFC_DONE             = 19 + 40,      //efc_done_intr
    INT_EFC                  = 19 + 41,      //efc_intr
    INT_CPU2_PC_ERR          = 19 + 43,      //CPU2 PC ERR
    INT_CPU1_PC_ERR          = 19 + 44,      //CPU1 PC ERR
    INT_DMA2_MUX             = 19 + 46,      //CPU2 DMA MUX
    INT_DMA1_MUX             = 19 + 47,      //CPU1 DMA MUX

    INT_EPG                  = 19 + 50,      //EPG
    INT_CRC                  = 19 + 51,      //CRC
    INT_FPIOC                = 19 + 52,      //FPIOC
    INT_FPDZC                = 19 + 53,      //FPDZC
    INT_FPIDC                = 19 + 54,      //FPIDC
    INT_FPIXC                = 19 + 55,      //FPIXC
    INT_FPUFC                = 19 + 56,      //FPUFC
    INT_FPOFC                = 19 + 57,      //FPOFC

    INT_XINT5                = 19 + 61,      //XINT5 interrupt
    INT_XINT4                = 19 + 62,      //XINT4 interrupt
    INT_XINT3                = 19 + 63,      //XINT3 interrupt
    INT_SDFM4_DR4            = 19 + 64,      //SDFM4 DR4
    INT_SDFM4_DR3            = 19 + 65,      //SDFM4 DR3
    INT_SDFM4_DR2            = 19 + 66,      //SDFM4 DR2
    INT_SDFM4_DR1            = 19 + 67,      //SDFM4 DR1

    INT_USER11_12            = 19 + 69,      //USER INT 11/12
    INT_USER9_10             = 19 + 70,      //USER INT 9/10
    INT_USER7_8              = 19 + 71,      //USER INT 7/8
    INT_USER5_6              = 19 + 72,      //USER INT 5/6
    INT_USER3_4              = 19 + 73,      //USER INT 3/4
    INT_USER1_2              = 19 + 74,      //USER INT 1/2

    INT_GPIO                 = 19 + 79,      //GPIO Combine Interrupt
    INT_ADCD4                = 19 + 80,      //ADCD4 interrupt
    INT_ADCD3                = 19 + 81,      //ADCD3 interrupt
    INT_ADCD2                = 19 + 82,      //ADCD2 interrupt
    INT_ADCD_EVT             = 19 + 83,      //ADCD_EVT interrupt
    INT_ADCC4                = 19 + 84,      //ADCC4 interrupt
    INT_ADCC3                = 19 + 85,      //ADCC3 interrupt
    INT_ADCC2                = 19 + 86,      //ADCC2 interrupt
    INT_ADCC_EVT             = 19 + 87,      //ADCC_EVT interrupt
    INT_ADCB4                = 19 + 88,      //ADCB4 interrupt
    INT_ADCB3                = 19 + 89,      //ADCB3 interrupt
    INT_ADCB2                = 19 + 90,      //ADCB2 interrupt
    INT_ADCB_EVT             = 19 + 91,      //ADCB_EVT interrupt
    INT_ADCA4                = 19 + 92,      //ADCA4 interrupt
    INT_ADCA3                = 19 + 93,      //ADCA3 interrupt
    INT_ADCA2                = 19 + 94,      //ADCA2 interrupt
    INT_ADCA_EVT             = 19 + 95,      //ADCA_EVT interrupt

    INT_PMBUSA_ALERT         = 19 + 98,      //PMBUSA alert
    INT_PMBUSA               = 19 + 99,      //PMBUSA interrupt

    INT_CAND                 = 19 + 102,     //CAND interrupt
    INT_CANC                 = 19 + 103,     //CANC interrupt
    INT_EPWM18               = 19 + 104,     //EPWM18 interrupt
    INT_EPWM17               = 19 + 105,     //EPWM17 interrupt
    INT_CANB                 = 19 + 106,     //CANB interrupt
    INT_CANA                 = 19 + 107,     //CANA interrupt

    INT_SCIB                 = 19 + 109,     //SCI_B interrupt

    INT_SCIA                 = 19 + 111,     //SCI_A interrupt
    INT_CLB8                 = 19 + 112,     //CLB8 interrupt
    INT_CLB7                 = 19 + 113,     //CLB7 interrupt
    INT_CLB6                 = 19 + 114,     //CLB6 interrupt
    INT_CLB5                 = 19 + 115,     //CLB5 interrupt
    INT_SDFM4                = 19 + 116,     //SDFM4 interrupt
    INT_SDFM3                = 19 + 117,     //SDFM3 intterupt

    INT_EWPM18_TZ            = 19 + 120,     //EWPM18_TZ
    INT_EPWM17_TZ            = 19 + 121,     //EPWM17_TZ
    INT_SCID                 = 19 + 122,     //SCI_D interrupt
    INT_SCIC                 = 19 + 123,     //SCI_C interrupt

    INT_I2CB                 = 19 + 125,     //I2CB interrupt

    INT_I2CA                 = 19 + 127,     //I2CA interrupt
    INT_SDFM3DR4             = 19 + 128,     //SDFM3DR4 interrupt
    INT_SDFM3DR3             = 19 + 129,     //SDFM3DR3 interrupt
    INT_SDFM3DR2             = 19 + 130,     //SDFM3DR2 interrupt
    INT_SDFM3DR1             = 19 + 131,     //SDFM3DR1 interrupt
    INT_HRCAP2               = 19 + 132,     //HRCAP2
    INT_HRCAP1               = 19 + 133,     //HRCAP1
    INT_EQEP6                = 19 + 134,     //EQEP6
    INT_EQEP5                = 19 + 135,     //EQEP5
    INT_DMA1_CH8             = 19 + 136,     //CPU1_CH8 interrupt
    INT_DMA1_CH7             = 19 + 137,     //CPU1_CH7 interrupt
    INT_DMA1_CH6             = 19 + 138,     //CPU1_CH6 interrupt
    INT_DMA1_CH5             = 19 + 139,     //CPU1_CH5 interrupt
    INT_DMA1_CH4             = 19 + 140,     //CPU1_CH4 interrupt
    INT_DMA1_CH3             = 19 + 141,     //CPU1_CH3 interrupt
    INT_DMA1_CH2             = 19 + 142,     //CPU1_CH2 interrupt
    INT_DMA1_CH1             = 19 + 143,     //CPU1_CH1 interrupt
    INT_SDFM2DR4             = 19 + 144,     //SDFM2DR4 interrupt
    INT_SDFM2DR3             = 19 + 145,     //SDFM2DR3 interrupt
    INT_SDFM2DR2             = 19 + 146,     //SDFM2DR2 interrupt
    INT_SDFM2DR1             = 19 + 147,     //SDFM2DR1 interrupt

    INT_TIMER5               = 19 + 151,     //TIMER5 interrupt
    INT_TIMER4               = 19 + 152,     //TIMER4 interrupt
    INT_TIMER3               = 19 + 153,     //TIMER3 interrupt
    INT_TIMER2               = 19 + 154,     //TIMER2 interrupt
    INT_TIMER1               = 19 + 155,     //TIMER1 interrupt
    INT_SPID                 = 19 + 156,     //SPID interrupt
    INT_SPIC                 = 19 + 157,     //SPIC interrupt
    INT_SPIB                 = 19 + 158,     //SPIB interrupt
    INT_SPIA                 = 19 + 159,     //SPIA interrupt
    INT_SDFM1DR4             = 19 + 160,     //SDFM1DR4 interrupt
    INT_SDFM1DR3             = 19 + 161,     //SDFM1DR3 interrupt
    INT_SDFM1DR2             = 19 + 162,     //SDFM1DR2 interrupt
    INT_SDFM1DR1             = 19 + 163,     //SDFM1DR1 interrupt

    INT_SD2                  = 19 + 166,     //SD2 interrupt
	INT_SDFM2                = 19 + 166,     //SD2 interrupt
    INT_SD1                  = 19 + 167,     //SD1 interrupt
	INT_SDFM1                = 19 + 167,     //SD1 interrupt
    INT_CLB4                 = 19 + 168,     //CLB4 interrupt
    INT_CLB3                 = 19 + 169,     //CLB3 interrupt
    INT_CLB2                 = 19 + 170,     //CLB2 interrupt
    INT_CLB1                 = 19 + 171,     //CLB1 interrupt
    INT_EQEP4                = 19 + 172,     //EQEP4 interrupt
    INT_EQEP3                = 19 + 173,     //EQEP3 interrupt
    INT_EQEP2                = 19 + 174,     //EQEP2 interrupt
    INT_EQEP1                = 19 + 175,     //EQEP1 interrupt

    INT_EXMC                 = 19 + 177,     //EXMC
    INT_SCIF                 = 19 + 178,     //SCIE
    INT_SCIE                 = 19 + 179,     //SCIF
    INT_I2CC               = 19 + 180,       //I2CC interrupt
    INT_SPIE                 = 19 + 181,     //SPIE interrupt
    INT_LINB                 = 19 + 182,     //LINB
    INT_LINA                 = 19 + 183,     //LINA

    INT_ECAP7                = 19 + 185,     //ECAP7 interrupt
    INT_ECAP6                = 19 + 186,     //ECAP6 interrupt
    INT_ECAP5                = 19 + 187,     //ECAP5 interrupt
    INT_ECAP4                = 19 + 188,     //ECAP4 interrupt
    INT_ECAP3                = 19 + 189,     //ECAP3 interrupt
    INT_ECAP2                = 19 + 190,     //ECAP2 interrupt
    INT_ECAP1                = 19 + 191,     //ECAP1 interrupt
    INT_EPWM16               = 19 + 192,     //EPWM16 interrupt
    INT_EPWM15               = 19 + 193,     //EPWM15 interrupt
    INT_EPWM14               = 19 + 194,     //EPWM14 interrupt
    INT_EPWM13               = 19 + 195,     //EPWM13 interrupt
    INT_EPWM12               = 19 + 196,     //EPWM12 interrupt
    INT_EPWM11               = 19 + 197,     //EPWM11 interrupt
    INT_EPWM10               = 19 + 198,     //EPWM10 interrupt
    INT_EPWM9                = 19 + 199,     //EPWM9 interrupt
    INT_EPWM8                = 19 + 200,     //EPWM8 interrupt
    INT_EPWM7                = 19 + 201,     //EPWM7 interrupt
    INT_EPWM6                = 19 + 202,     //EPWM6 interrupt
    INT_EPWM5                = 19 + 203,     //EPWM5 interrupt
    INT_EPWM4                = 19 + 204,     //EPWM4 interrupt
    INT_EPWM3                = 19 + 205,     //EPWM3 interrupt
    INT_EPWM2                = 19 + 206,     //EPWM2 interrupt
    INT_EPWM1                = 19 + 207,     //EPWM1 interrupt
    INT_EPWM16_TZ            = 19 + 208,     //EPWM16_TZ interrupt
    INT_EPWM15_TZ            = 19 + 209,     //EPWM15_TZ interrupt
    INT_EPWM14_TZ            = 19 + 210,     //EPWM14_TZ interrupt
    INT_EPWM13_TZ            = 19 + 211,     //EPWM13_TZ interrupt
    INT_EPWM12_TZ            = 19 + 212,     //EPWM12_TZ interrupt
    INT_EPWM11_TZ            = 19 + 213,     //EPWM11_TZ interrupt
    INT_EPWM10_TZ            = 19 + 214,     //EPWM10_TZ interrupt
    INT_EPWM9_TZ             = 19 + 215,     //EPWM9_TZ interrupt
    INT_EPWM8_TZ             = 19 + 216,     //EPWM8_TZ interrupt
    INT_EPWM7_TZ             = 19 + 217,     //EPWM7_TZ interrupt
    INT_EPWM6_TZ             = 19 + 218,     //EPWM6_TZ interrupt
    INT_EPWM5_TZ             = 19 + 219,     //EPWM5_TZ interrupt
    INT_EPWM4_TZ             = 19 + 220,     //EPWM4_TZ interrupt
    INT_EPWM3_TZ             = 19 + 221,     //EPWM3_TZ interrupt
    INT_EPWM2_TZ             = 19 + 222,     //EPWM2_TZ interrupt
    INT_EPWM1_TZ             = 19 + 223,     //EPWM1_TZ interrupt

    INT_SYS_ERR              = 19 + 230,     //SYS_ERR interrupt
    INT_CPU2_WDG             = 19 + 231,     //cpu2 watchdog interrupt
    INT_CPU1_WDG             = 19 + 232,     //cpu1 watchdog interrupt
    INT_TIMER0               = 19 + 233,     //TIMER0 interrupt
    INT_ADCD1                = 19 + 234,     //ADCD1 interrupt
    INT_XINT2                = 19 + 235,     //XINT2 interrupt
    INT_XINT1                = 19 + 236,     //XINT1 interrupt
    INT_ADCC1                = 19 + 237,     //ADCC1 interrupt
    INT_ADCB1                = 19 + 238,     //ADCB1 interrupt
    INT_ADCA1                = 19 + 239,     //ADCA1 interrupt
#endif /* IS_GS32F3xx(0x22) */
    SOC_INT_MAX,
} IRQn_Type;

#ifdef __cplusplus
}
#endif

#endif /* IS_GS32F3xx() */
#endif /* DEVICE_DRIVERLIB_HW_INTS_GS32F00xx_H_ */
