/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_memmap_hp32i002.h
*   @brief   
*
*   commit history
*   2024/4/17 zhaolei rename 2.2 sysctl base name
*   2024/4/20 zhaolei add 2.2 SUB_CRG_BASE
*   2024/5/07 zhaolei remove 2.0/2.2 FLASH ICACHE/DCACHE BASE, not exist
*   2024/6/06 zhaolei update 2.2 memory base
*   2025/1/1  hezhiyuan add "WWD1_BASE WWD2_BASE WD2_BASE"
*/

#ifndef DEVICE_HW_MEMMAP_GS32F3xx_H_
#define DEVICE_HW_MEMMAP_GS32F3xx_H_

#include "gs32_version.h"

#if  IS_GS32F3xx()
#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#if IS_GS32F3xx(0x22)
#define CPU1_ILM_BASE                   (0x10800000U)
#define CPU1_DLM_BASE                   (0x10840000U)
#define CPU2_ILM_AXI_BASE               (0x10880000U)
#define CPU2_DLM_AXI_BASE               (0x108C0000U)

#define AXI_SRAM0_BASE                  (0x10200000U)
#define AXI_SRAM1_BASE                  (0x10210000U)
#define FLEX_SRAM1_BASE                 (0x10220000U)
#define AXI_SRAM0_SHADOW_BASE           (0x10300000U)
#define AXI_SRAM1_SHADOW_BASE           (0x10310000U)
#define FLEX_SRAM1_SHADOW_BASE          (0x10320000U)

#define SYSMEM_DSP_BASE                 (0x1FFE0000U)
#define SYSMEM_ARM_BASE                 (0x1FFF0000U)

#define FLASH_MEMORY_BASE               (0x08000000U)

#define FLASH_BASE                      (0x08000000U)
#define FLASH_INFO_BASE                 (0x1FFF0000U)
#define FLASH_INFO_SIZE                 (32*1024)

#define OTP_BASE                        (0x1FFF8000U)
#define OPTION_BITS_BASE                (0x1FFFC000U)

//---------------------- AHB1 Peripheral ------------------------------------
#define ADCA_BASE                       (0x40000000U)
#define ADCB_BASE                       (0x40000800U)
#define ADCC_BASE                       (0x40001000U)
#define ADCD_BASE                       (0x40001800U)

#define ADCARESULT_BASE                 (ADCA_BASE + 0x400U)
#define ADCBRESULT_BASE                 (ADCB_BASE + 0x400U)
#define ADCCRESULT_BASE                 (ADCC_BASE + 0x400U)
#define ADCDRESULT_BASE                 (ADCD_BASE + 0x400U)

/* EPWM - Peripheral instance base addresses */
#define PREEPWM_BASE                    (0x40008000U)
#define EPWMTOP_BASE                    (0x40008000U)
#define EPWM1_BASE                      (0x40008800U)
#define EPWM2_BASE                      (0x40009000U)
#define EPWM3_BASE                      (0x40009800U)
#define EPWM4_BASE                      (0x4000A000U)
#define EPWM5_BASE                      (0x4000A800U)
#define EPWM6_BASE                      (0x4000B000U)
#define EPWM7_BASE                      (0x4000B800U)
#define EPWM8_BASE                      (0x4000C000U)
#define EPWM9_BASE                      (0x4000C800U)
#define EPWM10_BASE                     (0x4000D000U)
#define EPWM11_BASE                     (0x4000D800U)
#define EPWM12_BASE                     (0x4000E000U)
#define EPWM13_BASE                     (0x4000E800U)
#define EPWM14_BASE                     (0x4000F000U)
#define EPWM15_BASE                     (0x4000F800U)
#define EPWM16_BASE                     (0x40010000U)
#define EPWM17_BASE                     (0x40010800U)
#define EPWM18_BASE                     (0x40011000U)


/* ECAP - ECAP instance base addresses */
#define ECAP1_BASE                      (0x40028000U)                   /* ECAP1 Base Address */
#define ECAP2_BASE                      (0x40028200U)                   /* ECAP2 Base Address */
#define ECAP3_BASE                      (0x40028400U)                   /* ECAP3 Base Address */
#define ECAP4_BASE                      (0x40028600U)                   /* ECAP4 Base Address */
#define ECAP5_BASE                      (0x40028800U)                   /* ECAP5 Base Address */
#define ECAP6_BASE                      (0x40028A00U)                   /* ECAP6 Base Address */
#define ECAP7_BASE                      (0x40028C00U)                   /* ECAP7 Base Address */

/* eQEP - Enhanced Quadrature Encoder Pulse */
#define EQEP1_BASE                      (0x40030000U)
#define EQEP2_BASE                      (0x40030200U)
#define EQEP3_BASE                      (0x40030400U)
#define EQEP4_BASE                      (0x40030600U)
#define EQEP5_BASE                      (0x40030800U)
#define EQEP6_BASE                      (0x40030A00U)

#define AHB_COMM_PARA_BASE              (0x4003F000U)

//---------------------- AHB2 Peripheral ------------------------------------
#define CMPSS1_BASE                     (0x40040000U)
#define CMPSS2_BASE                     (0x40040200U)
#define CMPSS3_BASE                     (0x40040400U)
#define CMPSS4_BASE                     (0x40040600U)
#define CMPSS5_BASE                     (0x40040800U)
#define CMPSS6_BASE                     (0x40040A00U)
#define CMPSS7_BASE                     (0x40040C00U)
#define CMPSS8_BASE                     (0x40040E00U)
#define CMPSS9_BASE                     (0x40041000U)
#define CMPSS10_BASE                    (0x40041200U)
#define CMPSS11_BASE                    (0x40041400U)
#define CMPSS12_BASE                    (0x40041600U)

#define SDFM1_BASE                      (0x40043000U)
#define SDFM2_BASE                      (0x40043200U)
#define SDFM3_BASE                      (0x40043400U)
#define SDFM4_BASE                      (0x40043600U)

#define GPIODATA_BASE                   (0x40045000U)
#define GPIO_GROUP0_BASE                (0x40045000U)
#define GPIO_GROUP1_BASE                (0x40046000U)
#define GPIO_GROUP2_BASE                (0x40047000U)
#define GPIO_GROUP3_BASE                (0x40048000U)
#define GPIO_GROUP4_BASE                (0x40049000U)
#define GPIO_GROUP5_BASE                (0x4004A000U)
#define GPIO_GROUP6_BASE                (0x4004B000U)
#define GPIO_GROUP7_BASE                (0x4004C000U)
#define GPIO_GROUP8_BASE                (0x4004D000U)
#define GPIO_GROUP9_BASE                (0x4004E000U)
#define GPIO_GROUP10_BASE               (0x4004F000U)
#define GPIO_GROUP11_BASE               (0x40050000U)
#define GPIO_GROUP12_BASE               (0x40051000U)
#define GPIO_GROUP13_BASE               (0x40052000U)

#define CLB1_BASE                       (0x40065000U)
#define CLB2_BASE                       (0x40065400U)
#define CLB3_BASE                       (0x40065800U)
#define CLB4_BASE                       (0x40065C00U)
#define CLB5_BASE                       (0x40066000U)
#define CLB6_BASE                       (0x40066400U)
#define CLB7_BASE                       (0x40066800U)
#define CLB8_BASE                       (0x40066C00U)

/* XBAR - XBAR instance base addresses */
#define INPUTXBAR_BASE                  (0x4006D000U)
#define CLBINPUTXBAR_BASE               (0x4006D0C0U)
#define XBAR_BASE                       (0x4006D040U)
#define CLBOUTPUTXBAR_BASE              (0x4006D900U)
#define CLBOUTPUTXBAR2_BASE             (0x4006DA00U)
#define EPWMXBAR_BASE                   (0x4006D100U)
#define OUTPUTXBAR_BASE                 (0x4006D700U)
#define CLBXBAR_BASE                    (0x4006D400U)

//---------------------- AHB3 Peripheral ------------------------------------
#define DACA_BASE                       (0x40080000U)
#define DACB_BASE                       (0x40080200U)
#define DACC_BASE                       (0x40080400U)

// erad
#define ERAD_GLOBAL_BASE    0x40081000
#define ERAD_HWBP1_BASE     0x40081200
#define ERAD_COUNTER1_BASE  0x40081300

#define DMA1_BASE                       (0x40082000U)
#define DMA1_CH1_BASE                   (0x40082100U)
#define DMA1_CH2_BASE                   (0x40082200U)
#define DMA1_CH3_BASE                   (0x40082300U)
#define DMA1_CH4_BASE                   (0x40082400U)
#define DMA1_CH5_BASE                   (0x40082500U)
#define DMA1_CH6_BASE                   (0x40082600U)
#define DMA1_CH7_BASE                   (0x40082700U)
#define DMA1_CH8_BASE                   (0x40082800U)
#define DMA1_MUX_BASE                   (0x40085000U)


#define EPG_BASE                        (0x40086000U)
#define SEMA_BASE                       (0x40087000U)
#define CRC_BASE                        (0x40088000U)

#define DMA2_BASE                       (0x4008F000U)
#define DMA2_CH1_BASE                   (0x4008F100U)
#define DMA2_CH2_BASE                   (0x4008F200U)
#define DMA2_CH3_BASE                   (0x4008F300U)
#define DMA2_CH4_BASE                   (0x4008F400U)
#define DMA2_CH5_BASE                   (0x4008F500U)
#define DMA2_CH6_BASE                   (0x4008F600U)
#define DMA2_CH7_BASE                   (0x4008F700U)
#define DMA2_CH8_BASE                   (0x4008F800U)
#define DMA2_MUX_BASE                   (0x40092000U)


//---------------------- APB1 Peripheral ------------------------------------
#define APB_COMM_PARA_BASE              (0x400C0000U)

/* SCI - SCI instance base addresses */
#define SCIA_BASE                      (0x400C1000U)
#define SCIB_BASE                      (0x400C1200U)
#define SCIC_BASE                      (0x400C1400U)
#define SCID_BASE                      (0x400C1600U)
#define SCIE_BASE                      (0x400C1800U)
#define SCIF_BASE                      (0x400C1A00U)

#define I2CA_BASE                       (0x400C2000U)
#define I2CB_BASE                       (0x400C2200U)
#define I2CC_BASE                       (0x400C2600U)

#define PMBUSA_BASE                     (0x400C2400U)

/* SPI - Peripheral instance base addresses */
#define SPIA_BASE                       (0x400C3000U)
#define SPIB_BASE                       (0x400C3200U)
#define SPIC_BASE                       (0x400C3400U)
#define SPID_BASE                       (0x400C3600U)
#define SPIE_BASE                       (0x400C3800U)

#define CANA_BASE                       (0x400C4000U)
#define CANB_BASE                       (0x400C4200U)
#define CANC_BASE                       (0x400C4400U)
#define CAND_BASE                       (0x400C4600U)

#define LINA_BASE                       (0x400C5000U)
#define LINB_BASE                       (0x400C5200U)

#define SUB_CRG_BASE                    (0x400C6000U)

/* CPUTIMER - CPUTIMER instance base addresses */
#define CPUTIMER0_BASE                  (0x400C8000U)
#define CPUTIMER1_BASE                  (0x400C8020U)
#define CPUTIMER2_BASE                  (0x400C9000U)
#define CPUTIMER3_BASE                  (0x400C9020U)
#define CPUTIMER4_BASE                  (0x400CA000U)
#define CPUTIMER5_BASE                  (0x400CA020U)

#define GPIOCTRL_BASE                   (0x400CC000U)
#define ANALOGSUBSYS_BASE               (0x400CD000U)
#define CRG_CFG_BASE                    (0x400CE000U)
#define SYSCTL_BASE                     (0x400CF000U)

/** Watchdog base address */
#define GWDG_CPU1_BASE                  (0x400D1000U)         /* DSP General Watchdog0 Base Address */
#define WWDG_CPU1_BASE                  (0x400D1020U)         /* DSP Window Watchdog0 Base Address */
#define GWDG_CPU2_BASE                  (0x400D2000U)         /* DSP General Watchdog1 Base Address */
#define WWDG_CPU2_BASE                  (0x400D2020U)         /* DSP Window Watchdog1 Base Address */

#define WD1_BASE                        GWDG_CPU1_BASE
#define WWD1_BASE                       WWDG_CPU1_BASE
#define WD2_BASE                        GWDG_CPU2_BASE
#define WWD2_BASE                       WWDG_CPU2_BASE

#define NMI_BASE						(0x400D4000U)
//---------------------- AHB4 Peripheral -------------------------
#define FLASH_INTERFACE_EFC_BASE        (0x40087000U)

#define SYSCTL_COMM_PARA_BASE           (0x50223000U)   /** SYNCIN/OUT select for ecap and epwm */

#define DSP_RSV_CFG_BASE                (0x58000000U)

#define SYSCTL_DSP_BASE                 (SYSCTL_BASE)

#define FSMC_BANK1_BASE                 (0x70000000U) /*!< FSMC BANK1: NOR/SRAM accessmemory base address */

#define FSMC_CFG_BASE                   (0x90000000U) /*!< FSMC config registers base address */

#endif


#define FLASH_EFUSE_EFC_BASE            FLASH2_INTERFACE_EFC_BASE

#define GPIO_PORTA_BASE                 (GPIO_GROUP0_BASE)
#define GPIO_PORTB_BASE                 (GPIO_GROUP1_BASE)
#define GPIO_PORTC_BASE                 (GPIO_GROUP2_BASE)
#define GPIO_PORTD_BASE                 (GPIO_GROUP3_BASE)
#define GPIO_PORTE_BASE                 (GPIO_GROUP4_BASE)
#define GPIO_PORTF_BASE                 (GPIO_GROUP5_BASE)
#define GPIO_PORTG_BASE                 (GPIO_GROUP6_BASE)
#define GPIO_PORTH_BASE                 (GPIO_GROUP7_BASE)
#define GPIO_PORTI_BASE                 (GPIO_GROUP8_BASE)
#define GPIO_PORTJ_BASE                 (GPIO_GROUP9_BASE)
#define GPIO_PORTK_BASE                 (GPIO_GROUP10_BASE)
#define GPIO_PORTL_BASE                 (GPIO_GROUP11_BASE)
#define GPIO_PORTM_BASE                 (GPIO_GROUP12_BASE)
#define GPIO_PORTN_BASE                 (GPIO_GROUP13_BASE)

#ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_HW_MEMMAP_GS32F3xx_H_ */
