/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/*
 * enc.c
 *
 *  Created on: 2025 0619  WUMAN
 *
 */
#ifdef __cplusplus
extern "C"{
#endif


#include "enc.h"


//-------------------------     abs2qep     -------------------------//

// Set the clock frequency of the cured abs2qep

void PM_abs2qep_configwidth (uint32_t base, uint32_t qclk_phase, uint32_t qclk_period)
{
	ASSERT(ENC_isBaseValid(base));
	 HWREG(base + ABS2QEP_CNT0_REF) = qclk_phase<<0 | qclk_period<<16 ;
}

// How many cycles it takes to set the ABS2QEP
void PM_abs2qep_config_ptodown (uint32_t base, uint32_t pto_down)
{
	ASSERT(ENC_isBaseValid(base));
	 HWREG( base+ ABS2QEP_CNT1_REF) = pto_down<<16 ;
}

//Set the pulse width of the qepi in the ABS2QEP
void PM_abs2qep_config_qepiwidth (uint32_t base, uint32_t qepi_low, uint32_t qepi_high)
{
	ASSERT(ENC_isBaseValid(base));
	 HWREG( base+ ABS2QEP_CNT2_REF) = qepi_low<<0 | qepi_high<<16 ;
}

//Set the direction of the ABS2QEP
void PM_abs2qep_config_direction (uint32_t base, uint32_t direction)
{
	ASSERT(ENC_isBaseValid(base));
	 HWREG( base+ ABS2QEP_CTRL)|= direction<< 1 ;
}

// enable abs2qep Start to wave
void PM_abs2qep_enable (uint32_t base)
{
	ASSERT(ENC_isBaseValid(base));
	 HWREG( base+ ABS2QEP_CTRL) |= 0x1 ;
}

// disable abs2qep stop to wave
void PM_abs2qep_disable (uint32_t base)
{
	ASSERT(ENC_isBaseValid(base));
	 HWREG( base+ ABS2QEP_CTRL) = HWREG( base+ ABS2QEP_CTRL) & 0x2;
}

// get the current counter

uint32_t getPM_abs2qep_CURCNT (uint32_t base, uint32_t qclk_cnt)
{
	ASSERT(ENC_isBaseValid(base));
	uint32_t qclk_mun;
	if(qclk_cnt==0)
	{
		qclk_mun= HWREG(base + ABS2QEP_CNT0_RPT)  ; //qclk freq counter report
	}
	else if (qclk_cnt==1) {
		qclk_mun= HWREG(base + ABS2QEP_CNT1_RPT)  ;

	} else {
		qclk_mun= HWREG(base + ABS2QEP_CNT2_RPT)  ;
	}
	return(qclk_mun);
}
//-------------------------     abs2qep     -------------------------//

//-------------------------     qepdiv     -------------------------//
// Select the input signal for the qepdiv
void PM_qepdiv_input (uint32_t base,QEPDIV_INPUT_SEL  qepa_input,QEPDIV_INPUT_SEL  qepb_input ,QEPDIV_INPUT_SEL qepi_input)
{
	ASSERT(ENC_isBaseValid(base));
	HWREG(base + QEPDIV_CTRL) = qepa_input<<4 | qepb_input<<8 | qepi_input<<12 ;
}

// Set the frequency separation coefficient of qepdiv
void PM_qepdiv_diviider (uint32_t base, uint32_t div)
{
	ASSERT(ENC_isBaseValid(base));
	HWREG( base+ QEPDIV_DIVIDER)= div ;
}

// Set the pulse width of the qepi
void PM_qepdiv_index_width (uint32_t base, uint32_t index_width)
{
	ASSERT(ENC_isBaseValid(base));
	HWREG( base+ QEPDIV_INDEX_WIDTH)= index_width ;
}

// enable qepdiv start to wave
void PM_qepdiv_enable (uint32_t base)
{
	ASSERT(ENC_isBaseValid(base));
	 HWREG( base+ QEPDIV_CTRL) |= 0x1 ;
}

// disable qepdiv stop to wave
void PM_qepdiv_disable (uint32_t base)
{
	ASSERT(ENC_isBaseValid(base));
	 HWREG( base+ QEPDIV_CTRL) = HWREG( base+ QEPDIV_CTRL) & 0xfffe;
}

//-------------------------     qepdiv     -------------------------//

#if TA_FORMAT_MODULE
void ENC_TA_setConfig(uint32_t base,
					  TA_FORMATMODE format,\
					  uint32_t clbclkHz,
					  uint32_t bitRate,
					  CLB_ENC_INSEL input)
{
	uint32_t ctrl0;

	ASSERT(ENC_isBaseValid(base));
	ASSERT((bitRate<= (clbclkHz / 2)));

	ctrl0 = ((clbclkHz/bitRate)-1)<<ENC_TA_FORMAT_CTRL0_BAUDRATE_S;

	ctrl0 = (ctrl0 & (~ENC_TA_FORMAT_CTRL0_FORMAT_M))| \
							(format << ENC_TA_FORMAT_CTRL0_FORMAT_S);

	ctrl0 = (ctrl0 & (~ENC_TA_FORMAT_CTRL0_RXD_IN_SEL_M)) |	\
							(input << ENC_TA_FORMAT_CTRL0_RXD_IN_SEL_S);

	HWREG(base + ENC_O_TA_FORMAT_CTRL0) = ctrl0;
}

void ENC_TA_reviceHardwareMode(uint32_t base)
{
	ASSERT(ENC_isBaseValid(base));

	HWREG(base + ENC_O_TA_FORMAT_CTRL0) &= (~ENC_TA_FORMAT_CTRL0_RCV_MODE_M);
}

void ENC_TA_reviceSoftwareMode(uint32_t base,uint32_t waittime)
{
	ASSERT(ENC_isBaseValid(base));
	ASSERT(((waittime<=65535U) && (waittime >= 1)));

	HWREG(base + ENC_O_TA_FORMAT_CTRL0) |= ENC_TA_FORMAT_CTRL0_RCV_MODE_M;
	HWREG(base + ENC_O_TA_FORMAT_TIMING1) = 			\
			(HWREG(base +  ENC_O_TA_FORMAT_TIMING1)&(~ENC_TA_FORMAT_TIMING1_T5_CFG_M))|\
			((waittime-1) << ENC_TA_FORMAT_TIMING1_T5_CFG_S);

}

void ENC_TA_setTxClockDelay(uint32_t base,\
							 uint16_t startdelay,
							 uint16_t framedelay,
							 uint16_t enddelay)
{
	ASSERT(ENC_isBaseValid(base));

	HWREG(base + ENC_O_TA_FORMAT_TIMING0) =
			(HWREG(base + ENC_O_TA_FORMAT_TIMING0) & (~ENC_TA_FORMAT_TIMING0_T2_CFG_M))|\
					(startdelay);
	HWREG(base + ENC_O_TA_FORMAT_TIMING1) =
			(HWREG(base + ENC_O_TA_FORMAT_TIMING1) & (~ENC_TA_FORMAT_TIMING1_T4_CFG_M))|\
					(framedelay);
	HWREG(base + ENC_O_TA_FORMAT_TIMING0) =
			(HWREG(base + ENC_O_TA_FORMAT_TIMING0) & (~ENC_TA_FORMAT_TIMING0_T3_CFG_M))|\
					(enddelay<<ENC_TA_FORMAT_TIMING0_T3_CFG_S);
}

#endif /* TA_FORMAT_MODULE */

#if BISS_MODULE

extern void ENC_BISS_setConfig(uint32_t base,\
								BISS_SSI_MODE format,\
							   uint32_t clbclkHz,\
							   uint32_t bitRate,\
							   CLB_ENC_INSEL input)
{
	uint32_t ctrl0;

	ASSERT(ENC_isBaseValid(base));
	ASSERT((bitRate<= (clbclkHz / 2)));

	ctrl0 = ((clbclkHz/bitRate)-1)<<ENC_BISS_CTRL_BAUDRATE_S;

	ctrl0 |=  ENC_BISS_CTRL_TIMEOUT_MODE_M;

	ctrl0 = (ctrl0 & (~ENC_BISS_CTRL_SSI_MODE_M))| \
							(format << ENC_BISS_CTRL_SSI_MODE_S);

	ctrl0 = (ctrl0 & (~ENC_BISS_CTRL_SL_IN_SEL_M)) |	\
							(input << ENC_BISS_CTRL_SL_IN_SEL_S);
	HWREG(base + ENC_O_BISS_CTRL) = ctrl0;
}

void ENC_BISS_reviceHardwareMode(uint32_t base)
{
	ASSERT(ENC_isBaseValid(base));

	HWREG(base + ENC_O_BISS_CTRL) &= (~ENC_BISS_CTRL_RCV_MODE_M);
}

void ENC_BISS_reviceSoftwareMode(uint32_t base,uint32_t waittime)
{
	ASSERT(ENC_isBaseValid(base));
	ASSERT(((waittime<=65535U) && (ASSERT >= 1)));

	HWREG(base + ENC_O_BISS_CTRL) |= ENC_BISS_CTRL_RCV_MODE_M;
	HWREG(base + ENC_O_BISS_TIMING0) = 			\
			(HWREG(base + ENC_O_BISS_TIMING0)&(~ENC_BISS_TDLY_CFG_M))|\
			(waittime-1);

}

#endif /* BISS_MODULE */

#if ENDAT_MODULE
#endif /* ENDAT_MODULE */

#ifdef __cplusplus
}
#endif
