/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/******************************************************************************
 *
 * FILE:   epg.c
 *
 * TITLE:  GS32 EPG driver.
 *
 *****************************************************************************/

#include "gs32_version.h"
#include "epg.h"

//
// Select EPG Data Output
//
GS32_DRIVER_EPG_FUNC_T void
EPG_selectEPGDataOut(uint32_t base, EPG_DataIn dataIn,
                          EPG_DataOutSel dataOutSel)
{
    ASSERT(EPG_isMUXBaseValid(base));
    uint32_t regOffset;
    uint32_t bitPos;
    uint32_t regValue;

#if defined(IS_GS32F00xx) && (IS_GS32F00xx(0x12) || IS_GS32F00xx(0x30))
    ASSERT(dataIn <= 31U);
    regOffset = EPG_O_MXSEL0;
    bitPos = dataIn;
#elif defined(IS_GS32F3xx) && (IS_GS32F3xx(0x22))
    ASSERT(dataIn <= 63U);
    if (dataIn <= 31U)
    {
        regOffset = EPG_O_MXSEL0;
        bitPos = dataIn;
    }
    else
    {
        regOffset = EPG_O_MXSEL1;
        bitPos = dataIn - 32U;
    }
#elif defined(IS_GS32F3xx) && (IS_GS32F3xx(0x23))
    ASSERT(dataIn <= 95U);
    if (dataIn <= 31U)
    {
        regOffset = EPG_O_MXSEL0;
        bitPos = dataIn;
    }
    else if (dataIn <= 63U)
    {
        regOffset = EPG_O_MXSEL1;
        bitPos = dataIn - 32U;
    }
    else
    {
        regOffset = EPG_O_MXSEL2;
        bitPos = dataIn - 64U;
    }
#endif
    regValue = HWREG(base + regOffset);
    regValue = (regValue & ~(1U << bitPos)) | ((uint32_t)dataOutSel << bitPos);
    HWREG(base + regOffset) = regValue;
}
