/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_adc.h
*   @brief
*
*   2024/03/25, Zhao Lei, modify file header, add 3.0
*   2024/05/30, WenGuangYong,update ADC Version2(1.2 2.2) register,add 3.0 register(ADC Version3)
*   2024/06/05, WenGuangYong,fix  macro ADC_REP1CTL_SWSYNC 0x80000U    to  0x800000U
*	2024/06/26, WenGuangYong,Use macros to avoid conflicts related to 1.2CS macro definitions
*	2024/07/09, WenGuangYong,append ADCSOCPRICTL2 to support soc16-19
*   2024/09/02, update register address
*   2024/09/12, update ppb address
*/

#ifndef HW_ADC_H
#define HW_ADC_H
#include "inc/hw_types.h"
#include "gs32_version.h"

#ifndef ADC_REALSE
#ifndef HW_ASYSCTL_H

#if IS_GS32F00xx(0x12)
#define ADC_TRIM_VALUE						0x5204
#endif

#if IS_GS32F00xx(0x30)
#define ADC_TRIM_VALUE						0x5248U
#endif

#if IS_GS32F3xx(0x22)
#define ADC_TRIM_VALUE                      0X5204
#endif

#endif //HW_ASYSCTL_H
#endif //ADC_REALSE

//*************************************************************************************************
//
// The following are defines for the ADC register offsets
//
//*************************************************************************************************
/*ADC_REGSx Registers*/
#define ADC_O_CTL1                    0x0U
#define ADC_O_CTL2                    0x2U
#define ADC_O_BURSTCTL                0x4U
#define ADC_O_INTFLG                  0x6U
#define ADC_O_INTFLGCLR               0x8U
#define ADC_O_INTOVF                  0xAU
#define ADC_O_INTOVFCLR               0xCU
#define ADC_O_INTSEL1N2               0xEU
#define ADC_O_INTSEL3N4               0x10U
#define ADC_O_SOCPRICTL               0x12U
#define ADC_O_INTSOCSEL1              0x14U
#define ADC_O_INTSOCSEL2              0x16U
#define ADC_O_SOCFLG1                 0x18U
#define ADC_O_SOCFRC1                 0x1AU
#define ADC_O_SOCOVF1                 0x1CU
#define ADC_O_SOCOVFCLR1              0x1EU
#define ADC_O_SOC0CTL                 0x20U
#define ADC_O_SOC1CTL                 0x24U
#define ADC_O_SOC2CTL                 0x28U
#define ADC_O_SOC3CTL                 0x2CU
#define ADC_O_SOC4CTL                 0x30U
#define ADC_O_SOC5CTL                 0x34U
#define ADC_O_SOC6CTL                 0x38U
#define ADC_O_SOC7CTL                 0x3CU
#define ADC_O_SOC8CTL                 0x40U
#define ADC_O_SOC9CTL                 0x44U
#define ADC_O_SOC10CTL                0x48U
#define ADC_O_SOC11CTL                0x4CU
#define ADC_O_SOC12CTL                0x50U
#define ADC_O_SOC13CTL                0x54U
#define ADC_O_SOC14CTL                0x58U
#define ADC_O_SOC15CTL                0x5CU
#define ADC_O_EVTSTAT                 0x60U
#define ADC_O_EVTCLR                  0x64U
#define ADC_O_EVTSEL                  0x68U
#define ADC_O_EVTINTSEL               0x6CU
#define ADC_O_OSDETECT                0x70U
#define ADC_O_COUNTER                 0x72U
#define ADC_O_OFFTRIM                 0x76U
#define ADC_O_PPB1CONFIG              0x80U
#define ADC_O_PPB1STAMP               0x82U
#define ADC_O_PPB1OFFCAL              0x84U
#define ADC_O_PPB1OFFREF              0x86U
#define ADC_O_PPB1TRIPHI              0x88U
#define ADC_O_PPB1TRIPLO              0x8CU
#define ADC_O_PPB2CONFIG              0x90U
#define ADC_O_PPB2STAMP               0x92U
#define ADC_O_PPB2OFFCAL              0x94U
#define ADC_O_PPB2OFFREF              0x96U
#define ADC_O_PPB2TRIPHI              0x98U
#define ADC_O_PPB2TRIPLO              0x9CU
#define ADC_O_PPB3CONFIG              0xA0U
#define ADC_O_PPB3STAMP               0xA2U
#define ADC_O_PPB3OFFCAL              0xA4U
#define ADC_O_PPB3OFFREF              0xA6U
#define ADC_O_PPB3TRIPHI              0xA8U
#define ADC_O_PPB3TRIPLO              0xACU
#define ADC_O_PPB4CONFIG              0xB0U
#define ADC_O_PPB4STAMP               0xB2U
#define ADC_O_PPB4OFFCAL              0xB4U
#define ADC_O_PPB4OFFREF              0xB6U
#define ADC_O_PPB4TRIPHI              0xB8U
#define ADC_O_PPB4TRIPLO              0xBCU
#define ADC_O_INTCYCLE                0xDEU
#define ADC_O_INLTRIM1                0xE0U
#define ADC_O_INLTRIM2                0xE4U
#define ADC_O_INLTRIM3                0xE8U

#if (ADC_VERSION == 0001)
/*ADC_REGSx Registers For 1.0ES samples and 1.1ES */
#define ADC_O_PPB1_INT_CLR            0xECU
#define ADC_O_PPB1_INT_FLAG           0xEEU
#define ADC_O_PPB2_INT_CLR            0xF0U
#define ADC_O_PPB2_INT_FLAG           0xF2U
#define ADC_O_PPB3_INT_CLR            0xF4U
#define ADC_O_PPB3_INT_FLAG           0xF6U
#define ADC_O_PPB4_INT_CLR            0xF8U
#define ADC_O_PPB4_INT_FLAG           0xFAU
#define ADC_O_PPB_INT_MODE            0xFCU

#elif (ADC_VERSION == 0002)

/*ADC_REGSx Registers For 1.2ES*/
#define ADC_REGS_LOCK				  0xD0U
#define ADC_O_PPB_INT_CLR             0xD4U
#define ADC_O_PPB_INT_FLAG            0xD6U
#define ADC_O_PPB_INT_MODE            0xD8U
#define ADC_O_REP1CTL				  0x100U
#define ADC_O_REP1N					  0x104U
#define ADC_O_REP1PHASE				  0x108U
#define ADC_O_REP1SPREAD			  0x10CU
#define ADC_O_REP1FRC				  0x110U
#define ADC_O_REP2CTL				  0x120U
#define ADC_O_REP2N					  0x124U
#define ADC_O_REP2PHASE				  0x128U
#define ADC_O_REP2SPREAD			  0x12CU
#define ADC_O_REP2FRC				  0x130U
#define ADC_O_PPB1LIMIT			 	  0x140U
#define ADC_O_PPBP1COUNT			  0x144U
#define ADC_O_PPB1CONFIG2		 	  0x148U
#define ADC_O_PPB1PSUM				  0x14CU
#define ADC_O_PPB1PMAX			 	  0x150U
#define ADC_O_PPB1PMAXI				  0x154U
#define ADC_O_PPB1PMIN				  0x158U
#define ADC_O_PPB1PMINI				  0x15CU
#define ADC_O_PPB1TRIPLO2			  0x160U
#define ADC_O_PPB2LIMIT				  0x174U
#define ADC_O_PPBP2COUNT			  0x178U
#define ADC_O_PPB2CONFIG2			  0x17CU
#define ADC_O_PPB2PSUM				  0x180U
#define ADC_O_PPB2PMAX				  0x184U
#define ADC_O_PPB2PMAXI				  0x188U
#define ADC_O_PPB2PMIN				  0x18CU
#define ADC_O_PPB2PMINI				  0x190U
#define ADC_O_PPB2TRIPLO2			  0x194U
#define ADC_O_PPB3LIMIT				  0x1A8U
#define ADC_O_PPBP3COUNT			  0x1ACU
#define ADC_O_PPB3CONFIG2			  0x1B0U
#define ADC_O_PPB3PSUM				  0x1B4U
#define ADC_O_PPB3PMAX				  0x1B8U
#define ADC_O_PPB3PMAXI				  0x1BCU
#define ADC_O_PPB3PMIN				  0x1C0U
#define ADC_O_PPB3PMINI				  0x1C4U
#define ADC_O_PPB3TRIPLO2			  0x1C8U
#define ADC_O_PPB4LIMIT				  0x1DCU
#define ADC_O_PPBP4COUNT			  0x1E0U
#define ADC_O_PPB4CONFIG2			  0x1E4U
#define ADC_O_PPB4PSUM				  0x1E8U
#define ADC_O_PPB4PMAX				  0x1ECU
#define ADC_O_PPB4PMAXI				  0x1F0U
#define ADC_O_PPB4PMIN				  0x1F4U
#define ADC_O_PPB4PMINI				  0x1F8U
#define ADC_O_PPB4TRIPLO2			  0x1FCU
#define ADC_O_SOCPRICTL2			  0x200U
#define ADC_O_INTSOCSEL3			  0x202U
#define ADC_O_SOCFLG2				  0x204U
#define ADC_O_SOCFRC2				  0x206U
#define ADC_O_SOCOVF2				  0x208U
#define ADC_O_SOCOVFCLR2			  0x20AU
#define ADC_O_SOC16CTL				  0x210U
#define ADC_O_SOC17CTL				  0x214U
#define ADC_O_SOC18CTL				  0x218U
#define ADC_O_SOC19CTL				  0x21CU

#elif (ADC_VERSION == 0003)

/*ADC_REGSx Registers For 3.0*/
#define ADC_REGS_LOCK				  0xD0U
#define ADC_O_PPB_INT_CLR             0xD4U
#define ADC_O_PPB_INT_FLAG            0xD6U
#define ADC_O_PPB_INT_MODE            0xD8U
#define ADC_O_INT_CYCLE               0xDEU
#define ADC_O_INL_TRIM1               0xE0U
#define ADC_O_INL_TRIM2               0xE4U
#define ADC_O_INL_TRIM3	              0xE8U
#define ADC_O_REP1CTL				  0x194U
#define ADC_O_REP1N					  0x198U
#define ADC_O_REP1PHASE				  0x19CU
#define ADC_O_REP1SPREAD			  0x1A0U
#define ADC_O_REP1FRC				  0x1A4U
#define ADC_O_REP2CTL				  0x1B4U
#define ADC_O_REP2N					  0x1B8U
#define ADC_O_REP2PHASE				  0x1BCU
#define ADC_O_REP2SPREAD			  0x1C0U
#define ADC_O_REP2FRC				  0x1C4U
#define ADC_O_PPB1LIMIT			 	  0x1D4U
#define ADC_O_PPBP1COUNT			  0x1D8U
#define ADC_O_PPB1CONFIG2		 	  0x1DCU
#define ADC_O_PPB1PSUM				  0x1E0U
#define ADC_O_PPB1PMAX			 	  0x1E4U
#define ADC_O_PPB1PMAXI				  0x1E8U
#define ADC_O_PPB1PMIN				  0x1ECU
#define ADC_O_PPB1PMINI				  0x1F0U
#define ADC_O_PPB1TRIPLO2			  0x1F4U
#define ADC_O_PPB2LIMIT				  0x208U
#define ADC_O_PPBP2COUNT			  0x20CU
#define ADC_O_PPB2CONFIG2			  0x210U
#define ADC_O_PPB2PSUM				  0x214U
#define ADC_O_PPB2PMAX				  0x218U
#define ADC_O_PPB2PMAXI				  0x21CU
#define ADC_O_PPB2PMIN				  0x220U
#define ADC_O_PPB2PMINI				  0x224U
#define ADC_O_PPB2TRIPLO2			  0x228U
#define ADC_O_PPB3LIMIT				  0x23CU
#define ADC_O_PPBP3COUNT			  0x240U
#define ADC_O_PPB3CONFIG2			  0x244U
#define ADC_O_PPB3PSUM				  0x248U
#define ADC_O_PPB3PMAX				  0x24CU
#define ADC_O_PPB3PMAXI				  0x250U
#define ADC_O_PPB3PMIN				  0x254U
#define ADC_O_PPB3PMINI				  0x258U
#define ADC_O_PPB3TRIPLO2			  0x25CU
#define ADC_O_PPB4LIMIT				  0x270U
#define ADC_O_PPBP4COUNT			  0x274U
#define ADC_O_PPB4CONFIG2			  0x278U
#define ADC_O_PPB4PSUM				  0x27CU
#define ADC_O_PPB4PMAX				  0x280U
#define ADC_O_PPB4PMAXI				  0x284U
#define ADC_O_PPB4PMIN				  0x288U
#define ADC_O_PPB4PMINI				  0x28CU
#define ADC_O_PPB4TRIPLO2			  0x290U
#define ADC_O_SOCPRICTL2			  0x300U
#define ADC_O_INTSOCSEL3			  0x302U
#define ADC_O_SOCFLG2				  0x304U
#define ADC_O_SOCFRC2				  0x306U
#define ADC_O_SOCOVF2				  0x308U
#define ADC_O_SOCOVFCLR2			  0x30AU
#define ADC_O_SOC16CTL				  0x30CU
#define ADC_O_SOC17CTL				  0x310U
#define ADC_O_SOC18CTL				  0x314U
#define ADC_O_SOC19CTL				  0x318U
#define ADC_O_SOC20CTL                0x31CU
#define ADC_O_SOC_RST_CTRL            0x36CU

#endif  //ADC_REGSx Registers


/*ADC_RESULT_REGSx Registers*/
#define ADC_O_RESULT0                 0x0U
#define ADC_O_RESULT1                 0x2U
#define ADC_O_RESULT2                 0x4U
#define ADC_O_RESULT3                 0x6U
#define ADC_O_RESULT4                 0x8U
#define ADC_O_RESULT5                 0xAU
#define ADC_O_RESULT6                 0xCU
#define ADC_O_RESULT7                 0xEU
#define ADC_O_RESULT8                 0x10U
#define ADC_O_RESULT9                 0x12U
#define ADC_O_RESULT10                0x14U
#define ADC_O_RESULT11                0x16U
#define ADC_O_RESULT12                0x18U
#define ADC_O_RESULT13                0x1AU
#define ADC_O_RESULT14                0x1CU
#define ADC_O_RESULT15                0x1EU
#define ADC_O_PPB1RESULT              0x20U
#define ADC_O_PPB2RESULT              0x24U
#define ADC_O_PPB3RESULT              0x28U
#define ADC_O_PPB4RESULT              0x2CU

#if (ADC_VERSION == 0001)
/*ADC_RESULT_REGSx Registers For 1.0ES and 1.1ES */
#define ADC_O_MEANEN                  0x30U
#define ADC_O_FPRND                   0x38U
#define ADC_O_SMPSEL                  0x3CU
#define ADC_E_RESULT0                 0x40U
#define ADC_E_RESULT1                 0x44U
#define ADC_E_RESULT2                 0x48U
#define ADC_E_RESULT3                 0x4CU
#define ADC_E_RESULT4                 0x50U
#define ADC_E_RESULT5                 0x54U
#define ADC_E_RESULT6                 0x58U
#define ADC_E_RESULT7                 0x5CU
#define ADC_E_RESULT8                 0x60U
#define ADC_E_RESULT9                 0x64U
#define ADC_E_RESULT10                0x68U
#define ADC_E_RESULT11                0x6CU
#define ADC_E_RESULT12                0x70U
#define ADC_E_RESULT13                0x74U
#define ADC_E_RESULT14                0x78U
#define ADC_E_RESULT15                0x7CU
#define ADC_E_SCALE0                  0x80U
#define ADC_E_SCALE1                  0x84U
#define ADC_E_SCALE2                  0x88U
#define ADC_E_SCALE3                  0x8CU
#define ADC_E_SCALE4                  0x90U
#define ADC_E_SCALE5                  0x94U
#define ADC_E_SCALE6                  0x98U
#define ADC_E_SCALE7                  0x9CU
#define ADC_E_SCALE8                  0xA0U
#define ADC_E_SCALE9                  0xA4U
#define ADC_E_SCALE10                 0xA8U
#define ADC_E_SCALE11                 0xACU
#define ADC_E_SCALE12                 0xB0U
#define ADC_E_SCALE13                 0xB4U
#define ADC_E_SCALE14                 0xB8U
#define ADC_E_SCALE15                 0xBCU
#define ADC_E_OFFSET0                 0xC0U
#define ADC_E_OFFSET1                 0xC4U
#define ADC_E_OFFSET2                 0xC8U
#define ADC_E_OFFSET3                 0xCCU
#define ADC_E_OFFSET4                 0xD0U
#define ADC_E_OFFSET5                 0xD4U
#define ADC_E_OFFSET6                 0xD8U
#define ADC_E_OFFSET7                 0xDCU
#define ADC_E_OFFSET8                 0xE0U
#define ADC_E_OFFSET9                 0xE4U
#define ADC_E_OFFSET10                0xE8U
#define ADC_E_OFFSET11                0xECU
#define ADC_E_OFFSET12                0xF0U
#define ADC_E_OFFSET13                0xF4U
#define ADC_E_OFFSET14                0xF8U
#define ADC_E_OFFSET15                0xFCU

#elif (ADC_VERSION == 0002)
/*ADC_RESULT_REGSx Registers For 1.2ES*/
#define ADC_O_PPB1SUM         	      0x30U
#define ADC_O_PPB1COUNT       	      0x34U
#define ADC_O_PPB2SUM				  0x38U
#define ADC_O_PP2COUNT       	      0x3CU
#define ADC_O_PPB3SUM       	      0x40U
#define ADC_O_PP3COUNT      	      0x44U
#define ADC_O_PPB4SUM       	      0x48U
#define ADC_O_PP4COUNT   	          0x4CU
#define ADC_O_PPB1MAX       	      0x50U
#define ADC_O_PPB1MAXI             	  0x54U
#define ADC_O_PPB1MIN              	  0x58U
#define ADC_O_PPB1MINI       	      0x5CU
#define ADC_O_PPB2MAX        	      0x60U
#define ADC_O_PPB2MAXI     	          0x64U
#define ADC_O_PPB2MIN      	          0x68U
#define ADC_O_PPB2MINI     	          0x6CU
#define ADC_O_PPB3MAX       	      0x70U
#define ADC_O_PPB3MAXI            	  0x74U
#define ADC_O_PPB3MIN        	      0x78U
#define ADC_O_PPB3MINI    	          0x7CU
#define ADC_O_PPB4MAX      	          0x80U
#define ADC_O_PPB4MAXI     	          0x84U
#define ADC_O_PPB4MIN                 0x88U
#define ADC_O_PPB4MINI                0x8CU
#define ADC_O_RESULT16                0xE0U
#define ADC_O_RESULT17                0xE2U
#define ADC_O_RESULT18                0xE4U
#define ADC_O_RESULT19                0xE6U
#define ADC_O_MEANEN                  0xF0U
#define ADC_O_MEANEN2                 0xF4U
#define ADC_O_FPRND                   0xF8U
#define ADC_O_SMPSEL                  0xFCU
#define ADC_E_RESULT0                 0x100U
#define ADC_E_RESULT1                 0x104U
#define ADC_E_RESULT2                 0x108U
#define ADC_E_RESULT3                 0x10CU
#define ADC_E_RESULT4                 0x110U
#define ADC_E_RESULT5                 0x114U
#define ADC_E_RESULT6                 0x118U
#define ADC_E_RESULT7                 0x11CU
#define ADC_E_RESULT8                 0x120U
#define ADC_E_RESULT9                 0x124U
#define ADC_E_RESULT10                0x128U
#define ADC_E_RESULT11                0x12CU
#define ADC_E_RESULT12                0x130U
#define ADC_E_RESULT13                0x134U
#define ADC_E_RESULT14                0x138U
#define ADC_E_RESULT15                0x13CU
#define ADC_E_RESULT16                0x140U
#define ADC_E_RESULT17                0x144U
#define ADC_E_RESULT18                0x148U
#define ADC_E_RESULT19                0x14CU
#define ADC_E_SCALE0                  0x150U
#define ADC_E_SCALE1                  0x154U
#define ADC_E_SCALE2                  0x158U
#define ADC_E_SCALE3                  0x15CU
#define ADC_E_SCALE4                  0x160U
#define ADC_E_SCALE5                  0x164U
#define ADC_E_SCALE6                  0x168U
#define ADC_E_SCALE7                  0x16CU
#define ADC_E_SCALE8                  0x170U
#define ADC_E_SCALE9                  0x174U
#define ADC_E_SCALE10                 0x178U
#define ADC_E_SCALE11                 0x17CU
#define ADC_E_SCALE12                 0x180U
#define ADC_E_SCALE13                 0x184U
#define ADC_E_SCALE14                 0x188U
#define ADC_E_SCALE15                 0x18CU
#define ADC_E_SCALE16                 0x190U
#define ADC_E_SCALE17                 0x194U
#define ADC_E_SCALE18                 0x198U
#define ADC_E_SCALE19                 0x19CU
#define ADC_E_OFFSET0                 0x1A0U
#define ADC_E_OFFSET1                 0x1A4U
#define ADC_E_OFFSET2                 0x1A8U
#define ADC_E_OFFSET3                 0x1ACU
#define ADC_E_OFFSET4                 0x1B0U
#define ADC_E_OFFSET5                 0x1B4U
#define ADC_E_OFFSET6                 0x1B8U
#define ADC_E_OFFSET7                 0x1BCU
#define ADC_E_OFFSET8                 0x1C0U
#define ADC_E_OFFSET9                 0x1C4U
#define ADC_E_OFFSET10                0x1C8U
#define ADC_E_OFFSET11                0x1CCU
#define ADC_E_OFFSET12                0x1D0U
#define ADC_E_OFFSET13                0x1D4U
#define ADC_E_OFFSET14                0x1D8U
#define ADC_E_OFFSET15                0x1DCU
#define ADC_E_OFFSET16                0x1E0U
#define ADC_E_OFFSET17                0x1E4U
#define ADC_E_OFFSET18                0x1E8U
#define ADC_E_OFFSET19                0x1ECU

#elif (ADC_VERSION == 0003)
#define ADC_O_PPB1SUM         	      0x50U
#define ADC_O_PPB1COUNT       	      0x54U
#define ADC_O_PPB2SUM				  0x58U
#define ADC_O_PPB2COUNT       	      0x5CU
#define ADC_O_PPB3SUM       	      0x60U
#define ADC_O_PPB3COUNT      	      0x64
#define ADC_O_PPB4SUM       	      0x68
#define ADC_O_PP4COUNT   	          0x6C
#define ADC_O_PPB1MAX       	      0x70
#define ADC_O_PPB1MAXI             	  0x74
#define ADC_O_PPB1MIN              	  0x78
#define ADC_O_PPB1MINI       	      0x7C
#define ADC_O_PPB2MAX        	      0x80
#define ADC_O_PPB2MAXI     	          0x84
#define ADC_O_PPB2MIN      	          0x88
#define ADC_O_PPB2MINI     	          0x8C
#define ADC_O_PPB3MAX       	      0x90
#define ADC_O_PPB3MAXI            	  0x94
#define ADC_O_PPB3MIN        	      0x98
#define ADC_O_PPB3MINI    	          0x9C
#define ADC_O_PPB4MAX      	          0xA0
#define ADC_O_PPB4MAXI     	          0xA4
#define ADC_O_PPB4MIN                 0xA8
#define ADC_O_PPB4MINI                0xAC
#define ADC_O_RESULT16                0xE0U
#define ADC_O_RESULT17                0xE2U
#define ADC_O_RESULT18                0xE4U
#define ADC_O_RESULT19                0xE6U
#define ADC_O_RESULT20                0xE8U
#define ADC_O_MEANEN                  0xF0U
#define ADC_O_MEANEN2                 0xF4U
#define ADC_O_FPRND                   0xF8U
#define ADC_O_SMPSEL                  0xFCU
#define ADC_E_RESULT0                 0x100U
#define ADC_E_RESULT1                 0x104U
#define ADC_E_RESULT2                 0x108U
#define ADC_E_RESULT3                 0x10CU
#define ADC_E_RESULT4                 0x110U
#define ADC_E_RESULT5                 0x114U
#define ADC_E_RESULT6                 0x118U
#define ADC_E_RESULT7                 0x11CU
#define ADC_E_RESULT8                 0x120U
#define ADC_E_RESULT9                 0x124U
#define ADC_E_RESULT10                0x128U
#define ADC_E_RESULT11                0x12CU
#define ADC_E_RESULT12                0x130U
#define ADC_E_RESULT13                0x134U
#define ADC_E_RESULT14                0x138U
#define ADC_E_RESULT15                0x13CU
#define ADC_E_RESULT16                0x140U
#define ADC_E_RESULT17                0x144U
#define ADC_E_RESULT18                0x148U
#define ADC_E_RESULT19                0x14CU
#define ADC_E_RESULT20                0x150U //new
#define ADC_E_SCALE0                  0x160U
#define ADC_E_SCALE1                  0x164U
#define ADC_E_SCALE2                  0x168U
#define ADC_E_SCALE3                  0x16CU
#define ADC_E_SCALE4                  0x170U
#define ADC_E_SCALE5                  0x174U
#define ADC_E_SCALE6                  0x178U
#define ADC_E_SCALE7                  0x17CU
#define ADC_E_SCALE8                  0x180U
#define ADC_E_SCALE9                  0x184U
#define ADC_E_SCALE10                 0x188U
#define ADC_E_SCALE11                 0x18CU
#define ADC_E_SCALE12                 0x190U
#define ADC_E_SCALE13                 0x194U
#define ADC_E_SCALE14                 0x198U
#define ADC_E_SCALE15                 0x19CU
#define ADC_E_SCALE16                 0x1A0U
#define ADC_E_SCALE17                 0x1A4U
#define ADC_E_SCALE18                 0x1A8U
#define ADC_E_SCALE19                 0x1ACU
#define ADC_E_SCALE20                 0x1B0U  //new
#define ADC_E_OFFSET0                 0x1C0U
#define ADC_E_OFFSET1                 0x1C4U
#define ADC_E_OFFSET2                 0x1C8U
#define ADC_E_OFFSET3                 0x1CCU
#define ADC_E_OFFSET4                 0x1D0U
#define ADC_E_OFFSET5                 0x1D4U
#define ADC_E_OFFSET6                 0x1D8U
#define ADC_E_OFFSET7                 0x1DCU
#define ADC_E_OFFSET8                 0x1E0U
#define ADC_E_OFFSET9                 0x1E4U
#define ADC_E_OFFSET10                0x1E8U
#define ADC_E_OFFSET11                0x1ECU
#define ADC_E_OFFSET12                0x1F0U
#define ADC_E_OFFSET13                0x1F4U
#define ADC_E_OFFSET14                0x1F8U
#define ADC_E_OFFSET15                0x1FCU
#define ADC_E_OFFSET16                0x200U
#define ADC_E_OFFSET17                0x204U
#define ADC_E_OFFSET18                0x208U
#define ADC_E_OFFSET19                0x20CU
#define ADC_E_OFFSET20                0x210U //new

#endif	//ADC_RESULT_REGSx Registers


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADC_REGSx registers
//
//*************************************************************************************************


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCCTL1 register
//
//*************************************************************************************************
#if ADC_VERSION == 0001
#define ADC_CTL1_INTPULSEPOS   0x4U      // ADC Interrupt Pulse Position
#define ADC_CTL1_ADCPWDNZ      0x80U     // ADC Power Down
#define ADC_CTL1_ADCBSYCHN_S   8U
#define ADC_CTL1_ADCBSYCHN_M   0xF00U    // ADC Busy Channel
#define ADC_CTL1_ADCBSY        0x2000U   // ADC Busy

#elif ADC_VERSION == 0002
#define ADC_CTL1_INTPULSEPOS   0x4U      // ADC Interrupt Pulse Position
#define ADC_CTL1_ADCPWDNZ      0x80U     // ADC Power Down
#define ADC_CTL1_ADCBSYCHN_S   8U
#define ADC_CTL1_ADCBSYCHN_M   0x1F00U   // ADC Busy Channel
#define ADC_CTL1_ADCBSY        0x2000U   // ADC Busy

#elif ADC_VERSION == 0003
#define ADC_CTL1_TEMPCONV      0x1U      //todo
#define ADC_CTL1_VREFLOCONV    0x2U      //todo
#define ADC_CTL1_INTPULSEPOS   0x4U      // ADC Interrupt Pulse Position
#define ADC_CTL1_ADCPWDNZ      0x80U     // ADC Power Down
#define ADC_CTL1_ADCBSYCHN_S   8U
#define ADC_CTL1_ADCBSYCHN_M   0x1F00U   // ADC Busy Channel                 Set when an ADC Start of Conversion (SOC) is generated.
#define ADC_CTL1_ADCBSY        0x2000U   // ADC Busy                         determine if ADC is available to sample
#define ADC_CTL1_EXTMUXPRESELECTEN 0x4000U //Configures timing for ADC external mux pins.
#define ADC_CTL1_TDMAEN        0x8000U   //Controls DMA trigger timing with interrupts.
#endif


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCCTL2 register
//
//*************************************************************************************************
#if  ADC_VERSION == 0001
	#define ADC_CTL2_PRESCALE_S   0U
	#define ADC_CTL2_PRESCALE_M   0xFFU   // ADC Clock Prescaler
#elif ADC_VERSION == 0002 || ADC_VERSION == 0003
	#define ADC_CTL2_PRESCALE_S   0U
	#define ADC_CTL2_PRESCALE_M   0xFU   // ADC Clock Prescaler
#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCBURSTCTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_BURSTCTL_BURSTTRIGSEL_S   0U
    #define ADC_BURSTCTL_BURSTTRIGSEL_M   0x3FU     // SOC Burst Trigger Source Select
#elif (ADC_VERSION == 0002) || ADC_VERSION == 0003
	#define ADC_BURSTCTL_BURSTTRIGSEL_S   0U
    #define ADC_BURSTCTL_BURSTTRIGSEL_M   0x7FU     // SOC Burst Trigger Source Select
#endif


#if ADC_VERSION == 0001
	#define ADC_BURSTCTL_BURSTSIZE_S      8U
    #define ADC_BURSTCTL_BURSTSIZE_M      0xF00U    // SOC Burst Size Select
	#define ADC_BURSTCTL_BURSTEN          0x8000U   // SOC Burst Mode Enable
#elif ADC_VERSION == 0002 || ADC_VERSION == 0003
    #define ADC_BURSTCTL_BURSTSIZE_S      8U
	#define ADC_BURSTCTL_BURSTSIZE_M      0x1F00U    // SOC Burst Size Select
	#define ADC_BURSTCTL_BURSTEN          0x8000U   // SOC Burst Mode Enable
#endif 


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCINTFLG register
//
//*************************************************************************************************
#define ADC_INTFLG_ADCINT1   0x1U   // ADC Interrupt 1 Flag
#define ADC_INTFLG_ADCINT2   0x2U   // ADC Interrupt 2 Flag
#define ADC_INTFLG_ADCINT3   0x4U   // ADC Interrupt 3 Flag
#define ADC_INTFLG_ADCINT4   0x8U   // ADC Interrupt 4 Flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCINTFLGCLR register
//
//*************************************************************************************************
#define ADC_INTFLGCLR_ADCINT1   0x1U   // ADC Interrupt 1 Flag Clear
#define ADC_INTFLGCLR_ADCINT2   0x2U   // ADC Interrupt 2 Flag Clear
#define ADC_INTFLGCLR_ADCINT3   0x4U   // ADC Interrupt 3 Flag Clear
#define ADC_INTFLGCLR_ADCINT4   0x8U   // ADC Interrupt 4 Flag Clear

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCINTOVF register
//
//*************************************************************************************************
#define ADC_INTOVF_ADCINT1   0x1U   // ADC Interrupt 1 Overflow Flags
#define ADC_INTOVF_ADCINT2   0x2U   // ADC Interrupt 2 Overflow Flags
#define ADC_INTOVF_ADCINT3   0x4U   // ADC Interrupt 3 Overflow Flags
#define ADC_INTOVF_ADCINT4   0x8U   // ADC Interrupt 4 Overflow Flags

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCINTOVFCLR register
//
//*************************************************************************************************
#define ADC_INTOVFCLR_ADCINT1   0x1U   // ADC Interrupt 1 Overflow Clear Bits
#define ADC_INTOVFCLR_ADCINT2   0x2U   // ADC Interrupt 2 Overflow Clear Bits
#define ADC_INTOVFCLR_ADCINT3   0x4U   // ADC Interrupt 3 Overflow Clear Bits
#define ADC_INTOVFCLR_ADCINT4   0x8U   // ADC Interrupt 4 Overflow Clear Bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCINTSEL1N2 register
//
//*************************************************************************************************

#if (ADC_VERSION == 0001)
#define ADC_INTSEL1N2_INT1SEL_S   0U
#define ADC_INTSEL1N2_INT1SEL_M   0xFU      // ADCINT1 EOC Source Select
#define ADC_INTSEL1N2_INT1E       0x20U     // ADCINT1 Interrupt Enable
#define ADC_INTSEL1N2_INT1CONT    0x40U     // ADCINT1 Continue to Interrupt Mode
#define ADC_INTSEL1N2_INT2SEL_S   8U
#define ADC_INTSEL1N2_INT2SEL_M   0xF00U    // ADCINT2 EOC Source Select
#define ADC_INTSEL1N2_INT2E       0x2000U   // ADCINT2 Interrupt Enable
#define ADC_INTSEL1N2_INT2CONT    0x4000U   // ADCINT2 Continue to Interrupt Mode
#elif (ADC_VERSION == 0002) || ADC_VERSION == 0003
#define ADC_INTSEL1N2_INT1SEL_S   0U
#define ADC_INTSEL1N2_INT1SEL_M   0x1FU      // ADCINT1 EOC Source Select
#define ADC_INTSEL1N2_INT1E       0x20U     // ADCINT1 Interrupt Enable
#define ADC_INTSEL1N2_INT1CONT    0x40U     // ADCINT1 Continue to Interrupt Mode
#define ADC_INTSEL1N2_INT2SEL_S   8U
#define ADC_INTSEL1N2_INT2SEL_M   0x1F00U    // ADCINT2 EOC Source Select
#define ADC_INTSEL1N2_INT2E       0x2000U   // ADCINT2 Interrupt Enable
#define ADC_INTSEL1N2_INT2CONT    0x4000U   // ADCINT2 Continue to Interrupt Mode
#endif


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCINTSEL3N4 register
//
//*************************************************************************************************

#if (ADC_VERSION == 0001)
#define ADC_INTSEL3N4_INT3SEL_S   0U
#define ADC_INTSEL3N4_INT3SEL_M   0xFU      // ADCINT3 EOC Source Select
#define ADC_INTSEL3N4_INT3E       0x20U     // ADCINT3 Interrupt Enable
#define ADC_INTSEL3N4_INT3CONT    0x40U     // ADCINT3 Continue to Interrupt Mode
#define ADC_INTSEL3N4_INT4SEL_S   8U
#define ADC_INTSEL3N4_INT4SEL_M   0xF00U    // ADCINT4 EOC Source Select
#define ADC_INTSEL3N4_INT4E       0x2000U   // ADCINT4 Interrupt Enable
#define ADC_INTSEL3N4_INT4CONT    0x4000U   // ADCINT4 Continue to Interrupt Mode
#elif (ADC_VERSION == 0002) || ADC_VERSION == 0003
#define ADC_INTSEL3N4_INT3SEL_S   0U
#define ADC_INTSEL3N4_INT3SEL_M   0x1FU      // ADCINT3 EOC Source Select
#define ADC_INTSEL3N4_INT3E       0x20U     // ADCINT3 Interrupt Enable
#define ADC_INTSEL3N4_INT3CONT    0x40U     // ADCINT3 Continue to Interrupt Mode
#define ADC_INTSEL3N4_INT4SEL_S   8U
#define ADC_INTSEL3N4_INT4SEL_M   0x1F00U    // ADCINT4 EOC Source Select
#define ADC_INTSEL3N4_INT4E       0x2000U   // ADCINT4 Interrupt Enable
#define ADC_INTSEL3N4_INT4CONT    0x4000U   // ADCINT4 Continue to Interrupt Mode
#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCPRICTL register
//
//*************************************************************************************************
#define ADC_SOCPRICTL_SOCPRIORITY_S   0U
#define ADC_SOCPRICTL_SOCPRIORITY_M   0x1FU    // SOC Priority
#define ADC_SOCPRICTL_RRPOINTER_S     5U
#define ADC_SOCPRICTL_RRPOINTER_M     0x3E0U   // Round Robin Pointer

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCPRICTL2 register
//
//*************************************************************************************************
#define ADC_SOCPRICTL2_SOC_MODE       0x0400U	//enable SOC16-19
#define ADC_SOCPRICTL_SOCPRIORITY2_S  0U 
#define ADC_SOCPRICTL_SOCPRIORITY2_M  0x1FU    // SOC Priority2  default 0x14 = 20h EOC16
#define ADC_SOCPRICTL_RRPOINTER2_S    5U
#define ADC_SOCPRICTL_RRPOINTER2_M    0x3E0U   // Round Robin Pointer

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCINTSOCSEL1 register
//
//*************************************************************************************************
#define ADC_INTSOCSEL1_SOC0_S   0U
#define ADC_INTSOCSEL1_SOC0_M   0x3U      // SOC0 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL1_SOC1_S   2U
#define ADC_INTSOCSEL1_SOC1_M   0xCU      // SOC1 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL1_SOC2_S   4U
#define ADC_INTSOCSEL1_SOC2_M   0x30U     // SOC2 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL1_SOC3_S   6U
#define ADC_INTSOCSEL1_SOC3_M   0xC0U     // SOC3 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL1_SOC4_S   8U
#define ADC_INTSOCSEL1_SOC4_M   0x300U    // SOC4 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL1_SOC5_S   10U
#define ADC_INTSOCSEL1_SOC5_M   0xC00U    // SOC5 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL1_SOC6_S   12U
#define ADC_INTSOCSEL1_SOC6_M   0x3000U   // SOC6 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL1_SOC7_S   14U
#define ADC_INTSOCSEL1_SOC7_M   0xC000U   // SOC7 ADC Interrupt Trigger Select

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCINTSOCSEL2 register
//
//*************************************************************************************************
#define ADC_INTSOCSEL2_SOC8_S    0U
#define ADC_INTSOCSEL2_SOC8_M    0x3U      // SOC8 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL2_SOC9_S    2U
#define ADC_INTSOCSEL2_SOC9_M    0xCU      // SOC9 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL2_SOC10_S   4U
#define ADC_INTSOCSEL2_SOC10_M   0x30U     // SOC10 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL2_SOC11_S   6U
#define ADC_INTSOCSEL2_SOC11_M   0xC0U     // SOC11 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL2_SOC12_S   8U
#define ADC_INTSOCSEL2_SOC12_M   0x300U    // SOC12 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL2_SOC13_S   10U
#define ADC_INTSOCSEL2_SOC13_M   0xC00U    // SOC13 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL2_SOC14_S   12U
#define ADC_INTSOCSEL2_SOC14_M   0x3000U   // SOC14 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL2_SOC15_S   14U
#define ADC_INTSOCSEL2_SOC15_M   0xC000U   // SOC15 ADC Interrupt Trigger Select

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCINTSOCSEL3 register
//
//*************************************************************************************************
#define ADC_INTSOCSEL3_SOC16_S    0U
#define ADC_INTSOCSEL3_SOC16_M    0x3U      // SOC16 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL3_SOC17_S    2U
#define ADC_INTSOCSEL3_SOC17_M    0xCU      // SOC17 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL3_SOC18_S   4U
#define ADC_INTSOCSEL3_SOC18_M   0x30U     // SOC18 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL3_SOC19_S   6U
#define ADC_INTSOCSEL3_SOC19_M   0xC0U     // SOC19 ADC Interrupt Trigger Select
#define ADC_INTSOCSEL3_SOC20_S   8U                                                                     //3.0NEW
#define ADC_INTSOCSEL3_SOC20_M   0x300U    // SOC20 ADC Interrupt Trigger Select

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCFLG1 register
//
//*************************************************************************************************
#define ADC_SOCFLG1_SOC0    0x1U      // SOC0 Start of Conversion Flag
#define ADC_SOCFLG1_SOC1    0x2U      // SOC1 Start of Conversion Flag
#define ADC_SOCFLG1_SOC2    0x4U      // SOC2 Start of Conversion Flag
#define ADC_SOCFLG1_SOC3    0x8U      // SOC3 Start of Conversion Flag
#define ADC_SOCFLG1_SOC4    0x10U     // SOC4 Start of Conversion Flag
#define ADC_SOCFLG1_SOC5    0x20U     // SOC5 Start of Conversion Flag
#define ADC_SOCFLG1_SOC6    0x40U     // SOC6 Start of Conversion Flag
#define ADC_SOCFLG1_SOC7    0x80U     // SOC7 Start of Conversion Flag
#define ADC_SOCFLG1_SOC8    0x100U    // SOC8 Start of Conversion Flag
#define ADC_SOCFLG1_SOC9    0x200U    // SOC9 Start of Conversion Flag
#define ADC_SOCFLG1_SOC10   0x400U    // SOC10 Start of Conversion Flag
#define ADC_SOCFLG1_SOC11   0x800U    // SOC11 Start of Conversion Flag
#define ADC_SOCFLG1_SOC12   0x1000U   // SOC12 Start of Conversion Flag
#define ADC_SOCFLG1_SOC13   0x2000U   // SOC13 Start of Conversion Flag
#define ADC_SOCFLG1_SOC14   0x4000U   // SOC14 Start of Conversion Flag
#define ADC_SOCFLG1_SOC15   0x8000U   // SOC15 Start of Conversion Flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCFLG2 register
//
//*************************************************************************************************
#define ADC_SOCFLG2_SOC16    0x1U      // SOC16 Start of Conversion Flag
#define ADC_SOCFLG2_SOC17    0x2U      // SOC17 Start of Conversion Flag
#define ADC_SOCFLG2_SOC18    0x4U      // SOC18 Start of Conversion Flag
#define ADC_SOCFLG2_SOC19    0x8U      // SOC19 Start of Conversion Flag
#define ADC_SOCFLG2_SOC20    0x10U     // SOC20 Start of Conversion Flag                   //3.0NEW

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCFRC1 register
//
//*************************************************************************************************
#define ADC_SOCFRC1_SOC0    0x1U      // SOC0 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC1    0x2U      // SOC1 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC2    0x4U      // SOC2 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC3    0x8U      // SOC3 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC4    0x10U     // SOC4 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC5    0x20U     // SOC5 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC6    0x40U     // SOC6 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC7    0x80U     // SOC7 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC8    0x100U    // SOC8 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC9    0x200U    // SOC9 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC10   0x400U    // SOC10 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC11   0x800U    // SOC11 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC12   0x1000U   // SOC12 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC13   0x2000U   // SOC13 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC14   0x4000U   // SOC14 Force Start of Conversion Bit
#define ADC_SOCFRC1_SOC15   0x8000U   // SOC15 Force Start of Conversion Bit


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCFRC2 register
//
//*************************************************************************************************
#define ADC_SOCFRC2_SOC16    0x1U      // SOC16 Force Start of Conversion Bit
#define ADC_SOCFRC2_SOC17    0x2U      // SOC17 Force Start of Conversion Bit
#define ADC_SOCFRC2_SOC18    0x4U      // SOC18 Force Start of Conversion Bit
#define ADC_SOCFRC2_SOC19    0x8U      // SOC19 Force Start of Conversion Bit
#define ADC_SOCFRC2_SOC20    0x10U     // SOC20 Force Start of Conversion Bit

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCOVF1 register
//
//*************************************************************************************************
#define ADC_SOCOVF1_SOC0    0x1U      // SOC0 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC1    0x2U      // SOC1 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC2    0x4U      // SOC2 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC3    0x8U      // SOC3 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC4    0x10U     // SOC4 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC5    0x20U     // SOC5 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC6    0x40U     // SOC6 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC7    0x80U     // SOC7 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC8    0x100U    // SOC8 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC9    0x200U    // SOC9 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC10   0x400U    // SOC10 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC11   0x800U    // SOC11 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC12   0x1000U   // SOC12 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC13   0x2000U   // SOC13 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC14   0x4000U   // SOC14 Start of Conversion Overflow Flag
#define ADC_SOCOVF1_SOC15   0x8000U   // SOC15 Start of Conversion Overflow Flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCOVF2 register
//
//*************************************************************************************************
#define ADC_SOCOVF2_SOC16    0x1U      // SOC16 Start of Conversion Overflow Flag
#define ADC_SOCOVF2_SOC17    0x2U      // SOC17 Start of Conversion Overflow Flag
#define ADC_SOCOVF2_SOC18    0x4U      // SOC18 Start of Conversion Overflow Flag
#define ADC_SOCOVF2_SOC19    0x8U      // SOC19 Start of Conversion Overflow Flag
#define ADC_SOCOVF2_SOC20    0x10U     // SOC20 Start of Conversion Overflow Flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCOVFCLR1 register
//
//*************************************************************************************************
#define ADC_SOCOVFCLR1_SOC0    0x1U      // SOC0 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC1    0x2U      // SOC1 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC2    0x4U      // SOC2 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC3    0x8U      // SOC3 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC4    0x10U     // SOC4 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC5    0x20U     // SOC5 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC6    0x40U     // SOC6 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC7    0x80U     // SOC7 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC8    0x100U    // SOC8 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC9    0x200U    // SOC9 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC10   0x400U    // SOC10 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC11   0x800U    // SOC11 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC12   0x1000U   // SOC12 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC13   0x2000U   // SOC13 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC14   0x4000U   // SOC14 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR1_SOC15   0x8000U   // SOC15 Clear Start of Conversion Overflow Bit


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOCOVFCLR2 register
//
//*************************************************************************************************
#define ADC_SOCOVFCLR2_SOC16    0x1U      // SOC16 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR2_SOC17    0x2U      // SOC17 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR2_SOC18    0x4U      // SOC18 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR2_SOC19    0x8U      // SOC19 Clear Start of Conversion Overflow Bit
#define ADC_SOCOVFCLR2_SOC20    0x10U     // SOC20 Clear Start of Conversion Overflow Bit

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC0CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC0CTL_ACQPS_S     0U
	#define ADC_SOC0CTL_ACQPS_M     0x1FFU       // SOC0 Acquisition Prescale
	#define ADC_SOC0CTL_CHSEL_S     15U
	#define ADC_SOC0CTL_CHSEL_M     0x78000U     // SOC0 Channel Select
	#define ADC_SOC0CTL_TRIGSEL_S   20U
    #define ADC_SOC0CTL_TRIGSEL_M   0x1F00000U   // SOC0 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC0CTL_ACQPS_S     0U
	#define ADC_SOC0CTL_ACQPS_M     0x1FFU       // SOC0 Acquisition Prescale
	#define ADC_SOC0CTL_CHSEL_S     15U
	#define ADC_SOC0CTL_CHSEL_M     0x78000U     // SOC0 Channel Select
	#define ADC_SOC0CTL_TRIGSEL_S   20U
    #define ADC_SOC0CTL_TRIGSEL_M   0x7F00000U   // SOC0 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC0CTL_ACQPS_S     0U
	#define ADC_SOC0CTL_ACQPS_M     0x1FFU       // SOC0 Acquisition Prescale
	#define ADC_SOC0CTL_RST_DIS_M	0x00000200U	 // SOC0 Reset diable
	#define ADC_SOC0CTL_CHSEL_S     15U
	#define ADC_SOC0CTL_CHSEL_M     0x78000U     // SOC0 Channel Select
	#define ADC_SOC0CTL_TRIGSEL_S   20U
    #define ADC_SOC0CTL_TRIGSEL_M   0x7F00000U   // SOC0 Trigger Source Select
    #define ADC_SOC0CTL_EXTCHSEL_S  28U
    #define ADC_SOC0CTL_EXTCHSEL_M  0xF000000U   // SOC0 External Channel Mux Select
#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC1CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC1CTL_ACQPS_S     0U
	#define ADC_SOC1CTL_ACQPS_M     0x1FFU       // SOC1 Acquisition Prescale
	#define ADC_SOC1CTL_CHSEL_S     15U
	#define ADC_SOC1CTL_CHSEL_M     0x78000U     // SOC1 Channel Select
	#define ADC_SOC1CTL_TRIGSEL_S   20U
    #define ADC_SOC1CTL_TRIGSEL_M   0x1F00000U   // SOC1 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC1CTL_ACQPS_S     0U
	#define ADC_SOC1CTL_ACQPS_M     0x1FFU       // SOC1 Acquisition Prescale
	#define ADC_SOC1CTL_CHSEL_S     15U
	#define ADC_SOC1CTL_CHSEL_M     0x78000U     // SOC1 Channel Select
	#define ADC_SOC1CTL_TRIGSEL_S   20U
    #define ADC_SOC1CTL_TRIGSEL_M   0x7F00000U   // SOC1 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC1CTL_ACQPS_S     0U
	#define ADC_SOC1CTL_ACQPS_M     0x1FFU       // SOC1 Acquisition Prescale
	#define ADC_SOC1CTL_CHSEL_S     15U
	#define ADC_SOC1CTL_CHSEL_M     0x78000U     // SOC1 Channel Select
	#define ADC_SOC1CTL_TRIGSEL_S   20U
    #define ADC_SOC1CTL_TRIGSEL_M   0x7F00000U   // SOC1 Trigger Source Select
    #define ADC_SOC1CTL_EXTCHSEL_S  28U
    #define ADC_SOC1CTL_EXTCHSEL_M  0xF000000U   // SOC1 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC2CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC2CTL_ACQPS_S     0U
	#define ADC_SOC2CTL_ACQPS_M     0x1FFU       // SOC2 Acquisition Prescale
	#define ADC_SOC2CTL_CHSEL_S     15U
	#define ADC_SOC2CTL_CHSEL_M     0x78000U     // SOC2 Channel Select
	#define ADC_SOC2CTL_TRIGSEL_S   20U
    #define ADC_SOC2CTL_TRIGSEL_M   0x1F00000U   // SOC2 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC2CTL_ACQPS_S     0U
	#define ADC_SOC2CTL_ACQPS_M     0x1FFU       // SOC2 Acquisition Prescale
	#define ADC_SOC2CTL_CHSEL_S     15U
	#define ADC_SOC2CTL_CHSEL_M     0x78000U     // SOC2 Channel Select
	#define ADC_SOC2CTL_TRIGSEL_S   20U
    #define ADC_SOC2CTL_TRIGSEL_M   0x7F00000U   // SOC2 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC2CTL_ACQPS_S     0U
	#define ADC_SOC2CTL_ACQPS_M     0x1FFU       // SOC2 Acquisition Prescale
	#define ADC_SOC2CTL_CHSEL_S     15U
	#define ADC_SOC2CTL_CHSEL_M     0x78000U     // SOC2 Channel Select
	#define ADC_SOC2CTL_TRIGSEL_S   20U
    #define ADC_SOC2CTL_TRIGSEL_M   0x7F00000U   // SOC2 Trigger Source Select
    #define ADC_SOC2CTL_EXTCHSEL_S  28U
    #define ADC_SOC2CTL_EXTCHSEL_M  0xF000000U   // SOC2 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC3CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC3CTL_ACQPS_S     0U
	#define ADC_SOC3CTL_ACQPS_M     0x1FFU       // SOC3 Acquisition Prescale
	#define ADC_SOC3CTL_CHSEL_S     15U
	#define ADC_SOC3CTL_CHSEL_M     0x78000U     // SOC3 Channel Select
	#define ADC_SOC3CTL_TRIGSEL_S   20U
    #define ADC_SOC3CTL_TRIGSEL_M   0x1F00000U   // SOC3 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC3CTL_ACQPS_S     0U
	#define ADC_SOC3CTL_ACQPS_M     0x1FFU       // SOC3 Acquisition Prescale
	#define ADC_SOC3CTL_CHSEL_S     15U
	#define ADC_SOC3CTL_CHSEL_M     0x78000U     // SOC3 Channel Select
	#define ADC_SOC3CTL_TRIGSEL_S   20U
    #define ADC_SOC3CTL_TRIGSEL_M   0x7F00000U   // SOC3 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC3CTL_ACQPS_S     0U
	#define ADC_SOC3CTL_ACQPS_M     0x1FFU       // SOC3 Acquisition Prescale
	#define ADC_SOC3CTL_CHSEL_S     15U
	#define ADC_SOC3CTL_CHSEL_M     0x78000U     // SOC3 Channel Select
	#define ADC_SOC3CTL_TRIGSEL_S   20U
    #define ADC_SOC3CTL_TRIGSEL_M   0x7F00000U   // SOC3 Trigger Source Select
    #define ADC_SOC3CTL_EXTCHSEL_S  28U
    #define ADC_SOC3CTL_EXTCHSEL_M  0xF000000U   // SOC3 External Channel Mux Select
#endif

//********************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC4CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC4CTL_ACQPS_S     0U
	#define ADC_SOC4CTL_ACQPS_M     0x1FFU       // SOC4 Acquisition Prescale
	#define ADC_SOC4CTL_CHSEL_S     15U
	#define ADC_SOC4CTL_CHSEL_M     0x78000U     // SOC4 Channel Select
	#define ADC_SOC4CTL_TRIGSEL_S   20U
    #define ADC_SOC4CTL_TRIGSEL_M   0x1F00000U   // SOC4 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC4CTL_ACQPS_S     0U
	#define ADC_SOC4CTL_ACQPS_M     0x1FFU       // SOC4 Acquisition Prescale
	#define ADC_SOC4CTL_CHSEL_S     15U
	#define ADC_SOC4CTL_CHSEL_M     0x78000U     // SOC4 Channel Select
	#define ADC_SOC4CTL_TRIGSEL_S   20U
    #define ADC_SOC4CTL_TRIGSEL_M   0x7F00000U   // SOC4 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC4CTL_ACQPS_S     0U
	#define ADC_SOC4CTL_ACQPS_M     0x1FFU       // SOC4 Acquisition Prescale
	#define ADC_SOC4CTL_CHSEL_S     15U
	#define ADC_SOC4CTL_CHSEL_M     0x78000U     // SOC4 Channel Select
	#define ADC_SOC4CTL_TRIGSEL_S   20U
    #define ADC_SOC4CTL_TRIGSEL_M   0x7F00000U   // SOC4 Trigger Source Select
    #define ADC_SOC4CTL_EXTCHSEL_S  28U
    #define ADC_SOC4CTL_EXTCHSEL_M  0xF000000U   // SOC4 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC5CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC5CTL_ACQPS_S     0U
	#define ADC_SOC5CTL_ACQPS_M     0x1FFU       // SOC5 Acquisition Prescale
	#define ADC_SOC5CTL_CHSEL_S     15U
	#define ADC_SOC5CTL_CHSEL_M     0x78000U     // SOC5 Channel Select
	#define ADC_SOC5CTL_TRIGSEL_S   20U
    #define ADC_SOC5CTL_TRIGSEL_M   0x1F00000U   // SOC5 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC5CTL_ACQPS_S     0U
	#define ADC_SOC5CTL_ACQPS_M     0x1FFU       // SOC5 Acquisition Prescale
	#define ADC_SOC5CTL_CHSEL_S     15U
	#define ADC_SOC5CTL_CHSEL_M     0x78000U     // SOC5 Channel Select
	#define ADC_SOC5CTL_TRIGSEL_S   20U
    #define ADC_SOC5CTL_TRIGSEL_M   0x7F00000U   // SOC5 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC5CTL_ACQPS_S     0U
	#define ADC_SOC5CTL_ACQPS_M     0x1FFU       // SOC5 Acquisition Prescale
	#define ADC_SOC5CTL_CHSEL_S     15U
	#define ADC_SOC5CTL_CHSEL_M     0x78000U     // SOC5 Channel Select
	#define ADC_SOC5CTL_TRIGSEL_S   20U
    #define ADC_SOC5CTL_TRIGSEL_M   0x7F00000U   // SOC5 Trigger Source Select
    #define ADC_SOC5CTL_EXTCHSEL_S  28U
    #define ADC_SOC5CTL_EXTCHSEL_M  0xF000000U   // SOC5 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC6CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC6CTL_ACQPS_S     0U
	#define ADC_SOC6CTL_ACQPS_M     0x1FFU       // SOC6 Acquisition Prescale
	#define ADC_SOC6CTL_CHSEL_S     15U
	#define ADC_SOC6CTL_CHSEL_M     0x78000U     // SOC6 Channel Select
	#define ADC_SOC6CTL_TRIGSEL_S   20U
    #define ADC_SOC6CTL_TRIGSEL_M   0x1F00000U   // SOC6 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC6CTL_ACQPS_S     0U
	#define ADC_SOC6CTL_ACQPS_M     0x1FFU       // SOC6 Acquisition Prescale
	#define ADC_SOC6CTL_CHSEL_S     15U
	#define ADC_SOC6CTL_CHSEL_M     0x78000U     // SOC6 Channel Select
	#define ADC_SOC6CTL_TRIGSEL_S   20U
    #define ADC_SOC6CTL_TRIGSEL_M   0x7F00000U   // SOC6 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC6CTL_ACQPS_S     0U
	#define ADC_SOC6CTL_ACQPS_M     0x1FFU       // SOC6 Acquisition Prescale
	#define ADC_SOC6CTL_CHSEL_S     15U
	#define ADC_SOC6CTL_CHSEL_M     0x78000U     // SOC6 Channel Select
	#define ADC_SOC6CTL_TRIGSEL_S   20U
    #define ADC_SOC6CTL_TRIGSEL_M   0x7F00000U   // SOC6 Trigger Source Select
    #define ADC_SOC6CTL_EXTCHSEL_S  28U
    #define ADC_SOC6CTL_EXTCHSEL_M  0xF000000U   // SOC6 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC7CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC7CTL_ACQPS_S     0U
	#define ADC_SOC7CTL_ACQPS_M     0x1FFU       // SOC7 Acquisition Prescale
	#define ADC_SOC7CTL_CHSEL_S     15U
	#define ADC_SOC7CTL_CHSEL_M     0x78000U     // SOC7 Channel Select
	#define ADC_SOC7CTL_TRIGSEL_S   20U
    #define ADC_SOC7CTL_TRIGSEL_M   0x1F00000U   // SOC7 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC7CTL_ACQPS_S     0U
	#define ADC_SOC7CTL_ACQPS_M     0x1FFU       // SOC7 Acquisition Prescale
	#define ADC_SOC7CTL_CHSEL_S     15U
	#define ADC_SOC7CTL_CHSEL_M     0x78000U     // SOC7 Channel Select
	#define ADC_SOC7CTL_TRIGSEL_S   20U
    #define ADC_SOC7CTL_TRIGSEL_M   0x7F00000U   // SOC7 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC7CTL_ACQPS_S     0U
	#define ADC_SOC7CTL_ACQPS_M     0x1FFU       // SOC7 Acquisition Prescale
	#define ADC_SOC7CTL_CHSEL_S     15U
	#define ADC_SOC7CTL_CHSEL_M     0x78000U     // SOC7 Channel Select
	#define ADC_SOC7CTL_TRIGSEL_S   20U
    #define ADC_SOC7CTL_TRIGSEL_M   0x7F00000U   // SOC7 Trigger Source Select
    #define ADC_SOC7CTL_EXTCHSEL_S  28U
    #define ADC_SOC7CTL_EXTCHSEL_M  0xF000000U   // SOC7 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC8CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC8CTL_ACQPS_S     0U
	#define ADC_SOC8CTL_ACQPS_M     0x1FFU       // SOC8 Acquisition Prescale
	#define ADC_SOC8CTL_CHSEL_S     15U
	#define ADC_SOC8CTL_CHSEL_M     0x78000U     // SOC8 Channel Select
	#define ADC_SOC8CTL_TRIGSEL_S   20U
    #define ADC_SOC8CTL_TRIGSEL_M   0x1F00000U   // SOC8 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC8CTL_ACQPS_S     0U
	#define ADC_SOC8CTL_ACQPS_M     0x1FFU       // SOC8 Acquisition Prescale
	#define ADC_SOC8CTL_CHSEL_S     15U
	#define ADC_SOC8CTL_CHSEL_M     0x78000U     // SOC8 Channel Select
	#define ADC_SOC8CTL_TRIGSEL_S   20U
    #define ADC_SOC8CTL_TRIGSEL_M   0x7F00000U   // SOC8 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC8CTL_ACQPS_S     0U
	#define ADC_SOC8CTL_ACQPS_M     0x1FFU       // SOC8 Acquisition Prescale
	#define ADC_SOC8CTL_CHSEL_S     15U
	#define ADC_SOC8CTL_CHSEL_M     0x78000U     // SOC8 Channel Select
	#define ADC_SOC8CTL_TRIGSEL_S   20U
    #define ADC_SOC8CTL_TRIGSEL_M   0x7F00000U   // SOC8 Trigger Source Select
    #define ADC_SOC8CTL_EXTCHSEL_S  28U
    #define ADC_SOC8CTL_EXTCHSEL_M  0xF000000U   // SOC8 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC9CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC9CTL_ACQPS_S     0U
	#define ADC_SOC9CTL_ACQPS_M     0x1FFU       // SOC9 Acquisition Prescale
	#define ADC_SOC9CTL_CHSEL_S     15U
	#define ADC_SOC9CTL_CHSEL_M     0x78000U     // SOC9 Channel Select
	#define ADC_SOC9CTL_TRIGSEL_S   20U
    #define ADC_SOC9CTL_TRIGSEL_M   0x1F00000U   // SOC9 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC9CTL_ACQPS_S     0U
	#define ADC_SOC9CTL_ACQPS_M     0x1FFU       // SOC9 Acquisition Prescale
	#define ADC_SOC9CTL_CHSEL_S     15U
	#define ADC_SOC9CTL_CHSEL_M     0x78000U     // SOC9 Channel Select
	#define ADC_SOC9CTL_TRIGSEL_S   20U
    #define ADC_SOC9CTL_TRIGSEL_M   0x7F00000U   // SOC9 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC9CTL_ACQPS_S     0U
	#define ADC_SOC9CTL_ACQPS_M     0x1FFU       // SOC9 Acquisition Prescale
	#define ADC_SOC9CTL_CHSEL_S     15U
	#define ADC_SOC9CTL_CHSEL_M     0x78000U     // SOC9 Channel Select
	#define ADC_SOC9CTL_TRIGSEL_S   20U
    #define ADC_SOC9CTL_TRIGSEL_M   0x7F00000U   // SOC9 Trigger Source Select
    #define ADC_SOC9CTL_EXTCHSEL_S  28U
    #define ADC_SOC9CTL_EXTCHSEL_M  0xF000000U   // SOC9 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC10CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC10CTL_ACQPS_S     0U
	#define ADC_SOC10CTL_ACQPS_M     0x1FFU       // SOC10 Acquisition Prescale
	#define ADC_SOC10CTL_CHSEL_S     15U
	#define ADC_SOC10CTL_CHSEL_M     0x78000U     // SOC10 Channel Select
	#define ADC_SOC10CTL_TRIGSEL_S   20U
    #define ADC_SOC10CTL_TRIGSEL_M   0x1F00000U   // SOC10 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC10CTL_ACQPS_S     0U
	#define ADC_SOC10CTL_ACQPS_M     0x1FFU       // SOC10 Acquisition Prescale
	#define ADC_SOC10CTL_CHSEL_S     15U
	#define ADC_SOC10CTL_CHSEL_M     0x78000U     // SOC10 Channel Select
	#define ADC_SOC10CTL_TRIGSEL_S   20U
    #define ADC_SOC10CTL_TRIGSEL_M   0x7F00000U   // SOC10 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC10CTL_ACQPS_S     0U
	#define ADC_SOC10CTL_ACQPS_M     0x1FFU       // SOC10 Acquisition Prescale
	#define ADC_SOC10CTL_CHSEL_S     15U
	#define ADC_SOC10CTL_CHSEL_M     0x78000U     // SOC10 Channel Select
	#define ADC_SOC10CTL_TRIGSEL_S   20U
    #define ADC_SOC10CTL_TRIGSEL_M   0x7F00000U   // SOC10 Trigger Source Select
    #define ADC_SOC10CTL_EXTCHSEL_S  28U
    #define ADC_SOC10CTL_EXTCHSEL_M  0xF000000U   // SOC10 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC11CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC11CTL_ACQPS_S     0U
	#define ADC_SOC11CTL_ACQPS_M     0x1FFU       // SOC11 Acquisition Prescale
	#define ADC_SOC11CTL_CHSEL_S     15U
	#define ADC_SOC11CTL_CHSEL_M     0x78000U     // SOC11 Channel Select
	#define ADC_SOC11CTL_TRIGSEL_S   20U
    #define ADC_SOC11CTL_TRIGSEL_M   0x1F00000U   // SOC11 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC11CTL_ACQPS_S     0U
	#define ADC_SOC11CTL_ACQPS_M     0x1FFU       // SOC11 Acquisition Prescale
	#define ADC_SOC11CTL_CHSEL_S     15U
	#define ADC_SOC11CTL_CHSEL_M     0x78000U     // SOC11 Channel Select
	#define ADC_SOC11CTL_TRIGSEL_S   20U
    #define ADC_SOC11CTL_TRIGSEL_M   0x7F00000U   // SOC11 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC11CTL_ACQPS_S     0U
	#define ADC_SOC11CTL_ACQPS_M     0x1FFU       // SOC11 Acquisition Prescale
	#define ADC_SOC11CTL_CHSEL_S     15U
	#define ADC_SOC11CTL_CHSEL_M     0x78000U     // SOC11 Channel Select
	#define ADC_SOC11CTL_TRIGSEL_S   20U
    #define ADC_SOC11CTL_TRIGSEL_M   0x7F00000U   // SOC11 Trigger Source Select
    #define ADC_SOC11CTL_EXTCHSEL_S  28U
    #define ADC_SOC11CTL_EXTCHSEL_M  0xF000000U   // SOC11 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC12CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC12CTL_ACQPS_S     0U
	#define ADC_SOC12CTL_ACQPS_M     0x1FFU       // SOC12 Acquisition Prescale
	#define ADC_SOC12CTL_CHSEL_S     15U
	#define ADC_SOC12CTL_CHSEL_M     0x78000U     // SOC12 Channel Select
	#define ADC_SOC12CTL_TRIGSEL_S   20U
    #define ADC_SOC12CTL_TRIGSEL_M   0x1F00000U   // SOC12 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC12CTL_ACQPS_S     0U
	#define ADC_SOC12CTL_ACQPS_M     0x1FFU       // SOC12 Acquisition Prescale
	#define ADC_SOC12CTL_CHSEL_S     15U
	#define ADC_SOC12CTL_CHSEL_M     0x78000U     // SOC12 Channel Select
	#define ADC_SOC12CTL_TRIGSEL_S   20U
    #define ADC_SOC12CTL_TRIGSEL_M   0x7F00000U   // SOC12 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC12CTL_ACQPS_S     0U
	#define ADC_SOC12CTL_ACQPS_M     0x1FFU       // SOC12 Acquisition Prescale
	#define ADC_SOC12CTL_CHSEL_S     15U
	#define ADC_SOC12CTL_CHSEL_M     0x78000U     // SOC12 Channel Select
	#define ADC_SOC12CTL_TRIGSEL_S   20U
    #define ADC_SOC12CTL_TRIGSEL_M   0x7F00000U   // SOC12 Trigger Source Select
    #define ADC_SOC12CTL_EXTCHSEL_S  28U
    #define ADC_SOC12CTL_EXTCHSEL_M  0xF000000U   // SOC12 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC13CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC13CTL_ACQPS_S     0U
	#define ADC_SOC13CTL_ACQPS_M     0x1FFU       // SOC13 Acquisition Prescale
	#define ADC_SOC13CTL_CHSEL_S     15U
	#define ADC_SOC13CTL_CHSEL_M     0x78000U     // SOC13 Channel Select
	#define ADC_SOC13CTL_TRIGSEL_S   20U
    #define ADC_SOC13CTL_TRIGSEL_M   0x1F00000U   // SOC13 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC13CTL_ACQPS_S     0U
	#define ADC_SOC13CTL_ACQPS_M     0x1FFU       // SOC13 Acquisition Prescale
	#define ADC_SOC13CTL_CHSEL_S     15U
	#define ADC_SOC13CTL_CHSEL_M     0x78000U     // SOC13 Channel Select
	#define ADC_SOC13CTL_TRIGSEL_S   20U
    #define ADC_SOC13CTL_TRIGSEL_M   0x7F00000U   // SOC13 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC13CTL_ACQPS_S     0U
	#define ADC_SOC13CTL_ACQPS_M     0x1FFU       // SOC13 Acquisition Prescale
	#define ADC_SOC13CTL_CHSEL_S     15U
	#define ADC_SOC13CTL_CHSEL_M     0x78000U     // SOC13 Channel Select
	#define ADC_SOC13CTL_TRIGSEL_S   20U
    #define ADC_SOC13CTL_TRIGSEL_M   0x7F00000U   // SOC13 Trigger Source Select
    #define ADC_SOC13CTL_EXTCHSEL_S  28U
    #define ADC_SOC13CTL_EXTCHSEL_M  0xF000000U   // SOC13 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC14CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC14CTL_ACQPS_S     0U
	#define ADC_SOC14CTL_ACQPS_M     0x1FFU       // SOC14 Acquisition Prescale
	#define ADC_SOC14CTL_CHSEL_S     15U
	#define ADC_SOC14CTL_CHSEL_M     0x78000U     // SOC14 Channel Select
	#define ADC_SOC14CTL_TRIGSEL_S   20U
    #define ADC_SOC14CTL_TRIGSEL_M   0x1F00000U   // SOC14 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC14CTL_ACQPS_S     0U
	#define ADC_SOC14CTL_ACQPS_M     0x1FFU       // SOC14 Acquisition Prescale
	#define ADC_SOC14CTL_CHSEL_S     15U
	#define ADC_SOC14CTL_CHSEL_M     0x78000U     // SOC14 Channel Select
	#define ADC_SOC14CTL_TRIGSEL_S   20U
    #define ADC_SOC14CTL_TRIGSEL_M   0x7F00000U   // SOC14 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC14CTL_ACQPS_S     0U
	#define ADC_SOC14CTL_ACQPS_M     0x1FFU       // SOC14 Acquisition Prescale
	#define ADC_SOC14CTL_CHSEL_S     15U
	#define ADC_SOC14CTL_CHSEL_M     0x78000U     // SOC14 Channel Select
	#define ADC_SOC14CTL_TRIGSEL_S   20U
    #define ADC_SOC14CTL_TRIGSEL_M   0x7F00000U   // SOC14 Trigger Source Select
    #define ADC_SOC14CTL_EXTCHSEL_S  28U
    #define ADC_SOC14CTL_EXTCHSEL_M  0xF000000U   // SOC14 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC15CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC15CTL_ACQPS_S     0U
	#define ADC_SOC15CTL_ACQPS_M     0x1FFU       // SOC15 Acquisition Prescale
	#define ADC_SOC15CTL_CHSEL_S     15U
	#define ADC_SOC15CTL_CHSEL_M     0x78000U     // SOC15 Channel Select
	#define ADC_SOC15CTL_TRIGSEL_S   20U
    #define ADC_SOC15CTL_TRIGSEL_M   0x1F00000U   // SOC15 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC15CTL_ACQPS_S     0U
	#define ADC_SOC15CTL_ACQPS_M     0x1FFU       // SOC15 Acquisition Prescale
	#define ADC_SOC15CTL_CHSEL_S     15U
	#define ADC_SOC15CTL_CHSEL_M     0x78000U     // SOC15 Channel Select
	#define ADC_SOC15CTL_TRIGSEL_S   20U
    #define ADC_SOC15CTL_TRIGSEL_M   0x7F00000U   // SOC15 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC15CTL_ACQPS_S     0U
	#define ADC_SOC15CTL_ACQPS_M     0x1FFU       // SOC15 Acquisition Prescale
	#define ADC_SOC15CTL_CHSEL_S     15U
	#define ADC_SOC15CTL_CHSEL_M     0x78000U     // SOC15 Channel Select
	#define ADC_SOC15CTL_TRIGSEL_S   20U
    #define ADC_SOC15CTL_TRIGSEL_M   0x7F00000U   // SOC15 Trigger Source Select
    #define ADC_SOC15CTL_EXTCHSEL_S  28U
    #define ADC_SOC15CTL_EXTCHSEL_M  0xF000000U   // SOC15 External Channel Mux Select
#endif


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC16CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC16CTL_ACQPS_S     0U
	#define ADC_SOC16CTL_ACQPS_M     0x1FFU       // SOC16 Acquisition Prescale
	#define ADC_SOC16CTL_CHSEL_S     15U
	#define ADC_SOC16CTL_CHSEL_M     0x78000U     // SOC16 Channel Select
	#define ADC_SOC16CTL_TRIGSEL_S   20U
    #define ADC_SOC16CTL_TRIGSEL_M   0x1F00000U   // SOC16 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC16CTL_ACQPS_S     0U
	#define ADC_SOC16CTL_ACQPS_M     0x1FFU       // SOC16 Acquisition Prescale
	#define ADC_SOC16CTL_CHSEL_S     15U
	#define ADC_SOC16CTL_CHSEL_M     0x78000U     // SOC16 Channel Select
	#define ADC_SOC16CTL_TRIGSEL_S   20U
    #define ADC_SOC16CTL_TRIGSEL_M   0x7F00000U   // SOC16 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC16CTL_ACQPS_S     0U
	#define ADC_SOC16CTL_ACQPS_M     0x1FFU       // SOC16 Acquisition Prescale
	#define ADC_SOC16CTL_CHSEL_S     15U
	#define ADC_SOC16CTL_CHSEL_M     0x78000U     // SOC16 Channel Select
	#define ADC_SOC16CTL_TRIGSEL_S   20U
    #define ADC_SOC16CTL_TRIGSEL_M   0x7F00000U   // SOC16 Trigger Source Select
    #define ADC_SOC16CTL_EXTCHSEL_S  28U
    #define ADC_SOC16CTL_EXTCHSEL_M  0xF000000U   // SOC16 External Channel Mux Select
#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC17CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC17CTL_ACQPS_S     0U
	#define ADC_SOC17CTL_ACQPS_M     0x1FFU       // SOC17 Acquisition Prescale
	#define ADC_SOC17CTL_CHSEL_S     15U
	#define ADC_SOC17CTL_CHSEL_M     0x78000U     // SOC17 Channel Select
	#define ADC_SOC17CTL_TRIGSEL_S   20U
    #define ADC_SOC17CTL_TRIGSEL_M   0x1F00000U   // SOC17 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC17CTL_ACQPS_S     0U
	#define ADC_SOC17CTL_ACQPS_M     0x1FFU       // SOC17 Acquisition Prescale
	#define ADC_SOC17CTL_CHSEL_S     15U
	#define ADC_SOC17CTL_CHSEL_M     0x78000U     // SOC17 Channel Select
	#define ADC_SOC17CTL_TRIGSEL_S   20U
    #define ADC_SOC17CTL_TRIGSEL_M   0x7F00000U   // SOC17 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC17CTL_ACQPS_S     0U
	#define ADC_SOC17CTL_ACQPS_M     0x1FFU       // SOC17 Acquisition Prescale
	#define ADC_SOC17CTL_CHSEL_S     15U
	#define ADC_SOC17CTL_CHSEL_M     0x78000U     // SOC17 Channel Select
	#define ADC_SOC17CTL_TRIGSEL_S   20U
    #define ADC_SOC17CTL_TRIGSEL_M   0x7F00000U   // SOC17 Trigger Source Select
    #define ADC_SOC17CTL_EXTCHSEL_S  28U
    #define ADC_SOC17CTL_EXTCHSEL_M  0xF000000U   // SOC17 External Channel Mux Select
#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC18CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC18CTL_ACQPS_S     0U
	#define ADC_SOC18CTL_ACQPS_M     0x1FFU       // SOC18 Acquisition Prescale
	#define ADC_SOC18CTL_CHSEL_S     15U
	#define ADC_SOC18CTL_CHSEL_M     0x78000U     // SOC18 Channel Select
	#define ADC_SOC18CTL_TRIGSEL_S   20U
    #define ADC_SOC18CTL_TRIGSEL_M   0x1F00000U   // SOC18 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC18CTL_ACQPS_S     0U
	#define ADC_SOC18CTL_ACQPS_M     0x1FFU       // SOC18 Acquisition Prescale
	#define ADC_SOC18CTL_CHSEL_S     15U
	#define ADC_SOC18CTL_CHSEL_M     0x78000U     // SOC18 Channel Select
	#define ADC_SOC18CTL_TRIGSEL_S   20U
    #define ADC_SOC18CTL_TRIGSEL_M   0x7F00000U   // SOC18 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC18CTL_ACQPS_S     0U
	#define ADC_SOC18CTL_ACQPS_M     0x1FFU       // SOC18 Acquisition Prescale
	#define ADC_SOC18CTL_CHSEL_S     15U
	#define ADC_SOC18CTL_CHSEL_M     0x78000U     // SOC18 Channel Select
	#define ADC_SOC18CTL_TRIGSEL_S   20U
    #define ADC_SOC18CTL_TRIGSEL_M   0x7F00000U   // SOC18 Trigger Source Select
    #define ADC_SOC18CTL_EXTCHSEL_S  28U
    #define ADC_SOC18CTL_EXTCHSEL_M  0xF000000U   // SOC18 External Channel Mux Select
#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC19CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)
	#define ADC_SOC19CTL_ACQPS_S     0U
	#define ADC_SOC19CTL_ACQPS_M     0x1FFU       // SOC19 Acquisition Prescale
	#define ADC_SOC19CTL_CHSEL_S     15U
	#define ADC_SOC19CTL_CHSEL_M     0x78000U     // SOC19 Channel Select
	#define ADC_SOC19CTL_TRIGSEL_S   20U
    #define ADC_SOC19CTL_TRIGSEL_M   0x1F00000U   // SOC19 Trigger Source Select
#elif (ADC_VERSION == 0002)
	#define ADC_SOC19CTL_ACQPS_S     0U
	#define ADC_SOC19CTL_ACQPS_M     0x1FFU       // SOC19 Acquisition Prescale
	#define ADC_SOC19CTL_CHSEL_S     15U
	#define ADC_SOC19CTL_CHSEL_M     0x78000U     // SOC19 Channel Select
	#define ADC_SOC19CTL_TRIGSEL_S   20U
    #define ADC_SOC19CTL_TRIGSEL_M   0x7F00000U   // SOC19 Trigger Source Select
#elif ADC_VERSION == 0003
	#define ADC_SOC19CTL_ACQPS_S     0U
	#define ADC_SOC19CTL_ACQPS_M     0x1FFU       // SOC19 Acquisition Prescale
	#define ADC_SOC19CTL_CHSEL_S     15U
	#define ADC_SOC19CTL_CHSEL_M     0x78000U     // SOC19 Channel Select
	#define ADC_SOC19CTL_TRIGSEL_S   20U
    #define ADC_SOC19CTL_TRIGSEL_M   0x7F00000U   // SOC19 Trigger Source Select
    #define ADC_SOC19CTL_EXTCHSEL_S  28U
    #define ADC_SOC19CTL_EXTCHSEL_M  0xF000000U   // SOC19 External Channel Mux Select
#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCSOC20CTL register
//
//*************************************************************************************************
#if (ADC_VERSION == 0001)

#elif (ADC_VERSION == 0002)

#elif ADC_VERSION == 0003
	#define ADC_SOC20CTL_ACQPS_S     0U
	#define ADC_SOC20CTL_ACQPS_M     0x1FFU       // SOC20 Acquisition Prescale
	#define ADC_SOC20CTL_CHSEL_S     15U
	#define ADC_SOC20CTL_CHSEL_M     0x78000U     // SOC20 Channel Select
	#define ADC_SOC20CTL_TRIGSEL_S   20U
    #define ADC_SOC20CTL_TRIGSEL_M   0x7F00000U   // SOC20 Trigger Source Select
    #define ADC_SOC20CTL_EXTCHSEL_S  28U
    #define ADC_SOC20CTL_EXTCHSEL_M  0xF000000U   // SOC20 External Channel Mux Select
#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCEVTSTAT register
//
//*************************************************************************************************
#define ADC_EVTSTAT_PPB1TRIPHI   0x1U      // Post Processing Block 1 Trip High Flag
#define ADC_EVTSTAT_PPB1TRIPLO   0x2U      // Post Processing Block 1 Trip Low Flag
#define ADC_EVTSTAT_PPB1ZERO     0x4U      // Post Processing Block 1 Zero Crossing Flag
#define ADC_EVTSTAT_PPB2TRIPHI   0x10U     // Post Processing Block 2 Trip High Flag
#define ADC_EVTSTAT_PPB2TRIPLO   0x20U     // Post Processing Block 2 Trip Low Flag
#define ADC_EVTSTAT_PPB2ZERO     0x40U     // Post Processing Block 2 Zero Crossing Flag
#define ADC_EVTSTAT_PPB3TRIPHI   0x100U    // Post Processing Block 3 Trip High Flag
#define ADC_EVTSTAT_PPB3TRIPLO   0x200U    // Post Processing Block 3 Trip Low Flag
#define ADC_EVTSTAT_PPB3ZERO     0x400U    // Post Processing Block 3 Zero Crossing Flag
#define ADC_EVTSTAT_PPB4TRIPHI   0x1000U   // Post Processing Block 4 Trip High Flag
#define ADC_EVTSTAT_PPB4TRIPLO   0x2000U   // Post Processing Block 4 Trip Low Flag
#define ADC_EVTSTAT_PPB4ZERO     0x4000U   // Post Processing Block 4 Zero Crossing Flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCEVTCLR register
//
//*************************************************************************************************
#define ADC_EVTCLR_PPB1TRIPHI   0x1U      // Post Processing Block 1 Trip High Clear
#define ADC_EVTCLR_PPB1TRIPLO   0x2U      // Post Processing Block 1 Trip Low Clear
#define ADC_EVTCLR_PPB1ZERO     0x4U      // Post Processing Block 1 Zero Crossing Clear
#define ADC_EVTCLR_PPB2TRIPHI   0x10U     // Post Processing Block 2 Trip High Clear
#define ADC_EVTCLR_PPB2TRIPLO   0x20U     // Post Processing Block 2 Trip Low Clear
#define ADC_EVTCLR_PPB2ZERO     0x40U     // Post Processing Block 2 Zero Crossing Clear
#define ADC_EVTCLR_PPB3TRIPHI   0x100U    // Post Processing Block 3 Trip High Clear
#define ADC_EVTCLR_PPB3TRIPLO   0x200U    // Post Processing Block 3 Trip Low Clear
#define ADC_EVTCLR_PPB3ZERO     0x400U    // Post Processing Block 3 Zero Crossing Clear
#define ADC_EVTCLR_PPB4TRIPHI   0x1000U   // Post Processing Block 4 Trip High Clear
#define ADC_EVTCLR_PPB4TRIPLO   0x2000U   // Post Processing Block 4 Trip Low Clear
#define ADC_EVTCLR_PPB4ZERO     0x4000U   // Post Processing Block 4 Zero Crossing Clear

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCEVTSEL register
//
//*************************************************************************************************
#define ADC_EVTSEL_PPB1TRIPHI   0x1U      // Post Processing Block 1 Trip High Event Enable
#define ADC_EVTSEL_PPB1TRIPLO   0x2U      // Post Processing Block 1 Trip Low Event Enable
#define ADC_EVTSEL_PPB1ZERO     0x4U      // Post Processing Block 1 Zero Crossing Event Enable
#define ADC_EVTSEL_PPB2TRIPHI   0x10U     // Post Processing Block 2 Trip High Event Enable
#define ADC_EVTSEL_PPB2TRIPLO   0x20U     // Post Processing Block 2 Trip Low Event Enable
#define ADC_EVTSEL_PPB2ZERO     0x40U     // Post Processing Block 2 Zero Crossing Event Enable
#define ADC_EVTSEL_PPB3TRIPHI   0x100U    // Post Processing Block 3 Trip High Event Enable
#define ADC_EVTSEL_PPB3TRIPLO   0x200U    // Post Processing Block 3 Trip Low Event Enable
#define ADC_EVTSEL_PPB3ZERO     0x400U    // Post Processing Block 3 Zero Crossing Event Enable
#define ADC_EVTSEL_PPB4TRIPHI   0x1000U   // Post Processing Block 4 Trip High Event Enable
#define ADC_EVTSEL_PPB4TRIPLO   0x2000U   // Post Processing Block 4 Trip Low Event Enable
#define ADC_EVTSEL_PPB4ZERO     0x4000U   // Post Processing Block 4 Zero Crossing Event Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCEVTINTSEL register
//
//*************************************************************************************************
#define ADC_EVTINTSEL_PPB1TRIPHI   0x1U      // Post Processing Block 1 Trip High Interrupt Enable
#define ADC_EVTINTSEL_PPB1TRIPLO   0x2U      // Post Processing Block 1 Trip Low Interrupt Enable
#define ADC_EVTINTSEL_PPB1ZERO     0x4U      // Post Processing Block 1 Zero Crossing Interrupt
                                             // Enable
#define ADC_EVTINTSEL_PPB2TRIPHI   0x10U     // Post Processing Block 2 Trip High Interrupt Enable
#define ADC_EVTINTSEL_PPB2TRIPLO   0x20U     // Post Processing Block 2 Trip Low Interrupt Enable
#define ADC_EVTINTSEL_PPB2ZERO     0x40U     // Post Processing Block 2 Zero Crossing Interrupt
                                             // Enable
#define ADC_EVTINTSEL_PPB3TRIPHI   0x100U    // Post Processing Block 3 Trip High Interrupt Enable
#define ADC_EVTINTSEL_PPB3TRIPLO   0x200U    // Post Processing Block 3 Trip Low Interrupt Enable
#define ADC_EVTINTSEL_PPB3ZERO     0x400U    // Post Processing Block 3 Zero Crossing Interrupt
                                             // Enable
#define ADC_EVTINTSEL_PPB4TRIPHI   0x1000U   // Post Processing Block 4 Trip High Interrupt Enable
#define ADC_EVTINTSEL_PPB4TRIPLO   0x2000U   // Post Processing Block 4 Trip Low Interrupt Enable
#define ADC_EVTINTSEL_PPB4ZERO     0x4000U   // Post Processing Block 4 Zero Crossing Interrupt
                                             // Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCOSDETECT register
//
//*************************************************************************************************
#define ADC_OSDETECT_DETECTCFG_S   0U
#define ADC_OSDETECT_DETECTCFG_M   0x7U   // ADC Opens and Shorts Detect Configuration

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCCOUNTER register
//
//*************************************************************************************************
#define ADC_COUNTER_FREECOUNT_S   0U
#define ADC_COUNTER_FREECOUNT_M   0xFFFU   // ADC Free Running Counter Value

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCREV register
//
//*************************************************************************************************
#define ADC_REV_TYPE_S   0U
#define ADC_REV_TYPE_M   0xFFU     // ADC Type
#define ADC_REV_REV_S    8U
#define ADC_REV_REV_M    0xFF00U   // ADC Revision

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCOFFTRIM register
//
//*************************************************************************************************
#define ADC_OFFTRIM_OFFTRIM_S   0U
#define ADC_OFFTRIM_OFFTRIM_M   0xFFU   // ADC Offset Trim

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1CONFIG register
//
//*************************************************************************************************
#define ADC_PPB1CONFIG_CONFIG_S     0U
#define ADC_PPB1CONFIG_CONFIG_M     0xFU    // ADC Post Processing Block 1 Configuration
#define ADC_PPB1CONFIG_TWOSCOMPEN   0x10U   // ADC Post Processing Block 1 Two's Complement Enable
#define ADC_PPB1CONFIG_CBCEN        0x20U   // Cycle By Cycle Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1STAMP register
//
//*************************************************************************************************
#define ADC_PPB1STAMP_DLYSTAMP_S   0U
#define ADC_PPB1STAMP_DLYSTAMP_M   0xFFFU   // ADC Post Processing Block 1 Delay Time Stamp

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1OFFCAL register
//
//*************************************************************************************************
#define ADC_PPB1OFFCAL_OFFCAL_S   0U
#define ADC_PPB1OFFCAL_OFFCAL_M   0x3FFU   // ADC Post Processing Block Offset Correction

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1TRIPHI register
//
//*************************************************************************************************

#if (ADC_VERSION == 0001)
#define ADC_PPB1TRIPHI_LIMITHI_S   0U
#define ADC_PPB1TRIPHI_LIMITHI_M   0xFFFFU    // ADC Post Processing Block 1 Trip High Limit
#define ADC_PPB1TRIPHI_HSIGN       0x10000U   // High Limit Sign Bit
#elif (ADC_VERSION == 0002) || (ADC_VERSION == 0003)
#define ADC_PPB1TRIPHI_LIMITHI_S   0U
#define ADC_PPB1TRIPHI_LIMITHI_M   0xFFFFFFFFU    // ADC Post Processing Block 1 Trip High Limit
#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1TRIPLO register
//
//*************************************************************************************************
#define ADC_PPB1TRIPLO_LIMITLO_S    0U
#define ADC_PPB1TRIPLO_LIMITLO_M    0xFFFFU       // ADC Post Processing Block 1 Trip Low Limit
#define ADC_PPB1TRIPLO_LSIGN        0x10000U      // Low Limit Sign Bit
#define ADC_PPB1TRIPLO_REQSTAMP_S   20U
// ADC_PPB1TRIPLO_LIMITLO2EN
#define ADC_PPB1TRIPLO_REQSTAMP_M   0xFFF00000U   // ADC Post Processing Block 1 Request Time Stamp

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB2CONFIG register
//
//*************************************************************************************************
#define ADC_PPB2CONFIG_CONFIG_S     0U
#define ADC_PPB2CONFIG_CONFIG_M     0xFU    // ADC Post Processing Block 2 Configuration
#define ADC_PPB2CONFIG_TWOSCOMPEN   0x10U   // ADC Post Processing Block 2 Two's Complement Enable
#define ADC_PPB2CONFIG_CBCEN        0x20U   // Cycle By Cycle Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB2STAMP register
//
//*************************************************************************************************
#define ADC_PPB2STAMP_DLYSTAMP_S   0U
#define ADC_PPB2STAMP_DLYSTAMP_M   0xFFFU   // ADC Post Processing Block 2 Delay Time Stamp

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB2OFFCAL register
//
//*************************************************************************************************
#define ADC_PPB2OFFCAL_OFFCAL_S   0U
#define ADC_PPB2OFFCAL_OFFCAL_M   0x3FFU   // ADC Post Processing Block Offset Correction

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB2TRIPHI register
//
//*************************************************************************************************
#define ADC_PPB2TRIPHI_LIMITHI_S   0U
#define ADC_PPB2TRIPHI_LIMITHI_M   0xFFFFU    // ADC Post Processing Block 2 Trip High Limit
#define ADC_PPB2TRIPHI_HSIGN       0x10000U   // High Limit Sign Bit

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB2TRIPLO register
//
//*************************************************************************************************
#define ADC_PPB2TRIPLO_LIMITLO_S    0U
#define ADC_PPB2TRIPLO_LIMITLO_M    0xFFFFU       // ADC Post Processing Block 2 Trip Low Limit
#define ADC_PPB2TRIPLO_LSIGN        0x10000U      // Low Limit Sign Bit
#define ADC_PPB2TRIPLO_REQSTAMP_S   20U
#define ADC_PPB2TRIPLO_REQSTAMP_M   0xFFF00000U   // ADC Post Processing Block 2 Request Time Stamp

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB3CONFIG register
//
//*************************************************************************************************
#define ADC_PPB3CONFIG_CONFIG_S     0U
#define ADC_PPB3CONFIG_CONFIG_M     0xFU    // ADC Post Processing Block 3 Configuration
#define ADC_PPB3CONFIG_TWOSCOMPEN   0x10U   // ADC Post Processing Block 3 Two's Complement Enable
#define ADC_PPB3CONFIG_CBCEN        0x20U   // Cycle By Cycle Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB3STAMP register
//
//*************************************************************************************************
#define ADC_PPB3STAMP_DLYSTAMP_S   0U
#define ADC_PPB3STAMP_DLYSTAMP_M   0xFFFU   // ADC Post Processing Block 3 Delay Time Stamp

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB3OFFCAL register
//
//*************************************************************************************************
#define ADC_PPB3OFFCAL_OFFCAL_S   0U
#define ADC_PPB3OFFCAL_OFFCAL_M   0x3FFU   // ADC Post Processing Block Offset Correction

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB3TRIPHI register
//
//*************************************************************************************************
#define ADC_PPB3TRIPHI_LIMITHI_S   0U
#define ADC_PPB3TRIPHI_LIMITHI_M   0xFFFFU    // ADC Post Processing Block 3 Trip High Limit
#define ADC_PPB3TRIPHI_HSIGN       0x10000U   // High Limit Sign Bit

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB3TRIPLO register
//
//*************************************************************************************************
#define ADC_PPB3TRIPLO_LIMITLO_S    0U
#define ADC_PPB3TRIPLO_LIMITLO_M    0xFFFFU       // ADC Post Processing Block 3 Trip Low Limit
#define ADC_PPB3TRIPLO_LSIGN        0x10000U      // Low Limit Sign Bit
#define ADC_PPB3TRIPLO_REQSTAMP_S   20U
#define ADC_PPB3TRIPLO_REQSTAMP_M   0xFFF00000U   // ADC Post Processing Block 3 Request Time Stamp

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB4CONFIG register
//
//*************************************************************************************************
#define ADC_PPB4CONFIG_CONFIG_S     0U
#define ADC_PPB4CONFIG_CONFIG_M     0xFU    // ADC Post Processing Block 4 Configuration
#define ADC_PPB4CONFIG_TWOSCOMPEN   0x10U   // ADC Post Processing Block 4 Two's Complement Enable
#define ADC_PPB4CONFIG_CBCEN        0x20U   // Cycle By Cycle Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB4STAMP register
//
//*************************************************************************************************
#define ADC_PPB4STAMP_DLYSTAMP_S   0U
#define ADC_PPB4STAMP_DLYSTAMP_M   0xFFFU   // ADC Post Processing Block 4 Delay Time Stamp

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB4OFFCAL register
//
//*************************************************************************************************
#define ADC_PPB4OFFCAL_OFFCAL_S   0U
#define ADC_PPB4OFFCAL_OFFCAL_M   0x3FFU   // ADC Post Processing Block Offset Correction

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB4TRIPHI register
//
//*************************************************************************************************
#define ADC_PPB4TRIPHI_LIMITHI_S   0U
#define ADC_PPB4TRIPHI_LIMITHI_M   0xFFFFU    // ADC Post Processing Block 4 Trip High Limit
#define ADC_PPB4TRIPHI_HSIGN       0x10000U   // High Limit Sign Bit

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB4TRIPLO register
//
//*************************************************************************************************
#define ADC_PPB4TRIPLO_LIMITLO_S    0U
#define ADC_PPB4TRIPLO_LIMITLO_M    0xFFFFU       // ADC Post Processing Block 4 Trip Low Limit
#define ADC_PPB4TRIPLO_LSIGN        0x10000U      // Low Limit Sign Bit
#define ADC_PPB4TRIPLO_REQSTAMP_S   20U
#define ADC_PPB4TRIPLO_REQSTAMP_M   0xFFF00000U   // ADC Post Processing Block 4 Request Time Stamp


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1RESULT register
//
//*************************************************************************************************
#define ADC_PPB1RESULT_PPBRESULT_S   0U
#define ADC_PPB1RESULT_PPBRESULT_M   0xFFFFU       // ADC Post Processing Block Result
#define ADC_PPB1RESULT_SIGN_S        16U
#define ADC_PPB1RESULT_SIGN_M        0xFFFF0000U   // Sign Extended Bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB2RESULT register
//
//*************************************************************************************************
#define ADC_PPB2RESULT_PPBRESULT_S   0U
#define ADC_PPB2RESULT_PPBRESULT_M   0xFFFFU       // ADC Post Processing Block Result
#define ADC_PPB2RESULT_SIGN_S        16U
#define ADC_PPB2RESULT_SIGN_M        0xFFFF0000U   // Sign Extended Bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB3RESULT register
//
//*************************************************************************************************
#define ADC_PPB3RESULT_PPBRESULT_S   0U
#define ADC_PPB3RESULT_PPBRESULT_M   0xFFFFU       // ADC Post Processing Block Result
#define ADC_PPB3RESULT_SIGN_S        16U
#define ADC_PPB3RESULT_SIGN_M        0xFFFF0000U   // Sign Extended Bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB4RESULT register
//
//*************************************************************************************************
#define ADC_PPB4RESULT_PPBRESULT_S   0U
#define ADC_PPB4RESULT_PPBRESULT_M   0xFFFFU       // ADC Post Processing Block Result
#define ADC_PPB4RESULT_SIGN_S        16U
#define ADC_PPB4RESULT_SIGN_M        0xFFFF0000U   // Sign Extended Bits




#if (ADC_VERSION == 0002) || (ADC_VERSION == 0003)
/* Add Repeater & related PPB */
//*************************************************************************************************
//
// The following are defines for the bit fields in the REP1CTL register
//
//*************************************************************************************************
#define ADC_REP1CTL_MODE			 0x1U		   // ADC Trigger Repeater 1 Mode Selection
#define ADC_REP1CTL_ACTIVEMODE    	 0x2U          // ADC Trigger Repeater 1 Active Mode
#define ADC_REP1CTL_MODULEBUSY    	 0x8U          // ADC Trigger Repeater 1 Module Busy
#define ADC_REP1CTL_PHASEOVF		 0x40U		   // ADC Trigger Repeater 1 Phase Delay Overflow
#define ADC_REP1CTL_TRIGGEROVF		 0x80U		   // ADC Trigger Repeater 1 Oversampled Trigger Overflow

#define ADC_REP1CTL_TRIGGER_S		 8U
#define ADC_REP1CTL_TRIGGER_M		 0x7F00U	   // ADC Trigger Repeater 1 Trigger Select
#define ADC_REP1CTL_SYNCINSEL_S		 16U
#define ADC_REP1CTL_SYNCINSEL_M		 0x1F0000U	   // Trigger repeater 1 sync
#define ADC_REP1CTL_SWSYNC			 0x800000U	   // Trigger repeater 1 software force sync

//*************************************************************************************************
//
// The following are defines for the bit fields in the REP1N register
//
//*************************************************************************************************
#define ADC_REP1N_NSEL_S		     0U
#define ADC_REP1N_NSEL_M		     0xFFFFU	  	   // ADC Trigger Repeater 1 selection of number of triggers
#define ADC_REP1N_NCOUNT_S   		 16U
#define ADC_REP1N_NCOUNT_M   		 0xFFFF0000U     // ADC Trigger Repeater 1 Trigger Counter

//*************************************************************************************************
//
// The following are defines for the bit fields in the REP1PHASE register
//
//*************************************************************************************************
#define ADC_REP1PHASE_PHASE_S		     0U
#define ADC_REP1PHASE_PHASE_M		     0xFFFFU	  // ADC trigger repeater 1 phase delay configuration

#define ADC_REP1PHASE_PHASECOUNT_S   	 16U
#define ADC_REP1PHASE_PHASECOUNT_M   	 0xFFFF0000U   // ADC Trigger Repeater 1 Phase Delay Status

//*************************************************************************************************
//
// The following are defines for the bit fields in the REP1SPREAD register
//
//*************************************************************************************************
#define ADC_REP1SPREAD_SPREAD_S		     0U
#define ADC_REP1SPREAD_SPREAD_M		     0xFFFFU	  // ADC trigger repeater 1 spread delay configuration

#define ADC_REP1SPREAD_SPREADCOUNT_S   	 16U
#define ADC_REP1SPREAD_SPREADCOUNT_M  	 0xFFFF0000U   // ADC Trigger Repeater 1 Spread Delay Status

//*************************************************************************************************
//
// The following are defines for the bit fields in the REP1FRC register
//
//*************************************************************************************************
#define ADC_REP1FRC_SWFRC		     0x1U	  // ADC Trigger Repeater 1 Software Force

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1LIMIT register
//
//*************************************************************************************************
#define ADC_PPB1LIMIT_LIMIT_S   0U
#define ADC_PPB1LIMIT_LIMIT_M   0x3FFU   // Post Processing Block 1 Limit

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1CONFIG register
//
//*************************************************************************************************
#define ADC_PPB1CONFIG_ABSEN        0x40U   // ADC Post Processing Block 1 Absolute Enable
#define ADC_PPB1CONFIG_CONGIGEXP	0x80U	//

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1TRIPLO register
//
//*************************************************************************************************
#define ADC_PPB1TRIPLO_LIMITLO2EN   0x80000U      // Extended Low Limit 2 Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADCPPB1CONFIG2 register
//
//*************************************************************************************************
#define ADC_PPB1CONFIG2_SHIFT_S       0U
#define ADC_PPB1CONFIG2_SHIFT_M       0xFU      // Post Processing Block 1 Right Shift
#define ADC_PPB1CONFIG2_SYNCINSEL_S   4U
#define ADC_PPB1CONFIG2_SYNCINSEL_M   0x1F0U    // Post Processing Block 1 Sync. Input Select
#define ADC_PPB1CONFIG2_SWSYNC        0x800U    // Post Processing Block 1 Software Force Sync.
#define ADC_PPB1CONFIG2_OSINTSEL      0x1000U   // Post Processing Block 1 Interrupt Source Select
#define ADC_PPB1CONFIG2_COMPSEL_S     14U
#define ADC_PPB1CONFIG2_COMPSEL_M     0xC000U   // Post Processing Block 1 Compare Source Select


//*************************************************************************************************
//
// The following are defines for the bit fields in the ADC_SOC_RST_CTRL register
//
//*************************************************************************************************
#define ADC_SOC_RST_CTRL_RST_EN_MODE_M          0x00000003U
#define ADC_SOC_RST_CTRL_RST_PERIOD_S			4U
#define ADC_SOC_RST_CTRL_RST_PERIOD_M			0x00000FF0U
#endif



#endif //HW_ADC_H
