/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_asysctl_v12.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/
/**
 * history
 * 20240627,WenGuangYong,Add register bit-field descriptions for 1.2 CS asysctl
 * 
*/
#ifndef DEVICE_DRIVERLIB_HW_ANA_SYSCTRL_PARA_V12_H_
#define DEVICE_DRIVERLIB_HW_ANA_SYSCTRL_PARA_V12_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x12)       //used for 1.2CS

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
//*************************************************************************************************
//
// The following are defines for the ANA_SYSCTRL_PARA register offsets
//
//*************************************************************************************************
#define ANA_CFG_O_ANA_CFG_LOCK              0x000    //lock register

#define ANA_CFG_O_TSNSCTL                   0x0C0    //Temperature Sensor Control Register
#define ANA_CFG_O_ANAREFCTL                 0x0D0    //Analog Reference Control Register
#define ANA_CFG_O_VMONCTL                   0x0E0    //Voltage Monitor Control Register
#define ANA_CFG_O_CMPHPMXSEL                0x104    //Bits to select one of the many sources on CmpHP inputs
#define ANA_CFG_O_CMPLPMXSEL                0x108    //Bits to select one of the many sources on CmpLP inputs
#define ANA_CFG_O_CMPHNMXSEL                0x10C    //Bits to select one of the many sources on CmpHN inputs
#define ANA_CFG_O_CMPLNMXSEL                0x10E    //Bits to select one of the many sources on CmpLN inputs
#define ANA_CFG_O_ADCDACLOOPBACK            0x110    //Enable loopback from DAC to ADCs
#define ANA_CFG_O_AGPIOCTRLA                0x204    //AGPIO control register

#define ANA_CFG_O_ANA_BOR_CFG               0x304    //BOR config
#define ANA_CFG_O_ANA_LDO_1V1_CFG           0x308    //1V1LDO config
#define ANA_CFG_O_ANA_EFLASH_BOR_CFG        0x30C    //EFLASH_BOR config
#define ANA_CFG_O_ANA_TOP_BG_CFG            0x310    //BG config
#define ANA_CFG_O_ANA_OSC_TRIM              0x314    //OSC TRIM config
#define ANA_CFG_O_ANA_PVM_CFG               0x318    //PVM config
#define ANA_CFG_O_ANA_POR_1V1_CFG           0x31C    //POR_1V1 config
#define ANA_CFG_O_ANA_TOP_POR_CFG           0x320    //TOP_POR config

#define ANA_CFG_O_ADC_RST                   0x400    //ADC_RST register
#define ANA_CFG_O_ADC_SAMP_SEL              0x404    //ADC_SAMP_SEL register
#define ANA_CFG_O_ADCA_SPARE                0x408    //ADC_A spare register
#define ANA_CFG_O_ADCB_SPARE                0x40C    //ADC_B spare register
#define ANA_CFG_O_ADCC_SPARE                0x410    //ADC_C spare register
#define ANA_CFG_O_ADC_TOP_SPARE             0x418    //ADC TOP spare register
#define ANA_CFG_O_CMP_EN                    0x41C    //CMP_EN register
#define ANA_CFG_O_CMP_RST                   0x420    //CMP_RST register
#define ANA_CFG_O_CMP_TOP_SPARE             0x4B4    //CMP TOP spare register
#define ANA_CFG_O_DAC_TOP_EN                0x4B8    //DAC_TOP_EN config register
#define ANA_CFG_O_DAC_RST                   0x4BC    //DAC_RST config register
#define ANA_CFG_O_DACA_BUF_TRIM             0x4C0    //DACA_BUF trim
#define ANA_CFG_O_DACB_BUF_TRIM             0x4C4    //DACB_BUF trim
#define ANA_CFG_O_DACA_SPARE                0x4CC    //DAC A spare register
#define ANA_CFG_O_DACB_SPARE                0x4D0    //DAC B spare register
#define ANA_CFG_O_DAC_TOP_SPARE             0x4D8    //DAC TOP spare register
#define ANA_CFG_O_TMUX                      0x4DC    //TMUX config register
#define ANA_CFG_O_V2I_A                     0x4E0    //V2I_A config register
#define ANA_CFG_O_V2I_B                     0x4E4    //V2I_B config register
#define ANA_CFG_O_BG_REG                    0x4E8    //band gap config register
#define ANA_CFG_O_ANA_CLK_TRIM              0x4EC    //ana_clk trim config register
#define ANA_CFG_O_ANA_CLK_SPARE             0x4F0    //ana_clk_spare config register
#define ANA_CFG_O_ANA_TS_CHOP_EN            0x504    //ana_ts_chop_en config register
#define ANA_CFG_O_ANA_TS_MEAS_EN            0x508    //ana_ts_meas_en config register
#define ANA_CFG_O_ANA_TS_SPARE              0x510    //ana_ts_spare config register
#define ANA_CFG_O_ANA_TEST_MUX_SEL          0x524    //ana_test_mux_sel config register
#define ANA_CFG_O_ANA_TEST_MUX_EN           0x528    //ana_test_mux_en config register
#define ANA_CFG_O_LDO_ANA_TEST_EN           0x530    //LDO_ANA_TEST_EN config
#define ANA_CFG_O_LDO_ANA_VSEL              0x534    //LDO_ANA_VSEL config
#define ANA_CFG_O_LDO_ANA_FASTON            0x538    //LDO_ANA_FASTON config
#define ANA_CFG_O_DACA_ANA_CFG              0x53C    //DACA_ANA_CFG config
#define ANA_CFG_O_DACA_INL_OFF_DLY_TRIM     0x540    //DACA_INL_OFF_DLY_TRIM config
#define ANA_CFG_O_DACB_ANA_CFG              0x544    //DACB_ANA_CFG config
#define ANA_CFG_O_DACB_INL_OFF_DLY_TRIM     0x548    //DACB_INL_OFF_DLY_TRIM config
#define ANA_CFG_O_ANA_TOP_SPARE1            0x554    //ANA_TOP_SPARE1 config
#define ANA_CFG_O_ANA_TOP_SPARE2            0x558    //ANA_TOP_SPARE2 config
#define ANA_CFG_O_ANA_TOP_SPARE3            0x55C    //ANA_TOP_SPARE3 config
#define ANA_CFG_O_ANA_TOP_SPARE4            0x560    //ANA_TOP_SPARE4 config
#define ANA_CFG_O_ADCA_BUFDAC2ADC_LBEN      0x564    //ADCA_BUFDAC2ADC_LBEN config
#define ANA_CFG_O_ADCB_BUFDAC2ADC_LBEN      0x568    //ADCB_BUFDAC2ADC_LBEN config
#define ANA_CFG_O_ADCC_BUFDAC2ADC_LBEN      0x56C    //ADCC_BUFDAC2ADC_LBEN config
#define ANA_CFG_O_ADC_L2H_CFG               0x574    //ADC_L2H_CFG config
#define ANA_CFG_O_CMP_MX_EN                 0x578    //CMP_MX_EN config
#define ANA_CFG_O_MUX_IO_EN                 0x57C    //MUX_IO_CFG config
#define ANA_CFG_O_DACA_TRIM                 0x580    //DACA_TRIM config
#define ANA_CFG_O_DACB_TRIM                 0x584    //DACB_TRIM config

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_SYSCTRL_LOCK register
//
//*************************************************************************************************

// Lock register. After writing the unlock value to this register, all registers protected by lock can be written. 
// Writing other values will lock all registers protected by lock.
#define ANA_SYSCTRL_PARA_ANA_SYSCTRL_LOCK_ANA_SYSCTRL_LOCK_M		0XFFFFFFFFU		

#define ANA_SYSCTRL_PARA_ANA_SYSCTRL_LOCK_ANA_SYSCTRL_LOCK_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TOP_SPARE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE_ANA_TOP_SPARE_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE_ANA_TOP_SPARE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADC_SAMP_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ADC_SAMP_SEL_ADC_SAMP_SEL_M		0X3U
#define ANA_SYSCTRL_PARA_ADC_SAMP_SEL_ADC_SAMP_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADC_SPARE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ADC_SPARE_ADC_SPARE_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_ADC_SPARE_ADC_SPARE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ADC_TOP_SPARE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ADC_TOP_SPARE_ADC_TOP_SPARE_M		0xFU
#define ANA_SYSCTRL_PARA_ADC_TOP_SPARE_ADC_TOP_SPARE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC10_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC10_TRIM_CMP_DAC10_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC10_TRIM_CMP_DAC10_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC11_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC11_TRIM_CMP_DAC11_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC11_TRIM_CMP_DAC11_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC20_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC20_TRIM_CMP_DAC20_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC20_TRIM_CMP_DAC20_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC21_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC21_TRIM_CMP_DAC21_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC21_TRIM_CMP_DAC21_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC30_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC30_TRIM_CMP_DAC30_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC30_TRIM_CMP_DAC30_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC31_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC31_TRIM_CMP_DAC31_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC31_TRIM_CMP_DAC31_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC40_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC40_TRIM_CMP_DAC40_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC40_TRIM_CMP_DAC40_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC41_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC41_TRIM_CMP_DAC41_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC41_TRIM_CMP_DAC41_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC50_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC50_TRIM_CMP_DAC50_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC50_TRIM_CMP_DAC50_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC51_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC51_TRIM_CMP_DAC51_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC51_TRIM_CMP_DAC51_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC60_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC60_TRIM_CMP_DAC60_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC60_TRIM_CMP_DAC60_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC61_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC61_TRIM_CMP_DAC61_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC61_TRIM_CMP_DAC61_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC70_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC70_TRIM_CMP_DAC70_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC70_TRIM_CMP_DAC70_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_DAC71_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_DAC71_TRIM_CMP_DAC71_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_DAC71_TRIM_CMP_DAC71_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP10_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP10_TRIM_CMP10_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP10_TRIM_CMP10_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP11_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP11_TRIM_CMP11_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP11_TRIM_CMP11_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP20_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP20_TRIM_CMP20_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP20_TRIM_CMP20_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP21_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP21_TRIM_CMP21_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP21_TRIM_CMP21_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP30_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP30_TRIM_CMP30_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP30_TRIM_CMP30_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP31_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP31_TRIM_CMP31_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP31_TRIM_CMP31_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP40_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP40_TRIM_CMP40_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP40_TRIM_CMP40_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP41_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP41_TRIM_CMP41_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP41_TRIM_CMP41_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP50_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP50_TRIM_CMP50_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP50_TRIM_CMP50_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP51_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP51_TRIM_CMP51_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP51_TRIM_CMP51_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP60_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP60_TRIM_CMP60_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP60_TRIM_CMP60_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP61_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP61_TRIM_CMP61_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP61_TRIM_CMP61_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP70_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP70_TRIM_CMP70_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP70_TRIM_CMP70_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP71_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP71_TRIM_CMP71_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP71_TRIM_CMP71_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP_SPARE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP_SPARE_CMP_SPARE_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_SPARE_CMP_SPARE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DAC1_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_DAC1_TRIM_DAC1_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_DAC1_TRIM_DAC1_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DAC2_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_DAC2_TRIM_DAC2_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_DAC2_TRIM_DAC2_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DAC1_BUF_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_DAC1_BUF_TRIM_DAC1_BUF_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_DAC1_BUF_TRIM_DAC1_BUF_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DAC2_BUF_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_DAC2_BUF_TRIM_DAC2_BUF_TRIM_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_DAC2_BUF_TRIM_DAC2_BUF_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DAC_SPARE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_DAC_SPARE_DAC_SPARE_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_DAC_SPARE_DAC_SPARE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the TMUX register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_TMUX_TMUX_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_TMUX_TMUX_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the V2I_A register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_V2I_A_V2I_A_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_V2I_A_V2I_A_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the V2I_B register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_V2I_B_V2I_B_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_V2I_B_V2I_B_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the BG_REG register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_BG_REG_BG_MEAS		0X8U
#define ANA_SYSCTRL_PARA_BG_REG_BG_EN		0X4U
#define ANA_SYSCTRL_PARA_BG_REG_BG_CHOP_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the PVM_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_PVM_EN_PVM_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the PVM_ATTR register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_PVM_ATTR_PVM_FALLING_SEL_M		0X70U
#define ANA_SYSCTRL_PARA_PVM_ATTR_PVM_FALLING_SEL_S		4U
#define ANA_SYSCTRL_PARA_PVM_ATTR_PVM_RISING_SEL_M		0X7U
#define ANA_SYSCTRL_PARA_PVM_ATTR_PVM_RISING_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the PVM_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_PVM_TRIM_PVM_TRIM_M		0XFU
#define ANA_SYSCTRL_PARA_PVM_TRIM_PVM_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_CLK_TRIM register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_CLK_TRIM_ANA_CLK_TRIM_M		0XFFFFU
#define ANA_SYSCTRL_PARA_ANA_CLK_TRIM_ANA_CLK_TRIM_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_CLK_SPARE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_CLK_SPARE_ANA_CLK_SPARE_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_CLK_SPARE_ANA_CLK_SPARE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_DIG_TS_DTB_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_DIG_TS_DTB_SEL_ANA_DIG_TS_DTB_SEL_M		0X3U
#define ANA_SYSCTRL_PARA_ANA_DIG_TS_DTB_SEL_ANA_DIG_TS_DTB_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_DIG_TS_DTB_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_DIG_TS_DTB_EN_ANA_DIG_TS_DTB_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_DIG_TS_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_DIG_TS_EN_ANA_DIG_TS_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_DIG_TS_DATA register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_DIG_TS_DATA_TSENSOR_DATA_SYNC_M		0XFFFU
#define ANA_SYSCTRL_PARA_ANA_DIG_TS_DATA_TSENSOR_DATA_SYNC_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TS1_MUX_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TS1_MUX_SEL_ANA_TS1_MUX_SEL_M		0X7U
#define ANA_SYSCTRL_PARA_ANA_TS1_MUX_SEL_ANA_TS1_MUX_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TS1_CHOP_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TS1_CHOP_EN_ANA_TS1_CHOP_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TS1_MEAS_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TS1_MEAS_EN_ANA_TS1_MEAS_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TS1_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TS1_EN_ANA_TS1_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TS1_SPARE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TS1_SPARE_ANA_TS1_SPARE_M		0X3FFU
#define ANA_SYSCTRL_PARA_ANA_TS1_SPARE_ANA_TS1_SPARE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TS2_CHOP_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TS2_CHOP_EN_ANA_TS2_CHOP_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TS2_MEAS_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TS2_MEAS_EN_ANA_TS2_MEAS_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TS2_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TS2_EN_ANA_TS2_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TS2_SPARE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TS2_SPARE_ANA_TS2_SPARE_M		0X3FFU
#define ANA_SYSCTRL_PARA_ANA_TS2_SPARE_ANA_TS2_SPARE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the LDO_ANA_TEST_MODE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_LDO_ANA_TEST_MODE_LDO4_ANA_TEST_MODE_M		0X30U
#define ANA_SYSCTRL_PARA_LDO_ANA_TEST_MODE_LDO4_ANA_TEST_MODE_S		4U
#define ANA_SYSCTRL_PARA_LDO_ANA_TEST_MODE_LDO3_ANA_TEST_MODE_M		0X3U
#define ANA_SYSCTRL_PARA_LDO_ANA_TEST_MODE_LDO3_ANA_TEST_MODE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the LDO_ANA_TEST_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_LDO_ANA_TEST_EN_LDO4_ANA_TEST_EN		0X10U
#define ANA_SYSCTRL_PARA_LDO_ANA_TEST_EN_LDO3_ANA_TEST_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the LDO_ANA_VSEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_LDO_ANA_VSEL_LDO4_ANA_VSEL_M		0X3F00U
#define ANA_SYSCTRL_PARA_LDO_ANA_VSEL_LDO4_ANA_VSEL_S		8U
#define ANA_SYSCTRL_PARA_LDO_ANA_VSEL_LDO3_ANA_VSEL_M		0X3FU
#define ANA_SYSCTRL_PARA_LDO_ANA_VSEL_LDO3_ANA_VSEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the LDO_ANA_PD register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_LDO_ANA_PD_LDO4_ANA_PD		0X10U
#define ANA_SYSCTRL_PARA_LDO_ANA_PD_LDO3_ANA_PD		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TEST_MUX_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_ANA_TEST_MUX3_SEL_M		0XF00U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_ANA_TEST_MUX3_SEL_S		8U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_ANA_TEST_MUX2_SEL_M		0XF0U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_ANA_TEST_MUX2_SEL_S		4U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_ANA_TEST_MUX1_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_ANA_TEST_MUX1_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TEST_MUX_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX3_MODE		0X40U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX2_MODE		0X20U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX1_MODE		0X10U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX3_EN		0X4U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX2_EN		0X2U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX1_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A0_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A0_SEL_A0_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A0_SEL_A0_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A1_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A1_SEL_A1_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A1_SEL_A1_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A2_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A2_SEL_A2_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A2_SEL_A2_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A3_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A3_SEL_A3_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A3_SEL_A3_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A4_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A4_SEL_A4_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A4_SEL_A4_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A5_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A5_SEL_A5_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A5_SEL_A5_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A6_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A6_SEL_A6_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A6_SEL_A6_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A8_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A8_SEL_A8_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A8_SEL_A8_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A9_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A9_SEL_A9_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A9_SEL_A9_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A10_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A10_SEL_A10_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A10_SEL_A10_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A11_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A11_SEL_A11_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A11_SEL_A11_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A12_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A12_SEL_A12_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A12_SEL_A12_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A14_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A14_SEL_A14_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A14_SEL_A14_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the A15_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_A15_SEL_A15_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_A15_SEL_A15_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the B0_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_B0_SEL_B0_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_B0_SEL_B0_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the B2_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_B2_SEL_B2_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_B2_SEL_B2_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the B3_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_B3_SEL_B3_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_B3_SEL_B3_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the B4_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_B4_SEL_B4_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_B4_SEL_B4_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the B5_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_B5_SEL_B5_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_B5_SEL_B5_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the B11_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_B11_SEL_B11_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_B11_SEL_B11_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the B12_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_B12_SEL_B12_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_B12_SEL_B12_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the C1_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_C1_SEL_C1_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_C1_SEL_C1_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the C3_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_C3_SEL_C3_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_C3_SEL_C3_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the C14_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_C14_SEL_C14_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_C14_SEL_C14_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP1_HP2_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP1_HP2_SEL_CMP1_HP2_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_CMP1_HP2_SEL_CMP1_HP2_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP3_HP2_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP3_HP2_SEL_CMP3_HP2_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_CMP3_HP2_SEL_CMP3_HP2_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP5_HP2_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP5_HP2_SEL_CMP5_HP2_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_CMP5_HP2_SEL_CMP5_HP2_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMP7_HP2_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_CMP7_HP2_SEL_CMP7_HP2_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_CMP7_HP2_SEL_CMP7_HP2_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TEST_MUX0_MODE register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX0_MODE_ANA_TEST_MUX0_MODE		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TEST_MUX0_SEL register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX0_SEL_ANA_TEST_MUX0_SEL_M		0XFU
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX0_SEL_ANA_TEST_MUX0_SEL_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANA_TEST_MUX0_EN register
//
//*************************************************************************************************
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX0_EN_ANA_TEST_MUX0_EN		0X1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMPHPMXSEL register
//
//*************************************************************************************************
#define ASYSCTL_CMPHPMXSEL_CMP1HPMXSEL_S   0U
#define ASYSCTL_CMPHPMXSEL_CMP1HPMXSEL_M   0x7U     // CMP1HPMXSEL bits
#define ASYSCTL_CMPHPMXSEL_CMP2HPMXSEL_S   3U
#define ASYSCTL_CMPHPMXSEL_CMP2HPMXSEL_M   0x38U    // CMP2HPMXSEL bits
#define ASYSCTL_CMPHPMXSEL_CMP3HPMXSEL_S   6U
#define ASYSCTL_CMPHPMXSEL_CMP3HPMXSEL_M   0x1C0U   // CMP3HPMXSEL bits
#define ASYSCTL_CMPHPMXSEL_CMP4HPMXSEL_S   9U
#define ASYSCTL_CMPHPMXSEL_CMP4HPMXSEL_M   0xE00U   // CMP4HPMXSEL bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMPLPMXSEL register
//
//*************************************************************************************************
#define ASYSCTL_CMPLPMXSEL_CMP1LPMXSEL_S   0U
#define ASYSCTL_CMPLPMXSEL_CMP1LPMXSEL_M   0x7U     // CMP1LPMXSEL bits
#define ASYSCTL_CMPLPMXSEL_CMP2LPMXSEL_S   3U
#define ASYSCTL_CMPLPMXSEL_CMP2LPMXSEL_M   0x38U    // CMP2LPMXSEL bits
#define ASYSCTL_CMPLPMXSEL_CMP3LPMXSEL_S   6U
#define ASYSCTL_CMPLPMXSEL_CMP3LPMXSEL_M   0x1C0U   // CMP3LPMXSEL bits
#define ASYSCTL_CMPLPMXSEL_CMP4LPMXSEL_S   9U
#define ASYSCTL_CMPLPMXSEL_CMP4LPMXSEL_M   0xE00U   // CMP4LPMXSEL bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMPHNMXSEL register
//
//*************************************************************************************************
#define ASYSCTL_CMPHNMXSEL_CMP1HNMXSEL   0x1U   // CMP1HNMXSEL bits
#define ASYSCTL_CMPHNMXSEL_CMP2HNMXSEL   0x2U   // CMP2HNMXSEL bits
#define ASYSCTL_CMPHNMXSEL_CMP3HNMXSEL   0x4U   // CMP3HNMXSEL bits
#define ASYSCTL_CMPHNMXSEL_CMP4HNMXSEL   0x8U   // CMP4HNMXSEL bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMPLNMXSEL register
//
//*************************************************************************************************
#define ASYSCTL_CMPLNMXSEL_CMP1LNMXSEL   0x1U   // CMP1LNMXSEL bits
#define ASYSCTL_CMPLNMXSEL_CMP2LNMXSEL   0x2U   // CMP2LNMXSEL bits
#define ASYSCTL_CMPLNMXSEL_CMP3LNMXSEL   0x4U   // CMP3LNMXSEL bits
#define ASYSCTL_CMPLNMXSEL_CMP4LNMXSEL   0x8U   // CMP4LNMXSEL bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the TSNSCTL register
//
//*************************************************************************************************
#define ASYSCTL_TSNSCTL_ENABLE   0x1U   // Temperature Sensor Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANAREFCTL register
//
//*************************************************************************************************
#define ASYSCTL_ANAREFCTL_ANAREFSEL      0x1U     // Analog Reference Select
#define ASYSCTL_ANAREFCTL_ANAREF2P5SEL   0x100U   // Analog Reference Select

/**
 * @brief The following are defines for the bit fields in the CMP_MX_EN register
 */
#define ANA_SYSCTRL_PARA_CMPX_LN_SELECT_1_S   0U
#define ANA_SYSCTRL_PARA_CMPX_LN_SELECT_2_S   4U
#define ANA_SYSCTRL_PARA_CMPX_LN_SELECT_3_S   8U
#define ANA_SYSCTRL_PARA_CMPX_LN_SELECT_4_S   12U
#define ANA_SYSCTRL_PARA_CMPX_LN_SELECT_5_S   16U
#define ANA_SYSCTRL_PARA_CMPX_LN_SELECT_6_S   20U
#define ANA_SYSCTRL_PARA_CMPX_LN_SELECT_7_S   24U
#define ANA_SYSCTRL_PARA_CMPX_HN_SELECT_1_S   0U
#define ANA_SYSCTRL_PARA_CMPX_HN_SELECT_2_S   4U
#define ANA_SYSCTRL_PARA_CMPX_HN_SELECT_3_S   8U
#define ANA_SYSCTRL_PARA_CMPX_HN_SELECT_4_S   12U
#define ANA_SYSCTRL_PARA_CMPX_HN_SELECT_5_S   16U
#define ANA_SYSCTRL_PARA_CMPX_HN_SELECT_6_S   20U
#define ANA_SYSCTRL_PARA_CMPX_HN_SELECT_7_S   24U
#define ANA_SYSCTRL_PARA_CMPX_LN_EN_M		0x1U
#define ANA_SYSCTRL_PARA_CMPX_LP_EN_M		0x2U
#define ANA_SYSCTRL_PARA_CMPX_HN_EN_M		0x4U
#define ANA_SYSCTRL_PARA_CMPX_HP_EN_M		0x8U
#define ANA_SYSCTRL_PARA_CMPMUX_STEP		4U
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */


 #ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_HW_ANA_SYSCTRL_PARA_H_ */
