/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_asysctl_v30.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_ANA_SYSCTRL_PARA_V30_H_
#define DEVICE_DRIVERLIB_HW_ANA_SYSCTRL_PARA_V30_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x30)      //used for 3.0CS

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/**
 * @brief The following are defines for the ANA_SYSCTRL_PARA register offsets
 */
#define ANA_CFG_O_ANA_CFG_LOCK              0x000	/* lock register 					   */

#define ANA_CFG_O_TSNSCTL                   0x0C0   /* Temperature Sensor Control Register */
#define ANA_CFG_O_ANAREFCTL                 0x0D0   /* Analog Reference Control Register   */
#define ANA_CFG_O_VMONCTL                   0x0E0   /* Voltage Monitor Control Register    */
#define ANA_CFG_O_CMPHPMXSEL                0x104   /* Bits to select one of the many
														sources on CmpHP inputs 		   */
#define ANA_CFG_O_CMPLPMXSEL                0x108   /* Bits to select one of the many
														sources on CmpLP inputs 	*/
#define ANA_CFG_O_CMPHNMXSEL                0x10C   /* Bits to select one of the many
														sources on CmpHN inputs 	*/
#define ANA_CFG_O_CMPLNMXSEL                0x10E   /* Bits to select one of the many
														sources on CmpLN inputs 	*/
#define ANA_CFG_O_ADCDACLOOPBACK            0x110   /* Enable loopback from DAC to ADCs     */
#define ANA_CFG_O_CMPSSCTL					0x116	/* CMPSS control register               */

#define ANA_CFG_O_AGPIOCTRLA				0x214	/* AGPIO control register A(157/137/p55)*/
#define ANA_CFG_O_AGPIOCTRLB				0x218	/* AGPIO control register B(P55)		*/
#define ANA_CFG_O_ADCSOCFRCGB				0x26C	/* ADC GLOBAL SOC Force 				*/
#define ANA_CFG_O_ADCSOCFRCGBSEL			0x270	/* ADC GLOBAL SOC Force Select 			*/

#define ANA_CFG_O_ANA_BOR_CFG               0x304   /* BOR config                       */
#define ANA_CFG_O_ANA_LDO_1V1_CFG           0x308   /* 1V1LDO config                    */
#define ANA_CFG_O_ANA_EFLASH_BOR_CFG        0x30C   /* EFLASH_BOR config                */
#define ANA_CFG_O_ANA_TOP_BG_CFG            0x310   /* BG config                        */
#define ANA_CFG_O_ANA_OSC_TRIM              0x314   /* OSC TRIM config                  */
#define ANA_CFG_O_ANA_PVM_CFG               0x318   /* PVM config                       */
#define ANA_CFG_O_ANA_POR_1V1_CFG           0x31C   /* POR_1V1 config                   */
#define ANA_CFG_O_ANA_TOP_POR_CFG           0x320   /* TOP_POR config                   */
#define ANA_CFG_O_ANA_OSC_CFG               0x324
#define ANA_CFG_O_ANA_OSC2_SPARE            0x328

#define ANA_CFG_O_ADC_RST                   0x400   /* ADC_RST register                 */
#define ANA_CFG_O_ADC_SAMP_SEL              0x404   /* ADC_SAMP_SEL register            */
#define ANA_CFG_O_ADCA_SPARE                0x408   /* ADC_A spare register             */
#define ANA_CFG_O_ADCB_SPARE                0x40C   /* ADC_B spare register             */
#define ANA_CFG_O_ADCC_SPARE                0x410   /* ADC_C spare register             */
#define ANA_CFG_O_ADC_TOP_SPARE             0x418   /* ADC TOP spare register           */
#define ANA_CFG_O_CMP_EN                    0x41C   /* CMP_EN register                  */
#define ANA_CFG_O_CMP_RST                   0x420   /* CMP_RST register                 */
#define ANA_CFG_O_CMP_TOP_SPARE             0x4B4   /* CMP TOP spare register           */
#define ANA_CFG_O_DAC_TOP_EN                0x4B8   /* DAC_TOP_EN config register       */
#define ANA_CFG_O_DAC_RST                   0x4BC   /* DAC_RST config register          */
#define ANA_CFG_O_DACA_BUF_TRIM             0x4C0   /* DACA_BUF trim                    */
#define ANA_CFG_O_DACB_BUF_TRIM             0x4C4   /* DACB_BUF trim                    */
#define ANA_CFG_O_DACA_SPARE                0x4CC   /* DAC A spare register             */
#define ANA_CFG_O_DACB_SPARE                0x4D0   /* DAC B spare register             */
#define ANA_CFG_O_DAC_TOP_SPARE             0x4D8   /* DAC TOP spare register           */
#define ANA_CFG_O_TMUX                      0x4DC   /* TMUX config register             */
#define ANA_CFG_O_V2I_A                     0x4E0   /* V2I_A config register            */
#define ANA_CFG_O_V2I_B                     0x4E4   /* V2I_B config register            */
#define ANA_CFG_O_BG_REG                    0x4E8   /* band gap config register         */
#define ANA_CFG_O_ANA_CLK_TRIM              0x4EC   /* ana_clk trim config register     */
#define ANA_CFG_O_ANA_CLK_SPARE             0x4F0   /* ana_clk_spare config register    */
#define ANA_CFG_O_ANA_TS_CHOP_EN            0x504   /* ana_ts_chop_en config register   */
#define ANA_CFG_O_ANA_TS_MEAS_EN            0x508   /* ana_ts_meas_en config register   */
#define ANA_CFG_O_ANA_TS_SPARE              0x510   /* ana_ts_spare config register     */
#define ANA_CFG_O_ANA_TEST_MUX_SEL          0x524   /* ana_test_mux_sel config register */
#define ANA_CFG_O_ANA_TEST_MUX_EN           0x528   /* ana_test_mux_en config register  */
#define ANA_CFG_O_LDO_ANA_TEST_EN           0x530   /* LDO_ANA_TEST_EN config           */
#define ANA_CFG_O_LDO_ANA_VSEL              0x534   /* LDO_ANA_VSEL config              */
#define ANA_CFG_O_LDO_ANA_FASTON            0x538   /* LDO_ANA_FASTON config            */
#define ANA_CFG_O_DACA_ANA_CFG              0x53C   /* DACA_ANA_CFG config              */
#define ANA_CFG_O_DACA_INL_OFF_DLY_TRIM     0x540   /* DACA_INL_OFF_DLY_TRIM config     */
#define ANA_CFG_O_DACB_ANA_CFG              0x544   /* DACB_ANA_CFG config              */
#define ANA_CFG_O_DACB_INL_OFF_DLY_TRIM     0x548   /* DACB_INL_OFF_DLY_TRIM config     */
#define ANA_CFG_O_ANA_TOP_SPARE1            0x554   /* ANA_TOP_SPARE1 config            */
#define ANA_CFG_O_ANA_TOP_SPARE2            0x558   /* ANA_TOP_SPARE2 config            */
#define ANA_CFG_O_ANA_TOP_SPARE3            0x55C   /* ANA_TOP_SPARE3 config            */
#define ANA_CFG_O_ANA_TOP_SPARE4            0x560   /* ANA_TOP_SPARE4 config            */
#define ANA_CFG_O_ADCA_BUFDAC2ADC_LPEN      0x564   /* ADCA_BUFDAC2ADC_LBEN config      */
#define ANA_CFG_O_ADCC_BUFDAC2ADC_LPEN      0x56C   /* ADCC_BUFDAC2ADC_LBEN config      */
#define ANA_CFG_O_ADC_L2H_CFG               0x574   /* ADC_L2H_CFG config               */
#define ANA_CFG_O_CMP_MX_EN                 0x578   /* CMP_MX_EN config                 */
#define ANA_CFG_O_CMP_MUX_IO_EN             0x57C   /* MUX_IO_CFG config                */
#define ANA_CFG_O_CMP1DACCTL                0x588   /* DACB_TRIM config                 */

/**
 * @brief The following are defines for the bit fields in the ANA_SYSCTRL_LOCK register.
 */
#define ANA_SYSCTRL_PARA_ANA_SYSCTRL_LOCK_ANA_SYSCTRL_LOCK_M		0XFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_SYSCTRL_LOCK_ANA_SYSCTRL_LOCK_S		0U

/**
 * @brief The following are defines for the bit fields in the TSNSCL register.
 */
#define ANA_SYSCTRL_PARA_TSNSCTL_TSNS_ENABLE		0x0001U /* Temperature Sensor Enable.*/

/**
 * @brief The following are defines for the bit fields in the ANAREFCTL register.
 */
#define ANA_SYSCTRL_PARA_ANAREFCTL_ANAREFSEL		0x0001U /* Analog reference mode select.*/
#define ANA_SYSCTRL_PARA_ANAREFCTL_ANAREF2P5SEL		0x0100U /* Analog reference 2.5V source select.*/
#define ANA_SYSCTRL_PARA_ANAREFSEL_SUP_OVERRIDE		0x8000U/* This configuration determines (overrides)
															the external reference selection for ADC*/

/**
 * @brief The following are defines for the bit fields in the VMONCTL register.
 */
#define ANA_SYSCTRL_PARA_VMONCTL_BORLVMONDIS		0x0100U /* Disable BORL(ow) feature on VDDIO */

/**
 * @brief The following are defines for the bit fields in the CMPHPMXSEL register.
 */
#define ANA_SYSCTRL_PARA_CMPHPMXSEL_CMP1HPMXSEL_S	0U
#define ANA_SYSCTRL_PARA_CMPHPMXSEL_CMP1HPMXSEL_M	0x00000007U /* CMP1HPMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPHPMXSEL_CMP2HPMXSEL_S	3U
#define ANA_SYSCTRL_PARA_CMPHPMXSEL_CMP2HPMXSEL_M	0x00000038U /* CMP2HPMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPHPMXSEL_CMP3HPMXSEL_S	6U
#define ANA_SYSCTRL_PARA_CMPHPMXSEL_CMP3HPMXSEL_M	0x000001C0U /* CMP3HPMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPHPMXSEL_CMP4HPMXSEL_S	9U
#define ANA_SYSCTRL_PARA_CMPHPMXSEL_CMP4HPMXSEL_M	0x00000E00U /* CMP4HPMXSEL bits */

/**
 * @brief The following are defines for the bit fields in the CMPLPMXSEL register.
 */
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP1LPMXSEL_S	0U
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP1LPMXSEL_M	0x00000007U /* CMP1LPMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP2LPMXSEL_S	3U
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP2LPMXSEL_M	0x00000038U /* CMP2LPMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP3LPMXSEL_S	6U
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP3LPMXSEL_M	0x000001C0U /* CMP3LPMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP4LPMXSEL_S	9U
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP4LPMXSEL_M	0x00000E00U /* CMP4LPMXSEL bits */

/**
 * @brief The following are defines for the bit fields in the CMPHNMXSEL.
 */
#define ANA_SYSCTRL_PARA_CMPHNMXSEL_CMP1HNMXSEL		0x0001U /* CMP1HNMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPHNMXSEL_CMP2HNMXSEL		0x0002U /* CMP2HNMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPHNMXSEL_CMP3HNMXSEL		0x0004U /* CMP3HNMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPHNMXSEL_CMP4HNMXSEL		0x0008U /* CMP4HNMXSEL bits */

/**
 * @brief The following are defines for the bit fields in the CMPLNMXSEL.
 */
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP1LNMXSEL		0x0001U /* CMP1LNMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP2LNMXSEL		0x0002U /* CMP1LNMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP3LNMXSEL		0x0004U /* CMP1LNMXSEL bits */
#define ANA_SYSCTRL_PARA_CMPLPMXSEL_CMP4LNMXSEL		0x0008U /* CMP1LNMXSEL bits */

/**
 * @brief The following are defines for the bit fields in the ADCDACLOOPBACK.
 */
#define ANA_SYSCTRL_PARA_ADCDACLOOPBACK_ENLB2ADCA	0x00000001U /* Enable DACA loopback to ADCA */
#define ANA_SYSCTRL_PARA_ADCDACLOOPBACK_ENLB2ADCC	0x00000004U /* Enable DACC loopback to ADCC */

/**
 * @brief The following are defines for the bit fields in the CMPSSCTL.
 */
#define ANA_SYSCTRL_PARA_CMPSSCTL_CMP1DACLOUTEN		0x0001U /* Enable general purpose DAC functionality for
															CMPSS1.COMPDACL */
#define ANA_SYSCTRL_PARA_CMPSSCTL_CMPSSCTLEN		0x8000U /* Enable the CMPSSCTL Register */

/**
 * @brief The following are defines for the bit fields in the ADC_RST.
 */
#define ANA_SYSCTRL_PARA_ADC_RST_ADCA_RST	0x00000001U
#define ANA_SYSCTRL_PARA_ADC_RST_ADCC_RST	0x00000004U

#if (GS32_PART_NUM==0x00137)|| (GS32_PART_NUM==0x00157) || (GS32_PART_NUM==0x0550)
/**
 * @brief The following are defines for the bit fields in the AGPIOCTRLA.
 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLA_GPIO11	0x00000800U /* AGPIOCTRL for GPIO11 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLA_GPIO12	0x00001000U /* AGPIOCTRL for GPIO12 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLA_GPIO13	0x00002000U /* AGPIOCTRL for GPIO13 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLA_GPIO16	0x00010000U /* AGPIOCTRL for GPIO16 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLA_GPIO17	0x00020000U /* AGPIOCTRL for GPIO17 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLA_GPIO20	0x00100000U /* AGPIOCTRL for GPIO20 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLA_GPIO21	0x00200000U /* AGPIOCTRL for GPIO21 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLA_GPIO24	0x01000000U /* AGPIOCTRL for GPIO24 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLA_GPIO28	0x10000000U /* AGPIOCTRL for GPIO28 */
#endif

#if (GS32_PART_NUM==0x0550)
/**
 * @brief The following are defines for the bit fields in the AGPIOCTRLA.
 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLB_GPIO33	0x00000002U /* AGPIOCTRL for GPIO33 */
#endif

/**
 * @brief The following are defines for the bit fields in the ADCSOCFRCGB register.
 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC0    0x00000001U /* Generate synchronous SW trigger for SOC0  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC1    0x00000002U /* Generate synchronous SW trigger for SOC1  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC2    0x00000004U /* Generate synchronous SW trigger for SOC2  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC3    0x00000008U /* Generate synchronous SW trigger for SOC3  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC4    0x00000010U /* Generate synchronous SW trigger for SOC4  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC5    0x00000020U /* Generate synchronous SW trigger for SOC5  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC6    0x00000040U /* Generate synchronous SW trigger for SOC6  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC7    0x00000080U /* Generate synchronous SW trigger for SOC7  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC8    0x00000100U /* Generate synchronous SW trigger for SOC8  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC9    0x00000200U /* Generate synchronous SW trigger for SOC9  */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC10   0x00000400U /* Generate synchronous SW trigger for SOC10 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC11   0x00000800U /* Generate synchronous SW trigger for SOC11 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC12   0x00001000U /* Generate synchronous SW trigger for SOC12 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC13   0x00002000U /* Generate synchronous SW trigger for SOC13 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC14   0x00004000U /* Generate synchronous SW trigger for SOC14 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC15   0x00008000U /* Generate synchronous SW trigger for SOC15 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC16   0x00010000U /* Generate synchronous SW trigger for SOC16 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC17   0x00020000U /* Generate synchronous SW trigger for SOC17 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC18   0x00040000U /* Generate synchronous SW trigger for SOC18 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC19   0x00080000U /* Generate synchronous SW trigger for SOC19 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGB_SOC20   0x00100000U /* Generate synchronous SW trigger for SOC20 */

/**
 * @brief The following are defines for the bit fields in the ADCSOCFRCGBSEL register.
 */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGBSEL_ADCA   0x1U   /* Generate synchronous SW trigger for ADCA */
#define ANA_SYSCTRL_PARA_ADCSOCFRCGBSEL_ADCC   0x4U   /* Generate synchronous SW trigger for ADCC */

/**
 * @brief The following are defines for the bit fields in the AGPIOCTRLH register.
 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLH_GPIO224   0x00000001U	/* AGPIOCTRL for GPIO224 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLH_GPIO226   0x00000004U    /* AGPIOCTRL for GPIO226 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLH_GPIO227   0x00000008U    /* AGPIOCTRL for GPIO227 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLH_GPIO228   0x00000010U    /* AGPIOCTRL for GPIO228 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLH_GPIO230   0x00000040U    /* AGPIOCTRL for GPIO230 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLH_GPIO236   0x00001000U    /* AGPIOCTRL for GPIO236 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLH_GPIO242   0x00040000U    /* AGPIOCTRL for GPIO242 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLH_GPIO247   0x00800000U    /* AGPIOCTRL for GPIO247 */
#define ANA_SYSCTRL_PARA_AGPIOCTRLH_GPIO253   0x20000000U    /* AGPIOCTRL for GPIO253 */

/**
 * @brief The following are defines for the bit fields in the ANA_BOR_CFG register.
 */
#define ANA_SYSCTRL_PARA_BOR_CFG_BOR_FALLING_SEL_S	1U
#define ANA_SYSCTRL_PARA_BOR_CFG_BOR_FALLING_SEL_M 	0x0000000EU /* bor Low threshold selection */
#define ANA_SYSCTRL_PARA_BOR_CFG_BOR_RISING_SEL_S	4U
#define ANA_SYSCTRL_PARA_BOR_CFG_BOR_RISING_SEL_M 	0x00000070U /* bor High threshold selection */
#define ANA_SYSCTRL_PARA_BOR_CFG_BOR_TRIM_S			7
#define ANA_SYSCTRL_PARA_BOR_CFG_BOR_TRIM_M		 	0x00000780U /* bor Trim value */
#define ANA_SYSCTRL_PARA_BOR_CFG_BOR_TEST_EN	 	0x00000800U /* bor Test enable */

/**
 * @brief The following are defines for the bit fields in the ANA_LDO_1V1_CFG register
 */
#define ANA_SYSCTRL_PARA_ANA_LDO_1V1_CFG_VSEL_S			0U
#define ANA_SYSCTRL_PARA_ANA_LDO_1V1_CFG_VSEL_M			0x0000000FU
#define ANA_SYSCTRL_PARA_ANA_LDO_1V1_CFG_TEST_MODE_S	5U
#define ANA_SYSCTRL_PARA_ANA_LDO_1V1_CFG_TEST_MODE_M	0x00000060U
#define ANA_SYSCTRL_PARA_ANA_LDO_1V1_CFG_CHOP_EN		0x00000080U
#define ANA_SYSCTRL_PARA_ANA_LDO_1V1_CFG_TEST_MUX_SEL_S	8U
#define ANA_SYSCTRL_PARA_ANA_LDO_1V1_CFG_TEST_MUX_SEL_M 0x00000700U
#define ANA_SYSCTRL_PARA_ANA_LDO_1V1_CFG_TEST_EN	 	0x00000800U

/**
 * @brief The following are defines for the bit fields in the ANA_EFLASH_BOR_CFG register
 */
#define ANA_SYSCTRL_PARA_ANA_EFLASH_BOR_CFG_TEST_EN		0x00000001U
#define ANA_SYSCTRL_PARA_ANA_EFLASH_BOR_CFG_TEST_SEL_S	1U
#define ANA_SYSCTRL_PARA_ANA_EFLASH_BOR_CFG_TEST_SEL_M	0x00000006U

/**
 * @brief The following are defines for the bit fields in the ANA_TOP_BG_CFG register
 */
#define ANA_SYSCTRL_PARA_ANA_TOP_BG_CFG_CHOP_EN		 0x00000001U
#define ANA_SYSCTRL_PARA_ANA_TOP_BG_CFG_TEST_MUX_EN	 0x00000002U
#define ANA_SYSCTRL_PARA_ANA_TOP_BG_CFG_TEST_MUX_SEL_S 2U
#define ANA_SYSCTRL_PARA_ANA_TOP_BG_CFG_TEST_MUX_SEL_M 0x0000001CU

/**
 * @brief The following are defines for the bit fields in the ANA_PVM_CFG register
 */
#define ANA_SYSCTRL_PARA_ANA_PVM_CFG_PVM_EN				0x00000001U
#define ANA_SYSCTRL_PARA_ANA_PVM_CFG_PVM_FALLING_SEL_S	1U
#define ANA_SYSCTRL_PARA_ANA_PVM_CFG_PVM_FALLING_SEL_M	0x0000000EU
#define ANA_SYSCTRL_PARA_ANA_PVM_CFG_PVM_RISING_SEL_S	4U
#define ANA_SYSCTRL_PARA_ANA_PVM_CFG_PVM_RISING_SEL_M	0x00000070U
#define ANA_SYSCTRL_PARA_ANA_PVM_CFG_PVM_TRIM_S			7U
#define ANA_SYSCTRL_PARA_ANA_PVM_CFG_PVM_TRIM_M			0x00000780U
#define ANA_SYSCTRL_PARA_ANA_PVM_CFG_PVM_TEST_EN		0x00000800U

/**
 * @brief The following are defines for the bit fields in the ANA_POR_1V1_CFG register
 */
#define ANA_SYSCTRL_PARA_ANA_POR_1V1_CFG_TEST_EN	0x00000001U

/**
 * @brief The following are defines for the bit fields in the ANA_TOP_POR_CFG register
 */
#define ANA_SYSCTRL_PARA_ANA_TOP_POR_CFG_TEST_EN	0x00000001U

/**
 * @brief The following are defines for the bit fields in the ANA_OSC_CFG register
 */
#define ANA_SYSCTRL_PARA_ANA_OSC_CFG_OSC2_RES_SEL	0x00000002U

/**
 * @brief The following are defines for the bit fields in the ANA_OSC2_SPARE register
 */
#define ANA_SYSCTRL_PARA_ANA_OSC2_SPARE_M			0x0000FFFFU

/**
 * @brief The following are defines for the bit fields in the ADC_RST register
 */
#define ANA_SYSCTRL_PARA_ADC_RST_ADCA_RST		0x00000001U
#define ANA_SYSCTRL_PARA_ADC_RST_ADCC_RST		0x00000004U

/**
 * @brief The following are defines for the bit fields in the ADC_SAMP_SEL register
 */
#define ANA_SYSCTRL_PARA_ADC_SAMP_SEL_ADCA_SEL_M	0x00000003U
#define ANA_SYSCTRL_PARA_ADC_SAMP_SEL_ADCC_SEL_S	8U
#define ANA_SYSCTRL_PARA_ADC_SAMP_SEL_ADCC_SEL_M	0x00000300U

/**
 * @brief The following are defines for the bit fields in the ADCA_SPARE and ADCC_SPARE register
 */
#define ANA_SYSCTRL_PARA_ADC_SPARE_M			0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_ADC_SPARE_S			0U

/**
 * @brief The following are defines for the bit fields in the ADC_TOP_SPARE register
 */
#define ANA_SYSCTRL_PARA_ADC_TOP_SPARE_M		0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_ADC_TOP_SPARE_S		0U

/**
 * @brief The following are defines for the bit fields in the CMP_EN register
 */
#define ANA_SYSCTRL_PARA_CMP_EN					0x1U

/**
 * @brief The following are defines for the bit fields in the CMP_RST register
 */
#define ANA_SYSCTRL_PARA_CMP_RST				0x1U

/**
 * @brief The following are defines for the bit fields in the ANA_SYSCTRL_PARA register
 */
#define ANA_SYSCTRL_PARA_ANA_SYSCTRL_PARA_M		0x00000003U

/**
 * @brief The following are defines for the bit fields in the CMP_TOP_SPARE register
 */
#define ANA_SYSCTRL_PARA_CMP_TOP_SPARE_M		0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_CMP_TOP_SPARE_S		0U

/**
 * @brief The following are defines for the bit fields in the TMUX register
 */
#define ANA_SYSCTRL_PARA_TMUX_M			0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_TMUX_S			0U

/**
 * @brief The following are defines for the bit fields in the V2I_A register
 */
#define ANA_SYSCTRL_PARA_V2I_A_M		0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_V2I_A_S		0U

/**
 * @brief The following are defines for the bit fields in the V2I_B register
 */
#define ANA_SYSCTRL_PARA_V2I_B_M		0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_V2I_B_S		0U

/**
 * @brief The following are defines for the bit fields in the BG_REG register
 */
#define ANA_SYSCTRL_PARA_BG_CHOP_EN		0x00000001U
#define ANA_SYSCTRL_PARA_BG_MEAS		0x00000008U

/**
 * @brief The following are defines for the bit fields in the ANA_CLK_TRIM register
 */
#define ANA_SYSCTRL_PARA_ANA_CLK_TRIM_M	0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_CLK_TRIM_S	0U

/**
 * @brief The following are defines for the bit fields in the ANA_CLK_SPARE register
 */
#define ANA_SYSCTRL_PARA_ANA_CLK_SPARE_M	0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_CLK_SPARE_S	0U

/**
 * @brief The following are defines for the bit fields in the ANA_TS_CHOP_EN register
 */
#define ANA_SYSCTRL_PARA_ANA_TS_CHOP_EN		0x00000001U

/**
 * @brief The following are defines for the bit fields in the ANA_TS_MEAS_EN register
 */
#define ANA_SYSCTRL_PARA_ANA_TS_MEAS_EN		0x00000001U

/**
 * @brief The following are defines for the bit fields in the ANA_TS_SPARE register
 */
#define ANA_SYSCTRL_PARA_ANA_TS_SPARE_M		0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_TS_SPARE_S		0U

/**
 * @brief The following are defines for the bit fields in the ANA_TEST_MUX_SEL register
 */
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_MUX0_SEL_M	0x0000000FU
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_MUX0_SEL_S	0U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_MUX1_SEL_M	0x000000F0U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_MUX1_SEL_S	4U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_MUX2_SEL_M	0x00000F00U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_MUX2_SEL_S	8U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_MUX3_SEL_M	0x0000F000U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_SEL_MUX3_SEL_S	12U

/**
 * @brief The following are defines for the bit fields in the ANA_TEST_MUX_EN register
 */
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX3_MODE		0X80U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX2_MODE		0X40U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX1_MODE		0X20U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX0_MODE		0X10U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX3_EN		0X8U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX2_EN		0X4U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX1_EN		0X2U
#define ANA_SYSCTRL_PARA_ANA_TEST_MUX_EN_ANA_TEST_MUX0_EN		0X1U

/**
 * @brief The following are defines for the bit fields in the LDO_ANA_TEST_EN register
 */
#define ANA_SYSCTRL_PARA_LDO_ANA_TEST_EN_LDO_ANA_TEST_EN		0X1U

/**
 * @brief The following are defines for the bit fields in the LDO_ANA_VSEL register
 */
#define ANA_SYSCTRL_PARA_LDO_ANA_VSEL_LDO_ANA_VSEL_M		0X0000003FU
#define ANA_SYSCTRL_PARA_LDO_ANA_VSEL_LDO_ANA_VSEL_S		0U

/**
 * @brief The following are defines for the bit fields in the LDO_ANA_FASTON register
 */
#define ANA_SYSCTRL_PARA_LDO_ANA_FASTON_LDO_ANA_FASTON		0x00000001U

/**
 * @brief The following are defines for the bit fields in the ANA_TOP_SPARE1 register
 */
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE1_M		0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE1_S		0U

/**
 * @brief The following are defines for the bit fields in the ANA_TOP_SPARE2 register
 */
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE2_M		0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE2_S		0U

/**
 * @brief The following are defines for the bit fields in the ANA_TOP_SPARE3 register
 */
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE3_M		0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE3_S		0U

/**
 * @brief The following are defines for the bit fields in the ANA_TOP_SPARE4 register
 */
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE4_M		0xFFFFFFFFU
#define ANA_SYSCTRL_PARA_ANA_TOP_SPARE4_S		0U

/**
 * @brief The following are defines for the bit fields in the ADCA_BUFDAC2ADC_LPEN register
 */
#define ANA_SYSCTRL_PARA_ADCA_BUFDAC2ADC_LPEN	0x00000001U

/**
 * @brief The following are defines for the bit fields in the ADCC_BUFDAC2ADC_LPEN register
 */
#define ANA_SYSCTRL_PARA_ADCC_BUFDAC2ADC_LPEN	0x00000001U

/**
 * @brief The following are defines for the bit fields in the ADC_L2H_CFG register
 */
#define ANA_SYSCTRL_PARA_ADC_L2H_CFG	0x00000001U

/**
 * @brief The following are defines for the bit fields in the CMP_MX_EN register
 */
#define ANA_SYSCTRL_PARA_CMPX_LN_EN_M		0x1U
#define ANA_SYSCTRL_PARA_CMPX_LP_EN_M		0x2U
#define ANA_SYSCTRL_PARA_CMPX_HN_EN_M		0x4U
#define ANA_SYSCTRL_PARA_CMPX_HP_EN_M		0x8U
#define ANA_SYSCTRL_PARA_CMPMUX_STEP		4U

/**
 * @brief The following are defines for the bit fields in the CMP_MUX_IO_EN register
 */
#define ANA_SYSCTRL_PARA_CMP_MUX_IO_EN	0x00000001

/**
 * @brief The following are defines for the bit fields in the CMP1DACCTL register
 */
#define ANA_SYSCTRL_PARA_CMP1_DACL_GAIN			0x00000001
#define ANA_SYSCTRL_PARA_CMP1_DACL_BUF_HIZ_EN	0x00000002
#define ANA_SYSCTRL_PARA_CMP1_DACL_BUF_EN		0x00000004
#define ANA_SYSCTRL_PARA_CMP1_DACH_GAIN			0x00010000
#define ANA_SYSCTRL_PARA_CMP1_DACH_BUF_HIZ_EN	0x00020000
#define ANA_SYSCTRL_PARA_CMP1_DACH_BUF_EN		0x00040000

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

/**
 * \brief   add brief
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

 #ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_HW_ANA_SYSCTRL_PARA_H_ */
