/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_cmpss.h
*   @brief   
*   @details
*
*/
#ifndef DEVICE_DRIVERLIB_HW_CMPSS_H_
#define DEVICE_DRIVERLIB_HW_CMPSS_H_

#ifdef __cplusplus
extern "C"{
#endif

/*
 * Include Files
 */
#include "inc/hw_types.h"

/*
 * @brief The following are defines for the CMPSS register offsets
 */
#if IS_GS32F00xx(0x12)
#define CMPSS_O_COMPCTL           0x0U	// CMPSS Comparator Control Register
#define CMPSS_O_COMPHYSCTL        0x2U	// CMPSS Comparator Hysteresis Control Register
#define CMPSS_O_COMPSTS           0x4U  // CMPSS Comparator Status Register
#define CMPSS_O_COMPSTSCLR        0x6U  // CMPSS Comparator Status Clear Register
#define CMPSS_O_COMPDACCTL        0x8U  // CMPSS DAC Control Register
#define CMPSS_O_DACHVALS          0xCU  // CMPSS High DAC Value Shadow Register
#define CMPSS_O_DACHVALA          0xEU	// CMPSS High DAC Value Active Register
#define CMPSS_O_RAMPMAXREFA       0x10U	// CMPSS Ramp Max Reference Active Register
#define CMPSS_O_RAMPMAXREFS       0x14U // CMPSS Ramp Max Reference Shadow Register
#define CMPSS_O_RAMPDECVALA       0x18U // CMPSS Ramp Decrement Value Active Register
#define CMPSS_O_RAMPDECVALS       0x1CU // CMPSS Ramp Decrement Value Shadow Register
#define CMPSS_O_RAMPSTS           0x20U // CMPSS Ramp Status Register
#define CMPSS_O_DACLVALS          0x24U // CMPSS Low DAC Value Shadow Register
#define CMPSS_O_DACLVALA          0x26U // CMPSS Low DAC Value Active Register
#define CMPSS_O_RAMPDLYA          0x28U // CMPSS Ramp Delay Active Register
#define CMPSS_O_RAMPDLYS          0x2AU // CMPSS Ramp Delay Shadow Register
#define CMPSS_O_CTRIPLFILCTL      0x2CU // CTRIPL Filter Control Register
#define CMPSS_O_CTRIPLFILCLKCTL   0x2EU // CTRIPL Filter Clock Control Register
#define CMPSS_O_CTRIPHFILCTL      0x30U // CTRIPH Filter Control Register
#define CMPSS_O_CTRIPHFILCLKCTL   0x32U // CTRIPH Filter Clock Control Register
#define CMPSS_O_CMPSSLOCK 		  0x34U // CMPSS Lock Register
#define CMPSS_O_CMPHSETUPTIME     0x38U // CMPSS High Setup Time Register
#define CMPSS_O_CALIBOFFSETH      0x3CU //CALIBRATION Offset High Register
#define CMPSS_O_CMPLSETUPTIME     0x40U // CMPSS Low Setup Time Register
#define CMPSS_O_CALIBOFFSETL      0x44U //CALIBRATION Offset Low Register
#define CMPSS_O_ANACLKCFG         0x48U //ANA_CLOCK Configure Register
#define CMPSS_O_CALIBFSMSTATUS    0x4CU //CALIBRATION Current FSM Status Register
#define CMPSS_O_EPWMBLANKCTRL     0x50U //EPWMBLANK Signal Control Register
#define CMPSS_O_CMPDACCTL         0x54U //CMP internal DAC routing Control Register
#define CMPSS_O_DBG_CFG           0x5CU //Core Halt Signal Mask Configuration   1.2
#endif
/*
 * @brief The following are defines for the bit fields in the COMPCTL register
 */
#if IS_GS32F00xx(0x12)||IS_GS32F3xx(0x22)||IS_GS32F00xx(0x30)
#define CMPSS_COMPCTL_COMPHSOURCE      0x0001U	// High Comparator Source Select
#define CMPSS_COMPCTL_COMPHINV         0x0002U  // High Comparator Invert Select
#define CMPSS_COMPCTL_CTRIPHSEL_S      2U
#define CMPSS_COMPCTL_CTRIPHSEL_M      0x000CU  // High Comparator Trip Select
#define CMPSS_COMPCTL_CTRIPOUTHSEL_S   4U
#define CMPSS_COMPCTL_CTRIPOUTHSEL_M   0x0030U  // High Comparator Trip Output Select
#define CMPSS_COMPCTL_ASYNCHEN         0x0040U  // High Comparator Asynchronous Path Enable
#define CMPSS_COMPCTL_COMPLSOURCE      0x0100U  // Low Comparator Source Select
#define CMPSS_COMPCTL_COMPLINV         0x0200U  // Low Comparator Invert Select
#define CMPSS_COMPCTL_CTRIPLSEL_S      10U
#define CMPSS_COMPCTL_CTRIPLSEL_M      0x0C00U  // Low Comparator Trip Select
#define CMPSS_COMPCTL_CTRIPOUTLSEL_S   12U
#define CMPSS_COMPCTL_CTRIPOUTLSEL_M   0x3000U  // Low Comparator Trip Output Select
#define CMPSS_COMPCTL_ASYNCLEN         0x4000U  // Low Comparator Asynchronous Path Enable
#define CMPSS_COMPCTL_COMPDACE         0x8000U  // Comparator/DAC Enable

/*
 * @brief The following are defines for the bit fields in the COMPHYSCTL register
 */
#define CMPSS_COMPHYSCTL_COMPHYS_S   0U
#define CMPSS_COMPHYSCTL_COMPHYS_M   0x000FU   	// Comparator Hysteresis Trim

/*
 * @brief The following are defines for the bit fields in the COMPSTS register
 */
#define CMPSS_COMPSTS_COMPHSTS     	0x0001U     	// High Comparator Status
#define CMPSS_COMPSTS_COMPHLATCH_S	1U
#define CMPSS_COMPSTS_COMPHLATCH  	0x0002U     	// High Comparator Latched Status
#define CMPSS_COMPSTS_COMPLSTS_S	8U
#define CMPSS_COMPSTS_COMPLSTS     	0x0100U   	// Low Comparator Status
#define CMPSS_COMPSTS_COMPLLATCH_S	9U
#define CMPSS_COMPSTS_COMPLLATCH   	0x0200U   	// Low Comparator Latched Status

/*
 * @brief The following are defines for the bit fields in the COMPSTSCLR register
 */
#define CMPSS_COMPSTSCLR_HLATCHCLR    0x0002U	// High Comparator Latched Status Clear
#define CMPSS_COMPSTSCLR_HSYNCCLREN   0x0004U   // High Comparator EPWMSYNCPER Clear Enable
#define CMPSS_COMPSTSCLR_LLATCHCLR    0x0200U   // Low Comparator Latched Status Clear
#define CMPSS_COMPSTSCLR_LSYNCCLREN   0x0400U   // Low Comparator EPWMSYNCPER Clear Enable
#endif
/*
 * @brief The following are defines for the bit fields in the COMPDACCTL register
 */
#if IS_GS32F00xx(0x12)||IS_GS32F3xx(0x22)
#define CMPSS_COMPDACCTL_DACSOURCE       0x0001U	// DAC Source Control
#define CMPSS_COMPDACCTL_RAMPSOURCE_S    1U
#define CMPSS_COMPDACCTL_RAMPSOURCE_M    0x001EU    // Ramp Generator Source Control
#define CMPSS_COMPDACCTL_SELREF          0x0020U    // DAC Reference Select
#define CMPSS_COMPDACCTL_RAMPLOADSEL     0x0040U    // Ramp Load Select
#define CMPSS_COMPDACCTL_SWLOADSEL       0x0080U    // Software Load Select
#define CMPSS_COMPDACCTL_BLANKSOURCE_S   8U
#define CMPSS_COMPDACCTL_BLANKSOURCE_M   0x0F00U    // EPWMBLANK Source Select
#define CMPSS_COMPDACCTL_BLANKEN         0x1000U    // EPWMBLANK Enable
#define CMPSS_COMPDACCTL_FREESOFT_S      14U
#define CMPSS_COMPDACCTL_FREESOFT_M      0xC000U    // Free/Soft Emulation Bits

/*
 * @brief The following are defines for the bit fields in the DACHVALS register
 */
#define CMPSS_DACHVALS_DACVAL_S   0U
#define CMPSS_DACHVALS_DACVAL_M   0xFFFU   // DAC Value Control

/*
 * @brief The following are defines for the bit fields in the DACHVALA register
 */
#define CMPSS_DACHVALA_DACVAL_S   0U
#define CMPSS_DACHVALA_DACVAL_M   0xFFFU   // DAC Value Control

/*
 * @brief The following are defines for the bit fields in the RAMPMAXREFA register
 */
#define CMPSS_RAMPMAXREFA_RAMPMAXREF_M	0xFFFFU /* Ramp maximum reference active value */

/*
 * @brief The following are defines for the bit fields in the RAMPMAXREFS register
 */
#define CMPSS_RAMPMAXREFS_RAMPMAXREF_M	0xFFFFU /* Ramp maximum reference shadow value */

/*
 * @brief The following are defines for the bit fields in the RAMPDECVALA register
 */
#define CMPSS_RAMPDECVALA_RAMPDECVAL_M	0xFFFFU /* Ramp decrement value active */

/*
 * @brief The following are defines for the bit fields in the RAMPDECVALA register
 */
#define CMPSS_RAMPDECVALS_RAMPDECVAL_M	0xFFFFU /* Ramp decrement value shadow */

/*
 * @brief The following are defines for the bit fields in the RAMPSTS register
 */
#define CMPSS_RAMPSTS_RAMPVALUE_M		0xFFFFU /* Ramp value */

/*
 * @brief The following are defines for the bit fields in the DACLVALS register
 */
#define CMPSS_DACLVALS_DACVAL_S   0U
#define CMPSS_DACLVALS_DACVAL_M   0xFFFU   // DAC Value Control

/*
 * @brief The following are defines for the bit fields in the DACLVALA register
 */
#define CMPSS_DACLVALA_DACVAL_S   0U
#define CMPSS_DACLVALA_DACVAL_M   0xFFFU   // DAC Value Control

/*
 * @brief The following are defines for the bit fields in the RAMPDLYA register
 */
#define CMPSS_RAMPDLYA_DELAY_S   0U
#define CMPSS_RAMPDLYA_DELAY_M   0x1FFFU   // Ramp Delay Value

/*
 * @brief The following are defines for the bit fields in the RAMPDLYS register
 */
#define CMPSS_RAMPDLYS_DELAY_S   0U
#define CMPSS_RAMPDLYS_DELAY_M   0x1FFFU   // Ramp Delay Value

/*
 * @brief The following are defines for the bit fields in the CTRIPLFILCTL register
 */
#define CMPSS_CTRIPLFILCTL_SAMPWIN_S   4U
#define CMPSS_CTRIPLFILCTL_SAMPWIN_M   0x1F0U    // Sample Window
#define CMPSS_CTRIPLFILCTL_THRESH_S    9U
#define CMPSS_CTRIPLFILCTL_THRESH_M    0x3E00U   // Majority Voting Threshold
#define CMPSS_CTRIPLFILCTL_FILINIT     0x8000U   // Filter Initialization Bit

/*
 * @brief The following are defines for the bit fields in the CTRIPLFILCLKCTL register
 */
#define CMPSS_CTRIPLFILCLKCTL_CLKPRESCALE_M		0xFFFFU

/*
 * @brief The following are defines for the bit fields in the CTRIPHFILCTL register
 */
#define CMPSS_CTRIPHFILCTL_SAMPWIN_S   4U
#define CMPSS_CTRIPHFILCTL_SAMPWIN_M   0x1F0U    // Sample Window
#define CMPSS_CTRIPHFILCTL_THRESH_S    9U
#define CMPSS_CTRIPHFILCTL_THRESH_M    0x3E00U   // Majority Voting Threshold
#define CMPSS_CTRIPHFILCTL_FILINIT     0x8000U   // Filter Initialization Bit

/*
 * @brief The following are defines for the bit fields in the CTRIPHFILCLKCTL register
 */
#define CMPSS_CTRIPHFILCLKCTL_CLKPRESCALE_M		0xFFFFU

/*
 * @brief The following are defines for the bit fields in the COMPLOCK register
 */
#define CMPSS_COMPLOCK_COMPCTL      0xFFFFFFFFU
#define CMPSS_COMPLOCK_DEFAULT		0x5A5A5A5AU

/*
 * @brief The following are defines for the bit fields in the CMPHSETUPTIME register
 */
#define CMPSS_CMPHSETUPTIME_CMPHSETUPTIME_M	0xFFFFFFFFU

/*
 * @brief The following are defines for the bit fields in the CALIBOFFSETH register
 */
#define CMPSS_CALIBOFFSETH_CALIBOFFSETH_M	0x00001FFFU
#define CMPSS_CALIBOFFSETH_OFFSETHEN_S 		13U
#define CMPSS_CALIBOFFSETH_OFFSETHEN_M 		0x00002000U
#define CMPSS_CALIBOFFSETH_CAL_START_H_S 	14U
#define CMPSS_CALIBOFFSETH_CAL_START_H_M 	0x00004000U


/*
 * @brief The following are defines for the bit fields in the CMPLSETUPTIME register
 */
#define CMPSS_CMPLSETUPTIME_CMPLSETUPTIME_M	0xFFFFFFFFU

/*
 * @brief The following are defines for the bit fields in the CALIBOFFSETL register
 */
#define CMPSS_CALIBOFFSETL_CALIBOFFSETL_M	0x00001FFFU
#define CMPSS_CALIBOFFSETL_OFFSETLEN_S		13U
#define CMPSS_CALIBOFFSETL_OFFSETLEN_M		0x00002000U
#define CMPSS_CALIBOFFSETL_CAL_START_L_S	14U
#define CMPSS_CALIBOFFSETL_CAL_START_L_M	0x00004000U

/*
 * @brief The following are defines for the bit fields in the ANACLKCFG register
 */
#define CMPSS_ANACLKCFG_ANACLKDIV_M		0x0000FFFFU
#define CMPSS_ANACLKCFG_ANACLKPHADLY_S	16U
#define CMPSS_ANACLKCFG_ANACLKPHADLY_M	0xFFFF0000U

/*
 * @brief The following are defines for the bit fields in the CALIBFSMSTATUS register
 */
#define CMPSS_CALIBFSMSTATUS_CMPLFSM_STS_M	0x000000FFU
#define CMPSS_CALIBFSMSTATUS_CMPHFSM_STS_S	8U
#define CMPSS_CALIBFSMSTATUS_CMPHFSM_STS_M	0x0000FF00U

/*
 * @brief The following are defines for the bit fields in the EPWMBLANKCTRL register
 */
#define CMPSS_EPWMBLANKCTRL_BLACK_INV_M		0x00000001U
#endif
/*
 * @brief The following are defines for the bit fields in the CMPDACCTRL register
 */
#if IS_GS32F00xx(0x12)
#define CMPSS_CMPDACCTRL_LPSRC_S      0U   // LP signal source
#define CMPSS_CMPDACCTRL_LPSRC_M      0x00000001U   // LP signal source
#define CMPSS_CMPDACCTRL_LCLKDLY_S    1U   // Low inner DAC input clock delay
#define CMPSS_CMPDACCTRL_LCLKDLY_M    0x00000006U   // Low inner DAC input clock delay
#define CMPSS_CMPDACCTRL_HPSRC_S      16U   // HP signal source
#define CMPSS_CMPDACCTRL_HPSRC_M      0x00010000U   // HP signal source
#define CMPSS_CMPDACCTRL_HCLKDLY_S    17U   // How inner DAC input clock delay
#define CMPSS_CMPDACCTRL_HCLKDLY_M    0x00060000U   // How inner DAC input clock delay

/*
 * @brief The following are defines for the bit fields in the DBG_CFG register
 */
#define CMPSS_DBG_CFG_ARM_MASK_M	0x01U
#define CMPSS_DBG_CFG_DSP_MASK_S	1U
#define CMPSS_DBG_CFG_DSP_MASK_M    0x02U
#endif


#if IS_GS32F3xx(0x22)
#define CMPSS_O_COMPCTL           0x0U	// CMPSS Comparator Control Register
#define CMPSS_O_COMPHYSCTL        0x2U	// CMPSS Comparator Hysteresis Control Register
#define CMPSS_O_COMPSTS           0x4U  // CMPSS Comparator Status Register
#define CMPSS_O_COMPSTSCLR        0x6U  // CMPSS Comparator Status Clear Register
#define CMPSS_O_COMPDACCTL        0x8U  // CMPSS DAC Control Register
#define CMPSS_O_COMPDACCTL2       0xAU  // CMPSS inner DAC Control Register 2       2.2
#define CMPSS_O_DACHVALS          0xCU  // CMPSS High DAC Value Shadow Register
#define CMPSS_O_DACHVALA          0xEU	// CMPSS High DAC Value Active Register
#define CMPSS_O_RAMPMAXREFA       0x10U	// CMPSS Ramp Max Reference Active Register
#define CMPSS_O_RAMPMAXREFS       0x14U // CMPSS Ramp Max Reference Shadow Register
#define CMPSS_O_RAMPDECVALA       0x18U // CMPSS Ramp Decrement Value Active Register
#define CMPSS_O_RAMPDECVALS       0x1CU // CMPSS Ramp Decrement Value Shadow Register
#define CMPSS_O_RAMPSTS           0x20U // CMPSS Ramp Status Register
#define CMPSS_O_DACLVALS          0x24U // CMPSS Low DAC Value Shadow Register
#define CMPSS_O_DACLVALA          0x26U // CMPSS Low DAC Value Active Register
#define CMPSS_O_RAMPDLYA          0x28U // CMPSS Ramp Delay Active Register
#define CMPSS_O_RAMPDLYS          0x2AU // CMPSS Ramp Delay Shadow Register
#define CMPSS_O_CTRIPLFILCTL      0x2CU // CTRIPL Filter Control Register
#define CMPSS_O_CTRIPLFILCLKCTL   0x2EU // CTRIPL Filter Clock Control Register
#define CMPSS_O_CTRIPHFILCTL      0x30U // CTRIPH Filter Control Register
#define CMPSS_O_CTRIPHFILCLKCTL   0x32U // CTRIPH Filter Clock Control Register
#define CMPSS_O_CMPSSLOCK 		  0x34U // CMPSS Lock Register
#define CMPSS_O_CMPHSETUPTIME     0x38U // CMPSS High Setup Time Register
#define CMPSS_O_CALIBOFFSETH      0x3CU //CALIBRATION Offset High Register
#define CMPSS_O_CMPLSETUPTIME     0x40U // CMPSS Low Setup Time Register
#define CMPSS_O_CALIBOFFSETL      0x44U //CALIBRATION Offset Low Register
#define CMPSS_O_ANACLKCFG         0x48U //ANA_CLOCK Configure Register
#define CMPSS_O_CALIBFSMSTATUS    0x4CU //CALIBRATION Current FSM Status Register
#define CMPSS_O_EPWMBLANKCTRL     0x50U //EPWMBLANK Signal Control Register
#define CMPSS_O_CMPDACCTL         0x54U //CMP internal DAC routing Control Register
#define CMPSS_O_CMPDAC_INL_TRIM   0x58U //Analog comparator inner DAC trim configuration 2.2
#define CMPSS_O_DBG_CFG           0x5CU //Core Halt Signal Mask Configuration




//COMPDACCTL2                                  2.2
#define CMPSS_COMPDACCTL2_BLANKSOURCE_S  8U
#define CMPSS_COMPDACCTL2_BLANKSOURCE_M  0x100U
#define CMPSS_COMPDACCTL2_RAMPSOURCE_S   10U
#define CMPSS_COMPDACCTL2_RAMPSOURCE_M   0x400U



#define CMPSS_CMPDACCTRL_LPSRC_S      0U   // LP signal source
#define CMPSS_CMPDACCTRL_LPSRC_M      0x00000001U   // LP signal source
#define CMPSS_CMPDACCTRL_LCLKDLY_S    1U   // Low inner DAC input clock delay
#define CMPSS_CMPDACCTRL_LCLKDLY_M    0x00000006U   // Low inner DAC input clock delay
#define CMPSS_CMPDACCTRL_IDAC_LOFFSETTRIM_S 3U
#define CMPSS_CMPDACCTRL_IDAC_LOFFSETTRIM_M 0x7F8U
#define CMPSS_CMPDACCTRL_HPSRC_S      16U
#define CMPSS_CMPDACCTRL_HPSRC_M      0x10000U
#define CMPSS_CMPDACCTRL_HCLOCKDELAY_S 17U
#define CMPSS_CMPDACCTRL_HCLOCKDELAY_M 0x60000U
#define CMPSS_CMPDACCTRL_IDAC_HOFFSETTRIM_S 19U
#define CMPSS_CMPDACCTRL_IDAC_HOFFSETTRIM_M 0x7F80000U
/*
 * @brief The following are defines for the bit fields in the DBG_CFG register
 */
#define CMPSS_CMPDAC_INL_TRIM_DAC_L_INL_TRIM_S 0U
#define CMPSS_CMPDAC_INL_TRIM_DAC_L_INL_TRIM_M 0xFFFFU
#define CMPSS_CMPDAC_INL_TRIM_DAC_H_INL_TRIM_S 16U
#define CMPSS_CMPDAC_INL_TRIM_DAC_H_INL_TRIM_M 0xFFFF0000U



#define CMPSS_DBG_CFG_ARM_MASK_M	0x01U
#define CMPSS_DBG_CFG_DSP0_MASK_S	1U
#define CMPSS_DBG_CFG_DSP0_MASK_M    0x02U
#define CMPSS_DBG_CFG_DSP1_MASK_S	2U
#define CMPSS_DBG_CFG_DSP1_MASK_M    0x04U
#endif




#if IS_GS32F00xx(0x30)
#define CMPSS_O_COMPCTL           0x0U	// CMPSS Comparator Control Register
#define CMPSS_O_COMPHYSCTL        0x2U	// CMPSS Comparator Hysteresis Control Register
#define CMPSS_O_COMPSTS           0x4U  // CMPSS Comparator Status Register
#define CMPSS_O_COMPSTSCLR        0x6U  // CMPSS Comparator Status Clear Register
#define CMPSS_O_COMPDACHCTL       0x8U  // CMPSS DAC Control Register   1
#define CMPSS_O_COMPDACHCTL2      0xAU    //CMPSS High DAC Control Register 2
#define CMPSS_O_DACHVALS          0xCU  // CMPSS High DAC Value Shadow Register
#define CMPSS_O_DACHVALA          0xEU	// CMPSS High DAC Value Active Register
#define CMPSS_O_RAMPHREFA         0x10U	// CMPSS Ramp Max Reference Active Register    1111
#define CMPSS_O_RAMPHREFS         0x14U // CMPSS Ramp Max Reference Shadow Register      111
#define CMPSS_O_RAMPHSTEPVALA     0x18U // CMPSS Ramp Decrement Value Active Register   1
#define CMPSS_O_RAMPHCTLA         0x1AU //CMPSS High Ramp Control Active Register        1
#define CMPSS_O_RAMPHSTEPVALS     0x1CU // CMPSS Ramp Decrement Value Shadow Register    1
#define CMPSS_O_RAMPHCTLS         0x1EU //CMPSS High Ramp Control Active Register         1
#define CMPSS_O_RAMPHSTS          0x20U // CMPSS Ramp Status Register   1
#define CMPSS_O_DACLVALS          0x24U // CMPSS Low DAC Value Shadow Register
#define CMPSS_O_DACLVALA          0x26U // CMPSS Low DAC Value Active Register
#define CMPSS_O_RAMPHDLYA         0x28U // CMPSS Ramp Delay Active Register  1
#define CMPSS_O_RAMPHDLYS         0x2AU // CMPSS Ramp Delay Shadow Register   1
#define CMPSS_O_CTRIPLFILCTL      0x2CU // CTRIPL Filter Control Register
#define CMPSS_O_CTRIPLFILCLKCTL   0x2EU // CTRIPL Filter Clock Control Register
#define CMPSS_O_CTRIPHFILCTL      0x30U // CTRIPH Filter Control Register
#define CMPSS_O_CTRIPHFILCLKCTL   0x32U // CTRIPH Filter Clock Control Register
#define CMPSS_O_CMPSSLOCK		  0x34U // CMPSS Lock Register
#define CMPSS_O_DACHVALS2         0x38U // CMPSS High Setup Time Register  1
#define CMPSS_O_DACLVALS2         0x3AU//CMPSS Low DAC Value Shadow Register 2 1
#define CMPSS_O_COMPDACLCTL       0x48U//CMPSS Low DAC Control Register   1
#define CMPSS_O_COMPDACLCTL2      0x4AU//CMPSS Low DAC Control Register 2    1
#define CMPSS_O_RAMPLREFA         0x50U //EPWMBLANK Signal Control Register  1
#define CMPSS_O_RAMPLREFS         0x54U //CMP internal DAC routing Control Register  1
#define CMPSS_O_RAMPLSTEPVALA     0x58U//CMPSS Low Ramp Step Value Active Register 1
#define CMPSS_O_RAMPLCTLA         0x5AU//CMPSS Low Ramp Control Active Register    1
#define CMPSS_O_RAMPLSTEPVALS     0x5CU//CMPSS Low Ramp Step Value Shadow Register   1
#define CMPSS_O_RAMPLCTLS         0x5EU//CMPSS Low Ramp Control Active Register    1
#define CMPSS_O_RAMPLSTS          0x60U//CMPSS Low Ramp Status Register    1
#define CMPSS_O_RAMPLDLYA         0x68U//CMPSS Low Ramp Delay Active Register     1
#define CMPSS_O_RAMPLDLYS         0x6AU//CMPSS Low Ramp Delay Shadow Register   1
#define CMPSS_O_CTRIPLFILCLKCTL2  0x6EU//CTRIPL Filter Clock Control Register 2  1
#define CMPSS_O_CTRIPHFILCLKCTL2  0x72U//CTRIPH Filter Clock Control Register 2  1
#define CMPSS_O_CMPHSETUPTIME     0x100U//High Comparator Setup Time   1
#define CMPSS_O_CALIBOFFSETH      0x104U//High Comparator Calibration Register  1
#define CMPSS_O_CMPLSETUPTIME     0x108U//Low Comparator Setup Time   1
#define CMPSS_O_CALIBOFFSETL      0x10CU//Low Comparator Calibration Register  1
#define CMPSS_O_ANACLKCFG         0x110U//ANACLK Signal Frequency and Phase Delay Configuration  1
#define CMPSS_O_CALIBFSMSTATUS    0x114U//Calibration FSM Status Register   1
#define CMPSS_O_EPWMBLANKCTRL     0x118U//EPWMBLANK signal polarity configuration 1
#define CMPSS_O_CMPDACCTRL        0x11CU//Analog comparator and inner DAC configuration  1
#define CMPSS_O_DBG_CFG           0x124U//Core Halt Signal Mask Configuration   1
#define CMPSS_O_COMPHYSTCTL_TYPE0 0x128U//Comparator Hysteresis Control Register   1
#define CMPSS_O_CMPDACEN          0x12CU//CMPSS DACL Enable    1




/*
 * @brief The following are defines for the bit fields in the COMPDACCTL register
 */
#define CMPSS_COMPDACHCTL_DACSOURCE       0x0001U	// DAC Source Control
#define CMPSS_COMPDACHCTL_RAMPSOURCE_S    1U
#define CMPSS_COMPDACHCTL_RAMPSOURCE_M    0x001EU    // Ramp Generator Source Control
#define CMPSS_COMPDACHCTL_SELREF          0x0020U    // DAC Reference Select
#define CMPSS_COMPDACHCTL_RAMPLOADSEL     0x0040U    // Ramp Load Select
#define CMPSS_COMPDACHCTL_SWLOADSEL       0x0080U    // Software Load Select
#define CMPSS_COMPDACHCTL_BLANKSOURCE_S   8U
#define CMPSS_COMPDACHCTL_BLANKSOURCE_M   0x0F00U    // EPWMBLANK Source Select
#define CMPSS_COMPDACHCTL_BLANKEN         0x1000U    // EPWMBLANK Enable
#define CMPSS_COMPDACHCTL_RAMPDIR       0x2000U      //RAMP DIR
#define CMPSS_COMPDACHCTL_FREESOFT_S      14U
#define CMPSS_COMPDACHCTL_FREESOFT_M      0xC000U    // Free/Soft Emulation Bits


/*
 * @brief The following are defines for the bit fields in the COMPDACHCTL2 register
 */
#define CMPSS_COMPDACHCTL2_DEENABLE             0x0001U      //Diode Emulation mode enable.  1
#define CMPSS_COMPDACHCTL2_DEACTIVESEL_S        1U
#define CMPSS_COMPDACHCTL2_DEACTIVESEL_M        0x003EU     //DEACTIVE source select. This bit field determines which EPWMn.DEACTIVE is passed on as the DEACTIVE signal.
#define CMPSS_COMPDACHCTL2_BLANKSOURCEUSEL_S    8U
#define CMPSS_COMPDACHCTL2_BLANKSOURCEUSEL_M    0x0100U      //0: Selects EPWM1 to 16 as BLANK source for COMPH   1: Selects EPWM17 to 32 as BLANK source for COMPH
#define CMPSS_COMPDACHCTL2_RAMPSOURCEUSEL_S     10U
#define CMPSS_COMPDACHCTL2_RAMPSOURCEUSEL_M       0x0400U    //0: Selects EPWM1 to 16 as RAMP source for RAMPH 1: Selects EPWM17 to 32 as RAMP source for RAMPH
#define CMPSS_COMPDACHCTL2_XTRIGCFG_S           12U
#define CMPSS_COMPDACHCTL2_XTRIGCFG_M           0x3000U       //Ramp Generator Cross Trigger Configuration





/*
 * @brief The following are defines for the bit fields in the DACHVALS register
 */
#define CMPSS_DACHVALS_DACVAL_S   0U
#define CMPSS_DACHVALS_DACVAL_M   0xFFFU   // DAC Value Control

/*
 * @brief The following are defines for the bit fields in the DACHVALA register
 */
#define CMPSS_DACHVALA_DACVAL_S   0U
#define CMPSS_DACHVALA_DACVAL_M   0xFFFU   // DAC Value Control



/*
 * @brief The following are defines for the bit fields in the RAMPHREFA register
 */
#define CMPSS_RAMPHREFA_RAMPHREFA_M  0xFFFFU//1
/*
 * @brief The following are defines for the bit fields in the RAMPHREFS register
 */
#define CMPSS_RAMPHREFS_RAMPHREFS_M  0xFFFFU//1
/*
 * @brief The following are defines for the bit fields in the RAMPHSTEPVALA register
 */
#define CMPSS_RAMPHSTEPVALA_RAMPHSTEPVALA_M 0xFFFFU//111
/*
 * @brief The following are defines for the bit fields in the RAMPHCTLA register
 */
#define CMPSS_RAMPHCTLA_RAMPCLKDIV_M    0xFFFFU//111
/*
 * @brief The following are defines for the bit fields in the RAMPHSTEPVALS register
 */
#define CMPSS_RAMPHSTEPVALS_RAMPHSTEPVALS_M 0xFFFFU//111
/*
 * @brief The following are defines for the bit fields in the RAMPHCTLS register
 */
#define CMPSS_RAMPHCTLS_RAMPCLKDIVS_M    0xFFFFU//111
/*
 * @brief The following are defines for the bit fields in the RAMPHSTS register
 */
#define CMPSS_RAMPHSTS_RAMPHVALUE_M     0xFFFFU//111

/*
 * @brief The following are defines for the bit fields in the DACLVALS register
 */
#define CMPSS_DACLVALS_DACVAL_S   0U
#define CMPSS_DACLVALS_DACVAL_M   0xFFFU

/*
 * @brief The following are defines for the bit fields in the DACLVALA register
 */
#define CMPSS_DACLVALA_DACVAL_S   0U
#define CMPSS_DACLVALA_DACVAL_M   0xFFFU   //DAC Value Control
/*
 * @brief The following are defines for the bit fields in the RAMPHDLYA register
 */
#define CMPSS_RAMPHDLYA_DELAY_S  0U//1
#define CMPSS_RAMPHDLYA_DELAY_M  0x1FFFU //1
/*
 * @brief The following are defines for the bit fields in the RAMPHDLYS register
 */
#define CMPSS_RAMPHDLYS_DELAY_S  0U//1
#define CMPSS_RAMPHDLYS_DELAY_M  0x1FFFU //1

/*
 * @brief The following are defines for the bit fields in the CTRIPLFILCTL register
 */
#define CMPSS_CTRIPLFILCTL_FILTINSEL_S   0U  //1
#define CMPSS_CTRIPLFILCTL_FILTINSEL_M   0x07U  //Low filter Input Mux Select Bit 1
#define CMPSS_CTRIPLFILCTL_SAMPWIN_S   3U    //1   Sample Window
#define CMPSS_CTRIPLFILCTL_SAMPWIN_M   0x1F8U//1  Low filter sample window size. Number of samples to monitor is SAMPWIN+1.
#define CMPSS_CTRIPLFILCTL_THRESH_S    9U   //1 Majority Voting Threshold
#define CMPSS_CTRIPLFILCTL_THRESH_M    0x7E00U//Low filter majority voting threshold. At least THRESH samples of the opposite state must appear within the sample window in order for the output to change state. Threshold used is THRESH+1.1
#define CMPSS_CTRIPLFILCTL_FILINIT     0x8000U   //Low filter initialization.

/*
 * @brief The following are defines for the bit fields in the CTRIPLFILCLKCTL register
 */
#define CMPSS_CTRIPLFILCLKCTL_CLKPRESCALE_M		0xFFFFU

/*
 * @brief The following are defines for the bit fields in the CTRIPHFILCTL register
 */
#define CMPSS_CTRIPHFILCTL_FILTINSEL_S   0U   //1
#define CMPSS_CTRIPHFILCTL_FILTINSEL_M   0x07U    //1 Sample Window
#define CMPSS_CTRIPHFILCTL_SAMPWIN_S    3U    //1
#define CMPSS_CTRIPHFILCTL_SAMPWIN_M    0x1F8U   //1 Majority Voting Threshold
#define CMPSS_CTRIPHFILCTL_THRESH_S     9U   // 1Filter Initialization Bit
#define CMPSS_CTRIPHFILCTL_THRESH_M     0x7E00//1
#define CMPSS_CTRIPHFILCTL_FILINIT     0x8000U //1 High filter initialization.
/*
 * @brief The following are defines for the bit fields in the CTRIPHFILCLKCTL register
 */
#define CMPSS_CTRIPHFILCLKCTL_CLKPRESCALE_M		0xFFFFU

/*
 * @brief The following are defines for the bit fields in the COMPLOCK register
 */
#define CMPSS_COMPLOCK_COMPCTL      0xFFFFFFFFU
#define CMPSS_COMPLOCK_DEFAULT		0x5A5A5A5AU




/*
 * @brief The following are defines for the bit fields in the DACHVALS2 register
 */
#define CMPSS_DACHVALS2_DACVAL_S 0U//1
#define CMPSS_DACHVALS2_DACVAL_M 0xFFFU//1
/*
 * @brief The following are defines for the bit fields in the DACLVALS2 register
 */
#define CMPSS_DACLVALS2_DACVAL_S 0U//1
#define CMPSS_DACLVALS2_DACVAL_M 0xFFFU//1
/*
 * @brief The following are defines for the bit fields in the COMPDACLCTL register
 */
#define CMPSS_COMPDACLCTL_DACSOURCE 0x01U//1   DACL source select. Determines whether DACLVALA is updated from DACLVALS or from the low ramp generator.
#define CMPSS_COMPDACLCTL_RAMPSOURCE_S 1U//1
#define CMPSS_COMPDACLCTL_RAMPSOURCE_M 0x1EU//1    EPWMSYNCPER source select. Determines which EPWMnSYNCPER signal is used within the CMPSS module.
#define CMPSS_COMPDACLCTL_RAMPLOADSEL   0x40U//1
#define CMPSS_COMPDACLCTL_BLANKSOURCE_S  8U//1
#define CMPSS_COMPDACLCTL_BLANKSOURCE_M  0xF00U//1    EPWMBLANK source select.
#define CMPSS_COMPDACLCTL_BLANKEN       0x1000U//1
#define CMPSS_COMPDACLCTL_RAMPDIR       0x2000U// RAMP DIR SELECT
/*
 * @brief The following are defines for the bit fields in the COMPDACLCTL2 register
 */
#define CMPSS_COMPDACLCTL2_BLANKSOURCEUSEL_S 8U
#define CMPSS_COMPDACLCTL2_BLANKSOURCEUSEL_M  0x100U//1    0: Selects EPWM1 to 16 as BLANK source for COMPL 1: Selects EPWM17 to 32 as BLANK source for COMPL
#define CMPSS_COMPDACLCTL2_RAMPSOURCEUSEL_S  10
#define CMPSS_COMPDACLCTL2_RAMPSOURCEUSEL_M   0x400U//1   0: Selects EPWM1 to 16 as RAMP source for RAMPL 1: Selects EPWM17 to 32 as RAMP source for RAMPL


/*
 * @brief The following are defines for the bit fields in the RAMPLREFA register
 */
#define CMPSS_RAMPLREFA_RAMPLREFA_M 0xFFFFU   //1
/*
 * @brief The following are defines for the bit fields in the RAMPLREFS register
 */
#define CMPSS_RAMPLREFS_RAMPLREFS_M 0xFFFFU     //1
/*
 * @brief The following are defines for the bit fields in the RAMPLSTEPVALA register
 */
#define CMPSS_RAMPLSTEPVALA_RAMPLSTEPVALA_M 0xFFFFU     //1
/*
 * @brief The following are defines for the bit fields in the RAMPLCTLA register
 */
#define CMPSS_RAMPLCTLA_RAMPCLKDIV_M   0xFFFFU   //1
/*
 * @brief The following are defines for the bit fields in the RAMPLSTEPVALS register
 */
#define CMPSS_RAMPLSTEPVALS_RAMPLSTEPVALS_M 0xFFFFU   //1
/*
 * @brief The following are defines for the bit fields in the RAMPLCTLS register
 */
#define CMPSS_RAMPLCTLS_RAMPCLKDIV_M    0xFFFFU   //1
/*
 * @brief The following are defines for the bit fields in the RAMPLSTS register
 */
#define CMPSS_RAMPLSTS_RAMPLVALUE_M   0xFFFFU   //1
/*
 * @brief The following are defines for the bit fields in the RAMPLDLYA register
 */
#define CMPSS_RAMPLDLYA_DELAY_S   0U//1
#define CMPSS_RAMPLDLYA_DELAY_M   0x1FFFU//1
/*
 * @brief The following are defines for the bit fields in the RAMPLDLYS register
 */
#define CMPSS_RAMPLDLYS_DELAY_S  0U//1
#define CMPSS_RAMPLDLYS_DELAY_M  0x1FFFU//1
/*
 * @brief The following are defines for the bit fields in the CTRIPLFILCLKCTL2 register
 */
#define CMPSS_CTRIPLFILCLKCTL2_CLKPRESCALEU_M 0xFFFFU   //1
/*
 * @brief The following are defines for the bit fields in the CTRIPLFILCLKCTL2 register
 */
#define CMPSS_CTRIPLFILCLKCTL2_CLKPRESCALEU_M 0xFFFFU   //1
/*
 * @brief The following are defines for the bit fields in the CMPHSETUPTIME register
 */
#define CMPSS_CMPHSETUPTIME_CMPHSETUPTIME_M   0xFFFFFFFFU
/*
 * @brief The following are defines for the bit fields in the CALIBOFFSETH register
 */
#define CMPSS_CALIBOFFSETH_CALIBOFFSETH_S     0U //1
#define CMPSS_CALIBOFFSETH_CALIBOFFSETH_M     0xFFFFU//1  High Comparator Offset Value
#define CMPSS_CALIBOFFSETH_OFFSETHEN       0x2000U //1  High Comparator Offset Enable
#define CMPSS_CALIBOFFSETH_CAL_START       0x4000U//1   High Compartor Calibration Start
/*
 * @brief The following are defines for the bit fields in the CMPLSETUPTIME register
 */
//#define CMPSS_CMPLSETUPTIME_CMPLSETUPTIME_S 0U//1
#define CMPSS_CMPLSETUPTIME_CMPLSETUPTIME_M 0xFFFFFFFFU //32WEI
/*
 * @brief The following are defines for the bit fields in the CALIBOFFSETL register
 */
#define CMPSS_CALIBOFFSETL_CALIBOFFSETL_S 0U//1        Low Comparator Offset Value
#define CMPSS_CALIBOFFSETL_CALIBOFFSETL_M 0xFFFFU//1
#define CMPSS_CALIBOFFSETL_OFFSETHEN      0x2000U//1  Low Comparator Offset Enable
#define CMPSS_CALIBOFFSETL_CAL_START      0x4000U//1  Low Calibration Start

/*
 * @brief The following are defines for the bit fields in the ANACLKCFG register
 */
#define CMPSS_ANACLKCFG_ANACLKDIV_S  0U//1
#define CMPSS_ANACLKCFG_ANACLKDIV_M  0xFFFFU//1  ANACLK period configuration
#define CMPSS_ANACLKCFG_ANACLKPHADLY_S  16U//1
#define CMPSS_ANACLKCFG_ANACLKPHADLY_M  0xFFFF0000U//1  ANACLK phase delay configuration

/*
 * @brief The following are defines for the bit fields in the CALIBFSMSTATUS register
 */
#define CMPSS_CALIBFSMSTATUS_CMPL_FSM_STATUS_S  0U//1
#define CMPSS_CALIBFSMSTATUS_CMPL_FSM_STATUS_M  0xFFU//1  Low Comparator Calibration Current FSM State Value
#define CMPSS_CALIBFSMSTATUS_CMPH_FSM_STATUS_S  8U//1
#define CMPSS_CALIBFSMSTATUS_CMPH_FSM_STATUS_M  0xFF00U//1  High Comparator Calibration Current FSM State Value:
/*
 * @brief The following are defines for the bit fields in the EPWMBLANKCTRL register
 */
#define CMPSS_EPWMBLANKCTRL_BLANK_INV    0x01U
/*
 * @brief The following are defines for the bit fields in the CMPDACCTRL register
 */
#define CMPSS_CMPDACCTRL_LCLOCKDELAY_S   1U//1
#define CMPSS_CMPDACCTRL_LCLOCKDELAY_M   0x06U//1  Low inner input dac  delay
#define CMPSS_CMPDACCTRL_HCLOCKDELAY_S   17U//1
#define CMPSS_CMPDACCTRL_HCLOCKDELAY_M   0x60000U//1   high inner input dac  delay
/*
 * @brief The following are defines for the bit fields in the DBG_CFG register
 */
#define CMPSS_DBG_CFG_DSP0_MASK_M    0x2U

/*
 * @brief The following are defines for the bit fields in the COMPHYSTCTL register
 */
//#define CMPSS_COMPHYSTCTL_TYPE0_COMPH_HYST_DISABLE_S 0U//1
#define CMPSS_COMPHYSTCTL_TYPE0_COMPH_HYST_DISABLE 0x01U//1  High Comparator Hysteresis disable.
//#define CMPSS_COMPHYSTCTL_TYPE0_COMPL_HYST_DISABLE_S 1U//1
#define CMPSS_COMPHYSTCTL_TYPE0_COMPL_HYST_DISABLE 0x02U//1  Low Comparator Hysteresis disable.

/*
 * @brief The following are defines for the bit fields in the CMPDACEN register
 */
//#define CMPSS_CMPDACEN_CMP_DACL_EN_S 0U//1
#define CMPSS_CMPDACEN_CMP_DACL_EN 0x01U//1        Comparator DACL enable
//#define CMPSS_CMPDACEN_CMP_DACH_EN_S 1U//1
#define CMPSS_CMPDACEN_CMP_DACH_EN 0x02U//1       Comparator DACH enable


#endif






#ifdef __cplusplus
}
#endif

#endif //DEVICE_DRIVERLIB_HW_CMPSS_H_
