#ifndef HW_DAC_H
#define HW_DAC_H

/*
 * @brief The following are defines for the DAC register offsets
 */
#define DAC_O_CTL			0x2U 	/* DAC Control Register                  */
#define DAC_O_VALA			0x4U   	/* DAC Value Register - Active           */
#define DAC_O_VALS			0x6U   	/* DAC Value Register - Shadow           */
#define DAC_O_OUTEN			0x8U   	/* DAC Output Enable Register            */
#define DAC_O_TRIM			0xCU    /*  DAC Trim Register                    */
#define DAC_O_CAL_EN		0x10U 	/* DAC Calibration Enable Register       */
#define DAC_O_EN			0x12U  	/* DAC Enable Register                   */
#define DAC_O_ANACLKCFG		0x14U	/* DAC Analog Frequency Select Register  */
#define DAC_O_SAFETY        0x18U   /* DAC Functional safety  register       */
#define DAC_O_SAFETY_EN     0x1CU   /* DAC Functional safety Enable register */
#define DAC_O_LOCK  		0x100U	/* DAC REGS LOCK Register 				 */

/*
 * @brief The following are defines for the bit fields in the DACCTL register
 */
#define DAC_CTL_DACREFSEL   0x0001U    /* DAC Reference Select */
#define DAC_CTL_MODE        0x0002U    /* DAC Mode Select      */
#define DAC_CTL_LOADMODE    0x0004U    /* DACVALA Load Mode    */
#define DAC_CTL_SYNCSEL_S   4U
#define DAC_CTL_SYNCSEL_M   0x00F0U   /* DAC EPWMSYNCPER Select */

/*
 * @brief The following are defines for the bit fields in the DACVALA register
 */
#define DAC_VALA_DACVALA_S   0U
#define DAC_VALA_DACVALA_M   0xFFFU	/* DAC Active Output Code */

/*
 * @brief The following are defines for the bit fields in the DACVALS register
 */
#define DAC_VALS_DACVALS_S   0U
#define DAC_VALS_DACVALS_M   0xFFFU	/* DAC Shadow Output Code */

/*
 * @brief The following are defines for the bit fields in the DACOUTEN register
 */
#define DAC_OUTEN_DACOUTEN   0x1U	/* DAC Output Code */

/*
 * @brief The following are defines for the bit fields in the DACEN register
 */
#define DAC_ENABLE			0x1U   /* DAC Enable Code */

/*
 * @brief The following are defines for the bit fields in the DAC_PHASE_DELAY register
 */
#define DAC_ANACLKCDG_ANACLK_DIV_M		0x0000FFFFU	/* ANACLK period configuration Mask */
#define DAC_ANACLKCDG_PHASE_DELAY_S     16U
#define DAC_ANACLKCDG_PHASE_DELAY_M     0xFFFF0000U	/* DAC Default Phase Delay Mask */

/*
 * @brief The following are defines for the bit fields in the DAC REGS LOCK  register
 */
#define DAC_REGS_LOCK_M		0xFFFFFFFFU
#define DAC_REGS_LOCKVALUE	0x5A5A5A5AU

#endif
