/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_dma.h
*   @brief   DMA registers definitions
*
*/
/*
 * commit history
 * 20240313, LYF, verify for chip 3.0
 * 20240319, LYF, Organize DMA and DMAMUX driver version management
 * 20240322, LYF, translate source files to C source, ASCII text.
 * 20240612, LYF, fix cache issue and channel nums for chip 3.0
 * 20240617, LYF, add G5 DMA feature for chip 3.0 
 * 20240621, LYF, add block offset and block cnt feature for chip 3.0 
 * 20240626, LYF, update change from ip for chip3.0 
 */


#ifndef DEVICE_DRIVERLIB_HW_DMA_H_
#define DEVICE_DRIVERLIB_HW_DMA_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "gs32_version.h"

#include "inc/hw_types.h"
#include "hw_memmap.h"

/* ========================================================================== */
/*                          Version defs                                      */
/* ========================================================================== */
//*****************************************************************************
//
//! The following are defines for the AHB DMAC VERSION.
//
//*****************************************************************************


#ifdef DMAC_VERSION
#undef DMAC_VERSION
#endif 

#if IS_GS32F00xx(0x12)

#define DMAC_VERSION            (0x12)

#elif IS_GS32F00xx(0x30)

#define DMAC_VERSION            (0x30)

#else

#define DMAC_VERSION            (0xFF)  // Not support.

#endif


 //*****************************************************************************
 //
 //! The following are defines for the AHB DMAC PORT NUMS.
 //
 //*****************************************************************************

#ifdef DMAC_NUMS
#undef DMAC_NUMS
#endif 

#if IS_GS32F00xx(0x30)

#define DMAC_NUMS              (1U)

#else

#define DMAC_NUMS              (2U)

#endif  

 //*****************************************************************************
 //
 //! The following are defines for the AHB DMAC Channels in each port.
 //
 //*****************************************************************************

#ifdef DMAC_CHNLS
#undef DMAC_CHNLS
#endif 

#if IS_GS32F00xx(0x30)

#define DMAC_CHNLS              (6U)

#else

#define DMAC_CHNLS              (8U)

#endif  


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define DMA_O_SAR                     0x0
#define DMA_O_DAR                     0x8
#define DMA_O_CTL                     0x18
#define DMA_O_CFG                     0x40
#define DMA_O_SGR                     0x48
#define DMA_O_DSR                     0x50
#define DMA_O_RAWTFR                  0x2C0
#define DMA_O_RAWBLOCK                0x2C8
#define DMA_O_RAWSRCTRAN              0x2D0
#define DMA_O_RAWDSTTRAN              0x2D8
#define DMA_O_RAWERR                  0x2E0
#define DMA_O_STATUSTFR               0x2E8
#define DMA_O_STATUSBLOCK             0x2F0
#define DMA_O_STATUSSRCTRAN           0x2F8
#define DMA_O_STATUSDSTTRAN           0x300
#define DMA_O_STATUSERR               0x308
#define DMA_O_MASKTFR                 0x310
#define DMA_O_MASKBLOCK               0x318
#define DMA_O_MASKSRCTRAN             0x320
#define DMA_O_MASKDSTTRAN             0x328
#define DMA_O_MASKERR                 0x330
#define DMA_O_CLEARTFR                0x338
#define DMA_O_CLEARBLOCK              0x340
#define DMA_O_CLEARSRCTRAN            0x348
#define DMA_O_CLEARDSTTRAN            0x350
#define DMA_O_CLEARERR                0x358
#define DMA_O_STATUSINT               0x360
#define DMA_O_REQSRCREG               0x368
#define DMA_O_REQDSTREG               0x370
#define DMA_O_SGLRQSRCREG             0x378
#define DMA_O_SGLRQDSTREG             0x380
#define DMA_O_LSTSRCREG               0x388
#define DMA_O_LSTDSTREG               0x390
#define DMA_O_DMACFGREG               0x398
#define DMA_O_CHENREG                 0x3A0
#define DMA_O_DMAIDREG                0x3A8
#define DMA_O_DMATESTREG              0x3B0
#define DMA_O_DMALPTIMEOUTREG         0x3B8

#define DMA_O_BOR_OFFSET              0x400
#define DMA_O_BLKCNT_OFFSET           0x408


#define DMA_O_MASKFDI                 0x680
#define DMA_O_STATUSFDI               0x688

#define DMA_CTL_INT_EN                0x01U
#define DMA_CTL_DST_TR_WIDTH          0xEU
#define DMA_CTL_SRC_TR_WIDTH          0x70U
#define DMA_CTL_DINC                  0x180U
#define DMA_CTL_DINC                  0x180U
#define DMA_CTL_DINC                  0x180U
#define DMA_CTL_SINC                  0x600U
#define DMA_CTL_DEST_MSIZE            0x3800U
#define DMA_CTL_SRC_MSIZE             0x1C000U
#define DMA_CTL_SRC_GATHER_EN         0x20000U
#define DMA_CTL_DST_SCATTER_EN        0x40000U
#define DMA_CTL_TT_FC                 0x700000U
#define DMA_CTL_BLOCK_TS              0xFFF00000000U
#define DMA_CTL_DONE                  0x100000000000U

#define DMA_CFG_CH_PRIOR              0xE0U
#define DMA_CFG_CH_SUSP               0x100U
#define DMA_CFG_FIFO_EMPTY            0x200U
#define DMA_CFG_HS_SEL_DST            0x400U
#define DMA_CFG_HS_SEL_SRC            0x800U
#define DMA_CFG_DST_HS_POL            0x40000U
#define DMA_CFG_SRC_HS_POL            0x80000U
#define DMA_CFG_RELOAD_SRC            0x40000000U
#define DMA_CFG_RELOAD_DST            0x80000000U
#define DMA_CFG_FCMODE                0x100000000U
#define DMA_CFG_FIFOMODE              0x200000000U
#define DMA_CFG_PROTCTL               0x1C00000000U
#define DMA_CFG_SRC_PER               0x8000000000U
#define DMA_CFG_DEST_PER              0x40000000000U

#define DMA_SGR_SGI_MASK              (0x000FFFFFU)
#define DMA_DSR_DSI_MASK              (0x000FFFFFU)
#if (DMAC_VERSION == 0x30)
#define DMA_SGR_SGC_MASK              (0x7FFFU)
#define DMA_DSR_DSC_MASK              (0x7FFFU)
#else
#define DMA_SGR_SGC_MASK              (0xFFF00000U)
#define DMA_DSR_DSC_MASK              (0xFFF00000U)
#endif

#define DMA_CLEARERR_CLEAR            0x01U

#define DMA_DMACFGREG_DMA_EN          0x01U

#define DMA_CHENREG_CH_EN             0x01U
#define DMA_CHENREG_CH_EN_WE          0x100U

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/*****************************************************************
 *    New definitions for DMA
 *****************************************************************/

/* DMA channel registers - 22 registers, size 0x58 */
typedef struct  {
    __IO uint32_t SAR;
    __IO uint32_t Reserved_0;
    __IO uint32_t DAR;
    __IO uint32_t Reserved_1;
    __IO uint32_t LLP;
    __IO uint32_t Reserved_2;
    __IO uint32_t CTRL_L;
    __IO uint32_t CTRL_H;
    __IO uint32_t SSTAT;
    __IO uint32_t Reserved_3;
    __IO uint32_t DSTAT;
    __IO uint32_t Reserved_4;
    __IO uint32_t SSTATAR;
    __IO uint32_t Reserved_5;
    __IO uint32_t DSTATAR;
    __IO uint32_t Reserved_6;
    __IO uint32_t CFG_L;
    __IO uint32_t CFG_H;
    __IO uint32_t SGR_L;
    __IO uint32_t SGR_H;
    __IO uint32_t DSR_L;
    __IO uint32_t DSR_H;
} DMA_ChannelType;

/* Interrupt registers */
typedef struct {
    __IO uint32_t RawTfr_L;
    __IO uint32_t RawTfr_H;
    __IO uint32_t RawBlock_L;
    __IO uint32_t RawBlock_H;
    __IO uint32_t RawSrcTran_L;
    __IO uint32_t RawSrcTran_H;
    __IO uint32_t RawDstTran_L;
    __IO uint32_t RawDstTran_H;
    __IO uint32_t RawErr_L;
    __IO uint32_t RawErr_H;
    __IO uint32_t StatusTfr_L;
    __IO uint32_t StatusTfr_H;
    __IO uint32_t StatusBlock_L;
    __IO uint32_t StatusBlock_H;
    __IO uint32_t StatusSrcTran_L;
    __IO uint32_t StatusSrcTran_H;
    __IO uint32_t StatusDstTran_L;
    __IO uint32_t StatusDstTran_H;
    __IO uint32_t StatusErr_L;
    __IO uint32_t StatusErr_H;
    __IO uint32_t MaskTfr_L;
    __IO uint32_t MaskTfr_H;
    __IO uint32_t MaskBlock_L;
    __IO uint32_t MaskBlock_H;
    __IO uint32_t MaskSrcTran_L;
    __IO uint32_t MaskSrcTran_H;
    __IO uint32_t MaskDstTran_L;
    __IO uint32_t MaskDstTran_H;
    __IO uint32_t MaskErr_L;
    __IO uint32_t MaskErr_H;
    __IO uint32_t ClearTfr_L;
    __IO uint32_t ClearTfr_H;
    __IO uint32_t ClearBlock_L;
    __IO uint32_t ClearBlock_H;
    __IO uint32_t ClearSrcTran_L;
    __IO uint32_t ClearSrcTran_H;
    __IO uint32_t ClearDstTran_L;
    __IO uint32_t ClearDstTran_H;
    __IO uint32_t ClearErr_L;
    __IO uint32_t ClearErr_H;
    __IO uint32_t StatusInt_L;
    __IO uint32_t StatusInt_H;
} DMA_IntCtrlType;

/* Software_Handshake Registers */
typedef struct {
    __IO uint32_t ReqSrcReg;
    __IO uint32_t Reserved_0;
    __IO uint32_t ReqDstReg;
    __IO uint32_t Reserved_1;
    __IO uint32_t SglRqSrcReg;
    __IO uint32_t Reserved_2;
    __IO uint32_t SglRqDstcReg;
    __IO uint32_t Reserved_3;
    __IO uint32_t LstSrcReg;
    __IO uint32_t Reserved_4;
    __IO uint32_t LstDstReg;
    __IO uint32_t Reserved_5;
} DMA_SoftHandshakeType;

/* DMAC Miscellaneous Registers */
typedef struct {
    __IO uint32_t DmaCfgReg;
    __IO uint32_t Reserved_0;
    __IO uint32_t ChEnReg;
    __IO uint32_t Reserved_1;
    __IO uint32_t DmaLdReg;
    __IO uint32_t Reserved_2;
    __IO uint32_t DmaTestReg;
    __IO uint32_t Reserved_3;
    __IO uint32_t DmaLpTimeoutReg;
    __IO uint32_t Reserved_4;
    __IO uint32_t DmaCompParams[12];
    __IO uint32_t DmaCompsID;
    __IO uint32_t Reserved_5;
} DMA_MiscCfgType;

typedef struct {
    DMA_ChannelType Dma_Channels[8];    //offset is n*0x58=6*0x58= 0x210, max 8 channel
    DMA_IntCtrlType Dma_Interrupt;        //offset 0x02C0
    DMA_SoftHandshakeType Dma_SoftHandshake;    //offset 0x0368
    DMA_MiscCfgType    Dma_Misc;            //offset 0x0398
} DMA_Type;


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

/**
 * \brief   add brief
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */


#ifdef __cplusplus
}
#endif


#endif /* DEVICE_DRIVERLIB_DRV_INC_HW_DMA_H_ */
