/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_ecap.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_ECAP_H_
#define DEVICE_DRIVERLIB_HW_ECAP_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the ecap register offsets

// Active 32-bit counter register that is used as the capture time-base
// HR mode :
// 1) This register reads HRCOUNTER value and is not writable
// 2) can be reset using CTRFILTRESET
// 3) Its not synchronized to SYSCLK domain so reads may not be accurate
#define ECAP_O_TSCTR		0x00U
// Counter phase value register that can be programmed for phase
// lag/lead. This register CTRPHS is loaded into TSCTR upon either a
// SYNCI event or S/W force via a control bit. Used to achieve phase
// control synchronization with respect to other eCAP and EPWM timebases.
// This register is not applicable in HR mode.
#define ECAP_O_CTRPHS		0x04U
// This register can be loaded (written) by:
// - Time-Stamp counter value (TSCTR) during a capture event
// - Software - may be useful for test purposes or initialization
// - ARPD shadow register (CAP3) when used in APWM mode
#define ECAP_O_CAP1		0x08U
// This register can be loaded (written) by:
// - Time-Stamp ( counter value) during a capture event
// - Software - may be useful for test purposes
// - ACMP shadow register (CAP4) when used in APWM mode
#define ECAP_O_CAP2		0x0CU
// In CAP mode, this is a time-stamp capture register.
// In APWM mode, this is the period shadow (APRD) register. You can
// update the PWM period value through this register. CAP3 (APRD)
// shadows CAP1 in this mode.
#define ECAP_O_CAP3		0x10U
// In CAP mode, this is a time-stamp capture register.
// In APWM mode, this is the compare shadow (ACMP) register. You
// can update the PWM compare value via this register. CAP4 (ACMP)
// shadows CAP2 in this mode.
#define ECAP_O_CAP4		0x14U
// Capture input source select register
#define ECAP_O_ECCTL0		0x24U
// capture control register1
#define ECAP_O_ECCTL1		0x28U
// capture control register2
#define ECAP_O_ECCTL2		0x2AU
// capture interrupt enable register
#define ECAP_O_ECEINT		0x2CU
// capture flag register
#define ECAP_O_ECFLG		0x2EU
// capture interrupt clear register
#define ECAP_O_ECCLR		0x30U
// capture force register
#define ECAP_O_ECFRC		0x32U
//SYNC source select registe
#define ECAP_O_ECAPSYNCINSEL 0x3C


#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)

// High-Res Control Register
#define HRCAP_O_HRCTL        	0x100U
// High-Res Calibration Interrupt Enable Register
#define HRCAP_O_HRINTEN      	0x108U
// High-Res Calibration Interrupt Flag Register
#define HRCAP_O_HRFLG        	0x10CU
// High-Res Calibration Interrupt Clear Register
#define HRCAP_O_HRCLR        	0x110U
// High-Res Calibration Interrupt Force Register
#define HRCAP_O_HRFRC        	0x114U
// High-Res Calibration Period Register
#define HRCAP_O_HRCALPRD     	0x118U
// High-Res Calibration SYSCLK Counter Register
#define HRCAP_O_HRSYSCLKCTR  	0x11CU
// High-Res Calibration SYSCLK Capture Register
#define HRCAP_O_HRSYSCLKCAP  	0x120U
// High-Res Calibration HRCLK Counter Register
#define HRCAP_O_HRCLKCTR     	0x124U
// High-Res Calibration HRCLK Capture Register
#define HRCAP_O_HRCLKCAP     	0x128U
// DB_FILTER_CFG register
#define ECAP_O_DB_FILTER_CFG 	0x12CU

#define ECAP_O_DBG			0x130

#elif IS_GS32F00xx(0x30)

// High-Res Control Register
#define HRCAP_O_HRCTL        	0x40U
// High-Res Calibration Interrupt Enable Register
#define HRCAP_O_HRINTEN     	0x48U
// High-Res Calibration Interrupt Flag Register
#define HRCAP_O_HRFLG         	0x4CU
// High-Res Calibration Interrupt Clear Register
#define HRCAP_O_HRCLR         	0x50U
// High-Res Calibration Interrupt Force Register
#define HRCAP_O_HRFRC         	0x54U
// High-Res Calibration Period Register
#define HRCAP_O_HRCALPRD      	0x58U
// High-Res Calibration SYSCLK Counter Register
#define HRCAP_O_HRSYSCLKCTR   	0x5CU
// High-Res Calibration SYSCLK Capture Register
#define HRCAP_O_HRSYSCLKCAP   	0x60U
// High-Res Calibration HRCLK Counter Register
#define HRCAP_O_HRCLKCTR      	0x64U
// High-Res Calibration HRCLK Capture Register
#define HRCAP_O_HRCLKCAP      	0x68U




#define ECAP_O_MUNIT_COMMON_CTL          0x80U    // Control registers for monitoring unit {#}
#define ECAP_O_MUNIT_1_CTL               0xC0U   // Control registers for monitoring unit 1
#define ECAP_O_MUNIT_1_SHADOW_CTL        0xC4U   // Shadow control registers for monitoring unit 1
#define ECAP_O_MUNIT_1_MIN               0xD0U   // Min value for monitoring unit 1
#define ECAP_O_MUNIT_1_MAX               0xD4U   // Max value for monitoring unit 1
#define ECAP_O_MUNIT_1_MIN_SHADOW        0xD8U   // Shadow register for Min value of monitoring
                                                 // unit 1
#define ECAP_O_MUNIT_1_MAX_SHADOW        0xDCU   // Shadow register for Max value of monitoring
                                                 // unit 1
#define ECAP_O_MUNIT_1_DEBUG_RANGE_MIN   0xE0U   // Observed Min value of check being enabled on
                                                 // minotoring unit 1
#define ECAP_O_MUNIT_1_DEBUG_RANGE_MAX   0xE4U   // Observed Max value of check being enabled on
                                                 // minotoring unit 1
#define ECAP_O_MUNIT_2_CTL               0x100U   // Control registers for monitoring unit 2
#define ECAP_O_MUNIT_2_SHADOW_CTL        0x104U   // Shadow control registers for monitoring unit 2
#define ECAP_O_MUNIT_2_MIN               0x110U   // Min value for monitoring unit 2
#define ECAP_O_MUNIT_2_MAX               0x114U   // Max value for monitoring unit 2
#define ECAP_O_MUNIT_2_MIN_SHADOW        0x118U   // Shadow register for Min value of monitoring
                                                 // unit 2
#define ECAP_O_MUNIT_2_MAX_SHADOW        0x11CU   // Shadow register for Max value of monitoring
                                                 // unit 2
#define ECAP_O_MUNIT_2_DEBUG_RANGE_MIN   0x120U   // Observed Min value of check being enabled on
                                                 // minotoring unit 2
#define ECAP_O_MUNIT_2_DEBUG_RANGE_MAX   0x124U   // Observed Max value of check being enabled on
                                                 // minotoring unit 2

#define ECAP_O_DBG_CFG                   0x130U

#define ECAP_O_ECAP_LOCK                 0x134U

#define ECAP_O_TSCTR_DIV                 0x138U

#define ECAP_O_CAP_FRAC                  0x13CU

#define ECAP_O_MUNIT_DEBUG_RANGE_FRAC    0x140U
#endif

// The following are defines for the bit fields in the TSCTR register by ecap

// time base counter in capture mode
#define ECAP_TSCTR_TSCTR_M		0XFFFFFFFFU
#define ECAP_TSCTR_TSCTR_S		0U

// The following are defines for the bit fields in the CTRPHS register by ecap

// load phase shift value
#define ECAP_CTRPHS_CTRPHS_M		0XFFFFFFFFU
#define ECAP_CTRPHS_CTRPHS_S		0U

// The following are defines for the bit fields in the CAP1 register by ecap

// time stamp capture in capture mode
// period or compare in apwm mode
#define ECAP_CAP1_CAP_M		0XFFFFFFFFU
#define ECAP_CAP1_CAP_S		0U

// The following are defines for the bit fields in the CAP2 register by ecap

// time stamp capture in capture mode
// period or compare in apwm mode
#define ECAP_CAP2_CAP_M		0XFFFFFFFFU
#define ECAP_CAP2_CAP_S		0U

// The following are defines for the bit fields in the CAP3 register by ecap

// time stamp capture in capture mode
// period or compare in apwm mode
#define ECAP_CAP3_CAP_M		0XFFFFFFFFU
#define ECAP_CAP3_CAP_S		0U

// The following are defines for the bit fields in the CAP4 register by ecap

// time stamp capture in capture mode
// period or compare in apwm mode
#define ECAP_CAP4_CAP_M		0XFFFFFFFFU
#define ECAP_CAP4_CAP_S		0U

// The following are defines for the bit fields in the ECCTL0 register by ecap
#if IS_GS32F3xx(0x22) || IS_GS32F00xx(0x12, 0x30)
// Capture input source select bits
// 0000000 capture input is ECAPxINPUT[0]
// 0000001 capture input is ECAPxINPUT[1]
// 0000010 capture input is ECAPxINPUT[2]
// ...
// 11111111 capture input is ECAPxINPUT[255]
#define ECAP_ECCTL0_INPUTSEL_M		0X1FFU
#define ECAP_ECCTL0_INPUTSEL_S		0U

#define ECAP_ECCTL0_QUALPRD		    0XF000U
#define ECAP_ECCTL0_SOCEVTSEL		0X30000U
#else


// Capture input source select bits
// 0000000 capture input is ECAPxINPUT[0]
// 0000001 capture input is ECAPxINPUT[1]
// 0000010 capture input is ECAPxINPUT[2]
// ...
// 1111111 capture input is ECAPxINPUT[127]
#define ECAP_ECCTL0_INPUTSEL_M		0X7FU
#define ECAP_ECCTL0_INPUTSEL_S		0U
#endif
// The following are defines for the bit fields in the ECCTL1 register by ecap

// Emulation Control
// Reset type: SYSRSn
// 0h (R/W) = TSCTR counter stops immediately on emulation suspend
// 1h (R/W) = TSCTR counter runs until = 0
// 2h (R/W) = TSCTR counter is unaffected by emulation suspend (Run Free)
// 3h (R/W) = TSCTR counter is unaffected by emulation suspend (Run Free)
#define ECAP_ECCTL1_FREE_SOFT_M		0XC000U
#define ECAP_ECCTL1_FREE_SOFT_S		14U
// Event Filter prescale select
// Reset type: SYSRSn
// 0h (R/W) = Divide by 1 (i.e,. no prescale, by-pass the prescaler)
// 1h (R/W) = Divide by 2
// 2h (R/W) = Divide by 4
// 3h (R/W) = Divide by 6
// 4h (R/W) = Divide by 8
// 5h (R/W) = Divide by 10
// 1Eh (R/W) = Divide by 60
// 1Fh (R/W) = Divide by 62
#define ECAP_ECCTL1_PRESCALE_M		0X3E00U
#define ECAP_ECCTL1_PRESCALE_S		9U
// Enable Loading of CAP1-4 registers on a capture event. Note that
// this bit does not disable CEVTn events from being generated.
// Reset type: SYSRSn
// 0h (R/W) = Disable CAP1-4 register loads at capture event time.
// 1h (R/W) = Enable CAP1-4 register loads at capture event time.
#define ECAP_ECCTL1_CAPLDEN		0X100U
// Counter Reset on Capture Event 4
// Reset type: SYSRSn
// 0h (R/W) = Do not reset counter on Capture Event 4 (absolute time stamp operation)
// 1h (R/W) = Reset counter after Capture Event 4 time-stamp has been captured (used in difference mode
// operation)
#define ECAP_ECCTL1_CTRRST4		0X80U
// Capture Event 4 Polarity select
// Reset type: SYSRSn
// 0h (R/W) = Capture Event 4 triggered on a rising edge (RE)
// 1h (R/W) = Capture Event 4 triggered on a falling edge (FE)
#define ECAP_ECCTL1_CAP4POL		0X40U
// Counter Reset on Capture Event 3
// Reset type: SYSRSn
// 0h (R/W) = Do not reset counter on Capture Event 3 (absolute time stamp operation)
// 1h (R/W) = Reset counter after Capture Event 3 time-stamp has been captured (used in difference mode
// operation)
#define ECAP_ECCTL1_CTRRST3		0X20U
// Capture Event 3 Polarity select
// Reset type: SYSRSn
// 0h (R/W) = Capture Event 3 triggered on a rising edge (RE)
// 1h (R/W) = Capture Event 3 triggered on a falling edge (FE)
#define ECAP_ECCTL1_CAP3POL		0X10U
// Counter Reset on Capture Event 2
// Reset type: SYSRSn
// 0h (R/W) = Do not reset counter on Capture Event 2 (absolute time stamp operation)
// 1h (R/W) = Reset counter after Capture Event 2 time-stamp has been captured (used in difference mode
// operation)
#define ECAP_ECCTL1_CTRRST2		0X8U
// Capture Event 2 Polarity select
// Reset type: SYSRSn
// 0h (R/W) = Capture Event 2 triggered on a rising edge (RE)
// 1h (R/W) = Capture Event 2 triggered on a falling edge (FE)
#define ECAP_ECCTL1_CAP2POL		0X4U
// Counter Reset on Capture Event 1
// Reset type: SYSRSn
// 0h (R/W) = Do not reset counter on Capture Event 1 (absolute time stamp operation)
// 1h (R/W) = Reset counter after Capture Event 1 time-stamp has been captured (used in difference mode
// operation)
#define ECAP_ECCTL1_CTRRST1		0X2U
// Capture Event 1 Polarity select
// Reset type: SYSRSn
// 0h (R/W) = Capture Event 1 triggered on a rising edge (RE)
// 1h (R/W) = Capture Event 1 triggered on a falling edge (FE)
#define ECAP_ECCTL1_CAP1POL		0X1U

// The following are defines for the bit fields in the ECCTL2 register by ecap

// This bit field reads current status on modulo counter
// 00b (R) = CAP1 register gets loaded on next capture event.
// 01b (R) = CAP2 register gets loaded on next capture event.
// 10b (R) = CAP3 register gets loaded on next capture event.
// 11b (R) = CAP4 register gets loaded on next capture event.
#define ECAP_ECCTL2_MODCNTRSTS_M		0XC000U
#define ECAP_ECCTL2_MODCNTRSTS_S		14U
// DMA event select
// 00b (R/W) = DMA interrupt source is CEVT1
// 01b (R/W) = DMA interrupt source is CEVT2
// 10b (R/W) = DMA interrupt source is CEVT3
// 11b (R/W) = DMA interrupt source is CEVT4
// Note: ECCTL1.CAPLDEN also needs to be set to "1" for ECAPxDMA_INT to be generated
#define ECAP_ECCTL2_DMAEVTSEL_M		0X3000U
#define ECAP_ECCTL2_DMAEVTSEL_S		12U
// Reset Bit
// 0h (R) = No effect
// 1h (W) = Resets event filter, counter, modulo counter and CEVT[1,2,3,4] and CNTOVF , HRERROR flags
// Note: This provides an ability start capture module from known state in case spurious inputs are captured
// while ECAP is configured.
#define ECAP_ECCTL2_CTRFILTRESET		0X800U
// APWM output polarity select. This is applicable only in APWM operating mode.
// Reset type: SYSRSn
// 0h (R/W) = Output is active high (Compare value defines high time)
// 1h (R/W) = Output is active low (Compare value defines low time)
#define ECAP_ECCTL2_APWMPOL		0X400U
// CAP/APWM operating mode select
// Reset type: SYSRSn
// 0h (R/W) = ECAP module operates in capture mode. This mode forces the following configuration:
// - Inhibits TSCTR resets via CTR = PRD event
// - Inhibits shadow loads on CAP1 and 2 registers
// - Permits user to enable CAP1-4 register load
// - CAPx/APWMx pin operates as a capture input
// 1h (R/W) = ECAP module operates in APWM mode. This mode forces the following configuration:
// - Resets TSCTR on CTR = PRD event (period boundary)
// - Permits shadow loading on CAP1 and 2 registers
// - Disables loading of time-stamps into CAP1-4 registers
// - CAPx/APWMx pin operates as a APWM output
#define ECAP_ECCTL2_CAP_APWM		0X200U
// Software-forced Counter (TSCTR) Synchronizer. This provides the user a method to generate a synchronization
// pulse through software.
// In APWM mode, the synchronization pulse can also be sourced from the CTR = PRD event.
// Reset type: SYSRSn
// 0h (R/W) = Writing a zero has no effect. Reading always returns a zero
// 1h (R/W) = Writing a one forces a TSCTR shadow load of current ECAP module and any ECAP modules down-stream
// providing the SYNCO_SEL bits are 0,0. After writing a 1, this bit returns to a zero.
// Note: Selection CTR = PRD is meaningful only in APWM mode however, you can choose it in CAP mode if you
// find doing so useful.
#define ECAP_ECCTL2_SWSYNC		0X100U
// Sync-Out Select
// Reset type: SYSRSn
// 0h (R/W) = sync out signal is SWSYNC. In apwm mode, writing to the shadow register takes effect immediately.
// 1h (R/W) = Select CTR = PRD event as the sync-out signal. In APWM mode, the value written to the shadow register takes effect after CTR = PRD.
// 2h (R/W) = Disable sync out signal
// 3h (R/W) = Disable sync out signal
#define ECAP_ECCTL2_SYNCO_SEL_M		0XC0U
#define ECAP_ECCTL2_SYNCO_SEL_S		6U
// Counter (TSCTR) Sync-In select mode
// Reset type: SYSRSn
// 0h (R/W) = Disable sync-in option
// 1h (R/W) = Enable counter (TSCTR) to be loaded from CTRPHS register upon either a SYNCI signal or a S/W
// force event.
#define ECAP_ECCTL2_SYNCI_EN		0X20U
// Time Stamp (TSCTR) Counter Stop (freeze) Control
// Reset type: SYSRSn
// 0h (R/W) = TSCTR stopped
// 1h (R/W) = TSCTR free-running
#define ECAP_ECCTL2_TSCTRSTOP		0X10U
// Re-Arming Control. Note: The re-arm function is valid in one shot or continuous mode
// Reset type: SYSRSn
// 0h (R/W) = Has no effect (reading always returns a 0)
// 1h (R/W) = Arms the one-shot sequence as follows:
// 1) Resets the Mod4 counter to zero
// 2) Unfreezes the Mod4 counter
// 3) Enables capture register loads
#define ECAP_ECCTL2_REARM		0X8U
// Stop value for one-shot mode. This is the number (between 1-4) of captures allowed to occur before the
// CAP(1-4) registers are frozen, that is, capture sequence is stopped.
// Wrap value for continuous mode. This is the number (between 1-4) of the capture register in which the
// circular buffer wraps around and starts again.
// Notes: STOP_WRAP is compared to Mod4 counter and, when equal, 2 actions occur:
// - Mod4 counter is stopped (frozen)
// - Capture register loads are inhibited
// In one-shot mode, further interrupt events are blocked until re-armed. In this mode if TSCCTR counter
// is configured to reset on capture event (CEVTx) by configuring ECCTL1.CTRRSTx bit, it will still keep
// resetting the TSCCTR counter on capture event (CEVTx) after the STOP_WRAP value is 
// reached and re-arm (REARM) has not occurred.
// Reset type: SYSRSn
// 0h (R/W) = Stop after Capture Event 1 in one-shot mode. Wrap after Capture Event 1 in continuous mode.
// 1h (R/W) = Stop after Capture Event 2 in one-shot mode. Wrap after Capture Event 2 in continuous mode.
// 2h (R/W) = Stop after Capture Event 3 in one-shot mode. Wrap after Capture Event 3 in continuous mode.
// 3h (R/W) = Stop after Capture Event 4 in one-shot mode. Wrap after Capture Event 4 in continuous mode.
#define ECAP_ECCTL2_STOP_WRAP_M		0X6U
#define ECAP_ECCTL2_STOP_WRAP_S		1U
// Continuous or one-shot mode control (applicable only in capture mode)
// Reset type: SYSRSn
// 0h (R/W) = Operate in continuous mode
// 1h (R/W) = Operate in one-Shot mode
#define ECAP_ECCTL2_CONT_ONESHT		0X1U



// The following are defines for the bit fields in the ECEINT register by ecap

// Counter Equal Compare Interrupt Enable
// Reset type: SYSRSn
// 0h (R/W) = Disable Compare Equal as an Interrupt source
// 1h (R/W) = Enable Compare Equal as an Interrupt source
#define ECAP_ECEINT_EINT_CTR_CMP		0X80U
// Counter Equal Period Interrupt Enable
// Reset type: SYSRSn
// 0h (R/W) = Disable Period Equal as an Interrupt source
// 1h (R/W) = Enable Period Equal as an Interrupt source
#define ECAP_ECEINT_EINT_CTR_PRD		0X40U
// Counter Overflow Interrupt Enable
// Reset type: SYSRSn
// 0h (R/W) = Disabled counter Overflow as an Interrupt source
// 1h (R/W) = Enable counter Overflow as an Interrupt source
#define ECAP_ECEINT_EINT_CTROVF		0X20U
// Capture Event 4 Interrupt Enable
// Reset type: SYSRSn
// 0h (R/W) = Disable Capture Event 4 as an Interrupt source
// 1h (R/W) = Capture Event 4 Interrupt Enable
#define ECAP_ECEINT_EINT_CEVT4		0X10U
// Capture Event 3 Interrupt Enable
// Reset type: SYSRSn
// 0h (R/W) = Disable Capture Event 3 as an Interrupt source
// 1h (R/W) = Capture Event 3 Interrupt Enable
#define ECAP_ECEINT_EINT_CEVT3		0X8U
// Capture Event 2 Interrupt Enable
// Reset type: SYSRSn
// 0h (R/W) = Disable Capture Event 2 as an Interrupt source
// 1h (R/W) = Capture Event 2 Interrupt Enable
#define ECAP_ECEINT_EINT_CEVT2		0X4U
// Capture Event 1 Interrupt Enable
// Reset type: SYSRSn
// 0h (R/W) = Disable Capture Event 1 as an Interrupt source
// 1h (R/W) = Capture Event 1 Interrupt Enable
#define ECAP_ECEINT_EINT_CEVT1		0X2U

#define ECAP_ECEINT_MUNIT_1_ERROR_EVT1   0x200U    // Monitoring unit 1 error event-1 interrupt
                                                   // enable
#define ECAP_ECEINT_MUNIT_1_ERROR_EVT2   0x400U    // Monitoring unit 1 error event-2 interrupt
                                                   // enable
#define ECAP_ECEINT_MUNIT_2_ERROR_EVT1   0x800U    // Monitoring unit 2 error event-1 interrupt
                                                   // enable
#define ECAP_ECEINT_MUNIT_2_ERROR_EVT2   0x1000U   // Monitoring unit 2 error event-2 interrupt
                                                   // enable


// The following are defines for the bit fields in the ECFLG register by ecap

// Counter Equal Compare Status Flag. This flag is active only in APWM mode.
// Reset type: SYSRSn
// 0h (R/W) = Indicates no event occurred
// 1h (R/W) = Indicates the counter (TSCTR) reached the compare register value (ACMP)
#define ECAP_ECFLG_FLG_CTR_CMP		0X80U
// Counter Equal Period Status Flag. This flag is only active in APWM mode.
// Reset type: SYSRSn
// 0h (R/W) = Indicates no event occurred
// 1h (R/W) = Indicates the counter (TSCTR) reached the period register value (APRD) and was reset.
#define ECAP_ECFLG_FLG_CTR_PRD		0X40U
// Counter Overflow Status Flag. This flag is active in CAP and APWM mode.
// Reset type: SYSRSn
// 0h (R/W) = Indicates no event occurred
// 1h (R/W) = Indicates the counter (TSCTR) has made the transition from FFFFFFFF to 00000000
#define ECAP_ECFLG_FLG_CTROVF		0X20U
// Capture Event 4 Status Flag This flag is only active in CAP mode.
// Reset type: SYSRSn
// 0h (R/W) = Indicates no event occurred
// 1h (R/W) = Indicates the fourth event occurred at ECAPx pin
#define ECAP_ECFLG_FLG_CEVT4		0X10U
// Capture Event 3 Status Flag This flag is only active in CAP mode.
// Reset type: SYSRSn
// 0h (R/W) = Indicates no event occurred
// 1h (R/W) = Indicates the third event occurred at ECAPx pin
#define ECAP_ECFLG_FLG_CEVT3		0X8U
// Capture Event 2 Status Flag This flag is only active in CAP mode.
// Reset type: SYSRSn
// 0h (R/W) = Indicates no event occurred
// 1h (R/W) = Indicates the second event occurred at ECAPx pin
#define ECAP_ECFLG_CEVT2		0X4U
// Capture Event 1 Status Flag This flag is only active in CAP mode.
// Reset type: SYSRSn
// 0h (R/W) = Indicates no event occurred
// 1h (R/W) = Indicates the first event occurred at ECAPx pin
#define ECAP_ECFLG_CEVT1		0X2U
// Global Interrupt Status Flag
// Reset type: SYSRSn
// 0h (R/W) = Indicates no event occurred
// 1h (R/W) = Indicates that an interrupt was generated.
#define ECAP_ECFLG_INT		0X1U
#define ECAP_ECFLG_MUNIT_1_ERROR_EVT1   0x200U    // Error event 2 Interrupt Flag from monitoring
                                                  // unit 1
#define ECAP_ECFLG_MUNIT_1_ERROR_EVT2   0x400U    // Error event 2 Interrupt Flag from monitoring
                                                  // unit 1
#define ECAP_ECFLG_MUNIT_2_ERROR_EVT1   0x800U    // Error event 2 Interrupt Flag from monitoring
                                                  // unit 2
#define ECAP_ECFLG_MUNIT_2_ERROR_EVT2   0x1000U   // Error event 2 Interrupt Flag from monitoring
                                                  // unit 2



// The following are defines for the bit fields in the ECCLR register by ecap

// Counter Equal Compare Status Clear
// Reset type: SYSRSn
// 0h (R/W) = Writing a 0 has no effect. Always reads back a 0
// 1h (R/W) = Writing a 1 clears the CTR=CMP flag.
#define ECAP_ECCLR_CTR_CMP		0X80U
// Counter Equal Period Status Clear
// Reset type: SYSRSn
// 0h (R/W) = Writing a 0 has no effect. Always reads back a 0
// 1h (R/W) = Writing a 1 clears the CTR=PRD flag.
#define ECAP_ECCLR_CTR_PRD		0X40U
// Counter Overflow Status Clear
// Reset type: SYSRSn
// 0h (R/W) = Writing a 0 has no effect. Always reads back a 0
// 1h (R/W) = Writing a 1 clears the CTROVF flag.
#define ECAP_ECCLR_CTROVF		0X20U
// Capture Event 4 Status Clear
// Reset type: SYSRSn
// 0h (R/W) = Writing a 0 has no effect. Always reads back a 0
// 1h (R/W) = Writing a 1 clears the CEVT4 flag.
#define ECAP_ECCLR_CEVT4		0X10U
// Capture Event 3 Status Clear
// Reset type: SYSRSn
// 0h (R/W) = Writing a 0 has no effect. Always reads back a 0
// 1h (R/W) = Writing a 1 clears the CEVT3 flag.
#define ECAP_ECCLR_CEVT3		0X8U
// Capture Event 2 Status Clear
// Reset type: SYSRSn
// 0h (R/W) = Writing a 0 has no effect. Always reads back a 0
// 1h (R/W) = Writing a 1 clears the CEVT2 flag.
#define ECAP_ECCLR_CEVT2		0X4U
// Capture Event 1 Status Clear
// Reset type: SYSRSn
// 0h (R/W) = Writing a 0 has no effect. Always reads back a 0
// 1h (R/W) = Writing a 1 clears the CEVT1 flag.
#define ECAP_ECCLR_CEVT1		0X2U
// ECAP Global Interrupt Status Clear
// Reset type: SYSRSn
// 0h (R/W) = Writing a 0 has no effect. Always reads back a 0
// 1h (R/W) = Writing a 1 clears the INT flag and enable further interrupts to be generated if any of the
// event flags are set to 1
#define ECAP_ECCLR_INT		0X1U
#define ECAP_ECCLR_MUNIT_1_ERROR_EVT1   0x200U    // Writing '1' clears MUNIT_1_ERROR_EVT1 interrupt flag
#define ECAP_ECCLR_MUNIT_1_ERROR_EVT2   0x400U    // Writing '1' clears MUNIT_1_ERROR_EVT2 interrupt flag
#define ECAP_ECCLR_MUNIT_2_ERROR_EVT1   0x800U    // Writing '1' clears MUNIT_2_ERROR_EVT1 interrupt flag
#define ECAP_ECCLR_MUNIT_2_ERROR_EVT2   0x1000U   // Writing '1' clears MUNIT_2_ERROR_EVT2 interrupt flag



// The following are defines for the bit fields in the ECFRC register by ecap

// Force Counter Equal Compare Interrupt. This event is only active in
// APWM mode.
// Reset type: SYSRSn
// 0h (R/W) = No effect. Always reads back a 0.
// 1h (R/W) = Writing a 1 sets the CTR_CMP flag.
#define ECAP_ECFRC_CTR_CMP		0X80U
// Force Counter Equal Period Interrupt. This event is only active in
// APWM mode.
// Reset type: SYSRSn
// 0h (R/W) = No effect. Always reads back a 0.
// 1h (R/W) = Writing a 1 sets the CTR_PRD flag.
#define ECAP_ECFRC_CTR_PRD		0X40U
// Force Counter Overflow
// Reset type: SYSRSn
// 0h (R/W) = No effect. Always reads back a 0.
// 1h (R/W) = Writing a 1 to this bit sets the CTROVF flag.
#define ECAP_ECFRC_CTROVF		0X20U
// Force Capture Event 4. This event is only active in CAP mode.
// Reset type: SYSRSn
// 0h (R/W) = No effect. Always reads back a 0.
// 1h (R/W) = Writing a 1 sets the CEVT4 flag.
#define ECAP_ECFRC_CEVT4		0X10U
// Force Capture Event 3. This event is only active in CAP mode.
// Reset type: SYSRSn
// 0h (R/W) = No effect. Always reads back a 0.
// 1h (R/W) = Writing a 1 sets the CEVT3 flag.
#define ECAP_ECFRC_CEVT3		0X8U
// Force Capture Event 2. This event is only active in CAP mode.
// Reset type: SYSRSn
// 0h (R/W) = No effect. Always reads back a 0.
// 1h (R/W) = Writing a 1 sets the CEVT2 flag.
#define ECAP_ECFRC_CEVT2		0X4U
// Force Capture Event 1. This event is only active in CAP mode.
// Reset type: SYSRSn
// 0h (R/W) = No effect. Always reads back a 0.
// 1h (R/W) = Writing a 1 sets the CEVT1 flag.
#define ECAP_ECFRC_CEVT1		0X2U
#define ECAP_ECFRC_MUNIT_1_ERROR_EVT1   0x200U    // Writing '1' sets MUNIT_1_ERROR_EVT1 interrupt flag
#define ECAP_ECFRC_MUNIT_1_ERROR_EVT2   0x400U    // Writing '1' sets MUNIT_1_ERROR_EVT2 interrupt flag
#define ECAP_ECFRC_MUNIT_2_ERROR_EVT1   0x800U    // Writing '1' sets MUNIT_2_ERROR_EVT1 interrupt flag
#define ECAP_ECFRC_MUNIT_2_ERROR_EVT2   0x1000U   // Writing '1' sets MUNIT_2_ERROR_EVT2 interrupt flag

#define ECAP_SYNCINSEL_M		0x1F

#define	ECAP_DBG_DSP_MASK_S		1U
#define	ECAP_DBG_DSP_MASK_M		0x2U

//*************************************************************************************************
//
// The following are defines for the bit fields in the HRCTL register
//
//*************************************************************************************************
#define HRCAP_HRCTL_HRE          0x1U    // High Resolution Enable
#define HRCAP_HRCTL_HRCLKE       0x2U    // High Resolution Clock Enable
#define HRCAP_HRCTL_PRDSEL       0x4U    // Calibration Period Match
#define HRCAP_HRCTL_CALIBSTART   0x8U    // Calibration start
#define HRCAP_HRCTL_CALIBSTS     0x10U   // Calibration status
#define HRCAP_HRCTL_CALIBCONT    0x20U   // Continuous mode Calibration Select

//*************************************************************************************************
//
// The following are defines for the bit fields in the HRINTEN register
//
//*************************************************************************************************
#define HRCAP_HRINTEN_CALIBDONE      0x2U   // Calibration doe interrupt enable
#define HRCAP_HRINTEN_CALPRDCHKSTS   0x4U   // Calibration period check status enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the HRFLG register
//
//*************************************************************************************************
#define HRCAP_HRFLG_CALIBINT       0x1U   // Global calibration Interrupt Status Flag
#define HRCAP_HRFLG_CALIBDONE      0x2U   // Calibration Done Interrupt Flag Bit
#define HRCAP_HRFLG_CALPRDCHKSTS   0x4U   // Calibration period check status Flag Bi

//*************************************************************************************************
//
// The following are defines for the bit fields in the HRCLR register
//
//*************************************************************************************************
#define HRCAP_HRCLR_CALIBINT       0x1U   // Clear Global calibration Interrupt Flag
#define HRCAP_HRCLR_CALIBDONE      0x2U   // Clear Calibration Done Interrupt Flag Bit
#define HRCAP_HRCLR_CALPRDCHKSTS   0x4U   // Clear Calibration period check status Flag Bit

//*************************************************************************************************
//
// The following are defines for the bit fields in the HRFRC register
//
//*************************************************************************************************
#define HRCAP_HRFRC_CALIBDONE      0x2U   // Force Calibration Done Interrupt Flag Bit
#define HRCAP_HRFRC_CALPRDCHKSTS   0x4U   // Force Calibration period check status Flag Bit

//*************************************************************************************************
//
// The following are defines for the bit fields in the MUNIT_COMMON_CTL register
//
//*************************************************************************************************
#define ECAP_MUNIT_COMMON_CTL_TRIPSEL_S      0U
#define ECAP_MUNIT_COMMON_CTL_TRIPSEL_M      0x7FU     // Trip signal select
#define ECAP_MUNIT_COMMON_CTL_GLDSTRBSEL_S   8U
#define ECAP_MUNIT_COMMON_CTL_GLDSTRBSEL_M   0x7F00U   // Global Load strobe select

//*************************************************************************************************
//
// The following are defines for the bit fields in the MUNIT_1_CTL register
//
//*************************************************************************************************
#define ECAP_MUNIT_1_CTL_EN                      0x1U     // Enable bit
#define ECAP_MUNIT_1_CTL_DEBUG_RANGE_EN          0x2U     // Debug enable to aquire the range of
                                                          // check being done
#define ECAP_MUNIT_1_CTL_DISABLE_EARLY_MAX_ERR   0x4U     // Disable early max error check
#define ECAP_MUNIT_1_CTL_MON_SEL_S               8U
#define ECAP_MUNIT_1_CTL_MON_SEL_M               0xF00U   // Selects type of monitoring

//*************************************************************************************************
//
// The following are defines for the bit fields in the MUNIT_1_SHADOW_CTL register
//
//*************************************************************************************************
#define ECAP_MUNIT_1_SHADOW_CTL_SYNCI_EN   0x1U   // Enable for shadowing on Min and Max Registers
#define ECAP_MUNIT_1_SHADOW_CTL_SWSYNC     0x2U   // SW sync to copy shadow to active Min and Max
                                                  // registers
#define ECAP_MUNIT_1_SHADOW_CTL_LOADMODE   0x4U   // Load mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the MUNIT_2_CTL register
//
//*************************************************************************************************
#define ECAP_MUNIT_2_CTL_EN                      0x1U     // Enable bit
#define ECAP_MUNIT_2_CTL_DEBUG_RANGE_EN          0x2U     // Debug enable to aquire the range of
                                                          // check being done
#define ECAP_MUNIT_2_CTL_DISABLE_EARLY_MAX_ERR   0x4U     // Disable early max error check
#define ECAP_MUNIT_2_CTL_MON_SEL_S               8U
#define ECAP_MUNIT_2_CTL_MON_SEL_M               0xF00U   // Selects type of monitoring

//*************************************************************************************************
//
// The following are defines for the bit fields in the MUNIT_2_SHADOW_CTL register
//
//*************************************************************************************************
#define ECAP_MUNIT_2_SHADOW_CTL_SYNCI_EN   0x1U   // Enable for shadowing on Min and Max Registers
#define ECAP_MUNIT_2_SHADOW_CTL_SWSYNC     0x2U   // SW sync to copy shadow to active Min and Max
                                                  // registers
#define ECAP_MUNIT_2_SHADOW_CTL_LOADMODE   0x4U   // Load mode


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

/**
 * \brief   add brief
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

 #ifdef __cplusplus
}
#endif


#endif /* DEVICE_DRIVERLIB_HW_ECAP_H_ */
