/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    test.h
*   @brief   
*
*/

#ifndef DEVICE_HEADER_HW_I2C_H_
#define DEVICE_HEADER_HW_I2C_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)


/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
//register offset
#define I2C_O_IC_CON	0x0
#define I2C_O_IC_TAR	0x4
#define I2C_O_IC_SAR	0x8
#define I2C_O_IC_DATA_CMD	0x10
#define I2C_O_IC_SS_SCL_HCNT	0x14
#define I2C_O_IC_SS_SCL_LCNT	0x18
#define I2C_O_IC_FS_SCL_HCNT	0x1c
#define I2C_O_IC_FS_SCL_LCNT	0x20
#define I2C_O_IC_INTR_STAT	0x2c
#define I2C_O_IC_INTR_MASK	0x30
#define I2C_O_IC_RAW_INTR_STAT	0x34
#define I2C_O_IC_RX_TL	0x38
#define I2C_O_IC_TX_TL	0x3c
#define I2C_O_IC_CLR_INTR	0x40
#define I2C_O_IC_CLR_RX_UNDER	0x44
#define I2C_O_IC_CLR_RX_OVER	0x48
#define I2C_O_IC_CLR_TX_OVER	0x4c
#define I2C_O_IC_CLR_RD_REQ	0x50
#define I2C_O_IC_CLR_TX_ABRT	0x54
#define I2C_O_IC_CLR_RX_DONE	0x58
#define I2C_O_IC_CLR_ACTIVITY	0x5c
#define I2C_O_IC_CLR_STOP_DET	0x60
#define I2C_O_IC_CLR_START_DET	0x64
#define I2C_O_IC_CLR_GEN_CALL	0x68
#define I2C_O_IC_ENABLE	0x6c
#define I2C_O_IC_STATUS	0x70
#define I2C_O_IC_TXFLR	0x74
#define I2C_O_IC_RXFLR	0x78
#define I2C_O_IC_SDA_HOLD	0x7c
#define I2C_O_IC_TX_ABRT_SOURCE	0x80
#define I2C_O_IC_DMA_CR	0x88
#define I2C_O_IC_DMA_TDLR	0x8c
#define I2C_O_IC_DMA_RDLR	0x90
#define I2C_O_IC_SDA_SETUP	0x94
#define I2C_O_IC_ACK_GENERAL_CALL	0x98
#define I2C_O_IC_ENABLE_STATUS	0x9c
#define I2C_O_IC_FS_SPKLEN	0xa0
#define I2C_O_IC_CLR_RESTART_DET	0xa8
#define I2C_O_IC_SCL_STUCK_AT_LOW_TIMEOUT	0xac
#define I2C_O_IC_SDA_STUCK_AT_LOW_TIMEOUT	0xb0
#define I2C_O_IC_CLR_SCL_STUCK_DET	0xb4
#define I2C_O_IC_SMBUS_CLK_LOW_SEXT	0xbc
#define I2C_O_IC_SMBUS_CLK_LOW_MEXT	0xc0
#define I2C_O_IC_SMBUS_THIGH_MAX_IDLE_COUNT	0xc4
#define I2C_O_IC_SMBUS_INTR_STAT	0xc8
#define I2C_O_IC_SMBUS_INTR_MASK	0xcc
#define I2C_O_IC_SMBUS_RAW_INTR_STAT	0xd0
#define I2C_O_IC_CLR_SMBUS_INTR	0xd4
#define I2C_O_IC_SMBUS_UDID_LSB	0xdc
#define I2C_O_IC_COMP_PARAM_1	0xf4
#define I2C_O_IC_COMP_VERSION	0xf8
#define I2C_O_IC_COMP_TYPE	0xfc
#define I2C_O_IC_SAR2	0x100
#define I2C_O_IC_CLR_WR_REQ	0x11c
#define I2C_O_IC_CLR_SLV_ADDR_TAG	0x120

//register bit set
#define I2C_IC_ENABLE_ENABLE	0x01U
#define I2C_IC_ENABLE_ABORT	0x02U
#define I2C_IC_ENABLE_TX_CMD_BLOCK 0x04U
#define I2C_IC_ENABLE_SDA_STUCK_RECOVERY_ENABLE	0x08U
#define I2C_IC_ENABLE_SMBUS_CLK_RESET	0x10000U
#define I2C_IC_ENABLE_SMBUS_SUSPEND_EN	0x20000U
#define I2C_IC_ENABLE_SMBUS_ALERT_EN	0x40000U
#define I2C_IC_ENABLE_IC_SAR2_EN	0x100000U

#define I2C_IC_TX_TL_TX_TL	0xFFU

#define I2C_IC_RX_TL_RX_TL	0xFFU

#define I2C_IC_TAR_IC_TAR	0x3FFU
#define I2C_IC_TAR_GC_OR_START	0x400U
#define I2C_IC_TAR_SPECIAL	0x800U
#define I2C_IC_TAR_SMBUS_QUICK_CMD	0x10000U

#define I2C_IC_SAR_IC_SAR	0x3FFU

#define I2C_IC_STATUS_ACTIVITY	0x01U
#define I2C_IC_STATUS_TFNF	0x02U
#define I2C_IC_STATUS_TFE	0x04U
#define I2C_IC_STATUS_RFNE	0x08U
#define I2C_IC_STATUS_RFF	0x10U
#define I2C_IC_STATUS_MST_ACTIVITY	0x20U
#define I2C_IC_STATUS_SLV_ACTIVITY	0x40U

#define I2C_IC_DATA_CMD_DAT		0xFFU
#define I2C_IC_DATA_CMD_CMD		0x100U
#define I2C_IC_DATA_CMD_STOP	0x200U
#define I2C_IC_DATA_CMD_RESTART	0x400U
#define I2C_IC_DATA_CMD_READ	I2C_IC_DATA_CMD_CMD

#define I2C_IC_CON_MASTER_MODE	0x01U
#define I2C_IC_CON_SPEEDL	0x02U
#define I2C_IC_CON_SPEEDH	0x04U
#define I2C_IC_CON_SPEED	0x06U
#define I2C_IC_CON_IC_10BITADDR_SLAVE	0x08U
#define I2C_IC_CON_IC_10BITADDR_MASTER	0x10U
#define I2C_IC_CON_IC_RESTART_EN	0x20U
#define I2C_IC_CON_IC_SLAVE_DISABLE	0x40U
#define I2C_IC_CON_STOP_DET_IFADDRESSED	0x80U
#define I2C_IC_CON_TX_EMPTY_CTRL	0x100U
#define I2C_IC_CON_RX_FIFO_FULL_HLD_CTRL	0x200U
#define I2C_IC_CON_STOP_DET_IF_MASTER_ACTIVE	0x400U
#define I2C_IC_CON_BUS_CLEAR_FEATURE_CTRL	0x800U
#define I2C_IC_CON_SMBUS_SLAVE_QUICK_EN	0x2000U
#define I2C_IC_CON_SMBUS_ARP_EN	0x4000U
#define I2C_IC_CON_SMBUS_PERSISTENT_SLV_ADDR_EN	0x8000U
#define I2C_IC_CON_SMBUS_PERSISTENT_SLV_ADDR2_EN	0x10000U
#define I2C_IC_CON_IC_SAR2_SMBUS_ARP_EN	0x800000U

//
//return value of I2C_getStatus, I2C_getInterruptStatus, I2C_getInterruptRawStatus
//
#define I2C_IC_INTR_STAT_RX_UNDER	0x01U
#define I2C_IC_INTR_STAT_RX_OVER	0x02U
#define I2C_IC_INTR_STAT_RX_FULL	0x04U
#define I2C_IC_INTR_STAT_TX_OVER	0x08U
#define I2C_IC_INTR_STAT_TX_EMPTY	0x10U
#define I2C_IC_INTR_STAT_RD_REQ	0x20U
#define I2C_IC_INTR_STAT_TX_ABRT	0x40U
#define I2C_IC_INTR_STAT_RX_DONE	0x80U
#define I2C_IC_INTR_STAT_ACTIVITY	0x100U
#define I2C_IC_INTR_STAT_STOP_DET	0x200U
#define I2C_IC_INTR_STAT_START_DET	0x400U
#define I2C_IC_INTR_STAT_GEN_CALL	0x800U
#define I2C_IC_INTR_STAT_RESTART_DET	0x1000U
#define I2C_IC_INTR_STAT_MASTER_ON_HOLD 0x2000U
#define I2C_IC_INTR_STAT_WR_REQ	0x8000U
#define I2C_IC_INTR_STAT_SLV_ADDR1_TAG	0x10000U

#define I2C_IC_TX_ABRT_SOURCE_NACK	0x1FU
#define I2C_IC_TX_ABRT_SOURCE_ARB_LOST	0x1000U

#define I2C_IC_INTR_MASK_M_RX_UNDER	0x01U
#define I2C_IC_INTR_MASK_M_RX_OVER	0x02U
#define I2C_IC_INTR_MASK_M_RX_FULL	0x04U
#define I2C_IC_INTR_MASK_M_TX_OVER	0x08U
#define I2C_IC_INTR_MASK_M_TX_EMPTY	0x10U
#define I2C_IC_INTR_MASK_M_RD_REQ	0x20U
#define I2C_IC_INTR_MASK_M_TX_ABRT	0x40U
#define I2C_IC_INTR_MASK_M_RX_DONE	0x80U
#define I2C_IC_INTR_MASK_M_ACTIVITY	0x100U
#define I2C_IC_INTR_MASK_M_STOP_DET	0x200U
#define I2C_IC_INTR_MASK_M_START_DET	0x400U
#define I2C_IC_INTR_MASK_M_GEN_CALL	0x800U
#define I2C_IC_INTR_MASK_M_RESTART_DET	0x1000U
#define I2C_IC_INTR_MASK_M_WR_REQ	0x8000U
#define I2C_IC_INTR_MASK_M_SLV_ADDR1_TAG	0x10000U

#define I2C_IC_SDA_HOLD_IC_SDA_TX_HOLD	0xFFFFU
#define I2C_IC_SDA_HOLD_IC_SDA_RX_HOLD	0xFF0000U

#define I2C_IC_SDA_SETUP_SDA_SETUP	0xFFU

#define I2C_IC_ACK_GENERAL_CALL	0x01U

#define I2C_IC_DMA_CR_RDMAE	0x01U
#define I2C_IC_DMA_CR_TDMAE	0x02U

#define I2C_IC_DMA_TDLR_DMATDL 0x07U
#define I2C_IC_DMA_RDLR_DMARDL 0x07U

#endif



#if IS_GS32F00xx(0x30) || IS_GS32F3xx(0x23)


//*************************************************************************************************
//
// The following are defines for the I2C register offsets
//
//*************************************************************************************************
#define I2C_O_OAR    0x00U    // I2C Own address
#define I2C_O_IER    0x02U    // I2C Interrupt Enable
#define I2C_O_STR    0x04U    // I2C Status
#define I2C_O_CLKL   0x06U    // I2C Clock low-time divider
#define I2C_O_CLKH   0x08U    // I2C Clock high-time divider
#define I2C_O_CNT    0x0AU    // I2C Data count
#define I2C_O_DRR    0x0CU    // I2C Data receive
#define I2C_O_SAR    0x0EU    // I2C Slave address
#define I2C_O_DXR    0x10U    // I2C Data Transmit
#define I2C_O_MDR    0x12U    // I2C Mode
#define I2C_O_ISRC   0x14U    // I2C Interrupt Source
#define I2C_O_EMDR   0x16U    // I2C Extended Mode
#define I2C_O_PSC    0x18U    // I2C Prescaler
#define I2C_O_FFTX   0x40U    // I2C FIFO Transmit
#define I2C_O_FFRX   0x42U    // I2C FIFO Receive


//*************************************************************************************************
//
// The following are defines for the bit fields in the I2COAR register
//
//*************************************************************************************************
#define I2C_OAR_OAR_S   0U
#define I2C_OAR_OAR_M   0x3FFU   // I2C Own address

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CIER register
//
//*************************************************************************************************
#define I2C_IER_ARBL   0x1U    // Arbitration-lost interrupt enable
#define I2C_IER_NACK   0x2U    // No-acknowledgment interrupt enable
#define I2C_IER_ARDY   0x4U    // Register-access-ready interrupt enable
#define I2C_IER_RRDY   0x8U    // Receive-data-ready interrupt enable
#define I2C_IER_XRDY   0x10U   // Transmit-data-ready interrupt enable
#define I2C_IER_SCD    0x20U   // Stop condition detected interrupt enable
#define I2C_IER_AAS    0x40U   // Addressed as slave interrupt enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CSTR register
//
//*************************************************************************************************
#define I2C_STR_ARBL       0x1U      // Arbitration-lost interrupt flag bit
#define I2C_STR_NACK       0x2U      // No-acknowledgment interrupt flag bit.
#define I2C_STR_ARDY       0x4U      // Register-access-ready interrupt flag bit
#define I2C_STR_RRDY       0x8U      // Receive-data-ready interrupt flag bit.
#define I2C_STR_XRDY       0x10U     // Transmit-data-ready interrupt flag bit.
#define I2C_STR_SCD        0x20U     // Stop condition detected bit.
#define I2C_STR_BYTESENT   0x40U     // Byte transmit over indication
#define I2C_STR_AD0        0x100U    // Address 0 bits
#define I2C_STR_AAS        0x200U    // Addressed-as-slave bit
#define I2C_STR_XSMT       0x400U    // Transmit shift register empty bit.
#define I2C_STR_RSFULL     0x800U    // Receive shift register full bit.
#define I2C_STR_BB         0x1000U   // Bus busy bit.
#define I2C_STR_NACKSNT    0x2000U   // NACK sent bit.
#define I2C_STR_SDIR       0x4000U   // Slave direction bit

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CDRR register
//
//*************************************************************************************************
#define I2C_DRR_DATA_S   0U
#define I2C_DRR_DATA_M   0xFFU   // Receive data

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CSAR register
//
//*************************************************************************************************
#define I2C_SAR_SAR_S   0U
#define I2C_SAR_SAR_M   0x3FFU   // Slave Address

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CDXR register
//
//*************************************************************************************************
#define I2C_DXR_DATA_S   0U
#define I2C_DXR_DATA_M   0xFFU   // Transmit data

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CMDR register
//
//*************************************************************************************************
#define I2C_MDR_BC_S      0U
#define I2C_MDR_BC_M      0x7U      // Bit count bits.
#define I2C_MDR_FDF       0x8U      // Free Data Format
#define I2C_MDR_STB       0x10U     // START Byte Mode
#define I2C_MDR_IRS       0x20U     // I2C Module Reset
#define I2C_MDR_DLB       0x40U     // Digital Loopback Mode
#define I2C_MDR_RM        0x80U     // Repeat Mode
#define I2C_MDR_XA        0x100U    // Expanded Address Mode
#define I2C_MDR_TRX       0x200U    // Transmitter Mode
#define I2C_MDR_MST       0x400U    // Master Mode
#define I2C_MDR_STP       0x800U    // STOP Condition
#define I2C_MDR_STT       0x2000U   // START condition bit
#define I2C_MDR_FREE      0x4000U   // Debug Action
#define I2C_MDR_NACKMOD   0x8000U   // NACK mode bit

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CISRC register
//
//*************************************************************************************************
#define I2C_ISRC_INTCODE_S       0U
#define I2C_ISRC_INTCODE_M       0x7U     // Interrupt code bits.
#define I2C_ISRC_WRITE_ZEROS_S   8U
#define I2C_ISRC_WRITE_ZEROS_M   0xF00U   // Always write all 0s to this field

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CEMDR register
//
//*************************************************************************************************
#define I2C_EMDR_BC    0x1U   // Backwards compatibility mode
#define I2C_EMDR_FCM   0x2U   // Forward Compatibility for Tx behav in Type1

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CPSC register
//
//*************************************************************************************************
#define I2C_PSC_IPSC_S   0U
#define I2C_PSC_IPSC_M   0xFFU   // I2C Prescaler Divide Down

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CFFTX register
//
//*************************************************************************************************
#define I2C_FFTX_TXFFIL_S     0U
#define I2C_FFTX_TXFFIL_M     0x1FU     // Transmit FIFO Interrupt Level
#define I2C_FFTX_TXFFIENA     0x20U     // Transmit FIFO Interrupt Enable
#define I2C_FFTX_TXFFINTCLR   0x40U     // Transmit FIFO Interrupt Flag Clear
#define I2C_FFTX_TXFFINT      0x80U     // Transmit FIFO Interrupt Flag
#define I2C_FFTX_TXFFST_S     8U
#define I2C_FFTX_TXFFST_M     0x1F00U   // Transmit FIFO Status
#define I2C_FFTX_TXFFRST      0x2000U   // Transmit FIFO Reset
#define I2C_FFTX_I2CFFEN      0x4000U   // Transmit FIFO Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the I2CFFRX register
//
//*************************************************************************************************
#define I2C_FFRX_RXFFIL_S     0U
#define I2C_FFRX_RXFFIL_M     0x1FU     // Receive FIFO Interrupt Level
#define I2C_FFRX_RXFFIENA     0x20U     // Receive FIFO Interrupt Enable
#define I2C_FFRX_RXFFINTCLR   0x40U     // Receive FIFO Interrupt Flag Clear
#define I2C_FFRX_RXFFINT      0x80U     // Receive FIFO Interrupt Flag
#define I2C_FFRX_RXFFST_S     8U
#define I2C_FFRX_RXFFST_M     0x1F00U   // Receive FIFO Status
#define I2C_FFRX_RXFFRST      0x2000U   // Receive FIFO Reset




//*****************************************************************************
// I2C
//*****************************************************************************
#define I2C_O_TAR         I2C_O_SAR

#define I2C_TAR_TAR_S     I2C_SAR_SAR_S
#define I2C_TAR_TAR_M     I2C_SAR_SAR_M

#define I2C_IER_AAT       I2C_IER_AAS

#define I2C_STR_AAT       I2C_STR_AAS
#define I2C_STR_TDIR      I2C_STR_SDIR

#define I2C_MDR_CNT       I2C_MDR_MST


#endif


#ifdef __cplusplus
}
#endif


#endif /* DEVICE_HEADER_TEMPLATE_H_ */
