/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file    hw_nmi_wd.h
 *   @brief
 *   [note: This file is automatically generated and does not need to be
 *   manually edited. If you want to modify it, use the py script to generate]
 *
 */

#ifndef DEVICE_DRIVERLIB_HW_NMI_WD_H_
#define DEVICE_DRIVERLIB_NMI_WD_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#if IS_GS32F00xx(0x12)
//*************************************************************************************************
//
// The following are defines for the NMI_WD register offsets in 1.2CS
//
//*************************************************************************************************
#define NMI_O_DSP_NMI_CFG      0x000U
#define NMI_O_DSP_NMI_FLG      0x004U
#define NMI_O_DSP_NMI_FLG_CLR  0x008U
#define NMI_O_DSP_NMI_FLG_FRC  0x00CU
#define NMI_O_DSP_WD_CNT       0x010U
#define NMI_O_DSP_WD_PRD       0x014U
#define NMI_O_DSP_NMI_SHD_FLG  0x018U
#define NMI_O_ERRORSTS         0x01CU
#define NMI_O_ERRORSTSCLR      0x020U
#define NMI_O_ERRORSTSFRC      0x024U
#define NMI_O_ERRORCTL         0x028U

#define NMI_O_DSP_SOFT_INT     0x200U                                // Software generates interrupt, level interrupt
#define NMI_O_DSP_SOFT_INTn(n) (NMI_O_DSP_SOFT_INT + ((n - 1) * 4U)) // n:1-12

#define NMI_O_NMI_WDG_LOCK     0x400U
#define NMI_O_PARA_ICG_BYPASS  0x404U

#elif IS_GS32F00xx(0x30)

#define NMI_O_DSP_NMI_CFG      0x000U
#define NMI_O_DSP_NMI_FLG      0x004U
#define NMI_O_DSP_NMI_FLG_CLR  0x008U
#define NMI_O_DSP_NMI_FLG_FRC  0x00CU
#define NMI_O_DSP_WD_CNT       0x010U
#define NMI_O_DSP_WD_PRD       0x014U
#define NMI_O_DSP_NMI_SHD_FLG  0x018U
#define NMI_O_ERRORSTS         0x01CU
#define NMI_O_ERRORSTSCLR      0x020U
#define NMI_O_ERRORSTSFRC      0x024U
#define NMI_O_ERRORCTL         0x028U

/* DSP Software Interrupt Registers */
#define NMI_O_DSP_SOFT_INT     0x200U

#define NMI_O_DSP_SOFT_INT1    0x200U
#define NMI_O_DSP_SOFT_INT2    0x204U
#define NMI_O_DSP_SOFT_INT3    0x208U
#define NMI_O_DSP_SOFT_INT4    0x20CU
#define NMI_O_DSP_SOFT_INT5    0x210U
#define NMI_O_DSP_SOFT_INT6    0x214U
#define NMI_O_DSP_SOFT_INT7    0x218U
#define NMI_O_DSP_SOFT_INT8    0x21CU
#define NMI_O_DSP_SOFT_INT9    0x220U
#define NMI_O_DSP_SOFT_INT10   0x224U
#define NMI_O_DSP_SOFT_INT11   0x228U
#define NMI_O_DSP_SOFT_INT12   0x22CU

#define NMI_O_DSP_SOFT_INTn(n) (NMI_O_DSP_SOFT_INT + ((n - 1) * 4U)) /* n: 1-12 */

/* External Interrupt Configuration Registers */
#define NMI_O_XINT1_CFG        0x300U
#define NMI_O_XINT2_CFG        0x304U
#define NMI_O_XINT3_CFG        0x308U
#define NMI_O_XINT4_CFG        0x30CU
#define NMI_O_XINT5_CFG        0x310U
#define NMI_O_XINT6_CFG        0x314U
#define NMI_O_XINT7_CFG        0x318U
#define NMI_O_XINT8_CFG        0x31CU
#define NMI_O_XINT9_CFG        0x320U
#define NMI_O_XINT10_CFG       0x324U
#define NMI_O_XINT11_CFG       0x328U
#define NMI_O_XINT12_CFG       0x32CU
#define NMI_O_XINT13_CFG       0x330U
#define NMI_O_XINT14_CFG       0x334U
#define NMI_O_XINT15_CFG       0x338U
#define NMI_O_XINT16_CFG       0x33CU

#define NMI_O_XINT_CFG(j)      (NMI_O_XINT1_CFG + ((j - 1) * 4U)) /* j: 1-16 */

/* External Interrupt Counter Registers */
#define NMI_O_XINT1_COUNTER    0x340U
#define NMI_O_XINT2_COUNTER    0x344U
#define NMI_O_XINT3_COUNTER    0x348U

#define NMI_O_XINT_COUNTER(k)  (NMI_O_XINT1_COUNTER + ((k - 1) * 4U)) /* k: 1-3 */

#define NMI_O_NMI_WDG_LOCK     0x400U
#define NMI_O_PARA_ICG_BYPASS  0x404U

#elif IS_GS32F3xx(0x22)
//*************************************************************************************************
//
// The following are defines for the NMI_WD register offsets in 2.2CS
//
//*************************************************************************************************
#define NMI_O_CPU1_NMI_CFG     0x000U
#define NMI_O_CPU1_NMI_FLG     0x004U
#define NMI_O_CPU1_NMI_FLG_CLR 0x008U
#define NMI_O_CPU1_NMI_FLG_FRC 0x00CU // Force trigger register
#define NMI_O_CPU1_WD_CNT      0x010U // NMI_WD Count value register
#define NMI_O_CPU1_WD_PRD      0x014U // NMI_WD Period Register
#define NMI_O_CPU1_NMI_SHD_FLG 0x018U // Indicate whether any NMI signals are blocked or unshielded.
#define NMI_O_ERRORSTS         0x01CU // Error status register.Used to store the current error status.
#define NMI_O_ERRORSTSCLR      0x020U // Clear the register of error status.Used to clear error flags in ErrorsTS
#define NMI_O_ERRORSTSFRC      0x024U // Error state forcing register.Used to force the setting of an error state,
#define NMI_O_ERRORCTL         0x028U // Error control register
#define NMI_O_CPU2_NMI_CFG     0x040U
#define NMI_O_CPU2_NMI_FLG     0x044U
#define NMI_O_CPU2_NMI_FLG_CLR 0x048U
#define NMI_O_CPU2_NMI_FLG_FRC 0x04CU // Force trigger register
#define NMI_O_CPU2_WD_CNT      0x050U // NMI_WD Count value register
#define NMI_O_CPU2_WD_PRD      0x054U // NMI_WD Period Register
#define NMI_O_CPU2_NMI_SHD_FLG 0x058U // Indicate whether any NMI signals are blocked or unshielded.

#define NMI_O_DSP_SOFT_INT     0x200U                                // Software generates interrupt, level interrupt
#define NMI_O_DSP_SOFT_INTn(n) (NMI_O_DSP_SOFT_INT + ((n - 1) * 4U)) // n:1-12

#define NMI_O_NMI_WDG_LOCK     0x400U
#define NMI_O_PARA_ICG_BYPASS  0x404U

#endif // IS_GS32F00xx(0x12)

#if IS_GS32F00xx(0x12)

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_CFG register
//
//*************************************************************************************************
#define NMI_DSP_NMI_CFG_DSP_NMI_EN            0x1U
#define NMI_DSP_NMI_CFG_DSP_NMI_RSTREQ_EN     0x2U
#define NMI_DSP_NMI_CFG_DSP_DBG_WDG_HOLD_EN   0x4U
#define NMI_DSP_NMI_CFG_DSP_NMI_MASK_M        0xFFFF0000U
#define NMI_DSP_NMI_CFG_DSP_NMI_MASK_S        16U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_FLG register
//
//*************************************************************************************************
#define NMI_DSP_NMI_FLG_NMIINT                0x1U    //  DSP NMI Interrupt Flag
#define NMI_DSP_NMI_FLG_DLM_ECC               0x2U    //  DLM ECC Error Flag
#define NMI_DSP_NMI_FLG_ILM_ECC               0x4U    //  ILM ECC Error Flag
#define NMI_DSP_NMI_FLG_DCACHE_ECC            0x8U    //  DCACHE ECC Error Flag
#define NMI_DSP_NMI_FLG_ICACHE_ECC            0x10U   //  ICACHE ECC Error Flag
#define NMI_DSP_NMI_FLG_FLH_CACHE_ECC         0x20U   //  FLH CACHE ECC Error Flag
#define NMI_DSP_NMI_FLG_FLH_MACRO_ECC         0x40U   //  FLH MACRO ECC Error Flag
#define NMI_DSP_NMI_FLG_CCM_ECC               0x80U   //  CCM ECC Error Flag
#define NMI_DSP_NMI_FLG_ERAD_NMI              0x100U  //  ERAD NMI Flag
#define NMI_DSP_NMI_FLG_SRAM1_PARITY          0x200U  //  SRAM1 Parity Error Flag
#define NMI_DSP_NMI_FLG_GS_RAM_PARITY         0x400U  //  GS RAM Parity Error Flag
#define NMI_DSP_NMI_FLG_DSP_EXCP              0x800U  //  DSP Exception Flag
#define NMI_DSP_NMI_FLG_CLOCKFAIL             0x2000U //  Clock Fail Interrupt Flag

#define NMI_DSP_NMI_FLG_DSP_NMI_FLG_M         0xFFFFU
#define NMI_DSP_NMI_FLG_DSP_NMI_FLG_S         0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_FLG_CLR register
//
//*************************************************************************************************
#define NMI_DSP_NMI_FLG_CLR_NMIINT            0x1U    // NMIINT Flag Clear
#define NMI_DSP_NMI_FLG_CLR_CLOCKFAIL         0x2U    // CLOCKFAIL Flag Clear
#define NMI_DSP_NMI_FLG_CLR_RAMUNCERR         0x4U    // RAMUNCERR Flag Clear
#define NMI_DSP_NMI_FLG_CLR_FLUNCERR          0x8U    // FLUNCERR Flag Clear
#define NMI_DSP_NMI_FLG_CLR_CPU1HWBISTERR     0x10U   // CPU1HWBISTERR Flag Clear
#define NMI_DSP_NMI_FLG_CLR_SYSDBGNMI         0x80U   // SYSDBGNMI Flag Clear
#define NMI_DSP_NMI_FLG_CLR_RLNMI             0x100U  // RLNMI Flag Clear
#define NMI_DSP_NMI_FLG_CLR_SWERR             0x2000U // SW Error Flag Clear
#define NMI_DSP_NMI_FLG_CLR_CRC_FAIL          0x4000U // CRC_FAIL flag clear
#define NMI_DSP_NMI_FLG_CLR_DSP_NMI_FLG_CLR_M 0xFFFFU
#define NMI_DSP_NMI_FLG_CLR_DSP_NMI_FLG_CLR_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_FLG_FRC register
//
//*************************************************************************************************
#define NMI_DSP_NMI_FLG_FRC_CLOCKFAIL         0x2U    // CLOCKFAIL Flag Force
#define NMI_DSP_NMI_FLG_FRC_RAMUNCERR         0x4U    // RAMUNCERR Flag Force
#define NMI_DSP_NMI_FLG_FRC_FLUNCERR          0x8U    // FLUNCERR Flag Force
#define NMI_DSP_NMI_FLG_FRC_CPU1HWBISTERR     0x10U   // CPU1HWBISTERR Flag Force
#define NMI_DSP_NMI_FLG_FRC_SYSDBGNMI         0x80U   // SYSDBGNMI Flag Force
#define NMI_DSP_NMI_FLG_FRC_RLNMI             0x100U  // RLNMI Flag Force
#define NMI_DSP_NMI_FLG_FRC_SWERR             0x2000U // SW Error Flag Force
#define NMI_DSP_NMI_FLG_FRC_CRC_FAIL          0x4000U // CRC_FAIL flag force
#define NMI_DSP_NMI_FLG_FRC_DSP_NMI_FLG_FRC_M 0xFFFFU
#define NMI_DSP_NMI_FLG_FRC_DSP_NMI_FLG_FRC_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_WD_CNT register
//
//*************************************************************************************************
#define NMI_DSP_WD_CNT_DSP_WD_CNT_M           0xFFFFU
#define NMI_DSP_WD_CNT_DSP_WD_CNT_S           0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_WD_PRD register
//
//*************************************************************************************************

#define NMI_DSP_WD_PRD_DSP_WD_PRD_M           0xFFFFU
#define NMI_DSP_WD_PRD_DSP_WD_PRD_S           0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_SHD_FLG register
//
//*************************************************************************************************
#define NMI_DSP_NMI_SHD_FLG_CLOCKFAIL         0x2U    // Shadow CLOCKFAIL Flag
#define NMI_DSP_NMI_SHD_FLG_RAMUNCERR         0x4U    // Shadow RAMUNCERR Flag
#define NMI_DSP_NMI_SHD_FLG_FLUNCERR          0x8U    // Shadow FLUNCERR Flag
#define NMI_DSP_NMI_SHD_FLG_CPU1HWBISTERR     0x10U   // Shadow CPU1HWBISTERR Flag
#define NMI_DSP_NMI_SHD_FLG_SYSDBGNMI         0x80U   // Shadow SYSDBGNMI Flag
#define NMI_DSP_NMI_SHD_FLG_RLNMI             0x100U  // Shadow RLNMI Flag
#define NMI_DSP_NMI_SHD_FLG_SWERR             0x2000U // Shadow SW Error Flag
#define NMI_DSP_NMI_SHD_FLG_CRC_FAIL          0x4000U // CRC_FAIL flag
#define NMI_DSP_NMI_SHD_FLG_DSP_NMI_SHD_FLG_M 0xFFFFU
#define NMI_DSP_NMI_SHD_FLG_DSP_NMI_SHD_FLG_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORSTS register
//
//*************************************************************************************************
#define NMI_ERRORSTS_ERROR_M                  0x1U
#define NMI_ERRORSTS_ERROR_S                  0U
#define NMI_ERRORSTS_PINSTS_M                 0x2U
#define NMI_ERRORSTS_PINSTS_S                 1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORSTSCLR register
//
//*************************************************************************************************
#define NMI_ERRORSTSCLR_ERRORSTSCLR_M         0x1U
#define NMI_ERRORSTSCLR_ERRORSTSCLR_S         0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORSTSFRC register
//
//*************************************************************************************************
#define NMI_ERRORSTSFRC_ERRORSTSFRC_M         0x1U
#define NMI_ERRORSTSFRC_ERRORSTSFRC_S         0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORCTL register
//
//*************************************************************************************************
#define NMI_ERRORCTL_ERRORPOLSEL_M            0x1U
#define NMI_ERRORCTL_ERRORPOLSEL_S            0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_SOFT_INT register
//
//*************************************************************************************************
#define NMI_DSP_SOFT_INT_DSP_SOFT_INT         0x1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the NMI_WDG_LOCK register
//
//*************************************************************************************************
#define NMI_NMI_WDG_LOCK_NMI_WDG_LOCK_M       0xFFFFFFFFU
#define NMI_NMI_WDG_LOCK_NMI_WDG_LOCK         0x5A5A5A5AU

//*************************************************************************************************
//
// The following are defines for the bit fields in the PARA_ICG_BYPASS register
//
//*************************************************************************************************
#define NMI_PARA_ICG_BYPASS_PARA_ICG_BYPASS   0x1U

#elif IS_GS32F00xx(0x30)
//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_CFG register
//
//*************************************************************************************************
#define NMI_DSP_NMI_CFG_DSP_NMI_EN            0x1U
#define NMI_DSP_NMI_CFG_DSP_NMI_RSTREQ_EN     0x2U
#define NMI_DSP_NMI_CFG_DSP_DBG_WDG_HOLD_EN   0x4U
#define NMI_DSP_NMI_CFG_DSP_NMI_MASK_M        0xFFFF0000U
#define NMI_DSP_NMI_CFG_DSP_NMI_MASK_S        16U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_FLG register
//
//*************************************************************************************************
#define NMI_DSP_NMI_FLG_NMIINT                0x1U    //  DSP NMI Interrupt Flag
#define NMI_DSP_NMI_FLG_DLM_ECC               0x2U    //  DLM ECC Error Flag
#define NMI_DSP_NMI_FLG_ILM_ECC               0x4U    //  ILM ECC Error Flag
#define NMI_DSP_NMI_FLG_DCACHE_ECC            0x8U    //  DCACHE ECC Error Flag
#define NMI_DSP_NMI_FLG_ICACHE_ECC            0x10U   //  ICACHE ECC Error Flag
#define NMI_DSP_NMI_FLG_FLH_CACHE_ECC         0x20U   //  FLH CACHE ECC Error Flag
#define NMI_DSP_NMI_FLG_FLH_MACRO_ECC         0x40U   //  FLH MACRO ECC Error Flag
#define NMI_DSP_NMI_FLG_CCM_ECC               0x80U   //  CCM ECC Error Flag
#define NMI_DSP_NMI_FLG_ERAD_NMI              0x100U  //  ERAD NMI Flag
#define NMI_DSP_NMI_FLG_SRAM1_PARITY          0x200U  //  SRAM1 Parity Error Flag
#define NMI_DSP_NMI_FLG_GS_RAM_PARITY         0x400U  //  GS RAM Parity Error Flag
#define NMI_DSP_NMI_FLG_DSP_EXCP              0x800U  //  DSP Exception Flag
#define NMI_DSP_NMI_FLG_CLOCKFAIL             0x2000U //  Clock Fail Interrupt Flag

#define NMI_DSP_NMI_FLG_DSP_NMI_FLG_M         0xFFFFU
#define NMI_DSP_NMI_FLG_DSP_NMI_FLG_S         0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_FLG_CLR register
//
//*************************************************************************************************
#define NMI_DSP_NMI_FLG_CLR_NMIINT            0x1U    // NMIINT Flag Clear
#define NMI_DSP_NMI_FLG_CLR_CLOCKFAIL         0x2U    // CLOCKFAIL Flag Clear
#define NMI_DSP_NMI_FLG_CLR_RAMUNCERR         0x4U    // RAMUNCERR Flag Clear
#define NMI_DSP_NMI_FLG_CLR_FLUNCERR          0x8U    // FLUNCERR Flag Clear
#define NMI_DSP_NMI_FLG_CLR_CPU1HWBISTERR     0x10U   // CPU1HWBISTERR Flag Clear
#define NMI_DSP_NMI_FLG_CLR_SYSDBGNMI         0x80U   // SYSDBGNMI Flag Clear
#define NMI_DSP_NMI_FLG_CLR_RLNMI             0x100U  // RLNMI Flag Clear
#define NMI_DSP_NMI_FLG_CLR_SWERR             0x2000U // SW Error Flag Clear
#define NMI_DSP_NMI_FLG_CLR_CRC_FAIL          0x4000U // CRC_FAIL flag clear
#define NMI_DSP_NMI_FLG_CLR_DSP_NMI_FLG_CLR_M 0xFFFFU
#define NMI_DSP_NMI_FLG_CLR_DSP_NMI_FLG_CLR_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_FLG_FRC register
//
//*************************************************************************************************
#define NMI_DSP_NMI_FLG_FRC_CLOCKFAIL         0x2U    // CLOCKFAIL Flag Force
#define NMI_DSP_NMI_FLG_FRC_RAMUNCERR         0x4U    // RAMUNCERR Flag Force
#define NMI_DSP_NMI_FLG_FRC_FLUNCERR          0x8U    // FLUNCERR Flag Force
#define NMI_DSP_NMI_FLG_FRC_CPU1HWBISTERR     0x10U   // CPU1HWBISTERR Flag Force
#define NMI_DSP_NMI_FLG_FRC_SYSDBGNMI         0x80U   // SYSDBGNMI Flag Force
#define NMI_DSP_NMI_FLG_FRC_RLNMI             0x100U  // RLNMI Flag Force
#define NMI_DSP_NMI_FLG_FRC_SWERR             0x2000U // SW Error Flag Force
#define NMI_DSP_NMI_FLG_FRC_CRC_FAIL          0x4000U // CRC_FAIL flag force
#define NMI_DSP_NMI_FLG_FRC_DSP_NMI_FLG_FRC_M 0xFFFFU
#define NMI_DSP_NMI_FLG_FRC_DSP_NMI_FLG_FRC_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_WD_CNT register
//
//*************************************************************************************************
#define NMI_DSP_WD_CNT_DSP_WD_CNT_M           0xFFFFU
#define NMI_DSP_WD_CNT_DSP_WD_CNT_S           0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_WD_PRD register
//
//*************************************************************************************************

#define NMI_DSP_WD_PRD_DSP_WD_PRD_M           0xFFFFU
#define NMI_DSP_WD_PRD_DSP_WD_PRD_S           0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_NMI_SHD_FLG register
//
//*************************************************************************************************
#define NMI_DSP_NMI_SHD_FLG_CLOCKFAIL         0x2U    // Shadow CLOCKFAIL Flag
#define NMI_DSP_NMI_SHD_FLG_RAMUNCERR         0x4U    // Shadow RAMUNCERR Flag
#define NMI_DSP_NMI_SHD_FLG_FLUNCERR          0x8U    // Shadow FLUNCERR Flag
#define NMI_DSP_NMI_SHD_FLG_CPU1HWBISTERR     0x10U   // Shadow CPU1HWBISTERR Flag
#define NMI_DSP_NMI_SHD_FLG_SYSDBGNMI         0x80U   // Shadow SYSDBGNMI Flag
#define NMI_DSP_NMI_SHD_FLG_RLNMI             0x100U  // Shadow RLNMI Flag
#define NMI_DSP_NMI_SHD_FLG_SWERR             0x2000U // Shadow SW Error Flag
#define NMI_DSP_NMI_SHD_FLG_CRC_FAIL          0x4000U // CRC_FAIL flag
#define NMI_DSP_NMI_SHD_FLG_DSP_NMI_SHD_FLG_M 0xFFFFU
#define NMI_DSP_NMI_SHD_FLG_DSP_NMI_SHD_FLG_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORSTS register
//
//*************************************************************************************************
#define NMI_ERRORSTS_ERROR_M                  0x1U
#define NMI_ERRORSTS_ERROR_S                  0U
#define NMI_ERRORSTS_PINSTS_M                 0x2U
#define NMI_ERRORSTS_PINSTS_S                 1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORSTSCLR register
//
//*************************************************************************************************
#define NMI_ERRORSTSCLR_ERRORSTSCLR_M         0x1U
#define NMI_ERRORSTSCLR_ERRORSTSCLR_S         0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORSTSFRC register
//
//*************************************************************************************************
#define NMI_ERRORSTSFRC_ERRORSTSFRC_M         0x1U
#define NMI_ERRORSTSFRC_ERRORSTSFRC_S         0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORCTL register
//
//*************************************************************************************************
#define NMI_ERRORCTL_ERRORPOLSEL_M            0x1U
#define NMI_ERRORCTL_ERRORPOLSEL_S            0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORCTL register
//
//*************************************************************************************************
#define NMI_ERRORCTL_ERRORPOLSEL_M            0x1U
#define NMI_ERRORCTL_ERRORPOLSEL_S            0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the XINTj_CFG register (j: 1-16 )
//
//*************************************************************************************************
#define NMI_XINT_ENABLE                       0x1U // XINT1 Enable
#define NMI_XINT_POLARITY_S                   2U
#define NMI_XINT_POLARITY_M                   0xCU // XINT1 Polarity

//*************************************************************************************************
//
// The following are defines for the bit fields in the NMI_WDG_LOCK register
//
//*************************************************************************************************
#define NMI_NMI_WDG_LOCK_NMI_WDG_LOCK_M       0xFFFFFFFFU
#define NMI_NMI_WDG_LOCK_NMI_WDG_LOCK         0x5A5A5A5AU

//*************************************************************************************************
//
// The following are defines for the bit fields in the PARA_ICG_BYPASS register
//
//*************************************************************************************************
#define NMI_PARA_ICG_BYPASS_PARA_ICG_BYPASS   0x1U

#elif IS_GS32F3xx(0x22)
//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU1_NMI_CFG register
//
//*************************************************************************************************
#define NMI_CPU1_NMI_CFG_CPU1_NMI_EN            0x01U       // Bit 0, RW, cpu1_nmi_en
#define NMI_CPU1_NMI_CFG_CPU1_NMI_RSTREQ_EN     0x02U       // Bit 1, RW, cpu1_nmi_rstreq_en
#define NMI_CPU1_NMI_CFG_CPU1_DBG_WDG_HOLD_EN   0x04U       // Bit 2, RW, cpu1_dbg_wdg_hold_en
#define NMI_CPU1_NMI_CFG_CPU1_NMI_MASK_M        0xFFFF0000U // Bits 31:16, RW, cpu1_src_mask
#define NMI_CPU1_NMI_CFG_CPU1_NMI_MASK_S        16U         // Bits 31:16, RW, cpu1_src_mask

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU1_NMI_FLG register
//
//*************************************************************************************************
#define NMI_CPU1_NMI_FLG_CPU1_NMI_FLG_M         0xFFFFU
#define NMI_CPU1_NMI_FLG_CPU1_NMI_FLG_S         0U

#define NMI_CPU1_NMI_FLG_NMIINT                 0x01U   // CPU1 or CPU2 Total Interrupt Flag (Global for CPU1 or CPU2)
#define NMI_CPU1_NMI_FLG_CPU2_ECC               0x2U    // CPU2 ECC Error Flag
#define NMI_CPU1_NMI_FLG_CPU1_ECC               0x4U    // CPU1 ECC Error Flag
#define NMI_CPU1_NMI_FLG_EFC_ECC                0x10U   // EFC ECC Error Flag
#define NMI_CPU1_NMI_FLG_CPU2_NMI_WDT           0x20U   // CPU2 NMI Watchdog Timeout Reset Flag (Only CPU1 receives signal)
#define NMI_CPU1_NMI_FLG_CPU2_WINDOW_WDT        0x40U   // CPU2 Window Watchdog Timeout Reset Flag (Only CPU1 receives signal)
#define NMI_CPU1_NMI_FLG_CPU2_WDT_TIMEOUT       0x80U   // CPU2 Watchdog Timeout Reset Flag (Only CPU1 receives signal)
#define NMI_CPU1_NMI_FLG_CLOCKFAIL              0x1000U //  Clock Fail Interrupt Flag Flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU1_NMI_FLG_CLR register
//
//*************************************************************************************************
#define NMI_CPU1_NMI_FLG_CLR_CPU1_NMI_FLG_CLR_M 0xFFFFU
#define NMI_CPU1_NMI_FLG_CLR_CPU1_NMI_FLG_CLR_S 0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU1_NMI_FLG_FRC register
//
//*************************************************************************************************
#define NMI_CPU1_NMI_FLG_FRC_CPU1_NMI_FLG_FRC_M 0xFFFFU
#define NMI_CPU1_NMI_FLG_FRC_CPU1_NMI_FLG_FRC_S 0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU1_WD_CNT register
//
//*************************************************************************************************
#define NMI_CPU1_WD_CNT_CPU1_WD_CNT_M           0xFFFFU
#define NMI_CPU1_WD_CNT_CPU1_WD_CNT_S           0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU1_WD_PRD register
//
//*************************************************************************************************
#define NMI_CPU1_WD_PRD_CPU1_WD_PRD_M           0xFFFFU
#define NMI_CPU1_WD_PRD_CPU1_WD_PRD_S           0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU1_NMI_SHD_FLG register
//
//*************************************************************************************************
#define NMI_CPU1_NMI_SHD_FLG_CPU1_NMI_SHD_FLG_M 0xFFFFU
#define NMI_CPU1_NMI_SHD_FLG_CPU1_NMI_SHD_FLG_S 0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORSTS register
//
//*************************************************************************************************
#define NMI_ERRORSTS_ERROR_M                    0x1U
#define NMI_ERRORSTS_ERROR_S                    0U
#define NMI_ERRORSTS_PINSTS_M                   0x2U
#define NMI_ERRORSTS_PINSTS_S                   1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORSTSCLR register
//
//*************************************************************************************************
#define NMI_ERRORSTSCLR_ERRORSTSCLR_M           0x1U
#define NMI_ERRORSTSCLR_ERRORSTSCLR_S           0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORSTSFRC register
//
//*************************************************************************************************
#define NMI_ERRORSTSFRC_ERRORSTSFRC_M           0x1U
#define NMI_ERRORSTSFRC_ERRORSTSFRC_S           0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ERRORCTL register
//
//*************************************************************************************************
#define NMI_ERRORCTL_ERRORPOLSEL_M              0x1U
#define NMI_ERRORCTL_ERRORPOLSEL_S              0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU2_NMI_CFG register
//
//*************************************************************************************************
#define NMI_CPU2_NMI_CFG_CPU2_NMI_EN            0x1U
#define NMI_CPU2_NMI_CFG_CPU2_NMI_RSTREQ_EN     0x2U
#define NMI_CPU2_NMI_CFG_CPU2_DBG_WDG_HOLD_EN   0x4U
#define NMI_CPU2_NMI_CFG_CPU2_NMI_MASK_M        0xFFFF0000U
#define NMI_CPU2_NMI_CFG_CPU2_NMI_MASK_S        16U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU2_NMI_FLG register
//
//*************************************************************************************************
#define NMI_CPU2_NMI_FLG_CPU2_NMI_FLG_M         0xFFFFU
#define NMI_CPU2_NMI_FLG_CPU2_NMI_FLG_S         0U

#define NMI_CPU2_NMI_FLG_NMIINT                 0x01U   // CPU1 or CPU2 Total Interrupt Flag (Global for CPU1 or CPU2)
#define NMI_CPU2_NMI_FLG_CPU2_ECC               0x2U    // CPU2 ECC Error Flag
#define NMI_CPU2_NMI_FLG_CPU1_ECC               0x4U    // CPU1 ECC Error Flag
#define NMI_CPU2_NMI_FLG_EFC_ECC                0x10U   // EFC ECC Error Flag
#define NMI_CPU2_NMI_FLG_CLOCKFAIL              0x1000U //  Clock Fail Interrupt Flag Flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU2_NMI_FLG_CLR register
//
//*************************************************************************************************
#define NMI_CPU2_NMI_FLG_CLR_CPU2_NMI_FLG_CLR_M 0xFFFFU
#define NMI_CPU2_NMI_FLG_CLR_CPU2_NMI_FLG_CLR_S 0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU2_NMI_FLG_FRC register
//
//*************************************************************************************************
#define NMI_CPU2_NMI_FLG_FRC_CPU2_NMI_FLG_FRC_M 0xFFFFU
#define NMI_CPU2_NMI_FLG_FRC_CPU2_NMI_FLG_FRC_S 0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU2_WD_CNT register
//
//*************************************************************************************************
#define NMI_CPU2_WD_CNT_CPU2_WD_CNT_M           0xFFFFU
#define NMI_CPU2_WD_CNT_CPU2_WD_CNT_S           0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU2_WD_PRD register
//
//*************************************************************************************************
#define NMI_CPU2_WD_PRD_CPU2_WD_PRD_M           0xFFFFU
#define NMI_CPU2_WD_PRD_CPU2_WD_PRD_S           0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CPU2_NMI_SHD_FLG register
//
//*************************************************************************************************
#define NMI_CPU2_NMI_SHD_FLG_CPU2_NMI_SHD_FLG_M 0xFFFFU
#define NMI_CPU2_NMI_SHD_FLG_CPU2_NMI_SHD_FLG_S 0x0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DSP_SOFT_INT register
//
//*************************************************************************************************
#define NMI_DSP_SOFT_INT_DSP_SOFT_INT           0x1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the NMI_WDG_LOCK register
//
//*************************************************************************************************
#define NMI_NMI_WDG_LOCK_NMI_WDG_LOCK_M         0xFFFFFFFFU
#define NMI_NMI_WDG_LOCK_NMI_WDG_LOCK           0x5A5A5A5AU

//*************************************************************************************************
//
// The following are defines for the bit fields in the PARA_ICG_BYPASS register
//
//*************************************************************************************************
#define NMI_PARA_ICG_BYPASS_PARA_ICG_BYPASS     0x1U

#endif // 2.2

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

/**
 * \brief   add brief
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif

#endif /* DRIVERLIB_INC_HW_NMI_WD_H_ */
