/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    pmbus.h
*   @brief
*
*/

#ifndef DEVICE_HEADER_HW_PMBUS_H_
#define DEVICE_HEADER_HW_PMBUS_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif


//*************************************************************************************************
//
// The following are defines for the PMBUS register offsets
//
//*************************************************************************************************
#define PMBUS_O_IC_CON							0x00U	//PMBUS Control Register
#define PMBUS_O_IC_TAR							0x04U	//PMBUS Target Address Register
#define PMBUS_O_IC_SAR							0x08U	//PMBUS Slave Address Register
#define PMBUS_O_IC_HS_MADDR						0x0CU	//PMBUS High Speed Master Mode Code Address Register
#define PMBUS_O_IC_DATA_CMD						0x10U	//PMBUS Rx/Tx Data Buffer and Command Register
#define PMBUS_O_IC_SS_SCL_HCNT					0x14U	//Standard Speed PMBUS Clock SCL High Count Register
#define PMBUS_O_IC_UFM_SCL_HCNT					0x14U	//Ultra-Fast Speed PMBUS Clock SCL High Count Register
#define PMBUS_O_IC_SS_SCL_LCNT					0x18U	//Standard Speed PMBUS Clock SCL Low Count Register
#define PMBUS_O_IC_UFM_SCL_LCNT					0x18U	//Ultra-Fast Speed PMBUS Clock SCL Low Count Register
#define PMBUS_O_IC_FS_SCL_HCNT					0x1CU	//Fast Mode or Fast Mode Plus PMBUS Clock SCL High Count Register
#define PMBUS_O_IC_UFM_TBUF_CNT					0x1CU	//Ultra-Fast Speed mode TBuf Idle Count Register
#define PMBUS_O_IC_FS_SCL_LCNT					0x20U	//Fast Mode or Fast Mode Plus PMBUS Clock SCL Low Count Register
#define PMBUS_O_IC_HS_SCL_HCNT					0x24U	//High Speed PMBUS Clock SCL High Count Register
#define PMBUS_O_IC_HS_SCL_LCNT					0x28U	//High Speed PMBUS Clock SCL Low Count Register
#define PMBUS_O_IC_INTR_STAT					0x2CU	//PMBUS Interrupt Status Register
#define PMBUS_O_IC_INTR_MASK					0x30U	//PMBUS Interrupt Mask Register
#define PMBUS_O_IC_RAW_INTR_STAT				0x34U	//PMBUS Raw Interrupt Status Register
#define PMBUS_O_IC_RX_TL						0x38U	//PMBUS Receive FIFO Threshold Register
#define PMBUS_O_IC_TX_TL						0x3CU	//PMBUS Transmit FIFO Threshold Register
#define PMBUS_O_IC_CLR_INTR						0x40U	//Clear Combined and Individual Interrupt Register
#define PMBUS_O_IC_CLR_RX_UNDER					0x44U	//Clear RX_UNDER Interrupt Register
#define PMBUS_O_IC_CLR_RX_OVER					0x48U	//Clear RX_OVER Interrupt Register
#define PMBUS_O_IC_CLR_TX_OVER					0x4CU	//Clear TX_OVER Interrupt Register
#define PMBUS_O_IC_CLR_RD_REQ					0x50U	//Clear RD_REQ Interrupt Register
#define PMBUS_O_IC_CLR_TX_ABRT					0x54U	//Clear TX_ABRT Interrupt Register
#define PMBUS_O_IC_CLR_RX_DONE					0x58U	//Clear RX_DONE Interrupt Register
#define PMBUS_O_IC_CLR_ACTIVITY					0x5CU	//Clear ACTIVITY Interrupt Register
#define PMBUS_O_IC_CLR_STOP_DET					0x60U	//Clear STOP_DET Interrupt Register
#define PMBUS_O_IC_CLR_START_DET				0x64U	//Clear START_DET Interrupt Register
#define PMBUS_O_IC_CLR_GEN_CALL					0x68U	//Clear GEN_CALL Interrupt Register
#define PMBUS_O_IC_ENABLE						0x6CU	//PMBUS ENABLE Register
#define PMBUS_O_IC_STATUS						0x70U	//PMBUS STATUS Register
#define PMBUS_O_IC_TXFLR						0x74U	//PMBUS Transmit FIFO Level Register
#define PMBUS_O_IC_RXFLR						0x78U	//PMBUS Receive FIFO Level Register
#define PMBUS_O_IC_SDA_HOLD						0x7CU	//PMBUS SDA Hold Time Length Register
#define PMBUS_O_IC_TX_ABRT_SOURCE				0x80U	//PMBUS Transmit Abort Source Register
#define PMBUS_O_IC_SLV_DATA_NACK_ONLY			0x84U	//Generate Slave Data NACK Register
#define PMBUS_O_IC_DMA_CR						0x88U	//DMA Control Register
#define PMBUS_O_IC_DMA_TDLR						0x8CU	//DMA Transmit Data Level Register
#define PMBUS_O_IC_DMA_RDLR						0x90U	//DMA Receive Data Level Register
#define PMBUS_O_IC_SDA_SETUP					0x94U	//PMBUS SDA Setup Register
#define PMBUS_O_IC_ACK_GENERAL_CALL				0x98U	//PMBUS ACK General Call Register
#define PMBUS_O_IC_ENABLE_STATUS				0x9CU	//PMBUS Enable Status Register
#define PMBUS_O_IC_FS_SPKLEN					0xA0U	//PMBUS SS, FS or FM+ spike suppression limit
#define PMBUS_O_IC_UFM_SPKLEN					0xA0U	//PMBUS Ultra-Fast mode spike suppression limit
#define PMBUS_O_IC_HS_SPKLEN					0xA4U	//PMBUS HS spike suppression limit register
#define PMBUS_O_IC_CLR_RESTART_DET				0xA8U	//Clear RESTART_DET Interrupt Register
#define PMBUS_O_IC_SCL_STUCK_AT_LOW_TIMEOUT		0xACU	//PMBUS SCL Stuck at Low Timeout register
#define PMBUS_O_IC_SDA_STUCK_AT_LOW_TIMEOUT		0xB0U	//PMBUS SDA Stuck at Low Timeout register
#define PMBUS_O_IC_CLR_SCL_STUCK_DET			0xB4U	//Clear SCL Stuck at Low Detect interrupt Register
#define PMBUS_O_IC_DEVICE_ID					0xB8U	//PMBUS Device-Id register
#define PMBUS_O_IC_SMBUS_CLK_LOW_SEXT			0xBCU	//SMBus Slave Clock Extend Timeout register
#define PMBUS_O_IC_SMBUS_CLK_LOW_MEXT			0xC0U	//SMBus Master Clock Extend Timeout register
#define PMBUS_O_IC_SMBUS_THIGH_MAX_IDLE_COUNT	0xC4U	//SMBus Master THigh MAX Bus-idle count Register
#define PMBUS_O_IC_SMBUS_INTR_STAT				0xC8U	//SMBus Interrupt Status Register
#define PMBUS_O_IC_SMBUS_INTR_MASK				0xCCU	//SMBus Interrupt Mask Register
#define PMBUS_O_IC_SMBUS_RAW_INTR_STAT			0xD0U	//SMBus Raw Interrupt Status Register
#define PMBUS_O_IC_CLR_SMBUS_INTR				0xD4U	//Clear SMBus Interrupt Register
#define PMBUS_O_IC_OPTIONAL_SAR					0xD8U	//PMBUS Optional Slave Address Register
#define PMBUS_O_IC_SMBUS_UDID_LSB				0xDCU	//SMBUS ARP UDID LSB Register
#define PMBUS_O_IC_SMBUS_UDID_WORD0				0xDCU	//SMBUS ARP UDID WORD0 Register
#define PMBUS_O_IC_SMBUS_UDID_WORD1				0xE0U	//SMBUS ARP UDID WORD1 Register
#define PMBUS_O_IC_SMBUS_UDID_WORD2				0xE4U	//SMBUS ARP UDID WORD2 Register
#define PMBUS_O_IC_SMBUS_UDID_WORD3				0xE8U	//SMBUS ARP UDID WORD3 Register
#define PMBUS_O_REG_TIMEOUT_RST					0xF0U	//Register timeout counter reset value
#define PMBUS_O_IC_COMP_PARAM_1					0xF4U	//Component Parameter Register 1
#define PMBUS_O_IC_COMP_VERSION					0xF8U	//PMBUS Component Version Register
#define PMBUS_O_IC_COMP_TYPE					0xFCU	//PMBUS Component Type Register
#define PMBUS_O_IC_SAR2							0x100U	//PMBUS Slave Address Register 2
#define PMBUS_O_IC_SAR3							0x104U	//PMBUS Slave Address Register 3
#define PMBUS_O_IC_SAR4							0x108U	//PMBUS Slave Address Register 4
#define PMBUS_O_IC_CLR_WR_REQ					0x11CU	//Clear WR_REQ Interrupt Register
#define PMBUS_O_IC_CLR_SLV_ADDR_TAG				0x120U	//Clear CLR_SLV_ADDR_TAG Interrupt Register
#define PMBUS_O_IC_SAR2_SMBUS_UDID_WORD0		0x124U	//IC_SAR2 SMBUS ARP UDID WORD0 Register
#define PMBUS_O_IC_SAR2_SMBUS_UDID_WORD1		0x128U	//IC_SAR2 SMBUS ARP UDID WORD1 Register
#define PMBUS_O_IC_SAR2_SMBUS_UDID_WORD2		0x12CU	//IC_SAR2 SMBUS ARP UDID WORD2 Register
#define PMBUS_O_IC_SAR2_SMBUS_UDID_WORD3		0x130U	//IC_SAR2 SMBUS ARP UDID WORD3 Register
#define PMBUS_O_IC_SAR3_SMBUS_UDID_WORD0		0x134U	//IC_SAR3 SMBUS ARP UDID WORD0 Register
#define PMBUS_O_IC_SAR3_SMBUS_UDID_WORD1		0x138U	//IC_SAR3 SMBUS ARP UDID WORD1 Register
#define PMBUS_O_IC_SAR3_SMBUS_UDID_WORD2		0x13CU	//IC_SAR3 SMBUS ARP UDID WORD2 Register
#define PMBUS_O_IC_SAR3_SMBUS_UDID_WORD3		0x140U	//IC_SAR3 SMBUS ARP UDID WORD3 Register
#define PMBUS_O_IC_SAR4_SMBUS_UDID_WORD0		0x144U	//IC_SAR4 SMBUS ARP UDID WORD0 Register
#define PMBUS_O_IC_SAR4_SMBUS_UDID_WORD1		0x148U	//IC_SAR4 SMBUS ARP UDID WORD1 Register
#define PMBUS_O_IC_SAR4_SMBUS_UDID_WORD2		0x14CU	//IC_SAR4 SMBUS ARP UDID WORD2 Register
#define PMBUS_O_IC_SAR4_SMBUS_UDID_WORD3		0x150U	//IC_SAR4 SMBUS ARP UDID WORD3 Register


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CON register
//
//*************************************************************************************************
#define PMBUS_CON_MASTER_MODE						0x00000001U
#define PMBUS_CON_SPEED_S							1U
#define PMBUS_CON_SPEED_M							0x00000006U
#define PMBUS_CON_IC_10BITADDR_SLAVE				0x00000008U
#define PMBUS_CON_IC_10BITADDR_MASTER				0x00000010U
#define PMBUS_CON_IC_RESTART_EN						0x00000020U
#define PMBUS_CON_IC_SLAVE_DISABLE					0x00000040U
#define PMBUS_CON_STOP_DET_IFADDRESSED				0x00000080U
#define PMBUS_CON_TX_EMPTY_CTRL						0x00000100U
#define PMBUS_CON_RX_FIFO_FULL_HLD_CTRL				0x00000200U
#define PMBUS_CON_STOP_DET_IF_MASTER_ACTIVE			0x00000400U
#define PMBUS_CON_BUS_CLEAR_FEATURE_CTRL			0x00000800U
#define PMBUS_CON_OPTIONAL_SAR_CTRL					0x00010000U
#define PMBUS_CON_SMBUS_SLAVE_QUICK_EN				0x00020000U
#define PMBUS_CON_SMBUS_ARP_EN						0x00040000U
#define PMBUS_CON_SMBUS_PERSISTENT_SLV_ADDR_EN		0x00080000U
#define PMBUS_CON_SMBUS_PERSISTENT_SLV_ADDR2_EN		0x00100000U
#define PMBUS_CON_SMBUS_PERSISTENT_SLV_ADDR3_EN		0x00200000U
#define PMBUS_CON_SMBUS_PERSISTENT_SLV_ADDR4_EN		0x00400000U
#define PMBUS_CON_IC_SAR2_SMBUS_ARP_EN				0x00800000U
#define PMBUS_CON_IC_SAR3_SMBUS_ARP_EN				0x01000000U
#define PMBUS_CON_IC_SAR4_SMBUS_ARP_EN				0x02000000U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_TAR register
//
//*************************************************************************************************
#define PMBUS_TAR_IC_TAR_S					0U
#define PMBUS_TAR_IC_TAR_M					0x000003FFU
#define PMBUS_TAR_GC_OR_START				0x00000400U
#define PMBUS_TAR_SPECIAL					0x00000800U
#define PMBUS_TAR_IC_10BITADDR_MASTER		0x00001000U
#define PMBUS_TAR_DEVICE_ID					0x00002000U
#define PMBUS_TAR_SMBUS_QUICK_CMD			0x00010000U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR register
//
//*************************************************************************************************
#define PMBUS_SAR_IC_SAR_S		0U
#define PMBUS_SAR_IC_SAR_M		0x000003FFU

//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_HS_MADDR register
//
//*************************************************************************************************
#define PMBUS_HS_MADDR_S		0U
#define PMBUS_HS_MADDR_M		0x00000007U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_DATA_CMD register
//
//*************************************************************************************************
#define PMBUS_DATA_CMD_DAT_S				0U
#define PMBUS_DATA_CMD_DAT_M				0x000000FFU
#define PMBUS_DATA_CMD_CMD					0x00000100U
#define PMBUS_DATA_CMD_STOP					0x00000200U
#define PMBUS_DATA_CMD_RESTART				0x00000400U
#define PMBUS_DATA_CMD_FIRST_DATA_BYTE		0x00000800U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SS_SCL_HCNT register
//
//*************************************************************************************************
#define PMBUS_SS_SCL_HCNT_SS_SCL_HCNT_S		0U
#define PMBUS_SS_SCL_HCNT_SS_SCL_HCNT_M		0x0000FFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_UFM_SCL_HCNT register
//
//*************************************************************************************************
#define PMBUS_UFM_SCL_HCNT_UFM_SCL_HCNT_S	0U
#define PMBUS_UFM_SCL_HCNT_UFM_SCL_HCNT_M	0x0000FFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SS_SCL_LCNT register
//
//*************************************************************************************************
#define PMBUS_SS_SCL_LCNT_SS_SCL_LCNT_S		0U
#define PMBUS_SS_SCL_LCNT_SS_SCL_LCNT_M		0x0000FFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_UFM_SCL_LCNT register
//
//*************************************************************************************************
#define PMBUS_UFM_SCL_LCNT_UFM_SCL_LCNT_S	0U
#define PMBUS_UFM_SCL_LCNT_UFM_SCL_LCNT_M	0x0000FFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_FS_SCL_HCNT register
//
//*************************************************************************************************
#define PMBUS_FS_SCL_HCNT_FS_SCL_HCNT_S		0U
#define PMBUS_FS_SCL_HCNT_FS_SCL_HCNT_M		0x0000FFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_UFM_TBUF_CNT register
//
//*************************************************************************************************
#define PMBUS_UFM_TBUF_CNT_UFM_TBUF_CNT_S	0U
#define PMBUS_UFM_TBUF_CNT_UFM_TBUF_CNT_M	0x0000FFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_FS_SCL_LCNT register
//
//*************************************************************************************************
#define PMBUS_FS_SCL_LCNT_FS_SCL_LCNT_S		0U
#define PMBUS_FS_SCL_LCNT_FS_SCL_LCNT_M		0x0000FFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_HS_SCL_HCNT register
//
//*************************************************************************************************
#define PMBUS_HS_SCL_HCNT_HS_SCL_HCNT_S		0U
#define PMBUS_HS_SCL_HCNT_HS_SCL_HCNT_M		0x0000FFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_HS_SCL_LCNT register
//
//*************************************************************************************************
#define PMBUS_HS_SCL_LCNT_HS_SCL_LCNT_S		0U
#define PMBUS_HS_SCL_LCNT_HS_SCL_LCNT_M		0x0000FFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_INTR_STAT register
//
//*************************************************************************************************
#define PMBUS_INTR_STAT_R_RX_UNDER			0x00000001U
#define PMBUS_INTR_STAT_R_RX_OVER			0x00000002U
#define PMBUS_INTR_STAT_R_RX_FULL			0x00000004U
#define PMBUS_INTR_STAT_R_TX_OVER			0x00000008U
#define PMBUS_INTR_STAT_R_TX_EMPTY			0x00000010U
#define PMBUS_INTR_STAT_R_RD_REQ			0x00000020U
#define PMBUS_INTR_STAT_R_TX_ABRT			0x00000040U
#define PMBUS_INTR_STAT_R_RX_DONE			0x00000080U
#define PMBUS_INTR_STAT_R_ACTIVITY			0x00000100U
#define PMBUS_INTR_STAT_R_STOP_DET			0x00000200U
#define PMBUS_INTR_STAT_R_START_DET			0x00000400U
#define PMBUS_INTR_STAT_R_GEN_CALL			0x00000800U
#define PMBUS_INTR_STAT_R_RESTART_DET		0x00001000U
#define PMBUS_INTR_STAT_R_MASTER_ON_HOLD	0x00002000U
#define PMBUS_INTR_STAT_R_SCL_STUCK_AT_LOW	0x00004000U
#define PMBUS_INTR_STAT_R_WR_REQ			0x00008000U
#define PMBUS_INTR_STAT_R_SLV_ADDR1_TAG		0x00010000U
#define PMBUS_INTR_STAT_R_SLV_ADDR2_TAG		0x00020000U
#define PMBUS_INTR_STAT_R_SLV_ADDR3_TAG		0x00040000U
#define PMBUS_INTR_STAT_R_SLV_ADDR4_TAG		0x00080000U
#define PMBUS_INTR_STAT_R_ALL				0x000FFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_INTR_MASK register
//
//*************************************************************************************************
#define PMBUS_INTR_MASK_M_RX_UNDER			0x00000001U
#define PMBUS_INTR_MASK_M_RX_OVER			0x00000002U
#define PMBUS_INTR_MASK_M_RX_FULL			0x00000004U
#define PMBUS_INTR_MASK_M_TX_OVER			0x00000008U
#define PMBUS_INTR_MASK_M_TX_EMPTY			0x00000010U
#define PMBUS_INTR_MASK_M_RD_REQ			0x00000020U
#define PMBUS_INTR_MASK_M_TX_ABRT			0x00000040U
#define PMBUS_INTR_MASK_M_RX_DONE			0x00000080U
#define PMBUS_INTR_MASK_M_ACTIVITY			0x00000100U
#define PMBUS_INTR_MASK_M_STOP_DET			0x00000200U
#define PMBUS_INTR_MASK_M_START_DET			0x00000400U
#define PMBUS_INTR_MASK_M_GEN_CALL			0x00000800U
#define PMBUS_INTR_MASK_M_RESTART_DET		0x00001000U
#define PMBUS_INTR_MASK_M_MASTER_ON_HOLD	0x00002000U
#define PMBUS_INTR_MASK_M_SCL_STUCK_AT_LOW	0x00004000U
#define PMBUS_INTR_MASK_M_WR_REQ			0x00008000U
#define PMBUS_INTR_MASK_M_SLV_ADDR1_TAG		0x00010000U
#define PMBUS_INTR_MASK_M_SLV_ADDR2_TAG		0x00020000U
#define PMBUS_INTR_MASK_M_SLV_ADDR3_TAG		0x00040000U
#define PMBUS_INTR_MASK_M_SLV_ADDR4_TAG		0x00080000U
#define PMBUS_INTR_MASK_M_ALL				0x000FFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_RAW_INTR_STAT register
//
//*************************************************************************************************
#define PMBUS_RAW_INTR_STAT_RX_UNDER			0x00000001U
#define PMBUS_RAW_INTR_STAT_RX_OVER				0x00000002U
#define PMBUS_RAW_INTR_STAT_RX_FULL				0x00000004U
#define PMBUS_RAW_INTR_STAT_TX_OVER				0x00000008U
#define PMBUS_RAW_INTR_STAT_TX_EMPTY			0x00000010U
#define PMBUS_RAW_INTR_STAT_RD_REQ				0x00000020U
#define PMBUS_RAW_INTR_STAT_TX_ABRT				0x00000040U
#define PMBUS_RAW_INTR_STAT_RX_DONE				0x00000080U
#define PMBUS_RAW_INTR_STAT_ACTIVITY			0x00000100U
#define PMBUS_RAW_INTR_STAT_STOP_DET			0x00000200U
#define PMBUS_RAW_INTR_STAT_START_DET			0x00000400U
#define PMBUS_RAW_INTR_STAT_GEN_CALL			0x00000800U
#define PMBUS_RAW_INTR_STAT_RESTART_DET			0x00001000U
#define PMBUS_RAW_INTR_STAT_MASTER_ON_HOLD		0x00002000U
#define PMBUS_RAW_INTR_STAT_SCL_STUCK_AT_LOW	0x00004000U
#define PMBUS_RAW_INTR_STAT_WR_REQ				0x00008000U
#define PMBUS_RAW_INTR_STAT_SLV_ADDR1_TAG		0x00010000U
#define PMBUS_RAW_INTR_STAT_SLV_ADDR2_TAG		0x00020000U
#define PMBUS_RAW_INTR_STAT_SLV_ADDR3_TAG		0x00040000U
#define PMBUS_RAW_INTR_STAT_SLV_ADDR4_TAG		0x00080000U
#define PMBUS_RAW_INTR_STAT_ALL					0x000FFFFFU

//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_RX_TL register
//
//*************************************************************************************************
#define PMBUS_RX_TL_RX_TL_S		0U
#define PMBUS_RX_TL_RX_TL_M		0x000000FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_TX_TL register
//
//*************************************************************************************************
#define PMBUS_TX_TL_RX_TL_S		0U
#define PMBUS_TX_TL_RX_TL_M		0x000000FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_INTR register
//
//*************************************************************************************************
#define PMBUS_CLR_INTR_CLR_INTR		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_RX_UNDER register
//
//*************************************************************************************************
#define PMBUS_CLR_RX_UNDER_CLR_RX_UNDER		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_RX_OVER register
//
//*************************************************************************************************
#define PMBUS_CLR_RX_OVER_CLR_RX_OVER		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_TX_OVER register
//
//*************************************************************************************************
#define PMBUS_CLR_TX_OVER_CLR_TX_OVER		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_RD_REQ register
//
//*************************************************************************************************
#define PMBUS_CLR_RD_REQ_CLR_RD_REQ		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_TX_ABRT register
//
//*************************************************************************************************
#define PMBUS_CLR_TX_ABRT_CLR_TX_ABRT	0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_RX_DONE register
//
//*************************************************************************************************
#define PMBUS_CLR_RX_DONE_CLR_RX_DONE	0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_ACTIVITY register
//
//*************************************************************************************************
#define PMBUS_CLR_ACTIVITY_CLR_ACTIVITY		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_STOP_DET register
//
//*************************************************************************************************
#define PMBUS_CLR_STOP_DET_CLR_STOP_DET		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_START_DET register
//
//*************************************************************************************************
#define PMBUS_CLR_START_DET_CLR_START_DET 	0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_GEN_CALL register
//
//*************************************************************************************************
#define PMBUS_CLR_GEN_CALL_CLR_GEN_CALL		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_ENABLE register
//
//*************************************************************************************************
#define PMBUS_ENABLE_ENABLE							0x00000001U
#define PMBUS_ENABLE_ABORT							0x00000002U
#define PMBUS_ENABLE_TX_CMD_BLOCK					0x00000004U
#define PMBUS_ENABLE_SDA_STUCK_RECOVERY_ENABLE		0x00000008U
#define PMBUS_ENABLE_SMBUS_CLK_RESET				0x00010000U
#define PMBUS_ENABLE_SMBUS_SUSPEND_EN				0x00020000U
#define PMBUS_ENABLE_SMBUS_ALERT_EN					0x00040000U
#define PMBUS_ENABLE_SAR_EN							0x00080000U
#define PMBUS_ENABLE_SAR2_EN						0x00100000U
#define PMBUS_ENABLE_SAR3_EN						0x00200000U
#define PMBUS_ENABLE_SAR4_EN						0x00400000U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_STATUS register
//
//*************************************************************************************************
#define PMBUS_STATUS_ACTIVITY							0x00000001U
#define PMBUS_STATUS_TFNF								0x00000002U
#define PMBUS_STATUS_TFE								0x00000004U
#define PMBUS_STATUS_RFNE								0x00000008U
#define PMBUS_STATUS_RFF								0x00000010U
#define PMBUS_STATUS_MST_ACTIVITY						0x00000020U
#define PMBUS_STATUS_SLV_ACTIVITY						0x00000040U
#define PMBUS_STATUS_MST_HOLD_TX_FIFO_EMPTY				0x00000080U
#define PMBUS_STATUS_MST_HOLD_RX_FIFO_FULL				0x00000100U
#define PMBUS_STATUS_SLV_HOLD_TX_FIFO_EMPTY				0x00000200U
#define PMBUS_STATUS_SLV_HOLD_RX_FIFO_FULL				0x00000400U
#define PMBUS_STATUS_SDA_STUCK_NOT_RECOVERED			0x00000800U
#define PMBUS_STATUS_SLV_ISO_SAR_DATA_CLK_STRETCH		0x00001000U
#define PMBUS_STATUS_SMBUS_QUICK_CMD_BIT				0x00010000U
#define PMBUS_STATUS_SMBUS_SLAVE_ADDR_VALID				0x00020000U
#define PMBUS_STATUS_SMBUS_SLAVE_ADDR_RESOLVED			0x00040000U
#define PMBUS_STATUS_SMBUS_SUSPEND_STATUS				0x00080000U
#define PMBUS_STATUS_SMBUS_ALERT_STATUS					0x00100000U
#define PMBUS_STATUS_SMBUS_SLAVE_ADDR2_VALID			0x00200000U
#define PMBUS_STATUS_SMBUS_SLAVE_ADDR2_RESOLVED			0x00400000U
#define PMBUS_STATUS_SMBUS_SLAVE_ADDR3_VALID			0x00800000U
#define PMBUS_STATUS_SMBUS_SLAVE_ADDR3_RESOLVED			0x01000000U
#define PMBUS_STATUS_SMBUS_SLAVE_ADDR4_VALID			0x02000000U
#define PMBUS_STATUS_SMBUS_SLAVE_ADDR4_RESOLVED			0x04000000U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_TXFLR register
//
//*************************************************************************************************
#define PMBUS_TXFLR_TXFLR_S		0U
#define PMBUS_TXFLR_TXFLR_M		0x0000000FU	//TX_ABW_P1 = 5


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_RXFLR register
//
//*************************************************************************************************
#define PMBUS_RXFLR_RXFLR_S		0U
#define PMBUS_RXFLR_RXFLR_M		0x0000000FU	//RX_ABW_P1 = 5


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SDA_HOLD register
//
//*************************************************************************************************
#define PMBUS_SDA_HOLD_SDA_TX_HOLD_S	0U
#define PMBUS_SDA_HOLD_SDA_TX_HOLD_M	0x0000FFFFU
#define PMBUS_SDA_HOLD_SDA_RX_HOLD_S	16U
#define PMBUS_SDA_HOLD_SDA_RX_HOLD_M	0x00FF0000U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_TX_ABRT_SOURCE register
//
//*************************************************************************************************
#define PMBUS_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK				0x00000001U
#define PMBUS_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK				0x00000002U
#define PMBUS_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK				0x00000004U
#define PMBUS_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK				0x00000008U
#define PMBUS_TX_ABRT_SOURCE_ABRT_GCALL_NOACK				0x00000010U
#define PMBUS_TX_ABRT_SOURCE_ABRT_GCALL_READ				0x00000020U
#define PMBUS_TX_ABRT_SOURCE_ABRT_HS_ACKDET					0x00000040U
#define PMBUS_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET				0x00000080U
#define PMBUS_TX_ABRT_SOURCE_ABRT_HS_NORSTRT				0x00000100U
#define PMBUS_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT				0x00000200U
#define PMBUS_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT			0x00000400U
#define PMBUS_TX_ABRT_SOURCE_ABRT_MASTER_DIS				0x00000800U
#define PMBUS_TX_ABRT_SOURCE_ARB_LOST						0x00001000U
#define PMBUS_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO			0x00002000U
#define PMBUS_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST				0x00004000U
#define PMBUS_TX_ABRT_SOURCE_ABRT_SLVRD_INTX				0x00008000U
#define PMBUS_TX_ABRT_SOURCE_ABRT_USER_ABRT					0x00010000U
#define PMBUS_TX_ABRT_SOURCE_ABRT_SDA_STUCK_AT_LOW			0x00020000U
#define PMBUS_TX_ABRT_SOURCE_ABRT_DEVICE_NOACK				0x00040000U
#define PMBUS_TX_ABRT_SOURCE_ABRT_DEVICE_SLVADDR_NOACK		0x00080000U
#define PMBUS_TX_ABRT_SOURCE_ABRT_DEVICE_WRITE				0x00100000U
#define PMBUS_TX_ABRT_SOURCE_TX_FLUSH_CNT_S					23U
#define PMBUS_TX_ABRT_SOURCE_TX_FLUSH_CNT_M					0xFF800000U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SLV_DATA_NACK_ONLY register
//
//*************************************************************************************************
#define PMBUS_SLV_DATA_NACK_ONLY_NACK 	0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_DMA_CR register
//
//*************************************************************************************************
#define PMBUS_DMA_CR_TDMAE		0x00000001U
#define PMBUS_DMA_CR_RDMAE		0x00000002U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_DMA_TDLR register
//
//*************************************************************************************************
#define PMBUS_DMA_TDLR_DMATDL_S		0U
#define PMBUS_DMA_TDLR_DMATDL_M		0x0000000FU //TX_ABW = 4


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_DMA_RDLR register
//
//*************************************************************************************************
#define PMBUS_DMA_RDLR_DMARDL_S		0U
#define PMBUS_DMA_RDLR_DMARDL_M		0x000000FU //RX_ABW = 4


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SDA_SETUP register
//
//*************************************************************************************************
#define PMBUS_SDA_SETUP_SDA_SETUP_S		0U
#define PMBUS_SDA_SETUP_SDA_SETUP_M		0x000000FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_ACK_GENERAL_CALL register
//
//*************************************************************************************************
#define PMBUS_ACK_GENERAL_CALL_ACK_GEN_CALL 0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_ENABLE_STATUS register
//
//*************************************************************************************************
#define PMBUS_ENABLE_STATUS_IC_EN						0x00000001U
#define PMBUS_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY		0x00000002U
#define PMBUS_ENABLE_STATUS_SLV_RX_DATA_LOST			0x00000004U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_FS_SPKLEN register
//
//*************************************************************************************************
#define PMBUS_FS_SPKLEN_IC_FS_SPKLEN_S		0U
#define PMBUS_FS_SPKLEN_IC_FS_SPKLEN_M		0x000000FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_UFM_SPKLEN register
//
//*************************************************************************************************
#define PMBUS_UFM_SPKLEN_IC_UFM_SPKLEN_S	0U
#define PMBUS_UFM_SPKLEN_IC_UFM_SPKLEN_M	0x000000FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_HS_SPKLEN register
//
//*************************************************************************************************
#define PMBUS_HS_SPKLEN_IC_HS_SPKLEN_S		0U
#define PMBUS_HS_SPKLEN_IC_HS_SPKLEN_M		0x000000FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_RESTART_DET register
//
//*************************************************************************************************
#define PMBUS_CLR_RESTART_DET_CLR_RESTART_DET 	0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SCL_STUCK_AT_LOW_TIMEOUT register
//
//*************************************************************************************************
#define PMBUS_SCL_STUCK_AT_LOW_TIMEOUT_IC_SCL_STUCK_LOW_TIMEOUT_S	0U
#define PMBUS_SCL_STUCK_AT_LOW_TIMEOUT_IC_SCL_STUCK_LOW_TIMEOUT_M	0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SDA_STUCK_AT_LOW_TIMEOUT register
//
//*************************************************************************************************
#define PMBUS_SDA_STUCK_AT_LOW_TIMEOUT_IC_SDA_STUCK_LOW_TIMEOUT_S	0U
#define PMBUS_SDA_STUCK_AT_LOW_TIMEOUT_IC_SDA_STUCK_LOW_TIMEOUT_M	0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_SCL_STUCK_DET register
//
//*************************************************************************************************
#define PMBUS_CLR_SCL_STUCK_DET_CLR_SCL_STUCK_DET	0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_DEVICE_ID register
//
//*************************************************************************************************
#define PMBUS_DEVICE_ID_DEVICE_ID_S		0U
#define PMBUS_DEVICE_ID_DEVICE_ID_M		0x00FFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_CLK_LOW_SEXT register
//
//*************************************************************************************************
#define PMBUS_SMBUS_CLK_LOW_SEXT_SMBUS_CLK_LOW_SEXT_TIMEOUT_S	0U
#define PMBUS_SMBUS_CLK_LOW_SEXT_SMBUS_CLK_LOW_SEXT_TIMEOUT_M	0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_CLK_LOW_MEXT register
//
//*************************************************************************************************
#define PMBUS_SMBUS_CLK_LOW_MEXT_SMBUS_CLK_LOW_MEXT_TIMEOUT_S	0U
#define PMBUS_SMBUS_CLK_LOW_MEXT_SMBUS_CLK_LOW_MEXT_TIMEOUT_M	0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_THIGH_MAX_IDLE_COUNT register
//
//*************************************************************************************************
#define PMBUS_SMBUS_THIGH_MAX_IDLE_COUNT_SMBUS_THIGH_MAX_BUS_IDLE_CNT_S		0U
#define PMBUS_SMBUS_THIGH_MAX_IDLE_COUNT_SMBUS_THIGH_MAX_BUS_IDLE_CNT_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_INTR_STAT register
//
//*************************************************************************************************
#define PMBUS_SMBUS_INTR_STAT_R_SLV_CLOCK_EXTND_TIMEOUT		0x00000001U
#define PMBUS_SMBUS_INTR_STAT_R_MST_CLOCK_EXTND_TIMEOUT		0x00000002U
#define PMBUS_SMBUS_INTR_STAT_R_QUICK_CMD_DET				0x00000004U
#define PMBUS_SMBUS_INTR_STAT_R_HOST_NOTIFY_MST_DET			0x00000008U
#define PMBUS_SMBUS_INTR_STAT_R_ARP_PREPARE_CMD_DET			0x00000010U
#define PMBUS_SMBUS_INTR_STAT_R_ARP_RST_CMD_DET				0x00000020U
#define PMBUS_SMBUS_INTR_STAT_R_ARP_GET_UDID_CMD_DET		0x00000040U
#define PMBUS_SMBUS_INTR_STAT_R_ARP_ASSGN_ADDR_CMD_DET		0x00000080U
#define PMBUS_SMBUS_INTR_STAT_R_SLV_RX_PEC_NACK				0x00000100U
#define PMBUS_SMBUS_INTR_STAT_R_SMBUS_SUSPEND_DET			0x00000200U
#define PMBUS_SMBUS_INTR_STAT_R_SMBUS_ALERT_DET				0x00000400U
#define PMBUS_SMBUS_INTR_STAT_R_ALL							0x000007FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_INTR_MASK register
//
//*************************************************************************************************
#define PMBUS_SMBUS_INTR_MASK_M_SLV_CLOCK_EXTND_TIMEOUT		0x00000001U
#define PMBUS_SMBUS_INTR_MASK_M_MST_CLOCK_EXTND_TIMEOUT		0x00000002U
#define PMBUS_SMBUS_INTR_MASK_M_QUICK_CMD_DET				0x00000004U
#define PMBUS_SMBUS_INTR_MASK_M_HOST_NOTIFY_MST_DET			0x00000008U
#define PMBUS_SMBUS_INTR_MASK_M_ARP_PREPARE_CMD_DET			0x00000010U
#define PMBUS_SMBUS_INTR_MASK_M_ARP_RST_CMD_DET				0x00000020U
#define PMBUS_SMBUS_INTR_MASK_M_ARP_GET_UDID_CMD_DET		0x00000040U
#define PMBUS_SMBUS_INTR_MASK_M_ARP_ASSGN_ADDR_CMD_DET		0x00000080U
#define PMBUS_SMBUS_INTR_MASK_M_SLV_RX_PEC_NACK				0x00000100U
#define PMBUS_SMBUS_INTR_MASK_M_SMBUS_SUSPEND_DET			0x00000200U
#define PMBUS_SMBUS_INTR_MASK_M_SMBUS_ALERT_DET				0x00000400U
#define PMBUS_SMBUS_INTR_MASK_M_ALL							0x000007FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_RAW_INTR_STAT register
//
//*************************************************************************************************
#define PMBUS_SMBUS_RAW_INTR_STAT_SLV_CLOCK_EXTND_TIMEOUT	0x00000001U
#define PMBUS_SMBUS_RAW_INTR_STAT_MST_CLOCK_EXTND_TIMEOUT	0x00000002U
#define PMBUS_SMBUS_RAW_INTR_STAT_QUICK_CMD_DET				0x00000004U
#define PMBUS_SMBUS_RAW_INTR_STAT_HOST_NTFY_MST_DET			0x00000008U
#define PMBUS_SMBUS_RAW_INTR_STAT_ARP_PREPARE_CMD_DET		0x00000010U
#define PMBUS_SMBUS_RAW_INTR_STAT_ARP_RST_CMD_DET			0x00000020U
#define PMBUS_SMBUS_RAW_INTR_STAT_ARP_GET_UDID_CMD_DET		0x00000040U
#define PMBUS_SMBUS_RAW_INTR_STAT_ARP_ASSGN_ADDR_CMD_DET	0x00000080U
#define PMBUS_SMBUS_RAW_INTR_STAT_SLV_RX_PEC_NACK			0x00000100U
#define PMBUS_SMBUS_RAW_INTR_STAT_SMBUS_SUSPEND_DET			0x00000200U
#define PMBUS_SMBUS_RAW_INTR_STAT_SMBUS_ALERT_DET			0x00000400U
#define PMBUS_SMBUS_RAW_INTR_STAT_ALL						0x000007FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_SMBUS_INTR register
//
//*************************************************************************************************
#define PMBUS_CLR_SMBUS_INTR_CLR_SLV_CLOCK_EXTND_TIMEOUT	0x00000001U
#define PMBUS_CLR_SMBUS_INTR_CLR_MST_CLOCK_EXTND_TIMEOUT	0x00000002U
#define PMBUS_CLR_SMBUS_INTR_CLR_QUICK_CMD_DET				0x00000004U
#define PMBUS_CLR_SMBUS_INTR_CLR_HOST_NOTIFY_MST_DET		0x00000008U
#define PMBUS_CLR_SMBUS_INTR_CLR_ARP_PREPARE_CMD_DET		0x00000010U
#define PMBUS_CLR_SMBUS_INTR_CLR_ARP_RST_CMD_DET			0x00000020U
#define PMBUS_CLR_SMBUS_INTR_CLR_ARP_GET_UDID_CMD_DET		0x00000040U
#define PMBUS_CLR_SMBUS_INTR_CLR_ARP_ASSGN_ADDR_CMD_DET		0x00000080U
#define PMBUS_CLR_SMBUS_INTR_CLR_SLV_RX_PEC_NACK			0x00000100U
#define PMBUS_CLR_SMBUS_INTR_CLR_SMBUS_SUSPEND_DET			0x00000200U
#define PMBUS_CLR_SMBUS_INTR_CLR_SMBUS_ALERT_DET			0x00000400U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_OPTIONAL_SAR register
//
//*************************************************************************************************
#define PMBUS_OPTIONAL_SAR_OPTIONAL_SAR_S	0U
#define PMBUS_OPTIONAL_SAR_OPTIONAL_SAR_M	0x0000007FU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_UDID_LSB register
//
//*************************************************************************************************
#define PMBUS_SMBUS_UDID_LSB_SMBUS_UDID_LSB_S	0U
#define PMBUS_SMBUS_UDID_LSB_SMBUS_UDID_LSB_M	0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_UDID_WORD0 register
//
//*************************************************************************************************
#define PMBUS_SMBUS_UDID_WORD0_SMBUS_UDID_WORD0_S	0U
#define PMBUS_SMBUS_UDID_WORD0_SMBUS_UDID_WORD0_M	0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_UDID_WORD1 register
//
//*************************************************************************************************
#define PMBUS_SMBUS_UDID_WORD1_SMBUS_UDID_WORD1_S		0U
#define PMBUS_SMBUS_UDID_WORD1_SMBUS_UDID_WORD1_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_UDID_WORD2 register
//
//*************************************************************************************************
#define PMBUS_SMBUS_UDID_WORD2_SMBUS_UDID_WORD2_S		0U
#define PMBUS_SMBUS_UDID_WORD2_SMBUS_UDID_WORD2_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SMBUS_UDID_WORD3 register
//
//*************************************************************************************************
#define PMBUS_SMBUS_UDID_WORD3_SMBUS_UDID_WORD3_S		0U
#define PMBUS_SMBUS_UDID_WORD3_SMBUS_UDID_WORD3_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the REG_TIMEOUT_RST register
//
//*************************************************************************************************
#define PMBUS_REG_TIMEOUT_RST_REG_TIMEOUT_RST_rw_S		0U
#define PMBUS_REG_TIMEOUT_RST_REG_TIMEOUT_RST_rw_M		0x000000FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_COMP_PARAM_1 register
//
//*************************************************************************************************
#define PMBUS_COMP_PARAM_1_APB_DATA_WIDTH_S		0U
#define PMBUS_COMP_PARAM_1_APB_DATA_WIDTH_M		0x00000003U
#define PMBUS_COMP_PARAM_1_MAX_SPEED_MODE_S		2U
#define PMBUS_COMP_PARAM_1_MAX_SPEED_MODE_M		0x0000000CU
#define PMBUS_COMP_PARAM_1_HC_COUNT_VALUES		0x00000010U
#define PMBUS_COMP_PARAM_1_INTR_IO				0x00000020U
#define PMBUS_COMP_PARAM_1_HAS_DMA				0x00000040U
#define PMBUS_COMP_PARAM_1_ADD_ENCODED_PARAMS	0x00000070U
#define PMBUS_COMP_PARAM_1_RX_BUFFER_DEPTH_S	8U
#define PMBUS_COMP_PARAM_1_RX_BUFFER_DEPTH_M	0x0000FF00U
#define PMBUS_COMP_PARAM_1_TX_BUFFER_DEPTH_S	16U
#define PMBUS_COMP_PARAM_1_TX_BUFFER_DEPTH_M	0x00FF0000U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_COMP_VERSION register
//
//*************************************************************************************************
#define PMBUS_COMP_VERSION_IC_COMP_VERSION_S	0U
#define PMBUS_COMP_VERSION_IC_COMP_VERSION_M	0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_COMP_TYPE register
//
//*************************************************************************************************
#define PMBUS_COMP_TYPE_IC_COMP_TYPE_S		0U
#define PMBUS_COMP_TYPE_IC_COMP_TYPE_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR2 register
//
//*************************************************************************************************
#define PMBUS_SAR2_IC_SAR2_S	0U
#define PMBUS_SAR2_IC_SAR2_M	0x000003FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR3 register
//
//*************************************************************************************************
#define PMBUS_SAR3_IC_SAR3_S	0U
#define PMBUS_SAR3_IC_SAR3_M	0x000003FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR4 register
//
//*************************************************************************************************
#define PMBUS_SAR4_IC_SAR4_S	0U
#define PMBUS_SAR4_IC_SAR4_M	0x000003FFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_WR_REQ register
//
//*************************************************************************************************
#define PMBUS_CLR_WR_REQ_CLR_WR_REQ		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_CLR_SLV_ADDR_TAG register
//
//*************************************************************************************************
#define PMBUS_CLR_SLV_ADDR_TAG_CLR_SLV_ADDR_TAG		0x00000001U


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR2_SMBUS_UDID_WORD0 register
//
//*************************************************************************************************
#define PMBUS_SAR2_SMBUS_UDID_WORD0_SAR2_SMBUS_UDID_WORD0_S		0U
#define PMBUS_SAR2_SMBUS_UDID_WORD0_SAR2_SMBUS_UDID_WORD0_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR2_SMBUS_UDID_WORD1 register
//
//*************************************************************************************************
#define PMBUS_SAR2_SMBUS_UDID_WORD1_SAR2_SMBUS_UDID_WORD1_S		0U
#define PMBUS_SAR2_SMBUS_UDID_WORD1_SAR2_SMBUS_UDID_WORD1_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR2_SMBUS_UDID_WORD2 register
//
//*************************************************************************************************
#define PMBUS_SAR2_SMBUS_UDID_WORD2_SAR2_SMBUS_UDID_WORD2_S		0U
#define PMBUS_SAR2_SMBUS_UDID_WORD2_SAR2_SMBUS_UDID_WORD2_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR2_SMBUS_UDID_WORD3 register
//
//*************************************************************************************************
#define PMBUS_SAR2_SMBUS_UDID_WORD3_SAR2_SMBUS_UDID_WORD3_S		0U
#define PMBUS_SAR2_SMBUS_UDID_WORD3_SAR2_SMBUS_UDID_WORD3_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR3_SMBUS_UDID_WORD0 register
//
//*************************************************************************************************
#define PMBUS_SAR3_SMBUS_UDID_WORD0_SAR3_SMBUS_UDID_WORD0_S		0U
#define PMBUS_SAR3_SMBUS_UDID_WORD0_SAR3_SMBUS_UDID_WORD0_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR3_SMBUS_UDID_WORD1 register
//
//*************************************************************************************************
#define PMBUS_SAR3_SMBUS_UDID_WORD1_SAR3_SMBUS_UDID_WORD1_S		0U
#define PMBUS_SAR3_SMBUS_UDID_WORD1_SAR3_SMBUS_UDID_WORD1_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR3_SMBUS_UDID_WORD2 register
//
//*************************************************************************************************
#define PMBUS_SAR3_SMBUS_UDID_WORD2_SAR3_SMBUS_UDID_WORD2_S		0U
#define PMBUS_SAR3_SMBUS_UDID_WORD2_SAR3_SMBUS_UDID_WORD2_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR3_SMBUS_UDID_WORD3 register
//
//*************************************************************************************************
#define PMBUS_SAR3_SMBUS_UDID_WORD3_SAR3_SMBUS_UDID_WORD3_S		0U
#define PMBUS_SAR3_SMBUS_UDID_WORD3_SAR3_SMBUS_UDID_WORD3_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR4_SMBUS_UDID_WORD0 register
//
//*************************************************************************************************
#define PMBUS_SAR4_SMBUS_UDID_WORD0_SAR4_SMBUS_UDID_WORD0_S		0U
#define PMBUS_SAR4_SMBUS_UDID_WORD0_SAR4_SMBUS_UDID_WORD0_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR4_SMBUS_UDID_WORD1 register
//
//*************************************************************************************************
#define PMBUS_SAR4_SMBUS_UDID_WORD1_SAR4_SMBUS_UDID_WORD1_S		0U
#define PMBUS_SAR4_SMBUS_UDID_WORD1_SAR4_SMBUS_UDID_WORD1_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR4_SMBUS_UDID_WORD2 register
//
//*************************************************************************************************
#define PMBUS_SAR4_SMBUS_UDID_WORD2_SAR4_SMBUS_UDID_WORD2_S		0U
#define PMBUS_SAR4_SMBUS_UDID_WORD2_SAR4_SMBUS_UDID_WORD2_M		0xFFFFFFFFU


//*************************************************************************************************
//
// The following are defines for the bit fields in the IC_SAR4_SMBUS_UDID_WORD3 register
//
//*************************************************************************************************
#define PMBUS_SAR4_SMBUS_UDID_WORD3_SAR4_SMBUS_UDID_WORD3_S		0U
#define PMBUS_SAR4_SMBUS_UDID_WORD3_SAR4_SMBUS_UDID_WORD3_M		0xFFFFFFFFU



#ifdef __cplusplus
}
#endif


#endif /* DEVICE_HEADER_TEMPLATE_H_ */
