/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * @file  hw_spi_v30.h
 * @brief Definitions for the V3.0 SPI registers.
 */

#ifndef DRIVERLIB_INC_HW_SPI_V30_H_
#define DRIVERLIB_INC_HW_SPI_V30_H_

#ifdef __cplusplus
extern "C"{
#endif

#if (IS_GS32F00xx(0x30))

/**
 * @brief The following are defines for the SPI register offsets
 */
#define SPI_O_CCR                   0x0U    /** @brief SPI Configuration Control Register.         */
#define SPI_O_CTL                   0x2U    /** @brief SPI Operation Control Register.             */
#define SPI_O_STS                   0x4U    /** @brief SPI Status Register.                        */
#define SPI_O_BRR                   0x8U    /** @brief SPI Baud Rate Register.                     */
#define SPI_O_RXEMU                 0xCU    /** @brief SPI Emulation Buffer Register.              */
#define SPI_O_RXBUF                 0xEU    /** @brief SPI Serial Input Buffer Register.           */
#define SPI_O_TXBUF                 0x10U   /** @brief SPI Serial Output Buffer Register.          */
#define SPI_O_DAT                   0x12U   /** @brief SPI Serial Data Register.                   */
#define SPI_O_FFTX                  0x14U   /** @brief SPI FIFO Transmit Register.                 */
#define SPI_O_FFRX                  0x16U   /** @brief SPI FIFO Receive Register.                  */
#define SPI_O_FFCT                  0x18U   /** @brief SPI FIFO Control Register.                  */
#define SPI_O_PRI                   0x1EU   /** @brief SPI Priority Control Register.              */
#define SPI_O_DMA_REQ_TIMEOUT       0x20U   /** @brief SPI DMA RX REQ Timeout Interrupt Register.  */
#define SPI_O_DMA_REQ_TIMEOUT_TH    0x24U   /** @brief SPI DMA RX REQ Timeout Threshhold Register. */


/**
 * @brief The following are defines for the bit fields in the SPICCR register
 */
#define SPI_CCR_SPICHAR_S     0U
#define SPI_CCR_SPICHAR_M     0xFU    /** @brief Character Length Control. */
#define SPI_CCR_SPILBK        0x10U   /** @brief SPI Loopback.             */
#define SPI_CCR_HS_MODE       0x20U   /** @brief High Speed mode control.  */
#define SPI_CCR_CLKPOLARITY   0x40U   /** @brief Shift Clock Polarity.     */
#define SPI_CCR_SPISWRESET    0x80U   /** @brief SPI Software Reset.       */

/**
 * @brief  The following are defines for the bit fields in the SPICTL register
 */
#define SPI_CTL_SPIINTENA       0x1U    /** @brief SPI Interupt Enable.          */
#define SPI_CTL_TALK            0x2U    /** @brief Master/Slave Transmit Enable. */
#define SPI_CTL_MASTER_SLAVE    0x4U    /** @brief SPI Network Mode Control.     */
#define SPI_CTL_CLK_PHASE       0x8U    /** @brief SPI Clock Phase.              */
#define SPI_CTL_OVERRUNINTENA   0x10U   /** @brief Overrun Interrupt Enable.     */

/**
 * @brief The following are defines for the bit fields in the SPISTS register
 */
#define SPI_STS_BUFFULL_FLAG   0x20U   /** @brief SPI Transmit Buffer Full Flag. */
#define SPI_STS_INT_FLAG       0x40U   /** @brief SPI Interrupt Flag.            */
#define SPI_STS_OVERRUN_FLAG   0x80U   /** @brief SPI Receiver Overrun Flag.     */

/**
 * @brief The following are defines for the bit fields in the SPIBRR register
 */
#define SPI_BRR_SPI_BIT_RATE_S   0U
#define SPI_BRR_SPI_BIT_RATE_M   0x7FU   /** @brief SPI Bit Rate Control. */

/**
 * @brief The following are defines for the bit fields in the SPIFFTX register
 */
#define SPI_FFTX_TXFFIL_S     0U
#define SPI_FFTX_TXFFIL_M     0x1FU     /** @brief TXFIFO Interrupt Level.  */
#define SPI_FFTX_TXFFIENA     0x20U     /** @brief TXFIFO Interrupt Enable. */
#define SPI_FFTX_TXFFINTCLR   0x40U     /** @brief TXFIFO Interrupt Clear.  */
#define SPI_FFTX_TXFFINT      0x80U     /** @brief TXFIFO Interrupt Flag.   */
#define SPI_FFTX_TXFFST_S     8U
#define SPI_FFTX_TXFFST_M     0x1F00U   /** @brief Transmit FIFO Status.     */
#define SPI_FFTX_TXFIFO       0x2000U   /** @brief TXFIFO Reset.             */
#define SPI_FFTX_SPIFFENA     0x4000U   /** @brief FIFO Enhancements Enable. */
#define SPI_FFTX_SPIRST       0x8000U   /** @brief SPI Reset.                */

/**
 * @brief The following are defines for the bit fields in the SPIFFRX register
 */
#define SPI_FFRX_RXFFIL_S      0U
#define SPI_FFRX_RXFFIL_M      0x1FU     /** @brief RXFIFO Interrupt Level.  */
#define SPI_FFRX_RXFFIENA      0x20U     /** @brief RXFIFO Interrupt Enable. */
#define SPI_FFRX_RXFFINTCLR    0x40U     /** @brief RXFIFO Interupt Clear.   */
#define SPI_FFRX_RXFFINT       0x80U     /** @brief RXFIFO Interrupt Flag.   */
#define SPI_FFRX_RXFFST_S      8U
#define SPI_FFRX_RXFFST_M      0x1F00U   /** @brief Receive FIFO Status.         */
#define SPI_FFRX_RXFIFORESET   0x2000U   /** @brief RXFIFO Reset.                */
#define SPI_FFRX_RXFFOVFCLR    0x4000U   /** @brief Receive FIFO Overflow Clear. */
#define SPI_FFRX_RXFFOVF       0x8000U   /** @brief Receive FIFO Overflow Flag.  */

/**
 * @brief The following are defines for the bit fields in the SPIFFCT register
 */
#define SPI_FFCT_TXDLY_S   0U
#define SPI_FFCT_TXDLY_M   0xFFU   /** @brief FIFO Transmit Delay Bits. */

/**
 * @brief The following are defines for the bit fields in the SPIPRI register
 */
#define SPI_PRI_TRIWIRE   0x1U    /** @brief 3-wire mode select bit. */
#define SPI_PRI_STEINV    0x2U    /** @brief SPISTE inversion bit.   */
#define SPI_PRI_FREE      0x10U   /** @brief Free emulation mode.    */
#define SPI_PRI_SOFT      0x20U   /** @brief Soft emulation mode.    */

/**
 * @brief The following are defines for the bit fields in the DMA_REQ_TIMEOUT register
 */
#define SPI_DMA_REQ_TIMEOUT_DMA_REQ_INT_ENA         0x1U
#define SPI_DMA_REQ_TIMEOUT_DMA_REQ_INT_CLR         0x2U
#define SPI_DMA_REQ_TIMEOUT_DMA_RX_REQ_TIMEOUT_S    3U
#define SPI_DMA_REQ_TIMEOUT_DMA_RX_REQ_TIMEOUT_M    0x4U

/**
 * @brief The following are defines for the bit fields in the DMA_REQ_TIMEOUT_TH register
 */
#define SPI_DMA_REQ_TIMEOUT_TH_S    0U
#define SPI_DMA_REQ_TIMEOUT_TH_M    0xFFFFFFFFU

#define SPI_CTL_CONTROLLER_PERIPHERAL    SPI_CTL_MASTER_SLAVE
#define SPI_PRI_PTEINV                   SPI_PRI_STEINV

#endif /* version */

#ifdef __cplusplus
}
#endif

#endif /* DRIVERLIB_INC_HW_SPI_V30_H_ */
