/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_apb.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_SYSCTL_APB_H_
#define DEVICE_DRIVERLIB_SYSCTL_APB_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the apb1_comm_para register offsets

#if  IS_GS32F00xx()
// SPI master mode configuration.
#define APB1_COMM_PARA_SPI_MASTER_MODE		0X0U
// CAN FD enable configuration.
#define APB1_COMM_PARA_CAN_FD_ENABLE		0X20U
// CAN0 HOST IF report.
#define APB1_COMM_PARA_CAN0_HOST_IF		0X24U
// CAN1 HOST IF report.
#define APB1_COMM_PARA_CAN1_HOST_IF		0X28U
// APB domain memory parameter configuration.
#define APB1_COMM_PARA_APB_MEM_CTRL		0X30U
// APB domain memory low-power configuration.
#define APB1_COMM_PARA_APB_MEM_PWR_CTRL		0X34U
// Timer source selection for debug pause.
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_1		0X44U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_2		0X48U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_3		0X4CU
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_4		0X50U
#else
// SPI master mode configuration.
#define APB1_COMM_PARA_SPI_MASTER_MODE              0X0U

// CAN FD enable configuration.
#define APB1_COMM_PARA_CAN_FD_ENABLE                0X10U
// CAN0 HOST IF report.
#define APB1_COMM_PARA_CAN0_HOST_IF                 0X20U
// CAN1 HOST IF report.
#define APB1_COMM_PARA_CAN1_HOST_IF                 0X24U
// CAN2 HOST IF report.
#define APB1_COMM_PARA_CAN2_HOST_IF                 0X28U
// CAN3 HOST IF report.
#define APB1_COMM_PARA_CAN3_HOST_IF                 0X2CU

// APB domain memory parameter configuration.
#define APB1_COMM_PARA_APB_MEM_CTRL                 0X30U
// APB domain memory low-power configuration.
#define APB1_COMM_PARA_APB_MEM_PWR_CTRL             0X34U

#define APB1_COMM_PARA_SMP_EN                       0X40U
#define APB1_COMM_PARA_SMP_MODE                     0X44U
#define APB1_COMM_PARA_SMP_GAP                      0X48U
#define APB1_COMM_PARA_SMP_LEN                      0X4CU

// Timer source selection for debug pause.
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_1      0X50U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_2      0X54U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_3      0X58U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_4      0X5CU
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_5      0X60U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_6      0X64U
#endif

// The following are defines for the bit fields in the SPI_MASTER_MODE_0 register by apb1_comm_para

#define APB1_COMM_PARA_SPI_MASTER_MODE_SPI1_MASTER_MODE_M		0X10U
#define APB1_COMM_PARA_SPI_MASTER_MODE_SPI1_MASTER_MODE_S		4U
#define APB1_COMM_PARA_SPI_MASTER_MODE_SPI0_MASTER_MODE_M		0X1U
#define APB1_COMM_PARA_SPI_MASTER_MODE_SPI0_MASTER_MODE_S		0U

// The following are defines for the bit fields in the CAN_FD_ENABLE_0 register by apb1_comm_para

#define APB1_COMM_PARA_CAN_FD_ENABLE_CAN1_FD_ENABLE_M		0X10U
#define APB1_COMM_PARA_CAN_FD_ENABLE_CAN1_FD_ENABLE_S		4U
#define APB1_COMM_PARA_CAN_FD_ENABLE_CAN0_FD_ENABLE_M		0X1U
#define APB1_COMM_PARA_CAN_FD_ENABLE_CAN0_FD_ENABLE_S		0U

// The following are defines for the bit fields in the CAN0_HOST_IF_0 register by apb1_comm_para

#define APB1_COMM_PARA_CAN0_HOST_IF_CAN0_HOST_IF_M		0X7FFFFU
#define APB1_COMM_PARA_CAN0_HOST_IF_CAN0_HOST_IF_S		0U

// The following are defines for the bit fields in the CAN1_HOST_IF_0 register by apb1_comm_para

#define APB1_COMM_PARA_CAN1_HOST_IF_CAN1_HOST_IF_M		0X7FFFFU
#define APB1_COMM_PARA_CAN1_HOST_IF_CAN1_HOST_IF_S		0U

// The following are defines for the bit fields in the APB_MEM_CTRL_0 register by apb1_comm_para

// Reserved
#define APB1_COMM_PARA_APB_MEM_CTRL_CAN_RAM_MEM_CTRL_M		0XFFFFFFFFU
#define APB1_COMM_PARA_APB_MEM_CTRL_CAN_RAM_MEM_CTRL_S		0U

// The following are defines for the bit fields in the APB_MEM_PWR_CTRL_0 register by apb1_comm_para

// Reserved
#define APB1_COMM_PARA_APB_MEM_PWR_CTRL_CAN_RAM_MEM_PWR_CTRL_M		0XFFFFFFFFU
#define APB1_COMM_PARA_APB_MEM_PWR_CTRL_CAN_RAM_MEM_PWR_CTRL_S		0U

// The following are defines for the bit fields in the TIMER_DEBUG_STOP_MASK_1 register by apb1_comm_para

// bit1: corresponds to DSP debug, 1 = enable, 0 = mask
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_1_TIMER_DEBUG_STOP_MASK_M		0X3U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_1_TIMER_DEBUG_STOP_MASK_S		0U

// The following are defines for the bit fields in the TIMER_DEBUG_STOP_MASK_2 register by apb1_comm_para

// bit1: corresponds to DSP debug, 1 = enable, 0 = mask
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_2_TIMER_DEBUG_STOP_MASK_M		0X3U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_2_TIMER_DEBUG_STOP_MASK_S		0U

// The following are defines for the bit fields in the TIMER_DEBUG_STOP_MASK_3 register by apb1_comm_para

// bit1: corresponds to DSP debug, 1 = enable, 0 = mask
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_3_TIMER_DEBUG_STOP_MASK_M		0X3U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_3_TIMER_DEBUG_STOP_MASK_S		0U

// The following are defines for the bit fields in the TIMER_DEBUG_STOP_MASK_4 register by apb1_comm_para

// bit1: corresponds to DSP debug, 1 = enable, 0 = mask
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_4_TIMER_DEBUG_STOP_MASK_M		0X3U
#define APB1_COMM_PARA_TIMER_DEBUG_STOP_MASK_4_TIMER_DEBUG_STOP_MASK_S		0U


 #ifdef __cplusplus
}
#endif

#endif /* DEVICE_DRIVERLIB_SYSCTL_APB_H_ */
