/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_crg_v30.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_SYSCTL_CRG_V30_H_
#define DEVICE_DRIVERLIB_HW_SYSCTL_CRG_V30_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x30)

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define CRG_CFG_O_CRG_CFG_LOCK                      0x000    //lock control
#define CRG_CFG_O_REF_CLK_SEL                       0x004    //PLL reference clock selection
#define CRG_CFG_O_S2N_CLK_SEL                       0x008    //slow to normal clock switch
#define CRG_CFG_O_CAN_CORE_CLK_SEL                  0x00C    //CAN CORE clock selection
#define CRG_CFG_O_CFG_DIV_DSP_SYS                   0x010    //DSP clk div
#define CRG_CFG_O_CFG_DIV_PERI_SYS                  0x014    //PERI clk div
#define CRG_CFG_O_CFG_DIV_APB_SYS                   0x018    //APB clk div
#define CRG_CFG_O_CFG_SYS_DIV_LOAD_POS              0x01C    //load core/peri/apb div
#define CRG_CFG_O_LIN_CLK_DIV                       0x020    //lin clk div
#define CRG_CFG_O_SMW_CLK_DIV                       0x024    //smw clk div
#define CRG_CFG_O_CFG_DIV_CAN                       0x028    //can clk div
#define CRG_CFG_O_CFG_DIV_HRCAP                     0x02C    //hrcap clk div
#define CRG_CFG_O_CFG_DSP_WDG_CLK_PRE_DIV           0x038    //dsp wdg clk pre div
#define CRG_CFG_O_CFG_DSP_WDG_CLK_SCALER_DIV        0x03C    //dsp wdg clk scaler div
#define CRG_CFG_O_CFG_DBG_WDT_HOLD_EN               0x040    //hold WDG on debug halt
#define CRG_CFG_O_DSP_WDG_RST_EN                    0x048    //dsp_wdg
#define CRG_CFG_O_CFG_CMD_EN                        0x050    //CMD enable
#define CRG_CFG_O_CFG_CMD_ST_CLR                    0x054    //CMD status_clear
#define CRG_CFG_O_CMD_CHECK_FAIL_RPT                0x058    //CMD check report
#define CRG_CFG_O_TEST_MUX_EN                       0x060    //TEST_MUX_EN
#define CRG_CFG_O_TEST_MUX_SEL                      0x064    //TEST_MUX_SEL
#define CRG_CFG_O_OBS_SIG_SEL                       0x068    //OBS_SIG_SEL
#define CRG_CFG_O_OBS_SIG_DIV                       0x06C    //OBS_SIG_DIV
#define CRG_CFG_O_X1_CNT                            0x070    //X1 clock selfcheck count
#define CRG_CFG_O_CORE_RST_RECORD                   0x074    //reset cause record

#define CRG_CFG_O_PLL_PD                            0x200    //PLL Power down
#define CRG_CFG_O_PLL_BYPASS                        0x204    //PLL bypass
#define CRG_CFG_O_PLL_OTHPD_CFG                     0x208    //PLL OTHPD
#define CRG_CFG_O_PLL_DIV_CFG                       0x20C    //PLL DIV
#define CRG_CFG_O_PLL_FBDIV_CFG                     0x210    //PLL Feedback divide value
#define CRG_CFG_O_PLL_FRAC_CFG                      0x214    //PLL Fractional portion of feedback divide value
#define CRG_CFG_O_PLL_DIVVAL                        0x21C    //PLL sscg divider setting
#define CRG_CFG_O_PLL_SPREAD                        0x220    //PLL spread amplitude
#define CRG_CFG_O_PLL_DOWNSPREAD                    0x224    //PLL enable  downspread mode
#define CRG_CFG_O_PLL_EXT_MAXADDR                   0x228    //PLL external max addr
#define CRG_CFG_O_PLL_SEL_EXTWAVE                   0x22C    //PLL external wave value
#define CRG_CFG_O_PLL_RESETPTR                      0x230    //PLL synchronized reset to TBLADDR
#define CRG_CFG_O_PLL_DISABLE_SSCG                  0x234    //PLL bypass sscg
#define CRG_CFG_O_PLL_UNLCK                         0x238    //PLL unlock status
#define CRG_CFG_O_PLL_LCK                           0x23C    //PLL lock status

#define CRG_CFG_O_OSC1_TRIM_OSC_EN                  0x300    //OSC1 trim enable
#define CRG_CFG_O_OSC1_TRIM_OSC_STEP_NUM            0x304    //OSC1 trim step
#define CRG_CFG_O_OSC1_TRIM_OSC_CALC_NUM            0x308    //OSC1 trim
#define CRG_CFG_O_OSC1_TRIM_OSC_WAIT_NUM            0x30C    //OSC1 trim wait
#define CRG_CFG_O_OSC1_TRIM_REF_CALC_NUM            0x310    //OSC1
#define CRG_CFG_O_OSC1_TRIM_OVER                    0x314    //OSC1 trim over
#define CRG_CFG_O_OSC2_TRIM_OSC_EN                  0x320    //OSC2 trim enable
#define CRG_CFG_O_OSC2_TRIM_OSC_STEP_NUM            0x324    //OSC2 trim step
#define CRG_CFG_O_OSC2_TRIM_OSC_CALC_NUM            0x328    //OSC2
#define CRG_CFG_O_OSC2_TRIM_OSC_WAIT_NUM            0x32C    //OSC2 trim wait
#define CRG_CFG_O_OSC2_TRIM_REF_CALC_NUM            0x330    //OSC2
#define CRG_CFG_O_OSC2_TRIM_OVER                    0x334    //OSC2 trim over
#define CRG_CFG_O_OSC_TRIM_VALUE_RPT                0x340    //OSC trim value report
#define CRG_CFG_O_OSC_TRIM_REFCLK_SEL               0x344    //OSC trim clock source selection

#define CRG_CFG_O_SRST_SYS                          0x400    //system soft reset
#define CRG_CFG_O_SRST_EFLASH_CTRL_N                0x504    //eflash ctrl soft reset
#define CRG_CFG_O_SRST_DMA_N                        0x50C    //dma soft reset

#define CRG_CFG_O_EFLASH_CTRL_CLK_EN                0x600    //eflash ctrl clock enable
#define CRG_CFG_O_DMA_CLK_ICG_BYPASS                0x608    //dma ICG bypass
#define CRG_CFG_O_DSP_CLK_ICG_BYPASS                0x60C    //dsp ICG bypass
#define CRG_CFG_O_CFG_STANDBY                       0x614    //standby setup
#define CRG_CFG_O_CFG_WDG_WAKE_EN                   0x618    //WDG wakeup setup
#define CRG_CFG_O_CFG_GPIO_WAKE_EN                  0x61C    //GPIO wakeup setup
#define CRG_CFG_O_CFG_CMP_WAKE_EN                   0x620    //CMPSS wakeup enable
#define CRG_CFG_O_PARA_ICG_BYPASS                   0x6FC    //PARA_ICG

#define CRG_CFG_O_TOP_CRG_SYS_SPARE0                0xF00    //reserved
#define CRG_CFG_O_TOP_CRG_SYS_SPARE1                0xF04    //reserved
#define CRG_CFG_O_TOP_CRG_SYS_SPARE2                0xF08    //reserved
#define CRG_CFG_O_TOP_CRG_POR_SPARE0                0xF0C    //reserved
#define CRG_CFG_O_TOP_CRG_POR_SPARE1                0xF10    //reserved
#define CRG_CFG_O_TOP_CRG_POR_SPARE2                0xF14    //reserved
#define CRG_CFG_O_TOP_CRG_XRS_SPARE0                0xF18    //reserved
#define CRG_CFG_O_TOP_CRG_XRS_SPARE1                0xF1C    //reserved
#define CRG_CFG_O_TOP_CRG_XRS_SPARE2                0xF20    //reserved

#ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_HW_CRG_CFGIGH_H_ */
