/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_dig.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_SYSCTL_DIG_V12_H_
#define DEVICE_DRIVERLIB_HW_SYSCTL_DIG_V12_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x12)

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the sysctl_dig register offsets

// Lock control register
#define SYSCTL_O_SYSCTRL_LOCK		0x0000U

// Memory control signals (0x200~0x2FF)
#define SYSCTL_O_CCM_MEM_CTRL                 0x200      // RAM parameter configuration register
#define SYSCTL_O_CCM_MEM_PWR_CTRL             0x204      // RAM low power configuration register
#define SYSCTL_O_FLASH_MEM_CTRL               0x208      // Flash memory parameter configuration register
#define SYSCTL_O_FLASH_MEM_PWR_CTRL           0x20C      // Flash memory low power configuration register
#define SYSCTL_O_GS_MEM_CTRL                  0x210      // GS RAM parameter configuration register
#define SYSCTL_O_GS_MEM_PWR_CTRL              0x214      // GS RAM low power configuration register
#define SYSCTL_O_SRAM1_MEM_CTRL               0x218      // SRAM1 parameter configuration register
#define SYSCTL_O_SRAM1_MEM_PWR_CTRL           0x21C      // SRAM1 low power configuration register
#define SYSCTL_O_DSP_MEM_CTRL                 0x220      // DSP memory parameter configuration register
#define SYSCTL_O_DSP_MEM_PWR_CTRL             0x224      // DSP memory low power configuration register

// ECC error report (0x300~0x3FF)
#define SYSCTL_O_CCM_ECC_ERR_RPT              0x300      // ECC error report
#define SYSCTL_O_CCM_ECC_SYNDROME_RPT         0x304      // ECC syndrome report
#define SYSCTL_O_SRAM1_PARITY_RPT             0x308      // SRAM1 odd parity error report
#define SYSCTL_O_GS_PARITY_RPT                0x30C      // GS RAM odd parity error report
#define SYSCTL_O_LM_PARITY_RPT                0x310      // DSP LM odd parity error report
#define SYSCTL_O_FLASH_ICACHE_ECC_ERR_RPT     0x314      // Flash cache ECC error report
#define SYSCTL_O_PVM_INT_RPT                  0x318      // PVM report

// GS RAM configuration (0x400~0x4FF)
#define SYSCTL_O_GS_SRAM_SMP_MODE             0x400      // GS RAM data sampling mode configuration register
#define SYSCTL_O_FFT_RAM_MODE                 0x404      // FFT RAM mode configuration register

// Boot control (0x400~0x4FF)
#define SYSCTL_O_BOOT_PIN_LATCH_MSK           0x500      // Boot pin latch control, affected by system reset
#define SYSCTL_O_BOOT_PIN_LATCH_RPT           0x504      // Boot pin latch value report
#define SYSCTL_O_BUS_REMAP_CFG                0x508      // Software configuration for Bus Matrix Remap
#define SYSCTL_O_BUS_REMAP_RPT                0x50C      // Bus Matrix remap report
#define SYSCTL_O_DSP_RESET_VECTOR_RPT         0x510      // DSP initial vector report

// System control (0x600~0x6FF)
#define SYSCTL_O_DSP_STAT_REG                 0x608      // DSP core status report register
#define SYSCTL_O_DSP_RESET_VECTOR             0x60C      // DSP reset vector for slave core
#define SYSCTL_O_DSP_HALT_RPT                 0x610      // DSP halt report
#define SYSCTL_O_DBG_SWEN                     0x614      // Debug switch enable
#define SYSCTL_O_SLV_CORE_JTAG_CFG            0x618      // Slave core JTAG configuration register
#define SYSCTL_O_EFLASH_JTAG_CFG              0x61C      // EFLASH JTAG configuration register
//#define SYSCTL_O_EFC_BIST_ENABLE              0x620      // BIST enable (commented out)
#define SYSCTL_O_BUS_AUSER_ID_CFG             0x628      // BUS_USER_ID configuration
#define SYSCTL_O_SEMA_BUS_AUSER_ID_CFG        0x62C      // SEMA_USER_ID configuration
#define SYSCTL_O_DSP_NMI_MASK                 0x644      // DSP NMI interrupt selection
#define SYSCTL_O_DSP_SYS_ERR_MASK             0x64C      // System error interrupt selection
#define SYSCTL_O_PWM_ECCERR_MASK              0x650      // PWM ECC error masking
#define SYSCTL_O_PWM_SYSFAULT_MASK            0x654      // PWM system fault masking

// Memory initialization (0x700~0x7FF)
#define SYSCTL_O_MEM_INI_REQ                  0x700      // Memory initialization request configuration
#define SYSCTL_O_MEM_INI_DONE_RPT             0x704      // Memory initialization done report

// Miscellaneous
#define SYSCTL_O_PMBUS_CTL_OEN                0x708      // PMBus control output enable
#define SYSCTL_O_SDFM_TYPE_CFG                0x70C      // SDFM type configuration
#define SYSCTL_O_SEC_EN_CFG                   0x710      // Security enable configuration
#define SYSCTL_O_SEC_EN_RPT                   0x714      // Security enable report
#define SYSCTL_O_AES_LITTLE_ENDIAN_AHB        0x71C      // AES endianness configuration for AHB

// Mbist (0x800~0x8FF)
#define SYSCTL_O_MBIST_CFG_PROG_END_IDX       0x800      // MBIST configuration register 0
#define SYSCTL_O_MBIST_CFG_PROG_STA_IDX       0x804      // MBIST configuration register 1
#define SYSCTL_O_MBIST_CFG_PROG_IDX           0x808      // MBIST configuration register 2
#define SYSCTL_O_MBIST_CFG_MAX_VALUE          0x80C      // MBIST configuration register 3
#define SYSCTL_O_MBIST_CFG_MBIST_TRIG         0x810      // MBIST trigger configuration register
#define SYSCTL_O_MBIST_CFG_SC1                0x814      // MBIST configuration register 4
#define SYSCTL_O_MBIST_CFG_SC2                0x818      // MBIST configuration register 5
#define SYSCTL_O_MBIST_CFG_LOCK_MAX_VALUE     0x81C      // MBIST configuration register 6
#define SYSCTL_O_MBIST_RPT                    0x820      // MBIST report register
#define SYSCTL_O_MBIST_ACT_RPT                0x824      // MBIST active report register
#define SYSCTL_O_STC_INTR_RAW                 0x828      // STC interrupt raw register
#define SYSCTL_O_STC_INTR_MASK                0x82C      // STC interrupt mask register
#define SYSCTL_O_STC_INTR                     0x830      // STC interrupt report register

// Reserved registers (0xF00~0xFFF) (POR)
#define SYSCTL_O_DIG_SYSCTL_POR_SPARE0        0xF00      // Reserved register
#define SYSCTL_O_DIG_SYSCTL_POR_SPARE1        0xF04      // Reserved register
#define SYSCTL_O_DIG_SYSCTL_POR_SPARE2        0xF08      // Reserved register

// Reserved registers (0xF00~0xFFF) (SYS)
#define SYSCTL_O_DIG_SYSCTL_SYS_SPARE0        0xF10      // Reserved register
#define SYSCTL_O_DIG_SYSCTL_SYS_SPARE1        0xF14      // Reserved register
#define SYSCTL_O_DIG_SYSCTL_SYS_SPARE2        0xF18      // Reserved register



 #ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_HW_SYSCTL_DIG_H_ */
