/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_dig_v30.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_SYSCTL_DIG_V30_H_
#define DEVICE_DRIVERLIB_HW_SYSCTL_DIG_V30_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x30)

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the sysctl_dig register offsets

// Lock control register.
#define SYSCTL_O_SYSCTRL_LOCK                0x0000U

// Memory control signals (0x200~0x2FF)
#define SYSCTL_O_FLASH_MEM_CTRL              0x200      // RAM parameter configuration register.
#define SYSCTL_O_FLASH_MEM_PWR_CTRL          0x204      // RAM low-power configuration register.
#define SYSCTL_O_GS_MEM_CTRL                 0x208      // RAM parameter configuration register.
#define SYSCTL_O_GS_MEM_PWR_CTRL             0x20C      // RAM low-power configuration register.
#define SYSCTL_O_SWAP_MEM_CTRL               0x210      // RAM parameter configuration register.
#define SYSCTL_O_SWAP_MEM_PWR_CTRL           0x214      // RAM low-power configuration register.
#define SYSCTL_O_DSP_MEM_CTRL                0x218      // RAM parameter configuration register.
#define SYSCTL_O_DSP_MEM_PWR_CTRL            0x21C      // RAM low-power configuration register.

// Error check report (0x300~0x3FF)
#define SYSCTL_O_GS_PARITY_RPT               0x300      // GS RAM odd parity error report.
#define SYSCTL_O_SWAP0_PARITY_RPT            0x304      // SRAM0 odd parity error report.
#define SYSCTL_O_SWAP1_PARITY_RPT            0x308      // SRAM1 odd parity error report.
#define SYSCTL_O_PVM_INT_RPT                 0x318      // PVM report.

// GS RAM configuration (0x400~0x4FF)
#define SYSCTL_O_GS_SRAM_SMP_MODE            0x400      // GS RAM sampling mode configuration register.

// BOOT CTRL (0x400~0x4FF)
#define SYSCTL_O_BOOT_PIN_LATCH_MSK          0x500      // Boot pin latch affected by system reset or not.
#define SYSCTL_O_BOOT_PIN_LATCH_RPT          0x504      // Boot pin latch value.
#define SYSCTL_O_DSP_RESET_VECTOR_RPT        0x510      // DSP reset vector report.

// System control (0x600~0x6FF)
#define SYSCTL_O_DSP_STAT_REG                0x608      // DSP core status report register.
#define SYSCTL_O_DSP_HALT_RPT                0x610      // DSP halt report.
#define SYSCTL_O_DBG_FRC_OFF                 0x614      // DBG_SW.
#define SYSCTL_O_DSP_CORE_JTAG_CFG           0x618      // Slave core JTAG configuration register.
#define SYSCTL_O_EFLASH_CFG                  0x61C      // EFLASH test configuration register.
#define SYSCTL_O_DSP_SYS_ERR_MASK            0x64C      // System error interrupt mask.
#define SYSCTL_O_PWM_ECCERR_MASK             0x650      // PWM ECC error mask.
#define SYSCTL_O_PWM_SYSFAULT_MASK           0x654      // PWM system fault mask.
#define SYSCTL_O_ILM_SWAP_EN                 0x658      // ILM 64K space swap configuration.
#define SYSCTL_O_SRAM_SWAP_EN                0x65C      // SRAM space swap configuration.

// MEM initialization (0x700~0x7FF)
#define SYSCTL_O_MEM_INI_REQ                 0x700      // MEM_INI_REQ configuration.
#define SYSCTL_O_MEM_INI_DONE_RPT            0x704      // Initialization complete report.

// Others
#define SYSCTL_O_PMBUS_CTL_OEN               0x708      // PMBUS_CTL_OEN.
#define SYSCTL_O_SDFM_TYPE_CFG               0x70C      // SDFM_TYPE_CFG.
#define SYSCTL_O_SEC_EN_CFG                  0x710      // Security enable configuration.
#define SYSCTL_O_SEC_EN_RPT                  0x714      // Security enable report.
#define SYSCTL_O_AES_ENDIAN_CFG              0x718      // AES little-endian AHB configuration.
#define SYSCTL_O_FSMC_CFG                    0x71C      // FSMC configuration.
#define SYSCTL_O_HRPWM_CLK_RATE              0x720      // HRPWM clock rate.

// Mbist (0x800~0x8FF)

// SYS_REG (0x900~0x9FF)
#define SYSCTL_O_DIG_SYSCTL_POR_FLAG0        0x900      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_POR_FLAG1        0x904      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_SYS_FLAG0        0x908      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_SYS_FLAG1        0x90C      // Reserved register.

// Reserved registers (0xF00~0xFFF) (POR)
#define SYSCTL_O_DIG_SYSCTL_POR_SPARE0       0xF00      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_POR_SPARE1       0xF04      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_POR_SPARE2       0xF08      // Reserved register.
#define MT5000_100PIN_ENABLE                 0xF08      // 48/49/56/57 IO enable register (MT5000 or MT4000).

// Reserved registers (0xF00~0xFFF) (SYS)
#define SYSCTL_O_DIG_SYSCTL_SYS_SPARE0       0xF10      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_SYS_SPARE1       0xF14      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_SYS_SPARE2       0xF18      // Reserved register.



 #ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_HW_SYSCTL_DIG_H_ */
