/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file    hw_sysctl_io_v30.h
 *   @brief   Definitions for the sysctl_io registers.
 *
 */

#ifndef DEVICE_DRIVERLIB_HW_SYSCTL_IO_V30_H_
#define DEVICE_DRIVERLIB_HW_SYSCTL_IO_V30_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x30)

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//*************************************************************************************************
//
// The following are defines for the GPIO register offsets
//
//*************************************************************************************************

/******************************** IO_CFG_LOCK (0xFFC) *************************************/
#define IO_CFG_PARA_O_IO_CFG_LOCK 0xFFC   // Lock register. After writing the unlock value to this register,
                          	  	  	  	  // all registers protected by lock can be written.
                          	  	  	  	  // Writing the remaining values will lock all registers protected by lock;
                          	  	  	  	  // unlock value:0x5A5A_5A5A

/******************************** GPIO A (0x000~0x07C) *************************************/
#define GPIO_O_GPACTRL 0x0U   // GPIO A Qualification Sampling Period Control (GPIO0 to 31)
#define GPIO_O_GPAQSEL1 0x4U  // GPIO A Qualifier Select 1 Register (GPIO0 to 15)
#define GPIO_O_GPAQSEL2 0x8U  // GPIO A Qualifier Select 2 Register (GPIO16 to 31)
#define GPIO_O_GPAMUX1 0xCU   // GPIO A Mux 1 Register (GPIO0 to 15)
#define GPIO_O_GPAMUX2 0x10U  // GPIO A Mux 2 Register (GPIO16 to 31)
#define GPIO_O_GPADIR 0x14U   // GPIO A Direction Register (GPIO0 to 31)
#define GPIO_O_GPAPUD 0x18U   // GPIO A Pull Up Disable Register (GPIO0 to 31)
#define GPIO_O_GPAINV 0x20U   // GPIO A Input Polarity Invert Registers (GPIO0 to 31)
#define GPIO_O_GPAAMSEL 0x28U // GPIO A Analog Mode Select register (GPIO0 to GPIO31)
#define GPIO_O_GPAGMUX1 0x40U // GPIO A Peripheral Group Mux (GPIO0 to 15)
#define GPIO_O_GPAGMUX2 0x44U // GPIO A Peripheral Group Mux (GPIO16 to 31)

/******************************** GPIO B (0x080~0xFC) *************************************/
#define GPIO_O_GPBCTRL 0x80U  // GPIO B Qualification Sampling Period Control (GPIO32 to 63)
#define GPIO_O_GPBQSEL1 0x84U // GPIO B Qualifier Select 1 Register (GPIO32 to 47)
#define GPIO_O_GPBQSEL2 0x88U // GPIO B Qualifier Select 2 Register (GPIO48 to 63)
#define GPIO_O_GPBMUX1 0x8CU  // GPIO B Mux 1 Register (GPIO32 to 47)
#define GPIO_O_GPBMUX2 0x90U  // GPIO B Mux 2 Register (GPIO48 to 63)
#define GPIO_O_GPBDIR 0x94U   // GPIO B Direction Register (GPIO32 to 63)
#define GPIO_O_GPBPUD 0x98U   // GPIO B Pull Up Disable Register (GPIO32 to 63)
#define GPIO_O_GPBINV 0xA0U   // GPIO B Input Polarity Invert Registers (GPIO32 to 63)
#define GPIO_O_GPBAMSEL 0xA8U // GPIO B Analog Mode Select register (GPIO32 to 63)
#define GPIO_O_GPBGMUX1 0xC0U // GPIO B Peripheral Group Mux (GPIO32 to 47)
#define GPIO_O_GPBGMUX2 0xC4U // GPIO B Peripheral Group Mux (GPIO48 to 63)

/******************************** GPIO G (0x280~0x300) *************************************/
#define GPIO_O_GPGCTRL 0x280U  // GPIO G Qualification Sampling Period Control (GPIO200)
#define GPIO_O_GPGQSEL1 0x284U // GPIO G Qualifier Select 1 Register (GPIO200)
#define GPIO_O_GPGMUX1 0x28CU  // GPIO G Mux 1 Register (GPIO200)
#define GPIO_O_GPGDIR 0x290U   // GPIO G Direction Register (GPIO200)
#define GPIO_O_GPGPUD 0x294U   // GPIO G Pull Up Disable Register (GPIO200)
#define GPIO_O_GPGINV 0x298U   // GPIO G Input Polarity Invert Registers (GPIO200)
#define GPIO_O_GPGAMSEL 0x29CU // GPIO G Analog Mode Select register (GPIO200)
#define GPIO_O_GPGGMUX1 0x2A0U // GPIO G Peripheral Group Mux (GPIO200)

/******************************** GPIO H (0x380~0x3FC) *************************************/
#define GPIO_O_GPHCTRL 0x380U  // GPIO H Qualification Sampling Period Control (GPIO224 to 255)
#define GPIO_O_GPHQSEL1 0x384U // GPIO H Qualifier Select 1 Register (GPIO224 to 239)
#define GPIO_O_GPHQSEL2 0x388U // GPIO H Qualifier Select 2 Register (GPIO240 to 255)
#define GPIO_O_GPHMUX1 0x38CU  // GPIO H Mux 1 Register (GPIO224 to 239)
#define GPIO_O_GPHMUX2 0x390U  // GPIO H Mux 2 Register (GPIO240 to 255)
#define GPIO_O_GPHDIR 0x394U   // GPIO H Direction Register (GPIO224 to 255)
#define GPIO_O_GPHPUD 0x398U   // GPIO H Pull Up Disable Register (GPIO224 to 255)
#define GPIO_O_GPHINV 0x3A0U   // GPIO H Input Polarity Invert Registers (GPIO224 to 255)
#define GPIO_O_GPHAMSEL 0x3A8U // GPIO H Analog Mode Select register (GPIO224 to GPIO255)
#define GPIO_O_GPHGMUX1 0x3C0U // GPIO H Peripheral Group Mux (GPIO224 to 239)
#define GPIO_O_GPHGMUX2 0x3C4U // GPIO H Peripheral Group Mux (GPIO240 to 255)

/************************* GJ  GPIOA Extend Feature (0x400~0x41C) **************************/
#define GPIO_O_GPAPDD 0x400U       // GPIO A Pull Down Disable Register (GPIO0 to 31)
#define GPIO_O_GPADS1 0x404U       // GPIO A Drive Strength 1 Register1 (GPIO0 to 15)
#define GPIO_O_GPADS2 0x408U       // GPIO A Drive Strength Register2 (GPIO16 to 31)
#define GPIO_O_GPAIS 0x40CU        // GPIO A Schmitt Trigger Register (GPIO0 to 31)
#define GPIO_O_GPAOUTINV 0x410U    // GPIO A output Polarity Invert Registers (GPIO0 to 31)
#define GPIO_O_GPALOOPEN 0x414U    // GPIO A LOOP Enable Registers (GPIO0 to 31)
#define GPIO_O_GPAPI2C_MODE 0x418U // GPIO A PI2C MODE Registers (GPIO0 to 31)
#define GPIO_O_GPA_POUT_RPT 0x41CU // IO 0~31 POUT real-time reporting

/************************* GJ  GPIOB Extend Feature (0x420~0x43C) **************************/
#define GPIO_O_GPBPDD 0x420U       // GPIO B Pull Down Disable Register (GPIO32 to 63)
#define GPIO_O_GPBDS1 0x424U       // GPIO B Drive Strength 1 Register1 (GPIO32 to 47)
#define GPIO_O_GPBDS2 0x428U       // GPIO B Drive Strength Register2 (GPIO48 to 63)
#define GPIO_O_GPBIS 0x42CU        // GPIO B Schmitt Trigger Register (GPIO32 to 63)
#define GPIO_O_GPBOUTINV 0x430U    // GPIO B output Polarity Invert Registers (GPIO32 to 63)
#define GPIO_O_GPBLOOPEN 0x434U    // GPIO B LOOP Enable Registers (GPIO32 to 63)
#define GPIO_O_GPBPI2C_MODE 0x438U // GPIO B PI2C MODE Registers (GPIO32 to 63)
#define GPIO_O_GPB_POUT_RPT 0x43CU // IO 32~63 POUT real-time reporting

/************************* GJ  GPIOG Extend Feature  (0x4C0~0x4DC) **************************/
#define GPIO_O_GPGPDD 0x4C0U       // GPIO G Pull Down Disable Register (GPIO200)
#define GPIO_O_GPGDS1 0x4C4U       // GPIO G Drive Strength 1 Register1 (GPIO200)
#define GPIO_O_GPGIS 0x4C8U        // GPIO G Schmitt Trigger Register (GPIO200)
#define GPIO_O_GPGOUTINV 0x4CCU    // GPIO G output Polarity Invert Registers (GPIO200)
#define GPIO_O_GPGLOOPEN 0x4D0U    // GPIO G LOOP Enable Registers (GPIO200)
#define GPIO_O_GPG_POUT_RPT 0x4D4U // IO 200 POUT real-time reporting

/************************* GJ  GPIOH Extend Feature (0x4E0~0x500) **************************/
#define GPIO_O_GPHPDD 0x4E0U       // GPIO H Pull Down Disable Register (GPIO224)
#define GPIO_O_GPHDS1 0x4E4U       // GPIO H Drive Strength 1 Register1 (GPIO224 to 239)
#define GPIO_O_GPHDS2 0x4E8U       // GPIO H Drive Strength 2 Register2 (GPIO240to 255)
#define GPIO_O_GPHIS 0x4ECU        // GPIO G Schmitt Trigger Register (GPIO224 to 248)
#define GPIO_O_GPHOUTINV 0x4F0U    // GPIO H output Polarity Invert Registers (GPIO224~255)
#define GPIO_O_GPHLOOPEN 0x4F4U    // GPIO H LOOP Enable Registers (GPIO224)
#define GPIO_O_GPHIE 0x4F8U        // GPIO H  input Enable Registers (GPIO224 to 255)
#define GPIO_O_GPHPI2C_MODE 0x4FCU // GPIO H PI2C MODE Registers (GPIO224 to 255)
#define GPIO_O_GPH_POUT_RPT 0x500U // IO 224 POUT real-time reporting

/************************* GPIO A DATA_REGISTER (0x600~0x60C) **************************/
#define GPIO_O_GPADAT 0x600U // GPIO A Data Register (GPIO0 to 31)
#define GPIO_O_GPADAT_WR 0x600U // GPIO A Data Write Value Register (GPIO0 to 31)
#define GPIO_O_GPADAT_RE 0x600U // GPIO A Data Read Value Register (GPIO0 to 31)
#define GPIO_O_GPASET 0x604U    // GPIO A  Data Set Register (GPIO0 to 31)
#define GPIO_O_GPACLEAR 0x608U  // GPIO A  Data Clear Register (GPIO0 to 31)
#define GPIO_O_GPATOGGLE 0x60CU // GPIO A  Data Toggle Register (GPIO0 to 31)

/************************* GPIO B DATA_REGISTER (0x610~0x61C) **************************/
#define GPIO_O_GPBDAT 0x610U // GPIO B Data Register (GPIO32 to 63)
#define GPIO_O_GPBDAT_WR 0x610U // GPIO B Data Register Write Value (GPIO32 to 63)
#define GPIO_O_GPBDAT_RE 0x610U // GPIO B Data Register Read Value (GPIO32 to 63)
#define GPIO_O_GPBSET 0x614U    // GPIO B Data Set Register (GPIO32 to 63)
#define GPIO_O_GPBCLEAR 0x618U  // GPIO B Data Clear Register (GPIO32 to 63)
#define GPIO_O_GPBTOGGLE 0x61CU // GPIO B  Data Toggle Register (GPIO0 to 31)

/************************* GPIO G DATA_REGISTER (0x660~0x66C) **************************/
#define GPIO_O_GPGDAT 0x660U // GPG Data register (GPIO200)
#define GPIO_O_GPGDAT_WR 0x660U // GPG Data register Write Value (GPIO200)
#define GPIO_O_GPGDAT_RE 0x660U // GPG Data register Read Value (GPIO200)
#define GPIO_O_GPGSET 0x664U    // GPG Data  Set register(GPIO200)
#define GPIO_O_GPGCLEAR 0x668U  // GPG Data  Clear register(GPIO200)
#define GPIO_O_GPGTOGGLE 0x66CU // GPG Data  Toggle register(GPIO200)

/************************* GPIO H DATA_REGISTER (0x670~0x67C) **************************/
#define GPIO_O_GPHDAT 0x670U // GPH Data register (GPIO224 to 255)
#define GPIO_O_GPHDAT_WR 0x670U // GPH Data register write value(GPIO224 to 255)
#define GPIO_O_GPHDAT_RE 0x670U // GPH Data register read value(GPIO224 to 255)
#define GPIO_O_GPHSET 0x674U    // GPH Data  Set register(GPIO224 to 255)
#define GPIO_O_GPHCLEAR 0x678U  // GPH Data  Clear register(GPIO224 to 255)
#define GPIO_O_GPHTOGGLE 0x67CU // GPH Data  Toggle register(GPIO224 to 255)
/************************* GPIO_DATA_READ_REGISTER (0x700~0x71C) **************************/
#define GPIO_O_GPADAT_R 0x700U // GPA Data Read Register
#define GPIO_O_GPBDAT_R 0x704U // GPB Data Read Register
#define GPIO_O_GPGDAT_R 0x718U // GPG Data Read Register
#define GPIO_O_GPHDAT_R 0x71CU // GPH Data Read Register

/************************* GPIOA (Version: 035,027)  (0x800~0x818) **************************/
#define GPIO_O_GPACTRL_3527 0x800U  // "GPIO A Qualification Sampling Period Control (GPIO0 to 31)"
#define GPIO_O_GPAQSEL1_3527 0x804U // GPIO A Qualifier Select 1 Register (GPIO0 to 15)
#define GPIO_O_GPAQSEL2_3527 0x808U // GPIO A Qualifier Select 2 Register (GPIO16 to 31)
#define GPIO_O_GPAMUX1_3527 0x80CU  // GPIO A Mux 1 Register (GPIO0 to 15)
#define GPIO_O_GPAMUX2_3527 0x810U  // GPIO A Mux 2 Register (GPIO16 to 31)
#define GPIO_O_GPADIR_3527 0x814U   // GPIO A Direction Register (GPIO0 to 31)
#define GPIO_O_GPAPUD_3527 0x818U   // GPIO A Pull Up Disable Register (GPIO0 to 31)

/************************* GPIOB (Version: 035,027)  (0x820~0x838) **************************/
#define GPIO_O_GPBCTRL_3527 0x820U  // GPIO B Qualification Sampling Period Control (GPIO32 to 63)
#define GPIO_O_GPBQSEL1_3527 0x824U // GPIO B Qualifier Select 1 Register (GPIO32 to 47)
#define GPIO_O_GPBMUX1_3527 0x82CU  // GPIO B Mux 1 Register (GPIO32 to 47)
#define GPIO_O_GPBDIR_3527 0x834U   // GPIO B Direction Register (GPIO32 to 63)
#define GPIO_O_GPBPUD_3527 0x838U   // GPIO B Pull Up Disable Register (GPIO32 to 63)

/************************* AIO (Version: 035,027)  (0x86C~0x874) **************************/
#define GPIO_O_AIOCTRL_3527 0x860U // AIO Qualification Sampling Period Control (AIO2 to14)
#define GPIO_O_AIOQSEL1 0x864U     // AIO Qualifier Select 1 Register (AIO2 to 14)
#define GPIO_O_AIOMUX1 0x86CU      // AIO Mux 1 Register (AIO0 to 14)
#define GPIO_O_AIODS1 0x870U       // AIO Drive Strength 1 Register1 (AIO2 to 14)
#define GPIO_O_AIODIR 0x874U       // AIO Direction Register (AIO0 to 14)
#define GPIO_O_AIOMUX2 0x878U      // AIO Mux 2 Register (AIO0 to 14)
#define GPIO_O_AIOLOOPEN 0x87CU    // AIO loop Register (AIO0 to 14)

/****************** GPIO A (Version: 035,027) Data_Register  (0x880~0x88C) ********************/
#define GPIO_O_GPADAT_WR_3527 0x880U // GPIO A Data Register  Write value (GPIO0 to 31)
#define GPIO_O_GPADAT_RE_3527 0x880U // GPIO A Data Register  Read value (GPIO0 to 31)
#define GPIO_O_GPASET_3527 0x884U    // GPIO A  Data Set Register (GPIO0 to 31)
#define GPIO_O_GPACLEAR_3527 0x888U  // GPIO A  Data Clear Register (GPIO0 to 31)
#define GPIO_O_GPATOGGLE_3527 0x88CU // GPIO A  Data Toggle Register (GPIO0 to 31)

/****************** GPIO B (Version: 035,027) Data_Register  (0x890~0x89C) ********************/
#define GPIO_O_GPBDAT_WR_3527 0x890U // GPIO B Data Register Write Vlaue (GPIO32 to 63)
#define GPIO_O_GPBDAT_RE_3527 0x890U // GPIO B Data Register Read value (GPIO32 to 63)
#define GPIO_O_GPBSET_3527 0x894U    // GPIO B Data Set Register (GPIO32 to 63)
#define GPIO_O_GPBCLEAR_3527 0x898U  // GPIO B Data Clear Register (GPIO32 to 63)
#define GPIO_O_GPBTOGGLE_3527 0x89CU // GPIO B  Data Toggle Register (GPIO0 to 31)

/****************** AIO (Version: 035,027) Data_Register  (0x8B0~0x8BC) ********************/
#define GPIO_O_AIODAT_WR 0x8B0U // AIO Data Register (AIO0 to 14)
#define GPIO_O_AIODAT_RE 0x8B0U // AIO Data Register (AIO0 to 14)
#define GPIO_O_AIOSET 0x8B4U    // AIO  Data Set Register (AIO0 to 14)
#define GPIO_O_AIOCLEAR 0x8B8U  // AIO Data Clear Register (AIO0 to 14)
#define GPIO_O_AIOTOGGLE 0x8BCU // AIO Data Toggle Register (AIO0 to 14)

/****** GPIO interrupt and low power mode select registers (Version: 035,027)  (0x8C0~0x8D0) ******/
#define GPIO_O_GPIOXINT1SEL 0x8C0U // XINT1 source select register(gpio0-gpio31)
#define GPIO_O_GPIOXINT2SEL 0x8C2U // XINT2 source select register(gpio0-gpio31)
#define GPIO_O_GPIOXINT3SEL 0x8C4U // XINT3 source select register(gpio0-gpio31)
#define GPIO_O_GPIOLPMSEL 0x8D0U   // GPIO Low Power Mode Wakeup Select

/**
 *
 * GPIO Interrupt relative register ( type pol mask clear raw status)
 *
 */

/************************ GPIO A interrupt register (0x900 ~0x914) ************************/
#define GPIO_O_GPA_INTTYPE 0x900U   // GPIO A  Interrrupt type (GPIO0 to 31)
#define GPIO_O_GPA_INTPOL 0x904U    // GPIO A  Interrrupt polarity (GPIO0 to 31)
#define GPIO_O_GPA_INTMASK 0x908U   // GPIO A  Interrrupt mask (GPIO0 to 31)
#define GPIO_O_GPA_INTCLR 0x90CU    // GPIO A  Interrrupt clear (GPIO0 to 31)
#define GPIO_O_GPA_INTRAW 0x910U    // GPIO A  raw Interrrupt  (GPIO0 to 31)
#define GPIO_O_GPA_INTSTATUS 0x914U // GPIO A  Interrrupt states  (GPIO0 to 31)

/************************ GPIO B interrupt register (0x918 ~ 0x92c) ************************/
#define GPIO_O_GPB_INTTYPE 0x918U   // GPIO B  Interrrupt type (GPIO32 to 63)
#define GPIO_O_GPB_INTPOL 0x91CU    // GPIO B  Interrrupt polarity (GPIO32 to 63)
#define GPIO_O_GPB_INTMASK 0x920U   // GPIO B  Interrrupt mask (GPIO32 to 63)
#define GPIO_O_GPB_INTCLR 0x924U    // GPIO B  Interrrupt clear (GPIO32 to 63)
#define GPIO_O_GPB_INTRAW 0x928U    // GPIO B  raw Interrrupt  (GPIO32 to 63)
#define GPIO_O_GPB_INTSTATUS 0x92CU // GPIO B  Interrrupt states  (GPIO32 to 63)

/************  JTAG Port mode_035(0x954)(The address in the ti document is 0x702A) **********/
#define GPIO_O_JTAGDEBUG 0x954U // JTAG debug register

/************************ GPIO G interrupt register (0x990 ~ 0x9a4) ************************/
#define GPIO_O_GPG_INTTYPE 0x990U   // GPIO G  Interrrupt type (AGPIOx200)
#define GPIO_O_GPG_INTPOL 0x994U    // GPIO G  Interrrupt polarity (AGPIO200)
#define GPIO_O_GPG_INTMASK 0x998U   // GPIO G  Interrrupt mask (AGPIO200)
#define GPIO_O_GPG_INTCLR 0x99CU    // GPIO G  Interrrupt clear (AGPIO200)
#define GPIO_O_GPG_INTRAW 0x9A0U    // GPIO G  raw Interrrupt  (AGPIO200)
#define GPIO_O_GPG_INTSTATUS 0x9A4U // GPIO G  Interrrupt states  (AGPIO200)

/************************ GPIO H interrupt register (0x9a8 ~ 0x9bc) ************************/
#define GPIO_O_GPH_INTTYPE 0x9A8U   // GPIO H  Interrrupt type (AGPIO224 to 255)
#define GPIO_O_GPH_INTPOL 0x9ACU    // GPIO H  Interrrupt polarity  (AGPIO224 to 255)
#define GPIO_O_GPH_INTMASK 0x9B0U   // GPIO H  Interrrupt mask (AGPIO224 to 255)
#define GPIO_O_GPH_INTCLR 0x9B4U    // GPIO H  Interrrupt clear (AGPIO224 to 255)
#define GPIO_O_GPH_INTRAW 0x9B8U    // GPIO H  raw Interrrupt  (AGPIO224 to 255)
#define GPIO_O_GPH_INTSTATUS 0x9BCU // GPIO H  Interrrupt states  (AGPIO224 to 255)

/************************ gpio a interrupt register version 3527 (0xa00 ~0xa14) ************************/
#define GPIO_O_GPA_INTTYPE_3527 0xA00U   // GPIO A  Interrrupt type (GPIO0 to 31)
#define GPIO_O_GPA_INTPOL_3527 0xA04U    // GPIO A  Interrrupt polarity (GPIO0 to 31)
#define GPIO_O_GPA_INTMASK_3527 0xA08U   // GPIO A  Interrrupt mask (GPIO0 to 31)
#define GPIO_O_GPA_INTCLR_3527 0xA0CU    // GPIO A  Interrrupt clear (GPIO0 to 31)
#define GPIO_O_GPA_INTRAW_3527 0xA10U    // GPIO A  raw Interrrupt  (GPIO0 to 31)
#define GPIO_O_GPA_INTSTATUS_3527 0xA14U // GPIO A  Interrrupt states  (GPIO0 to 31)

/************************ gpio b interrupt register version 3527 (0xa18 ~ 0xa2c) ************************/
#define GPIO_O_GPB_INTTYPE_3527 0xA18U   // GPIO B  Interrrupt type (GPIO32 to 63)
#define GPIO_O_GPB_INTPOL_3527 0xA1CU    // GPIO B  Interrrupt polarity (GPIO32 to 63)
#define GPIO_O_GPB_INTMASK_3527 0xA20U   // GPIO B  Interrrupt mask (GPIO32 to 63)
#define GPIO_O_GPB_INTCLR_3527 0xA24U    // GPIO B  Interrrupt clear (GPIO32 to 63)
#define GPIO_O_GPB_INTRAW_3527 0xA28U    // GPIO B  raw Interrrupt  (GPIO32 to 63)
#define GPIO_O_GPB_INTSTATUS_3527 0xA2CU // GPIO B  Interrrupt states  (GPIO32 to 63)

/************************ aio interrupt register version 3527 (0xa60 ~ 0xa74) ************************/
#define AIO_O_INTTYPE_3527 0xA60U   // AIO  Interrrupt type (AIO2 to 14)
#define AIO_O_INTPOL_3527 0xA64U    // AIO  Interrrupt polarity (AIO2 to 14)
#define AIO_O_INTMASK_3527 0xA68U   // AIO  Interrrupt mask (AIO2 to 14)
#define AIO_O_INTCLR_3527 0xA6CU    // AIO  Interrrupt clear (AIO2 to 14)
#define AIO_O_INTRAW_3527 0xA70U    // AIO  Interrrupt status (AIO2 to 14)
#define AIO_O_INTSTATUS_3527 0xA74U // AIO  Interrrupt raw (AIO2 to 14)

/************************ Other control configurations for digital IO (0xF00~0xF5C) ************************/
#define GPIO_O_CLK_REF_PIN_CTRL 0xF00U // Reference clock mode configuration
#define GPIO_O_AUXCLKIN_SEL 0xF04U     // Auxclkin selection
#define GPIO_O_AUXCLKIN_EN 0xF08U      // Auxclkin enabled
#define GPIO_O_LPMCR_QUALSTDBY 0xF50U  // IO Quantization Register (GPIO-WAKE.UP)
// #define GPIO_O_IO_SET_STBY 0xF54U      // IOx Control Configuration
#define GPIO_O_GPIOLPMSEL0 0xF58U      // GPIO Low Power Mode Wakeup Select0
#define GPIO_O_GPIOLPMSEL1 0xF5CU      // GPIO Low Power Mode Wakeup Select1
#define GPIO_O_CLB_HRPWM_EX_EN 0xF60U  // CLB - epwm exchange enable

/*************************************************************************************************
 *
 * The following are defines for the bit fields in the GPACTRL register
 *
 *************************************************************************************************/
#define GPIO_GPACTRL_QUALPRD0_S 0U
#define GPIO_GPACTRL_QUALPRD0_M 0xFFU // Qualification sampling period for GPIO0 to GPIO7
#define GPIO_GPACTRL_QUALPRD1_S 8U
#define GPIO_GPACTRL_QUALPRD1_M 0xFF00U // Qualification sampling period for GPIO8 to GPIO15
#define GPIO_GPACTRL_QUALPRD2_S 16U
#define GPIO_GPACTRL_QUALPRD2_M 0xFF0000U // Qualification sampling period for GPIO16 to GPIO23
#define GPIO_GPACTRL_QUALPRD3_S 24U
#define GPIO_GPACTRL_QUALPRD3_M 0xFF000000U // Qualification sampling period for GPIO24 to GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAQSEL1 register
//
//*************************************************************************************************
#define GPIO_GPAQSEL1_GPIO0_S 0U
#define GPIO_GPAQSEL1_GPIO0_M 0x3U // Select input qualification type for GPIO0
#define GPIO_GPAQSEL1_GPIO1_S 2U
#define GPIO_GPAQSEL1_GPIO1_M 0xCU // Select input qualification type for GPIO1
#define GPIO_GPAQSEL1_GPIO2_S 4U
#define GPIO_GPAQSEL1_GPIO2_M 0x30U // Select input qualification type for GPIO2
#define GPIO_GPAQSEL1_GPIO3_S 6U
#define GPIO_GPAQSEL1_GPIO3_M 0xC0U // Select input qualification type for GPIO3
#define GPIO_GPAQSEL1_GPIO4_S 8U
#define GPIO_GPAQSEL1_GPIO4_M 0x300U // Select input qualification type for GPIO4
#define GPIO_GPAQSEL1_GPIO5_S 10U
#define GPIO_GPAQSEL1_GPIO5_M 0xC00U // Select input qualification type for GPIO5
#define GPIO_GPAQSEL1_GPIO6_S 12U
#define GPIO_GPAQSEL1_GPIO6_M 0x3000U // Select input qualification type for GPIO6
#define GPIO_GPAQSEL1_GPIO7_S 14U
#define GPIO_GPAQSEL1_GPIO7_M 0xC000U // Select input qualification type for GPIO7
#define GPIO_GPAQSEL1_GPIO8_S 16U
#define GPIO_GPAQSEL1_GPIO8_M 0x30000U // Select input qualification type for GPIO8
#define GPIO_GPAQSEL1_GPIO9_S 18U
#define GPIO_GPAQSEL1_GPIO9_M 0xC0000U // Select input qualification type for GPIO9
#define GPIO_GPAQSEL1_GPIO10_S 20U
#define GPIO_GPAQSEL1_GPIO10_M 0x300000U // Select input qualification type for GPIO10
#define GPIO_GPAQSEL1_GPIO11_S 22U
#define GPIO_GPAQSEL1_GPIO11_M 0xC00000U // Select input qualification type for GPIO11
#define GPIO_GPAQSEL1_GPIO12_S 24U
#define GPIO_GPAQSEL1_GPIO12_M 0x3000000U // Select input qualification type for GPIO12
#define GPIO_GPAQSEL1_GPIO13_S 26U
#define GPIO_GPAQSEL1_GPIO13_M 0xC000000U // Select input qualification type for GPIO13
#define GPIO_GPAQSEL1_GPIO14_S 28U
#define GPIO_GPAQSEL1_GPIO14_M 0x30000000U // Select input qualification type for GPIO14
#define GPIO_GPAQSEL1_GPIO15_S 30U
#define GPIO_GPAQSEL1_GPIO15_M 0xC0000000U // Select input qualification type for GPIO15

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAQSEL2 register
//
//*************************************************************************************************
#define GPIO_GPAQSEL2_GPIO16_S 0U
#define GPIO_GPAQSEL2_GPIO16_M 0x3U // Select input qualification type for GPIO16
#define GPIO_GPAQSEL2_GPIO17_S 2U
#define GPIO_GPAQSEL2_GPIO17_M 0xCU // Select input qualification type for GPIO17
#define GPIO_GPAQSEL2_GPIO18_S 4U
#define GPIO_GPAQSEL2_GPIO18_M 0x30U // Select input qualification type for GPIO18
#define GPIO_GPAQSEL2_GPIO19_S 6U
#define GPIO_GPAQSEL2_GPIO19_M 0xC0U // Select input qualification type for GPIO19
#define GPIO_GPAQSEL2_GPIO20_S 8U
#define GPIO_GPAQSEL2_GPIO20_M 0x300U // Select input qualification type for GPIO20
#define GPIO_GPAQSEL2_GPIO21_S 10U
#define GPIO_GPAQSEL2_GPIO21_M 0xC00U // Select input qualification type for GPIO21
#define GPIO_GPAQSEL2_GPIO22_S 12U
#define GPIO_GPAQSEL2_GPIO22_M 0x3000U // Select input qualification type for GPIO22
#define GPIO_GPAQSEL2_GPIO23_S 14U
#define GPIO_GPAQSEL2_GPIO23_M 0xC000U // Select input qualification type for GPIO23
#define GPIO_GPAQSEL2_GPIO24_S 16U
#define GPIO_GPAQSEL2_GPIO24_M 0x30000U // Select input qualification type for GPIO24
#define GPIO_GPAQSEL2_GPIO25_S 18U
#define GPIO_GPAQSEL2_GPIO25_M 0xC0000U // Select input qualification type for GPIO25
#define GPIO_GPAQSEL2_GPIO26_S 20U
#define GPIO_GPAQSEL2_GPIO26_M 0x300000U // Select input qualification type for GPIO26
#define GPIO_GPAQSEL2_GPIO27_S 22U
#define GPIO_GPAQSEL2_GPIO27_M 0xC00000U // Select input qualification type for GPIO27
#define GPIO_GPAQSEL2_GPIO28_S 24U
#define GPIO_GPAQSEL2_GPIO28_M 0x3000000U // Select input qualification type for GPIO28
#define GPIO_GPAQSEL2_GPIO29_S 26U
#define GPIO_GPAQSEL2_GPIO29_M 0xC000000U // Select input qualification type for GPIO29
#define GPIO_GPAQSEL2_GPIO30_S 28U
#define GPIO_GPAQSEL2_GPIO30_M 0x30000000U // Select input qualification type for GPIO30
#define GPIO_GPAQSEL2_GPIO31_S 30U
#define GPIO_GPAQSEL2_GPIO31_M 0xC0000000U // Select input qualification type for GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAMUX1 register
//
//*************************************************************************************************
#define GPIO_GPAMUX1_GPIO0_S 0U
#define GPIO_GPAMUX1_GPIO0_M 0x3U // Defines pin-muxing selection for GPIO0
#define GPIO_GPAMUX1_GPIO1_S 2U
#define GPIO_GPAMUX1_GPIO1_M 0xCU // Defines pin-muxing selection for GPIO1
#define GPIO_GPAMUX1_GPIO2_S 4U
#define GPIO_GPAMUX1_GPIO2_M 0x30U // Defines pin-muxing selection for GPIO2
#define GPIO_GPAMUX1_GPIO3_S 6U
#define GPIO_GPAMUX1_GPIO3_M 0xC0U // Defines pin-muxing selection for GPIO3
#define GPIO_GPAMUX1_GPIO4_S 8U
#define GPIO_GPAMUX1_GPIO4_M 0x300U // Defines pin-muxing selection for GPIO4
#define GPIO_GPAMUX1_GPIO5_S 10U
#define GPIO_GPAMUX1_GPIO5_M 0xC00U // Defines pin-muxing selection for GPIO5
#define GPIO_GPAMUX1_GPIO6_S 12U
#define GPIO_GPAMUX1_GPIO6_M 0x3000U // Defines pin-muxing selection for GPIO6
#define GPIO_GPAMUX1_GPIO7_S 14U
#define GPIO_GPAMUX1_GPIO7_M 0xC000U // Defines pin-muxing selection for GPIO7
#define GPIO_GPAMUX1_GPIO8_S 16U
#define GPIO_GPAMUX1_GPIO8_M 0x30000U // Defines pin-muxing selection for GPIO8
#define GPIO_GPAMUX1_GPIO9_S 18U
#define GPIO_GPAMUX1_GPIO9_M 0xC0000U // Defines pin-muxing selection for GPIO9
#define GPIO_GPAMUX1_GPIO10_S 20U
#define GPIO_GPAMUX1_GPIO10_M 0x300000U // Defines pin-muxing selection for GPIO10
#define GPIO_GPAMUX1_GPIO11_S 22U
#define GPIO_GPAMUX1_GPIO11_M 0xC00000U // Defines pin-muxing selection for GPIO11
#define GPIO_GPAMUX1_GPIO12_S 24U
#define GPIO_GPAMUX1_GPIO12_M 0x3000000U // Defines pin-muxing selection for GPIO12
#define GPIO_GPAMUX1_GPIO13_S 26U
#define GPIO_GPAMUX1_GPIO13_M 0xC000000U // Defines pin-muxing selection for GPIO13
#define GPIO_GPAMUX1_GPIO14_S 28U
#define GPIO_GPAMUX1_GPIO14_M 0x30000000U // Defines pin-muxing selection for GPIO14
#define GPIO_GPAMUX1_GPIO15_S 30U
#define GPIO_GPAMUX1_GPIO15_M 0xC0000000U // Defines pin-muxing selection for GPIO15

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAMUX2 register
//
//*************************************************************************************************
#define GPIO_GPAMUX2_GPIO16_S 0U
#define GPIO_GPAMUX2_GPIO16_M 0x3U // Defines pin-muxing selection for GPIO16
#define GPIO_GPAMUX2_GPIO17_S 2U
#define GPIO_GPAMUX2_GPIO17_M 0xCU // Defines pin-muxing selection for GPIO17
#define GPIO_GPAMUX2_GPIO18_S 4U
#define GPIO_GPAMUX2_GPIO18_M 0x30U // Defines pin-muxing selection for GPIO18
#define GPIO_GPAMUX2_GPIO19_S 6U
#define GPIO_GPAMUX2_GPIO19_M 0xC0U // Defines pin-muxing selection for GPIO19
#define GPIO_GPAMUX2_GPIO20_S 8U
#define GPIO_GPAMUX2_GPIO20_M 0x300U // Defines pin-muxing selection for GPIO20
#define GPIO_GPAMUX2_GPIO21_S 10U
#define GPIO_GPAMUX2_GPIO21_M 0xC00U // Defines pin-muxing selection for GPIO21
#define GPIO_GPAMUX2_GPIO22_S 12U
#define GPIO_GPAMUX2_GPIO22_M 0x3000U // Defines pin-muxing selection for GPIO22
#define GPIO_GPAMUX2_GPIO23_S 14U
#define GPIO_GPAMUX2_GPIO23_M 0xC000U // Defines pin-muxing selection for GPIO23
#define GPIO_GPAMUX2_GPIO24_S 16U
#define GPIO_GPAMUX2_GPIO24_M 0x30000U // Defines pin-muxing selection for GPIO24
#define GPIO_GPAMUX2_GPIO25_S 18U
#define GPIO_GPAMUX2_GPIO25_M 0xC0000U // Defines pin-muxing selection for GPIO25
#define GPIO_GPAMUX2_GPIO26_S 20U
#define GPIO_GPAMUX2_GPIO26_M 0x300000U // Defines pin-muxing selection for GPIO26
#define GPIO_GPAMUX2_GPIO27_S 22U
#define GPIO_GPAMUX2_GPIO27_M 0xC00000U // Defines pin-muxing selection for GPIO27
#define GPIO_GPAMUX2_GPIO28_S 24U
#define GPIO_GPAMUX2_GPIO28_M 0x3000000U // Defines pin-muxing selection for GPIO28
#define GPIO_GPAMUX2_GPIO29_S 26U
#define GPIO_GPAMUX2_GPIO29_M 0xC000000U // Defines pin-muxing selection for GPIO29
#define GPIO_GPAMUX2_GPIO30_S 28U
#define GPIO_GPAMUX2_GPIO30_M 0x30000000U // Defines pin-muxing selection for GPIO30
#define GPIO_GPAMUX2_GPIO31_S 30U
#define GPIO_GPAMUX2_GPIO31_M 0xC0000000U // Defines pin-muxing selection for GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADIR register
//
//*************************************************************************************************
#define GPIO_GPADIR_GPIO0 0x1U         // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO1 0x2U         // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO2 0x4U         // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO3 0x8U         // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO4 0x10U        // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO5 0x20U        // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO6 0x40U        // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO7 0x80U        // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO8 0x100U       // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO9 0x200U       // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO10 0x400U      // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO11 0x800U      // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO12 0x1000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO13 0x2000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO14 0x4000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO15 0x8000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO16 0x10000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO17 0x20000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO18 0x40000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO19 0x80000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO20 0x100000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO21 0x200000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO22 0x400000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO23 0x800000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO24 0x1000000U  // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO25 0x2000000U  // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO26 0x4000000U  // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO27 0x8000000U  // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO28 0x10000000U // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO29 0x20000000U // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO30 0x40000000U // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO31 0x80000000U // Defines direction for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAPUD register
//
//*************************************************************************************************
#define GPIO_GPAPUD_GPIO0 0x1U         // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO1 0x2U         // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO2 0x4U         // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO3 0x8U         // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO4 0x10U        // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO5 0x20U        // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO6 0x40U        // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO7 0x80U        // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO8 0x100U       // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO9 0x200U       // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO10 0x400U      // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO11 0x800U      // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO12 0x1000U     // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO13 0x2000U     // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO14 0x4000U     // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO15 0x8000U     // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO16 0x10000U    // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO17 0x20000U    // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO18 0x40000U    // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO19 0x80000U    // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO20 0x100000U   // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO21 0x200000U   // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO22 0x400000U   // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO23 0x800000U   // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO24 0x1000000U  // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO25 0x2000000U  // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO26 0x4000000U  // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO27 0x8000000U  // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO28 0x10000000U // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO29 0x20000000U // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO30 0x40000000U // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO31 0x80000000U // Pull-Up Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAINV register
//
//*************************************************************************************************
#define GPIO_GPAINV_GPIO0 0x1U         // Input inversion control for this pin
#define GPIO_GPAINV_GPIO1 0x2U         // Input inversion control for this pin
#define GPIO_GPAINV_GPIO2 0x4U         // Input inversion control for this pin
#define GPIO_GPAINV_GPIO3 0x8U         // Input inversion control for this pin
#define GPIO_GPAINV_GPIO4 0x10U        // Input inversion control for this pin
#define GPIO_GPAINV_GPIO5 0x20U        // Input inversion control for this pin
#define GPIO_GPAINV_GPIO6 0x40U        // Input inversion control for this pin
#define GPIO_GPAINV_GPIO7 0x80U        // Input inversion control for this pin
#define GPIO_GPAINV_GPIO8 0x100U       // Input inversion control for this pin
#define GPIO_GPAINV_GPIO9 0x200U       // Input inversion control for this pin
#define GPIO_GPAINV_GPIO10 0x400U      // Input inversion control for this pin
#define GPIO_GPAINV_GPIO11 0x800U      // Input inversion control for this pin
#define GPIO_GPAINV_GPIO12 0x1000U     // Input inversion control for this pin
#define GPIO_GPAINV_GPIO13 0x2000U     // Input inversion control for this pin
#define GPIO_GPAINV_GPIO14 0x4000U     // Input inversion control for this pin
#define GPIO_GPAINV_GPIO15 0x8000U     // Input inversion control for this pin
#define GPIO_GPAINV_GPIO16 0x10000U    // Input inversion control for this pin
#define GPIO_GPAINV_GPIO17 0x20000U    // Input inversion control for this pin
#define GPIO_GPAINV_GPIO18 0x40000U    // Input inversion control for this pin
#define GPIO_GPAINV_GPIO19 0x80000U    // Input inversion control for this pin
#define GPIO_GPAINV_GPIO20 0x100000U   // Input inversion control for this pin
#define GPIO_GPAINV_GPIO21 0x200000U   // Input inversion control for this pin
#define GPIO_GPAINV_GPIO22 0x400000U   // Input inversion control for this pin
#define GPIO_GPAINV_GPIO23 0x800000U   // Input inversion control for this pin
#define GPIO_GPAINV_GPIO24 0x1000000U  // Input inversion control for this pin
#define GPIO_GPAINV_GPIO25 0x2000000U  // Input inversion control for this pin
#define GPIO_GPAINV_GPIO26 0x4000000U  // Input inversion control for this pin
#define GPIO_GPAINV_GPIO27 0x8000000U  // Input inversion control for this pin
#define GPIO_GPAINV_GPIO28 0x10000000U // Input inversion control for this pin
#define GPIO_GPAINV_GPIO29 0x20000000U // Input inversion control for this pin
#define GPIO_GPAINV_GPIO30 0x40000000U // Input inversion control for this pin
#define GPIO_GPAINV_GPIO31 0x80000000U // Input inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAAMSEL register
//
//*************************************************************************************************
#define GPIO_GPAAMSEL_GPIO11 0x800U      // Analog Mode select for this pin
#define GPIO_GPAAMSEL_GPIO12 0x1000U     // Analog Mode select for this pin
#define GPIO_GPAAMSEL_GPIO13 0x2000U     // Analog Mode select for this pin
#define GPIO_GPAAMSEL_GPIO16 0x10000U    // Analog Mode select for this pin
#define GPIO_GPAAMSEL_GPIO17 0x20000U    // Analog Mode select for this pin
#define GPIO_GPAAMSEL_GPIO20 0x100000U   // Analog Mode select for this pin
#define GPIO_GPAAMSEL_GPIO21 0x200000U   // Analog Mode select for this pin
#define GPIO_GPAAMSEL_GPIO24 0x1000000U  // Analog Mode select for this pin
#define GPIO_GPAAMSEL_GPIO28 0x10000000U // Analog Mode select for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAGMUX1 register
//
//*************************************************************************************************
#define GPIO_GPAGMUX1_GPIO0_S 0U
#define GPIO_GPAGMUX1_GPIO0_M 0x3U // Defines pin-muxing selection for GPIO0
#define GPIO_GPAGMUX1_GPIO1_S 2U
#define GPIO_GPAGMUX1_GPIO1_M 0xCU // Defines pin-muxing selection for GPIO1
#define GPIO_GPAGMUX1_GPIO2_S 4U
#define GPIO_GPAGMUX1_GPIO2_M 0x30U // Defines pin-muxing selection for GPIO2
#define GPIO_GPAGMUX1_GPIO3_S 6U
#define GPIO_GPAGMUX1_GPIO3_M 0xC0U // Defines pin-muxing selection for GPIO3
#define GPIO_GPAGMUX1_GPIO4_S 8U
#define GPIO_GPAGMUX1_GPIO4_M 0x300U // Defines pin-muxing selection for GPIO4
#define GPIO_GPAGMUX1_GPIO5_S 10U
#define GPIO_GPAGMUX1_GPIO5_M 0xC00U // Defines pin-muxing selection for GPIO5
#define GPIO_GPAGMUX1_GPIO6_S 12U
#define GPIO_GPAGMUX1_GPIO6_M 0x3000U // Defines pin-muxing selection for GPIO6
#define GPIO_GPAGMUX1_GPIO7_S 14U
#define GPIO_GPAGMUX1_GPIO7_M 0xC000U // Defines pin-muxing selection for GPIO7
#define GPIO_GPAGMUX1_GPIO8_S 16U
#define GPIO_GPAGMUX1_GPIO8_M 0x30000U // Defines pin-muxing selection for GPIO8
#define GPIO_GPAGMUX1_GPIO9_S 18U
#define GPIO_GPAGMUX1_GPIO9_M 0xC0000U // Defines pin-muxing selection for GPIO9
#define GPIO_GPAGMUX1_GPIO10_S 20U
#define GPIO_GPAGMUX1_GPIO10_M 0x300000U // Defines pin-muxing selection for GPIO10
#define GPIO_GPAGMUX1_GPIO11_S 22U
#define GPIO_GPAGMUX1_GPIO11_M 0xC00000U // Defines pin-muxing selection for GPIO11
#define GPIO_GPAGMUX1_GPIO12_S 24U
#define GPIO_GPAGMUX1_GPIO12_M 0x3000000U // Defines pin-muxing selection for GPIO12
#define GPIO_GPAGMUX1_GPIO13_S 26U
#define GPIO_GPAGMUX1_GPIO13_M 0xC000000U // Defines pin-muxing selection for GPIO13
#define GPIO_GPAGMUX1_GPIO14_S 28U
#define GPIO_GPAGMUX1_GPIO14_M 0x30000000U // Defines pin-muxing selection for GPIO14
#define GPIO_GPAGMUX1_GPIO15_S 30U
#define GPIO_GPAGMUX1_GPIO15_M 0xC0000000U // Defines pin-muxing selection for GPIO15

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAGMUX2 register
//
//*************************************************************************************************
#define GPIO_GPAGMUX2_GPIO16_S 0U
#define GPIO_GPAGMUX2_GPIO16_M 0x3U // Defines pin-muxing selection for GPIO16
#define GPIO_GPAGMUX2_GPIO17_S 2U
#define GPIO_GPAGMUX2_GPIO17_M 0xCU // Defines pin-muxing selection for GPIO17
#define GPIO_GPAGMUX2_GPIO18_S 4U
#define GPIO_GPAGMUX2_GPIO18_M 0x30U // Defines pin-muxing selection for GPIO18
#define GPIO_GPAGMUX2_GPIO19_S 6U
#define GPIO_GPAGMUX2_GPIO19_M 0xC0U // Defines pin-muxing selection for GPIO19
#define GPIO_GPAGMUX2_GPIO20_S 8U
#define GPIO_GPAGMUX2_GPIO20_M 0x300U // Defines pin-muxing selection for GPIO20
#define GPIO_GPAGMUX2_GPIO21_S 10U
#define GPIO_GPAGMUX2_GPIO21_M 0xC00U // Defines pin-muxing selection for GPIO21
#define GPIO_GPAGMUX2_GPIO22_S 12U
#define GPIO_GPAGMUX2_GPIO22_M 0x3000U // Defines pin-muxing selection for GPIO22
#define GPIO_GPAGMUX2_GPIO23_S 14U
#define GPIO_GPAGMUX2_GPIO23_M 0xC000U // Defines pin-muxing selection for GPIO23
#define GPIO_GPAGMUX2_GPIO24_S 16U
#define GPIO_GPAGMUX2_GPIO24_M 0x30000U // Defines pin-muxing selection for GPIO24
#define GPIO_GPAGMUX2_GPIO25_S 18U
#define GPIO_GPAGMUX2_GPIO25_M 0xC0000U // Defines pin-muxing selection for GPIO25
#define GPIO_GPAGMUX2_GPIO26_S 20U
#define GPIO_GPAGMUX2_GPIO26_M 0x300000U // Defines pin-muxing selection for GPIO26
#define GPIO_GPAGMUX2_GPIO27_S 22U
#define GPIO_GPAGMUX2_GPIO27_M 0xC00000U // Defines pin-muxing selection for GPIO27
#define GPIO_GPAGMUX2_GPIO28_S 24U
#define GPIO_GPAGMUX2_GPIO28_M 0x3000000U // Defines pin-muxing selection for GPIO28
#define GPIO_GPAGMUX2_GPIO29_S 26U
#define GPIO_GPAGMUX2_GPIO29_M 0xC000000U // Defines pin-muxing selection for GPIO29
#define GPIO_GPAGMUX2_GPIO30_S 28U
#define GPIO_GPAGMUX2_GPIO30_M 0x30000000U // Defines pin-muxing selection for GPIO30
#define GPIO_GPAGMUX2_GPIO31_S 30U
#define GPIO_GPAGMUX2_GPIO31_M 0xC0000000U // Defines pin-muxing selection for GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBCTRL register
//
//*************************************************************************************************
#define GPIO_GPBCTRL_QUALPRD0_S 0U
#define GPIO_GPBCTRL_QUALPRD0_M 0xFFU // Qualification sampling period for GPIO32 to GPIO39
#define GPIO_GPBCTRL_QUALPRD1_S 8U
#define GPIO_GPBCTRL_QUALPRD1_M 0xFF00U // Qualification sampling period for GPIO40 to GPIO47
#define GPIO_GPBCTRL_QUALPRD2_S 16U
#define GPIO_GPBCTRL_QUALPRD2_M 0xFF0000U // Qualification sampling period for GPIO48 to GPIO55
#define GPIO_GPBCTRL_QUALPRD3_S 24U
#define GPIO_GPBCTRL_QUALPRD3_M 0xFF000000U // Qualification sampling period for GPIO56 to GPIO63

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBQSEL1 register
//
//*************************************************************************************************
#define GPIO_GPBQSEL1_GPIO32_S 0U
#define GPIO_GPBQSEL1_GPIO32_M 0x3U // Select input qualification type for GPIO32
#define GPIO_GPBQSEL1_GPIO33_S 2U
#define GPIO_GPBQSEL1_GPIO33_M 0xCU // Select input qualification type for GPIO33
#define GPIO_GPBQSEL1_GPIO34_S 4U
#define GPIO_GPBQSEL1_GPIO34_M 0x30U // Select input qualification type for GPIO34
#define GPIO_GPBQSEL1_GPIO35_S 6U
#define GPIO_GPBQSEL1_GPIO35_M 0xC0U // Select input qualification type for GPIO35
#define GPIO_GPBQSEL1_GPIO37_S 10U
#define GPIO_GPBQSEL1_GPIO37_M 0xC00U // Select input qualification type for GPIO37
#define GPIO_GPBQSEL1_GPIO39_S 14U
#define GPIO_GPBQSEL1_GPIO39_M 0xC000U // Select input qualification type for GPIO39
#define GPIO_GPBQSEL1_GPIO40_S 16U
#define GPIO_GPBQSEL1_GPIO40_M 0x30000U // Select input qualification type for GPIO40
#define GPIO_GPBQSEL1_GPIO41_S 18U
#define GPIO_GPBQSEL1_GPIO41_M 0xC0000U // Select input qualification type for GPIO41
#define GPIO_GPBQSEL1_GPIO42_S 20U
#define GPIO_GPBQSEL1_GPIO42_M 0x300000U // Select input qualification type for GPIO42
#define GPIO_GPBQSEL1_GPIO43_S 22U
#define GPIO_GPBQSEL1_GPIO43_M 0xC00000U // Select input qualification type for GPIO43
#define GPIO_GPBQSEL1_GPIO44_S 24U
#define GPIO_GPBQSEL1_GPIO44_M 0x3000000U // Select input qualification type for GPIO44
#define GPIO_GPBQSEL1_GPIO45_S 26U
#define GPIO_GPBQSEL1_GPIO45_M 0xC000000U // Select input qualification type for GPIO45
#define GPIO_GPBQSEL1_GPIO46_S 28U
#define GPIO_GPBQSEL1_GPIO46_M 0x30000000U // Select input qualification type for GPIO46

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBQSEL2 register
//
//*************************************************************************************************
#define GPIO_GPBQSEL2_GPIO48_S 0U
#define GPIO_GPBQSEL2_GPIO48_M 0x3U // Select input qualification type for GPIO48
#define GPIO_GPBQSEL2_GPIO49_S 2U
#define GPIO_GPBQSEL2_GPIO49_M 0xCU // Select input qualification type for GPIO49
#define GPIO_GPBQSEL2_GPIO53_S 10U
#define GPIO_GPBQSEL2_GPIO53_M 0xC00U // Select input qualification type for GPIO53
#define GPIO_GPBQSEL2_GPIO54_S 12U
#define GPIO_GPBQSEL2_GPIO54_M 0x3000U // Select input qualification type for GPIO54
#define GPIO_GPBQSEL2_GPIO55_S 14U
#define GPIO_GPBQSEL2_GPIO55_M 0xC000U // Select input qualification type for GPIO55
#define GPIO_GPBQSEL2_GPIO56_S 16U
#define GPIO_GPBQSEL2_GPIO56_M 0x30000U // Select input qualification type for GPIO56
#define GPIO_GPBQSEL2_GPIO57_S 18U
#define GPIO_GPBQSEL2_GPIO57_M 0xC0000U // Select input qualification type for GPIO57
#define GPIO_GPBQSEL2_GPIO58_S 20U
#define GPIO_GPBQSEL2_GPIO58_M 0x300000U // Select input qualification type for GPIO58
#define GPIO_GPBQSEL2_GPIO59_S 22U
#define GPIO_GPBQSEL2_GPIO59_M 0xC00000U // Select input qualification type for GPIO59
#define GPIO_GPBQSEL2_GPIO60_S 24U
#define GPIO_GPBQSEL2_GPIO60_M 0x3000000U // Select input qualification type for GPIO60
#define GPIO_GPBQSEL2_GPIO61_S 26U
#define GPIO_GPBQSEL2_GPIO61_M 0xC000000U // Select input qualification type for GPIO61
#define GPIO_GPBQSEL2_GPIO62_S 28U
#define GPIO_GPBQSEL2_GPIO62_M 0x30000000U // Select input qualification type for GPIO62
#define GPIO_GPBQSEL2_GPIO63_S 30U
#define GPIO_GPBQSEL2_GPIO63_M 0xC0000000U // Select input qualification type for GPIO63

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBMUX1 register
//
//*************************************************************************************************
#define GPIO_GPBMUX1_GPIO32_S 0U
#define GPIO_GPBMUX1_GPIO32_M 0x3U // Defines pin-muxing selection for GPIO32
#define GPIO_GPBMUX1_GPIO33_S 2U
#define GPIO_GPBMUX1_GPIO33_M 0xCU // Defines pin-muxing selection for GPIO33
#define GPIO_GPBMUX1_GPIO34_S 4U
#define GPIO_GPBMUX1_GPIO34_M 0x30U // Defines pin-muxing selection for GPIO34
#define GPIO_GPBMUX1_GPIO35_S 6U
#define GPIO_GPBMUX1_GPIO35_M 0xC0U // Defines pin-muxing selection for GPIO35
#define GPIO_GPBMUX1_GPIO37_S 10U
#define GPIO_GPBMUX1_GPIO37_M 0xC00U // Defines pin-muxing selection for GPIO37
#define GPIO_GPBMUX1_GPIO39_S 14U
#define GPIO_GPBMUX1_GPIO39_M 0xC000U // Defines pin-muxing selection for GPIO39
#define GPIO_GPBMUX1_GPIO40_S 16U
#define GPIO_GPBMUX1_GPIO40_M 0x30000U // Defines pin-muxing selection for GPIO40
#define GPIO_GPBMUX1_GPIO41_S 18U
#define GPIO_GPBMUX1_GPIO41_M 0xC0000U // Defines pin-muxing selection for GPIO41
#define GPIO_GPBMUX1_GPIO42_S 20U
#define GPIO_GPBMUX1_GPIO42_M 0x300000U // Defines pin-muxing selection for GPIO42
#define GPIO_GPBMUX1_GPIO43_S 22U
#define GPIO_GPBMUX1_GPIO43_M 0xC00000U // Defines pin-muxing selection for GPIO43
#define GPIO_GPBMUX1_GPIO44_S 24U
#define GPIO_GPBMUX1_GPIO44_M 0x3000000U // Defines pin-muxing selection for GPIO44
#define GPIO_GPBMUX1_GPIO45_S 26U
#define GPIO_GPBMUX1_GPIO45_M 0xC000000U // Defines pin-muxing selection for GPIO45
#define GPIO_GPBMUX1_GPIO46_S 28U
#define GPIO_GPBMUX1_GPIO46_M 0x30000000U // Defines pin-muxing selection for GPIO46

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBMUX2 register
//
//*************************************************************************************************
#define GPIO_GPBMUX2_GPIO48_S 0U
#define GPIO_GPBMUX2_GPIO48_M 0x3U // Defines pin-muxing selection for GPIO48
#define GPIO_GPBMUX2_GPIO49_S 2U
#define GPIO_GPBMUX2_GPIO49_M 0xCU // Defines pin-muxing selection for GPIO49
#define GPIO_GPBMUX2_GPIO53_S 10U
#define GPIO_GPBMUX2_GPIO53_M 0xC00U // Defines pin-muxing selection for GPIO53
#define GPIO_GPBMUX2_GPIO54_S 12U
#define GPIO_GPBMUX2_GPIO54_M 0x3000U // Defines pin-muxing selection for GPIO54
#define GPIO_GPBMUX2_GPIO55_S 14U
#define GPIO_GPBMUX2_GPIO55_M 0xC000U // Defines pin-muxing selection for GPIO55
#define GPIO_GPBMUX2_GPIO56_S 16U
#define GPIO_GPBMUX2_GPIO56_M 0x30000U // Defines pin-muxing selection for GPIO56
#define GPIO_GPBMUX2_GPIO57_S 18U
#define GPIO_GPBMUX2_GPIO57_M 0xC0000U // Defines pin-muxing selection for GPIO57
#define GPIO_GPBMUX2_GPIO58_S 20U
#define GPIO_GPBMUX2_GPIO58_M 0x300000U // Defines pin-muxing selection for GPIO58
#define GPIO_GPBMUX2_GPIO59_S 22U
#define GPIO_GPBMUX2_GPIO59_M 0xC00000U // Defines pin-muxing selection for GPIO59
#define GPIO_GPBMUX2_GPIO60_S 24U
#define GPIO_GPBMUX2_GPIO60_M 0x3000000U // Defines pin-muxing selection for GPIO60
#define GPIO_GPBMUX2_GPIO61_S 26U
#define GPIO_GPBMUX2_GPIO61_M 0xC000000U // Defines pin-muxing selection for GPIO61
#define GPIO_GPBMUX2_GPIO62_S 28U
#define GPIO_GPBMUX2_GPIO62_M 0x30000000U // Defines pin-muxing selection for GPIO62
#define GPIO_GPBMUX2_GPIO63_S 30U
#define GPIO_GPBMUX2_GPIO63_M 0xC0000000U // Defines pin-muxing selection for GPIO63

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDIR register
//
//*************************************************************************************************
#define GPIO_GPBDIR_GPIO32 0x1U        // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO33 0x2U        // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO34 0x4U        // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO35 0x8U        // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO37 0x20U       // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO39 0x80U       // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO40 0x100U      // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO41 0x200U      // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO42 0x400U      // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO43 0x800U      // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO44 0x1000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO45 0x2000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO46 0x4000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO48 0x10000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO49 0x20000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO53 0x200000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO54 0x400000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO55 0x800000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO56 0x1000000U  // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO57 0x2000000U  // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO58 0x4000000U  // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO59 0x8000000U  // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO60 0x10000000U // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO61 0x20000000U // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO62 0x40000000U // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO63 0x80000000U // Defines direction for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBPUD register
//
//*************************************************************************************************
#define GPIO_GPBPUD_GPIO32 0x1U        // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO33 0x2U        // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO34 0x4U        // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO35 0x8U        // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO37 0x20U       // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO39 0x80U       // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO40 0x100U      // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO41 0x200U      // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO42 0x400U      // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO43 0x800U      // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO44 0x1000U     // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO45 0x2000U     // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO46 0x4000U     // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO48 0x10000U    // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO49 0x20000U    // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO53 0x200000U   // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO54 0x400000U   // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO55 0x800000U   // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO56 0x1000000U  // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO57 0x2000000U  // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO58 0x4000000U  // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO59 0x8000000U  // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO60 0x10000000U // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO61 0x20000000U // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO62 0x40000000U // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO63 0x80000000U // Pull-Up Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBINV register
//
//*************************************************************************************************
#define GPIO_GPBINV_GPIO32 0x1U        // Input inversion control for this pin
#define GPIO_GPBINV_GPIO33 0x2U        // Input inversion control for this pin
#define GPIO_GPBINV_GPIO34 0x4U        // Input inversion control for this pin
#define GPIO_GPBINV_GPIO35 0x8U        // Input inversion control for this pin
#define GPIO_GPBINV_GPIO37 0x20U       // Input inversion control for this pin
#define GPIO_GPBINV_GPIO39 0x80U       // Input inversion control for this pin
#define GPIO_GPBINV_GPIO40 0x100U      // Input inversion control for this pin
#define GPIO_GPBINV_GPIO41 0x200U      // Input inversion control for this pin
#define GPIO_GPBINV_GPIO42 0x400U      // Input inversion control for this pin
#define GPIO_GPBINV_GPIO43 0x800U      // Input inversion control for this pin
#define GPIO_GPBINV_GPIO44 0x1000U     // Input inversion control for this pin
#define GPIO_GPBINV_GPIO45 0x2000U     // Input inversion control for this pin
#define GPIO_GPBINV_GPIO46 0x4000U     // Input inversion control for this pin
#define GPIO_GPBINV_GPIO48 0x10000U    // Input inversion control for this pin
#define GPIO_GPBINV_GPIO49 0x20000U    // Input inversion control for this pin
#define GPIO_GPBINV_GPIO53 0x200000U   // Input inversion control for this pin
#define GPIO_GPBINV_GPIO54 0x400000U   // Input inversion control for this pin
#define GPIO_GPBINV_GPIO55 0x800000U   // Input inversion control for this pin
#define GPIO_GPBINV_GPIO56 0x1000000U  // Input inversion control for this pin
#define GPIO_GPBINV_GPIO57 0x2000000U  // Input inversion control for this pin
#define GPIO_GPBINV_GPIO58 0x4000000U  // Input inversion control for this pin
#define GPIO_GPBINV_GPIO59 0x8000000U  // Input inversion control for this pin
#define GPIO_GPBINV_GPIO60 0x10000000U // Input inversion control for this pin
#define GPIO_GPBINV_GPIO61 0x20000000U // Input inversion control for this pin
#define GPIO_GPBINV_GPIO62 0x40000000U // Input inversion control for this pin
#define GPIO_GPBINV_GPIO63 0x80000000U // Input inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBAMSEL register
//
//*************************************************************************************************
#define GPIO_GPBAMSEL_GPIO33 0x2U // Analog Mode select for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBGMUX1 register
//
//*************************************************************************************************
#define GPIO_GPBGMUX1_GPIO32_S 0U
#define GPIO_GPBGMUX1_GPIO32_M 0x3U // Defines pin-muxing selection for GPIO32
#define GPIO_GPBGMUX1_GPIO33_S 2U
#define GPIO_GPBGMUX1_GPIO33_M 0xCU // Defines pin-muxing selection for GPIO33
#define GPIO_GPBGMUX1_GPIO34_S 4U
#define GPIO_GPBGMUX1_GPIO34_M 0x30U // Defines pin-muxing selection for GPIO34
#define GPIO_GPBGMUX1_GPIO35_S 6U
#define GPIO_GPBGMUX1_GPIO35_M 0xC0U // Defines pin-muxing selection for GPIO35
#define GPIO_GPBGMUX1_GPIO37_S 10U
#define GPIO_GPBGMUX1_GPIO37_M 0xC00U // Defines pin-muxing selection for GPIO37
#define GPIO_GPBGMUX1_GPIO39_S 14U
#define GPIO_GPBGMUX1_GPIO39_M 0xC000U // Defines pin-muxing selection for GPIO39
#define GPIO_GPBGMUX1_GPIO40_S 16U
#define GPIO_GPBGMUX1_GPIO40_M 0x30000U // Defines pin-muxing selection for GPIO40
#define GPIO_GPBGMUX1_GPIO41_S 18U
#define GPIO_GPBGMUX1_GPIO41_M 0xC0000U // Defines pin-muxing selection for GPIO41
#define GPIO_GPBGMUX1_GPIO42_S 20U
#define GPIO_GPBGMUX1_GPIO42_M 0x300000U // Defines pin-muxing selection for GPIO42
#define GPIO_GPBGMUX1_GPIO43_S 22U
#define GPIO_GPBGMUX1_GPIO43_M 0xC00000U // Defines pin-muxing selection for GPIO43
#define GPIO_GPBGMUX1_GPIO44_S 24U
#define GPIO_GPBGMUX1_GPIO44_M 0x3000000U // Defines pin-muxing selection for GPIO44
#define GPIO_GPBGMUX1_GPIO45_S 26U
#define GPIO_GPBGMUX1_GPIO45_M 0xC000000U // Defines pin-muxing selection for GPIO45
#define GPIO_GPBGMUX1_GPIO46_S 28U
#define GPIO_GPBGMUX1_GPIO46_M 0x30000000U // Defines pin-muxing selection for GPIO46

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBGMUX2 register
//
//*************************************************************************************************
#define GPIO_GPBGMUX2_GPIO48_S 0U
#define GPIO_GPBGMUX2_GPIO48_M 0x3U // Defines pin-muxing selection for GPIO48
#define GPIO_GPBGMUX2_GPIO49_S 2U
#define GPIO_GPBGMUX2_GPIO49_M 0xCU // Defines pin-muxing selection for GPIO49
#define GPIO_GPBGMUX2_GPIO53_S 10U
#define GPIO_GPBGMUX2_GPIO53_M 0xC00U // Defines pin-muxing selection for GPIO53
#define GPIO_GPBGMUX2_GPIO54_S 12U
#define GPIO_GPBGMUX2_GPIO54_M 0x3000U // Defines pin-muxing selection for GPIO54
#define GPIO_GPBGMUX2_GPIO55_S 14U
#define GPIO_GPBGMUX2_GPIO55_M 0xC000U // Defines pin-muxing selection for GPIO55
#define GPIO_GPBGMUX2_GPIO56_S 16U
#define GPIO_GPBGMUX2_GPIO56_M 0x30000U // Defines pin-muxing selection for GPIO56
#define GPIO_GPBGMUX2_GPIO57_S 18U
#define GPIO_GPBGMUX2_GPIO57_M 0xC0000U // Defines pin-muxing selection for GPIO57
#define GPIO_GPBGMUX2_GPIO58_S 20U
#define GPIO_GPBGMUX2_GPIO58_M 0x300000U // Defines pin-muxing selection for GPIO58
#define GPIO_GPBGMUX2_GPIO59_S 22U
#define GPIO_GPBGMUX2_GPIO59_M 0xC00000U // Defines pin-muxing selection for GPIO59
#define GPIO_GPBGMUX2_GPIO60_S 24U
#define GPIO_GPBGMUX2_GPIO60_M 0x3000000U // Defines pin-muxing selection for GPIO60
#define GPIO_GPBGMUX2_GPIO61_S 26U
#define GPIO_GPBGMUX2_GPIO61_M 0xC000000U // Defines pin-muxing selection for GPIO61
#define GPIO_GPBGMUX2_GPIO62_S 28U
#define GPIO_GPBGMUX2_GPIO62_M 0x30000000U // Defines pin-muxing selection for GPIO62
#define GPIO_GPBGMUX2_GPIO63_S 30U
#define GPIO_GPBGMUX2_GPIO63_M 0xC0000000U // Defines pin-muxing selection for GPIO63

/*************************************************************************************************
 *
 * The following are defines for the bit fields in the GPGCTRL register
 *
 *************************************************************************************************/
#define GPIO_GPGCTRL_QUALPRD200_S 0U
#define GPIO_GPGCTRL_QUALPRD200_M 0xFFU // Qualification sampling period for GPIO200

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGQSEL1 register
//
//*************************************************************************************************
#define GPIO_GPGQSEL1_GPIO200_S 0U
#define GPIO_GPGQSEL1_GPIO200_M 0x3U // Select input qualification type for GPIO200

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGMUX1 register
//
//*************************************************************************************************
#define GPIO_GPGMUX1_GPIO200_S 0U
#define GPIO_GPGMUX1_GPIO200_M 0x3U // Defines pin-muxing selection for GPIO200

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGDIR register
//
//*************************************************************************************************
#define GPIO_GPGDIR_GPIO200 0x1U // Defines direction for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGPUD register
//
//*************************************************************************************************
#define GPIO_GPGPUD_GPIO200 0x1U // Pull-Up Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGINV register
//
//*************************************************************************************************
#define GPIO_GPGINV_GPIO200 0x1U // Input inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGAMSEL register
//
//*************************************************************************************************
#define GPIO_GPGAMSEL_GPIO200 0x1U // Analog Mode select for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGGMUX1 register
//
//*************************************************************************************************
#define GPIO_GPGGMUX1_GPIO200_S 0U
#define GPIO_GPGGMUX1_GPIO200_M 0x3U // Defines pin-muxing selection for GPIO200

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHCTRL register
//
//*************************************************************************************************
#define GPIO_GPHCTRL_QUALPRD0_S 0U
#define GPIO_GPHCTRL_QUALPRD0_M 0xFFU // Qualification sampling period for GPIO224 to GPIO231
#define GPIO_GPHCTRL_QUALPRD1_S 8U
#define GPIO_GPHCTRL_QUALPRD1_M 0xFF00U // Qualification sampling period for GPIO232 to GPIO239
#define GPIO_GPHCTRL_QUALPRD2_S 16U
#define GPIO_GPHCTRL_QUALPRD2_M 0xFF0000U // Qualification sampling period for GPIO240 to GPIO247
#define GPIO_GPHCTRL_QUALPRD3_S 24U
#define GPIO_GPHCTRL_QUALPRD3_M 0xFF000000U // Qualification sampling period for GPIO248

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHQSEL1 register
//
//*************************************************************************************************
#define GPIO_GPHQSEL1_GPIO224_S 0U
#define GPIO_GPHQSEL1_GPIO224_M 0x3U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO225_S 2U
#define GPIO_GPHQSEL1_GPIO225_M 0xCU // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO226_S 4U
#define GPIO_GPHQSEL1_GPIO226_M 0x30U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO227_S 6U
#define GPIO_GPHQSEL1_GPIO227_M 0xC0U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO228_S 8U
#define GPIO_GPHQSEL1_GPIO228_M 0x300U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO230_S 12U
#define GPIO_GPHQSEL1_GPIO230_M 0x3000U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO231_S 14U
#define GPIO_GPHQSEL1_GPIO231_M 0xC000U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO232_S 16U
#define GPIO_GPHQSEL1_GPIO232_M 0x30000U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO233_S 18U
#define GPIO_GPHQSEL1_GPIO233_M 0xC0000U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO234_S 20U
#define GPIO_GPHQSEL1_GPIO234_M 0x300000U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO235_S 22U
#define GPIO_GPHQSEL1_GPIO235_M 0xC00000U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO236_S 24U
#define GPIO_GPHQSEL1_GPIO236_M 0x3000000U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO237_S 26U
#define GPIO_GPHQSEL1_GPIO237_M 0xC000000U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO238_S 28U
#define GPIO_GPHQSEL1_GPIO238_M 0x30000000U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL1_GPIO239_S 30U
#define GPIO_GPHQSEL1_GPIO239_M 0xC0000000U // Select input qualification type for this GPIO Pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHQSEL2 register
//
//*************************************************************************************************
#define GPIO_GPHQSEL2_GPIO241_S 2U
#define GPIO_GPHQSEL2_GPIO241_M 0xCU // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO242_S 4U
#define GPIO_GPHQSEL2_GPIO242_M 0x30U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO244_S 8U
#define GPIO_GPHQSEL2_GPIO244_M 0x300U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO245_S 10U
#define GPIO_GPHQSEL2_GPIO245_M 0xC00U // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO248_S 16U
#define GPIO_GPHQSEL2_GPIO248_M 0x30000U // Select input qualification type for this GPIO Pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHMUX1 register
//
//*************************************************************************************************
#define GPIO_GPHMUX1_GPIO224_S 0U
#define GPIO_GPHMUX1_GPIO224_M 0x3U // Defines pin-muxing selection for GPIO224
#define GPIO_GPHMUX1_GPIO225_S 2U
#define GPIO_GPHMUX1_GPIO225_M 0xCU // Defines pin-muxing selection for GPIO225
#define GPIO_GPHMUX1_GPIO226_S 4U
#define GPIO_GPHMUX1_GPIO226_M 0x30U // Defines pin-muxing selection for GPIO226
#define GPIO_GPHMUX1_GPIO227_S 6U
#define GPIO_GPHMUX1_GPIO227_M 0xC0U // Defines pin-muxing selection for GPIO227
#define GPIO_GPHMUX1_GPIO228_S 8U
#define GPIO_GPHMUX1_GPIO228_M 0x300U // Defines pin-muxing selection for GPIO228
#define GPIO_GPHMUX1_GPIO230_S 12U
#define GPIO_GPHMUX1_GPIO230_M 0x3000U // Defines pin-muxing selection for GPIO230
#define GPIO_GPHMUX1_GPIO231_S 14U
#define GPIO_GPHMUX1_GPIO231_M 0xC000U // Defines pin-muxing selection for GPIO231
#define GPIO_GPHMUX1_GPIO232_S 16U
#define GPIO_GPHMUX1_GPIO232_M 0x30000U // Defines pin-muxing selection for GPIO232
#define GPIO_GPHMUX1_GPIO233_S 18U
#define GPIO_GPHMUX1_GPIO233_M 0xC0000U // Defines pin-muxing selection for GPIO233
#define GPIO_GPHMUX1_GPIO234_S 20U
#define GPIO_GPHMUX1_GPIO234_M 0x300000U // Defines pin-muxing selection for GPIO234
#define GPIO_GPHMUX1_GPIO235_S 22U
#define GPIO_GPHMUX1_GPIO235_M 0xC00000U // Defines pin-muxing selection for GPIO235
#define GPIO_GPHMUX1_GPIO236_S 24U
#define GPIO_GPHMUX1_GPIO236_M 0x3000000U // Defines pin-muxing selection for GPIO236
#define GPIO_GPHMUX1_GPIO237_S 26U
#define GPIO_GPHMUX1_GPIO237_M 0xC000000U // Defines pin-muxing selection for GPIO237
#define GPIO_GPHMUX1_GPIO238_S 28U
#define GPIO_GPHMUX1_GPIO238_M 0x30000000U // Defines pin-muxing selection for GPIO238
#define GPIO_GPHMUX1_GPIO239_S 30U
#define GPIO_GPHMUX1_GPIO239_M 0xC0000000U // Defines pin-muxing selection for GPIO239

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHMUX2 register
//
//*************************************************************************************************
#define GPIO_GPHMUX2_GPIO241_S 2U
#define GPIO_GPHMUX2_GPIO241_M 0xCU // Defines pin-muxing selection for GPIO241
#define GPIO_GPHMUX2_GPIO242_S 4U
#define GPIO_GPHMUX2_GPIO242_M 0x30U // Defines pin-muxing selection for GPIO242
#define GPIO_GPHMUX2_GPIO244_S 8U
#define GPIO_GPHMUX2_GPIO244_M 0x300U // Defines pin-muxing selection for GPIO244
#define GPIO_GPHMUX2_GPIO245_S 10U
#define GPIO_GPHMUX2_GPIO245_M 0xC00U // Defines pin-muxing selection for GPIO245

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHDIR register
//
//*************************************************************************************************
#define GPIO_GPHDIR_GPIO224 0x1U      // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO225 0x2U      // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO226 0x4U      // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO227 0x8U      // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO228 0x10U     // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO230 0x40U     // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO233 0x200U    // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO236 0x1000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO237 0x2000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO242 0x40000U  // Defines direction for this pin in GPIO mode
#define GPIO_GPHDIR_GPIO245 0x200000U // Defines direction for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHPUD register
//
//*************************************************************************************************
#define GPIO_GPHPUD_GPIO224 0x1U       // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO225 0x2U       // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO226 0x4U       // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO227 0x8U       // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO228 0x10U      // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO230 0x40U      // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO231 0x80U      // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO232 0x100U     // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO233 0x200U     // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO234 0x400U     // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO235 0x800U     // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO236 0x1000U    // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO237 0x2000U    // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO238 0x4000U    // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO239 0x8000U    // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO241 0x20000U   // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO242 0x40000U   // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO244 0x100000U  // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO245 0x200000U  // Pull-Up Disable control for this pin
#define GPIO_GPHPUD_GPIO248 0x1000000U // Pull-Up Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHINV register
//
//*************************************************************************************************
#define GPIO_GPHINV_GPIO224 0x1U       // Input inversion control for this pin
#define GPIO_GPHINV_GPIO225 0x2U       // Input inversion control for this pin
#define GPIO_GPHINV_GPIO226 0x4U       // Input inversion control for this pin
#define GPIO_GPHINV_GPIO227 0x8U       // Input inversion control for this pin
#define GPIO_GPHINV_GPIO228 0x10U      // Input inversion control for this pin
#define GPIO_GPHINV_GPIO230 0x40U      // Input inversion control for this pin
#define GPIO_GPHINV_GPIO231 0x80U      // Input inversion control for this pin
#define GPIO_GPHINV_GPIO232 0x100U     // Input inversion control for this pin
#define GPIO_GPHINV_GPIO233 0x200U     // Input inversion control for this pin
#define GPIO_GPHINV_GPIO234 0x400U     // Input inversion control for this pin
#define GPIO_GPHINV_GPIO235 0x800U     // Input inversion control for this pin
#define GPIO_GPHINV_GPIO236 0x1000U    // Input inversion control for this pin
#define GPIO_GPHINV_GPIO237 0x2000U    // Input inversion control for this pin
#define GPIO_GPHINV_GPIO238 0x4000U    // Input inversion control for this pin
#define GPIO_GPHINV_GPIO239 0x8000U    // Input inversion control for this pin
#define GPIO_GPHINV_GPIO241 0x20000U   // Input inversion control for this pin
#define GPIO_GPHINV_GPIO242 0x40000U   // Input inversion control for this pin
#define GPIO_GPHINV_GPIO244 0x100000U  // Input inversion control for this pin
#define GPIO_GPHINV_GPIO245 0x200000U  // Input inversion control for this pin
#define GPIO_GPHINV_GPIO248 0x1000000U // Input inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHAMSEL register
//
//*************************************************************************************************
#define GPIO_GPHAMSEL_GPIO224 0x1U       // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO225 0x2U       // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO226 0x4U       // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO227 0x8U       // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO228 0x10U      // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO230 0x40U      // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO231 0x80U      // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO232 0x100U     // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO233 0x200U     // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO234 0x400U     // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO235 0x800U     // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO236 0x1000U    // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO237 0x2000U    // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO238 0x4000U    // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO239 0x8000U    // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO241 0x20000U   // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO242 0x40000U   // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO244 0x100000U  // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO245 0x200000U  // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO248 0x1000000U // Analog Mode select for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHGMUX1 register
//
//*************************************************************************************************
#define GPIO_GPHGMUX1_GPIO224_S 0U
#define GPIO_GPHGMUX1_GPIO224_M 0x3U // Defines pin-muxing selection for GPIO224
#define GPIO_GPHGMUX1_GPIO225_S 2U
#define GPIO_GPHGMUX1_GPIO225_M 0xCU // Defines pin-muxing selection for GPIO225
#define GPIO_GPHGMUX1_GPIO226_S 4U
#define GPIO_GPHGMUX1_GPIO226_M 0x30U // Defines pin-muxing selection for GPIO226
#define GPIO_GPHGMUX1_GPIO227_S 6U
#define GPIO_GPHGMUX1_GPIO227_M 0xC0U // Defines pin-muxing selection for GPIO227
#define GPIO_GPHGMUX1_GPIO228_S 8U
#define GPIO_GPHGMUX1_GPIO228_M 0x300U // Defines pin-muxing selection for GPIO228
#define GPIO_GPHGMUX1_GPIO230_S 12U
#define GPIO_GPHGMUX1_GPIO230_M 0x3000U // Defines pin-muxing selection for GPIO230
#define GPIO_GPHGMUX1_GPIO231_S 14U
#define GPIO_GPHGMUX1_GPIO231_M 0xC000U // Defines pin-muxing selection for GPIO231
#define GPIO_GPHGMUX1_GPIO232_S 16U
#define GPIO_GPHGMUX1_GPIO232_M 0x30000U // Defines pin-muxing selection for GPIO232
#define GPIO_GPHGMUX1_GPIO233_S 18U
#define GPIO_GPHGMUX1_GPIO233_M 0xC0000U // Defines pin-muxing selection for GPIO233
#define GPIO_GPHGMUX1_GPIO234_S 20U
#define GPIO_GPHGMUX1_GPIO234_M 0x300000U // Defines pin-muxing selection for GPIO234
#define GPIO_GPHGMUX1_GPIO235_S 22U
#define GPIO_GPHGMUX1_GPIO235_M 0xC00000U // Defines pin-muxing selection for GPIO235
#define GPIO_GPHGMUX1_GPIO236_S 24U
#define GPIO_GPHGMUX1_GPIO236_M 0x3000000U // Defines pin-muxing selection for GPIO236
#define GPIO_GPHGMUX1_GPIO237_S 26U
#define GPIO_GPHGMUX1_GPIO237_M 0xC000000U // Defines pin-muxing selection for GPIO237
#define GPIO_GPHGMUX1_GPIO238_S 28U
#define GPIO_GPHGMUX1_GPIO238_M 0x30000000U // Defines pin-muxing selection for GPIO238
#define GPIO_GPHGMUX1_GPIO239_S 30U
#define GPIO_GPHGMUX1_GPIO239_M 0xC0000000U // Defines pin-muxing selection for GPIO239

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHGMUX2 register
//
//*************************************************************************************************
#define GPIO_GPHGMUX2_GPIO241_S 2U
#define GPIO_GPHGMUX2_GPIO241_M 0xCU // Defines pin-muxing selection for GPIO241
#define GPIO_GPHGMUX2_GPIO242_S 4U
#define GPIO_GPHGMUX2_GPIO242_M 0x30U // Defines pin-muxing selection for GPIO242
#define GPIO_GPHGMUX2_GPIO244_S 8U
#define GPIO_GPHGMUX2_GPIO244_M 0x300U // Defines pin-muxing selection for GPIO244
#define GPIO_GPHGMUX2_GPIO245_S 10U
#define GPIO_GPHGMUX2_GPIO245_M 0xC00U // Defines pin-muxing selection for GPIO245

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAPDD register
//
//*************************************************************************************************
#define GPIO_GPAPDD_GPIO0 0x1U         // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO1 0x2U         // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO2 0x4U         // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO3 0x8U         // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO4 0x10U        // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO5 0x20U        // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO6 0x40U        // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO7 0x80U        // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO8 0x100U       // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO9 0x200U       // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO10 0x400U      // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO11 0x800U      // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO12 0x1000U     // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO13 0x2000U     // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO14 0x4000U     // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO15 0x8000U     // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO16 0x10000U    // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO17 0x20000U    // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO18 0x40000U    // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO19 0x80000U    // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO20 0x100000U   // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO21 0x200000U   // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO22 0x400000U   // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO23 0x800000U   // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO24 0x1000000U  // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO25 0x2000000U  // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO26 0x4000000U  // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO27 0x8000000U  // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO28 0x10000000U // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO29 0x20000000U // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO30 0x40000000U // Pull-Down Disable control for this pin
#define GPIO_GPAPDD_GPIO31 0x80000000U // Pull-Down Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADS1 register
//
//*************************************************************************************************
#define GPIO_GPADS1_GPIO0_S  0U
#define GPIO_GPADS1_GPIO0_M  0x1U         // Defines drive strength for PI2C GPIO
#define GPIO_GPADS1_GPIO1_S  2U
#define GPIO_GPADS1_GPIO1_M  0xCU         // Defines drive strength for GPIO
#define GPIO_GPADS1_GPIO2_S  4U
#define GPIO_GPADS1_GPIO2_M  0x30U        // Defines drive strength for GPIO
#define GPIO_GPADS1_GPIO3_S  6U
#define GPIO_GPADS1_GPIO3_M  0x40U        // Defines drive strength for PI2C GPIO
#define GPIO_GPADS1_GPIO4_S  8U
#define GPIO_GPADS1_GPIO4_M  0x100U       // Defines drive strength for PI2C GPIO
#define GPIO_GPADS1_GPIO5_S  10U
#define GPIO_GPADS1_GPIO5_M  0x400U       // Defines drive strength for PI2C GPIO
#define GPIO_GPADS1_GPIO6_S  12U
#define GPIO_GPADS1_GPIO6_M  0x3000U      // Defines drive strength for GPIO
#define GPIO_GPADS1_GPIO7_S  14U
#define GPIO_GPADS1_GPIO7_M  0xC000U      // Defines drive strength for GPIO
#define GPIO_GPADS1_GPIO8_S  16U
#define GPIO_GPADS1_GPIO8_M  0x10000U     // Defines drive strength for PI2C GPIO
#define GPIO_GPADS1_GPIO9_S  18U
#define GPIO_GPADS1_GPIO9_M  0x40000U     // Defines drive strength for PI2C GPIO
#define GPIO_GPADS1_GPIO10_S 20U
#define GPIO_GPADS1_GPIO10_M 0x300000U    // Defines drive strength for GPIO
#define GPIO_GPADS1_GPIO11_S 22U
#define GPIO_GPADS1_GPIO11_M 0xC00000U    // Defines drive strength for GPIO
#define GPIO_GPADS1_GPIO12_S 24U
#define GPIO_GPADS1_GPIO12_M 0x3000000U   // Defines drive strength for GPIO
#define GPIO_GPADS1_GPIO13_S 26U
#define GPIO_GPADS1_GPIO13_M 0x4000000U   // Defines drive strength for PI2C GPIO
#define GPIO_GPADS1_GPIO14_S 28U
#define GPIO_GPADS1_GPIO14_M 0x10000000U  // Defines drive strength for PI2C GPIO
#define GPIO_GPADS1_GPIO15_S 30U
#define GPIO_GPADS1_GPIO15_M 0x40000000U  // Defines drive strength for PI2C GPIO


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADS2 register
//
//*************************************************************************************************
#define GPIO_GPADS2_GPIO16_S 0U
#define GPIO_GPADS2_GPIO16_M 0x1U         // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO17_S 2U
#define GPIO_GPADS2_GPIO17_M 0x1U         // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO18_S 4U
#define GPIO_GPADS2_GPIO18_M 0x1U         // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO19_S 6U
#define GPIO_GPADS2_GPIO19_M 0x1U         // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO20_S 8U
#define GPIO_GPADS2_GPIO20_M 0x1U         // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO21_S 10U
#define GPIO_GPADS2_GPIO21_M 0x1U         // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO22_S 12U
#define GPIO_GPADS2_GPIO22_M 0x3000U      // Defines drive strength for GPIO
#define GPIO_GPADS2_GPIO23_S 14U
#define GPIO_GPADS2_GPIO23_M 0xC000U      // Defines drive strength for GPIO
#define GPIO_GPADS2_GPIO24_S 16U
#define GPIO_GPADS2_GPIO24_M 0x30000U     // Defines drive strength for GPIO
#define GPIO_GPADS2_GPIO25_S 18U
#define GPIO_GPADS2_GPIO25_M 0x40000U     // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO26_S 20U
#define GPIO_GPADS2_GPIO26_M 0x300000U    // Defines drive strength for GPIO
#define GPIO_GPADS2_GPIO27_S 22U
#define GPIO_GPADS2_GPIO27_M 0x400000U    // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO28_S 24U
#define GPIO_GPADS2_GPIO28_M 0x1000000U   // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO29_S 26U
#define GPIO_GPADS2_GPIO29_M 0x4000000U   // Defines drive strength for PI2C GPIO
#define GPIO_GPADS2_GPIO30_S 28U
#define GPIO_GPADS2_GPIO30_M 0x30000000U  // Defines drive strength for GPIO
#define GPIO_GPADS2_GPIO31_S 30U
#define GPIO_GPADS2_GPIO31_M 0xC0000000U  // Defines drive strength for GPIO


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAIS register
//
//*************************************************************************************************
#define GPIO_GPAIS_GPIO0 0x1U         // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO1 0x2U         // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO2 0x4U         // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO3 0x8U         // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO4 0x10U        // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO5 0x20U        // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO6 0x40U        // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO7 0x80U        // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO8 0x100U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO9 0x200U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO10 0x400U      // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO11 0x800U      // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO12 0x1000U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO13 0x2000U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO14 0x4000U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO15 0x8000U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO16 0x10000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO17 0x20000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO18 0x40000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO19 0x80000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO20 0x100000U   // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO21 0x200000U   // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO22 0x400000U   // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO23 0x800000U   // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO24 0x1000000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO25 0x2000000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO26 0x4000000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO27 0x8000000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO28 0x10000000U // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO29 0x20000000U // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO30 0x40000000U // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPAIS_GPIO31 0x80000000U // Defines  Schmitt trigger for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAOUTINV register
//
//*************************************************************************************************
#define GPIO_GPAOUTINV_GPIO0 0x1U         // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO1 0x2U         // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO2 0x4U         // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO3 0x8U         // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO4 0x10U        // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO5 0x20U        // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO6 0x40U        // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO7 0x80U        // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO8 0x100U       // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO9 0x200U       // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO10 0x400U      // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO11 0x800U      // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO12 0x1000U     // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO13 0x2000U     // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO14 0x4000U     // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO15 0x8000U     // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO16 0x10000U    // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO17 0x20000U    // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO18 0x40000U    // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO19 0x80000U    // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO20 0x100000U   // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO21 0x200000U   // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO22 0x400000U   // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO23 0x800000U   // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO24 0x1000000U  // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO25 0x2000000U  // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO26 0x4000000U  // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO27 0x8000000U  // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO28 0x10000000U // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO29 0x20000000U // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO30 0x40000000U // output inversion control for this pin
#define GPIO_GPAOUTINV_GPIO31 0x80000000U // output inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPALOOPEN register
//
//*************************************************************************************************
#define GPIO_GPALOOPEN_GPIO0 0x1U         // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO1 0x2U         // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO2 0x4U         // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO3 0x8U         // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO4 0x10U        // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO5 0x20U        // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO6 0x40U        // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO7 0x80U        // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO8 0x100U       // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO9 0x200U       // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO10 0x400U      // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO11 0x800U      // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO12 0x1000U     // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO13 0x2000U     // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO14 0x4000U     // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO15 0x8000U     // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO16 0x10000U    // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO17 0x20000U    // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO18 0x40000U    // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO19 0x80000U    // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO20 0x100000U   // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO21 0x200000U   // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO22 0x400000U   // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO23 0x800000U   // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO24 0x1000000U  // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO25 0x2000000U  // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO26 0x4000000U  // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO27 0x8000000U  // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO28 0x10000000U // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO29 0x20000000U // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO30 0x40000000U // loopback enable for this pin
#define GPIO_GPALOOPEN_GPIO31 0x80000000U // loopback enable for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAPI2C_MODE register
//
//*************************************************************************************************
#define GPIO_GPAPI2C_MODE_GPIO0 0x1U         // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO1 0x2U         // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO2 0x4U         // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO3 0x8U         // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO4 0x10U        // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO5 0x20U        // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO8 0x100U       // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO9 0x200U       // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO10 0x400U      // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO12 0x1000U     // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO13 0x2000U     // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO14 0x4000U     // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO15 0x8000U     // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO16 0x10000U    // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO17 0x20000U    // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO18 0x40000U    // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO19 0x80000U    // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO20 0x100000U   // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO21 0x200000U   // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO24 0x1000000U  // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO25 0x2000000U  // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO26 0x4000000U  // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO27 0x8000000U  // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO28 0x10000000U // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO29 0x20000000U // I2C Mode Select for this pin
#define GPIO_GPAPI2C_MODE_GPIO30 0x40000000U // I2C Mode Select for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_POUT_RPT register
//
//*************************************************************************************************
#define GPIO_GPA_POUT_RPT_S 0U
#define GPIO_GPA_POUT_RPT_M 0xFFFFFFFFU // IO0~31 output real-time reporting

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBPDD register
//
//*************************************************************************************************
#define GPIO_GPBPDD_GPIO32 0x1U        // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO33 0x2U        // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO34 0x4U        // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO35 0x8U        // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO36 0x10U       // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO37 0x20U       // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO38 0x40U       // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO39 0x80U       // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO40 0x100U      // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO41 0x200U      // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO42 0x400U      // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO43 0x800U      // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO44 0x1000U     // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO45 0x2000U     // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO46 0x4000U     // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO48 0x10000U    // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO49 0x20000U    // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO53 0x200000U   // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO54 0x400000U   // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO55 0x800000U   // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO56 0x1000000U  // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO57 0x2000000U  // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO58 0x4000000U  // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO59 0x8000000U  // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO60 0x10000000U // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO61 0x20000000U // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO62 0x40000000U // Pull-Down Disable control for this pin
#define GPIO_GPBPDD_GPIO63 0x80000000U // Pull-Down Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDS1 register
//
//*************************************************************************************************
#define GPIO_GPBDS1_GPIO32_S 0U
#define GPIO_GPBDS1_GPIO32_M 0x3U         // Defines drive strength for GPIO
#define GPIO_GPBDS1_GPIO33_S 2U
#define GPIO_GPBDS1_GPIO33_M 0x4U         // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO34_S 4U
#define GPIO_GPBDS1_GPIO34_M 0x10U        // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO35_S 6U
#define GPIO_GPBDS1_GPIO35_M 0x40U        // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO36_S 8U
#define GPIO_GPBDS1_GPIO36_M 0x100U       // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO37_S 10U
#define GPIO_GPBDS1_GPIO37_M 0x400U       // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO38_S 12U
#define GPIO_GPBDS1_GPIO38_M 0x1000U      // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO39_S 14U
#define GPIO_GPBDS1_GPIO39_M 0xC000U      // Defines drive strength for GPIO
#define GPIO_GPBDS1_GPIO40_S 16U
#define GPIO_GPBDS1_GPIO40_M 0x10000U     // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO41_S 18U
#define GPIO_GPBDS1_GPIO41_M 0x40000U     // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO42_S 20U
#define GPIO_GPBDS1_GPIO42_M 0x300000U    // Defines drive strength for GPIO
#define GPIO_GPBDS1_GPIO43_S 22U
#define GPIO_GPBDS1_GPIO43_M 0x400000U    // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO44_S 24U
#define GPIO_GPBDS1_GPIO44_M 0x3000000U   // Defines drive strength for GPIO
#define GPIO_GPBDS1_GPIO45_S 26U
#define GPIO_GPBDS1_GPIO45_M 0x4000000U   // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS1_GPIO46_S 28U
#define GPIO_GPBDS1_GPIO46_M 0x10000000U  // Defines drive strength for PI2C GPIO


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDS2 register
//
//*************************************************************************************************
#define GPIO_GPBDS2_GPIO48_S 0U
#define GPIO_GPBDS2_GPIO48_M 0x1U         // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS2_GPIO49_S 2U
#define GPIO_GPBDS2_GPIO49_M 0xCU         // Defines drive strength for GPIO
#define GPIO_GPBDS2_GPIO53_S 10U
#define GPIO_GPBDS2_GPIO53_M 0xC00U       // Defines drive strength for GPIO
#define GPIO_GPBDS2_GPIO54_S 12U
#define GPIO_GPBDS2_GPIO54_M 0x3000U      // Defines drive strength for GPIO
#define GPIO_GPBDS2_GPIO55_S 14U
#define GPIO_GPBDS2_GPIO55_M 0xC000U      // Defines drive strength for GPIO
#define GPIO_GPBDS2_GPIO56_S 16U
#define GPIO_GPBDS2_GPIO56_M 0x10000U     // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS2_GPIO57_S 18U
#define GPIO_GPBDS2_GPIO57_M 0x40000U     // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS2_GPIO58_S 20U
#define GPIO_GPBDS2_GPIO58_M 0x300000U    // Defines drive strength for GPIO
#define GPIO_GPBDS2_GPIO59_S 22U
#define GPIO_GPBDS2_GPIO59_M 0xC00000U    // Defines drive strength for GPIO
#define GPIO_GPBDS2_GPIO60_S 24U
#define GPIO_GPBDS2_GPIO60_M 0x3000000U   // Defines drive strength for GPIO
#define GPIO_GPBDS2_GPIO61_S 26U
#define GPIO_GPBDS2_GPIO61_M 0xC000000U   // Defines drive strength for GPIO
#define GPIO_GPBDS2_GPIO62_S 28U
#define GPIO_GPBDS2_GPIO62_M 0x10000000U  // Defines drive strength for PI2C GPIO
#define GPIO_GPBDS2_GPIO63_S 30U
#define GPIO_GPBDS2_GPIO63_M 0xC0000000U  // Defines drive strength for GPIO


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBIS register
//
//*************************************************************************************************
#define GPIO_GPBIS_GPIO32 0x1U        // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO33 0x2U        // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO34 0x4U        // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO35 0x8U        // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO36 0x10U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO37 0x20U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO38 0x40U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO39 0x80U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO40 0x100U      // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO41 0x200U      // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO42 0x400U      // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO43 0x800U      // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO44 0x1000U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO45 0x2000U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO46 0x4000U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO48 0x10000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO49 0x20000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO53 0x200000U   // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO54 0x400000U   // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO55 0x800000U   // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO56 0x1000000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO57 0x2000000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO58 0x4000000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO59 0x8000000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO60 0x10000000U // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO61 0x20000000U // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO62 0x40000000U // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPBIS_GPIO63 0x80000000U // Defines  Schmitt trigger for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBOUTINV register
//
//*************************************************************************************************
#define GPIO_GPBOUTINV_GPIO32 0x1U        // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO33 0x2U        // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO34 0x4U        // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO35 0x8U        // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO36 0x10U       // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO37 0x20U       // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO38 0x40U       // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO39 0x80U       // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO40 0x100U      // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO41 0x200U      // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO42 0x400U      // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO43 0x800U      // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO44 0x1000U     // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO45 0x2000U     // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO46 0x4000U     // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO48 0x10000U    // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO49 0x20000U    // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO53 0x200000U   // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO54 0x400000U   // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO55 0x800000U   // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO56 0x1000000U  // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO57 0x2000000U  // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO58 0x4000000U  // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO59 0x8000000U  // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO60 0x10000000U // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO61 0x20000000U // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO62 0x40000000U // output inversion control for this pin
#define GPIO_GPBOUTINV_GPIO63 0x80000000U // output inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBLOOPEN register
//
//*************************************************************************************************
#define GPIO_GPBLOOPEN_GPIO32 0x1U        // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO33 0x2U        // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO34 0x4U        // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO35 0x8U        // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO36 0x10U       // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO37 0x20U       // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO38 0x40U       // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO39 0x80U       // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO40 0x100U      // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO41 0x200U      // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO42 0x400U      // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO43 0x800U      // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO44 0x1000U     // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO45 0x2000U     // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO46 0x4000U     // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO48 0x10000U    // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO49 0x20000U    // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO53 0x200000U   // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO54 0x400000U   // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO55 0x800000U   // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO56 0x1000000U  // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO57 0x2000000U  // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO58 0x4000000U  // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO59 0x8000000U  // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO60 0x10000000U // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO61 0x20000000U // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO62 0x40000000U // loopback enable for this pin
#define GPIO_GPBLOOPEN_GPIO63 0x80000000U // loopback enable for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBPI2C_MODE register
//
//*************************************************************************************************
#define GPIO_GPBPI2C_MODE_GPIO32 0x1U        // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO33 0x2U        // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO34 0x4U        // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO35 0x8U        // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO37 0x20U       // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO40 0x100U      // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO41 0x200U      // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO42 0x400U      // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO43 0x800U      // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO44 0x1000U     // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO45 0x2000U     // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO46 0x4000U     // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO48 0x10000U    // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO56 0x1000000U  // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO57 0x2000000U  // I2C Mode Select for this pin
#define GPIO_GPBPI2C_MODE_GPIO62 0x40000000U // I2C Mode Select for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_POUT_RPT register
//
//*************************************************************************************************
#define GPIO_GPB_POUT_RPT_S 0U
#define GPIO_GPB_POUT_RPT_M 0xFFFFFFFFU // IO32~63 output real-time reporting

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGPDD register
//
//*************************************************************************************************
#define GPIO_GPGPDD_GPIO200 0x1U // Pull-Down Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGDS1 register
//
//*************************************************************************************************
#define GPIO_GPGDS1_GPIO200_S 0U
#define GPIO_GPGDS1_GPIO200_M 0x3U // Defines drive strength for GPIO

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGIS register
//
//*************************************************************************************************
#define GPIO_GPGIS_GPIO200 0x1U // Defines  Schmitt trigger for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGOUTINV register
//
//*************************************************************************************************
#define GPIO_GPGOUTINV_GPIO200 0x1U // output inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGLOOPEN register
//
//*************************************************************************************************
#define GPIO_GPGLOOPEN_GPIO200 0x1U // loopback enable for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPG_POUT_RPT register
//
//*************************************************************************************************
#define GPIO_GPG_POUT_RPT_S 0U
#define GPIO_GPG_POUT_RPT_M 0xFFFFFFFFU // IO200 output real-time reporting

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHPDD register
//
//*************************************************************************************************
#define GPIO_GPHPDD_GPIO224 0x1U       // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO225 0x2U       // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO226 0x4U       // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO227 0x8U       // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO228 0x10U      // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO230 0x40U      // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO231 0x80U      // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO232 0x100U     // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO233 0x200U     // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO234 0x400U     // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO235 0x800U     // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO236 0x1000U    // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO237 0x2000U    // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO238 0x4000U    // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO239 0x8000U    // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO241 0x20000U   // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO242 0x40000U   // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO244 0x100000U  // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO245 0x200000U  // Pull-Down Disable control for this pin
#define GPIO_GPHPDD_GPIO248 0x1000000U // Pull-Down Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHDS1 register
//
//*************************************************************************************************
#define GPIO_GPHDS1_GPIO224_S 0U
#define GPIO_GPHDS1_GPIO224_M 0x3U // Defines drive strength for GPIO
#define GPIO_GPHDS1_GPIO225_S 2U
#define GPIO_GPHDS1_GPIO225_M 0xCU // Defines drive strength for GPIO
#define GPIO_GPHDS1_GPIO226_S 4U
#define GPIO_GPHDS1_GPIO226_M 0x30U // Defines drive strength for GPIO
#define GPIO_GPHDS1_GPIO227 0x40U   // Defines drive strength for PI2C GPIO
#define GPIO_GPHDS1_GPIO228_S 8U
#define GPIO_GPHDS1_GPIO228_M 0x300U // Defines drive strength for GPIO
#define GPIO_GPHDS1_GPIO230 0x1000U  // Defines drive strength for PI2C GPIO
#define GPIO_GPHDS1_GPIO233_S 18U
#define GPIO_GPHDS1_GPIO233_M 0xC0000U // Defines drive strength for GPIO
#define GPIO_GPHDS1_GPIO236 0x1000000U // Defines drive strength for PI2C GPIO
#define GPIO_GPHDS1_GPIO237_S 26U
#define GPIO_GPHDS1_GPIO237_M 0xC000000U // Defines drive strength for GPIO

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHDS2 register
//
//*************************************************************************************************
#define GPIO_GPHDS2_GPIO242_S 4U
#define GPIO_GPHDS2_GPIO242_M 0x30U // Defines drive strength for GPIO
#define GPIO_GPHDS2_GPIO245_S 10U
#define GPIO_GPHDS2_GPIO245_M 0xC00U // Defines drive strength for GPIO

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHIS register
//
//*************************************************************************************************
#define GPIO_GPHIS_GPIO224 0x1U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO225 0x2U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO226 0x4U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO227 0x8U       // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO228 0x10U      // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO230 0x40U      // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO231 0x80U      // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO232 0x100U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO233 0x200U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO234 0x400U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO235 0x800U     // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO236 0x1000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO237 0x2000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO238 0x4000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO239 0x8000U    // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO241 0x20000U   // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO242 0x40000U   // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO244 0x100000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO245 0x200000U  // Defines  Schmitt trigger for this pin in GPIO mode
#define GPIO_GPHIS_GPIO248 0x1000000U // Defines  Schmitt trigger for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHOUTINV register
//
//*************************************************************************************************
#define GPIO_GPHOUTINV_GPIO224 0x1U      // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO225 0x2U      // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO226 0x4U      // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO227 0x8U      // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO228 0x10U     // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO230 0x40U     // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO233 0x200U    // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO236 0x1000U   // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO237 0x2000U   // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO242 0x40000U  // output inversion control for this pin
#define GPIO_GPHOUTINV_GPIO245 0x200000U // output inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHLOOPEN register
//
//*************************************************************************************************
#define GPIO_GPHLOOPEN_GPIO224 0x1U      // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO225 0x2U      // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO226 0x4U      // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO227 0x8U      // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO228 0x10U     // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO230 0x40U     // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO233 0x200U    // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO236 0x1000U   // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO237 0x2000U   // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO242 0x40000U  // loopback enable for this pin
#define GPIO_GPHLOOPEN_GPIO245 0x200000U // loopback enable for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHIE register
//
//*************************************************************************************************
#define GPIO_GPHIE_GPIO224 0x1U       // input enable for this pin
#define GPIO_GPHIE_GPIO225 0x2U       // input enable for this pin
#define GPIO_GPHIE_GPIO226 0x4U       // input enable for this pin
#define GPIO_GPHIE_GPIO227 0x8U       // input enable for this pin
#define GPIO_GPHIE_GPIO228 0x10U      // input enable for this pin
#define GPIO_GPHIE_GPIO230 0x40U      // input enable for this pin
#define GPIO_GPHIE_GPIO231 0x80U      // input enable for this pin
#define GPIO_GPHIE_GPIO232 0x100U     // input enable for this pin
#define GPIO_GPHIE_GPIO233 0x200U     // input enable for this pin
#define GPIO_GPHIE_GPIO234 0x400U     // input enable for this pin
#define GPIO_GPHIE_GPIO235 0x800U     // input enable for this pin
#define GPIO_GPHIE_GPIO236 0x1000U    // input enable for this pin
#define GPIO_GPHIE_GPIO237 0x2000U    // input enable for this pin
#define GPIO_GPHIE_GPIO238 0x4000U    // input enable for this pin
#define GPIO_GPHIE_GPIO239 0x8000U    // input enable for this pin
#define GPIO_GPHIE_GPIO241 0x20000U   // input enable for this pin
#define GPIO_GPHIE_GPIO242 0x40000U   // input enable for this pin
#define GPIO_GPHIE_GPIO244 0x100000U  // input enable for this pin
#define GPIO_GPHIE_GPIO245 0x200000U  // input enable for this pin
#define GPIO_GPHIE_GPIO248 0x1000000U // input enable for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHPI2C_MODE register
//
//*************************************************************************************************
#define GPIO_GPHPI2C_MODE_GPIO227 0x8U  // I2C Mode Select for this pin
#define GPIO_GPHPI2C_MODE_GPIO230 0x40U // I2C Mode Select for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPH_POUT_RPT register
//
//*************************************************************************************************
#define GPIO_GPH_POUT_RPT_S 0U
#define GPIO_GPH_POUT_RPT_M 0xFFFFFFFFU // IO224 output real-time reporting

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADAT_WR register
//
//*************************************************************************************************
#define GPIO_GPADAT_WR_GPIO0 0x1U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO1 0x2U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO2 0x4U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO3 0x8U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO4 0x10U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO5 0x20U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO6 0x40U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO7 0x80U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO8 0x100U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO9 0x200U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO10 0x400U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO11 0x800U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO12 0x1000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO13 0x2000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO14 0x4000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO15 0x8000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO16 0x10000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO17 0x20000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO18 0x40000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO19 0x80000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO20 0x100000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO21 0x200000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO22 0x400000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO23 0x800000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO24 0x1000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO25 0x2000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO26 0x4000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO27 0x8000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO28 0x10000000U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO29 0x20000000U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO30 0x40000000U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO31 0x80000000U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADAT_RE register
//
//*************************************************************************************************
#define GPIO_GPADAT_RE_GPIO0 0x1U         // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO1 0x2U         // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO2 0x4U         // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO3 0x8U         // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO4 0x10U        // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO5 0x20U        // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO6 0x40U        // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO7 0x80U        // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO8 0x100U       // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO9 0x200U       // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO10 0x400U      // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO11 0x800U      // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO12 0x1000U     // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO13 0x2000U     // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO14 0x4000U     // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO15 0x8000U     // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO16 0x10000U    // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO17 0x20000U    // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO18 0x40000U    // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO19 0x80000U    // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO20 0x100000U   // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO21 0x200000U   // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO22 0x400000U   // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO23 0x800000U   // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO24 0x1000000U  // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO25 0x2000000U  // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO26 0x4000000U  // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO27 0x8000000U  // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO28 0x10000000U // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO29 0x20000000U // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO30 0x40000000U // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO31 0x80000000U // read : sample the state of pin ;

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPASET register
//
//*************************************************************************************************
#define GPIO_GPASET_GPIO0 0x1U         // Output Set bit for this pin
#define GPIO_GPASET_GPIO1 0x2U         // Output Set bit for this pin
#define GPIO_GPASET_GPIO2 0x4U         // Output Set bit for this pin
#define GPIO_GPASET_GPIO3 0x8U         // Output Set bit for this pin
#define GPIO_GPASET_GPIO4 0x10U        // Output Set bit for this pin
#define GPIO_GPASET_GPIO5 0x20U        // Output Set bit for this pin
#define GPIO_GPASET_GPIO6 0x40U        // Output Set bit for this pin
#define GPIO_GPASET_GPIO7 0x80U        // Output Set bit for this pin
#define GPIO_GPASET_GPIO8 0x100U       // Output Set bit for this pin
#define GPIO_GPASET_GPIO9 0x200U       // Output Set bit for this pin
#define GPIO_GPASET_GPIO10 0x400U      // Output Set bit for this pin
#define GPIO_GPASET_GPIO11 0x800U      // Output Set bit for this pin
#define GPIO_GPASET_GPIO12 0x1000U     // Output Set bit for this pin
#define GPIO_GPASET_GPIO13 0x2000U     // Output Set bit for this pin
#define GPIO_GPASET_GPIO14 0x4000U     // Output Set bit for this pin
#define GPIO_GPASET_GPIO15 0x8000U     // Output Set bit for this pin
#define GPIO_GPASET_GPIO16 0x10000U    // Output Set bit for this pin
#define GPIO_GPASET_GPIO17 0x20000U    // Output Set bit for this pin
#define GPIO_GPASET_GPIO18 0x40000U    // Output Set bit for this pin
#define GPIO_GPASET_GPIO19 0x80000U    // Output Set bit for this pin
#define GPIO_GPASET_GPIO20 0x100000U   // Output Set bit for this pin
#define GPIO_GPASET_GPIO21 0x200000U   // Output Set bit for this pin
#define GPIO_GPASET_GPIO22 0x400000U   // Output Set bit for this pin
#define GPIO_GPASET_GPIO23 0x800000U   // Output Set bit for this pin
#define GPIO_GPASET_GPIO24 0x1000000U  // Output Set bit for this pin
#define GPIO_GPASET_GPIO25 0x2000000U  // Output Set bit for this pin
#define GPIO_GPASET_GPIO26 0x4000000U  // Output Set bit for this pin
#define GPIO_GPASET_GPIO27 0x8000000U  // Output Set bit for this pin
#define GPIO_GPASET_GPIO28 0x10000000U // Output Set bit for this pin
#define GPIO_GPASET_GPIO29 0x20000000U // Output Set bit for this pin
#define GPIO_GPASET_GPIO30 0x40000000U // Output Set bit for this pin
#define GPIO_GPASET_GPIO31 0x80000000U // Output Set bit for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPACLEAR register
//
//*************************************************************************************************
#define GPIO_GPACLEAR_GPIO0 0x1U         // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO1 0x2U         // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO2 0x4U         // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO3 0x8U         // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO4 0x10U        // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO5 0x20U        // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO6 0x40U        // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO7 0x80U        // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO8 0x100U       // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO9 0x200U       // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO10 0x400U      // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO11 0x800U      // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO12 0x1000U     // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO13 0x2000U     // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO14 0x4000U     // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO15 0x8000U     // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO16 0x10000U    // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO17 0x20000U    // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO18 0x40000U    // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO19 0x80000U    // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO20 0x100000U   // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO21 0x200000U   // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO22 0x400000U   // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO23 0x800000U   // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO24 0x1000000U  // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO25 0x2000000U  // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO26 0x4000000U  // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO27 0x8000000U  // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO28 0x10000000U // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO29 0x20000000U // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO30 0x40000000U // Output Clear bit for this pin
#define GPIO_GPACLEAR_GPIO31 0x80000000U // Output Clear bit for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPATOGGLE register
//
//*************************************************************************************************
#define GPIO_GPATOGGLE_GPIO0 0x1U         // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO1 0x2U         // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO2 0x4U         // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO3 0x8U         // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO4 0x10U        // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO5 0x20U        // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO6 0x40U        // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO7 0x80U        // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO8 0x100U       // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO9 0x200U       // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO10 0x400U      // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO11 0x800U      // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO12 0x1000U     // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO13 0x2000U     // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO14 0x4000U     // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO15 0x8000U     // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO16 0x10000U    // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO17 0x20000U    // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO18 0x40000U    // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO19 0x80000U    // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO20 0x100000U   // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO21 0x200000U   // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO22 0x400000U   // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO23 0x800000U   // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO24 0x1000000U  // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO25 0x2000000U  // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO26 0x4000000U  // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO27 0x8000000U  // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO28 0x10000000U // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO29 0x20000000U // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO30 0x40000000U // Output Toggle bit for this pin
#define GPIO_GPATOGGLE_GPIO31 0x80000000U // Output Toggle bit for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDAT_WR register
//
//*************************************************************************************************
#define GPIO_GPBDAT_WR_GPIO32 0x1U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO33 0x2U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO34 0x4U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO35 0x8U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO37 0x20U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO39 0x80U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO40 0x100U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO41 0x200U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO42 0x400U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO43 0x800U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO44 0x1000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO45 0x2000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO46 0x4000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO48 0x10000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO49 0x20000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO53 0x200000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO54 0x400000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO55 0x800000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO56 0x1000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO57 0x2000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO58 0x4000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO59 0x8000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO60 0x10000000U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO61 0x20000000U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO62 0x40000000U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO63 0x80000000U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDAT_RE register
//
//*************************************************************************************************
#define GPIO_GPBDAT_RE_GPIO32 0x1U        // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO33 0x2U        // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO34 0x4U        // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO35 0x8U        // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO37 0x20U       // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO39 0x80U       // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO40 0x100U      // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO41 0x200U      // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO42 0x400U      // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO43 0x800U      // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO44 0x1000U     // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO45 0x2000U     // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO46 0x4000U     // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO48 0x10000U    // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO49 0x20000U    // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO53 0x200000U   // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO54 0x400000U   // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO55 0x800000U   // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO56 0x1000000U  // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO57 0x2000000U  // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO58 0x4000000U  // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO59 0x8000000U  // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO60 0x10000000U // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO61 0x20000000U // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO62 0x40000000U // read : sample the state of pin ;
#define GPIO_GPBDAT_RE_GPIO63 0x80000000U // read : sample the state of pin ;

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBSET register
//
//*************************************************************************************************
#define GPIO_GPBSET_GPIO32 0x1U        // Output Set bit for this pin
#define GPIO_GPBSET_GPIO33 0x2U        // Output Set bit for this pin
#define GPIO_GPBSET_GPIO34 0x4U        // Output Set bit for this pin
#define GPIO_GPBSET_GPIO35 0x8U        // Output Set bit for this pin
#define GPIO_GPBSET_GPIO37 0x20U       // Output Set bit for this pin
#define GPIO_GPBSET_GPIO39 0x80U       // Output Set bit for this pin
#define GPIO_GPBSET_GPIO40 0x100U      // Output Set bit for this pin
#define GPIO_GPBSET_GPIO41 0x200U      // Output Set bit for this pin
#define GPIO_GPBSET_GPIO42 0x400U      // Output Set bit for this pin
#define GPIO_GPBSET_GPIO43 0x800U      // Output Set bit for this pin
#define GPIO_GPBSET_GPIO44 0x1000U     // Output Set bit for this pin
#define GPIO_GPBSET_GPIO45 0x2000U     // Output Set bit for this pin
#define GPIO_GPBSET_GPIO46 0x4000U     // Output Set bit for this pin
#define GPIO_GPBSET_GPIO48 0x10000U    // Output Set bit for this pin
#define GPIO_GPBSET_GPIO49 0x20000U    // Output Set bit for this pin
#define GPIO_GPBSET_GPIO53 0x200000U   // Output Set bit for this pin
#define GPIO_GPBSET_GPIO54 0x400000U   // Output Set bit for this pin
#define GPIO_GPBSET_GPIO55 0x800000U   // Output Set bit for this pin
#define GPIO_GPBSET_GPIO56 0x1000000U  // Output Set bit for this pin
#define GPIO_GPBSET_GPIO57 0x2000000U  // Output Set bit for this pin
#define GPIO_GPBSET_GPIO58 0x4000000U  // Output Set bit for this pin
#define GPIO_GPBSET_GPIO59 0x8000000U  // Output Set bit for this pin
#define GPIO_GPBSET_GPIO60 0x10000000U // Output Set bit for this pin
#define GPIO_GPBSET_GPIO61 0x20000000U // Output Set bit for this pin
#define GPIO_GPBSET_GPIO62 0x40000000U // Output Set bit for this pin
#define GPIO_GPBSET_GPIO63 0x80000000U // Output Set bit for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBCLEAR register
//
//*************************************************************************************************
#define GPIO_GPBCLEAR_GPIO32 0x1U        // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO33 0x2U        // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO34 0x4U        // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO35 0x8U        // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO37 0x20U       // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO39 0x80U       // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO40 0x100U      // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO41 0x200U      // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO42 0x400U      // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO43 0x800U      // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO44 0x1000U     // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO45 0x2000U     // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO46 0x4000U     // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO48 0x10000U    // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO49 0x20000U    // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO53 0x200000U   // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO54 0x400000U   // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO55 0x800000U   // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO56 0x1000000U  // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO57 0x2000000U  // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO58 0x4000000U  // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO59 0x8000000U  // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO60 0x10000000U // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO61 0x20000000U // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO62 0x40000000U // Output Clear bit for this pin
#define GPIO_GPBCLEAR_GPIO63 0x80000000U // Output Clear bit for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBTOGGLE register
//
//*************************************************************************************************
#define GPIO_GPBTOGGLE_GPIO32 0x1U        // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO33 0x2U        // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO34 0x4U        // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO35 0x8U        // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO37 0x20U       // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO39 0x80U       // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO40 0x100U      // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO41 0x200U      // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO42 0x400U      // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO43 0x800U      // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO44 0x1000U     // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO45 0x2000U     // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO46 0x4000U     // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO48 0x10000U    // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO49 0x20000U    // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO53 0x200000U   // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO54 0x400000U   // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO55 0x800000U   // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO56 0x1000000U  // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO57 0x2000000U  // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO58 0x4000000U  // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO59 0x8000000U  // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO60 0x10000000U // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO61 0x20000000U // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO62 0x40000000U // Output Toggle bit for this pin
#define GPIO_GPBTOGGLE_GPIO63 0x80000000U // Output Toggle bit for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGDAT_WR register
//
//*************************************************************************************************
#define GPIO_GPGDAT_WR_GPIO200 0x1U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGDAT_RE register
//
//*************************************************************************************************
#define GPIO_GPGDAT_RE_GPIO200 0x1U // read : sample the state of pin ;

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGSET register
//
//*************************************************************************************************
#define GPIO_GPGSET_GPIO200 0x1U // Output Set bit for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGCLEAR register
//
//*************************************************************************************************
#define GPIO_GPGCLEAR_GPIO200 0x1U // Output Clear bit for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGTOGGLE register
//
//*************************************************************************************************
#define GPIO_GPGTOGGLE_GPIO200 0x1U // Output Toggle bit for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHDAT_WR register (GPIO224-GPIO245)
//
//*************************************************************************************************
#define GPIO_GPHDAT_WR_GPIO224 0x1U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO225 0x2U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO226 0x4U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO227 0x8U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO228 0x10U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO230 0x40U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO233 0x200U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO236 0x1000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO237 0x2000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO242 0x40000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPHDAT_WR_GPIO245 0x200000U // write : write value to output latch (output mode : output to pin ; input mode : hold the value )

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHDAT_RE register (GPIO224-GPIO245)
//
//*************************************************************************************************
#define GPIO_GPHDAT_RE_GPIO224 0x1U      // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO225 0x2U      // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO226 0x4U      // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO227 0x8U      // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO228 0x10U     // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO230 0x40U     // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO233 0x200U    // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO236 0x1000U   // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO237 0x2000U   // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO242 0x40000U  // read : sample the state of pin ;
#define GPIO_GPHDAT_RE_GPIO245 0x200000U // read : sample the state of pin ;

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHSET register (GPIO224-GPIO245)
//
//*************************************************************************************************
#define GPIO_GPHSET_GPIO224 0x1U      // Output Set bit for GPIO224
#define GPIO_GPHSET_GPIO225 0x2U      // Output Set bit for GPIO225
#define GPIO_GPHSET_GPIO226 0x4U      // Output Set bit for GPIO226
#define GPIO_GPHSET_GPIO227 0x8U      // Output Set bit for GPIO227
#define GPIO_GPHSET_GPIO228 0x10U     // Output Set bit for GPIO228
#define GPIO_GPHSET_GPIO230 0x40U     // Output Set bit for GPIO230
#define GPIO_GPHSET_GPIO233 0x200U    // Output Set bit for GPIO233
#define GPIO_GPHSET_GPIO236 0x1000U   // Output Set bit for GPIO236
#define GPIO_GPHSET_GPIO237 0x2000U   // Output Set bit for GPIO237
#define GPIO_GPHSET_GPIO242 0x40000U  // Output Set bit for GPIO242
#define GPIO_GPHSET_GPIO245 0x200000U // Output Set bit for GPIO245

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHCLEAR register
//
//*************************************************************************************************
#define GPIO_GPHCLEAR_GPIO224 0x1U      // Output Clear bit for GPIO224
#define GPIO_GPHCLEAR_GPIO225 0x2U      // Output Clear bit for GPIO225
#define GPIO_GPHCLEAR_GPIO226 0x4U      // Output Clear bit for GPIO226
#define GPIO_GPHCLEAR_GPIO227 0x8U      // Output Clear bit for GPIO227
#define GPIO_GPHCLEAR_GPIO228 0x10U     // Output Clear bit for GPIO228
#define GPIO_GPHCLEAR_GPIO230 0x40U     // Output Clear bit for GPIO230
#define GPIO_GPHCLEAR_GPIO233 0x200U    // Output Clear bit for GPIO233
#define GPIO_GPHCLEAR_GPIO236 0x1000U   // Output Clear bit for GPIO236
#define GPIO_GPHCLEAR_GPIO237 0x2000U   // Output Clear bit for GPIO237
#define GPIO_GPHCLEAR_GPIO242 0x40000U  // Output Clear bit for GPIO242
#define GPIO_GPHCLEAR_GPIO245 0x200000U // Output Clear bit for GPIO245

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHTOGGLE register
//
//*************************************************************************************************
#define GPIO_GPHTOGGLE_GPIO224 0x1U      // Output Toggle bit for GPIO224
#define GPIO_GPHTOGGLE_GPIO225 0x2U      // Output Toggle bit for GPIO225
#define GPIO_GPHTOGGLE_GPIO226 0x4U      // Output Toggle bit for GPIO226
#define GPIO_GPHTOGGLE_GPIO227 0x8U      // Output Toggle bit for GPIO227
#define GPIO_GPHTOGGLE_GPIO228 0x10U     // Output Toggle bit for GPIO228
#define GPIO_GPHTOGGLE_GPIO230 0x40U     // Output Toggle bit for GPIO230
#define GPIO_GPHTOGGLE_GPIO233 0x200U    // Output Toggle bit for GPIO233
#define GPIO_GPHTOGGLE_GPIO236 0x1000U   // Output Toggle bit for GPIO236
#define GPIO_GPHTOGGLE_GPIO237 0x2000U   // Output Toggle bit for GPIO237
#define GPIO_GPHTOGGLE_GPIO242 0x40000U  // Output Toggle bit for GPIO242
#define GPIO_GPHTOGGLE_GPIO245 0x200000U // Output Toggle bit for GPIO245

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADAT_R register
//
//*************************************************************************************************
#define GPIO_GPADAT_R_S 0U
#define GPIO_GPADAT_R_M 0xFFFFFFFFU // returns the contents of GPADAT register on a read ; write means nothing

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDAT_R register
//
//*************************************************************************************************
#define GPIO_GPBDAT_R_S 0U
#define GPIO_GPBDAT_R_M 0xFFFFFFFFU // returns the contents of GPBDAT register on a read ; write means nothing

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPGDAT_R register
//
//*************************************************************************************************
#define GPIO_GPGDAT_R_S 0U
#define GPIO_GPGDAT_R_M 0x1U // returns the contents of GPGDAT register on a read ; write means nothing

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHDAT_R register
//
//*************************************************************************************************
#define GPIO_GPHDAT_R_S 0U
#define GPIO_GPHDAT_R_M 0xFFFFFFFFU // returns the contents of GPHDAT register on a read ; write means nothing

/*************************************************************************************************
 *
 * The following are defines for the bit fields in the GPACTRL_3527 register
 *
 *************************************************************************************************/
#define GPIO_GPACTRL_QUALPRD0_3527_S 0U
#define GPIO_GPACTRL_QUALPRD0_3527_M 0xFFU // Qualification sampling period for GPIO0 to GPIO7
#define GPIO_GPACTRL_QUALPRD1_3527_S 8U
#define GPIO_GPACTRL_QUALPRD1_3527_M 0xFF00U // Qualification sampling period for GPIO8 to GPIO15
#define GPIO_GPACTRL_QUALPRD2_3527_S 16U
#define GPIO_GPACTRL_QUALPRD2_3527_M 0xFF0000U // Qualification sampling period for GPIO16 to GPIO23
#define GPIO_GPACTRL_QUALPRD3_3527_S 24U
#define GPIO_GPACTRL_QUALPRD3_3527_M 0xFF000000U // Qualification sampling period for GPIO24 to GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAQSEL1_3527 register
// Input Qualification Types:
// - 00 = Sync to SYSCLK
// - 01 = Qualified with 3 samples
// - 10 = Qualified with 6 samples
// - 11 = Async (no qualification)
//
//*************************************************************************************************
#define GPIO_GPAQSEL1_GPIO0_3527_S   0U
#define GPIO_GPAQSEL1_GPIO0_3527_M   0x3U         // Select input qualification type for GPIO0
#define GPIO_GPAQSEL1_GPIO1_3527_S   2U
#define GPIO_GPAQSEL1_GPIO1_3527_M   0xCU         // Select input qualification type for GPIO1
#define GPIO_GPAQSEL1_GPIO2_3527_S   4U
#define GPIO_GPAQSEL1_GPIO2_3527_M   0x30U        // Select input qualification type for GPIO2
#define GPIO_GPAQSEL1_GPIO3_3527_S   6U
#define GPIO_GPAQSEL1_GPIO3_3527_M   0xC0U        // Select input qualification type for GPIO3
#define GPIO_GPAQSEL1_GPIO4_3527_S   8U
#define GPIO_GPAQSEL1_GPIO4_3527_M   0x300U       // Select input qualification type for GPIO4
#define GPIO_GPAQSEL1_GPIO5_3527_S   10U
#define GPIO_GPAQSEL1_GPIO5_3527_M   0xC00U       // Select input qualification type for GPIO5
#define GPIO_GPAQSEL1_GPIO6_3527_S   12U
#define GPIO_GPAQSEL1_GPIO6_3527_M   0x3000U      // Select input qualification type for GPIO6
#define GPIO_GPAQSEL1_GPIO7_3527_S   14U
#define GPIO_GPAQSEL1_GPIO7_3527_M   0xC000U      // Select input qualification type for GPIO7
#define GPIO_GPAQSEL1_GPIO8_3527_S   16U
#define GPIO_GPAQSEL1_GPIO8_3527_M   0x30000U     // Select input qualification type for GPIO8
#define GPIO_GPAQSEL1_GPIO9_3527_S   18U
#define GPIO_GPAQSEL1_GPIO9_3527_M   0xC0000U     // Select input qualification type for GPIO9
#define GPIO_GPAQSEL1_GPIO10_3527_S  20U
#define GPIO_GPAQSEL1_GPIO10_3527_M  0x300000U    // Select input qualification type for GPIO10
#define GPIO_GPAQSEL1_GPIO11_3527_S  22U
#define GPIO_GPAQSEL1_GPIO11_3527_M  0xC00000U    // Select input qualification type for GPIO11
#define GPIO_GPAQSEL1_GPIO12_3527_S  24U
#define GPIO_GPAQSEL1_GPIO12_3527_M  0x3000000U   // Select input qualification type for GPIO12
#define GPIO_GPAQSEL1_GPIO13_3527_S  26U
#define GPIO_GPAQSEL1_GPIO13_3527_M  0xC000000U   // Select input qualification type for GPIO13
#define GPIO_GPAQSEL1_GPIO14_3527_S  28U
#define GPIO_GPAQSEL1_GPIO14_3527_M  0x30000000U  // Select input qualification type for GPIO14
#define GPIO_GPAQSEL1_GPIO15_3527_S  30U
#define GPIO_GPAQSEL1_GPIO15_3527_M  0xC0000000U  // Select input qualification type for GPIO15

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAQSEL2_3527 register
// Input Qualification Types:
// - 00 = Sync to SYSCLK
// - 01 = Qualified with 3 samples
// - 10 = Qualified with 6 samples
// - 11 = Async (no qualification)
//
//*************************************************************************************************
#define GPIO_GPAQSEL2_GPIO16_3527_S   0U
#define GPIO_GPAQSEL2_GPIO16_3527_M   0x3U         // Select input qualification type for GPIO16
#define GPIO_GPAQSEL2_GPIO17_3527_S   2U
#define GPIO_GPAQSEL2_GPIO17_3527_M   0xCU         // Select input qualification type for GPIO17
#define GPIO_GPAQSEL2_GPIO18_3527_S   4U
#define GPIO_GPAQSEL2_GPIO18_3527_M   0x30U        // Select input qualification type for GPIO18
#define GPIO_GPAQSEL2_GPIO19_3527_S   6U
#define GPIO_GPAQSEL2_GPIO19_3527_M   0xC0U        // Select input qualification type for GPIO19
#define GPIO_GPAQSEL2_GPIO20_3527_S   8U
#define GPIO_GPAQSEL2_GPIO20_3527_M   0x300U       // Select input qualification type for GPIO20
#define GPIO_GPAQSEL2_GPIO21_3527_S   10U
#define GPIO_GPAQSEL2_GPIO21_3527_M   0xC00U       // Select input qualification type for GPIO21
#define GPIO_GPAQSEL2_GPIO22_3527_S   12U
#define GPIO_GPAQSEL2_GPIO22_3527_M   0x3000U      // Select input qualification type for GPIO22
#define GPIO_GPAQSEL2_GPIO23_3527_S   14U
#define GPIO_GPAQSEL2_GPIO23_3527_M   0xC000U      // Select input qualification type for GPIO23
#define GPIO_GPAQSEL2_GPIO24_3527_S   16U
#define GPIO_GPAQSEL2_GPIO24_3527_M   0x30000U     // Select input qualification type for GPIO24
#define GPIO_GPAQSEL2_GPIO25_3527_S   18U
#define GPIO_GPAQSEL2_GPIO25_3527_M   0xC0000U     // Select input qualification type for GPIO25
#define GPIO_GPAQSEL2_GPIO26_3527_S   20U
#define GPIO_GPAQSEL2_GPIO26_3527_M   0x300000U    // Select input qualification type for GPIO26
#define GPIO_GPAQSEL2_GPIO27_3527_S   22U
#define GPIO_GPAQSEL2_GPIO27_3527_M   0xC00000U    // Select input qualification type for GPIO27
#define GPIO_GPAQSEL2_GPIO28_3527_S   24U
#define GPIO_GPAQSEL2_GPIO28_3527_M   0x3000000U   // Select input qualification type for GPIO28
#define GPIO_GPAQSEL2_GPIO29_3527_S   26U
#define GPIO_GPAQSEL2_GPIO29_3527_M   0xC000000U   // Select input qualification type for GPIO29
#define GPIO_GPAQSEL2_GPIO30_3527_S   28U
#define GPIO_GPAQSEL2_GPIO30_3527_M   0x30000000U  // Select input qualification type for GPIO30
#define GPIO_GPAQSEL2_GPIO31_3527_S   30U
#define GPIO_GPAQSEL2_GPIO31_3527_M   0xC0000000U  // Select input qualification type for GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAMUX1_3527 register
//
//*************************************************************************************************
#define GPIO_GPAMUX1_GPIO0_3527_S   0U
#define GPIO_GPAMUX1_GPIO0_3527_M   0x3U        // Defines pin-muxing selection for GPIO0
#define GPIO_GPAMUX1_GPIO1_3527_S   2U
#define GPIO_GPAMUX1_GPIO1_3527_M   0xCU        // Defines pin-muxing selection for GPIO1
#define GPIO_GPAMUX1_GPIO2_3527_S   4U
#define GPIO_GPAMUX1_GPIO2_3527_M   0x30U       // Defines pin-muxing selection for GPIO2
#define GPIO_GPAMUX1_GPIO3_3527_S   6U
#define GPIO_GPAMUX1_GPIO3_3527_M   0xC0U       // Defines pin-muxing selection for GPIO3
#define GPIO_GPAMUX1_GPIO4_3527_S   8U
#define GPIO_GPAMUX1_GPIO4_3527_M   0x300U      // Defines pin-muxing selection for GPIO4
#define GPIO_GPAMUX1_GPIO5_3527_S   10U
#define GPIO_GPAMUX1_GPIO5_3527_M   0xC00U      // Defines pin-muxing selection for GPIO5
#define GPIO_GPAMUX1_GPIO6_3527_S   12U
#define GPIO_GPAMUX1_GPIO6_3527_M   0x3000U     // Defines pin-muxing selection for GPIO6
#define GPIO_GPAMUX1_GPIO7_3527_S   14U
#define GPIO_GPAMUX1_GPIO7_3527_M   0xC000U     // Defines pin-muxing selection for GPIO7
#define GPIO_GPAMUX1_GPIO8_3527_NO27_S   16U
#define GPIO_GPAMUX1_GPIO8_3527_NO27_M   0x30000U    // Defines pin-muxing selection for GPIO8
#define GPIO_GPAMUX1_GPIO9_3527_NO27_S   18U
#define GPIO_GPAMUX1_GPIO9_3527_NO27_M   0xC0000U    // Defines pin-muxing selection for GPIO9
#define GPIO_GPAMUX1_GPIO10_3527_NO27_S  20U
#define GPIO_GPAMUX1_GPIO10_3527_NO27_M  0x300000U   // Defines pin-muxing selection for GPIO10
#define GPIO_GPAMUX1_GPIO11_3527_NO27_S  22U
#define GPIO_GPAMUX1_GPIO11_3527_NO27_M  0xC00000U   // Defines pin-muxing selection for GPIO11
#define GPIO_GPAMUX1_GPIO12_3527_S  24U
#define GPIO_GPAMUX1_GPIO12_3527_M  0x3000000U  // Defines pin-muxing selection for GPIO12
#define GPIO_GPAMUX1_GPIO13_3527_NO27_S  26U
#define GPIO_GPAMUX1_GPIO13_3527_NO27_M  0xC000000U  // Defines pin-muxing selection for GPIO13
#define GPIO_GPAMUX1_GPIO14_3527_NO27_S  28U
#define GPIO_GPAMUX1_GPIO14_3527_NO27_M  0x30000000U // Defines pin-muxing selection for GPIO14
#define GPIO_GPAMUX1_GPIO15_3527_NO27_S  30U
#define GPIO_GPAMUX1_GPIO15_3527_NO27_M  0xC0000000U // Defines pin-muxing selection for GPIO15

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAMUX2_3527 register
//
//*************************************************************************************************
#define GPIO_GPAMUX2_GPIO16_3527_S   0U
#define GPIO_GPAMUX2_GPIO16_3527_M   0x3U        // Defines pin-muxing selection for GPIO16
#define GPIO_GPAMUX2_GPIO17_3527_S   2U
#define GPIO_GPAMUX2_GPIO17_3527_M   0xCU        // Defines pin-muxing selection for GPIO17
#define GPIO_GPAMUX2_GPIO18_3527_S   4U
#define GPIO_GPAMUX2_GPIO18_3527_M   0x30U       // Defines pin-muxing selection for GPIO18
#define GPIO_GPAMUX2_GPIO19_3527_S   6U
#define GPIO_GPAMUX2_GPIO19_3527_M   0xC0U       // Defines pin-muxing selection for GPIO19
#define GPIO_GPAMUX2_GPIO20_3527_NO27_S   8U
#define GPIO_GPAMUX2_GPIO20_3527_NO27_M   0x300U      // Defines pin-muxing selection for GPIO20
#define GPIO_GPAMUX2_GPIO21_3527_NO27_S   10U
#define GPIO_GPAMUX2_GPIO21_3527_NO27_M   0xC00U      // Defines pin-muxing selection for GPIO21
#define GPIO_GPAMUX2_GPIO22_3527_NO27_S   12U
#define GPIO_GPAMUX2_GPIO22_3527_NO27_M   0x3000U     // Defines pin-muxing selection for GPIO22
#define GPIO_GPAMUX2_GPIO23_3527_NO27_S   14U
#define GPIO_GPAMUX2_GPIO23_3527_NO27_M   0xC000U     // Defines pin-muxing selection for GPIO23
#define GPIO_GPAMUX2_GPIO24_3527_NO27_S   16U
#define GPIO_GPAMUX2_GPIO24_3527_NO27_M   0x30000U    // Defines pin-muxing selection for GPIO24
#define GPIO_GPAMUX2_GPIO25_3527_NO27_S   18U
#define GPIO_GPAMUX2_GPIO25_3527_NO27_M   0xC0000U    // Defines pin-muxing selection for GPIO25
#define GPIO_GPAMUX2_GPIO26_3527_NO27_S   20U
#define GPIO_GPAMUX2_GPIO26_3527_NO27_M   0x300000U   // Defines pin-muxing selection for GPIO26
#define GPIO_GPAMUX2_GPIO27_3527_NO27_S   22U
#define GPIO_GPAMUX2_GPIO27_3527_NO27_M   0xC00000U   // Defines pin-muxing selection for GPIO27
#define GPIO_GPAMUX2_GPIO28_3527_S   24U
#define GPIO_GPAMUX2_GPIO28_3527_M   0x3000000U  // Defines pin-muxing selection for GPIO28
#define GPIO_GPAMUX2_GPIO29_3527_S   26U
#define GPIO_GPAMUX2_GPIO29_3527_M   0xC000000U  // Defines pin-muxing selection for GPIO29
#define GPIO_GPAMUX2_GPIO30_3527_NO27_S   28U
#define GPIO_GPAMUX2_GPIO30_3527_NO27_M   0x30000000U // Defines pin-muxing selection for GPIO30
#define GPIO_GPAMUX2_GPIO31_3527_NO27_S   30U
#define GPIO_GPAMUX2_GPIO31_3527_NO27_M   0xC0000000U // Defines pin-muxing selection for GPIO31


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADIR_3527 register
//
//*************************************************************************************************
#define GPIO_GPADIR_GPIO0_3527  0x1U         // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO1_3527  0x2U         // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO2_3527  0x4U         // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO3_3527  0x8U         // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO4_3527  0x10U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO5_3527  0x20U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO6_3527  0x40U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO7_3527  0x80U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO8_3527  0x100U       // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO9_3527  0x200U       // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO10_3527 0x400U       // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO11_3527 0x800U       // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO12_3527 0x1000U      // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO13_3527 0x2000U      // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO14_3527 0x4000U      // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO15_3527 0x8000U      // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO16_3527 0x10000U     // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO17_3527 0x20000U     // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO18_3527 0x40000U     // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO19_3527 0x80000U     // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO20_3527 0x100000U    // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO21_3527 0x200000U    // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO22_3527 0x400000U    // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO23_3527 0x800000U    // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO24_3527 0x1000000U   // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO25_3527 0x2000000U   // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO26_3527 0x4000000U   // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO27_3527 0x8000000U   // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO28_3527 0x10000000U  // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO29_3527 0x20000000U  // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO30_3527 0x40000000U  // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPADIR_GPIO31_3527 0x80000000U  // Defines direction for this pin in GPIO mode (0:input ; 1:output)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAPUD_3527 register
//
//*************************************************************************************************
#define GPIO_GPAPUD_GPIO0_3527  0x1U         // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO1_3527  0x2U         // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO2_3527  0x4U         // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO3_3527  0x8U         // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO4_3527  0x10U        // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO5_3527  0x20U        // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO6_3527  0x40U        // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO7_3527  0x80U        // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO8_3527  0x100U       // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO9_3527  0x200U       // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO10_3527 0x400U       // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO11_3527 0x800U       // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO12_3527 0x1000U      // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO13_3527 0x2000U      // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO14_3527 0x4000U      // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO15_3527 0x8000U      // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO16_3527 0x10000U     // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO17_3527 0x20000U     // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO18_3527 0x40000U     // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO19_3527 0x80000U     // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO20_3527 0x100000U    // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO21_3527 0x200000U    // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO22_3527 0x400000U    // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO23_3527 0x800000U    // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO24_3527 0x1000000U   // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO25_3527 0x2000000U   // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO26_3527 0x4000000U   // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO27_3527 0x8000000U   // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO28_3527 0x10000000U  // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO29_3527 0x20000000U  // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO30_3527 0x40000000U  // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPAPUD_GPIO31_3527 0x80000000U  // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)

/*************************************************************************************************
 *
 * The following are defines for the bit fields in the GPBCTRL_3527 register
 *
 *************************************************************************************************/
#define GPIO_GPBCTRL_QUALPRD0_3527_S 0U
#define GPIO_GPBCTRL_QUALPRD0_3527_M 0xFFU // Qualification sampling period for GPIO32 to GPIO39
#define GPIO_GPBCTRL_QUALPRD1_3527_S 8U
#define GPIO_GPBCTRL_QUALPRD1_3527_M 0xFF00U // Qualification sampling period for GPIO40 to GPIO47

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBQSEL1_3527 register
//
//*************************************************************************************************
#define GPIO_GPBQSEL1_GPIO32_3527_S   0U
#define GPIO_GPBQSEL1_GPIO32_3527_M   0x3U        // Select input qualification type for GPIO32
#define GPIO_GPBQSEL1_GPIO33_3527_S   2U
#define GPIO_GPBQSEL1_GPIO33_3527_M   0xCU        // Select input qualification type for GPIO33
#define GPIO_GPBQSEL1_GPIO34_3527_S   4U
#define GPIO_GPBQSEL1_GPIO34_3527_M   0x30U       // Select input qualification type for GPIO34
#define GPIO_GPBQSEL1_GPIO35_3527_S   6U
#define GPIO_GPBQSEL1_GPIO35_3527_M   0xC0U       // Select input qualification type for GPIO35
#define GPIO_GPBQSEL1_GPIO36_3527_S   8U
#define GPIO_GPBQSEL1_GPIO36_3527_M   0x300U      // Select input qualification type for GPIO36
#define GPIO_GPBQSEL1_GPIO37_3527_S   10U
#define GPIO_GPBQSEL1_GPIO37_3527_M   0xC00U      // Select input qualification type for GPIO37
#define GPIO_GPBQSEL1_GPIO38_3527_S   12U
#define GPIO_GPBQSEL1_GPIO38_3527_M   0x3000U     // Select input qualification type for GPIO38
#define GPIO_GPBQSEL1_GPIO39_3527_NO27_S   14U
#define GPIO_GPBQSEL1_GPIO39_3527_NO27_M   0xC000U     // Select input qualification type for GPIO39
#define GPIO_GPBQSEL1_GPIO40_3527_NO27_S   16U
#define GPIO_GPBQSEL1_GPIO40_3527_NO27_M   0x30000U    // Select input qualification type for GPIO40
#define GPIO_GPBQSEL1_GPIO41_3527_NO27_S   18U
#define GPIO_GPBQSEL1_GPIO41_3527_NO27_M   0xC0000U    // Select input qualification type for GPIO41
#define GPIO_GPBQSEL1_GPIO42_3527_NO27_S   20U
#define GPIO_GPBQSEL1_GPIO42_3527_NO27_M   0x300000U   // Select input qualification type for GPIO42
#define GPIO_GPBQSEL1_GPIO43_3527_NO27_S   22U
#define GPIO_GPBQSEL1_GPIO43_3527_NO27_M   0xC00000U   // Select input qualification type for GPIO43
#define GPIO_GPBQSEL1_GPIO44_3527_NO27_S   24U
#define GPIO_GPBQSEL1_GPIO44_3527_NO27_M   0x3000000U  // Select input qualification type for GPIO44
#define GPIO_GPBQSEL1_GPIO45_3527_NO27_S   26U
#define GPIO_GPBQSEL1_GPIO45_3527_NO27_M   0xC000000U  // Select input qualification type for GPIO45

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBMUX1_3527 register
//
//*************************************************************************************************
#define GPIO_GPBMUX1_GPIO32_3527_S   0U
#define GPIO_GPBMUX1_GPIO32_3527_M   0x3U        // Defines pin-muxing selection for GPIO32
#define GPIO_GPBMUX1_GPIO33_3527_S   2U
#define GPIO_GPBMUX1_GPIO33_3527_M   0xCU        // Defines pin-muxing selection for GPIO33
#define GPIO_GPBMUX1_GPIO34_3527_S   4U
#define GPIO_GPBMUX1_GPIO34_3527_M   0x30U       // Defines pin-muxing selection for GPIO34
#define GPIO_GPBMUX1_GPIO35_3527_S   6U
#define GPIO_GPBMUX1_GPIO35_3527_M   0xC0U       // Defines pin-muxing selection for GPIO35
#define GPIO_GPBMUX1_GPIO36_3527_S   8U
#define GPIO_GPBMUX1_GPIO36_3527_M   0x300U      // Defines pin-muxing selection for GPIO36
#define GPIO_GPBMUX1_GPIO37_3527_S   10U
#define GPIO_GPBMUX1_GPIO37_3527_M   0xC00U      // Defines pin-muxing selection for GPIO37
#define GPIO_GPBMUX1_GPIO38_3527_S   12U
#define GPIO_GPBMUX1_GPIO38_3527_M   0x3000U     // Defines pin-muxing selection for GPIO38
#define GPIO_GPBMUX1_GPIO39_3527_NO27_S   14U
#define GPIO_GPBMUX1_GPIO39_3527_NO27_M   0xC000U     // Defines pin-muxing selection for GPIO39
#define GPIO_GPBMUX1_GPIO40_3527_NO27_S   16U
#define GPIO_GPBMUX1_GPIO40_3527_NO27_M   0x30000U    // Defines pin-muxing selection for GPIO40
#define GPIO_GPBMUX1_GPIO41_3527_NO27_S   18U
#define GPIO_GPBMUX1_GPIO41_3527_NO27_M   0xC0000U    // Defines pin-muxing selection for GPIO41
#define GPIO_GPBMUX1_GPIO42_3527_NO27_S   20U
#define GPIO_GPBMUX1_GPIO42_3527_NO27_M   0x300000U   // Defines pin-muxing selection for GPIO42
#define GPIO_GPBMUX1_GPIO43_3527_NO27_S   22U
#define GPIO_GPBMUX1_GPIO43_3527_NO27_M   0xC00000U   // Defines pin-muxing selection for GPIO43
#define GPIO_GPBMUX1_GPIO44_3527_NO27_S   24U
#define GPIO_GPBMUX1_GPIO44_3527_NO27_M   0x3000000U  // Defines pin-muxing selection for GPIO44
#define GPIO_GPBMUX1_GPIO45_3527_NO27_S   26U
#define GPIO_GPBMUX1_GPIO45_3527_NO27_M   0xC000000U  // Defines pin-muxing selection for GPIO45

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDIR_3527 register
//
//*************************************************************************************************
#define GPIO_GPBDIR_GPIO32_3527      0x1U         // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO33_3527      0x2U         // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO34_3527      0x4U         // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO35_3527      0x8U         // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO36_3527      0x10U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO37_3527      0x20U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO38_3527      0x40U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO39_3527_NO27 0x80U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO40_3527_NO27 0x100U       // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO41_3527_NO27 0x200U       // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO42_3527_NO27 0x400U       // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO43_3527_NO27 0x800U       // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO44_3527_NO27 0x1000U      // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define GPIO_GPBDIR_GPIO45_3527_NO27 0x2000U      // Defines direction for this pin in GPIO mode (0:input ; 1:output)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBPUD_3527 register
//
//*************************************************************************************************
#define GPIO_GPBPUD_GPIO32_3527      0x1U         // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO33_3527      0x2U         // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO34_3527      0x4U         // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO35_3527      0x8U         // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO36_3527      0x10U        // Reserved
#define GPIO_GPBPUD_GPIO37_3527      0x20U        // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO38_3527      0x40U        // Reserved
#define GPIO_GPBPUD_GPIO39_3527_NO27 0x80U        // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO40_3527_NO27 0x100U       // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO41_3527_NO27 0x200U       // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO42_3527_NO27 0x400U       // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO43_3527_NO27 0x800U       // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO44_3527_NO27 0x1000U      // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)
#define GPIO_GPBPUD_GPIO45_3527_NO27 0x2000U      // Pull-Up Disable control for this pin (0:Pull-Up Enable, 1:Pull-Up Disable)

/*************************************************************************************************
 *
 * The following are defines for the bit fields in the AIOCTRL_3527 register
 *
 *************************************************************************************************/
#define GPIO_AIOCTRL_QUALPRD0_3527_S 0U
#define GPIO_AIOCTRL_QUALPRD0_3527_M 0xFFU // Qualification sampling period for AIO0 to AIO7
#define GPIO_AIOCTRL_QUALPRD1_3527_S 8U
#define GPIO_AIOCTRL_QUALPRD1_3527_M 0xFF00U // Qualification sampling period for AIO8 to AIO15

//*************************************************************************************************
//
// The following are defines for the bit fields in the AIOQSEL1 register
//
//*************************************************************************************************
#define AIO_AIOQSEL1_AIO2_S    4U
#define AIO_AIOQSEL1_AIO2_M    0x30U        // Select input qualification type for AIO2
#define AIO_AIOQSEL1_AIO4_S    8U
#define AIO_AIOQSEL1_AIO4_M    0x300U       // Select input qualification type for AIO4
#define AIO_AIOQSEL1_AIO6_S    12U
#define AIO_AIOQSEL1_AIO6_M    0x3000U      // Select input qualification type for AIO6
#define AIO_AIOQSEL1_AIO10_S   20U
#define AIO_AIOQSEL1_AIO10_M   0x300000U    // Select input qualification type for AIO10
#define AIO_AIOQSEL1_AIO12_S   24U
#define AIO_AIOQSEL1_AIO12_M   0x3000000U   // Select input qualification type for AIO12
#define AIO_AIOQSEL1_AIO14_S   28U
#define AIO_AIOQSEL1_AIO14_M   0x30000000U  // Select input qualification type for AIO14


//*************************************************************************************************
//
// The following are defines for the bit fields in the AIOMUX1 register
//
//*************************************************************************************************
#define AIO_AIOMUX1_AIO2_S    4U
#define AIO_AIOMUX1_AIO2_M    0x30U        // Enable signal for this GPIO
#define AIO_AIOMUX1_AIO4_S    8U
#define AIO_AIOMUX1_AIO4_M    0x300U       // Enable signal for this GPIO
#define AIO_AIOMUX1_AIO6_S    12U
#define AIO_AIOMUX1_AIO6_M    0x3000U      // Enable signal for this GPIO
#define AIO_AIOMUX1_AIO10_S   20U
#define AIO_AIOMUX1_AIO10_M   0x300000U    // Enable signal for this GPIO
#define AIO_AIOMUX1_AIO12_S   24U
#define AIO_AIOMUX1_AIO12_M   0x3000000U   // Enable signal for this GPIO
#define AIO_AIOMUX1_AIO14_S   28U
#define AIO_AIOMUX1_AIO14_M   0x30000000U  // Enable signal for this GPIO

//*************************************************************************************************
//
// The following are defines for the bit fields in the AIODS1 register
//
//*************************************************************************************************
#define AIO_AIODS1_AIO2_S    4U
#define AIO_AIODS1_AIO2_M    0x30U        // Defines drive strength for GPIO
#define AIO_AIODS1_AIO4_S    8U
#define AIO_AIODS1_AIO4_M    0x300U       // Defines drive strength for GPIO
#define AIO_AIODS1_AIO6_S    12U
#define AIO_AIODS1_AIO6_M    0x3000U      // Defines drive strength for GPIO
#define AIO_AIODS1_AIO10_S   20U
#define AIO_AIODS1_AIO10_M   0x300000U    // Defines drive strength for GPIO
#define AIO_AIODS1_AIO12_S   24U
#define AIO_AIODS1_AIO12_M   0x3000000U   // Defines drive strength for GPIO
#define AIO_AIODS1_AIO14_S   28U
#define AIO_AIODS1_AIO14_M   0x10000000U  // Defines drive strength for PI2C GPIO

//*************************************************************************************************
//
// The following are defines for the bit fields in the AIODIR register
//
//*************************************************************************************************
#define AIO_AIODIR_AIO2_3527    0x4U         // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define AIO_AIODIR_AIO4_3527    0x10U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define AIO_AIODIR_AIO6_3527    0x40U        // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define AIO_AIODIR_AIO10_3527   0x400U       // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define AIO_AIODIR_AIO12_3527   0x1000U      // Defines direction for this pin in GPIO mode (0:input ; 1:output)
#define AIO_AIODIR_AIO14_3527   0x4000U      // Defines direction for this pin in GPIO mode (0:input ; 1:output)

//*************************************************************************************************
//
// The following are defines for the bit fields in the AIOMUX2 register
//
//*************************************************************************************************
#define AIO_AIOMUX2_AIO2_S    4U
#define AIO_AIOMUX2_AIO2_M    0x30U        // Defines pin-muxing selection for AIO2
#define AIO_AIOMUX2_AIO4_S    8U
#define AIO_AIOMUX2_AIO4_M    0x300U       // Defines pin-muxing selection for AIO4
#define AIO_AIOMUX2_AIO6_S    12U
#define AIO_AIOMUX2_AIO6_M    0x3000U      // Defines pin-muxing selection for AIO6
#define AIO_AIOMUX2_AIO10_S   20U
#define AIO_AIOMUX2_AIO10_M   0x300000U    // Defines pin-muxing selection for AIO10
#define AIO_AIOMUX2_AIO12_S   24U
#define AIO_AIOMUX2_AIO12_M   0x3000000U   // Defines pin-muxing selection for AIO12
#define AIO_AIOMUX2_AIO14_S   28U
#define AIO_AIOMUX2_AIO14_M   0x30000000U  // Defines pin-muxing selection for AIO14


//*************************************************************************************************
//
// The following are defines for the bit fields in the AIOLOOPEN register
//
//*************************************************************************************************
#define AIO_AIOLOOPEN_AIO2_3527    0x4U         // Defines loopen for AIO2 (1:input_en=output_en, 0:input_en=~output_en)
#define AIO_AIOLOOPEN_AIO4_3527    0x10U        // Defines loopen for AIO4 (1:input_en=output_en, 0:input_en=~output_en)
#define AIO_AIOLOOPEN_AIO6_3527    0x40U        // Defines loopen for AIO6 (1:input_en=output_en, 0:input_en=~output_en)
#define AIO_AIOLOOPEN_AIO10_3527   0x400U       // Defines loopen for AIO10 (1:input_en=output_en, 0:input_en=~output_en)
#define AIO_AIOLOOPEN_AIO12_3527   0x1000U      // Defines loopen for AIO12 (1:input_en=output_en, 0:input_en=~output_en)
#define AIO_AIOLOOPEN_AIO14_3527   0x4000U      // Defines loopen for AIO14 (1:input_en=output_en, 0:input_en=~output_en)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADAT_WR_3527 register
//
//*************************************************************************************************
#define GPIO_GPADAT_WR_GPIO0_3527    0x1U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO1_3527    0x2U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO2_3527    0x4U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO3_3527    0x8U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO4_3527    0x10U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO5_3527    0x20U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO6_3527    0x40U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO7_3527    0x80U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO8_3527    0x100U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO9_3527    0x200U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO10_3527   0x400U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO11_3527   0x800U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO12_3527   0x1000U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO13_3527   0x2000U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO14_3527   0x4000U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO15_3527   0x8000U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO16_3527   0x10000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO17_3527   0x20000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO18_3527   0x40000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO19_3527   0x80000U     // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO20_3527   0x100000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO21_3527   0x200000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO22_3527   0x400000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO23_3527   0x800000U    // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO24_3527   0x1000000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO25_3527   0x2000000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO26_3527   0x4000000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO27_3527   0x8000000U   // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO28_3527   0x10000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO29_3527   0x20000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO30_3527   0x40000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPADAT_WR_GPIO31_3527   0x80000000U  // write : write value to output latch (output mode : output to pin ; input mode : hold the value )

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADAT_RE_3527 register
//
//*************************************************************************************************
#define GPIO_GPADAT_RE_GPIO0_3527    0x1U         // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO1_3527    0x2U         // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO2_3527    0x4U         // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO3_3527    0x8U         // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO4_3527    0x10U        // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO5_3527    0x20U        // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO6_3527    0x40U        // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO7_3527    0x80U        // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO8_3527    0x100U       // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO9_3527    0x200U       // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO10_3527   0x400U       // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO11_3527   0x800U       // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO12_3527   0x1000U      // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO13_3527   0x2000U      // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO14_3527   0x4000U      // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO15_3527   0x8000U      // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO16_3527   0x10000U     // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO17_3527   0x20000U     // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO18_3527   0x40000U     // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO19_3527   0x80000U     // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO20_3527   0x100000U    // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO21_3527   0x200000U    // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO22_3527   0x400000U    // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO23_3527   0x800000U    // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO24_3527   0x1000000U   // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO25_3527   0x2000000U   // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO26_3527   0x4000000U   // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO27_3527   0x8000000U   // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO28_3527   0x10000000U  // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO29_3527   0x20000000U  // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO30_3527   0x40000000U  // read : sample the state of pin ;
#define GPIO_GPADAT_RE_GPIO31_3527   0x80000000U  // read : sample the state of pin ;

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPASET_3527 register
//
//*************************************************************************************************
#define GPIO_GPASET_GPIO0_3527    0x1U         // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO1_3527    0x2U         // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO2_3527    0x4U         // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO3_3527    0x8U         // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO4_3527    0x10U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO5_3527    0x20U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO6_3527    0x40U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO7_3527    0x80U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO8_3527    0x100U       // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO9_3527    0x200U       // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO10_3527   0x400U       // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO11_3527   0x800U       // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO12_3527   0x1000U      // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO13_3527   0x2000U      // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO14_3527   0x4000U      // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO15_3527   0x8000U      // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO16_3527   0x10000U     // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO17_3527   0x20000U     // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO18_3527   0x40000U     // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO19_3527   0x80000U     // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO20_3527   0x100000U    // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO21_3527   0x200000U    // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO22_3527   0x400000U    // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO23_3527   0x800000U    // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO24_3527   0x1000000U   // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO25_3527   0x2000000U   // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO26_3527   0x4000000U   // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO27_3527   0x8000000U   // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO28_3527   0x10000000U  // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO29_3527   0x20000000U  // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO30_3527   0x40000000U  // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPASET_GPIO31_3527   0x80000000U  // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPACLEAR_3527 register
//
//*************************************************************************************************
#define GPIO_GPACLEAR_GPIO0_3527    0x1U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO1_3527    0x2U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO2_3527    0x4U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO3_3527    0x8U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO4_3527    0x10U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO5_3527    0x20U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO6_3527    0x40U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO7_3527    0x80U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO8_3527    0x100U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO9_3527    0x200U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO10_3527   0x400U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO11_3527   0x800U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO12_3527   0x1000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO13_3527   0x2000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO14_3527   0x4000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO15_3527   0x8000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO16_3527   0x10000U     // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO17_3527   0x20000U     // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO18_3527   0x40000U     // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO19_3527   0x80000U     // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO20_3527   0x100000U    // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO21_3527   0x200000U    // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO22_3527   0x400000U    // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO23_3527   0x800000U    // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO24_3527   0x1000000U   // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO25_3527   0x2000000U   // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO26_3527   0x4000000U   // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO27_3527   0x8000000U   // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO28_3527   0x10000000U  // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO29_3527   0x20000000U  // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO30_3527   0x40000000U  // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPACLEAR_GPIO31_3527   0x80000000U  // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPATOGGLE_3527 register
//
//*************************************************************************************************
#define GPIO_GPATOGGLE_GPIO0_3527    0x1U         // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO1_3527    0x2U         // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO2_3527    0x4U         // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO3_3527    0x8U         // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO4_3527    0x10U        // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO5_3527    0x20U        // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO6_3527    0x40U        // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO7_3527    0x80U        // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO8_3527    0x100U       // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO9_3527    0x200U       // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO10_3527   0x400U       // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO11_3527   0x800U       // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO12_3527   0x1000U      // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO13_3527   0x2000U      // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO14_3527   0x4000U      // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO15_3527   0x8000U      // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO16_3527   0x10000U     // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO17_3527   0x20000U     // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO18_3527   0x40000U     // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO19_3527   0x80000U     // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO20_3527   0x100000U    // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO21_3527   0x200000U    // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO22_3527   0x400000U    // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO23_3527   0x800000U    // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO24_3527   0x1000000U   // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO25_3527   0x2000000U   // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO26_3527   0x4000000U   // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO27_3527   0x8000000U   // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO28_3527   0x10000000U  // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO29_3527   0x20000000U  // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO30_3527   0x40000000U  // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPATOGGLE_GPIO31_3527   0x80000000U  // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDAT_WR_3527 register
//
//*************************************************************************************************
#define GPIO_GPBDAT_WR_GPIO32_3527         0x1U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO33_3527         0x2U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO34_3527         0x4U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO35_3527         0x8U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO36_3527         0x10U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO37_3527         0x20U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO38_3527         0x40U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO39_3527_NO27    0x80U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO40_3527_NO27    0x100U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO41_3527_NO27    0x200U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO42_3527_NO27    0x400U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO43_3527_NO27    0x800U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO44_3527_NO27    0x1000U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define GPIO_GPBDAT_WR_GPIO45_3527_NO27    0x2000U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDAT_RE_3527 register
//
//*************************************************************************************************
#define GPIO_GPBDAT_RE_GPIO32_3527         0x1U         // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO33_3527         0x2U         // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO34_3527         0x4U         // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO35_3527         0x8U         // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO36_3527         0x10U        // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO37_3527         0x20U        // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO38_3527         0x40U        // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO39_3527_NO27    0x80U        // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO40_3527_NO27    0x100U       // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO41_3527_NO27    0x200U       // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO42_3527_NO27    0x400U       // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO43_3527_NO27    0x800U       // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO44_3527_NO27    0x1000U      // read : sample the state of pin ; 
#define GPIO_GPBDAT_RE_GPIO45_3527_NO27    0x2000U      // read : sample the state of pin ; 

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBSET_3527 register
//
//*************************************************************************************************
#define GPIO_GPBSET_GPIO32_3527         0x1U         // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO33_3527         0x2U         // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO34_3527         0x4U         // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO35_3527         0x8U         // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO36_3527         0x10U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO37_3527         0x20U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO38_3527         0x40U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO39_3527_NO27    0x80U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO40_3527_NO27    0x100U       // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO41_3527_NO27    0x200U       // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO42_3527_NO27    0x400U       // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO43_3527_NO27    0x800U       // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO44_3527_NO27    0x1000U      // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBSET_GPIO45_3527_NO27    0x2000U      // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBCLEAR_3527 register
//
//*************************************************************************************************
#define GPIO_GPBCLEAR_GPIO32_3527         0x1U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO33_3527         0x2U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO34_3527         0x4U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO35_3527         0x8U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO36_3527         0x10U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO37_3527         0x20U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO38_3527         0x40U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO39_3527_NO27    0x80U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO40_3527_NO27    0x100U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO41_3527_NO27    0x200U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO42_3527_NO27    0x400U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO43_3527_NO27    0x800U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO44_3527_NO27    0x1000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define GPIO_GPBCLEAR_GPIO45_3527_NO27    0x2000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBTOGGLE_3527 register
//
//*************************************************************************************************
#define GPIO_GPBTOGGLE_GPIO32_3527         0x1U         // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO33_3527         0x2U         // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO34_3527         0x4U         // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO35_3527         0x8U         // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO36_3527         0x10U        // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO37_3527         0x20U        // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO38_3527         0x40U        // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO39_3527_NO27    0x80U        // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO40_3527_NO27    0x100U       // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO41_3527_NO27    0x200U       // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO42_3527_NO27    0x400U       // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO43_3527_NO27    0x800U       // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO44_3527_NO27    0x1000U      // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
#define GPIO_GPBTOGGLE_GPIO45_3527_NO27    0x2000U      // write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0


//*************************************************************************************************
//
// The following are defines for the bit fields in the AIODAT_WR_3527 register
//
//*************************************************************************************************
#define AIO_AIODAT_WR_AIO2_3527    0x4U         // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define AIO_AIODAT_WR_AIO4_3527    0x10U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define AIO_AIODAT_WR_AIO6_3527    0x40U        // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define AIO_AIODAT_WR_AIO10_3527   0x400U       // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define AIO_AIODAT_WR_AIO12_3527   0x1000U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )
#define AIO_AIODAT_WR_AIO14_3527   0x4000U      // write : write value to output latch (output mode : output to pin ; input mode : hold the value )

//*************************************************************************************************
//
// The following are defines for the bit fields in the AIODAT_RE_3527 register
//
//*************************************************************************************************
#define AIO_AIODAT_RE_AIO2_3527    0x4U         // read : sample the state of pin ; 
#define AIO_AIODAT_RE_AIO4_3527    0x10U        // read : sample the state of pin ; 
#define AIO_AIODAT_RE_AIO6_3527    0x40U        // read : sample the state of pin ; 
#define AIO_AIODAT_RE_AIO10_3527   0x400U       // read : sample the state of pin ; 
#define AIO_AIODAT_RE_AIO12_3527   0x1000U      // read : sample the state of pin ; 
#define AIO_AIODAT_RE_AIO14_3527   0x4000U      // read : sample the state of pin ; 

//*************************************************************************************************
//
// The following are defines for the bit fields in the AIOSET_3527 register
//
//*************************************************************************************************
#define AIO_AIOSET_AIO2_3527    0x4U         // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define AIO_AIOSET_AIO4_3527    0x10U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define AIO_AIOSET_AIO6_3527    0x40U        // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define AIO_AIOSET_AIO10_3527   0x400U       // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define AIO_AIOSET_AIO12_3527   0x1000U      // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
#define AIO_AIOSET_AIO14_3527   0x4000U      // write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0


//*************************************************************************************************
//
// The following are defines for the bit fields in the AIOCLEAR_3527 register
//
//*************************************************************************************************
#define AIO_AIOCLEAR_AIO2_3527    0x4U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOCLEAR_AIO4_3527    0x10U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOCLEAR_AIO6_3527    0x40U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOCLEAR_AIO10_3527   0x400U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOCLEAR_AIO12_3527   0x1000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOCLEAR_AIO14_3527   0x4000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0


//*************************************************************************************************
//
// The following are defines for the bit fields in the AIOTOGGLE_3527 register
//
//*************************************************************************************************
#define AIO_AIOTOGGLE_AIO2_3527    0x4U         // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOTOGGLE_AIO4_3527    0x10U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOTOGGLE_AIO6_3527    0x40U        // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOTOGGLE_AIO10_3527   0x400U       // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOTOGGLE_AIO12_3527   0x1000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
#define AIO_AIOTOGGLE_AIO14_3527   0x4000U      // write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPIOXINT1SEL_3527 register
//
//*************************************************************************************************
#define GPIO_XINT1SEL_3527_M          0x1FU        // select the gpio pin as XINT1 interrupt source mask
#define GPIO_XINT1SEL_3527_S          0U           // select the gpio pin as XINT1 interrupt source shift

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPIOXINT2SEL_3527 register
//
//*************************************************************************************************
#define GPIO_XINT2SEL_3527_M          0x1FU        // select the gpio pin as XINT2 interrupt source mask
#define GPIO_XINT2SEL_3527_S          0U           // select the gpio pin as XINT2 interrupt source shift


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPIOXINT3SEL_3527 register
//
//*************************************************************************************************
#define GPIO_XINT3SEL_3527_M          0x1FU        // select the gpio pin as XINT3 interrupt source mask
#define GPIO_XINT3SEL_3527_S          0U           // select the gpio pin as XINT3 interrupt source shift

//*************************************************************************************************
//
// The following are defines for the bit fields in the LPMSEL_GPIO_3527 register
//
//*************************************************************************************************
#define GPIO_LPMSEL_GPIO0_3527      0x00000001U  // GPIO0 LPM wake-up enable
#define GPIO_LPMSEL_GPIO1_3527      0x00000002U  // GPIO1 LPM wake-up enable
#define GPIO_LPMSEL_GPIO2_3527      0x00000004U  // GPIO2 LPM wake-up enable
#define GPIO_LPMSEL_GPIO3_3527      0x00000008U  // GPIO3 LPM wake-up enable
#define GPIO_LPMSEL_GPIO4_3527      0x00000010U  // GPIO4 LPM wake-up enable
#define GPIO_LPMSEL_GPIO5_3527      0x00000020U  // GPIO5 LPM wake-up enable
#define GPIO_LPMSEL_GPIO6_3527      0x00000040U  // GPIO6 LPM wake-up enable
#define GPIO_LPMSEL_GPIO7_3527      0x00000080U  // GPIO7 LPM wake-up enable
#define GPIO_LPMSEL_GPIO8_3527      0x00000100U  // GPIO8 LPM wake-up enable
#define GPIO_LPMSEL_GPIO9_3527      0x00000200U  // GPIO9 LPM wake-up enable
#define GPIO_LPMSEL_GPIO10_3527     0x00000400U  // GPIO10 LPM wake-up enable
#define GPIO_LPMSEL_GPIO11_3527     0x00000800U  // GPIO11 LPM wake-up enable
#define GPIO_LPMSEL_GPIO12_3527     0x00001000U  // GPIO12 LPM wake-up enable
#define GPIO_LPMSEL_GPIO13_3527     0x00002000U  // GPIO13 LPM wake-up enable
#define GPIO_LPMSEL_GPIO14_3527     0x00004000U  // GPIO14 LPM wake-up enable
#define GPIO_LPMSEL_GPIO15_3527     0x00008000U  // GPIO15 LPM wake-up enable
#define GPIO_LPMSEL_GPIO16_3527     0x00010000U  // GPIO16 LPM wake-up enable
#define GPIO_LPMSEL_GPIO17_3527     0x00020000U  // GPIO17 LPM wake-up enable
#define GPIO_LPMSEL_GPIO18_3527     0x00040000U  // GPIO18 LPM wake-up enable
#define GPIO_LPMSEL_GPIO19_3527     0x00080000U  // GPIO19 LPM wake-up enable
#define GPIO_LPMSEL_GPIO20_3527     0x00100000U  // GPIO20 LPM wake-up enable
#define GPIO_LPMSEL_GPIO21_3527     0x00200000U  // GPIO21 LPM wake-up enable
#define GPIO_LPMSEL_GPIO22_3527     0x00400000U  // GPIO22 LPM wake-up enable
#define GPIO_LPMSEL_GPIO23_3527     0x00800000U  // GPIO23 LPM wake-up enable
#define GPIO_LPMSEL_GPIO24_3527     0x01000000U  // GPIO24 LPM wake-up enable
#define GPIO_LPMSEL_GPIO25_3527     0x02000000U  // GPIO25 LPM wake-up enable
#define GPIO_LPMSEL_GPIO26_3527     0x04000000U  // GPIO26 LPM wake-up enable
#define GPIO_LPMSEL_GPIO27_3527     0x08000000U  // GPIO27 LPM wake-up enable
#define GPIO_LPMSEL_GPIO28_3527     0x10000000U  // GPIO28 LPM wake-up enable
#define GPIO_LPMSEL_GPIO29_3527     0x20000000U  // GPIO29 LPM wake-up enable
#define GPIO_LPMSEL_GPIO30_3527     0x40000000U  // GPIO30 LPM wake-up enable
#define GPIO_LPMSEL_GPIO31_3527     0x80000000U  // GPIO31 LPM wake-up enable

// All GPIO LPM wake-up sources mask
#define GPIO_LPMSEL_ALL_3527        0xFFFFFFFFU  // All GPIO pins LPM wake-up enable mask

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTTYPE register
//
//*************************************************************************************************
#define GPA_INTTYPE_GPIO0      0x00000001U  // GPIO0 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO1      0x00000002U  // GPIO1 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO2      0x00000004U  // GPIO2 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO3      0x00000008U  // GPIO3 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO4      0x00000010U  // GPIO4 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO5      0x00000020U  // GPIO5 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO6      0x00000040U  // GPIO6 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO7      0x00000080U  // GPIO7 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO8      0x00000100U  // GPIO8 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO9      0x00000200U  // GPIO9 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO10     0x00000400U  // GPIO10 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO11     0x00000800U  // GPIO11 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO12     0x00001000U  // GPIO12 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO13     0x00002000U  // GPIO13 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO14     0x00004000U  // GPIO14 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO15     0x00008000U  // GPIO15 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO16     0x00010000U  // GPIO16 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO17     0x00020000U  // GPIO17 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO18     0x00040000U  // GPIO18 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO19     0x00080000U  // GPIO19 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO20     0x00100000U  // GPIO20 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO21     0x00200000U  // GPIO21 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO22     0x00400000U  // GPIO22 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO23     0x00800000U  // GPIO23 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO24     0x01000000U  // GPIO24 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO25     0x02000000U  // GPIO25 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO26     0x04000000U  // GPIO26 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO27     0x08000000U  // GPIO27 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO28     0x10000000U  // GPIO28 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO29     0x20000000U  // GPIO29 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO30     0x40000000U  // GPIO30 interrupt type (0:level, 1:edge)
#define GPA_INTTYPE_GPIO31     0x80000000U  // GPIO31 interrupt type (0:level, 1:edge)


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTPOL register
//
//*************************************************************************************************
#define GPA_INTPOL_GPIO0      0x00000001U  // GPIO0 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO1      0x00000002U  // GPIO1 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO2      0x00000004U  // GPIO2 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO3      0x00000008U  // GPIO3 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO4      0x00000010U  // GPIO4 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO5      0x00000020U  // GPIO5 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO6      0x00000040U  // GPIO6 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO7      0x00000080U  // GPIO7 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO8      0x00000100U  // GPIO8 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO9      0x00000200U  // GPIO9 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO10     0x00000400U  // GPIO10 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO11     0x00000800U  // GPIO11 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO12     0x00001000U  // GPIO12 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO13     0x00002000U  // GPIO13 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO14     0x00004000U  // GPIO14 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO15     0x00008000U  // GPIO15 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO16     0x00010000U  // GPIO16 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO17     0x00020000U  // GPIO17 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO18     0x00040000U  // GPIO18 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO19     0x00080000U  // GPIO19 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO20     0x00100000U  // GPIO20 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO21     0x00200000U  // GPIO21 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO22     0x00400000U  // GPIO22 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO23     0x00800000U  // GPIO23 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO24     0x01000000U  // GPIO24 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO25     0x02000000U  // GPIO25 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO26     0x04000000U  // GPIO26 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO27     0x08000000U  // GPIO27 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO28     0x10000000U  // GPIO28 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO29     0x20000000U  // GPIO29 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO30     0x40000000U  // GPIO30 interrupt polarity (0:low/fall, 1:high/rise)
#define GPA_INTPOL_GPIO31     0x80000000U  // GPIO31 interrupt polarity (0:low/fall, 1:high/rise)


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTMASK register
//
//*************************************************************************************************
#define GPA_INTMASK_GPIO0      0x00000001U  // GPIO0 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO1      0x00000002U  // GPIO1 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO2      0x00000004U  // GPIO2 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO3      0x00000008U  // GPIO3 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO4      0x00000010U  // GPIO4 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO5      0x00000020U  // GPIO5 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO6      0x00000040U  // GPIO6 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO7      0x00000080U  // GPIO7 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO8      0x00000100U  // GPIO8 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO9      0x00000200U  // GPIO9 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO10     0x00000400U  // GPIO10 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO11     0x00000800U  // GPIO11 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO12     0x00001000U  // GPIO12 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO13     0x00002000U  // GPIO13 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO14     0x00004000U  // GPIO14 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO15     0x00008000U  // GPIO15 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO16     0x00010000U  // GPIO16 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO17     0x00020000U  // GPIO17 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO18     0x00040000U  // GPIO18 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO19     0x00080000U  // GPIO19 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO20     0x00100000U  // GPIO20 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO21     0x00200000U  // GPIO21 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO22     0x00400000U  // GPIO22 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO23     0x00800000U  // GPIO23 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO24     0x01000000U  // GPIO24 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO25     0x02000000U  // GPIO25 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO26     0x04000000U  // GPIO26 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO27     0x08000000U  // GPIO27 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO28     0x10000000U  // GPIO28 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO29     0x20000000U  // GPIO29 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO30     0x40000000U  // GPIO30 interrupt mask (0:masked, 1:unmasked)
#define GPA_INTMASK_GPIO31     0x80000000U  // GPIO31 interrupt mask (0:masked, 1:unmasked)

// All GPIO interrupt mask
#define GPA_INTMASK_ALL        0xFFFFFFFFU  // All GPIO pins interrupt mask

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTCLR register
//
//*************************************************************************************************
#define GPA_INTCLR_GPIO0      0x00000001U  // GPIO0 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO1      0x00000002U  // GPIO1 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO2      0x00000004U  // GPIO2 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO3      0x00000008U  // GPIO3 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO4      0x00000010U  // GPIO4 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO5      0x00000020U  // GPIO5 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO6      0x00000040U  // GPIO6 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO7      0x00000080U  // GPIO7 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO8      0x00000100U  // GPIO8 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO9      0x00000200U  // GPIO9 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO10     0x00000400U  // GPIO10 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO11     0x00000800U  // GPIO11 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO12     0x00001000U  // GPIO12 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO13     0x00002000U  // GPIO13 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO14     0x00004000U  // GPIO14 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO15     0x00008000U  // GPIO15 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO16     0x00010000U  // GPIO16 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO17     0x00020000U  // GPIO17 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO18     0x00040000U  // GPIO18 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO19     0x00080000U  // GPIO19 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO20     0x00100000U  // GPIO20 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO21     0x00200000U  // GPIO21 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO22     0x00400000U  // GPIO22 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO23     0x00800000U  // GPIO23 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO24     0x01000000U  // GPIO24 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO25     0x02000000U  // GPIO25 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO26     0x04000000U  // GPIO26 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO27     0x08000000U  // GPIO27 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO28     0x10000000U  // GPIO28 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO29     0x20000000U  // GPIO29 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO30     0x40000000U  // GPIO30 interrupt clear (Write 1 to clear)
#define GPA_INTCLR_GPIO31     0x80000000U  // GPIO31 interrupt clear (Write 1 to clear)

// All GPIO interrupt clear mask
#define GPA_INTCLR_ALL        0xFFFFFFFFU  // All GPIO pins interrupt clear mask

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTRAW register
//
//*************************************************************************************************
#define GPA_INTRAW_GPIO0      0x00000001U  // GPIO0 raw interrupt status (RO)
#define GPA_INTRAW_GPIO1      0x00000002U  // GPIO1 raw interrupt status (RO)
#define GPA_INTRAW_GPIO2      0x00000004U  // GPIO2 raw interrupt status (RO)
#define GPA_INTRAW_GPIO3      0x00000008U  // GPIO3 raw interrupt status (RO)
#define GPA_INTRAW_GPIO4      0x00000010U  // GPIO4 raw interrupt status (RO)
#define GPA_INTRAW_GPIO5      0x00000020U  // GPIO5 raw interrupt status (RO)
#define GPA_INTRAW_GPIO6      0x00000040U  // GPIO6 raw interrupt status (RO)
#define GPA_INTRAW_GPIO7      0x00000080U  // GPIO7 raw interrupt status (RO)
#define GPA_INTRAW_GPIO8      0x00000100U  // GPIO8 raw interrupt status (RO)
#define GPA_INTRAW_GPIO9      0x00000200U  // GPIO9 raw interrupt status (RO)
#define GPA_INTRAW_GPIO10     0x00000400U  // GPIO10 raw interrupt status (RO)
#define GPA_INTRAW_GPIO11     0x00000800U  // GPIO11 raw interrupt status (RO)
#define GPA_INTRAW_GPIO12     0x00001000U  // GPIO12 raw interrupt status (RO)
#define GPA_INTRAW_GPIO13     0x00002000U  // GPIO13 raw interrupt status (RO)
#define GPA_INTRAW_GPIO14     0x00004000U  // GPIO14 raw interrupt status (RO)
#define GPA_INTRAW_GPIO15     0x00008000U  // GPIO15 raw interrupt status (RO)
#define GPA_INTRAW_GPIO16     0x00010000U  // GPIO16 raw interrupt status (RO)
#define GPA_INTRAW_GPIO17     0x00020000U  // GPIO17 raw interrupt status (RO)
#define GPA_INTRAW_GPIO18     0x00040000U  // GPIO18 raw interrupt status (RO)
#define GPA_INTRAW_GPIO19     0x00080000U  // GPIO19 raw interrupt status (RO)
#define GPA_INTRAW_GPIO20     0x00100000U  // GPIO20 raw interrupt status (RO)
#define GPA_INTRAW_GPIO21     0x00200000U  // GPIO21 raw interrupt status (RO)
#define GPA_INTRAW_GPIO22     0x00400000U  // GPIO22 raw interrupt status (RO)
#define GPA_INTRAW_GPIO23     0x00800000U  // GPIO23 raw interrupt status (RO)
#define GPA_INTRAW_GPIO24     0x01000000U  // GPIO24 raw interrupt status (RO)
#define GPA_INTRAW_GPIO25     0x02000000U  // GPIO25 raw interrupt status (RO)
#define GPA_INTRAW_GPIO26     0x04000000U  // GPIO26 raw interrupt status (RO)
#define GPA_INTRAW_GPIO27     0x08000000U  // GPIO27 raw interrupt status (RO)
#define GPA_INTRAW_GPIO28     0x10000000U  // GPIO28 raw interrupt status (RO)
#define GPA_INTRAW_GPIO29     0x20000000U  // GPIO29 raw interrupt status (RO)
#define GPA_INTRAW_GPIO30     0x40000000U  // GPIO30 raw interrupt status (RO)
#define GPA_INTRAW_GPIO31     0x80000000U  // GPIO31 raw interrupt status (RO)


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTSTATUS register
//
//*************************************************************************************************
#define GPA_INTSTATUS_GPIO0      0x00000001U  // GPIO0 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO1      0x00000002U  // GPIO1 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO2      0x00000004U  // GPIO2 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO3      0x00000008U  // GPIO3 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO4      0x00000010U  // GPIO4 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO5      0x00000020U  // GPIO5 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO6      0x00000040U  // GPIO6 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO7      0x00000080U  // GPIO7 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO8      0x00000100U  // GPIO8 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO9      0x00000200U  // GPIO9 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO10     0x00000400U  // GPIO10 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO11     0x00000800U  // GPIO11 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO12     0x00001000U  // GPIO12 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO13     0x00002000U  // GPIO13 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO14     0x00004000U  // GPIO14 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO15     0x00008000U  // GPIO15 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO16     0x00010000U  // GPIO16 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO17     0x00020000U  // GPIO17 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO18     0x00040000U  // GPIO18 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO19     0x00080000U  // GPIO19 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO20     0x00100000U  // GPIO20 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO21     0x00200000U  // GPIO21 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO22     0x00400000U  // GPIO22 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO23     0x00800000U  // GPIO23 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO24     0x01000000U  // GPIO24 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO25     0x02000000U  // GPIO25 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO26     0x04000000U  // GPIO26 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO27     0x08000000U  // GPIO27 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO28     0x10000000U  // GPIO28 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO29     0x20000000U  // GPIO29 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO30     0x40000000U  // GPIO30 masked interrupt status (RO)
#define GPA_INTSTATUS_GPIO31     0x80000000U  // GPIO31 masked interrupt status (RO)



//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTTYPE register
//
//*************************************************************************************************
#define GPB_INTTYPE_GPIO32     0x00000001U  // GPIO32 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO33     0x00000002U  // GPIO33 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO34     0x00000004U  // GPIO34 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO35     0x00000008U  // GPIO35 interrupt type (0:level, 1:edge)
// Bit 4 is reserved
#define GPB_INTTYPE_GPIO37     0x00000020U  // GPIO37 interrupt type (0:level, 1:edge)
// Bit 6 is reserved
#define GPB_INTTYPE_GPIO39     0x00000080U  // GPIO39 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO40     0x00000100U  // GPIO40 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO41     0x00000200U  // GPIO41 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO42     0x00000400U  // GPIO42 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO43     0x00000800U  // GPIO43 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO44     0x00001000U  // GPIO44 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO45     0x00002000U  // GPIO45 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO46     0x00004000U  // GPIO46 interrupt type (0:level, 1:edge)
// Bit 15 is reserved
#define GPB_INTTYPE_GPIO48      0x00010000U  // GPIO48 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO49      0x00020000U  // GPIO49 interrupt type (0:level, 1:edge)
// Bits 18-20 are reserved
#define GPB_INTTYPE_GPIO53      0x00200000U  // GPIO53 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO54      0x00400000U  // GPIO54 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO55      0x00800000U  // GPIO55 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO56      0x01000000U  // GPIO56 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO57      0x02000000U  // GPIO57 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO58      0x04000000U  // GPIO58 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO59      0x08000000U  // GPIO59 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO60      0x10000000U  // GPIO60 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO61      0x20000000U  // GPIO61 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO62      0x40000000U  // GPIO62 interrupt type (0:level, 1:edge)
#define GPB_INTTYPE_GPIO63      0x80000000U  // GPIO63 interrupt type (0:level, 1:edge)


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTPOL register
//
//*************************************************************************************************
#define GPB_INTPOL_GPIO32     0x00000001U  // GPIO32 interrupt polarity
#define GPB_INTPOL_GPIO33     0x00000002U  // GPIO33 interrupt polarity
#define GPB_INTPOL_GPIO34     0x00000004U  // GPIO34 interrupt polarity
#define GPB_INTPOL_GPIO35     0x00000008U  // GPIO35 interrupt polarity
// Bit 4 is reserved
#define GPB_INTPOL_GPIO37     0x00000020U  // GPIO37 interrupt polarity
// Bit 6 is reserved
#define GPB_INTPOL_GPIO39     0x00000080U  // GPIO39 interrupt polarity
#define GPB_INTPOL_GPIO40     0x00000100U  // GPIO40 interrupt polarity
#define GPB_INTPOL_GPIO41     0x00000200U  // GPIO41 interrupt polarity
#define GPB_INTPOL_GPIO42     0x00000400U  // GPIO42 interrupt polarity
#define GPB_INTPOL_GPIO43     0x00000800U  // GPIO43 interrupt polarity
#define GPB_INTPOL_GPIO44     0x00001000U  // GPIO44 interrupt polarity
#define GPB_INTPOL_GPIO45     0x00002000U  // GPIO45 interrupt polarity
#define GPB_INTPOL_GPIO46     0x00004000U  // GPIO46 interrupt polarity
// Bit 15 is reserved
#define GPB_INTPOL_GPIO48      0x00010000U  // GPIO48 interrupt polarity
#define GPB_INTPOL_GPIO49      0x00020000U  // GPIO49 interrupt polarity
// Bits 18-20 are reserved
#define GPB_INTPOL_GPIO53      0x00200000U  // GPIO53 interrupt polarity
#define GPB_INTPOL_GPIO54      0x00400000U  // GPIO54 interrupt polarity
#define GPB_INTPOL_GPIO55      0x00800000U  // GPIO55 interrupt polarity
#define GPB_INTPOL_GPIO56      0x01000000U  // GPIO56 interrupt polarity
#define GPB_INTPOL_GPIO57      0x02000000U  // GPIO57 interrupt polarity
#define GPB_INTPOL_GPIO58      0x04000000U  // GPIO58 interrupt polarity
#define GPB_INTPOL_GPIO59      0x08000000U  // GPIO59 interrupt polarity
#define GPB_INTPOL_GPIO60      0x10000000U  // GPIO60 interrupt polarity
#define GPB_INTPOL_GPIO61      0x20000000U  // GPIO61 interrupt polarity
#define GPB_INTPOL_GPIO62      0x40000000U  // GPIO62 interrupt polarity
#define GPB_INTPOL_GPIO63      0x80000000U  // GPIO63 interrupt polarity


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTMASK register
//
//*************************************************************************************************
#define GPB_INTMASK_GPIO32     0x00000001U  // GPIO32 interrupt mask
#define GPB_INTMASK_GPIO33     0x00000002U  // GPIO33 interrupt mask
#define GPB_INTMASK_GPIO34     0x00000004U  // GPIO34 interrupt mask
#define GPB_INTMASK_GPIO35     0x00000008U  // GPIO35 interrupt mask
// Bit 4 is reserved
#define GPB_INTMASK_GPIO37     0x00000020U  // GPIO37 interrupt mask
// Bit 6 is reserved
#define GPB_INTMASK_GPIO39     0x00000080U  // GPIO39 interrupt mask
#define GPB_INTMASK_GPIO40     0x00000100U  // GPIO40 interrupt mask
#define GPB_INTMASK_GPIO41     0x00000200U  // GPIO41 interrupt mask
#define GPB_INTMASK_GPIO42     0x00000400U  // GPIO42 interrupt mask
#define GPB_INTMASK_GPIO43     0x00000800U  // GPIO43 interrupt mask
#define GPB_INTMASK_GPIO44     0x00001000U  // GPIO44 interrupt mask
#define GPB_INTMASK_GPIO45     0x00002000U  // GPIO45 interrupt mask
#define GPB_INTMASK_GPIO46     0x00004000U  // GPIO46 interrupt mask
// Bit 15 is reserved
#define GPB_INTMASK_GPIO48      0x00010000U  // GPIO48 interrupt mask
#define GPB_INTMASK_GPIO49      0x00020000U  // GPIO49 interrupt mask
// Bits 18-20 are reserved
#define GPB_INTMASK_GPIO53      0x00200000U  // GPIO53 interrupt mask
#define GPB_INTMASK_GPIO54      0x00400000U  // GPIO54 interrupt mask
#define GPB_INTMASK_GPIO55      0x00800000U  // GPIO55 interrupt mask
#define GPB_INTMASK_GPIO56      0x01000000U  // GPIO56 interrupt mask
#define GPB_INTMASK_GPIO57      0x02000000U  // GPIO57 interrupt mask
#define GPB_INTMASK_GPIO58      0x04000000U  // GPIO58 interrupt mask
#define GPB_INTMASK_GPIO59      0x08000000U  // GPIO59 interrupt mask
#define GPB_INTMASK_GPIO60      0x10000000U  // GPIO60 interrupt mask
#define GPB_INTMASK_GPIO61      0x20000000U  // GPIO61 interrupt mask
#define GPB_INTMASK_GPIO62      0x40000000U  // GPIO62 interrupt mask
#define GPB_INTMASK_GPIO63      0x80000000U  // GPIO63 interrupt mask

#define GPB_INTMASK_ALL         0xFFE37FAFU  // Mask all GPIO interrupts

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTCLR register
//
//*************************************************************************************************
#define GPB_INTCLR_GPIO32     0x00000001U  // GPIO32 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO33     0x00000002U  // GPIO33 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO34     0x00000004U  // GPIO34 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO35     0x00000008U  // GPIO35 interrupt clear (W1SR0)
// Bit 4 is reserved
#define GPB_INTCLR_GPIO37     0x00000020U  // GPIO37 interrupt clear (W1SR0)
// Bit 6 is reserved
#define GPB_INTCLR_GPIO39     0x00000080U  // GPIO39 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO40     0x00000100U  // GPIO40 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO41     0x00000200U  // GPIO41 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO42     0x00000400U  // GPIO42 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO43     0x00000800U  // GPIO43 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO44     0x00001000U  // GPIO44 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO45     0x00002000U  // GPIO45 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO46     0x00004000U  // GPIO46 interrupt clear (W1SR0)
// Bit 15 is reserved
#define GPB_INTCLR_GPIO48      0x00010000U  // GPIO48 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO49      0x00020000U  // GPIO49 interrupt clear (W1SR0)
// Bits 18-20 are reserved
#define GPB_INTCLR_GPIO53      0x00200000U  // GPIO53 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO54      0x00400000U  // GPIO54 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO55      0x00800000U  // GPIO55 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO56      0x01000000U  // GPIO56 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO57      0x02000000U  // GPIO57 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO58      0x04000000U  // GPIO58 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO59      0x08000000U  // GPIO59 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO60      0x10000000U  // GPIO60 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO61      0x20000000U  // GPIO61 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO62      0x40000000U  // GPIO62 interrupt clear (W1SR0)
#define GPB_INTCLR_GPIO63      0x80000000U  // GPIO63 interrupt clear (W1SR0)

// Useful combinations
#define GPB_INTCLR_ALL         0xFFE37FAFU  // Clear all available GPIO interrupts (excluding reserved bits)


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTRAW register
//
//*************************************************************************************************
#define GPB_INTRAW_GPIO32     0x00000001U  // GPIO32 raw interrupt status (RO)
#define GPB_INTRAW_GPIO33     0x00000002U  // GPIO33 raw interrupt status (RO)
#define GPB_INTRAW_GPIO34     0x00000004U  // GPIO34 raw interrupt status (RO)
#define GPB_INTRAW_GPIO35     0x00000008U  // GPIO35 raw interrupt status (RO)
// Bit 4 is reserved
#define GPB_INTRAW_GPIO37     0x00000020U  // GPIO37 raw interrupt status (RO)
// Bit 6 is reserved
#define GPB_INTRAW_GPIO39     0x00000080U  // GPIO39 raw interrupt status (RO)
#define GPB_INTRAW_GPIO40     0x00000100U  // GPIO40 raw interrupt status (RO)
#define GPB_INTRAW_GPIO41     0x00000200U  // GPIO41 raw interrupt status (RO)
#define GPB_INTRAW_GPIO42     0x00000400U  // GPIO42 raw interrupt status (RO)
#define GPB_INTRAW_GPIO43     0x00000800U  // GPIO43 raw interrupt status (RO)
#define GPB_INTRAW_GPIO44     0x00001000U  // GPIO44 raw interrupt status (RO)
#define GPB_INTRAW_GPIO45     0x00002000U  // GPIO45 raw interrupt status (RO)
#define GPB_INTRAW_GPIO46     0x00004000U  // GPIO46 raw interrupt status (RO)
// Bit 15 is reserved
#define GPB_INTRAW_GPIO48      0x00010000U  // GPIO48 raw interrupt status (RO)
#define GPB_INTRAW_GPIO49      0x00020000U  // GPIO49 raw interrupt status (RO)
// Bits 18-20 are reserved
#define GPB_INTRAW_GPIO53      0x00200000U  // GPIO53 raw interrupt status (RO)
#define GPB_INTRAW_GPIO54      0x00400000U  // GPIO54 raw interrupt status (RO)
#define GPB_INTRAW_GPIO55      0x00800000U  // GPIO55 raw interrupt status (RO)
#define GPB_INTRAW_GPIO56      0x01000000U  // GPIO56 raw interrupt status (RO)
#define GPB_INTRAW_GPIO57      0x02000000U  // GPIO57 raw interrupt status (RO)
#define GPB_INTRAW_GPIO58      0x04000000U  // GPIO58 raw interrupt status (RO)
#define GPB_INTRAW_GPIO59      0x08000000U  // GPIO59 raw interrupt status (RO)
#define GPB_INTRAW_GPIO60      0x10000000U  // GPIO60 raw interrupt status (RO)
#define GPB_INTRAW_GPIO61      0x20000000U  // GPIO61 raw interrupt status (RO)
#define GPB_INTRAW_GPIO62      0x40000000U  // GPIO62 raw interrupt status (RO)
#define GPB_INTRAW_GPIO63      0x80000000U  // GPIO63 raw interrupt status (RO)



//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTSTATUS register
//
//*************************************************************************************************
#define GPB_INTSTATUS_GPIO32     0x00000001U  // GPIO32 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO33     0x00000002U  // GPIO33 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO34     0x00000004U  // GPIO34 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO35     0x00000008U  // GPIO35 masked interrupt status (RO)
// Bit 4 is reserved
#define GPB_INTSTATUS_GPIO37     0x00000020U  // GPIO37 masked interrupt status (RO)
// Bit 6 is reserved
#define GPB_INTSTATUS_GPIO39     0x00000080U  // GPIO39 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO40     0x00000100U  // GPIO40 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO41     0x00000200U  // GPIO41 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO42     0x00000400U  // GPIO42 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO43     0x00000800U  // GPIO43 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO44     0x00001000U  // GPIO44 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO45     0x00002000U  // GPIO45 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO46     0x00004000U  // GPIO46 masked interrupt status (RO)
// Bit 15 is reserved
#define GPB_INTSTATUS_GPIO48      0x00010000U  // GPIO48 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO49      0x00020000U  // GPIO49 masked interrupt status (RO)
// Bits 18-20 are reserved
#define GPB_INTSTATUS_GPIO53      0x00200000U  // GPIO53 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO54      0x00400000U  // GPIO54 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO55      0x00800000U  // GPIO55 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO56      0x01000000U  // GPIO56 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO57      0x02000000U  // GPIO57 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO58      0x04000000U  // GPIO58 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO59      0x08000000U  // GPIO59 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO60      0x10000000U  // GPIO60 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO61      0x20000000U  // GPIO61 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO62      0x40000000U  // GPIO62 masked interrupt status (RO)
#define GPB_INTSTATUS_GPIO63      0x80000000U  // GPIO63 masked interrupt status (RO)


//*************************************************************************************************
//
// The following are defines for the bit fields in the JTAGDIS register
//
//*************************************************************************************************
#define GPIO_JTAGDIS                 0x00000001U  // Jtag Port Disable bit: when disabled ,the Jtag pins can be used as gpio :
                                            // 0 : JTAG Port enabled 
                                            // 1:  JTAG Port Disabled(GPIO Mode)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPG_INTTYPE register
//
//*************************************************************************************************
#define GPG_INTTYPE_AGPIO200    0x00000001U  // GPIO200 interrupt type (RW)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPG_INTPOL register
//
//*************************************************************************************************
#define GPG_INTPOL_AGPIO200     0x00000001U  // GPIO200 interrupt polarity (RW)


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPG_INTMASK register
//
//*************************************************************************************************
#define GPG_INTMASK_AGPIO200    0x00000001U  // GPIO200 interrupt mask (RW)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPG_INTCLR register
//
//*************************************************************************************************
#define GPG_INTCLR_AGPIO200     0x00000001U  // GPIO200 interrupt clear (W1SR0)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPG_INTRAW register
//
//*************************************************************************************************
#define GPG_INTRAW_AGPIO200     0x00000001U  // GPIO200 raw interrupt status (RO)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPG_INTSTATUS register
//
//*************************************************************************************************
#define GPG_INTSTATUS_AGPIO200  0x00000001U  // GPIO200 masked interrupt status (RO)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPH_INTTYPE register
//
//*************************************************************************************************
// GPIO interrupt type bits
#define GPH_INTTYPE_GPIO248    0x01000000U  // GPIO248 interrupt type (RW)
#define GPH_INTTYPE_GPIO245    0x00200000U  // GPIO245 interrupt type (RW)
#define GPH_INTTYPE_GPIO244    0x00100000U  // GPIO244 interrupt type (RW)
#define GPH_INTTYPE_GPIO242    0x00040000U  // GPIO242 interrupt type (RW)
#define GPH_INTTYPE_GPIO241    0x00020000U  // GPIO241 interrupt type (RW)
#define GPH_INTTYPE_GPIO239    0x00008000U  // GPIO239 interrupt type (RW)
#define GPH_INTTYPE_GPIO238    0x00004000U  // GPIO238 interrupt type (RW)
#define GPH_INTTYPE_GPIO237    0x00002000U  // GPIO237 interrupt type (RW)
#define GPH_INTTYPE_GPIO236    0x00001000U  // GPIO236 interrupt type (RW)
#define GPH_INTTYPE_GPIO235    0x00000800U  // GPIO235 interrupt type (RW)
#define GPH_INTTYPE_GPIO234    0x00000400U  // GPIO234 interrupt type (RW)
#define GPH_INTTYPE_GPIO233    0x00000200U  // GPIO233 interrupt type (RW)
#define GPH_INTTYPE_GPIO232    0x00000100U  // GPIO232 interrupt type (RW)
#define GPH_INTTYPE_GPIO231    0x00000080U  // GPIO231 interrupt type (RW)
#define GPH_INTTYPE_GPIO230    0x00000040U  // GPIO230 interrupt type (RW)
#define GPH_INTTYPE_GPIO228    0x00000010U  // GPIO228 interrupt type (RW)
#define GPH_INTTYPE_GPIO227    0x00000008U  // GPIO227 interrupt type (RW)
#define GPH_INTTYPE_GPIO226    0x00000004U  // GPIO226 interrupt type (RW)
#define GPH_INTTYPE_GPIO225    0x00000002U  // GPIO225 interrupt type (RW)
#define GPH_INTTYPE_GPIO224    0x00000001U  // GPIO224 interrupt type (RW)



//*************************************************************************************************
//
// The following are defines for the bit fields in the GPH_INTPOL register
//
//*************************************************************************************************
// GPIO interrupt polarity bits
#define GPH_INTPOL_GPIO248    0x01000000U  // GPIO248 interrupt polarity (RW)
#define GPH_INTPOL_GPIO245    0x00200000U  // GPIO245 interrupt polarity (RW)
#define GPH_INTPOL_GPIO244    0x00100000U  // GPIO244 interrupt polarity (RW)
#define GPH_INTPOL_GPIO242    0x00040000U  // GPIO242 interrupt polarity (RW)
#define GPH_INTPOL_GPIO241    0x00020000U  // GPIO241 interrupt polarity (RW)
#define GPH_INTPOL_GPIO239    0x00008000U  // GPIO239 interrupt polarity (RW)
#define GPH_INTPOL_GPIO238    0x00004000U  // GPIO238 interrupt polarity (RW)
#define GPH_INTPOL_GPIO237    0x00002000U  // GPIO237 interrupt polarity (RW)
#define GPH_INTPOL_GPIO236    0x00001000U  // GPIO236 interrupt polarity (RW)
#define GPH_INTPOL_GPIO235    0x00000800U  // GPIO235 interrupt polarity (RW)
#define GPH_INTPOL_GPIO234    0x00000400U  // GPIO234 interrupt polarity (RW)
#define GPH_INTPOL_GPIO233    0x00000200U  // GPIO233 interrupt polarity (RW)
#define GPH_INTPOL_GPIO232    0x00000100U  // GPIO232 interrupt polarity (RW)
#define GPH_INTPOL_GPIO231    0x00000080U  // GPIO231 interrupt polarity (RW)
#define GPH_INTPOL_GPIO230    0x00000040U  // GPIO230 interrupt polarity (RW)
#define GPH_INTPOL_GPIO228    0x00000010U  // GPIO228 interrupt polarity (RW)
#define GPH_INTPOL_GPIO227    0x00000008U  // GPIO227 interrupt polarity (RW)
#define GPH_INTPOL_GPIO226    0x00000004U  // GPIO226 interrupt polarity (RW)
#define GPH_INTPOL_GPIO225    0x00000002U  // GPIO225 interrupt polarity (RW)
#define GPH_INTPOL_GPIO224    0x00000001U  // GPIO224 interrupt polarity (RW)


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPH_INTMASK register
//
//*************************************************************************************************
// GPIO interrupt mask bits
#define GPH_INTMASK_GPIO248    0x01000000U  // GPIO248 interrupt mask (RW)
#define GPH_INTMASK_GPIO245    0x00200000U  // GPIO245 interrupt mask (RW)
#define GPH_INTMASK_GPIO244    0x00100000U  // GPIO244 interrupt mask (RW)
#define GPH_INTMASK_GPIO242    0x00040000U  // GPIO242 interrupt mask (RW)
#define GPH_INTMASK_GPIO241    0x00020000U  // GPIO241 interrupt mask (RW)
#define GPH_INTMASK_GPIO239    0x00008000U  // GPIO239 interrupt mask (RW)
#define GPH_INTMASK_GPIO238    0x00004000U  // GPIO238 interrupt mask (RW)
#define GPH_INTMASK_GPIO237    0x00002000U  // GPIO237 interrupt mask (RW)
#define GPH_INTMASK_GPIO236    0x00001000U  // GPIO236 interrupt mask (RW)
#define GPH_INTMASK_GPIO235    0x00000800U  // GPIO235 interrupt mask (RW)
#define GPH_INTMASK_GPIO234    0x00000400U  // GPIO234 interrupt mask (RW)
#define GPH_INTMASK_GPIO233    0x00000200U  // GPIO233 interrupt mask (RW)
#define GPH_INTMASK_GPIO232    0x00000100U  // GPIO232 interrupt mask (RW)
#define GPH_INTMASK_GPIO231    0x00000080U  // GPIO231 interrupt mask (RW)
#define GPH_INTMASK_GPIO230    0x00000040U  // GPIO230 interrupt mask (RW)
#define GPH_INTMASK_GPIO228    0x00000010U  // GPIO228 interrupt mask (RW)
#define GPH_INTMASK_GPIO227    0x00000008U  // GPIO227 interrupt mask (RW)
#define GPH_INTMASK_GPIO226    0x00000004U  // GPIO226 interrupt mask (RW)
#define GPH_INTMASK_GPIO225    0x00000002U  // GPIO225 interrupt mask (RW)
#define GPH_INTMASK_GPIO224    0x00000001U  // GPIO224 interrupt mask (RW)

#define GPH_INTMASK_ALL        0x0136FDFFU  // Mask all GPIO interrupts (RW)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPH_INTCLR register
//
//*************************************************************************************************
// GPIO interrupt clear bits (W1SR0)
#define GPH_INTCLR_GPIO248    0x01000000U  // GPIO248 interrupt clear
#define GPH_INTCLR_GPIO245    0x00200000U  // GPIO245 interrupt clear
#define GPH_INTCLR_GPIO244    0x00100000U  // GPIO244 interrupt clear
#define GPH_INTCLR_GPIO242    0x00040000U  // GPIO242 interrupt clear
#define GPH_INTCLR_GPIO241    0x00020000U  // GPIO241 interrupt clear
#define GPH_INTCLR_GPIO239    0x00008000U  // GPIO239 interrupt clear
#define GPH_INTCLR_GPIO238    0x00004000U  // GPIO238 interrupt clear
#define GPH_INTCLR_GPIO237    0x00002000U  // GPIO237 interrupt clear
#define GPH_INTCLR_GPIO236    0x00001000U  // GPIO236 interrupt clear
#define GPH_INTCLR_GPIO235    0x00000800U  // GPIO235 interrupt clear
#define GPH_INTCLR_GPIO234    0x00000400U  // GPIO234 interrupt clear
#define GPH_INTCLR_GPIO233    0x00000200U  // GPIO233 interrupt clear
#define GPH_INTCLR_GPIO232    0x00000100U  // GPIO232 interrupt clear
#define GPH_INTCLR_GPIO231    0x00000080U  // GPIO231 interrupt clear
#define GPH_INTCLR_GPIO230    0x00000040U  // GPIO230 interrupt clear
#define GPH_INTCLR_GPIO228    0x00000010U  // GPIO228 interrupt clear
#define GPH_INTCLR_GPIO227    0x00000008U  // GPIO227 interrupt clear
#define GPH_INTCLR_GPIO226    0x00000004U  // GPIO226 interrupt clear
#define GPH_INTCLR_GPIO225    0x00000002U  // GPIO225 interrupt clear
#define GPH_INTCLR_GPIO224    0x00000001U  // GPIO224 interrupt clear

#define GPH_INTCLR_ALL        0x0136FDFFU  // Clear all GPIO interrupts

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPH_INTRAW register
//
//*************************************************************************************************
// GPIO raw interrupt status bits (RO)
#define GPH_INTRAW_GPIO248    0x01000000U  // GPIO248 raw interrupt status
#define GPH_INTRAW_GPIO245    0x00200000U  // GPIO245 raw interrupt status
#define GPH_INTRAW_GPIO244    0x00100000U  // GPIO244 raw interrupt status
#define GPH_INTRAW_GPIO242    0x00040000U  // GPIO242 raw interrupt status
#define GPH_INTRAW_GPIO241    0x00020000U  // GPIO241 raw interrupt status
#define GPH_INTRAW_GPIO239    0x00008000U  // GPIO239 raw interrupt status
#define GPH_INTRAW_GPIO238    0x00004000U  // GPIO238 raw interrupt status
#define GPH_INTRAW_GPIO237    0x00002000U  // GPIO237 raw interrupt status
#define GPH_INTRAW_GPIO236    0x00001000U  // GPIO236 raw interrupt status
#define GPH_INTRAW_GPIO235    0x00000800U  // GPIO235 raw interrupt status
#define GPH_INTRAW_GPIO234    0x00000400U  // GPIO234 raw interrupt status
#define GPH_INTRAW_GPIO233    0x00000200U  // GPIO233 raw interrupt status
#define GPH_INTRAW_GPIO232    0x00000100U  // GPIO232 raw interrupt status
#define GPH_INTRAW_GPIO231    0x00000080U  // GPIO231 raw interrupt status
#define GPH_INTRAW_GPIO230    0x00000040U  // GPIO230 raw interrupt status
#define GPH_INTRAW_GPIO228    0x00000010U  // GPIO228 raw interrupt status
#define GPH_INTRAW_GPIO227    0x00000008U  // GPIO227 raw interrupt status
#define GPH_INTRAW_GPIO226    0x00000004U  // GPIO226 raw interrupt status
#define GPH_INTRAW_GPIO225    0x00000002U  // GPIO225 raw interrupt status
#define GPH_INTRAW_GPIO224    0x00000001U  // GPIO224 raw interrupt status

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPH_INTSTATUS register
//
//*************************************************************************************************
// GPIO masked interrupt status bits (RO)
#define GPH_INTSTATUS_GPIO248    0x01000000U  // GPIO248 masked interrupt status
#define GPH_INTSTATUS_GPIO245    0x00200000U  // GPIO245 masked interrupt status
#define GPH_INTSTATUS_GPIO244    0x00100000U  // GPIO244 masked interrupt status
#define GPH_INTSTATUS_GPIO242    0x00040000U  // GPIO242 masked interrupt status
#define GPH_INTSTATUS_GPIO241    0x00020000U  // GPIO241 masked interrupt status
#define GPH_INTSTATUS_GPIO239    0x00008000U  // GPIO239 masked interrupt status
#define GPH_INTSTATUS_GPIO238    0x00004000U  // GPIO238 masked interrupt status
#define GPH_INTSTATUS_GPIO237    0x00002000U  // GPIO237 masked interrupt status
#define GPH_INTSTATUS_GPIO236    0x00001000U  // GPIO236 masked interrupt status
#define GPH_INTSTATUS_GPIO235    0x00000800U  // GPIO235 masked interrupt status
#define GPH_INTSTATUS_GPIO234    0x00000400U  // GPIO234 masked interrupt status
#define GPH_INTSTATUS_GPIO233    0x00000200U  // GPIO233 masked interrupt status
#define GPH_INTSTATUS_GPIO232    0x00000100U  // GPIO232 masked interrupt status
#define GPH_INTSTATUS_GPIO231    0x00000080U  // GPIO231 masked interrupt status
#define GPH_INTSTATUS_GPIO230    0x00000040U  // GPIO230 masked interrupt status
#define GPH_INTSTATUS_GPIO228    0x00000010U  // GPIO228 masked interrupt status
#define GPH_INTSTATUS_GPIO227    0x00000008U  // GPIO227 masked interrupt status
#define GPH_INTSTATUS_GPIO226    0x00000004U  // GPIO226 masked interrupt status
#define GPH_INTSTATUS_GPIO225    0x00000002U  // GPIO225 masked interrupt status
#define GPH_INTSTATUS_GPIO224    0x00000001U  // GPIO224 masked interrupt status

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTTYPE_3527 register
//
//*************************************************************************************************
// GPIO interrupt type bits
#define GPA_INTTYPE_GPIO31_3527    0x80000000U  // GPIO31 interrupt type (RW)
#define GPA_INTTYPE_GPIO30_3527    0x40000000U  // GPIO30 interrupt type (RW)
#define GPA_INTTYPE_GPIO29_3527    0x20000000U  // GPIO29 interrupt type (RW)
#define GPA_INTTYPE_GPIO28_3527    0x10000000U  // GPIO28 interrupt type (RW)
#define GPA_INTTYPE_GPIO27_3527    0x08000000U  // GPIO27 interrupt type (RW)
#define GPA_INTTYPE_GPIO26_3527    0x04000000U  // GPIO26 interrupt type (RW)
#define GPA_INTTYPE_GPIO25_3527    0x02000000U  // GPIO25 interrupt type (RW)
#define GPA_INTTYPE_GPIO24_3527    0x01000000U  // GPIO24 interrupt type (RW)
#define GPA_INTTYPE_GPIO23_3527    0x00800000U  // GPIO23 interrupt type (RW)
#define GPA_INTTYPE_GPIO22_3527    0x00400000U  // GPIO22 interrupt type (RW)
#define GPA_INTTYPE_GPIO21_3527    0x00200000U  // GPIO21 interrupt type (RW)
#define GPA_INTTYPE_GPIO20_3527    0x00100000U  // GPIO20 interrupt type (RW)
#define GPA_INTTYPE_GPIO19_3527    0x00080000U  // GPIO19 interrupt type (RW)
#define GPA_INTTYPE_GPIO18_3527    0x00040000U  // GPIO18 interrupt type (RW)
#define GPA_INTTYPE_GPIO17_3527    0x00020000U  // GPIO17 interrupt type (RW)
#define GPA_INTTYPE_GPIO16_3527    0x00010000U  // GPIO16 interrupt type (RW)
#define GPA_INTTYPE_GPIO15_3527    0x00008000U  // GPIO15 interrupt type (RW)
#define GPA_INTTYPE_GPIO14_3527    0x00004000U  // GPIO14 interrupt type (RW)
#define GPA_INTTYPE_GPIO13_3527    0x00002000U  // GPIO13 interrupt type (RW)
#define GPA_INTTYPE_GPIO12_3527    0x00001000U  // GPIO12 interrupt type (RW)
#define GPA_INTTYPE_GPIO11_3527    0x00000800U  // GPIO11 interrupt type (RW)
#define GPA_INTTYPE_GPIO10_3527    0x00000400U  // GPIO10 interrupt type (RW)
#define GPA_INTTYPE_GPIO9_3527     0x00000200U  // GPIO9 interrupt type (RW)
#define GPA_INTTYPE_GPIO8_3527     0x00000100U  // GPIO8 interrupt type (RW)
#define GPA_INTTYPE_GPIO7_3527     0x00000080U  // GPIO7 interrupt type (RW)
#define GPA_INTTYPE_GPIO6_3527     0x00000040U  // GPIO6 interrupt type (RW)
#define GPA_INTTYPE_GPIO5_3527     0x00000020U  // GPIO5 interrupt type (RW)
#define GPA_INTTYPE_GPIO4_3527     0x00000010U  // GPIO4 interrupt type (RW)
#define GPA_INTTYPE_GPIO3_3527     0x00000008U  // GPIO3 interrupt type (RW)
#define GPA_INTTYPE_GPIO2_3527     0x00000004U  // GPIO2 interrupt type (RW)
#define GPA_INTTYPE_GPIO1_3527     0x00000002U  // GPIO1 interrupt type (RW)
#define GPA_INTTYPE_GPIO0_3527     0x00000001U  // GPIO0 interrupt type (RW)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTPOL_3527 register
//
//*************************************************************************************************
// GPIO interrupt polarity bits
#define GPA_INTPOL_GPIO31_3527    0x80000000U  // GPIO31 interrupt polarity (RW)
#define GPA_INTPOL_GPIO30_3527    0x40000000U  // GPIO30 interrupt polarity (RW)
#define GPA_INTPOL_GPIO29_3527    0x20000000U  // GPIO29 interrupt polarity (RW)
#define GPA_INTPOL_GPIO28_3527    0x10000000U  // GPIO28 interrupt polarity (RW)
#define GPA_INTPOL_GPIO27_3527    0x08000000U  // GPIO27 interrupt polarity (RW)
#define GPA_INTPOL_GPIO26_3527    0x04000000U  // GPIO26 interrupt polarity (RW)
#define GPA_INTPOL_GPIO25_3527    0x02000000U  // GPIO25 interrupt polarity (RW)
#define GPA_INTPOL_GPIO24_3527    0x01000000U  // GPIO24 interrupt polarity (RW)
#define GPA_INTPOL_GPIO23_3527    0x00800000U  // GPIO23 interrupt polarity (RW)
#define GPA_INTPOL_GPIO22_3527    0x00400000U  // GPIO22 interrupt polarity (RW)
#define GPA_INTPOL_GPIO21_3527    0x00200000U  // GPIO21 interrupt polarity (RW)
#define GPA_INTPOL_GPIO20_3527    0x00100000U  // GPIO20 interrupt polarity (RW)
#define GPA_INTPOL_GPIO19_3527    0x00080000U  // GPIO19 interrupt polarity (RW)
#define GPA_INTPOL_GPIO18_3527    0x00040000U  // GPIO18 interrupt polarity (RW)
#define GPA_INTPOL_GPIO17_3527    0x00020000U  // GPIO17 interrupt polarity (RW)
#define GPA_INTPOL_GPIO16_3527    0x00010000U  // GPIO16 interrupt polarity (RW)
#define GPA_INTPOL_GPIO15_3527    0x00008000U  // GPIO15 interrupt polarity (RW)
#define GPA_INTPOL_GPIO14_3527    0x00004000U  // GPIO14 interrupt polarity (RW)
#define GPA_INTPOL_GPIO13_3527    0x00002000U  // GPIO13 interrupt polarity (RW)
#define GPA_INTPOL_GPIO12_3527    0x00001000U  // GPIO12 interrupt polarity (RW)
#define GPA_INTPOL_GPIO11_3527    0x00000800U  // GPIO11 interrupt polarity (RW)
#define GPA_INTPOL_GPIO10_3527    0x00000400U  // GPIO10 interrupt polarity (RW)
#define GPA_INTPOL_GPIO9_3527     0x00000200U  // GPIO9 interrupt polarity (RW)
#define GPA_INTPOL_GPIO8_3527     0x00000100U  // GPIO8 interrupt polarity (RW)
#define GPA_INTPOL_GPIO7_3527     0x00000080U  // GPIO7 interrupt polarity (RW)
#define GPA_INTPOL_GPIO6_3527     0x00000040U  // GPIO6 interrupt polarity (RW)
#define GPA_INTPOL_GPIO5_3527     0x00000020U  // GPIO5 interrupt polarity (RW)
#define GPA_INTPOL_GPIO4_3527     0x00000010U  // GPIO4 interrupt polarity (RW)
#define GPA_INTPOL_GPIO3_3527     0x00000008U  // GPIO3 interrupt polarity (RW)
#define GPA_INTPOL_GPIO2_3527     0x00000004U  // GPIO2 interrupt polarity (RW)
#define GPA_INTPOL_GPIO1_3527     0x00000002U  // GPIO1 interrupt polarity (RW)
#define GPA_INTPOL_GPIO0_3527     0x00000001U  // GPIO0 interrupt polarity (RW)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTMASK_3527 register
//
//*************************************************************************************************
// GPIO interrupt mask bits
#define GPA_INTMASK_GPIO31_3527    0x80000000U  // GPIO31 interrupt mask (RW)
#define GPA_INTMASK_GPIO30_3527    0x40000000U  // GPIO30 interrupt mask (RW)
#define GPA_INTMASK_GPIO29_3527    0x20000000U  // GPIO29 interrupt mask (RW)
#define GPA_INTMASK_GPIO28_3527    0x10000000U  // GPIO28 interrupt mask (RW)
#define GPA_INTMASK_GPIO27_3527    0x08000000U  // GPIO27 interrupt mask (RW)
#define GPA_INTMASK_GPIO26_3527    0x04000000U  // GPIO26 interrupt mask (RW)
#define GPA_INTMASK_GPIO25_3527    0x02000000U  // GPIO25 interrupt mask (RW)
#define GPA_INTMASK_GPIO24_3527    0x01000000U  // GPIO24 interrupt mask (RW)
#define GPA_INTMASK_GPIO23_3527    0x00800000U  // GPIO23 interrupt mask (RW)
#define GPA_INTMASK_GPIO22_3527    0x00400000U  // GPIO22 interrupt mask (RW)
#define GPA_INTMASK_GPIO21_3527    0x00200000U  // GPIO21 interrupt mask (RW)
#define GPA_INTMASK_GPIO20_3527    0x00100000U  // GPIO20 interrupt mask (RW)
#define GPA_INTMASK_GPIO19_3527    0x00080000U  // GPIO19 interrupt mask (RW)
#define GPA_INTMASK_GPIO18_3527    0x00040000U  // GPIO18 interrupt mask (RW)
#define GPA_INTMASK_GPIO17_3527    0x00020000U  // GPIO17 interrupt mask (RW)
#define GPA_INTMASK_GPIO16_3527    0x00010000U  // GPIO16 interrupt mask (RW)
#define GPA_INTMASK_GPIO15_3527    0x00008000U  // GPIO15 interrupt mask (RW)
#define GPA_INTMASK_GPIO14_3527    0x00004000U  // GPIO14 interrupt mask (RW)
#define GPA_INTMASK_GPIO13_3527    0x00002000U  // GPIO13 interrupt mask (RW)
#define GPA_INTMASK_GPIO12_3527    0x00001000U  // GPIO12 interrupt mask (RW)
#define GPA_INTMASK_GPIO11_3527    0x00000800U  // GPIO11 interrupt mask (RW)
#define GPA_INTMASK_GPIO10_3527    0x00000400U  // GPIO10 interrupt mask (RW)
#define GPA_INTMASK_GPIO9_3527     0x00000200U  // GPIO9 interrupt mask (RW)
#define GPA_INTMASK_GPIO8_3527     0x00000100U  // GPIO8 interrupt mask (RW)
#define GPA_INTMASK_GPIO7_3527     0x00000080U  // GPIO7 interrupt mask (RW)
#define GPA_INTMASK_GPIO6_3527     0x00000040U  // GPIO6 interrupt mask (RW)
#define GPA_INTMASK_GPIO5_3527     0x00000020U  // GPIO5 interrupt mask (RW)
#define GPA_INTMASK_GPIO4_3527     0x00000010U  // GPIO4 interrupt mask (RW)
#define GPA_INTMASK_GPIO3_3527     0x00000008U  // GPIO3 interrupt mask (RW)
#define GPA_INTMASK_GPIO2_3527     0x00000004U  // GPIO2 interrupt mask (RW)
#define GPA_INTMASK_GPIO1_3527     0x00000002U  // GPIO1 interrupt mask (RW)
#define GPA_INTMASK_GPIO0_3527     0x00000001U  // GPIO0 interrupt mask (RW)

#define GPA_INTMASK_ALL_3527       0xFFFFFFFFU  // Mask all GPIO interrupts (RW)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTCLR_3527 register
//
//*************************************************************************************************
// GPIO interrupt clear bits (W1SR0)
#define GPA_INTCLR_GPIO31_3527    0x80000000U  // GPIO31 interrupt clear
#define GPA_INTCLR_GPIO30_3527    0x40000000U  // GPIO30 interrupt clear
#define GPA_INTCLR_GPIO29_3527    0x20000000U  // GPIO29 interrupt clear
#define GPA_INTCLR_GPIO28_3527    0x10000000U  // GPIO28 interrupt clear
#define GPA_INTCLR_GPIO27_3527    0x08000000U  // GPIO27 interrupt clear
#define GPA_INTCLR_GPIO26_3527    0x04000000U  // GPIO26 interrupt clear
#define GPA_INTCLR_GPIO25_3527    0x02000000U  // GPIO25 interrupt clear
#define GPA_INTCLR_GPIO24_3527    0x01000000U  // GPIO24 interrupt clear
#define GPA_INTCLR_GPIO23_3527    0x00800000U  // GPIO23 interrupt clear
#define GPA_INTCLR_GPIO22_3527    0x00400000U  // GPIO22 interrupt clear
#define GPA_INTCLR_GPIO21_3527    0x00200000U  // GPIO21 interrupt clear
#define GPA_INTCLR_GPIO20_3527    0x00100000U  // GPIO20 interrupt clear
#define GPA_INTCLR_GPIO19_3527    0x00080000U  // GPIO19 interrupt clear
#define GPA_INTCLR_GPIO18_3527    0x00040000U  // GPIO18 interrupt clear
#define GPA_INTCLR_GPIO17_3527    0x00020000U  // GPIO17 interrupt clear
#define GPA_INTCLR_GPIO16_3527    0x00010000U  // GPIO16 interrupt clear
#define GPA_INTCLR_GPIO15_3527    0x00008000U  // GPIO15 interrupt clear
#define GPA_INTCLR_GPIO14_3527    0x00004000U  // GPIO14 interrupt clear
#define GPA_INTCLR_GPIO13_3527    0x00002000U  // GPIO13 interrupt clear
#define GPA_INTCLR_GPIO12_3527    0x00001000U  // GPIO12 interrupt clear
#define GPA_INTCLR_GPIO11_3527    0x00000800U  // GPIO11 interrupt clear
#define GPA_INTCLR_GPIO10_3527    0x00000400U  // GPIO10 interrupt clear
#define GPA_INTCLR_GPIO9_3527     0x00000200U  // GPIO9 interrupt clear
#define GPA_INTCLR_GPIO8_3527     0x00000100U  // GPIO8 interrupt clear
#define GPA_INTCLR_GPIO7_3527     0x00000080U  // GPIO7 interrupt clear
#define GPA_INTCLR_GPIO6_3527     0x00000040U  // GPIO6 interrupt clear
#define GPA_INTCLR_GPIO5_3527     0x00000020U  // GPIO5 interrupt clear
#define GPA_INTCLR_GPIO4_3527     0x00000010U  // GPIO4 interrupt clear
#define GPA_INTCLR_GPIO3_3527     0x00000008U  // GPIO3 interrupt clear
#define GPA_INTCLR_GPIO2_3527     0x00000004U  // GPIO2 interrupt clear
#define GPA_INTCLR_GPIO1_3527     0x00000002U  // GPIO1 interrupt clear
#define GPA_INTCLR_GPIO0_3527     0x00000001U  // GPIO0 interrupt clear

// Useful combinations
#define GPA_INTCLR_ALL_3527       0xFFFFFFFFU  // Clear all interrupts

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTRAW_3527 register
//
//*************************************************************************************************
// GPIO raw interrupt status bits (RO)
#define GPA_INTRAW_GPIO31_3527    0x80000000U  // GPIO31 raw interrupt status
#define GPA_INTRAW_GPIO30_3527    0x40000000U  // GPIO30 raw interrupt status
#define GPA_INTRAW_GPIO29_3527    0x20000000U  // GPIO29 raw interrupt status
#define GPA_INTRAW_GPIO28_3527    0x10000000U  // GPIO28 raw interrupt status
#define GPA_INTRAW_GPIO27_3527    0x08000000U  // GPIO27 raw interrupt status
#define GPA_INTRAW_GPIO26_3527    0x04000000U  // GPIO26 raw interrupt status
#define GPA_INTRAW_GPIO25_3527    0x02000000U  // GPIO25 raw interrupt status
#define GPA_INTRAW_GPIO24_3527    0x01000000U  // GPIO24 raw interrupt status
#define GPA_INTRAW_GPIO23_3527    0x00800000U  // GPIO23 raw interrupt status
#define GPA_INTRAW_GPIO22_3527    0x00400000U  // GPIO22 raw interrupt status
#define GPA_INTRAW_GPIO21_3527    0x00200000U  // GPIO21 raw interrupt status
#define GPA_INTRAW_GPIO20_3527    0x00100000U  // GPIO20 raw interrupt status
#define GPA_INTRAW_GPIO19_3527    0x00080000U  // GPIO19 raw interrupt status
#define GPA_INTRAW_GPIO18_3527    0x00040000U  // GPIO18 raw interrupt status
#define GPA_INTRAW_GPIO17_3527    0x00020000U  // GPIO17 raw interrupt status
#define GPA_INTRAW_GPIO16_3527    0x00010000U  // GPIO16 raw interrupt status
#define GPA_INTRAW_GPIO15_3527    0x00008000U  // GPIO15 raw interrupt status
#define GPA_INTRAW_GPIO14_3527    0x00004000U  // GPIO14 raw interrupt status
#define GPA_INTRAW_GPIO13_3527    0x00002000U  // GPIO13 raw interrupt status
#define GPA_INTRAW_GPIO12_3527    0x00001000U  // GPIO12 raw interrupt status
#define GPA_INTRAW_GPIO11_3527    0x00000800U  // GPIO11 raw interrupt status
#define GPA_INTRAW_GPIO10_3527    0x00000400U  // GPIO10 raw interrupt status
#define GPA_INTRAW_GPIO9_3527     0x00000200U  // GPIO9 raw interrupt status
#define GPA_INTRAW_GPIO8_3527     0x00000100U  // GPIO8 raw interrupt status
#define GPA_INTRAW_GPIO7_3527     0x00000080U  // GPIO7 raw interrupt status
#define GPA_INTRAW_GPIO6_3527     0x00000040U  // GPIO6 raw interrupt status
#define GPA_INTRAW_GPIO5_3527     0x00000020U  // GPIO5 raw interrupt status
#define GPA_INTRAW_GPIO4_3527     0x00000010U  // GPIO4 raw interrupt status
#define GPA_INTRAW_GPIO3_3527     0x00000008U  // GPIO3 raw interrupt status
#define GPA_INTRAW_GPIO2_3527     0x00000004U  // GPIO2 raw interrupt status
#define GPA_INTRAW_GPIO1_3527     0x00000002U  // GPIO1 raw interrupt status
#define GPA_INTRAW_GPIO0_3527     0x00000001U  // GPIO0 raw interrupt status

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPA_INTSTATUS_3527 register
//
//*************************************************************************************************
// GPIO masked interrupt status bits (RO)
#define GPA_INTSTATUS_GPIO31_3527    0x80000000U  // GPIO31 masked interrupt status
#define GPA_INTSTATUS_GPIO30_3527    0x40000000U  // GPIO30 masked interrupt status
#define GPA_INTSTATUS_GPIO29_3527    0x20000000U  // GPIO29 masked interrupt status
#define GPA_INTSTATUS_GPIO28_3527    0x10000000U  // GPIO28 masked interrupt status
#define GPA_INTSTATUS_GPIO27_3527    0x08000000U  // GPIO27 masked interrupt status
#define GPA_INTSTATUS_GPIO26_3527    0x04000000U  // GPIO26 masked interrupt status
#define GPA_INTSTATUS_GPIO25_3527    0x02000000U  // GPIO25 masked interrupt status
#define GPA_INTSTATUS_GPIO24_3527    0x01000000U  // GPIO24 masked interrupt status
#define GPA_INTSTATUS_GPIO23_3527    0x00800000U  // GPIO23 masked interrupt status
#define GPA_INTSTATUS_GPIO22_3527    0x00400000U  // GPIO22 masked interrupt status
#define GPA_INTSTATUS_GPIO21_3527    0x00200000U  // GPIO21 masked interrupt status
#define GPA_INTSTATUS_GPIO20_3527    0x00100000U  // GPIO20 masked interrupt status
#define GPA_INTSTATUS_GPIO19_3527    0x00080000U  // GPIO19 masked interrupt status
#define GPA_INTSTATUS_GPIO18_3527    0x00040000U  // GPIO18 masked interrupt status
#define GPA_INTSTATUS_GPIO17_3527    0x00020000U  // GPIO17 masked interrupt status
#define GPA_INTSTATUS_GPIO16_3527    0x00010000U  // GPIO16 masked interrupt status
#define GPA_INTSTATUS_GPIO15_3527    0x00008000U  // GPIO15 masked interrupt status
#define GPA_INTSTATUS_GPIO14_3527    0x00004000U  // GPIO14 masked interrupt status
#define GPA_INTSTATUS_GPIO13_3527    0x00002000U  // GPIO13 masked interrupt status
#define GPA_INTSTATUS_GPIO12_3527    0x00001000U  // GPIO12 masked interrupt status
#define GPA_INTSTATUS_GPIO11_3527    0x00000800U  // GPIO11 masked interrupt status
#define GPA_INTSTATUS_GPIO10_3527    0x00000400U  // GPIO10 masked interrupt status
#define GPA_INTSTATUS_GPIO9_3527     0x00000200U  // GPIO9 masked interrupt status
#define GPA_INTSTATUS_GPIO8_3527     0x00000100U  // GPIO8 masked interrupt status
#define GPA_INTSTATUS_GPIO7_3527     0x00000080U  // GPIO7 masked interrupt status
#define GPA_INTSTATUS_GPIO6_3527     0x00000040U  // GPIO6 masked interrupt status
#define GPA_INTSTATUS_GPIO5_3527     0x00000020U  // GPIO5 masked interrupt status
#define GPA_INTSTATUS_GPIO4_3527     0x00000010U  // GPIO4 masked interrupt status
#define GPA_INTSTATUS_GPIO3_3527     0x00000008U  // GPIO3 masked interrupt status
#define GPA_INTSTATUS_GPIO2_3527     0x00000004U  // GPIO2 masked interrupt status
#define GPA_INTSTATUS_GPIO1_3527     0x00000002U  // GPIO1 masked interrupt status
#define GPA_INTSTATUS_GPIO0_3527     0x00000001U  // GPIO0 masked interrupt status


//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTTYPE_3527 register
//
//*************************************************************************************************
// GPIO interrupt type bits
#define GPB_INTTYPE_GPIO45_3527    0x00002000U  // GPIO45 interrupt type (RW)
#define GPB_INTTYPE_GPIO44_3527    0x00001000U  // GPIO44 interrupt type (RW)
#define GPB_INTTYPE_GPIO43_3527    0x00000800U  // GPIO43 interrupt type (RW)
#define GPB_INTTYPE_GPIO42_3527    0x00000400U  // GPIO42 interrupt type (RW)
#define GPB_INTTYPE_GPIO41_3527    0x00000200U  // GPIO41 interrupt type (RW)
#define GPB_INTTYPE_GPIO40_3527    0x00000100U  // GPIO40 interrupt type (RW)
#define GPB_INTTYPE_GPIO39_3527    0x00000080U  // GPIO39 interrupt type (RW)
#define GPB_INTTYPE_GPIO38_3527    0x00000040U  // GPIO38 interrupt type (RW)
#define GPB_INTTYPE_GPIO37_3527    0x00000020U  // GPIO37 interrupt type (RW)
#define GPB_INTTYPE_GPIO36_3527    0x00000010U  // GPIO36 interrupt type (RW)
#define GPB_INTTYPE_GPIO35_3527    0x00000008U  // GPIO35 interrupt type (RW)
#define GPB_INTTYPE_GPIO34_3527    0x00000004U  // GPIO34 interrupt type (RW)
#define GPB_INTTYPE_GPIO33_3527    0x00000002U  // GPIO33 interrupt type (RW)
#define GPB_INTTYPE_GPIO32_3527    0x00000001U  // GPIO32 interrupt type (RW)

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTPOL_3527 register
//
//*************************************************************************************************
// GPIO interrupt polarity bits (RW)
#define GPB_INTPOL_GPIO45_3527    0x00002000U  // GPIO45 interrupt polarity
#define GPB_INTPOL_GPIO44_3527    0x00001000U  // GPIO44 interrupt polarity
#define GPB_INTPOL_GPIO43_3527    0x00000800U  // GPIO43 interrupt polarity
#define GPB_INTPOL_GPIO42_3527    0x00000400U  // GPIO42 interrupt polarity
#define GPB_INTPOL_GPIO41_3527    0x00000200U  // GPIO41 interrupt polarity
#define GPB_INTPOL_GPIO40_3527    0x00000100U  // GPIO40 interrupt polarity
#define GPB_INTPOL_GPIO39_3527    0x00000080U  // GPIO39 interrupt polarity
#define GPB_INTPOL_GPIO38_3527    0x00000040U  // GPIO38 interrupt polarity
#define GPB_INTPOL_GPIO37_3527    0x00000020U  // GPIO37 interrupt polarity
#define GPB_INTPOL_GPIO36_3527    0x00000010U  // GPIO36 interrupt polarity
#define GPB_INTPOL_GPIO35_3527    0x00000008U  // GPIO35 interrupt polarity
#define GPB_INTPOL_GPIO34_3527    0x00000004U  // GPIO34 interrupt polarity
#define GPB_INTPOL_GPIO33_3527    0x00000002U  // GPIO33 interrupt polarity
#define GPB_INTPOL_GPIO32_3527    0x00000001U  // GPIO32 interrupt polarity

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTMASK_3527 register
//
//*************************************************************************************************
// GPIO interrupt mask bits (RW)
#define GPB_INTMASK_GPIO45_3527    0x00002000U  // GPIO45 interrupt mask
#define GPB_INTMASK_GPIO44_3527    0x00001000U  // GPIO44 interrupt mask
#define GPB_INTMASK_GPIO43_3527    0x00000800U  // GPIO43 interrupt mask
#define GPB_INTMASK_GPIO42_3527    0x00000400U  // GPIO42 interrupt mask
#define GPB_INTMASK_GPIO41_3527    0x00000200U  // GPIO41 interrupt mask
#define GPB_INTMASK_GPIO40_3527    0x00000100U  // GPIO40 interrupt mask
#define GPB_INTMASK_GPIO39_3527    0x00000080U  // GPIO39 interrupt mask
#define GPB_INTMASK_GPIO38_3527    0x00000040U  // GPIO38 interrupt mask
#define GPB_INTMASK_GPIO37_3527    0x00000020U  // GPIO37 interrupt mask
#define GPB_INTMASK_GPIO36_3527    0x00000010U  // GPIO36 interrupt mask
#define GPB_INTMASK_GPIO35_3527    0x00000008U  // GPIO35 interrupt mask
#define GPB_INTMASK_GPIO34_3527    0x00000004U  // GPIO34 interrupt mask
#define GPB_INTMASK_GPIO33_3527    0x00000002U  // GPIO33 interrupt mask
#define GPB_INTMASK_GPIO32_3527    0x00000001U  // GPIO32 interrupt mask

#define GPB_INTMASK_ALL_3527       0x00003FFFU  // Mask all GPIO interrupts

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTCLR_3527 register
//
//*************************************************************************************************
// GPIO interrupt clear bits (W1SR0)
#define GPB_INTCLR_GPIO45_3527    0x00002000U  // GPIO45 interrupt clear
#define GPB_INTCLR_GPIO44_3527    0x00001000U  // GPIO44 interrupt clear
#define GPB_INTCLR_GPIO43_3527    0x00000800U  // GPIO43 interrupt clear
#define GPB_INTCLR_GPIO42_3527    0x00000400U  // GPIO42 interrupt clear
#define GPB_INTCLR_GPIO41_3527    0x00000200U  // GPIO41 interrupt clear
#define GPB_INTCLR_GPIO40_3527    0x00000100U  // GPIO40 interrupt clear
#define GPB_INTCLR_GPIO39_3527    0x00000080U  // GPIO39 interrupt clear
#define GPB_INTCLR_GPIO38_3527    0x00000040U  // GPIO38 interrupt clear
#define GPB_INTCLR_GPIO37_3527    0x00000020U  // GPIO37 interrupt clear
#define GPB_INTCLR_GPIO36_3527    0x00000010U  // GPIO36 interrupt clear
#define GPB_INTCLR_GPIO35_3527    0x00000008U  // GPIO35 interrupt clear
#define GPB_INTCLR_GPIO34_3527    0x00000004U  // GPIO34 interrupt clear
#define GPB_INTCLR_GPIO33_3527    0x00000002U  // GPIO33 interrupt clear
#define GPB_INTCLR_GPIO32_3527    0x00000001U  // GPIO32 interrupt clear

// All GPIO interrupts clear mask
#define GPB_INTCLR_ALL_3527       0x00003FFFU  // Clear all GPIO32-45 interrupts

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTRAW_3527 register
//
//*************************************************************************************************
// GPIO raw interrupt status bits (RO)
#define GPB_INTRAW_GPIO45_3527    0x00002000U  // GPIO45 raw interrupt status
#define GPB_INTRAW_GPIO44_3527    0x00001000U  // GPIO44 raw interrupt status
#define GPB_INTRAW_GPIO43_3527    0x00000800U  // GPIO43 raw interrupt status
#define GPB_INTRAW_GPIO42_3527    0x00000400U  // GPIO42 raw interrupt status
#define GPB_INTRAW_GPIO41_3527    0x00000200U  // GPIO41 raw interrupt status
#define GPB_INTRAW_GPIO40_3527    0x00000100U  // GPIO40 raw interrupt status
#define GPB_INTRAW_GPIO39_3527    0x00000080U  // GPIO39 raw interrupt status
#define GPB_INTRAW_GPIO38_3527    0x00000040U  // GPIO38 raw interrupt status
#define GPB_INTRAW_GPIO37_3527    0x00000020U  // GPIO37 raw interrupt status
#define GPB_INTRAW_GPIO36_3527    0x00000010U  // GPIO36 raw interrupt status
#define GPB_INTRAW_GPIO35_3527    0x00000008U  // GPIO35 raw interrupt status
#define GPB_INTRAW_GPIO34_3527    0x00000004U  // GPIO34 raw interrupt status
#define GPB_INTRAW_GPIO33_3527    0x00000002U  // GPIO33 raw interrupt status
#define GPB_INTRAW_GPIO32_3527    0x00000001U  // GPIO32 raw interrupt status

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPB_INTSTATUS_3527 register
//
//*************************************************************************************************
// GPIO masked interrupt status bits (RO)
#define GPB_INTSTATUS_GPIO45_3527    0x00002000U  // GPIO45 masked interrupt status
#define GPB_INTSTATUS_GPIO44_3527    0x00001000U  // GPIO44 masked interrupt status
#define GPB_INTSTATUS_GPIO43_3527    0x00000800U  // GPIO43 masked interrupt status
#define GPB_INTSTATUS_GPIO42_3527    0x00000400U  // GPIO42 masked interrupt status
#define GPB_INTSTATUS_GPIO41_3527    0x00000200U  // GPIO41 masked interrupt status
#define GPB_INTSTATUS_GPIO40_3527    0x00000100U  // GPIO40 masked interrupt status
#define GPB_INTSTATUS_GPIO39_3527    0x00000080U  // GPIO39 masked interrupt status
#define GPB_INTSTATUS_GPIO38_3527    0x00000040U  // GPIO38 masked interrupt status
#define GPB_INTSTATUS_GPIO37_3527    0x00000020U  // GPIO37 masked interrupt status
#define GPB_INTSTATUS_GPIO36_3527    0x00000010U  // GPIO36 masked interrupt status
#define GPB_INTSTATUS_GPIO35_3527    0x00000008U  // GPIO35 masked interrupt status
#define GPB_INTSTATUS_GPIO34_3527    0x00000004U  // GPIO34 masked interrupt status
#define GPB_INTSTATUS_GPIO33_3527    0x00000002U  // GPIO33 masked interrupt status
#define GPB_INTSTATUS_GPIO32_3527    0x00000001U  // GPIO32 masked interrupt status


//*************************************************************************************************
//
// The following are defines for the bit fields in the AIO_INTTYPE_3527 register
//
//*************************************************************************************************
// AIO interrupt type bits (RW)
#define AIO_INTTYPE_AIO14          0x00004000U  // AIO14 interrupt type
#define AIO_INTTYPE_AIO12          0x00001000U  // AIO12 interrupt type
#define AIO_INTTYPE_AIO10          0x00000400U  // AIO10 interrupt type
#define AIO_INTTYPE_AIO6           0x00000040U  // AIO6 interrupt type
#define AIO_INTTYPE_AIO4           0x00000010U  // AIO4 interrupt type
#define AIO_INTTYPE_AIO2           0x00000004U  // AIO2 interrupt type

//*************************************************************************************************
//
// The following are defines for the bit fields in the AIO_INTPOL_3527 register
//
//*************************************************************************************************
// AIO interrupt polarity bits (RW)
#define AIO_INTPOL_AIO14          0x00004000U  // AIO14 interrupt polarity
#define AIO_INTPOL_AIO12          0x00001000U  // AIO12 interrupt polarity
#define AIO_INTPOL_AIO10          0x00000400U  // AIO10 interrupt polarity
#define AIO_INTPOL_AIO6           0x00000040U  // AIO6 interrupt polarity
#define AIO_INTPOL_AIO4           0x00000010U  // AIO4 interrupt polarity
#define AIO_INTPOL_AIO2           0x00000004U  // AIO2 interrupt polarity


//*************************************************************************************************
//
// The following are defines for the bit fields in the AIO_INTMASK_3527 register
//
//*************************************************************************************************
// AIO interrupt mask bits (RW)
#define AIO_INTMASK_AIO14          0x00004000U  // AIO14 interrupt mask
#define AIO_INTMASK_AIO12          0x00001000U  // AIO12 interrupt mask
#define AIO_INTMASK_AIO10          0x00000400U  // AIO10 interrupt mask
#define AIO_INTMASK_AIO6           0x00000040U  // AIO6 interrupt mask
#define AIO_INTMASK_AIO4           0x00000010U  // AIO4 interrupt mask
#define AIO_INTMASK_AIO2           0x00000004U  // AIO2 interrupt mask

#define AIO_INTMASK_ALL            0x00005454U  // Mask all AIO interrupts

//*************************************************************************************************
//
// The following are defines for the bit fields in the AIO_INTCLR_3527 register
//
//*************************************************************************************************
// AIO interrupt clear bits (RW)
#define AIO_INTCLR_AIO14           0x00004000U  // AIO14 interrupt clear
#define AIO_INTCLR_AIO12           0x00001000U  // AIO12 interrupt clear
#define AIO_INTCLR_AIO10           0x00000400U  // AIO10 interrupt clear
#define AIO_INTCLR_AIO6            0x00000040U  // AIO6 interrupt clear
#define AIO_INTCLR_AIO4            0x00000010U  // AIO4 interrupt clear
#define AIO_INTCLR_AIO2            0x00000004U  // AIO2 interrupt clear

#define AIO_INTCLR_ALL             0x00005454U  // Clear all AIO interrupts

//*************************************************************************************************
//
// The following are defines for the bit fields in the AIO_INTRAW_3527 register
//
//*************************************************************************************************
// AIO raw interrupt status bits (RO)
#define AIO_INTRAW_AIO14          0x00004000U  // AIO14 raw interrupt status
#define AIO_INTRAW_AIO12          0x00001000U  // AIO12 raw interrupt status
#define AIO_INTRAW_AIO10          0x00000400U  // AIO10 raw interrupt status
#define AIO_INTRAW_AIO6           0x00000040U  // AIO6 raw interrupt status
#define AIO_INTRAW_AIO4           0x00000010U  // AIO4 raw interrupt status
#define AIO_INTRAW_AIO2           0x00000004U  // AIO2 raw interrupt status


//*************************************************************************************************
//
// The following are defines for the bit fields in the AIO_INTSTATUS_3527 register
//
//*************************************************************************************************
// AIO interrupt status bits (RO)
#define AIO_INTSTATUS_AIO14          0x00004000U  // AIO14 interrupt status
#define AIO_INTSTATUS_AIO12          0x00001000U  // AIO12 interrupt status
#define AIO_INTSTATUS_AIO10          0x00000400U  // AIO10 interrupt status
#define AIO_INTSTATUS_AIO6           0x00000040U  // AIO6 interrupt status
#define AIO_INTSTATUS_AIO4           0x00000010U  // AIO4 interrupt status
#define AIO_INTSTATUS_AIO2           0x00000004U  // AIO2 interrupt status


//*************************************************************************************************
//
// The following are defines for the bit fields in the CLK_REF_PIN_CTRL register
//
//*************************************************************************************************
// Clock reference pin control bits (RW)
#define GPIO_CLK_REF_PIN_R_SEL          0x00000010U  // Oscillator resistance selection
                                                // 0: 500k oscillation resistance
                                                // 1: 100k oscillation resistance
#define GPIO_CLK_REF_PIN_SF1            0x00000008U  // Select frequency pin 1
#define GPIO_CLK_REF_PIN_SF0            0x00000004U  // Select frequency pin 0
#define GPIO_CLK_REF_PIN_TE             0x00000002U  // Test enable pin (enables buffer for testing)
#define GPIO_CLK_REF_PIN_E0             0x00000001U  // Crystal enable pin (enables feedback amplifier)

//*************************************************************************************************
//
// The following are defines for the bit fields in the AUXCLKIN_SEL register
// 
// (meaningful when the model is 28035/28027; otherwise, the signal source is gpio29)
// 0: The signal source is gpio38 (35/27)
// 1: The signal source is gpio19 (35/27)
//
//*************************************************************************************************
// AUXCLKIN source selection bit (RW)
#define GPIO_AUXCLKIN_SEL        0x00000001U  // Auxclkin signal source selection

//*************************************************************************************************
//
// The following are defines for the bit fields in the AUXCLKIN_EN register
//
// (meaningful when model 28035/28027; otherwise signal source is gpio29)
// 0 auxclkin disable
// 1 auxclkin enable
//*************************************************************************************************
// AUXCLKIN enable control bit (RW)
#define GPIO_AUXCLKIN_EN            0x00000001U  // Enable AUXCLKIN


//*************************************************************************************************
//
// The following are defines for the bit fields in the LPMCR_QUALSTDBY register
//
//*************************************************************************************************
// Qualification cycles mask and shift
#define GPIO_LPMCR_QUALSTDBY_CYCLES_M         0x000000FCU  // Qualification cycles mask [7:2]
#define GPIO_LPMCR_QUALSTDBY_CYCLES_S         2U           // Qualification cycles shift

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPIOLPMSEL0 register
//
//*************************************************************************************************
// Individual GPIO LPM selection bits
#define GPIOLPMSEL0_GPIO31         0x80000000U  // GPIO31 LPM selection
#define GPIOLPMSEL0_GPIO30         0x40000000U  // GPIO30 LPM selection
#define GPIOLPMSEL0_GPIO29         0x20000000U  // GPIO29 LPM selection
#define GPIOLPMSEL0_GPIO28         0x10000000U  // GPIO28 LPM selection
#define GPIOLPMSEL0_GPIO27         0x08000000U  // GPIO27 LPM selection
#define GPIOLPMSEL0_GPIO26         0x04000000U  // GPIO26 LPM selection
#define GPIOLPMSEL0_GPIO25         0x02000000U  // GPIO25 LPM selection
#define GPIOLPMSEL0_GPIO24         0x01000000U  // GPIO24 LPM selection
#define GPIOLPMSEL0_GPIO23         0x00800000U  // GPIO23 LPM selection
#define GPIOLPMSEL0_GPIO22         0x00400000U  // GPIO22 LPM selection
#define GPIOLPMSEL0_GPIO21         0x00200000U  // GPIO21 LPM selection
#define GPIOLPMSEL0_GPIO20         0x00100000U  // GPIO20 LPM selection
#define GPIOLPMSEL0_GPIO19         0x00080000U  // GPIO19 LPM selection
#define GPIOLPMSEL0_GPIO18         0x00040000U  // GPIO18 LPM selection
#define GPIOLPMSEL0_GPIO17         0x00020000U  // GPIO17 LPM selection
#define GPIOLPMSEL0_GPIO16         0x00010000U  // GPIO16 LPM selection
#define GPIOLPMSEL0_GPIO15         0x00008000U  // GPIO15 LPM selection
#define GPIOLPMSEL0_GPIO14         0x00004000U  // GPIO14 LPM selection
#define GPIOLPMSEL0_GPIO13         0x00002000U  // GPIO13 LPM selection
#define GPIOLPMSEL0_GPIO12         0x00001000U  // GPIO12 LPM selection
#define GPIOLPMSEL0_GPIO11         0x00000800U  // GPIO11 LPM selection
#define GPIOLPMSEL0_GPIO10         0x00000400U  // GPIO10 LPM selection
#define GPIOLPMSEL0_GPIO9          0x00000200U  // GPIO9 LPM selection
#define GPIOLPMSEL0_GPIO8          0x00000100U  // GPIO8 LPM selection
#define GPIOLPMSEL0_GPIO7          0x00000080U  // GPIO7 LPM selection
#define GPIOLPMSEL0_GPIO6          0x00000040U  // GPIO6 LPM selection
#define GPIOLPMSEL0_GPIO5          0x00000020U  // GPIO5 LPM selection
#define GPIOLPMSEL0_GPIO4          0x00000010U  // GPIO4 LPM selection
#define GPIOLPMSEL0_GPIO3          0x00000008U  // GPIO3 LPM selection
#define GPIOLPMSEL0_GPIO2          0x00000004U  // GPIO2 LPM selection
#define GPIOLPMSEL0_GPIO1          0x00000002U  // GPIO1 LPM selection
#define GPIOLPMSEL0_GPIO0          0x00000001U  // GPIO0 LPM selection

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPIOLPMSEL1 register
//
//*************************************************************************************************
// Individual GPIO LPM selection bits
#define GPIOLPMSEL1_GPIO63         0x80000000U  // GPIO63 LPM selection
#define GPIOLPMSEL1_GPIO62         0x40000000U  // GPIO62 LPM selection
#define GPIOLPMSEL1_GPIO61         0x20000000U  // GPIO61 LPM selection
#define GPIOLPMSEL1_GPIO60         0x10000000U  // GPIO60 LPM selection
#define GPIOLPMSEL1_GPIO59         0x08000000U  // GPIO59 LPM selection
#define GPIOLPMSEL1_GPIO58         0x04000000U  // GPIO58 LPM selection
#define GPIOLPMSEL1_GPIO57         0x02000000U  // GPIO57 LPM selection
#define GPIOLPMSEL1_GPIO56         0x01000000U  // GPIO56 LPM selection
#define GPIOLPMSEL1_GPIO55         0x00800000U  // GPIO55 LPM selection
#define GPIOLPMSEL1_GPIO54         0x00400000U  // GPIO54 LPM selection
#define GPIOLPMSEL1_GPIO53         0x00200000U  // GPIO53 LPM selection
#define GPIOLPMSEL1_GPIO52         0x00100000U  // GPIO52 LPM selection
#define GPIOLPMSEL1_GPIO51         0x00080000U  // GPIO51 LPM selection
#define GPIOLPMSEL1_GPIO50         0x00040000U  // GPIO50 LPM selection
#define GPIOLPMSEL1_GPIO49         0x00020000U  // GPIO49 LPM selection
#define GPIOLPMSEL1_GPIO48         0x00010000U  // GPIO48 LPM selection
#define GPIOLPMSEL1_GPIO47         0x00008000U  // GPIO47 LPM selection
#define GPIOLPMSEL1_GPIO46         0x00004000U  // GPIO46 LPM selection
#define GPIOLPMSEL1_GPIO45         0x00002000U  // GPIO45 LPM selection
#define GPIOLPMSEL1_GPIO44         0x00001000U  // GPIO44 LPM selection
#define GPIOLPMSEL1_GPIO43         0x00000800U  // GPIO43 LPM selection
#define GPIOLPMSEL1_GPIO42         0x00000400U  // GPIO42 LPM selection
#define GPIOLPMSEL1_GPIO41         0x00000200U  // GPIO41 LPM selection
#define GPIOLPMSEL1_GPIO40         0x00000100U  // GPIO40 LPM selection
#define GPIOLPMSEL1_GPIO39         0x00000080U  // GPIO39 LPM selection
#define GPIOLPMSEL1_GPIO38         0x00000040U  // GPIO38 LPM selection
#define GPIOLPMSEL1_GPIO37         0x00000020U  // GPIO37 LPM selection
#define GPIOLPMSEL1_GPIO36         0x00000010U  // GPIO36 LPM selection
#define GPIOLPMSEL1_GPIO35         0x00000008U  // GPIO35 LPM selection
#define GPIOLPMSEL1_GPIO34         0x00000004U  // GPIO34 LPM selection
#define GPIOLPMSEL1_GPIO33         0x00000002U  // GPIO33 LPM selection
#define GPIOLPMSEL1_GPIO32         0x00000001U  // GPIO32 LPM selection


/*************************************************************************************************
*
* The following are defines for the bit fields in the CLB_HRPWM_EX_EN register
* 
*************************************************************************************************/
#define GPIO_CLB_HRPWM_EX_EN_EPWM4_B           0x00000080U
#define GPIO_CLB_HRPWM_EX_EN_EPWM4_A           0x00000040U
#define GPIO_CLB_HRPWM_EX_EN_EPWM3_B           0x00000020U
#define GPIO_CLB_HRPWM_EX_EN_EPWM3_A           0x00000010U
#define GPIO_CLB_HRPWM_EX_EN_EPWM2_B           0x00000008U
#define GPIO_CLB_HRPWM_EX_EN_EPWM2_A           0x00000004U
#define GPIO_CLB_HRPWM_EX_EN_EPWM1_B           0x00000002U
#define GPIO_CLB_HRPWM_EX_EN_EPWM1_A           0x00000001U

// All channels mask
#define CLB_HRPWM_EX_EN_ALL_CHANNELS      0x000000FFU

    /* ========================================================================== */
    /*                         Structures and Enums                               */
    /* ========================================================================== */

    /* None */

    /* ========================================================================== */
    /*                            Global Constants                                */
    /* ========================================================================== */

    /* None */

    /* ========================================================================== */
    /*                            Global Variables                                */
    /* ========================================================================== */

    /* None */

    /* ========================================================================== */
    /*                         Global Functions Declarations                      */
    /* ========================================================================== */

    /* None */

#ifdef __cplusplus
}
#endif

#endif  /*IS_GS32F00xx(0x30)*/

#endif /* DEVICE_DRIVERLIB_HW_SYSCTL_IO_V30_H_ */
