/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_SCI.h
*   @brief   
*
*/

#ifndef DEVICE_DRIVERLIB_HW_UART_H_
#define DEVICE_DRIVERLIB_HW_UART_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "gs32_version.h"

#include "inc/hw_types.h"

#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//#define SCIA_BASE              (0x4030A000)
#define FIFO_DEPTH              (16)  
//*************************************************************************************************
//
// The following are defines for the SCI register offsets
//
//*************************************************************************************************
#define SCI_O_RBR_THR_DLL   0x00   // SCI_O_LCR[7]==0?Receive Buffer Register+Transmit Holding Register:Divisor Latch low
#define SCI_O_IER_DLH       0x04   // SCI_O_LCR[7]==0?Interrupt Enable Register:Divisor Latch High
#define SCI_O_IIR_FCR       0x08   /* FIFO Control Register */
#define SCI_O_LCR           0x0C   // Line Control Register
#define SCI_O_MCR           0x10   // Modem Control Register
#define SCI_O_LSR           0x14   // Line Status Register
#define SCI_O_MSR           0x18
#define SCI_O_SCR           0x1C   //Scratchpad Register

#define SCI_O_USR           0x7C   // SCI status register
#define SCI_O_TFL           0x80   // Transmit FIFO Level
#define SCI_O_RFL           0x84   // Receive FIFO Level
#define SCI_O_TCR           0xAC   // Transceiver Control Register
#define SCI_O_DE_EN         0xB0   // Transceiver Control Register
#define SCI_O_RE_EN         0xB4   // Transceiver Control Register
#define SCI_O_DET           0xB8   // Driver Output Enable Timing Register
#define SCI_O_TAT           0xB4   // TurnAround Timing Register
#define SCI_O_DLF           0xC0   // Divisor Latch Fraction Register
#define SCI_O_RAR           0xC4   // Receive  Address Register
#define SCI_O_TAR           0xC8   // Transmit Address Register
#define SCI_O_LCR_EXT       0xCC   // Line Control Register

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCI_O_RBR_THR_DLL register
//
//*************************************************************************************************
#define SCI_LSR_ADDR_RCVD    BIT(8)
#define SCI_LSR_RFE          BIT(7)
#define SCI_LSR_TEMT         BIT(6)
#define SCI_LSR_THRE         BIT(5)
#define SCI_LSR_BI           BIT(4)
#define SCI_LSR_FE           BIT(3)
#define SCI_LSR_PE           BIT(2)
#define SCI_LSR_OE           BIT(1)
#define SCI_LSR_DR           BIT(0)

#define SCI_RBR_SAR_M     0xFFU     // Receive Character bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCI_O_IER_DLH register
//
//*************************************************************************************************
#define SCI_IER_ERBFI        BIT(0)
#define SCI_IER_ETBEI        BIT(1)
#define SCI_IER_ELSI         BIT(2)
#define SCI_IER_PTIME        BIT(7)

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCI_O_LCR register
//
//*************************************************************************************************
#define SCI_LCR_DLAB         BIT(7)
#define SCI_LCR_DLS_M        (0x03U)

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCI_O_MCR register
//
//*************************************************************************************************
#define SCI_MCR_LOOPBACK         BIT(4)
#define SCI_MCR_AFCE             BIT(5)
#define SCI_MCR_SIR              BIT(6)


//*************************************************************************************************
//
// The following are defines for the bit fields in the SCI_LSR register
//
//*************************************************************************************************

#define SCI_LSR_TEMT        BIT(6)
#define SCI_LSR_THRE        BIT(5)
#define SCI_LSR_BI          BIT(4)
#define SCI_LSR_FE          BIT(3)
#define SCI_LSR_PE          BIT(2)
#define SCI_LSR_OE          BIT(1)
#define SCI_LSR_DR          BIT(0)


//*************************************************************************************************
//
// The following are defines for the bit fields in the SCI_USR register
//
//*************************************************************************************************

#define SCI_USR_RFF        BIT(4)
#define SCI_USR_RFNE       BIT(3)
#define SCI_USR_TFE        BIT(2)
#define SCI_USR_TFNF       BIT(1)
#define SCI_USR_BUSY       BIT(0)

//*************************************************************************************************
//
// The following are defines for the bit fields in the USR register
//
//*************************************************************************************************

#define SCI_USR_RSVD_RFF     BIT(4)
#define SCI_USR_RSVD_RFNE    BIT(3)
#define SCI_USR_RSVD_TFE     BIT(2)
#define SCI_USR_RSVD_TFNF    BIT(1)
#define SCI_USR_BUSY         BIT(0)
#define SCI_USR_TXFF_ST_M    0x06U
#define SCI_USR_RXFF_ST_M    0x18U

//*************************************************************************************************
//*************************************************************************************************
//
// The following are defines for the bit fields in the SCI_O_IIR_FCR register
//
//*************************************************************************************************
#define SCI_IIR_RO_FIFOSE_M    0x00C0
#define SCI_IIR_RO_IID_M       0x000F

#define SCI_FCR_FIFOE          BIT(0)
#define SCI_FCR_RFIFOR         BIT(1)
#define SCI_FCR_XFIFOR         BIT(2)
#define SCI_FCR_DMAM           BIT(3)

#define SCI_IIR_IID_MODEM      0x0
#define SCI_IIR_IID_NO_PD      0x1
#define SCI_IIR_IID_THR_EMPTY  0x2
#define SCI_IIR_IID_RECV       0x4
#define SCI_IIR_IID_STATUS     0x6
#define SCI_IIR_IID_BUSY       0x7
#define SCI_IIR_IID_CH_TIMEOUT 0xc

//*************************************************************************************************
// wfmodify
// The following are defines for the bit fields in the SCI_O_LCR_EXT register 
//
//*************************************************************************************************
#define SCI_LCR_EXT_DLS_E            BIT(0)
#define SCI_LCR_EXT_ADDR_MATCH       BIT(1)
#define SCI_LCR_EXT_SEND_ADDR        BIT(2)
#define SCI_LCR_EXT_TRANSMIT_MODE    BIT(3)

//*************************************************************************************************
// wfmodify
// The following are defines for the bit fields in the SCI_O_TCR register 
//
//*************************************************************************************************
#define SCI_TCR_RS485_E              BIT(0)
#define SCI_TCR_RE_POL               BIT(1)
#define SCI_TCR_DE_POL               BIT(2)
#define SCI_XFER_MODE_M              (BIT(3) | BIT(4))

//*************************************************************************************************
// 
// The following are defines for the bit fields in the SCI_O_TFL register 
//
//*************************************************************************************************
#define SCI_TFL_MSK             0x1F

//*************************************************************************************************
// 
// The following are defines for the bit fields in the SCI_O_RFL register 
//
//*************************************************************************************************
#define SCI_RFL_MSK             0x1F

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

#endif	/* #if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22) */


#if IS_GS32F00xx(0x30) || IS_GS32F3xx(0x23)


//*************************************************************************************************
//
// The following are defines for the SCI register offsets
//
//*************************************************************************************************
#define SCI_O_CCR     0x00U   // Communications control register
#define SCI_O_CTL1    0x02U   // Control register 1
#define SCI_O_HBAUD   0x04U   // Baud rate (high) register
#define SCI_O_LBAUD   0x06U  // Baud rate (low) register
#define SCI_O_CTL2    0x08U   // Control register 2
#define SCI_O_RXST    0x0AU   // Receive status register
#define SCI_O_RXEMU   0x0CU   // Receive emulation buffer register
#define SCI_O_RXBUF   0x0EU   // Receive data buffer
#define SCI_O_TXBUF   0x12U   // Transmit data buffer
#define SCI_O_FFTX    0x14U   // FIFO transmit register
#define SCI_O_FFRX    0x16U   // FIFO receive register
#define SCI_O_FFCT    0x18U   // FIFO control register
#define SCI_O_PRI     0x1EU   // SCI priority control
#define SCI_O_DBG_CFG     0x20U   //Core Halt Signal Mask
#define SCI_O_RXTIMEOUTVAL    0x24U   //RX Timeout Value Configure
#define SCI_O_RXTIMEOUTINT     0x28U   //RX Timeout Interrupt Configure

#define SCI_O_DLF     0x1C0U   // SCI priority control
#define SCI_O_LCR     0x10CU   // SCI priority control


//*************************************************************************************************
//
// The following are defines for the bit fields in the SCICCR register
//
//*************************************************************************************************
#define SCI_CCR_SCICHAR_S       0U
#define SCI_CCR_SCICHAR_M       0x7U    // Character length control
#define SCI_CCR_ADDRIDLE_MODE   0x8U    // ADDR/IDLE Mode control
#define SCI_CCR_LOOPBKENA       0x10U   // Loop Back enable
#define SCI_CCR_PARITYENA       0x20U   // Parity enable
#define SCI_CCR_PARITY          0x40U   // Even or Odd Parity
#define SCI_CCR_STOPBITS        0x80U   // Number of Stop Bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCICTL1 register
//
//*************************************************************************************************
#define SCI_CTL1_RXENA         0x1U    // SCI receiver enable
#define SCI_CTL1_TXENA         0x2U    // SCI transmitter enable
#define SCI_CTL1_SLEEP         0x4U    // SCI sleep
#define SCI_CTL1_TXWAKE        0x8U    // Transmitter wakeup method
#define SCI_CTL1_SWRESET       0x20U   // Software reset
#define SCI_CTL1_RXERRINTENA   0x40U   // Receive error interrupt enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCIHBAUD register
//
//*************************************************************************************************
#define SCI_HBAUD_BAUD_S   0U
#define SCI_HBAUD_BAUD_M   0xFFU   // SCI 16-bit baud selection Registers SCIHBAUD

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCILBAUD register
//
//*************************************************************************************************
#define SCI_LBAUD_BAUD_S   0U
#define SCI_LBAUD_BAUD_M   0xFFU   // SCI 16-bit baud selection Registers SCILBAUD

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCICTL2 register
//
//*************************************************************************************************
#define SCI_CTL2_TXINTENA     0x1U    // Transmit __interrupt enable
#define SCI_CTL2_RXBKINTENA   0x2U    // Receiver-buffer break enable
#define SCI_CTL2_TXEMPTY      0x40U   // Transmitter empty flag
#define SCI_CTL2_TXRDY        0x80U   // Transmitter ready flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCIRXST register
//
//*************************************************************************************************
#define SCI_RXST_RXWAKE    0x2U    // Receiver wakeup detect flag
#define SCI_RXST_PE        0x4U    // Parity error flag
#define SCI_RXST_OE        0x8U    // Overrun error flag
#define SCI_RXST_FE        0x10U   // Framing error flag
#define SCI_RXST_BRKDT     0x20U   // Break-detect flag
#define SCI_RXST_RXRDY     0x40U   // Receiver ready flag
#define SCI_RXST_RXERROR   0x80U   // Receiver error flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCIRXEMU register
//
//*************************************************************************************************
#define SCI_RXEMU_ERXDT_S   0U
#define SCI_RXEMU_ERXDT_M   0xFFU   // Receive emulation buffer data

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCIRXBUF register
//
//*************************************************************************************************
#define SCI_RXBUF_SAR_S     0U
#define SCI_RXBUF_SAR_M     0xFFU     // Receive Character bits
#define SCI_RXBUF_SCIFFPE   0x4000U   // Receiver error flag
#define SCI_RXBUF_SCIFFFE   0x8000U   // Receiver error flag

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCITXBUF register
//
//*************************************************************************************************
#define SCI_TXBUF_TXDT_S   0U
#define SCI_TXBUF_TXDT_M   0xFFU   // Transmit data buffer

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCIFFTX register
//
//*************************************************************************************************
#define SCI_FFTX_TXFFIL_S      0U
#define SCI_FFTX_TXFFIL_M      0x1FU     // Interrupt level
#define SCI_FFTX_TXFFIENA      0x20U     // Interrupt enable
#define SCI_FFTX_TXFFINTCLR    0x40U     // Clear INT flag
#define SCI_FFTX_TXFFINT       0x80U     // INT flag
#define SCI_FFTX_TXFFST_S      8U
#define SCI_FFTX_TXFFST_M      0x1F00U   // FIFO status
#define SCI_FFTX_TXFIFORESET   0x2000U   // FIFO reset
#define SCI_FFTX_SCIFFENA      0x4000U   // Enhancement enable
#define SCI_FFTX_SCIRST        0x8000U   // SCI reset rx/tx channels

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCIFFRX register
//
//*************************************************************************************************
#define SCI_FFRX_RXFFIL_S      0U
#define SCI_FFRX_RXFFIL_M      0x1FU     // Interrupt level
#define SCI_FFRX_RXFFIENA      0x20U     // Interrupt enable
#define SCI_FFRX_RXFFINTCLR    0x40U     // Clear INT flag
#define SCI_FFRX_RXFFINT       0x80U     // INT flag
#define SCI_FFRX_RXFFST_S      8U
#define SCI_FFRX_RXFFST_M      0x1F00U   // FIFO status
#define SCI_FFRX_RXFIFORESET   0x2000U   // FIFO reset
#define SCI_FFRX_RXFFOVRCLR    0x4000U   // Clear overflow
#define SCI_FFRX_RXFFOVF       0x8000U   // FIFO overflow

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCIFFCT register
//
//*************************************************************************************************
#define SCI_FFCT_FFTXDLY_S   0U
#define SCI_FFCT_FFTXDLY_M   0xFFU     // FIFO transmit delay
#define SCI_FFCT_CDC         0x2000U   // Auto baud mode enable
#define SCI_FFCT_ABDCLR      0x4000U   // Auto baud clear
#define SCI_FFCT_ABD         0x8000U   // Auto baud detect

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCIPRI register
//
//*************************************************************************************************
#define SCI_PRI_FREESOFT_S   3U
#define SCI_PRI_FREESOFT_M   0x18U   // Emulation modes

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCI_O_DMA_REQ_TIMEOUT_TH register
//
//*************************************************************************************************
#define SCI_O_RXTIMEOUTVAL_S   0U
#define SCI_O_RXTIMEOUTVAL_M   0xFFFFFFFFU   // DMA_REQ_timeout

//*************************************************************************************************
//
// The following are defines for the bit fields in the SCI_O_DMA_REQ_TIMEOUT register
//
//*************************************************************************************************
#define SCI_RXTIMEOUTINT_FLG   0x1U
#define SCI_RXTIMEOUTINT_ENA   0x2U
#define SCI_RXTIMEOUTINT_CLR   0x4U
#define SCI_RXTIMEOUTINT_FRC   0x8U   // Forcefully generate receive timeout interrupt



#endif /* #if IS_GS32F00xx(0x30) || IS_GS32F3xx(0x23) */

#ifdef __cplusplus
}
#endif

#endif /* DEVICE_DRIVERLIB_UART_H_ */



