/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_wd.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_WD_H_
#define DEVICE_DRIVERLIB_HW_WD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
//*************************************************************************************************
//
// The following are defines for the WD register offsets
//
//*************************************************************************************************
#define WD_O_LOAD		0X0U    //WD Counter loading register
#define WD_O_VALUE		0X4U    //WD Count value register
#define WD_O_CONTROL	0X8U    //WD Control register
#define WD_O_INTCLR	    0XCU    //WD Interrupt clearing register
#define WD_O_RIS		0X10U   //WD Original interrupt flag register
#define WD_O_MIS		0X14U   //WD Masked interrupt flag register
#define WD_O_LOCK		0XC00U  //WD LOCK register
#define WD_O_ITCR		0XF00U
#define WD_O_ITOP		0XF04U

#define WWD_O_LOAD		0X00U   //WWD Counter loading register
#define WWD_O_VALUE	    0X04U   //WWD Count value register
#define WWD_O_CONTROL	0X08U   //WWD Control register
#define WWD_O_INTCLR	0X0CU   //WWD Interrupt clearing register
#define WWD_O_RIS		0X10U   //WWD Original interrupt flag register
#define WWD_O_MIS		0X14U   //WWD Masked interrupt flag register
#define WWD_O_WINVALUE	0X18U   //WWD Window value
#define WWD_O_LOCK		0XBE0U  //WWD LOCK register




//*************************************************************************************************
//
// The following are defines for the bit fields in the WD_LOAD register
//
//*************************************************************************************************
#define WD_LOAD_LOAD_M		0XFFFFFFFFU		// When this register is written to, the count is immediately restarted from the new value. The minimum
#define WD_LOAD_LOAD_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the WD_VALUE register
//
//*************************************************************************************************
#define WD_VALUE_VALUE_M		0XFFFFFFFFU		// The WDVALUE Register gives the current value of the decrementing counter.
#define WD_VALUE_VALUE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the WD_CONTROL register
//
//*************************************************************************************************
#define WD_CONTROL_INTEN		0X1U		// Enable the interrupt event, WDINT. Set HIGH to enable the counter and the interrupt, or LOW to disable
#define WD_CONTROL_RESEN		0X2U		// Reset the output after the second countdown of the enabled monitor ends, generating an interrupt for the first time, WDRES. Acts as a mask for the reset output. Set HIGH to enable the reset,
#define WD_CONTROL_RESEN_FIRST  0X4U        // Reset output after the first countdown of the enabled monitor ends, WDRES. Acts as a mask for the reset output. Set HIGH to enable the reset,

//*************************************************************************************************
//
// The following are defines for the bit fields in the WD_INTCLR register
//
//*************************************************************************************************
#define WD_INTCLR_INTCLR_M		0XFFFFFFFFU		// A write of any value to the WDINTCLR Register clears the watchdog interrupt, and reloads the counter
#define WD_INTCLR_INTCLR_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the RIS0 register
//
//*************************************************************************************************
#define WD_RIS_RINT		0X1U		// Raw interrupt status from the counter

//*************************************************************************************************
//
// The following are defines for the bit fields in the MIS0 register
//
//*************************************************************************************************
#define WD_MIS_MINT		0X1U		// Enabled interrupt status from the counter

//*************************************************************************************************
//
// The following are defines for the bit fields in the LOAD1 register
//
//*************************************************************************************************
#define WWD_LOAD_LOAD_M		0XFFFFFFFFU		// When this register is written to, the count is immediately restarted from the new value. The minimum
#define WWD_LOAD_LOAD_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the VALUE1 register
//
//*************************************************************************************************
#define WWD_VALUE_VALUE_M		0XFFFFFFFEU		// The WDVALUE Register gives the current value of the decrementing counter.
#define WWD_VALUE_VALUE_S		1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CONTROL1 register
//
//*************************************************************************************************
#define WWD_CONTROL_INTEN		0X1U		// Enable the interrupt event, WDINT. Set HIGH to enable the counter and the interrupt, or LOW to disable
#define WWD_CONTROL_RESEN		0X2U		// Reset the output after the second countdown of the enabled monitor ends, generating an interrupt for the first time, WDRES. Acts as a mask for the reset output. Set HIGH to enable the reset,
#define WWD_CONTROL_RESEN_FIRST 0X4U        // Reset output after the first countdown of the enabled monitor ends, WDRES. Acts as a mask for the reset output. Set HIGH to enable the reset,

//*************************************************************************************************
//
// The following are defines for the bit fields in the INTCLR1 register
//
//*************************************************************************************************
#define WWD_INTCLR_INTCLR_M		0XFFFFFFFFU		// A write of any value to the WDINTCLR Register clears the watchdog interrupt, and reloads the counter
#define WWD_INTCLR_INTCLR_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the RIS1 register
//
//*************************************************************************************************
#define WWD_RIS_RINT		0X1U		// Raw interrupt status from the counter

//*************************************************************************************************
//
// The following are defines for the bit fields in the MIS1 register
//
//*************************************************************************************************
#define WWD_MIS_MINT		0X1U		// Enabled interrupt status from the counter

//*************************************************************************************************
//
// The following are defines for the bit fields in the WINVALUE1 register
//
//*************************************************************************************************
#define WWD_WINVALUE_VALUE_M		0XFFFFFFFFU		// The windowed value.
#define WWD_WINVALUE_VALUE_S		0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the LOCK register
//
//*************************************************************************************************
#define WD_LOCK_KEY		    0X1U		// Write access to all other registers, 0 is enabled,1 is disabled.
#define WD_LOCK_STAT_M		0XFFFFFFFEU		// Enable write access to all other registers by writing 0x1ACCE551. Disable write access by writing any
#define WD_LOCK_STAT_S		1U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ITCR register
//
//*************************************************************************************************
#define WD_ITCR_MODE		0X1U		// When set HIGH, places the watchdog into integration test mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the ITOP register
//
//*************************************************************************************************
#define WD_ITOP_RES		0X1U		// Value output on WDRES when in Integration Test Mode
#define WD_ITOP_INT		0X2U		// Value output on WDINT when in Integration Test Mode


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

/**
 * \brief   add brief
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

 #ifdef __cplusplus
}
#endif


#endif /* DEVICE_DRIVERLIB_HW_WD_H_ */