/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    Interrupt.h
*   @brief   
*
*/

#ifndef DEVICE_GEJIAN_HEADER_INTERRUPT_H_
#define DEVICE_GEJIAN_HEADER_INTERRUPT_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <stdint.h>
#include "cpu.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

typedef void (*IrqHandlerType)(void);

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */


/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */
void Interrupt_enable(IRQn_Type IRQn);
void Interrupt_disable(IRQn_Type IRQn);
void Interrupt_SetPriority(IRQn_Type IRQn, uint32_t PreemptPriority, uint32_t SubPriority);
void Interrupt_SetPriorityGrouping(uint32_t PriorityGroup);
void CPU_SystemReset(void);

uint32_t Interrupt_GetPriorityGrouping(void);

void Interrupt_register(IRQn_Type IRQn,IrqHandlerType NewHandler);
void Interrupt_unregister(IRQn_Type IRQn);
void Interrupt_reload_vectable(uint32_t vec_addr);
void Interrupt_SetVTOR(uint32_t vec_addr);

void Interrupt_setMode(IRQn_Type IRQn, uint32_t mode);
void Interrupt_enableDualcoreShare(IRQn_Type IRQn);

void Interrupt_initModule(void);
void Interrupt_initVectorTable(void);

/* ========================================================================== */
/*                         Inline Functions Declarations                      */
/* ========================================================================== */

/*
 * Define this empty function to avoid compiling error
 * */
__STATIC_INLINE void Interrupt_clearACKGroup(uint16_t group)
{
	(void)group;
	return;
}


#ifdef __cplusplus
}
#endif


#endif /* DEVICE_GEJIAN_HEADER_INTERRUPT_H_ */
