/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS"AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file    pinmap_gs32f027.h
 *   @brief
 *
 */

#ifndef PINMAP_GS32F027_H_
#define PINMAP_GS32F027_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif

#if IS_GS32F00xx(0x30)

#if (GS32_PART_NUM == 0x027)

#define GPIO_MUX_MASK       0x3
#define GPIO_MUX_DATA(x)    (x & GPIO_MUX_MASK)   

/*****************************************************************************
 *
 * Note: Refer to the corresponding data manual for detailed information
 * on each pin's reuse functions and configurations.
 *
 *****************************************************************************/
#define GPIO_0_GPIO0      0x080C0000U /* 027 */ 
#define GPIO_0_EPWM1A     0x080C0001U /* 027 */ 

#define GPIO_1_GPIO1      0x080C0200U /* 027 */ 
#define GPIO_1_EPWM1B     0x080C0201U /* 027 */ 
#define GPIO_1_COMP1OUT   0x080C0203U /* 027 */ 

#define GPIO_2_GPIO2      0x080C0400U /* 027 */ 
#define GPIO_2_EPWM2A     0x080C0401U /* 027 */ 

#define GPIO_3_GPIO3      0x080C0600U /* 027 */ 
#define GPIO_3_EPWM2B     0x080C0601U /* 027 */  
#define GPIO_3_COMP2OUT   0x080C0603U /* 027 */ 

#define GPIO_4_GPIO4      0x080C0800U /* 027 */ 
#define GPIO_4_EPWM3A     0x080C0801U /* 027 */ 

#define GPIO_5_GPIO5      0x080C0A00U /* 027 */ 
#define GPIO_5_EPWM3B     0x080C0A01U /* 027 */ 
#define GPIO_5_ECAP1      0x080C0A03U /* 027 */ 

#define GPIO_6_GPIO6      0x080C0C00U /* 027 */ 
#define GPIO_6_EPWM4A     0x080C0C01U /* 027 */ 
#define GPIO_6_EPWMSYNCI  0x080C0C02U /* 027 */ 
#define GPIO_6_EPWMSYNCO  0x080C0C03U /* 027 */ 

#define GPIO_7_GPIO7      0x080C0E00U /* 027 */ 
#define GPIO_7_EPWM4B     0x080C0E01U /* 027 */ 
#define GPIO_7_SCIRXDA    0x080C0E02U /* 027 */ 

#define GPIO_12_GPIO12    0x080C1800U /* 027 */ 
#define GPIO_12_TZ1       0x080C1801U /* 027 */ 
#define GPIO_12_SCITXDA   0x080C1802U /* 027 */ 

#define GPIO_16_GPIO16    0x08100000U /* 027 */ 
#define GPIO_16_SPISIMOA  0x08100001U /* 027 */ 
#define GPIO_16_TZ2       0x08100003U /* 027 */ 

#define GPIO_17_GPIO17    0x08100200U /* 027 */ 
#define GPIO_17_SPISOMIA  0x08100201U /* 027 */ 
#define GPIO_17_TZ3       0x08100203U /* 027 */ 

#define GPIO_18_GPIO18    0x08100400U /* 027 */ 
#define GPIO_18_SPICLKA   0x08100401U /* 027 */ 
#define GPIO_18_LINTXA    0x08100402U /* 027 */ 
#define GPIO_18_XCLKOUT   0x08100403U /* 027 */ 

#define GPIO_19_GPIO19    0x08100600U /* 027 */ 
// #define GPIO_19_XCLKIN             /* 027 */ 
#define GPIO_19_SPISTEA   0x08100601U /* 027 */ 
#define GPIO_19_LINRXA    0x08100602U /* 027 */ 
#define GPIO_19_ECAP1     0x08100603U /* 027 */ 

#define GPIO_28_GPIO28    0x08101800U /* 027 */ 
#define GPIO_28_SCIRXDA   0x08101801U /* 027 */ 
#define GPIO_28_SDAA      0x08101802U /* 027 */ 
#define GPIO_28_TZ2       0x08101803U /* 027 */ 

#define GPIO_29_GPIO29    0x08101A00U /* 027 */ 
#define GPIO_29_SCITXDA   0x08101A01U /* 027 */ 
#define GPIO_29_SCLA      0x08101A02U /* 027 */ 
#define GPIO_29_TZ3       0x08101A03U /* 027 */ 

#define GPIO_32_GPIO32    0x082C0000U /* 027 */ 
#define GPIO_32_SDAA      0x082C0001U /* 027 */ 
#define GPIO_32_EPWMSYNCI 0x082C0002U /* 027 */ 
#define GPIO_32_ADCSOCAO  0x082C0003U /* 027 */ 

#define GPIO_33_GPIO33    0x082C0200U /* 027 */ 
#define GPIO_33_SCLA      0x082C0201U /* 027 */ 
#define GPIO_33_EPWMSYNCO 0x082C0202U /* 027 */ 
#define GPIO_33_ADCSOCBO  0x082C0203U /* 027 */ 

#define GPIO_34_GPIO34    0x082C0400U /* 027 */ 
#define GPIO_34_COMP2OUT  0x082C0401U /* 027 */     

#define GPIO_35_GPIO35    0x082C0600U /* 027 */ 
#define GPIO_35_TDI       0x082C0601U /* 027 */ 

#define GPIO_36_GPIO36    0x082C0800U /* 027 */ 
#define GPIO_36_TMS       0x082C0801U /* 027 */ 

#define GPIO_37_GPIO37    0x082C0A00U /* 027 */ 
#define GPIO_37_TDO       0x082C0A01U /* 027 */ 

#define GPIO_38_GPIO38    0x082C0C00U /* 027 */ 
#define GPIO_38_TCK       0x082C0C01U /* 027 */ 
// #define GPIO_38_XCLKIN             /* 027 */ 

#endif /* (GS32_PART_NUM==0x027) */

#endif /* IS_GS32F00xx(0x30) */

#ifdef __cplusplus
}
#endif

#endif /* PINMAP_GS32F027_H_ */
