/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    pinmap_gs32p65.h
*   @brief   
*
*/

#ifndef PINMAP_GS32P65_H_
#define PINMAP_GS32P65_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

#if IS_GS32F3xx()

#if GS32_PART_NUM == 0x0650
/*****************************************************************************
 * 
 * Values that can be passed to GPIO_setPinConfig() as the pinConfig parameter.
 * 
 * Note: Refer to the corresponding data manual for detailed information 
 * on each pin's reuse functions and configurations.
 * 
*****************************************************************************/

#define GPIO_0_GPIO0                     0x000C0000U
#define GPIO_0_EPWM1_A                   0x000C0001U
#define GPIO_0_CLB_OUTPUTXBAR1           0x000C0005U
#define GPIO_0_I2CA_SDA                  0x000C0006U
#define GPIO_0_FSMC_A15                  0x000C0009U

#define GPIO_1_GPIO1                     0x000C0200U
#define GPIO_1_EPWM1_B                   0x000C0201U
#define GPIO_1_CLB_OUTPUTXBAR2           0x000C0205U
#define GPIO_1_I2CA_SCL                  0x000C0206U
#define GPIO_1_FSMC_A16                  0x000C0209U

#define GPIO_2_GPIO2                     0x000C0400U
#define GPIO_2_EPWM2_A                   0x000C0401U
#define GPIO_2_OUTPUTXBAR1               0x000C0405U
#define GPIO_2_I2CB_SDA                  0x000C0406U
#define GPIO_2_SCIE_TX                  0x000C0407U
#define GPIO_2_FSMC_A17                  0x000C0409U

#define GPIO_3_GPIO3                     0x000C0600U
#define GPIO_3_EPWM2_B                   0x000C0601U
#define GPIO_3_OUTPUTXBAR2               0x000C0602U
#define GPIO_3_I2CB_SCL                  0x000C0606U
#define GPIO_3_SCIE_RX                  0x000C0607U

#define GPIO_4_GPIO4                     0x000C0800U
#define GPIO_4_EPWM3_A                   0x000C0801U
#define GPIO_4_OUTPUTXBAR3               0x000C0805U
#define GPIO_4_CANA_TX                   0x000C0806U
#define GPIO_4_CANC_TX                   0x000C0809U

#define GPIO_5_GPIO5                     0x000C0A00U
#define GPIO_5_EPWM3_B                   0x000C0A01U
#define GPIO_5_OUTPUTXBAR3               0x000C0A03U
#define GPIO_5_CLB_OUTPUTXBAR3           0x000C0A05U
#define GPIO_5_CANA_RX                   0x000C0A06U
#define GPIO_5_CANC_RX                   0x000C0A09U

#define GPIO_6_GPIO6                     0x000C0C00U
#define GPIO_6_EPWM4_A                   0x000C0C01U
#define GPIO_6_OUTPUTXBAR4               0x000C0C02U
#define GPIO_6_EXTSYNCOUT                0x000C0C03U
#define GPIO_6_EQEP3_A                   0x000C0C05U
#define GPIO_6_CANB_TX                   0x000C0C06U
#define GPIO_6_LINA_TX                   0x000C0C07U
#define GPIO_6_FSMC_NBL0                 0x000C0C09U

#define GPIO_7_GPIO7                     0x000C0E00U
#define GPIO_7_EPWM4_B                   0x000C0E01U
#define GPIO_7_OUTPUTXBAR5               0x000C0E03U
#define GPIO_7_EQEP3_B                   0x000C0E05U
#define GPIO_7_CANB_RX                   0x000C0E06U
#define GPIO_7_LINA_RX                   0x000C0E07U
#define GPIO_7_FSMC_NBL1                 0x000C0E09U

#define GPIO_8_GPIO8                     0x000C1000U
#define GPIO_8_EPWM5_A                   0x000C1001U
#define GPIO_8_ADCSOCAO                  0x000C1003U
#define GPIO_8_EQEP3_STROBE              0x000C1005U
#define GPIO_8_SCIA_TX                   0x000C1006U
#define GPIO_8_CLB_OUTPUTXBAR4           0x000C1007U
#define GPIO_8_CANC_TX                   0x000C1009U

#define GPIO_9_GPIO9                     0x000C1200U
#define GPIO_9_EPWM5_B                   0x000C1201U
#define GPIO_9_SCIB_TX                   0x000C1202U
#define GPIO_9_OUTPUTXBAR6               0x000C1203U
#define GPIO_9_EQEP3_INDEX               0x000C1205U
#define GPIO_9_SCIA_RX                   0x000C1206U

#define GPIO_10_GPIO10                    0x000C1400U
#define GPIO_10_EPWM6_A                   0x000C1401U
#define GPIO_10_ADCSOCBO                  0x000C1403U
#define GPIO_10_EQEP1_A                   0x000C1405U
#define GPIO_10_SCIB_TX                   0x000C1406U
#define GPIO_10_SD4_C1                    0x000C1407U
#define GPIO_10_CANC_RX                   0x000C1409U
#define GPIO_10_CLB_OUTPUTXBAR5           0x000C140AU

#define GPIO_11_GPIO11                    0x000C1600U
#define GPIO_11_EPWM6_B                   0x000C1601U
#define GPIO_11_SCIB_RX                   0x000C1602U
#define GPIO_11_OUTPUTXBAR7               0x000C1603U
#define GPIO_11_EQEP1_B                   0x000C1605U
#define GPIO_11_SD4_D1                    0x000C1607U
#define GPIO_11_PMBUSA_ALERT              0x000C160FU

#define GPIO_12_GPIO12                    0x000C1800U
#define GPIO_12_EPWM7_A                   0x000C1801U
#define GPIO_12_CLB_OUTPUTXBAR6           0x000C1802U
#define GPIO_12_ADCSOCAO                  0x000C1803U
#define GPIO_12_EQEP1_STROBE              0x000C1805U
#define GPIO_12_SCIA_TX                   0x000C1806U
#define GPIO_12_SD4_C2                    0x000C1807U
#define GPIO_12_FSMC_A3                   0x000C1809U
#define GPIO_12_PMBUSA_CTL                0x000C180FU

#define GPIO_13_GPIO13                    0x000C1A00U
#define GPIO_13_EPWM7_B                   0x000C1A01U
#define GPIO_13_CLB_OUTPUTXBAR7           0x000C1A02U
#define GPIO_13_EQEP5_STROBE              0x000C1A03U
#define GPIO_13_EQEP1_INDEX               0x000C1A05U
#define GPIO_13_SCIA_RX                   0x000C1A06U
#define GPIO_13_SD4_D2                    0x000C1A07U
#define GPIO_13_FSMC_NE1                  0x000C1A09U
#define GPIO_13_PMBUSA_SDA                0x000C1A0FU

#define GPIO_14_GPIO14                    0x000C1C00U
#define GPIO_14_EPWM8_A                   0x000C1C01U
#define GPIO_14_SCIB_TX                   0x000C1C02U
#define GPIO_14_EQEP5_INDEX               0x000C1C03U
#define GPIO_14_LINA_TX                   0x000C1C05U
#define GPIO_14_OUTPUTXBAR3               0x000C1C06U
#define GPIO_14_OUTPUTXBAR8               0x000C1C07U
#define GPIO_14_PMBUSA_SCL                0x000C1C0FU

#define GPIO_15_GPIO15                    0x000C1E00U
#define GPIO_15_EPWM8_B                   0x000C1E01U
#define GPIO_15_SCIB_RX                   0x000C1E02U
#define GPIO_15_LINA_RX                   0x000C1E05U
#define GPIO_15_OUTPUTXBAR4               0x000C1E06U
#define GPIO_15_CLB_OUTPUTXBAR8           0x000C1E07U
#define GPIO_15_EQEP5_A                   0x000C1E0BU

#define GPIO_16_GPIO16                    0x00100000U
#define GPIO_16_SPIA_PICO                 0x00100001U
#define GPIO_16_OUTPUTXBAR7               0x00100003U
#define GPIO_16_EPWM9_A                   0x00100005U
#define GPIO_16_SD1_D1                    0x00100007U
#define GPIO_16_EQEP5_B                   0x0010000BU

#define GPIO_17_GPIO17                    0x00100200U
#define GPIO_17_SPIA_POCI                 0x00100201U
#define GPIO_17_OUTPUTXBAR8               0x00100203U
#define GPIO_17_EPWM9_B                   0x00100205U
#define GPIO_17_SD1_C1                    0x00100207U
#define GPIO_17_EQEP5_STROBE              0x0010020BU

#define GPIO_18_GPIO18                    0x00100400U
#define GPIO_18_SPIA_CLK                  0x00100401U
#define GPIO_18_SCIB_TX                   0x00100402U
#define GPIO_18_CANA_RX                   0x00100403U
#define GPIO_18_EPWM10_A                  0x00100405U
#define GPIO_18_SD1_D2                    0x00100407U
#define GPIO_18_CANC_RX                   0x00100409U
#define GPIO_18_FSMC_NE2                  0x0010040AU
#define GPIO_18_EQEP5_INDEX               0x0010040BU

#define GPIO_19_GPIO19                    0x00100600U
#define GPIO_19_SPIA_PTE                  0x00100601U
#define GPIO_19_SCIB_RX                   0x00100602U
#define GPIO_19_CANA_TX                   0x00100603U
#define GPIO_19_EPWM10_B                  0x00100605U
#define GPIO_19_SD1_C2                    0x00100607U
#define GPIO_19_CANC_TX                   0x00100609U
#define GPIO_19_FSMC_NE3                  0x0010060AU

#define GPIO_20_GPIO20                    0x00100800U
#define GPIO_20_EQEP1_A                   0x00100801U
#define GPIO_20_EPWM11_A                  0x00100805U
#define GPIO_20_SD1_D3                    0x00100807U
#define GPIO_20_CANB_TX                   0x00100809U
#define GPIO_20_FSMC_A0                   0x0010080AU
#define GPIO_20_SPIC_PICO                 0x0010080EU

#define GPIO_21_GPIO21                    0x00100A00U
#define GPIO_21_EQEP1_B                   0x00100A01U
#define GPIO_21_EPWM11_B                  0x00100A05U
#define GPIO_21_SD1_C3                    0x00100A07U
#define GPIO_21_CANB_RX                   0x00100A09U
#define GPIO_21_FSMC_A1                   0x00100A0AU
#define GPIO_21_SPIC_POCI                 0x00100A0EU

#define GPIO_22_GPIO22                    0x00100C00U
#define GPIO_22_EQEP1_STROBE              0x00100C01U
#define GPIO_22_SCIB_TX                   0x00100C03U
#define GPIO_22_EPWM12_A                  0x00100C05U
#define GPIO_22_SPIB_CLK                  0x00100C06U
#define GPIO_22_SD1_D4                    0x00100C07U
#define GPIO_22_CANC_TX                   0x00100C09U
#define GPIO_22_SPIC_CLK                  0x00100C0EU

#define GPIO_23_GPIO23                    0x00100E00U
#define GPIO_23_EQEP1_INDEX               0x00100E01U
#define GPIO_23_SCIB_RX                   0x00100E03U
#define GPIO_23_EPWM12_B                  0x00100E05U
#define GPIO_23_SPIB_PTE                  0x00100E06U
#define GPIO_23_SD1_C4                    0x00100E07U
#define GPIO_23_CANC_RX                   0x00100E09U
#define GPIO_23_SPIC_PTE                  0x00100E0EU

#define GPIO_24_GPIO24                    0x00101000U
#define GPIO_24_OUTPUTXBAR1               0x00101001U
#define GPIO_24_EQEP2_A                   0x00101002U
#define GPIO_24_LINB_TX                   0x00101005U
#define GPIO_24_SPIB_PICO                 0x00101006U
#define GPIO_24_SD2_D1                    0x00101007U
#define GPIO_24_PMBUSA_SCL                0x00101009U
#define GPIO_24_FSMC_NBL0                 0x0010100AU
#define GPIO_24_EPWM13_A                  0x0010100DU

#define GPIO_25_GPIO25                    0x00101200U
#define GPIO_25_OUTPUTXBAR2               0x00101201U
#define GPIO_25_EQEP2_B                   0x00101202U
#define GPIO_25_LINB_RX                   0x00101205U
#define GPIO_25_SPIB_POCI                 0x00101206U
#define GPIO_25_SD2_C1                    0x00101207U
#define GPIO_25_PMBUSA_SDA                0x00101209U
#define GPIO_25_FSMC_NBL1                 0x0010120AU
#define GPIO_25_EQEP5_B                   0x0010120BU
#define GPIO_25_EPWM13_B                  0x0010120DU

#define GPIO_26_GPIO26                    0x00101400U
#define GPIO_26_OUTPUTXBAR3               0x00101401U
#define GPIO_26_EQEP2_INDEX               0x00101402U
#define GPIO_26_SPIB_CLK                  0x00101406U
#define GPIO_26_SD2_D2                    0x00101407U
#define GPIO_26_PMBUSA_ALERT              0x00101409U
#define GPIO_26_EPWM14_A                  0x0010140DU

#define GPIO_27_GPIO27                    0x00101600U
#define GPIO_27_OUTPUTXBAR4               0x00101601U
#define GPIO_27_EQEP2_STROBE              0x00101602U
#define GPIO_27_SPIB_PTE                  0x00101606U
#define GPIO_27_SD2_C2                    0x00101607U
#define GPIO_27_PMBUSA_CTL                0x00101609U
#define GPIO_27_EPWM14_B                  0x0010160DU

#define GPIO_28_GPIO28                    0x00101800U
#define GPIO_28_SCIA_RX                   0x00101801U
#define GPIO_28_FSMC_NE4                  0x00101802U
#define GPIO_28_SCIE_RX                   0x00101803U
#define GPIO_28_OUTPUTXBAR5               0x00101805U
#define GPIO_28_EQEP3_A                   0x00101806U
#define GPIO_28_SD2_D3                    0x00101807U
#define GPIO_28_FSMC_NE2                  0x00101809U
#define GPIO_28_EPWM15_A                  0x0010180DU

#define GPIO_29_GPIO29                    0x00101A00U
#define GPIO_29_SCIA_TX                   0x00101A01U
#define GPIO_29_FSMC_SDCKE                0x00101A02U
#define GPIO_29_SCIE_TX                   0x00101A03U
#define GPIO_29_OUTPUTXBAR6               0x00101A05U
#define GPIO_29_EQEP3_B                   0x00101A06U
#define GPIO_29_SD2_C3                    0x00101A07U
#define GPIO_29_FSMC_NE3                  0x00101A09U
#define GPIO_29_EPWM15_B                  0x00101A0DU

#define GPIO_30_GPIO30                    0x00101C00U
#define GPIO_30_CANA_RX                   0x00101C01U
#define GPIO_30_FSMC_CLK                  0x00101C02U
#define GPIO_30_CANC_RX                   0x00101C03U
#define GPIO_30_OUTPUTXBAR7               0x00101C05U
#define GPIO_30_EQEP3_STROBE              0x00101C06U
#define GPIO_30_SD2_D4                    0x00101C07U
#define GPIO_30_FSMC_NE4                  0x00101C09U
#define GPIO_30_EPWM16_A                  0x00101C0DU
#define GPIO_30_SPID_PICO                 0x00101C0FU

#define GPIO_31_GPIO31                    0x00101E00U
#define GPIO_31_CANA_TX                   0x00101E01U
#define GPIO_31_FSMC_NWE                  0x00101E02U
#define GPIO_31_CANC_TX                   0x00101E03U
#define GPIO_31_OUTPUTXBAR8               0x00101E05U
#define GPIO_31_EQEP3_INDEX               0x00101E06U
#define GPIO_31_SD2_C4                    0x00101E07U
#define GPIO_31_FSMC_RNW                  0x00101E09U
#define GPIO_31_I2CA_SDA                  0x00101E0AU
#define GPIO_31_I2CC_SDA                  0x00101E0BU
#define GPIO_31_EPWM16_B                  0x00101E0DU
#define GPIO_31_SPID_POCI                 0x00101E0FU

#define GPIO_32_GPIO32                    0x008C0000U
#define GPIO_32_I2CA_SDA                  0x008C0001U
#define GPIO_32_FSMC_NE1                  0x008C0002U
#define GPIO_32_SPIA_PICO                 0x008C0003U
#define GPIO_32_EQEP4_A                   0x008C0005U
#define GPIO_32_LINB_TX                   0x008C0006U
#define GPIO_32_CLB_OUTPUTXBAR1           0x008C0007U
#define GPIO_32_FSMC_NOE                  0x008C0009U
#define GPIO_32_I2CA_SCL                  0x008C000AU
#define GPIO_32_I2CC_SCL                  0x008C000BU
#define GPIO_32_SPID_CLK                  0x008C000FU

#define GPIO_33_GPIO33                    0x008C0200U
#define GPIO_33_I2CA_SCL                  0x008C0201U
#define GPIO_33_FSMC_RNW                  0x008C0202U
#define GPIO_33_SPIA_POCI                 0x008C0203U
#define GPIO_33_EQEP4_B                   0x008C0205U
#define GPIO_33_CLB_OUTPUTXBAR2           0x008C0207U
#define GPIO_33_FSMC_A0                   0x008C0209U
#define GPIO_33_SPID_PTE                  0x008C020FU

#define GPIO_34_GPIO34                    0x008C0400U
#define GPIO_34_OUTPUTXBAR1               0x008C0401U
#define GPIO_34_FSMC_NE2                  0x008C0402U
#define GPIO_34_SPIA_CLK                  0x008C0403U
#define GPIO_34_EQEP4_STROBE              0x008C0405U
#define GPIO_34_I2CB_SDA                  0x008C0406U
#define GPIO_34_CLB_OUTPUTXBAR3           0x008C0407U
#define GPIO_34_FSMC_A1                   0x008C0409U
#define GPIO_34_EPWM18_A                  0x008C040BU
#define GPIO_34_SCIA_TX                   0x008C040DU

#define GPIO_35_GPIO35                    0x008C0600U
#define GPIO_35_SCIA_RX                   0x008C0601U
#define GPIO_35_FSMC_NE3                  0x008C0602U
#define GPIO_35_SPIA_PTE                  0x008C0603U
#define GPIO_35_EQEP4_INDEX               0x008C0605U
#define GPIO_35_I2CB_SCL                  0x008C0606U
#define GPIO_35_CLB_OUTPUTXBAR4           0x008C0607U
#define GPIO_35_FSMC_A2                   0x008C0609U
#define GPIO_35_EPWM18_B                  0x008C060BU

#define GPIO_36_GPIO36                    0x008C0800U
#define GPIO_36_SCIA_TX                   0x008C0801U
#define GPIO_36_FSMC_NWAIT                0x008C0802U
#define GPIO_36_CANA_RX                   0x008C0806U
#define GPIO_36_CLB_OUTPUTXBAR5           0x008C0807U
#define GPIO_36_FSMC_A3                   0x008C0809U
#define GPIO_36_CANC_RX                   0x008C080AU
#define GPIO_36_SD1_D1                    0x008C080DU
#define GPIO_36_FSMC_NWE                  0x008C080EU

#define GPIO_37_GPIO37                    0x008C0A00U
#define GPIO_37_OUTPUTXBAR2               0x008C0A01U
#define GPIO_37_FSMC_NOE                  0x008C0A02U
#define GPIO_37_EPWM18_A                  0x008C0A03U
#define GPIO_37_CANA_TX                   0x008C0A06U
#define GPIO_37_CLB_OUTPUTXBAR6           0x008C0A07U
#define GPIO_37_FSMC_A4                   0x008C0A09U
#define GPIO_37_CANC_TX                   0x008C0A0AU
#define GPIO_37_SD1_D2                    0x008C0A0DU

#define GPIO_38_GPIO38                    0x008C0C00U
#define GPIO_38_FSMC_A2                   0x008C0C02U
#define GPIO_38_EPWM18_B                  0x008C0C03U
#define GPIO_38_SCIE_TX                   0x008C0C05U
#define GPIO_38_SCIB_TX                   0x008C0C06U
#define GPIO_38_CLB_OUTPUTXBAR7           0x008C0C07U
#define GPIO_38_FSMC_A5                   0x008C0C09U
#define GPIO_38_SD1_D3                    0x008C0C0DU
#define GPIO_38_FSMC_NE2                  0x008C0C0EU

#define GPIO_39_GPIO39                    0x008C0E00U
#define GPIO_39_FSMC_A3                   0x008C0E02U
#define GPIO_39_SCIE_RX                   0x008C0E05U
#define GPIO_39_SCIB_RX                   0x008C0E06U
#define GPIO_39_CLB_OUTPUTXBAR8           0x008C0E07U
#define GPIO_39_FSMC_A6                   0x008C0E09U
#define GPIO_39_SD1_D4                    0x008C0E0DU

#define GPIO_40_GPIO40                    0x008C1000U
#define GPIO_40_FSMC_A4                   0x008C1002U
#define GPIO_40_EPWM13_A                  0x008C1003U
#define GPIO_40_CANB_RX                   0x008C1005U
#define GPIO_40_I2CB_SDA                  0x008C1006U
#define GPIO_40_SD4_C3                    0x008C1007U
#define GPIO_40_CLB_OUTPUTXBAR1           0x008C100AU
#define GPIO_40_SD2_C1                    0x008C100DU

#define GPIO_41_GPIO41                    0x008C1200U
#define GPIO_41_FSMC_A5                   0x008C1202U
#define GPIO_41_EPWM13_B                  0x008C1203U
#define GPIO_41_CANB_TX                   0x008C1205U
#define GPIO_41_I2CB_SCL                  0x008C1206U
#define GPIO_41_SD4_D3                    0x008C1207U
#define GPIO_41_CLB_OUTPUTXBAR2           0x008C120AU
#define GPIO_41_SD2_D1                    0x008C120DU

#define GPIO_42_GPIO42                    0x008C1400U
#define GPIO_42_EPWM14_A                  0x008C1403U
#define GPIO_42_EQEP4_A                   0x008C1405U
#define GPIO_42_I2CA_SDA                  0x008C1406U
#define GPIO_42_SD4_C4                    0x008C1407U
#define GPIO_42_CLB_OUTPUTXBAR5           0x008C140AU
#define GPIO_42_SCIE_TX                   0x008C140BU
#define GPIO_42_SCIA_TX                   0x008C140FU

#define GPIO_43_GPIO43                    0x008C1600U
#define GPIO_43_EPWM14_B                  0x008C1603U
#define GPIO_43_EQEP4_B                   0x008C1605U
#define GPIO_43_I2CA_SCL                  0x008C1606U
#define GPIO_43_SD4_D4                    0x008C1607U
#define GPIO_43_CLB_OUTPUTXBAR6           0x008C160AU
#define GPIO_43_SCIE_RX                   0x008C160BU
#define GPIO_43_SCIA_RX                   0x008C160FU

#define GPIO_44_GPIO44                    0x008C1800U
#define GPIO_44_SPID_POCI                 0x008C1801U
#define GPIO_44_FSMC_A6                   0x008C1802U
#define GPIO_44_CANB_RX                   0x008C1803U
#define GPIO_44_SD3_C4                    0x008C1806U
#define GPIO_44_SCIF_TX                   0x008C1807U
#define GPIO_44_CLB_OUTPUTXBAR6           0x008C180AU

#define GPIO_45_GPIO45                    0x008C1A00U
#define GPIO_45_SPID_PTE                  0x008C1A01U
#define GPIO_45_FSMC_A7                   0x008C1A02U
#define GPIO_45_CANB_TX                   0x008C1A03U
#define GPIO_45_SD3_D4                    0x008C1A06U
#define GPIO_45_SCIF_RX                   0x008C1A07U
#define GPIO_45_CLB_OUTPUTXBAR7           0x008C1A0AU

#define GPIO_46_GPIO46                    0x008C1C00U
#define GPIO_46_EPWM4_A                   0x008C1C01U
#define GPIO_46_FSMC_A8                   0x008C1C02U
#define GPIO_46_EPWM14_A                  0x008C1C03U
#define GPIO_46_SCIA_RX                   0x008C1C06U
#define GPIO_46_SD3_C4                    0x008C1C07U

#define GPIO_47_GPIO47                    0x008C1E00U
#define GPIO_47_EPWM4_B                   0x008C1E01U
#define GPIO_47_FSMC_A9                   0x008C1E02U
#define GPIO_47_EPWM14_B                  0x008C1E03U
#define GPIO_47_SCIA_TX                   0x008C1E06U
#define GPIO_47_SD4_C3                    0x008C1E07U

#define GPIO_48_GPIO48                    0x00900000U
#define GPIO_48_OUTPUTXBAR3               0x00900001U
#define GPIO_48_FSMC_A10                  0x00900002U
#define GPIO_48_SCIA_TX                   0x00900006U
#define GPIO_48_SD1_D1                    0x00900007U
#define GPIO_48_SD2_C2                    0x0090000DU

#define GPIO_49_GPIO49                    0x00900200U
#define GPIO_49_OUTPUTXBAR4               0x00900201U
#define GPIO_49_FSMC_A11                  0x00900202U
#define GPIO_49_SCIA_RX                   0x00900206U
#define GPIO_49_SD1_C1                    0x00900207U
#define GPIO_49_FSMC_A7                   0x00900209U
#define GPIO_49_SD2_D1                    0x0090020DU

#define GPIO_50_GPIO50                    0x00900400U
#define GPIO_50_EQEP1_A                   0x00900401U
#define GPIO_50_FSMC_A12                  0x00900402U
#define GPIO_50_EPWM15_A                  0x00900403U
#define GPIO_50_SPIC_PICO                 0x00900406U
#define GPIO_50_SD1_D2                    0x00900407U
#define GPIO_50_FSMC_A8                   0x00900409U
#define GPIO_50_SD2_D2                    0x0090040DU

#define GPIO_51_GPIO51                    0x00900600U
#define GPIO_51_EQEP1_B                   0x00900601U
#define GPIO_51_FSMC_A13                  0x00900602U
#define GPIO_51_EPWM15_B                  0x00900603U
#define GPIO_51_SPIC_POCI                 0x00900606U
#define GPIO_51_SD1_C2                    0x00900607U
#define GPIO_51_FSMC_A9                   0x00900609U
#define GPIO_51_SD2_D3                    0x0090060DU

#define GPIO_52_GPIO52                    0x00900800U
#define GPIO_52_EQEP1_STROBE              0x00900801U
#define GPIO_52_FSMC_A14                  0x00900802U
#define GPIO_52_EPWM16_A                  0x00900803U
#define GPIO_52_SPIC_CLK                  0x00900806U
#define GPIO_52_SD1_D3                    0x00900807U
#define GPIO_52_FSMC_A10                  0x00900809U
#define GPIO_52_SD2_D4                    0x0090080DU

#define GPIO_53_GPIO53                    0x00900A00U
#define GPIO_53_EQEP1_INDEX               0x00900A01U
#define GPIO_53_SPIC_PTE                  0x00900A06U
#define GPIO_53_SD1_C3                    0x00900A07U
#define GPIO_53_FSMC_A11                  0x00900A09U
#define GPIO_53_SD1_C1                    0x00900A0DU

#define GPIO_54_GPIO54                    0x00900C00U
#define GPIO_54_SPIA_PICO                 0x00900C01U
#define GPIO_54_EQEP2_A                   0x00900C05U
#define GPIO_54_SCIB_TX                   0x00900C06U
#define GPIO_54_SD1_D4                    0x00900C07U
#define GPIO_54_FSMC_A12                  0x00900C09U
#define GPIO_54_SD1_C2                    0x00900C0DU
#define GPIO_54_SPIE_PICO                 0x00900C0FU

#define GPIO_55_GPIO55                    0x00900E00U
#define GPIO_55_SPIA_POCI                 0x00900E01U
#define GPIO_55_EPWM16_B                  0x00900E03U
#define GPIO_55_EQEP2_B                   0x00900E05U
#define GPIO_55_SCIB_RX                   0x00900E06U
#define GPIO_55_SD1_C4                    0x00900E07U
#define GPIO_55_FSMC_D0                   0x00900E09U
#define GPIO_55_SD1_C3                    0x00900E0DU
#define GPIO_55_SPIE_POCI                 0x00900E0FU

#define GPIO_56_GPIO56                    0x00901000U
#define GPIO_56_SPIA_CLK                  0x00901001U
#define GPIO_56_EPWM17_A                  0x00901003U
#define GPIO_56_EQEP2_STROBE              0x00901005U
#define GPIO_56_SCIC_TX                   0x00901006U
#define GPIO_56_SD2_D1                    0x00901007U
#define GPIO_56_FSMC_D1                   0x00901009U
#define GPIO_56_I2CA_SDA                  0x0090100AU
#define GPIO_56_SD1_C4                    0x0090100DU
#define GPIO_56_SPIE_CLK                  0x0090100FU

#define GPIO_57_GPIO57                    0x00901200U
#define GPIO_57_SPIA_PTE                  0x00901201U
#define GPIO_57_EPWM17_B                  0x00901203U
#define GPIO_57_EQEP2_INDEX               0x00901205U
#define GPIO_57_SCIC_RX                   0x00901206U
#define GPIO_57_SD2_C1                    0x00901207U
#define GPIO_57_FSMC_D2                   0x00901209U
#define GPIO_57_I2CA_SCL                  0x0090120AU
#define GPIO_57_SD3_D3                    0x0090120DU
#define GPIO_57_SPIE_PTE                  0x0090120FU

#define GPIO_58_GPIO58                    0x00901400U
#define GPIO_58_SPIA_PICO                 0x00901401U
#define GPIO_58_EPWM8_A                   0x00901403U
#define GPIO_58_OUTPUTXBAR1               0x00901405U
#define GPIO_58_SPIB_CLK                  0x00901406U
#define GPIO_58_SD2_D2                    0x00901407U
#define GPIO_58_FSMC_D3                   0x00901409U
#define GPIO_58_CANA_RX                   0x0090140BU
#define GPIO_58_SD2_C2                    0x0090140DU

#define GPIO_59_GPIO59                    0x00901600U
#define GPIO_59_EPWM5_A                   0x00901601U
#define GPIO_59_EPWM8_B                   0x00901603U
#define GPIO_59_OUTPUTXBAR2               0x00901605U
#define GPIO_59_SPIB_PTE                  0x00901606U
#define GPIO_59_SD2_C2                    0x00901607U
#define GPIO_59_FSMC_D4                   0x00901609U
#define GPIO_59_CANA_TX                   0x0090160BU
#define GPIO_59_SD2_C3                    0x0090160DU
#define GPIO_59_SPIA_POCI                 0x0090160FU

#define GPIO_60_GPIO60                    0x00901800U
#define GPIO_60_EPWM3_B                   0x00901801U
#define GPIO_60_OUTPUTXBAR3               0x00901805U
#define GPIO_60_SPIB_PICO                 0x00901806U
#define GPIO_60_SD2_D3                    0x00901807U
#define GPIO_60_FSMC_D5                   0x00901809U
#define GPIO_60_SD2_C4                    0x0090180DU
#define GPIO_60_SPIA_CLK                  0x0090180FU

#define GPIO_61_GPIO61                    0x00901A00U
#define GPIO_61_EPWM17_B                  0x00901A01U
#define GPIO_61_OUTPUTXBAR4               0x00901A05U
#define GPIO_61_SPIB_POCI                 0x00901A06U
#define GPIO_61_SD2_C3                    0x00901A07U
#define GPIO_61_FSMC_D6                   0x00901A09U
#define GPIO_61_CANA_RX                   0x00901A0EU
#define GPIO_61_SPIA_PTE                  0x00901A0FU

#define GPIO_62_GPIO62                    0x00901C00U
#define GPIO_62_SCIA_RX                   0x00901C01U
#define GPIO_62_EQEP3_A                   0x00901C05U
#define GPIO_62_CANA_RX                   0x00901C06U
#define GPIO_62_SD2_D4                    0x00901C07U
#define GPIO_62_FSMC_D7                   0x00901C09U
#define GPIO_62_CANA_TX                   0x00901C0EU

#define GPIO_63_GPIO63                    0x00901E00U
#define GPIO_63_SCIA_TX                   0x00901E01U
#define GPIO_63_EPWM9_A                   0x00901E03U
#define GPIO_63_EQEP3_B                   0x00901E05U
#define GPIO_63_CANA_TX                   0x00901E06U
#define GPIO_63_SD2_C4                    0x00901E07U
#define GPIO_63_FSMC_RNW                  0x00901E09U
#define GPIO_63_FSMC_A0                   0x00901E0AU
#define GPIO_63_SD1_D1                    0x00901E0DU
#define GPIO_63_SPIB_PICO                 0x00901E0FU

#define GPIO_64_GPIO64                    0x010C0000U
#define GPIO_64_EPWM9_B                   0x010C0003U
#define GPIO_64_EQEP3_STROBE              0x010C0005U
#define GPIO_64_SCIA_RX                   0x010C0006U
#define GPIO_64_FSMC_NWAIT                0x010C0009U
#define GPIO_64_FSMC_A1                   0x010C000AU
#define GPIO_64_SD1_C1                    0x010C000DU
#define GPIO_64_SPIB_POCI                 0x010C000FU

#define GPIO_65_GPIO65                    0x010C0200U
#define GPIO_65_EPWM10_A                  0x010C0203U
#define GPIO_65_EQEP3_INDEX               0x010C0205U
#define GPIO_65_SCIA_TX                   0x010C0206U
#define GPIO_65_FSMC_NWE                  0x010C0209U
#define GPIO_65_SD1_D2                    0x010C020DU
#define GPIO_65_SPIB_CLK                  0x010C020FU

#define GPIO_66_GPIO66                    0x010C0400U
#define GPIO_66_EQEP6_B                   0x010C0401U
#define GPIO_66_FSMC_D18                  0x010C0402U
#define GPIO_66_EPWM10_B                  0x010C0403U
#define GPIO_66_I2CB_SDA                  0x010C0406U
#define GPIO_66_FSMC_NOE                  0x010C0409U
#define GPIO_66_SD1_C2                    0x010C040DU
#define GPIO_66_SPIB_PTE                  0x010C040FU

#define GPIO_67_GPIO67                    0x010C0600U
#define GPIO_67_EPWM17_A                  0x010C0603U
#define GPIO_67_LINB_TX                   0x010C0605U
#define GPIO_67_SD1_D3                    0x010C060DU

#define GPIO_68_GPIO68                    0x010C0800U
#define GPIO_68_EPWM17_B                  0x010C0803U
#define GPIO_68_LINB_RX                   0x010C0805U
#define GPIO_68_SD1_C3                    0x010C080DU

#define GPIO_69_GPIO69                    0x010C0A00U
#define GPIO_69_FSMC_D15                  0x010C0A02U
#define GPIO_69_EPWM11_A                  0x010C0A03U
#define GPIO_69_I2CB_SCL                  0x010C0A06U
#define GPIO_69_NA                        0x010C0A0BU
#define GPIO_69_SD1_D4                    0x010C0A0DU
#define GPIO_69_SPIC_PICO                 0x010C0A0FU

#define GPIO_70_GPIO70                    0x010C0C00U
#define GPIO_70_FSMC_D14                  0x010C0C02U
#define GPIO_70_EPWM11_B                  0x010C0C03U
#define GPIO_70_CANA_RX                   0x010C0C05U
#define GPIO_70_SCIB_TX                   0x010C0C06U
#define GPIO_70_SCIF_TX                   0x010C0C07U
#define GPIO_70_CANC_RX                   0x010C0C09U
#define GPIO_70_NA                        0x010C0C0BU
#define GPIO_70_SD1_C4                    0x010C0C0DU
#define GPIO_70_SPIC_POCI                 0x010C0C0FU

#define GPIO_71_GPIO71                    0x010C0E00U
#define GPIO_71_FSMC_D13                  0x010C0E02U
#define GPIO_71_EPWM12_A                  0x010C0E03U
#define GPIO_71_CANA_TX                   0x010C0E05U
#define GPIO_71_SCIB_RX                   0x010C0E06U
#define GPIO_71_SCIF_RX                   0x010C0E07U
#define GPIO_71_CANC_TX                   0x010C0E09U
#define GPIO_71_SD3_D1                    0x010C0E0DU
#define GPIO_71_SPIC_CLK                  0x010C0E0FU

#define GPIO_72_GPIO72                    0x010C1000U
#define GPIO_72_EQEP6_STROBE              0x010C1001U
#define GPIO_72_FSMC_D12                  0x010C1002U
#define GPIO_72_EPWM12_B                  0x010C1003U
#define GPIO_72_OUTPUTXBAR8               0x010C1005U
#define GPIO_72_SCIE_TX                   0x010C1006U
#define GPIO_72_CANB_RX                   0x010C1009U
#define GPIO_72_SD3_C1                    0x010C100DU
#define GPIO_72_SPIC_PTE                  0x010C100FU

#define GPIO_73_GPIO73                    0x010C1200U
#define GPIO_73_EQEP6_INDEX               0x010C1201U
#define GPIO_73_FSMC_D11                  0x010C1202U
#define GPIO_73_XCLKOUT                   0x010C1203U
#define GPIO_73_OUTPUTXBAR6               0x010C1205U
#define GPIO_73_SCIE_RX                   0x010C1206U
#define GPIO_73_EPWM5_B                   0x010C1207U
#define GPIO_73_CANB_TX                   0x010C1209U
#define GPIO_73_SD4_D4                    0x010C120AU
#define GPIO_73_SD2_D2                    0x010C120DU

#define GPIO_74_GPIO74                    0x010C1400U
#define GPIO_74_EPWM8_A                   0x010C1401U
#define GPIO_74_FSMC_D10                  0x010C1402U
#define GPIO_74_EQEP5_A                   0x010C1406U
#define GPIO_74_CANC_TX                   0x010C1409U
#define GPIO_74_SD1_D4                    0x010C140AU
#define GPIO_74_SD2_C2                    0x010C140DU

#define GPIO_75_GPIO75                    0x010C1600U
#define GPIO_75_EPWM8_B                   0x010C1601U
#define GPIO_75_FSMC_D9                   0x010C1602U
#define GPIO_75_EQEP5_B                   0x010C1606U
#define GPIO_75_SPID_CLK                  0x010C1607U
#define GPIO_75_CANC_RX                   0x010C1609U
#define GPIO_75_CLB_OUTPUTXBAR8           0x010C160AU
#define GPIO_75_SD2_D3                    0x010C160DU

#define GPIO_76_GPIO76                    0x010C1800U
#define GPIO_76_EPWM9_A                   0x010C1801U
#define GPIO_76_FSMC_D8                   0x010C1802U
#define GPIO_76_EQEP5_STROBE              0x010C1806U
#define GPIO_76_SD3_C1                    0x010C1807U
#define GPIO_76_SD4_D4                    0x010C180AU
#define GPIO_76_SD2_C3                    0x010C180DU

#define GPIO_77_GPIO77                    0x010C1A00U
#define GPIO_77_EPWM9_B                   0x010C1A01U
#define GPIO_77_FSMC_D7                   0x010C1A02U
#define GPIO_77_EQEP5_INDEX               0x010C1A06U
#define GPIO_77_SD3_D1                    0x010C1A07U
#define GPIO_77_SD1_D4                    0x010C1A0AU
#define GPIO_77_SD2_D4                    0x010C1A0DU

#define GPIO_78_GPIO78                    0x010C1C00U
#define GPIO_78_EPWM10_A                  0x010C1C01U
#define GPIO_78_FSMC_D6                   0x010C1C02U
#define GPIO_78_EQEP2_A                   0x010C1C06U
#define GPIO_78_SD3_C2                    0x010C1C07U
#define GPIO_78_SD4_D4                    0x010C1C0AU
#define GPIO_78_SD2_C4                    0x010C1C0DU

#define GPIO_79_GPIO79                    0x010C1E00U
#define GPIO_79_EPWM10_B                  0x010C1E01U
#define GPIO_79_FSMC_D5                   0x010C1E02U
#define GPIO_79_ERRORSTS                  0x010C1E05U
#define GPIO_79_EQEP2_B                   0x010C1E06U
#define GPIO_79_SD3_D2                    0x010C1E07U
#define GPIO_79_SD2_D1                    0x010C1E0DU

#define GPIO_80_GPIO80                    0x01100000U
#define GPIO_80_EPWM11_A                  0x01100001U
#define GPIO_80_FSMC_D4                   0x01100002U
#define GPIO_80_ERRORSTS                  0x01100005U
#define GPIO_80_EQEP2_STROBE              0x01100006U
#define GPIO_80_SD3_C3                    0x01100007U
#define GPIO_80_SD1_D4                    0x0110000AU
#define GPIO_80_SD2_C1                    0x0110000DU

#define GPIO_81_GPIO81                    0x01100200U
#define GPIO_81_EPWM11_B                  0x01100201U
#define GPIO_81_FSMC_D3                   0x01100202U
#define GPIO_81_EQEP2_INDEX               0x01100206U
#define GPIO_81_SD3_D3                    0x01100207U

#define GPIO_82_GPIO82                    0x01100400U
#define GPIO_82_EPWM12_A                  0x01100401U
#define GPIO_82_FSMC_D2                   0x01100402U
#define GPIO_82_SD3_C2                    0x0110040DU

#define GPIO_83_GPIO83                    0x01100600U
#define GPIO_83_EPWM12_B                  0x01100601U
#define GPIO_83_FSMC_D1                   0x01100602U
#define GPIO_83_SD3_D2                    0x0110060DU

#define GPIO_84_GPIO84                    0x01100800U
#define GPIO_84_EPWM12_B                  0x01100801U
#define GPIO_84_FSMC_D1                   0x01100802U
#define GPIO_84_FSMC_NE4                 0x01100803U
#define GPIO_84_SCIA_TX                   0x01100805U
#define GPIO_84_EQEP6_A                   0x01100806U
#define GPIO_84_SD3_D2                    0x01100809U
#define GPIO_84_SCIE_TX                   0x0110080BU
#define GPIO_84_SD3_C2                    0x0110080DU

#define GPIO_85_GPIO85                    0x01100A00U
#define GPIO_85_EPWM13_A                  0x01100A01U
#define GPIO_85_FSMC_D0                   0x01100A02U
#define GPIO_85_SCIA_RX                   0x01100A05U
#define GPIO_85_EQEP6_B                   0x01100A06U
#define GPIO_85_SD3_D1                    0x01100A07U
#define GPIO_85_SCIE_RX                   0x01100A0BU
#define GPIO_85_SD3_D3                    0x01100A0DU

#define GPIO_86_GPIO86                    0x01100C00U
#define GPIO_86_EPWM13_B                  0x01100C01U
#define GPIO_86_FSMC_A15                  0x01100C02U
#define GPIO_86_SCIB_TX                   0x01100C05U
#define GPIO_86_EQEP6_STROBE              0x01100C06U
#define GPIO_86_SD3_C3                    0x01100C0DU

#define GPIO_87_GPIO87                    0x01100E00U
#define GPIO_87_EPWM14_A                  0x01100E01U
#define GPIO_87_FSMC_A16                  0x01100E02U
#define GPIO_87_SCIB_RX                   0x01100E05U
#define GPIO_87_EQEP6_INDEX               0x01100E06U
#define GPIO_87_SD3_D4                    0x01100E0DU

#define GPIO_88_GPIO88                    0x01101000U
#define GPIO_88_EPWM14_B                  0x01101001U
#define GPIO_88_FSMC_A17                  0x01101002U
#define GPIO_88_FSMC_NBL0                 0x01101003U
#define GPIO_88_FSMC_NBL1                 0x01101009U
#define GPIO_88_SD3_C4                    0x0110100DU

#define GPIO_89_GPIO89                    0x01101200U
#define GPIO_89_EPWM15_A                  0x01101201U
#define GPIO_89_FSMC_A18                  0x01101202U
#define GPIO_89_FSMC_NBL1                 0x01101203U
#define GPIO_89_SCIC_TX                   0x01101206U
#define GPIO_89_SD1_D3                    0x01101207U
#define GPIO_89_SD4_D1                    0x0110120DU
#define GPIO_89_SPID_PTE                  0x0110120FU

#define GPIO_90_GPIO90                    0x01101400U
#define GPIO_90_EPWM15_B                  0x01101401U
#define GPIO_90_FSMC_A19                  0x01101402U
#define GPIO_90_SCIC_RX                   0x01101406U
#define GPIO_90_SD1_C3                    0x01101407U
#define GPIO_90_SD4_C1                    0x0110140DU
#define GPIO_90_SPID_CLK                  0x0110140FU

#define GPIO_91_GPIO91                    0x01101600U
#define GPIO_91_EPWM16_A                  0x01101601U
#define GPIO_91_FSMC_A20                  0x01101602U
#define GPIO_91_I2CA_SDA                  0x01101606U
#define GPIO_91_SD4_D2                    0x01101607U
#define GPIO_91_PMBUSA_SCL                0x0110160AU
#define GPIO_91_CLB_OUTPUTXBAR1           0x0110160EU
#define GPIO_91_SPID_PICO                 0x0110160FU

#define GPIO_92_GPIO92                    0x01101800U
#define GPIO_92_EPWM16_B                  0x01101801U
#define GPIO_92_FSMC_A21                  0x01101802U
#define GPIO_92_FSMC_A1                   0x01101803U
#define GPIO_92_I2CA_SCL                  0x01101806U
#define GPIO_92_SD4_C2                    0x01101807U
#define GPIO_92_FSMC_NBL0                 0x01101809U
#define GPIO_92_PMBUSA_SDA                0x0110180AU
#define GPIO_92_SPIE_POCI                 0x0110180BU
#define GPIO_92_CLB_OUTPUTXBAR2           0x0110180EU
#define GPIO_92_SPID_POCI                 0x0110180FU

#define GPIO_93_GPIO93                    0x01101A00U
#define GPIO_93_EPWM17_A                  0x01101A01U
#define GPIO_93_FSMC_A0                   0x01101A03U
#define GPIO_93_SCID_TX                   0x01101A06U
#define GPIO_93_SD4_D3                    0x01101A07U
#define GPIO_93_PMBUSA_ALERT              0x01101A0AU
#define GPIO_93_CLB_OUTPUTXBAR3           0x01101A0EU
#define GPIO_93_SPID_CLK                  0x01101A0FU

#define GPIO_94_GPIO94                    0x01101C00U
#define GPIO_94_EPWM17_B                  0x01101C01U
#define GPIO_94_SCID_RX                   0x01101C06U
#define GPIO_94_SD4_C3                    0x01101C07U
#define GPIO_94_FSMC_A1                   0x01101C09U
#define GPIO_94_PMBUSA_CTL                0x01101C0AU
#define GPIO_94_CLB_OUTPUTXBAR4           0x01101C0EU
#define GPIO_94_SPID_PTE                  0x01101C0FU

#define GPIO_95_GPIO95                    0x01101E00U
#define GPIO_95_EPWM18_A                  0x01101E01U
#define GPIO_95_EQEP4_A                   0x01101E02U
#define GPIO_95_SD1_D1                    0x01101E06U
#define GPIO_95_CLB_OUTPUTXBAR5           0x01101E0EU

#define GPIO_96_GPIO96                    0x018C0000U
#define GPIO_96_EPWM18_B                  0x018C0001U
#define GPIO_96_EQEP4_B                   0x018C0002U
#define GPIO_96_EQEP1_A                   0x018C0005U
#define GPIO_96_SD1_C1                    0x018C0006U
#define GPIO_96_CLB_OUTPUTXBAR6           0x018C000EU

#define GPIO_97_GPIO97                    0x018C0200U
#define GPIO_97_EQEP4_STROBE              0x018C0202U
#define GPIO_97_EQEP1_B                   0x018C0205U
#define GPIO_97_SD1_D2                    0x018C0206U
#define GPIO_97_CLB_OUTPUTXBAR7           0x018C020EU

#define GPIO_98_GPIO98                    0x018C0400U
#define GPIO_98_EQEP4_INDEX               0x018C0402U
#define GPIO_98_EQEP1_STROBE              0x018C0405U
#define GPIO_98_SD1_C2                    0x018C0406U
#define GPIO_98_CLB_OUTPUTXBAR8           0x018C040EU

#define GPIO_99_GPIO99                    0x018C0600U
#define GPIO_99_EPWM8_A                   0x018C0603U
#define GPIO_99_EQEP1_INDEX               0x018C0605U
#define GPIO_99_SD4_D4                    0x018C0607U

#define GPIO_100_GPIO100                   0x018C0800U
#define GPIO_100_SPIA_PICO                 0x018C0801U
#define GPIO_100_FSMC_A1                   0x018C0802U
#define GPIO_100_EPWM9_A                   0x018C0803U
#define GPIO_100_EQEP2_A                   0x018C0805U
#define GPIO_100_SPIC_PICO                 0x018C0806U
#define GPIO_100_SD4_C4                    0x018C0807U
#define GPIO_100_SD1_D1                    0x018C0809U

#define GPIO_101_GPIO101                   0x018C0A00U
#define GPIO_101_EPWM18_A                  0x018C0A01U
#define GPIO_101_EQEP2_B                   0x018C0A05U
#define GPIO_101_SPIC_POCI                 0x018C0A06U
#define GPIO_101_FSMC_A7                   0x018C0A0BU

#define GPIO_102_GPIO102                   0x018C0C00U
#define GPIO_102_EPWM18_B                  0x018C0C01U
#define GPIO_102_EQEP2_STROBE              0x018C0C05U
#define GPIO_102_SPIC_CLK                  0x018C0C06U
#define GPIO_102_FSMC_A8                   0x018C0C0BU

#define GPIO_103_GPIO103                   0x018C0E00U
#define GPIO_103_FSMC_A0                   0x018C0E02U
#define GPIO_103_EPWM8_B                   0x018C0E03U
#define GPIO_103_EQEP2_INDEX               0x018C0E05U
#define GPIO_103_SPIC_PTE                  0x018C0E06U
#define GPIO_103_SD4_C4                    0x018C0E07U

#define GPIO_104_GPIO104                   0x018C1000U
#define GPIO_104_I2CA_SDA                  0x018C1001U
#define GPIO_104_EPWM18_A                  0x018C1002U
#define GPIO_104_EQEP3_A                   0x018C1005U
#define GPIO_104_SD3_D1                    0x018C1006U
#define GPIO_104_I2CC_SDA                  0x018C100BU

#define GPIO_105_GPIO105                   0x018C1200U
#define GPIO_105_I2CA_SCL                  0x018C1201U
#define GPIO_105_EPWM18_B                  0x018C1202U
#define GPIO_105_EQEP3_B                   0x018C1205U
#define GPIO_105_SD3_C1                    0x018C1206U
#define GPIO_105_I2CC_SCL                  0x018C120BU

#define GPIO_106_GPIO106                   0x018C1400U
#define GPIO_106_EPWM16_A                  0x018C1401U
#define GPIO_106_FSMC_A12                  0x018C1402U
#define GPIO_106_EQEP3_STROBE              0x018C1405U
#define GPIO_106_SD3_D2                    0x018C1406U

#define GPIO_107_GPIO107                   0x018C1600U
#define GPIO_107_EPWM16_B                  0x018C1601U
#define GPIO_107_EQEP3_INDEX               0x018C1605U
#define GPIO_107_SD3_C2                    0x018C1606U

#define GPIO_108_GPIO108                   0x018C1800U
#define GPIO_108_EPWM17_A                  0x018C1801U
#define GPIO_108_FSMC_A14                  0x018C1802U
#define GPIO_108_EQEP5_A                   0x018C1805U
#define GPIO_108_SD3_D3                    0x018C1806U

#define GPIO_109_GPIO109                   0x018C1A00U
#define GPIO_109_EPWM17_B                  0x018C1A01U
#define GPIO_109_FSMC_A13                  0x018C1A02U
#define GPIO_109_EQEP5_B                   0x018C1A05U
#define GPIO_109_SD3_C3                    0x018C1A06U

#define GPIO_110_GPIO110                   0x018C1C00U
#define GPIO_110_EQEP5_STROBE              0x018C1C05U
#define GPIO_110_SD3_D4                    0x018C1C06U

#define GPIO_111_GPIO111                   0x018C1E00U
#define GPIO_111_EQEP5_INDEX               0x018C1E05U
#define GPIO_111_SD3_C4                    0x018C1E06U

#define GPIO_112_GPIO112                   0x01900000U
#define GPIO_112_SD1_D3                    0x01900007U

#define GPIO_113_GPIO113                   0x01900200U
#define GPIO_113_SD1_C3                    0x01900207U

#define GPIO_114_GPIO114                   0x01900400U
#define GPIO_114_SD1_D4                    0x01900407U

#define GPIO_115_GPIO115                   0x01900600U
#define GPIO_115_OUTPUTXBAR5               0x01900605U
#define GPIO_115_SD1_C4                    0x01900607U

#define GPIO_116_GPIO116                   0x01900800U
#define GPIO_116_OUTPUTXBAR6               0x01900805U

#define GPIO_119_GPIO119                   0x01900E00U
#define GPIO_119_CANB_TX                   0x01900E05U

#define GPIO_120_GPIO120                   0x01901000U
#define GPIO_120_CANB_RX                   0x01901005U

#define GPIO_122_GPIO122                   0x01901400U
#define GPIO_122_SPIC_PICO                 0x01901406U
#define GPIO_122_SD1_D1                    0x01901407U

#define GPIO_123_GPIO123                   0x01901600U
#define GPIO_123_FSMC_D22                  0x01901601U
#define GPIO_123_SPIC_POCI                 0x01901606U
#define GPIO_123_SD1_C1                    0x01901607U

#define GPIO_124_GPIO124                   0x01901800U
#define GPIO_124_SPIC_CLK                  0x01901806U
#define GPIO_124_SD1_D2                    0x01901807U

#define GPIO_125_GPIO125                   0x01901A00U
#define GPIO_125_SPIC_PTE                  0x01901A06U
#define GPIO_125_SD1_C2                    0x01901A07U

#define GPIO_126_GPIO126                   0x01901C00U
#define GPIO_126_SPID_PICO                 0x01901C06U
#define GPIO_126_SD1_D3                    0x01901C07U

#define GPIO_127_GPIO127                   0x01901E00U
#define GPIO_127_SPID_POCI                 0x01901E06U
#define GPIO_127_SD1_C3                    0x01901E07U

#define GPIO_128_GPIO128                   0x020C0000U
#define GPIO_128_SPID_CLK                  0x020C0006U
#define GPIO_128_SD1_D4                    0x020C0007U

#define GPIO_129_GPIO129                   0x020C0200U
#define GPIO_129_SPID_PTE                  0x020C0206U
#define GPIO_129_SD1_C4                    0x020C0207U

#define GPIO_130_GPIO130                   0x020C0400U
#define GPIO_130_EPWM13_A                  0x020C0401U
#define GPIO_130_SD2_D1                    0x020C0407U

#define GPIO_131_GPIO131                   0x020C0600U
#define GPIO_131_EPWM13_B                  0x020C0601U
#define GPIO_131_SD2_C1                    0x020C0607U

#define GPIO_132_GPIO132                   0x020C0800U
#define GPIO_132_EPWM14_A                  0x020C0801U
#define GPIO_132_SD2_D2                    0x020C0807U

#define GPIO_133_GPIO133                   0x020C0A00U
#define GPIO_133_FSMC_A13                  0x020C0A01U
#define GPIO_133_EPWM9_A                   0x020C0A02U
#define GPIO_133_SD2_C2                    0x020C0A07U

#define GPIO_134_GPIO134                   0x020C0C00U
#define GPIO_134_EPWM14_B                  0x020C0C01U
#define GPIO_134_SD2_D3                    0x020C0C07U
#define GPIO_134_SD2_C1                    0x020C0C0DU

#define GPIO_141_GPIO141                   0x020C1A00U
#define GPIO_141_EPWM15_A                  0x020C1A01U
#define GPIO_141_SCIB_TX                   0x020C1A06U

#define GPIO_142_GPIO142                   0x020C1C00U
#define GPIO_142_EPWM15_B                  0x020C1C01U
#define GPIO_142_SCIB_RX                   0x020C1C06U

#define GPIO_145_GPIO145                   0x02100200U
#define GPIO_145_EPWM1_A                   0x02100201U
#define GPIO_145_CANB_TX                   0x02100206U

#define GPIO_146_GPIO146                   0x02100400U
#define GPIO_146_EPWM1_B                   0x02100401U
#define GPIO_146_CANB_RX                   0x02100406U

#define GPIO_147_GPIO147                   0x02100600U
#define GPIO_147_EPWM2_A                   0x02100601U
#define GPIO_147_EQEP5_A                   0x02100606U

#define GPIO_148_GPIO148                   0x02100800U
#define GPIO_148_EPWM2_B                   0x02100801U
#define GPIO_148_EQEP5_B                   0x02100806U

#define GPIO_149_GPIO149                   0x02100A00U
#define GPIO_149_EPWM3_A                   0x02100A01U
#define GPIO_149_EQEP5_STROBE              0x02100A06U

#define GPIO_150_GPIO150                   0x02100C00U
#define GPIO_150_EPWM3_B                   0x02100C01U
#define GPIO_150_EQEP5_INDEX               0x02100C06U

#define GPIO_151_GPIO151                   0x02100E00U
#define GPIO_151_EPWM4_A                   0x02100E01U
#define GPIO_151_PMBUSA_SCL                0x02100E06U

#define GPIO_152_GPIO152                   0x02101000U
#define GPIO_152_EPWM4_B                   0x02101001U
#define GPIO_152_PMBUSA_SDA                0x02101006U

#define GPIO_153_GPIO153                   0x02101200U
#define GPIO_153_EPWM5_A                   0x02101201U
#define GPIO_153_PMBUSA_ALERT              0x02101206U

#define GPIO_154_GPIO154                   0x02101400U
#define GPIO_154_EPWM5_B                   0x02101401U
#define GPIO_154_PMBUSA_CTL                0x02101406U

#define GPIO_155_GPIO155                   0x02101600U
#define GPIO_155_EPWM6_A                   0x02101601U

#define GPIO_156_GPIO156                   0x02101800U
#define GPIO_156_EPWM6_B                   0x02101801U

#define GPIO_157_GPIO157                   0x02101A00U
#define GPIO_157_EPWM7_A                   0x02101A01U

#define GPIO_158_GPIO158                   0x02101C00U
#define GPIO_158_EPWM7_B                   0x02101C01U

#define GPIO_159_GPIO159                   0x02101E00U
#define GPIO_159_EPWM8_A                   0x02101E01U

#define GPIO_160_GPIO160                   0x028C0000U
#define GPIO_160_EPWM8_B                   0x028C0001U

#define GPIO_161_GPIO161                   0x028C0200U
#define GPIO_161_EPWM9_A                   0x028C0201U

#define GPIO_162_GPIO162                   0x028C0400U
#define GPIO_162_EPWM9_B                   0x028C0401U

#define GPIO_163_GPIO163                   0x028C0600U
#define GPIO_163_EPWM10_A                  0x028C0601U

#define GPIO_164_GPIO164                   0x028C0800U
#define GPIO_164_EPWM10_B                  0x028C0801U

#define GPIO_165_GPIO165                   0x028C0A00U
#define GPIO_165_EPWM11_A                  0x028C0A01U

#define GPIO_166_GPIO166                   0x028C0C00U
#define GPIO_166_EPWM11_B                  0x028C0C01U

#define GPIO_167_GPIO167                   0x028C0E00U
#define GPIO_167_EPWM12_A                  0x028C0E01U

#define GPIO_168_GPIO168                   0x028C1000U
#define GPIO_168_EPWM12_B                  0x028C1001U

#define GPIO_198_GPIO198                   0x030C0C00U
#define GPIO_198_EQEP1_A                   0x030C0C01U
#define GPIO_198_EPWM9_B                   0x030C0C02U
#define GPIO_198_SPIA_PICO                 0x030C0C03U

#define GPIO_199_GPIO199                   0x030C0E00U
#define GPIO_199_EQEP1_STROBE              0x030C0E01U
#define GPIO_199_EPWM17_A                  0x030C0E02U
#define GPIO_199_SCIB_TX                   0x030C0E03U
#define GPIO_199_EPWM12_A                  0x030C0E05U
#define GPIO_199_SPIB_CLK                  0x030C0E06U
#define GPIO_199_SD1_D4                    0x030C0E07U
#define GPIO_199_CANC_TX                   0x030C0E09U
#define GPIO_199_SPIC_CLK                  0x030C0E0EU

#define GPIO_200_GPIO200                   0x030C1000U
#define GPIO_200_EQEP1_INDEX               0x030C1001U
#define GPIO_200_EPWM17_B                  0x030C1002U
#define GPIO_200_SCIB_RX                   0x030C1003U
#define GPIO_200_EPWM12_B                  0x030C1005U
#define GPIO_200_SPIB_PTE                  0x030C1006U
#define GPIO_200_SD1_C4                    0x030C1007U
#define GPIO_200_CANC_RX                   0x030C1009U
#define GPIO_200_SPIC_PTE                  0x030C100EU

#define GPIO_201_GPIO201                   0x030C1200U
#define GPIO_201_OUTPUTXBAR1               0x030C1201U
#define GPIO_201_EQEP2_A                   0x030C1202U
#define GPIO_201_EPWM18_A                  0x030C1203U
#define GPIO_201_LINB_TX                   0x030C1205U
#define GPIO_201_SPIB_PICO                 0x030C1206U
#define GPIO_201_SD2_D1                    0x030C1207U
#define GPIO_201_PMBUSA_SCL                0x030C1209U
#define GPIO_201_FSMC_NBL0                 0x030C120AU
#define GPIO_201_EPWM13_A                  0x030C120DU

#define GPIO_202_GPIO202                   0x030C1400U
#define GPIO_202_OUTPUTXBAR2               0x030C1401U
#define GPIO_202_EQEP2_B                   0x030C1402U
#define GPIO_202_EPWM18_B                  0x030C1403U
#define GPIO_202_LINB_RX                   0x030C1405U
#define GPIO_202_SPIB_POCI                 0x030C1406U
#define GPIO_202_SD2_C1                    0x030C1407U
#define GPIO_202_PMBUSA_SDA                0x030C1409U
#define GPIO_202_FSMC_NBL1                 0x030C140AU
#define GPIO_202_EPWM13_B                  0x030C140DU

#define GPIO_203_GPIO203                   0x030C1600U
#define GPIO_203_OUTPUTXBAR3               0x030C1601U
#define GPIO_203_EQEP2_INDEX               0x030C1602U
#define GPIO_203_SPIA_POCI                 0x030C1603U
#define GPIO_203_SPIB_CLK                  0x030C1606U
#define GPIO_203_SD3_D1                    0x030C1607U
#define GPIO_203_PMBUSA_ALERT              0x030C1609U
#define GPIO_203_EPWM14_A                  0x030C160DU
#define GPIO_203_EPWM8_B                   0x030C160FU

#define GPIO_204_GPIO204                   0x030C1800U
#define GPIO_204_OUTPUTXBAR4               0x030C1801U
#define GPIO_204_EQEP2_STROBE              0x030C1802U
#define GPIO_204_SPIA_CLK                  0x030C1803U
#define GPIO_204_SPIB_PTE                  0x030C1806U
#define GPIO_204_SD2_C2                    0x030C1807U
#define GPIO_204_PMBUSA_CTL                0x030C1809U
#define GPIO_204_EPWM14_B                  0x030C180DU
#define GPIO_204_SD1_D3                    0x030C180FU

#define GPIO_205_GPIO205                   0x030C1A00U
#define GPIO_205_EQEP1_INDEX               0x030C1A01U
#define GPIO_205_EPWM10_A                  0x030C1A02U
#define GPIO_205_SPIA_PTE                  0x030C1A03U
#define GPIO_205_OUTPUTXBAR1               0x030C1A0BU
#define GPIO_205_SD1_C3                    0x030C1A0FU

#define GPIO_206_GPIO206                   0x030C1C00U
#define GPIO_206_FSMC_A13                  0x030C1C01U
#define GPIO_206_EPWM10_B                  0x030C1C02U
#define GPIO_206_FSMC_NWE                  0x030C1C03U
#define GPIO_206_OUTPUTXBAR2               0x030C1C0BU

#define GPIO_207_GPIO207                   0x030C1E00U
#define GPIO_207_EQEP2_A                   0x030C1E01U
#define GPIO_207_EPWM11_A                  0x030C1E02U
#define GPIO_207_EXTSYNCOUT                0x030C1E03U
#define GPIO_207_CANA_TX                   0x030C1E05U
#define GPIO_207_SD4_D1                    0x030C1E06U
#define GPIO_207_SCIA_RX                   0x030C1E07U
#define GPIO_207_LINA_RX                   0x030C1E09U
#define GPIO_207_I2CB_SCL                  0x030C1E0AU
#define GPIO_207_OUTPUTXBAR3               0x030C1E0BU
#define GPIO_207_PMBUSA_ALERT              0x030C1E0FU

#define GPIO_208_GPIO208                   0x03100000U
#define GPIO_208_EQEP2_B                   0x03100001U
#define GPIO_208_EPWM11_B                  0x03100002U
#define GPIO_208_FSMC_D13                  0x03100003U
#define GPIO_208_SPIB_PICO                 0x03100005U
#define GPIO_208_SD4_C1                    0x03100006U
#define GPIO_208_SCIA_TX                   0x03100007U
#define GPIO_208_OUTPUTXBAR4               0x0310000BU
#define GPIO_208_PMBUSA_CTL                0x0310000FU

#define GPIO_209_GPIO209                   0x03100200U
#define GPIO_209_EQEP2_STROBE              0x03100201U
#define GPIO_209_EPWM12_A                  0x03100202U
#define GPIO_209_FSMC_D14                  0x03100203U
#define GPIO_209_SPIB_POCI                 0x03100205U
#define GPIO_209_SD4_D2                    0x03100206U
#define GPIO_209_EPWM12_B                  0x03100207U
#define GPIO_209_LINB_RX                   0x0310020AU
#define GPIO_209_OUTPUTXBAR5               0x0310020BU
#define GPIO_209_PMBUSA_SDA                0x0310020FU

#define GPIO_210_GPIO210                   0x03100400U
#define GPIO_210_EQEP2_INDEX               0x03100401U
#define GPIO_210_EPWM12_B                  0x03100402U
#define GPIO_210_FSMC_D15                  0x03100403U
#define GPIO_210_SD4_C2                    0x03100406U
#define GPIO_210_LINB_TX                   0x0310040AU
#define GPIO_210_OUTPUTXBAR6               0x0310040BU
#define GPIO_210_PMBUSA_SCL                0x0310040FU

#define GPIO_211_GPIO211                   0x03100600U
#define GPIO_211_EQEP6_A                   0x03100601U
#define GPIO_211_EPWM14_A                  0x03100602U
#define GPIO_211_SD4_D3                    0x03100606U
#define GPIO_211_OUTPUTXBAR7               0x0310060BU

#define GPIO_212_GPIO212                   0x03100800U
#define GPIO_212_EQEP6_B                   0x03100801U
#define GPIO_212_EPWM14_B                  0x03100802U
#define GPIO_212_SD4_C3                    0x03100806U

#define GPIO_213_GPIO213                   0x03100A00U
#define GPIO_213_EQEP6_STROBE              0x03100A01U
#define GPIO_213_EPWM8_A                   0x03100A02U
#define GPIO_213_SD4_D4                    0x03100A06U
#define GPIO_213_LINB_TX                   0x03100A0AU

#define GPIO_214_GPIO214                   0x03100C00U
#define GPIO_214_CANA_RX                   0x03100C01U
#define GPIO_214_FSMC_CLK                  0x03100C02U
#define GPIO_214_CANC_RX                   0x03100C03U
#define GPIO_214_OUTPUTXBAR7               0x03100C05U
#define GPIO_214_EQEP3_STROBE              0x03100C06U
#define GPIO_214_SD2_D4                    0x03100C07U
#define GPIO_214_FSMC_NE4                 0x03100C09U
#define GPIO_214_EPWM16_A                  0x03100C0DU
#define GPIO_214_SPID_PICO                 0x03100C0FU

#define GPIO_215_GPIO215                   0x03100E00U
#define GPIO_215_SCIA_RX                   0x03100E01U
#define GPIO_215_FSMC_NE4                  0x03100E02U
#define GPIO_215_CANA_RX                   0x03100E03U
#define GPIO_215_OUTPUTXBAR5               0x03100E05U
#define GPIO_215_EQEP3_A                   0x03100E06U
#define GPIO_215_SD2_D3                    0x03100E07U
#define GPIO_215_FSMC_NE3                  0x03100E09U
#define GPIO_215_I2CB_SDA                  0x03100E0AU
#define GPIO_215_EPWM15_A                  0x03100E0DU
#define GPIO_215_LINA_TX                   0x03100E0EU
#define GPIO_215_FSMC_D12                  0x03100E0FU

#define GPIO_216_GPIO216                   0x03101000U
#define GPIO_216_SCIA_TX                   0x03101001U
#define GPIO_216_FSMC_SDCKE                0x03101002U
#define GPIO_216_SPID_CLK                  0x03101003U
#define GPIO_216_OUTPUTXBAR6               0x03101005U
#define GPIO_216_EQEP3_B                   0x03101006U
#define GPIO_216_SD2_C3                    0x03101007U
#define GPIO_216_FSMC_NE2                  0x03101009U
#define GPIO_216_EPWM15_B                  0x0310100DU
#define GPIO_216_FSMC_D13                  0x0310100FU

#define GPIO_217_GPIO217                   0x03101200U
#define GPIO_217_CANA_TX                   0x03101201U
#define GPIO_217_FSMC_NWE                  0x03101202U
#define GPIO_217_CANC_TX                   0x03101203U
#define GPIO_217_OUTPUTXBAR8               0x03101205U
#define GPIO_217_EQEP3_INDEX               0x03101206U
#define GPIO_217_SD2_C4                    0x03101207U
#define GPIO_217_FSMC_RNW                  0x03101209U
#define GPIO_217_I2CA_SDA                  0x0310120AU
#define GPIO_217_SPID_PTE                  0x0310120BU
#define GPIO_217_EPWM16_B                  0x0310120DU
#define GPIO_217_LINB_TX                   0x0310120EU
#define GPIO_217_SPID_POCI                 0x0310120FU

#define GPIO_218_GPIO218                   0x03101400U
#define GPIO_218_I2CA_SDA                  0x03101401U
#define GPIO_218_FSMC_NE1                  0x03101402U
#define GPIO_218_SPIA_PICO                 0x03101403U
#define GPIO_218_EQEP4_A                   0x03101405U
#define GPIO_218_LINB_TX                   0x03101406U
#define GPIO_218_CLB_OUTPUTXBAR1           0x03101407U
#define GPIO_218_FSMC_NOE                  0x03101409U
#define GPIO_218_I2CA_SCL                  0x0310140AU
#define GPIO_218_SPID_CLK                  0x0310140FU

#define GPIO_219_GPIO219                   0x03101600U
#define GPIO_219_EQEP6_INDEX               0x03101601U
#define GPIO_219_EPWM8_B                   0x03101602U
#define GPIO_219_SD4_C4                    0x03101606U

#define GPIO_220_GPIO220                   0x03101800U
#define GPIO_220_EPWM6_A                   0x03101802U
#define GPIO_220_SPID_POCI                 0x03101803U
#define GPIO_220_OUTPUTXBAR2               0x03101805U
#define GPIO_220_SCIB_TX                   0x03101806U
#define GPIO_220_CANC_TX                   0x03101807U
#define GPIO_220_PMBUSA_ALERT              0x0310180FU

#define GPIO_221_GPIO221                   0x03101A00U
#define GPIO_221_EPWM6_B                   0x03101A02U
#define GPIO_221_SPID_PTE                  0x03101A03U
#define GPIO_221_OUTPUTXBAR3               0x03101A05U
#define GPIO_221_SCIB_RX                   0x03101A06U
#define GPIO_221_CANC_RX                   0x03101A07U
#define GPIO_221_PMBUSA_CTL                0x03101A0FU

#define GPIO_222_GPIO222                   0x03101C00U
#define GPIO_222_TDI                       0x03101C01U
#define GPIO_222_EPWM7_A                   0x03101C02U
#define GPIO_222_SPIA_PICO                 0x03101C03U
#define GPIO_222_OUTPUTXBAR4               0x03101C05U
#define GPIO_222_SCIA_RX                   0x03101C06U
#define GPIO_222_SCIF_TX                   0x03101C07U
#define GPIO_222_I2CA_SDA                  0x03101C09U
#define GPIO_222_SPIC_CLK                  0x03101C0AU
#define GPIO_222_PMBUSA_SDA                0x03101C0FU

#define GPIO_223_GPIO223                   0x03101E00U
#define GPIO_223_TDO                       0x03101E01U
#define GPIO_223_EPWM7_B                   0x03101E02U
#define GPIO_223_FSMC_A13                  0x03101E03U
#define GPIO_223_OUTPUTXBAR5               0x03101E05U
#define GPIO_223_SCIA_TX                   0x03101E06U
#define GPIO_223_SCIF_RX                   0x03101E07U
#define GPIO_223_I2CA_SCL                  0x03101E09U
#define GPIO_223_SPIC_PTE                  0x03101E0AU
#define GPIO_223_PMBUSA_SCL                0x03101E0FU

#define GPIO_224_GPIO224                   0x038C0000U
#define GPIO_224_ERRORSTS                  0x038C0001U
#define GPIO_224_FSMC_SDCKE                0x038C0002U
#define GPIO_224_XCLKOUT                   0x038C0003U
#define GPIO_224_OUTPUTXBAR1               0x038C0005U
#define GPIO_224_SD2_C1                    0x038C000DU

#define GPIO_225_GPIO225                0x038C0200U

#define GPIO_226_GPIO226                0x038C0400U

#define GPIO_227_GPIO227                0x038C0600U

#define GPIO_228_GPIO228                0x038C0800U

#define GPIO_229_GPIO229                0x038C0A00U

#define GPIO_230_GPIO230                0x038C0C00U

#define GPIO_231_GPIO231                0x038C0E00U

#define GPIO_232_GPIO232                0x038C1000U

#define GPIO_233_GPIO233                0x038C1200U

#define GPIO_234_GPIO234                0x038C1400U

#define GPIO_235_GPIO235                0x038C1600U

#define GPIO_236_GPIO236                0x038C1800U

#define GPIO_237_GPIO237                0x038C1A00U

#define GPIO_238_GPIO238                0x038C1C00U

#define GPIO_239_GPIO239                0x038C1E00U

#define GPIO_240_GPIO240                0x03900000U

#define GPIO_241_GPIO241                0x03900200U

#define GPIO_242_GPIO242                0x03900400U

#endif

#endif /* IS_GS32F3xx() */

#ifdef __cplusplus
}
#endif

#endif /* PINMAP_GS32F3xx_H_ */

