/* ========================================================================== */
/**
*   @file    regs_apb_comm_para.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the script to generate]
*
*/
/* ========================================================================== */
/**
 *  Copyright (C) Gejian Semiconductors 2023
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 * 
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 * 
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 * 
 *    Neither the name of Gejian Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/* ========================================================================== */

#ifndef REGS_APB_COMM_PARA_H
#define REGS_APB_COMM_PARA_H

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/*
 * commit history
 *
 * 20240927, Zhengyulong, Add suport SPI for 2.2 in lines 83-93,
 */

// APB_COMM_PARA Individual Register Bit Definitions:

//
// SPI master
//
struct SPI_MASTER_MODE_BITS {			// bits   description
	uint32_t	SPIA_MASTER_MODE:1;			// 0:0   
	uint32_t	rsvd1:3;			// 3:1   Reserved
	uint32_t	SPIB_MASTER_MODE:1;			// 4:4   
#if IS_GS32F00xx(0x12)
	uint32_t	rsvd2:27;			// 31:5   Reserved
#elif IS_GS32F3xx(0x22)
	uint32_t	rsvd2:3;			// 7:5 Reserved
	uint32_t	SPIC_MASTER_MODE:1;	// 8:8
	uint32_t	rsvd3:3;			// 11:9   Reserved
	uint32_t	SPID_MASTER_MODE:1;	// 12:12
	uint32_t	rsvd4:3;			// 15:13   Reserved
	uint32_t	CMSPI_MASTER_MODE:1;// 16:16
	uint32_t	rsvd5:15;			// 31:17   Reserved
#endif
};

union SPI_MASTER_MODE_REG {
	uint32_t 		 all;
	struct SPI_MASTER_MODE_BITS 		 bit;
};

//
// can fd
//
struct CAN_FD_ENABLE_BITS {			// bits   description
	uint32_t	CANA_FD_ENABLE:1;			// 0:0   
	uint32_t	rsvd1:3;			// 3:1   Reserved
	uint32_t	CANB_FD_ENABLE:1;			// 4:4
	uint32_t	rsvd2:27;			// 31:5   Reserved
};

union CAN_FD_ENABLE_REG {
	uint32_t 		 all;
	struct CAN_FD_ENABLE_BITS 		 bit;
};

//
// CAN0 HOST
//
struct CAN0_HOST_IF_BITS {			// bits   description
	uint32_t	CANA_HOST_IF:19;			// 18:0
	uint32_t	rsvd1:13;			// 31:19   Reserved
};

union CAN0_HOST_IF_REG {
	uint32_t 		 all;
	struct CAN0_HOST_IF_BITS 		 bit;
};

//
// CAN1 HOST IF
//
struct CAN1_HOST_IF_BITS {			// bits   description
	uint32_t	CANB_HOST_IF:19;			// 18:0
	uint32_t	rsvd1:13;			// 31:19   Reserved
};

union CAN1_HOST_IF_REG {
	uint32_t 		 all;
	struct CAN1_HOST_IF_BITS 		 bit;
};

//
// Timer
//
struct TIMER_HALT1_BITS {			// bits   description
	uint32_t	TIMER_DEBUG_STOP_MASK0:2;			// 1:0
	uint32_t	rsvd1:30;			// 31:2   Reserved
};

union TIMER_HALT1_REG {
	uint32_t 		 all;
	struct TIMER_HALT1_BITS 		 bit;
};

//
// Timer
//
struct TIMER_HALT2_BITS {			// bits   description
	uint32_t	TIMER_DEBUG_STOP_MASK1:2;			// 1:0
	uint32_t	rsvd1:30;			// 31:2   Reserved
};

union TIMER_HALT2_REG {
	uint32_t 		 all;
	struct TIMER_HALT2_BITS 		 bit;
};

//
// Timer
//
struct TIMER_HALT3_BITS {			// bits   description
	uint32_t	TIMER_DEBUG_STOP_MASK2:2;			// 1:0
	uint32_t	rsvd1:30;			// 31:2   Reserved
};

union TIMER_HALT3_REG {
	uint32_t 		 all;
	struct TIMER_HALT3_BITS 		 bit;
};

//
// Timer
//
struct TIMER_HALT4_BITS {			// bits   description
	uint32_t	TIMER_DEBUG_STOP_MASK3:2;			// 1:0
	uint32_t	rsvd1:30;			// 31:2   Reserved
};

union TIMER_HALT4_REG {
	uint32_t 		 all;
	struct TIMER_HALT4_BITS 		 bit;
};


// APB_COMM_PARA Register Definitions:

struct APB_COMM_PARA_REGS {
	union  SPI_MASTER_MODE_REG			SPI_MASTER_MODE;
	uint32_t 						rsvd1[7]; 		 // Reserved
	union  CAN_FD_ENABLE_REG			CAN_FD_ENABLE;
	union  CAN0_HOST_IF_REG			CAN0_HOST_IF;
	union  CAN1_HOST_IF_REG			CAN1_HOST_IF;
	uint32_t 						rsvd2; 		 // Reserved
	uint32_t  						APB_MEM_CTRL;
	uint32_t  						APB_MEM_PWR_CTRL;
	uint32_t 						rsvd3[3]; 		 // Reserved
	union  TIMER_HALT1_REG			TIMER_HALT1;
	union  TIMER_HALT2_REG			TIMER_HALT2;
	union  TIMER_HALT3_REG			TIMER_HALT3;
	union  TIMER_HALT4_REG			TIMER_HALT4;
};


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

// APB_COMM_PARA External References & Function Declarations

extern volatile struct APB_COMM_PARA_REGS ApbCommParaRegs;

/**
 * \brief   "add brief description of this function"
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif      /* extern "C" */


#endif      // end of REGS_APB_COMM_PARA_H definition

/* ========================================================================== */
/*                                  End of file                               */
/* ========================================================================== */
