/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_crc.h
*   @brief   
*   [note: This file is automatically generated and does not need to be
*   manually edited. If you want to modify it, use the py script to generate]
*
*   commit history
*   2024/03/07, Xu Haoze, add bit field registers of CRC in version 1.2 and 2.2.
*
*/

#ifndef REGS_CRC_H
#define REGS_CRC_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "inc/hw_crc.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// CRC Individual Register Bit Definitions:

struct CRC_DR_BITS {			// bits   description
	uint32_t	DR:32;			// 31:0   Data register bits
};

union CRC_DR_REG {
	uint32_t 		 all;
	struct CRC_DR_BITS 		 bit;
};

struct CRC_RESULT_BITS {			// bits   description
	uint32_t	CRC_getResult:32;			// 31:0   Last CRC result
};

union CRC_RESULT_REG {
	uint32_t 		 all;
	struct CRC_RESULT_BITS 		 bit;
};

#if (CRC_VERSION == 100)
struct CRC_CR_BITS {			// bits   description
	uint32_t	RESET:1;			// 0:0   RESET bit
	uint32_t	rsvd1:1;			// 1:1   reserved
	uint32_t	POLYSIZE:3;			// 4:2   Polynomial size
	uint32_t	REV_IN:2;			// 6:5   Reverse input data
	uint32_t	REV_OUT:1;			// 7:7   Reverse output data
	uint32_t	rsvd2:24;			// 31:8   reserved
};
#elif (CRC_VERSION == 110)
struct CRC_CR_BITS {
	uint32_t	RESET:1;			// 0:0   RESET bit
	uint32_t	TX_RX_CFG:1;		// 1:1   Configure CRC is currently used in TX mode or RX mode
	uint32_t	POLYSIZE:3;			// 4:2   Polynomial size
	uint32_t	REV_IN:2;			// 6:5   Reverse input data
	uint32_t	REV_OUT:1;			// 7:7   Reverse output data
	uint32_t	rsvd1:24;			// 31:8   reserved
};
#else

#endif

union CRC_CR_REG {
	uint32_t 		 all;
	struct CRC_CR_BITS 		 bit;
};

struct CRC_INIT_BITS {			// bits   description
	uint32_t	CRC_INIT:32;			// 31:0   Programmable initial CRC value
};

union CRC_INIT_REG {
	uint32_t 		 all;
	struct CRC_INIT_BITS 		 bit;
};

struct CRC_POL_BITS {			// bits   description
	uint32_t	POL:32;			// 31:0   Programmable polynomial
};

union CRC_POL_REG {
	uint32_t 		 all;
	struct CRC_POL_BITS 		 bit;
};

struct CRC_EN_BITS {			// bits   description
	uint32_t	START:1;			// 0:0   Write a "1" to start CRC calculation.
	uint32_t	rsvd1:29;			// 29:1   reserved
	uint32_t	FMAT_READY:1;			// 30:30   F matrix ready
	uint32_t	RUN_STS:1;			// 31:31   Status bit:
};

union CRC_EN_REG {
	uint32_t 		 all;
	struct CRC_EN_BITS 		 bit;
};

struct CRC_LEN_BITS {			// bits   description
	uint32_t	CRC_LENGTH:32;			// 31:0   Length of CRC calcuation. Basic unit depends on the CRC size set by CRC_CR.POLYSIZE
};

union CRC_LEN_REG {
	uint32_t 		 all;
	struct CRC_LEN_BITS 		 bit;
};

struct CRC_GOLDEN_BITS {			// bits   description
	uint32_t	CRC_GOLDEN:32;			// 31:0   Golden CRC register:
};

union CRC_GOLDEN_REG {
	uint32_t 		 all;
	struct CRC_GOLDEN_BITS 		 bit;
};

#if (CRC_VERSION == 100)
struct CRC_INTEN_BITS {			// bits   description
	uint32_t	rsvd1:1;			// 0:0   reserved
	uint32_t	INTEN_CRC_DONE:1;			// 1:1   0 TEST_DONE Interrupt disabled
	uint32_t	INTEN_CRC_FAIL:1;			// 2:2   0 CRC_FAIL Interrupt disabled
	uint32_t	rsvd2:29;			// 31:3   reserved
};

union CRC_INTEN_REG {
	uint32_t 		 all;
	struct CRC_INTEN_BITS 		 bit;
};

struct CRC_INTFLG_BITS {			// bits   description
	uint32_t	INTFLG_INT:1;		// 0:0   Global Interrupt Status flag
	uint32_t	INTFLG_CRC_DONE:1;	// 1:1   Done Interrupt Status flag
	uint32_t	INTFLG_CRC_FAIL:1;	// 2:2   CRC fail interrupt
	uint32_t	rsvd1:29;			// 31:3   reserved
};

union CRC_INTFLG_REG {
	uint32_t 		 all;
	struct CRC_INTFLG_BITS 		 bit;
};

struct CRC_INTCLR_BITS {			// bits   description
	uint32_t	INTCLR_INT:1;		// 0:0   Global Interrupt Clear
	uint32_t	INTCLR_CRC_DONE:1;	// 1:1   Clear interrupt flag
	uint32_t	INTCLR_CRC_FAIL:1;	// 2:2   Clear interrupt flag
	uint32_t	rsvd1:29;			// 31:3   reserved
};

union CRC_INTCLR_REG {
	uint32_t 		 all;
	struct CRC_INTCLR_BITS 		 bit;
};

struct CRC_INTFRC_BITS {			// bits   description
	uint32_t	rsvd1:1;			// 0:0   reserved
	uint32_t	INTFRC_CRC_DONE:1;	// 1:1   Force interrupt flag
	uint32_t	INTFRC_CRC_FAIL:1;	// 2:2   Force interrupt flag
	uint32_t	rsvd2:29;			// 31:3   reserved
};

union CRC_INTFRC_REG {
	uint32_t 		 all;
	struct CRC_INTFRC_BITS 		 bit;
};
#elif (CRC_VERSION == 110)
struct CRC_INTR_RAW_BITS {			// bits   description
	uint32_t INTR_RAW_DONE:1;		// 0:0	 CRC done raw interrupt
	uint32_t INTR_RAW_FAIL:1;		// 1:1	 CRC fail raw interrupt
	uint32_t rsvd1:30;				// 31:2	 reserved
};

union CRC_INTR_RAW_REG {
	uint32_t all;
	struct CRC_INTR_RAW_BITS bit;	
};

struct CRC_INTR_MASK_BITS {			// bits   description
	uint32_t INTR_MASK_DONE:1;		// 0:0	 CRC done interrupt mask
	uint32_t INTR_MASK_FAIL:1;		// 1:1	 CRC fail interrupt mask
	uint32_t rsvd1:30;				// 31:2	 reserved
};

union CRC_INTR_MASK_REG {
	uint32_t all;
	struct CRC_INTR_MASK_BITS bit;	
};

struct CRC_INTR_BITS {				// bits   description
	uint32_t INTR_CRC_DONE:1;		// 0:0	 CRC done interrupt mask
	uint32_t INTR_CRC_FAIL:1;		// 1:1	 CRC fail interrupt mask
	uint32_t rsvd1:30;				// 31:2	 reserved
};

union CRC_INTR_REG {
	uint32_t all;
	struct CRC_INTR_BITS bit;	
};

struct CRC_INTFRC_BITS {			// bits   description
	uint32_t INTFRC_CRC_DONE:1;		// 0:0	 CRC done interrupt force
	uint32_t INTFRC_CRC_FAIL:1;		// 1:1	 CRC fail interrupt force
	uint32_t rsvd1:30;				// 31:2	 reserved
};

union CRC_INTFRC_REG {
	uint32_t all;
	struct CRC_INTFRC_BITS bit;	
};

struct CRC_LOCK_BITS {				// bits   description
	uint32_t REGSLOCK:32;			// 31:0	 CRC lock register
};

union CRC_LOCK_REG {
	uint32_t all;
	struct CRC_LOCK_BITS bit;	
};

#endif


// CRC Register Definitions:
#if (CRC_VERSION == 100)
struct CRC_REGS {
	union  CRC_DR_REG			CRC_DR;
	union  CRC_RESULT_REG		CRC_getResult;
	union  CRC_CR_REG			CRC_CR;
	union  CRC_INIT_REG			CRC_INIT;
	union  CRC_POL_REG			CRC_POL;
	union  CRC_EN_REG			CRC_EN;
	union  CRC_LEN_REG			CRC_LEN;
	union  CRC_GOLDEN_REG		CRC_GOLDEN;
	union  CRC_INTEN_REG		CRC_INTEN;
	union  CRC_INTFLG_REG		CRC_INTFLG;
	union  CRC_INTCLR_REG		CRC_INTCLR;
	union  CRC_INTFRC_REG		CRC_INTFRC;
};

#elif (CRC_VERSION == 110)
struct CRC_REGS {
	union  CRC_DR_REG			CRC_DR;
	union  CRC_RESULT_REG		CRC_getResult;
	union  CRC_CR_REG			CRC_CR;
	union  CRC_INIT_REG			CRC_INIT;
	union  CRC_POL_REG			CRC_POL;
	union  CRC_EN_REG			CRC_EN;
	union  CRC_LEN_REG			CRC_LEN;
	union  CRC_GOLDEN_REG		CRC_GOLDEN;
	union  CRC_INTR_RAW_REG		CRC_INTER_RAW;
	union  CRC_INTR_MASK_REG	CRC_INTR_MASK;
	union  CRC_INTR_REG			CRC_INTR;
	union  CRC_INTFRC_REG		CRC_INTFRC;
	union  CRC_LOCK_REG			CRC_LOCK;
};

#endif

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// CRC External References & Function Declarations

extern volatile struct CRC_REGS crcRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_CRC_H definition
