/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_dmamux.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_DMAMUX_H
#define REGS_DMAMUX_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

#if (DMAMUX_VERSION == 0x20 || DMAMUX_VERSION == 0x11)
struct DmaMux_Ccr
{
    // DMA request identification
    // Selects the input DMA request. See the DMAMUX table about assignments of multiplexer
    // inputs to resources.
    uint32_t    dmareq_id:7;   //6:0
    uint32_t    rsvd3:1;       //7
    // Synchronization overrun interrupt enable
    // 0: interrupt disabled
    // 1: interrupt enabled
    uint32_t    soie:1;        //8
    // Event generation enable
    // 0: event generation disabled
    // 1: event generation enabled
    uint32_t    ege:1;         //9
    uint32_t    rsvd2:6;       //15:10
    // Synchronization enable
    // 0: synchronization disabled
    // 1: synchronization enabled
    uint32_t    se:1;          //16
    // Synchronization polarity
    // Defines the edge polarity of the selected synchronization input:
    // 00: no event, i.e. no synchronization nor detection.
    // 01: rising edge
    // 10: falling edge
    // 11: rising and falling edge
    uint32_t    spol:2;        //18:17
    // Number of DMA requests minus 1 to forward
    // Defines the number of DMA requests to forward to the DMA controller after a synchronization
    // event, and/or the number of DMA requests before an output event is generated.
    // This field shall only be written when both SE and EGE bits are low.
    uint32_t    nbreq:5;       //23:19
    // Synchronization identification
    // Selects the synchronization input (see ).
    uint32_t    sync_id:6;     //29:24
    uint32_t    rsvd1:2;       //31:30
};

union DMAMUX_CCR_REG {
    uint32_t          all;
    struct DmaMux_Ccr          bit;
};

struct DmaMux_Rgcr
{
    // Signal identification
    // Selects the DMA request trigger input used for the channel x of the DMA request generator
    uint32_t    sig_id:7;      //6:0
    uint32_t    rsvd3:1;       //7
    // Trigger overrun interrupt enable
    // 0: interrupt on a trigger overrun event occurrence is disabled
    // 1: interrupt on a trigger overrun event occurrence is enabled
    uint32_t    oie:1;         //8
    uint32_t    rsvd2:7;       //15:9
    // DMA request generator channel x enable
    // 0: DMA request generator channel x disabled
    // 1: DMA request generator channel x enabled
    uint32_t    ge:1;          //16
    // DMA request generator trigger polarity
    // Defines the edge polarity of the selected trigger input
    // 00: no event. I.e. none trigger detection nor generation.
    // 01: rising edge
    // 10: falling edge
    // 11: rising and falling edge
    uint32_t    gpol:2;        //18:17
    // Number of DMA requests to be generated (minus 1)
    // Defines the number of DMA requests to be generated after a trigger event. The actual
    // number of generated DMA requests is GNBREQ +1.
    // Note: This field shall only be written when GE bit is disabled
    uint32_t    gnbreq:5;      //23:19
    uint32_t    rsvd1:8;       //31:24
};

union DMAMUX_RGCR_REG {
    uint32_t          all;
    struct DmaMux_Rgcr          bit;
};

#else

struct DmaMux_Ccr
{
    // DMA request identification
    // Selects the input DMA request. See the DMAMUX table about assignments of multiplexer
    // inputs to resources.
    uint32_t    dmareq_id:7;   //6:0
    uint32_t    rsvd3:2;       //8:7
    // Event generation enable
    // 0: event generation disabled
    // 1: event generation enabled
    uint32_t    ege:1;         //9
    uint32_t    rsvd2:6;       //15:10
    // Synchronization enable
    // 0: synchronization disabled
    // 1: synchronization enabled
    uint32_t    se:1;          //16
    // Synchronization polarity
    // Defines the edge polarity of the selected synchronization input:
    // 00: no event, i.e. no synchronization nor detection.
    // 01: rising edge
    // 10: falling edge
    // 11: rising and falling edge
    uint32_t    spol:2;        //18:17
    // Number of DMA requests minus 1 to forward
    // Defines the number of DMA requests to forward to the DMA controller after a synchronization
    // event, and/or the number of DMA requests before an output event is generated.
    // This field shall only be written when both SE and EGE bits are low.
    uint32_t    nbreq:5;       //23:19
    // Synchronization identification
    // Selects the synchronization input (see ).
    uint32_t    sync_id:6;     //29:24
    uint32_t    rsvd1:2;       //31:30
};

union DMAMUX_CCR_REG {
    uint32_t          all;
    struct DmaMux_Ccr          bit;
};

struct DmaMux_Rgcr
{
    // Signal identification
    // Selects the DMA request trigger input used for the channel x of the DMA request generator
    uint32_t    sig_id:7;      //6:0
    uint32_t    rsvd3:2;       //8:7
    uint32_t    rsvd2:7;       //15:9
    // DMA request generator channel x enable
    // 0: DMA request generator channel x disabled
    // 1: DMA request generator channel x enabled
    uint32_t    ge:1;          //16
    // DMA request generator trigger polarity
    // Defines the edge polarity of the selected trigger input
    // 00: no event. I.e. none trigger detection nor generation.
    // 01: rising edge
    // 10: falling edge
    // 11: rising and falling edge
    uint32_t    gpol:2;        //18:17
    // Number of DMA requests to be generated (minus 1)
    // Defines the number of DMA requests to be generated after a trigger event. The actual
    // number of generated DMA requests is GNBREQ +1.
    // Note: This field shall only be written when GE bit is disabled
    uint32_t    gnbreq:12;      //30:19
    uint32_t    rsvd1:1;       //31
};

union DMAMUX_RGCR_REG {
    uint32_t          all;
    struct DmaMux_Rgcr          bit;
};

#endif /* #if (DMAMUX_VERSION == 0x20 || DMAMUX_VERSION == 0x11) */



#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_DMAMUX_H definition
