/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_eflash.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_EFLASH_H
#define REGS_EFLASH_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// EFLASH Individual Register Bit Definitions:

struct FLASH_CONTROL_REG_BITS {			// bits   description
	uint32_t	SLP_MODE:1;			// 0:0   Sleep mode, active high. Directly drives the SLM signal to the flash
	uint32_t	WRITE_PROTECT:1;			// 1:1   Register write protect, active high
	uint32_t	rsvd1:1;			// 2:2   reserved
	uint32_t	ERASE:1;			// 3:3   Erase. Write-only.
	uint32_t	ERASE_PAGE:1;			// 4:4   Erase page. Write-only.
	uint32_t	PROGRAM_START:1;			// 5:5   Program start.Write-only
	uint32_t	ERASE_REFERENCE_CELL:1;			// 6:6   Erase reference cell. Write-only.
	uint32_t	RECALL_TRIM_CODE:1;			// 7:7   Recall trim code. Write-only.
	uint32_t	PROGRAM_END:1;			// 8:8   Program end.Write-only
	uint32_t	ERROR_INDICATE:1;			// 9:9   Indicates an error on mem_hresp if an uncorrectable error is detected by ECC logic. 
	uint32_t	WRITE_COMP_INTR_ENABLE:1;			// 10:10   Write complete interrupt enable.
	uint32_t	ECC_INTR_ENABLE:1;			// 11:11   Error corrected interrupt enable.
	uint32_t	DED_INTR_ENABLE:1;			// 12:12   Error detected interrupt enable.
	uint32_t	START_TRIM:1;			// 13:13   Start Trimming to eFlash through parallel trim code. Write-only.
	uint32_t	START_ERASE_INFO1:1;			// 14:14   Start erasing all cells in info-1 array
	uint32_t	START_PROG_INFO1:1;			// 15:15   Start programming to info1-array
	uint32_t	rsvd2:16;			// 31:16   reserved
};

union FLASH_CONTROL_REG_REG {
	uint32_t 		 all;
	struct FLASH_CONTROL_REG_BITS 		 bit;
};

struct FLASH_TIMING_REG0_BITS {			// bits   description
	uint32_t	TACC_CYCLES:6;			// 5:0   Read wait timing counter to get a valid read data from flash.

	uint32_t	PROG_CYCLES:12;			// 17:6   When program to Info1 block , prog_cycles * clock period should meet Tprog, which is 8us~15us
	uint32_t	EIGHT_US_CYCLES:14;			// 31:18   eight_us_cycles * clock period should be larger than 8us
};

union FLASH_TIMING_REG0_REG {
	uint32_t 		 all;
	struct FLASH_TIMING_REG0_BITS 		 bit;
};

struct FLASH_TIMING_REG1_BITS {			// bits   description
	uint32_t	ERC_ERASE_CYCLES:22;			// 21:0   erc_erase_cycles*clock period should meet Tre,which is 10ms~20ms
	uint32_t	TWO_US_CYCLES:10;			// 31:22   two_us_cycles*clock period should be larger than 2us  to meet program info1 timing requirement
};

union FLASH_TIMING_REG1_REG {
	uint32_t 		 all;
	struct FLASH_TIMING_REG1_BITS 		 bit;
};

struct FLASH_TIMING_REG2_BITS {			// bits   description
	uint32_t	PROG_ERC_SHARED_CYCLES:16;			// 15:0   When doing ERC, prog_erc_shared_cycles*clock period should be larger than Ttmh, which is 30us
	uint32_t	HUNDRED_NS_CYCLES:8;			// 23:16   hundred_ns_cycles*clock period should be larger than 100ns, to meet timing Ttpl in ERC
	uint32_t	TEN_NS_CYCLES:4;			// 27:24   ten_ns_cycles*clock period should be larger than 10ns
	uint32_t	rsvd1:4;			// 31:28   reserved
};

union FLASH_TIMING_REG2_REG {
	uint32_t 		 all;
	struct FLASH_TIMING_REG2_BITS 		 bit;
};

struct FLASH_UNLOCK_REG0_BITS {			// bits   description
	uint32_t	KEY0:16;			// 15:0   Write a specific sequence in order to unlock access to the write protection register.
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union FLASH_UNLOCK_REG0_REG {
	uint32_t 		 all;
	struct FLASH_UNLOCK_REG0_BITS 		 bit;
};

struct FLASH_UNLOCK_REG1_BITS {			// bits   description
	uint32_t	KEY1:16;			// 15:0   Write a specific sequence in order to unlock access to the write protection register.
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union FLASH_UNLOCK_REG1_REG {
	uint32_t 		 all;
	struct FLASH_UNLOCK_REG1_BITS 		 bit;
};

struct FLASH_ADDRESS_REG_BITS {			// bits   description
	uint32_t	GROUP_ADDR:4;			// 3:0   group address to slect which 32-bits are read. not used in program/erase
	uint32_t	YADDR:5;			// 8:4   Y-address to flash
	uint32_t	XADDR:10;			// 18:9   X-address to flash
	uint32_t	IFREN_ADDR:1;			// 19:19   Info array select
	uint32_t	rsvd1:12;			// 31:20   reserved
};

union FLASH_ADDRESS_REG_REG {
	uint32_t 		 all;
	struct FLASH_ADDRESS_REG_BITS 		 bit;
};

struct FLASH_PROGRAM_DATA0_BITS {			// bits   description
	uint32_t	DATA0:32;			// 31:0   program/trim data0
};

union FLASH_PROGRAM_DATA0_REG {
	uint32_t 		 all;
	struct FLASH_PROGRAM_DATA0_BITS 		 bit;
};

struct FLASH_PROGRAM_DATA1_BITS {			// bits   description
	uint32_t	DATA1:32;			// 31:0   program/trim data1
};

union FLASH_PROGRAM_DATA1_REG {
	uint32_t 		 all;
	struct FLASH_PROGRAM_DATA1_BITS 		 bit;
};

struct FLASH_PROGRAM_DATA2_BITS {			// bits   description
	uint32_t	DATA2:32;			// 31:0   program/trim data2
};

union FLASH_PROGRAM_DATA2_REG {
	uint32_t 		 all;
	struct FLASH_PROGRAM_DATA2_BITS 		 bit;
};

struct FLASH_PROGRAM_DATA3_BITS {			// bits   description
	uint32_t	DATA3:32;			// 31:0   program/trim data3
};

union FLASH_PROGRAM_DATA3_REG {
	uint32_t 		 all;
	struct FLASH_PROGRAM_DATA3_BITS 		 bit;
};

struct FLASH_PROGRAM_DATA4_BITS {			// bits   description
	uint32_t	DATA4:9;			// 8:0   program data4, ony used as trim data
	uint32_t	rsvd1:23;			// 31:9   reserved
};

union FLASH_PROGRAM_DATA4_REG {
	uint32_t 		 all;
	struct FLASH_PROGRAM_DATA4_BITS 		 bit;
};

struct FLASH_STATUS_REG_BITS {			// bits   description
	uint32_t	EFC_BUSY:1;			// 0:0   Indicates whether the flash controller is busy performing an erase or program operation.
	uint32_t	WRITE_ERR:1;			// 1:1   Indicates an attempt was made to erase / write a write protected page or a brown out occurred during
	uint32_t	DISABLED_REDUND:1;			// 2:2   1:  disable redundancy
	uint32_t	DISCHARGED_STATUS:1;			// 3:3   1:  discharged  0: normal
	uint32_t	BROWNOUT_STATUS:1;			// 4:4   1:  Brown out detected  0:  Power normal
	uint32_t	WRITE_COMP_STATUS:1;			// 5:5   1:  Write complete   0:  Write not complete   
	uint32_t	SEC_DETECTED:1;			// 6:6   Indicates if an error has been corrected.
	uint32_t	DED_DETECTED:1;			// 7:7   Indicates if an uncorrectable error has been detecteds.
	uint32_t	SMW_ERR_STATUS:1;			// 8:8   status from smw, 1 to indicate smart-write failure. Debug usage.
	uint32_t	SMW_LATEST_STATUS:9;			// 17:9   status from smw, indicate the value of {WIPGM[1:0],WMV[2:0],WHV[3:0]} in the last loop of smw operation.
	uint32_t	SMW_LOOP_STATUS:10;			// 27:18   status from smw, indicate the loop count to complete current smw operation. Debug usage.
	uint32_t	rsvd1:4;			// 31:28   reserved
};

union FLASH_STATUS_REG_REG {
	uint32_t 		 all;
	struct FLASH_STATUS_REG_BITS 		 bit;
};

struct FLASH_REDUN_ADRR_REG0_BITS {			// bits   description
	uint32_t	REDUN_INDICATE:1;			// 0:0   Indicate redundancy 0 is used
	uint32_t	REDUN_PAGE_ADDR:7;			// 18:12   Redundant page 0 address
	uint32_t	rsvd1:13;			// 31:19   reserved
};

union FLASH_REDUN_ADRR_REG0_REG {
	uint32_t 		 all;
	struct FLASH_REDUN_ADRR_REG0_BITS 		 bit;
};

struct FLASH_REDUN_ADRR_REG1_BITS {			// bits   description
	uint32_t	REDUN_INDICATE:1;			// 0:0   Indicate redundancy 1 is used
	uint32_t	REDUN_PAGE_ADDR:7;			// 18:12   Redundant page 1 address
	uint32_t	rsvd1:13;			// 31:19   reserved
};

union FLASH_REDUN_ADRR_REG1_REG {
	uint32_t 		 all;
	struct FLASH_REDUN_ADRR_REG1_BITS 		 bit;
};

struct FLASH_SINGLE_ERROR_CORRECTED_COUNT_REG_BITS {			// bits   description
	uint32_t	CNT:16;			// 15:0   The single error corrected count register is incremented each time the ECC logic corrects a single error.
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union FLASH_SINGLE_ERROR_CORRECTED_COUNT_REG_REG {
	uint32_t 		 all;
	struct FLASH_SINGLE_ERROR_CORRECTED_COUNT_REG_BITS 		 bit;
};

struct FLASH_DOUBLE_ERROR_DETECTED_COUNT_REG_BITS {			// bits   description
	uint32_t	CNT:16;			// 15:0   The double error detected count register is incremented each time the ECC logic detects an uncorrectable
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union FLASH_DOUBLE_ERROR_DETECTED_COUNT_REG_REG {
	uint32_t 		 all;
	struct FLASH_DOUBLE_ERROR_DETECTED_COUNT_REG_BITS 		 bit;
};

struct SMW_TIMER_OPTION_REG_BITS {			// bits   description
	uint32_t	ONEUS_PULSE_CYCLES:8;			// 7:0   Refer to TSMC smw databook
	uint32_t	PV_EV_READ_CYCLES:5;			// 12:8   Refer to TSMC smw databook
	uint32_t	rsvd1:19;			// 31:13   reserved
};

union SMW_TIMER_OPTION_REG_REG {
	uint32_t 		 all;
	struct SMW_TIMER_OPTION_REG_BITS 		 bit;
};

struct SMW_SETTING_OPTION1_REG0_BITS {			// bits   description
	uint32_t	FLASHUNUSED:14;			// 13:0   Refer to TSMC smw databook
	uint32_t	MV_CTRL:10;			// 23:14   Refer to TSMC smw databook
	uint32_t	IPGM_CTRL:7;			// 30:24   Refer to TSMC smw databook
	uint32_t	rsvd1:1;			// 31:31   reserved
};

union SMW_SETTING_OPTION1_REG0_REG {
	uint32_t 		 all;
	struct SMW_SETTING_OPTION1_REG0_BITS 		 bit;
};

struct SMW_SETTING_OPTION1_REG1_BITS {			// bits   description
	uint32_t	TEST_CTRL:3;			// 2:0   Refer to TSMC smw databook
	uint32_t	TPGM_CTRL:2;			// 4:3   Refer to TSMC smw databook
	uint32_t	TNVS_CTRL:3;			// 7:5   Refer to TSMC smw databook
	uint32_t	TNVH_CTRL:3;			// 10:8   Refer to TSMC smw databook
	uint32_t	TPGS_CRTL:3;			// 13:11   Refer to TSMC smw databook
	uint32_t	MAX_ERASE:9;			// 22:14   Refer to TSMC smw databook
	uint32_t	MAX_PROG:5;			// 27:23   Refer to TSMC smw databook
	uint32_t	rsvd1:4;			// 31:28   reserved
};

union SMW_SETTING_OPTION1_REG1_REG {
	uint32_t 		 all;
	struct SMW_SETTING_OPTION1_REG1_BITS 		 bit;
};

struct SMW_SETTING_OPTION2_REG_BITS {			// bits   description
	uint32_t	THVS_CTRL:3;			// 2:0   Refer to TSMC smw databook
	uint32_t	TRCV_CTRL:3;			// 5:3   Refer to TSMC smw databook
	uint32_t	EXTRA_PULSE:4;			// 9:6   Refer to TSMC smw databook
	uint32_t	WHV_COUNTER:8;			// 17:10   Refer to TSMC smw databook
	uint32_t	POST_TERS:3;			// 20:18   Refer to TSMC smw databook
	uint32_t	POST_TPGM:2;			// 22:21   Refer to TSMC smw databook
	uint32_t	VERIFY_OPTION:2;			// 24:23   Refer to TSMC smw databook
	uint32_t	TPGM_OPTION:2;			// 26:25   Refer to TSMC smw databook
	uint32_t	MASK0_OPTION:1;			// 27:27   Refer to TSMC smw databook
	uint32_t	DISABLE_PRER_OPTION:1;			// 28:28   Refer to TSMC smw databook
	uint32_t	rsvd1:3;			// 31:29   reserved
};

union SMW_SETTING_OPTION2_REG_REG {
	uint32_t 		 all;
	struct SMW_SETTING_OPTION2_REG_BITS 		 bit;
};

struct SMW_SETTING_OPTION3_REG_BITS {			// bits   description
	uint32_t	HWM_WHV_COUNTER:8;			// 7:0   Refer to TSMC smw databook
	uint32_t	HEM_MAX_ERASE:9;			// 16:8   Refer to TSMC smw databook
	uint32_t	rsvd1:15;			// 31:17   reserved
};

union SMW_SETTING_OPTION3_REG_REG {
	uint32_t 		 all;
	struct SMW_SETTING_OPTION3_REG_BITS 		 bit;
};

struct SMW_SMP_WHV_OPTION_REG0_BITS {			// bits   description
	uint32_t	SMP_WHV_OPTION_LOW:32;			// 31:0   Refer to TSMC smw databook
};

union SMW_SMP_WHV_OPTION_REG0_REG {
	uint32_t 		 all;
	struct SMW_SMP_WHV_OPTION_REG0_BITS 		 bit;
};

struct SMW_SMP_WHV_OPTION_REG1_BITS {			// bits   description
	uint32_t	SMP_WHV_OPTION_HIGH:32;			// 31:0   Refer to TSMC smw databook
};

union SMW_SMP_WHV_OPTION_REG1_REG {
	uint32_t 		 all;
	struct SMW_SMP_WHV_OPTION_REG1_BITS 		 bit;
};

struct SMW_SME_WHV_OPTION_REG0_BITS {			// bits   description
	uint32_t	SME_WHV_OPTION_LOW:32;			// 31:0   Refer to TSMC smw databook
};

union SMW_SME_WHV_OPTION_REG0_REG {
	uint32_t 		 all;
	struct SMW_SME_WHV_OPTION_REG0_BITS 		 bit;
};

struct SMW_SME_WHV_OPTION_REG1_BITS {			// bits   description
	uint32_t	SME_WHV_OPTION_HIGH:32;			// 31:0   Refer to TSMC smw databook
};

union SMW_SME_WHV_OPTION_REG1_REG {
	uint32_t 		 all;
	struct SMW_SME_WHV_OPTION_REG1_BITS 		 bit;
};

struct FLASH_MISC_CFG_BITS {			// bits   description
	uint32_t	WHV_CFG:4;			// 3:0   WHV[3:0] config to flash ,only work when sw_electrical_config_en is high and in a non-smart operaion
	uint32_t	WMV_CFG:3;			// 6:4   WMV[2:0] config to flash ,only work  when sw_electrical_config_en is high and in a non-smart operaion
	uint32_t	WIPGM_CFG:2;			// 8:7   WIPGM[1:0] config to flash, only work when sw_electrical_config_en is high and in a non-smart operaion
	uint32_t	SW_ELECTRICAL_CONFIG_EN:1;			// 9:9   software config enable to whv_cfg/wmv_cfg/wipgm
	uint32_t	FLASH_MISC:22;			// 31:10   Reserved flash misc register field; used for metal ECO purpose.
};

union FLASH_MISC_CFG_REG {
	uint32_t 		 all;
	struct FLASH_MISC_CFG_BITS 		 bit;
};

struct FLASH_PROTECT_REG0_BITS {			// bits   description
	uint32_t	INFO_WRITE_PROTECT:1;			// 0:0   Write protect to all info pages
	uint32_t	rsvd1:15;			// 15:1   reserved
	uint32_t	WRITE_PROTECT_ALL:1;			// 16:16   Write protect to all pages
	uint32_t	rsvd2:15;			// 31:17   reserved
};

union FLASH_PROTECT_REG0_REG {
	uint32_t 		 all;
	struct FLASH_PROTECT_REG0_BITS 		 bit;
};

struct FLASH_PROTECT_REG1_BITS {			// bits   description
	uint32_t	WP_PAGE_31_0:32;			// 31:0   Write prottect to page 0~31, per bit
};

union FLASH_PROTECT_REG1_REG {
	uint32_t 		 all;
	struct FLASH_PROTECT_REG1_BITS 		 bit;
};

struct FLASH_PROTECT_REG2_BITS {			// bits   description
	uint32_t	WP_PAGE_63_32:32;			// 31:0   Write prottect to page 32~63, per bit
};

union FLASH_PROTECT_REG2_REG {
	uint32_t 		 all;
	struct FLASH_PROTECT_REG2_BITS 		 bit;
};


// eFLASH Register Definitions:

struct EFLASH_REGS {
	union  FLASH_CONTROL_REG_REG			FLASH_CONTROL_REG;
	union  FLASH_TIMING_REG0_REG			FLASH_TIMING_REG0;
	union  FLASH_TIMING_REG1_REG			FLASH_TIMING_REG1;
	union  FLASH_TIMING_REG2_REG			FLASH_TIMING_REG2;
	uint32_t 						rsvd1[2]; 		 // reserved
	union  FLASH_UNLOCK_REG0_REG			FLASH_UNLOCK_REG0;
	union  FLASH_UNLOCK_REG1_REG			FLASH_UNLOCK_REG1;
	union  FLASH_ADDRESS_REG_REG			FLASH_ADDRESS_REG;
	union  FLASH_PROGRAM_DATA0_REG			FLASH_PROGRAM_DATA0;
	union  FLASH_PROGRAM_DATA1_REG			FLASH_PROGRAM_DATA1;
	union  FLASH_PROGRAM_DATA2_REG			FLASH_PROGRAM_DATA2;
	union  FLASH_PROGRAM_DATA3_REG			FLASH_PROGRAM_DATA3;
	union  FLASH_PROGRAM_DATA4_REG			FLASH_PROGRAM_DATA4;
	uint32_t 						rsvd2[3]; 		 // reserved
	union  FLASH_STATUS_REG_REG			FLASH_STATUS_REG;
	union  FLASH_REDUN_ADRR_REG0_REG			FLASH_REDUN_ADRR_REG0;
	union  FLASH_REDUN_ADRR_REG1_REG			FLASH_REDUN_ADRR_REG1;
	union  FLASH_SINGLE_ERROR_CORRECTED_COUNT_REG_REG			FLASH_SINGLE_ERROR_CORRECTED_COUNT_REG;
	union  FLASH_DOUBLE_ERROR_DETECTED_COUNT_REG_REG			FLASH_DOUBLE_ERROR_DETECTED_COUNT_REG;
	uint32_t 						rsvd3; 		 // reserved
	union  SMW_TIMER_OPTION_REG_REG			SMW_TIMER_OPTION_REG;
	union  SMW_SETTING_OPTION1_REG0_REG			SMW_SETTING_OPTION1_REG0;
	union  SMW_SETTING_OPTION1_REG1_REG			SMW_SETTING_OPTION1_REG1;
	union  SMW_SETTING_OPTION2_REG_REG			SMW_SETTING_OPTION2_REG;
	union  SMW_SETTING_OPTION3_REG_REG			SMW_SETTING_OPTION3_REG;
	union  SMW_SMP_WHV_OPTION_REG0_REG			SMW_SMP_WHV_OPTION_REG0;
	union  SMW_SMP_WHV_OPTION_REG1_REG			SMW_SMP_WHV_OPTION_REG1;
	union  SMW_SME_WHV_OPTION_REG0_REG			SMW_SME_WHV_OPTION_REG0;
	union  SMW_SME_WHV_OPTION_REG1_REG			SMW_SME_WHV_OPTION_REG1;
	union  FLASH_MISC_CFG_REG			FLASH_MISC_CFG;
	union  FLASH_PROTECT_REG0_REG			FLASH_PROTECT_REG0;
	union  FLASH_PROTECT_REG1_REG			FLASH_PROTECT_REG1;
	union  FLASH_PROTECT_REG2_REG			FLASH_PROTECT_REG2;
};

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// EFLASH External References & Function Declarations

extern volatile struct EFLASH_REGS eflashRegs;


#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_EFLASH_H definition
