/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *  @file    regs_epwmxbar.h
 *  @brief
 *  Commit History
 *  20240410, Jason, change license header, add support for 1.1ES
 */

#ifndef REGS_EPWM_XBAR_H
#define REGS_EPWM_XBAR_H

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif


//---------------------------------------------------------------------------
// EPWM_XBAR Individual Register Bit Definitions:

struct TRIP4MUX0TO15CFG_BITS {          // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for TRIP4 of EPWM-XBAR
};

union TRIP4MUX0TO15CFG_REG {
    uint32_t  all;
    struct  TRIP4MUX0TO15CFG_BITS  bit;
};

struct TRIP4MUX16TO31CFG_BITS {         // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for TRIP4 of EPWM-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for TRIP4 of EPWM-XBAR
};

union TRIP4MUX16TO31CFG_REG {
    uint32_t  all;
    struct  TRIP4MUX16TO31CFG_BITS  bit;
};

struct TRIP5MUX0TO15CFG_BITS {          // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for TRIP5 of EPWM-XBAR
};

union TRIP5MUX0TO15CFG_REG {
    uint32_t  all;
    struct  TRIP5MUX0TO15CFG_BITS  bit;
};

struct TRIP5MUX16TO31CFG_BITS {         // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for TRIP5 of EPWM-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for TRIP5 of EPWM-XBAR
};

union TRIP5MUX16TO31CFG_REG {
    uint32_t  all;
    struct  TRIP5MUX16TO31CFG_BITS  bit;
};

struct TRIP7MUX0TO15CFG_BITS {          // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for TRIP7 of EPWM-XBAR
};

union TRIP7MUX0TO15CFG_REG {
    uint32_t  all;
    struct  TRIP7MUX0TO15CFG_BITS  bit;
};

struct TRIP7MUX16TO31CFG_BITS {         // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for TRIP7 of EPWM-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for TRIP7 of EPWM-XBAR
};

union TRIP7MUX16TO31CFG_REG {
    uint32_t  all;
    struct  TRIP7MUX16TO31CFG_BITS  bit;
};

struct TRIP8MUX0TO15CFG_BITS {          // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for TRIP8 of EPWM-XBAR
};

union TRIP8MUX0TO15CFG_REG {
    uint32_t  all;
    struct  TRIP8MUX0TO15CFG_BITS  bit;
};

struct TRIP8MUX16TO31CFG_BITS {         // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for TRIP8 of EPWM-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for TRIP8 of EPWM-XBAR
};

union TRIP8MUX16TO31CFG_REG {
    uint32_t  all;
    struct  TRIP8MUX16TO31CFG_BITS  bit;
};

struct TRIP9MUX0TO15CFG_BITS {          // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for TRIP9 of EPWM-XBAR
};

union TRIP9MUX0TO15CFG_REG {
    uint32_t  all;
    struct  TRIP9MUX0TO15CFG_BITS  bit;
};

struct TRIP9MUX16TO31CFG_BITS {         // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for TRIP9 of EPWM-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for TRIP9 of EPWM-XBAR
};

union TRIP9MUX16TO31CFG_REG {
    uint32_t  all;
    struct  TRIP9MUX16TO31CFG_BITS  bit;
};

struct TRIP10MUX0TO15CFG_BITS {         // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for TRIP10 of EPWM-XBAR
};

union TRIP10MUX0TO15CFG_REG {
    uint32_t  all;
    struct  TRIP10MUX0TO15CFG_BITS  bit;
};

struct TRIP10MUX16TO31CFG_BITS {        // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for TRIP10 of EPWM-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for TRIP10 of EPWM-XBAR
};

union TRIP10MUX16TO31CFG_REG {
    uint32_t  all;
    struct  TRIP10MUX16TO31CFG_BITS  bit;
};

struct TRIP11MUX0TO15CFG_BITS {         // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for TRIP11 of EPWM-XBAR
};

union TRIP11MUX0TO15CFG_REG {
    uint32_t  all;
    struct  TRIP11MUX0TO15CFG_BITS  bit;
};

struct TRIP11MUX16TO31CFG_BITS {        // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for TRIP11 of EPWM-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for TRIP11 of EPWM-XBAR
};

union TRIP11MUX16TO31CFG_REG {
    uint32_t  all;
    struct  TRIP11MUX16TO31CFG_BITS  bit;
};

struct TRIP12MUX0TO15CFG_BITS {         // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for TRIP12 of EPWM-XBAR
};

union TRIP12MUX0TO15CFG_REG {
    uint32_t  all;
    struct  TRIP12MUX0TO15CFG_BITS  bit;
};

struct TRIP12MUX16TO31CFG_BITS {        // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for TRIP12 of EPWM-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for TRIP12 of EPWM-XBAR
};

union TRIP12MUX16TO31CFG_REG {
    uint32_t  all;
    struct  TRIP12MUX16TO31CFG_BITS  bit;
};

struct TRIP4MUXENABLE_BITS {            // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive TRIP4 of EPWM-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive TRIP4 of EPWM-XBAR
};

union TRIP4MUXENABLE_REG {
    uint32_t  all;
    struct  TRIP4MUXENABLE_BITS  bit;
};

struct TRIP5MUXENABLE_BITS {            // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive TRIP5 of EPWM-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive TRIP5 of EPWM-XBAR
};

union TRIP5MUXENABLE_REG {
    uint32_t  all;
    struct  TRIP5MUXENABLE_BITS  bit;
};

struct TRIP7MUXENABLE_BITS {            // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive TRIP7 of EPWM-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive TRIP7 of EPWM-XBAR
};

union TRIP7MUXENABLE_REG {
    uint32_t  all;
    struct  TRIP7MUXENABLE_BITS  bit;
};

struct TRIP8MUXENABLE_BITS {            // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive TRIP8 of EPWM-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive TRIP8 of EPWM-XBAR
};

union TRIP8MUXENABLE_REG {
    uint32_t  all;
    struct  TRIP8MUXENABLE_BITS  bit;
};

struct TRIP9MUXENABLE_BITS {            // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive TRIP9 of EPWM-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive TRIP9 of EPWM-XBAR
};

union TRIP9MUXENABLE_REG {
    uint32_t  all;
    struct  TRIP9MUXENABLE_BITS  bit;
};

struct TRIP10MUXENABLE_BITS {           // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive TRIP10 of EPWM-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive TRIP10 of EPWM-XBAR
};

union TRIP10MUXENABLE_REG {
    uint32_t  all;
    struct  TRIP10MUXENABLE_BITS  bit;
};

struct TRIP11MUXENABLE_BITS {           // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive TRIP11 of EPWM-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive TRIP11 of EPWM-XBAR
};

union TRIP11MUXENABLE_REG {
    uint32_t  all;
    struct  TRIP11MUXENABLE_BITS  bit;
};

struct TRIP12MUXENABLE_BITS {           // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive TRIP12 of EPWM-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive TRIP12 of EPWM-XBAR
};

union TRIP12MUXENABLE_REG {
    uint32_t  all;
    struct  TRIP12MUXENABLE_BITS  bit;
};

/*****************************************add mux32-mux63 and muxenable32-63 base GS32F3XX==0X0022 and GS32F00XX==0X0030 **************************/
struct TRIP4MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union TRIP4MUX32TO47CFG_REG {
    uint32_t  all;
    struct  TRIP4MUX32TO47CFG_BITS  bit;
};

struct TRIP4MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union TRIP4MUX48TO63CFG_REG {
    uint32_t  all;
    struct  TRIP4MUX48TO63CFG_BITS  bit;
};

struct TRIP5MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union TRIP5MUX32TO47CFG_REG {
    uint32_t  all;
    struct  TRIP5MUX32TO47CFG_BITS  bit;
};

struct TRIP5MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union TRIP5MUX48TO63CFG_REG {
    uint32_t  all;
    struct  TRIP5MUX48TO63CFG_BITS  bit;
};

struct TRIP6MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union TRIP6MUX32TO47CFG_REG {
    uint32_t  all;
    struct  TRIP6MUX32TO47CFG_BITS  bit;
};

#if IS_GS32F3xx(0x22)
struct TRIP6MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union TRIP6MUX48TO63CFG_REG {
    uint32_t  all;
    struct  TRIP6MUX48TO63CFG_BITS  bit;
};
#endif

struct TRIP7MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union TRIP7MUX32TO47CFG_REG {
    uint32_t  all;
    struct  TRIP7MUX32TO47CFG_BITS  bit;
};

struct TRIP7MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                   
};

union TRIP7MUX48TO63CFG_REG {
    uint32_t  all;
    struct  TRIP7MUX48TO63CFG_BITS  bit;
};

struct TRIP8MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union TRIP8MUX32TO47CFG_REG {
    uint32_t  all;
    struct  TRIP8MUX32TO47CFG_BITS  bit;
};

struct TRIP8MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union TRIP8MUX48TO63CFG_REG {
    uint32_t  all;
    struct  TRIP8MUX48TO63CFG_BITS  bit;
};

struct TRIP9MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union TRIP9MUX32TO47CFG_REG {
    uint32_t  all;
    struct  TRIP9MUX32TO47CFG_BITS  bit;
};

struct TRIP9MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union TRIP9MUX48TO63CFG_REG {
    uint32_t  all;
    struct  TRIP9MUX48TO63CFG_BITS  bit;
};

struct TRIP10MUX32TO47CFG_BITS {        
    uint32_t MUX32:2;                   
    uint32_t MUX33:2;                   
    uint32_t MUX34:2;                   
    uint32_t MUX35:2;                   
    uint32_t MUX36:2;                   
    uint32_t MUX37:2;                   
    uint32_t MUX38:2;                   
    uint32_t MUX39:2;                   
    uint32_t MUX40:2;                
    uint32_t MUX41:2;                
    uint32_t MUX42:2;                
    uint32_t MUX43:2;                
    uint32_t MUX44:2;                
    uint32_t MUX45:2;                
    uint32_t MUX46:2;                
    uint32_t MUX47:2;                
};

union TRIP10MUX32TO47CFG_REG {
    uint32_t  all;
    struct  TRIP10MUX32TO47CFG_BITS  bit;
};

struct TRIP10MUX48TO63CFG_BITS {      
    uint32_t MUX48:2;                    
    uint32_t MUX49:2;                    
    uint32_t MUX50:2;                    
    uint32_t MUX51:2;                    
    uint32_t MUX52:2;                    
    uint32_t MUX53:2;                    
    uint32_t MUX54:2;                    
    uint32_t MUX55:2;                    
    uint32_t MUX56:2;                    
    uint32_t MUX57:2;                    
    uint32_t MUX58:2;                    
    uint32_t MUX59:2;                    
    uint32_t MUX60:2;                    
    uint32_t MUX61:2;                    
    uint32_t MUX62:2;                    
    uint32_t MUX63:2;                    
};

union TRIP10MUX48TO63CFG_REG {
    uint32_t  all;
    struct  TRIP10MUX48TO63CFG_BITS  bit;
};

struct TRIP11MUX32TO47CFG_BITS {         
    uint32_t MUX32:2;                     
    uint32_t MUX33:2;                     
    uint32_t MUX34:2;                     
    uint32_t MUX35:2;                     
    uint32_t MUX36:2;                     
    uint32_t MUX37:2;                     
    uint32_t MUX38:2;                     
    uint32_t MUX39:2;                     
    uint32_t MUX40:2;                     
    uint32_t MUX41:2;                     
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union TRIP11MUX32TO47CFG_REG {
    uint32_t  all;
    struct  TRIP11MUX32TO47CFG_BITS  bit;
};

struct TRIP11MUX48TO63CFG_BITS {       
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union TRIP11MUX48TO63CFG_REG {
    uint32_t  all;
    struct  TRIP11MUX48TO63CFG_BITS  bit;
};

struct TRIP12MUX32TO47CFG_BITS {      
    uint32_t MUX32:2;                 
    uint32_t MUX33:2;                 
    uint32_t MUX34:2;                 
    uint32_t MUX35:2;                 
    uint32_t MUX36:2;                 
    uint32_t MUX37:2;                 
    uint32_t MUX38:2;                 
    uint32_t MUX39:2;                 
    uint32_t MUX40:2;                 
    uint32_t MUX41:2;                 
    uint32_t MUX42:2;                 
    uint32_t MUX43:2;                 
    uint32_t MUX44:2;                 
    uint32_t MUX45:2;                 
    uint32_t MUX46:2;                 
    uint32_t MUX47:2;                 
};

union TRIP12MUX32TO47CFG_REG {
    uint32_t  all;
    struct  TRIP12MUX32TO47CFG_BITS  bit;
};

struct TRIP12MUX48TO63CFG_BITS {      
    uint32_t MUX48:2;                    
    uint32_t MUX49:2;                    
    uint32_t MUX50:2;                    
    uint32_t MUX51:2;                    
    uint32_t MUX52:2;                    
    uint32_t MUX53:2;                    
    uint32_t MUX54:2;                    
    uint32_t MUX55:2;                    
    uint32_t MUX56:2;                    
    uint32_t MUX57:2;                    
    uint32_t MUX58:2;                    
    uint32_t MUX59:2;                    
    uint32_t MUX60:2;                    
    uint32_t MUX61:2;                    
    uint32_t MUX62:2;                    
    uint32_t MUX63:2;                    
};

union TRIP12MUX48TO63CFG_REG {
    uint32_t  all;
    struct  TRIP12MUX48TO63CFG_BITS  bit;
};

//MUX ENABLE
struct TRIP4MUXENABLE32TO64_BITS {        
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union TRIP4MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  TRIP4MUXENABLE32TO64_BITS  bit;
};

struct TRIP5MUXENABLE32TO64_BITS {     
    uint32_t MUX32:1;                  
    uint32_t MUX33:1;                  
    uint32_t MUX34:1;                  
    uint32_t MUX35:1;                  
    uint32_t MUX36:1;                  
    uint32_t MUX37:1;                  
    uint32_t MUX38:1;                  
    uint32_t MUX39:1;                  
    uint32_t MUX40:1;                  
    uint32_t MUX41:1;                  
    uint32_t MUX42:1;                  
    uint32_t MUX43:1;                  
    uint32_t MUX44:1;                  
    uint32_t MUX45:1;                  
    uint32_t MUX46:1;                  
    uint32_t MUX47:1;                  
    uint32_t MUX48:1;                  
    uint32_t MUX49:1;                  
    uint32_t MUX50:1;                  
    uint32_t MUX51:1;                  
    uint32_t MUX52:1;                  
    uint32_t MUX53:1;                  
    uint32_t MUX54:1;                  
    uint32_t MUX55:1;                  
    uint32_t MUX56:1;                  
    uint32_t MUX57:1;                  
    uint32_t MUX58:1;                  
    uint32_t MUX59:1;                  
    uint32_t MUX60:1;                  
    uint32_t MUX61:1;                  
    uint32_t MUX62:1;                  
    uint32_t MUX63:1;                  
};

union TRIP5MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  TRIP5MUXENABLE32TO64_BITS  bit;
};

#if IS_GS32F3xx(0x22)
struct TRIP6MUXENABLE32TO64_BITS {     
    uint32_t MUX32:1;                  
    uint32_t MUX33:1;                  
    uint32_t MUX34:1;                  
    uint32_t MUX35:1;                  
    uint32_t MUX36:1;                  
    uint32_t MUX37:1;                  
    uint32_t MUX38:1;                  
    uint32_t MUX39:1;                  
    uint32_t MUX40:1;                  
    uint32_t MUX41:1;                  
    uint32_t MUX42:1;                  
    uint32_t MUX43:1;                  
    uint32_t MUX44:1;                  
    uint32_t MUX45:1;                  
    uint32_t MUX46:1;                  
    uint32_t MUX47:1;                  
    uint32_t MUX48:1;                  
    uint32_t MUX49:1;                  
    uint32_t MUX50:1;                  
    uint32_t MUX51:1;                  
    uint32_t MUX52:1;                  
    uint32_t MUX53:1;                  
    uint32_t MUX54:1;                  
    uint32_t MUX55:1;                  
    uint32_t MUX56:1;                  
    uint32_t MUX57:1;                  
    uint32_t MUX58:1;                  
    uint32_t MUX59:1;                  
    uint32_t MUX60:1;                  
    uint32_t MUX61:1;                  
    uint32_t MUX62:1;                  
    uint32_t MUX63:1;                  
};

union TRIP6MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  TRIP6MUXENABLE32TO64_BITS  bit;
};
#endif

struct TRIP7MUXENABLE32TO64_BITS {    
    uint32_t MUX32:1;                 
    uint32_t MUX33:1;                 
    uint32_t MUX34:1;                 
    uint32_t MUX35:1;                 
    uint32_t MUX36:1;                 
    uint32_t MUX37:1;                 
    uint32_t MUX38:1;                 
    uint32_t MUX39:1;                 
    uint32_t MUX40:1;                 
    uint32_t MUX41:1;                 
    uint32_t MUX42:1;                 
    uint32_t MUX43:1;                 
    uint32_t MUX44:1;                 
    uint32_t MUX45:1;                 
    uint32_t MUX46:1;                 
    uint32_t MUX47:1;                 
    uint32_t MUX48:1;                 
    uint32_t MUX49:1;                 
    uint32_t MUX50:1;                 
    uint32_t MUX51:1;                 
    uint32_t MUX52:1;                 
    uint32_t MUX53:1;                 
    uint32_t MUX54:1;                 
    uint32_t MUX55:1;                 
    uint32_t MUX56:1;                 
    uint32_t MUX57:1;                 
    uint32_t MUX58:1;                 
    uint32_t MUX59:1;                 
    uint32_t MUX60:1;                 
    uint32_t MUX61:1;                 
    uint32_t MUX62:1;                 
    uint32_t MUX63:1;                 
};

union TRIP7MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  TRIP7MUXENABLE32TO64_BITS  bit;
};

struct TRIP8MUXENABLE32TO64_BITS {    
    uint32_t MUX32:1;                 
    uint32_t MUX33:1;                 
    uint32_t MUX34:1;                 
    uint32_t MUX35:1;                 
    uint32_t MUX36:1;                 
    uint32_t MUX37:1;                 
    uint32_t MUX38:1;                 
    uint32_t MUX39:1;                 
    uint32_t MUX40:1;                 
    uint32_t MUX41:1;                 
    uint32_t MUX42:1;                 
    uint32_t MUX43:1;                 
    uint32_t MUX44:1;                 
    uint32_t MUX45:1;                 
    uint32_t MUX46:1;                 
    uint32_t MUX47:1;                 
    uint32_t MUX48:1;                 
    uint32_t MUX49:1;                 
    uint32_t MUX50:1;                 
    uint32_t MUX51:1;                 
    uint32_t MUX52:1;                 
    uint32_t MUX53:1;                 
    uint32_t MUX54:1;                 
    uint32_t MUX55:1;                 
    uint32_t MUX56:1;                 
    uint32_t MUX57:1;                 
    uint32_t MUX58:1;                 
    uint32_t MUX59:1;                 
    uint32_t MUX60:1;                 
    uint32_t MUX61:1;                 
    uint32_t MUX62:1;                 
    uint32_t MUX63:1;                 
};

union TRIP8MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  TRIP8MUXENABLE32TO64_BITS  bit;
};

struct TRIP9MUXENABLE32TO64_BITS {      
    uint32_t MUX32:1;                   
    uint32_t MUX33:1;                   
    uint32_t MUX34:1;                   
    uint32_t MUX35:1;                   
    uint32_t MUX36:1;                   
    uint32_t MUX37:1;                   
    uint32_t MUX38:1;                   
    uint32_t MUX39:1;                   
    uint32_t MUX40:1;                   
    uint32_t MUX41:1;                   
    uint32_t MUX42:1;                   
    uint32_t MUX43:1;                   
    uint32_t MUX44:1;                   
    uint32_t MUX45:1;                   
    uint32_t MUX46:1;                   
    uint32_t MUX47:1;                   
    uint32_t MUX48:1;                   
    uint32_t MUX49:1;                   
    uint32_t MUX50:1;                   
    uint32_t MUX51:1;                   
    uint32_t MUX52:1;                   
    uint32_t MUX53:1;                   
    uint32_t MUX54:1;                   
    uint32_t MUX55:1;                   
    uint32_t MUX56:1;                   
    uint32_t MUX57:1;                   
    uint32_t MUX58:1;                   
    uint32_t MUX59:1;                   
    uint32_t MUX60:1;                   
    uint32_t MUX61:1;                   
    uint32_t MUX62:1;                   
    uint32_t MUX63:1;                   
};

union TRIP9MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  TRIP9MUXENABLE32TO64_BITS  bit;
};

struct TRIP10MUXENABLE32TO64_BITS {     
    uint32_t MUX32:1;                   
    uint32_t MUX33:1;                   
    uint32_t MUX34:1;                   
    uint32_t MUX35:1;                   
    uint32_t MUX36:1;                   
    uint32_t MUX37:1;                   
    uint32_t MUX38:1;                   
    uint32_t MUX39:1;                   
    uint32_t MUX40:1;                   
    uint32_t MUX41:1;                   
    uint32_t MUX42:1;                   
    uint32_t MUX43:1;                   
    uint32_t MUX44:1;                   
    uint32_t MUX45:1;                   
    uint32_t MUX46:1;                   
    uint32_t MUX47:1;                   
    uint32_t MUX48:1;                   
    uint32_t MUX49:1;                   
    uint32_t MUX50:1;                   
    uint32_t MUX51:1;                   
    uint32_t MUX52:1;                   
    uint32_t MUX53:1;                   
    uint32_t MUX54:1;                   
    uint32_t MUX55:1;                   
    uint32_t MUX56:1;                   
    uint32_t MUX57:1;                   
    uint32_t MUX58:1;                   
    uint32_t MUX59:1;                   
    uint32_t MUX60:1;                   
    uint32_t MUX61:1;                   
    uint32_t MUX62:1;                   
    uint32_t MUX63:1;                   
};

union TRIP10MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  TRIP10MUXENABLE32TO64_BITS  bit;
};

struct TRIP11MUXENABLE32TO64_BITS {     
    uint32_t MUX32:1;                   
    uint32_t MUX33:1;                   
    uint32_t MUX34:1;                   
    uint32_t MUX35:1;                   
    uint32_t MUX36:1;                   
    uint32_t MUX37:1;                   
    uint32_t MUX38:1;                   
    uint32_t MUX39:1;                   
    uint32_t MUX40:1;                   
    uint32_t MUX41:1;                   
    uint32_t MUX42:1;                   
    uint32_t MUX43:1;                   
    uint32_t MUX44:1;                   
    uint32_t MUX45:1;                   
    uint32_t MUX46:1;                   
    uint32_t MUX47:1;                   
    uint32_t MUX48:1;                   
    uint32_t MUX49:1;                   
    uint32_t MUX50:1;                   
    uint32_t MUX51:1;                   
    uint32_t MUX52:1;                   
    uint32_t MUX53:1;                   
    uint32_t MUX54:1;                   
    uint32_t MUX55:1;                   
    uint32_t MUX56:1;                   
    uint32_t MUX57:1;                   
    uint32_t MUX58:1;                   
    uint32_t MUX59:1;                   
    uint32_t MUX60:1;                   
    uint32_t MUX61:1;                   
    uint32_t MUX62:1;                   
    uint32_t MUX63:1;                   
};

union TRIP11MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  TRIP11MUXENABLE32TO64_BITS  bit;
};

struct TRIP12MUXENABLE32TO64_BITS {       
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union TRIP12MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  TRIP12MUXENABLE32TO64_BITS  bit;
};
/************************************************************************************************************/

struct TRIPOUTINV_BITS {                // bits description
    uint32_t TRIP4:1;                     // 0 Selects polarity for TRIP4 of EPWM-XBAR
    uint32_t TRIP5:1;                     // 1 Selects polarity for TRIP5 of EPWM-XBAR
    uint32_t TRIP7:1;                     // 2 Selects polarity for TRIP7 of EPWM-XBAR
    uint32_t TRIP8:1;                     // 3 Selects polarity for TRIP8 of EPWM-XBAR
    uint32_t TRIP9:1;                     // 4 Selects polarity for TRIP9 of EPWM-XBAR
    uint32_t TRIP10:1;                    // 5 Selects polarity for TRIP10 of EPWM-XBAR
    uint32_t TRIP11:1;                    // 6 Selects polarity for TRIP11 of EPWM-XBAR
    uint32_t TRIP12:1;                    // 7 Selects polarity for TRIP12 of EPWM-XBAR
    uint32_t rsvd1:8;                     // 15:8 Reserved
    uint32_t rsvd2:16;                    // 31:16 Reserved
};

union TRIPOUTINV_REG {
    uint32_t  all;
    struct  TRIPOUTINV_BITS  bit;
};

struct TRIPLOCK_BITS {                  // bits description
    Uint16 LOCK:1;                      // 0 Locks the configuration for EPWM-XBAR
    Uint16 rsvd1:15;                    // 15:1 Reserved
    Uint16 KEY:16;                      // 31:16 Write protection KEY
};

union TRIPLOCK_REG {
    Uint32  all;
    struct  TRIPLOCK_BITS  bit;
};


struct EPWM_XBAR_REGS {
    union   TRIP4MUX0TO15CFG_REG             TRIP4MUX0TO15CFG;             // ePWM XBAR Mux Configuration for TRIP4
    union   TRIP4MUX16TO31CFG_REG            TRIP4MUX16TO31CFG;            // ePWM XBAR Mux Configuration for TRIP4
    union   TRIP5MUX0TO15CFG_REG             TRIP5MUX0TO15CFG;             // ePWM XBAR Mux Configuration for TRIP5
    union   TRIP5MUX16TO31CFG_REG            TRIP5MUX16TO31CFG;            // ePWM XBAR Mux Configuration for TRIP5
    union   TRIP7MUX0TO15CFG_REG             TRIP7MUX0TO15CFG;             // ePWM XBAR Mux Configuration for TRIP7
    union   TRIP7MUX16TO31CFG_REG            TRIP7MUX16TO31CFG;            // ePWM XBAR Mux Configuration for TRIP7
    union   TRIP8MUX0TO15CFG_REG             TRIP8MUX0TO15CFG;             // ePWM XBAR Mux Configuration for TRIP8
    union   TRIP8MUX16TO31CFG_REG            TRIP8MUX16TO31CFG;            // ePWM XBAR Mux Configuration for TRIP8
    union   TRIP9MUX0TO15CFG_REG             TRIP9MUX0TO15CFG;             // ePWM XBAR Mux Configuration for TRIP9
    union   TRIP9MUX16TO31CFG_REG            TRIP9MUX16TO31CFG;            // ePWM XBAR Mux Configuration for TRIP9
    union   TRIP10MUX0TO15CFG_REG            TRIP10MUX0TO15CFG;            // ePWM XBAR Mux Configuration for TRIP10
    union   TRIP10MUX16TO31CFG_REG           TRIP10MUX16TO31CFG;           // ePWM XBAR Mux Configuration for TRIP10
    union   TRIP11MUX0TO15CFG_REG            TRIP11MUX0TO15CFG;            // ePWM XBAR Mux Configuration for TRIP11
    union   TRIP11MUX16TO31CFG_REG           TRIP11MUX16TO31CFG;           // ePWM XBAR Mux Configuration for TRIP11
    union   TRIP12MUX0TO15CFG_REG            TRIP12MUX0TO15CFG;            // ePWM XBAR Mux Configuration for TRIP12
    union   TRIP12MUX16TO31CFG_REG           TRIP12MUX16TO31CFG;           // ePWM XBAR Mux Configuration for TRIP12
    union   TRIP4MUXENABLE_REG               TRIP4MUXENABLE;               // ePWM XBAR Mux Enable for TRIP4
    union   TRIP5MUXENABLE_REG               TRIP5MUXENABLE;               // ePWM XBAR Mux Enable for TRIP5
    union   TRIP7MUXENABLE_REG               TRIP7MUXENABLE;               // ePWM XBAR Mux Enable for TRIP7
    union   TRIP8MUXENABLE_REG               TRIP8MUXENABLE;               // ePWM XBAR Mux Enable for TRIP8
    union   TRIP9MUXENABLE_REG               TRIP9MUXENABLE;               // ePWM XBAR Mux Enable for TRIP9
    union   TRIP10MUXENABLE_REG              TRIP10MUXENABLE;              // ePWM XBAR Mux Enable for TRIP10
    union   TRIP11MUXENABLE_REG              TRIP11MUXENABLE;              // ePWM XBAR Mux Enable for TRIP11
    union   TRIP12MUXENABLE_REG              TRIP12MUXENABLE;              // ePWM XBAR Mux Enable for TRIP12
#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)||IS_GS32F00xx(0x30)
    uint32_t                                   rsvd1[4];                     // Reserved
    union   TRIPOUTINV_REG                   TRIPOUTINV;                   // ePWM XBAR Output Inversion Register
    uint32_t                                   rsvd2[3];                     // Reserved
#if IS_GS32F3xx(0x22)||IS_GS32F00xx(0x30)
    union   TRIP4MUX32TO47CFG_REG             TRIP4MUX32TO47CFG;			//0x80
    union   TRIP4MUX48TO63CFG_REG             TRIP4MUX48TO63CFG;
    union   TRIP5MUX32TO47CFG_REG             TRIP5MUX32TO47CFG;
    union   TRIP5MUX48TO63CFG_REG             TRIP5MUX48TO63CFG;
//    union   TRIP6MUX32TO47CFG_REG             TRIP6MUX32TO47CFG;
//    union   TRIP6MUX48TO63CFG_REG             TRIP6MUX48TO63CFG;
    union   TRIP7MUX32TO47CFG_REG             TRIP7MUX32TO47CFG;
    union   TRIP7MUX48TO63CFG_REG             TRIP7MUX48TO63CFG;
    union   TRIP8MUX32TO47CFG_REG             TRIP8MUX32TO47CFG;
    union   TRIP8MUX48TO63CFG_REG             TRIP8MUX48TO63CFG;
    union   TRIP9MUX32TO47CFG_REG             TRIP9MUX32TO47CFG;
    union   TRIP9MUX48TO63CFG_REG             TRIP9MUX48TO63CFG;
    union   TRIP10MUX32TO47CFG_REG            TRIP10MUX32TO47CFG;
    union   TRIP10MUX48TO63CFG_REG            TRIP10MUX48TO63CFG;
    union   TRIP11MUX32TO47CFG_REG            TRIP11MUX32TO47CFG;
    union   TRIP11MUX48TO63CFG_REG            TRIP11MUX48TO63CFG;
    union   TRIP12MUX32TO47CFG_REG            TRIP12MUX32TO47CFG;
    union   TRIP12MUX48TO63CFG_REG            TRIP12MUX48TO63CFG;
    union   TRIP4MUXENABLE32TO64_REG          TRIP4MUXENABLE32TO64; 		//0xC0
    union   TRIP5MUXENABLE32TO64_REG          TRIP5MUXENABLE32TO64; 
   // union   TRIP6MUXENABLE32TO64_REG          TRIP6MUXENABLE32TO64;
    union   TRIP7MUXENABLE32TO64_REG          TRIP7MUXENABLE32TO64; 
    union   TRIP8MUXENABLE32TO64_REG          TRIP8MUXENABLE32TO64; 
    union   TRIP9MUXENABLE32TO64_REG          TRIP9MUXENABLE32TO64; 
    union   TRIP10MUXENABLE32TO64_REG         TRIP10MUXENABLE32TO64; 
    union   TRIP11MUXENABLE32TO64_REG         TRIP11MUXENABLE32TO64; 
    union   TRIP12MUXENABLE32TO64_REG         TRIP12MUXENABLE32TO64; 		//0xDC
#endif
    uint32_t                                   rsvd3[7];                     // Reserved
    union   TRIPLOCK_REG                     TRIPLOCK;						//0xFC
#endif
};

//---------------------------------------------------------------------------
// EPWM_XBAR External References & Function Declarations:
//
extern volatile struct EPWM_XBAR_REGS EPwmXbarRegs;
#ifdef __cplusplus
}
#endif                                  /* extern "C" */

#endif

//===========================================================================
// End of file.
//===========================================================================
