/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_gpio.h
*   @brief
*   [note: This file is automatically generated and does not need to be
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_GPIO_V12_H
#define REGS_GPIO_V12_H

#if IS_GS32F00xx(0x12)

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// GPIO Individual Register Bit Definitions:

struct DATA_BITS {			// bits   description
	uint32_t	DATA:16;			// 15:0   Data value [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union DATA_REG {
	uint32_t 		 all;
	struct DATA_BITS 		 bit;
};

struct DATAOUT_BITS {			// bits   description
	uint32_t	DATAOUT:16;			// 15:0   Data output Register value [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union DATAOUT_REG {
	uint32_t 		 all;
	struct DATAOUT_BITS 		 bit;
};

struct OUTENSET_BITS {			// bits   description
	uint32_t	OUTENSET:16;			// 15:0   Output enable set [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union OUTENSET_REG {
	uint32_t 		 all;
	struct OUTENSET_BITS 		 bit;
};

struct OUTENCLR_BITS {			// bits   description
	uint32_t	OUTENCLR:16;			// 15:0   Output enable clear [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union OUTENCLR_REG {
	uint32_t 		 all;
	struct OUTENCLR_BITS 		 bit;
};

struct ALTFUNCSET_BITS {			// bits   description
	uint32_t	ALTFUNCSET:16;			// 15:0   Alternative function set [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union ALTFUNCSET_REG {
	uint32_t 		 all;
	struct ALTFUNCSET_BITS 		 bit;
};

struct ALTFUNCCLR_BITS {			// bits   description
	uint32_t	ALTFUNCCLR:16;			// 15:0   Alternative function clear [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union ALTFUNCCLR_REG {
	uint32_t 		 all;
	struct ALTFUNCCLR_BITS 		 bit;
};

struct INTENSET_BITS {			// bits   description
	uint32_t	INTENSET:16;			// 15:0   Interrupt enable set [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTENSET_REG {
	uint32_t 		 all;
	struct INTENSET_BITS 		 bit;
};

struct INTENCLR_BITS {			// bits   description
	uint32_t	INTENCLR:16;			// 15:0   Interrupt enable clear [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTENCLR_REG {
	uint32_t 		 all;
	struct INTENCLR_BITS 		 bit;
};

struct INTTYPESET_BITS {			// bits   description
	uint32_t	INTTYPESET:16;			// 15:0   Interrupt type set [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTTYPESET_REG {
	uint32_t 		 all;
	struct INTTYPESET_BITS 		 bit;
};

struct INTTYPECLR_BITS {			// bits   description
	uint32_t	INTTYPECLR:16;			// 15:0   Interrupt type clear [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTTYPECLR_REG {
	uint32_t 		 all;
	struct INTTYPECLR_BITS 		 bit;
};

struct INTPOLSET_BITS {			// bits   description
	uint32_t	INTPOLSET:16;			// 15:0   Polarity-level, edge IRQ configuration [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTPOLSET_REG {
	uint32_t 		 all;
	struct INTPOLSET_BITS 		 bit;
};

struct INTPOLCLR_BITS {			// bits   description
	uint32_t	INTPOLCLR:16;			// 15:0   Polarity-level, edge IRQ configuration [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTPOLCLR_REG {
	uint32_t 		 all;
	struct INTPOLCLR_BITS 		 bit;
};

struct INTSTATUS_CLEAR_BITS {			// bits   description
	uint32_t	INTSTATUS_CLEAR:16;			// 15:0   Write one to clear interrupt request
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTSTATUS_CLEAR_REG {
	uint32_t 		 all;
	struct INTSTATUS_CLEAR_BITS 		 bit;
};

//struct INTCLEAR_BITS {			// bits   description
//	uint32_t	INTCLEAR:16;			// 15:0   Write one to clear interrupt request
//	uint32_t	rsvd1:16;			// 31:16   reserved
//};
//
//union INTCLEAR_REG {
//	uint32_t 		 all;
//	struct INTCLEAR_BITS 		 bit;
//};

struct MASKLOWBYTE_BITS {			// bits   description
	uint32_t	MASKLOWBYTE:8;			// 7:0   Lower eight bits masked access.
	uint32_t	RAZ_WI:8;			// 15:8   Not used.
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union MASKLOWBYTE_REG {
	uint32_t 		 all;
	struct MASKLOWBYTE_BITS 		 bit;
};

struct MASKHIGHBYTE_BITS {			// bits   description
	uint32_t	RAZ_WI:8;			// 7:0   Not used.
	uint32_t	MASKLOWBYTE:8;			// 15:8   Higher eight bits masked access.
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union MASKHIGHBYTE_REG {
	uint32_t 		 all;
	struct MASKHIGHBYTE_BITS 		 bit;
};



// GPIO Register Definitions:

struct GPIO_REGS {
	union  DATA_REG			  DATA;
	union  DATAOUT_REG			DATAOUT;
	uint32_t 						rsvd1[2]; 		 // reserved
	union  OUTENSET_REG			OUTENSET;
	union  OUTENCLR_REG			OUTENCLR;
	union  ALTFUNCSET_REG			ALTFUNCSET;
	union  ALTFUNCCLR_REG			ALTFUNCCLR;
	union  INTENSET_REG			INTENSET;
	union  INTENCLR_REG			INTENCLR;
	union  INTTYPESET_REG			INTTYPESET;
	union  INTTYPECLR_REG			INTTYPECLR;
	union  INTPOLSET_REG			INTPOLSET;
	union  INTPOLCLR_REG			INTPOLCLR;
	union  INTSTATUS_CLEAR_REG		INTSTATUS_CLEAR;
	//union  INTCLEAR_REG			    INTCLEAR;
	uint32_t 						rsvd2[241]; 		 // reserved
	union  MASKLOWBYTE_REG			MASKLOWBYTE[16];
	uint32_t 						rsvd3[240]; 		 // reserved
	union  MASKHIGHBYTE_REG			MASKHIGHBYTE[16];
};


/***********************************************************
 * Start definition of virtual GPIO Ctrl registers
 **************************************************************/
//---------------------------------------------------------------------------
// GPIO Individual Register Bit Definitions:

struct GPACTRL_BITS {                   // bits description
    Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO0 to GPIO7
    Uint32 QUALPRD0_H:4;                  // 8:4 Qualification sampling period for GPIO0 to GPIO7
    Uint32 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO8 to GPIO15
    Uint32 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO8 to GPIO15
    Uint32 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO16 to GPIO23
    Uint32 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO16 to GPIO23
    Uint32 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO24 to GPIO31
    Uint32 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO24 to GPIO31
};

union GPACTRL_REG {
    Uint32  all;
    struct  GPACTRL_BITS  bit;
};

struct GPAQSEL1_BITS {                  // bits description
    Uint16 GPIO0:2;                     // 1:0 Select input qualification type for GPIO0
    Uint16 GPIO1:2;                     // 3:2 Select input qualification type for GPIO1
    Uint16 GPIO2:2;                     // 5:4 Select input qualification type for GPIO2
    Uint16 GPIO3:2;                     // 7:6 Select input qualification type for GPIO3
    Uint16 GPIO4:2;                     // 9:8 Select input qualification type for GPIO4
    Uint16 GPIO5:2;                     // 11:10 Select input qualification type for GPIO5
    Uint16 GPIO6:2;                     // 13:12 Select input qualification type for GPIO6
    Uint16 GPIO7:2;                     // 15:14 Select input qualification type for GPIO7
    Uint16 GPIO8:2;                     // 17:16 Select input qualification type for GPIO8
    Uint16 GPIO9:2;                     // 19:18 Select input qualification type for GPIO9
    Uint16 GPIO10:2;                    // 21:20 Select input qualification type for GPIO10
    Uint16 GPIO11:2;                    // 23:22 Select input qualification type for GPIO11
    Uint16 GPIO12:2;                    // 25:24 Select input qualification type for GPIO12
    Uint16 GPIO13:2;                    // 27:26 Select input qualification type for GPIO13
    Uint16 GPIO14:2;                    // 29:28 Select input qualification type for GPIO14
    Uint16 GPIO15:2;                    // 31:30 Select input qualification type for GPIO15
};

union GPAQSEL1_REG {
    Uint32  all;
    struct  GPAQSEL1_BITS  bit;
};

struct GPAQSEL2_BITS {                  // bits description
    Uint16 GPIO16:2;                    // 1:0 Select input qualification type for GPIO16
    Uint16 GPIO17:2;                    // 3:2 Select input qualification type for GPIO17
    Uint16 GPIO18:2;                    // 5:4 Select input qualification type for GPIO18
    Uint16 GPIO19:2;                    // 7:6 Select input qualification type for GPIO19
    Uint16 GPIO20:2;                    // 9:8 Select input qualification type for GPIO20
    Uint16 GPIO21:2;                    // 11:10 Select input qualification type for GPIO21
    Uint16 GPIO22:2;                    // 13:12 Select input qualification type for GPIO22
    Uint16 GPIO23:2;                    // 15:14 Select input qualification type for GPIO23
    Uint16 GPIO24:2;                    // 17:16 Select input qualification type for GPIO24
    Uint16 GPIO25:2;                    // 19:18 Select input qualification type for GPIO25
    Uint16 GPIO26:2;                    // 21:20 Select input qualification type for GPIO26
    Uint16 GPIO27:2;                    // 23:22 Select input qualification type for GPIO27
    Uint16 GPIO28:2;                    // 25:24 Select input qualification type for GPIO28
    Uint16 GPIO29:2;                    // 27:26 Select input qualification type for GPIO29
    Uint16 GPIO30:2;                    // 29:28 Select input qualification type for GPIO30
    Uint16 GPIO31:2;                    // 31:30 Select input qualification type for GPIO31
};

union GPAQSEL2_REG {
    Uint32  all;
    struct  GPAQSEL2_BITS  bit;
};

struct GPAMUX1_BITS {                   // bits description
    Uint16 GPIO0:2;                     // 1:0 Defines pin-muxing selection for GPIO0
    Uint16 GPIO1:2;                     // 3:2 Defines pin-muxing selection for GPIO1
    Uint16 GPIO2:2;                     // 5:4 Defines pin-muxing selection for GPIO2
    Uint16 GPIO3:2;                     // 7:6 Defines pin-muxing selection for GPIO3
    Uint16 GPIO4:2;                     // 9:8 Defines pin-muxing selection for GPIO4
    Uint16 GPIO5:2;                     // 11:10 Defines pin-muxing selection for GPIO5
    Uint16 GPIO6:2;                     // 13:12 Defines pin-muxing selection for GPIO6
    Uint16 GPIO7:2;                     // 15:14 Defines pin-muxing selection for GPIO7
    Uint16 GPIO8:2;                     // 17:16 Defines pin-muxing selection for GPIO8
    Uint16 GPIO9:2;                     // 19:18 Defines pin-muxing selection for GPIO9
    Uint16 GPIO10:2;                    // 21:20 Defines pin-muxing selection for GPIO10
    Uint16 GPIO11:2;                    // 23:22 Defines pin-muxing selection for GPIO11
    Uint16 GPIO12:2;                    // 25:24 Defines pin-muxing selection for GPIO12
    Uint16 GPIO13:2;                    // 27:26 Defines pin-muxing selection for GPIO13
    Uint16 GPIO14:2;                    // 29:28 Defines pin-muxing selection for GPIO14
    Uint16 GPIO15:2;                    // 31:30 Defines pin-muxing selection for GPIO15
};

union GPAMUX1_REG {
    Uint32  all;
    struct  GPAMUX1_BITS  bit;
};

struct GPAMUX2_BITS {                   // bits description
    Uint16 GPIO16:2;                    // 1:0 Defines pin-muxing selection for GPIO16
    Uint16 GPIO17:2;                    // 3:2 Defines pin-muxing selection for GPIO17
    Uint16 GPIO18:2;                    // 5:4 Defines pin-muxing selection for GPIO18
    Uint16 GPIO19:2;                    // 7:6 Defines pin-muxing selection for GPIO19
    Uint16 GPIO20:2;                    // 9:8 Defines pin-muxing selection for GPIO20
    Uint16 GPIO21:2;                    // 11:10 Defines pin-muxing selection for GPIO21
    Uint16 GPIO22:2;                    // 13:12 Defines pin-muxing selection for GPIO22
    Uint16 GPIO23:2;                    // 15:14 Defines pin-muxing selection for GPIO23
    Uint16 GPIO24:2;                    // 17:16 Defines pin-muxing selection for GPIO24
    Uint16 GPIO25:2;                    // 19:18 Defines pin-muxing selection for GPIO25
    Uint16 GPIO26:2;                    // 21:20 Defines pin-muxing selection for GPIO26
    Uint16 GPIO27:2;                    // 23:22 Defines pin-muxing selection for GPIO27
    Uint16 GPIO28:2;                    // 25:24 Defines pin-muxing selection for GPIO28
    Uint16 GPIO29:2;                    // 27:26 Defines pin-muxing selection for GPIO29
    Uint16 GPIO30:2;                    // 29:28 Defines pin-muxing selection for GPIO30
    Uint16 GPIO31:2;                    // 31:30 Defines pin-muxing selection for GPIO31
};

union GPAMUX2_REG {
    Uint32  all;
    struct  GPAMUX2_BITS  bit;
};


struct GPAPUD_BITS {                    // bits description
    Uint16 GPIO0:1;                     // 0 Pull-Up Disable control for this pin
    Uint16 GPIO1:1;                     // 1 Pull-Up Disable control for this pin
    Uint16 GPIO2:1;                     // 2 Pull-Up Disable control for this pin
    Uint16 GPIO3:1;                     // 3 Pull-Up Disable control for this pin
    Uint16 GPIO4:1;                     // 4 Pull-Up Disable control for this pin
    Uint16 GPIO5:1;                     // 5 Pull-Up Disable control for this pin
    Uint16 GPIO6:1;                     // 6 Pull-Up Disable control for this pin
    Uint16 GPIO7:1;                     // 7 Pull-Up Disable control for this pin
    Uint16 GPIO8:1;                     // 8 Pull-Up Disable control for this pin
    Uint16 GPIO9:1;                     // 9 Pull-Up Disable control for this pin
    Uint16 GPIO10:1;                    // 10 Pull-Up Disable control for this pin
    Uint16 GPIO11:1;                    // 11 Pull-Up Disable control for this pin
    Uint16 GPIO12:1;                    // 12 Pull-Up Disable control for this pin
    Uint16 GPIO13:1;                    // 13 Pull-Up Disable control for this pin
    Uint16 GPIO14:1;                    // 14 Pull-Up Disable control for this pin
    Uint16 GPIO15:1;                    // 15 Pull-Up Disable control for this pin
    Uint16 GPIO16:1;                    // 16 Pull-Up Disable control for this pin
    Uint16 GPIO17:1;                    // 17 Pull-Up Disable control for this pin
    Uint16 GPIO18:1;                    // 18 Pull-Up Disable control for this pin
    Uint16 GPIO19:1;                    // 19 Pull-Up Disable control for this pin
    Uint16 GPIO20:1;                    // 20 Pull-Up Disable control for this pin
    Uint16 GPIO21:1;                    // 21 Pull-Up Disable control for this pin
    Uint16 GPIO22:1;                    // 22 Pull-Up Disable control for this pin
    Uint16 GPIO23:1;                    // 23 Pull-Up Disable control for this pin
    Uint16 GPIO24:1;                    // 24 Pull-Up Disable control for this pin
    Uint16 GPIO25:1;                    // 25 Pull-Up Disable control for this pin
    Uint16 GPIO26:1;                    // 26 Pull-Up Disable control for this pin
    Uint16 GPIO27:1;                    // 27 Pull-Up Disable control for this pin
    Uint16 GPIO28:1;                    // 28 Pull-Up Disable control for this pin
    Uint16 GPIO29:1;                    // 29 Pull-Up Disable control for this pin
    Uint16 GPIO30:1;                    // 30 Pull-Up Disable control for this pin
    Uint16 GPIO31:1;                    // 31 Pull-Up Disable control for this pin
};

union GPAPUD_REG {
    Uint32  all;
    struct  GPAPUD_BITS  bit;
};

struct GPAINV_BITS {                    // bits description
    Uint16 GPIO0:1;                     // 0 Input inversion control for this pin
    Uint16 GPIO1:1;                     // 1 Input inversion control for this pin
    Uint16 GPIO2:1;                     // 2 Input inversion control for this pin
    Uint16 GPIO3:1;                     // 3 Input inversion control for this pin
    Uint16 GPIO4:1;                     // 4 Input inversion control for this pin
    Uint16 GPIO5:1;                     // 5 Input inversion control for this pin
    Uint16 GPIO6:1;                     // 6 Input inversion control for this pin
    Uint16 GPIO7:1;                     // 7 Input inversion control for this pin
    Uint16 GPIO8:1;                     // 8 Input inversion control for this pin
    Uint16 GPIO9:1;                     // 9 Input inversion control for this pin
    Uint16 GPIO10:1;                    // 10 Input inversion control for this pin
    Uint16 GPIO11:1;                    // 11 Input inversion control for this pin
    Uint16 GPIO12:1;                    // 12 Input inversion control for this pin
    Uint16 GPIO13:1;                    // 13 Input inversion control for this pin
    Uint16 GPIO14:1;                    // 14 Input inversion control for this pin
    Uint16 GPIO15:1;                    // 15 Input inversion control for this pin
    Uint16 GPIO16:1;                    // 16 Input inversion control for this pin
    Uint16 GPIO17:1;                    // 17 Input inversion control for this pin
    Uint16 GPIO18:1;                    // 18 Input inversion control for this pin
    Uint16 GPIO19:1;                    // 19 Input inversion control for this pin
    Uint16 GPIO20:1;                    // 20 Input inversion control for this pin
    Uint16 GPIO21:1;                    // 21 Input inversion control for this pin
    Uint16 GPIO22:1;                    // 22 Input inversion control for this pin
    Uint16 GPIO23:1;                    // 23 Input inversion control for this pin
    Uint16 GPIO24:1;                    // 24 Input inversion control for this pin
    Uint16 GPIO25:1;                    // 25 Input inversion control for this pin
    Uint16 GPIO26:1;                    // 26 Input inversion control for this pin
    Uint16 GPIO27:1;                    // 27 Input inversion control for this pin
    Uint16 GPIO28:1;                    // 28 Input inversion control for this pin
    Uint16 GPIO29:1;                    // 29 Input inversion control for this pin
    Uint16 GPIO30:1;                    // 30 Input inversion control for this pin
    Uint16 GPIO31:1;                    // 31 Input inversion control for this pin
};

union GPAINV_REG {
    Uint32  all;
    struct  GPAINV_BITS  bit;
};



struct GPAAMSEL_BITS {                    // bits description

	Uint32 rsvd1:13;                    // 12:0 Reserved
    Uint32 GPIO13:1;                    // 13  Analog Mode Select for GPIO13
    Uint32 rsvd2:6;                     // 19:14 Reserved
    Uint32 GPIO20:1;                    // 20  Analog Mode Select for GPIO20
    Uint32 GPIO21:1;                    // 21  Analog Mode Select for GPIO21
    Uint32 rsvd3:10;                    // 31:22 Reserved
};

union GPAAMSEL_REG {
    Uint32  all;
    struct  GPAAMSEL_BITS  bit;
};


struct GPAGMUX1_BITS {                  // bits description
    Uint16 GPIO0:2;                     // 1:0 Defines pin-muxing selection for GPIO0
    Uint16 GPIO1:2;                     // 3:2 Defines pin-muxing selection for GPIO1
    Uint16 GPIO2:2;                     // 5:4 Defines pin-muxing selection for GPIO2
    Uint16 GPIO3:2;                     // 7:6 Defines pin-muxing selection for GPIO3
    Uint16 GPIO4:2;                     // 9:8 Defines pin-muxing selection for GPIO4
    Uint16 GPIO5:2;                     // 11:10 Defines pin-muxing selection for GPIO5
    Uint16 GPIO6:2;                     // 13:12 Defines pin-muxing selection for GPIO6
    Uint16 GPIO7:2;                     // 15:14 Defines pin-muxing selection for GPIO7
    Uint16 GPIO8:2;                     // 17:16 Defines pin-muxing selection for GPIO8
    Uint16 GPIO9:2;                     // 19:18 Defines pin-muxing selection for GPIO9
    Uint16 GPIO10:2;                    // 21:20 Defines pin-muxing selection for GPIO10
    Uint16 GPIO11:2;                    // 23:22 Defines pin-muxing selection for GPIO11
    Uint16 GPIO12:2;                    // 25:24 Defines pin-muxing selection for GPIO12
    Uint16 GPIO13:2;                    // 27:26 Defines pin-muxing selection for GPIO13
    Uint16 GPIO14:2;                    // 29:28 Defines pin-muxing selection for GPIO14
    Uint16 GPIO15:2;                    // 31:30 Defines pin-muxing selection for GPIO15
};

union GPAGMUX1_REG {
    Uint32  all;
    struct  GPAGMUX1_BITS  bit;
};

struct GPAGMUX2_BITS {                  // bits description
    Uint16 GPIO16:2;                    // 1:0 Defines pin-muxing selection for GPIO16
    Uint16 GPIO17:2;                    // 3:2 Defines pin-muxing selection for GPIO17
    Uint16 GPIO18:2;                    // 5:4 Defines pin-muxing selection for GPIO18
    Uint16 GPIO19:2;                    // 7:6 Defines pin-muxing selection for GPIO19
    Uint16 GPIO20:2;                    // 9:8 Defines pin-muxing selection for GPIO20
    Uint16 GPIO21:2;                    // 11:10 Defines pin-muxing selection for GPIO21
    Uint16 GPIO22:2;                    // 13:12 Defines pin-muxing selection for GPIO22
    Uint16 GPIO23:2;                    // 15:14 Defines pin-muxing selection for GPIO23
    Uint16 GPIO24:2;                    // 17:16 Defines pin-muxing selection for GPIO24
    Uint16 GPIO25:2;                    // 19:18 Defines pin-muxing selection for GPIO25
    Uint16 GPIO26:2;                    // 21:20 Defines pin-muxing selection for GPIO26
    Uint16 GPIO27:2;                    // 23:22 Defines pin-muxing selection for GPIO27
    Uint16 GPIO28:2;                    // 25:24 Defines pin-muxing selection for GPIO28
    Uint16 GPIO29:2;                    // 27:26 Defines pin-muxing selection for GPIO29
    Uint16 GPIO30:2;                    // 29:28 Defines pin-muxing selection for GPIO30
    Uint16 GPIO31:2;                    // 31:30 Defines pin-muxing selection for GPIO31
};

union GPAGMUX2_REG {
    Uint32  all;
    struct  GPAGMUX2_BITS  bit;
};



struct GPBCTRL_BITS {                   // bits description
    Uint16 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO32 to GPIO39
    Uint16 QUALPRD0_H:4;                  // 7:4 Qualification sampling period for GPIO32 to GPIO39
    Uint16 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO40 to GPIO47
    Uint16 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO40 to GPIO47
    Uint16 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO48 to GPIO55
    Uint16 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO48 to GPIO55
    Uint16 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO56 to GPIO63
    Uint16 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO56 to GPIO63
};

union GPBCTRL_REG {
    Uint32  all;
    struct  GPBCTRL_BITS  bit;
};

struct GPBQSEL1_BITS {                  // bits description
    Uint16 GPIO32:2;                    // 1:0 Select input qualification type for GPIO32
    Uint16 GPIO33:2;                    // 3:2 Select input qualification type for GPIO33
    Uint16 GPIO34:2;                    // 5:4 Select input qualification type for GPIO34
    Uint16 GPIO35:2;                    // 7:6 Select input qualification type for GPIO35
    Uint16 GPIO36:2;                    // 9:8 Select input qualification type for GPIO36
    Uint16 GPIO37:2;                    // 11:10 Select input qualification type for GPIO37
    Uint16 GPIO38:2;                    // 13:12 Select input qualification type for GPIO38
    Uint16 GPIO39:2;                    // 15:14 Select input qualification type for GPIO39
    Uint16 GPIO40:2;                    // 17:16 Select input qualification type for GPIO40
    Uint16 GPIO41:2;                    // 19:18 Select input qualification type for GPIO41
    Uint16 GPIO42:2;                    // 21:20 Select input qualification type for GPIO42
    Uint16 GPIO43:2;                    // 23:22 Select input qualification type for GPIO43
    Uint16 GPIO44:2;                    // 25:24 Select input qualification type for GPIO44
    Uint16 GPIO45:2;                    // 27:26 Select input qualification type for GPIO45
    Uint16 GPIO46:2;                    // 29:28 Select input qualification type for GPIO46
    Uint16 GPIO47:2;                    // 31:30 Select input qualification type for GPIO47
};

union GPBQSEL1_REG {
    Uint32  all;
    struct  GPBQSEL1_BITS  bit;
};

struct GPBQSEL2_BITS {                  // bits description
    Uint16 GPIO48:2;                    // 1:0 Select input qualification type for GPIO48
    Uint16 GPIO49:2;                    // 3:2 Select input qualification type for GPIO49
    Uint16 GPIO50:2;                    // 5:4 Select input qualification type for GPIO50
    Uint16 GPIO51:2;                    // 7:6 Select input qualification type for GPIO51
    Uint16 GPIO52:2;                    // 9:8 Select input qualification type for GPIO52
    Uint16 GPIO53:2;                    // 11:10 Select input qualification type for GPIO53
    Uint16 GPIO54:2;                    // 13:12 Select input qualification type for GPIO54
    Uint16 GPIO55:2;                    // 15:14 Select input qualification type for GPIO55
    Uint16 GPIO56:2;                    // 17:16 Select input qualification type for GPIO56
    Uint16 GPIO57:2;                    // 19:18 Select input qualification type for GPIO57
    Uint16 GPIO58:2;                    // 21:20 Select input qualification type for GPIO58
    Uint16 GPIO59:2;                    // 23:22 Select input qualification type for GPIO59
    Uint16 GPIO60:2;                    // 25:24 Select input qualification type for GPIO60
    Uint16 GPIO61:2;                    // 27:26 Select input qualification type for GPIO61
    Uint16 GPIO62:2;                    // 29:28 Select input qualification type for GPIO62
    Uint16 GPIO63:2;                    // 31:30 Select input qualification type for GPIO63
};

union GPBQSEL2_REG {
    Uint32  all;
    struct  GPBQSEL2_BITS  bit;
};

struct GPBMUX1_BITS {                   // bits description
    Uint16 GPIO32:2;                    // 1:0 Defines pin-muxing selection for GPIO32
    Uint16 GPIO33:2;                    // 3:2 Defines pin-muxing selection for GPIO33
    Uint16 GPIO34:2;                    // 5:4 Defines pin-muxing selection for GPIO34
    Uint16 GPIO35:2;                    // 7:6 Defines pin-muxing selection for GPIO35
    Uint16 GPIO36:2;                    // 9:8 Defines pin-muxing selection for GPIO36
    Uint16 GPIO37:2;                    // 11:10 Defines pin-muxing selection for GPIO37
    Uint16 GPIO38:2;                    // 13:12 Defines pin-muxing selection for GPIO38
    Uint16 GPIO39:2;                    // 15:14 Defines pin-muxing selection for GPIO39
    Uint16 GPIO40:2;                    // 17:16 Defines pin-muxing selection for GPIO40
    Uint16 GPIO41:2;                    // 19:18 Defines pin-muxing selection for GPIO41
    Uint16 GPIO42:2;                    // 21:20 Defines pin-muxing selection for GPIO42
    Uint16 GPIO43:2;                    // 23:22 Defines pin-muxing selection for GPIO43
    Uint16 GPIO44:2;                    // 25:24 Defines pin-muxing selection for GPIO44
    Uint16 GPIO45:2;                    // 27:26 Defines pin-muxing selection for GPIO45
    Uint16 GPIO46:2;                    // 29:28 Defines pin-muxing selection for GPIO46
    Uint16 GPIO47:2;                    // 31:30 Defines pin-muxing selection for GPIO47
};

union GPBMUX1_REG {
    Uint32  all;
    struct  GPBMUX1_BITS  bit;
};

struct GPBMUX2_BITS {                   // bits description
    Uint16 GPIO48:2;                    // 1:0 Defines pin-muxing selection for GPIO48
    Uint16 GPIO49:2;                    // 3:2 Defines pin-muxing selection for GPIO49
    Uint16 GPIO50:2;                    // 5:4 Defines pin-muxing selection for GPIO50
    Uint16 GPIO51:2;                    // 7:6 Defines pin-muxing selection for GPIO51
    Uint16 GPIO52:2;                    // 9:8 Defines pin-muxing selection for GPIO52
    Uint16 GPIO53:2;                    // 11:10 Defines pin-muxing selection for GPIO53
    Uint16 GPIO54:2;                    // 13:12 Defines pin-muxing selection for GPIO54
    Uint16 GPIO55:2;                    // 15:14 Defines pin-muxing selection for GPIO55
    Uint16 GPIO56:2;                    // 17:16 Defines pin-muxing selection for GPIO56
    Uint16 GPIO57:2;                    // 19:18 Defines pin-muxing selection for GPIO57
    Uint16 GPIO58:2;                    // 21:20 Defines pin-muxing selection for GPIO58
    Uint16 GPIO59:2;                    // 23:22 Defines pin-muxing selection for GPIO59
    Uint16 GPIO60:2;                    // 25:24 Defines pin-muxing selection for GPIO60
    Uint16 GPIO61:2;                    // 27:26 Defines pin-muxing selection for GPIO61
    Uint16 GPIO62:2;                    // 29:28 Defines pin-muxing selection for GPIO62
    Uint16 GPIO63:2;                    // 31:30 Defines pin-muxing selection for GPIO63
};

union GPBMUX2_REG {
    Uint32  all;
    struct  GPBMUX2_BITS  bit;
};


struct GPBPUD_BITS {                    // bits description
    Uint16 GPIO32:1;                    // 0 Pull-Up Disable control for this pin
    Uint16 GPIO33:1;                    // 1 Pull-Up Disable control for this pin
    Uint16 GPIO34:1;                    // 2 Pull-Up Disable control for this pin
    Uint16 GPIO35:1;                    // 3 Pull-Up Disable control for this pin
    Uint16 GPIO36:1;                    // 4 Pull-Up Disable control for this pin
    Uint16 GPIO37:1;                    // 5 Pull-Up Disable control for this pin
    Uint16 GPIO38:1;                    // 6 Pull-Up Disable control for this pin
    Uint16 GPIO39:1;                    // 7 Pull-Up Disable control for this pin
    Uint16 GPIO40:1;                    // 8 Pull-Up Disable control for this pin
    Uint16 GPIO41:1;                    // 9 Pull-Up Disable control for this pin
    Uint16 GPIO42:1;                    // 10 Pull-Up Disable control for this pin
    Uint16 GPIO43:1;                    // 11 Pull-Up Disable control for this pin
    Uint16 GPIO44:1;                    // 12 Pull-Up Disable control for this pin
    Uint16 GPIO45:1;                    // 13 Pull-Up Disable control for this pin
    Uint16 GPIO46:1;                    // 14 Pull-Up Disable control for this pin
    Uint16 GPIO47:1;                    // 15 Pull-Up Disable control for this pin
    Uint16 GPIO48:1;                    // 16 Pull-Up Disable control for this pin
    Uint16 GPIO49:1;                    // 17 Pull-Up Disable control for this pin
    Uint16 GPIO50:1;                    // 18 Pull-Up Disable control for this pin
    Uint16 GPIO51:1;                    // 19 Pull-Up Disable control for this pin
    Uint16 GPIO52:1;                    // 20 Pull-Up Disable control for this pin
    Uint16 GPIO53:1;                    // 21 Pull-Up Disable control for this pin
    Uint16 GPIO54:1;                    // 22 Pull-Up Disable control for this pin
    Uint16 GPIO55:1;                    // 23 Pull-Up Disable control for this pin
    Uint16 GPIO56:1;                    // 24 Pull-Up Disable control for this pin
    Uint16 GPIO57:1;                    // 25 Pull-Up Disable control for this pin
    Uint16 GPIO58:1;                    // 26 Pull-Up Disable control for this pin
    Uint16 GPIO59:1;                    // 27 Pull-Up Disable control for this pin
    Uint16 GPIO60:1;                    // 28 Pull-Up Disable control for this pin
    Uint16 GPIO61:1;                    // 29 Pull-Up Disable control for this pin
    Uint16 GPIO62:1;                    // 30 Pull-Up Disable control for this pin
    Uint16 GPIO63:1;                    // 31 Pull-Up Disable control for this pin
};

union GPBPUD_REG {
    Uint32  all;
    struct  GPBPUD_BITS  bit;
};

struct GPBINV_BITS {                    // bits description
    Uint16 GPIO32:1;                    // 0 Input inversion control for this pin
    Uint16 GPIO33:1;                    // 1 Input inversion control for this pin
    Uint16 GPIO34:1;                    // 2 Input inversion control for this pin
    Uint16 GPIO35:1;                    // 3 Input inversion control for this pin
    Uint16 GPIO36:1;                    // 4 Input inversion control for this pin
    Uint16 GPIO37:1;                    // 5 Input inversion control for this pin
    Uint16 GPIO38:1;                    // 6 Input inversion control for this pin
    Uint16 GPIO39:1;                    // 7 Input inversion control for this pin
    Uint16 GPIO40:1;                    // 8 Input inversion control for this pin
    Uint16 GPIO41:1;                    // 9 Input inversion control for this pin
    Uint16 GPIO42:1;                    // 10 Input inversion control for this pin
    Uint16 GPIO43:1;                    // 11 Input inversion control for this pin
    Uint16 GPIO44:1;                    // 12 Input inversion control for this pin
    Uint16 GPIO45:1;                    // 13 Input inversion control for this pin
    Uint16 GPIO46:1;                    // 14 Input inversion control for this pin
    Uint16 GPIO47:1;                    // 15 Input inversion control for this pin
    Uint16 GPIO48:1;                    // 16 Input inversion control for this pin
    Uint16 GPIO49:1;                    // 17 Input inversion control for this pin
    Uint16 GPIO50:1;                    // 18 Input inversion control for this pin
    Uint16 GPIO51:1;                    // 19 Input inversion control for this pin
    Uint16 GPIO52:1;                    // 20 Input inversion control for this pin
    Uint16 GPIO53:1;                    // 21 Input inversion control for this pin
    Uint16 GPIO54:1;                    // 22 Input inversion control for this pin
    Uint16 GPIO55:1;                    // 23 Input inversion control for this pin
    Uint16 GPIO56:1;                    // 24 Input inversion control for this pin
    Uint16 GPIO57:1;                    // 25 Input inversion control for this pin
    Uint16 GPIO58:1;                    // 26 Input inversion control for this pin
    Uint16 GPIO59:1;                    // 27 Input inversion control for this pin
    Uint16 GPIO60:1;                    // 28 Input inversion control for this pin
    Uint16 GPIO61:1;                    // 29 Input inversion control for this pin
    Uint16 GPIO62:1;                    // 30 Input inversion control for this pin
    Uint16 GPIO63:1;                    // 31 Input inversion control for this pin
};

union GPBINV_REG {
    Uint32  all;
    struct  GPBINV_BITS  bit;
};


struct GPBGMUX1_BITS {                  // bits description
    Uint16 GPIO32:2;                    // 1:0 Defines pin-muxing selection for GPIO32
    Uint16 GPIO33:2;                    // 3:2 Defines pin-muxing selection for GPIO33
    Uint16 GPIO34:2;                    // 5:4 Defines pin-muxing selection for GPIO34
    Uint16 GPIO35:2;                    // 7:6 Defines pin-muxing selection for GPIO35
    Uint16 GPIO36:2;                    // 9:8 Defines pin-muxing selection for GPIO36
    Uint16 GPIO37:2;                    // 11:10 Defines pin-muxing selection for GPIO37
    Uint16 GPIO38:2;                    // 13:12 Defines pin-muxing selection for GPIO38
    Uint16 GPIO39:2;                    // 15:14 Defines pin-muxing selection for GPIO39
    Uint16 GPIO40:2;                    // 17:16 Defines pin-muxing selection for GPIO40
    Uint16 GPIO41:2;                    // 19:18 Defines pin-muxing selection for GPIO41
    Uint16 GPIO42:2;                    // 21:20 Defines pin-muxing selection for GPIO42
    Uint16 GPIO43:2;                    // 23:22 Defines pin-muxing selection for GPIO43
    Uint16 GPIO44:2;                    // 25:24 Defines pin-muxing selection for GPIO44
    Uint16 GPIO45:2;                    // 27:26 Defines pin-muxing selection for GPIO45
    Uint16 GPIO46:2;                    // 29:28 Defines pin-muxing selection for GPIO46
    Uint16 GPIO47:2;                    // 31:30 Defines pin-muxing selection for GPIO47
};

union GPBGMUX1_REG {
    Uint32  all;
    struct  GPBGMUX1_BITS  bit;
};

struct GPBGMUX2_BITS {                  // bits description
    Uint16 GPIO48:2;                    // 1:0 Defines pin-muxing selection for GPIO48
    Uint16 GPIO49:2;                    // 3:2 Defines pin-muxing selection for GPIO49
    Uint16 GPIO50:2;                    // 5:4 Defines pin-muxing selection for GPIO50
    Uint16 GPIO51:2;                    // 7:6 Defines pin-muxing selection for GPIO51
    Uint16 GPIO52:2;                    // 9:8 Defines pin-muxing selection for GPIO52
    Uint16 GPIO53:2;                    // 11:10 Defines pin-muxing selection for GPIO53
    Uint16 GPIO54:2;                    // 13:12 Defines pin-muxing selection for GPIO54
    Uint16 GPIO55:2;                    // 15:14 Defines pin-muxing selection for GPIO55
    Uint16 GPIO56:2;                    // 17:16 Defines pin-muxing selection for GPIO56
    Uint16 GPIO57:2;                    // 19:18 Defines pin-muxing selection for GPIO57
    Uint16 GPIO58:2;                    // 21:20 Defines pin-muxing selection for GPIO58
    Uint16 GPIO59:2;                    // 23:22 Defines pin-muxing selection for GPIO59
    Uint16 GPIO60:2;                    // 25:24 Defines pin-muxing selection for GPIO60
    Uint16 GPIO61:2;                    // 27:26 Defines pin-muxing selection for GPIO61
    Uint16 GPIO62:2;                    // 29:28 Defines pin-muxing selection for GPIO62
    Uint16 GPIO63:2;                    // 31:30 Defines pin-muxing selection for GPIO63
};

union GPBGMUX2_REG {
    Uint32  all;
    struct  GPBGMUX2_BITS  bit;
};



struct GPCCTRL_BITS {                   // bits description
	Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO64 to GPIO68
	Uint32 QUALPRD0_H:4;                  // 7:4 Qualification sampling period for GPIO64 to GPIO68
	Uint32 rsvd1:24;                    // 31:8 Reserved
};

union GPCCTRL_REG {
    Uint32  all;
    struct  GPCCTRL_BITS  bit;
};

struct GPCQSEL1_BITS {                  // bits description
	Uint32 GPIO64:2;                    // 1:0 Select input qualification type for GPIO64
    Uint32 GPIO65:2;                    // 3:2 Select input qualification type for GPIO65
    Uint32 GPIO66:2;                    // 5:4 Select input qualification type for GPIO66
    Uint32 GPIO67:2;                    // 7:6 Select input qualification type for GPIO67
    Uint32 GPIO68:2;                    // 9:8 Select input qualification type for GPIO68
    Uint32 rsvd1:22;                    // 31:10 Reserved
};

union GPCQSEL1_REG {
    Uint32  all;
    struct  GPCQSEL1_BITS  bit;
};


struct GPCMUX1_BITS {                   // bits description
	Uint32 GPIO64:2;                    // 1:0 Defines pin-muxing selection for GPIO64
    Uint32 GPIO65:2;                    // 3:2 Defines pin-muxing selection for GPIO65
    Uint32 GPIO66:2;                    // 5:4 Defines pin-muxing selection for GPIO66
    Uint32 GPIO67:2;                    // 7:6 Defines pin-muxing selection for GPIO67
    Uint32 GPIO68:2;                    // 9:8 Defines pin-muxing selection for GPIO68
    Uint32 rsvd1:22;                    // 31:10 Reserved
};

union GPCMUX1_REG {
    Uint32  all;
    struct  GPCMUX1_BITS  bit;
};


struct GPCPUD_BITS {                    // bits description
	Uint32 GPIO64:1;                    // 0 Pull-Up Disable control for this pin
    Uint32 GPIO65:1;                    // 1 Pull-Up Disable control for this pin
    Uint32 GPIO66:1;                    // 2 Pull-Up Disable control for this pin
    Uint32 GPIO67:1;                    // 3 Pull-Up Disable control for this pin
    Uint32 GPIO68:1;                    // 4 Pull-Up Disable control for this pin
	Uint32 rsvd1:27;                    // 31:5 Reserved
};

union GPCPUD_REG {
    Uint32  all;
    struct  GPCPUD_BITS  bit;
};

struct GPCINV_BITS {                    // bits description
	Uint32 GPIO64:1;                    // 0 Input inversion control for this pin
	Uint32 GPIO65:1;                    // 1 Input inversion control for this pin
	Uint32 GPIO66:1;                    // 2 Input inversion control for this pin
	Uint32 GPIO67:1;                    // 3 Input inversion control for this pin
	Uint32 GPIO68:1;                    // 4 Input inversion control for this pin
	Uint32 rsvd1:27;                    // 31:5 Reserved

};

union GPCINV_REG {
    Uint32  all;
    struct  GPCINV_BITS  bit;
};



struct GPCGMUX1_BITS {                  // bits description
    Uint32 GPIO64:2;                    // 1:0 Defines pin-muxing selection for GPIO64
    Uint32 GPIO65:2;                    // 3:2 Defines pin-muxing selection for GPIO65
    Uint32 GPIO66:2;                    // 5:4 Defines pin-muxing selection for GPIO66
    Uint32 GPIO67:2;                    // 7:6 Defines pin-muxing selection for GPIO67
    Uint32 GPIO68:2;                    // 9:8 Defines pin-muxing selection for GPIO68
    Uint32 rsvd1:22;                    // 31:10 Reserved
};

union GPCGMUX1_REG {
    Uint32  all;
    struct  GPCGMUX1_BITS  bit;
};


struct GPAPDD_BITS {                    // bits description
    Uint16 GPIO0:1;                     // 0 Pull-Down Disable control for this pin
    Uint16 GPIO1:1;                     // 1 Pull-Down Disable control for this pin
    Uint16 GPIO2:1;                     // 2 Pull-Down Disable control for this pin
    Uint16 GPIO3:1;                     // 3 Pull-Down Disable control for this pin
    Uint16 GPIO4:1;                     // 4 Pull-Down Disable control for this pin
    Uint16 GPIO5:1;                     // 5 Pull-Down Disable control for this pin
    Uint16 GPIO6:1;                     // 6 Pull-Down Disable control for this pin
    Uint16 GPIO7:1;                     // 7 Pull-Down Disable control for this pin
    Uint16 GPIO8:1;                     // 8 Pull-Down Disable control for this pin
    Uint16 GPIO9:1;                     // 9 Pull-Down Disable control for this pin
    Uint16 GPIO10:1;                    // 10 Pull-Down Disable control for this pin
    Uint16 GPIO11:1;                    // 11 Pull-Down Disable control for this pin
    Uint16 GPIO12:1;                    // 12 Pull-Down Disable control for this pin
    Uint16 GPIO13:1;                    // 13 Pull-Down Disable control for this pin
    Uint16 GPIO14:1;                    // 14 Pull-Down Disable control for this pin
    Uint16 GPIO15:1;                    // 15 Pull-Down Disable control for this pin
    Uint16 GPIO16:1;                    // 16 Pull-Down Disable control for this pin
    Uint16 GPIO17:1;                    // 17 Pull-Down Disable control for this pin
    Uint16 GPIO18:1;                    // 18 Pull-Down Disable control for this pin
    Uint16 GPIO19:1;                    // 19 Pull-Down Disable control for this pin
    Uint16 GPIO20:1;                    // 20 Pull-Down Disable control for this pin
    Uint16 GPIO21:1;                    // 21 Pull-Down Disable control for this pin
    Uint16 GPIO22:1;                    // 22 Pull-Down Disable control for this pin
    Uint16 GPIO23:1;                    // 23 Pull-Down Disable control for this pin
    Uint16 GPIO24:1;                    // 24 Pull-Down Disable control for this pin
    Uint16 GPIO25:1;                    // 25 Pull-Down Disable control for this pin
    Uint16 GPIO26:1;                    // 26 Pull-Down Disable control for this pin
    Uint16 GPIO27:1;                    // 27 Pull-Down Disable control for this pin
    Uint16 GPIO28:1;                    // 28 Pull-Down Disable control for this pin
    Uint16 GPIO29:1;                    // 29 Pull-Down Disable control for this pin
    Uint16 GPIO30:1;                    // 30 Pull-Down Disable control for this pin
    Uint16 GPIO31:1;                    // 31 Pull-Down Disable control for this pin
};

union GPAPDD_REG {
    Uint32  all;
    struct  GPAPDD_BITS  bit;
};

struct GPADS1_BITS {                    // bits description
    Uint16 GPIO0:1;                     // 0 Pull-Down Disable control for this pin
    Uint16 rsvd1:1;                     // 1 Reserved
    Uint16 GPIO1:1;                     // 2 Pull-Down Disable control for this pin
    Uint16 rsvd2:1;                     // 3 Reserved
    Uint16 GPIO2:1;                     // 4 Pull-Down Disable control for this pin
    Uint16 rsvd3:1;                     // 5 Reserved
    Uint16 GPIO3:1;                     // 6 Pull-Down Disable control for this pin
    Uint16 rsvd4:1;                     // 7 Reserved
    Uint16 GPIO4:2;                     // 9:8 Pull-Down Disable control for this pin
    Uint16 GPIO5:2;                     // 11:10 Pull-Down Disable control for this pin
    Uint16 GPIO6:2;                     // 13:12 Pull-Down Disable control for this pin
    Uint16 GPIO7:2;                     // 15:14 Pull-Down Disable control for this pin
    Uint16 GPIO8:1;                     // 16 Pull-Down Disable control for this pin
    Uint16 rsvd5:1;                     // 17 Reserved
    Uint16 GPIO9:1;                     // 18 Pull-Down Disable control for this pin
    Uint16 rsvd6:1;                     // 19 Reserved
    Uint16 GPIO10:1;                    // 20 Pull-Down Disable control for this pin
    Uint16 rsvd7:1;                     // 21 Reserved
    Uint16 GPIO11:2;                    // 23:22 Pull-Down Disable control for this pin
    Uint16 GPIO12:2;                    // 25:24 Pull-Down Disable control for this pin
    Uint16 GPIO13:2;                    // 27:26 Pull-Down Disable control for this pin
    Uint16 GPIO14:2;                    // 29:28 Pull-Down Disable control for this pin
    Uint16 GPIO15:1;                    // 30 Pull-Down Disable control for this pin
    Uint16 rsvd8:1;                     // 31 Reserved
};

union GPADS1_REG {
    Uint32  all;
    struct  GPADS1_BITS  bit;
};

struct GPADS2_BITS {                    // bits description
    Uint16 GPIO16:1;                     // 0 Pull-Down Disable control for this pin
    Uint16 rsvd1:1;                     // 1 Reserved
    Uint16 GPIO17:1;                     // 2 Pull-Down Disable control for this pin
    Uint16 rsvd2:1;                     // 3 Reserved
    Uint16 GPIO18:1;                     // 4 Pull-Down Disable control for this pin
    Uint16 rsvd3:1;                     // 5 Reserved
    Uint16 GPIO19:1;                     // 6 Pull-Down Disable control for this pin
    Uint16 rsvd4:1;                     // 7 Reserved
    Uint16 GPIO20:2;                     // 9:8 Pull-Down Disable control for this pin
    Uint16 GPIO21:2;                     // 11:10 Pull-Down Disable control for this pin
    Uint16 GPIO22:2;                     // 13:12 Pull-Down Disable control for this pin
    Uint16 GPIO23:2;                     // 15:14 Pull-Down Disable control for this pin
    Uint16 GPIO24:1;                     // 16 Pull-Down Disable control for this pin
    Uint16 rsvd5:1;                     // 17 Reserved
    Uint16 GPIO25:1;                     // 18 Pull-Down Disable control for this pin
    Uint16 rsvd6:1;                     // 19 Reserved
    Uint16 GPIO26:1;                    // 20 Pull-Down Disable control for this pin
    Uint16 rsvd7:1;                     // 21 Reserved
    Uint16 GPIO27:1;                    // 22 Pull-Down Disable control for this pin
    Uint16 rsvd8:1;                     // 23 Reserved
    Uint16 GPIO28:1;                    // 24 Pull-Down Disable control for this pin
    Uint16 rsvd9:1;                     // 25 Reserved
    Uint16 GPIO29:1;                    // 26 Pull-Down Disable control for this pin
    Uint16 rsvd10:1;                    // 27 Reserved
    Uint16 GPIO30:2;                    // 29:28 Pull-Down Disable control for this pin
    Uint16 GPIO31:2;                    // 31:30 Pull-Down Disable control for this pin
};

union GPADS2_REG {
    Uint32  all;
    struct  GPADS2_BITS  bit;
};

struct GPAIS_BITS {                    // bits description
    Uint16 GPIO0:1;                     // 0 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO1:1;                     // 1 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO2:1;                     // 2 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO3:1;                     // 3 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO4:1;                     // 4 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO5:1;                     // 5 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO6:1;                     // 6 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO7:1;                     // 7 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO8:1;                     // 8 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO9:1;                     // 9 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO10:1;                    // 10 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO11:1;                    // 11 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO12:1;                    // 12 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO13:1;                    // 13 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO14:1;                    // 14 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO15:1;                    // 15 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO16:1;                    // 16 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO17:1;                    // 17 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO18:1;                    // 18 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO19:1;                    // 19 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO20:1;                    // 20 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO21:1;                    // 21 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO22:1;                    // 22 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO23:1;                    // 23 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO24:1;                    // 24 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO25:1;                    // 25 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO26:1;                    // 26 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO27:1;                    // 27 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO28:1;                    // 28 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO29:1;                    // 29 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO30:1;                    // 30 GPIO A Schmitt Trigger  control for this pin
    Uint16 GPIO31:1;                    // 31 GPIO A Schmitt Trigger  control for this pin
};

union GPAIS_REG {
    Uint32  all;
    struct  GPAIS_BITS  bit;
};

struct GPAOUTINV_BITS {                    // bits description
    Uint16 GPIO0:1;                     // 0 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO1:1;                     // 1 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO2:1;                     // 2 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO3:1;                     // 3 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO4:1;                     // 4 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO5:1;                     // 5 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO6:1;                     // 6 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO7:1;                     // 7 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO8:1;                     // 8 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO9:1;                     // 9 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO10:1;                    // 10 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO11:1;                    // 11 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO12:1;                    // 12 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO13:1;                    // 13 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO14:1;                    // 14 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO15:1;                    // 15 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO16:1;                    // 16 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO17:1;                    // 17 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO18:1;                    // 18 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO19:1;                    // 19 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO20:1;                    // 20 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO21:1;                    // 21 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO22:1;                    // 22 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO23:1;                    // 23 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO24:1;                    // 24 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO25:1;                    // 25 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO26:1;                    // 26 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO27:1;                    // 27 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO28:1;                    // 28 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO29:1;                    // 29 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO30:1;                    // 30 GPIO A output Polarity Invert control for this pin
    Uint16 GPIO31:1;                    // 31 GPIO A output Polarity Invert control for this pin
};

union GPAOUTINV_REG {
    Uint32  all;
    struct  GPAOUTINV_BITS  bit;
};

struct GPALOOPEN_BITS {                    // bits description
    Uint16 GPIO0:1;                     // 0 GPIO A LOOP Enable control for this pin
    Uint16 GPIO1:1;                     // 1 GPIO A LOOP Enable control for this pin
    Uint16 GPIO2:1;                     // 2 GPIO A LOOP Enable control for this pin
    Uint16 GPIO3:1;                     // 3 GPIO A LOOP Enable control for this pin
    Uint16 GPIO4:1;                     // 4 GPIO A LOOP Enable control for this pin
    Uint16 GPIO5:1;                     // 5 GPIO A LOOP Enable control for this pin
    Uint16 GPIO6:1;                     // 6 GPIO A LOOP Enable control for this pin
    Uint16 GPIO7:1;                     // 7 GPIO A LOOP Enable control for this pin
    Uint16 GPIO8:1;                     // 8 GPIO A LOOP Enable control for this pin
    Uint16 GPIO9:1;                     // 9 GPIO A LOOP Enable control for this pin
    Uint16 GPIO10:1;                    // 10 GPIO A LOOP Enable control for this pin
    Uint16 GPIO11:1;                    // 11 GPIO A LOOP Enable control for this pin
    Uint16 GPIO12:1;                    // 12 GPIO A LOOP Enable control for this pin
    Uint16 GPIO13:1;                    // 13 GPIO A LOOP Enable control for this pin
    Uint16 GPIO14:1;                    // 14 GPIO A LOOP Enable control for this pin
    Uint16 GPIO15:1;                    // 15 GPIO A LOOP Enable control for this pin
    Uint16 GPIO16:1;                    // 16 GPIO A LOOP Enable control for this pin
    Uint16 GPIO17:1;                    // 17 GPIO A LOOP Enable control for this pin
    Uint16 GPIO18:1;                    // 18 GPIO A LOOP Enable control for this pin
    Uint16 GPIO19:1;                    // 19 GPIO A LOOP Enable control for this pin
    Uint16 GPIO20:1;                    // 20 GPIO A LOOP Enable control for this pin
    Uint16 GPIO21:1;                    // 21 GPIO A LOOP Enable control for this pin
    Uint16 GPIO22:1;                    // 22 GPIO A LOOP Enable control for this pin
    Uint16 GPIO23:1;                    // 23 GPIO A LOOP Enable control for this pin
    Uint16 GPIO24:1;                    // 24 GPIO A LOOP Enable control for this pin
    Uint16 GPIO25:1;                    // 25 GPIO A LOOP Enable control for this pin
    Uint16 GPIO26:1;                    // 26 GPIO A LOOP Enable control for this pin
    Uint16 GPIO27:1;                    // 27 GPIO A LOOP Enable control for this pin
    Uint16 GPIO28:1;                    // 28 GPIO A LOOP Enable control for this pin
    Uint16 GPIO29:1;                    // 29 GPIO A LOOP Enable control for this pin
    Uint16 GPIO30:1;                    // 30 GPIO A LOOP Enable control for this pin
    Uint16 GPIO31:1;                    // 31 GPIO A LOOP Enable control for this pin
};

union GPALOOPEN_REG {
    Uint32  all;
    struct  GPALOOPEN_BITS  bit;
};

struct GPAPI2C_MODE_BITS {                    // bits description
    Uint16 GPIO0:1;                     // 0 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO1:1;                     // 1 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO2:1;                     // 2 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO3:1;                     // 3 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO4:1;                     // 4 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO5:1;                     // 5 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO6:1;                     // 6 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO7:1;                     // 7 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO8:1;                     // 8 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO9:1;                     // 9 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO10:1;                    // 10 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO11:1;                    // 11 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO12:1;                    // 12 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO13:1;                    // 13 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO14:1;                    // 14 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO15:1;                    // 15 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO16:1;                    // 16 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO17:1;                    // 17 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO18:1;                    // 18 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO19:1;                    // 19 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO20:1;                    // 20 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO21:1;                    // 21 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO22:1;                    // 22 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO23:1;                    // 23 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO24:1;                    // 24 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO25:1;                    // 25 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO26:1;                    // 26 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO27:1;                    // 27 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO28:1;                    // 28 GPIO A  PI2C MODE control for this pin
    Uint16 GPIO29:1;                    // 29 GPIO A  PI2C MODE control for this pin
    Uint16 rsvd1:2;                     // 31:30 Reserved
};

union GPAPI2C_MODE_REG {
    Uint32  all;
    struct  GPAPI2C_MODE_BITS  bit;
};




struct GPBPDD_BITS {                    // bits description
    Uint16 GPIO32:1;                     // 0 Pull-Down Disable control for this pin
    Uint16 GPIO33:1;                     // 1 Pull-Down Disable control for this pin
    Uint16 GPIO34:1;                     // 2 Pull-Down Disable control for this pin
    Uint16 GPIO35:1;                     // 3 Pull-Down Disable control for this pin
    Uint16 GPIO36:1;                     // 4 Pull-Down Disable control for this pin
    Uint16 GPIO37:1;                     // 5 Pull-Down Disable control for this pin
    Uint16 GPIO38:1;                     // 6 Pull-Down Disable control for this pin
    Uint16 GPIO39:1;                     // 7 Pull-Down Disable control for this pin
    Uint16 GPIO40:1;                     // 8 Pull-Down Disable control for this pin
    Uint16 GPIO41:1;                     // 9 Pull-Down Disable control for this pin
    Uint16 GPIO42:1;                    // 10 Pull-Down Disable control for this pin
    Uint16 GPIO43:1;                    // 11 Pull-Down Disable control for this pin
    Uint16 GPIO44:1;                    // 12 Pull-Down Disable control for this pin
    Uint16 GPIO45:1;                    // 13 Pull-Down Disable control for this pin
    Uint16 GPIO46:1;                    // 14 Pull-Down Disable control for this pin
    Uint16 GPIO47:1;                    // 15 Pull-Down Disable control for this pin
    Uint16 GPIO48:1;                    // 16 Pull-Down Disable control for this pin
    Uint16 GPIO49:1;                    // 17 Pull-Down Disable control for this pin
    Uint16 GPIO50:1;                    // 18 Pull-Down Disable control for this pin
    Uint16 GPIO51:1;                    // 19 Pull-Down Disable control for this pin
    Uint16 GPIO52:1;                    // 20 Pull-Down Disable control for this pin
    Uint16 GPIO53:1;                    // 21 Pull-Down Disable control for this pin
    Uint16 GPIO54:1;                    // 22 Pull-Down Disable control for this pin
    Uint16 GPIO55:1;                    // 23 Pull-Down Disable control for this pin
    Uint16 GPIO56:1;                    // 24 Pull-Down Disable control for this pin
    Uint16 GPIO57:1;                    // 25 Pull-Down Disable control for this pin
    Uint16 GPIO58:1;                    // 26 Pull-Down Disable control for this pin
    Uint16 GPIO59:1;                    // 27 Pull-Down Disable control for this pin
    Uint16 GPIO60:1;                    // 28 Pull-Down Disable control for this pin
    Uint16 GPIO61:1;                    // 29 Pull-Down Disable control for this pin
    Uint16 GPIO62:1;                    // 30 Pull-Down Disable control for this pin
    Uint16 GPIO63:1;                    // 31 Pull-Down Disable control for this pin
};

union GPBPDD_REG {
    Uint32  all;
    struct  GPBPDD_BITS  bit;
};

struct GPBDS1_BITS {                    // bits description
    Uint16 GPIO32:1;                     // 0 Pull-Down Disable control for this pin
    Uint16 rsvd1:1;                     // 1 Reserved
    Uint16 GPIO33:1;                     // 2 Pull-Down Disable control for this pin
    Uint16 rsvd2:1;                     // 3 Reserved
    Uint16 GPIO34:1;                     // 4 Pull-Down Disable control for this pin
    Uint16 rsvd3:1;                     // 5 Reserved
    Uint16 GPIO35:1;                     // 6 Pull-Down Disable control for this pin
    Uint16 rsvd4:3;                     // 9:7 Reserved
    Uint16 GPIO37:1;                     // 10 Pull-Down Disable control for this pin
    Uint16 rsvd5:3;                     // 13:11 Reserved
    Uint16 GPIO39:2;                     // 15:14 Pull-Down Disable control for this pin
    Uint16 GPIO40:1;                     // 16 Pull-Down Disable control for this pin
    Uint16 rsvd6:1;                     // 17 Reserved
    Uint16 GPIO41:1;                     // 18 Pull-Down Disable control for this pin
    Uint16 rsvd7:1;                     // 19 Reserved
    Uint16 GPIO42:1;                    // 20 Pull-Down Disable control for this pin
    Uint16 rsvd8:1;                     // 21 Reserved
    Uint16 GPIO43:1;                    // 22 Pull-Down Disable control for this pin
    Uint16 rsvd9:1;                     // 23 Reserved
    Uint16 GPIO44:1;                    // 24 Pull-Down Disable control for this pin
    Uint16 rsvd10:1;                     // 25 Reserved
    Uint16 GPIO45:2;                    // 27:26 Pull-Down Disable control for this pin
    Uint16 GPIO46:1;                    // 28 Pull-Down Disable control for this pin
    Uint16 rsvd11:1;                     // 29 Reserved
    Uint16 GPIO47:1;                    // 30 Pull-Down Disable control for this pin
    Uint16 rsvd12:1;                     // 31 Reserved
};

union GPBDS1_REG {
    Uint32  all;
    struct  GPBDS1_BITS  bit;
};

struct GPBDS2_BITS {                    // bits description
    Uint16 GPIO48:1;                     // 0 Pull-Down Disable control for this pin
    Uint16 rsvd1:1;                     // 1 Reserved
    Uint16 GPIO49:2;                     // 3:2 Pull-Down Disable control for this pin
    Uint16 GPIO50:1;                     // 4 Pull-Down Disable control for this pin
    Uint16 rsvd3:1;                     // 5 Reserved
    Uint16 GPIO51:1;                     // 6 Pull-Down Disable control for this pin
    Uint16 rsvd4:1;                     // 7 Reserved
    Uint16 GPIO52:2;                     // 9:8 Pull-Down Disable control for this pin
    Uint16 GPIO53:2;                     // 11:10 Pull-Down Disable control for this pin
    Uint16 GPIO54:2;                     // 13:12 Pull-Down Disable control for this pin
    Uint16 GPIO55:2;                     // 15:14 Pull-Down Disable control for this pin
    Uint16 GPIO56:1;                     // 16 Pull-Down Disable control for this pin
    Uint16 rsvd5:1;                     // 17 Reserved
    Uint16 GPIO57:1;                    // 18 Pull-Down Disable control for this pin
    Uint16 rsvd6:1;                     // 19 Reserved
    Uint16 GPIO58:2;                    // 21:20 Pull-Down Disable control for this pin
    Uint16 GPIO59:2;                    // 23:22 Pull-Down Disable control for this pin
    Uint16 GPIO60:2;                    // 25:24 Pull-Down Disable control for this pin
    Uint16 GPIO61:2;                    // 27:26:26 Pull-Down Disable control for this pin
    Uint16 GPIO62:2;                    // 29:28 Pull-Down Disable control for this pin
    Uint16 GPIO63:2;                    // 31:30 Pull-Down Disable control for this pin
};

union GPBDS2_REG {
    Uint32  all;
    struct  GPBDS2_BITS  bit;
};

struct GPBIS_BITS {                    // bits description
    Uint16 GPIO32:1;                     // 0 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO33:1;                     // 1 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO34:1;                     // 2 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO35:1;                     // 3 GPIO B Schmitt Trigger  control for this pin
    Uint32 rsvd1:1;					     // 4 Reserved
    Uint16 GPIO37:1;                     // 5 GPIO B Schmitt Trigger  control for this pin
    Uint32 rsvd2:1;					     // 6 Reserved
    Uint16 GPIO39:1;                     // 7 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO40:1;                     // 8 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO41:1;                     // 9 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO42:1;                    // 10 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO43:1;                    // 11 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO44:1;                    // 12 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO45:1;                    // 13 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO46:1;                    // 14 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO47:1;                    // 15 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO48:1;                    // 16 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO49:1;                    // 17 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO50:1;                    // 18 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO51:1;                    // 19 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO52:1;                    // 20 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO53:1;                    // 21 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO54:1;                    // 22 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO55:1;                    // 23 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO56:1;                    // 24 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO57:1;                    // 25 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO58:1;                    // 26 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO59:1;                    // 27 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO60:1;                    // 28 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO61:1;                    // 29 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO62:1;                    // 30 GPIO B Schmitt Trigger  control for this pin
    Uint16 GPIO63:1;                    // 31 GPIO B Schmitt Trigger  control for this pin
};

union GPBIS_REG {
    Uint32  all;
    struct  GPBIS_BITS  bit;
};

struct GPBOUTINV_BITS {                    // bits description
    Uint16 GPIO32:1;                     // 0 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO33:1;                     // 1 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO34:1;                     // 2 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO35:1;                     // 3 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO36:1;                     // 4 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO37:1;                     // 5 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO38:1;                     // 6 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO39:1;                     // 7 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO40:1;                     // 8 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO41:1;                     // 9 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO42:1;                    // 10 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO43:1;                    // 11 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO44:1;                    // 12 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO45:1;                    // 13 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO46:1;                    // 14 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO47:1;                    // 15 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO48:1;                    // 16 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO49:1;                    // 17 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO50:1;                    // 18 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO51:1;                    // 19 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO52:1;                    // 20 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO53:1;                    // 21 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO54:1;                    // 22 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO55:1;                    // 23 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO56:1;                    // 24 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO57:1;                    // 25 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO58:1;                    // 26 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO59:1;                    // 27 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO60:1;                    // 28 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO61:1;                    // 29 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO62:1;                    // 30 GPIO B output Polarity Invert control for this pin
    Uint16 GPIO63:1;                    // 31 GPIO B output Polarity Invert control for this pin
};

union GPBOUTINV_REG {
    Uint32  all;
    struct  GPBOUTINV_BITS  bit;
};

struct GPBLOOPEN_BITS {                    // bits description
    Uint16 GPIO32:1;                     // 0 GPIO B LOOP Enable control for this pin
    Uint16 GPIO33:1;                     // 1 GPIO B LOOP Enable control for this pin
    Uint16 GPIO34:1;                     // 2 GPIO B LOOP Enable control for this pin
    Uint16 GPIO35:1;                     // 3 GPIO B LOOP Enable control for this pin
    Uint16 GPIO36:1;                     // 4 GPIO B LOOP Enable control for this pin
    Uint16 GPIO37:1;                     // 5 GPIO B LOOP Enable control for this pin
    Uint16 GPIO38:1;                     // 6 GPIO B LOOP Enable control for this pin
    Uint16 GPIO39:1;                     // 7 GPIO B LOOP Enable control for this pin
    Uint16 GPIO40:1;                     // 8 GPIO B LOOP Enable control for this pin
    Uint16 GPIO41:1;                     // 9 GPIO B LOOP Enable control for this pin
    Uint16 GPIO42:1;                    // 10 GPIO B LOOP Enable control for this pin
    Uint16 GPIO43:1;                    // 11 GPIO B LOOP Enable control for this pin
    Uint16 GPIO44:1;                    // 12 GPIO B LOOP Enable control for this pin
    Uint16 GPIO45:1;                    // 13 GPIO B LOOP Enable control for this pin
    Uint16 GPIO46:1;                    // 14 GPIO B LOOP Enable control for this pin
    Uint16 GPIO47:1;                    // 15 GPIO B LOOP Enable control for this pin
    Uint16 GPIO48:1;                    // 16 GPIO B LOOP Enable control for this pin
    Uint16 GPIO49:1;                    // 17 GPIO B LOOP Enable control for this pin
    Uint16 GPIO50:1;                    // 18 GPIO B LOOP Enable control for this pin
    Uint16 GPIO51:1;                    // 19 GPIO B LOOP Enable control for this pin
    Uint16 GPIO52:1;                    // 20 GPIO B LOOP Enable control for this pin
    Uint16 GPIO53:1;                    // 21 GPIO B LOOP Enable control for this pin
    Uint16 GPIO54:1;                    // 22 GPIO B LOOP Enable control for this pin
    Uint16 GPIO55:1;                    // 23 GPIO B LOOP Enable control for this pin
    Uint16 GPIO56:1;                    // 24 GPIO B LOOP Enable control for this pin
    Uint16 GPIO57:1;                    // 25 GPIO B LOOP Enable control for this pin
    Uint16 GPIO58:1;                    // 26 GPIO B LOOP Enable control for this pin
    Uint16 GPIO59:1;                    // 27 GPIO B LOOP Enable control for this pin
    Uint16 GPIO60:1;                    // 28 GPIO B LOOP Enable control for this pin
    Uint16 GPIO61:1;                    // 29 GPIO B LOOP Enable control for this pin
    Uint16 GPIO62:1;                    // 30 GPIO B LOOP Enable control for this pin
    Uint16 GPIO63:1;                    // 31 GPIO B LOOP Enable control for this pin
};

union GPBLOOPEN_REG {
    Uint32  all;
    struct  GPBLOOPEN_BITS  bit;
};

struct GPBPI2C_MODE_BITS {                    // bits description
    Uint16 GPIO32:1;                     // 0 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO33:1;                     // 1 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO34:1;                     // 2 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO35:1;                     // 3 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO36:1;                     // 4 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO37:1;                     // 5 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO38:1;                     // 6 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO39:1;                     // 7 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO40:1;                     // 8 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO41:1;                     // 9 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO42:1;                    // 10 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO43:1;                    // 11 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO44:1;                    // 12 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO45:1;                    // 13 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO46:1;                    // 14 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO47:1;                    // 15 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO48:1;                    // 16 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO49:1;                    // 17 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO50:1;                    // 18 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO51:1;                    // 19 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO52:1;                    // 20 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO53:1;                    // 21 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO54:1;                    // 22 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO55:1;                    // 23 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO56:1;                    // 24 GPIO B  PI2C MODE control for this pin
    Uint16 GPIO57:1;                    // 25 GPIO B  PI2C MODE control for this pin
    Uint16 rsvd1:6;                     // 31:30 Reserved
};

union GPBPI2C_MODE_REG {
    Uint32  all;
    struct  GPBPI2C_MODE_BITS  bit;
};


struct GPCPDD_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 Pull-Down Disable control for this pin
    Uint32 GPIO65:1;                     // 1 Pull-Down Disable control for this pin
    Uint32 GPIO66:1;                     // 2 Pull-Down Disable control for this pin
    Uint32 GPIO67:1;                     // 3 Pull-Down Disable control for this pin
    Uint32 GPIO68:1;                     // 4 Pull-Down Disable control for this pin
    Uint32 rsvd1:27;					 // Reserved
};

union GPCPDD_REG {
    Uint32  all;
    struct  GPCPDD_BITS  bit;
};

struct GPCDS1_BITS {                    // bits description
    Uint32 GPIO64:2;                     // 1:0 Pull-Down Disable control for this pin
    Uint32 GPIO65:2;                     // 3:2 Pull-Down Disable control for this pin
    Uint32 GPIO66:2;                     // 5:4 Pull-Down Disable control for this pin
    Uint32 GPIO67:2;                     // 7:6 Pull-Down Disable control for this pin
    Uint32 GPIO68:2;                     // 9:8 Pull-Down Disable control for this pin
    Uint32 rsvd1:22;					 // Reserved
};

union GPCDS1_REG {
    Uint32  all;
    struct  GPCDS1_BITS  bit;
};


struct GPCIS_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 GPIO C Schmitt Trigger  control for this pin
    Uint32 GPIO65:1;                     // 1 GPIO C Schmitt Trigger  control for this pin
    Uint32 GPIO66:1;                     // 2 GPIO C Schmitt Trigger  control for this pin
    Uint32 GPIO67:1;                     // 3 GPIO C Schmitt Trigger  control for this pin
    Uint32 GPIO68:1;                     // 4 GPIO C Schmitt Trigger  control for this pin
    Uint32 rsvd1:27;					 // Reserved
};

union GPCIS_REG {
    Uint32  all;
    struct  GPCIS_BITS  bit;
};

struct GPCOUTINV_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 GPIO C output Polarity Invert control for this pin
    Uint32 GPIO65:1;                     // 1 GPIO C output Polarity Invert control for this pin
    Uint32 GPIO66:1;                     // 2 GPIO C output Polarity Invert control for this pin
    Uint32 GPIO67:1;                     // 3 GPIO C output Polarity Invert control for this pin
    Uint32 GPIO68:1;                     // 4 GPIO C output Polarity Invert control for this pin
    Uint32 rsvd1:27;					 // Reserved
};

union GPCOUTINV_REG {
    Uint32  all;
    struct  GPCOUTINV_BITS  bit;
};

struct GPCLOOPEN_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 GPIO C LOOP Enable control for this pin
    Uint32 GPIO65:1;                     // 1 GPIO C LOOP Enable control for this pin
    Uint32 GPIO66:1;                     // 2 GPIO C LOOP Enable control for this pin
    Uint32 GPIO67:1;                     // 3 GPIO C LOOP Enable control for this pin
    Uint32 GPIO68:1;                     // 4 GPIO C LOOP Enable control for this pin
    Uint32 rsvd1:27;					 // Reserved
};

union GPCLOOPEN_REG {
    Uint32  all;
    struct  GPCLOOPEN_BITS  bit;
};

struct GPHIS_BITS {                    // bits description
    Uint16 GPIO224:1;                    // 0 Schmitt Trigger control for this pin
    Uint16 GPIO225:1;                    // 1 Schmitt Trigger control for this pin
    Uint16 GPIO226:1;                    // 2 Schmitt Trigger control for this pin
    Uint16 GPIO227:1;                    // 3 Schmitt Trigger control for this pin
    Uint16 GPIO228:1;                    // 4 Schmitt Trigger control for this pin
    Uint16 GPIO229:1;                    // 5 Schmitt Trigger control for this pin
    Uint16 GPIO230:1;                    // 6 Schmitt Trigger control for this pin
    Uint16 GPIO231:1;                    // 7 Schmitt Trigger control for this pin
    Uint16 GPIO232:1;                    // 8 Schmitt Trigger control for this pin
    Uint16 GPIO233:1;                    // 9 Schmitt Trigger control for this pin
    Uint16 GPIO234:1;                    // 10 Schmitt Trigger control for this pin
    Uint16 GPIO235:1;                    // 11 Schmitt Trigger control for this pin
    Uint16 GPIO236:1;                    // 12 Schmitt Trigger control for this pin
    Uint16 GPIO237:1;                    // 13 Schmitt Trigger control for this pin
    Uint16 GPIO238:1;                    // 14 Schmitt Trigger control for this pin
    Uint16 GPIO239:1;                    // 15 Schmitt Trigger control for this pin
    Uint16 GPIO240:1;                    // 16 Schmitt Trigger control for this pin
    Uint16 GPIO241:1;                    // 17 Schmitt Trigger control for this pin
    Uint16 GPIO242:1;                    // 18 Schmitt Trigger control for this pin
    Uint16 GPIO243:1;                    // 19 Schmitt Trigger control for this pin
    Uint16 GPIO244:1;                    // 20 Schmitt Trigger control for this pin
    Uint16 GPIO245:1;                    // 21 Schmitt Trigger control for this pin
    Uint16 GPIO246:1;                    // 22 Schmitt Trigger control for this pin
    Uint16 GPIO247:1;                    // 23 Schmitt Trigger control for this pin
    Uint16 GPIO248:1;                    // 24 Schmitt Trigger control for this pin
    Uint16 GPIO249:1;                    // 25 Schmitt Trigger control for this pin
    Uint16 GPIO250:1;                    // 26 Schmitt Trigger control for this pin
    Uint16 GPIO251:1;                    // 27 Schmitt Trigger control for this pin
    Uint16 GPIO252:1;                    // 28 Schmitt Trigger control for this pin
    Uint16 GPIO253:1;                    // 29 Schmitt Trigger control for this pin
    Uint16 GPIO254:1;                    // 30 Schmitt Trigger control for this pin
    Uint32 rsvd1:1;					     //31 Reserved
};

union GPHIS_REG {
    Uint32  all;
    struct  GPHIS_BITS  bit;
};

struct GPHIE_BITS {                    // bits description
    Uint16 GPIO224:1;                    // 0 input Enable control for this pin
    Uint16 GPIO225:1;                    // 1 input Enable control for this pin
    Uint16 GPIO226:1;                    // 2 input Enable control for this pin
    Uint16 GPIO227:1;                    // 3 input Enable control for this pin
    Uint16 GPIO228:1;                    // 4 input Enable control for this pin
    Uint16 GPIO229:1;                    // 5 input Enable control for this pin
    Uint16 GPIO230:1;                    // 6 input Enable control for this pin
    Uint16 GPIO231:1;                    // 7 input Enable control for this pin
    Uint16 GPIO232:1;                    // 8 input Enable control for this pin
    Uint16 GPIO233:1;                    // 9 input Enable control for this pin
    Uint16 GPIO234:1;                    // 10 input Enable control for this pin
    Uint16 GPIO235:1;                    // 11 input Enable control for this pin
    Uint16 GPIO236:1;                    // 12 input Enable control for this pin
    Uint16 GPIO237:1;                    // 13 input Enable control for this pin
    Uint16 GPIO238:1;                    // 14 input Enable control for this pin
    Uint16 GPIO239:1;                    // 15 input Enable control for this pin
    Uint16 GPIO240:1;                    // 16 input Enable control for this pin
    Uint16 GPIO241:1;                    // 17 input Enable control for this pin
    Uint16 GPIO242:1;                    // 18 input Enable control for this pin
    Uint16 GPIO243:1;                    // 19 input Enable control for this pin
    Uint16 GPIO244:1;                    // 20 input Enable control for this pin
    Uint16 GPIO245:1;                    // 21 input Enable control for this pin
    Uint16 GPIO246:1;                    // 22 input Enable control for this pin
    Uint16 GPIO247:1;                    // 23 input Enable control for this pin
    Uint16 GPIO248:1;                    // 24 input Enable control for this pin
    Uint16 GPIO249:1;                    // 25 input Enable control for this pin
    Uint16 GPIO250:1;                    // 26 input Enable control for this pin
    Uint16 GPIO251:1;                    // 27 input Enable control for this pin
    Uint16 GPIO252:1;                    // 28 input Enable control for this pin
    Uint16 GPIO253:1;                    // 29 input Enable control for this pin
    Uint16 GPIO254:1;                    // 30 input Enable control for this pin
    Uint32 rsvd1:1;					     //31 Reserved
};

union GPHIE_REG {
    Uint32  all;
    struct  GPHIE_BITS  bit;
};

//
//struct CLK_REF_PIN_CTRL_BITS {                   // bits description
//    Uint32 CLK_REF_PIN_CTRL:5;                  // 4:0
//    Uint32 rsvd1:27;					     //31:5 Reserved
//};
//
//union CLK_REF_PIN_CTRL_REG {
//    Uint32  all;
//    struct  CLK_REF_PIN_CTRL_BITS  bit;
//};
//
//struct IO_IE_MODE_BITS {                   // bits description
//    Uint32 IO_IE_MODE:1;                  // 0
//    Uint32 rsvd1:31;					     //31:1 Reserved
//};
//
//union IO_IE_MODE_REG {
//    Uint32  all;
//    struct  IO_IE_MODE_BITS  bit;
//};
//
//struct LPMCR_QUALSTDBY_BITS {                   // bits description
//	Uint32 rsvd1:2;					    //1:0 Reserved
//	Uint32 QUALSTDBY:6;                  //7:2
//    Uint32 rsvd2:24;					//31:8 Reserved
//};
//
//union LPMCR_QUALSTDBY_REG {
//    Uint32  all;
//    struct  LPMCR_QUALSTDBY_BITS  bit;
//};
//
//struct IO_SET_STDBY_BITS {                   // bits description
//	Uint32 IO_SET_STDBY:32;                  //31:0
//};
//
//union IO_SET_STDBY_REG {
//    Uint32  all;
//    struct  IO_SET_STDBY_BITS  bit;
//};
//
//struct GPIOLPMSEL0_BITS {                   // bits description
//	Uint32 GPIOLPMSEL0:32;                  //31:0
//};
//
//union GPIOLPMSEL0_REG {
//    Uint32  all;
//    struct  GPIOLPMSEL0_BITS  bit;
//};
//
//struct GPIOLPMSEL1_BITS {                   // bits description
//	Uint32 GPIOLPMSEL1:32;                  //31:0
//};
//
//union GPIOLPMSEL1_REG {
//    Uint32  all;
//    struct  GPIOLPMSEL1_BITS  bit;
//};
//
//struct GPIOLPMSEL2_BITS {                   // bits description
//	Uint32 GPIOLPMSEL2:32;                  //31:0
//};
//
//union GPIOLPMSEL2_REG {
//    Uint32  all;
//    struct  GPIOLPMSEL2_BITS  bit;
//};
//

struct GPHCTRL_BITS {                   // bits description
    Uint16 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO224 to GPIO231
    Uint16 QUALPRD0_H:4;                  // 7:4 Qualification sampling period for GPIO224 to GPIO231
    Uint16 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO232 to GPIO239
    Uint16 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO232 to GPIO239
    Uint16 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO240 to GPIO247
    Uint16 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO240 to GPIO247
    Uint16 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO248 to GPIO255
    Uint16 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO248 to GPIO255
};

union GPHCTRL_REG {
    Uint32  all;
    struct  GPHCTRL_BITS  bit;
};

struct GPHQSEL1_BITS {                  // bits description
    Uint16 GPIO224:2;                    // 1:0 Select input qualification type for GPIO224
    Uint16 GPIO225:2;                    // 3:2 Select input qualification type for GPIO225
    Uint16 GPIO226:2;                    // 5:4 Select input qualification type for GPIO226
    Uint16 GPIO227:2;                    // 7:6 Select input qualification type for GPIO227
    Uint16 GPIO228:2;                    // 9:8 Select input qualification type for GPIO228
    Uint16 GPIO229:2;                    // 11:10 Select input qualification type for GPIO229
    Uint16 GPIO230:2;                    // 13:12 Select input qualification type for GPIO230
    Uint16 GPIO231:2;                    // 15:14 Select input qualification type for GPIO231
    Uint16 GPIO232:2;                    // 17:16 Select input qualification type for GPIO232
    Uint16 GPIO233:2;                    // 19:18 Select input qualification type for GPIO233
    Uint16 GPIO234:2;                    // 21:20 Select input qualification type for GPIO234
    Uint16 GPIO235:2;                    // 23:22 Select input qualification type for GPIO235
    Uint16 GPIO236:2;                    // 25:24 Select input qualification type for GPIO236
    Uint16 GPIO237:2;                    // 27:26 Select input qualification type for GPIO237
    Uint16 GPIO238:2;                    // 29:28 Select input qualification type for GPIO238
    Uint16 GPIO239:2;                    // 31:30 Select input qualification type for GPIO239
};

union GPHQSEL1_REG {
    Uint32  all;
    struct  GPHQSEL1_BITS  bit;
};

struct GPHQSEL2_BITS {                  // bits description
    Uint16 GPIO240:2;                    // 1:0 Select input qualification type for GPIO240
    Uint16 GPIO241:2;                    // 3:2 Select input qualification type for GPIO241
    Uint16 GPIO242:2;                    // 5:4 Select input qualification type for GPIO242
    Uint16 GPIO243:2;                    // 7:6 Select input qualification type for GPIO243
    Uint16 GPIO244:2;                    // 9:8 Select input qualification type for GPIO244
    Uint16 GPIO245:2;                    // 11:10 Select input qualification type for GPIO245
    Uint16 GPIO246:2;                    // 13:12 Select input qualification type for GPIO246
    Uint16 GPIO247:2;                    // 15:14 Select input qualification type for GPIO247
    Uint16 GPIO248:2;                    // 17:16 Select input qualification type for GPIO248
    Uint16 GPIO249:2;                    // 19:18 Select input qualification type for GPIO249
    Uint16 GPIO250:2;                    // 21:20 Select input qualification type for GPIO250
    Uint16 GPIO251:2;                    // 23:22 Select input qualification type for GPIO251
    Uint16 GPIO252:2;                    // 25:24 Select input qualification type for GPIO252
    Uint16 GPIO253:2;                    // 27:26 Select input qualification type for GPIO253
    Uint16 GPIO254:2;                    // 29:28 Select input qualification type for GPIO254
    Uint16 rsvd1:2;                      // 31:30 Reserved
};

union GPHQSEL2_REG {
    Uint32  all;
    struct  GPHQSEL2_BITS  bit;
};

struct GPHMUX1_BITS {                   // bits description
    Uint16 GPIO224:2;                    // 1:0 Defines pin-muxing selection for GPIO224
    Uint16 GPIO225:2;                    // 3:2 Defines pin-muxing selection for GPIO225
    Uint16 GPIO226:2;                    // 5:4 Defines pin-muxing selection for GPIO226
    Uint16 GPIO227:2;                    // 7:6 Defines pin-muxing selection for GPIO227
    Uint16 GPIO228:2;                    // 9:8 Defines pin-muxing selection for GPIO228
    Uint16 GPIO229:2;                    // 11:10 Defines pin-muxing selection for GPIO229
    Uint16 GPIO230:2;                    // 13:12 Defines pin-muxing selection for GPIO230
    Uint16 GPIO231:2;                    // 15:14 Defines pin-muxing selection for GPIO231
    Uint16 GPIO232:2;                    // 17:16 Defines pin-muxing selection for GPIO232
    Uint16 GPIO233:2;                    // 19:18 Defines pin-muxing selection for GPIO233
    Uint16 GPIO234:2;                    // 21:20 Defines pin-muxing selection for GPIO234
    Uint16 GPIO235:2;                    // 23:22 Defines pin-muxing selection for GPIO235
    Uint16 GPIO236:2;                    // 25:24 Defines pin-muxing selection for GPIO236
    Uint16 GPIO237:2;                    // 27:26 Defines pin-muxing selection for GPIO237
    Uint16 GPIO238:2;                    // 29:28 Defines pin-muxing selection for GPIO238
    Uint16 GPIO239:2;                    // 31:30 Defines pin-muxing selection for GPIO239
};

union GPHMUX1_REG {
    Uint32  all;
    struct  GPHMUX1_BITS  bit;
};

struct GPHMUX2_BITS {                   // bits description
    Uint16 GPIO240:2;                    // 1:0 Defines pin-muxing selection for GPIO240
    Uint16 GPIO241:2;                    // 3:2 Defines pin-muxing selection for GPIO241
    Uint16 GPIO242:2;                    // 5:4 Defines pin-muxing selection for GPIO242
    Uint16 GPIO243:2;                    // 7:6 Defines pin-muxing selection for GPIO243
    Uint16 GPIO244:2;                    // 9:8 Defines pin-muxing selection for GPIO244
    Uint16 GPIO245:2;                    // 11:10 Defines pin-muxing selection for GPIO245
    Uint16 GPIO246:2;                    // 13:12 Defines pin-muxing selection for GPIO246
    Uint16 GPIO247:2;                    // 15:14 Defines pin-muxing selection for GPIO247
    Uint16 GPIO248:2;                    // 17:16 Defines pin-muxing selection for GPIO248
    Uint16 GPIO249:2;                    // 19:18 Defines pin-muxing selection for GPIO249
    Uint16 GPIO250:2;                    // 21:20 Defines pin-muxing selection for GPIO250
    Uint16 GPIO251:2;                    // 23:22 Defines pin-muxing selection for GPIO251
    Uint16 GPIO252:2;                    // 25:24 Defines pin-muxing selection for GPIO252
    Uint16 GPIO253:2;                    // 27:26 Defines pin-muxing selection for GPIO253
    Uint16 GPIO254:2;                    // 29:28 Defines pin-muxing selection for GPIO254
    Uint16 rsvd1:2;                      // 31:30 Reserved
};

union GPHMUX2_REG {
    Uint32  all;
    struct  GPHMUX2_BITS  bit;
};



struct GPHINV_BITS {                    // bits description
    Uint16 GPIO224:1;                    // 0 Input inversion control for this pin
    Uint16 GPIO225:1;                    // 1 Input inversion control for this pin
    Uint16 GPIO226:1;                    // 2 Input inversion control for this pin
    Uint16 GPIO227:1;                    // 3 Input inversion control for this pin
    Uint16 GPIO228:1;                    // 4 Input inversion control for this pin
    Uint16 GPIO229:1;                    // 5 Input inversion control for this pin
    Uint16 GPIO230:1;                    // 6 Input inversion control for this pin
    Uint16 GPIO231:1;                    // 7 Input inversion control for this pin
    Uint16 GPIO232:1;                    // 8 Input inversion control for this pin
    Uint16 GPIO233:1;                    // 9 Input inversion control for this pin
    Uint16 GPIO234:1;                    // 10 Input inversion control for this pin
    Uint16 GPIO235:1;                    // 11 Input inversion control for this pin
    Uint16 GPIO236:1;                    // 12 Input inversion control for this pin
    Uint16 GPIO237:1;                    // 13 Input inversion control for this pin
    Uint16 GPIO238:1;                    // 14 Input inversion control for this pin
    Uint16 GPIO239:1;                    // 15 Input inversion control for this pin
    Uint16 GPIO240:1;                    // 16 Input inversion control for this pin
    Uint16 GPIO241:1;                    // 17 Input inversion control for this pin
    Uint16 GPIO242:1;                    // 18 Input inversion control for this pin
    Uint16 GPIO243:1;                    // 19 Input inversion control for this pin
    Uint16 GPIO244:1;                    // 20 Input inversion control for this pin
    Uint16 GPIO245:1;                    // 21 Input inversion control for this pin
    Uint16 GPIO246:1;                    // 22 Input inversion control for this pin
    Uint16 GPIO247:1;                    // 23 Input inversion control for this pin
    Uint16 GPIO248:1;                    // 24 Input inversion control for this pin
    Uint16 GPIO249:1;                    // 25 Input inversion control for this pin
    Uint16 GPIO250:1;                    // 26 Input inversion control for this pin
    Uint16 GPIO251:1;                    // 27 Input inversion control for this pin
    Uint16 GPIO252:1;                    // 28 Input inversion control for this pin
    Uint16 GPIO253:1;                    // 29 Input inversion control for this pin
    Uint16 GPIO254:1;                    // 30 Input inversion control for this pin
    Uint16 rsvd1:1;                      // 31 Reserved
};

union GPHINV_REG {
    Uint32  all;
    struct  GPHINV_BITS  bit;
};

struct GPHAMSEL_BITS {                    // bits description
    Uint16 GPIO224:1;                    // 0 Input inversion control for this pin
    Uint16 GPIO225:1;                    // 1 Input inversion control for this pin
    Uint16 GPIO226:1;                    // 2 Input inversion control for this pin
    Uint16 GPIO227:1;                    // 3 Input inversion control for this pin
    Uint16 GPIO228:1;                    // 4 Input inversion control for this pin
    Uint16 GPIO229:1;                    // 5 Input inversion control for this pin
    Uint16 GPIO230:1;                    // 6 Input inversion control for this pin
    Uint16 GPIO231:1;                    // 7 Input inversion control for this pin
    Uint16 GPIO232:1;                    // 8 Input inversion control for this pin
    Uint16 GPIO233:1;                    // 9 Input inversion control for this pin
    Uint16 GPIO234:1;                    // 10 Input inversion control for this pin
    Uint16 GPIO235:1;                    // 11 Input inversion control for this pin
    Uint16 GPIO236:1;                    // 12 Input inversion control for this pin
    Uint16 GPIO237:1;                    // 13 Input inversion control for this pin
    Uint16 GPIO238:1;                    // 14 Input inversion control for this pin
    Uint16 GPIO239:1;                    // 15 Input inversion control for this pin
    Uint16 GPIO240:1;                    // 16 Input inversion control for this pin
    Uint16 GPIO241:1;                    // 17 Input inversion control for this pin
    Uint16 GPIO242:1;                    // 18 Input inversion control for this pin
    Uint16 GPIO243:1;                    // 19 Input inversion control for this pin
    Uint16 GPIO244:1;                    // 20 Input inversion control for this pin
    Uint16 GPIO245:1;                    // 21 Input inversion control for this pin
    Uint16 GPIO246:1;                    // 22 Input inversion control for this pin
    Uint16 GPIO247:1;                    // 23 Input inversion control for this pin
    Uint16 GPIO248:1;                    // 24 Input inversion control for this pin
    Uint16 GPIO249:1;                    // 25 Input inversion control for this pin
    Uint16 GPIO250:1;                    // 26 Input inversion control for this pin
    Uint16 GPIO251:1;                    // 27 Input inversion control for this pin
    Uint16 GPIO252:1;                    // 28 Input inversion control for this pin
    Uint16 GPIO253:1;                    // 29 Input inversion control for this pin
    Uint16 GPIO254:1;                    // 30 Input inversion control for this pin
    Uint16 rsvd1:1;                      // 31 Reserved
};

union GPHAMSEL_REG {
    Uint32  all;
    struct  GPHAMSEL_BITS  bit;
};

struct GPHGMUX1_BITS {                  // bits description
    Uint16 GPIO224:2;                    // 1:0 Defines pin-muxing selection for GPIO224
    Uint16 GPIO225:2;                    // 3:2 Defines pin-muxing selection for GPIO225
    Uint16 GPIO226:2;                    // 5:4 Defines pin-muxing selection for GPIO226
    Uint16 GPIO227:2;                    // 7:6 Defines pin-muxing selection for GPIO227
    Uint16 GPIO228:2;                    // 9:8 Defines pin-muxing selection for GPIO228
    Uint16 GPIO229:2;                    // 11:10 Defines pin-muxing selection for GPIO229
    Uint16 GPIO230:2;                    // 13:12 Defines pin-muxing selection for GPIO230
    Uint16 GPIO231:2;                    // 15:14 Defines pin-muxing selection for GPIO231
    Uint16 GPIO232:2;                    // 17:16 Defines pin-muxing selection for GPIO232
    Uint16 GPIO233:2;                    // 19:18 Defines pin-muxing selection for GPIO233
    Uint16 GPIO234:2;                    // 21:20 Defines pin-muxing selection for GPIO234
    Uint16 GPIO235:2;                    // 23:22 Defines pin-muxing selection for GPIO235
    Uint16 GPIO236:2;                    // 25:24 Defines pin-muxing selection for GPIO236
    Uint16 GPIO237:2;                    // 27:26 Defines pin-muxing selection for GPIO237
    Uint16 GPIO238:2;                    // 29:28 Defines pin-muxing selection for GPIO238
    Uint16 GPIO239:2;                    // 31:30 Defines pin-muxing selection for GPIO239
};

union GPHGMUX1_REG {
    Uint32  all;
    struct  GPHGMUX1_BITS  bit;
};

struct GPHGMUX2_BITS {                  // bits description
    Uint16 GPIO240:2;                    // 1:0 Defines pin-muxing selection for GPIO240
    Uint16 GPIO241:2;                    // 3:2 Defines pin-muxing selection for GPIO241
    Uint16 GPIO242:2;                    // 5:4 Defines pin-muxing selection for GPIO242
    Uint16 GPIO243:2;                    // 7:6 Defines pin-muxing selection for GPIO243
    Uint16 GPIO244:2;                    // 9:8 Defines pin-muxing selection for GPIO244
    Uint16 GPIO245:2;                    // 11:10 Defines pin-muxing selection for GPIO245
    Uint16 GPIO246:2;                    // 13:12 Defines pin-muxing selection for GPIO246
    Uint16 GPIO247:2;                    // 15:14 Defines pin-muxing selection for GPIO247
    Uint16 GPIO248:2;                    // 17:16 Defines pin-muxing selection for GPIO248
    Uint16 GPIO249:2;                    // 19:18 Defines pin-muxing selection for GPIO249
    Uint16 GPIO250:2;                    // 21:20 Defines pin-muxing selection for GPIO250
    Uint16 GPIO251:2;                    // 23:22 Defines pin-muxing selection for GPIO251
    Uint16 GPIO252:2;                    // 25:24 Defines pin-muxing selection for GPIO252
    Uint16 GPIO253:2;                    // 27:26 Defines pin-muxing selection for GPIO253
    Uint16 GPIO254:2;                    // 29:28 Defines pin-muxing selection for GPIO254
    Uint16 rsvd1:2;                      // 31:30 Reserved
};

union GPHGMUX2_REG {
    Uint32  all;
    struct  GPHGMUX2_BITS  bit;
};



struct GPIO_CTRL_REGS {
    union   GPACTRL_REG                      GPACTRL;                      // GPIO A Qualification Sampling Period Control (GPIO0 to 31)
    union   GPAQSEL1_REG                     GPAQSEL1;                     // GPIO A Qualifier Select 1 Register (GPIO0 to 15)
    union   GPAQSEL2_REG                     GPAQSEL2;                     // GPIO A Qualifier Select 2 Register (GPIO16 to 31)
    union   GPAMUX1_REG                      GPAMUX1;                      // GPIO A Mux 1 Register (GPIO0 to 15)
    union   GPAMUX2_REG                      GPAMUX2;                      // GPIO A Mux 2 Register (GPIO16 to 31)
    Uint16                                   rsvd1[2];					   // Reserved
    union   GPAPUD_REG                       GPAPUD;                       // GPIO A Pull Up Disable Register (GPIO0 to 31)
    Uint16                                   rsvd2[2];                     // Reserved
    union   GPAINV_REG                       GPAINV;                       // GPIO A Input Polarity Invert Registers (GPIO0 to 31)
    Uint16                                   rsvd3[2];					   // Reserved
    union   GPAAMSEL_REG                     GPAAMSEL;					   //GPIO A Analog Mode Select register (GPIO0 to GPIO31)
    Uint16                                   rsvd4[10];                     // Reserved
    union   GPAGMUX1_REG                     GPAGMUX1;                     // GPIO A Peripheral Group Mux (GPIO0 to 15)
    union   GPAGMUX2_REG                     GPAGMUX2;                     // GPIO A Peripheral Group Mux (GPIO16 to 31)
    Uint16                                   rsvd5[28];                    // Reserved

    union   GPBCTRL_REG                      GPBCTRL;                      // GPIO B Qualification Sampling Period Control (GPIO32 to 63)
    union   GPBQSEL1_REG                     GPBQSEL1;                     // GPIO B Qualifier Select 1 Register (GPIO32 to 47)
    union   GPBQSEL2_REG                     GPBQSEL2;                     // GPIO B Qualifier Select 2 Register (GPIO48 to 63)
    union   GPBMUX1_REG                      GPBMUX1;                      // GPIO B Mux 1 Register (GPIO32 to 47)
    union   GPBMUX2_REG                      GPBMUX2;                      // GPIO B Mux 2 Register (GPIO48 to 63)
    Uint16                                   rsvd6[2];					   // Reserved
    union   GPBPUD_REG                       GPBPUD;                       // GPIO B Pull Up Disable Register (GPIO32 to 63)
    Uint16                                   rsvd7[2];                     // Reserved
    union   GPBINV_REG                       GPBINV;                       // GPIO B Input Polarity Invert Registers (GPIO32 to 63)
    Uint16                                   rsvd8[14];                    // Reserved
    union   GPBGMUX1_REG                     GPBGMUX1;                     // GPIO B Peripheral Group Mux (GPIO32 to 47)
    union   GPBGMUX2_REG                     GPBGMUX2;                     // GPIO B Peripheral Group Mux (GPIO48 to 63)
    Uint16                                   rsvd9[28];                    // Reserved

    union   GPCCTRL_REG                      GPCCTRL;                      // GPIO C Qualification Sampling Period Control (GPIO64 to 68)
    union   GPCQSEL1_REG                     GPCQSEL1;                     // GPIO C Qualifier Select 1 Register (GPIO64 to 68)
    Uint16                                   rsvd10[2];                    // Reserved
    union   GPCMUX1_REG                      GPCMUX1;                      // GPIO C Mux 1 Register (GPIO64 to 68)
    Uint16                                   rsvd11[4];					   // Reserved
    union   GPCPUD_REG                       GPCPUD;                       // GPIO C Pull Up Disable Register (GPIO64 to 68)
    Uint16                                   rsvd12[2];                    // Reserved
    union   GPCINV_REG                       GPCINV;                       // GPIO C Input Polarity Invert Registers (GPIO64 to 68)
    Uint16                                   rsvd13[6];                    // Reserved
    union   GPCGMUX1_REG                     GPCGMUX1;                     // GPIO C Peripheral Group Mux (GPIO64 to 68)
    Uint16                                   rsvd14[38];                   // Reserved

    union   GPAPDD_REG                       GPAPDD;                       //GPIO A Pull Down Disable Register (GPIO0 to 31)
    union   GPADS1_REG                       GPADS1;                       //GPIO A Drive Strength 1 Register1 (GPIO0 to 15)
    union   GPADS2_REG                       GPADS2;                       //GPIO A Drive Strength Register2 (GPIO16 to 31)
    union   GPAIS_REG                        GPAIS;                        //GPIO A Schmitt Trigger Register (GPIO0 to 31)
    union   GPAOUTINV_REG                    GPAOUTINV;                    //GPIO A output Polarity Invert Registers (GPIO0 to 31)
    union   GPALOOPEN_REG                    GPALOOPEN;                    //GPIO A LOOP Enable Registers (GPIO0 to 31)
    union   GPAPI2C_MODE_REG                 GPAPI2C_MODE;                 //GPIO A PI2C MODE Registers (GPIO0 to 31)
    Uint32                                   GPA_POUT_RPT;                 //GPIO A Port output report (GPIO0 to 31)

    union   GPBPDD_REG                       GPBPDD;                       //GPIO B Pull Down Disable Register (GPIO32 to 63)
    union   GPBDS1_REG                       GPBDS1;                       //GPIO B Drive Strength 1 Register1 (GPIO32 to 47)
    union   GPBDS2_REG                       GPBDS2;                       //GPIO B Drive Strength Register2 (GPIO48 to 63)
    union   GPBIS_REG                        GPBIS;                        //GPIO B Schmitt Trigger Register (GPIO32 to 63)
    union   GPBOUTINV_REG                    GPBOUTINV;                    //GPIO B output Polarity Invert Registers (GPIO32 to 63)
    union   GPBLOOPEN_REG                    GPBLOOPEN;                    //GPIO B LOOP Enable Registers (GPIO32 to 63)
    union   GPBPI2C_MODE_REG                 GPBPI2C_MODE;                 //GPIO B PI2C MODE Registers (GPIO32 to 63)
    Uint32                                   GPB_POUT_RPT;                 //GPIO B Port output report (GPIO32 to 63)

    union   GPCPDD_REG                       GPCPDD;                       //GPIO C Pull Down Disable Register (GPIO64 to 68)
    union   GPCDS1_REG                       GPCDS1;                       //GPIO C Drive Strength 1 Register1 (GPIO64 to 68)
    Uint16                                   rsvd15[2];                    // Reserved
    union   GPCIS_REG                        GPCIS;                        //GPIO C Schmitt Trigger Register (GPIO64 to 68)
    union   GPCOUTINV_REG                    GPCOUTINV;                    //GPIO C output Polarity Invert Registers (GPIO64 to 68)
    union   GPCLOOPEN_REG                    GPCLOOPEN;                    //GPIO C LOOP Enable Registers (GPIO64 to 68)
    Uint16                                   rsvd16[2];                    // Reserved
    Uint32                                   GPC_POUT_RPT;                 //GPIO C Port output report (GPIO64 to 68)

    Uint16                                   rsvd17[4];                    // Reserved
    union   GPHIS_REG                        GPHIS;                        //GPIO H Schmitt Trigger Register (GPIO224 to 255)
    Uint16                                   rsvd18[2];                    // Reserved
    union   GPHIE_REG                        GPHIE;                        //GPIO H  input Enable Registers (GPIO224 to 255)
    Uint16                                   rsvd19[134];                    // Reserved


    Uint16                                   rsvd20[64];                    // Reserved

//    Uint16                                   rsvd20[2];                    // Reserved
//    union   CLK_REF_PIN_CTRL_REG             CLK_REF_PIN_CTRL;             //
//    union   IO_IE_MODE_REG                   IO_IE_MODE;                   //
//    Uint16                                   rsvd21[34];                   // Reserved
//    union   LPMCR_QUALSTDBY_REG              LPMCR_QUALSTDBY;              //
//    union   IO_SET_STDBY_REG                 IO_SET_STDBY;                 //
//    union   GPIOLPMSEL0_REG                  GPIOLPMSEL0;                  //
//    union   GPIOLPMSEL1_REG                  GPIOLPMSEL1;                  //
//    union   GPIOLPMSEL2_REG                  GPIOLPMSEL2;                  //
//    Uint16                                   rsvd22[14];                   // Reserved


    union   GPHCTRL_REG                      GPHCTRL;                      // GPIO H Qualification Sampling Period Control (GPIO224 to 255)
	union   GPHQSEL1_REG                     GPHQSEL1;                     // GPIO H Qualifier Select 1 Register (GPIO224 to 239)
	union   GPHQSEL2_REG                     GPHQSEL2;                     // GPIO H Qualifier Select 2 Register (GPIO240 to 255)
	union   GPHMUX1_REG                      GPHMUX1;                      // GPIO H Mux 1 Register (GPIO224 to 239)
	union   GPHMUX2_REG                      GPHMUX2;                      // GPIO H Mux 2 Register (GPIO240 to 255)
	Uint16                                   rsvd23[6];					   // Reserved
	union   GPHINV_REG                       GPHINV;                       // GPIO H Input Polarity Invert Registers (GPIO224 to 255)
	Uint16                                   rsvd24[2];                    // Reserved
	union   GPHAMSEL_REG                     GPHAMSEL;                     // GPIO H Analog Mode Select register  (GPIO224 to 255)
	Uint16                                   rsvd25[10];                    // Reserved
	union   GPHGMUX1_REG                     GPHGMUX1;                     // GPIO H Peripheral Group Mux (GPIO224 to 239)
	union   GPHGMUX2_REG                     GPHGMUX2;                     // GPIO H Peripheral Group Mux (GPIO240 to 255)


};

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// GPIO External References & Function Declarations

extern volatile struct GPIO_REGS gpioRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif  /* IS_GS32F00xx(0x12) */

#endif  // end of REGS_GPIO_H definition
