/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_hal_can.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/
/*
 * commit history
 * 20240313, LYF, verify for HAL_CAN Send/Receive
 * 20240316, LYF, verify for HAL_CAN Bus error/Bus off/Fifo depth MailBox/Can Nums
 * 20240322, LYF, translate source files to C source, ASCII text. 
 */
 
#ifndef REGS_HAL_CAN_H
#define REGS_HAL_CAN_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// CAN Individual Register Bit Definitions:

//*****************************************************************************
//
//! The following are defines for HAL_CAN refer to DCAN Frame domain registers.
//
//*****************************************************************************
//!
//! HAL_CAN Message RAM Parity Register bit definitions (x: 0~31)
//!
struct HAL_CAN_MSGx_PAR_BITS {

    uint32_t Parity:5;      //4:0   
    uint32_t rsvd1:27;      //31:5
};

//!
//! HAL_CAN Message RAM Parity Register  (x: 0~31)
//!
union HAL_CAN_MSGx_PAR_REG{
    uint32_t                        all;
    struct HAL_CAN_MSGx_PAR_BITS    bit;
};

//!
//! HAL_CAN Message RAM Mask Register bit definitions  (x: 0~31)
//!
struct HAL_CAN_MSGx_MSK_BITS {
    // Identifier Mask
    // 0: The corresponding bit in the identifier of the message object is not used for acceptance 
    //    filtering (don't care).
    // 1: The corresponding bit in the identifier of the message object is used for acceptance filtering.
    uint32_t Msk:29;        //28:0    
    uint32_t rsvd1:1;       //29  

    // Mask Message Direction
    // 0: The message direction bit (Dir) has no effect on the acceptance filtering.
    // 1: The message direction bit (Dir) is used for acceptance filtering.     
    uint32_t MDir:1;        //30

    // Mask Extended Identifier
    // 0: The extended identifier bit (Xtd) has no effect on the acceptance filtering.
    // 1: The extended identifier bit (Xtd) is used for acceptance filtering. When 11-bit ("standard")
    //    identifiers are used for a message object, the identifiers of received data frames are 
    //    written into bits ID[28:18]. For acceptance filtering, only these bits together with mask 
    //    bits Msk[28:18] are considered.    
    uint32_t Mxtd:1;        //31
};

//!
//! HAL_CAN Message RAM Mask Register  (x: 0~31)
//!
union HAL_CAN_MSGx_MSK_REG{
    uint32_t                        all;
    struct HAL_CAN_MSGx_MSK_BITS    bit;
};

//!
//! HAL_CAN Message RAM ID Register bit definitions  (x: 0~31)
//!
struct HAL_CAN_MSGx_ID_BITS {
    // Message Identifier
    // ID[28:0] 29-bit Identifier ("Extended Frame")
    // ID[10:0] 11-bit Identifier ("Standard Frame")
    uint32_t ID:29;        //28:0

    // Message Direction
    // 0: CAN_MSG_TYPE_TRANSMIT
    //    Direction = receive: On TxRqst, a remote frame with the identifier of this message object
    //    is transmitted. On reception of a data frame with matching identifier, that frame is stored
    //    in this message object.
    // 1: CAN_MSG_TYPE_RECEIVE
    //    Direction = transmit: On TxRqst, the respective message object is transmitted as a data
    //    frame. On reception of a remote frame with matching identifier, the TxRqst bit of this 
    //    message object is set (if RmtEn = one).      
    uint32_t Dir:1;         //29

    // Extended Identifier
    // 0: The 11-bit ("standard") Identifier is used for this message object.
    // 1: The 29-bit ("extended") Identifier is used for this message object.    
    uint32_t xtd:1;         //30       
    uint32_t MsgVal:1;      //31  //indicate this mail box is enabled
};

//!
//! HAL_CAN Message RAM ID Register  (x: 0~31)
//!
union HAL_CAN_MSGx_ID_REG{
    uint32_t                        all;
    struct HAL_CAN_MSGx_ID_BITS     bit;
};

//!
//! HAL_CAN Message RAM Ctrl Register bit definitions  (x: 0~31)
//!
struct HAL_CAN_MSGx_CTRL_BITS {
    // Data length code
    // 0-8: Data frame has 0-8 data bytes.
    // 9-15: Data frame has 8 data bytes.
    uint32_t DLC:4;         //3:0
    uint32_t BRS:1;         //4
    uint32_t FDF:1;         //5
    uint32_t Rsvd4:1;       //6
    
    // End of Block
    // 0: The message object is part of a FIFO Buffer block and is not the last message object of 
    //    the FIFO Buffer block. 
    // 1: The message object is a single message object or the last message object in a FIFO Buffer
    //    Block.        
    uint32_t EoB:1;         //7    
    uint32_t TxRqst:1;      //8

    // Remote Enable
    // 0: At the reception of a remote frame, TxRqst is not changed.
    // 1: At the reception of a remote frame, TxRqst is set.      
    uint32_t RmtEn:1;       //9

    // Receive Interrupt Enable
    // 0: IntPnd will not be triggered after the successful reception of a frame.
    // 1: IntPnd will be triggered after the successful reception of a frame.       
    uint32_t RxIE:1;        //10

    // Transmit Interrupt Enable
    // 0: IntPnd will not be triggered after the successful transmission of a frame.
    // 1: IntPnd will be triggered after the successful transmission of a frame.    
    uint32_t TxIE:1;        //11

    // Use Acceptance Mask
    // If the UMask bit is set to one, the message object's mask bits have to be programmed during 
    // initialization of the message object before MsgVal is set to one.
    // 0: Mask ignored
    // 1: Use Mask (Msk[28:0], MXtd, and MDir) for acceptance filtering    
    uint32_t UMask:1;       //12 
    uint32_t IntPnd:1;       //13

    // Message Lost (only valid for message objects with direction = receive)
    // 0: No message lost since the last time when this bit was reset by the CPU.
    // 1: The message handler stored a new message into this object when NewDat was still set, so 
    //    the previous message has been overwritten.   
    uint32_t MsgLst:1;      //14
    // New Data
    // 0: No new data has been written into the data portion of this message object by the message 
    //    handler since the last time when this flag was cleared by the CPU.
    // 1: The message handler or the CPU has written new data into the data portion of this message 
    //    object.
    uint32_t NewDat:1;      //15
    uint32_t rsvd1:16;      //31:16
};

//!
//! HAL_CAN Message RAM ID Register  (x: 0~31)
//!
union HAL_CAN_MSGx_CTRL_REG{
    uint32_t                       all;
    struct HAL_CAN_MSGx_CTRL_BITS      bit;
};

//!
//! HAL_CAN Message RAM Data Register bit definitions  (x: 0~31)
//!
struct HAL_CAN_MSGx_DATA_BITS {

    // Data Byte 0
    uint32_t Data_0:8;      //7:0

    // Data Byte 1
    uint32_t Data_1:8;      //15:8
    
    // Data Byte 2
    uint32_t Data_2:8;      //23:16

    // Data Byte 3
    uint32_t Data_3:8;      //31:24   
};

//!
//! HAL_CAN Message RAM Data A Register  (x: 0~31)
//!
union HAL_CAN_MSGx_DATA_REG{
    uint32_t                        all;
    struct HAL_CAN_MSGx_DATA_BITS   bit;
};

//*****************************************************************************
//
//! The following are defines for HAL_CAN_based on DCAN Control domain registers.
//
//*****************************************************************************
//!
//!  HAL_CAN Control Register bit definitions
//!
struct HAL_CAN_CTRL_BITS {
    // Initialization Mode
    // This bit is used to keep the HAL_CAN module inactive during bit timing configuration and 
    // message RAM initialization. It is set automatically during a bus off event. Clearing
    // this bit will not shorten the bus recovery time.
    // 0: HAL_CAN module processes messages normally
    // 1: HAL_CAN module ignores bus activity
    uint32_t Init:1;        //0

    // Interrupt line 0 Enable
    // 0: HAL_CANINT0 is disabled.
    // 1: HAL_CANINT0 is enabled. Interrupts will assert HAL_CANINT0 line to 1 line remains active 
    //    until pending interrupts are processed.
    uint32_t IE0:1;          //1

    // Status Change Interrupt Enable
    // 0: Disabled - RxOk, TxOk and LEC bits cannot generate an interrupt.
    // 1: Enabled - RxOk, TxOk and LEC can generate an interrupt on the HAL_CANINT0 line
    uint32_t SIE:1;         //2

    // Error Interrupt Enable
    // 0: Disabled - PER, BOff and EWarn bits cannot generate an interrupt.
    // 1: Enabled - PER, BOff and EWarn bits can generate an interrupt at HAL_CANINT0 line 
    //    and affect the Interrupt Register.
    uint32_t EIE:1;         //3
    uint32_t rsvd3:1;       //4

    // Disable Automatic Retransmission
    // 0: Automatic Retransmission of "not successful" messages enabled.
    // 1: Automatic Retransmission disabled.
    uint32_t DAR:1;         //5

    // Configuration Change Enable
    // 0: The CPU has no write access to the configuration registers.
    // 1: The CPU has write access to the configuration registers (when Init bit is set).
    uint32_t CCE:1;         //6

    // Test Mode Enable
    // 0: Disable Test Mode (Normal operation)
    // 1: Enable Test Mode
    uint32_t Test:1;        //7

    // Interruption Debug Support Enable
    // 0: When Debug mode is requested, the HAL_CAN module will wait for a started transmission 
    //    or reception to be completed before entering Debug mode
    // 1: When Debug mode is requested, the HAL_CAN module will interrupt any transmission or 
    //    reception, and enter Debug mode immediately.
    uint32_t IDS:1;         //8

    // Auto-Bus-On Enable
    // 0: The Auto-Bus-On feature is disabled
    // 1: The Auto-Bus-On feature is enabled
    uint32_t ABO:9;         //9

    // Parity on/off
    // 0101: Parity function disabled
    // Any other value: - Parity function enabled
    uint32_t PMD:4;         //13:10
    uint32_t rsvd2:1;       //14
    
    // Software Reset Enable Bit: This bit activates the software reset.
    // 0: Normal Operation.
    // 1: Module is forced to reset state. This bit will get cleared automatically one clock 
    //    cycle after execution of software reset.
    // Note: To execute software reset, the following procedure is necessary:
    // 1. Set INIT bit to shut down HAL_CAN communication.
    // 2. Set SWR bit.
    uint32_t SWR:1;         //15

    // Debug Mode Status Bit: This bit indicates the internal init state for a debug access
    // 0: Not in debug mode, or debug mode requested but not entered.
    // 1: Debug mode requested and internally entered
    uint32_t INITDBG:1;     //16

    // Interrupt line 1 Enable
    // 0: HAL_CANINT1 is disabled.
    // 1: HAL_CANINT1 is enabled. Interrupts will assert HAL_CANINT1 line to 1    
    uint32_t IE1:1;         //17

    // Enable DMA request line for IF1
    // 0: Disabled
    // 1: Enabled    
    uint32_t DE1:1;         //18

    // Enable DMA request line for IF2
    // 0: Disabled
    // 1: Enabled
    uint32_t DE2:1;         //19

    // Enable DMA request line for IF3
    // 0: Disabled
    // 1: Enabled
    uint32_t DE3:1;         //20
    uint32_t rsvd1:11;      //31:21
};

//!
//!  HAL_CAN Control Register
//!
union HAL_CAN_CTRL_REG{
    uint32_t                    all;
    struct HAL_CAN_CTRL_BITS    bit;
};

//!
//! HAL_CAN Error and Status Register bit definitions
//!
struct HAL_CAN_ES_BITS {
    // Last Error Code
    // The LEC field indicates the type of the last error on the HAL_CAN bus. This field will be 
    // cleared to '0' when a message has been transferred (reception or transmission) without
    // error. This field will be reset to '7' whenever the CPU reads the register.
    // 0: No Error
    // 1: Stuff Error: More than five equal bits in a row have been detected in a part of a 
    //    received message where this is not allowed.
    // 2: Form Error: A fixed format part of a received frame has the wrong format.
    // 3: Ack Error: The message this HAL_CAN Core transmitted was not acknowledged by another node.
    // 4: Bit1 Error: During the transmission of a message (with the exception of the arbitration
    //    field), the device wanted to send a recessive level (bit of logical value '1'), but the
    //    monitored bus value was dominant.
    // 5: Bit0 Error: During the transmission of a message (or acknowledge bit, or active error 
    //    flag, or overload flag), the device wanted to send a dominant level (logical value '0'), 
    //    but the monitored bus level was recessive. During Bus-Off recovery, this status is set
    //    each time a sequence of 11 recessive bits has been monitored. This enables the CPU to 
    //    monitor the proceeding of the Bus-Off recovery sequence (indicating the bus is not 
    //    stuck at dominant or continuously disturbed).
    // 6: CRC Error: In a received message, the CRC check sum was incorrect. (CRC received for 
    //    an incoming message does not match the calculated CRC for the received data).
    // 7: No HAL_CAN bus event was detected since the last time when CPU has read the Error and 
    //    Status Register. Any read access to the Error and Status Register re-initializes the
    //    LEC to value '7'.
    uint32_t LEC:2;         //2:0

    // Transmission status Bit: This bit indicates the status of transmission. The bit will be
    // reset after the CPU reads the register.
    // 0: No message has been successfully transmitted since the last time when this bit was 
    //    read by the CPU. This bit is never reset by HAL_CAN internal events.
    // 1: A message has been successfully transmitted (error free and acknowledged by at least
    //    one other node) since the last time when this bit was cleared by a read access of the CPU.    
    uint32_t TxOK:1;        //3

    // Reception status Bit: This bit indicates the status of reception. The bit will be reset
    // after the CPU reads the register.
    // 0: No message has been successfully received since the last time when this bit was read
    //    by the CPU. This bit is never reset by HAL_CAN internal events.
    // 1: A message has been successfully received since the last time when this bit was reset
    //    by a read access of the CPU. This bit will be set independent of the result of 
    //    acceptance filtering.
    uint32_t RxOK:1;        //4

    // Error Passive State
    // 0: On HAL_CAN Bus error, the HAL_CAN could send active error frames.
    // 1: The HAL_CAN Core is in the error passive state as defined in the HAL_CAN Specification.
    uint32_t EPass:1;       //5

    // Warning State Bit:
    // 0: Both error counters are below the error warning limit of 96.
    // 1: At least one of the error counters has reached the error warning limit of 96.    
    uint32_t EWam:1;        //6

    // Bus-off Status Bit:
    // 0: The HAL_CAN module is not in Bus-Off state.
    // 1: The HAL_CAN module is in Bus-Off state.
    uint32_t BOff:1;        //7
    
    // Parity Error Detected: This bit will be reset after the CPU reads the register.
    // 0: No parity error has been detected since last read access.
    // 1: The parity check mechanism has detected a parity error in the Message RAM.        
    uint32_t PER:1;         //8
    uint32_t rsvd1:23;      //31:9
};

//!
//! HAL_CAN Error and Status Register.
//!
union HAL_CAN_ES_REG{
    uint32_t                        all;
    struct HAL_CAN_ES_BITS          bit;
};

//!
//! HAL_CAN Error and Status Register bit definitions
//!
struct HAL_CAN_ERRC_BITS {

    // Transmit Error Counter
    // 0~255: Actual state of the Transmit Error Counter. 
    uint32_t TEC:8;         //7:0

    // Receive Error Counter
    // 0~127: Actual state of the Receive Error Counter.
    uint32_t REC:7;         //14:8

    // Receive Error Passive
    // 0: The Receive Error Counter is below the error passive level.
    // 1: The Receive Error Counter has reached the error passive level as defined in the HAL_CAN
    //    Specification.
    uint32_t RP:1;          //15
    uint32_t rsvd1:16;      //31: 16
};
//!
//! HAL_CAN Error and Status Register
//!
union HAL_CAN_ERRC_REG{
    uint32_t                        all;
    struct HAL_CAN_ERRC_BITS        bit;
};


//!
//! HAL_CAN Bit Timing Register bit definitions
//!
struct HAL_CAN_BTR_BITS {
    // Baud Rate Prescaler Value.
    // The value by which the HAL_CAN_CLK frequency is divided to generate the bit time quanta. 
    // The bit time is constructed from a multiple of this quanta. 
    // 0~63: Valid programmed values. The actual BRP value interpreted for Bit Timing will be
    //       the programmed BRP value + 1.
    uint32_t BRP:6;             //5:0

    // Synchronization Jump Width 
    // 0~3: Valid programmed values. The actual SJW value interpreted for the Synchronization
    //      will be the programmed SJW value + 1.
    uint32_t SJW:2;             //7:6

    // Time segment before the sample point 
    // 0~15: Valid programmed values. The actual TSeg1 value interpreted for the Bit Timing 
    //       will be the programmed TSeg1 value + 1.
    uint32_t TSEG1:4;           //11:8

    // Time segment after the sample point
    // 0~7: Valid programmed values. The actual TSeg2 value which is interpreted for the Bit
    //      Timing will be the programmed TSeg2 value + 1.
    uint32_t TSEG2:3;           //14:12
    uint32_t rsvd2:1;           //15

    // Baud Rate Prescaler Extension
    // 0~15: Valid programmed values, by programming BRPE the Baud Rate Prescaler can be 
    //       extended to values up to 1024.
    uint32_t BRPE:4;            //19:16
    uint32_t rsvd1:12;          //31:20
};

//!
//! HAL_CAN Bit Timing Register
//!
union HAL_CAN_BTR_REG{
    uint32_t                        all;
    struct HAL_CAN_BTR_BITS         bit;
};

//!
//! HAL_CAN Interrupt Register bit definitions
//!
struct HAL_CAN_INT_BITS {
    // Interrupt 0 Cause
    // 0x0000: No interrupt is pending.
    // 0x0001~0x0020: Number of message object which caused the interrupt.
    // 0x0021~0x7FFF: Unused.
    // 0x8000: Error and Status Register value is not 0x07.
    // 0x8001: 0xFFFF: Unused.
    // If several interrupts are pending, the HAL_CAN Interrupt Register will point to the pending 
    // interrupt with the highest priority.
    uint32_t INT0ID:16;          //15:0

    // Interrupt 1 Cause
    // 0x00: No interrupt is pending.
    // 0x01-0x20: Number of message object (mailbox) which caused the interrupt.
    // 0x21-0xFF Unused.
    // If several interrupts are pending, the HAL_CAN Interrupt Register will point to the pending 
    // interrupt with the highest priority.  
    uint32_t INT1ID:8;          //23:16
    uint32_t rsvd1:8;           //31:24
};
//!
//! HAL_CAN Interrupt Register
//!
union HAL_CAN_INT_REG{
    uint32_t                        all;
    struct HAL_CAN_INT_BITS         bit;
};

//!
//! HAL_CAN Global Interrupt Enable Register bit definitions
//!
struct HAL_CAN_GLBINTEN_BITS {
    // Global Interrupt Enable for HAL_CANINT0
    // 0: HAL_CANINT0 does not generate interrupt to PIE
    // 1: HAL_CANINT0 generates interrupt to PIE if interrupt condition occurs
    uint32_t GLBINT0_EN:1;      //0

    // Global Interrupt Enable for HAL_CANINT1
    // 0: HAL_CANINT1 does not generate interrupt to PIE
    // 1: HAL_CANINT1 generates interrupt to PIE if interrupt condition occurs    
    uint32_t GLBINT1_EN:1;      //1
    uint32_t rsvd1:30;          //31:2
};
//!
//! HAL_CAN Global Interrupt Enable Register
//!
union HAL_CAN_GLB_INT_EN_REG{
    uint32_t                        all;
    struct HAL_CAN_GLBINTEN_BITS    bit;
};


//!
//! HAL_CAN Global Interrupt Flag Register bit definitions
//!
struct HAL_CAN_GLBINTFLG_BITS {
    // HAL_CANINT0 Flag
    // 0: No interrupt generated
    // 1: Interrupt is generated due to HAL_CANINT0 (refer to HAL_CAN Interrupt Status Register
    //    for the condition)
    uint32_t INT0_FLG:1;        //0

    // HAL_CANINT1 Flag
    // 0: No interrupt generated
    // 1: Interrupt is generated due to HAL_CANINT1 (refer to HAL_CAN Interrupt Status Register 
    //    for the condition)    
    uint32_t INT1_FLG:1;        //1
    uint32_t rsvd1:30;          //31:2
};
//!
//! HAL_CAN Global Interrupt Flag Register
//!
union HAL_CAN_GLB_INT_FLG_REG{
    uint32_t                        all;
    struct HAL_CAN_GLBINTFLG_BITS   bit;
};


//!
//! HAL_CAN Global Interrupt Clear Register bit definitions
//!
struct HAL_CAN_GLBINTCLR_BITS {
    // Global Interrupt flag clear for HAL_CANINT0
    // 0: No effect
    // 1: Write 1 to clear the corresponding bit of the Global Interrupt Flag Register and
    //    allow the PIE to receive another interrupt from HAL_CANINT0.    
    uint32_t INT0_FLG_CLR:1;    //0

    // Global Interrupt flag clear for HAL_CANINT1
    // 0: No effect
    // 1: Write 1 to clear the corresponding bit of the Global Interrupt Flag Register and
    //    allow the PIE to receive another interrupt from HAL_CANINT1.
    uint32_t INT1_FLG_CLR:1;    //1
    uint32_t rsvd1:30;          //31:2
};
//!
//! HAL_CAN Global Interrupt Clear Register.
//!
union HAL_CAN_GLB_INT_CLR_REG{
    uint32_t                        all;
    struct HAL_CAN_GLBINTCLR_BITS   bit;
};


//!
//! HAL_CAN Auto-Bus-On Time Register bit definitions
//!
struct HAL_CAN_ABOTR_BITS {    
    // Auto-Bus-On Timer
    // Number of clock cycles before a Bus-Off recovery sequence is started by clearing the 
    // Init bit. "Clock" refers to the input clock to the HAL_CAN module. This function has to 
    // be enabled by setting bit ABO in HAL_CAN Control Register. The Auto-Bus-On timer is realized
    // by a 32-bit counter which starts to count down to zero when the module goes Bus-Off. 
    // The counter will be reloaded with the preload value of the ABO Time register after this phase.
    uint32_t ABO_Time:32;       //31:0
};
//!
//! HAL_CAN Auto-Bus-On Time Register
//!
union HAL_CAN_ABOTR_REG{
    uint32_t                        all;
    struct HAL_CAN_ABOTR_BITS       bit;
};


//!
//! HAL_CAN Transmission Request Register bit definitions
//!
struct HAL_CAN_TXRQX_BITS {
    // Transmit Request Register 1 flag:
    // Bit 0: represents byte 0 of HAL_CAN_TXRQ_21 Register. If one or more bits in that byte are 
    //        set, then bit 0 will be set.
    // Bit 1: represents byte 1 of HAL_CAN_TXRQ_21 Register. If one or more bits in that byte are
    //        set, then bit 1 will be set.
    uint32_t TxRqstReg1:2;      //1:0

    // Transmit Request Register 2 flag:
    // Bit 2: represents byte 2 of HAL_CAN_TXRQ_21. If one or more bits in that byte are set, then 
    //        bit 2 will be set.
    // Bit 3: represents byte 3 of HAL_CAN_TXRQ_21 Register. If one or more bits in that byte are 
    //        set, then bit 3 will be set.
    uint32_t TxRqstReg2:2;      //3:2
    uint32_t rsvd1:28;          //31:4
};
//!
//! HAL_CAN Transmission Request Register
//!
union HAL_CAN_TXRQ_X_REG{
    uint32_t                        all;
    struct HAL_CAN_TXRQX_BITS       bit;
};


//!
//! HAL_CAN Transmission Request 2_1 Register bit definitions
//!
struct HAL_CAN_TXRQ21_BITS {
    // Transmission Request Bits (for all message objects)
    // 0: No transmission has been requested for this message object.
    // 1: The transmission of this message object is requested and is not yet done.
    // Note: Bit 0 is for mailbox 1, Bit 1 is for mailbox 2, Bit 2 is for mailbox 3,..., Bit 31 
    // is for mailbox 32    
    uint32_t TxRqst:32;         //31:0
};
//!
//! HAL_CAN Transmission Request 2_1 Register
//!
union HAL_CAN_TXRQ_21_REG{
    uint32_t                        all;
    struct HAL_CAN_TXRQ21_BITS      bit;
};


//!
//! HAL_CAN New Data Register bit definitions
//!
struct HAL_CAN_NDATX_BITS {
    // New Data Register 1 flag:
    // Bit 0: represents byte 0 of HAL_CAN_NDAT _21 Register. If one or more bits in that byte are set, 
    //        then bit 0 will be set.
    // Bit 1: represents byte 1 of HAL_CAN_NDAT _21 Register. If one or more bits in that byte are set, 
    //        then bit 1 will be set.
    uint32_t NewDatReg1:2;      //1:0

    // New Data Register 2 flag:
    // Bit 2: represents byte 2 of HAL_CAN_NDAT _21 Register. If one or more bits in that byte are set, 
    //        then bit 2 will be set.
    // Bit 3: represents byte 3 of HAL_CAN_NDAT _21 Register. If one or more bits in that byte are set, 
    //        then bit 3 will be set.    
    uint32_t NewDatReg2:2;      //3:2
    uint32_t rsvd1:28;          //31:4
};
//!
//! HAL_CAN New Data Register
//!
union HAL_CAN_NDAT_X_REG{
    uint32_t                        all;
    struct HAL_CAN_NDATX_BITS       bit;
};

//!
//! HAL_CAN New Data 2_1 Register bit definitions
//!
struct HAL_CAN_NDAT21_BITS {
    // New Data Bits (for all message objects)
    // 0: No new data has been written into the data portion of this message object by the message 
    //    handler since the last time when this flag was cleared by the CPU.
    // 1: The message handler or the CPU has written new data into the data portion of this message
    //    object.
    // Note: Bit 0 is for mailbox 1, Bit 1 is for mailbox 2, Bit 2 is for mailbox 3,..., Bit 31 is 
    // for mailbox 32   
    uint32_t NewDat:32;         //31:0
};
//!
//! HAL_CAN New Data 2_1 Register
//!
union HAL_CAN_NDAT_21_REG{
    uint32_t                        all;
    struct HAL_CAN_NDAT21_BITS      bit;
};


//!
//! HAL_CAN Interrupt Pending Register bit definitions
//!
struct HAL_CAN_IPENX_BITS {
    // Interrupt Pending Register 1 flag:
    // Bit 0: represents byte 0 of HAL_CAN_IPEN_21 Register. If one or more bits in that byte are set, 
    //        then bit 0 will be set.
    // Bit 1: represents byte 1 of HAL_CAN_IPEN_21 Register. If one or more bits in that byte are set, 
    //        then bit 1 will be set.
    uint32_t IntPndReg1:2;      //1:0

    // Interrupt Pending Register 2 flag:
    // Bit 2: represents byte 2 of HAL_CAN_IPEN_21 Register. If one or more bits in that byte are set, 
    //        then bit 2 will be set.
    // Bit 3: represents byte 3 of HAL_CAN_IPEN_21 Register. If one or more bits in that byte are set, 
    //        then bit 3 will be set.
    uint32_t IntPndReg2:2;      //3:2
    uint32_t rsvd1:28;          //31:4
};
//!
//! HAL_CAN Interrupt Pending Register
//!
union HAL_CAN_IPEN_X_REG{
    uint32_t                        all;
    struct HAL_CAN_IPENX_BITS       bit;
};

//!
//! HAL_CAN Interrupt Pending Register 2_1 bit definitions
//!
struct HAL_CAN_IPEN21_BITS {
    // Interrupt Pending bits. 
    // This register contains the bits that indicate the pending interrupts in each one of the 32 
    // mailboxes.
    // 0: This mailbox is not the source of an interrupt.
    // 1: This mailbox is the source of an interrupt.
    // Note: Bit 0 is for mailbox 1, Bit 1 is for mailbox 2, Bit 2 is for mailbox 3,..., Bit 31 
    // is for mailbox 32    
    uint32_t IntPnd:32;         //31:0
};
//!
//! HAL_CAN Interrupt Pending Register 2_1
union HAL_CAN_IPEN_21_REG{
    uint32_t                        all;
    struct HAL_CAN_IPEN21_BITS      bit;
};

//!
//! HAL_CAN Message Valid Register bit definitions
//!
struct HAL_CAN_MVALX_BITS {
    // Message Valid Register 1 flag.
    // Bit 0: represents byte 0 of HAL_CAN_ CAN_MVAL_21 Register. If one or more bits in that byte are set, 
    //        then bit 0 will be set.
    // Bit 1: represents byte 1 of HAL_CAN_ MVAL _21 Register. If one or more bits in that byte are set,
    //        then bit 1 will be set.
    uint32_t MsgValReg1:2;      //1:0

    // Message Valid Register 2 flag.
    // Bit 2: represents byte 2 of HAL_CAN_ MVAL _21 Register. If one or more bits in that byte are set, 
    //        then bit 2 will be set.
    // Bit 3: represents byte 3 of HAL_CAN_ MVAL _21 Register. If one or more bits in that byte are set,
    //        then bit 3 will be set.
    uint32_t MsgValReg2:2;      //3:2
    uint32_t rsvd1:28;          //31:4
};
//!
//! HAL_CAN Message Valid Register
//!
union HAL_CAN_MVAL_X_REG{
    uint32_t                        all;
    struct HAL_CAN_MVALX_BITS       bit;
};

//!
//! HAL_CAN Message Valid Register 2_1 bit definitions
//!
struct HAL_CAN_MVAL21_BITS {
    // Message Valid Bits (for all message objects)
    // 0: This message object is ignored by the message handler.
    // 1: This message object is configured and will be considered by the message handler.
    // Note: Bit 0 is for mailbox 1, Bit 1 is for mailbox 2, Bit 2 is for mailbox 3,..., Bit 31 is 
    // for mailbox 32
    uint32_t MsgValReg:32;      //31:0              
};
//!
//! HAL_CAN Message Valid Register 2_1
//!
union HAL_CAN_MVAL_21_REG{
    uint32_t                        all;
    struct HAL_CAN_MVAL21_BITS      bit;
};


//!
//! HAL_CAN Interrupt Multiplexer 2_1 Register bit definitions
//!
struct HAL_CAN_IPMUX21_BITS {
    // Interrupt Mux bits:
    // 0: HAL_CANINT0 line is active if corresponding IntPnd flag is one.
    // 1: HAL_CANINT1 line is active if corresponding IntPnd flag is one.
    // Note: Bit 0 is for mailbox 32, Bit 1 is for mailbox 1, Bit 2 is for mailbox 2,..., Bit 31 is
    // for mailbox 31        
    uint32_t IntMux:31;         //31:0
};
//!
//! HAL_CAN Interrupt Multiplexer 2_1 Register
//!
union HAL_CAN_IP_MUX21_REG{
    uint32_t                        all;
    struct HAL_CAN_IPMUX21_BITS     bit;
};

//!
//! HAL_CAN IFx Command Registers bit definitions (x: 1~3)
//!
struct HAL_CAN_IFxCMD_BITS {
    // Number of message object in Message RAM which is used for data transfer
    // 0x00: Invalid message number
    // 0x01-0x20: Valid message numbers
    // 0x21-0xFF: Invalid message numbers
    uint32_t MSG_NUM:8;     //7:0    
    uint32_t rsvd12:6;      //13:8
    
    // DMA trigger status due to IF1 update.
    // 0: No IF1 DMA request is active.
    // 1: DMA is requested after a completed transfer between IF1 and the message RAM. The 
    //    DMA request remains active until the first read or write to one of the IF1 registers
    //    an exception is a write to Message Number (Bits [7:0]) when DMAactive is one.    
    uint32_t DMAactive:1;   //14
    
    // Busy Flag
    // 0: No transfer between IF1/IF2 Register Set and Message RAM is in progress.
    // 1: Transfer between IF1/IF2 Register Set and Message RAM is in progress
    uint32_t Busy:1;        //15
    
    // Access Data Bytes 4-7
    // 0: Data Bytes 4-7 will not be changed.
    // 1: (Direction = Read): The Data Bytes 4-7 will be transferred from the message object 
    //    addressed by Message Number (Bits [7:0]) to the corresponding IF1/IF2 Register set.
    // 1: (Direction = Write): The Data Bytes 4-7 will be transferred from the IF1/IF2 Register
    //    set to the message object addressed by Message Number (Bits [7:0]).
    uint32_t DATA_B:1;      //16
    
    // Access Data Bytes 0-3
    // 0: Data Bytes 0-3 will not be changed.
    // 1: (Direction = Read): The Data Bytes 0-3 will be transferred from the message object 
    //    addressed by the Message Number (Bits [7:0]) to the corresponding IF1/IF2 Register set.
    // 1: (Direction = Write): The Data Bytes 0-3 will be transferred from the IF1/IF2 Register
    //    set to the message object addressed by the Message Number (Bits [7:0]).
    uint32_t DATA_A:1;      //17
    
    // Access Transmission Request (TxRqst) / New Data (NewDat) Bit
    // 0: (Direction = Read): NewDat bit will not be changed.
    // 0: (Direction = Write): TxRqst/NewDat bit will be handled according to the Control bit.
    // 1: (Direction = Read): Clears NewDat bit in the message object.
    // 1: (Direction = Write): Sets TxRqst/NewDat in message object.
    uint32_t TxRqst:1;      //18
    
    // Clear Interrupt Pending Bit
    // 0: IntPnd bit will not be changed
    // 1:  (Direction = Read): Clears IntPnd bit in the message object.
    // 1:  (Direction = Write): This bit is ignored.    
    uint32_t ClrIntPnd:1;   //19
    
    // Access control bits.
    // If the TxRqst/NewDat bit in this register(Bit [18]) is set, the TxRqst/NewDat bit in the 
    // IF1 message control register will be ignored.
    // 0: Control bits will not be changed.
    // 1: (Direction = Read): The message control bits will be transferred from the message object
    //    addressed by message number (Bits [7:0]) to the IF1 register set.
    // 1: (Direction = Write): The message control bits will be transferred from the IF1 register 
    //    set to the message object addressed by message number (Bits [7:0]).    
    uint32_t Control:1;     //20
    
    // Access Arbitration Bits
    // 0: Arbitration bits will not be changed 1 (Direction = Read): The Arbitration bits 
    //    (Identifier + Dir + Xtd + MsgVal) will be transferred from the message object addressed
    //    by Message Number (Bits [7:0]) to the corresponding IF1/IF2 Register set.
    // 1: (Direction = Write): The Arbitration bits (Identifier + Dir + Xtd + MsgVal) will be 
    //    transferred from the IF1/IF2 Register set to the message object addressed by Message 
    //    Number (Bits [7:0]).
    uint32_t Arb:1;         //21
    
    // Access Mask Bits
    // 0: Mask bits will not be changed 1 (Direction = Read): The Mask bits (Identifier Mask + 
    //    MDir + MXtd) will be transferred from the message object addressed by Message Number 
    //    (Bits [7:0]) to the IF1/IF2 Register set.
    // 1: (Direction = Write): The Mask bits (Identifier Mask + MDir + MXtd) will be transferred
    //     from the IF1/IF2 Register set to the message object addressed by Message Number 
    //     (Bits [7:0]).
    uint32_t Mask:1;        //22
    
    // Write/Read
    // 0: Direction = Read: Transfer direction is from the message object addressed by Message
    //    Number (Bits [7:0]) to the IF1/IF2 Register set. That is, transfer data from the 
    //    mailbox into the selected IF1/IF2 Message Buffer Registers.
    // 1: Direction = Write: Transfer direction is from the IF1/IF2 Register set to the message 
    //    object addressed by Message Number (Bits [7:0]). That is, transfer data from the 
    //    selected IF1/IF2 Message Buffer Registers to the mailbox.
    uint32_t DIR:1;         //23    
    uint32_t rsvd1:8;       //31:24    
};
//!
//! HAL_CAN IFx Command Registers (x: 1~3)
//!
union HAL_CAN_IFxCMD_REG{
    uint32_t                        all;
    struct HAL_CAN_IFxCMD_BITS      bit;
};

//!
//! HAL_CAN IFx Mask Registers bit definitions (x: 1~3)
//!
struct HAL_CAN_IFxMSK_BITS {
    // Identifier Mask
    // 0: The corresponding bit in the identifier of the message object is not used for acceptance 
    //    filtering (don't care).
    // 1: The corresponding bit in the identifier of the message object is used for acceptance filtering.
    uint32_t Msk:29;        //28:0
    uint32_t rsvd1:1;       //29
    
    // Mask Message Direction
    // 0: The message direction bit (Dir) has no effect on the acceptance filtering.
    // 1: The message direction bit (Dir) is used for acceptance filtering. 
    uint32_t MDir:1;        //30
        
    // Mask Extended Identifier
    // 0: The extended identifier bit (Xtd) has no effect on the acceptance filtering.
    // 1: The extended identifier bit (Xtd) is used for acceptance filtering. When 11-bit ("standard")
    //    identifiers are used for a message object, the identifiers of received data frames are 
    //    written into bits ID[28:18]. For acceptance filtering, only these bits together with mask 
    //    bits Msk[28:18] are considered.
    uint32_t MXtd:1;         //31    
};
//!
//! HAL_CAN IFx Mask Registerss (x: 1~3)
//!
union HAL_CAN_IFxMSK_REG{
    uint32_t                        all;
    struct HAL_CAN_IFxMSK_BITS      bit;
};


//!
//! HAL_CAN IFx Arbitration Registers bit definitions (x: 1~3)
//!
struct HAL_CAN_IFxARB_BITS {
    // Message Identifier
    // ID[28:0] 29-bit Identifier ("Extended Frame")
    // ID[28:18] 11-bit Identifier ("Standard Frame")
    uint32_t ID:29;         //28:0

    // Message Direction
    // 0: Direction = receive: On TxRqst, a remote frame with the identifier of this message object
    //    is transmitted. On reception of a data frame with matching identifier, that frame is stored
    //    in this message object.
    // 1: Direction = transmit: On TxRqst, the respective message object is transmitted as a data 
    //    frame. On reception of a remote frame with matching identifier, the TxRqst bit of this 
    //    message object is set (if RmtEn = one).    
    uint32_t Dir:1;         //29
    
    // Extended Identifier
    // 0: The 11-bit ("standard") Identifier is used for this message object.
    // 1: The 29-bit ("extended") Identifier is used for this message object.
    uint32_t Xtd:1;         //30

    // Message Valid
    // The CPU should reset the MsgVal bit of all unused Messages Objects during the initialization 
    // before it resets the Init bit in the HAL_CAN Control Register 
    // 0: The mailbox is disabled. (The message object is ignored by the message handler).
    // 1: The mailbox is enabled. (The message object is to be used by the message handler).
    uint32_t MsgVal:1;      //31
};
//!
//! HAL_CAN IFx Arbitration Registers(x: 1~3)
//!
union HAL_CAN_IFxARB_REG{
    uint32_t                        all;
    struct HAL_CAN_IFxARB_BITS      bit;
};


//!
//! HAL_CAN IFx Message Control Registers bit definitions (x: 1~3)
//!
struct HAL_CAN_IFxMCTL_BITS {
    // Data length code
    // 0-8: Data frame has 0-8 data bytes.
    // 9-15: Data frame has 8 data bytes.
    uint32_t DLC:4;         //3:0
    uint32_t rsvd2:3;       //6:4

    // End of Block
    // 0: The message object is part of a FIFO Buffer block and is not the last message object of 
    //    the FIFO Buffer block. 
    // 1: The message object is a single message object or the last message object in a FIFO Buffer
    //    Block.    
    uint32_t EoB:1;         //7

    // Transmit Request
    // 0: This message object is not waiting for a transmission.
    // 1: The transmission of this message object is requested and is not yet done.    
    uint32_t TxRqst:1;      //8

    // Remote Enable
    // 0: At the reception of a remote frame, TxRqst is not changed.
    // 1: At the reception of a remote frame, TxRqst is set.    
    uint32_t RmtEn:1;       //9

    // Receive Interrupt Enable
    // 0: IntPnd will not be triggered after the successful reception of a frame.
    // 1: IntPnd will be triggered after the successful reception of a frame.    
    uint32_t RxIE:1;        //10        

    // Transmit Interrupt Enable
    // 0: IntPnd will not be triggered after the successful transmission of a frame.
    // 1: IntPnd will be triggered after the successful transmission of a frame.
    uint32_t TxIE:1;        //11

    // Use Acceptance Mask
    // If the UMask bit is set to one, the message object's mask bits have to be programmed during 
    // initialization of the message object before MsgVal is set to one.
    // 0: Mask ignored
    // 1: Use Mask (Msk[28:0], MXtd, and MDir) for acceptance filtering
    uint32_t UMask:1;       //12

    // Interrupt Pending
    // 0: This message object is not the source of an interrupt.
    // 1: This message object is the source of an interrupt. The Interrupt Identifier in the Interrupt
    //    Register will point to this message object if there is no other interrupt source with higher 
    //    priority.    
    uint32_t IntPnd:1;      //13

    // Message Lost (only valid for message objects with direction = receive)
    // 0: No message lost since the last time when this bit was reset by the CPU.
    // 1: The message handler stored a new message into this object when NewDat was still set, so 
    //    the previous message has been overwritten.
    uint32_t MsgLst:1;      //14

    // New Data
    // 0: No new data has been written into the data portion of this message object by the message 
    //    handler since the last time when this flag was cleared by the CPU.
    // 1: The message handler or the CPU has written new data into the data portion of this message 
    //    object.
    uint32_t NewDat:1;      //15
    uint32_t rsvd1:16;      //31:16   
};
//!
//! HAL_CAN IFx Message Control Registers (x: 1~3)
//!
union HAL_CAN_IFxMCTL_REG{
    uint32_t                        all;
    struct HAL_CAN_IFxMCTL_BITS     bit;
};


//!
//! HAL_CAN IF Data A Registers bit definitions (x: 1~3)
//!
struct HAL_CAN_IFxDATA_BITS {
    // Data Byte 0
    uint32_t Data_0:8;      //7:0

    // Data Byte 1
    uint32_t Data_1:8;      //15:8
    
    // Data Byte 2
    uint32_t Data_2:8;      //23:16

    // Data Byte 3
    uint32_t Data_3:8;      //31:24    
};
//!
//! HAL_CAN IF Data A Registers (x: 1~3)
//!
union HAL_CAN_IFxDATA_REG{
    uint32_t                        all;
    struct HAL_CAN_IFxDATA_BITS     bit;
};

//!
//! HAL_CAN IF1 Data B Register bit definitions
//!
struct HAL_CAN_IFxDATB_BITS {
    // Data Byte 4
    uint32_t Data_4:8;      //7:0

    // Data Byte 5
    uint32_t Data_5:8;      //15:8
    
    // Data Byte 6
    uint32_t Data_6:8;      //23:16

    // Data Byte 7
    uint32_t Data_7:8;      //31:24   
};

//!
//! HAL_CAN IF1 Data B Registers
//!
union HAL_CAN_IFxDATB_REG{
    uint32_t                        all;
    struct HAL_CAN_IFxDATB_BITS     bit;
};


//!
//! HAL_CAN IF3 Observation Register bit definitions
//!
struct HAL_CAN_IF3OBS_BITS {
    // Mask data read observation
    // 0: Mask data not to be read.
    // 1: Mask data has to be read to enable next IF3 update.
    uint32_t Mask:1;        //0

    // Arbitration data read observation
    // 0: Arbitration data not to be read.
    // 1: Arbitration data has to be read to enable next IF3 update.
    uint32_t Arb:1;         //1

    // Ctrl read observation
    // 0: Ctrl section not to be read.
    // 1: Ctrl section has to be read to enable next IF3 update.
    uint32_t Ctrl:1;        //2

    // Data A read observation
    // 0: Data A section not to be read.
    // 1: Data A section has to be read to enable next IF3 update.    
    uint32_t Data_A:1;      //3

    // Data B read observation
    // 0: Data B section not to be read.
    // 1: Data B section has to be read to enable next IF3 update.
    uint32_t Data_B:1;      //4
    uint32_t rsvd3:3;       //7:5

    // IF3 Status of Mask data read access
    // 0: All Mask data bytes are already read out, or are not marked to be read.
    // 1: Mask section has still data to be read out.
    uint32_t IF3SM:1;       //8

    // IF3 Status of Arbitration data read access
    // 0: All Arbitration data bytes are already read out, or are not marked to be read.
    // 1: Arbitration section has still data to be read out.    
    uint32_t IF3SA:1;       //9

    // IF3 Status of Control bits read access
    // 0: All Control section bytes are already read out, or are not marked to be read.
    // 1: Control section has still data to be read out.
    uint32_t IF3SC:1;       //10

    // IF3 Status of Data A read access
    // 0: All Data A bytes are already read out, or are not marked to be read.
    // 1: Data A section has still data to be read out.
    uint32_t IF3SDA:1;      //11

    // IF3 Status of Data B read access
    // 0: All Data B bytes are already read out, or are not marked to be read.
    // 1: Data B section has still data to be read out.    
    uint32_t IF3SDB:1;      //12
    uint32_t rsvd2:2;       //14:13
    
    // IF3 Update Data
    // 0: No new data has been loaded since last IF3 read.
    // 1: New data has been loaded since last IF3 read.      
    uint32_t IF3Upd:1;      //15
    uint32_t rsvd1:16;      //31:16
};

//!
//! HAL_CAN IF3 Observation Registers
//!
union HAL_CAN_IF3OBS_REG{
    uint32_t                        all;
    struct HAL_CAN_IF3OBS_BITS      bit;
};

//!
//! HAL_CAN IF3 Update Enable Registers bit definitions
//!
struct HAL_CAN_IF3UPD_BITS {
    // IF3 Update Enabled (for all message objects)
    // 0: Automatic IF3 update is disabled for this message object.
    // 1: Automatic IF3 update is enabled for this message object. A message object is scheduled
    //    to be copied to IF3 register set, if NewDat flag of the message object is active.    
    uint32_t IF3UpdEn:32;   //31:0
};
//
//! HAL_CAN IF3 Update Enable Registers
union HAL_CAN_IF3UPD_REG{
    uint32_t                        all;
    struct HAL_CAN_IF3UPD_BITS      bit;
};


//!
//! HAL_CAN Message ID (MSGID) bit definitions
//!
struct  HAL_CANMSGID_STD_BITS {
    uint32_t rsvd2:18;   //17 : 0
    //Message Identifier
    //ID[28:18] 11-bit ("standard") identifier bits    
    uint32_t ID: 11; //28 : 18
    uint32_t rsvd1: 3; //31 : 29 
};

struct  HAL_CANMSGID_EXT_BITS {
    //Message Identifier
    //ID[28:0] 29-bit ("extended") identifier bits
    uint32_t ID: 29; //28 : 0
    uint32_t rsvd1: 3; //31 : 29 
};

union HAL_CANMSGID_REG{
    uint32_t                        all;
    struct HAL_CANMSGID_STD_BITS    std_bits;
    struct HAL_CANMSGID_EXT_BITS    ext_bits;
};


#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_CAN_H definition
