/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_nvic.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_NVIC_H
#define REGS_NVIC_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// NVIC Individual Register Bit Definitions:

struct ISER0_BITS {			// bits   description
	uint32_t	IRQ0_ENABLE:1;			// 0:0   CAN1_HOST_IRQ Enable
	uint32_t	IRQ1_ENABLE:1;			// 1:1   CAN0_HOST_IRQ Enable
	uint32_t	IRQ2_ENABLE:1;			// 2:2   SPI1_INTR Enable
	uint32_t	IRQ3_ENABLE:1;			// 3:3   SPI0_INTR Enable
	uint32_t	rsvd1:2;			// 5:4   reserved
	uint32_t	IRQ6_ENABLE:1;			// 6:6   SCIB_INTR Enable
	uint32_t	IRQ7_ENABLE:1;			// 7:7   SCIA_INTR Enable
	uint32_t	IRQ8_ENABLE:1;			// 8:8   I2C2_INTR Enable
	uint32_t	IRQ9_ENABLE:1;			// 9:9   I2C1_INTR Enable
	uint32_t	IRQ10_ENABLE:1;			// 10:10   I2C0_INTR Enable
	uint32_t	rsvd2:12;			// 22:11   reserved
	uint32_t	IRQ23_ENABLE:1;			// 23:23   APB_GPIO3_CMBINTR Enable
	uint32_t	IRQ24_ENABLE:1;			// 24:24   APB_GPIO2_CMBINTR Enable
	uint32_t	IRQ25_ENABLE:1;			// 25:25   APB_GPIO1_CMBINTR Enable
	uint32_t	IRQ26_ENABLE:1;			// 26:26   APB_GPIO0_CMBINTR Enable
	uint32_t	IRQ27_ENABLE:1;			// 27:27   AP_TIMER_INTR3 Enable
	uint32_t	IRQ28_ENABLE:1;			// 28:28   AP_TIMER_INTR2 Enable
	uint32_t	IRQ29_ENABLE:1;			// 29:29   AP_TIMER_INTR1 Enable
	uint32_t	IRQ30_ENABLE:1;			// 30:30   AP_TIMER_INTR0 Enable
	uint32_t	IRQ31_ENABLE:1;			// 31:31   CRC_FAIL_INT Enable
};

union ISER0_REG {
	uint32_t 		 all;
	struct ISER0_BITS 		 bit;
};

struct ISER1_BITS {			// bits   description
	uint32_t	IRQ32_ENABLE:1;			// 0:0   CRC_DONE_INT Enable
	uint32_t	IRQ33_ENABLE:1;			// 1:1   LC3_INT_REQ Enable
	uint32_t	IRQ34_ENABLE:1;			// 2:2   LC2_INT_REQ Enable
	uint32_t	IRQ35_ENABLE:1;			// 3:3   LC1_INT_REQ Enable
	uint32_t	IRQ36_ENABLE:1;			// 4:4   EQEP2_INT Enable
	uint32_t	IRQ37_ENABLE:1;			// 5:5   EQEP1_INT Enable
	uint32_t	IRQ38_ENABLE:1;			// 6:6   ECAP2_HRCAL_INT Enable
	uint32_t	IRQ39_ENABLE:1;			// 7:7   ECAP1_HRCAL_INT Enable
	uint32_t	IRQ40_ENABLE:1;			// 8:8   ECAP7_INT Enable
	uint32_t	IRQ41_ENABLE:1;			// 9:9   ECAP6_INT Enable
	uint32_t	IRQ42_ENABLE:1;			// 10:10   ECAP5_INT Enable
	uint32_t	IRQ43_ENABLE:1;			// 11:11   ECAP4_INT Enable
	uint32_t	IRQ44_ENABLE:1;			// 12:12   ECAP3_INT Enable
	uint32_t	IRQ45_ENABLE:1;			// 13:13   ECAP2_INT Enable
	uint32_t	IRQ46_ENABLE:1;			// 14:14   ECAP1_INT Enable
	uint32_t	IRQ47_ENABLE:1;			// 15:15   CPU_16XINT Enable
	uint32_t	IRQ48_ENABLE:1;			// 16:16   CPU_15XINT Enable
	uint32_t	IRQ49_ENABLE:1;			// 17:17   CPU_14XINT Enable
	uint32_t	IRQ50_ENABLE:1;			// 18:18   CPU_13XINT Enable
	uint32_t	IRQ51_ENABLE:1;			// 19:19   CPU_12XINT Enable
	uint32_t	IRQ52_ENABLE:1;			// 20:20   CPU_11XINT Enable
	uint32_t	IRQ53_ENABLE:1;			// 21:21   CPU_10XINT Enable
	uint32_t	IRQ54_ENABLE:1;			// 22:22   CPU_9XINT Enable
	uint32_t	IRQ55_ENABLE:1;			// 23:23   CPU_8XINT Enable
	uint32_t	IRQ56_ENABLE:1;			// 24:24   CPU_7XINT Enable
	uint32_t	IRQ57_ENABLE:1;			// 25:25   CPU_6XINT Enable
	uint32_t	IRQ58_ENABLE:1;			// 26:26   CPU_5XINT Enable
	uint32_t	IRQ59_ENABLE:1;			// 27:27   CPU_4XINT Enable
	uint32_t	IRQ60_ENABLE:1;			// 28:28   CPU_3XINT Enable
	uint32_t	IRQ61_ENABLE:1;			// 29:29   CPU_2XINT Enable
	uint32_t	IRQ62_ENABLE:1;			// 30:30   CPU_1XINT Enable
	uint32_t	IRQ63_ENABLE:1;			// 31:31   TZ12_INTERRUPT Enable
};

union ISER1_REG {
	uint32_t 		 all;
	struct ISER1_BITS 		 bit;
};

struct ISER2_BITS {			// bits   description
	uint32_t	IRQ64_ENABLE:1;			// 0:0   TZ11_INTERRUPT Enable
	uint32_t	IRQ65_ENABLE:1;			// 1:1   TZ10_INTERRUPT Enable
	uint32_t	IRQ66_ENABLE:1;			// 2:2   TZ9_INTERRUPT Enable
	uint32_t	IRQ67_ENABLE:1;			// 3:3   TZ8_INTERRUPT Enable
	uint32_t	IRQ68_ENABLE:1;			// 4:4   TZ7_INTERRUPT Enable
	uint32_t	IRQ69_ENABLE:1;			// 5:5   TZ6_INTERRUPT Enable
	uint32_t	IRQ70_ENABLE:1;			// 6:6   TZ5_INTERRUPT Enable
	uint32_t	IRQ71_ENABLE:1;			// 7:7   TZ4_INTERRUPT Enable
	uint32_t	IRQ72_ENABLE:1;			// 8:8   TZ3_INTERRUPT Enable
	uint32_t	IRQ73_ENABLE:1;			// 9:9   TZ2_INTERRUPT Enable
	uint32_t	IRQ74_ENABLE:1;			// 10:10   TZ1_INTERRUPT Enable
	uint32_t	IRQ75_ENABLE:1;			// 11:11   EPWM12XINT Enable
	uint32_t	IRQ76_ENABLE:1;			// 12:12   EPWM11XINT Enable
	uint32_t	IRQ77_ENABLE:1;			// 13:13   EPWM10XINT Enable
	uint32_t	IRQ78_ENABLE:1;			// 14:14   EPWM9XINT Enable
	uint32_t	IRQ79_ENABLE:1;			// 15:15   EPWM8XINT Enable
	uint32_t	IRQ80_ENABLE:1;			// 16:16   EPWM7XINT Enable
	uint32_t	IRQ81_ENABLE:1;			// 17:17   EPWM6XINT Enable
	uint32_t	IRQ82_ENABLE:1;			// 18:18   EPWM5XINT Enable
	uint32_t	IRQ83_ENABLE:1;			// 19:19   EPWM4XINT Enable
	uint32_t	IRQ84_ENABLE:1;			// 20:20   EPWM3XINT Enable
	uint32_t	IRQ85_ENABLE:1;			// 21:21   EPWM2XINT Enable
	uint32_t	IRQ86_ENABLE:1;			// 22:22   EPWM1XINT Enable
	uint32_t	IRQ87_ENABLE:1;			// 23:23   QSPI_INTR Enable
	uint32_t	IRQ88_ENABLE:1;			// 24:24   DMA_INT_CH0_ISTATUSTFR Enable
	uint32_t	IRQ89_ENABLE:1;			// 25:25   DMA_INT_CH1_ISTATUSTFR Enable
	uint32_t	IRQ90_ENABLE:1;			// 26:26   DMA_INT_CH2_ISTATUSTFR Enable
	uint32_t	IRQ91_ENABLE:1;			// 27:27   DMA_INT_CH3_ISTATUSTFR Enable
	uint32_t	IRQ92_ENABLE:1;			// 28:28   DMA_INT_CH4_ISTATUSTFR Enable
	uint32_t	IRQ93_ENABLE:1;			// 29:29   DMA_INT_CH5_ISTATUSTFR Enable
	uint32_t	IRQ94_ENABLE:1;			// 30:30   DMA_INT_CH6_ISTATUSTFR Enable
	uint32_t	IRQ95_ENABLE:1;			// 31:31   DMA_INT_CH7_ISTATUSTFR Enable
};

union ISER2_REG {
	uint32_t 		 all;
	struct ISER2_BITS 		 bit;
};

struct ISER3_BITS {			// bits   description
	uint32_t	IRQ96_ENABLE:1;			// 0:0   DMA_INT_CH0_ISTATUSBLOCK Enable
	uint32_t	IRQ97_ENABLE:1;			// 1:1   DMA_INT_CH1_ISTATUSBLOCK Enable
	uint32_t	IRQ98_ENABLE:1;			// 2:2   DMA_INT_CH2_ISTATUSBLOCK Enable
	uint32_t	IRQ99_ENABLE:1;			// 3:3   DMA_INT_CH3_ISTATUSBLOCK Enable
	uint32_t	IRQ100_ENABLE:1;			// 4:4   DMA_INT_CH4_ISTATUSBLOCK Enable
	uint32_t	IRQ101_ENABLE:1;			// 5:5   DMA_INT_CH5_ISTATUSBLOCK Enable
	uint32_t	IRQ102_ENABLE:1;			// 6:6   DMA_INT_CH6_ISTATUSBLOCK Enable
	uint32_t	IRQ103_ENABLE:1;			// 7:7   DMA_INT_CH7_ISTATUSBLOCK Enable
	uint32_t	IRQ104_ENABLE:1;			// 8:8   DMA_INT_CH0_ISTATUSSRCTRAN Enable
	uint32_t	IRQ105_ENABLE:1;			// 9:9   DMA_INT_CH1_ISTATUSSRCTRAN Enable
	uint32_t	IRQ106_ENABLE:1;			// 10:10   DMA_INT_CH2_ISTATUSSRCTRAN Enable
	uint32_t	IRQ107_ENABLE:1;			// 11:11   DMA_INT_CH3_ISTATUSSRCTRAN Enable
	uint32_t	IRQ108_ENABLE:1;			// 12:12   DMA_INT_CH4_ISTATUSSRCTRAN Enable
	uint32_t	IRQ109_ENABLE:1;			// 13:13   DMA_INT_CH5_ISTATUSSRCTRAN Enable
	uint32_t	IRQ110_ENABLE:1;			// 14:14   DMA_INT_CH6_ISTATUSSRCTRAN Enable
	uint32_t	IRQ111_ENABLE:1;			// 15:15   DMA_INT_CH7_ISTATUSSRCTRAN Enable
	uint32_t	IRQ112_ENABLE:1;			// 16:16   DMA_INT_CH0_ISTATUSDSTTRAN Enable
	uint32_t	IRQ113_ENABLE:1;			// 17:17   DMA_INT_CH1_ISTATUSDSTTRAN Enable
	uint32_t	IRQ114_ENABLE:1;			// 18:18   DMA_INT_CH2_ISTATUSDSTTRAN Enable
	uint32_t	IRQ115_ENABLE:1;			// 19:19   DMA_INT_CH3_ISTATUSDSTTRAN Enable
	uint32_t	IRQ116_ENABLE:1;			// 20:20   DMA_INT_CH4_ISTATUSDSTTRAN Enable
	uint32_t	IRQ117_ENABLE:1;			// 21:21   DMA_INT_CH5_ISTATUSDSTTRAN Enable
	uint32_t	IRQ118_ENABLE:1;			// 22:22   DMA_INT_CH6_ISTATUSDSTTRAN Enable
	uint32_t	IRQ119_ENABLE:1;			// 23:23   DMA_INT_CH7_ISTATUSDSTTRAN Enable
	uint32_t	IRQ120_ENABLE:1;			// 24:24   DMA_INT_CH0_ISTATUSERR Enable
	uint32_t	IRQ121_ENABLE:1;			// 25:25   DMA_INT_CH1_ISTATUSERR Enable
	uint32_t	IRQ122_ENABLE:1;			// 26:26   DMA_INT_CH2_ISTATUSERR Enable
	uint32_t	IRQ123_ENABLE:1;			// 27:27   DMA_INT_CH3_ISTATUSERR Enable
	uint32_t	IRQ124_ENABLE:1;			// 28:28   DMA_INT_CH4_ISTATUSERR Enable
	uint32_t	IRQ125_ENABLE:1;			// 29:29   DMA_INT_CH5_ISTATUSERR Enable
	uint32_t	IRQ126_ENABLE:1;			// 30:30   DMA_INT_CH6_ISTATUSERR Enable
	uint32_t	IRQ127_ENABLE:1;			// 31:31   DMA_INT_CH7_ISTATUSERR Enable
};

union ISER3_REG {
	uint32_t 		 all;
	struct ISER3_BITS 		 bit;
};

struct ISER4_BITS {			// bits   description
	uint32_t	IRQ128_ENABLE:1;			// 0:0   EXTI_INT0 Enable
	uint32_t	IRQ129_ENABLE:1;			// 1:1   EXTI_INT1 Enable
	uint32_t	IRQ130_ENABLE:1;			// 2:2   EXTI_INT2 Enable
	uint32_t	IRQ131_ENABLE:1;			// 3:3   EXTI_INT3 Enable
	uint32_t	IRQ132_ENABLE:1;			// 4:4   EXTI_INT4 Enable
	uint32_t	IRQ133_ENABLE:1;			// 5:5   EXTI_INT5 Enable
	uint32_t	IRQ134_ENABLE:1;			// 6:6   EXTI_INT6 Enable
	uint32_t	IRQ135_ENABLE:1;			// 7:7   EXTI_INT7 Enable
	uint32_t	IRQ136_ENABLE:1;			// 8:8   EXTI_INT8 Enable
	uint32_t	IRQ137_ENABLE:1;			// 9:9   EXTI_INT9 Enable
	uint32_t	IRQ138_ENABLE:1;			// 10:10   EXTI_INT10 Enable
	uint32_t	IRQ139_ENABLE:1;			// 11:11   EXTI_INT11 Enable
	uint32_t	IRQ140_ENABLE:1;			// 12:12   EXTI_INT12 Enable
	uint32_t	IRQ141_ENABLE:1;			// 13:13   EXTI_INT13 Enable
	uint32_t	IRQ142_ENABLE:1;			// 14:14   EXTI_INT14 Enable
	uint32_t	IRQ143_ENABLE:1;			// 15:15   EXTI_INT15 Enable
	uint32_t	IRQ144_ENABLE:1;			// 16:16   EXTI_INT16 Enable
	uint32_t	IRQ145_ENABLE:1;			// 17:17   EXTI_INT17 Enable
	uint32_t	IRQ146_ENABLE:1;			// 18:18   EXTI_INT18 Enable
	uint32_t	IRQ147_ENABLE:1;			// 19:19   EXTI_INT19 Enable
	uint32_t	IRQ148_ENABLE:1;			// 20:20   EXTI_INT20 Enable
	uint32_t	IRQ149_ENABLE:1;			// 21:21   EXTI_INT21 Enable
	uint32_t	IRQ150_ENABLE:1;			// 22:22   EXTI_INT22 Enable
	uint32_t	IRQ151_ENABLE:1;			// 23:23   EXTI_INT23 Enable
	uint32_t	IRQ152_ENABLE:1;			// 24:24   EXTI_INT24 Enable
	uint32_t	IRQ153_ENABLE:1;			// 25:25   EXTI_INT25 Enable
	uint32_t	IRQ154_ENABLE:1;			// 26:26   EXTI_INT26 Enable
	uint32_t	IRQ155_ENABLE:1;			// 27:27   EXTI_INT27 Enable
	uint32_t	IRQ156_ENABLE:1;			// 28:28   EXTI_INT28 Enable
	uint32_t	IRQ157_ENABLE:1;			// 29:29   EXTI_INT29 Enable
	uint32_t	IRQ158_ENABLE:1;			// 30:30   EXTI_INT30 Enable
	uint32_t	IRQ159_ENABLE:1;			// 31:31   EXTI_INT31 Enable
};

union ISER4_REG {
	uint32_t 		 all;
	struct ISER4_BITS 		 bit;
};

struct ISER5_BITS {			// bits   description
	uint32_t	IRQ160_ENABLE:1;			// 0:0   AP_SYSCTL_FPUSTA Enable
	uint32_t	IRQ161_ENABLE:1;			// 1:1   AP_SYSCTL_FPUSTA Enable
	uint32_t	IRQ162_ENABLE:1;			// 2:2   AP_SYSCTL_FPUSTA Enable
	uint32_t	IRQ163_ENABLE:1;			// 3:3   AP_SYSCTL_FPUSTA Enable
	uint32_t	IRQ164_ENABLE:1;			// 4:4   AP_SYSCTL_FPUSTA Enable
	uint32_t	IRQ165_ENABLE:1;			// 5:5   AP_SYSCTL_FPUSTA Enable
	uint32_t	IRQ166_ENABLE:1;			// 6:6   FP_NV_INT Enable
	uint32_t	IRQ167_ENABLE:1;			// 7:7   FP_DZ_INT Enable
	uint32_t	IRQ168_ENABLE:1;			// 8:8   FP_OF_INT Enable
	uint32_t	IRQ169_ENABLE:1;			// 9:9   FP_UF_INT Enable
	uint32_t	IRQ170_ENABLE:1;			// 10:10   AP_WDT_INTR Enable
	uint32_t	IRQ171_ENABLE:1;			// 11:11   ADCC_EVT_INT Enable
	uint32_t	IRQ172_ENABLE:1;			// 12:12   ADCB_EVT_INT Enable
	uint32_t	IRQ173_ENABLE:1;			// 13:13   ADCA_EVT_INT Enable
	uint32_t	IRQ174_ENABLE:1;			// 14:14   ADCC_4INT Enable
	uint32_t	IRQ175_ENABLE:1;			// 15:15   ADCC_3INT Enable
	uint32_t	IRQ176_ENABLE:1;			// 16:16   ADCC_2INT Enable
	uint32_t	IRQ177_ENABLE:1;			// 17:17   ADCC_1INT Enable
	uint32_t	IRQ178_ENABLE:1;			// 18:18   ADCB_4INT Enable
	uint32_t	IRQ179_ENABLE:1;			// 19:19   ADCB_3INT Enable
	uint32_t	IRQ180_ENABLE:1;			// 20:20   ADCB_2INT Enable
	uint32_t	IRQ181_ENABLE:1;			// 21:21   ADCB_1INT Enable
	uint32_t	IRQ182_ENABLE:1;			// 22:22   ADCA_4INT Enable
	uint32_t	IRQ183_ENABLE:1;			// 23:23   ADCA_3INT Enable
	uint32_t	IRQ184_ENABLE:1;			// 24:24   ADCA_2INT Enable
	uint32_t	IRQ185_ENABLE:1;			// 25:25   ADCA_1INT Enable
	uint32_t	IRQ186_ENABLE:1;			// 26:26   DSP_EVT_O Enable
	uint32_t	IRQ187_ENABLE:1;			// 27:27   DSP_TASK_INT0 Enable
	uint32_t	IRQ188_ENABLE:1;			// 28:28   DSP_TASK_INT1 Enable
	uint32_t	IRQ189_ENABLE:1;			// 29:29   DSP_TASK_INT2 Enable
	uint32_t	IRQ190_ENABLE:1;			// 30:30   DSP_TASK_INT3 Enable
	uint32_t	IRQ191_ENABLE:1;			// 31:31   DSP_TASK_INT4 Enable
};

union ISER5_REG {
	uint32_t 		 all;
	struct ISER5_BITS 		 bit;
};

struct ISER6_BITS {			// bits   description
	uint32_t	IRQ192_ENABLE:1;			// 0:0   DSP_TASK_INT5 Enable
	uint32_t	IRQ193_ENABLE:1;			// 1:1   DSP_TASK_INT6 Enable
	uint32_t	IRQ194_ENABLE:1;			// 2:2   DSP_TASK_INT7 Enable
	uint32_t	IRQ195_ENABLE:1;			// 3:3   DSP_TASK_INT8 Enable
	uint32_t	IRQ196_ENABLE:1;			// 4:4   DSP_TASK_INT9 Enable
	uint32_t	IRQ197_ENABLE:1;			// 5:5   DSP_TASK_INT10 Enable
	uint32_t	IRQ198_ENABLE:1;			// 6:6   DSP_TASK_INT11 Enable
	uint32_t	IRQ199_ENABLE:1;			// 7:7   DSP_TASK_INT12 Enable
	uint32_t	IRQ200_ENABLE:1;			// 8:8   DSP_TASK_INT13 Enable
	uint32_t	IRQ201_ENABLE:1;			// 9:9   DSP_TASK_INT14 Enable
	uint32_t	IRQ202_ENABLE:1;			// 10:10   DSP_TASK_INT15 Enable
	uint32_t	IRQ203_ENABLE:1;			// 11:11   DSP_TASK_INT16 Enable
	uint32_t	IRQ204_ENABLE:1;			// 12:12   DSP_TASK_INT17 Enable
	uint32_t	IRQ205_ENABLE:1;			// 13:13   DSP_TASK_INT18 Enable
	uint32_t	IRQ206_ENABLE:1;			// 14:14   DSP_TASK_INT19 Enable
	uint32_t	IRQ207_ENABLE:1;			// 15:15   DSP_TASK_INT20 Enable
	uint32_t	IRQ208_ENABLE:1;			// 16:16   DSP_TASK_INT21 Enable
	uint32_t	IRQ209_ENABLE:1;			// 17:17   DSP_TASK_INT22 Enable
	uint32_t	IRQ210_ENABLE:1;			// 18:18   DSP_TASK_INT23 Enable
	uint32_t	IRQ211_ENABLE:1;			// 19:19   DSP_TASK_INT24 Enable
	uint32_t	IRQ212_ENABLE:1;			// 20:20   DSP_TASK_INT25 Enable
	uint32_t	IRQ213_ENABLE:1;			// 21:21   DSP_TASK_INT26 Enable
	uint32_t	IRQ214_ENABLE:1;			// 22:22   DSP_TASK_INT27 Enable
	uint32_t	IRQ215_ENABLE:1;			// 23:23   DSP_TASK_INT28 Enable
	uint32_t	IRQ216_ENABLE:1;			// 24:24   DSP_TASK_INT29 Enable
	uint32_t	IRQ217_ENABLE:1;			// 25:25   DSP_TASK_INT30 Enable
	uint32_t	IRQ218_ENABLE:1;			// 26:26   DSP_TASK_INT31 Enable
	uint32_t	IRQ219_ENABLE:1;			// 27:27   DLM_ECC_SBERR Enable
	uint32_t	IRQ220_ENABLE:1;			// 28:28   ILM_ECC_SBERR Enable
	uint32_t	IRQ221_ENABLE:1;			// 29:29   |GS_RAM_RD_ERR Enable
	uint32_t	IRQ222_ENABLE:1;			// 30:30   |CCM_RAM_RD_ERR Enable
	uint32_t	IRQ223_ENABLE:1;			// 31:31   EFC_SEC_INTR Enable
};

union ISER6_REG {
	uint32_t 		 all;
	struct ISER6_BITS 		 bit;
};

struct ISER7_BITS {			// bits   description
	uint32_t	IRQ224_ENABLE:1;			// 0:0   EFC_DONE_INTR Enable
	uint32_t	IRQ225_ENABLE:1;			// 1:1   EFC_INTR Enable
	uint32_t	IRQ226_ENABLE:1;			// 2:2   IBUS_IRQ Enable
	uint32_t	IRQ227_ENABLE:1;			// 3:3   DBUS_IRQ Enable
	uint32_t	IRQ228_ENABLE:1;			// 4:4   RTOSINT2 Enable
	uint32_t	IRQ229_ENABLE:1;			// 5:5   RTOSINT1 Enable
	uint32_t	IRQ230_ENABLE:1;			// 6:6   LSE_CLOCK_FAIL_INT Enable
	uint32_t	IRQ231_ENABLE:1;			// 7:7   ~PLL_LOCK Enable
	uint32_t	IRQ232_ENABLE:1;			// 8:8   PMBUS_ALERT Enable
	uint32_t	IRQ233_ENABLE:1;			// 9:9   DSP_EXCP_INT0TRACE_EXCP0 Enable
	uint32_t	IRQ234_ENABLE:1;			// 10:10   DSP_EXCP_INT1TRACE_EXCP1 Enable
	uint32_t	IRQ235_ENABLE:1;			// 11:11   DSP_EXCP_INT2TRACE_EXCP2 Enable
	uint32_t	IRQ236_ENABLE:1;			// 12:12   DSP_EXCP_INT3TRACE_EXCP3 Enable
	uint32_t	IRQ237_ENABLE:1;			// 13:13   DSP_EXCP_INT4TRACE_EXCP4|TRACE_EXCP6 Enable
	uint32_t	IRQ238_ENABLE:1;			// 14:14   DSP_EXCP_INT5TRACE_EXCP5|7|13|15 Enable
	uint32_t	IRQ239_ENABLE:1;			// 15:15   DSP_EXCP_INT6TRACE_EXCP11 Enable
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union ISER7_REG {
	uint32_t 		 all;
	struct ISER7_BITS 		 bit;
};

struct ICER0_BITS {			// bits   description
	uint32_t	IRQ0_CLEAR_ENABLE:1;			// 0:0   CAN1_HOST_IRQ Clear Enable
	uint32_t	IRQ1_CLEAR_ENABLE:1;			// 1:1   CAN0_HOST_IRQ Clear Enable
	uint32_t	IRQ2_CLEAR_ENABLE:1;			// 2:2   SPI1_INTR Clear Enable
	uint32_t	IRQ3_CLEAR_ENABLE:1;			// 3:3   SPI0_INTR Clear Enable
	uint32_t	rsvd1:2;			// 5:4   reserved
	uint32_t	IRQ6_CLEAR_ENABLE:1;			// 6:6   SCIB_INTR Clear Enable
	uint32_t	IRQ7_CLEAR_ENABLE:1;			// 7:7   SCIA_INTR Clear Enable
	uint32_t	IRQ8_CLEAR_ENABLE:1;			// 8:8   I2C2_INTR Clear Enable
	uint32_t	IRQ9_CLEAR_ENABLE:1;			// 9:9   I2C1_INTR Clear Enable
	uint32_t	IRQ10_CLEAR_ENABLE:1;			// 10:10   I2C0_INTR Clear Enable
	uint32_t	rsvd2:12;			// 22:11   reserved
	uint32_t	IRQ23_CLEAR_ENABLE:1;			// 23:23   APB_GPIO3_CMBINTR Clear Enable
	uint32_t	IRQ24_CLEAR_ENABLE:1;			// 24:24   APB_GPIO2_CMBINTR Clear Enable
	uint32_t	IRQ25_CLEAR_ENABLE:1;			// 25:25   APB_GPIO1_CMBINTR Clear Enable
	uint32_t	IRQ26_CLEAR_ENABLE:1;			// 26:26   APB_GPIO0_CMBINTR Clear Enable
	uint32_t	IRQ27_CLEAR_ENABLE:1;			// 27:27   AP_TIMER_INTR3 Clear Enable
	uint32_t	IRQ28_CLEAR_ENABLE:1;			// 28:28   AP_TIMER_INTR2 Clear Enable
	uint32_t	IRQ29_CLEAR_ENABLE:1;			// 29:29   AP_TIMER_INTR1 Clear Enable
	uint32_t	IRQ30_CLEAR_ENABLE:1;			// 30:30   AP_TIMER_INTR0 Clear Enable
	uint32_t	IRQ31_CLEAR_ENABLE:1;			// 31:31   CRC_FAIL_INT Clear Enable
};

union ICER0_REG {
	uint32_t 		 all;
	struct ICER0_BITS 		 bit;
};

struct ICER1_BITS {			// bits   description
	uint32_t	IRQ32_CLEAR_ENABLE:1;			// 0:0   CRC_DONE_INT Clear Enable
	uint32_t	IRQ33_CLEAR_ENABLE:1;			// 1:1   LC3_INT_REQ Clear Enable
	uint32_t	IRQ34_CLEAR_ENABLE:1;			// 2:2   LC2_INT_REQ Clear Enable
	uint32_t	IRQ35_CLEAR_ENABLE:1;			// 3:3   LC1_INT_REQ Clear Enable
	uint32_t	IRQ36_CLEAR_ENABLE:1;			// 4:4   EQEP2_INT Clear Enable
	uint32_t	IRQ37_CLEAR_ENABLE:1;			// 5:5   EQEP1_INT Clear Enable
	uint32_t	IRQ38_CLEAR_ENABLE:1;			// 6:6   ECAP2_HRCAL_INT Clear Enable
	uint32_t	IRQ39_CLEAR_ENABLE:1;			// 7:7   ECAP1_HRCAL_INT Clear Enable
	uint32_t	IRQ40_CLEAR_ENABLE:1;			// 8:8   ECAP7_INT Clear Enable
	uint32_t	IRQ41_CLEAR_ENABLE:1;			// 9:9   ECAP6_INT Clear Enable
	uint32_t	IRQ42_CLEAR_ENABLE:1;			// 10:10   ECAP5_INT Clear Enable
	uint32_t	IRQ43_CLEAR_ENABLE:1;			// 11:11   ECAP4_INT Clear Enable
	uint32_t	IRQ44_CLEAR_ENABLE:1;			// 12:12   ECAP3_INT Clear Enable
	uint32_t	IRQ45_CLEAR_ENABLE:1;			// 13:13   ECAP2_INT Clear Enable
	uint32_t	IRQ46_CLEAR_ENABLE:1;			// 14:14   ECAP1_INT Clear Enable
	uint32_t	IRQ47_CLEAR_ENABLE:1;			// 15:15   CPU_16XINT Clear Enable
	uint32_t	IRQ48_CLEAR_ENABLE:1;			// 16:16   CPU_15XINT Clear Enable
	uint32_t	IRQ49_CLEAR_ENABLE:1;			// 17:17   CPU_14XINT Clear Enable
	uint32_t	IRQ50_CLEAR_ENABLE:1;			// 18:18   CPU_13XINT Clear Enable
	uint32_t	IRQ51_CLEAR_ENABLE:1;			// 19:19   CPU_12XINT Clear Enable
	uint32_t	IRQ52_CLEAR_ENABLE:1;			// 20:20   CPU_11XINT Clear Enable
	uint32_t	IRQ53_CLEAR_ENABLE:1;			// 21:21   CPU_10XINT Clear Enable
	uint32_t	IRQ54_CLEAR_ENABLE:1;			// 22:22   CPU_9XINT Clear Enable
	uint32_t	IRQ55_CLEAR_ENABLE:1;			// 23:23   CPU_8XINT Clear Enable
	uint32_t	IRQ56_CLEAR_ENABLE:1;			// 24:24   CPU_7XINT Clear Enable
	uint32_t	IRQ57_CLEAR_ENABLE:1;			// 25:25   CPU_6XINT Clear Enable
	uint32_t	IRQ58_CLEAR_ENABLE:1;			// 26:26   CPU_5XINT Clear Enable
	uint32_t	IRQ59_CLEAR_ENABLE:1;			// 27:27   CPU_4XINT Clear Enable
	uint32_t	IRQ60_CLEAR_ENABLE:1;			// 28:28   CPU_3XINT Clear Enable
	uint32_t	IRQ61_CLEAR_ENABLE:1;			// 29:29   CPU_2XINT Clear Enable
	uint32_t	IRQ62_CLEAR_ENABLE:1;			// 30:30   CPU_1XINT Clear Enable
	uint32_t	IRQ63_CLEAR_ENABLE:1;			// 31:31   TZ12_INTERRUPT Clear Enable
};

union ICER1_REG {
	uint32_t 		 all;
	struct ICER1_BITS 		 bit;
};

struct ICER2_BITS {			// bits   description
	uint32_t	IRQ64_CLEAR_ENABLE:1;			// 0:0   TZ11_INTERRUPT Clear Enable
	uint32_t	IRQ65_CLEAR_ENABLE:1;			// 1:1   TZ10_INTERRUPT Clear Enable
	uint32_t	IRQ66_CLEAR_ENABLE:1;			// 2:2   TZ9_INTERRUPT Clear Enable
	uint32_t	IRQ67_CLEAR_ENABLE:1;			// 3:3   TZ8_INTERRUPT Clear Enable
	uint32_t	IRQ68_CLEAR_ENABLE:1;			// 4:4   TZ7_INTERRUPT Clear Enable
	uint32_t	IRQ69_CLEAR_ENABLE:1;			// 5:5   TZ6_INTERRUPT Clear Enable
	uint32_t	IRQ70_CLEAR_ENABLE:1;			// 6:6   TZ5_INTERRUPT Clear Enable
	uint32_t	IRQ71_CLEAR_ENABLE:1;			// 7:7   TZ4_INTERRUPT Clear Enable
	uint32_t	IRQ72_CLEAR_ENABLE:1;			// 8:8   TZ3_INTERRUPT Clear Enable
	uint32_t	IRQ73_CLEAR_ENABLE:1;			// 9:9   TZ2_INTERRUPT Clear Enable
	uint32_t	IRQ74_CLEAR_ENABLE:1;			// 10:10   TZ1_INTERRUPT Clear Enable
	uint32_t	IRQ75_CLEAR_ENABLE:1;			// 11:11   EPWM12XINT Clear Enable
	uint32_t	IRQ76_CLEAR_ENABLE:1;			// 12:12   EPWM11XINT Clear Enable
	uint32_t	IRQ77_CLEAR_ENABLE:1;			// 13:13   EPWM10XINT Clear Enable
	uint32_t	IRQ78_CLEAR_ENABLE:1;			// 14:14   EPWM9XINT Clear Enable
	uint32_t	IRQ79_CLEAR_ENABLE:1;			// 15:15   EPWM8XINT Clear Enable
	uint32_t	IRQ80_CLEAR_ENABLE:1;			// 16:16   EPWM7XINT Clear Enable
	uint32_t	IRQ81_CLEAR_ENABLE:1;			// 17:17   EPWM6XINT Clear Enable
	uint32_t	IRQ82_CLEAR_ENABLE:1;			// 18:18   EPWM5XINT Clear Enable
	uint32_t	IRQ83_CLEAR_ENABLE:1;			// 19:19   EPWM4XINT Clear Enable
	uint32_t	IRQ84_CLEAR_ENABLE:1;			// 20:20   EPWM3XINT Clear Enable
	uint32_t	IRQ85_CLEAR_ENABLE:1;			// 21:21   EPWM2XINT Clear Enable
	uint32_t	IRQ86_CLEAR_ENABLE:1;			// 22:22   EPWM1XINT Clear Enable
	uint32_t	IRQ87_CLEAR_ENABLE:1;			// 23:23   QSPI_INTR Clear Enable
	uint32_t	IRQ88_CLEAR_ENABLE:1;			// 24:24   DMA_INT_CH0_ISTATUSTFR Clear Enable
	uint32_t	IRQ89_CLEAR_ENABLE:1;			// 25:25   DMA_INT_CH1_ISTATUSTFR Clear Enable
	uint32_t	IRQ90_CLEAR_ENABLE:1;			// 26:26   DMA_INT_CH2_ISTATUSTFR Clear Enable
	uint32_t	IRQ91_CLEAR_ENABLE:1;			// 27:27   DMA_INT_CH3_ISTATUSTFR Clear Enable
	uint32_t	IRQ92_CLEAR_ENABLE:1;			// 28:28   DMA_INT_CH4_ISTATUSTFR Clear Enable
	uint32_t	IRQ93_CLEAR_ENABLE:1;			// 29:29   DMA_INT_CH5_ISTATUSTFR Clear Enable
	uint32_t	IRQ94_CLEAR_ENABLE:1;			// 30:30   DMA_INT_CH6_ISTATUSTFR Clear Enable
	uint32_t	IRQ95_CLEAR_ENABLE:1;			// 31:31   DMA_INT_CH7_ISTATUSTFR Clear Enable
};

union ICER2_REG {
	uint32_t 		 all;
	struct ICER2_BITS 		 bit;
};

struct ICER3_BITS {			// bits   description
	uint32_t	IRQ96_CLEAR_ENABLE:1;			// 0:0   DMA_INT_CH0_ISTATUSBLOCK Clear Enable
	uint32_t	IRQ97_CLEAR_ENABLE:1;			// 1:1   DMA_INT_CH1_ISTATUSBLOCK Clear Enable
	uint32_t	IRQ98_CLEAR_ENABLE:1;			// 2:2   DMA_INT_CH2_ISTATUSBLOCK Clear Enable
	uint32_t	IRQ99_CLEAR_ENABLE:1;			// 3:3   DMA_INT_CH3_ISTATUSBLOCK Clear Enable
	uint32_t	IRQ100_CLEAR_ENABLE:1;			// 4:4   DMA_INT_CH4_ISTATUSBLOCK Clear Enable
	uint32_t	IRQ101_CLEAR_ENABLE:1;			// 5:5   DMA_INT_CH5_ISTATUSBLOCK Clear Enable
	uint32_t	IRQ102_CLEAR_ENABLE:1;			// 6:6   DMA_INT_CH6_ISTATUSBLOCK Clear Enable
	uint32_t	IRQ103_CLEAR_ENABLE:1;			// 7:7   DMA_INT_CH7_ISTATUSBLOCK Clear Enable
	uint32_t	IRQ104_CLEAR_ENABLE:1;			// 8:8   DMA_INT_CH0_ISTATUSSRCTRAN Clear Enable
	uint32_t	IRQ105_CLEAR_ENABLE:1;			// 9:9   DMA_INT_CH1_ISTATUSSRCTRAN Clear Enable
	uint32_t	IRQ106_CLEAR_ENABLE:1;			// 10:10   DMA_INT_CH2_ISTATUSSRCTRAN Clear Enable
	uint32_t	IRQ107_CLEAR_ENABLE:1;			// 11:11   DMA_INT_CH3_ISTATUSSRCTRAN Clear Enable
	uint32_t	IRQ108_CLEAR_ENABLE:1;			// 12:12   DMA_INT_CH4_ISTATUSSRCTRAN Clear Enable
	uint32_t	IRQ109_CLEAR_ENABLE:1;			// 13:13   DMA_INT_CH5_ISTATUSSRCTRAN Clear Enable
	uint32_t	IRQ110_CLEAR_ENABLE:1;			// 14:14   DMA_INT_CH6_ISTATUSSRCTRAN Clear Enable
	uint32_t	IRQ111_CLEAR_ENABLE:1;			// 15:15   DMA_INT_CH7_ISTATUSSRCTRAN Clear Enable
	uint32_t	IRQ112_CLEAR_ENABLE:1;			// 16:16   DMA_INT_CH0_ISTATUSDSTTRAN Clear Enable
	uint32_t	IRQ113_CLEAR_ENABLE:1;			// 17:17   DMA_INT_CH1_ISTATUSDSTTRAN Clear Enable
	uint32_t	IRQ114_CLEAR_ENABLE:1;			// 18:18   DMA_INT_CH2_ISTATUSDSTTRAN Clear Enable
	uint32_t	IRQ115_CLEAR_ENABLE:1;			// 19:19   DMA_INT_CH3_ISTATUSDSTTRAN Clear Enable
	uint32_t	IRQ116_CLEAR_ENABLE:1;			// 20:20   DMA_INT_CH4_ISTATUSDSTTRAN Clear Enable
	uint32_t	IRQ117_CLEAR_ENABLE:1;			// 21:21   DMA_INT_CH5_ISTATUSDSTTRAN Clear Enable
	uint32_t	IRQ118_CLEAR_ENABLE:1;			// 22:22   DMA_INT_CH6_ISTATUSDSTTRAN Clear Enable
	uint32_t	IRQ119_CLEAR_ENABLE:1;			// 23:23   DMA_INT_CH7_ISTATUSDSTTRAN Clear Enable
	uint32_t	IRQ120_CLEAR_ENABLE:1;			// 24:24   DMA_INT_CH0_ISTATUSERR Clear Enable
	uint32_t	IRQ121_CLEAR_ENABLE:1;			// 25:25   DMA_INT_CH1_ISTATUSERR Clear Enable
	uint32_t	IRQ122_CLEAR_ENABLE:1;			// 26:26   DMA_INT_CH2_ISTATUSERR Clear Enable
	uint32_t	IRQ123_CLEAR_ENABLE:1;			// 27:27   DMA_INT_CH3_ISTATUSERR Clear Enable
	uint32_t	IRQ124_CLEAR_ENABLE:1;			// 28:28   DMA_INT_CH4_ISTATUSERR Clear Enable
	uint32_t	IRQ125_CLEAR_ENABLE:1;			// 29:29   DMA_INT_CH5_ISTATUSERR Clear Enable
	uint32_t	IRQ126_CLEAR_ENABLE:1;			// 30:30   DMA_INT_CH6_ISTATUSERR Clear Enable
	uint32_t	IRQ127_CLEAR_ENABLE:1;			// 31:31   DMA_INT_CH7_ISTATUSERR Clear Enable
};

union ICER3_REG {
	uint32_t 		 all;
	struct ICER3_BITS 		 bit;
};

struct ICER4_BITS {			// bits   description
	uint32_t	IRQ128_CLEAR_ENABLE:1;			// 0:0   EXTI_INT0 Clear Enable
	uint32_t	IRQ129_CLEAR_ENABLE:1;			// 1:1   EXTI_INT1 Clear Enable
	uint32_t	IRQ130_CLEAR_ENABLE:1;			// 2:2   EXTI_INT2 Clear Enable
	uint32_t	IRQ131_CLEAR_ENABLE:1;			// 3:3   EXTI_INT3 Clear Enable
	uint32_t	IRQ132_CLEAR_ENABLE:1;			// 4:4   EXTI_INT4 Clear Enable
	uint32_t	IRQ133_CLEAR_ENABLE:1;			// 5:5   EXTI_INT5 Clear Enable
	uint32_t	IRQ134_CLEAR_ENABLE:1;			// 6:6   EXTI_INT6 Clear Enable
	uint32_t	IRQ135_CLEAR_ENABLE:1;			// 7:7   EXTI_INT7 Clear Enable
	uint32_t	IRQ136_CLEAR_ENABLE:1;			// 8:8   EXTI_INT8 Clear Enable
	uint32_t	IRQ137_CLEAR_ENABLE:1;			// 9:9   EXTI_INT9 Clear Enable
	uint32_t	IRQ138_CLEAR_ENABLE:1;			// 10:10   EXTI_INT10 Clear Enable
	uint32_t	IRQ139_CLEAR_ENABLE:1;			// 11:11   EXTI_INT11 Clear Enable
	uint32_t	IRQ140_CLEAR_ENABLE:1;			// 12:12   EXTI_INT12 Clear Enable
	uint32_t	IRQ141_CLEAR_ENABLE:1;			// 13:13   EXTI_INT13 Clear Enable
	uint32_t	IRQ142_CLEAR_ENABLE:1;			// 14:14   EXTI_INT14 Clear Enable
	uint32_t	IRQ143_CLEAR_ENABLE:1;			// 15:15   EXTI_INT15 Clear Enable
	uint32_t	IRQ144_CLEAR_ENABLE:1;			// 16:16   EXTI_INT16 Clear Enable
	uint32_t	IRQ145_CLEAR_ENABLE:1;			// 17:17   EXTI_INT17 Clear Enable
	uint32_t	IRQ146_CLEAR_ENABLE:1;			// 18:18   EXTI_INT18 Clear Enable
	uint32_t	IRQ147_CLEAR_ENABLE:1;			// 19:19   EXTI_INT19 Clear Enable
	uint32_t	IRQ148_CLEAR_ENABLE:1;			// 20:20   EXTI_INT20 Clear Enable
	uint32_t	IRQ149_CLEAR_ENABLE:1;			// 21:21   EXTI_INT21 Clear Enable
	uint32_t	IRQ150_CLEAR_ENABLE:1;			// 22:22   EXTI_INT22 Clear Enable
	uint32_t	IRQ151_CLEAR_ENABLE:1;			// 23:23   EXTI_INT23 Clear Enable
	uint32_t	IRQ152_CLEAR_ENABLE:1;			// 24:24   EXTI_INT24 Clear Enable
	uint32_t	IRQ153_CLEAR_ENABLE:1;			// 25:25   EXTI_INT25 Clear Enable
	uint32_t	IRQ154_CLEAR_ENABLE:1;			// 26:26   EXTI_INT26 Clear Enable
	uint32_t	IRQ155_CLEAR_ENABLE:1;			// 27:27   EXTI_INT27 Clear Enable
	uint32_t	IRQ156_CLEAR_ENABLE:1;			// 28:28   EXTI_INT28 Clear Enable
	uint32_t	IRQ157_CLEAR_ENABLE:1;			// 29:29   EXTI_INT29 Clear Enable
	uint32_t	IRQ158_CLEAR_ENABLE:1;			// 30:30   EXTI_INT30 Clear Enable
	uint32_t	IRQ159_CLEAR_ENABLE:1;			// 31:31   EXTI_INT31 Clear Enable
};

union ICER4_REG {
	uint32_t 		 all;
	struct ICER4_BITS 		 bit;
};

struct ICER5_BITS {			// bits   description
	uint32_t	IRQ160_CLEAR_ENABLE:1;			// 0:0   AP_SYSCTL_FPUSTA Clear Enable
	uint32_t	IRQ161_CLEAR_ENABLE:1;			// 1:1   AP_SYSCTL_FPUSTA Clear Enable
	uint32_t	IRQ162_CLEAR_ENABLE:1;			// 2:2   AP_SYSCTL_FPUSTA Clear Enable
	uint32_t	IRQ163_CLEAR_ENABLE:1;			// 3:3   AP_SYSCTL_FPUSTA Clear Enable
	uint32_t	IRQ164_CLEAR_ENABLE:1;			// 4:4   AP_SYSCTL_FPUSTA Clear Enable
	uint32_t	IRQ165_CLEAR_ENABLE:1;			// 5:5   AP_SYSCTL_FPUSTA Clear Enable
	uint32_t	IRQ166_CLEAR_ENABLE:1;			// 6:6   FP_NV_INT Clear Enable
	uint32_t	IRQ167_CLEAR_ENABLE:1;			// 7:7   FP_DZ_INT Clear Enable
	uint32_t	IRQ168_CLEAR_ENABLE:1;			// 8:8   FP_OF_INT Clear Enable
	uint32_t	IRQ169_CLEAR_ENABLE:1;			// 9:9   FP_UF_INT Clear Enable
	uint32_t	IRQ170_CLEAR_ENABLE:1;			// 10:10   AP_WDT_INTR Clear Enable
	uint32_t	IRQ171_CLEAR_ENABLE:1;			// 11:11   ADCC_EVT_INT Clear Enable
	uint32_t	IRQ172_CLEAR_ENABLE:1;			// 12:12   ADCB_EVT_INT Clear Enable
	uint32_t	IRQ173_CLEAR_ENABLE:1;			// 13:13   ADCA_EVT_INT Clear Enable
	uint32_t	IRQ174_CLEAR_ENABLE:1;			// 14:14   ADCC_4INT Clear Enable
	uint32_t	IRQ175_CLEAR_ENABLE:1;			// 15:15   ADCC_3INT Clear Enable
	uint32_t	IRQ176_CLEAR_ENABLE:1;			// 16:16   ADCC_2INT Clear Enable
	uint32_t	IRQ177_CLEAR_ENABLE:1;			// 17:17   ADCC_1INT Clear Enable
	uint32_t	IRQ178_CLEAR_ENABLE:1;			// 18:18   ADCB_4INT Clear Enable
	uint32_t	IRQ179_CLEAR_ENABLE:1;			// 19:19   ADCB_3INT Clear Enable
	uint32_t	IRQ180_CLEAR_ENABLE:1;			// 20:20   ADCB_2INT Clear Enable
	uint32_t	IRQ181_CLEAR_ENABLE:1;			// 21:21   ADCB_1INT Clear Enable
	uint32_t	IRQ182_CLEAR_ENABLE:1;			// 22:22   ADCA_4INT Clear Enable
	uint32_t	IRQ183_CLEAR_ENABLE:1;			// 23:23   ADCA_3INT Clear Enable
	uint32_t	IRQ184_CLEAR_ENABLE:1;			// 24:24   ADCA_2INT Clear Enable
	uint32_t	IRQ185_CLEAR_ENABLE:1;			// 25:25   ADCA_1INT Clear Enable
	uint32_t	IRQ186_CLEAR_ENABLE:1;			// 26:26   DSP_EVT_O Clear Enable
	uint32_t	IRQ187_CLEAR_ENABLE:1;			// 27:27   DSP_TASK_INT0 Clear Enable
	uint32_t	IRQ188_CLEAR_ENABLE:1;			// 28:28   DSP_TASK_INT1 Clear Enable
	uint32_t	IRQ189_CLEAR_ENABLE:1;			// 29:29   DSP_TASK_INT2 Clear Enable
	uint32_t	IRQ190_CLEAR_ENABLE:1;			// 30:30   DSP_TASK_INT3 Clear Enable
	uint32_t	IRQ191_CLEAR_ENABLE:1;			// 31:31   DSP_TASK_INT4 Clear Enable
};

union ICER5_REG {
	uint32_t 		 all;
	struct ICER5_BITS 		 bit;
};

struct ICER6_BITS {			// bits   description
	uint32_t	IRQ192_CLEAR_ENABLE:1;			// 0:0   DSP_TASK_INT5 Clear Enable
	uint32_t	IRQ193_CLEAR_ENABLE:1;			// 1:1   DSP_TASK_INT6 Clear Enable
	uint32_t	IRQ194_CLEAR_ENABLE:1;			// 2:2   DSP_TASK_INT7 Clear Enable
	uint32_t	IRQ195_CLEAR_ENABLE:1;			// 3:3   DSP_TASK_INT8 Clear Enable
	uint32_t	IRQ196_CLEAR_ENABLE:1;			// 4:4   DSP_TASK_INT9 Clear Enable
	uint32_t	IRQ197_CLEAR_ENABLE:1;			// 5:5   DSP_TASK_INT10 Clear Enable
	uint32_t	IRQ198_CLEAR_ENABLE:1;			// 6:6   DSP_TASK_INT11 Clear Enable
	uint32_t	IRQ199_CLEAR_ENABLE:1;			// 7:7   DSP_TASK_INT12 Clear Enable
	uint32_t	IRQ200_CLEAR_ENABLE:1;			// 8:8   DSP_TASK_INT13 Clear Enable
	uint32_t	IRQ201_CLEAR_ENABLE:1;			// 9:9   DSP_TASK_INT14 Clear Enable
	uint32_t	IRQ202_CLEAR_ENABLE:1;			// 10:10   DSP_TASK_INT15 Clear Enable
	uint32_t	IRQ203_CLEAR_ENABLE:1;			// 11:11   DSP_TASK_INT16 Clear Enable
	uint32_t	IRQ204_CLEAR_ENABLE:1;			// 12:12   DSP_TASK_INT17 Clear Enable
	uint32_t	IRQ205_CLEAR_ENABLE:1;			// 13:13   DSP_TASK_INT18 Clear Enable
	uint32_t	IRQ206_CLEAR_ENABLE:1;			// 14:14   DSP_TASK_INT19 Clear Enable
	uint32_t	IRQ207_CLEAR_ENABLE:1;			// 15:15   DSP_TASK_INT20 Clear Enable
	uint32_t	IRQ208_CLEAR_ENABLE:1;			// 16:16   DSP_TASK_INT21 Clear Enable
	uint32_t	IRQ209_CLEAR_ENABLE:1;			// 17:17   DSP_TASK_INT22 Clear Enable
	uint32_t	IRQ210_CLEAR_ENABLE:1;			// 18:18   DSP_TASK_INT23 Clear Enable
	uint32_t	IRQ211_CLEAR_ENABLE:1;			// 19:19   DSP_TASK_INT24 Clear Enable
	uint32_t	IRQ212_CLEAR_ENABLE:1;			// 20:20   DSP_TASK_INT25 Clear Enable
	uint32_t	IRQ213_CLEAR_ENABLE:1;			// 21:21   DSP_TASK_INT26 Clear Enable
	uint32_t	IRQ214_CLEAR_ENABLE:1;			// 22:22   DSP_TASK_INT27 Clear Enable
	uint32_t	IRQ215_CLEAR_ENABLE:1;			// 23:23   DSP_TASK_INT28 Clear Enable
	uint32_t	IRQ216_CLEAR_ENABLE:1;			// 24:24   DSP_TASK_INT29 Clear Enable
	uint32_t	IRQ217_CLEAR_ENABLE:1;			// 25:25   DSP_TASK_INT30 Clear Enable
	uint32_t	IRQ218_CLEAR_ENABLE:1;			// 26:26   DSP_TASK_INT31 Clear Enable
	uint32_t	IRQ219_CLEAR_ENABLE:1;			// 27:27   DLM_ECC_SBERR Clear Enable
	uint32_t	IRQ220_CLEAR_ENABLE:1;			// 28:28   ILM_ECC_SBERR Clear Enable
	uint32_t	IRQ221_CLEAR_ENABLE:1;			// 29:29   |GS_RAM_RD_ERR Clear Enable
	uint32_t	IRQ222_CLEAR_ENABLE:1;			// 30:30   |CCM_RAM_RD_ERR Clear Enable
	uint32_t	IRQ223_CLEAR_ENABLE:1;			// 31:31   EFC_SEC_INTR Clear Enable
};

union ICER6_REG {
	uint32_t 		 all;
	struct ICER6_BITS 		 bit;
};

struct ICER7_BITS {			// bits   description
	uint32_t	IRQ224_CLEAR_ENABLE:1;			// 0:0   EFC_DONE_INTR Clear Enable
	uint32_t	IRQ225_CLEAR_ENABLE:1;			// 1:1   EFC_INTR Clear Enable
	uint32_t	IRQ226_CLEAR_ENABLE:1;			// 2:2   IBUS_IRQ Clear Enable
	uint32_t	IRQ227_CLEAR_ENABLE:1;			// 3:3   DBUS_IRQ Clear Enable
	uint32_t	IRQ228_CLEAR_ENABLE:1;			// 4:4   RTOSINT2 Clear Enable
	uint32_t	IRQ229_CLEAR_ENABLE:1;			// 5:5   RTOSINT1 Clear Enable
	uint32_t	IRQ230_CLEAR_ENABLE:1;			// 6:6   LSE_CLOCK_FAIL_INT Clear Enable
	uint32_t	IRQ231_CLEAR_ENABLE:1;			// 7:7   ~PLL_LOCK Clear Enable
	uint32_t	IRQ232_CLEAR_ENABLE:1;			// 8:8   PMBUS_ALERT Clear Enable
	uint32_t	IRQ233_CLEAR_ENABLE:1;			// 9:9   DSP_EXCP_INT0TRACE_EXCP0 Clear Enable
	uint32_t	IRQ234_CLEAR_ENABLE:1;			// 10:10   DSP_EXCP_INT1TRACE_EXCP1 Clear Enable
	uint32_t	IRQ235_CLEAR_ENABLE:1;			// 11:11   DSP_EXCP_INT2TRACE_EXCP2 Clear Enable
	uint32_t	IRQ236_CLEAR_ENABLE:1;			// 12:12   DSP_EXCP_INT3TRACE_EXCP3 Clear Enable
	uint32_t	IRQ237_CLEAR_ENABLE:1;			// 13:13   DSP_EXCP_INT4TRACE_EXCP4|TRACE_EXCP6 Clear Enable
	uint32_t	IRQ238_CLEAR_ENABLE:1;			// 14:14   DSP_EXCP_INT5TRACE_EXCP5|7|13|15 Clear Enable
	uint32_t	IRQ239_CLEAR_ENABLE:1;			// 15:15   DSP_EXCP_INT6TRACE_EXCP11 Clear Enable
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union ICER7_REG {
	uint32_t 		 all;
	struct ICER7_BITS 		 bit;
};

struct ISPR0_BITS {			// bits   description
	uint32_t	IRQ0_SET_PENDING:1;			// 0:0   CAN1_HOST_IRQ Set Pending
	uint32_t	IRQ1_SET_PENDING:1;			// 1:1   CAN0_HOST_IRQ Set Pending
	uint32_t	IRQ2_SET_PENDING:1;			// 2:2   SPI1_INTR Set Pending
	uint32_t	IRQ3_SET_PENDING:1;			// 3:3   SPI0_INTR Set Pending
	uint32_t	rsvd1:2;			// 5:4   reserved
	uint32_t	IRQ6_SET_PENDING:1;			// 6:6   SCIB_INTR Set Pending
	uint32_t	IRQ7_SET_PENDING:1;			// 7:7   SCIA_INTR Set Pending
	uint32_t	IRQ8_SET_PENDING:1;			// 8:8   I2C2_INTR Set Pending
	uint32_t	IRQ9_SET_PENDING:1;			// 9:9   I2C1_INTR Set Pending
	uint32_t	IRQ10_SET_PENDING:1;			// 10:10   I2C0_INTR Set Pending
	uint32_t	rsvd2:12;			// 22:11   reserved
	uint32_t	IRQ23_SET_PENDING:1;			// 23:23   APB_GPIO3_CMBINTR Set Pending
	uint32_t	IRQ24_SET_PENDING:1;			// 24:24   APB_GPIO2_CMBINTR Set Pending
	uint32_t	IRQ25_SET_PENDING:1;			// 25:25   APB_GPIO1_CMBINTR Set Pending
	uint32_t	IRQ26_SET_PENDING:1;			// 26:26   APB_GPIO0_CMBINTR Set Pending
	uint32_t	IRQ27_SET_PENDING:1;			// 27:27   AP_TIMER_INTR3 Set Pending
	uint32_t	IRQ28_SET_PENDING:1;			// 28:28   AP_TIMER_INTR2 Set Pending
	uint32_t	IRQ29_SET_PENDING:1;			// 29:29   AP_TIMER_INTR1 Set Pending
	uint32_t	IRQ30_SET_PENDING:1;			// 30:30   AP_TIMER_INTR0 Set Pending
	uint32_t	IRQ31_SET_PENDING:1;			// 31:31   CRC_FAIL_INT Set Pending
};

union ISPR0_REG {
	uint32_t 		 all;
	struct ISPR0_BITS 		 bit;
};

struct ISPR1_BITS {			// bits   description
	uint32_t	IRQ32_SET_PENDING:1;			// 0:0   CRC_DONE_INT Set Pending
	uint32_t	IRQ33_SET_PENDING:1;			// 1:1   LC3_INT_REQ Set Pending
	uint32_t	IRQ34_SET_PENDING:1;			// 2:2   LC2_INT_REQ Set Pending
	uint32_t	IRQ35_SET_PENDING:1;			// 3:3   LC1_INT_REQ Set Pending
	uint32_t	IRQ36_SET_PENDING:1;			// 4:4   EQEP2_INT Set Pending
	uint32_t	IRQ37_SET_PENDING:1;			// 5:5   EQEP1_INT Set Pending
	uint32_t	IRQ38_SET_PENDING:1;			// 6:6   ECAP2_HRCAL_INT Set Pending
	uint32_t	IRQ39_SET_PENDING:1;			// 7:7   ECAP1_HRCAL_INT Set Pending
	uint32_t	IRQ40_SET_PENDING:1;			// 8:8   ECAP7_INT Set Pending
	uint32_t	IRQ41_SET_PENDING:1;			// 9:9   ECAP6_INT Set Pending
	uint32_t	IRQ42_SET_PENDING:1;			// 10:10   ECAP5_INT Set Pending
	uint32_t	IRQ43_SET_PENDING:1;			// 11:11   ECAP4_INT Set Pending
	uint32_t	IRQ44_SET_PENDING:1;			// 12:12   ECAP3_INT Set Pending
	uint32_t	IRQ45_SET_PENDING:1;			// 13:13   ECAP2_INT Set Pending
	uint32_t	IRQ46_SET_PENDING:1;			// 14:14   ECAP1_INT Set Pending
	uint32_t	IRQ47_SET_PENDING:1;			// 15:15   CPU_16XINT Set Pending
	uint32_t	IRQ48_SET_PENDING:1;			// 16:16   CPU_15XINT Set Pending
	uint32_t	IRQ49_SET_PENDING:1;			// 17:17   CPU_14XINT Set Pending
	uint32_t	IRQ50_SET_PENDING:1;			// 18:18   CPU_13XINT Set Pending
	uint32_t	IRQ51_SET_PENDING:1;			// 19:19   CPU_12XINT Set Pending
	uint32_t	IRQ52_SET_PENDING:1;			// 20:20   CPU_11XINT Set Pending
	uint32_t	IRQ53_SET_PENDING:1;			// 21:21   CPU_10XINT Set Pending
	uint32_t	IRQ54_SET_PENDING:1;			// 22:22   CPU_9XINT Set Pending
	uint32_t	IRQ55_SET_PENDING:1;			// 23:23   CPU_8XINT Set Pending
	uint32_t	IRQ56_SET_PENDING:1;			// 24:24   CPU_7XINT Set Pending
	uint32_t	IRQ57_SET_PENDING:1;			// 25:25   CPU_6XINT Set Pending
	uint32_t	IRQ58_SET_PENDING:1;			// 26:26   CPU_5XINT Set Pending
	uint32_t	IRQ59_SET_PENDING:1;			// 27:27   CPU_4XINT Set Pending
	uint32_t	IRQ60_SET_PENDING:1;			// 28:28   CPU_3XINT Set Pending
	uint32_t	IRQ61_SET_PENDING:1;			// 29:29   CPU_2XINT Set Pending
	uint32_t	IRQ62_SET_PENDING:1;			// 30:30   CPU_1XINT Set Pending
	uint32_t	IRQ63_SET_PENDING:1;			// 31:31   TZ12_INTERRUPT Set Pending
};

union ISPR1_REG {
	uint32_t 		 all;
	struct ISPR1_BITS 		 bit;
};

struct ISPR2_BITS {			// bits   description
	uint32_t	IRQ64_SET_PENDING:1;			// 0:0   TZ11_INTERRUPT Set Pending
	uint32_t	IRQ65_SET_PENDING:1;			// 1:1   TZ10_INTERRUPT Set Pending
	uint32_t	IRQ66_SET_PENDING:1;			// 2:2   TZ9_INTERRUPT Set Pending
	uint32_t	IRQ67_SET_PENDING:1;			// 3:3   TZ8_INTERRUPT Set Pending
	uint32_t	IRQ68_SET_PENDING:1;			// 4:4   TZ7_INTERRUPT Set Pending
	uint32_t	IRQ69_SET_PENDING:1;			// 5:5   TZ6_INTERRUPT Set Pending
	uint32_t	IRQ70_SET_PENDING:1;			// 6:6   TZ5_INTERRUPT Set Pending
	uint32_t	IRQ71_SET_PENDING:1;			// 7:7   TZ4_INTERRUPT Set Pending
	uint32_t	IRQ72_SET_PENDING:1;			// 8:8   TZ3_INTERRUPT Set Pending
	uint32_t	IRQ73_SET_PENDING:1;			// 9:9   TZ2_INTERRUPT Set Pending
	uint32_t	IRQ74_SET_PENDING:1;			// 10:10   TZ1_INTERRUPT Set Pending
	uint32_t	IRQ75_SET_PENDING:1;			// 11:11   EPWM12XINT Set Pending
	uint32_t	IRQ76_SET_PENDING:1;			// 12:12   EPWM11XINT Set Pending
	uint32_t	IRQ77_SET_PENDING:1;			// 13:13   EPWM10XINT Set Pending
	uint32_t	IRQ78_SET_PENDING:1;			// 14:14   EPWM9XINT Set Pending
	uint32_t	IRQ79_SET_PENDING:1;			// 15:15   EPWM8XINT Set Pending
	uint32_t	IRQ80_SET_PENDING:1;			// 16:16   EPWM7XINT Set Pending
	uint32_t	IRQ81_SET_PENDING:1;			// 17:17   EPWM6XINT Set Pending
	uint32_t	IRQ82_SET_PENDING:1;			// 18:18   EPWM5XINT Set Pending
	uint32_t	IRQ83_SET_PENDING:1;			// 19:19   EPWM4XINT Set Pending
	uint32_t	IRQ84_SET_PENDING:1;			// 20:20   EPWM3XINT Set Pending
	uint32_t	IRQ85_SET_PENDING:1;			// 21:21   EPWM2XINT Set Pending
	uint32_t	IRQ86_SET_PENDING:1;			// 22:22   EPWM1XINT Set Pending
	uint32_t	IRQ87_SET_PENDING:1;			// 23:23   QSPI_INTR Set Pending
	uint32_t	IRQ88_SET_PENDING:1;			// 24:24   DMA_INT_CH0_ISTATUSTFR Set Pending
	uint32_t	IRQ89_SET_PENDING:1;			// 25:25   DMA_INT_CH1_ISTATUSTFR Set Pending
	uint32_t	IRQ90_SET_PENDING:1;			// 26:26   DMA_INT_CH2_ISTATUSTFR Set Pending
	uint32_t	IRQ91_SET_PENDING:1;			// 27:27   DMA_INT_CH3_ISTATUSTFR Set Pending
	uint32_t	IRQ92_SET_PENDING:1;			// 28:28   DMA_INT_CH4_ISTATUSTFR Set Pending
	uint32_t	IRQ93_SET_PENDING:1;			// 29:29   DMA_INT_CH5_ISTATUSTFR Set Pending
	uint32_t	IRQ94_SET_PENDING:1;			// 30:30   DMA_INT_CH6_ISTATUSTFR Set Pending
	uint32_t	IRQ95_SET_PENDING:1;			// 31:31   DMA_INT_CH7_ISTATUSTFR Set Pending
};

union ISPR2_REG {
	uint32_t 		 all;
	struct ISPR2_BITS 		 bit;
};

struct ISPR3_BITS {			// bits   description
	uint32_t	IRQ96_SET_PENDING:1;			// 0:0   DMA_INT_CH0_ISTATUSBLOCK Set Pending
	uint32_t	IRQ97_SET_PENDING:1;			// 1:1   DMA_INT_CH1_ISTATUSBLOCK Set Pending
	uint32_t	IRQ98_SET_PENDING:1;			// 2:2   DMA_INT_CH2_ISTATUSBLOCK Set Pending
	uint32_t	IRQ99_SET_PENDING:1;			// 3:3   DMA_INT_CH3_ISTATUSBLOCK Set Pending
	uint32_t	IRQ100_SET_PENDING:1;			// 4:4   DMA_INT_CH4_ISTATUSBLOCK Set Pending
	uint32_t	IRQ101_SET_PENDING:1;			// 5:5   DMA_INT_CH5_ISTATUSBLOCK Set Pending
	uint32_t	IRQ102_SET_PENDING:1;			// 6:6   DMA_INT_CH6_ISTATUSBLOCK Set Pending
	uint32_t	IRQ103_SET_PENDING:1;			// 7:7   DMA_INT_CH7_ISTATUSBLOCK Set Pending
	uint32_t	IRQ104_SET_PENDING:1;			// 8:8   DMA_INT_CH0_ISTATUSSRCTRAN Set Pending
	uint32_t	IRQ105_SET_PENDING:1;			// 9:9   DMA_INT_CH1_ISTATUSSRCTRAN Set Pending
	uint32_t	IRQ106_SET_PENDING:1;			// 10:10   DMA_INT_CH2_ISTATUSSRCTRAN Set Pending
	uint32_t	IRQ107_SET_PENDING:1;			// 11:11   DMA_INT_CH3_ISTATUSSRCTRAN Set Pending
	uint32_t	IRQ108_SET_PENDING:1;			// 12:12   DMA_INT_CH4_ISTATUSSRCTRAN Set Pending
	uint32_t	IRQ109_SET_PENDING:1;			// 13:13   DMA_INT_CH5_ISTATUSSRCTRAN Set Pending
	uint32_t	IRQ110_SET_PENDING:1;			// 14:14   DMA_INT_CH6_ISTATUSSRCTRAN Set Pending
	uint32_t	IRQ111_SET_PENDING:1;			// 15:15   DMA_INT_CH7_ISTATUSSRCTRAN Set Pending
	uint32_t	IRQ112_SET_PENDING:1;			// 16:16   DMA_INT_CH0_ISTATUSDSTTRAN Set Pending
	uint32_t	IRQ113_SET_PENDING:1;			// 17:17   DMA_INT_CH1_ISTATUSDSTTRAN Set Pending
	uint32_t	IRQ114_SET_PENDING:1;			// 18:18   DMA_INT_CH2_ISTATUSDSTTRAN Set Pending
	uint32_t	IRQ115_SET_PENDING:1;			// 19:19   DMA_INT_CH3_ISTATUSDSTTRAN Set Pending
	uint32_t	IRQ116_SET_PENDING:1;			// 20:20   DMA_INT_CH4_ISTATUSDSTTRAN Set Pending
	uint32_t	IRQ117_SET_PENDING:1;			// 21:21   DMA_INT_CH5_ISTATUSDSTTRAN Set Pending
	uint32_t	IRQ118_SET_PENDING:1;			// 22:22   DMA_INT_CH6_ISTATUSDSTTRAN Set Pending
	uint32_t	IRQ119_SET_PENDING:1;			// 23:23   DMA_INT_CH7_ISTATUSDSTTRAN Set Pending
	uint32_t	IRQ120_SET_PENDING:1;			// 24:24   DMA_INT_CH0_ISTATUSERR Set Pending
	uint32_t	IRQ121_SET_PENDING:1;			// 25:25   DMA_INT_CH1_ISTATUSERR Set Pending
	uint32_t	IRQ122_SET_PENDING:1;			// 26:26   DMA_INT_CH2_ISTATUSERR Set Pending
	uint32_t	IRQ123_SET_PENDING:1;			// 27:27   DMA_INT_CH3_ISTATUSERR Set Pending
	uint32_t	IRQ124_SET_PENDING:1;			// 28:28   DMA_INT_CH4_ISTATUSERR Set Pending
	uint32_t	IRQ125_SET_PENDING:1;			// 29:29   DMA_INT_CH5_ISTATUSERR Set Pending
	uint32_t	IRQ126_SET_PENDING:1;			// 30:30   DMA_INT_CH6_ISTATUSERR Set Pending
	uint32_t	IRQ127_SET_PENDING:1;			// 31:31   DMA_INT_CH7_ISTATUSERR Set Pending
};

union ISPR3_REG {
	uint32_t 		 all;
	struct ISPR3_BITS 		 bit;
};

struct ISPR4_BITS {			// bits   description
	uint32_t	IRQ128_SET_PENDING:1;			// 0:0   EXTI_INT0 Set Pending
	uint32_t	IRQ129_SET_PENDING:1;			// 1:1   EXTI_INT1 Set Pending
	uint32_t	IRQ130_SET_PENDING:1;			// 2:2   EXTI_INT2 Set Pending
	uint32_t	IRQ131_SET_PENDING:1;			// 3:3   EXTI_INT3 Set Pending
	uint32_t	IRQ132_SET_PENDING:1;			// 4:4   EXTI_INT4 Set Pending
	uint32_t	IRQ133_SET_PENDING:1;			// 5:5   EXTI_INT5 Set Pending
	uint32_t	IRQ134_SET_PENDING:1;			// 6:6   EXTI_INT6 Set Pending
	uint32_t	IRQ135_SET_PENDING:1;			// 7:7   EXTI_INT7 Set Pending
	uint32_t	IRQ136_SET_PENDING:1;			// 8:8   EXTI_INT8 Set Pending
	uint32_t	IRQ137_SET_PENDING:1;			// 9:9   EXTI_INT9 Set Pending
	uint32_t	IRQ138_SET_PENDING:1;			// 10:10   EXTI_INT10 Set Pending
	uint32_t	IRQ139_SET_PENDING:1;			// 11:11   EXTI_INT11 Set Pending
	uint32_t	IRQ140_SET_PENDING:1;			// 12:12   EXTI_INT12 Set Pending
	uint32_t	IRQ141_SET_PENDING:1;			// 13:13   EXTI_INT13 Set Pending
	uint32_t	IRQ142_SET_PENDING:1;			// 14:14   EXTI_INT14 Set Pending
	uint32_t	IRQ143_SET_PENDING:1;			// 15:15   EXTI_INT15 Set Pending
	uint32_t	IRQ144_SET_PENDING:1;			// 16:16   EXTI_INT16 Set Pending
	uint32_t	IRQ145_SET_PENDING:1;			// 17:17   EXTI_INT17 Set Pending
	uint32_t	IRQ146_SET_PENDING:1;			// 18:18   EXTI_INT18 Set Pending
	uint32_t	IRQ147_SET_PENDING:1;			// 19:19   EXTI_INT19 Set Pending
	uint32_t	IRQ148_SET_PENDING:1;			// 20:20   EXTI_INT20 Set Pending
	uint32_t	IRQ149_SET_PENDING:1;			// 21:21   EXTI_INT21 Set Pending
	uint32_t	IRQ150_SET_PENDING:1;			// 22:22   EXTI_INT22 Set Pending
	uint32_t	IRQ151_SET_PENDING:1;			// 23:23   EXTI_INT23 Set Pending
	uint32_t	IRQ152_SET_PENDING:1;			// 24:24   EXTI_INT24 Set Pending
	uint32_t	IRQ153_SET_PENDING:1;			// 25:25   EXTI_INT25 Set Pending
	uint32_t	IRQ154_SET_PENDING:1;			// 26:26   EXTI_INT26 Set Pending
	uint32_t	IRQ155_SET_PENDING:1;			// 27:27   EXTI_INT27 Set Pending
	uint32_t	IRQ156_SET_PENDING:1;			// 28:28   EXTI_INT28 Set Pending
	uint32_t	IRQ157_SET_PENDING:1;			// 29:29   EXTI_INT29 Set Pending
	uint32_t	IRQ158_SET_PENDING:1;			// 30:30   EXTI_INT30 Set Pending
	uint32_t	IRQ159_SET_PENDING:1;			// 31:31   EXTI_INT31 Set Pending
};

union ISPR4_REG {
	uint32_t 		 all;
	struct ISPR4_BITS 		 bit;
};

struct ISPR5_BITS {			// bits   description
	uint32_t	IRQ160_SET_PENDING:1;			// 0:0   AP_SYSCTL_FPUSTA Set Pending
	uint32_t	IRQ161_SET_PENDING:1;			// 1:1   AP_SYSCTL_FPUSTA Set Pending
	uint32_t	IRQ162_SET_PENDING:1;			// 2:2   AP_SYSCTL_FPUSTA Set Pending
	uint32_t	IRQ163_SET_PENDING:1;			// 3:3   AP_SYSCTL_FPUSTA Set Pending
	uint32_t	IRQ164_SET_PENDING:1;			// 4:4   AP_SYSCTL_FPUSTA Set Pending
	uint32_t	IRQ165_SET_PENDING:1;			// 5:5   AP_SYSCTL_FPUSTA Set Pending
	uint32_t	IRQ166_SET_PENDING:1;			// 6:6   FP_NV_INT Set Pending
	uint32_t	IRQ167_SET_PENDING:1;			// 7:7   FP_DZ_INT Set Pending
	uint32_t	IRQ168_SET_PENDING:1;			// 8:8   FP_OF_INT Set Pending
	uint32_t	IRQ169_SET_PENDING:1;			// 9:9   FP_UF_INT Set Pending
	uint32_t	IRQ170_SET_PENDING:1;			// 10:10   AP_WDT_INTR Set Pending
	uint32_t	IRQ171_SET_PENDING:1;			// 11:11   ADCC_EVT_INT Set Pending
	uint32_t	IRQ172_SET_PENDING:1;			// 12:12   ADCB_EVT_INT Set Pending
	uint32_t	IRQ173_SET_PENDING:1;			// 13:13   ADCA_EVT_INT Set Pending
	uint32_t	IRQ174_SET_PENDING:1;			// 14:14   ADCC_4INT Set Pending
	uint32_t	IRQ175_SET_PENDING:1;			// 15:15   ADCC_3INT Set Pending
	uint32_t	IRQ176_SET_PENDING:1;			// 16:16   ADCC_2INT Set Pending
	uint32_t	IRQ177_SET_PENDING:1;			// 17:17   ADCC_1INT Set Pending
	uint32_t	IRQ178_SET_PENDING:1;			// 18:18   ADCB_4INT Set Pending
	uint32_t	IRQ179_SET_PENDING:1;			// 19:19   ADCB_3INT Set Pending
	uint32_t	IRQ180_SET_PENDING:1;			// 20:20   ADCB_2INT Set Pending
	uint32_t	IRQ181_SET_PENDING:1;			// 21:21   ADCB_1INT Set Pending
	uint32_t	IRQ182_SET_PENDING:1;			// 22:22   ADCA_4INT Set Pending
	uint32_t	IRQ183_SET_PENDING:1;			// 23:23   ADCA_3INT Set Pending
	uint32_t	IRQ184_SET_PENDING:1;			// 24:24   ADCA_2INT Set Pending
	uint32_t	IRQ185_SET_PENDING:1;			// 25:25   ADCA_1INT Set Pending
	uint32_t	IRQ186_SET_PENDING:1;			// 26:26   DSP_EVT_O Set Pending
	uint32_t	IRQ187_SET_PENDING:1;			// 27:27   DSP_TASK_INT0 Set Pending
	uint32_t	IRQ188_SET_PENDING:1;			// 28:28   DSP_TASK_INT1 Set Pending
	uint32_t	IRQ189_SET_PENDING:1;			// 29:29   DSP_TASK_INT2 Set Pending
	uint32_t	IRQ190_SET_PENDING:1;			// 30:30   DSP_TASK_INT3 Set Pending
	uint32_t	IRQ191_SET_PENDING:1;			// 31:31   DSP_TASK_INT4 Set Pending
};

union ISPR5_REG {
	uint32_t 		 all;
	struct ISPR5_BITS 		 bit;
};

struct ISPR6_BITS {			// bits   description
	uint32_t	IRQ192_SET_PENDING:1;			// 0:0   DSP_TASK_INT5 Set Pending
	uint32_t	IRQ193_SET_PENDING:1;			// 1:1   DSP_TASK_INT6 Set Pending
	uint32_t	IRQ194_SET_PENDING:1;			// 2:2   DSP_TASK_INT7 Set Pending
	uint32_t	IRQ195_SET_PENDING:1;			// 3:3   DSP_TASK_INT8 Set Pending
	uint32_t	IRQ196_SET_PENDING:1;			// 4:4   DSP_TASK_INT9 Set Pending
	uint32_t	IRQ197_SET_PENDING:1;			// 5:5   DSP_TASK_INT10 Set Pending
	uint32_t	IRQ198_SET_PENDING:1;			// 6:6   DSP_TASK_INT11 Set Pending
	uint32_t	IRQ199_SET_PENDING:1;			// 7:7   DSP_TASK_INT12 Set Pending
	uint32_t	IRQ200_SET_PENDING:1;			// 8:8   DSP_TASK_INT13 Set Pending
	uint32_t	IRQ201_SET_PENDING:1;			// 9:9   DSP_TASK_INT14 Set Pending
	uint32_t	IRQ202_SET_PENDING:1;			// 10:10   DSP_TASK_INT15 Set Pending
	uint32_t	IRQ203_SET_PENDING:1;			// 11:11   DSP_TASK_INT16 Set Pending
	uint32_t	IRQ204_SET_PENDING:1;			// 12:12   DSP_TASK_INT17 Set Pending
	uint32_t	IRQ205_SET_PENDING:1;			// 13:13   DSP_TASK_INT18 Set Pending
	uint32_t	IRQ206_SET_PENDING:1;			// 14:14   DSP_TASK_INT19 Set Pending
	uint32_t	IRQ207_SET_PENDING:1;			// 15:15   DSP_TASK_INT20 Set Pending
	uint32_t	IRQ208_SET_PENDING:1;			// 16:16   DSP_TASK_INT21 Set Pending
	uint32_t	IRQ209_SET_PENDING:1;			// 17:17   DSP_TASK_INT22 Set Pending
	uint32_t	IRQ210_SET_PENDING:1;			// 18:18   DSP_TASK_INT23 Set Pending
	uint32_t	IRQ211_SET_PENDING:1;			// 19:19   DSP_TASK_INT24 Set Pending
	uint32_t	IRQ212_SET_PENDING:1;			// 20:20   DSP_TASK_INT25 Set Pending
	uint32_t	IRQ213_SET_PENDING:1;			// 21:21   DSP_TASK_INT26 Set Pending
	uint32_t	IRQ214_SET_PENDING:1;			// 22:22   DSP_TASK_INT27 Set Pending
	uint32_t	IRQ215_SET_PENDING:1;			// 23:23   DSP_TASK_INT28 Set Pending
	uint32_t	IRQ216_SET_PENDING:1;			// 24:24   DSP_TASK_INT29 Set Pending
	uint32_t	IRQ217_SET_PENDING:1;			// 25:25   DSP_TASK_INT30 Set Pending
	uint32_t	IRQ218_SET_PENDING:1;			// 26:26   DSP_TASK_INT31 Set Pending
	uint32_t	IRQ219_SET_PENDING:1;			// 27:27   DLM_ECC_SBERR Set Pending
	uint32_t	IRQ220_SET_PENDING:1;			// 28:28   ILM_ECC_SBERR Set Pending
	uint32_t	IRQ221_SET_PENDING:1;			// 29:29   |GS_RAM_RD_ERR Set Pending
	uint32_t	IRQ222_SET_PENDING:1;			// 30:30   |CCM_RAM_RD_ERR Set Pending
	uint32_t	IRQ223_SET_PENDING:1;			// 31:31   EFC_SEC_INTR Set Pending
};

union ISPR6_REG {
	uint32_t 		 all;
	struct ISPR6_BITS 		 bit;
};

struct ISPR7_BITS {			// bits   description
	uint32_t	IRQ224_SET_PENDING:1;			// 0:0   EFC_DONE_INTR Set Pending
	uint32_t	IRQ225_SET_PENDING:1;			// 1:1   EFC_INTR Set Pending
	uint32_t	IRQ226_SET_PENDING:1;			// 2:2   IBUS_IRQ Set Pending
	uint32_t	IRQ227_SET_PENDING:1;			// 3:3   DBUS_IRQ Set Pending
	uint32_t	IRQ228_SET_PENDING:1;			// 4:4   RTOSINT2 Set Pending
	uint32_t	IRQ229_SET_PENDING:1;			// 5:5   RTOSINT1 Set Pending
	uint32_t	IRQ230_SET_PENDING:1;			// 6:6   LSE_CLOCK_FAIL_INT Set Pending
	uint32_t	IRQ231_SET_PENDING:1;			// 7:7   ~PLL_LOCK Set Pending
	uint32_t	IRQ232_SET_PENDING:1;			// 8:8   PMBUS_ALERT Set Pending
	uint32_t	IRQ233_SET_PENDING:1;			// 9:9   DSP_EXCP_INT0TRACE_EXCP0 Set Pending
	uint32_t	IRQ234_SET_PENDING:1;			// 10:10   DSP_EXCP_INT1TRACE_EXCP1 Set Pending
	uint32_t	IRQ235_SET_PENDING:1;			// 11:11   DSP_EXCP_INT2TRACE_EXCP2 Set Pending
	uint32_t	IRQ236_SET_PENDING:1;			// 12:12   DSP_EXCP_INT3TRACE_EXCP3 Set Pending
	uint32_t	IRQ237_SET_PENDING:1;			// 13:13   DSP_EXCP_INT4TRACE_EXCP4|TRACE_EXCP6 Set Pending
	uint32_t	IRQ238_SET_PENDING:1;			// 14:14   DSP_EXCP_INT5TRACE_EXCP5|7|13|15 Set Pending
	uint32_t	IRQ239_SET_PENDING:1;			// 15:15   DSP_EXCP_INT6TRACE_EXCP11 Set Pending
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union ISPR7_REG {
	uint32_t 		 all;
	struct ISPR7_BITS 		 bit;
};

struct ICPR0_BITS {			// bits   description
	uint32_t	IRQ0_CLEAR_PENDING:1;			// 0:0   CAN1_HOST_IRQ Clear Pending
	uint32_t	IRQ1_CLEAR_PENDING:1;			// 1:1   CAN0_HOST_IRQ Clear Pending
	uint32_t	IRQ2_CLEAR_PENDING:1;			// 2:2   SPI1_INTR Clear Pending
	uint32_t	IRQ3_CLEAR_PENDING:1;			// 3:3   SPI0_INTR Clear Pending
	uint32_t	rsvd1:2;			// 5:4   reserved
	uint32_t	IRQ6_CLEAR_PENDING:1;			// 6:6   SCIB_INTR Clear Pending
	uint32_t	IRQ7_CLEAR_PENDING:1;			// 7:7   SCIA_INTR Clear Pending
	uint32_t	IRQ8_CLEAR_PENDING:1;			// 8:8   I2C2_INTR Clear Pending
	uint32_t	IRQ9_CLEAR_PENDING:1;			// 9:9   I2C1_INTR Clear Pending
	uint32_t	IRQ10_CLEAR_PENDING:1;			// 10:10   I2C0_INTR Clear Pending
	uint32_t	rsvd2:12;			// 22:11   reserved
	uint32_t	IRQ23_CLEAR_PENDING:1;			// 23:23   APB_GPIO3_CMBINTR Clear Pending
	uint32_t	IRQ24_CLEAR_PENDING:1;			// 24:24   APB_GPIO2_CMBINTR Clear Pending
	uint32_t	IRQ25_CLEAR_PENDING:1;			// 25:25   APB_GPIO1_CMBINTR Clear Pending
	uint32_t	IRQ26_CLEAR_PENDING:1;			// 26:26   APB_GPIO0_CMBINTR Clear Pending
	uint32_t	IRQ27_CLEAR_PENDING:1;			// 27:27   AP_TIMER_INTR3 Clear Pending
	uint32_t	IRQ28_CLEAR_PENDING:1;			// 28:28   AP_TIMER_INTR2 Clear Pending
	uint32_t	IRQ29_CLEAR_PENDING:1;			// 29:29   AP_TIMER_INTR1 Clear Pending
	uint32_t	IRQ30_CLEAR_PENDING:1;			// 30:30   AP_TIMER_INTR0 Clear Pending
	uint32_t	IRQ31_CLEAR_PENDING:1;			// 31:31   CRC_FAIL_INT Clear Pending
};

union ICPR0_REG {
	uint32_t 		 all;
	struct ICPR0_BITS 		 bit;
};

struct ICPR1_BITS {			// bits   description
	uint32_t	IRQ32_CLEAR_PENDING:1;			// 0:0   CRC_DONE_INT Clear Pending
	uint32_t	IRQ33_CLEAR_PENDING:1;			// 1:1   LC3_INT_REQ Clear Pending
	uint32_t	IRQ34_CLEAR_PENDING:1;			// 2:2   LC2_INT_REQ Clear Pending
	uint32_t	IRQ35_CLEAR_PENDING:1;			// 3:3   LC1_INT_REQ Clear Pending
	uint32_t	IRQ36_CLEAR_PENDING:1;			// 4:4   EQEP2_INT Clear Pending
	uint32_t	IRQ37_CLEAR_PENDING:1;			// 5:5   EQEP1_INT Clear Pending
	uint32_t	IRQ38_CLEAR_PENDING:1;			// 6:6   ECAP2_HRCAL_INT Clear Pending
	uint32_t	IRQ39_CLEAR_PENDING:1;			// 7:7   ECAP1_HRCAL_INT Clear Pending
	uint32_t	IRQ40_CLEAR_PENDING:1;			// 8:8   ECAP7_INT Clear Pending
	uint32_t	IRQ41_CLEAR_PENDING:1;			// 9:9   ECAP6_INT Clear Pending
	uint32_t	IRQ42_CLEAR_PENDING:1;			// 10:10   ECAP5_INT Clear Pending
	uint32_t	IRQ43_CLEAR_PENDING:1;			// 11:11   ECAP4_INT Clear Pending
	uint32_t	IRQ44_CLEAR_PENDING:1;			// 12:12   ECAP3_INT Clear Pending
	uint32_t	IRQ45_CLEAR_PENDING:1;			// 13:13   ECAP2_INT Clear Pending
	uint32_t	IRQ46_CLEAR_PENDING:1;			// 14:14   ECAP1_INT Clear Pending
	uint32_t	IRQ47_CLEAR_PENDING:1;			// 15:15   CPU_16XINT Clear Pending
	uint32_t	IRQ48_CLEAR_PENDING:1;			// 16:16   CPU_15XINT Clear Pending
	uint32_t	IRQ49_CLEAR_PENDING:1;			// 17:17   CPU_14XINT Clear Pending
	uint32_t	IRQ50_CLEAR_PENDING:1;			// 18:18   CPU_13XINT Clear Pending
	uint32_t	IRQ51_CLEAR_PENDING:1;			// 19:19   CPU_12XINT Clear Pending
	uint32_t	IRQ52_CLEAR_PENDING:1;			// 20:20   CPU_11XINT Clear Pending
	uint32_t	IRQ53_CLEAR_PENDING:1;			// 21:21   CPU_10XINT Clear Pending
	uint32_t	IRQ54_CLEAR_PENDING:1;			// 22:22   CPU_9XINT Clear Pending
	uint32_t	IRQ55_CLEAR_PENDING:1;			// 23:23   CPU_8XINT Clear Pending
	uint32_t	IRQ56_CLEAR_PENDING:1;			// 24:24   CPU_7XINT Clear Pending
	uint32_t	IRQ57_CLEAR_PENDING:1;			// 25:25   CPU_6XINT Clear Pending
	uint32_t	IRQ58_CLEAR_PENDING:1;			// 26:26   CPU_5XINT Clear Pending
	uint32_t	IRQ59_CLEAR_PENDING:1;			// 27:27   CPU_4XINT Clear Pending
	uint32_t	IRQ60_CLEAR_PENDING:1;			// 28:28   CPU_3XINT Clear Pending
	uint32_t	IRQ61_CLEAR_PENDING:1;			// 29:29   CPU_2XINT Clear Pending
	uint32_t	IRQ62_CLEAR_PENDING:1;			// 30:30   CPU_1XINT Clear Pending
	uint32_t	IRQ63_CLEAR_PENDING:1;			// 31:31   TZ12_INTERRUPT Clear Pending
};

union ICPR1_REG {
	uint32_t 		 all;
	struct ICPR1_BITS 		 bit;
};

struct ICPR2_BITS {			// bits   description
	uint32_t	IRQ64_CLEAR_PENDING:1;			// 0:0   TZ11_INTERRUPT Clear Pending
	uint32_t	IRQ65_CLEAR_PENDING:1;			// 1:1   TZ10_INTERRUPT Clear Pending
	uint32_t	IRQ66_CLEAR_PENDING:1;			// 2:2   TZ9_INTERRUPT Clear Pending
	uint32_t	IRQ67_CLEAR_PENDING:1;			// 3:3   TZ8_INTERRUPT Clear Pending
	uint32_t	IRQ68_CLEAR_PENDING:1;			// 4:4   TZ7_INTERRUPT Clear Pending
	uint32_t	IRQ69_CLEAR_PENDING:1;			// 5:5   TZ6_INTERRUPT Clear Pending
	uint32_t	IRQ70_CLEAR_PENDING:1;			// 6:6   TZ5_INTERRUPT Clear Pending
	uint32_t	IRQ71_CLEAR_PENDING:1;			// 7:7   TZ4_INTERRUPT Clear Pending
	uint32_t	IRQ72_CLEAR_PENDING:1;			// 8:8   TZ3_INTERRUPT Clear Pending
	uint32_t	IRQ73_CLEAR_PENDING:1;			// 9:9   TZ2_INTERRUPT Clear Pending
	uint32_t	IRQ74_CLEAR_PENDING:1;			// 10:10   TZ1_INTERRUPT Clear Pending
	uint32_t	IRQ75_CLEAR_PENDING:1;			// 11:11   EPWM12XINT Clear Pending
	uint32_t	IRQ76_CLEAR_PENDING:1;			// 12:12   EPWM11XINT Clear Pending
	uint32_t	IRQ77_CLEAR_PENDING:1;			// 13:13   EPWM10XINT Clear Pending
	uint32_t	IRQ78_CLEAR_PENDING:1;			// 14:14   EPWM9XINT Clear Pending
	uint32_t	IRQ79_CLEAR_PENDING:1;			// 15:15   EPWM8XINT Clear Pending
	uint32_t	IRQ80_CLEAR_PENDING:1;			// 16:16   EPWM7XINT Clear Pending
	uint32_t	IRQ81_CLEAR_PENDING:1;			// 17:17   EPWM6XINT Clear Pending
	uint32_t	IRQ82_CLEAR_PENDING:1;			// 18:18   EPWM5XINT Clear Pending
	uint32_t	IRQ83_CLEAR_PENDING:1;			// 19:19   EPWM4XINT Clear Pending
	uint32_t	IRQ84_CLEAR_PENDING:1;			// 20:20   EPWM3XINT Clear Pending
	uint32_t	IRQ85_CLEAR_PENDING:1;			// 21:21   EPWM2XINT Clear Pending
	uint32_t	IRQ86_CLEAR_PENDING:1;			// 22:22   EPWM1XINT Clear Pending
	uint32_t	IRQ87_CLEAR_PENDING:1;			// 23:23   QSPI_INTR Clear Pending
	uint32_t	IRQ88_CLEAR_PENDING:1;			// 24:24   DMA_INT_CH0_ISTATUSTFR Clear Pending
	uint32_t	IRQ89_CLEAR_PENDING:1;			// 25:25   DMA_INT_CH1_ISTATUSTFR Clear Pending
	uint32_t	IRQ90_CLEAR_PENDING:1;			// 26:26   DMA_INT_CH2_ISTATUSTFR Clear Pending
	uint32_t	IRQ91_CLEAR_PENDING:1;			// 27:27   DMA_INT_CH3_ISTATUSTFR Clear Pending
	uint32_t	IRQ92_CLEAR_PENDING:1;			// 28:28   DMA_INT_CH4_ISTATUSTFR Clear Pending
	uint32_t	IRQ93_CLEAR_PENDING:1;			// 29:29   DMA_INT_CH5_ISTATUSTFR Clear Pending
	uint32_t	IRQ94_CLEAR_PENDING:1;			// 30:30   DMA_INT_CH6_ISTATUSTFR Clear Pending
	uint32_t	IRQ95_CLEAR_PENDING:1;			// 31:31   DMA_INT_CH7_ISTATUSTFR Clear Pending
};

union ICPR2_REG {
	uint32_t 		 all;
	struct ICPR2_BITS 		 bit;
};

struct ICPR3_BITS {			// bits   description
	uint32_t	IRQ96_CLEAR_PENDING:1;			// 0:0   DMA_INT_CH0_ISTATUSBLOCK Clear Pending
	uint32_t	IRQ97_CLEAR_PENDING:1;			// 1:1   DMA_INT_CH1_ISTATUSBLOCK Clear Pending
	uint32_t	IRQ98_CLEAR_PENDING:1;			// 2:2   DMA_INT_CH2_ISTATUSBLOCK Clear Pending
	uint32_t	IRQ99_CLEAR_PENDING:1;			// 3:3   DMA_INT_CH3_ISTATUSBLOCK Clear Pending
	uint32_t	IRQ100_CLEAR_PENDING:1;			// 4:4   DMA_INT_CH4_ISTATUSBLOCK Clear Pending
	uint32_t	IRQ101_CLEAR_PENDING:1;			// 5:5   DMA_INT_CH5_ISTATUSBLOCK Clear Pending
	uint32_t	IRQ102_CLEAR_PENDING:1;			// 6:6   DMA_INT_CH6_ISTATUSBLOCK Clear Pending
	uint32_t	IRQ103_CLEAR_PENDING:1;			// 7:7   DMA_INT_CH7_ISTATUSBLOCK Clear Pending
	uint32_t	IRQ104_CLEAR_PENDING:1;			// 8:8   DMA_INT_CH0_ISTATUSSRCTRAN Clear Pending
	uint32_t	IRQ105_CLEAR_PENDING:1;			// 9:9   DMA_INT_CH1_ISTATUSSRCTRAN Clear Pending
	uint32_t	IRQ106_CLEAR_PENDING:1;			// 10:10   DMA_INT_CH2_ISTATUSSRCTRAN Clear Pending
	uint32_t	IRQ107_CLEAR_PENDING:1;			// 11:11   DMA_INT_CH3_ISTATUSSRCTRAN Clear Pending
	uint32_t	IRQ108_CLEAR_PENDING:1;			// 12:12   DMA_INT_CH4_ISTATUSSRCTRAN Clear Pending
	uint32_t	IRQ109_CLEAR_PENDING:1;			// 13:13   DMA_INT_CH5_ISTATUSSRCTRAN Clear Pending
	uint32_t	IRQ110_CLEAR_PENDING:1;			// 14:14   DMA_INT_CH6_ISTATUSSRCTRAN Clear Pending
	uint32_t	IRQ111_CLEAR_PENDING:1;			// 15:15   DMA_INT_CH7_ISTATUSSRCTRAN Clear Pending
	uint32_t	IRQ112_CLEAR_PENDING:1;			// 16:16   DMA_INT_CH0_ISTATUSDSTTRAN Clear Pending
	uint32_t	IRQ113_CLEAR_PENDING:1;			// 17:17   DMA_INT_CH1_ISTATUSDSTTRAN Clear Pending
	uint32_t	IRQ114_CLEAR_PENDING:1;			// 18:18   DMA_INT_CH2_ISTATUSDSTTRAN Clear Pending
	uint32_t	IRQ115_CLEAR_PENDING:1;			// 19:19   DMA_INT_CH3_ISTATUSDSTTRAN Clear Pending
	uint32_t	IRQ116_CLEAR_PENDING:1;			// 20:20   DMA_INT_CH4_ISTATUSDSTTRAN Clear Pending
	uint32_t	IRQ117_CLEAR_PENDING:1;			// 21:21   DMA_INT_CH5_ISTATUSDSTTRAN Clear Pending
	uint32_t	IRQ118_CLEAR_PENDING:1;			// 22:22   DMA_INT_CH6_ISTATUSDSTTRAN Clear Pending
	uint32_t	IRQ119_CLEAR_PENDING:1;			// 23:23   DMA_INT_CH7_ISTATUSDSTTRAN Clear Pending
	uint32_t	IRQ120_CLEAR_PENDING:1;			// 24:24   DMA_INT_CH0_ISTATUSERR Clear Pending
	uint32_t	IRQ121_CLEAR_PENDING:1;			// 25:25   DMA_INT_CH1_ISTATUSERR Clear Pending
	uint32_t	IRQ122_CLEAR_PENDING:1;			// 26:26   DMA_INT_CH2_ISTATUSERR Clear Pending
	uint32_t	IRQ123_CLEAR_PENDING:1;			// 27:27   DMA_INT_CH3_ISTATUSERR Clear Pending
	uint32_t	IRQ124_CLEAR_PENDING:1;			// 28:28   DMA_INT_CH4_ISTATUSERR Clear Pending
	uint32_t	IRQ125_CLEAR_PENDING:1;			// 29:29   DMA_INT_CH5_ISTATUSERR Clear Pending
	uint32_t	IRQ126_CLEAR_PENDING:1;			// 30:30   DMA_INT_CH6_ISTATUSERR Clear Pending
	uint32_t	IRQ127_CLEAR_PENDING:1;			// 31:31   DMA_INT_CH7_ISTATUSERR Clear Pending
};

union ICPR3_REG {
	uint32_t 		 all;
	struct ICPR3_BITS 		 bit;
};

struct ICPR4_BITS {			// bits   description
	uint32_t	IRQ128_CLEAR_PENDING:1;			// 0:0   EXTI_INT0 Clear Pending
	uint32_t	IRQ129_CLEAR_PENDING:1;			// 1:1   EXTI_INT1 Clear Pending
	uint32_t	IRQ130_CLEAR_PENDING:1;			// 2:2   EXTI_INT2 Clear Pending
	uint32_t	IRQ131_CLEAR_PENDING:1;			// 3:3   EXTI_INT3 Clear Pending
	uint32_t	IRQ132_CLEAR_PENDING:1;			// 4:4   EXTI_INT4 Clear Pending
	uint32_t	IRQ133_CLEAR_PENDING:1;			// 5:5   EXTI_INT5 Clear Pending
	uint32_t	IRQ134_CLEAR_PENDING:1;			// 6:6   EXTI_INT6 Clear Pending
	uint32_t	IRQ135_CLEAR_PENDING:1;			// 7:7   EXTI_INT7 Clear Pending
	uint32_t	IRQ136_CLEAR_PENDING:1;			// 8:8   EXTI_INT8 Clear Pending
	uint32_t	IRQ137_CLEAR_PENDING:1;			// 9:9   EXTI_INT9 Clear Pending
	uint32_t	IRQ138_CLEAR_PENDING:1;			// 10:10   EXTI_INT10 Clear Pending
	uint32_t	IRQ139_CLEAR_PENDING:1;			// 11:11   EXTI_INT11 Clear Pending
	uint32_t	IRQ140_CLEAR_PENDING:1;			// 12:12   EXTI_INT12 Clear Pending
	uint32_t	IRQ141_CLEAR_PENDING:1;			// 13:13   EXTI_INT13 Clear Pending
	uint32_t	IRQ142_CLEAR_PENDING:1;			// 14:14   EXTI_INT14 Clear Pending
	uint32_t	IRQ143_CLEAR_PENDING:1;			// 15:15   EXTI_INT15 Clear Pending
	uint32_t	IRQ144_CLEAR_PENDING:1;			// 16:16   EXTI_INT16 Clear Pending
	uint32_t	IRQ145_CLEAR_PENDING:1;			// 17:17   EXTI_INT17 Clear Pending
	uint32_t	IRQ146_CLEAR_PENDING:1;			// 18:18   EXTI_INT18 Clear Pending
	uint32_t	IRQ147_CLEAR_PENDING:1;			// 19:19   EXTI_INT19 Clear Pending
	uint32_t	IRQ148_CLEAR_PENDING:1;			// 20:20   EXTI_INT20 Clear Pending
	uint32_t	IRQ149_CLEAR_PENDING:1;			// 21:21   EXTI_INT21 Clear Pending
	uint32_t	IRQ150_CLEAR_PENDING:1;			// 22:22   EXTI_INT22 Clear Pending
	uint32_t	IRQ151_CLEAR_PENDING:1;			// 23:23   EXTI_INT23 Clear Pending
	uint32_t	IRQ152_CLEAR_PENDING:1;			// 24:24   EXTI_INT24 Clear Pending
	uint32_t	IRQ153_CLEAR_PENDING:1;			// 25:25   EXTI_INT25 Clear Pending
	uint32_t	IRQ154_CLEAR_PENDING:1;			// 26:26   EXTI_INT26 Clear Pending
	uint32_t	IRQ155_CLEAR_PENDING:1;			// 27:27   EXTI_INT27 Clear Pending
	uint32_t	IRQ156_CLEAR_PENDING:1;			// 28:28   EXTI_INT28 Clear Pending
	uint32_t	IRQ157_CLEAR_PENDING:1;			// 29:29   EXTI_INT29 Clear Pending
	uint32_t	IRQ158_CLEAR_PENDING:1;			// 30:30   EXTI_INT30 Clear Pending
	uint32_t	IRQ159_CLEAR_PENDING:1;			// 31:31   EXTI_INT31 Clear Pending
};

union ICPR4_REG {
	uint32_t 		 all;
	struct ICPR4_BITS 		 bit;
};

struct ICPR5_BITS {			// bits   description
	uint32_t	IRQ160_CLEAR_PENDING:1;			// 0:0   AP_SYSCTL_FPUSTA Clear Pending
	uint32_t	IRQ161_CLEAR_PENDING:1;			// 1:1   AP_SYSCTL_FPUSTA Clear Pending
	uint32_t	IRQ162_CLEAR_PENDING:1;			// 2:2   AP_SYSCTL_FPUSTA Clear Pending
	uint32_t	IRQ163_CLEAR_PENDING:1;			// 3:3   AP_SYSCTL_FPUSTA Clear Pending
	uint32_t	IRQ164_CLEAR_PENDING:1;			// 4:4   AP_SYSCTL_FPUSTA Clear Pending
	uint32_t	IRQ165_CLEAR_PENDING:1;			// 5:5   AP_SYSCTL_FPUSTA Clear Pending
	uint32_t	IRQ166_CLEAR_PENDING:1;			// 6:6   FP_NV_INT Clear Pending
	uint32_t	IRQ167_CLEAR_PENDING:1;			// 7:7   FP_DZ_INT Clear Pending
	uint32_t	IRQ168_CLEAR_PENDING:1;			// 8:8   FP_OF_INT Clear Pending
	uint32_t	IRQ169_CLEAR_PENDING:1;			// 9:9   FP_UF_INT Clear Pending
	uint32_t	IRQ170_CLEAR_PENDING:1;			// 10:10   AP_WDT_INTR Clear Pending
	uint32_t	IRQ171_CLEAR_PENDING:1;			// 11:11   ADCC_EVT_INT Clear Pending
	uint32_t	IRQ172_CLEAR_PENDING:1;			// 12:12   ADCB_EVT_INT Clear Pending
	uint32_t	IRQ173_CLEAR_PENDING:1;			// 13:13   ADCA_EVT_INT Clear Pending
	uint32_t	IRQ174_CLEAR_PENDING:1;			// 14:14   ADCC_4INT Clear Pending
	uint32_t	IRQ175_CLEAR_PENDING:1;			// 15:15   ADCC_3INT Clear Pending
	uint32_t	IRQ176_CLEAR_PENDING:1;			// 16:16   ADCC_2INT Clear Pending
	uint32_t	IRQ177_CLEAR_PENDING:1;			// 17:17   ADCC_1INT Clear Pending
	uint32_t	IRQ178_CLEAR_PENDING:1;			// 18:18   ADCB_4INT Clear Pending
	uint32_t	IRQ179_CLEAR_PENDING:1;			// 19:19   ADCB_3INT Clear Pending
	uint32_t	IRQ180_CLEAR_PENDING:1;			// 20:20   ADCB_2INT Clear Pending
	uint32_t	IRQ181_CLEAR_PENDING:1;			// 21:21   ADCB_1INT Clear Pending
	uint32_t	IRQ182_CLEAR_PENDING:1;			// 22:22   ADCA_4INT Clear Pending
	uint32_t	IRQ183_CLEAR_PENDING:1;			// 23:23   ADCA_3INT Clear Pending
	uint32_t	IRQ184_CLEAR_PENDING:1;			// 24:24   ADCA_2INT Clear Pending
	uint32_t	IRQ185_CLEAR_PENDING:1;			// 25:25   ADCA_1INT Clear Pending
	uint32_t	IRQ186_CLEAR_PENDING:1;			// 26:26   DSP_EVT_O Clear Pending
	uint32_t	IRQ187_CLEAR_PENDING:1;			// 27:27   DSP_TASK_INT0 Clear Pending
	uint32_t	IRQ188_CLEAR_PENDING:1;			// 28:28   DSP_TASK_INT1 Clear Pending
	uint32_t	IRQ189_CLEAR_PENDING:1;			// 29:29   DSP_TASK_INT2 Clear Pending
	uint32_t	IRQ190_CLEAR_PENDING:1;			// 30:30   DSP_TASK_INT3 Clear Pending
	uint32_t	IRQ191_CLEAR_PENDING:1;			// 31:31   DSP_TASK_INT4 Clear Pending
};

union ICPR5_REG {
	uint32_t 		 all;
	struct ICPR5_BITS 		 bit;
};

struct ICPR6_BITS {			// bits   description
	uint32_t	IRQ192_CLEAR_PENDING:1;			// 0:0   DSP_TASK_INT5 Clear Pending
	uint32_t	IRQ193_CLEAR_PENDING:1;			// 1:1   DSP_TASK_INT6 Clear Pending
	uint32_t	IRQ194_CLEAR_PENDING:1;			// 2:2   DSP_TASK_INT7 Clear Pending
	uint32_t	IRQ195_CLEAR_PENDING:1;			// 3:3   DSP_TASK_INT8 Clear Pending
	uint32_t	IRQ196_CLEAR_PENDING:1;			// 4:4   DSP_TASK_INT9 Clear Pending
	uint32_t	IRQ197_CLEAR_PENDING:1;			// 5:5   DSP_TASK_INT10 Clear Pending
	uint32_t	IRQ198_CLEAR_PENDING:1;			// 6:6   DSP_TASK_INT11 Clear Pending
	uint32_t	IRQ199_CLEAR_PENDING:1;			// 7:7   DSP_TASK_INT12 Clear Pending
	uint32_t	IRQ200_CLEAR_PENDING:1;			// 8:8   DSP_TASK_INT13 Clear Pending
	uint32_t	IRQ201_CLEAR_PENDING:1;			// 9:9   DSP_TASK_INT14 Clear Pending
	uint32_t	IRQ202_CLEAR_PENDING:1;			// 10:10   DSP_TASK_INT15 Clear Pending
	uint32_t	IRQ203_CLEAR_PENDING:1;			// 11:11   DSP_TASK_INT16 Clear Pending
	uint32_t	IRQ204_CLEAR_PENDING:1;			// 12:12   DSP_TASK_INT17 Clear Pending
	uint32_t	IRQ205_CLEAR_PENDING:1;			// 13:13   DSP_TASK_INT18 Clear Pending
	uint32_t	IRQ206_CLEAR_PENDING:1;			// 14:14   DSP_TASK_INT19 Clear Pending
	uint32_t	IRQ207_CLEAR_PENDING:1;			// 15:15   DSP_TASK_INT20 Clear Pending
	uint32_t	IRQ208_CLEAR_PENDING:1;			// 16:16   DSP_TASK_INT21 Clear Pending
	uint32_t	IRQ209_CLEAR_PENDING:1;			// 17:17   DSP_TASK_INT22 Clear Pending
	uint32_t	IRQ210_CLEAR_PENDING:1;			// 18:18   DSP_TASK_INT23 Clear Pending
	uint32_t	IRQ211_CLEAR_PENDING:1;			// 19:19   DSP_TASK_INT24 Clear Pending
	uint32_t	IRQ212_CLEAR_PENDING:1;			// 20:20   DSP_TASK_INT25 Clear Pending
	uint32_t	IRQ213_CLEAR_PENDING:1;			// 21:21   DSP_TASK_INT26 Clear Pending
	uint32_t	IRQ214_CLEAR_PENDING:1;			// 22:22   DSP_TASK_INT27 Clear Pending
	uint32_t	IRQ215_CLEAR_PENDING:1;			// 23:23   DSP_TASK_INT28 Clear Pending
	uint32_t	IRQ216_CLEAR_PENDING:1;			// 24:24   DSP_TASK_INT29 Clear Pending
	uint32_t	IRQ217_CLEAR_PENDING:1;			// 25:25   DSP_TASK_INT30 Clear Pending
	uint32_t	IRQ218_CLEAR_PENDING:1;			// 26:26   DSP_TASK_INT31 Clear Pending
	uint32_t	IRQ219_CLEAR_PENDING:1;			// 27:27   DLM_ECC_SBERR Clear Pending
	uint32_t	IRQ220_CLEAR_PENDING:1;			// 28:28   ILM_ECC_SBERR Clear Pending
	uint32_t	IRQ221_CLEAR_PENDING:1;			// 29:29   |GS_RAM_RD_ERR Clear Pending
	uint32_t	IRQ222_CLEAR_PENDING:1;			// 30:30   |CCM_RAM_RD_ERR Clear Pending
	uint32_t	IRQ223_CLEAR_PENDING:1;			// 31:31   EFC_SEC_INTR Clear Pending
};

union ICPR6_REG {
	uint32_t 		 all;
	struct ICPR6_BITS 		 bit;
};

struct ICPR7_BITS {			// bits   description
	uint32_t	IRQ224_CLEAR_PENDING:1;			// 0:0   EFC_DONE_INTR Clear Pending
	uint32_t	IRQ225_CLEAR_PENDING:1;			// 1:1   EFC_INTR Clear Pending
	uint32_t	IRQ226_CLEAR_PENDING:1;			// 2:2   IBUS_IRQ Clear Pending
	uint32_t	IRQ227_CLEAR_PENDING:1;			// 3:3   DBUS_IRQ Clear Pending
	uint32_t	IRQ228_CLEAR_PENDING:1;			// 4:4   RTOSINT2 Clear Pending
	uint32_t	IRQ229_CLEAR_PENDING:1;			// 5:5   RTOSINT1 Clear Pending
	uint32_t	IRQ230_CLEAR_PENDING:1;			// 6:6   LSE_CLOCK_FAIL_INT Clear Pending
	uint32_t	IRQ231_CLEAR_PENDING:1;			// 7:7   ~PLL_LOCK Clear Pending
	uint32_t	IRQ232_CLEAR_PENDING:1;			// 8:8   PMBUS_ALERT Clear Pending
	uint32_t	IRQ233_CLEAR_PENDING:1;			// 9:9   DSP_EXCP_INT0TRACE_EXCP0 Clear Pending
	uint32_t	IRQ234_CLEAR_PENDING:1;			// 10:10   DSP_EXCP_INT1TRACE_EXCP1 Clear Pending
	uint32_t	IRQ235_CLEAR_PENDING:1;			// 11:11   DSP_EXCP_INT2TRACE_EXCP2 Clear Pending
	uint32_t	IRQ236_CLEAR_PENDING:1;			// 12:12   DSP_EXCP_INT3TRACE_EXCP3 Clear Pending
	uint32_t	IRQ237_CLEAR_PENDING:1;			// 13:13   DSP_EXCP_INT4TRACE_EXCP4|TRACE_EXCP6 Clear Pending
	uint32_t	IRQ238_CLEAR_PENDING:1;			// 14:14   DSP_EXCP_INT5TRACE_EXCP5|7|13|15 Clear Pending
	uint32_t	IRQ239_CLEAR_PENDING:1;			// 15:15   DSP_EXCP_INT6TRACE_EXCP11 Clear Pending
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union ICPR7_REG {
	uint32_t 		 all;
	struct ICPR7_BITS 		 bit;
};

struct IABR0_BITS {			// bits   description
	uint32_t	IRQ0_IS_ACTIVE:1;			// 0:0   CAN1_HOST_IRQ is Active
	uint32_t	IRQ1_IS_ACTIVE:1;			// 1:1   CAN0_HOST_IRQ is Active
	uint32_t	IRQ2_IS_ACTIVE:1;			// 2:2   SPI1_INTR is Active
	uint32_t	IRQ3_IS_ACTIVE:1;			// 3:3   SPI0_INTR is Active
	uint32_t	rsvd1:2;			// 5:4   reserved
	uint32_t	IRQ6_IS_ACTIVE:1;			// 6:6   SCIB_INTR is Active
	uint32_t	IRQ7_IS_ACTIVE:1;			// 7:7   SCIA_INTR is Active
	uint32_t	IRQ8_IS_ACTIVE:1;			// 8:8   I2C2_INTR is Active
	uint32_t	IRQ9_IS_ACTIVE:1;			// 9:9   I2C1_INTR is Active
	uint32_t	IRQ10_IS_ACTIVE:1;			// 10:10   I2C0_INTR is Active
	uint32_t	rsvd2:12;			// 22:11   reserved
	uint32_t	IRQ23_IS_ACTIVE:1;			// 23:23   APB_GPIO3_CMBINTR is Active
	uint32_t	IRQ24_IS_ACTIVE:1;			// 24:24   APB_GPIO2_CMBINTR is Active
	uint32_t	IRQ25_IS_ACTIVE:1;			// 25:25   APB_GPIO1_CMBINTR is Active
	uint32_t	IRQ26_IS_ACTIVE:1;			// 26:26   APB_GPIO0_CMBINTR is Active
	uint32_t	IRQ27_IS_ACTIVE:1;			// 27:27   AP_TIMER_INTR3 is Active
	uint32_t	IRQ28_IS_ACTIVE:1;			// 28:28   AP_TIMER_INTR2 is Active
	uint32_t	IRQ29_IS_ACTIVE:1;			// 29:29   AP_TIMER_INTR1 is Active
	uint32_t	IRQ30_IS_ACTIVE:1;			// 30:30   AP_TIMER_INTR0 is Active
	uint32_t	IRQ31_IS_ACTIVE:1;			// 31:31   CRC_FAIL_INT is Active
};

union IABR0_REG {
	uint32_t 		 all;
	struct IABR0_BITS 		 bit;
};

struct IABR1_BITS {			// bits   description
	uint32_t	IRQ32_IS_ACTIVE:1;			// 0:0   CRC_DONE_INT is Active
	uint32_t	IRQ33_IS_ACTIVE:1;			// 1:1   LC3_INT_REQ is Active
	uint32_t	IRQ34_IS_ACTIVE:1;			// 2:2   LC2_INT_REQ is Active
	uint32_t	IRQ35_IS_ACTIVE:1;			// 3:3   LC1_INT_REQ is Active
	uint32_t	IRQ36_IS_ACTIVE:1;			// 4:4   EQEP2_INT is Active
	uint32_t	IRQ37_IS_ACTIVE:1;			// 5:5   EQEP1_INT is Active
	uint32_t	IRQ38_IS_ACTIVE:1;			// 6:6   ECAP2_HRCAL_INT is Active
	uint32_t	IRQ39_IS_ACTIVE:1;			// 7:7   ECAP1_HRCAL_INT is Active
	uint32_t	IRQ40_IS_ACTIVE:1;			// 8:8   ECAP7_INT is Active
	uint32_t	IRQ41_IS_ACTIVE:1;			// 9:9   ECAP6_INT is Active
	uint32_t	IRQ42_IS_ACTIVE:1;			// 10:10   ECAP5_INT is Active
	uint32_t	IRQ43_IS_ACTIVE:1;			// 11:11   ECAP4_INT is Active
	uint32_t	IRQ44_IS_ACTIVE:1;			// 12:12   ECAP3_INT is Active
	uint32_t	IRQ45_IS_ACTIVE:1;			// 13:13   ECAP2_INT is Active
	uint32_t	IRQ46_IS_ACTIVE:1;			// 14:14   ECAP1_INT is Active
	uint32_t	IRQ47_IS_ACTIVE:1;			// 15:15   CPU_16XINT is Active
	uint32_t	IRQ48_IS_ACTIVE:1;			// 16:16   CPU_15XINT is Active
	uint32_t	IRQ49_IS_ACTIVE:1;			// 17:17   CPU_14XINT is Active
	uint32_t	IRQ50_IS_ACTIVE:1;			// 18:18   CPU_13XINT is Active
	uint32_t	IRQ51_IS_ACTIVE:1;			// 19:19   CPU_12XINT is Active
	uint32_t	IRQ52_IS_ACTIVE:1;			// 20:20   CPU_11XINT is Active
	uint32_t	IRQ53_IS_ACTIVE:1;			// 21:21   CPU_10XINT is Active
	uint32_t	IRQ54_IS_ACTIVE:1;			// 22:22   CPU_9XINT is Active
	uint32_t	IRQ55_IS_ACTIVE:1;			// 23:23   CPU_8XINT is Active
	uint32_t	IRQ56_IS_ACTIVE:1;			// 24:24   CPU_7XINT is Active
	uint32_t	IRQ57_IS_ACTIVE:1;			// 25:25   CPU_6XINT is Active
	uint32_t	IRQ58_IS_ACTIVE:1;			// 26:26   CPU_5XINT is Active
	uint32_t	IRQ59_IS_ACTIVE:1;			// 27:27   CPU_4XINT is Active
	uint32_t	IRQ60_IS_ACTIVE:1;			// 28:28   CPU_3XINT is Active
	uint32_t	IRQ61_IS_ACTIVE:1;			// 29:29   CPU_2XINT is Active
	uint32_t	IRQ62_IS_ACTIVE:1;			// 30:30   CPU_1XINT is Active
	uint32_t	IRQ63_IS_ACTIVE:1;			// 31:31   TZ12_INTERRUPT is Active
};

union IABR1_REG {
	uint32_t 		 all;
	struct IABR1_BITS 		 bit;
};

struct IABR2_BITS {			// bits   description
	uint32_t	IRQ64_IS_ACTIVE:1;			// 0:0   TZ11_INTERRUPT is Active
	uint32_t	IRQ65_IS_ACTIVE:1;			// 1:1   TZ10_INTERRUPT is Active
	uint32_t	IRQ66_IS_ACTIVE:1;			// 2:2   TZ9_INTERRUPT is Active
	uint32_t	IRQ67_IS_ACTIVE:1;			// 3:3   TZ8_INTERRUPT is Active
	uint32_t	IRQ68_IS_ACTIVE:1;			// 4:4   TZ7_INTERRUPT is Active
	uint32_t	IRQ69_IS_ACTIVE:1;			// 5:5   TZ6_INTERRUPT is Active
	uint32_t	IRQ70_IS_ACTIVE:1;			// 6:6   TZ5_INTERRUPT is Active
	uint32_t	IRQ71_IS_ACTIVE:1;			// 7:7   TZ4_INTERRUPT is Active
	uint32_t	IRQ72_IS_ACTIVE:1;			// 8:8   TZ3_INTERRUPT is Active
	uint32_t	IRQ73_IS_ACTIVE:1;			// 9:9   TZ2_INTERRUPT is Active
	uint32_t	IRQ74_IS_ACTIVE:1;			// 10:10   TZ1_INTERRUPT is Active
	uint32_t	IRQ75_IS_ACTIVE:1;			// 11:11   EPWM12XINT is Active
	uint32_t	IRQ76_IS_ACTIVE:1;			// 12:12   EPWM11XINT is Active
	uint32_t	IRQ77_IS_ACTIVE:1;			// 13:13   EPWM10XINT is Active
	uint32_t	IRQ78_IS_ACTIVE:1;			// 14:14   EPWM9XINT is Active
	uint32_t	IRQ79_IS_ACTIVE:1;			// 15:15   EPWM8XINT is Active
	uint32_t	IRQ80_IS_ACTIVE:1;			// 16:16   EPWM7XINT is Active
	uint32_t	IRQ81_IS_ACTIVE:1;			// 17:17   EPWM6XINT is Active
	uint32_t	IRQ82_IS_ACTIVE:1;			// 18:18   EPWM5XINT is Active
	uint32_t	IRQ83_IS_ACTIVE:1;			// 19:19   EPWM4XINT is Active
	uint32_t	IRQ84_IS_ACTIVE:1;			// 20:20   EPWM3XINT is Active
	uint32_t	IRQ85_IS_ACTIVE:1;			// 21:21   EPWM2XINT is Active
	uint32_t	IRQ86_IS_ACTIVE:1;			// 22:22   EPWM1XINT is Active
	uint32_t	IRQ87_IS_ACTIVE:1;			// 23:23   QSPI_INTR is Active
	uint32_t	IRQ88_IS_ACTIVE:1;			// 24:24   DMA_INT_CH0_ISTATUSTFR is Active
	uint32_t	IRQ89_IS_ACTIVE:1;			// 25:25   DMA_INT_CH1_ISTATUSTFR is Active
	uint32_t	IRQ90_IS_ACTIVE:1;			// 26:26   DMA_INT_CH2_ISTATUSTFR is Active
	uint32_t	IRQ91_IS_ACTIVE:1;			// 27:27   DMA_INT_CH3_ISTATUSTFR is Active
	uint32_t	IRQ92_IS_ACTIVE:1;			// 28:28   DMA_INT_CH4_ISTATUSTFR is Active
	uint32_t	IRQ93_IS_ACTIVE:1;			// 29:29   DMA_INT_CH5_ISTATUSTFR is Active
	uint32_t	IRQ94_IS_ACTIVE:1;			// 30:30   DMA_INT_CH6_ISTATUSTFR is Active
	uint32_t	IRQ95_IS_ACTIVE:1;			// 31:31   DMA_INT_CH7_ISTATUSTFR is Active
};

union IABR2_REG {
	uint32_t 		 all;
	struct IABR2_BITS 		 bit;
};

struct IABR3_BITS {			// bits   description
	uint32_t	IRQ96_IS_ACTIVE:1;			// 0:0   DMA_INT_CH0_ISTATUSBLOCK is Active
	uint32_t	IRQ97_IS_ACTIVE:1;			// 1:1   DMA_INT_CH1_ISTATUSBLOCK is Active
	uint32_t	IRQ98_IS_ACTIVE:1;			// 2:2   DMA_INT_CH2_ISTATUSBLOCK is Active
	uint32_t	IRQ99_IS_ACTIVE:1;			// 3:3   DMA_INT_CH3_ISTATUSBLOCK is Active
	uint32_t	IRQ100_IS_ACTIVE:1;			// 4:4   DMA_INT_CH4_ISTATUSBLOCK is Active
	uint32_t	IRQ101_IS_ACTIVE:1;			// 5:5   DMA_INT_CH5_ISTATUSBLOCK is Active
	uint32_t	IRQ102_IS_ACTIVE:1;			// 6:6   DMA_INT_CH6_ISTATUSBLOCK is Active
	uint32_t	IRQ103_IS_ACTIVE:1;			// 7:7   DMA_INT_CH7_ISTATUSBLOCK is Active
	uint32_t	IRQ104_IS_ACTIVE:1;			// 8:8   DMA_INT_CH0_ISTATUSSRCTRAN is Active
	uint32_t	IRQ105_IS_ACTIVE:1;			// 9:9   DMA_INT_CH1_ISTATUSSRCTRAN is Active
	uint32_t	IRQ106_IS_ACTIVE:1;			// 10:10   DMA_INT_CH2_ISTATUSSRCTRAN is Active
	uint32_t	IRQ107_IS_ACTIVE:1;			// 11:11   DMA_INT_CH3_ISTATUSSRCTRAN is Active
	uint32_t	IRQ108_IS_ACTIVE:1;			// 12:12   DMA_INT_CH4_ISTATUSSRCTRAN is Active
	uint32_t	IRQ109_IS_ACTIVE:1;			// 13:13   DMA_INT_CH5_ISTATUSSRCTRAN is Active
	uint32_t	IRQ110_IS_ACTIVE:1;			// 14:14   DMA_INT_CH6_ISTATUSSRCTRAN is Active
	uint32_t	IRQ111_IS_ACTIVE:1;			// 15:15   DMA_INT_CH7_ISTATUSSRCTRAN is Active
	uint32_t	IRQ112_IS_ACTIVE:1;			// 16:16   DMA_INT_CH0_ISTATUSDSTTRAN is Active
	uint32_t	IRQ113_IS_ACTIVE:1;			// 17:17   DMA_INT_CH1_ISTATUSDSTTRAN is Active
	uint32_t	IRQ114_IS_ACTIVE:1;			// 18:18   DMA_INT_CH2_ISTATUSDSTTRAN is Active
	uint32_t	IRQ115_IS_ACTIVE:1;			// 19:19   DMA_INT_CH3_ISTATUSDSTTRAN is Active
	uint32_t	IRQ116_IS_ACTIVE:1;			// 20:20   DMA_INT_CH4_ISTATUSDSTTRAN is Active
	uint32_t	IRQ117_IS_ACTIVE:1;			// 21:21   DMA_INT_CH5_ISTATUSDSTTRAN is Active
	uint32_t	IRQ118_IS_ACTIVE:1;			// 22:22   DMA_INT_CH6_ISTATUSDSTTRAN is Active
	uint32_t	IRQ119_IS_ACTIVE:1;			// 23:23   DMA_INT_CH7_ISTATUSDSTTRAN is Active
	uint32_t	IRQ120_IS_ACTIVE:1;			// 24:24   DMA_INT_CH0_ISTATUSERR is Active
	uint32_t	IRQ121_IS_ACTIVE:1;			// 25:25   DMA_INT_CH1_ISTATUSERR is Active
	uint32_t	IRQ122_IS_ACTIVE:1;			// 26:26   DMA_INT_CH2_ISTATUSERR is Active
	uint32_t	IRQ123_IS_ACTIVE:1;			// 27:27   DMA_INT_CH3_ISTATUSERR is Active
	uint32_t	IRQ124_IS_ACTIVE:1;			// 28:28   DMA_INT_CH4_ISTATUSERR is Active
	uint32_t	IRQ125_IS_ACTIVE:1;			// 29:29   DMA_INT_CH5_ISTATUSERR is Active
	uint32_t	IRQ126_IS_ACTIVE:1;			// 30:30   DMA_INT_CH6_ISTATUSERR is Active
	uint32_t	IRQ127_IS_ACTIVE:1;			// 31:31   DMA_INT_CH7_ISTATUSERR is Active
};

union IABR3_REG {
	uint32_t 		 all;
	struct IABR3_BITS 		 bit;
};

struct IABR4_BITS {			// bits   description
	uint32_t	IRQ128_IS_ACTIVE:1;			// 0:0   EXTI_INT0 is Active
	uint32_t	IRQ129_IS_ACTIVE:1;			// 1:1   EXTI_INT1 is Active
	uint32_t	IRQ130_IS_ACTIVE:1;			// 2:2   EXTI_INT2 is Active
	uint32_t	IRQ131_IS_ACTIVE:1;			// 3:3   EXTI_INT3 is Active
	uint32_t	IRQ132_IS_ACTIVE:1;			// 4:4   EXTI_INT4 is Active
	uint32_t	IRQ133_IS_ACTIVE:1;			// 5:5   EXTI_INT5 is Active
	uint32_t	IRQ134_IS_ACTIVE:1;			// 6:6   EXTI_INT6 is Active
	uint32_t	IRQ135_IS_ACTIVE:1;			// 7:7   EXTI_INT7 is Active
	uint32_t	IRQ136_IS_ACTIVE:1;			// 8:8   EXTI_INT8 is Active
	uint32_t	IRQ137_IS_ACTIVE:1;			// 9:9   EXTI_INT9 is Active
	uint32_t	IRQ138_IS_ACTIVE:1;			// 10:10   EXTI_INT10 is Active
	uint32_t	IRQ139_IS_ACTIVE:1;			// 11:11   EXTI_INT11 is Active
	uint32_t	IRQ140_IS_ACTIVE:1;			// 12:12   EXTI_INT12 is Active
	uint32_t	IRQ141_IS_ACTIVE:1;			// 13:13   EXTI_INT13 is Active
	uint32_t	IRQ142_IS_ACTIVE:1;			// 14:14   EXTI_INT14 is Active
	uint32_t	IRQ143_IS_ACTIVE:1;			// 15:15   EXTI_INT15 is Active
	uint32_t	IRQ144_IS_ACTIVE:1;			// 16:16   EXTI_INT16 is Active
	uint32_t	IRQ145_IS_ACTIVE:1;			// 17:17   EXTI_INT17 is Active
	uint32_t	IRQ146_IS_ACTIVE:1;			// 18:18   EXTI_INT18 is Active
	uint32_t	IRQ147_IS_ACTIVE:1;			// 19:19   EXTI_INT19 is Active
	uint32_t	IRQ148_IS_ACTIVE:1;			// 20:20   EXTI_INT20 is Active
	uint32_t	IRQ149_IS_ACTIVE:1;			// 21:21   EXTI_INT21 is Active
	uint32_t	IRQ150_IS_ACTIVE:1;			// 22:22   EXTI_INT22 is Active
	uint32_t	IRQ151_IS_ACTIVE:1;			// 23:23   EXTI_INT23 is Active
	uint32_t	IRQ152_IS_ACTIVE:1;			// 24:24   EXTI_INT24 is Active
	uint32_t	IRQ153_IS_ACTIVE:1;			// 25:25   EXTI_INT25 is Active
	uint32_t	IRQ154_IS_ACTIVE:1;			// 26:26   EXTI_INT26 is Active
	uint32_t	IRQ155_IS_ACTIVE:1;			// 27:27   EXTI_INT27 is Active
	uint32_t	IRQ156_IS_ACTIVE:1;			// 28:28   EXTI_INT28 is Active
	uint32_t	IRQ157_IS_ACTIVE:1;			// 29:29   EXTI_INT29 is Active
	uint32_t	IRQ158_IS_ACTIVE:1;			// 30:30   EXTI_INT30 is Active
	uint32_t	IRQ159_IS_ACTIVE:1;			// 31:31   EXTI_INT31 is Active
};

union IABR4_REG {
	uint32_t 		 all;
	struct IABR4_BITS 		 bit;
};

struct IABR5_BITS {			// bits   description
	uint32_t	IRQ160_IS_ACTIVE:1;			// 0:0   AP_SYSCTL_FPUSTA is Active
	uint32_t	IRQ161_IS_ACTIVE:1;			// 1:1   AP_SYSCTL_FPUSTA is Active
	uint32_t	IRQ162_IS_ACTIVE:1;			// 2:2   AP_SYSCTL_FPUSTA is Active
	uint32_t	IRQ163_IS_ACTIVE:1;			// 3:3   AP_SYSCTL_FPUSTA is Active
	uint32_t	IRQ164_IS_ACTIVE:1;			// 4:4   AP_SYSCTL_FPUSTA is Active
	uint32_t	IRQ165_IS_ACTIVE:1;			// 5:5   AP_SYSCTL_FPUSTA is Active
	uint32_t	IRQ166_IS_ACTIVE:1;			// 6:6   FP_NV_INT is Active
	uint32_t	IRQ167_IS_ACTIVE:1;			// 7:7   FP_DZ_INT is Active
	uint32_t	IRQ168_IS_ACTIVE:1;			// 8:8   FP_OF_INT is Active
	uint32_t	IRQ169_IS_ACTIVE:1;			// 9:9   FP_UF_INT is Active
	uint32_t	IRQ170_IS_ACTIVE:1;			// 10:10   AP_WDT_INTR is Active
	uint32_t	IRQ171_IS_ACTIVE:1;			// 11:11   ADCC_EVT_INT is Active
	uint32_t	IRQ172_IS_ACTIVE:1;			// 12:12   ADCB_EVT_INT is Active
	uint32_t	IRQ173_IS_ACTIVE:1;			// 13:13   ADCA_EVT_INT is Active
	uint32_t	IRQ174_IS_ACTIVE:1;			// 14:14   ADCC_4INT is Active
	uint32_t	IRQ175_IS_ACTIVE:1;			// 15:15   ADCC_3INT is Active
	uint32_t	IRQ176_IS_ACTIVE:1;			// 16:16   ADCC_2INT is Active
	uint32_t	IRQ177_IS_ACTIVE:1;			// 17:17   ADCC_1INT is Active
	uint32_t	IRQ178_IS_ACTIVE:1;			// 18:18   ADCB_4INT is Active
	uint32_t	IRQ179_IS_ACTIVE:1;			// 19:19   ADCB_3INT is Active
	uint32_t	IRQ180_IS_ACTIVE:1;			// 20:20   ADCB_2INT is Active
	uint32_t	IRQ181_IS_ACTIVE:1;			// 21:21   ADCB_1INT is Active
	uint32_t	IRQ182_IS_ACTIVE:1;			// 22:22   ADCA_4INT is Active
	uint32_t	IRQ183_IS_ACTIVE:1;			// 23:23   ADCA_3INT is Active
	uint32_t	IRQ184_IS_ACTIVE:1;			// 24:24   ADCA_2INT is Active
	uint32_t	IRQ185_IS_ACTIVE:1;			// 25:25   ADCA_1INT is Active
	uint32_t	IRQ186_IS_ACTIVE:1;			// 26:26   DSP_EVT_O is Active
	uint32_t	IRQ187_IS_ACTIVE:1;			// 27:27   DSP_TASK_INT0 is Active
	uint32_t	IRQ188_IS_ACTIVE:1;			// 28:28   DSP_TASK_INT1 is Active
	uint32_t	IRQ189_IS_ACTIVE:1;			// 29:29   DSP_TASK_INT2 is Active
	uint32_t	IRQ190_IS_ACTIVE:1;			// 30:30   DSP_TASK_INT3 is Active
	uint32_t	IRQ191_IS_ACTIVE:1;			// 31:31   DSP_TASK_INT4 is Active
};

union IABR5_REG {
	uint32_t 		 all;
	struct IABR5_BITS 		 bit;
};

struct IABR6_BITS {			// bits   description
	uint32_t	IRQ192_IS_ACTIVE:1;			// 0:0   DSP_TASK_INT5 is Active
	uint32_t	IRQ193_IS_ACTIVE:1;			// 1:1   DSP_TASK_INT6 is Active
	uint32_t	IRQ194_IS_ACTIVE:1;			// 2:2   DSP_TASK_INT7 is Active
	uint32_t	IRQ195_IS_ACTIVE:1;			// 3:3   DSP_TASK_INT8 is Active
	uint32_t	IRQ196_IS_ACTIVE:1;			// 4:4   DSP_TASK_INT9 is Active
	uint32_t	IRQ197_IS_ACTIVE:1;			// 5:5   DSP_TASK_INT10 is Active
	uint32_t	IRQ198_IS_ACTIVE:1;			// 6:6   DSP_TASK_INT11 is Active
	uint32_t	IRQ199_IS_ACTIVE:1;			// 7:7   DSP_TASK_INT12 is Active
	uint32_t	IRQ200_IS_ACTIVE:1;			// 8:8   DSP_TASK_INT13 is Active
	uint32_t	IRQ201_IS_ACTIVE:1;			// 9:9   DSP_TASK_INT14 is Active
	uint32_t	IRQ202_IS_ACTIVE:1;			// 10:10   DSP_TASK_INT15 is Active
	uint32_t	IRQ203_IS_ACTIVE:1;			// 11:11   DSP_TASK_INT16 is Active
	uint32_t	IRQ204_IS_ACTIVE:1;			// 12:12   DSP_TASK_INT17 is Active
	uint32_t	IRQ205_IS_ACTIVE:1;			// 13:13   DSP_TASK_INT18 is Active
	uint32_t	IRQ206_IS_ACTIVE:1;			// 14:14   DSP_TASK_INT19 is Active
	uint32_t	IRQ207_IS_ACTIVE:1;			// 15:15   DSP_TASK_INT20 is Active
	uint32_t	IRQ208_IS_ACTIVE:1;			// 16:16   DSP_TASK_INT21 is Active
	uint32_t	IRQ209_IS_ACTIVE:1;			// 17:17   DSP_TASK_INT22 is Active
	uint32_t	IRQ210_IS_ACTIVE:1;			// 18:18   DSP_TASK_INT23 is Active
	uint32_t	IRQ211_IS_ACTIVE:1;			// 19:19   DSP_TASK_INT24 is Active
	uint32_t	IRQ212_IS_ACTIVE:1;			// 20:20   DSP_TASK_INT25 is Active
	uint32_t	IRQ213_IS_ACTIVE:1;			// 21:21   DSP_TASK_INT26 is Active
	uint32_t	IRQ214_IS_ACTIVE:1;			// 22:22   DSP_TASK_INT27 is Active
	uint32_t	IRQ215_IS_ACTIVE:1;			// 23:23   DSP_TASK_INT28 is Active
	uint32_t	IRQ216_IS_ACTIVE:1;			// 24:24   DSP_TASK_INT29 is Active
	uint32_t	IRQ217_IS_ACTIVE:1;			// 25:25   DSP_TASK_INT30 is Active
	uint32_t	IRQ218_IS_ACTIVE:1;			// 26:26   DSP_TASK_INT31 is Active
	uint32_t	IRQ219_IS_ACTIVE:1;			// 27:27   DLM_ECC_SBERR is Active
	uint32_t	IRQ220_IS_ACTIVE:1;			// 28:28   ILM_ECC_SBERR is Active
	uint32_t	IRQ221_IS_ACTIVE:1;			// 29:29   |GS_RAM_RD_ERR is Active
	uint32_t	IRQ222_IS_ACTIVE:1;			// 30:30   |CCM_RAM_RD_ERR is Active
	uint32_t	IRQ223_IS_ACTIVE:1;			// 31:31   EFC_SEC_INTR is Active
};

union IABR6_REG {
	uint32_t 		 all;
	struct IABR6_BITS 		 bit;
};

struct IABR7_BITS {			// bits   description
	uint32_t	IRQ224_IS_ACTIVE:1;			// 0:0   EFC_DONE_INTR is Active
	uint32_t	IRQ225_IS_ACTIVE:1;			// 1:1   EFC_INTR is Active
	uint32_t	IRQ226_IS_ACTIVE:1;			// 2:2   IBUS_IRQ is Active
	uint32_t	IRQ227_IS_ACTIVE:1;			// 3:3   DBUS_IRQ is Active
	uint32_t	IRQ228_IS_ACTIVE:1;			// 4:4   RTOSINT2 is Active
	uint32_t	IRQ229_IS_ACTIVE:1;			// 5:5   RTOSINT1 is Active
	uint32_t	IRQ230_IS_ACTIVE:1;			// 6:6   LSE_CLOCK_FAIL_INT is Active
	uint32_t	IRQ231_IS_ACTIVE:1;			// 7:7   ~PLL_LOCK is Active
	uint32_t	IRQ232_IS_ACTIVE:1;			// 8:8   PMBUS_ALERT is Active
	uint32_t	IRQ233_IS_ACTIVE:1;			// 9:9   DSP_EXCP_INT0TRACE_EXCP0 is Active
	uint32_t	IRQ234_IS_ACTIVE:1;			// 10:10   DSP_EXCP_INT1TRACE_EXCP1 is Active
	uint32_t	IRQ235_IS_ACTIVE:1;			// 11:11   DSP_EXCP_INT2TRACE_EXCP2 is Active
	uint32_t	IRQ236_IS_ACTIVE:1;			// 12:12   DSP_EXCP_INT3TRACE_EXCP3 is Active
	uint32_t	IRQ237_IS_ACTIVE:1;			// 13:13   DSP_EXCP_INT4TRACE_EXCP4|TRACE_EXCP6 is Active
	uint32_t	IRQ238_IS_ACTIVE:1;			// 14:14   DSP_EXCP_INT5TRACE_EXCP5|7|13|15 is Active
	uint32_t	IRQ239_IS_ACTIVE:1;			// 15:15   DSP_EXCP_INT6TRACE_EXCP11 is Active
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union IABR7_REG {
	uint32_t 		 all;
	struct IABR7_BITS 		 bit;
};

struct IP0_BITS {			// bits   description
	uint8_t	IRQ0_PRIORITY:8;			// 7:0   CAN1_HOST_IRQ Priority
};

union IP0_REG {
	uint8_t 		 all;
	struct IP0_BITS 		 bit;
};

struct IP1_BITS {			// bits   description
	uint8_t	IRQ1_PRIORITY:8;			// 7:0   CAN0_HOST_IRQ Priority
};

union IP1_REG {
	uint8_t 		 all;
	struct IP1_BITS 		 bit;
};

struct IP2_BITS {			// bits   description
	uint8_t	IRQ2_PRIORITY:8;			// 7:0   SPI1_INTR Priority
};

union IP2_REG {
	uint8_t 		 all;
	struct IP2_BITS 		 bit;
};

struct IP3_BITS {			// bits   description
	uint8_t	IRQ3_PRIORITY:8;			// 7:0   SPI0_INTR Priority
};

union IP3_REG {
	uint8_t 		 all;
	struct IP3_BITS 		 bit;
};

struct IP6_BITS {			// bits   description
	uint8_t	IRQ6_PRIORITY:8;			// 7:0   SCIB_INTR Priority
};

union IP6_REG {
	uint8_t 		 all;
	struct IP6_BITS 		 bit;
};

struct IP7_BITS {			// bits   description
	uint8_t	IRQ7_PRIORITY:8;			// 7:0   SCIA_INTR Priority
};

union IP7_REG {
	uint8_t 		 all;
	struct IP7_BITS 		 bit;
};

struct IP8_BITS {			// bits   description
	uint8_t	IRQ8_PRIORITY:8;			// 7:0   I2C2_INTR Priority
};

union IP8_REG {
	uint8_t 		 all;
	struct IP8_BITS 		 bit;
};

struct IP9_BITS {			// bits   description
	uint8_t	IRQ9_PRIORITY:8;			// 7:0   I2C1_INTR Priority
};

union IP9_REG {
	uint8_t 		 all;
	struct IP9_BITS 		 bit;
};

struct IP10_BITS {			// bits   description
	uint8_t	IRQ10_PRIORITY:8;			// 7:0   I2C0_INTR Priority
};

union IP10_REG {
	uint8_t 		 all;
	struct IP10_BITS 		 bit;
};

struct IP23_BITS {			// bits   description
	uint8_t	IRQ23_PRIORITY:8;			// 7:0   APB_GPIO3_CMBINTR Priority
};

union IP23_REG {
	uint8_t 		 all;
	struct IP23_BITS 		 bit;
};

struct IP24_BITS {			// bits   description
	uint8_t	IRQ24_PRIORITY:8;			// 7:0   APB_GPIO2_CMBINTR Priority
};

union IP24_REG {
	uint8_t 		 all;
	struct IP24_BITS 		 bit;
};

struct IP25_BITS {			// bits   description
	uint8_t	IRQ25_PRIORITY:8;			// 7:0   APB_GPIO1_CMBINTR Priority
};

union IP25_REG {
	uint8_t 		 all;
	struct IP25_BITS 		 bit;
};

struct IP26_BITS {			// bits   description
	uint8_t	IRQ26_PRIORITY:8;			// 7:0   APB_GPIO0_CMBINTR Priority
};

union IP26_REG {
	uint8_t 		 all;
	struct IP26_BITS 		 bit;
};

struct IP27_BITS {			// bits   description
	uint8_t	IRQ27_PRIORITY:8;			// 7:0   AP_TIMER_INTR3 Priority
};

union IP27_REG {
	uint8_t 		 all;
	struct IP27_BITS 		 bit;
};

struct IP28_BITS {			// bits   description
	uint8_t	IRQ28_PRIORITY:8;			// 7:0   AP_TIMER_INTR2 Priority
};

union IP28_REG {
	uint8_t 		 all;
	struct IP28_BITS 		 bit;
};

struct IP29_BITS {			// bits   description
	uint8_t	IRQ29_PRIORITY:8;			// 7:0   AP_TIMER_INTR1 Priority
};

union IP29_REG {
	uint8_t 		 all;
	struct IP29_BITS 		 bit;
};

struct IP30_BITS {			// bits   description
	uint8_t	IRQ30_PRIORITY:8;			// 7:0   AP_TIMER_INTR0 Priority
};

union IP30_REG {
	uint8_t 		 all;
	struct IP30_BITS 		 bit;
};

struct IP31_BITS {			// bits   description
	uint8_t	IRQ31_PRIORITY:8;			// 7:0   CRC_FAIL_INT Priority
};

union IP31_REG {
	uint8_t 		 all;
	struct IP31_BITS 		 bit;
};

struct IP32_BITS {			// bits   description
	uint8_t	IRQ32_PRIORITY:8;			// 7:0   CRC_DONE_INT Priority
};

union IP32_REG {
	uint8_t 		 all;
	struct IP32_BITS 		 bit;
};

struct IP33_BITS {			// bits   description
	uint8_t	IRQ33_PRIORITY:8;			// 7:0   LC3_INT_REQ Priority
};

union IP33_REG {
	uint8_t 		 all;
	struct IP33_BITS 		 bit;
};

struct IP34_BITS {			// bits   description
	uint8_t	IRQ34_PRIORITY:8;			// 7:0   LC2_INT_REQ Priority
};

union IP34_REG {
	uint8_t 		 all;
	struct IP34_BITS 		 bit;
};

struct IP35_BITS {			// bits   description
	uint8_t	IRQ35_PRIORITY:8;			// 7:0   LC1_INT_REQ Priority
};

union IP35_REG {
	uint8_t 		 all;
	struct IP35_BITS 		 bit;
};

struct IP36_BITS {			// bits   description
	uint8_t	IRQ36_PRIORITY:8;			// 7:0   EQEP2_INT Priority
};

union IP36_REG {
	uint8_t 		 all;
	struct IP36_BITS 		 bit;
};

struct IP37_BITS {			// bits   description
	uint8_t	IRQ37_PRIORITY:8;			// 7:0   EQEP1_INT Priority
};

union IP37_REG {
	uint8_t 		 all;
	struct IP37_BITS 		 bit;
};

struct IP38_BITS {			// bits   description
	uint8_t	IRQ38_PRIORITY:8;			// 7:0   ECAP2_HRCAL_INT Priority
};

union IP38_REG {
	uint8_t 		 all;
	struct IP38_BITS 		 bit;
};

struct IP39_BITS {			// bits   description
	uint8_t	IRQ39_PRIORITY:8;			// 7:0   ECAP1_HRCAL_INT Priority
};

union IP39_REG {
	uint8_t 		 all;
	struct IP39_BITS 		 bit;
};

struct IP40_BITS {			// bits   description
	uint8_t	IRQ40_PRIORITY:8;			// 7:0   ECAP7_INT Priority
};

union IP40_REG {
	uint8_t 		 all;
	struct IP40_BITS 		 bit;
};

struct IP41_BITS {			// bits   description
	uint8_t	IRQ41_PRIORITY:8;			// 7:0   ECAP6_INT Priority
};

union IP41_REG {
	uint8_t 		 all;
	struct IP41_BITS 		 bit;
};

struct IP42_BITS {			// bits   description
	uint8_t	IRQ42_PRIORITY:8;			// 7:0   ECAP5_INT Priority
};

union IP42_REG {
	uint8_t 		 all;
	struct IP42_BITS 		 bit;
};

struct IP43_BITS {			// bits   description
	uint8_t	IRQ43_PRIORITY:8;			// 7:0   ECAP4_INT Priority
};

union IP43_REG {
	uint8_t 		 all;
	struct IP43_BITS 		 bit;
};

struct IP44_BITS {			// bits   description
	uint8_t	IRQ44_PRIORITY:8;			// 7:0   ECAP3_INT Priority
};

union IP44_REG {
	uint8_t 		 all;
	struct IP44_BITS 		 bit;
};

struct IP45_BITS {			// bits   description
	uint8_t	IRQ45_PRIORITY:8;			// 7:0   ECAP2_INT Priority
};

union IP45_REG {
	uint8_t 		 all;
	struct IP45_BITS 		 bit;
};

struct IP46_BITS {			// bits   description
	uint8_t	IRQ46_PRIORITY:8;			// 7:0   ECAP1_INT Priority
};

union IP46_REG {
	uint8_t 		 all;
	struct IP46_BITS 		 bit;
};

struct IP47_BITS {			// bits   description
	uint8_t	IRQ47_PRIORITY:8;			// 7:0   CPU_16XINT Priority
};

union IP47_REG {
	uint8_t 		 all;
	struct IP47_BITS 		 bit;
};

struct IP48_BITS {			// bits   description
	uint8_t	IRQ48_PRIORITY:8;			// 7:0   CPU_15XINT Priority
};

union IP48_REG {
	uint8_t 		 all;
	struct IP48_BITS 		 bit;
};

struct IP49_BITS {			// bits   description
	uint8_t	IRQ49_PRIORITY:8;			// 7:0   CPU_14XINT Priority
};

union IP49_REG {
	uint8_t 		 all;
	struct IP49_BITS 		 bit;
};

struct IP50_BITS {			// bits   description
	uint8_t	IRQ50_PRIORITY:8;			// 7:0   CPU_13XINT Priority
};

union IP50_REG {
	uint8_t 		 all;
	struct IP50_BITS 		 bit;
};

struct IP51_BITS {			// bits   description
	uint8_t	IRQ51_PRIORITY:8;			// 7:0   CPU_12XINT Priority
};

union IP51_REG {
	uint8_t 		 all;
	struct IP51_BITS 		 bit;
};

struct IP52_BITS {			// bits   description
	uint8_t	IRQ52_PRIORITY:8;			// 7:0   CPU_11XINT Priority
};

union IP52_REG {
	uint8_t 		 all;
	struct IP52_BITS 		 bit;
};

struct IP53_BITS {			// bits   description
	uint8_t	IRQ53_PRIORITY:8;			// 7:0   CPU_10XINT Priority
};

union IP53_REG {
	uint8_t 		 all;
	struct IP53_BITS 		 bit;
};

struct IP54_BITS {			// bits   description
	uint8_t	IRQ54_PRIORITY:8;			// 7:0   CPU_9XINT Priority
};

union IP54_REG {
	uint8_t 		 all;
	struct IP54_BITS 		 bit;
};

struct IP55_BITS {			// bits   description
	uint8_t	IRQ55_PRIORITY:8;			// 7:0   CPU_8XINT Priority
};

union IP55_REG {
	uint8_t 		 all;
	struct IP55_BITS 		 bit;
};

struct IP56_BITS {			// bits   description
	uint8_t	IRQ56_PRIORITY:8;			// 7:0   CPU_7XINT Priority
};

union IP56_REG {
	uint8_t 		 all;
	struct IP56_BITS 		 bit;
};

struct IP57_BITS {			// bits   description
	uint8_t	IRQ57_PRIORITY:8;			// 7:0   CPU_6XINT Priority
};

union IP57_REG {
	uint8_t 		 all;
	struct IP57_BITS 		 bit;
};

struct IP58_BITS {			// bits   description
	uint8_t	IRQ58_PRIORITY:8;			// 7:0   CPU_5XINT Priority
};

union IP58_REG {
	uint8_t 		 all;
	struct IP58_BITS 		 bit;
};

struct IP59_BITS {			// bits   description
	uint8_t	IRQ59_PRIORITY:8;			// 7:0   CPU_4XINT Priority
};

union IP59_REG {
	uint8_t 		 all;
	struct IP59_BITS 		 bit;
};

struct IP60_BITS {			// bits   description
	uint8_t	IRQ60_PRIORITY:8;			// 7:0   CPU_3XINT Priority
};

union IP60_REG {
	uint8_t 		 all;
	struct IP60_BITS 		 bit;
};

struct IP61_BITS {			// bits   description
	uint8_t	IRQ61_PRIORITY:8;			// 7:0   CPU_2XINT Priority
};

union IP61_REG {
	uint8_t 		 all;
	struct IP61_BITS 		 bit;
};

struct IP62_BITS {			// bits   description
	uint8_t	IRQ62_PRIORITY:8;			// 7:0   CPU_1XINT Priority
};

union IP62_REG {
	uint8_t 		 all;
	struct IP62_BITS 		 bit;
};

struct IP63_BITS {			// bits   description
	uint8_t	IRQ63_PRIORITY:8;			// 7:0   TZ12_INTERRUPT Priority
};

union IP63_REG {
	uint8_t 		 all;
	struct IP63_BITS 		 bit;
};

struct IP64_BITS {			// bits   description
	uint8_t	IRQ64_PRIORITY:8;			// 7:0   TZ11_INTERRUPT Priority
};

union IP64_REG {
	uint8_t 		 all;
	struct IP64_BITS 		 bit;
};

struct IP65_BITS {			// bits   description
	uint8_t	IRQ65_PRIORITY:8;			// 7:0   TZ10_INTERRUPT Priority
};

union IP65_REG {
	uint8_t 		 all;
	struct IP65_BITS 		 bit;
};

struct IP66_BITS {			// bits   description
	uint8_t	IRQ66_PRIORITY:8;			// 7:0   TZ9_INTERRUPT Priority
};

union IP66_REG {
	uint8_t 		 all;
	struct IP66_BITS 		 bit;
};

struct IP67_BITS {			// bits   description
	uint8_t	IRQ67_PRIORITY:8;			// 7:0   TZ8_INTERRUPT Priority
};

union IP67_REG {
	uint8_t 		 all;
	struct IP67_BITS 		 bit;
};

struct IP68_BITS {			// bits   description
	uint8_t	IRQ68_PRIORITY:8;			// 7:0   TZ7_INTERRUPT Priority
};

union IP68_REG {
	uint8_t 		 all;
	struct IP68_BITS 		 bit;
};

struct IP69_BITS {			// bits   description
	uint8_t	IRQ69_PRIORITY:8;			// 7:0   TZ6_INTERRUPT Priority
};

union IP69_REG {
	uint8_t 		 all;
	struct IP69_BITS 		 bit;
};

struct IP70_BITS {			// bits   description
	uint8_t	IRQ70_PRIORITY:8;			// 7:0   TZ5_INTERRUPT Priority
};

union IP70_REG {
	uint8_t 		 all;
	struct IP70_BITS 		 bit;
};

struct IP71_BITS {			// bits   description
	uint8_t	IRQ71_PRIORITY:8;			// 7:0   TZ4_INTERRUPT Priority
};

union IP71_REG {
	uint8_t 		 all;
	struct IP71_BITS 		 bit;
};

struct IP72_BITS {			// bits   description
	uint8_t	IRQ72_PRIORITY:8;			// 7:0   TZ3_INTERRUPT Priority
};

union IP72_REG {
	uint8_t 		 all;
	struct IP72_BITS 		 bit;
};

struct IP73_BITS {			// bits   description
	uint8_t	IRQ73_PRIORITY:8;			// 7:0   TZ2_INTERRUPT Priority
};

union IP73_REG {
	uint8_t 		 all;
	struct IP73_BITS 		 bit;
};

struct IP74_BITS {			// bits   description
	uint8_t	IRQ74_PRIORITY:8;			// 7:0   TZ1_INTERRUPT Priority
};

union IP74_REG {
	uint8_t 		 all;
	struct IP74_BITS 		 bit;
};

struct IP75_BITS {			// bits   description
	uint8_t	IRQ75_PRIORITY:8;			// 7:0   EPWM12XINT Priority
};

union IP75_REG {
	uint8_t 		 all;
	struct IP75_BITS 		 bit;
};

struct IP76_BITS {			// bits   description
	uint8_t	IRQ76_PRIORITY:8;			// 7:0   EPWM11XINT Priority
};

union IP76_REG {
	uint8_t 		 all;
	struct IP76_BITS 		 bit;
};

struct IP77_BITS {			// bits   description
	uint8_t	IRQ77_PRIORITY:8;			// 7:0   EPWM10XINT Priority
};

union IP77_REG {
	uint8_t 		 all;
	struct IP77_BITS 		 bit;
};

struct IP78_BITS {			// bits   description
	uint8_t	IRQ78_PRIORITY:8;			// 7:0   EPWM9XINT Priority
};

union IP78_REG {
	uint8_t 		 all;
	struct IP78_BITS 		 bit;
};

struct IP79_BITS {			// bits   description
	uint8_t	IRQ79_PRIORITY:8;			// 7:0   EPWM8XINT Priority
};

union IP79_REG {
	uint8_t 		 all;
	struct IP79_BITS 		 bit;
};

struct IP80_BITS {			// bits   description
	uint8_t	IRQ80_PRIORITY:8;			// 7:0   EPWM7XINT Priority
};

union IP80_REG {
	uint8_t 		 all;
	struct IP80_BITS 		 bit;
};

struct IP81_BITS {			// bits   description
	uint8_t	IRQ81_PRIORITY:8;			// 7:0   EPWM6XINT Priority
};

union IP81_REG {
	uint8_t 		 all;
	struct IP81_BITS 		 bit;
};

struct IP82_BITS {			// bits   description
	uint8_t	IRQ82_PRIORITY:8;			// 7:0   EPWM5XINT Priority
};

union IP82_REG {
	uint8_t 		 all;
	struct IP82_BITS 		 bit;
};

struct IP83_BITS {			// bits   description
	uint8_t	IRQ83_PRIORITY:8;			// 7:0   EPWM4XINT Priority
};

union IP83_REG {
	uint8_t 		 all;
	struct IP83_BITS 		 bit;
};

struct IP84_BITS {			// bits   description
	uint8_t	IRQ84_PRIORITY:8;			// 7:0   EPWM3XINT Priority
};

union IP84_REG {
	uint8_t 		 all;
	struct IP84_BITS 		 bit;
};

struct IP85_BITS {			// bits   description
	uint8_t	IRQ85_PRIORITY:8;			// 7:0   EPWM2XINT Priority
};

union IP85_REG {
	uint8_t 		 all;
	struct IP85_BITS 		 bit;
};

struct IP86_BITS {			// bits   description
	uint8_t	IRQ86_PRIORITY:8;			// 7:0   EPWM1XINT Priority
};

union IP86_REG {
	uint8_t 		 all;
	struct IP86_BITS 		 bit;
};

struct IP87_BITS {			// bits   description
	uint8_t	IRQ87_PRIORITY:8;			// 7:0   QSPI_INTR Priority
};

union IP87_REG {
	uint8_t 		 all;
	struct IP87_BITS 		 bit;
};

struct IP88_BITS {			// bits   description
	uint8_t	IRQ88_PRIORITY:8;			// 7:0   DMA_INT_CH0_ISTATUSTFR Priority
};

union IP88_REG {
	uint8_t 		 all;
	struct IP88_BITS 		 bit;
};

struct IP89_BITS {			// bits   description
	uint8_t	IRQ89_PRIORITY:8;			// 7:0   DMA_INT_CH1_ISTATUSTFR Priority
};

union IP89_REG {
	uint8_t 		 all;
	struct IP89_BITS 		 bit;
};

struct IP90_BITS {			// bits   description
	uint8_t	IRQ90_PRIORITY:8;			// 7:0   DMA_INT_CH2_ISTATUSTFR Priority
};

union IP90_REG {
	uint8_t 		 all;
	struct IP90_BITS 		 bit;
};

struct IP91_BITS {			// bits   description
	uint8_t	IRQ91_PRIORITY:8;			// 7:0   DMA_INT_CH3_ISTATUSTFR Priority
};

union IP91_REG {
	uint8_t 		 all;
	struct IP91_BITS 		 bit;
};

struct IP92_BITS {			// bits   description
	uint8_t	IRQ92_PRIORITY:8;			// 7:0   DMA_INT_CH4_ISTATUSTFR Priority
};

union IP92_REG {
	uint8_t 		 all;
	struct IP92_BITS 		 bit;
};

struct IP93_BITS {			// bits   description
	uint8_t	IRQ93_PRIORITY:8;			// 7:0   DMA_INT_CH5_ISTATUSTFR Priority
};

union IP93_REG {
	uint8_t 		 all;
	struct IP93_BITS 		 bit;
};

struct IP94_BITS {			// bits   description
	uint8_t	IRQ94_PRIORITY:8;			// 7:0   DMA_INT_CH6_ISTATUSTFR Priority
};

union IP94_REG {
	uint8_t 		 all;
	struct IP94_BITS 		 bit;
};

struct IP95_BITS {			// bits   description
	uint8_t	IRQ95_PRIORITY:8;			// 7:0   DMA_INT_CH7_ISTATUSTFR Priority
};

union IP95_REG {
	uint8_t 		 all;
	struct IP95_BITS 		 bit;
};

struct IP96_BITS {			// bits   description
	uint8_t	IRQ96_PRIORITY:8;			// 7:0   DMA_INT_CH0_ISTATUSBLOCK Priority
};

union IP96_REG {
	uint8_t 		 all;
	struct IP96_BITS 		 bit;
};

struct IP97_BITS {			// bits   description
	uint8_t	IRQ97_PRIORITY:8;			// 7:0   DMA_INT_CH1_ISTATUSBLOCK Priority
};

union IP97_REG {
	uint8_t 		 all;
	struct IP97_BITS 		 bit;
};

struct IP98_BITS {			// bits   description
	uint8_t	IRQ98_PRIORITY:8;			// 7:0   DMA_INT_CH2_ISTATUSBLOCK Priority
};

union IP98_REG {
	uint8_t 		 all;
	struct IP98_BITS 		 bit;
};

struct IP99_BITS {			// bits   description
	uint8_t	IRQ99_PRIORITY:8;			// 7:0   DMA_INT_CH3_ISTATUSBLOCK Priority
};

union IP99_REG {
	uint8_t 		 all;
	struct IP99_BITS 		 bit;
};

struct IP100_BITS {			// bits   description
	uint8_t	IRQ100_PRIORITY:8;			// 7:0   DMA_INT_CH4_ISTATUSBLOCK Priority
};

union IP100_REG {
	uint8_t 		 all;
	struct IP100_BITS 		 bit;
};

struct IP101_BITS {			// bits   description
	uint8_t	IRQ101_PRIORITY:8;			// 7:0   DMA_INT_CH5_ISTATUSBLOCK Priority
};

union IP101_REG {
	uint8_t 		 all;
	struct IP101_BITS 		 bit;
};

struct IP102_BITS {			// bits   description
	uint8_t	IRQ102_PRIORITY:8;			// 7:0   DMA_INT_CH6_ISTATUSBLOCK Priority
};

union IP102_REG {
	uint8_t 		 all;
	struct IP102_BITS 		 bit;
};

struct IP103_BITS {			// bits   description
	uint8_t	IRQ103_PRIORITY:8;			// 7:0   DMA_INT_CH7_ISTATUSBLOCK Priority
};

union IP103_REG {
	uint8_t 		 all;
	struct IP103_BITS 		 bit;
};

struct IP104_BITS {			// bits   description
	uint8_t	IRQ104_PRIORITY:8;			// 7:0   DMA_INT_CH0_ISTATUSSRCTRAN Priority
};

union IP104_REG {
	uint8_t 		 all;
	struct IP104_BITS 		 bit;
};

struct IP105_BITS {			// bits   description
	uint8_t	IRQ105_PRIORITY:8;			// 7:0   DMA_INT_CH1_ISTATUSSRCTRAN Priority
};

union IP105_REG {
	uint8_t 		 all;
	struct IP105_BITS 		 bit;
};

struct IP106_BITS {			// bits   description
	uint8_t	IRQ106_PRIORITY:8;			// 7:0   DMA_INT_CH2_ISTATUSSRCTRAN Priority
};

union IP106_REG {
	uint8_t 		 all;
	struct IP106_BITS 		 bit;
};

struct IP107_BITS {			// bits   description
	uint8_t	IRQ107_PRIORITY:8;			// 7:0   DMA_INT_CH3_ISTATUSSRCTRAN Priority
};

union IP107_REG {
	uint8_t 		 all;
	struct IP107_BITS 		 bit;
};

struct IP108_BITS {			// bits   description
	uint8_t	IRQ108_PRIORITY:8;			// 7:0   DMA_INT_CH4_ISTATUSSRCTRAN Priority
};

union IP108_REG {
	uint8_t 		 all;
	struct IP108_BITS 		 bit;
};

struct IP109_BITS {			// bits   description
	uint8_t	IRQ109_PRIORITY:8;			// 7:0   DMA_INT_CH5_ISTATUSSRCTRAN Priority
};

union IP109_REG {
	uint8_t 		 all;
	struct IP109_BITS 		 bit;
};

struct IP110_BITS {			// bits   description
	uint8_t	IRQ110_PRIORITY:8;			// 7:0   DMA_INT_CH6_ISTATUSSRCTRAN Priority
};

union IP110_REG {
	uint8_t 		 all;
	struct IP110_BITS 		 bit;
};

struct IP111_BITS {			// bits   description
	uint8_t	IRQ111_PRIORITY:8;			// 7:0   DMA_INT_CH7_ISTATUSSRCTRAN Priority
};

union IP111_REG {
	uint8_t 		 all;
	struct IP111_BITS 		 bit;
};

struct IP112_BITS {			// bits   description
	uint8_t	IRQ112_PRIORITY:8;			// 7:0   DMA_INT_CH0_ISTATUSDSTTRAN Priority
};

union IP112_REG {
	uint8_t 		 all;
	struct IP112_BITS 		 bit;
};

struct IP113_BITS {			// bits   description
	uint8_t	IRQ113_PRIORITY:8;			// 7:0   DMA_INT_CH1_ISTATUSDSTTRAN Priority
};

union IP113_REG {
	uint8_t 		 all;
	struct IP113_BITS 		 bit;
};

struct IP114_BITS {			// bits   description
	uint8_t	IRQ114_PRIORITY:8;			// 7:0   DMA_INT_CH2_ISTATUSDSTTRAN Priority
};

union IP114_REG {
	uint8_t 		 all;
	struct IP114_BITS 		 bit;
};

struct IP115_BITS {			// bits   description
	uint8_t	IRQ115_PRIORITY:8;			// 7:0   DMA_INT_CH3_ISTATUSDSTTRAN Priority
};

union IP115_REG {
	uint8_t 		 all;
	struct IP115_BITS 		 bit;
};

struct IP116_BITS {			// bits   description
	uint8_t	IRQ116_PRIORITY:8;			// 7:0   DMA_INT_CH4_ISTATUSDSTTRAN Priority
};

union IP116_REG {
	uint8_t 		 all;
	struct IP116_BITS 		 bit;
};

struct IP117_BITS {			// bits   description
	uint8_t	IRQ117_PRIORITY:8;			// 7:0   DMA_INT_CH5_ISTATUSDSTTRAN Priority
};

union IP117_REG {
	uint8_t 		 all;
	struct IP117_BITS 		 bit;
};

struct IP118_BITS {			// bits   description
	uint8_t	IRQ118_PRIORITY:8;			// 7:0   DMA_INT_CH6_ISTATUSDSTTRAN Priority
};

union IP118_REG {
	uint8_t 		 all;
	struct IP118_BITS 		 bit;
};

struct IP119_BITS {			// bits   description
	uint8_t	IRQ119_PRIORITY:8;			// 7:0   DMA_INT_CH7_ISTATUSDSTTRAN Priority
};

union IP119_REG {
	uint8_t 		 all;
	struct IP119_BITS 		 bit;
};

struct IP120_BITS {			// bits   description
	uint8_t	IRQ120_PRIORITY:8;			// 7:0   DMA_INT_CH0_ISTATUSERR Priority
};

union IP120_REG {
	uint8_t 		 all;
	struct IP120_BITS 		 bit;
};

struct IP121_BITS {			// bits   description
	uint8_t	IRQ121_PRIORITY:8;			// 7:0   DMA_INT_CH1_ISTATUSERR Priority
};

union IP121_REG {
	uint8_t 		 all;
	struct IP121_BITS 		 bit;
};

struct IP122_BITS {			// bits   description
	uint8_t	IRQ122_PRIORITY:8;			// 7:0   DMA_INT_CH2_ISTATUSERR Priority
};

union IP122_REG {
	uint8_t 		 all;
	struct IP122_BITS 		 bit;
};

struct IP123_BITS {			// bits   description
	uint8_t	IRQ123_PRIORITY:8;			// 7:0   DMA_INT_CH3_ISTATUSERR Priority
};

union IP123_REG {
	uint8_t 		 all;
	struct IP123_BITS 		 bit;
};

struct IP124_BITS {			// bits   description
	uint8_t	IRQ124_PRIORITY:8;			// 7:0   DMA_INT_CH4_ISTATUSERR Priority
};

union IP124_REG {
	uint8_t 		 all;
	struct IP124_BITS 		 bit;
};

struct IP125_BITS {			// bits   description
	uint8_t	IRQ125_PRIORITY:8;			// 7:0   DMA_INT_CH5_ISTATUSERR Priority
};

union IP125_REG {
	uint8_t 		 all;
	struct IP125_BITS 		 bit;
};

struct IP126_BITS {			// bits   description
	uint8_t	IRQ126_PRIORITY:8;			// 7:0   DMA_INT_CH6_ISTATUSERR Priority
};

union IP126_REG {
	uint8_t 		 all;
	struct IP126_BITS 		 bit;
};

struct IP127_BITS {			// bits   description
	uint8_t	IRQ127_PRIORITY:8;			// 7:0   DMA_INT_CH7_ISTATUSERR Priority
};

union IP127_REG {
	uint8_t 		 all;
	struct IP127_BITS 		 bit;
};

struct IP128_BITS {			// bits   description
	uint8_t	IRQ128_PRIORITY:8;			// 7:0   EXTI_INT0 Priority
};

union IP128_REG {
	uint8_t 		 all;
	struct IP128_BITS 		 bit;
};

struct IP129_BITS {			// bits   description
	uint8_t	IRQ129_PRIORITY:8;			// 7:0   EXTI_INT1 Priority
};

union IP129_REG {
	uint8_t 		 all;
	struct IP129_BITS 		 bit;
};

struct IP130_BITS {			// bits   description
	uint8_t	IRQ130_PRIORITY:8;			// 7:0   EXTI_INT2 Priority
};

union IP130_REG {
	uint8_t 		 all;
	struct IP130_BITS 		 bit;
};

struct IP131_BITS {			// bits   description
	uint8_t	IRQ131_PRIORITY:8;			// 7:0   EXTI_INT3 Priority
};

union IP131_REG {
	uint8_t 		 all;
	struct IP131_BITS 		 bit;
};

struct IP132_BITS {			// bits   description
	uint8_t	IRQ132_PRIORITY:8;			// 7:0   EXTI_INT4 Priority
};

union IP132_REG {
	uint8_t 		 all;
	struct IP132_BITS 		 bit;
};

struct IP133_BITS {			// bits   description
	uint8_t	IRQ133_PRIORITY:8;			// 7:0   EXTI_INT5 Priority
};

union IP133_REG {
	uint8_t 		 all;
	struct IP133_BITS 		 bit;
};

struct IP134_BITS {			// bits   description
	uint8_t	IRQ134_PRIORITY:8;			// 7:0   EXTI_INT6 Priority
};

union IP134_REG {
	uint8_t 		 all;
	struct IP134_BITS 		 bit;
};

struct IP135_BITS {			// bits   description
	uint8_t	IRQ135_PRIORITY:8;			// 7:0   EXTI_INT7 Priority
};

union IP135_REG {
	uint8_t 		 all;
	struct IP135_BITS 		 bit;
};

struct IP136_BITS {			// bits   description
	uint8_t	IRQ136_PRIORITY:8;			// 7:0   EXTI_INT8 Priority
};

union IP136_REG {
	uint8_t 		 all;
	struct IP136_BITS 		 bit;
};

struct IP137_BITS {			// bits   description
	uint8_t	IRQ137_PRIORITY:8;			// 7:0   EXTI_INT9 Priority
};

union IP137_REG {
	uint8_t 		 all;
	struct IP137_BITS 		 bit;
};

struct IP138_BITS {			// bits   description
	uint8_t	IRQ138_PRIORITY:8;			// 7:0   EXTI_INT10 Priority
};

union IP138_REG {
	uint8_t 		 all;
	struct IP138_BITS 		 bit;
};

struct IP139_BITS {			// bits   description
	uint8_t	IRQ139_PRIORITY:8;			// 7:0   EXTI_INT11 Priority
};

union IP139_REG {
	uint8_t 		 all;
	struct IP139_BITS 		 bit;
};

struct IP140_BITS {			// bits   description
	uint8_t	IRQ140_PRIORITY:8;			// 7:0   EXTI_INT12 Priority
};

union IP140_REG {
	uint8_t 		 all;
	struct IP140_BITS 		 bit;
};

struct IP141_BITS {			// bits   description
	uint8_t	IRQ141_PRIORITY:8;			// 7:0   EXTI_INT13 Priority
};

union IP141_REG {
	uint8_t 		 all;
	struct IP141_BITS 		 bit;
};

struct IP142_BITS {			// bits   description
	uint8_t	IRQ142_PRIORITY:8;			// 7:0   EXTI_INT14 Priority
};

union IP142_REG {
	uint8_t 		 all;
	struct IP142_BITS 		 bit;
};

struct IP143_BITS {			// bits   description
	uint8_t	IRQ143_PRIORITY:8;			// 7:0   EXTI_INT15 Priority
};

union IP143_REG {
	uint8_t 		 all;
	struct IP143_BITS 		 bit;
};

struct IP144_BITS {			// bits   description
	uint8_t	IRQ144_PRIORITY:8;			// 7:0   EXTI_INT16 Priority
};

union IP144_REG {
	uint8_t 		 all;
	struct IP144_BITS 		 bit;
};

struct IP145_BITS {			// bits   description
	uint8_t	IRQ145_PRIORITY:8;			// 7:0   EXTI_INT17 Priority
};

union IP145_REG {
	uint8_t 		 all;
	struct IP145_BITS 		 bit;
};

struct IP146_BITS {			// bits   description
	uint8_t	IRQ146_PRIORITY:8;			// 7:0   EXTI_INT18 Priority
};

union IP146_REG {
	uint8_t 		 all;
	struct IP146_BITS 		 bit;
};

struct IP147_BITS {			// bits   description
	uint8_t	IRQ147_PRIORITY:8;			// 7:0   EXTI_INT19 Priority
};

union IP147_REG {
	uint8_t 		 all;
	struct IP147_BITS 		 bit;
};

struct IP148_BITS {			// bits   description
	uint8_t	IRQ148_PRIORITY:8;			// 7:0   EXTI_INT20 Priority
};

union IP148_REG {
	uint8_t 		 all;
	struct IP148_BITS 		 bit;
};

struct IP149_BITS {			// bits   description
	uint8_t	IRQ149_PRIORITY:8;			// 7:0   EXTI_INT21 Priority
};

union IP149_REG {
	uint8_t 		 all;
	struct IP149_BITS 		 bit;
};

struct IP150_BITS {			// bits   description
	uint8_t	IRQ150_PRIORITY:8;			// 7:0   EXTI_INT22 Priority
};

union IP150_REG {
	uint8_t 		 all;
	struct IP150_BITS 		 bit;
};

struct IP151_BITS {			// bits   description
	uint8_t	IRQ151_PRIORITY:8;			// 7:0   EXTI_INT23 Priority
};

union IP151_REG {
	uint8_t 		 all;
	struct IP151_BITS 		 bit;
};

struct IP152_BITS {			// bits   description
	uint8_t	IRQ152_PRIORITY:8;			// 7:0   EXTI_INT24 Priority
};

union IP152_REG {
	uint8_t 		 all;
	struct IP152_BITS 		 bit;
};

struct IP153_BITS {			// bits   description
	uint8_t	IRQ153_PRIORITY:8;			// 7:0   EXTI_INT25 Priority
};

union IP153_REG {
	uint8_t 		 all;
	struct IP153_BITS 		 bit;
};

struct IP154_BITS {			// bits   description
	uint8_t	IRQ154_PRIORITY:8;			// 7:0   EXTI_INT26 Priority
};

union IP154_REG {
	uint8_t 		 all;
	struct IP154_BITS 		 bit;
};

struct IP155_BITS {			// bits   description
	uint8_t	IRQ155_PRIORITY:8;			// 7:0   EXTI_INT27 Priority
};

union IP155_REG {
	uint8_t 		 all;
	struct IP155_BITS 		 bit;
};

struct IP156_BITS {			// bits   description
	uint8_t	IRQ156_PRIORITY:8;			// 7:0   EXTI_INT28 Priority
};

union IP156_REG {
	uint8_t 		 all;
	struct IP156_BITS 		 bit;
};

struct IP157_BITS {			// bits   description
	uint8_t	IRQ157_PRIORITY:8;			// 7:0   EXTI_INT29 Priority
};

union IP157_REG {
	uint8_t 		 all;
	struct IP157_BITS 		 bit;
};

struct IP158_BITS {			// bits   description
	uint8_t	IRQ158_PRIORITY:8;			// 7:0   EXTI_INT30 Priority
};

union IP158_REG {
	uint8_t 		 all;
	struct IP158_BITS 		 bit;
};

struct IP159_BITS {			// bits   description
	uint8_t	IRQ159_PRIORITY:8;			// 7:0   EXTI_INT31 Priority
};

union IP159_REG {
	uint8_t 		 all;
	struct IP159_BITS 		 bit;
};

struct IP160_BITS {			// bits   description
	uint8_t	IRQ160_PRIORITY:8;			// 7:0   AP_SYSCTL_FPUSTA Priority
};

union IP160_REG {
	uint8_t 		 all;
	struct IP160_BITS 		 bit;
};

struct IP161_BITS {			// bits   description
	uint8_t	IRQ161_PRIORITY:8;			// 7:0   AP_SYSCTL_FPUSTA Priority
};

union IP161_REG {
	uint8_t 		 all;
	struct IP161_BITS 		 bit;
};

struct IP162_BITS {			// bits   description
	uint8_t	IRQ162_PRIORITY:8;			// 7:0   AP_SYSCTL_FPUSTA Priority
};

union IP162_REG {
	uint8_t 		 all;
	struct IP162_BITS 		 bit;
};

struct IP163_BITS {			// bits   description
	uint8_t	IRQ163_PRIORITY:8;			// 7:0   AP_SYSCTL_FPUSTA Priority
};

union IP163_REG {
	uint8_t 		 all;
	struct IP163_BITS 		 bit;
};

struct IP164_BITS {			// bits   description
	uint8_t	IRQ164_PRIORITY:8;			// 7:0   AP_SYSCTL_FPUSTA Priority
};

union IP164_REG {
	uint8_t 		 all;
	struct IP164_BITS 		 bit;
};

struct IP165_BITS {			// bits   description
	uint8_t	IRQ165_PRIORITY:8;			// 7:0   AP_SYSCTL_FPUSTA Priority
};

union IP165_REG {
	uint8_t 		 all;
	struct IP165_BITS 		 bit;
};

struct IP166_BITS {			// bits   description
	uint8_t	IRQ166_PRIORITY:8;			// 7:0   FP_NV_INT Priority
};

union IP166_REG {
	uint8_t 		 all;
	struct IP166_BITS 		 bit;
};

struct IP167_BITS {			// bits   description
	uint8_t	IRQ167_PRIORITY:8;			// 7:0   FP_DZ_INT Priority
};

union IP167_REG {
	uint8_t 		 all;
	struct IP167_BITS 		 bit;
};

struct IP168_BITS {			// bits   description
	uint8_t	IRQ168_PRIORITY:8;			// 7:0   FP_OF_INT Priority
};

union IP168_REG {
	uint8_t 		 all;
	struct IP168_BITS 		 bit;
};

struct IP169_BITS {			// bits   description
	uint8_t	IRQ169_PRIORITY:8;			// 7:0   FP_UF_INT Priority
};

union IP169_REG {
	uint8_t 		 all;
	struct IP169_BITS 		 bit;
};

struct IP170_BITS {			// bits   description
	uint8_t	IRQ170_PRIORITY:8;			// 7:0   AP_WDT_INTR Priority
};

union IP170_REG {
	uint8_t 		 all;
	struct IP170_BITS 		 bit;
};

struct IP171_BITS {			// bits   description
	uint8_t	IRQ171_PRIORITY:8;			// 7:0   ADCC_EVT_INT Priority
};

union IP171_REG {
	uint8_t 		 all;
	struct IP171_BITS 		 bit;
};

struct IP172_BITS {			// bits   description
	uint8_t	IRQ172_PRIORITY:8;			// 7:0   ADCB_EVT_INT Priority
};

union IP172_REG {
	uint8_t 		 all;
	struct IP172_BITS 		 bit;
};

struct IP173_BITS {			// bits   description
	uint8_t	IRQ173_PRIORITY:8;			// 7:0   ADCA_EVT_INT Priority
};

union IP173_REG {
	uint8_t 		 all;
	struct IP173_BITS 		 bit;
};

struct IP174_BITS {			// bits   description
	uint8_t	IRQ174_PRIORITY:8;			// 7:0   ADCC_4INT Priority
};

union IP174_REG {
	uint8_t 		 all;
	struct IP174_BITS 		 bit;
};

struct IP175_BITS {			// bits   description
	uint8_t	IRQ175_PRIORITY:8;			// 7:0   ADCC_3INT Priority
};

union IP175_REG {
	uint8_t 		 all;
	struct IP175_BITS 		 bit;
};

struct IP176_BITS {			// bits   description
	uint8_t	IRQ176_PRIORITY:8;			// 7:0   ADCC_2INT Priority
};

union IP176_REG {
	uint8_t 		 all;
	struct IP176_BITS 		 bit;
};

struct IP177_BITS {			// bits   description
	uint8_t	IRQ177_PRIORITY:8;			// 7:0   ADCC_1INT Priority
};

union IP177_REG {
	uint8_t 		 all;
	struct IP177_BITS 		 bit;
};

struct IP178_BITS {			// bits   description
	uint8_t	IRQ178_PRIORITY:8;			// 7:0   ADCB_4INT Priority
};

union IP178_REG {
	uint8_t 		 all;
	struct IP178_BITS 		 bit;
};

struct IP179_BITS {			// bits   description
	uint8_t	IRQ179_PRIORITY:8;			// 7:0   ADCB_3INT Priority
};

union IP179_REG {
	uint8_t 		 all;
	struct IP179_BITS 		 bit;
};

struct IP180_BITS {			// bits   description
	uint8_t	IRQ180_PRIORITY:8;			// 7:0   ADCB_2INT Priority
};

union IP180_REG {
	uint8_t 		 all;
	struct IP180_BITS 		 bit;
};

struct IP181_BITS {			// bits   description
	uint8_t	IRQ181_PRIORITY:8;			// 7:0   ADCB_1INT Priority
};

union IP181_REG {
	uint8_t 		 all;
	struct IP181_BITS 		 bit;
};

struct IP182_BITS {			// bits   description
	uint8_t	IRQ182_PRIORITY:8;			// 7:0   ADCA_4INT Priority
};

union IP182_REG {
	uint8_t 		 all;
	struct IP182_BITS 		 bit;
};

struct IP183_BITS {			// bits   description
	uint8_t	IRQ183_PRIORITY:8;			// 7:0   ADCA_3INT Priority
};

union IP183_REG {
	uint8_t 		 all;
	struct IP183_BITS 		 bit;
};

struct IP184_BITS {			// bits   description
	uint8_t	IRQ184_PRIORITY:8;			// 7:0   ADCA_2INT Priority
};

union IP184_REG {
	uint8_t 		 all;
	struct IP184_BITS 		 bit;
};

struct IP185_BITS {			// bits   description
	uint8_t	IRQ185_PRIORITY:8;			// 7:0   ADCA_1INT Priority
};

union IP185_REG {
	uint8_t 		 all;
	struct IP185_BITS 		 bit;
};

struct IP186_BITS {			// bits   description
	uint8_t	IRQ186_PRIORITY:8;			// 7:0   DSP_EVT_O Priority
};

union IP186_REG {
	uint8_t 		 all;
	struct IP186_BITS 		 bit;
};

struct IP187_BITS {			// bits   description
	uint8_t	IRQ187_PRIORITY:8;			// 7:0   DSP_TASK_INT0 Priority
};

union IP187_REG {
	uint8_t 		 all;
	struct IP187_BITS 		 bit;
};

struct IP188_BITS {			// bits   description
	uint8_t	IRQ188_PRIORITY:8;			// 7:0   DSP_TASK_INT1 Priority
};

union IP188_REG {
	uint8_t 		 all;
	struct IP188_BITS 		 bit;
};

struct IP189_BITS {			// bits   description
	uint8_t	IRQ189_PRIORITY:8;			// 7:0   DSP_TASK_INT2 Priority
};

union IP189_REG {
	uint8_t 		 all;
	struct IP189_BITS 		 bit;
};

struct IP190_BITS {			// bits   description
	uint8_t	IRQ190_PRIORITY:8;			// 7:0   DSP_TASK_INT3 Priority
};

union IP190_REG {
	uint8_t 		 all;
	struct IP190_BITS 		 bit;
};

struct IP191_BITS {			// bits   description
	uint8_t	IRQ191_PRIORITY:8;			// 7:0   DSP_TASK_INT4 Priority
};

union IP191_REG {
	uint8_t 		 all;
	struct IP191_BITS 		 bit;
};

struct IP192_BITS {			// bits   description
	uint8_t	IRQ192_PRIORITY:8;			// 7:0   DSP_TASK_INT5 Priority
};

union IP192_REG {
	uint8_t 		 all;
	struct IP192_BITS 		 bit;
};

struct IP193_BITS {			// bits   description
	uint8_t	IRQ193_PRIORITY:8;			// 7:0   DSP_TASK_INT6 Priority
};

union IP193_REG {
	uint8_t 		 all;
	struct IP193_BITS 		 bit;
};

struct IP194_BITS {			// bits   description
	uint8_t	IRQ194_PRIORITY:8;			// 7:0   DSP_TASK_INT7 Priority
};

union IP194_REG {
	uint8_t 		 all;
	struct IP194_BITS 		 bit;
};

struct IP195_BITS {			// bits   description
	uint8_t	IRQ195_PRIORITY:8;			// 7:0   DSP_TASK_INT8 Priority
};

union IP195_REG {
	uint8_t 		 all;
	struct IP195_BITS 		 bit;
};

struct IP196_BITS {			// bits   description
	uint8_t	IRQ196_PRIORITY:8;			// 7:0   DSP_TASK_INT9 Priority
};

union IP196_REG {
	uint8_t 		 all;
	struct IP196_BITS 		 bit;
};

struct IP197_BITS {			// bits   description
	uint8_t	IRQ197_PRIORITY:8;			// 7:0   DSP_TASK_INT10 Priority
};

union IP197_REG {
	uint8_t 		 all;
	struct IP197_BITS 		 bit;
};

struct IP198_BITS {			// bits   description
	uint8_t	IRQ198_PRIORITY:8;			// 7:0   DSP_TASK_INT11 Priority
};

union IP198_REG {
	uint8_t 		 all;
	struct IP198_BITS 		 bit;
};

struct IP199_BITS {			// bits   description
	uint8_t	IRQ199_PRIORITY:8;			// 7:0   DSP_TASK_INT12 Priority
};

union IP199_REG {
	uint8_t 		 all;
	struct IP199_BITS 		 bit;
};

struct IP200_BITS {			// bits   description
	uint8_t	IRQ200_PRIORITY:8;			// 7:0   DSP_TASK_INT13 Priority
};

union IP200_REG {
	uint8_t 		 all;
	struct IP200_BITS 		 bit;
};

struct IP201_BITS {			// bits   description
	uint8_t	IRQ201_PRIORITY:8;			// 7:0   DSP_TASK_INT14 Priority
};

union IP201_REG {
	uint8_t 		 all;
	struct IP201_BITS 		 bit;
};

struct IP202_BITS {			// bits   description
	uint8_t	IRQ202_PRIORITY:8;			// 7:0   DSP_TASK_INT15 Priority
};

union IP202_REG {
	uint8_t 		 all;
	struct IP202_BITS 		 bit;
};

struct IP203_BITS {			// bits   description
	uint8_t	IRQ203_PRIORITY:8;			// 7:0   DSP_TASK_INT16 Priority
};

union IP203_REG {
	uint8_t 		 all;
	struct IP203_BITS 		 bit;
};

struct IP204_BITS {			// bits   description
	uint8_t	IRQ204_PRIORITY:8;			// 7:0   DSP_TASK_INT17 Priority
};

union IP204_REG {
	uint8_t 		 all;
	struct IP204_BITS 		 bit;
};

struct IP205_BITS {			// bits   description
	uint8_t	IRQ205_PRIORITY:8;			// 7:0   DSP_TASK_INT18 Priority
};

union IP205_REG {
	uint8_t 		 all;
	struct IP205_BITS 		 bit;
};

struct IP206_BITS {			// bits   description
	uint8_t	IRQ206_PRIORITY:8;			// 7:0   DSP_TASK_INT19 Priority
};

union IP206_REG {
	uint8_t 		 all;
	struct IP206_BITS 		 bit;
};

struct IP207_BITS {			// bits   description
	uint8_t	IRQ207_PRIORITY:8;			// 7:0   DSP_TASK_INT20 Priority
};

union IP207_REG {
	uint8_t 		 all;
	struct IP207_BITS 		 bit;
};

struct IP208_BITS {			// bits   description
	uint8_t	IRQ208_PRIORITY:8;			// 7:0   DSP_TASK_INT21 Priority
};

union IP208_REG {
	uint8_t 		 all;
	struct IP208_BITS 		 bit;
};

struct IP209_BITS {			// bits   description
	uint8_t	IRQ209_PRIORITY:8;			// 7:0   DSP_TASK_INT22 Priority
};

union IP209_REG {
	uint8_t 		 all;
	struct IP209_BITS 		 bit;
};

struct IP210_BITS {			// bits   description
	uint8_t	IRQ210_PRIORITY:8;			// 7:0   DSP_TASK_INT23 Priority
};

union IP210_REG {
	uint8_t 		 all;
	struct IP210_BITS 		 bit;
};

struct IP211_BITS {			// bits   description
	uint8_t	IRQ211_PRIORITY:8;			// 7:0   DSP_TASK_INT24 Priority
};

union IP211_REG {
	uint8_t 		 all;
	struct IP211_BITS 		 bit;
};

struct IP212_BITS {			// bits   description
	uint8_t	IRQ212_PRIORITY:8;			// 7:0   DSP_TASK_INT25 Priority
};

union IP212_REG {
	uint8_t 		 all;
	struct IP212_BITS 		 bit;
};

struct IP213_BITS {			// bits   description
	uint8_t	IRQ213_PRIORITY:8;			// 7:0   DSP_TASK_INT26 Priority
};

union IP213_REG {
	uint8_t 		 all;
	struct IP213_BITS 		 bit;
};

struct IP214_BITS {			// bits   description
	uint8_t	IRQ214_PRIORITY:8;			// 7:0   DSP_TASK_INT27 Priority
};

union IP214_REG {
	uint8_t 		 all;
	struct IP214_BITS 		 bit;
};

struct IP215_BITS {			// bits   description
	uint8_t	IRQ215_PRIORITY:8;			// 7:0   DSP_TASK_INT28 Priority
};

union IP215_REG {
	uint8_t 		 all;
	struct IP215_BITS 		 bit;
};

struct IP216_BITS {			// bits   description
	uint8_t	IRQ216_PRIORITY:8;			// 7:0   DSP_TASK_INT29 Priority
};

union IP216_REG {
	uint8_t 		 all;
	struct IP216_BITS 		 bit;
};

struct IP217_BITS {			// bits   description
	uint8_t	IRQ217_PRIORITY:8;			// 7:0   DSP_TASK_INT30 Priority
};

union IP217_REG {
	uint8_t 		 all;
	struct IP217_BITS 		 bit;
};

struct IP218_BITS {			// bits   description
	uint8_t	IRQ218_PRIORITY:8;			// 7:0   DSP_TASK_INT31 Priority
};

union IP218_REG {
	uint8_t 		 all;
	struct IP218_BITS 		 bit;
};

struct IP219_BITS {			// bits   description
	uint8_t	IRQ219_PRIORITY:8;			// 7:0   DLM_ECC_SBERR Priority
};

union IP219_REG {
	uint8_t 		 all;
	struct IP219_BITS 		 bit;
};

struct IP220_BITS {			// bits   description
	uint8_t	IRQ220_PRIORITY:8;			// 7:0   ILM_ECC_SBERR Priority
};

union IP220_REG {
	uint8_t 		 all;
	struct IP220_BITS 		 bit;
};

struct IP221_BITS {			// bits   description
	uint8_t	IRQ221_PRIORITY:8;			// 7:0   |GS_RAM_RD_ERR Priority
};

union IP221_REG {
	uint8_t 		 all;
	struct IP221_BITS 		 bit;
};

struct IP222_BITS {			// bits   description
	uint8_t	IRQ222_PRIORITY:8;			// 7:0   |CCM_RAM_RD_ERR Priority
};

union IP222_REG {
	uint8_t 		 all;
	struct IP222_BITS 		 bit;
};

struct IP223_BITS {			// bits   description
	uint8_t	IRQ223_PRIORITY:8;			// 7:0   EFC_SEC_INTR Priority
};

union IP223_REG {
	uint8_t 		 all;
	struct IP223_BITS 		 bit;
};

struct IP224_BITS {			// bits   description
	uint8_t	IRQ224_PRIORITY:8;			// 7:0   EFC_DONE_INTR Priority
};

union IP224_REG {
	uint8_t 		 all;
	struct IP224_BITS 		 bit;
};

struct IP225_BITS {			// bits   description
	uint8_t	IRQ225_PRIORITY:8;			// 7:0   EFC_INTR Priority
};

union IP225_REG {
	uint8_t 		 all;
	struct IP225_BITS 		 bit;
};

struct IP226_BITS {			// bits   description
	uint8_t	IRQ226_PRIORITY:8;			// 7:0   IBUS_IRQ Priority
};

union IP226_REG {
	uint8_t 		 all;
	struct IP226_BITS 		 bit;
};

struct IP227_BITS {			// bits   description
	uint8_t	IRQ227_PRIORITY:8;			// 7:0   DBUS_IRQ Priority
};

union IP227_REG {
	uint8_t 		 all;
	struct IP227_BITS 		 bit;
};

struct IP228_BITS {			// bits   description
	uint8_t	IRQ228_PRIORITY:8;			// 7:0   RTOSINT2 Priority
};

union IP228_REG {
	uint8_t 		 all;
	struct IP228_BITS 		 bit;
};

struct IP229_BITS {			// bits   description
	uint8_t	IRQ229_PRIORITY:8;			// 7:0   RTOSINT1 Priority
};

union IP229_REG {
	uint8_t 		 all;
	struct IP229_BITS 		 bit;
};

struct IP230_BITS {			// bits   description
	uint8_t	IRQ230_PRIORITY:8;			// 7:0   LSE_CLOCK_FAIL_INT Priority
};

union IP230_REG {
	uint8_t 		 all;
	struct IP230_BITS 		 bit;
};

struct IP231_BITS {			// bits   description
	uint8_t	IRQ231_PRIORITY:8;			// 7:0   ~PLL_LOCK Priority
};

union IP231_REG {
	uint8_t 		 all;
	struct IP231_BITS 		 bit;
};

struct IP232_BITS {			// bits   description
	uint8_t	IRQ232_PRIORITY:8;			// 7:0   PMBUS_ALERT Priority
};

union IP232_REG {
	uint8_t 		 all;
	struct IP232_BITS 		 bit;
};

struct IP233_BITS {			// bits   description
	uint8_t	IRQ233_PRIORITY:8;			// 7:0   DSP_EXCP_INT0TRACE_EXCP0 Priority
};

union IP233_REG {
	uint8_t 		 all;
	struct IP233_BITS 		 bit;
};

struct IP234_BITS {			// bits   description
	uint8_t	IRQ234_PRIORITY:8;			// 7:0   DSP_EXCP_INT1TRACE_EXCP1 Priority
};

union IP234_REG {
	uint8_t 		 all;
	struct IP234_BITS 		 bit;
};

struct IP235_BITS {			// bits   description
	uint8_t	IRQ235_PRIORITY:8;			// 7:0   DSP_EXCP_INT2TRACE_EXCP2 Priority
};

union IP235_REG {
	uint8_t 		 all;
	struct IP235_BITS 		 bit;
};

struct IP236_BITS {			// bits   description
	uint8_t	IRQ236_PRIORITY:8;			// 7:0   DSP_EXCP_INT3TRACE_EXCP3 Priority
};

union IP236_REG {
	uint8_t 		 all;
	struct IP236_BITS 		 bit;
};

struct IP237_BITS {			// bits   description
	uint8_t	IRQ237_PRIORITY:8;			// 7:0   DSP_EXCP_INT4TRACE_EXCP4|TRACE_EXCP6 Priority
};

union IP237_REG {
	uint8_t 		 all;
	struct IP237_BITS 		 bit;
};

struct IP238_BITS {			// bits   description
	uint8_t	IRQ238_PRIORITY:8;			// 7:0   DSP_EXCP_INT5TRACE_EXCP5|7|13|15 Priority
};

union IP238_REG {
	uint8_t 		 all;
	struct IP238_BITS 		 bit;
};

struct IP239_BITS {			// bits   description
	uint8_t	IRQ239_PRIORITY:8;			// 7:0   DSP_EXCP_INT6TRACE_EXCP11 Priority
};

union IP239_REG {
	uint8_t 		 all;
	struct IP239_BITS 		 bit;
};

struct STIR_BITS {			// bits   description
	uint32_t	INTID:9;			// 8:0   Software Trigger Interrupt Register
	uint32_t	rsvd1:23;			// 31:9   reserved
};

union STIR_REG {
	uint32_t 		 all;
	struct STIR_BITS 		 bit;
};


// NVIC Register Definitions:

struct NVIC_REGS {
	union  ISER0_REG			ISER0;
	union  ISER1_REG			ISER1;
	union  ISER2_REG			ISER2;
	union  ISER3_REG			ISER3;
	union  ISER4_REG			ISER4;
	union  ISER5_REG			ISER5;
	union  ISER6_REG			ISER6;
	union  ISER7_REG			ISER7;
	uint32_t 						rsvd1[24]; 		 // reserved
	union  ICER0_REG			ICER0;
	union  ICER1_REG			ICER1;
	union  ICER2_REG			ICER2;
	union  ICER3_REG			ICER3;
	union  ICER4_REG			ICER4;
	union  ICER5_REG			ICER5;
	union  ICER6_REG			ICER6;
	union  ICER7_REG			ICER7;
	uint32_t 						rsvd2[24]; 		 // reserved
	union  ISPR0_REG			ISPR0;
	union  ISPR1_REG			ISPR1;
	union  ISPR2_REG			ISPR2;
	union  ISPR3_REG			ISPR3;
	union  ISPR4_REG			ISPR4;
	union  ISPR5_REG			ISPR5;
	union  ISPR6_REG			ISPR6;
	union  ISPR7_REG			ISPR7;
	uint32_t 						rsvd3[24]; 		 // reserved
	union  ICPR0_REG			ICPR0;
	union  ICPR1_REG			ICPR1;
	union  ICPR2_REG			ICPR2;
	union  ICPR3_REG			ICPR3;
	union  ICPR4_REG			ICPR4;
	union  ICPR5_REG			ICPR5;
	union  ICPR6_REG			ICPR6;
	union  ICPR7_REG			ICPR7;
	uint32_t 						rsvd4[24]; 		 // reserved
	union  IABR0_REG			IABR0;
	union  IABR1_REG			IABR1;
	union  IABR2_REG			IABR2;
	union  IABR3_REG			IABR3;
	union  IABR4_REG			IABR4;
	union  IABR5_REG			IABR5;
	union  IABR6_REG			IABR6;
	union  IABR7_REG			IABR7;
	uint32_t 						rsvd5[56]; 		 // reserved
	union  IP0_REG			IP0;
	union  IP1_REG			IP1;
	union  IP2_REG			IP2;
	union  IP3_REG			IP3;
	uint8_t 						rsvd6[2]; 		 // reserved
	union  IP6_REG			IP6;
	union  IP7_REG			IP7;
	union  IP8_REG			IP8;
	union  IP9_REG			IP9;
	union  IP10_REG			IP10;
	uint8_t 						rsvd7[12]; 		 // reserved
	union  IP23_REG			IP23;
	union  IP24_REG			IP24;
	union  IP25_REG			IP25;
	union  IP26_REG			IP26;
	union  IP27_REG			IP27;
	union  IP28_REG			IP28;
	union  IP29_REG			IP29;
	union  IP30_REG			IP30;
	union  IP31_REG			IP31;
	union  IP32_REG			IP32;
	union  IP33_REG			IP33;
	union  IP34_REG			IP34;
	union  IP35_REG			IP35;
	union  IP36_REG			IP36;
	union  IP37_REG			IP37;
	union  IP38_REG			IP38;
	union  IP39_REG			IP39;
	union  IP40_REG			IP40;
	union  IP41_REG			IP41;
	union  IP42_REG			IP42;
	union  IP43_REG			IP43;
	union  IP44_REG			IP44;
	union  IP45_REG			IP45;
	union  IP46_REG			IP46;
	union  IP47_REG			IP47;
	union  IP48_REG			IP48;
	union  IP49_REG			IP49;
	union  IP50_REG			IP50;
	union  IP51_REG			IP51;
	union  IP52_REG			IP52;
	union  IP53_REG			IP53;
	union  IP54_REG			IP54;
	union  IP55_REG			IP55;
	union  IP56_REG			IP56;
	union  IP57_REG			IP57;
	union  IP58_REG			IP58;
	union  IP59_REG			IP59;
	union  IP60_REG			IP60;
	union  IP61_REG			IP61;
	union  IP62_REG			IP62;
	union  IP63_REG			IP63;
	union  IP64_REG			IP64;
	union  IP65_REG			IP65;
	union  IP66_REG			IP66;
	union  IP67_REG			IP67;
	union  IP68_REG			IP68;
	union  IP69_REG			IP69;
	union  IP70_REG			IP70;
	union  IP71_REG			IP71;
	union  IP72_REG			IP72;
	union  IP73_REG			IP73;
	union  IP74_REG			IP74;
	union  IP75_REG			IP75;
	union  IP76_REG			IP76;
	union  IP77_REG			IP77;
	union  IP78_REG			IP78;
	union  IP79_REG			IP79;
	union  IP80_REG			IP80;
	union  IP81_REG			IP81;
	union  IP82_REG			IP82;
	union  IP83_REG			IP83;
	union  IP84_REG			IP84;
	union  IP85_REG			IP85;
	union  IP86_REG			IP86;
	union  IP87_REG			IP87;
	union  IP88_REG			IP88;
	union  IP89_REG			IP89;
	union  IP90_REG			IP90;
	union  IP91_REG			IP91;
	union  IP92_REG			IP92;
	union  IP93_REG			IP93;
	union  IP94_REG			IP94;
	union  IP95_REG			IP95;
	union  IP96_REG			IP96;
	union  IP97_REG			IP97;
	union  IP98_REG			IP98;
	union  IP99_REG			IP99;
	union  IP100_REG			IP100;
	union  IP101_REG			IP101;
	union  IP102_REG			IP102;
	union  IP103_REG			IP103;
	union  IP104_REG			IP104;
	union  IP105_REG			IP105;
	union  IP106_REG			IP106;
	union  IP107_REG			IP107;
	union  IP108_REG			IP108;
	union  IP109_REG			IP109;
	union  IP110_REG			IP110;
	union  IP111_REG			IP111;
	union  IP112_REG			IP112;
	union  IP113_REG			IP113;
	union  IP114_REG			IP114;
	union  IP115_REG			IP115;
	union  IP116_REG			IP116;
	union  IP117_REG			IP117;
	union  IP118_REG			IP118;
	union  IP119_REG			IP119;
	union  IP120_REG			IP120;
	union  IP121_REG			IP121;
	union  IP122_REG			IP122;
	union  IP123_REG			IP123;
	union  IP124_REG			IP124;
	union  IP125_REG			IP125;
	union  IP126_REG			IP126;
	union  IP127_REG			IP127;
	union  IP128_REG			IP128;
	union  IP129_REG			IP129;
	union  IP130_REG			IP130;
	union  IP131_REG			IP131;
	union  IP132_REG			IP132;
	union  IP133_REG			IP133;
	union  IP134_REG			IP134;
	union  IP135_REG			IP135;
	union  IP136_REG			IP136;
	union  IP137_REG			IP137;
	union  IP138_REG			IP138;
	union  IP139_REG			IP139;
	union  IP140_REG			IP140;
	union  IP141_REG			IP141;
	union  IP142_REG			IP142;
	union  IP143_REG			IP143;
	union  IP144_REG			IP144;
	union  IP145_REG			IP145;
	union  IP146_REG			IP146;
	union  IP147_REG			IP147;
	union  IP148_REG			IP148;
	union  IP149_REG			IP149;
	union  IP150_REG			IP150;
	union  IP151_REG			IP151;
	union  IP152_REG			IP152;
	union  IP153_REG			IP153;
	union  IP154_REG			IP154;
	union  IP155_REG			IP155;
	union  IP156_REG			IP156;
	union  IP157_REG			IP157;
	union  IP158_REG			IP158;
	union  IP159_REG			IP159;
	union  IP160_REG			IP160;
	union  IP161_REG			IP161;
	union  IP162_REG			IP162;
	union  IP163_REG			IP163;
	union  IP164_REG			IP164;
	union  IP165_REG			IP165;
	union  IP166_REG			IP166;
	union  IP167_REG			IP167;
	union  IP168_REG			IP168;
	union  IP169_REG			IP169;
	union  IP170_REG			IP170;
	union  IP171_REG			IP171;
	union  IP172_REG			IP172;
	union  IP173_REG			IP173;
	union  IP174_REG			IP174;
	union  IP175_REG			IP175;
	union  IP176_REG			IP176;
	union  IP177_REG			IP177;
	union  IP178_REG			IP178;
	union  IP179_REG			IP179;
	union  IP180_REG			IP180;
	union  IP181_REG			IP181;
	union  IP182_REG			IP182;
	union  IP183_REG			IP183;
	union  IP184_REG			IP184;
	union  IP185_REG			IP185;
	union  IP186_REG			IP186;
	union  IP187_REG			IP187;
	union  IP188_REG			IP188;
	union  IP189_REG			IP189;
	union  IP190_REG			IP190;
	union  IP191_REG			IP191;
	union  IP192_REG			IP192;
	union  IP193_REG			IP193;
	union  IP194_REG			IP194;
	union  IP195_REG			IP195;
	union  IP196_REG			IP196;
	union  IP197_REG			IP197;
	union  IP198_REG			IP198;
	union  IP199_REG			IP199;
	union  IP200_REG			IP200;
	union  IP201_REG			IP201;
	union  IP202_REG			IP202;
	union  IP203_REG			IP203;
	union  IP204_REG			IP204;
	union  IP205_REG			IP205;
	union  IP206_REG			IP206;
	union  IP207_REG			IP207;
	union  IP208_REG			IP208;
	union  IP209_REG			IP209;
	union  IP210_REG			IP210;
	union  IP211_REG			IP211;
	union  IP212_REG			IP212;
	union  IP213_REG			IP213;
	union  IP214_REG			IP214;
	union  IP215_REG			IP215;
	union  IP216_REG			IP216;
	union  IP217_REG			IP217;
	union  IP218_REG			IP218;
	union  IP219_REG			IP219;
	union  IP220_REG			IP220;
	union  IP221_REG			IP221;
	union  IP222_REG			IP222;
	union  IP223_REG			IP223;
	union  IP224_REG			IP224;
	union  IP225_REG			IP225;
	union  IP226_REG			IP226;
	union  IP227_REG			IP227;
	union  IP228_REG			IP228;
	union  IP229_REG			IP229;
	union  IP230_REG			IP230;
	union  IP231_REG			IP231;
	union  IP232_REG			IP232;
	union  IP233_REG			IP233;
	union  IP234_REG			IP234;
	union  IP235_REG			IP235;
	union  IP236_REG			IP236;
	union  IP237_REG			IP237;
	union  IP238_REG			IP238;
	union  IP239_REG			IP239;
};

struct NVIC_STIR_REGS {
	union  STIR_REG			STIR;
};

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// NVIC External References & Function Declarations

extern volatile struct NVIC_REGS NVICRegs;
extern volatile struct NVIC_STIR_REGS NVICSTIRRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_NVIC_H definition
