/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    regs_ptr.h
*   @brief   
*
*/

#ifndef COMMON_REGS_PTR_H_
#define COMMON_REGS_PTR_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "inc/hw_types.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */
extern volatile struct ADC_REGS * const AdcaRegsPtr;
extern volatile struct ADC_REGS * const AdcbRegsPtr;
extern volatile struct ADC_REGS * const AdccRegsPtr;
#if IS_GS32F3xx()
extern volatile struct ADC_REGS * const AdcdRegsPtr;
#endif
extern volatile struct ADC_RESULT_REGS * const AdcaResultRegsPtr;
extern volatile struct ADC_RESULT_REGS * const AdcbResultRegsPtr;
extern volatile struct ADC_RESULT_REGS * const AdccResultRegsPtr;
#if IS_GS32F3xx()
extern volatile struct ADC_RESULT_REGS * const AdcdResultRegsPtr;
#endif

extern volatile struct EPWM_REGS * const EPwm1RegsPtr;
extern volatile struct EPWM_REGS * const EPwm2RegsPtr;
extern volatile struct EPWM_REGS * const EPwm3RegsPtr;
extern volatile struct EPWM_REGS * const EPwm4RegsPtr;
extern volatile struct EPWM_REGS * const EPwm5RegsPtr;
extern volatile struct EPWM_REGS * const EPwm6RegsPtr;
extern volatile struct EPWM_REGS * const EPwm7RegsPtr;
extern volatile struct EPWM_REGS * const EPwm8RegsPtr;
#if IS_GS32F3xx()
extern volatile struct EPWM_REGS * const EPwm9RegsPtr;
extern volatile struct EPWM_REGS * const EPwm10RegsPtr;
extern volatile struct EPWM_REGS * const EPwm11RegsPtr;
extern volatile struct EPWM_REGS * const EPwm12RegsPtr;
#endif

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */


#ifdef __cplusplus
}
#endif


#endif /* COMMON_DLOG_H_ */
