/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_qspi.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_QSPI_H
#define REGS_QSPI_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// QSPI Individual Register Bit Definitions:

struct CTRLR0_BITS {			// bits   description
	uint32_t	DFS:5;			// 4:0   Data Frame Size.
	uint32_t	FRF:2;			// 7:6    Frame Format.Selects which serial protocol transfers the data.
	uint32_t	SCPH:1;			// 8:8   Serial Clock Phase.Valid when the frame format (FRF) is set to Motorola SPI. 
	uint32_t	SCPOL:1;			// 9:9   Serial Clock Polarity.Valid when the frame format (FRF) is set to Motorola SPI. 
	uint32_t	TMOD:2;			// 11:10   Transfer Mode.
	uint32_t	SLV_OE:1;			// 12:12   Target Output Enable.Relevant only when the DWC_ssi is configured as a serial-target device. When configured
	uint32_t	SRL:1;			// 13:13   Shift Register Loop.Used for testing purposes only. When internally active, connects the transmit shift
	uint32_t	SSTE:1;			// 14:14   Target Select Toggle Enable.While operating in SPI mode with clock phase (SCPH) set to 0, this register
	uint32_t	CFS:4;			// 19:16   Control Frame Size.Selects the length of the control word for the Microwire frame format.
	uint32_t	SPI_FRF:2;			// 23:22   SPI Frame Format Selects data frame format for Transmitting/Receiving the data. Bits only valid when
	uint32_t	SPI_HYPERBUS_EN:1;			// 24:24    SPI Hyperbus Frame format enable.
	uint32_t	SPI_DWS_EN:1;			// 25:25   Enable Dynamic wait states in SPI mode of operation. This field is only applicable when CTRLR0.FRF is
	uint32_t	CLK_LOOP_EN:1;			// 26:26   Clock loop back enable bit. Once this bit is set to 1, DWC_ssi will use looped back clock (mst_sclk_in)
	uint32_t	SSI_IS_MST:1;			// 31:31   This field selects if DWC_ssi is working in Controller or Target mode
};

union CTRLR0_REG {
	uint32_t 		 all;
	struct CTRLR0_BITS 		 bit;
};

struct CTRLR1_BITS {			// bits   description
	uint32_t	NDF:16;			// 15:0   Number of Data Frames.
};

union CTRLR1_REG {
	uint32_t 		 all;
	struct CTRLR1_BITS 		 bit;
};

struct SSIENR_BITS {			// bits   description
	uint32_t	SSIC_EN:1;			// 0:0   SSI Enable.
};

union SSIENR_REG {
	uint32_t 		 all;
	struct SSIENR_BITS 		 bit;
};

struct MWCR_BITS {			// bits   description
	uint32_t	MWMOD:1;			// 0:0   Microwire Transfer Mode.
	uint32_t	MDD:1;			// 1:1   Microwire Control.
	uint32_t	MHS:1;			// 2:2   Microwire Handshaking.
};

union MWCR_REG {
	uint32_t 		 all;
	struct MWCR_BITS 		 bit;
};

struct SER_BITS {			// bits   description
	uint32_t	SER:1;			// 0:0   Chip Select Enable Flag.
};

union SER_REG {
	uint32_t 		 all;
	struct SER_BITS 		 bit;
};

struct BAUDR_BITS {			// bits   description
	uint32_t	SCKDV:15;			// 15:1   SSI Clock Divider.
};

union BAUDR_REG {
	uint32_t 		 all;
	struct BAUDR_BITS 		 bit;
};

struct TXFTLR_BITS {			// bits   description
	uint32_t	TFT:5;			// 4:0   Transmit FIFO Threshold.
	uint32_t	TXFTHR:5;			// 20:16   Transfer start FIFO level.
};

union TXFTLR_REG {
	uint32_t 		 all;
	struct TXFTLR_BITS 		 bit;
};

struct RXFTLR_BITS {			// bits   description
	uint32_t	RFT:5;			// 4:0   Receive FIFO Threshold.

};

union RXFTLR_REG {
	uint32_t 		 all;
	struct RXFTLR_BITS 		 bit;
};

struct TXFLR_BITS {			// bits   description
	uint32_t	TXTFL:6;			// 5:0   Transmit FIFO Level.

};

union TXFLR_REG {
	uint32_t 		 all;
	struct TXFLR_BITS 		 bit;
};

struct RXFLR_BITS {			// bits   description
	uint32_t	RXTFL:6;			// 5:0   Receive FIFO Level.

};

union RXFLR_REG {
	uint32_t 		 all;
	struct RXFLR_BITS 		 bit;
};

struct SR_BITS {			// bits   description
	uint32_t	BUSY:1;			// 0:0   SSI Busy Flag.
	uint32_t	TFNF:1;			// 1:1   Transmit FIFO Not Full.
	uint32_t	TFE:1;			// 2:2   Transmit FIFO Empty.
	uint32_t	RFNE:1;			// 3:3   Receive FIFO Not Empty.
	uint32_t	RFF:1;			// 4:4   Receive FIFO Full.
	uint32_t	TXE:1;			// 5:5   Transmission Error.
	uint32_t	DCOL:1;			// 6:6   Data Collision Error.
	uint32_t	CMPLTD_DF:17;			// 31:15   Completed Data frames This field indicates total data frames transferred in the previous internal DMA
};

union SR_REG {
	uint32_t 		 all;
	struct SR_BITS 		 bit;
};

struct IMR_BITS {			// bits   description
	uint32_t	TXEIM:1;			// 0:0   Transmit FIFO Empty Interrupt Mask
	uint32_t	TXOIM:1;			// 1:1   Transmit FIFO Overflow Interrupt Mask
	uint32_t	RXUIM:1;			// 2:2   Receive FIFO Underflow Interrupt Mask
	uint32_t	RXOIM:1;			// 3:3   Receive FIFO Overflow Interrupt Mask
	uint32_t	RXFIM:1;			// 4:4   Receive FIFO Full Interrupt Mask 0 - ssi_rxf_intr interrupt is masked 1 - ssi_rxf_intr interrupt is not
	uint32_t	MSTIM:1;			// 5:5   Multi-Controller Contention Interrupt Mask. This bit field is not present if the DWC_ssi is configured
	uint32_t	XRXOIM:1;			// 6:6   XIP Receive FIFO Overflow Interrupt Mask
	uint32_t	TXUIM:1;			// 7:7   Transmit FIFO Underflow Interrupt Mask
	uint32_t	AXIEM:1;			// 8:8   AXI Error Interrupt Mask
	uint32_t	SPITEM:1;			// 10:10   SPI Transmit Error Interrupt Mask
	uint32_t	DONEM:1;			// 11:11   SSI Done Interrupt Mask
};

union IMR_REG {
	uint32_t 		 all;
	struct IMR_BITS 		 bit;
};

struct ISR_BITS {			// bits   description
	uint32_t	TXEIS:1;			// 0:0   Transmit FIFO Empty Interrupt Status
	uint32_t	TXOIS:1;			// 1:1   Transmit FIFO Overflow Interrupt Status
	uint32_t	RXUIS:1;			// 2:2   Receive FIFO Underflow Interrupt Status
	uint32_t	RXOIS:1;			// 3:3    Receive FIFO Overflow Interrupt StatuS
	uint32_t	RXFIS:1;			// 4:4   Receive FIFO Full Interrupt Status
	uint32_t	MSTIS:1;			// 5:5   Multi-Controller Contention Interrupt Status. This bit field is not present if the DWC_ssi is configured
	uint32_t	XRXOIS:1;			// 6:6   XIP Receive FIFO Overflow Interrupt Status
	uint32_t	TXUIS:1;			// 7:7   Transmit FIFO Underflow Interrupt Status
	uint32_t	AXIES:1;			// 8:8   AXI Error Interrupt Status
	uint32_t	SPITES:1;			// 10:10   SPI Transmit Error Interrupt
	uint32_t	DONES:1;			// 11:11   SSI Done Interrupt Status
};

union ISR_REG {
	uint32_t 		 all;
	struct ISR_BITS 		 bit;
};

struct RISR_BITS {			// bits   description
	uint32_t	TXEIR:1;			// 0:0   Transmit FIFO Empty Interrupt Status
	uint32_t	TXOIR:1;			// 1:1   Transmit FIFO Overflow Interrupt Status
	uint32_t	RXUIR:1;			// 2:2   Receive FIFO Underflow Interrupt Status
	uint32_t	RXOIR:1;			// 3:3    Receive FIFO Overflow Interrupt StatuS
	uint32_t	RXFIR:1;			// 4:4   Receive FIFO Full Interrupt Status
	uint32_t	MSTIR:1;			// 5:5   Multi-Controller Contention Interrupt Status. This bit field is not present if the DWC_ssi is configured
	uint32_t	XRXOIR:1;			// 6:6   XIP Receive FIFO Overflow Interrupt Status
	uint32_t	TXUIR:1;			// 7:7   Transmit FIFO Underflow Interrupt Status
	uint32_t	AXIER:1;			// 8:8   AXI Error Interrupt Status
	uint32_t	SPITER:1;			// 10:10   SPI Transmit Error Interrupt
	uint32_t	DONER:1;			// 11:11   SSI Done Interrupt Status
};

union RISR_REG {
	uint32_t 		 all;
	struct RISR_BITS 		 bit;
};

struct TXEICR_BITS {			// bits   description
	uint32_t	TXEICR:1;			// 0:0   Clear Transmit FIFO Overflow/Underflow Interrupt.
};

union TXEICR_REG {
	uint32_t 		 all;
	struct TXEICR_BITS 		 bit;
};

struct RXOICR_BITS {			// bits   description
	uint32_t	RXOICR:1;			// 0:0   Clear Receive FIFO Overflow Interrupt.
};

union RXOICR_REG {
	uint32_t 		 all;
	struct RXOICR_BITS 		 bit;
};

struct RXUICR_BITS {			// bits   description
	uint32_t	RXUICR:1;			// 0:0   Clear Receive FIFO Underflow Interrupt.
};

union RXUICR_REG {
	uint32_t 		 all;
	struct RXUICR_BITS 		 bit;
};

struct MSTICR_BITS {			// bits   description
	uint32_t	RXOICR:1;			// 0:0   Clear Multi-Controller Contention Interrupt.
};

union MSTICR_REG {
	uint32_t 		 all;
	struct MSTICR_BITS 		 bit;
};

struct ICR_BITS {			// bits   description
	uint32_t	ICR:1;			// 0:0   Clear Interrupts.A read clears
};

union ICR_REG {
	uint32_t 		 all;
	struct ICR_BITS 		 bit;
};

struct DMACR_BITS {			// bits   description
	uint32_t	RDMAE:1;			// 0:0   Receive DMA Enable. This bit enables/disables the receive FIFO DMA channel.
	uint32_t	TDMAE:1;			// 1:1   Transmit DMA Enable. This bit enables/disables the transmit FIFO DMA channel.
	uint32_t	IDMAE:1;			// 2:2   Internal DMA Enable. This bit should be enabled only when CTRLR0.FRF = 0 (Motorola SPI) and CTRLR0.SPI_FRF
	uint32_t	ATW:2;			// 4:3   AXI transfer width for DMA transfers mapped to arsize/awsize. This value must be less than or equal to
	uint32_t	AINC:1;			// 6:6   Address Increment. Indicates whether to increment the AXI address on every transfer. 
	uint32_t	ACACHE:4;			// 11:8   AXI arcache/awcache signal value.
	uint32_t	APROT:3;			// 14:12   AXI arprot/awprot signal value.
	uint32_t	AID:6;			// 20:15   AXI awid/arid signal value.
};

union DMACR_REG {
	uint32_t 		 all;
	struct DMACR_BITS 		 bit;
};

struct DMATDLR_BITS {			// bits   description
	uint32_t	DMATDL:5;			// 4:0   Transmit Data Level. This bit field controls the level at which a DMA request is made by the transmit
};

union DMATDLR_REG {
	uint32_t 		 all;
	struct DMATDLR_BITS 		 bit;
};

struct DMARDLR_BITS {			// bits   description
	uint32_t	DMARDL:5;			// 4:0   Receive Data Level. This bit field controls the level at which a DMA request is made by the receive logic.
};

union DMARDLR_REG {
	uint32_t 		 all;
	struct DMARDLR_BITS 		 bit;
};

struct IDR_BITS {			// bits   description
	uint32_t	IDCODE:32;			// 31:0   Identification code. 
};

union IDR_REG {
	uint32_t 		 all;
	struct IDR_BITS 		 bit;
};

struct DR0_BITS {			// bits   description
	uint32_t	DR:32;			// 31:0   Data Register. When writing to this register, you must right-justify the data. Read data are automatically
};

union DR0_REG {
	uint32_t 		 all;
	struct DR0_BITS 		 bit;
};

struct SPI_CTRLR0_BITS {			// bits   description
	uint32_t	TRANS_TYPE:2;			// 1:0   Address and instruction transfer format.
	uint32_t	ADDR_L:4;			// 5:2   This bit defines Length of Address to be transmitted. Only after this much bits are programmed in to
	uint32_t	XIP_MD_BIT_EN:1;			// 7:7   Mode bits enable in XIP mode.
	uint32_t	INST_L:2;			// 9:8   Enhanced SPI mode instruction length in bits.
	uint32_t	WAIT_CYCLES:5;			// 15:11   Wait cycles in Enhanced SPI mode between control frames transmit and data reception. Specified as number
	uint32_t	SPI_DDR_EN:1;			// 16:16   SPI DDR Enable bit. This will enable Dual-data rate transfers in Enhanced SPI frame formats of SPI.
	uint32_t	INST_DDR_EN:1;			// 17:17   Instruction DDR Enable bit. This will enable Dual-data rate transfer for Instruction phase.
	uint32_t	SPI_RXDS_EN:1;			// 18:18   Read data strobe enable bit. Once this bit is set to 1 DWC_ssi will use Read data strobe (rxds) to capture
	uint32_t	XIP_DFS_HC:1;			// 19:19   Fix DFS for XIP transfers.  
	uint32_t	XIP_INST_EN:1;			// 20:20   Shift Register Loop.Used for testing purposes only. When internally active, connects the transmit shift
	uint32_t	SSIC_XIP_CONT_XFER_EN:1;			// 21:21   Enable continuous transfer in XIP mode. If this bit is set to 1 then continuous transfer mode in XIP
	uint32_t	RXDS_VL_EN:1;			// 23:23   RXDS variable latency enable bit.
	uint32_t	SPI_DM_EN:1;			// 24:24   SPI data mask enable bit.
	uint32_t	SPI_RXDS_SIG_EN:1;			// 25:25   Enable rxds signaling during address and command phase of Hyperbus transfer.
	uint32_t	XIP_MBL:2;			// 27:26   XIP Mode bits length. Sets the length of mode bits in XIP mode of operation. These bits are valid only
	uint32_t	XIP_PREFETCH_EN:1;			// 29:29   Enables XIP pre-fetch functionality in DWC_ssi. 
	uint32_t	CLK_STRETCH_EN:1;			// 30:30   Enables clock stretching capability in SPI transfers.
};

union SPI_CTRLR0_REG {
	uint32_t 		 all;
	struct SPI_CTRLR0_BITS 		 bit;
};

struct DDR_DRIVE_EDGE_BITS {			// bits   description
	uint32_t	TDE:8;			// 7:0   TXD Drive edge register which decided the driving edge of transmit data.
};

union DDR_DRIVE_EDGE_REG {
	uint32_t 		 all;
	struct DDR_DRIVE_EDGE_BITS 		 bit;
};

struct XIP_MODE_BITS_BITS {			// bits   description
	uint32_t	XIP_MD_BITS:16;			// 15:0   XIP mode bits to be sent after address phase of XIP transfer.
};

union XIP_MODE_BITS_REG {
	uint32_t 		 all;
	struct XIP_MODE_BITS_BITS 		 bit;
};

struct XIP_INCR_INST_BITS {			// bits   description
	uint32_t	INCR_INST:16;			// 15:0   XIP INCR transfer opcode. When SPI_CTRLR0.XIP_INST_EN bit is set to 1, DWC_ssi sends instruction for
};

union XIP_INCR_INST_REG {
	uint32_t 		 all;
	struct XIP_INCR_INST_BITS 		 bit;
};

struct XIP_WRAP_INST_BITS {			// bits   description
	uint32_t	WRAP_INST:16;			// 15:0   XIP WRAP transfer opcode. When SPI_CTRLR0.XIP_INST_EN bit is set to 1, DWC_ssi sends instruction for
};

union XIP_WRAP_INST_REG {
	uint32_t 		 all;
	struct XIP_WRAP_INST_BITS 		 bit;
};

struct XIP_CTRL_BITS {			// bits   description
	uint32_t	FRF:2;			// 1:0   SPI Frame Format
	uint32_t	TRANS_TYPE:2;			// 3:2   Address and instruction transfer format.
	uint32_t	ADDR_L:4;			// 7:4   This bit defines Length of Address to be transmitted. Only after this much bits are programmed in to
	uint32_t	INST_L:2;			// 10:9    
	uint32_t	MD_BITS_EN:1;			// 12:12    
	uint32_t	WAIT_CYCLES:5;			// 17:13    
	uint32_t	DFS_HC:1;			// 18:18   Read data strobe enable bit. Once this bit is set to 1 DWC_ssi will use Read data strobe (rxds) to capture
	uint32_t	DDR_EN:1;			// 19:19   Fix DFS for XIP transfers.  
	uint32_t	INST_DDR_EN:1;			// 20:20   SPI DDR Enable bit. This will enable Dual-data rate transfers in Enhanced SPI frame formats of SPI.
	uint32_t	RXDS_EN:1;			// 21:21   Read data strobe enable bit. Once this bit is set to 1 DWC_ssi will use Read data strobe (rxds) to capture
	uint32_t	INST_EN:1;			// 22:22   XIP instruction enable bit. If this bit is set to 1 then XIP transfers will also have instruction phase.
	uint32_t	CONT_XFER_EN:1;			// 23:23   Enable continuous transfer in XIP mode. If this bit is set to 1 then continuous transfer mode in XIP
	uint32_t	XIP_HYPERBUS_EN:1;			// 24:24   SPI Hyperbus Frame format enable for XIP transfers.
	uint32_t	RXDS_SIG_EN:1;			// 25:25   Enable rxds signaling during address and command phase of Hyperbus transfer.
	uint32_t	XIP_MBL:2;			// 27:26   XIP Mode bits length. Sets the length of mode bits in XIP mode of operation. These bits are valid only
	uint32_t	XIP_PREFETCH_EN:1;			// 29:29   Enables XIP pre-fetch functionality in DWC_ssi. Once enabled DWC_ssi will pre-fetch data frames from
	uint32_t	RXDS_VL_EN:1;			// 30:30   RXDS variable latency enable bit.
};

union XIP_CTRL_REG {
	uint32_t 		 all;
	struct XIP_CTRL_BITS 		 bit;
};

struct XRXOICR_BITS {			// bits   description
	uint32_t	XRXOICR:1;			// 0:0   Clear XIP Receive FIFO Overflow Interrupt.
};

union XRXOICR_REG {
	uint32_t 		 all;
	struct XRXOICR_BITS 		 bit;
};

struct XIP_CNT_TIME_OUT_BITS {			// bits   description
	uint32_t	XTOC:8;			// 7:0   XIP time out value in terms of hclk. Once target is selected in continuous XIP mode this counter will
};

union XIP_CNT_TIME_OUT_REG {
	uint32_t 		 all;
	struct XIP_CNT_TIME_OUT_BITS 		 bit;
};

struct SPI_CTRLR1_BITS {			// bits   description
	uint32_t	DYN_WS:3;			// 2:0   SPI Dynamic Wait states field.
	uint32_t	MAX_WS:4;			// 11:8   Maximum wait cycles allowed per transaction.
	uint32_t	CS_MIN_HIGH:4;			// 19:16   Chip-Select Minimum HIGH period.
};

union SPI_CTRLR1_REG {
	uint32_t 		 all;
	struct SPI_CTRLR1_BITS 		 bit;
};

struct XIP_WRITE_INCR_INST_BITS {			// bits   description
	uint32_t	INCR_WRITE_INST:16;			// 15:0   XIP Write INCR transfer opcode. When XIP_WRITE_CTRL.INST_L is not equal to 0, DWC_ssi sends instruction
};

union XIP_WRITE_INCR_INST_REG {
	uint32_t 		 all;
	struct XIP_WRITE_INCR_INST_BITS 		 bit;
};

struct WRAP_WRITE_INST_BITS {			// bits   description
	uint32_t	WRAP_WRITE_INST:16;			// 15:0    
};

union WRAP_WRITE_INST_REG {
	uint32_t 		 all;
	struct WRAP_WRITE_INST_BITS 		 bit;
};

struct XIP_WRITE_CTRL_BITS {			// bits   description
	uint32_t	WR_FRF:2;			// 1:0   SPI Frame Format
	uint32_t	WR_TRANS_TYPE:2;			// 3:2   Address and instruction transfer format.
	uint32_t	WR_ADDR_L:4;			// 7:4   This bit defines Length of Address to be transmitted. Only after this much bits are programmed in to
	uint32_t	WR_INST_L:2;			// 9:8   Enhanced SPI mode instruction length in bits.
	uint32_t	WR_SPI_DDR_EN:1;			// 10:10   SPI DDR Enable bit. This will enable Dual-data rate transfers in Enhanced SPI frame formats of SPI.
	uint32_t	WR_INST_DDR_EN:1;			// 11:11   Instruction DDR Enable bit. This will enable Dual-data rate transfer for Instruction phase.
	uint32_t	XIPWR_HYPERBUS_EN:1;			// 12:12   SPI Hyperbus Frame format enable for XIP Write transfers.
	uint32_t	XIPWR_RXDS_SIG_EN:1;			// 13:13   Enable rxds signaling during address and command phase of Hyperbus transfer.
	uint32_t	XIPWR_DM_EN:1;			// 14:14   Enable rxds signaling during address and command phase of Hyperbus transfer.
	uint32_t	XIPWR_WAIT_CYCLES:5;			// 20:16   Wait cycles in Enhanced SPI mode between control frames transmit and data reception. Specified as number
	uint32_t	XIPWR_DFS_HC:1;			// 21:21    
};

union XIP_WRITE_CTRL_REG {
	uint32_t 		 all;
	struct XIP_WRITE_CTRL_BITS 		 bit;
};


// QSPI Register Definitions:

struct QSPI_REGS {
	union  CTRLR0_REG			CTRLR0;
	union  CTRLR1_REG			CTRLR1;
	union  SSIENR_REG			SSIENR;
	union  MWCR_REG			MWCR;
	union  SER_REG			SER;
	union  BAUDR_REG			BAUDR;
	union  TXFTLR_REG			TXFTLR;
	union  RXFTLR_REG			RXFTLR;
	union  TXFLR_REG			TXFLR;
	union  RXFLR_REG			RXFLR;
	union  SR_REG			SR;
	union  IMR_REG			IMR;
	union  ISR_REG			ISR;
	union  RISR_REG			RISR;
	union  TXEICR_REG			TXEICR;
	union  RXOICR_REG			RXOICR;
	union  RXUICR_REG			RXUICR;
	union  MSTICR_REG			MSTICR;
	union  ICR_REG			ICR;
	union  DMACR_REG			DMACR;
	union  DMATDLR_REG			DMATDLR;
	union  DMARDLR_REG			DMARDLR;
	union  IDR_REG			IDR;
	uint32_t 						rsvd1; 		 // reserved
	union  DR0_REG			DR0;
	uint32_t 						rsvd2[36]; 		 // reserved
	union  SPI_CTRLR0_REG			SPI_CTRLR0;
	union  DDR_DRIVE_EDGE_REG			DDR_DRIVE_EDGE;
	union  XIP_MODE_BITS_REG			XIP_MODE_BITS;
	union  XIP_INCR_INST_REG			XIP_INCR_INST;
	union  XIP_WRAP_INST_REG			XIP_WRAP_INST;
	union  XIP_CTRL_REG			XIP_CTRL;
	uint32_t 						rsvd3; 		 // reserved
	union  XRXOICR_REG			XRXOICR;
	union  XIP_CNT_TIME_OUT_REG			XIP_CNT_TIME_OUT;
	union  SPI_CTRLR1_REG			SPI_CTRLR1;
	uint32_t 						rsvd4[9]; 		 // reserved
	union  XIP_WRITE_INCR_INST_REG			XIP_WRITE_INCR_INST;
	union  WRAP_WRITE_INST_REG			WRAP_WRITE_INST;
	union  XIP_WRITE_CTRL_REG			XIP_WRITE_CTRL;
};

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// QSPI External References & Function Declarations

extern volatile struct QSPI_REGS QspiRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_QSPI_H definition
