/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    sysctl.h
*   @brief   
*
*/

#ifndef DEVICE_DRIVERLIB_SYSCTL_H_
#define DEVICE_DRIVERLIB_SYSCTL_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "gs32_version.h"

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "inc/hw_wd.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_epwm.h"
#include "inc/hw_nmi.h"
#include "sysctl/sysctl_ahb.h"
#include "sysctl/sysctl_apb.h"

#if IS_GS32F00xx(0x12)
#include "sysctl/asysctl_v12.h"
#include "sysctl/sysctl_crg_v12.h"
#include "sysctl/sysctl_subcrg_v12.h"
#include "sysctl/sysctl_dig_v12.h"
#include "sysctl/sysctl_io_v12.h"
#include "sysctl/sysctl_pinmux_v12.h"
#include "sysctl/sysctl_nmi_wd.h"
#elif IS_GS32F00xx(0x30)
#include "sysctl/asysctl_v30.h"
#include "sysctl/sysctl_crg_v30.h"
#include "sysctl/sysctl_subcrg_v30.h"
#include "sysctl/sysctl_dig_v30.h"
#include "sysctl/sysctl_io_v30.h"
#include "sysctl/sysctl_nmi_wd.h"
#elif IS_GS32F3xx(0x22)
#include "sysctl/sysctl_crg_v22.h"
#include "sysctl/sysctl_subcrg_v22.h"
#include "sysctl/asysctl_v22.h"
#include "sysctl/sysctl_dig_v22.h"
#include "sysctl/sysctl_io_v12.h"
#include "sysctl/sysctl_pinmux_v12.h"
#include "sysctl/sysctl_nmi_wd.h"
#endif

#define GPIO_setAnalogPin    SysCtl_setAnalogPin

#if IS_GS32F00xx(0x12)
#define XTALWaitDelay		 33     //Waiting for XTAL 28us to start
#elif IS_GS32F00xx(0x30)
#define XTALWaitDelay		 40		//Waiting for XTAL 28us to start
#elif IS_GS32F3xx(0x22)
#define XTALWaitDelay		 27		//Waiting for XTAL 28us to start
#endif

#define XTALExpectCountUpper (DEVICE_OSCSRC_FREQ / (1000*1000) * 30)
#define XTALExpectCountLower (DEVICE_OSCSRC_FREQ / (1000*1000) * 20)

void SysCtl_delay(uint32_t delay_ticks);

#if IS_GS32F00xx() || IS_GS32F3xx(0x22)
//void sysctl_clock_init(void);
void sysctl_clock_init(uint32_t nPllClkFreq, uint32_t nOscFreq, uint32_t nSysClkDiv, uint32_t nAhbClkDiv, uint32_t nApbClkDiv);
#else
void sysctl_clock_init(uint32_t nSysClkFreq, uint32_t nOscFreq);
#endif

#ifdef __cplusplus
}
#endif


#endif /* DEVICE_DRIVERLIB_SYSCTL_H_ */
