/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    sysctl_io_v12.h
*   @brief   do NOT include this file directly, include "sysctl.h" instead
*
*/
/**
 * commit history
 * 20241218,Hezhiyuan,Modify comments
*/
#ifndef DEVICE_DRIVERLIB_SYSCTL_IO_V12_H_
#define DEVICE_DRIVERLIB_SYSCTL_IO_V12_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)

#ifdef __cplusplus
extern "C"{
#endif

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "inc/hw_sysctl_io_v12.h"

/*
 * IO_CFG_LOCK   Lock Control Register   offset 0x0000
 *
 *  Register Field                Field Range
 *  io_cfg_lock                  31 : 0
 *
 * Locks the register. Writing unlock value to this register allows writing to all registers protected by lock.
 * Writing other values will lock all registers protected by lock;
 * Unlock value: 0x5A5A_5A5A.
 * *
 */
__STATIC_INLINE void GPIO_lockPortConfig(void)
{
    HWREG(GPIOCTRL_BASE + GPIO_O_IO_CFG_LOCK) = 0x01;
}

__STATIC_INLINE void GPIO_unlockPortConfig(void)
{
    HWREG(GPIOCTRL_BASE + GPIO_O_IO_CFG_LOCK) = 0x5A5A5A5A;
}


/*
 * AGPIO42_ANA   AGPIO42 analog function enable configuration   offset 0x04
 *
 * Register Field Name    Field Range
 * reserved               31 : 5
 * agpio42_ana_en         0
 */
__STATIC_INLINE void SysCtl_setAgpio42AnaEnable(uint32_t val)
{

}

__STATIC_INLINE uint32_t SysCtl_getAgpio42AnaEnable(void)
{
    return 0;
}

/*
 * AGPIO43_ANA   AGPIO43 analog function enable configuration   offset 0x08
 *
 * Register Field Name    Field Range
 * reserved               31 : 5
 * agpio43_ana_en         0
 */
__STATIC_INLINE void SysCtl_setAgpio43AnaEnable(uint32_t val)
{

}

__STATIC_INLINE uint32_t SysCtl_getAgpio43AnaEnable(void)
{
    return 0;
}

/*
 * CLK_REF_PIN_CTRL   Clock Pin Configuration Register   Offset 0x10
 *
 * Register Field Name         Field Range
 * reserved                    31 : 4
 * clk_ref_pin_ctrl            3 : 0
 *
 * [0]: E0, Crystal enable pin, Enables the feedback amplifier.
 * [1]: TE, Test enable pin, Enables buffer for testing purposes.
 * [2]: SF0, Select frequency pin.
 * [3]: SF1, Select frequency pin.
 * {SF1, SF0}:
 * 00: 1MHz to 4MHz
 * 01: 4.1MHz to 12MHz
 * 10: 12.1MHz to 24MHz
 * 11: 24.1MHz to 48MHz
 */
__STATIC_INLINE void SysCtl_setClkRefPinCtrl(uint32_t value)
{

}

__STATIC_INLINE uint32_t SysCtl_getClkRefPinCtrl(void)
{
    return 0;
}

/**
 * IO_QUALPRD  IO Quantization Configuration Register   offset 0x0014 + n*4  n = 0~12
 *
 * Register Field Name       Field Range
 * reserved                  31 : 9
 * io_qualprd                8 : 0
 *  
 * IO quantization configuration register. Every 8 GPIOs correspond to one configuration register.
 * GPIO 0 to 7 configure register 0x1A0 (word address), GPIO 8 to 15 configure register 0x1A1 (word address), and so on.
 * This is the IO qual sampling period configuration register. When configured as 'n', it samples once every n+1 sysclk cycles.
 * The maximum configuration value is 511, meaning sampling once every 512 sysclk cycles.
 */
__STATIC_INLINE void SysCtl_setIoQualprd(uint32_t value, uint32_t n)
{

}

__STATIC_INLINE uint32_t SysCtl_getIoQualprd(uint32_t n)
{
    return 0;
}

#ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_SYSCTL_APB_PARA_H_ */
