/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS_OR_IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER_OR_CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY,_OR_CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS_OR_SERVICES; LOSS OF USE,
 *  DATA,_OR_PROFITS;_OR_BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,_OR_TORT
 *  (INCLUDING NEGLIGENCE_OR_OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file    xbar.h
 *   @brief
 *
 *   commit history:
 *   2024/06/13 ZhaoLei, add 3.0 CLBENC Output option
 */

#ifndef DEVICE_DRIVERLIB_XBAR_H
#define DEVICE_DRIVERLIB_XBAR_H

/**
 * @brief If building with a C++ compiler, make all of the definitions in this header have a C binding.
 */
#ifdef __cplusplus
extern "C"
{
#endif

/**
 * @brief addtogroup xbar_api XBAR.
 */
#include <stdint.h>
#include <stdbool.h>

#include "gs32_version.h"

#include "inc/hw_memmap.h"
#include "inc/hw_types.h"

// #include "cpu.h"
#include "debug.h"

#include "inc/hw_clbxbar.h"
#include "inc/hw_epwmxbar.h"
#include "inc/hw_inputxbar.h"
#include "inc/hw_outputxbar.h"
#include "inc/hw_xbar.h"
#include "inc/hw_iclxbar.h"
#include "inc/hw_mindbxbar.h"

/**
 * @brief Useful defines used within the driver functions
 * Not intended for use by application code.
 */
#define EPWMXBAR_BASE_OFFSET 0x100  //base 3.0 version
#define XBAR_EPWM_CFG_REG_BASE (EPWMXBAR_BASE + XBAR_O_TRIP4MUX0TO15CFG)
#define XBAR_EPWM_EN_REG_BASE (EPWMXBAR_BASE + XBAR_O_TRIP4MUXENABLE)

#define XBAR_CLB_CFG_REG_BASE (CLBXBAR_BASE + XBAR_O_AUXSIG0MUX0TO15CFG)
#define XBAR_CLB_EN_REG_BASE (CLBXBAR_BASE + XBAR_O_AUXSIG0MUXENABLE)
// #define XBAR_INPUT_BASE           			(INPUTXBAR_BASE + XBAR_O_INPUT1SELECT)
// #define XBAR_OUTPUT_CFG_REG_BASE  			(OUTPUTXBAR_BASE + XBAR_O_OUTPUT1MUX0TO15CFG)
// #define XBAR_OUTPUT_EN_REG_BASE   			(OUTPUTXBAR_BASE + XBAR_O_OUTPUT1MUXENABLE)
#if IS_GS32F00xx(0x12)
#define XBAR_INPUT_FLG_INPUT_M    0x00FFU
#define XBAR_INPUT_FLG_REG_M      0xFF00U
#define XBAR_INPUT_FLG_REG_1      0x0000U
#define XBAR_INPUT_FLG_REG_2      0x0100U
#define XBAR_INPUT_FLG_REG_3      0x0200U
#define XBAR_INPUT_FLG_REG_4      0x0300U
#define XBAR_INPUT_FLG_REG_5      0x0400U
#define XBAR_INPUT_FLG_REG_6      0x0500U
#elif IS_GS32F00xx(0x30)
#define XBAR_INPUT_FLG_INPUT_M    0x0FFU
#define XBAR_INPUT_FLG_REG_M      0xFF00U
#define XBAR_INPUT_FLG_REG_1      0x0000U
#define XBAR_INPUT_FLG_REG_2      0x0100U
#define XBAR_INPUT_FLG_REG_3      0x0200U
#define XBAR_INPUT_FLG_REG_4      0x0300U
#define XBAR_INPUT_FLG_REG_5      0x0400U
#define XBAR_INPUT_FLG_REG_6      0x0500U
#define XBAR_INPUT_FLG_REG_7      0x0600U
#define XBAR_INPUT_FLG_REG_8      0x0700U
#define XBAR_INPUT_FLG_REG_9      0x0800U
#define XBAR_INPUT_FLG_REG_10     0x0900U
#define XBAR_INPUT_FLG_REG_11     0x1000U
#define XBAR_INPUT_FLG_REG_12     0x1100U
#define XBAR_INPUT_FLG_REG_13     0x1200U
#define XBAR_INPUT_FLG_REG_14     0x1300U
#define XBAR_INPUT_FLG_REG_15     0x1400U
#define XBAR_INPUT_FLG_REG_16     0x1500U
#elif IS_GS32F3xx(0x22)
#define XBAR_INPUT_FLG_INPUT_M    0x0FFU
#define XBAR_INPUT_FLG_REG_M      0xFF00U
#define XBAR_INPUT_FLG_REG_1      0x0000U
#define XBAR_INPUT_FLG_REG_2      0x0100U
#define XBAR_INPUT_FLG_REG_3      0x0200U
#define XBAR_INPUT_FLG_REG_4      0x0300U
#define XBAR_INPUT_FLG_REG_11     0x0400U
#define XBAR_INPUT_FLG_REG_12     0x0500U
#define XBAR_INPUT_FLG_REG_13     0x0600U
#define XBAR_INPUT_FLG_REG_14     0x0700U
#define XBAR_INPUT_FLG_REG_15     0x0800U
#define XBAR_INPUT_FLG_REG_16     0x0900U
#endif

#if IS_GS32F00xx(0x12, 0x30)
#define XBAR_GPIO_MAX_CNT 65U
#define XBAR_NON_GPIO_MIN_CNT 200U
#define XBAR_NON_GPIO_MAX_CNT 0xFFFFU
#elif IS_GS32F3xx(0x22)
#define XBAR_GPIO_MAX_CNT 168U
#define XBAR_NON_GPIO_MIN_CNT 169U
#define XBAR_NON_GPIO_MAX_CNT 0xFFFFU
#endif
// #define XBAR_GPIO_AIO_MIN_CNT            224U
// #define XBAR_GPIO_AIO_MAX_CNT            253U

// check
#define XBAR_TOP_PLU1_OUT_SEL1 0x50U
#define XBAR_TOP_PLU1_OUT_SEL2 0x54U
#define XBAR_TOP_PLU2_OUT_SEL1 0x58U
#define XBAR_TOP_PLU2_OUT_SEL2 0x5CU

/**
 * @brief
 * The following values define the muxes parameter for XBAR_enableEPWMMux(),
 * XBAR_enableOutputMux(), XBAR_disableEPWMMux(), and XBAR_disableOutputMux().
 *
 */
#define XBAR_MUX00                  0U //!< Mask for X-BAR mux 0
#define XBAR_MUX01                  1U //!< Mask for X-BAR mux 1
#define XBAR_MUX02                  2U //!< Mask for X-BAR mux 2
#define XBAR_MUX03                  3U //!< Mask for X-BAR mux 3
#define XBAR_MUX04                  4U //!< Mask for X-BAR mux 4
#define XBAR_MUX05                  5U //!< Mask for X-BAR mux 5
#define XBAR_MUX06                  6U //!< Mask for X-BAR mux 6
#define XBAR_MUX07                  7U //!< Mask for X-BAR mux 7
#define XBAR_MUX08                  8U //!< Mask for X-BAR mux 8
#define XBAR_MUX09                  9U //!< Mask for X-BAR mux 9
#define XBAR_MUX10                  10U //!< Mask for X-BAR mux 10
#define XBAR_MUX11                  11U //!< Mask for X-BAR mux 11
#define XBAR_MUX12                  12U //!< Mask for X-BAR mux 12
#define XBAR_MUX13                  13U //!< Mask for X-BAR mux 13
#define XBAR_MUX14                  14U //!< Mask for X-BAR mux 14
#define XBAR_MUX15                  15U //!< Mask for X-BAR mux 15
#define XBAR_MUX16                  16U //!< Mask for X-BAR mux 16
#define XBAR_MUX17                  17U //!< Mask for X-BAR mux 17
#define XBAR_MUX18                  18U //!< Mask for X-BAR mux 18
#define XBAR_MUX19                  19U //!< Mask for X-BAR mux 19
#define XBAR_MUX20                  20U //!< Mask for X-BAR mux 20
#define XBAR_MUX21                  21U //!< Mask for X-BAR mux 21
#define XBAR_MUX22                  22U //!< Mask for X-BAR mux 22
#define XBAR_MUX23                  23U //!< Mask for X-BAR mux 23
#define XBAR_MUX24                  24U //!< Mask for X-BAR mux 24
#define XBAR_MUX25                  25U //!< Mask for X-BAR mux 25
#define XBAR_MUX26                  26U //!< Mask for X-BAR mux 26
#define XBAR_MUX27                  27U //!< Mask for X-BAR mux 27
#define XBAR_MUX28                  28U //!< Mask for X-BAR mux 28
#define XBAR_MUX29                  29U //!< Mask for X-BAR mux 29
#define XBAR_MUX30                  30U //!< Mask for X-BAR mux 30
#define XBAR_MUX31                  31U //!< Mask for X-BAR mux 31
#if IS_GS32F00xx(0x12, 0x30) || IS_GS32F3xx(0x22)
#define XBAR_MUX32                  32U//!< Mask for X-BAR mux 0
#define XBAR_MUX33                  33U//!< Mask for X-BAR mux 1
#define XBAR_MUX34                  34U//!< Mask for X-BAR mux 2
#define XBAR_MUX35                  35U//!< Mask for X-BAR mux 3
#define XBAR_MUX36                  36U//!< Mask for X-BAR mux 4
#define XBAR_MUX37                  37U//!< Mask for X-BAR mux 5
#define XBAR_MUX38                  38U//!< Mask for X-BAR mux 6
#define XBAR_MUX39                  39U//!< Mask for X-BAR mux 7
#define XBAR_MUX40                  40U//!< Mask for X-BAR mux 8
#define XBAR_MUX41                  41U//!< Mask for X-BAR mux 9
#define XBAR_MUX42                  42U//!< Mask for X-BAR mux 10
#define XBAR_MUX43                  43U//!< Mask for X-BAR mux 11
#define XBAR_MUX44                  44U//!< Mask for X-BAR mux 12
#define XBAR_MUX45                  45U//!< Mask for X-BAR mux 13
#define XBAR_MUX46                  46U//!< Mask for X-BAR mux 14
#define XBAR_MUX47                  47U//!< Mask for X-BAR mux 15
#define XBAR_MUX48                  48U//!< Mask for X-BAR mux 16
#define XBAR_MUX49                  49U//!< Mask for X-BAR mux 17
#define XBAR_MUX50                  50U//!< Mask for X-BAR mux 18
#define XBAR_MUX51                  51U//!< Mask for X-BAR mux 19
#define XBAR_MUX52                  52U//!< Mask for X-BAR mux 20
#define XBAR_MUX53                  53U//!< Mask for X-BAR mux 21
#define XBAR_MUX54                  54U//!< Mask for X-BAR mux 22
#define XBAR_MUX55                  55U//!< Mask for X-BAR mux 23
#define XBAR_MUX56                  56U//!< Mask for X-BAR mux 24
#define XBAR_MUX57                  57U//!< Mask for X-BAR mux 25
#define XBAR_MUX58                  58U//!< Mask for X-BAR mux 26
#define XBAR_MUX59                  59U//!< Mask for X-BAR mux 27
#define XBAR_MUX60                  60U//!< Mask for X-BAR mux 28
#define XBAR_MUX61                  61U//!< Mask for X-BAR mux 29
#define XBAR_MUX62                  62U//!< Mask for X-BAR mux 30
#define XBAR_MUX63                  63U//!< Mask for X-BAR mux 31
#endif

/**
 * @brief
 * The following values define the \e output parameter for
 * XBAR_setOutputMuxConfig(), XBAR_enableOutputMux(), and XBAR_disableOutputMux().
 *
 */
typedef enum
{
    XBAR_OUTPUT1 ,       //!< OUTPUT1 of the Output X-BAR
    XBAR_OUTPUT2 ,       //!< OUTPUT2 of the Output X-BAR
    XBAR_OUTPUT3 ,       //!< OUTPUT3 of the Output X-BAR
    XBAR_OUTPUT4 ,       //!< OUTPUT4 of the Output X-BAR
    XBAR_OUTPUT5 ,       //!< OUTPUT5 of the Output X-BAR
    XBAR_OUTPUT6 ,       //!< OUTPUT6 of the Output X-BAR
    XBAR_OUTPUT7 ,       //!< OUTPUT7 of the Output X-BAR
    XBAR_OUTPUT8 ,       //!< OUTPUT8 of the Output X-BAR
    XBAR_OUTPUT9 ,       //!< OUTPUT9 of the Output X-BAR
    XBAR_OUTPUT10,       //!< OUTPUT10 of the Output X-BAR
    XBAR_OUTPUT11,       //!< OUTPUT11 of the Output X-BAR
    XBAR_OUTPUT12,       //!< OUTPUT12 of the Output X-BAR
    XBAR_OUTPUT13,       //!< OUTPUT13 of the Output X-BAR
    XBAR_OUTPUT14,       //!< OUTPUT14 of the Output X-BAR
    XBAR_OUTPUT15,       //!< OUTPUT15 of the Output X-BAR
    XBAR_OUTPUT16        //!< OUTPUT16 of the Output X-BAR
} XBAR_OutputNum;

/**
 * @brief
 * The following values define the \e trip parameter for
 * XBAR_setEPWMMuxConfig(), XBAR_enableEPWMMux(), and XBAR_disableEPWMMux().
 *
 */
typedef enum
{
    XBAR_TRIP4  ,        //!< TRIP4 of the ePWM X-BAR
    XBAR_TRIP5  ,        //!< TRIP5 of the ePWM X-BAR
    XBAR_TRIP7  ,        //!< TRIP7 of the ePWM X-BAR
    XBAR_TRIP8  ,       //!< TRIP8 of the ePWM X-BAR
    XBAR_TRIP9  ,       //!< TRIP9 of the ePWM X-BAR
    XBAR_TRIP10 ,       //!< TRIP10 of the ePWM X-BAR
    XBAR_TRIP11 ,       //!< TRIP11 of the ePWM X-BAR
    XBAR_TRIP12 ,        //!< TRIP12 of the ePWM X-BAR

	/*GS32 extended trip*/
    XBAR_TRIP16 ,
#if IS_GS32F3xx(0x22)
    XBAR_TRIP17 ,
    XBAR_TRIP18 ,
    XBAR_TRIP19 ,
    XBAR_TRIP20 ,
    XBAR_TRIP21 ,
	XBAR_TRIP22 ,
	XBAR_TRIP23 ,
	XBAR_TRIP24 ,
	XBAR_TRIP25 ,
	XBAR_TRIP26 ,
	XBAR_TRIP27 ,
	XBAR_TRIP28 ,
	XBAR_TRIP29 ,
	XBAR_TRIP30 ,
	XBAR_TRIP31 ,
#endif
} XBAR_TripNum;

/**
 * @brief
 * The following values define the \e input parameter for XBAR_setInputPin().
 *
 */
#if 1
typedef enum
{
    XBAR_AUXSIG0 ,
    XBAR_AUXSIG1 ,
    XBAR_AUXSIG2 ,
    XBAR_AUXSIG3 ,
    XBAR_AUXSIG4 ,
    XBAR_AUXSIG5 ,
    XBAR_AUXSIG6 ,
    XBAR_AUXSIG7 ,

    XBAR_AUXSIG8 = 80,
    XBAR_AUXSIG9 = 84,
    XBAR_AUXSIG10 = 88,
    XBAR_AUXSIG11 = 92
} XBAR_AuxSigNum;

// need to add auxsig8-11
// check
#endif

/**
 * @brief
 * The following values define the \e input parameter for XBAR_setInputPin().
 *
 */
typedef enum
{
    XBAR_INPUT1 ,              //!< ePWM[TZ1], ePWM[TRIP1], X-BARs, XINT1
    XBAR_INPUT2 ,              //!< ePWM[TZ2], ePWM[TRIP2], X-BARs, XINT2
    XBAR_INPUT3 ,              //!< ePWM[TZ3], ePWM[TRIP3], X-BARs, XINT3
    XBAR_INPUT4 ,              //!< X-BARs, XINT4
    XBAR_INPUT5 ,              //!< EXTSYNCIN1, ADCEXTSOC, X-BARs, XINT5
    XBAR_INPUT6 ,             //!< EXTSYNCIN2, ePWM[TRIP6], X-BARs, XINT6
    XBAR_INPUT7 ,             //!< X-BARs, XINT7
    XBAR_INPUT8 ,             //!< X-BARs, XINT8
    XBAR_INPUT9 ,             //!< X-BARs, XINT9
    XBAR_INPUT10,            //!< X-BARs, XINT10
    XBAR_INPUT11,            //!< X-BARs, XINT11
    XBAR_INPUT12,            //!< X-BARs, XINT12
    XBAR_INPUT13,            //!< X-BARs, XINT13
    XBAR_INPUT14,            //!< ePWM[TZ7], X-BARs, XINT14
    XBAR_INPUT15,            //!< ePWM[TZ8], X-BARs, XINT15
    XBAR_INPUT16             //!< ePWM[TZ9], X-BARs, XINT16
} XBAR_InputNum;

/**
 * @brief
 * The following values define the \e muxConfig parameter for XBAR_setOutputMuxConfig().
 *
 */
typedef enum
{
    XBAR_CLB1_OUT0_SEL =0,
	XBAR_CLB1_OUT1_SEL =4,
    XBAR_CLB1_OUT2_SEL =8 ,
	XBAR_CLB1_OUT3_SEL =12,
    XBAR_CLB1_OUT4_SEL =16 ,
	XBAR_CLB1_OUT5_SEL =20,
    XBAR_CLB1_OUT6_SEL =24,
	XBAR_CLB1_OUT7_SEL =28,
    XBAR_CLB2_OUT0_SEL =32,
	XBAR_CLB2_OUT1_SEL =36,
    XBAR_CLB2_OUT2_SEL =40,
	XBAR_CLB2_OUT3_SEL =44,
    XBAR_CLB2_OUT4_SEL =48,
	XBAR_CLB2_OUT5_SEL =52,
    XBAR_CLB2_OUT6_SEL =56,
	XBAR_CLB2_OUT7_SEL =60
} XBAR_clb_sel;

typedef enum
{
    XBAR_CLB1_OUT ,
	XBAR_CLB2_OUT ,
    XBAR_CLB3_OUT ,
	XBAR_CLB4_OUT
} clb_out_sel;
typedef enum
{
//
// OUTPUTXBAR
//
#if IS_GS32F00xx(0x12)
    XBAR_OUT_MUX00_CMPSS1_CTRIPOUTH                 = 0x0000,
    XBAR_OUT_MUX00_CMPSS1_CTRIPOUTH_OR_CTRIPOUTL    = 0x0001,
    XBAR_OUT_MUX00_ADCAEVT1                         = 0x0002,
    XBAR_OUT_MUX00_ECAP1_OUT                        = 0x0003,
    XBAR_OUT_MUX01_CMPSS1_CTRIPOUTL                 = 0x0200,
    XBAR_OUT_MUX01_INPUTXBAR1                       = 0x0201,
    XBAR_OUT_MUX01_CLB1_OUT1                        = 0x0202,
    XBAR_OUT_MUX01_ADCCEVT1                         = 0x0203,
    XBAR_OUT_MUX02_CMPSS2_CTRIPOUTH                 = 0x0400,
    XBAR_OUT_MUX02_CMPSS2_CTRIPOUTH_OR_CTRIPOUTL    = 0x0401,
    XBAR_OUT_MUX02_ADCAEVT2                         = 0x0402,
    XBAR_OUT_MUX02_ECAP2_OUT                        = 0x0403,
    XBAR_OUT_MUX03_CMPSS2_CTRIPOUTL                 = 0x0600,
    XBAR_OUT_MUX03_INPUTXBAR2                       = 0x0601,
    XBAR_OUT_MUX03_CLB1_OUT2                        = 0x0602,
    XBAR_OUT_MUX03_ADCCEVT2                         = 0x0603,
    XBAR_OUT_MUX04_CMPSS3_CTRIPOUTH                 = 0x0800,
    XBAR_OUT_MUX04_CMPSS3_CTRIPOUTH_OR_CTRIPOUTL    = 0x0801,
    XBAR_OUT_MUX04_ADCAEVT3                         = 0x0802,
    XBAR_OUT_MUX04_ECAP3_OUT                        = 0x0803,
    XBAR_OUT_MUX05_CMPSS3_CTRIPOUTL                 = 0x0A00,
    XBAR_OUT_MUX05_INPUTXBAR3                       = 0x0A01,
    XBAR_OUT_MUX05_CLB1_OUT3                        = 0x0A02,
    XBAR_OUT_MUX05_ADCCEVT3                         = 0x0A03,
    XBAR_OUT_MUX06_CMPSS4_CTRIPOUTH                 = 0x0C00,
    XBAR_OUT_MUX06_CMPSS4_CTRIPOUTH_OR_CTRIPOUTL    = 0x0C01,
    XBAR_OUT_MUX06_ADCAEVT4                         = 0x0C02,
    XBAR_OUT_MUX06_ECAP4_OUT                        = 0x0C03,
    XBAR_OUT_MUX07_CMPSS4_CTRIPOUTL                 = 0x0E00,
    XBAR_OUT_MUX07_INPUTXBAR4                       = 0x0E01,
    XBAR_OUT_MUX07_CLB1_OUT4                        = 0x0E02,
    XBAR_OUT_MUX07_ADCCEVT4                         = 0x0E03,
    XBAR_OUT_MUX08_CMPSS5_CTRIPOUTH                 = 0x1000,
    XBAR_OUT_MUX08_CMPSS5_CTRIPOUTH_OR_CTRIPOUTL    = 0x1001,
    XBAR_OUT_MUX08_ADCBEVT1                         = 0x1002,
    XBAR_OUT_MUX08_ECAP5_OUT                        = 0x1003,
    XBAR_OUT_MUX09_CMPSS5_CTRIPOUTL                 = 0x1200,
    XBAR_OUT_MUX09_INPUTXBAR5                       = 0x1201,
    XBAR_OUT_MUX09_CLB1_OUT5                        = 0x1202,
    XBAR_OUT_MUX10_CMPSS6_CTRIPOUTH                 = 0x1400,
    XBAR_OUT_MUX10_CMPSS6_CTRIPOUTH_OR_CTRIPOUTL    = 0x1401,
    XBAR_OUT_MUX10_ADCBEVT2                         = 0x1402,
    XBAR_OUT_MUX10_ECAP6_OUT                        = 0x1403,
    XBAR_OUT_MUX11_CMPSS6_CTRIPOUTL                 = 0x1600,
    XBAR_OUT_MUX11_INPUTXBAR6                       = 0x1601,
    XBAR_OUT_MUX11_CLB1_OUT6                        = 0x1602,
    XBAR_OUT_MUX12_CMPSS7_CTRIPOUTH                 = 0x1800,
    XBAR_OUT_MUX12_CMPSS7_CTRIPOUTH_OR_CTRIPOUTL    = 0x1801,
    XBAR_OUT_MUX12_ADCBEVT3                         = 0x1802,
    XBAR_OUT_MUX12_ECAP7_OUT                        = 0x1803,
    XBAR_OUT_MUX13_CMPSS7_CTRIPOUTL                 = 0x1A00,
    XBAR_OUT_MUX13_ADCSOCAO                         = 0x1A01,
    XBAR_OUT_MUX13_CLB1_OUT7                        = 0x1A02,
    XBAR_OUT_MUX14_ADCBEVT4                         = 0x1C02,
    XBAR_OUT_MUX14_EXTSYNCOUT                       = 0x1C03,
    XBAR_OUT_MUX15_ADCSOCBO                         = 0x1E01,
    XBAR_OUT_MUX15_CLB1_OUT8                        = 0x1E02,
    XBAR_OUT_MUX16_SD1FLT1_CEVT1                    = 0x2000,
    XBAR_OUT_MUX16_SD1FLT1_CEVT1_OR_CEVT2           = 0x2001,
    XBAR_OUT_MUX17_SD1FLT1_CEVT2                    = 0x2200,
    XBAR_OUT_MUX17_INPUTXBAR7                       = 0x2201,
    XBAR_OUT_MUX17_CLB1_OUT9                        = 0x2202,
    XBAR_OUT_MUX17_HALT                             = 0x2203,
    XBAR_OUT_MUX18_SD1FLT2_CEVT1                    = 0x2400,
    XBAR_OUT_MUX18_SD1FLT2_CEVT1_OR_CEVT2           = 0x2401,
    XBAR_OUT_MUX19_SD1FLT2_CEVT2                    = 0x2600,
    XBAR_OUT_MUX19_INPUTXBAR8                       = 0x2601,
    XBAR_OUT_MUX19_CLB1_OUT10                       = 0x2602,
    XBAR_OUT_MUX19_ERRORSTS                         = 0x2603,
    XBAR_OUT_MUX20_SD1FLT3_CEVT1                    = 0x2800,
    XBAR_OUT_MUX20_SD1FLT3_CEVT1_OR_CEVT2           = 0x2801,
    XBAR_OUT_MUX21_SD1FLT3_CEVT2                    = 0x2A00,
    XBAR_OUT_MUX21_INPUTXBAR9                       = 0x2A01,
    XBAR_OUT_MUX21_CLB1_OUT11                       = 0x2A02,
    XBAR_OUT_MUX22_SD1FLT4_CEVT1                    = 0x2C00,
    XBAR_OUT_MUX22_SD1FLT4_CEVT1_OR_CEVT2           = 0x2C01,
    XBAR_OUT_MUX23_SD1FLT4_CEVT2                    = 0x2E00,
    XBAR_OUT_MUX23_INPUTXBAR10                      = 0x2E01,
    XBAR_OUT_MUX23_CLB1_OUT12                       = 0x2E02,
    XBAR_OUT_MUX24_SD2FLT1_CEVT1                    = 0x3000,
    XBAR_OUT_MUX24_SD2FLT1_CEVT1_OR_CEVT2           = 0x3001,
    XBAR_OUT_MUX25_SD2FLT1_CEVT2                    = 0x3200,
    XBAR_OUT_MUX25_INPUTXBAR11                      = 0x3201,
    XBAR_OUT_MUX26_SD2FLT2_CEVT1                    = 0x3400,
    XBAR_OUT_MUX26_SD2FLT2_CEVT1_OR_CEVT2           = 0x3401,
    XBAR_OUT_MUX27_SD2FLT2_CEVT2                    = 0x3600,
    XBAR_OUT_MUX27_INPUTXBAR12                      = 0x3601,
    XBAR_OUT_MUX28_SD2FLT3_CEVT1                    = 0x3800,
    XBAR_OUT_MUX28_SD2FLT3_CEVT1_OR_CEVT2           = 0x3801,
    XBAR_OUT_MUX29_SD2FLT3_CEVT2                    = 0x3A00,
    XBAR_OUT_MUX29_INPUTXBAR13                      = 0x3A01,
    XBAR_OUT_MUX30_SD2FLT4_CEVT1                    = 0x3C00,
    XBAR_OUT_MUX30_SD2FLT4_CEVT1_OR_CEVT2           = 0x3C01,
    XBAR_OUT_MUX30_EPGOUT0                          = 0x3C03,
    XBAR_OUT_MUX31_SD2FLT4_CEVT2                    = 0x3E00,
    XBAR_OUT_MUX31_INPUTXBAR14                      = 0x3E01,
    XBAR_OUT_MUX31_ERRORSTS                         = 0x3E02,
    XBAR_OUT_MUX31_EPGOUT1                          = 0x3E03,
    XBAR_OUT_MUX33_INPUTXBAR15                      = 0x4201,
    XBAR_OUT_MUX35_INPUTXBAR16                      = 0x4601,
    XBAR_OUT_MUX52_CLB2_OUT1                        = 0x6801,
    XBAR_OUT_MUX53_CLB2_OUT2                        = 0x6A01,
    XBAR_OUT_MUX54_CLB2_OUT3                        = 0x6C01,
    XBAR_OUT_MUX55_CLB2_OUT4                        = 0x6E01,
    XBAR_OUT_MUX56_CLB2_OUT5                        = 0x7001,
    XBAR_OUT_MUX57_CLB2_OUT6                        = 0x7201,
    XBAR_OUT_MUX58_CLB2_OUT7                        = 0x7401,
    XBAR_OUT_MUX59_CLB2_OUT8                        = 0x7601,
    XBAR_OUT_MUX60_CLB2_OUT9                        = 0x7801,
    XBAR_OUT_MUX61_CLB2_OUT10                       = 0x7A01,
    XBAR_OUT_MUX62_CLB2_OUT11                       = 0x7C01,
    XBAR_OUT_MUX63_CLB2_OUT12                       = 0x7E01,


    //
    // CLBOUTPUTXBAR
    //
    XBAR_OUT_MUX00_CLB1_OUT1                        = 0x0000,
    XBAR_OUT_MUX00_OUTPUTXBAR1                      = 0x0003,
    XBAR_OUT_MUX01_CLB1_OUT2                        = 0x0200,
    XBAR_OUT_MUX01_OUTPUTXBAR2                      = 0x0203,
    XBAR_OUT_MUX02_CLB1_OUT3                        = 0x0400,
    XBAR_OUT_MUX03_CLB1_OUT4                        = 0x0600,
    XBAR_OUT_MUX04_CLB1_OUT5                        = 0x0800,
    XBAR_OUT_MUX05_CLB1_OUT6                        = 0x0A00,
    XBAR_OUT_MUX06_CLB1_OUT7                        = 0x0C00,
    XBAR_OUT_MUX07_CLB1_OUT8                        = 0x0E00,
    XBAR_OUT_MUX08_CLB1_OUT9                        = 0x1000,
    XBAR_OUT_MUX08_OUTPUTXBAR3                      = 0x1003,
    XBAR_OUT_MUX09_CLB1_OUT10                       = 0x1200,
    XBAR_OUT_MUX09_OUTPUTXBAR4                      = 0x1203,
    XBAR_OUT_MUX10_CLB1_OUT11                       = 0x1400,
    XBAR_OUT_MUX11_CLB1_OUT12                       = 0x1600,
    XBAR_OUT_MUX12_CLB2_OUT1                        = 0x1800,
    XBAR_OUT_MUX13_CLB2_OUT2                        = 0x1A00,
    XBAR_OUT_MUX14_CLB2_OUT3                        = 0x1C00,
    XBAR_OUT_MUX15_CLB2_OUT4                        = 0x1E00,
    XBAR_OUT_MUX16_CLB2_OUT5                        = 0x2000,
    XBAR_OUT_MUX16_OUTPUTXBAR5                      = 0x2003,
    XBAR_OUT_MUX17_CLB2_OUT6                        = 0x2200,
    XBAR_OUT_MUX17_OUTPUTXBAR6                      = 0x2203,
    XBAR_OUT_MUX18_CLB2_OUT7                        = 0x2400,
    XBAR_OUT_MUX19_CLB2_OUT8                        = 0x2600,
    XBAR_OUT_MUX20_CLB2_OUT9                        = 0x2800,
    XBAR_OUT_MUX21_CLB2_OUT10                       = 0x2A00,
    XBAR_OUT_MUX22_CLB2_OUT11                       = 0x2C00,
    XBAR_OUT_MUX23_CLB2_OUT12                       = 0x2E00,
    XBAR_OUT_MUX24_OUTPUTXBAR7                      = 0x3003,
    XBAR_OUT_MUX25_OUTPUTXBAR8                      = 0x3203,
    XBAR_OUT_MUX30_EPGOUT2                          = 0x3C03,
    XBAR_OUT_MUX31_EPGOUT3                          = 0x3E03,
    XBAR_OUT_MUX32_OUTPUTXBAR9                      = 0x4003,
    XBAR_OUT_MUX33_OUTPUTXBAR10                     = 0x4203,
    XBAR_OUT_MUX40_OUTPUTXBAR11                     = 0x5003,
    XBAR_OUT_MUX41_OUTPUTXBAR12                     = 0x5203,
#endif
#if IS_GS32F00xx(0x30)
    XBAR_OUT_MUX00_CMPSS1_CTRIPOUTH                 = 0x0000,
    XBAR_OUT_MUX00_CMPSS1_CTRIPOUTH_OR_CTRIPOUTL    = 0x0001,
    XBAR_OUT_MUX00_ADCAEVT1                         = 0x0002,
    XBAR_OUT_MUX00_ECAP1_OUT                        = 0x0003,
    XBAR_OUT_MUX01_CMPSS1_CTRIPOUTL                 = 0x0200,
    XBAR_OUT_MUX01_INPUTXBAR1                       = 0x0201,
    XBAR_OUT_MUX01_CLB1_OUT4                        = 0x0202,
    XBAR_OUT_MUX01_ADCCEVT1                         = 0x0203,
    XBAR_OUT_MUX02_CMPSS2_CTRIPOUTH                 = 0x0400,
    XBAR_OUT_MUX02_CMPSS2_CTRIPOUTH_OR_CTRIPOUTL    = 0x0401,
    XBAR_OUT_MUX02_ADCAEVT2                         = 0x0402,
    XBAR_OUT_MUX02_ECAP2_OUT                        = 0x0403,
    XBAR_OUT_MUX03_CMPSS2_CTRIPOUTL                 = 0x0600,
    XBAR_OUT_MUX03_INPUTXBAR2                       = 0x0601,
    XBAR_OUT_MUX03_CLB1_OUT5                        = 0x0602,
    XBAR_OUT_MUX03_ADCCEVT2                         = 0x0603,
    XBAR_OUT_MUX04_CMPSS3_CTRIPOUTH                 = 0x0800,
    XBAR_OUT_MUX04_CMPSS3_CTRIPOUTH_OR_CTRIPOUTL    = 0x0801,
    XBAR_OUT_MUX04_ADCAEVT3                         = 0x0802,
    XBAR_OUT_MUX04_ECAP3_OUT                        = 0x0803,
    XBAR_OUT_MUX05_CMPSS3_CTRIPOUTL                 = 0x0A00,
    XBAR_OUT_MUX05_INPUTXBAR3                       = 0x0A01,
    XBAR_OUT_MUX05_CLB2_OUT4                        = 0x0A02,
    XBAR_OUT_MUX05_ADCCEVT3                         = 0x0A03,
    XBAR_OUT_MUX06_CMPSS4_CTRIPOUTH                 = 0x0C00,
    XBAR_OUT_MUX06_CMPSS4_CTRIPOUTH_OR_CTRIPOUTL    = 0x0C01,
    XBAR_OUT_MUX06_ADCAEVT4                         = 0x0C02,
	XBAR_OUT_MUX06_ECAP4_OUT                        = 0x0C03,
    XBAR_OUT_MUX07_CMPSS4_CTRIPOUTL                 = 0x0E00,
    XBAR_OUT_MUX07_INPUTXBAR4                       = 0x0E01,
    XBAR_OUT_MUX07_CLB2_OUT5                        = 0x0E02,
    XBAR_OUT_MUX07_ADCCEVT4                         = 0x0E03,
    XBAR_OUT_MUX08_CMPSS5_CTRIPOUTL                 = 0x1000,
    XBAR_OUT_MUX08_CMPSS5_CTRIPOUTH_OR_CTRIPOUTL    = 0x1001,
    XBAR_OUT_MUX08_ADCBEVT1                         = 0x1002,
    XBAR_OUT_MUX08_ECAP5_OUT                        = 0x1003,
    XBAR_OUT_MUX09_INPUTXBAR5                       = 0x1201,
    XBAR_OUT_MUX11_INPUTXBAR6                       = 0x1601,
    XBAR_OUT_MUX13_ADCSOCAO                         = 0x1A01,
    XBAR_OUT_MUX14_EXTSYNCOUT                       = 0x1C03,
    XBAR_OUT_MUX15_ADCSOCBO                         = 0x1E01,
    XBAR_OUT_MUX15_ECATSYNC0                        = 0x1E03,
    XBAR_OUT_MUX16_SD1FLT1_CEVT1                    = 0x2000,
    XBAR_OUT_MUX16_SD1FLT1_CEVT1_OR_CEVT2           = 0x2001,
    XBAR_OUT_MUX16_ECATSYNC1                        = 0x2003,
    XBAR_OUT_MUX17_SD1FLT1_CEVT2                    = 0x2200,
    XBAR_OUT_MUX17_INPUTXBAR7                       = 0x2201,
    XBAR_OUT_MUX17_HALT                             = 0x2203,
    XBAR_OUT_MUX18_SD1FLT2_CEVT1                    = 0x2400,
    XBAR_OUT_MUX18_SD1FLT2_CEVT1_OR_CEVT2           = 0x2401,
    XBAR_OUT_MUX19_SD1FLT2_CEVT2                    = 0x2600,
    XBAR_OUT_MUX19_INPUTXBAR8                       = 0x2601,
    XBAR_OUT_MUX19_ERRORSTS                         = 0x2603,
    XBAR_OUT_MUX20_SD1FLT3_CEVT1                    = 0x2800,
    XBAR_OUT_MUX20_SD1FLT3_CEVT1_OR_CEVT2           = 0x2801,
    XBAR_OUT_MUX21_SD1FLT3_CEVT2                    = 0x2A00,
    XBAR_OUT_MUX21_INPUTXBAR9                       = 0x2A01,
    XBAR_OUT_MUX22_SD1FLT4_CEVT1                    = 0x2C00,
    XBAR_OUT_MUX22_SD1FLT4_CEVT1_OR_CEVT2           = 0x2C01,
    XBAR_OUT_MUX23_SD1FLT4_CEVT2                    = 0x2E00,
    XBAR_OUT_MUX23_INPUTXBAR10                      = 0x2E01,
    XBAR_OUT_MUX24_SD2FLT1_CEVT1                    = 0x3000,
    XBAR_OUT_MUX24_SD2FLT1_CEVT1_OR_CEVT2           = 0x3001,
    XBAR_OUT_MUX25_SD2FLT1_CEVT2                    = 0x3200,
    XBAR_OUT_MUX25_INPUTXBAR11                      = 0x3201,
    XBAR_OUT_MUX26_SD2FLT2_CEVT1                    = 0x3400,
    XBAR_OUT_MUX26_SD2FLT2_CEVT1_OR_CEVT2           = 0x3401,
    XBAR_OUT_MUX27_SD2FLT2_CEVT2                    = 0x3600,
    XBAR_OUT_MUX27_INPUTXBAR12                      = 0x3601,
    XBAR_OUT_MUX28_SD2FLT3_CEVT1                    = 0x3800,
    XBAR_OUT_MUX28_SD2FLT3_CEVT1_OR_CEVT2           = 0x3801,
    XBAR_OUT_MUX29_SD2FLT3_CEVT2                    = 0x3A00,
    XBAR_OUT_MUX29_INPUTXBAR13                      = 0x3A01,
    XBAR_OUT_MUX30_SD2FLT4_CEVT1                    = 0x3C00,
    XBAR_OUT_MUX30_SD2FLT4_CEVT1_OR_CEVT2           = 0x3C01,
    XBAR_OUT_MUX30_EPGOUT0                          = 0x3C03,
    XBAR_OUT_MUX31_SD2FLT4_CEVT2                    = 0x3E00,
    XBAR_OUT_MUX31_INPUTXBAR14                      = 0x3E01,
    XBAR_OUT_MUX31_ERRORSTS                         = 0x3E02,
    XBAR_OUT_MUX31_EPGOUT1                          = 0x3E03,
    XBAR_OUT_MUX32_EPWM1_TRIPOUT                    = 0x4000,
    XBAR_OUT_MUX32_EPWM1_DEMONTRIP                  = 0x4001,
    XBAR_OUT_MUX32_EPWM1_DE_ACTIVE                  = 0x4002,
    XBAR_OUT_MUX32_CLB1_OUT0                        = 0x4003,
    XBAR_OUT_MUX33_EPWM2_TRIPOUT                    = 0x4200,
    XBAR_OUT_MUX33_EPWM2_DEMONTRIP                  = 0x4201,
    XBAR_OUT_MUX33_EPWM2_DE_ACTIVE                  = 0x4202,
    XBAR_OUT_MUX33_CLB1_OUT1                        = 0x4203,
    XBAR_OUT_MUX34_EPWM3_TRIPOUT                    = 0x4400,
    XBAR_OUT_MUX34_EPWM3_DEMONTRIP                  = 0x4401,
    XBAR_OUT_MUX34_EPWM3_DE_ACTIVE                  = 0x4402,
    XBAR_OUT_MUX34_CLB1_OUT2                        = 0x4403,
    XBAR_OUT_MUX35_EPWM4_TRIPOUT                    = 0x4600,
    XBAR_OUT_MUX35_EPWM4_DEMONTRIP                  = 0x4601,
    XBAR_OUT_MUX35_EPWM4_DE_ACTIVE                  = 0x4602,
    XBAR_OUT_MUX35_CLB1_OUT3                        = 0x4603,
    XBAR_OUT_MUX36_EPWM5_TRIPOUT                    = 0x4800,
    XBAR_OUT_MUX36_EPWM5_DEMONTRIP                  = 0x4801,
    XBAR_OUT_MUX36_EPWM5_DE_ACTIVE                  = 0x4802,
    XBAR_OUT_MUX36_CLB1_OUT6                        = 0x4803,
    XBAR_OUT_MUX37_EPWM6_TRIPOUT                    = 0x4A00,
    XBAR_OUT_MUX37_EPWM6_DEMONTRIP                  = 0x4A01,
    XBAR_OUT_MUX37_EPWM6_DE_ACTIVE                  = 0x4A02,
    XBAR_OUT_MUX37_CLB1_OUT7                        = 0x4A03,
    XBAR_OUT_MUX38_EPWM7_TRIPOUT                    = 0x4C00,
    XBAR_OUT_MUX38_EPWM7_DEMONTRIP                  = 0x4C01,
    XBAR_OUT_MUX38_EPWM7_DE_ACTIVE                  = 0x4C02,
    XBAR_OUT_MUX38_CLB2_OUT0                        = 0x4C03,
    XBAR_OUT_MUX39_EPWM8_TRIPOUT                    = 0x4E00,
    XBAR_OUT_MUX39_EPWM8_DEMONTRIP                  = 0x4E01,
    XBAR_OUT_MUX39_EPWM8_DE_ACTIVE                  = 0x4E02,
    XBAR_OUT_MUX39_CLB2_OUT1                        = 0x4E03,
    XBAR_OUT_MUX40_CLB2_OUT2                        = 0x5003,
    XBAR_OUT_MUX41_CLB2_OUT3                        = 0x5203,
    XBAR_OUT_MUX42_CLB2_OUT6                        = 0x5403,
    XBAR_OUT_MUX43_CLB2_OUT7                        = 0x5603,
    XBAR_OUT_MUX50_INPUTXBAR15                      = 0x6401,
    XBAR_OUT_MUX51_INPUTXBAR16                      = 0x6601,
    XBAR_OUT_MUX52_ADCA_EXTMUXSEL0                  = 0x6802,
    XBAR_OUT_MUX53_ADCA_EXTMUXSEL1                  = 0x6A02,
    XBAR_OUT_MUX54_ADCA_EXTMUXSEL2                  = 0x6C02,
    XBAR_OUT_MUX55_ADCA_EXTMUXSEL3                  = 0x6E02,
    XBAR_OUT_MUX60_ADCC_EXTMUXSEL0                  = 0x7802,
    XBAR_OUT_MUX61_ADCC_EXTMUXSEL1                  = 0x7A02,
    XBAR_OUT_MUX62_ADCC_EXTMUXSEL2                  = 0x7C02,
    XBAR_OUT_MUX63_ADCC_EXTMUXSEL3                  = 0x7E02,

    //CLB OUTXBAR
    XBAR_OUT_MUX00_CLB1_OUT0                        = 0x0000,
    XBAR_OUT_MUX01_CLB1_OUT1                        = 0x0200,
    XBAR_OUT_MUX02_CLB1_OUT2                        = 0x0400,
    XBAR_OUT_MUX03_CLB1_OUT3                        = 0x0600,
    XBAR_OUT_MUX04_CLB1_OUT4                        = 0x0800,
    XBAR_OUT_MUX05_CLB1_OUT5                        = 0x0A00,
    XBAR_OUT_MUX06_CLB1_OUT6                        = 0x0C00,
    XBAR_OUT_MUX07_CLB1_OUT7                        = 0x0E00,
    XBAR_OUT_MUX08_CLB2_OUT0                        = 0x1000,
    XBAR_OUT_MUX09_CLB2_OUT1                        = 0x1200,
    XBAR_OUT_MUX10_CLB2_OUT2                        = 0x1400,
    XBAR_OUT_MUX11_CLB2_OUT3                        = 0x1600,
    XBAR_OUT_MUX12_CLB2_OUT4                        = 0x1800,
    XBAR_OUT_MUX13_CLB2_OUT5                        = 0x1A00,
    XBAR_OUT_MUX14_CLB2_OUT6                        = 0x1C00,
    XBAR_OUT_MUX15_CLB2_OUT7                        = 0x1E00,

    XBAR_OUT_MUX00_CLB_ENC1_ENDAT_TXEN              = 0x0002,
    XBAR_OUT_MUX01_CLB_ENC1_ENDAT_SPI_CLK           = 0x0202,
    XBAR_OUT_MUX02_CLB_ENC1_ENDAT_ENC_CLK           = 0x0402,
    XBAR_OUT_MUX03_CLB_ENC1_BISS_SPI_CLK            = 0x0602,
    XBAR_OUT_MUX04_CLB_ENC1_BISS_MA                 = 0x0802,
    XBAR_OUT_MUX05_CLB_ENC1_TA_TXEN                 = 0x0A02,
    XBAR_OUT_MUX06_CLB_ENC1_TA_SPI_CLK              = 0x0C02,
    XBAR_OUT_MUX07_CLB_ENC1_ABS2QEP_I_OUT           = 0x0E02,
    XBAR_OUT_MUX08_CLB_ENC1_ABS2QEP_B_OUT           = 0x1002,
    XBAR_OUT_MUX09_CLB_ENC1_ABS2QEP_A_OUT           = 0x1202,
    XBAR_OUT_MUX10_CLB_ENC1_QEPDIV_I_OUT            = 0x1402,
    XBAR_OUT_MUX11_CLB_ENC1_QEPDIV_B_OUT            = 0x1602,
    XBAR_OUT_MUX12_CLB_ENC1_QEPDIV_A_OUT            = 0x1802,
    XBAR_OUT_MUX13_CLB_ENC1_PULSE_GEN_PTO_DIRECTION = 0x1A02,
    XBAR_OUT_MUX14_CLB_ENC1_CLBSE_GEN_PTO_PULSE     = 0x1C02,
    XBAR_OUT_MUX15_CLB_ENC2_ENDAT_TXEN              = 0x1E02,
    XBAR_OUT_MUX16_CLB_ENC2_ENDAT_SPI_CLK           = 0x2002,
    XBAR_OUT_MUX17_CLB_ENC2_ENDAT_ENC_CLK           = 0x2202,
    XBAR_OUT_MUX18_CLB_ENC2_BISS_SPI_CLK            = 0x2402,
    XBAR_OUT_MUX19_CLB_ENC2_BISS_MA                 = 0x2602,
    XBAR_OUT_MUX20_CLB_ENC2_TA_TXEN                 = 0x2802,
    XBAR_OUT_MUX21_CLB_ENC2_TA_SPI_CLK              = 0x2A02,
    XBAR_OUT_MUX22_CLB_ENC2_ABS2QEP_I_OUT           = 0x2C02,
    XBAR_OUT_MUX23_CLB_ENC2_ABS2QEP_B_OUT           = 0x2E02,
    XBAR_OUT_MUX24_CLB_ENC2_ABS2QEP_A_OUT           = 0x3002,
    XBAR_OUT_MUX25_CLB_ENC2_QEPDIV_I_OUT            = 0x3202,
    XBAR_OUT_MUX26_CLB_ENC2_QEPDIV_B_OUT            = 0x3402,
    XBAR_OUT_MUX27_CLB_ENC2_QEPDIV_A_OUT            = 0x3602,
    XBAR_OUT_MUX28_CLB_ENC2_PULSE_GEN_PTO_DIRECTION = 0x3802,
    XBAR_OUT_MUX29_CLB_ENC2_CLBSE_GEN_PTO_PULSE     = 0x3A02,

    XBAR_OUT_MUX00_OUTPUTXBAR1                      = 0x0003,
    XBAR_OUT_MUX01_OUTPUTXBAR2                      = 0x0203,
    XBAR_OUT_MUX08_OUTPUTXBAR3                      = 0x1003,
    XBAR_OUT_MUX09_OUTPUTXBAR4                      = 0x1203,
    XBAR_OUT_MUX16_OUTPUTXBAR5                      = 0x2003,
    XBAR_OUT_MUX17_OUTPUTXBAR6                      = 0x2203,
    XBAR_OUT_MUX24_OUTPUTXBAR7                      = 0x3003,
    XBAR_OUT_MUX25_OUTPUTXBAR8                      = 0x3203,
    XBAR_OUT_MUX30_EPGOUT2                          = 0x3C03,
    XBAR_OUT_MUX31_EPGOUT3                          = 0x3E03,



#endif
#if IS_GS32F3xx(0x22)
    XBAR_OUT_MUX00_CMPSS1_CTRIPOUTH                 = 0x0000,
    XBAR_OUT_MUX00_SD3FLT1_CEVT1                    = 0x0001,
    XBAR_OUT_MUX00_ADCAEVT1                         = 0x0002,
    XBAR_OUT_MUX00_ECAP1_OUT                        = 0x0003,
    XBAR_OUT_MUX01_CMPSS1_CTRIPOUTL                 = 0x0200,
    XBAR_OUT_MUX01_INPUTXBAR1                       = 0x0201,
    XBAR_OUT_MUX01_CLB1_OUT1                        = 0x0202,
    XBAR_OUT_MUX01_ADCCEVT1                         = 0x0203,
    XBAR_OUT_MUX02_CMPSS2_CTRIPOUTH                 = 0x0400,
    XBAR_OUT_MUX02_SD3FLT1_CEVT2                    = 0x0401,
    XBAR_OUT_MUX02_ADCAEVT2                         = 0x0402,
    XBAR_OUT_MUX02_ECAP2_OUT                        = 0x0403,
    XBAR_OUT_MUX03_CMPSS2_CTRIPOUTL                 = 0x0600,
    XBAR_OUT_MUX03_INPUTXBAR2                       = 0x0601,
    XBAR_OUT_MUX03_CLB1_OUT2                        = 0x0602,
    XBAR_OUT_MUX03_ADCCEVT2                         = 0x0603,
    XBAR_OUT_MUX04_CMPSS3_CTRIPOUTH                 = 0x0800,
    XBAR_OUT_MUX04_SD3FLT2_CEVT1                    = 0x0801,
    XBAR_OUT_MUX04_ADCAEVT3                         = 0x0802,
    XBAR_OUT_MUX04_ECAP3_OUT                        = 0x0803,
    XBAR_OUT_MUX05_CMPSS3_CTRIPOUTL                 = 0x0A00,
    XBAR_OUT_MUX05_INPUTXBAR3                       = 0x0A01,
    XBAR_OUT_MUX05_CLB1_OUT3                        = 0x0A02,
    XBAR_OUT_MUX05_ADCCEVT3                         = 0x0A03,
    XBAR_OUT_MUX06_CMPSS4_CTRIPOUTH                 = 0x0C00,
    XBAR_OUT_MUX06_SD3FLT2_CEVT2                    = 0x0C01,
    XBAR_OUT_MUX06_ADCAEVT4                         = 0x0C02,
    XBAR_OUT_MUX06_ECAP4_OUT                        = 0x0C03,
    XBAR_OUT_MUX07_CMPSS4_CTRIPOUTL                 = 0x0E00,
    XBAR_OUT_MUX07_INPUTXBAR4                       = 0x0E01,
    XBAR_OUT_MUX07_CLB1_OUT4                        = 0x0E02,
    XBAR_OUT_MUX07_ADCCEVT4                         = 0x0E03,
    XBAR_OUT_MUX08_CMPSS5_CTRIPOUTH                 = 0x1000,
    XBAR_OUT_MUX08_SD3FLT3_CEVT1                    = 0x1001,
    XBAR_OUT_MUX08_ADCBEVT1                         = 0x1002,
    XBAR_OUT_MUX08_ECAP5_OUT                        = 0x1003,
    XBAR_OUT_MUX09_CMPSS5_CTRIPOUTL                 = 0x1200,
    XBAR_OUT_MUX09_INPUTXBAR5                       = 0x1201,
    XBAR_OUT_MUX09_CLB1_OUT5                        = 0x1202,
    XBAR_OUT_MUX09_ADCDEVT1                         = 0x1203,
    XBAR_OUT_MUX10_CMPSS6_CTRIPOUTH                 = 0x1400,
    XBAR_OUT_MUX10_SD3FLT3_CEVT2                    = 0x1401,
    XBAR_OUT_MUX10_ADCBEVT2                         = 0x1402,
    XBAR_OUT_MUX10_ECAP6_OUT                        = 0x1403,
    XBAR_OUT_MUX11_CMPSS6_CTRIPOUTL                 = 0x1600,
    XBAR_OUT_MUX11_INPUTXBAR6                       = 0x1601,
    XBAR_OUT_MUX11_CLB1_OUT6                        = 0x1602,
    XBAR_OUT_MUX11_ADCDEVT2                         = 0x1603,
    XBAR_OUT_MUX12_CMPSS7_CTRIPOUTH                 = 0x1800,
    XBAR_OUT_MUX12_SD3FLT4_CEVT1                    = 0x1801,
    XBAR_OUT_MUX12_ADCBEVT3                         = 0x1802,
    XBAR_OUT_MUX12_ECAP7_OUT                        = 0x1803,
    XBAR_OUT_MUX13_CMPSS7_CTRIPOUTL                 = 0x1A00,
    XBAR_OUT_MUX13_ADCSOCAO                         = 0x1A01,
    XBAR_OUT_MUX13_CLB1_OUT7                        = 0x1A02,
    XBAR_OUT_MUX13_ADCDEVT3                         = 0x1A03,
    XBAR_OUT_MUX14_CMPSS8_CTRIPOUTH                 = 0x1C00,
    XBAR_OUT_MUX14_SD3FLT4_CEVT2                    = 0x1C01,
    XBAR_OUT_MUX14_ADCBEVT4                         = 0x1C02,
    XBAR_OUT_MUX14_EXTSYNCOUT                       = 0x1C03,
    XBAR_OUT_MUX15_CMPSS8_CTRIPOUTL                 = 0x1E00,
    XBAR_OUT_MUX15_ADCSOCBO                         = 0x1E01,
    XBAR_OUT_MUX15_CLB1_OUT8                        = 0x1E02,
    XBAR_OUT_MUX15_ADCDEVT4                         = 0x1E03,
    XBAR_OUT_MUX16_SD1FLT1_CEVT1                    = 0x2000,
    XBAR_OUT_MUX16_SD4FLT1_CEVT1                    = 0x2001,
    XBAR_OUT_MUX17_SD1FLT1_CEVT2                    = 0x2200,
    XBAR_OUT_MUX17_INPUTXBAR7                       = 0x2201,
    XBAR_OUT_MUX17_CLB1_OUT9                        = 0x2202,
    XBAR_OUT_MUX17_HALT                             = 0x2203,
    XBAR_OUT_MUX18_SD1FLT2_CEVT1                    = 0x2400,
    XBAR_OUT_MUX18_SD4FLT1_CEVT2                    = 0x2401,
    XBAR_OUT_MUX19_SD1FLT2_CEVT2                    = 0x2600,
    XBAR_OUT_MUX19_INPUTXBAR8                       = 0x2601,
    XBAR_OUT_MUX19_CLB1_OUT10                       = 0x2602,
    XBAR_OUT_MUX19_ERRORSTS                         = 0x2603,
    XBAR_OUT_MUX20_SD1FLT3_CEVT1                    = 0x2800,
    XBAR_OUT_MUX20_SD4FLT2_CEVT1                    = 0x2801,
    XBAR_OUT_MUX21_SD1FLT3_CEVT2                    = 0x2A00,
    XBAR_OUT_MUX21_INPUTXBAR9                       = 0x2A01,
    XBAR_OUT_MUX21_CLB1_OUT11                       = 0x2A02,
    XBAR_OUT_MUX22_SD1FLT4_CEVT1                    = 0x2C00,
    XBAR_OUT_MUX22_SD4FLT2_CEVT2                    = 0x2C01,
    XBAR_OUT_MUX23_SD1FLT4_CEVT2                    = 0x2E00,
    XBAR_OUT_MUX23_INPUTXBAR10                      = 0x2E01,
    XBAR_OUT_MUX23_CLB1_OUT12                       = 0x2E02,
    XBAR_OUT_MUX24_SD2FLT1_CEVT1                    = 0x3000,
    XBAR_OUT_MUX24_SD4FLT3_CEVT1                    = 0x3001,
    XBAR_OUT_MUX25_SD2FLT1_CEVT2                    = 0x3200,
    XBAR_OUT_MUX25_INPUTXBAR11                      = 0x3201,
    XBAR_OUT_MUX26_SD2FLT2_CEVT1                    = 0x3400,
    XBAR_OUT_MUX26_SD4FLT3_CEVT2                    = 0x3401,
    XBAR_OUT_MUX27_SD2FLT2_CEVT2                    = 0x3600,
    XBAR_OUT_MUX27_INPUTXBAR12                      = 0x3601,
    XBAR_OUT_MUX28_SD2FLT3_CEVT1                    = 0x3800,
    XBAR_OUT_MUX28_SD4FLT4_CEVT1                    = 0x3801,
    XBAR_OUT_MUX29_SD2FLT3_CEVT2                    = 0x3A00,
    XBAR_OUT_MUX29_INPUTXBAR13                      = 0x3A01,
    XBAR_OUT_MUX30_SD2FLT4_CEVT1                    = 0x3C00,
    XBAR_OUT_MUX30_SD4FLT4_CEVT2                    = 0x3C01,
    XBAR_OUT_MUX30_EPGOUT0                          = 0x3C03,
    XBAR_OUT_MUX31_SD2FLT4_CEVT2                    = 0x3E00,
    XBAR_OUT_MUX31_INPUTXBAR14                      = 0x3E01,
    XBAR_OUT_MUX31_ERRORSTS                         = 0x3E02,
    XBAR_OUT_MUX31_EPGOUT1                          = 0x3E03,
    XBAR_OUT_MUX33_INPUTXBAR15                      = 0x4201,
    XBAR_OUT_MUX33_CMPSS1_CTRIPOUTH_OR_CTRIPOUTL    = 0x4202,
    XBAR_OUT_MUX33_SD1FLT1_CEVT1_OR_CEVT2           = 0x4203,
    XBAR_OUT_MUX35_INPUTXBAR16                      = 0x4601,
    XBAR_OUT_MUX35_CMPSS2_CTRIPOUTH_OR_CTRIPOUTL    = 0x4602,
    XBAR_OUT_MUX35_SD1FLT2_CEVT1_OR_CEVT2           = 0x4603,
    XBAR_OUT_MUX37_CMPSS3_CTRIPOUTH_OR_CTRIPOUTL    = 0x4A02,
    XBAR_OUT_MUX37_SD1FLT3_CEVT1_OR_CEVT2           = 0x4A03,
    XBAR_OUT_MUX39_CMPSS4_CTRIPOUTH_OR_CTRIPOUTL    = 0x4E02,
    XBAR_OUT_MUX39_SD1FLT4_CEVT1_OR_CEVT2           = 0x4E03,
    XBAR_OUT_MUX41_CMPSS5_CTRIPOUTH_OR_CTRIPOUTL    = 0x5202,
    XBAR_OUT_MUX41_SD2FLT1_CEVT1_OR_CEVT2           = 0x5203,
    XBAR_OUT_MUX43_CMPSS6_CTRIPOUTH_OR_CTRIPOUTL    = 0x5602,
    XBAR_OUT_MUX43_SD2FLT2_CEVT1_OR_CEVT2           = 0x5603,
    XBAR_OUT_MUX45_CMPSS7_CTRIPOUTH_OR_CTRIPOUTL    = 0x5A02,
    XBAR_OUT_MUX45_SD2FLT3_CEVT1_OR_CEVT2           = 0x5A03,
    XBAR_OUT_MUX47_CMPSS8_CTRIPOUTH_OR_CTRIPOUTL    = 0x5E02,
    XBAR_OUT_MUX47_SD2FLT4_CEVT1_OR_CEVT2           = 0x5E03,
    XBAR_OUT_MUX49_CMPSS9_CTRIPOUTH_OR_CTRIPOUTL    = 0x6202,
    XBAR_OUT_MUX49_SD3FLT1_CEVT1_OR_CEVT2           = 0x6203,
    XBAR_OUT_MUX51_CMPSS10_CTRIPOUTH_OR_CTRIPOUTL   = 0x6602,
    XBAR_OUT_MUX51_SD3FLT2_CEVT1_OR_CEVT2           = 0x6603,
    XBAR_OUT_MUX52_CLB2_OUT1                        = 0x6801,
    XBAR_OUT_MUX53_CLB2_OUT2                        = 0x6A01,
    XBAR_OUT_MUX53_CMPSS11_CTRIPOUTH_OR_CTRIPOUTL   = 0x6A02,
    XBAR_OUT_MUX53_SD3FLT3_CEVT1_OR_CEVT2           = 0x6A03,
    XBAR_OUT_MUX54_CLB2_OUT3                        = 0x6C01,
    XBAR_OUT_MUX55_CLB2_OUT4                        = 0x6E01,
    XBAR_OUT_MUX55_CMPSS12_CTRIPOUTH_OR_CTRIPOUTL   = 0x6E02,
    XBAR_OUT_MUX55_SD3FLT4_CEVT1_OR_CEVT2           = 0x6E03,
    XBAR_OUT_MUX56_CMPSS12_CTRIPOUTH                = 0x7000,
    XBAR_OUT_MUX56_CLB2_OUT5                        = 0x7001,
    XBAR_OUT_MUX57_CMPSS12_CTRIPOUTL                = 0x7200,
    XBAR_OUT_MUX57_CLB2_OUT6                        = 0x7201,
    XBAR_OUT_MUX57_SD4FLT1_CEVT1_OR_CEVT2           = 0x7203,
    XBAR_OUT_MUX58_CMPSS9_CTRIPOUTH                 = 0x7400,
    XBAR_OUT_MUX58_CLB2_OUT7                        = 0x7401,
    XBAR_OUT_MUX59_CMPSS9_CTRIPOUTL                 = 0x7600,
    XBAR_OUT_MUX59_CLB2_OUT8                        = 0x7601,
    XBAR_OUT_MUX59_SD4FLT2_CEVT1_OR_CEVT2           = 0x7603,
    XBAR_OUT_MUX60_CMPSS10_CTRIPOUTH                = 0x7800,
    XBAR_OUT_MUX60_CLB2_OUT9                        = 0x7801,
    XBAR_OUT_MUX61_CMPSS10_CTRIPOUTL                = 0x7A00,
    XBAR_OUT_MUX61_CLB2_OUT10                       = 0x7A01,
    XBAR_OUT_MUX61_SD4FLT3_CEVT1_OR_CEVT2           = 0x7A03,
    XBAR_OUT_MUX62_CMPSS11_CTRIPOUTH                = 0x7C00,
    XBAR_OUT_MUX62_CLB2_OUT11                       = 0x7C01,
    XBAR_OUT_MUX63_CMPSS11_CTRIPOUTL                = 0x7E00,
    XBAR_OUT_MUX63_CLB2_OUT12                       = 0x7E01,
    XBAR_OUT_MUX63_SD4FLT4_CEVT1_OR_CEVT2           = 0x7E03,


    //plu_outxbar input signal
    XBAR_OUT_MUX00_CLB1_OUT1                        = 0x0000,
    XBAR_OUT_MUX00_CLB6_OUT1                        = 0x0001,
    XBAR_OUT_MUX00_OUTPUTXBAR1                      = 0x0003,
    XBAR_OUT_MUX01_CLB1_OUT2                        = 0x0200,
    XBAR_OUT_MUX01_CLB6_OUT2                        = 0x0201,
    XBAR_OUT_MUX01_OUTPUTXBAR2                      = 0x0203,
    XBAR_OUT_MUX02_CLB1_OUT3                        = 0x0400,
    XBAR_OUT_MUX02_CLB6_OUT3                        = 0x0401,
    XBAR_OUT_MUX03_CLB1_OUT4                        = 0x0600,
    XBAR_OUT_MUX03_CLB6_OUT4                        = 0x0601,
    XBAR_OUT_MUX04_CLB1_OUT5                        = 0x0800,
    XBAR_OUT_MUX04_CLB6_OUT5                        = 0x0801,
    XBAR_OUT_MUX05_CLB1_OUT6                        = 0x0A00,
    XBAR_OUT_MUX05_CLB6_OUT6                        = 0x0A01,
    XBAR_OUT_MUX06_CLB1_OUT7                        = 0x0C00,
    XBAR_OUT_MUX06_CLB6_OUT7                        = 0x0C01,
    XBAR_OUT_MUX07_CLB1_OUT8                        = 0x0E00,
    XBAR_OUT_MUX07_CLB6_OUT8                        = 0x0E01,
    XBAR_OUT_MUX08_CLB1_OUT9                        = 0x1000,
    XBAR_OUT_MUX08_CLB6_OUT9                        = 0x1001,
    XBAR_OUT_MUX08_OUTPUTXBAR3                      = 0x1003,
    XBAR_OUT_MUX09_CLB1_OUT10                       = 0x1200,
    XBAR_OUT_MUX09_CLB6_OUT10                       = 0x1201,
    XBAR_OUT_MUX09_OUTPUTXBAR4                      = 0x1203,
    XBAR_OUT_MUX10_CLB1_OUT11                       = 0x1400,
    XBAR_OUT_MUX10_CLB6_OUT11                       = 0x1401,
    XBAR_OUT_MUX11_CLB1_OUT12                       = 0x1600,
    XBAR_OUT_MUX11_CLB6_OUT12                       = 0x1601,
    XBAR_OUT_MUX12_CLB2_OUT1                        = 0x1800,
    XBAR_OUT_MUX12_CLB7_OUT1                        = 0x1801,
    XBAR_OUT_MUX13_CLB2_OUT2                        = 0x1A00,
    XBAR_OUT_MUX13_CLB7_OUT2                        = 0x1A01,
    XBAR_OUT_MUX14_CLB2_OUT3                        = 0x1C00,
    XBAR_OUT_MUX14_CLB7_OUT3                        = 0x1C01,
    XBAR_OUT_MUX15_CLB2_OUT4                        = 0x1E00,
    XBAR_OUT_MUX15_CLB7_OUT4                        = 0x1E01,
    XBAR_OUT_MUX16_CLB2_OUT5                        = 0x2000,
    XBAR_OUT_MUX16_CLB7_OUT5                        = 0x2001,
    XBAR_OUT_MUX16_OUTPUTXBAR5                      = 0x2003,
    XBAR_OUT_MUX17_CLB2_OUT6                        = 0x2200,
    XBAR_OUT_MUX17_CLB7_OUT6                        = 0x2201,
    XBAR_OUT_MUX17_OUTPUTXBAR6                      = 0x2203,
    XBAR_OUT_MUX18_CLB2_OUT7                        = 0x2400,
    XBAR_OUT_MUX18_CLB7_OUT7                        = 0x2401,
    XBAR_OUT_MUX19_CLB2_OUT8                        = 0x2600,
    XBAR_OUT_MUX19_CLB7_OUT8                        = 0x2601,
    XBAR_OUT_MUX20_CLB2_OUT9                        = 0x2800,
    XBAR_OUT_MUX20_CLB7_OUT9                        = 0x2801,
    XBAR_OUT_MUX21_CLB2_OUT10                       = 0x2A00,
    XBAR_OUT_MUX21_CLB7_OUT10                       = 0x2A01,
    XBAR_OUT_MUX22_CLB2_OUT11                       = 0x2C00,
    XBAR_OUT_MUX22_CLB7_OUT11                       = 0x2C01,
    XBAR_OUT_MUX23_CLB2_OUT12                       = 0x2E00,
    XBAR_OUT_MUX23_CLB7_OUT12                       = 0x2E01,
    XBAR_OUT_MUX24_CLB3_OUT1                        = 0x3000,
    XBAR_OUT_MUX24_CLB8_OUT1                        = 0x3001,
    XBAR_OUT_MUX24_OUTPUTXBAR7                      = 0x3003,
    XBAR_OUT_MUX25_CLB3_OUT2                        = 0x3200,
    XBAR_OUT_MUX25_CLB8_OUT2                        = 0x3201,
    XBAR_OUT_MUX25_OUTPUTXBAR8                      = 0x3203,
    XBAR_OUT_MUX26_CLB3_OUT3                        = 0x3400,
    XBAR_OUT_MUX26_CLB8_OUT3                        = 0x3401,
    XBAR_OUT_MUX27_CLB3_OUT4                        = 0x3600,
    XBAR_OUT_MUX27_CLB8_OUT4                        = 0x3601,
    XBAR_OUT_MUX28_CLB3_OUT5                        = 0x3800,
    XBAR_OUT_MUX28_CLB8_OUT5                        = 0x3801,
    XBAR_OUT_MUX29_CLB3_OUT6                        = 0x3A00,
    XBAR_OUT_MUX29_CLB8_OUT6                        = 0x3A01,
    XBAR_OUT_MUX30_CLB3_OUT7                        = 0x3C00,
    XBAR_OUT_MUX30_CLB8_OUT7                        = 0x3C01,
    XBAR_OUT_MUX30_EPGOUT2                          = 0x3C03,
    XBAR_OUT_MUX31_CLB3_OUT8                        = 0x3E00,
    XBAR_OUT_MUX31_CLB8_OUT8                        = 0x3E01,
    XBAR_OUT_MUX31_EPGOUT3                          = 0x3E03,
    XBAR_OUT_MUX32_CLB3_OUT9                        = 0x4000,
    XBAR_OUT_MUX32_CLB8_OUT9                        = 0x4001,
    XBAR_OUT_MUX32_OUTPUTXBAR9                      = 0x4003,
    XBAR_OUT_MUX33_CLB3_OUT10                       = 0x4200,
    XBAR_OUT_MUX33_CLB8_OUT10                       = 0x4201,
    XBAR_OUT_MUX33_OUTPUTXBAR10                     = 0x4203,
    XBAR_OUT_MUX34_CLB3_OUT11                       = 0x4400,
    XBAR_OUT_MUX34_CLB8_OUT11                       = 0x4401,
    XBAR_OUT_MUX35_CLB3_OUT12                       = 0x4600,
    XBAR_OUT_MUX35_CLB8_OUT12                       = 0x4601,
    XBAR_OUT_MUX36_CLB4_OUT1                        = 0x4800,
    XBAR_OUT_MUX37_CLB4_OUT2                        = 0x4A00,
    XBAR_OUT_MUX38_CLB4_OUT3                        = 0x4C00,
    XBAR_OUT_MUX39_CLB4_OUT4                        = 0x4E00,
    XBAR_OUT_MUX40_CLB4_OUT5                        = 0x5000,
    XBAR_OUT_MUX40_OUTPUTXBAR11                     = 0x5003,
    XBAR_OUT_MUX41_CLB4_OUT6                        = 0x5200,
    XBAR_OUT_MUX41_OUTPUTXBAR12                     = 0x5203,
    XBAR_OUT_MUX42_CLB4_OUT7                        = 0x5400,
    XBAR_OUT_MUX43_CLB4_OUT8                        = 0x5600,
    XBAR_OUT_MUX44_CLB4_OUT9                        = 0x5800,
    XBAR_OUT_MUX45_CLB4_OUT10                       = 0x5A00,
    XBAR_OUT_MUX46_CLB4_OUT11                       = 0x5C00,
    XBAR_OUT_MUX47_CLB4_OUT12                       = 0x5E00,
    XBAR_OUT_MUX48_CLB5_OUT1                        = 0x6000,
    XBAR_OUT_MUX48_OUTPUTXBAR13                     = 0x6003,
    XBAR_OUT_MUX49_CLB5_OUT2                        = 0x6200,
    XBAR_OUT_MUX49_OUTPUTXBAR14                     = 0x6203,
    XBAR_OUT_MUX50_CLB5_OUT3                        = 0x6400,
    XBAR_OUT_MUX51_CLB5_OUT4                        = 0x6600,
    XBAR_OUT_MUX52_CLB5_OUT5                        = 0x6800,
    XBAR_OUT_MUX53_CLB5_OUT6                        = 0x6A00,
    XBAR_OUT_MUX54_CLB5_OUT7                        = 0x6C00,
    XBAR_OUT_MUX55_CLB5_OUT8                        = 0x6E00,
    XBAR_OUT_MUX56_CLB5_OUT9                        = 0x7000,
    XBAR_OUT_MUX56_OUTPUTXBAR15                     = 0x7003,
    XBAR_OUT_MUX57_CLB5_OUT10                       = 0x7200,
    XBAR_OUT_MUX57_OUTPUTXBAR16                     = 0x7203,
    XBAR_OUT_MUX58_CLB5_OUT11                       = 0x7400,
    XBAR_OUT_MUX59_CLB5_OUT12                       = 0x7600,

#endif
} XBAR_OutputMuxConfig;

#define XBAR_OUT_MUX00_OUTPUT XBAR1 0x0003

/**
 * @brief
 * The following values define the \e muxConfig parameter for XBAR_setEPWMMuxConfig().
 *
 */
typedef enum
{
#if IS_GS32F00xx()
#if IS_GS32F00xx(0x12)
    XBAR_EPWM_MUX00_CMPSS1_CTRIPH           = 0x0000,
    XBAR_EPWM_MUX00_CMPSS1_CTRIPH_OR_CTRIPL = 0x0001,
    XBAR_EPWM_MUX00_ADCAEVT1                = 0x0002,
    XBAR_EPWM_MUX00_ECAP1_OUT               = 0x0003,
    XBAR_EPWM_MUX01_CMPSS1_CTRIPL           = 0x0200,
    XBAR_EPWM_MUX01_INPUTXBAR1              = 0x0201,
    XBAR_EPWM_MUX01_CLB1_OUT1               = 0x0202,
    XBAR_EPWM_MUX01_ADCCEVT1                = 0x0203,
    XBAR_EPWM_MUX02_CMPSS2_CTRIPH           = 0x0400,
    XBAR_EPWM_MUX02_CMPSS2_CTRIPH_OR_CTRIPL = 0x0401,
    XBAR_EPWM_MUX02_ADCAEVT2                = 0x0402,
    XBAR_EPWM_MUX02_ECAP2_OUT               = 0x0403,
    XBAR_EPWM_MUX03_CMPSS2_CTRIPL           = 0x0600,
    XBAR_EPWM_MUX03_INPUTXBAR2              = 0x0601,
    XBAR_EPWM_MUX03_CLB1_OUT2               = 0x0602,
    XBAR_EPWM_MUX03_ADCCEVT2                = 0x0603,
    XBAR_EPWM_MUX04_CMPSS3_CTRIPH           = 0x0800,
    XBAR_EPWM_MUX04_CMPSS3_CTRIPH_OR_CTRIPL = 0x0801,
    XBAR_EPWM_MUX04_ADCAEVT3                = 0x0802,
    XBAR_EPWM_MUX04_ECAP3_OUT               = 0x0803,
    XBAR_EPWM_MUX05_CMPSS3_CTRIPL           = 0x0A00,
    XBAR_EPWM_MUX05_INPUTXBAR3              = 0x0A01,
    XBAR_EPWM_MUX05_CLB1_OUT3               = 0x0A02,
    XBAR_EPWM_MUX05_ADCCEVT3                = 0x0A03,
    XBAR_EPWM_MUX06_CMPSS4_CTRIPH           = 0x0C00,
    XBAR_EPWM_MUX06_CMPSS4_CTRIPH_OR_CTRIPL = 0x0C01,
    XBAR_EPWM_MUX06_ADCAEVT4                = 0x0C02,
    XBAR_EPWM_MUX06_ECAP4_OUT               = 0x0C03,
    XBAR_EPWM_MUX07_CMPSS4_CTRIPL           = 0x0E00,
    XBAR_EPWM_MUX07_INPUTXBAR4              = 0x0E01,
    XBAR_EPWM_MUX07_CLB1_OUT4               = 0x0E02,
    XBAR_EPWM_MUX07_ADCCEVT4                = 0x0E03,
    XBAR_EPWM_MUX08_CMPSS5_CTRIPH           = 0x1000,
    XBAR_EPWM_MUX08_CMPSS5_CTRIPH_OR_CTRIPL = 0x1001,
    XBAR_EPWM_MUX08_ADCBEVT1                = 0x1002,
    XBAR_EPWM_MUX08_ECAP5_OUT               = 0x1003,
    XBAR_EPWM_MUX09_CMPSS5_CTRIPL           = 0x1200,
    XBAR_EPWM_MUX09_INPUTXBAR5              = 0x1201,
    XBAR_EPWM_MUX09_CLB1_OUT5               = 0x1202,
    XBAR_EPWM_MUX10_CMPSS6_CTRIPH           = 0x1400,
    XBAR_EPWM_MUX10_CMPSS6_CTRIPH_OR_CTRIPL = 0x1401,
    XBAR_EPWM_MUX10_ADCBEVT2                = 0x1402,
    XBAR_EPWM_MUX10_ECAP6_OUT               = 0x1403,
    XBAR_EPWM_MUX11_CMPSS6_CTRIPL           = 0x1600,
    XBAR_EPWM_MUX11_INPUTXBAR6              = 0x1601,
    XBAR_EPWM_MUX11_CLB1_OUT6               = 0x1602,
    XBAR_EPWM_MUX12_CMPSS7_CTRIPH           = 0x1800,
    XBAR_EPWM_MUX12_CMPSS7_CTRIPH_OR_CTRIPL = 0x1801,
    XBAR_EPWM_MUX12_ADCBEVT3                = 0x1802,
    XBAR_EPWM_MUX12_ECAP7_OUT               = 0x1803,
    XBAR_EPWM_MUX13_CMPSS7_CTRIPL           = 0x1A00,
    XBAR_EPWM_MUX13_ADCSOCAO                = 0x1A01,
    XBAR_EPWM_MUX13_CLB1_OUT7               = 0x1A02,
    XBAR_EPWM_MUX14_ADCBEVT4                = 0x1C02,
    XBAR_EPWM_MUX14_EXTSYNCOUT              = 0x1C03,
    XBAR_EPWM_MUX15_ADCSOCBO                = 0x1E01,
    XBAR_EPWM_MUX15_CLB1_OUT8               = 0x1E02,
    XBAR_EPWM_MUX16_SD1FLT1_CEVT1           = 0x2000,
    XBAR_EPWM_MUX16_SD1FLT1_CEVT1_OR_CEVT2  = 0x2001,
    XBAR_EPWM_MUX16_CLB1_OUT9               = 0x2002,
    XBAR_EPWM_MUX17_SD1FLT1_CEVT2           = 0x2200,
    XBAR_EPWM_MUX17_INPUTXBAR7              = 0x2201,
    XBAR_EPWM_MUX17_CLBINPUTXBAR7           = 0x2202,
    XBAR_EPWM_MUX17_HALT                    = 0x2203,
    XBAR_EPWM_MUX18_SD1FLT2_CEVT1           = 0x2400,
    XBAR_EPWM_MUX18_SD1FLT2_CEVT1_OR_CEVT2  = 0x2401,
    XBAR_EPWM_MUX18_CLB1_OUT10              = 0x2402,
    XBAR_EPWM_MUX19_SD1FLT2_CEVT2           = 0x2600,
    XBAR_EPWM_MUX19_INPUTXBAR8              = 0x2601,
    XBAR_EPWM_MUX19_CLBINPUTXBAR8           = 0x2602,
    XBAR_EPWM_MUX19_ERRORSTS                = 0x2603,
    XBAR_EPWM_MUX20_SD1FLT3_CEVT1           = 0x2800,
    XBAR_EPWM_MUX20_SD1FLT3_CEVT1_OR_CEVT2  = 0x2801,
    XBAR_EPWM_MUX20_CLB1_OUT11              = 0x2802,
    XBAR_EPWM_MUX21_SD1FLT3_CEVT2           = 0x2A00,
    XBAR_EPWM_MUX21_INPUTXBAR9              = 0x2A01,
    XBAR_EPWM_MUX21_CLBINPUTXBAR9           = 0x2A02,
    XBAR_EPWM_MUX22_SD1FLT4_CEVT1           = 0x2C00,
    XBAR_EPWM_MUX22_SD1FLT4_CEVT1_OR_CEVT2  = 0x2C01,
    XBAR_EPWM_MUX22_CLB1_OUT12              = 0x2C02,
    XBAR_EPWM_MUX23_SD1FLT4_CEVT2           = 0x2E00,
    XBAR_EPWM_MUX23_INPUTXBAR10             = 0x2E01,
    XBAR_EPWM_MUX23_CLBINPUTXBAR10          = 0x2E02,
    XBAR_EPWM_MUX24_SD2FLT1_CEVT1           = 0x3000,
    XBAR_EPWM_MUX24_SD2FLT1_CEVT1_OR_CEVT2  = 0x3001,
    XBAR_EPWM_MUX25_SD2FLT1_CEVT2           = 0x3200,
    XBAR_EPWM_MUX25_INPUTXBAR11             = 0x3201,
    XBAR_EPWM_MUX25_CANA_EVT                = 0x3202,
    XBAR_EPWM_MUX25_CLBINPUTXBAR11          = 0x3203,
    XBAR_EPWM_MUX26_SD2FLT2_CEVT1           = 0x3400,
    XBAR_EPWM_MUX26_SD2FLT2_CEVT1_OR_CEVT2  = 0x3401,
    XBAR_EPWM_MUX27_SD2FLT2_CEVT2           = 0x3600,
    XBAR_EPWM_MUX27_INPUTXBAR12             = 0x3601,
    XBAR_EPWM_MUX27_CANB_EVT                = 0x3602,
    XBAR_EPWM_MUX27_CLBINPUTXBAR12          = 0x3603,
    XBAR_EPWM_MUX28_SD2FLT3_CEVT1           = 0x3800,
    XBAR_EPWM_MUX28_SD2FLT3_CEVT1_OR_CEVT2  = 0x3801,
    XBAR_EPWM_MUX29_SD2FLT3_CEVT2           = 0x3A00,
    XBAR_EPWM_MUX29_INPUTXBAR13             = 0x3A01,
    XBAR_EPWM_MUX29_CLBINPUTXBAR13          = 0x3A03,
    XBAR_EPWM_MUX30_SD2FLT4_CEVT1           = 0x3C00,
    XBAR_EPWM_MUX30_SD2FLT4_CEVT1_OR_CEVT2  = 0x3C01,
    XBAR_EPWM_MUX31_SD2FLT4_CEVT2           = 0x3E00,
    XBAR_EPWM_MUX31_INPUTXBAR14             = 0x3E01,
    XBAR_EPWM_MUX31_ERRORSTS                = 0x3E02,
    XBAR_EPWM_MUX31_CLBINPUTXBAR14          = 0x3E03,
    XBAR_EPWM_MUX33_INPUTXBAR15             = 0x4201,
    XBAR_EPWM_MUX35_INPUTXBAR16             = 0x4601,
    XBAR_EPWM_MUX37_ERAD_EVT0               = 0x4A01,
    XBAR_EPWM_MUX38_ERAD_EVT1               = 0x4C01,
    XBAR_EPWM_MUX39_ERAD_EVT2               = 0x4E01,
    XBAR_EPWM_MUX40_ERAD_EVT3               = 0x5001,
    XBAR_EPWM_MUX41_ERAD_EVT4               = 0x5201,
    XBAR_EPWM_MUX42_ERAD_EVT5               = 0x5401,
    XBAR_EPWM_MUX43_ERAD_EVT6               = 0x5601,
    XBAR_EPWM_MUX44_ERAD_EVT7               = 0x5801,
    XBAR_EPWM_MUX45_ERAD_EVT8               = 0x5A01,
    XBAR_EPWM_MUX46_ERAD_EVT9               = 0x5C01,
    XBAR_EPWM_MUX52_CLB2_OUT1               = 0x6801,
    XBAR_EPWM_MUX53_CLB2_OUT2               = 0x6A01,
    XBAR_EPWM_MUX54_CLB2_OUT3               = 0x6C01,
    XBAR_EPWM_MUX55_CLB2_OUT4               = 0x6E01,
    XBAR_EPWM_MUX56_CLB2_OUT5               = 0x7001,
    XBAR_EPWM_MUX57_CLB2_OUT6               = 0x7201,
    XBAR_EPWM_MUX58_CLB2_OUT7               = 0x7401,
    XBAR_EPWM_MUX59_CLB2_OUT8               = 0x7601,
    XBAR_EPWM_MUX60_CLB2_OUT9               = 0x7801,
    XBAR_EPWM_MUX61_CLB2_OUT10              = 0x7A01,
    XBAR_EPWM_MUX62_CLB2_OUT11              = 0x7C01,
    XBAR_EPWM_MUX63_CLB2_OUT12              = 0x7E01,
#elif IS_GS32F00xx(0x30)
    XBAR_EPWM_MUX00_CMPSS1_CTRIPH                  = 0x0000,
    XBAR_EPWM_MUX00_CMPSS1_CTRIPH_OR_CTRIPL        = 0x0001,
    XBAR_EPWM_MUX00_ADCAEVT1                       = 0x0002,
    XBAR_EPWM_MUX00_ECAP1_OUT                      = 0x0003,
    XBAR_EPWM_MUX01_CMPSS1_CTRIPL                  = 0x0200,
    XBAR_EPWM_MUX01_INPUTXBAR1                     = 0x0201,
    XBAR_EPWM_MUX01_CLB1_OUT4                      = 0x0202,
    XBAR_EPWM_MUX01_ADCCEVT1                       = 0x0203,
    XBAR_EPWM_MUX02_CMPSS2_CTRIPH                  = 0x0400,
    XBAR_EPWM_MUX02_CMPSS2_CTRIPH_OR_CTRIPL        = 0x0401,
    XBAR_EPWM_MUX02_ADCAEVT2                       = 0x0402,
    XBAR_EPWM_MUX02_ECAP2_OUT                      = 0x0403,
    XBAR_EPWM_MUX03_CMPSS2_CTRIPL                  = 0x0600,
    XBAR_EPWM_MUX03_INPUTXBAR2                     = 0x0601,
    XBAR_EPWM_MUX03_CLB1_OUT5                      = 0x0602,
    XBAR_EPWM_MUX03_ADCCEVT2                       = 0x0603,
    XBAR_EPWM_MUX04_CMPSS3_CTRIPH                  = 0x0800,
    XBAR_EPWM_MUX04_CMPSS3_CTRIPH_OR_CTRIPL        = 0x0801,
    XBAR_EPWM_MUX04_ADCAEVT3                       = 0x0802,
    XBAR_EPWM_MUX04_ECAP3_OUT                      = 0x0803,
    XBAR_EPWM_MUX05_CMPSS3_CTRIPL                  = 0x0A00,
    XBAR_EPWM_MUX05_INPUTXBAR3                     = 0x0A01,
    XBAR_EPWM_MUX05_CLB2_OUT4                      = 0x0A02,
    XBAR_EPWM_MUX05_ADCCEVT3                       = 0x0A03,
    XBAR_EPWM_MUX06_CMPSS4_CTRIPH                  = 0x0C00,
    XBAR_EPWM_MUX06_CMPSS4_CTRIPH_OR_CTRIPL        = 0x0C01,
    XBAR_EPWM_MUX06_ADCAEVT4                       = 0x0C02,
    XBAR_EPWM_MUX07_CMPSS4_CTRIPL                  = 0x0E00,
    XBAR_EPWM_MUX07_INPUTXBAR4                     = 0x0E01,
    XBAR_EPWM_MUX07_CLB2_OUT5                      = 0x0E02,
    XBAR_EPWM_MUX07_ADCCEVT4                       = 0x0E03,
    XBAR_EPWM_MUX09_INPUTXBAR5                     = 0x1201,
    XBAR_EPWM_MUX11_INPUTXBAR6                     = 0x1601,
    XBAR_EPWM_MUX13_ADCSOCAO                       = 0x1A01,
    XBAR_EPWM_MUX14_EXTSYNCOUT                     = 0x1C03,
    XBAR_EPWM_MUX15_ADCSOCBO                       = 0x1E01,
    XBAR_EPWM_MUX15_ECATSYNC0                      = 0x1E03,
    XBAR_EPWM_MUX16_SD1FLT1_CEVT1                  = 0x2000,
    XBAR_EPWM_MUX16_SD1FLT1_CEVT1_OR_CEVT2         = 0x2001,
    XBAR_EPWM_MUX16_ECATSYNC1                      = 0x2003,
    XBAR_EPWM_MUX17_SD1FLT1_CEVT2                  = 0x2200,
    XBAR_EPWM_MUX17_INPUTXBAR7                     = 0x2201,
    XBAR_EPWM_MUX17_CLBINPUTXBAR7                  = 0x2202,
    XBAR_EPWM_MUX17_HALT                           = 0x2203,
    XBAR_EPWM_MUX18_SD1FLT2_CEVT1                  = 0x2400,
    XBAR_EPWM_MUX18_SD1FLT2_CEVT1_OR_CEVT2         = 0x2401,
    XBAR_EPWM_MUX19_SD1FLT2_CEVT2                  = 0x2600,
    XBAR_EPWM_MUX19_INPUTXBAR8                     = 0x2601,
    XBAR_EPWM_MUX19_CLBINPUTXBAR8                  = 0x2602,
    XBAR_EPWM_MUX19_ERRORSTS                       = 0x2603,
    XBAR_EPWM_MUX20_SD1FLT3_CEVT1                  = 0x2800,
    XBAR_EPWM_MUX20_SD1FLT3_CEVT1_OR_CEVT2         = 0x2801,
    XBAR_EPWM_MUX21_SD1FLT3_CEVT2                  = 0x2A00,
    XBAR_EPWM_MUX21_INPUTXBAR9                     = 0x2A01,
    XBAR_EPWM_MUX21_CLBINPUTXBAR9                  = 0x2A02,
    XBAR_EPWM_MUX22_SD1FLT4_CEVT1                  = 0x2C00,
    XBAR_EPWM_MUX22_SD1FLT4_CEVT1_OR_CEVT2         = 0x2C01,
    XBAR_EPWM_MUX23_SD1FLT4_CEVT2                  = 0x2E00,
    XBAR_EPWM_MUX23_INPUTXBAR10                    = 0x2E01,
    XBAR_EPWM_MUX23_CLBINPUTXBAR10                 = 0x2E02,
    XBAR_EPWM_MUX24_SD2FLT1_CEVT1                  = 0x3000,
    XBAR_EPWM_MUX24_SD2FLT1_CEVT1_OR_CEVT2         = 0x3001,
    XBAR_EPWM_MUX25_SD2FLT1_CEVT2                  = 0x3200,
    XBAR_EPWM_MUX25_INPUTXBAR11                    = 0x3201,
    XBAR_EPWM_MUX25_MCANA_FEVT0                    = 0x3202,
    XBAR_EPWM_MUX25_CLBINPUTXBAR11                 = 0x3203,
    XBAR_EPWM_MUX26_SD2FLT2_CEVT1                  = 0x3400,
    XBAR_EPWM_MUX26_SD2FLT2_CEVT1_OR_CEVT2         = 0x3401,
    XBAR_EPWM_MUX26_MCANB_FEVT0                    = 0x3403,
    XBAR_EPWM_MUX27_SD2FLT2_CEVT2                  = 0x3600,
    XBAR_EPWM_MUX27_INPUTXBAR12                    = 0x3601,
    XBAR_EPWM_MUX27_MCANA_FEVT1                    = 0x3602,
    XBAR_EPWM_MUX27_CLBINPUTXBAR12                 = 0x3603,
    XBAR_EPWM_MUX28_SD2FLT3_CEVT1                  = 0x3800,
    XBAR_EPWM_MUX28_SD2FLT3_CEVT1_OR_CEVT2         = 0x3801,
    XBAR_EPWM_MUX28_MCANB_FEVT1                    = 0x3803,
    XBAR_EPWM_MUX29_SD2FLT3_CEVT2                  = 0x3A00,
    XBAR_EPWM_MUX29_INPUTXBAR13                    = 0x3A01,
    XBAR_EPWM_MUX29_MCANA_FEVT2                    = 0x3A02,
    XBAR_EPWM_MUX29_CLBINPUTXBAR13                 = 0x3A03,
    XBAR_EPWM_MUX30_SD2FLT4_CEVT1                  = 0x3C00,
    XBAR_EPWM_MUX30_SD2FLT4_CEVT1_OR_CEVT2         = 0x3C01,
    XBAR_EPWM_MUX30_MCANB_FEVT2                    = 0x3C03,
    XBAR_EPWM_MUX31_SD2FLT4_CEVT2                  = 0x3E00,
    XBAR_EPWM_MUX31_INPUTXBAR14                    = 0x3E01,
    XBAR_EPWM_MUX31_ERRORSTS                       = 0x3E02,
    XBAR_EPWM_MUX31_CLBINPUTXBAR14                 = 0x3E03,
    XBAR_EPWM_MUX32_EPWM1_TRIPOUT                  = 0x4000,
    XBAR_EPWM_MUX32_EPWM1_DEMONTRIP                = 0x4001,
    XBAR_EPWM_MUX32_EPWM1_DE_ACTIVE                = 0x4002,
    XBAR_EPWM_MUX32_ECAP1_TRIPOUT                  = 0x4003,
    XBAR_EPWM_MUX33_EPWM2_TRIPOUT                  = 0x4200,
    XBAR_EPWM_MUX33_EPWM2_DEMONTRIP                = 0x4201,
    XBAR_EPWM_MUX33_EPWM2_DE_ACTIVE                = 0x4202,
    XBAR_EPWM_MUX33_ECAP2_TRIPOUT                  = 0x4203,
    XBAR_EPWM_MUX34_EPWM3_TRIPOUT                  = 0x4400,
    XBAR_EPWM_MUX34_EPWM3_DEMONTRIP                = 0x4401,
    XBAR_EPWM_MUX34_EPWM3_DE_ACTIVE                = 0x4402,
    XBAR_EPWM_MUX34_ECAP3_TRIPOUT                  = 0x4403,
    XBAR_EPWM_MUX35_EPWM4_TRIPOUT                  = 0x4600,
    XBAR_EPWM_MUX35_EPWM4_DEMONTRIP                = 0x4601,
    XBAR_EPWM_MUX35_EPWM4_DE_ACTIVE                = 0x4602,
    XBAR_EPWM_MUX36_EPWM5_TRIPOUT                  = 0x4800,
    XBAR_EPWM_MUX36_EPWM5_DEMONTRIP                = 0x4801,
    XBAR_EPWM_MUX36_EPWM5_DE_ACTIVE                = 0x4802,
    XBAR_EPWM_MUX37_EPWM6_TRIPOUT                  = 0x4A00,
    XBAR_EPWM_MUX37_EPWM6_DEMONTRIP                = 0x4A01,
    XBAR_EPWM_MUX37_EPWM6_DE_ACTIVE                = 0x4A02,
    XBAR_EPWM_MUX38_EPWM7_TRIPOUT                  = 0x4C00,
    XBAR_EPWM_MUX38_EPWM7_DEMONTRIP                = 0x4C01,
    XBAR_EPWM_MUX38_EPWM7_DE_ACTIVE                = 0x4C02,
    XBAR_EPWM_MUX39_EPWM8_TRIPOUT                  = 0x4E00,
    XBAR_EPWM_MUX39_EPWM8_DEMONTRIP                = 0x4E01,
    XBAR_EPWM_MUX39_EPWM8_DE_ACTIVE                = 0x4E02,
    XBAR_EPWM_MUX48_PIEERR                         = 0x6003,
    XBAR_EPWM_MUX49_ECCERR                         = 0x6203,
    XBAR_EPWM_MUX50_INPUTXBAR15                    = 0x6401,
    XBAR_EPWM_MUX50_CLB1_OUT0                      = 0x6402,
    XBAR_EPWM_MUX51_INPUTXBAR16                    = 0x6601,
    XBAR_EPWM_MUX51_CLB1_OUT1                      = 0x6602,
    XBAR_EPWM_MUX52_ERAD_EVT0                      = 0x6801,
    XBAR_EPWM_MUX52_CLB1_OUT2                      = 0x6802,
    XBAR_EPWM_MUX53_ERAD_EVT1                      = 0x6A01,
    XBAR_EPWM_MUX53_CLB1_OUT3                      = 0x6A02,
    XBAR_EPWM_MUX54_ERAD_EVT2                      = 0x6C01,
    XBAR_EPWM_MUX54_CLB1_OUT6                      = 0x6C02,
    XBAR_EPWM_MUX55_ERAD_EVT3                      = 0x6E01,
    XBAR_EPWM_MUX55_CLB1_OUT7                      = 0x6E02,
    XBAR_EPWM_MUX56_ERAD_EVT4                      = 0x7001,
    XBAR_EPWM_MUX56_CLB2_OUT0                      = 0x7002,
    XBAR_EPWM_MUX57_ERAD_EVT5                      = 0x7201,
    XBAR_EPWM_MUX57_CLB2_OUT1                      = 0x7202,
    XBAR_EPWM_MUX58_ERAD_EVT6                      = 0x7401,
    XBAR_EPWM_MUX58_CLB2_OUT2                      = 0x7402,
    XBAR_EPWM_MUX59_ERAD_EVT7                      = 0x7601,
    XBAR_EPWM_MUX59_CLB2_OUT3                      = 0x7602,
    XBAR_EPWM_MUX60_ERAD_EVT8                      = 0x7801,
    XBAR_EPWM_MUX60_CLB2_OUT6                      = 0x7802,
    XBAR_EPWM_MUX61_ERAD_EVT9                      = 0x7A01,
    XBAR_EPWM_MUX61_CLB2_OUT7                      = 0x7A02,
#endif

#elif IS_GS32F3xx()
#if IS_GS32F3xx(0x22)
    XBAR_EPWM_MUX00_CMPSS1_CTRIPH           = 0x0000,
    XBAR_EPWM_MUX00_SD3FLT1_CEVT1           = 0x0001,
    XBAR_EPWM_MUX00_ADCAEVT1                = 0x0002,
    XBAR_EPWM_MUX00_ECAP1_OUT               = 0x0003,
    XBAR_EPWM_MUX01_CMPSS1_CTRIPL           = 0x0200,
    XBAR_EPWM_MUX01_INPUTXBAR1              = 0x0201,
    XBAR_EPWM_MUX01_CLB1_OUT1               = 0x0202,
    XBAR_EPWM_MUX01_ADCCEVT1                = 0x0203,
    XBAR_EPWM_MUX02_CMPSS2_CTRIPH           = 0x0400,
    XBAR_EPWM_MUX02_SD3FLT1_CEVT2           = 0x0401,
    XBAR_EPWM_MUX02_ADCAEVT2                = 0x0402,
    XBAR_EPWM_MUX02_ECAP2_OUT               = 0x0403,
    XBAR_EPWM_MUX03_CMPSS2_CTRIPL           = 0x0600,
    XBAR_EPWM_MUX03_INPUTXBAR2              = 0x0601,
    XBAR_EPWM_MUX03_CLB1_OUT2               = 0x0602,
    XBAR_EPWM_MUX03_ADCCEVT2                = 0x0603,
    XBAR_EPWM_MUX04_CMPSS3_CTRIPH           = 0x0800,
    XBAR_EPWM_MUX04_SD3FLT2_CEVT1           = 0x0801,
    XBAR_EPWM_MUX04_ADCAEVT3                = 0x0802,
    XBAR_EPWM_MUX04_ECAP3_OUT               = 0x0803,
    XBAR_EPWM_MUX05_CMPSS3_CTRIPL           = 0x0A00,
    XBAR_EPWM_MUX05_INPUTXBAR3              = 0x0A01,
    XBAR_EPWM_MUX05_CLB1_OUT3               = 0x0A02,
    XBAR_EPWM_MUX05_ADCCEVT3                = 0x0A03,
    XBAR_EPWM_MUX06_CMPSS4_CTRIPH           = 0x0C00,
    XBAR_EPWM_MUX06_SD3FLT2_CEVT2           = 0x0C01,
    XBAR_EPWM_MUX06_ADCAEVT4                = 0x0C02,
    XBAR_EPWM_MUX06_ECAP4_OUT               = 0x0C03,
    XBAR_EPWM_MUX07_CMPSS4_CTRIPL           = 0x0E00,
    XBAR_EPWM_MUX07_INPUTXBAR4              = 0x0E01,
    XBAR_EPWM_MUX07_CLB1_OUT4               = 0x0E02,
    XBAR_EPWM_MUX07_ADCCEVT4                = 0x0E03,
    XBAR_EPWM_MUX08_CMPSS5_CTRIPH           = 0x1000,
    XBAR_EPWM_MUX08_SD3FLT3_CEVT1           = 0x1001,
    XBAR_EPWM_MUX08_ADCBEVT1                = 0x1002,
    XBAR_EPWM_MUX08_ECAP5_OUT               = 0x1003,
    XBAR_EPWM_MUX09_CMPSS5_CTRIPL           = 0x1200,
    XBAR_EPWM_MUX09_INPUTXBAR5              = 0x1201,
    XBAR_EPWM_MUX09_CLB1_OUT5               = 0x1202,
    XBAR_EPWM_MUX09_ADCDEVT1                = 0x1203,
    XBAR_EPWM_MUX10_CMPSS6_CTRIPH           = 0x1400,
    XBAR_EPWM_MUX10_SD3FLT3_CEVT2           = 0x1401,
    XBAR_EPWM_MUX10_ADCBEVT2                = 0x1402,
    XBAR_EPWM_MUX10_ECAP6_OUT               = 0x1403,
    XBAR_EPWM_MUX11_CMPSS6_CTRIPL           = 0x1600,
    XBAR_EPWM_MUX11_INPUTXBAR6              = 0x1601,
    XBAR_EPWM_MUX11_CLB1_OUT6               = 0x1602,
    XBAR_EPWM_MUX11_ADCDEVT2                = 0x1603,
    XBAR_EPWM_MUX12_CMPSS7_CTRIPH           = 0x1800,
    XBAR_EPWM_MUX12_SD3FLT4_CEVT1           = 0x1801,
    XBAR_EPWM_MUX12_ADCBEVT3                = 0x1802,
    XBAR_EPWM_MUX12_ECAP7_OUT               = 0x1803,
    XBAR_EPWM_MUX13_CMPSS7_CTRIPL           = 0x1A00,
    XBAR_EPWM_MUX13_ADCSOCAO                = 0x1A01,
    XBAR_EPWM_MUX13_CLB1_OUT7               = 0x1A02,
    XBAR_EPWM_MUX13_ADCDEVT3                = 0x1A03,
    XBAR_EPWM_MUX14_CMPSS8_CTRIPH           = 0x1C00,
    XBAR_EPWM_MUX14_SD3FLT4_CEVT2           = 0x1C01,
    XBAR_EPWM_MUX14_ADCBEVT4                = 0x1C02,
    XBAR_EPWM_MUX14_EXTSYNCOUT              = 0x1C03,
    XBAR_EPWM_MUX15_CMPSS8_CTRIPL           = 0x1E00,
    XBAR_EPWM_MUX15_ADCSOCBO                = 0x1E01,
    XBAR_EPWM_MUX15_CLB1_OUT8               = 0x1E02,
    XBAR_EPWM_MUX15_ADCDEVT4                = 0x1E03,
    XBAR_EPWM_MUX16_SD1FLT1_CEVT1           = 0x2000,
    XBAR_EPWM_MUX16_SD4FLT1_CEVT1           = 0x2001,
    XBAR_EPWM_MUX16_CLBINPUTXBAR7           = 0x2002,
    XBAR_EPWM_MUX17_SD1FLT1_CEVT2           = 0x2200,
    XBAR_EPWM_MUX17_INPUTXBAR7              = 0x2201,
    XBAR_EPWM_MUX17_CLB1_OUT9               = 0x2202,
    XBAR_EPWM_MUX17_HALT                    = 0x2203,
    XBAR_EPWM_MUX18_SD1FLT2_CEVT1           = 0x2400,
    XBAR_EPWM_MUX18_SD4FLT1_CEVT2           = 0x2401,
    XBAR_EPWM_MUX18_CLBINPUTXBAR8           = 0x2402,
    XBAR_EPWM_MUX19_SD1FLT2_CEVT2           = 0x2600,
    XBAR_EPWM_MUX19_INPUTXBAR8              = 0x2601,
    XBAR_EPWM_MUX19_CLB1_OUT10              = 0x2602,
    XBAR_EPWM_MUX19_ERRORSTS                = 0x2603,
    XBAR_EPWM_MUX20_SD1FLT3_CEVT1           = 0x2800,
    XBAR_EPWM_MUX20_SD4FLT2_CEVT1           = 0x2801,
    XBAR_EPWM_MUX20_CLBINPUTXBAR9           = 0x2802,
    XBAR_EPWM_MUX21_SD1FLT3_CEVT2           = 0x2A00,
    XBAR_EPWM_MUX21_INPUTXBAR9              = 0x2A01,
    XBAR_EPWM_MUX21_CLB1_OUT11              = 0x2A02,
    XBAR_EPWM_MUX22_SD1FLT4_CEVT1           = 0x2C00,
    XBAR_EPWM_MUX22_SD4FLT2_CEVT2           = 0x2C01,
    XBAR_EPWM_MUX22_CLBINPUTXBAR10          = 0x2C02,
    XBAR_EPWM_MUX23_SD1FLT4_CEVT2           = 0x2E00,
    XBAR_EPWM_MUX23_INPUTXBAR10             = 0x2E01,
    XBAR_EPWM_MUX23_CLB1_OUT12              = 0x2E02,
    XBAR_EPWM_MUX24_SD2FLT1_CEVT1           = 0x3000,
    XBAR_EPWM_MUX24_SD4FLT3_CEVT1           = 0x3001,
    XBAR_EPWM_MUX24_CLBINPUTXBAR11          = 0x3002,
    XBAR_EPWM_MUX25_SD2FLT1_CEVT2           = 0x3200,
    XBAR_EPWM_MUX25_INPUTXBAR11             = 0x3201,
    XBAR_EPWM_MUX25_CANA_EVT                = 0x3202,
    XBAR_EPWM_MUX26_SD2FLT2_CEVT1           = 0x3400,
    XBAR_EPWM_MUX26_SD4FLT3_CEVT2           = 0x3401,
    XBAR_EPWM_MUX26_CLBINPUTXBAR12          = 0x3402,
    XBAR_EPWM_MUX27_SD2FLT2_CEVT2           = 0x3600,
    XBAR_EPWM_MUX27_INPUTXBAR12             = 0x3601,
    XBAR_EPWM_MUX27_CANB_EVT                = 0x3602,
    XBAR_EPWM_MUX28_SD2FLT3_CEVT1           = 0x3800,
    XBAR_EPWM_MUX28_SD4FLT4_CEVT1           = 0x3801,
    XBAR_EPWM_MUX28_CLBINPUTXBAR13          = 0x3802,
    XBAR_EPWM_MUX29_SD2FLT3_CEVT2           = 0x3A00,
    XBAR_EPWM_MUX29_INPUTXBAR13             = 0x3A01,
    XBAR_EPWM_MUX30_SD2FLT4_CEVT1           = 0x3C00,
    XBAR_EPWM_MUX30_SD4FLT4_CEVT2           = 0x3C01,
    XBAR_EPWM_MUX30_CLBINPUTXBAR14          = 0x3C02,
    XBAR_EPWM_MUX31_SD2FLT4_CEVT2           = 0x3E00,
    XBAR_EPWM_MUX31_INPUTXBAR14             = 0x3E01,
    XBAR_EPWM_MUX31_ERRORSTS                = 0x3E02,
    XBAR_EPWM_MUX33_INPUTXBAR15             = 0x4201,
    XBAR_EPWM_MUX33_CMPSS1_CTRIPH_OR_CTRIPL = 0x4202,
    XBAR_EPWM_MUX33_SD1FLT1_CEVT1_OR_CEVT2  = 0x4203,
    XBAR_EPWM_MUX35_INPUTXBAR16             = 0x4601,
    XBAR_EPWM_MUX35_CMPSS2_CTRIPH_OR_CTRIPL = 0x4602,
    XBAR_EPWM_MUX35_SD1FLT2_CEVT1_OR_CEVT2  = 0x4603,
    XBAR_EPWM_MUX37_ERAD_EVT0               = 0x4A01,
    XBAR_EPWM_MUX37_CMPSS3_CTRIPH_OR_CTRIPL = 0x4A02,
    XBAR_EPWM_MUX37_SD1FLT3_CEVT1_OR_CEVT2  = 0x4A03,
    XBAR_EPWM_MUX38_ERAD_EVT1               = 0x4C01,
    XBAR_EPWM_MUX39_ERAD_EVT2               = 0x4E01,
    XBAR_EPWM_MUX39_CMPSS4_CTRIPH_OR_CTRIPL = 0x4E02,
    XBAR_EPWM_MUX39_SD1FLT4_CEVT1_OR_CEVT2  = 0x4E03,
    XBAR_EPWM_MUX40_ERAD_EVT3               = 0x5001,
    XBAR_EPWM_MUX41_ERAD_EVT4               = 0x5201,
    XBAR_EPWM_MUX41_CMPSS5_CTRIPH_OR_CTRIPL = 0x5202,
    XBAR_EPWM_MUX41_SD2FLT1_CEVT1_OR_CEVT2  = 0x5203,
    XBAR_EPWM_MUX42_ERAD_EVT5               = 0x5401,
    XBAR_EPWM_MUX43_ERAD_EVT6               = 0x5601,
    XBAR_EPWM_MUX43_CMPSS6_CTRIPH_OR_CTRIPL = 0x5602,
    XBAR_EPWM_MUX43_SD2FLT2_CEVT1_OR_CEVT2  = 0x5603,
    XBAR_EPWM_MUX44_ERAD_EVT7               = 0x5801,
    XBAR_EPWM_MUX45_ERAD_EVT8               = 0x5A01,
    XBAR_EPWM_MUX45_CMPSS7_CTRIPH_OR_CTRIPL = 0x5A02,
    XBAR_EPWM_MUX45_SD2FLT3_CEVT1_OR_CEVT2  = 0x5A03,
    XBAR_EPWM_MUX46_ERAD_EVT9               = 0x5C01,
    XBAR_EPWM_MUX47_CMPSS8_CTRIPH_OR_CTRIPL = 0x5E02,
    XBAR_EPWM_MUX47_SD2FLT4_CEVT1_OR_CEVT2  = 0x5E03,
    XBAR_EPWM_MUX49_CMPSS9_CTRIPH_OR_CTRIPL = 0x6202,
    XBAR_EPWM_MUX49_SD3FLT1_CEVT1_OR_CEVT2  = 0x6203,
    XBAR_EPWM_MUX51_CMPSS10_CTRIPH_OR_CTRIPL= 0x6602,
    XBAR_EPWM_MUX51_SD3FLT2_CEVT1_OR_CEVT2  = 0x6603,
    XBAR_EPWM_MUX52_CLB2_OUT1               = 0x6801,
    XBAR_EPWM_MUX53_CLB2_OUT2               = 0x6A01,
    XBAR_EPWM_MUX53_CMPSS11_CTRIPH_OR_CTRIPL= 0x6A02,
    XBAR_EPWM_MUX53_SD3FLT3_CEVT1_OR_CEVT2  = 0x6A03,
    XBAR_EPWM_MUX54_CLB2_OUT3               = 0x6C01,
    XBAR_EPWM_MUX55_CLB2_OUT4               = 0x6E01,
    XBAR_EPWM_MUX55_CMPSS12_CTRIPH_OR_CTRIPL= 0x6E02,
    XBAR_EPWM_MUX55_SD3FLT4_CEVT1_OR_CEVT2  = 0x6E03,
    XBAR_EPWM_MUX56_CMPSS12_CTRIPH          = 0x7000,
    XBAR_EPWM_MUX56_CLB2_OUT5               = 0x7001,
    XBAR_EPWM_MUX57_CMPSS12_CTRIPL          = 0x7200,
    XBAR_EPWM_MUX57_CLB2_OUT6               = 0x7201,
    XBAR_EPWM_MUX57_SD4FLT1_CEVT1_OR_CEVT2  = 0x7203,
    XBAR_EPWM_MUX58_CMPSS9_CTRIPH           = 0x7400,
    XBAR_EPWM_MUX58_CLB2_OUT7               = 0x7401,
    XBAR_EPWM_MUX59_CMPSS9_CTRIPL           = 0x7600,
    XBAR_EPWM_MUX59_CLB2_OUT8               = 0x7601,
    XBAR_EPWM_MUX59_SD4FLT2_CEVT1_OR_CEVT2  = 0x7603,
    XBAR_EPWM_MUX60_CMPSS10_CTRIPH          = 0x7800,
    XBAR_EPWM_MUX60_CLB2_OUT9               = 0x7801,
    XBAR_EPWM_MUX61_CMPSS10_CTRIPL          = 0x7A00,
    XBAR_EPWM_MUX61_CLB2_OUT10              = 0x7A01,
    XBAR_EPWM_MUX61_SD4FLT3_CEVT1_OR_CEVT2  = 0x7A03,
    XBAR_EPWM_MUX62_CMPSS11_CTRIPH          = 0x7C00,
    XBAR_EPWM_MUX62_CLB2_OUT11              = 0x7C01,
    XBAR_EPWM_MUX63_CMPSS11_CTRIPL          = 0x7E00,
    XBAR_EPWM_MUX63_CLB2_OUT12              = 0x7E01,
    XBAR_EPWM_MUX63_SD4FLT4_CEVT1_OR_CEVT2  = 0x7E03,
#endif
#endif
} XBAR_EPWMMuxConfig;

/**
 * @brief
 *  The following values define the muxConfig parameter for XBAR_setCLBMuxConfig().
 *
 */
typedef enum
{
#if IS_GS32F00xx()
#if IS_GS32F00xx(0x12)
    XBAR_CLB_MUX00_CMPSS1_CTRIPH            = 0x0000,
    XBAR_CLB_MUX00_CMPSS1_CTRIPH_OR_CTRIPL  = 0x0001,
    XBAR_CLB_MUX00_ADCAEVT1                 = 0x0002,
    XBAR_CLB_MUX00_ECAP1_OUT                = 0x0003,
    XBAR_CLB_MUX01_CMPSS1_CTRIPL            = 0x0200,
    XBAR_CLB_MUX01_INPUTXBAR1               = 0x0201,
    XBAR_CLB_MUX01_CLB1_OUT1                = 0x0202,
    XBAR_CLB_MUX01_ADCCEVT1                 = 0x0203,
    XBAR_CLB_MUX02_CMPSS2_CTRIPH            = 0x0400,
    XBAR_CLB_MUX02_CMPSS2_CTRIPH_OR_CTRIPL  = 0x0401,
    XBAR_CLB_MUX02_ADCAEVT2                 = 0x0402,
    XBAR_CLB_MUX02_ECAP2_OUT                = 0x0403,
    XBAR_CLB_MUX03_CMPSS2_CTRIPL            = 0x0600,
    XBAR_CLB_MUX03_INPUTXBAR2               = 0x0601,
    XBAR_CLB_MUX03_CLB1_OUT2                = 0x0602,
    XBAR_CLB_MUX03_ADCCEVT2                 = 0x0603,
    XBAR_CLB_MUX04_CMPSS3_CTRIPH            = 0x0800,
    XBAR_CLB_MUX04_CMPSS3_CTRIPH_OR_CTRIPL  = 0x0801,
    XBAR_CLB_MUX04_ADCAEVT3                 = 0x0802,
    XBAR_CLB_MUX04_ECAP3_OUT                = 0x0803,
    XBAR_CLB_MUX05_CMPSS3_CTRIPL            = 0x0A00,
    XBAR_CLB_MUX05_INPUTXBAR3               = 0x0A01,
    XBAR_CLB_MUX05_CLB1_OUT3                = 0x0A02,
    XBAR_CLB_MUX05_ADCCEVT3                 = 0x0A03,
    XBAR_CLB_MUX06_CMPSS4_CTRIPH            = 0x0C00,
    XBAR_CLB_MUX06_CMPSS4_CTRIPH_OR_CTRIPL  = 0x0C01,
    XBAR_CLB_MUX06_ADCAEVT4                 = 0x0C02,
    XBAR_CLB_MUX06_ECAP4_OUT                = 0x0C03,
    XBAR_CLB_MUX07_CMPSS4_CTRIPL            = 0x0E00,
    XBAR_CLB_MUX07_INPUTXBAR4               = 0x0E01,
    XBAR_CLB_MUX07_CLB1_OUT4                = 0x0E02,
    XBAR_CLB_MUX07_ADCCEVT4                 = 0x0E03,
    XBAR_CLB_MUX08_CMPSS5_CTRIPH            = 0x1000,
    XBAR_CLB_MUX08_CMPSS5_CTRIPH_OR_CTRIPL  = 0x1001,
    XBAR_CLB_MUX08_ADCBEVT1                 = 0x1002,
    XBAR_CLB_MUX08_ECAP5_OUT                = 0x1003,
    XBAR_CLB_MUX09_CMPSS5_CTRIPL            = 0x1200,
    XBAR_CLB_MUX09_INPUTXBAR5               = 0x1201,
    XBAR_CLB_MUX09_CLB1_OUT5                = 0x1202,
    XBAR_CLB_MUX10_CMPSS6_CTRIPH            = 0x1400,
    XBAR_CLB_MUX10_CMPSS6_CTRIPH_OR_CTRIPL  = 0x1401,
    XBAR_CLB_MUX10_ADCBEVT2                 = 0x1402,
    XBAR_CLB_MUX10_ECAP6_OUT                = 0x1403,
    XBAR_CLB_MUX11_CMPSS6_CTRIPL            = 0x1600,
    XBAR_CLB_MUX11_INPUTXBAR6               = 0x1601,
    XBAR_CLB_MUX11_CLB1_OUT6                = 0x1602,
    XBAR_CLB_MUX12_CMPSS7_CTRIPH            = 0x1800,
    XBAR_CLB_MUX12_CMPSS7_CTRIPH_OR_CTRIPL  = 0x1801,
    XBAR_CLB_MUX12_ADCBEVT3                 = 0x1802,
    XBAR_CLB_MUX12_ECAP7_OUT                = 0x1803,
    XBAR_CLB_MUX13_CMPSS7_CTRIPL            = 0x1A00,
    XBAR_CLB_MUX13_ADCSOCAO                 = 0x1A01,
    XBAR_CLB_MUX13_CLB1_OUT7                = 0x1A02,
    XBAR_CLB_MUX14_ADCBEVT4                 = 0x1C02,
    XBAR_CLB_MUX14_EXTSYNCOUT               = 0x1C03,
    XBAR_CLB_MUX15_ADCSOCBO                 = 0x1E01,
    XBAR_CLB_MUX15_CLB1_OUT8                = 0x1E02,
    XBAR_CLB_MUX16_SD1FLT1_CEVT1            = 0x2000,
    XBAR_CLB_MUX16_SD1FLT1_CEVT1_OR_CEVT2   = 0x2001,
    XBAR_CLB_MUX16_SD1FLT1_COMPZ            = 0x2002,
    XBAR_CLB_MUX16_SD1FLT1_DRINT            = 0x2003,
    XBAR_CLB_MUX17_SD1FLT1_CEVT2            = 0x2200,
    XBAR_CLB_MUX17_INPUTXBAR7               = 0x2201,
    XBAR_CLB_MUX17_CLB1_OUT9                = 0x2202,
    XBAR_CLB_MUX17_HALT                     = 0x2203,
    XBAR_CLB_MUX18_SD1FLT2_CEVT1            = 0x2400,
    XBAR_CLB_MUX18_SD1FLT2_CEVT1_OR_CEVT2   = 0x2401,
    XBAR_CLB_MUX18_SD1FLT2_COMPZ            = 0x2402,
    XBAR_CLB_MUX18_SD1FLT2_DRINT            = 0x2403,
    XBAR_CLB_MUX19_SD1FLT2_CEVT2            = 0x2600,
    XBAR_CLB_MUX19_INPUTXBAR8               = 0x2601,
    XBAR_CLB_MUX19_CLB1_OUT10               = 0x2602,
    XBAR_CLB_MUX19_ERRORSTS                 = 0x2603,
    XBAR_CLB_MUX20_SD1FLT3_CEVT1            = 0x2800,
    XBAR_CLB_MUX20_SD1FLT3_CEVT1_OR_CEVT2   = 0x2801,
    XBAR_CLB_MUX20_SD1FLT3_COMPZ            = 0x2802,
    XBAR_CLB_MUX20_SD1FLT3_DRINT            = 0x2803,
    XBAR_CLB_MUX21_SD1FLT3_CEVT2            = 0x2A00,
    XBAR_CLB_MUX21_INPUTXBAR9               = 0x2A01,
    XBAR_CLB_MUX21_CLB1_OUT11               = 0x2A02,
    XBAR_CLB_MUX22_SD1FLT4_CEVT1            = 0x2C00,
    XBAR_CLB_MUX22_SD1FLT4_CEVT1_OR_CEVT2   = 0x2C01,
    XBAR_CLB_MUX22_SD1FLT4_COMPZ            = 0x2C02,
    XBAR_CLB_MUX22_SD1FLT4_DRINT            = 0x2C03,
    XBAR_CLB_MUX23_SD1FLT4_CEVT2            = 0x2E00,
    XBAR_CLB_MUX23_INPUTXBAR10              = 0x2E01,
    XBAR_CLB_MUX23_CLB1_OUT12               = 0x2E02,
    XBAR_CLB_MUX24_SD2FLT1_CEVT1            = 0x3000,
    XBAR_CLB_MUX24_SD2FLT1_CEVT1_OR_CEVT2   = 0x3001,
    XBAR_CLB_MUX24_SD2FLT1_COMPZ            = 0x3002,
    XBAR_CLB_MUX24_SD2FLT1_DRINT            = 0x3003,
    XBAR_CLB_MUX25_SD2FLT1_CEVT2            = 0x3200,
    XBAR_CLB_MUX25_INPUTXBAR11              = 0x3201,
    XBAR_CLB_MUX25_CANA_EVT                 = 0x3202,
    XBAR_CLB_MUX26_SD2FLT2_CEVT1            = 0x3400,
    XBAR_CLB_MUX26_SD2FLT2_CEVT1_OR_CEVT2   = 0x3401,
    XBAR_CLB_MUX26_SD2FLT2_COMPZ            = 0x3402,
    XBAR_CLB_MUX26_SD2FLT2_DRINT            = 0x3403,
    XBAR_CLB_MUX27_SD2FLT2_CEVT2            = 0x3600,
    XBAR_CLB_MUX27_INPUTXBAR12              = 0x3601,
    XBAR_CLB_MUX27_CANB_EVT                 = 0x3602,
    XBAR_CLB_MUX28_SD2FLT3_CEVT1            = 0x3800,
    XBAR_CLB_MUX28_SD2FLT3_CEVT1_OR_CEVT2   = 0x3801,
    XBAR_CLB_MUX28_SD2FLT3_COMPZ            = 0x3802,
    XBAR_CLB_MUX28_SD2FLT3_DRINT            = 0x3803,
    XBAR_CLB_MUX29_SD2FLT3_CEVT2            = 0x3A00,
    XBAR_CLB_MUX29_INPUTXBAR13              = 0x3A01,
    XBAR_CLB_MUX30_SD2FLT4_CEVT1            = 0x3C00,
    XBAR_CLB_MUX30_SD2FLT4_CEVT1_OR_CEVT2   = 0x3C01,
    XBAR_CLB_MUX30_SD2FLT4_COMPZ            = 0x3C02,
    XBAR_CLB_MUX30_SD2FLT4_DRINT            = 0x3C03,
    XBAR_CLB_MUX31_SD2FLT4_CEVT2            = 0x3E00,
    XBAR_CLB_MUX31_INPUTXBAR14              = 0x3E01,
    XBAR_CLB_MUX31_ERRORSTS                 = 0x3E02,
    XBAR_CLB_MUX33_INPUTXBAR15              = 0x4201,
    XBAR_CLB_MUX35_INPUTXBAR16              = 0x4601,
    XBAR_CLB_MUX52_CLB2_OUT1                = 0x6801,
    XBAR_CLB_MUX53_CLB2_OUT2                = 0x6A01,
    XBAR_CLB_MUX54_CLB2_OUT3                = 0x6C01,
    XBAR_CLB_MUX55_CLB2_OUT4                = 0x6E01,
    XBAR_CLB_MUX56_CLB2_OUT5                = 0x7001,
    XBAR_CLB_MUX57_CLB2_OUT6                = 0x7201,
    XBAR_CLB_MUX58_CLB2_OUT7                = 0x7401,
    XBAR_CLB_MUX59_CLB2_OUT8                = 0x7601,
    XBAR_CLB_MUX60_CLB2_OUT9                = 0x7801,
    XBAR_CLB_MUX61_CLB2_OUT10               = 0x7A01,
    XBAR_CLB_MUX62_CLB2_OUT11               = 0x7C01,
    XBAR_CLB_MUX63_CLB2_OUT12               = 0x7E01,
#elif IS_GS32F00xx(0x30)
    XBAR_CLB_MUX00_CMPSS1_CTRIPH                    = 0x0000,
    XBAR_CLB_MUX00_CMPSS1_CTRIPH_OR_CTRIPL          = 0x0001,
    XBAR_CLB_MUX00_ADCAEVT1                         = 0x0002,
    XBAR_CLB_MUX00_ECAP1_OUT                        = 0x0003,
    XBAR_CLB_MUX01_CMPSS1_CTRIPL                    = 0x0200,
    XBAR_CLB_MUX01_INPUTXBAR1                       = 0x0201,
    XBAR_CLB_MUX01_CLB1_OUT4                        = 0x0202,
    XBAR_CLB_MUX01_ADCCEVT1                         = 0x0203,
    XBAR_CLB_MUX02_CMPSS2_CTRIPH                    = 0x0400,
    XBAR_CLB_MUX02_CMPSS2_CTRIPH_OR_CTRIPL          = 0x0401,
    XBAR_CLB_MUX02_ADCAEVT2                         = 0x0402,
    XBAR_CLB_MUX02_ECAP2_OUT                        = 0x0403,
    XBAR_CLB_MUX03_CMPSS2_CTRIPL                    = 0x0600,
    XBAR_CLB_MUX03_INPUTXBAR2                       = 0x0601,
    XBAR_CLB_MUX03_CLB1_OUT5                        = 0x0602,
    XBAR_CLB_MUX03_ADCCEVT2                         = 0x0603,
    XBAR_CLB_MUX04_CMPSS3_CTRIPH                    = 0x0800,
    XBAR_CLB_MUX04_CMPSS3_CTRIPH_OR_CTRIPL          = 0x0801,
    XBAR_CLB_MUX04_ADCAEVT3                         = 0x0802,
    XBAR_CLB_MUX04_ECAP3_OUT                        = 0x0803,
    XBAR_CLB_MUX05_CMPSS3_CTRIPL                    = 0x0A00,
    XBAR_CLB_MUX05_INPUTXBAR3                       = 0x0A01,
    XBAR_CLB_MUX05_CLB2_OUT4                        = 0x0A02,
    XBAR_CLB_MUX05_ADCCEVT3                         = 0x0A03,
    XBAR_CLB_MUX06_CMPSS4_CTRIPH                    = 0x0C00,
    XBAR_CLB_MUX06_CMPSS4_CTRIPH_OR_CTRIPL          = 0x0C01,
    XBAR_CLB_MUX06_ADCAEVT4                         = 0x0C02,
    XBAR_CLB_MUX07_CMPSS4_CTRIPL                    = 0x0E00,
    XBAR_CLB_MUX07_INPUTXBAR4                       = 0x0E01,
    XBAR_CLB_MUX07_CLB2_OUT5                        = 0x0E02,
    XBAR_CLB_MUX07_ADCCEVT4                         = 0x0E03,
    XBAR_CLB_MUX09_INPUTXBAR5                       = 0x1201,
    XBAR_CLB_MUX11_INPUTXBAR6                       = 0x1601,
    XBAR_CLB_MUX13_ADCSOCAO                         = 0x1A01,
    XBAR_CLB_MUX14_EXTSYNCOUT                       = 0x1C03,
    XBAR_CLB_MUX15_ADCSOCBO                         = 0x1E01,
    XBAR_CLB_MUX16_SD1FLT1_CEVT1                    = 0x2000,
    XBAR_CLB_MUX16_SD1FLT1_CEVT1_OR_CEVT2           = 0x2001,
    XBAR_CLB_MUX16_SD1FLT1_COMPZ                    = 0x2002,
    XBAR_CLB_MUX16_SD1FLT1_DRINT                    = 0x2003,
    XBAR_CLB_MUX17_SD1FLT1_CEVT2                    = 0x2200,
    XBAR_CLB_MUX17_INPUTXBAR7                       = 0x2201,
    XBAR_CLB_MUX17_HALT                             = 0x2203,
    XBAR_CLB_MUX18_SD1FLT2_CEVT1                    = 0x2400,
    XBAR_CLB_MUX18_SD1FLT2_CEVT1_OR_CEVT2           = 0x2401,
    XBAR_CLB_MUX18_SD1FLT2_COMPZ                    = 0x2402,
    XBAR_CLB_MUX18_SD1FLT2_DRINT                    = 0x2403,
    XBAR_CLB_MUX19_SD1FLT2_CEVT2                    = 0x2600,
    XBAR_CLB_MUX19_INPUTXBAR8                       = 0x2601,
    XBAR_CLB_MUX19_ERRORSTS                         = 0x2603,
    XBAR_CLB_MUX20_SD1FLT3_CEVT1                    = 0x2800,
    XBAR_CLB_MUX20_SD1FLT3_CEVT1_OR_CEVT2           = 0x2801,
    XBAR_CLB_MUX20_SD1FLT3_COMPZ                    = 0x2802,
    XBAR_CLB_MUX20_SD1FLT3_DRINT                    = 0x2803,
    XBAR_CLB_MUX21_SD1FLT3_CEVT2                    = 0x2A00,
    XBAR_CLB_MUX21_INPUTXBAR9                       = 0x2A01,
    XBAR_CLB_MUX22_SD1FLT4_CEVT1                    = 0x2C00,
    XBAR_CLB_MUX22_SD1FLT4_CEVT1_OR_CEVT2           = 0x2C01,
    XBAR_CLB_MUX22_SD1FLT4_COMPZ                    = 0x2C02,
    XBAR_CLB_MUX22_SD1FLT4_DRINT                    = 0x2C03,
    XBAR_CLB_MUX23_SD1FLT4_CEVT2                    = 0x2E00,
    XBAR_CLB_MUX23_INPUTXBAR10                      = 0x2E01,
    XBAR_CLB_MUX24_SD2FLT1_CEVT1                    = 0x3000,
    XBAR_CLB_MUX24_SD2FLT1_CEVT1_OR_CEVT2           = 0x3001,
    XBAR_CLB_MUX24_SD2FLT1_COMPZ                    = 0x3002,
    XBAR_CLB_MUX24_SD2FLT1_DRINT                    = 0x3003,
    XBAR_CLB_MUX25_SD2FLT1_CEVT2                    = 0x3200,
    XBAR_CLB_MUX25_INPUTXBAR11                      = 0x3201,
    XBAR_CLB_MUX25_CANA_EVT                         = 0x3202,
    XBAR_CLB_MUX26_SD2FLT2_CEVT1                    = 0x3400,
    XBAR_CLB_MUX26_SD2FLT2_CEVT1_OR_CEVT2           = 0x3401,
    XBAR_CLB_MUX26_SD2FLT2_COMPZ                    = 0x3402,
    XBAR_CLB_MUX26_SD2FLT2_DRINT                    = 0x3403,
    XBAR_CLB_MUX27_SD2FLT2_CEVT2                    = 0x3600,
    XBAR_CLB_MUX27_INPUTXBAR12                      = 0x3601,
    XBAR_CLB_MUX27_CANB_EVT                         = 0x3602,
    XBAR_CLB_MUX28_SD2FLT3_CEVT1                    = 0x3800,
    XBAR_CLB_MUX28_SD2FLT3_CEVT1_OR_CEVT2           = 0x3801,
    XBAR_CLB_MUX28_SD2FLT3_COMPZ                    = 0x3802,
    XBAR_CLB_MUX28_SD2FLT3_DRINT                    = 0x3803,
    XBAR_CLB_MUX29_SD2FLT3_CEVT2                    = 0x3A00,
    XBAR_CLB_MUX29_INPUTXBAR13                      = 0x3A01,
    XBAR_CLB_MUX30_SD2FLT4_CEVT1                    = 0x3C00,
    XBAR_CLB_MUX30_SD2FLT4_CEVT1_OR_CEVT2           = 0x3C01,
    XBAR_CLB_MUX30_SD2FLT4_COMPZ                    = 0x3C02,
    XBAR_CLB_MUX30_SD2FLT4_DRINT                    = 0x3C03,
    XBAR_CLB_MUX31_SD2FLT4_CEVT2                    = 0x3E00,
    XBAR_CLB_MUX31_INPUTXBAR14                      = 0x3E01,
    XBAR_CLB_MUX31_ERRORSTS                         = 0x3E02,
    XBAR_CLB_MUX50_INPUTXBAR15                      = 0x6401,
    XBAR_CLB_MUX50_CLB1_OUT0                        = 0x6402,
    XBAR_CLB_MUX51_INPUTXBAR16                      = 0x6601,
    XBAR_CLB_MUX51_CLB1_OUT1                        = 0x6602,
    XBAR_CLB_MUX52_ERAD_EVT0                        = 0x6801,
    XBAR_CLB_MUX52_CLB1_OUT2                        = 0x6802,
    XBAR_CLB_MUX53_ERAD_EVT1                        = 0x6A01,
    XBAR_CLB_MUX53_CLB1_OUT3                        = 0x6A02,
    XBAR_CLB_MUX54_ERAD_EVT2                        = 0x6C01,
    XBAR_CLB_MUX54_CLB1_OUT6                        = 0x6C02,
    XBAR_CLB_MUX55_ERAD_EVT3                        = 0x6E01,
    XBAR_CLB_MUX55_CLB1_OUT7                        = 0x6E02,
    XBAR_CLB_MUX56_ERAD_EVT4                        = 0x7001,
    XBAR_CLB_MUX56_CLB2_OUT0                        = 0x7002,
    XBAR_CLB_MUX57_ERAD_EVT5                        = 0x7201,
    XBAR_CLB_MUX57_CLB2_OUT1                        = 0x7202,
    XBAR_CLB_MUX58_ERAD_EVT6                        = 0x7401,
    XBAR_CLB_MUX58_CLB2_OUT2                        = 0x7402,
    XBAR_CLB_MUX59_ERAD_EVT7                        = 0x7601,
    XBAR_CLB_MUX59_CLB2_OUT3                        = 0x7602,
    XBAR_CLB_MUX60_ERAD_EVT8                        = 0x7801,
    XBAR_CLB_MUX60_CLB2_OUT6                        = 0x7802,
    XBAR_CLB_MUX61_ERAD_EVT9                        = 0x7A01,
    XBAR_CLB_MUX61_CLB2_OUT7                        = 0x7A02,



#endif
#elif IS_GS32F3xx()
#if IS_GS32F3xx(0x22)
   XBAR_CLB_MUX00_CMPSS1_CTRIPH                    = 0x0000,
   XBAR_CLB_MUX00_SD3FLT1_CEVT1                    = 0x0001,
   XBAR_CLB_MUX00_ADCAEVT1                         = 0x0002,
   XBAR_CLB_MUX00_ECAP1_CLB                        = 0x0003,
   XBAR_CLB_MUX01_CMPSS1_CTRIPL                    = 0x0200,
   XBAR_CLB_MUX01_INPUTXBAR1                       = 0x0201,
   XBAR_CLB_MUX01_CLB1_CLB1                        = 0x0202,
   XBAR_CLB_MUX01_ADCCEVT1                         = 0x0203,
   XBAR_CLB_MUX02_CMPSS2_CTRIPH                    = 0x0400,
   XBAR_CLB_MUX02_SD3FLT1_CEVT2                    = 0x0401,
   XBAR_CLB_MUX02_ADCAEVT2                         = 0x0402,
   XBAR_CLB_MUX02_ECAP2_CLB                        = 0x0403,
   XBAR_CLB_MUX03_CMPSS2_CTRIPL                    = 0x0600,
   XBAR_CLB_MUX03_INPUTXBAR2                       = 0x0601,
   XBAR_CLB_MUX03_CLB1_CLB2                        = 0x0602,
   XBAR_CLB_MUX03_ADCCEVT2                         = 0x0603,
   XBAR_CLB_MUX04_CMPSS3_CTRIPH                    = 0x0800,
   XBAR_CLB_MUX04_SD3FLT2_CEVT1                    = 0x0801,
   XBAR_CLB_MUX04_ADCAEVT3                         = 0x0802,
   XBAR_CLB_MUX04_ECAP3_CLB                        = 0x0803,
   XBAR_CLB_MUX05_CMPSS3_CTRIPL                    = 0x0A00,
   XBAR_CLB_MUX05_INPUTXBAR3                       = 0x0A01,
   XBAR_CLB_MUX05_CLB1_CLB3                        = 0x0A02,
   XBAR_CLB_MUX05_ADCCEVT3                         = 0x0A03,
   XBAR_CLB_MUX06_CMPSS4_CTRIPH                    = 0x0C00,
   XBAR_CLB_MUX06_SD3FLT2_CEVT2                    = 0x0C01,
   XBAR_CLB_MUX06_ADCAEVT4                         = 0x0C02,
   XBAR_CLB_MUX06_ECAP4_CLB                        = 0x0C03,
   XBAR_CLB_MUX07_CMPSS4_CTRIPL                    = 0x0E00,
   XBAR_CLB_MUX07_INPUTXBAR4                       = 0x0E01,
   XBAR_CLB_MUX07_CLB1_CLB4                        = 0x0E02,
   XBAR_CLB_MUX07_ADCCEVT4                         = 0x0E03,
   XBAR_CLB_MUX08_CMPSS5_CTRIPH                    = 0x1000,
   XBAR_CLB_MUX08_SD3FLT3_CEVT1                    = 0x1001,
   XBAR_CLB_MUX08_ADCBEVT1                         = 0x1002,
   XBAR_CLB_MUX08_ECAP5_CLB                        = 0x1003,
   XBAR_CLB_MUX09_CMPSS5_CTRIPL                    = 0x1200,
   XBAR_CLB_MUX09_INPUTXBAR5                       = 0x1201,
   XBAR_CLB_MUX09_CLB1_CLB5                        = 0x1202,
   XBAR_CLB_MUX09_ADCDEVT1                         = 0x1203,
   XBAR_CLB_MUX10_CMPSS6_CTRIPH                    = 0x1400,
   XBAR_CLB_MUX10_SD3FLT3_CEVT2                    = 0x1401,
   XBAR_CLB_MUX10_ADCBEVT2                         = 0x1402,
   XBAR_CLB_MUX10_ECAP6_CLB                        = 0x1403,
   XBAR_CLB_MUX11_CMPSS6_CTRIPL                    = 0x1600,
   XBAR_CLB_MUX11_INPUTXBAR6                       = 0x1601,
   XBAR_CLB_MUX11_CLB1_CLB6                        = 0x1602,
   XBAR_CLB_MUX11_ADCDEVT2                         = 0x1603,
   XBAR_CLB_MUX12_CMPSS7_CTRIPH                    = 0x1800,
   XBAR_CLB_MUX12_SD3FLT4_CEVT1                    = 0x1801,
   XBAR_CLB_MUX12_ADCBEVT3                         = 0x1802,
   XBAR_CLB_MUX12_ECAP7_CLB                        = 0x1803,
   XBAR_CLB_MUX13_CMPSS7_CTRIPL                    = 0x1A00,
   XBAR_CLB_MUX13_ADCSOCAO                         = 0x1A01,
   XBAR_CLB_MUX13_CLB1_CLB7                        = 0x1A02,
   XBAR_CLB_MUX13_ADCDEVT3                         = 0x1A03,
   XBAR_CLB_MUX14_CMPSS8_CTRIPH                    = 0x1C00,
   XBAR_CLB_MUX14_SD3FLT4_CEVT2                    = 0x1C01,
   XBAR_CLB_MUX14_ADCBEVT4                         = 0x1C02,
   XBAR_CLB_MUX14_EXTSYNCCLB                       = 0x1C03,
   XBAR_CLB_MUX15_CMPSS8_CTRIPL                    = 0x1E00,
   XBAR_CLB_MUX15_ADCSOCBO                         = 0x1E01,
   XBAR_CLB_MUX15_CLB1_CLB8                        = 0x1E02,
   XBAR_CLB_MUX15_ADCDEVT4                         = 0x1E03,
   XBAR_CLB_MUX16_SD1FLT1_CEVT1                    = 0x2000,
   XBAR_CLB_MUX16_SD4FLT1_CEVT1                    = 0x2001,
   XBAR_CLB_MUX17_SD1FLT1_CEVT2                    = 0x2200,
   XBAR_CLB_MUX17_INPUTXBAR7                       = 0x2201,
   XBAR_CLB_MUX17_CLB1_CLB9                        = 0x2202,
   XBAR_CLB_MUX17_HALT                             = 0x2203,
   XBAR_CLB_MUX18_SD1FLT2_CEVT1                    = 0x2400,
   XBAR_CLB_MUX18_SD4FLT1_CEVT2                    = 0x2401,
   XBAR_CLB_MUX19_SD1FLT2_CEVT2                    = 0x2600,
   XBAR_CLB_MUX19_INPUTXBAR8                       = 0x2601,
   XBAR_CLB_MUX19_CLB1_CLB10                       = 0x2602,
   XBAR_CLB_MUX19_ERRORSTS                         = 0x2603,
   XBAR_CLB_MUX20_SD1FLT3_CEVT1                    = 0x2800,
   XBAR_CLB_MUX20_SD4FLT2_CEVT1                    = 0x2801,
   XBAR_CLB_MUX20_CMPSS12_CTRIPH                   = 0x2803,
   XBAR_CLB_MUX21_SD1FLT3_CEVT2                    = 0x2A00,
   XBAR_CLB_MUX21_INPUTXBAR9                       = 0x2A01,
   XBAR_CLB_MUX21_CLB1_CLB11                       = 0x2A02,
   XBAR_CLB_MUX22_SD1FLT4_CEVT1                    = 0x2C00,
   XBAR_CLB_MUX22_SD4FLT2_CEVT2                    = 0x2C01,
   XBAR_CLB_MUX22_CMPSS12_CTRIPL                   = 0x2C03,
   XBAR_CLB_MUX23_SD1FLT4_CEVT2                    = 0x2E00,
   XBAR_CLB_MUX23_INPUTXBAR10                      = 0x2E01,
   XBAR_CLB_MUX23_CLB1_CLB12                       = 0x2E02,
   XBAR_CLB_MUX24_SD2FLT1_CEVT1                    = 0x3000,
   XBAR_CLB_MUX24_SD4FLT3_CEVT1                    = 0x3001,
   XBAR_CLB_MUX24_CMPSS9_CTRIPH                    = 0x3003,
   XBAR_CLB_MUX25_SD2FLT1_CEVT2                    = 0x3200,
   XBAR_CLB_MUX25_INPUTXBAR11                      = 0x3201,
   XBAR_CLB_MUX25_CANA_EVT                         = 0x3202,
   XBAR_CLB_MUX26_SD2FLT2_CEVT1                    = 0x3400,
   XBAR_CLB_MUX26_SD4FLT3_CEVT2                    = 0x3401,
   XBAR_CLB_MUX26_CMPSS9_CTRIPL                    = 0x3403,
   XBAR_CLB_MUX27_SD2FLT2_CEVT2                    = 0x3600,
   XBAR_CLB_MUX27_INPUTXBAR12                      = 0x3601,
   XBAR_CLB_MUX27_CANB_EVT                         = 0x3602,
   XBAR_CLB_MUX28_SD2FLT3_CEVT1                    = 0x3800,
   XBAR_CLB_MUX28_SD4FLT4_CEVT1                    = 0x3801,
   XBAR_CLB_MUX28_CMPSS10_CTRIPH                   = 0x3803,
   XBAR_CLB_MUX29_SD2FLT3_CEVT2                    = 0x3A00,
   XBAR_CLB_MUX29_INPUTXBAR13                      = 0x3A01,
   XBAR_CLB_MUX29_CMPSS10_CTRIPL                   = 0x3A03,
   XBAR_CLB_MUX30_SD2FLT4_CEVT1                    = 0x3C00,
   XBAR_CLB_MUX30_SD4FLT4_CEVT2                    = 0x3C01,
   XBAR_CLB_MUX30_CMPSS11_CTRIPH                   = 0x3C03,
   XBAR_CLB_MUX31_SD2FLT4_CEVT2                    = 0x3E00,
   XBAR_CLB_MUX31_INPUTXBAR14                      = 0x3E01,
   XBAR_CLB_MUX31_CMPSS11_CTRIPL                   = 0x3E03,
   XBAR_CLB_MUX32_SD1FLT1_COMPHZ                   = 0x4002,
   XBAR_CLB_MUX32_SD1FLT1_DRINT                    = 0x4003,
   XBAR_CLB_MUX33_INPUTXBAR15                      = 0x4201,
   XBAR_CLB_MUX33_CMPSS1_CTRIPH_OR_CTRIPL          = 0x4202,
   XBAR_CLB_MUX33_SD1FLT1_CEVT1_OR_CEVT2           = 0x4203,
   XBAR_CLB_MUX34_SD1FLT2_COMPHZ                   = 0x4402,
   XBAR_CLB_MUX34_SD1FLT2_DRINT                    = 0x4403,
   XBAR_CLB_MUX35_INPUTXBAR16                      = 0x4601,
   XBAR_CLB_MUX35_CMPSS2_CTRIPH_OR_CTRIPL          = 0x4602,
   XBAR_CLB_MUX35_SD1FLT2_CEVT1_OR_CEVT2           = 0x4603,
   XBAR_CLB_MUX36_SD1FLT3_COMPHZ                   = 0x4802,
   XBAR_CLB_MUX36_SD1FLT3_DRINT                    = 0x4803,
   XBAR_CLB_MUX37_CMPSS3_CTRIPH_OR_CTRIPL          = 0x4A02,
   XBAR_CLB_MUX37_SD1FLT3_CEVT1_OR_CEVT2           = 0x4A03,
   XBAR_CLB_MUX38_SD1FLT4_COMPHZ                   = 0x4C02,
   XBAR_CLB_MUX38_SD1FLT4_DRINT                    = 0x4C03,
   XBAR_CLB_MUX39_CMPSS4_CTRIPH_OR_CTRIPL          = 0x4E02,
   XBAR_CLB_MUX39_SD1FLT4_CEVT1_OR_CEVT2           = 0x4E03,
   XBAR_CLB_MUX40_SD2FLT1_COMPHZ                   = 0x5002,
   XBAR_CLB_MUX40_SD2FLT1_DRINT                    = 0x5003,
   XBAR_CLB_MUX41_CMPSS5_CTRIPH_OR_CTRIPL          = 0x5202,
   XBAR_CLB_MUX41_SD2FLT1_CEVT1_OR_CEVT2           = 0x5203,
   XBAR_CLB_MUX42_SD2FLT2_COMPHZ                   = 0x5402,
   XBAR_CLB_MUX42_SD2FLT2_DRINT                    = 0x5403,
   XBAR_CLB_MUX43_CMPSS6_CTRIPH_OR_CTRIPL          = 0x5602,
   XBAR_CLB_MUX43_SD2FLT2_CEVT1_OR_CEVT2           = 0x5603,
   XBAR_CLB_MUX44_SD2FLT3_COMPHZ                   = 0x5802,
   XBAR_CLB_MUX44_SD2FLT3_DRINT                    = 0x5803,
   XBAR_CLB_MUX45_CMPSS7_CTRIPH_OR_CTRIPL          = 0x5A02,
   XBAR_CLB_MUX45_SD2FLT3_CEVT1_OR_CEVT2           = 0x5A03,
   XBAR_CLB_MUX46_SD2FLT4_COMPHZ                   = 0x5C02,
   XBAR_CLB_MUX46_SD2FLT4_DRINT                    = 0x5C03,
   XBAR_CLB_MUX47_CMPSS8_CTRIPH_OR_CTRIPL          = 0x5E02,
   XBAR_CLB_MUX47_SD2FLT4_CEVT1_OR_CEVT2           = 0x5E03,
   XBAR_CLB_MUX48_SD3FLT1_COMPHZ                   = 0x6002,
   XBAR_CLB_MUX48_SD3FLT1_DRINT                    = 0x6003,
   XBAR_CLB_MUX49_CMPSS9_CTRIPH_OR_CTRIPL          = 0x6202,
   XBAR_CLB_MUX49_SD3FLT1_CEVT1_OR_CEVT2           = 0x6203,
   XBAR_CLB_MUX50_SD3FLT2_COMPHZ                   = 0x6402,
   XBAR_CLB_MUX50_SD3FLT2_DRINT                    = 0x6403,
   XBAR_CLB_MUX51_CMPSS10_CTRIPH_OR_CTRIPL         = 0x6602,
   XBAR_CLB_MUX51_SD3FLT2_CEVT1_OR_CEVT2           = 0x6603,
   XBAR_CLB_MUX52_CLB2_OUT1                        = 0x6801,
   XBAR_CLB_MUX52_SD3FLT3_COMPHZ                   = 0x6802,
   XBAR_CLB_MUX52_SD3FLT3_DRINT                    = 0x6803,
   XBAR_CLB_MUX53_CLB2_OUT2                        = 0x6A01,
   XBAR_CLB_MUX53_CMPSS11_CTRIPH_OR_CTRIPL         = 0x6A02,
   XBAR_CLB_MUX53_SD3FLT3_CEVT1_OR_CEVT2           = 0x6A03,
   XBAR_CLB_MUX54_CLB2_OUT3                        = 0x6C01,
   XBAR_CLB_MUX54_SD3FLT4_COMPHZ                   = 0x6C02,
   XBAR_CLB_MUX54_SD3FLT4_DRINT                    = 0x6C03,
   XBAR_CLB_MUX55_CLB2_OUT4                        = 0x6E01,
   XBAR_CLB_MUX55_CMPSS12_CTRIPH_OR_CTRIPL         = 0x6E02,
   XBAR_CLB_MUX55_SD3FLT4_CEVT1_OR_CEVT2           = 0x6E03,
   XBAR_CLB_MUX56_CLB2_OUT5                        = 0x7001,
   XBAR_CLB_MUX56_SD4FLT1_COMPHZ                   = 0x7002,
   XBAR_CLB_MUX56_SD4FLT1_DRINT                    = 0x7003,
   XBAR_CLB_MUX57_CLB2_OUT6                        = 0x7201,
   XBAR_CLB_MUX57_SD4FLT1_CEVT1_OR_CEVT2           = 0x7203,
   XBAR_CLB_MUX58_CLB2_OUT7                        = 0x7401,
   XBAR_CLB_MUX58_SD4FLT2_COMPHZ                   = 0x7402,
   XBAR_CLB_MUX58_SD4FLT2_DRINT                    = 0x7403,
   XBAR_CLB_MUX59_CLB2_OUT8                        = 0x7601,
   XBAR_CLB_MUX59_SD4FLT2_CEVT1_OR_CEVT2           = 0x7603,
   XBAR_CLB_MUX60_CLB2_OUT9                        = 0x7801,
   XBAR_CLB_MUX60_SD4FLT3_COMPHZ                   = 0x7802,
   XBAR_CLB_MUX60_SD4FLT3_DRINT                    = 0x7803,
   XBAR_CLB_MUX61_CLB2_OUT10                       = 0x7A01,
   XBAR_CLB_MUX61_SD4FLT3_CEVT1_OR_CEVT2           = 0x7A03,
   XBAR_CLB_MUX62_CLB2_OUT11                       = 0x7C01,
   XBAR_CLB_MUX62_SD4FLT4_COMPHZ                   = 0x7C02,
   XBAR_CLB_MUX62_SD4FLT4_DRINT                    = 0x7C03,
   XBAR_CLB_MUX63_CLB2_OUT12                       = 0x7E01,
   XBAR_CLB_MUX63_SD4FLT4_CEVT1_OR_CEVT2           = 0x7E03,
#endif
#endif
} XBAR_CLBMuxConfig;

#if IS_GS32F00xx(0x30)
/**
 * @brief add ICL_XBAR Signal defination base 3.0
 *
 */
typedef enum
{
    XBAR_ICL_MUX00_EPWM1A_MINDB  ,
    XBAR_ICL_MUX01_EPWM1B_MINDB  ,
    XBAR_ICL_MUX02_EPWM2A_MINDB  ,
    XBAR_ICL_MUX03_EPWM2B_MINDB  ,
    XBAR_ICL_MUX04_EPWM3A_MINDB  ,
    XBAR_ICL_MUX05_EPWM3B_MINDB  ,
    XBAR_ICL_MUX06_EPWM4A_MINDB  ,
    XBAR_ICL_MUX07_EPWM4B_MINDB  ,
    XBAR_ICL_MUX08_EPWM5A_MINDB  ,
    XBAR_ICL_MUX09_EPWM5B_MINDB  ,
    XBAR_ICL_MUX10_EPWM6A_MINDB  ,
    XBAR_ICL_MUX11_EPWM6B_MINDB  ,
    XBAR_ICL_MUX12_EPWM7A_MINDB  ,
    XBAR_ICL_MUX13_EPWM7B_MINDB  ,
    XBAR_ICL_MUX14_EPWM8A_MINDB  ,
    XBAR_ICL_MUX15_EPWM8B_MINDB  ,
    XBAR_ICL_MUX36_CLB1_OUT4  ,
    XBAR_ICL_MUX37_CLB1_OUT5  ,
    XBAR_ICL_MUX38_CLB2_OUT4  ,
    XBAR_ICL_MUX39_CLB2_OUT5  ,
    XBAR_ICL_MUX52_CLB1_OUT0  ,
    XBAR_ICL_MUX53_CLB1_OUT1  ,
    XBAR_ICL_MUX54_CLB1_OUT2  ,
    XBAR_ICL_MUX55_CLB1_OUT3  ,
    XBAR_ICL_MUX56_CLB1_OUT6  ,
    XBAR_ICL_MUX57_CLB1_OUT7  ,
    XBAR_ICL_MUX58_CLB2_OUT0  ,
    XBAR_ICL_MUX59_CLB2_OUT1  ,
    XBAR_ICL_MUX60_CLB2_OUT2  ,
    XBAR_ICL_MUX61_CLB2_OUT3  ,
    XBAR_ICL_MUX62_CLB2_OUT6  ,
    XBAR_ICL_MUX63_CLB2_OUT7

}XBAR_ICLINPUT;
#endif
#if  IS_GS32F00xx(0x30)
/**
 * @brief add MINDBXBAR Signal base 3.0
 *
 */
typedef enum
{
    XBAR_MINDB_MUX00_EPWM1A_DB_NO_HR ,
    XBAR_MINDB_MUX01_EPWM1B_DB_NO_HR ,
    XBAR_MINDB_MUX02_EPWM2A_DB_NO_HR ,
    XBAR_MINDB_MUX03_EPWM2B_DB_NO_HR ,
    XBAR_MINDB_MUX04_EPWM3A_DB_NO_HR ,
    XBAR_MINDB_MUX05_EPWM3B_DB_NO_HR ,
    XBAR_MINDB_MUX06_EPWM4A_DB_NO_HR ,
    XBAR_MINDB_MUX07_EPWM4B_DB_NO_HR ,
    XBAR_MINDB_MUX08_EPWM5A_DB_NO_HR ,
    XBAR_MINDB_MUX09_EPWM5B_DB_NO_HR ,
    XBAR_MINDB_MUX10_EPWM6A_DB_NO_HR ,
    XBAR_MINDB_MUX11_EPWM6B_DB_NO_HR ,
    XBAR_MINDB_MUX12_EPWM7A_DB_NO_HR ,
    XBAR_MINDB_MUX13_EPWM7B_DB_NO_HR ,
    XBAR_MINDB_MUX14_EPWM8A_DB_NO_HR ,
    XBAR_MINDB_MUX15_EPWM8B_DB_NO_HR ,
    XBAR_MINDB_MUX36_CLB1_OUT4 ,
    XBAR_MINDB_MUX37_CLB1_OUT5 ,
    XBAR_MINDB_MUX38_CLB2_OUT4 ,
    XBAR_MINDB_MUX39_CLB2_OUT5 ,
    XBAR_MINDB_MUX52_CLB1_OUT0 ,
    XBAR_MINDB_MUX53_CLB1_OUT1 ,
    XBAR_MINDB_MUX54_CLB1_OUT2 ,
    XBAR_MINDB_MUX55_CLB1_OUT3 ,
    XBAR_MINDB_MUX56_CLB1_OUT6 ,
    XBAR_MINDB_MUX57_CLB1_OUT7 ,
    XBAR_MINDB_MUX58_CLB2_OUT0 ,
    XBAR_MINDB_MUX59_CLB2_OUT1 ,
    XBAR_MINDB_MUX60_CLB2_OUT2 ,
    XBAR_MINDB_MUX61_CLB2_OUT3 ,
    XBAR_MINDB_MUX62_CLB2_OUT6 ,
    XBAR_MINDB_MUX63_CLB2_OUT7
}XBAR_MINDBINPUT;



//*****************************************************************************
//
//! The following values define the \e signal parameter for
//! XBAR_setInputSignal().
//
//*****************************************************************************
typedef enum
{
    //
    //Inputs for MINDB XBAR
    //
    XBAR_MINDB_EPWM1A_DB_NO_HR             = 0,
	XBAR_MINDB_EPWM1B_DB_NO_HR             = 1,
	XBAR_MINDB_EPWM2A_DB_NO_HR             = 2,
	XBAR_MINDB_EPWM2B_DB_NO_HR             = 3,
	XBAR_MINDB_EPWM3A_DB_NO_HR             = 4,
	XBAR_MINDB_EPWM3B_DB_NO_HR             = 5,
	XBAR_MINDB_EPWM4A_DB_NO_HR             = 6,
	XBAR_MINDB_EPWM4B_DB_NO_HR             = 7,
	XBAR_MINDB_EPWM5A_DB_NO_HR             = 8,
	XBAR_MINDB_EPWM5B_DB_NO_HR             = 9,
	XBAR_MINDB_EPWM6A_DB_NO_HR             = 10,
	XBAR_MINDB_EPWM6B_DB_NO_HR             = 11,
	XBAR_MINDB_EPWM7A_DB_NO_HR             = 12,
	XBAR_MINDB_EPWM7B_DB_NO_HR             = 13,
	XBAR_MINDB_EPWM8A_DB_NO_HR             = 14,
	XBAR_MINDB_EPWM8B_DB_NO_HR             = 15,
	XBAR_MINDB_EPWM9A_DB_NO_HR             = 16,
	XBAR_MINDB_EPWM9B_DB_NO_HR             = 17,
	XBAR_MINDB_EPWM10A_DB_NO_HR            = 18,
	XBAR_MINDB_EPWM10B_DB_NO_HR            = 19,
	XBAR_MINDB_EPWM11A_DB_NO_HR            = 20,
	XBAR_MINDB_EPWM11B_DB_NO_HR            = 21,
	XBAR_MINDB_EPWM12A_DB_NO_HR            = 22,
	XBAR_MINDB_EPWM12B_DB_NO_HR            = 23,
	XBAR_MINDB_EPWM13A_DB_NO_HR            = 24,
	XBAR_MINDB_EPWM13B_DB_NO_HR            = 25,
	XBAR_MINDB_EPWM14A_DB_NO_HR            = 26,
	XBAR_MINDB_EPWM14B_DB_NO_HR            = 27,
	XBAR_MINDB_EPWM15A_DB_NO_HR            = 28,
	XBAR_MINDB_EPWM15B_DB_NO_HR            = 29,
	XBAR_MINDB_EPWM16A_DB_NO_HR            = 30,
	XBAR_MINDB_EPWM16B_DB_NO_HR            = 31,
	XBAR_MINDB_EPWM17A_DB_NO_HR            = 32,
	XBAR_MINDB_EPWM17B_DB_NO_HR            = 33,
	XBAR_MINDB_EPWM18A_DB_NO_HR            = 34,
	XBAR_MINDB_EPWM18B_DB_NO_HR            = 35,
	XBAR_MINDB_CLB1_OUT4                   = 36,
	XBAR_MINDB_CLB1_OUT5                   = 37,
	XBAR_MINDB_CLB2_OUT4                   = 38,
	XBAR_MINDB_CLB2_OUT5                   = 39,
	XBAR_MINDB_CLB3_OUT4                   = 40,
	XBAR_MINDB_CLB3_OUT5                   = 41,
	XBAR_MINDB_CLB4_OUT4                   = 42,
	XBAR_MINDB_CLB4_OUT5                   = 43,
	XBAR_MINDB_CLB5_OUT4                   = 44,
	XBAR_MINDB_CLB5_OUT5                   = 45,
	XBAR_MINDB_CLB6_OUT4                   = 46,
	XBAR_MINDB_CLB6_OUT5                   = 47,
	//Extended Mindb signals
	XBAR_MINDB_CLB1_OUT0                   = 52,
	XBAR_MINDB_CLB1_OUT1                   = 53,
	XBAR_MINDB_CLB1_OUT2                   = 54,
	XBAR_MINDB_CLB1_OUT3                   = 55,
	XBAR_MINDB_CLB1_OUT6                   = 56,
	XBAR_MINDB_CLB1_OUT7                   = 57,
	XBAR_MINDB_CLB2_OUT0                   = 58,
	XBAR_MINDB_CLB2_OUT1                   = 59,
	XBAR_MINDB_CLB2_OUT2                   = 60,
	XBAR_MINDB_CLB2_OUT3                   = 61,
	XBAR_MINDB_CLB2_OUT6                   = 62,
	XBAR_MINDB_CLB2_OUT7                   = 63,

    //
    //Inputs for ICL XBAR
    //
    XBAR_ICL_EPWM1A_MINDB                  = 0,
	XBAR_ICL_EPWM1B_MINDB                  = 1,
	XBAR_ICL_EPWM2A_MINDB                  = 2,
	XBAR_ICL_EPWM2B_MINDB                  = 3,
	XBAR_ICL_EPWM3A_MINDB                  = 4,
	XBAR_ICL_EPWM3B_MINDB                  = 5,
	XBAR_ICL_EPWM4A_MINDB                  = 6,
	XBAR_ICL_EPWM4B_MINDB                  = 7,
	XBAR_ICL_EPWM5A_MINDB                  = 8,
	XBAR_ICL_EPWM5B_MINDB                  = 9,
	XBAR_ICL_EPWM6A_MINDB                  = 10,
	XBAR_ICL_EPWM6B_MINDB                  = 11,
	XBAR_ICL_EPWM7A_MINDB                  = 12,
	XBAR_ICL_EPWM7B_MINDB                  = 13,
	XBAR_ICL_EPWM8A_MINDB                  = 14,
	XBAR_ICL_EPWM8B_MINDB                  = 15,
	XBAR_ICL_EPWM9A_MINDB                  = 16,
	XBAR_ICL_EPWM9B_MINDB                  = 17,
	XBAR_ICL_EPWM10A_MINDB                 = 18,
	XBAR_ICL_EPWM10B_MINDB                 = 19,
	XBAR_ICL_EPWM11A_MINDB                 = 20,
	XBAR_ICL_EPWM11B_MINDB                 = 21,
	XBAR_ICL_EPWM12A_MINDB                 = 22,
	XBAR_ICL_EPWM12B_MINDB                 = 23,
	XBAR_ICL_EPWM13A_MINDB                 = 24,
	XBAR_ICL_EPWM13B_MINDB                 = 25,
	XBAR_ICL_EPWM14A_MINDB                 = 26,
	XBAR_ICL_EPWM14B_MINDB                 = 27,
	XBAR_ICL_EPWM15A_MINDB                 = 28,
	XBAR_ICL_EPWM15B_MINDB                 = 29,
	XBAR_ICL_EPWM16A_MINDB                 = 30,
	XBAR_ICL_EPWM16B_MINDB                 = 31,
	XBAR_ICL_EPWM17A_MINDB                 = 32,
	XBAR_ICL_EPWM17B_MINDB                 = 33,
	XBAR_ICL_EPWM18A_MINDB                 = 34,
	XBAR_ICL_EPWM18B_MINDB                 = 35,
	XBAR_ICL_CLB1_OUT4                     = 36,
	XBAR_ICL_CLB1_OUT5                     = 37,
	XBAR_ICL_CLB2_OUT4                     = 38,
	XBAR_ICL_CLB2_OUT5                     = 39,
	XBAR_ICL_CLB3_OUT4                     = 40,
	XBAR_ICL_CLB3_OUT5                     = 41,
	XBAR_ICL_CLB4_OUT4                     = 42,
	XBAR_ICL_CLB4_OUT5                     = 43,
	XBAR_ICL_CLB5_OUT4                     = 44,
	XBAR_ICL_CLB5_OUT5                     = 45,
	XBAR_ICL_CLB6_OUT4                     = 46,
	XBAR_ICL_CLB6_OUT5                     = 47,

	//Extended ICL signals
	XBAR_ICL_CLB1_OUT0                   = 52,
	XBAR_ICL_CLB1_OUT1                   = 53,
	XBAR_ICL_CLB1_OUT2                   = 54,
	XBAR_ICL_CLB1_OUT3                   = 55,
	XBAR_ICL_CLB1_OUT6                   = 56,
	XBAR_ICL_CLB1_OUT7                   = 57,
	XBAR_ICL_CLB2_OUT0                   = 58,
	XBAR_ICL_CLB2_OUT1                   = 59,
	XBAR_ICL_CLB2_OUT2                   = 60,
	XBAR_ICL_CLB2_OUT3                   = 61,
	XBAR_ICL_CLB2_OUT6                   = 62,
	XBAR_ICL_CLB2_OUT7                   = 63,
} XBAR_InputSignal;
#endif

/**
 * @brief
 * The following values define the \e inputFlag parameter for XBAR_getInputFlagStatus() and XBAR_clearInputFlag().
 *
 */
typedef enum
{
#if IS_GS32F00xx()
#if IS_GS32F00xx(0x12)
    //
    // XBARFLG1
    //
    XBAR_INPUT_FLG_CMPSS7_CTRIPOUTH         = 0x001D,
    XBAR_INPUT_FLG_CMPSS7_CTRIPOUTL         = 0x001C,
    XBAR_INPUT_FLG_CMPSS6_CTRIPOUTH         = 0x001B,
    XBAR_INPUT_FLG_CMPSS6_CTRIPOUTL         = 0x001A,
    XBAR_INPUT_FLG_CMPSS5_CTRIPOUTH         = 0x0019,
    XBAR_INPUT_FLG_CMPSS5_CTRIPOUTL         = 0x0018,
    XBAR_INPUT_FLG_CMPSS4_CTRIPOUTH         = 0x0017,
    XBAR_INPUT_FLG_CMPSS4_CTRIPOUTL         = 0x0016,
    XBAR_INPUT_FLG_CMPSS3_CTRIPOUTH         = 0x0015,
    XBAR_INPUT_FLG_CMPSS3_CTRIPOUTL         = 0x0014,
    XBAR_INPUT_FLG_CMPSS2_CTRIPOUTH         = 0x0013,
    XBAR_INPUT_FLG_CMPSS2_CTRIPOUTL         = 0x0012,
    XBAR_INPUT_FLG_CMPSS1_CTRIPOUTH         = 0x0011,
    XBAR_INPUT_FLG_CMPSS1_CTRIPOUTL         = 0x0010,
    XBAR_INPUT_FLG_CMPSS7_CTRIPH            = 0x000D,
    XBAR_INPUT_FLG_CMPSS7_CTRIPL            = 0x000C,
    XBAR_INPUT_FLG_CMPSS6_CTRIPH            = 0x000B,
    XBAR_INPUT_FLG_CMPSS6_CTRIPL            = 0x000A,
    XBAR_INPUT_FLG_CMPSS5_CTRIPH            = 0x0009,
    XBAR_INPUT_FLG_CMPSS5_CTRIPL            = 0x0008,
    XBAR_INPUT_FLG_CMPSS4_CTRIPH            = 0x0007,
    XBAR_INPUT_FLG_CMPSS4_CTRIPL            = 0x0006,
    XBAR_INPUT_FLG_CMPSS3_CTRIPH            = 0x0005,
    XBAR_INPUT_FLG_CMPSS3_CTRIPL            = 0x0004,
    XBAR_INPUT_FLG_CMPSS2_CTRIPH            = 0x0003,
    XBAR_INPUT_FLG_CMPSS2_CTRIPL            = 0x0002,
    XBAR_INPUT_FLG_CMPSS1_CTRIPH            = 0x0001,
    XBAR_INPUT_FLG_CMPSS1_CTRIPL            = 0x0000,

    //
    // XBARFLG2
    //

    XBAR_INPUT_FLG_ADCC_1EVT                = 0x011F,
    XBAR_INPUT_FLG_ADCB_4EVT                = 0x011E,
    XBAR_INPUT_FLG_ADCB_3EVT                = 0x011D,
    XBAR_INPUT_FLG_ADCB_2EVT                = 0x011C,
    XBAR_INPUT_FLG_ADCB_1EVT                = 0x011B,
    XBAR_INPUT_FLG_ADCA_4EVT                = 0x011A,
    XBAR_INPUT_FLG_ADCA_3EVT                = 0x0119,
    XBAR_INPUT_FLG_ADCA_2EVT                = 0x0118,
    XBAR_INPUT_FLG_ADCA_1EVT                = 0x0117,
    XBAR_INPUT_FLG_EXTSYNCOUT               = 0x0116,
    XBAR_INPUT_FLG_ECAP6_OUT                = 0x0115,
    XBAR_INPUT_FLG_ECAP5_OUT                = 0x0114,
    XBAR_INPUT_FLG_ECAP4_OUT                = 0x0113,
    XBAR_INPUT_FLG_ECAP3_OUT                = 0x0112,
    XBAR_INPUT_FLG_ECAP2_OUT                = 0x0111,
    XBAR_INPUT_FLG_ECAP1_OUT                = 0x0110,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL14_OUT     = 0x010F,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL13_OUT     = 0x010E,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL12_OUT     = 0x010D,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL11_OUT     = 0x010C,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL10_OUT     = 0x010B,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL9_OUT      = 0x010A,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL8_OUT      = 0x0109,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL7_OUT      = 0x0108,
    XBAR_INPUT_FLG_ADCSOCB                  = 0x0107,
    XBAR_INPUT_FLG_ADCSOCA                  = 0x0106,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL6_OUT      = 0x0105,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL5_OUT      = 0x0104,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL4_OUT      = 0x0103,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL3_OUT      = 0x0102,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL2_OUT      = 0x0101,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL1_OUT      = 0x0100,

    //
    // XBARFLG3
    //

    XBAR_INPUT_FLG_SD1FLT4_DRINT            = 0x021F,
    XBAR_INPUT_FLG_SD1FLT4_COMPZ            = 0x021E,
    XBAR_INPUT_FLG_SD1FLT3_DRINT            = 0x021D,
    XBAR_INPUT_FLG_SD1FLT3_COMPZ            = 0x021C,
    XBAR_INPUT_FLG_SD1FLT2_DRINT            = 0x021B,
    XBAR_INPUT_FLG_SD1FLT2_COMPZ            = 0x021A,
    XBAR_INPUT_FLG_SD1FLT1_DRINT            = 0x0219,
    XBAR_INPUT_FLG_SD1FLT1_COMPZ            = 0x0218,
    XBAR_INPUT_FLG_ECAP7_OUT                = 0x0217,
    XBAR_INPUT_FLG_SD2FLT4_1CEVT            = 0x0216,
    XBAR_INPUT_FLG_SD2FLT4_2CEVT            = 0x0215,
    XBAR_INPUT_FLG_SD2FLT3_1CEVT            = 0x0214,
    XBAR_INPUT_FLG_SD2FLT3_2CEVT            = 0x0213,
    XBAR_INPUT_FLG_SD2FLT2_1CEVT            = 0x0212,
    XBAR_INPUT_FLG_SD2FLT2_2CEVT            = 0x0211,
    XBAR_INPUT_FLG_SD2FLT1_1CEVT            = 0x0210,
    XBAR_INPUT_FLG_SD2FLT1_2CEVT            = 0x020F,
    XBAR_INPUT_FLG_SD1FLT4_1CEVT            = 0x020E,
    XBAR_INPUT_FLG_SD1FLT4_2CEVT            = 0x020D,
    XBAR_INPUT_FLG_SD1FLT3_1CEVT            = 0x020C,
    XBAR_INPUT_FLG_SD1FLT3_2CEVT            = 0x020B,
    XBAR_INPUT_FLG_SD1FLT2_1CEVT            = 0x020A,
    XBAR_INPUT_FLG_SD1FLT2_2CEVT            = 0x0209,
    XBAR_INPUT_FLG_SD1FLT1_1CEVT            = 0x0208,
    XBAR_INPUT_FLG_SD1FLT1_2CEVT            = 0x0207,
    XBAR_INPUT_FLG_ADCC_4EVT                = 0x0202,
    XBAR_INPUT_FLG_ADCC_3EVT                = 0x0201,
    XBAR_INPUT_FLG_ADCC_2EVT                = 0x0200,

    //
    // XBARFLG4
    //

    XBAR_INPUT_FLG_CPU_HALT_IN              = 0x031F,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL16_OUT     = 0x031E,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL15_OUT     = 0x031D,
    XBAR_INPUT_FLG_ERRORSTS_IN              = 0x031C,
    XBAR_INPUT_FLG_CLB1_LC3_OUT3            = 0x031B,
    XBAR_INPUT_FLG_CLB1_LC3_OUT2            = 0x031A,
    XBAR_INPUT_FLG_CLB1_LC3_OUT1            = 0x0319,
    XBAR_INPUT_FLG_CLB1_LC3_OUT0            = 0x0318,
    XBAR_INPUT_FLG_CLB1_LC2_OUT3            = 0x0317,
    XBAR_INPUT_FLG_CLB1_LC2_OUT2            = 0x0316,
    XBAR_INPUT_FLG_CLB1_LC2_OUT1            = 0x0315,
    XBAR_INPUT_FLG_CLB1_LC2_OUT0            = 0x0314,
    XBAR_INPUT_FLG_CLB1_LC1_OUT3            = 0x0313,
    XBAR_INPUT_FLG_CLB1_LC1_OUT2            = 0x0312,
    XBAR_INPUT_FLG_CLB1_LC1_OUT1            = 0x0311,
    XBAR_INPUT_FLG_CLB1_LC1_OUT0            = 0x0310,
    XBAR_INPUT_FLG_CANB_HOST_IF_IN          = 0x030B,
    XBAR_INPUT_FLG_CANA_HOST_IF_IN          = 0x030A,
    XBAR_INPUT_FLG_SD2FLT4_DRINT            = 0x0307,
    XBAR_INPUT_FLG_SD2FLT4_COMPZ            = 0x0306,
    XBAR_INPUT_FLG_SD2FLT3_DRINT            = 0x0305,
    XBAR_INPUT_FLG_SD2FLT3_COMPZ            = 0x0304,
    XBAR_INPUT_FLG_SD2FLT2_DRINT            = 0x0303,
    XBAR_INPUT_FLG_SD2FLT2_COMPZ            = 0x0302,
    XBAR_INPUT_FLG_SD2FLT1_DRINT            = 0x0301,
    XBAR_INPUT_FLG_SD2FLT1_COMPZ            = 0x0300,

    //
    // XBARFLG5
    //

    XBAR_INPUT_FLG_ERAD_EBC_EVENT0          = 0x041F,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT1          = 0x041E,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT2          = 0x041D,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT3          = 0x041C,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT4          = 0x041B,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT5          = 0x041A,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT0          = 0x0419,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT1          = 0x0418,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT2          = 0x0417,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT3          = 0x0416,
    XBAR_INPUT_FLG_CLB2_LC3_OUT3_SEL        = 0x040B,
    XBAR_INPUT_FLG_CLB2_LC3_OUT2_SEL        = 0x040A,
    XBAR_INPUT_FLG_CLB2_LC3_OUT1_SEL        = 0x0409,
    XBAR_INPUT_FLG_CLB2_LC3_OUT0_SEL        = 0x0408,
    XBAR_INPUT_FLG_CLB2_LC2_OUT3_SEL        = 0x0407,
    XBAR_INPUT_FLG_CLB2_LC2_OUT2_SEL        = 0x0406,
    XBAR_INPUT_FLG_CLB2_LC2_OUT1_SEL        = 0x0405,
    XBAR_INPUT_FLG_CLB2_LC2_OUT0_SEL        = 0x0404,
    XBAR_INPUT_FLG_CLB2_LC1_OUT3_SEL        = 0x0403,
    XBAR_INPUT_FLG_CLB2_LC1_OUT2_SEL        = 0x0402,
    XBAR_INPUT_FLG_CLB2_LC1_OUT1_SEL        = 0x0401,
    XBAR_INPUT_FLG_CLB2_LC1_OUT0_SEL        = 0x0400,

    //
    // XBARFLG6
    //

    XBAR_INPUT_FLG_EPG_XBAR_OUT3            = 0x051F,
    XBAR_INPUT_FLG_EPG_XBAR_OUT2            = 0x051E,
    XBAR_INPUT_FLG_EPG_XBAR_OUT1            = 0x051D,
    XBAR_INPUT_FLG_EPG_XBAR_OUT0            = 0x051C,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL14_OUT = 0x0507,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL13_OUT = 0x0506,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL12_OUT = 0x0505,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL11_OUT = 0x0504,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL10_OUT = 0x0503,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL9_OUT  = 0x0502,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL8_OUT  = 0x0501,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL7_OUT  = 0x0500,

#elif IS_GS32F00xx(0x30)
    //
    // XBARFLG1
    //

    XBAR_INPUT_FLG_CMPSS8_CTRIPOUTH         = 0x01F,
    XBAR_INPUT_FLG_CMPSS8_CTRIPOUTL         = 0x01E,
    XBAR_INPUT_FLG_CMPSS7_CTRIPOUTH         = 0x01D,
    XBAR_INPUT_FLG_CMPSS7_CTRIPOUTL         = 0x01C,
    XBAR_INPUT_FLG_CMPSS6_CTRIPOUTH         = 0x01B,
    XBAR_INPUT_FLG_CMPSS6_CTRIPOUTL         = 0x01A,
    XBAR_INPUT_FLG_CMPSS5_CTRIPOUTH         = 0x019,
    XBAR_INPUT_FLG_CMPSS5_CTRIPOUTL         = 0x018,
    XBAR_INPUT_FLG_CMPSS4_CTRIPOUTH         = 0x017,
    XBAR_INPUT_FLG_CMPSS4_CTRIPOUTL         = 0x016,
    XBAR_INPUT_FLG_CMPSS3_CTRIPOUTH         = 0x015,
    XBAR_INPUT_FLG_CMPSS3_CTRIPOUTL         = 0x014,
    XBAR_INPUT_FLG_CMPSS2_CTRIPOUTH         = 0x013,
    XBAR_INPUT_FLG_CMPSS2_CTRIPOUTL         = 0x012,
    XBAR_INPUT_FLG_CMPSS1_CTRIPOUTH         = 0x011,
    XBAR_INPUT_FLG_CMPSS1_CTRIPOUTL         = 0x010,
    XBAR_INPUT_FLG_CMPSS8_CTRIPH            = 0x00F,
    XBAR_INPUT_FLG_CMPSS8_CTRIPL            = 0x00E,
    XBAR_INPUT_FLG_CMPSS7_CTRIPH            = 0x00D,
    XBAR_INPUT_FLG_CMPSS7_CTRIPL            = 0x00C,
    XBAR_INPUT_FLG_CMPSS6_CTRIPH            = 0x00B,
    XBAR_INPUT_FLG_CMPSS6_CTRIPL            = 0x00A,
    XBAR_INPUT_FLG_CMPSS5_CTRIPH            = 0x009,
    XBAR_INPUT_FLG_CMPSS5_CTRIPL            = 0x008,
    XBAR_INPUT_FLG_CMPSS4_CTRIPH            = 0x007,
    XBAR_INPUT_FLG_CMPSS4_CTRIPL            = 0x006,
    XBAR_INPUT_FLG_CMPSS3_CTRIPH            = 0x005,
    XBAR_INPUT_FLG_CMPSS3_CTRIPL            = 0x004,
    XBAR_INPUT_FLG_CMPSS2_CTRIPH            = 0x003,
    XBAR_INPUT_FLG_CMPSS2_CTRIPL            = 0x002,
    XBAR_INPUT_FLG_CMPSS1_CTRIPH            = 0x001,
    XBAR_INPUT_FLG_CMPSS1_CTRIPL            = 0x000,

    //
    // XBARFLG2
    //

    XBAR_INPUT_FLG_ADCC_1EVT                = 0x11F,
    XBAR_INPUT_FLG_ADCB_4EVT                = 0x11E,
    XBAR_INPUT_FLG_ADCB_3EVT                = 0x11D,
    XBAR_INPUT_FLG_ADCB_2EVT                = 0x11C,
    XBAR_INPUT_FLG_ADCB_1EVT                = 0x11B,
    XBAR_INPUT_FLG_ADCA_4EVT                = 0x11A,
    XBAR_INPUT_FLG_ADCA_3EVT                = 0x119,
    XBAR_INPUT_FLG_ADCA_2EVT                = 0x118,
    XBAR_INPUT_FLG_ADCA_1EVT                = 0x117,
    XBAR_INPUT_FLG_EXTSYNCOUT               = 0x116,
    XBAR_INPUT_FLG_ECAP6_OUT                = 0x115,
    XBAR_INPUT_FLG_ECAP5_OUT                = 0x114,
    XBAR_INPUT_FLG_ECAP4_OUT                = 0x113,
    XBAR_INPUT_FLG_ECAP3_OUT                = 0x112,
    XBAR_INPUT_FLG_ECAP2_OUT                = 0x111,
    XBAR_INPUT_FLG_ECAP1_OUT                = 0x110,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL14_OUT     = 0x10F,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL13_OUT     = 0x10E,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL12_OUT     = 0x10D,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL11_OUT     = 0x10C,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL10_OUT     = 0x10B,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL9_OUT      = 0x10A,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL8_OUT      = 0x109,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL7_OUT      = 0x108,
    XBAR_INPUT_FLG_ADCSOCB                  = 0x107,
    XBAR_INPUT_FLG_ADCSOCA                  = 0x106,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL6_OUT      = 0x105,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL5_OUT      = 0x104,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL4_OUT      = 0x103,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL3_OUT      = 0x102,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL2_OUT      = 0x101,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL1_OUT      = 0x100,

    //
    // XBARFLG3
    //

    XBAR_INPUT_FLG_SD1FLT4_DRINT            = 0x21F,
    XBAR_INPUT_FLG_SD1FLT4_COMPZ            = 0x21E,
    XBAR_INPUT_FLG_SD1FLT3_DRINT            = 0x21D,
    XBAR_INPUT_FLG_SD1FLT3_COMPZ            = 0x21C,
    XBAR_INPUT_FLG_SD1FLT2_DRINT            = 0x21B,
    XBAR_INPUT_FLG_SD1FLT2_COMPZ            = 0x21A,
    XBAR_INPUT_FLG_SD1FLT1_DRINT            = 0x219,
    XBAR_INPUT_FLG_SD1FLT1_COMPZ            = 0x218,
    XBAR_INPUT_FLG_ECAP7_OUT                = 0x217,
    XBAR_INPUT_FLG_SD2FLT4_1CEVT            = 0x216,
    XBAR_INPUT_FLG_SD2FLT4_2CEVT            = 0x215,
    XBAR_INPUT_FLG_SD2FLT3_1CEVT            = 0x214,
    XBAR_INPUT_FLG_SD2FLT3_2CEVT            = 0x213,
    XBAR_INPUT_FLG_SD2FLT2_1CEVT            = 0x212,
    XBAR_INPUT_FLG_SD2FLT2_2CEVT            = 0x211,
    XBAR_INPUT_FLG_SD2FLT1_1CEVT            = 0x210,
    XBAR_INPUT_FLG_SD2FLT1_2CEVT            = 0x20F,
    XBAR_INPUT_FLG_SD1FLT4_1CEVT            = 0x20E,
    XBAR_INPUT_FLG_SD1FLT4_2CEVT            = 0x20D,
    XBAR_INPUT_FLG_SD1FLT3_1CEVT            = 0x20C,
    XBAR_INPUT_FLG_SD1FLT3_2CEVT            = 0x20B,
    XBAR_INPUT_FLG_SD1FLT2_1CEVT            = 0x20A,
    XBAR_INPUT_FLG_SD1FLT2_2CEVT            = 0x209,
    XBAR_INPUT_FLG_SD1FLT1_1CEVT            = 0x208,
    XBAR_INPUT_FLG_SD1FLT1_2CEVT            = 0x207,
    XBAR_INPUT_FLG_ADCD_4EVT                = 0x206,
    XBAR_INPUT_FLG_ADCD_3EVT                = 0x205,
    XBAR_INPUT_FLG_ADCD_2EVT                = 0x204,
    XBAR_INPUT_FLG_ADCD_1EVT                = 0x203,
    XBAR_INPUT_FLG_ADCC_4EVT                = 0x202,
    XBAR_INPUT_FLG_ADCC_3EVT                = 0x201,
    XBAR_INPUT_FLG_ADCC_2EVT                = 0x200,

    //
    // XBARFLG4
    //

    XBAR_INPUT_FLG_CPU_HALT_IN              = 0x31F,
    XBAR_INPUT_FLG_ECAT_SYNC1               = 0x31E,
    XBAR_INPUT_FLG_ECAT_SYNC0               = 0x31D,
    XBAR_INPUT_FLG_ERRORSTS_IN              = 0x31C,
    XBAR_INPUT_FLG_CLB6_LC2_OUT1_SEL        = 0x31B,
    XBAR_INPUT_FLG_CLB6_LC2_OUT0_SEL        = 0x31A,
    XBAR_INPUT_FLG_CLB5_LC2_OUT1_SEL        = 0x319,
    XBAR_INPUT_FLG_CLB5_LC2_OUT0_SEL        = 0x318,
    XBAR_INPUT_FLG_CLB4_LC2_OUT1_SEL        = 0x317,
    XBAR_INPUT_FLG_CLB4_LC2_OUT0_SEL        = 0x316,
    XBAR_INPUT_FLG_CLB3_LC2_OUT1_SEL        = 0x315,
    XBAR_INPUT_FLG_CLB3_LC2_OUT0_SEL        = 0x314,
    XBAR_INPUT_FLG_CLB2_LC2_OUT1_SEL        = 0x313,
    XBAR_INPUT_FLG_CLB2_LC2_OUT0_SEL        = 0x312,
    XBAR_INPUT_FLG_CLB1_LC2_OUT1_SEL        = 0x311,
    XBAR_INPUT_FLG_CLB1_LC2_OUT0_SEL        = 0x310,
    XBAR_INPUT_FLG_CLB8_LC2_OUT1_SEL        = 0x30F,
    XBAR_INPUT_FLG_CLB8_LC2_OUT0_SEL        = 0x30E,
    XBAR_INPUT_FLG_CLB7_LC2_OUT1_SEL        = 0x30D,
    XBAR_INPUT_FLG_CLB7_LC2_OUT0_SEL        = 0x30C,
    XBAR_INPUT_FLG_CANB_HOST_IF_IN          = 0x30A,
    XBAR_INPUT_FLG_CANA_HOST_IF_IN          = 0x309,
    XBAR_INPUT_FLG_SD2FLT4_DRINT            = 0x307,
    XBAR_INPUT_FLG_SD2FLT4_COMPZ            = 0x306,
    XBAR_INPUT_FLG_SD2FLT3_DRINT            = 0x305,
    XBAR_INPUT_FLG_SD2FLT3_COMPZ            = 0x304,
    XBAR_INPUT_FLG_SD2FLT2_DRINT            = 0x303,
    XBAR_INPUT_FLG_SD2FLT2_COMPZ            = 0x302,
    XBAR_INPUT_FLG_SD2FLT1_DRINT            = 0x301,
    XBAR_INPUT_FLG_SD2FLT1_COMPZ            = 0x300,

    //
    // XBARFLG5
    //

    XBAR_INPUT_FLG_XBAR_INPUT_SEL16_OUT     = 0x41F,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL15_OUT     = 0x41E,
    XBAR_INPUT_FLG_EPWM18_TRIPOUT           = 0x411,
    XBAR_INPUT_FLG_EPWM17_TRIPOUT           = 0x410,
    XBAR_INPUT_FLG_EPWM16_TRIPOUT           = 0x40F,
    XBAR_INPUT_FLG_EPWM15_TRIPOUT           = 0x40E,
    XBAR_INPUT_FLG_EPWM14_TRIPOUT           = 0x40D,
    XBAR_INPUT_FLG_EPWM13_TRIPOUT           = 0x40C,
    XBAR_INPUT_FLG_EPWM12_TRIPOUT           = 0x40B,
    XBAR_INPUT_FLG_EPWM11_TRIPOUT           = 0x40A,
    XBAR_INPUT_FLG_EPWM10_TRIPOUT           = 0x409,
    XBAR_INPUT_FLG_EPWM9_TRIPOUT            = 0x408,
    XBAR_INPUT_FLG_EPWM8_TRIPOUT            = 0x407,
    XBAR_INPUT_FLG_EPWM7_TRIPOUT            = 0x406,
    XBAR_INPUT_FLG_EPWM6_TRIPOUT            = 0x405,
    XBAR_INPUT_FLG_EPWM5_TRIPOUT            = 0x404,
    XBAR_INPUT_FLG_EPWM4_TRIPOUT            = 0x403,
    XBAR_INPUT_FLG_EPWM3_TRIPOUT            = 0x402,
    XBAR_INPUT_FLG_EPWM2_TRIPOUT            = 0x401,
    XBAR_INPUT_FLG_EPWM1_TRIPOUT            = 0x400,

    //
    // XBARFLG6
    //

    XBAR_INPUT_FLG_EPWM18_DEMONTRIP         = 0x511,
    XBAR_INPUT_FLG_EPWM17_DEMONTRIP         = 0x510,
    XBAR_INPUT_FLG_EPWM16_DEMONTRIP         = 0x50F,
    XBAR_INPUT_FLG_EPWM15_DEMONTRIP         = 0x50E,
    XBAR_INPUT_FLG_EPWM14_DEMONTRIP         = 0x50D,
    XBAR_INPUT_FLG_EPWM13_DEMONTRIP         = 0x50C,
    XBAR_INPUT_FLG_EPWM12_DEMONTRIP         = 0x50B,
    XBAR_INPUT_FLG_EPWM11_DEMONTRIP         = 0x50A,
    XBAR_INPUT_FLG_EPWM10_DEMONTRIP         = 0x509,
    XBAR_INPUT_FLG_EPWM9_DEMONTRIP          = 0x508,
    XBAR_INPUT_FLG_EPWM8_DEMONTRIP          = 0x507,
    XBAR_INPUT_FLG_EPWM7_DEMONTRIP          = 0x506,
    XBAR_INPUT_FLG_EPWM6_DEMONTRIP          = 0x505,
    XBAR_INPUT_FLG_EPWM5_DEMONTRIP          = 0x504,
    XBAR_INPUT_FLG_EPWM4_DEMONTRIP          = 0x503,
    XBAR_INPUT_FLG_EPWM3_DEMONTRIP          = 0x502,
    XBAR_INPUT_FLG_EPWM2_DEMONTRIP          = 0x501,
    XBAR_INPUT_FLG_EPWM1_DEMONTRIP          = 0x500,

    //
    // XBARFLG7
    //

    XBAR_INPUT_FLG_EPWM18_DEACTIVE          = 0x611,
    XBAR_INPUT_FLG_EPWM17_DEACTIVE          = 0x610,
    XBAR_INPUT_FLG_EPWM16_DEACTIVE          = 0x60F,
    XBAR_INPUT_FLG_EPWM15_DEACTIVE          = 0x60E,
    XBAR_INPUT_FLG_EPWM14_DEACTIVE          = 0x60D,
    XBAR_INPUT_FLG_EPWM13_DEACTIVE          = 0x60C,
    XBAR_INPUT_FLG_EPWM12_DEACTIVE          = 0x60B,
    XBAR_INPUT_FLG_EPWM11_DEACTIVE          = 0x60A,
    XBAR_INPUT_FLG_EPWM10_DEACTIVE          = 0x609,
    XBAR_INPUT_FLG_EPWM9_DEACTIVE           = 0x608,
    XBAR_INPUT_FLG_EPWM8_DEACTIVE           = 0x607,
    XBAR_INPUT_FLG_EPWM7_DEACTIVE           = 0x606,
    XBAR_INPUT_FLG_EPWM6_DEACTIVE           = 0x605,
    XBAR_INPUT_FLG_EPWM5_DEACTIVE           = 0x604,
    XBAR_INPUT_FLG_EPWM4_DEACTIVE           = 0x603,
    XBAR_INPUT_FLG_EPWM3_DEACTIVE           = 0x602,
    XBAR_INPUT_FLG_EPWM2_DEACTIVE           = 0x601,
    XBAR_INPUT_FLG_EPWM1_DEACTIVE           = 0x600,

    //
    // XBARFLG8
    //

    XBAR_INPUT_FLG_EPWM16B_DB_NO_HR         = 0x71F,
    XBAR_INPUT_FLG_EPWM16A_DB_NO_HR         = 0x71E,
    XBAR_INPUT_FLG_EPWM15B_DB_NO_HR         = 0x71D,
    XBAR_INPUT_FLG_EPWM15A_DB_NO_HR         = 0x71C,
    XBAR_INPUT_FLG_EPWM14B_DB_NO_HR         = 0x71B,
    XBAR_INPUT_FLG_EPWM14A_DB_NO_HR         = 0x71A,
    XBAR_INPUT_FLG_EPWM13B_DB_NO_HR         = 0x719,
    XBAR_INPUT_FLG_EPWM13A_DB_NO_HR         = 0x718,
    XBAR_INPUT_FLG_EPWM12B_DB_NO_HR         = 0x717,
    XBAR_INPUT_FLG_EPWM12A_DB_NO_HR         = 0x716,
    XBAR_INPUT_FLG_EPWM11B_DB_NO_HR         = 0x715,
    XBAR_INPUT_FLG_EPWM11A_DB_NO_HR         = 0x714,
    XBAR_INPUT_FLG_EPWM10B_DB_NO_HR         = 0x713,
    XBAR_INPUT_FLG_EPWM10A_DB_NO_HR         = 0x712,
    XBAR_INPUT_FLG_EPWM9B_DB_NO_HR          = 0x711,
    XBAR_INPUT_FLG_EPWM9A_DB_NO_HR          = 0x710,
    XBAR_INPUT_FLG_EPWM8B_DB_NO_HR          = 0x70F,
    XBAR_INPUT_FLG_EPWM8A_DB_NO_HR          = 0x70E,
    XBAR_INPUT_FLG_EPWM7B_DB_NO_HR          = 0x70D,
    XBAR_INPUT_FLG_EPWM7A_DB_NO_HR          = 0x70C,
    XBAR_INPUT_FLG_EPWM6B_DB_NO_HR          = 0x70B,
    XBAR_INPUT_FLG_EPWM6A_DB_NO_HR          = 0x70A,
    XBAR_INPUT_FLG_EPWM5B_DB_NO_HR          = 0x709,
    XBAR_INPUT_FLG_EPWM5A_DB_NO_HR          = 0x708,
    XBAR_INPUT_FLG_EPWM4B_DB_NO_HR          = 0x707,
    XBAR_INPUT_FLG_EPWM4A_DB_NO_HR          = 0x706,
    XBAR_INPUT_FLG_EPWM3B_DB_NO_HR          = 0x705,
    XBAR_INPUT_FLG_EPWM3A_DB_NO_HR          = 0x704,
    XBAR_INPUT_FLG_EPWM2B_DB_NO_HR          = 0x703,
    XBAR_INPUT_FLG_EPWM2A_DB_NO_HR          = 0x702,
    XBAR_INPUT_FLG_EPWM1B_DB_NO_HR          = 0x701,
    XBAR_INPUT_FLG_EPWM1A_DB_NO_HR          = 0x700,

    //
    // XBARFLG9
    //

    XBAR_INPUT_FLG_CLB8_LC2_OUT3_SEL        = 0x81F,
    XBAR_INPUT_FLG_CLB8_LC2_OUT2_SEL        = 0x81E,
    XBAR_INPUT_FLG_CLB8_LC1_OUT3_SEL        = 0x81D,
    XBAR_INPUT_FLG_CLB8_LC1_OUT2_SEL        = 0x81C,
    XBAR_INPUT_FLG_CLB8_LC1_OUT1_SEL        = 0x81B,
    XBAR_INPUT_FLG_CLB8_LC1_OUT0_SEL        = 0x81A,
    XBAR_INPUT_FLG_CLB7_LC2_OUT3_SEL        = 0x819,
    XBAR_INPUT_FLG_CLB7_LC2_OUT2_SEL        = 0x818,
    XBAR_INPUT_FLG_CLB7_LC1_OUT3_SEL        = 0x817,
    XBAR_INPUT_FLG_CLB7_LC1_OUT2_SEL        = 0x816,
    XBAR_INPUT_FLG_CLB7_LC1_OUT1_SEL        = 0x815,
    XBAR_INPUT_FLG_CLB7_LC1_OUT0_SEL        = 0x814,
    XBAR_INPUT_FLG_ADCD_EXT_MUXSEL3         = 0x813,
    XBAR_INPUT_FLG_ADCD_EXT_MUXSEL2         = 0x812,
    XBAR_INPUT_FLG_ADCD_EXT_MUXSEL1         = 0x811,
    XBAR_INPUT_FLG_ADCD_EXT_MUXSEL0         = 0x810,
    XBAR_INPUT_FLG_EPWM18B_DB_NO_HR         = 0x803,
    XBAR_INPUT_FLG_EPWM18A_DB_NO_HR         = 0x802,
    XBAR_INPUT_FLG_EPWM17B_DB_NO_HR         = 0x801,
    XBAR_INPUT_FLG_EPWM17A_DB_NO_HR         = 0x800,

    //
    // XBARFLG10
    //

    XBAR_INPUT_FLG_EPWM16B_MINDB            = 0x91F,
    XBAR_INPUT_FLG_EPWM16A_MINDB            = 0x91E,
    XBAR_INPUT_FLG_EPWM15B_MINDB            = 0x91D,
    XBAR_INPUT_FLG_EPWM15A_MINDB            = 0x91C,
    XBAR_INPUT_FLG_EPWM14B_MINDB            = 0x91B,
    XBAR_INPUT_FLG_EPWM14A_MINDB            = 0x91A,
    XBAR_INPUT_FLG_EPWM13B_MINDB            = 0x919,
    XBAR_INPUT_FLG_EPWM13A_MINDB            = 0x918,
    XBAR_INPUT_FLG_EPWM12B_MINDB            = 0x917,
    XBAR_INPUT_FLG_EPWM12A_MINDB            = 0x916,
    XBAR_INPUT_FLG_EPWM11B_MINDB            = 0x915,
    XBAR_INPUT_FLG_EPWM11A_MINDB            = 0x914,
    XBAR_INPUT_FLG_EPWM10B_MINDB            = 0x913,
    XBAR_INPUT_FLG_EPWM10A_MINDB            = 0x912,
    XBAR_INPUT_FLG_EPWM9B_MINDB             = 0x911,
    XBAR_INPUT_FLG_EPWM9A_MINDB             = 0x910,
    XBAR_INPUT_FLG_EPWM8B_MINDB             = 0x90F,
    XBAR_INPUT_FLG_EPWM8A_MINDB             = 0x90E,
    XBAR_INPUT_FLG_EPWM7B_MINDB             = 0x90D,
    XBAR_INPUT_FLG_EPWM7A_MINDB             = 0x90C,
    XBAR_INPUT_FLG_EPWM6B_MINDB             = 0x90B,
    XBAR_INPUT_FLG_EPWM6A_MINDB             = 0x90A,
    XBAR_INPUT_FLG_EPWM5B_MINDB             = 0x909,
    XBAR_INPUT_FLG_EPWM5A_MINDB             = 0x908,
    XBAR_INPUT_FLG_EPWM4B_MINDB             = 0x907,
    XBAR_INPUT_FLG_EPWM4A_MINDB             = 0x906,
    XBAR_INPUT_FLG_EPWM3B_MINDB             = 0x905,
    XBAR_INPUT_FLG_EPWM3A_MINDB             = 0x904,
    XBAR_INPUT_FLG_EPWM2B_MINDB             = 0x903,
    XBAR_INPUT_FLG_EPWM2A_MINDB             = 0x902,
    XBAR_INPUT_FLG_EPWM1B_MINDB             = 0x901,
    XBAR_INPUT_FLG_EPWM1A_MINDB             = 0x900,

    //
    // XBARFLG11
    //

    XBAR_INPUT_FLG_SD3FLT4_DRINT            = 0x101F,
    XBAR_INPUT_FLG_SD3FLT4_COMPZ            = 0x101E,
    XBAR_INPUT_FLG_SD3FLT3_DRINT            = 0x101D,
    XBAR_INPUT_FLG_SD3FLT3_COMPZ            = 0x101C,
    XBAR_INPUT_FLG_SD3FLT2_DRINT            = 0x101B,
    XBAR_INPUT_FLG_SD3FLT2_COMPZ            = 0x101A,
    XBAR_INPUT_FLG_SD3FLT1_DRINT            = 0x1019,
    XBAR_INPUT_FLG_SD3FLT1_COMPZ            = 0x1018,
    XBAR_INPUT_FLG_SD4FLT4_DRINT            = 0x1017,
    XBAR_INPUT_FLG_SD4FLT4_COMPZ            = 0x1016,
    XBAR_INPUT_FLG_SD4FLT3_DRINT            = 0x1015,
    XBAR_INPUT_FLG_SD4FLT3_COMPZ            = 0x1014,
    XBAR_INPUT_FLG_SD4FLT2_DRINT            = 0x1013,
    XBAR_INPUT_FLG_SD4FLT2_COMPZ            = 0x1012,
    XBAR_INPUT_FLG_SD4FLT1_DRINT            = 0x1011,
    XBAR_INPUT_FLG_SD4FLT1_COMPZ            = 0x1010,
    XBAR_INPUT_FLG_EPWM18B_MINDB            = 0x1003,
    XBAR_INPUT_FLG_EPWM18A_MINDB            = 0x1002,
    XBAR_INPUT_FLG_EPWM17B_MINDB            = 0x1001,
    XBAR_INPUT_FLG_EPWM17A_MINDB            = 0x1000,

    //
    // XBARFLG12
    //

    XBAR_INPUT_FLG_CLB6_LC1_OUT1_SEL        = 0x111F,
    XBAR_INPUT_FLG_CLB6_LC1_OUT0_SEL        = 0x111E,
    XBAR_INPUT_FLG_CLB5_LC2_OUT3_SEL        = 0x111D,
    XBAR_INPUT_FLG_CLB5_LC2_OUT2_SEL        = 0x111C,
    XBAR_INPUT_FLG_CLB5_LC1_OUT3_SEL        = 0x111B,
    XBAR_INPUT_FLG_CLB5_LC1_OUT2_SEL        = 0x111A,
    XBAR_INPUT_FLG_CLB5_LC1_OUT1_SEL        = 0x1119,
    XBAR_INPUT_FLG_CLB5_LC1_OUT0_SEL        = 0x1118,
    XBAR_INPUT_FLG_CLB4_LC2_OUT3_SEL        = 0x1117,
    XBAR_INPUT_FLG_CLB4_LC2_OUT2_SEL        = 0x1116,
    XBAR_INPUT_FLG_CLB4_LC1_OUT3_SEL        = 0x1115,
    XBAR_INPUT_FLG_CLB4_LC1_OUT2_SEL        = 0x1114,
    XBAR_INPUT_FLG_CLB4_LC1_OUT1_SEL        = 0x1113,
    XBAR_INPUT_FLG_CLB4_LC1_OUT0_SEL        = 0x1112,
    XBAR_INPUT_FLG_CLB3_LC2_OUT3_SEL        = 0x1111,
    XBAR_INPUT_FLG_CLB3_LC2_OUT2_SEL        = 0x1110,
    XBAR_INPUT_FLG_CLB3_LC1_OUT3_SEL        = 0x110F,
    XBAR_INPUT_FLG_CLB3_LC1_OUT2_SEL        = 0x110E,
    XBAR_INPUT_FLG_CLB3_LC1_OUT1_SEL        = 0x110D,
    XBAR_INPUT_FLG_CLB3_LC1_OUT0_SEL        = 0x110C,
    XBAR_INPUT_FLG_CLB2_LC2_OUT3_SEL        = 0x110B,
    XBAR_INPUT_FLG_CLB2_LC2_OUT2_SEL        = 0x110A,
    XBAR_INPUT_FLG_CLB2_LC1_OUT3_SEL        = 0x1109,
    XBAR_INPUT_FLG_CLB2_LC1_OUT2_SEL        = 0x1108,
    XBAR_INPUT_FLG_CLB2_LC1_OUT1_SEL        = 0x1107,
    XBAR_INPUT_FLG_CLB2_LC1_OUT0_SEL        = 0x1106,
    XBAR_INPUT_FLG_CLB1_LC2_OUT3_SEL        = 0x1105,
    XBAR_INPUT_FLG_CLB1_LC2_OUT2_SEL        = 0x1104,
    XBAR_INPUT_FLG_CLB1_LC1_OUT3_SEL        = 0x1103,
    XBAR_INPUT_FLG_CLB1_LC1_OUT2_SEL        = 0x1102,
    XBAR_INPUT_FLG_CLB1_LC1_OUT1_SEL        = 0x1101,
    XBAR_INPUT_FLG_CLB1_LC1_OUT0_SEL        = 0x1100,

    //
    // XBARFLG13
    //

    XBAR_INPUT_FLG_EPG_XBAR_OUT3            = 0x121F,
    XBAR_INPUT_FLG_EPG_XBAR_OUT2            = 0x121E,
    XBAR_INPUT_FLG_EPG_XBAR_OUT1            = 0x121D,
    XBAR_INPUT_FLG_EPG_XBAR_OUT0            = 0x121C,
    XBAR_INPUT_FLG_TOP_PWM_TRIP14IN         = 0x121B,
    XBAR_INPUT_FLG_TOP_PWM_TRIP15IN         = 0x121A,
    XBAR_INPUT_FLG_ADCC_EXT_MUXSEL3         = 0x1217,
    XBAR_INPUT_FLG_ADCC_EXT_MUXSEL2         = 0x1216,
    XBAR_INPUT_FLG_ADCC_EXT_MUXSEL1         = 0x1215,
    XBAR_INPUT_FLG_ADCC_EXT_MUXSEL0         = 0x1214,
    XBAR_INPUT_FLG_ADCB_EXT_MUXSEL3         = 0x1213,
    XBAR_INPUT_FLG_ADCB_EXT_MUXSEL2         = 0x1212,
    XBAR_INPUT_FLG_ADCB_EXT_MUXSEL1         = 0x1211,
    XBAR_INPUT_FLG_ADCB_EXT_MUXSEL0         = 0x1210,
    XBAR_INPUT_FLG_ADCA_EXT_MUXSEL3         = 0x120F,
    XBAR_INPUT_FLG_ADCA_EXT_MUXSEL2         = 0x120E,
    XBAR_INPUT_FLG_ADCA_EXT_MUXSEL1         = 0x120D,
    XBAR_INPUT_FLG_ADCA_EXT_MUXSEL0         = 0x120C,
    XBAR_INPUT_FLG_CLB6_LC2_OUT3_SEL        = 0x1203,
    XBAR_INPUT_FLG_CLB6_LC2_OUT2_SEL        = 0x1202,
    XBAR_INPUT_FLG_CLB6_LC1_OUT3_SEL        = 0x1201,
    XBAR_INPUT_FLG_CLB6_LC1_OUT2_SEL        = 0x1200,

    //
    // XBARFLG14
    //

    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL9_OUT  = 0x1318,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL8_OUT  = 0x1317,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL7_OUT  = 0x1316,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL14_OUT = 0x1315,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL13_OUT = 0x1314,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL12_OUT = 0x1313,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL11_OUT = 0x1312,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL10_OUT = 0x1311,
    XBAR_INPUT_FLG_SD4FLT4_2CEVT            = 0x130F,
    XBAR_INPUT_FLG_SD4FLT4_1CEVT            = 0x130E,
    XBAR_INPUT_FLG_SD4FLT3_2CEVT            = 0x130D,
    XBAR_INPUT_FLG_SD4FLT3_1CEVT            = 0x130C,
    XBAR_INPUT_FLG_SD4FLT2_2CEVT            = 0x130B,
    XBAR_INPUT_FLG_SD4FLT2_1CEVT            = 0x130A,
    XBAR_INPUT_FLG_SD4FLT1_2CEVT            = 0x1309,
    XBAR_INPUT_FLG_SD4FLT1_1CEVT            = 0x1308,
    XBAR_INPUT_FLG_SD3FLT4_2CEVT            = 0x1307,
    XBAR_INPUT_FLG_SD3FLT4_1CEVT            = 0x1306,
    XBAR_INPUT_FLG_SD3FLT3_2CEVT            = 0x1305,
    XBAR_INPUT_FLG_SD3FLT3_1CEVT            = 0x1304,
    XBAR_INPUT_FLG_SD3FLT2_2CEVT            = 0x1303,
    XBAR_INPUT_FLG_SD3FLT2_1CEVT            = 0x1302,
    XBAR_INPUT_FLG_SD3FLT1_2CEVT            = 0x1301,
    XBAR_INPUT_FLG_SD3FLT1_1CEVT            = 0x1300,

    //
    // XBARFLG15
    //

    XBAR_INPUT_FLG_ERAD_EBC_EVENT0          = 0x141F,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT1          = 0x141E,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT2          = 0x1419,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT3          = 0x1418,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT4          = 0x1417,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT5          = 0x1416,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT0          = 0x1411,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT1          = 0x1410,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT2          = 0x140F,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT3          = 0x140E,
    XBAR_INPUT_FLG_ECAP6_TRIPOUT            = 0x140D,
    XBAR_INPUT_FLG_ECAP5_TRIPOUT            = 0x140C,
    XBAR_INPUT_FLG_ECAP4_TRIPOUT            = 0x140B,
    XBAR_INPUT_FLG_ECAP3_TRIPOUT            = 0x140A,
    XBAR_INPUT_FLG_ECAP2_TRIPOUT            = 0x1409,
    XBAR_INPUT_FLG_ECAP1_TRIPOUT            = 0x1408,

    //
    // XBARFLG16
    //

    XBAR_INPUT_FLG_ECAP7_TRIPOUT            = 0x1510,
    XBAR_INPUT_FLG_CMPSS12_CTRIPOUTL        = 0x150F,
    XBAR_INPUT_FLG_CMPSS12_CTRIPOUTH        = 0x150E,
    XBAR_INPUT_FLG_CMPSS12_CTRIPL           = 0x150D,
    XBAR_INPUT_FLG_CMPSS12_CTRIPH           = 0x150C,
    XBAR_INPUT_FLG_CMPSS11_CTRIPOUTL        = 0x150B,
    XBAR_INPUT_FLG_CMPSS11_CTRIPOUTH        = 0x150A,
    XBAR_INPUT_FLG_CMPSS11_CTRIPL           = 0x1509,
    XBAR_INPUT_FLG_CMPSS11_CTRIPH           = 0x1508,
    XBAR_INPUT_FLG_CMPSS10_CTRIPOUTL        = 0x1507,
    XBAR_INPUT_FLG_CMPSS10_CTRIPOUTH        = 0x1506,
    XBAR_INPUT_FLG_CMPSS10_CTRIPL           = 0x1505,
    XBAR_INPUT_FLG_CMPSS10_CTRIPH           = 0x1504,
    XBAR_INPUT_FLG_CMPSS9_CTRIPOUTL         = 0x1503,
    XBAR_INPUT_FLG_CMPSS9_CTRIPOUTH         = 0x1502,
    XBAR_INPUT_FLG_CMPSS9_CTRIPL            = 0x1501,
    XBAR_INPUT_FLG_CMPSS9_CTRIPH            = 0x1500,
    XBAR_INPUT_FLG_ECAP7_TRIPOUT_CLR        = 0x1510,
    XBAR_INPUT_FLG_CMPSS12_CTRIPOUTL_CLR    = 0x150F,
    XBAR_INPUT_FLG_CMPSS12_CTRIPOUTH_CLR    = 0x150E,
    XBAR_INPUT_FLG_CMPSS12_CTRIPL_CLR       = 0x150D,
    XBAR_INPUT_FLG_CMPSS12_CTRIPH_CLR       = 0x150C,
    XBAR_INPUT_FLG_CMPSS11_CTRIPOUTL_CLR    = 0x150B,
    XBAR_INPUT_FLG_CMPSS11_CTRIPOUTH_CLR    = 0x150A,
    XBAR_INPUT_FLG_CMPSS11_CTRIPL_CLR       = 0x1509,
    XBAR_INPUT_FLG_CMPSS11_CTRIPH_CLR       = 0x1508,
    XBAR_INPUT_FLG_CMPSS10_CTRIPOUTL_CLR    = 0x1507,
    XBAR_INPUT_FLG_CMPSS10_CTRIPOUTH_CLR    = 0x1506,
    XBAR_INPUT_FLG_CMPSS10_CTRIPL_CLR       = 0x1505,
    XBAR_INPUT_FLG_CMPSS10_CTRIPH_CLR       = 0x1504,
    XBAR_INPUT_FLG_CMPSS9_CTRIPOUTL_CLR     = 0x1503,

#endif
#elif IS_GS32F3xx()
//
// XBARFLG1
//

    XBAR_INPUT_FLG_CMPSS8_CTRIPOUTH         = 0x001F,
    XBAR_INPUT_FLG_CMPSS8_CTRIPOUTL         = 0x001E,
    XBAR_INPUT_FLG_CMPSS7_CTRIPOUTH         = 0x001D,
    XBAR_INPUT_FLG_CMPSS7_CTRIPOUTL         = 0x001C,
    XBAR_INPUT_FLG_CMPSS6_CTRIPOUTH         = 0x001B,
    XBAR_INPUT_FLG_CMPSS6_CTRIPOUTL         = 0x001A,
    XBAR_INPUT_FLG_CMPSS5_CTRIPOUTH         = 0x0019,
    XBAR_INPUT_FLG_CMPSS5_CTRIPOUTL         = 0x0018,
    XBAR_INPUT_FLG_CMPSS4_CTRIPOUTH         = 0x0017,
    XBAR_INPUT_FLG_CMPSS4_CTRIPOUTL         = 0x0016,
    XBAR_INPUT_FLG_CMPSS3_CTRIPOUTH         = 0x0015,
    XBAR_INPUT_FLG_CMPSS3_CTRIPOUTL         = 0x0014,
    XBAR_INPUT_FLG_CMPSS2_CTRIPOUTH         = 0x0013,
    XBAR_INPUT_FLG_CMPSS2_CTRIPOUTL         = 0x0012,
    XBAR_INPUT_FLG_CMPSS1_CTRIPOUTH         = 0x0011,
    XBAR_INPUT_FLG_CMPSS1_CTRIPOUTL         = 0x0010,
    XBAR_INPUT_FLG_CMPSS8_CTRIPH            = 0x000F,
    XBAR_INPUT_FLG_CMPSS8_CTRIPL            = 0x000E,
    XBAR_INPUT_FLG_CMPSS7_CTRIPH            = 0x000D,
    XBAR_INPUT_FLG_CMPSS7_CTRIPL            = 0x000C,
    XBAR_INPUT_FLG_CMPSS6_CTRIPH            = 0x000B,
    XBAR_INPUT_FLG_CMPSS6_CTRIPL            = 0x000A,
    XBAR_INPUT_FLG_CMPSS5_CTRIPH            = 0x0009,
    XBAR_INPUT_FLG_CMPSS5_CTRIPL            = 0x0008,
    XBAR_INPUT_FLG_CMPSS4_CTRIPH            = 0x0007,
    XBAR_INPUT_FLG_CMPSS4_CTRIPL            = 0x0006,
    XBAR_INPUT_FLG_CMPSS3_CTRIPH            = 0x0005,
    XBAR_INPUT_FLG_CMPSS3_CTRIPL            = 0x0004,
    XBAR_INPUT_FLG_CMPSS2_CTRIPH            = 0x0003,
    XBAR_INPUT_FLG_CMPSS2_CTRIPL            = 0x0002,
    XBAR_INPUT_FLG_CMPSS1_CTRIPH            = 0x0001,
    XBAR_INPUT_FLG_CMPSS1_CTRIPL            = 0x0000,

//
// XBARFLG2
//

    XBAR_INPUT_FLG_ADCC_1EVT                = 0x011F,
    XBAR_INPUT_FLG_ADCB_4EVT                = 0x011E,
    XBAR_INPUT_FLG_ADCB_3EVT                = 0x011D,
    XBAR_INPUT_FLG_ADCB_2EVT                = 0x011C,
    XBAR_INPUT_FLG_ADCB_1EVT                = 0x011B,
    XBAR_INPUT_FLG_ADCA_4EVT                = 0x011A,
    XBAR_INPUT_FLG_ADCA_3EVT                = 0x0119,
    XBAR_INPUT_FLG_ADCA_2EVT                = 0x0118,
    XBAR_INPUT_FLG_ADCA_1EVT                = 0x0117,
    XBAR_INPUT_FLG_EXTSYNCOUT               = 0x0116,
    XBAR_INPUT_FLG_ECAP6_OUT                = 0x0115,
    XBAR_INPUT_FLG_ECAP5_OUT                = 0x0114,
    XBAR_INPUT_FLG_ECAP4_OUT                = 0x0113,
    XBAR_INPUT_FLG_ECAP3_OUT                = 0x0112,
    XBAR_INPUT_FLG_ECAP2_OUT                = 0x0111,
    XBAR_INPUT_FLG_ECAP1_OUT                = 0x0110,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL14_OUT     = 0x010F,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL13_OUT     = 0x010E,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL12_OUT     = 0x010D,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL11_OUT     = 0x010C,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL10_OUT     = 0x010B,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL9_OUT      = 0x010A,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL8_OUT      = 0x0109,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL7_OUT      = 0x0108,
    XBAR_INPUT_FLG_ADCSOCB                  = 0x0107,
    XBAR_INPUT_FLG_ADCSOCA                  = 0x0106,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL6_OUT      = 0x0105,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL5_OUT      = 0x0104,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL4_OUT      = 0x0103,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL3_OUT      = 0x0102,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL2_OUT      = 0x0101,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL1_OUT      = 0x0100,

//
// XBARFLG3
//

    XBAR_INPUT_FLG_SD1FLT4_DRINT            = 0x021F,
    XBAR_INPUT_FLG_SD1FLT4_COMPZ            = 0x021E,
    XBAR_INPUT_FLG_SD1FLT3_DRINT            = 0x021D,
    XBAR_INPUT_FLG_SD1FLT3_COMPZ            = 0x021C,
    XBAR_INPUT_FLG_SD1FLT2_DRINT            = 0x021B,
    XBAR_INPUT_FLG_SD1FLT2_COMPZ            = 0x021A,
    XBAR_INPUT_FLG_SD1FLT1_DRINT            = 0x0219,
    XBAR_INPUT_FLG_SD1FLT1_COMPZ            = 0x0218,
    XBAR_INPUT_FLG_ECAP7_OUT                = 0x0217,
    XBAR_INPUT_FLG_SD2FLT4_1CEVT            = 0x0216,
    XBAR_INPUT_FLG_SD2FLT4_2CEVT            = 0x0215,
    XBAR_INPUT_FLG_SD2FLT3_1CEVT            = 0x0214,
    XBAR_INPUT_FLG_SD2FLT3_2CEVT            = 0x0213,
    XBAR_INPUT_FLG_SD2FLT2_1CEVT            = 0x0212,
    XBAR_INPUT_FLG_SD2FLT2_2CEVT            = 0x0211,
    XBAR_INPUT_FLG_SD2FLT1_1CEVT            = 0x0210,
    XBAR_INPUT_FLG_SD2FLT1_2CEVT            = 0x020F,
    XBAR_INPUT_FLG_SD1FLT4_1CEVT            = 0x020E,
    XBAR_INPUT_FLG_SD1FLT4_2CEVT            = 0x020D,
    XBAR_INPUT_FLG_SD1FLT3_1CEVT            = 0x020C,
    XBAR_INPUT_FLG_SD1FLT3_2CEVT            = 0x020B,
    XBAR_INPUT_FLG_SD1FLT2_1CEVT            = 0x020A,
    XBAR_INPUT_FLG_SD1FLT2_2CEVT            = 0x0209,
    XBAR_INPUT_FLG_SD1FLT1_1CEVT            = 0x0208,
    XBAR_INPUT_FLG_SD1FLT1_2CEVT            = 0x0207,
    XBAR_INPUT_FLG_ADCD_4EVT                = 0x0206,
    XBAR_INPUT_FLG_ADCD_3EVT                = 0x0205,
    XBAR_INPUT_FLG_ADCD_2EVT                = 0x0204,
    XBAR_INPUT_FLG_ADCD_1EVT                = 0x0203,
    XBAR_INPUT_FLG_ADCC_4EVT                = 0x0202,
    XBAR_INPUT_FLG_ADCC_3EVT                = 0x0201,
    XBAR_INPUT_FLG_ADCC_2EVT                = 0x0200,

//
// XBARFLG4
//

    XBAR_INPUT_FLG_CPU_HALT_IN              = 0x031F,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL16_OUT     = 0x031E,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL15_OUT     = 0x031D,
    XBAR_INPUT_FLG_ERRORSTS_IN              = 0x031C,
    XBAR_INPUT_FLG_CLB1_LC3_OUT3_SEL        = 0x031B,
    XBAR_INPUT_FLG_CLB1_LC3_OUT2_SEL        = 0x031A,
    XBAR_INPUT_FLG_CLB1_LC3_OUT1_SEL        = 0x0319,
    XBAR_INPUT_FLG_CLB1_LC3_OUT0_SEL        = 0x0318,
    XBAR_INPUT_FLG_CLB1_LC2_OUT3_SEL        = 0x0317,
    XBAR_INPUT_FLG_CLB1_LC2_OUT2_SEL        = 0x0316,
    XBAR_INPUT_FLG_CLB1_LC2_OUT1_SEL        = 0x0315,
    XBAR_INPUT_FLG_CLB1_LC2_OUT0_SEL        = 0x0314,
    XBAR_INPUT_FLG_CLB1_LC1_OUT3_SEL        = 0x0313,
    XBAR_INPUT_FLG_CLB1_LC1_OUT2_SEL        = 0x0312,
    XBAR_INPUT_FLG_CLB1_LC1_OUT1_SEL        = 0x0311,
    XBAR_INPUT_FLG_CLB1_LC1_OUT0_SEL        = 0x0310,
    XBAR_INPUT_FLG_CANB_HOST_IF_IN          = 0x030A,
    XBAR_INPUT_FLG_CANA_HOST_IF_IN          = 0x0309,
    XBAR_INPUT_FLG_SD2FLT4_DRINT            = 0x0307,
    XBAR_INPUT_FLG_SD2FLT4_COMPZ            = 0x0306,
    XBAR_INPUT_FLG_SD2FLT3_DRINT            = 0x0305,
    XBAR_INPUT_FLG_SD2FLT3_COMPZ            = 0x0304,
    XBAR_INPUT_FLG_SD2FLT2_DRINT            = 0x0303,
    XBAR_INPUT_FLG_SD2FLT2_COMPZ            = 0x0302,
    XBAR_INPUT_FLG_SD2FLT1_DRINT            = 0x0301,
    XBAR_INPUT_FLG_SD2FLT1_COMPZ            = 0x0300,

    //
    // XBARFLG11
    //

    XBAR_INPUT_FLG_SD3FLT4_DRINT            = 0x041F,
    XBAR_INPUT_FLG_SD3FLT4_COMPZ            = 0x041E,
    XBAR_INPUT_FLG_SD3FLT3_DRINT            = 0x041D,
    XBAR_INPUT_FLG_SD3FLT3_COMPZ            = 0x041C,
    XBAR_INPUT_FLG_SD3FLT2_DRINT            = 0x041B,
    XBAR_INPUT_FLG_SD3FLT2_COMPZ            = 0x041A,
    XBAR_INPUT_FLG_SD3FLT1_DRINT            = 0x0419,
    XBAR_INPUT_FLG_SD3FLT1_COMPZ            = 0x0418,
    XBAR_INPUT_FLG_SD4FLT4_DRINT            = 0x0417,
    XBAR_INPUT_FLG_SD4FLT4_COMPZ            = 0x0416,
    XBAR_INPUT_FLG_SD4FLT3_DRINT            = 0x0415,
    XBAR_INPUT_FLG_SD4FLT3_COMPZ            = 0x0414,
    XBAR_INPUT_FLG_SD4FLT2_DRINT            = 0x0413,
    XBAR_INPUT_FLG_SD4FLT2_COMPZ            = 0x0412,
    XBAR_INPUT_FLG_SD4FLT1_DRINT            = 0x0411,
    XBAR_INPUT_FLG_SD4FLT1_COMPZ            = 0x0410,

//
// XBARFLG12
//

    XBAR_INPUT_FLG_CLB2_LC3_OUT3_SEL        = 0x050B,
    XBAR_INPUT_FLG_CLB2_LC3_OUT2_SEL        = 0x050A,
    XBAR_INPUT_FLG_CLB2_LC3_OUT1_SEL        = 0x0509,
    XBAR_INPUT_FLG_CLB2_LC3_OUT0_SEL        = 0x0508,
    XBAR_INPUT_FLG_CLB2_LC2_OUT3_SEL        = 0x0507,
    XBAR_INPUT_FLG_CLB2_LC2_OUT2_SEL        = 0x0506,
    XBAR_INPUT_FLG_CLB2_LC2_OUT1_SEL        = 0x0505,
    XBAR_INPUT_FLG_CLB2_LC2_OUT0_SEL        = 0x0504,
    XBAR_INPUT_FLG_CLB2_LC1_OUT3_SEL        = 0x0503,
    XBAR_INPUT_FLG_CLB2_LC1_OUT2_SEL        = 0x0502,
    XBAR_INPUT_FLG_CLB2_LC1_OUT1_SEL        = 0x0501,
    XBAR_INPUT_FLG_CLB2_LC1_OUT0_SEL        = 0x0500,

//
// XBARFLG13
//

    XBAR_INPUT_FLG_EPG_XBAR_OUT3            = 0x061F,
    XBAR_INPUT_FLG_EPG_XBAR_OUT2            = 0x061E,
    XBAR_INPUT_FLG_EPG_XBAR_OUT1            = 0x061D,
    XBAR_INPUT_FLG_EPG_XBAR_OUT0            = 0x061C,

//
// XBARFLG14
//

    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL9_OUT  = 0x0718,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL8_OUT  = 0x0717,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL7_OUT  = 0x0716,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL14_OUT = 0x0715,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL13_OUT = 0x0714,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL12_OUT = 0x0713,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL11_OUT = 0x0712,
    XBAR_INPUT_FLG_XBAR_CLB_INPUT_SEL10_OUT = 0x0711,
    XBAR_INPUT_FLG_SD4FLT4_2CEVT            = 0x070F,
    XBAR_INPUT_FLG_SD4FLT4_1CEVT            = 0x070E,
    XBAR_INPUT_FLG_SD4FLT3_2CEVT            = 0x070D,
    XBAR_INPUT_FLG_SD4FLT3_1CEVT            = 0x070C,
    XBAR_INPUT_FLG_SD4FLT2_2CEVT            = 0x070B,
    XBAR_INPUT_FLG_SD4FLT2_1CEVT            = 0x070A,
    XBAR_INPUT_FLG_SD4FLT1_2CEVT            = 0x0709,
    XBAR_INPUT_FLG_SD4FLT1_1CEVT            = 0x0708,
    XBAR_INPUT_FLG_SD3FLT4_2CEVT            = 0x0707,
    XBAR_INPUT_FLG_SD3FLT4_1CEVT            = 0x0706,
    XBAR_INPUT_FLG_SD3FLT3_2CEVT            = 0x0705,
    XBAR_INPUT_FLG_SD3FLT3_1CEVT            = 0x0704,
    XBAR_INPUT_FLG_SD3FLT2_2CEVT            = 0x0703,
    XBAR_INPUT_FLG_SD3FLT2_1CEVT            = 0x0702,
    XBAR_INPUT_FLG_SD3FLT1_2CEVT            = 0x0701,
    XBAR_INPUT_FLG_SD3FLT1_1CEVT            = 0x0700,

//
// XBARFLG15
//

    XBAR_INPUT_FLG_ERAD_EBC_EVENT0          = 0x081F,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT1          = 0x081E,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT2          = 0x0819,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT3          = 0x0818,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT4          = 0x0817,
    XBAR_INPUT_FLG_ERAD_EBC_EVENT5          = 0x0816,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT0          = 0x0811,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT1          = 0x0810,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT2          = 0x080F,
    XBAR_INPUT_FLG_ERAD_SEC_EVENT3          = 0x080E,

//
// XBARFLG16
//

    XBAR_INPUT_FLG_CMPSS12_CTRIPOUTL        = 0x090F,
    XBAR_INPUT_FLG_CMPSS12_CTRIPOUTH        = 0x090E,
    XBAR_INPUT_FLG_CMPSS12_CTRIPL           = 0x090D,
    XBAR_INPUT_FLG_CMPSS12_CTRIPH           = 0x090C,
    XBAR_INPUT_FLG_CMPSS11_CTRIPOUTL        = 0x090B,
    XBAR_INPUT_FLG_CMPSS11_CTRIPOUTH        = 0x090A,
    XBAR_INPUT_FLG_CMPSS11_CTRIPL           = 0x0909,
    XBAR_INPUT_FLG_CMPSS11_CTRIPH           = 0x0908,
    XBAR_INPUT_FLG_CMPSS10_CTRIPOUTL        = 0x0907,
    XBAR_INPUT_FLG_CMPSS10_CTRIPOUTH        = 0x0906,
    XBAR_INPUT_FLG_CMPSS10_CTRIPL           = 0x0905,
    XBAR_INPUT_FLG_CMPSS10_CTRIPH           = 0x0904,
    XBAR_INPUT_FLG_CMPSS9_CTRIPOUTL         = 0x0903,
    XBAR_INPUT_FLG_CMPSS9_CTRIPOUTH         = 0x0902,
    XBAR_INPUT_FLG_CMPSS9_CTRIPL            = 0x0901,
    XBAR_INPUT_FLG_CMPSS9_CTRIPH            = 0x0900,



#endif
} XBAR_InputFlag;

struct xbarInput_offset{
	uint16_t  pin;
	int16_t   offset;
};

// Array mapping pins to offsets
extern struct xbarInput_offset xbar_InputGPIO_map[];

//The size of XBAR_INPUT_GPIO_MAP
#if IS_GS32F00xx(0x30)

#define XBAR_INPUT_GPIO_MAP_SIZE 				(10)

#elif IS_GS32F00xx(0x12)

#if GS32_PART_NUM==0x0049

#define XBAR_INPUT_GPIO_MAP_SIZE 				(6)

#else

#define XBAR_INPUT_GPIO_MAP_SIZE 				(2)

#endif  //GS32_PART_NUM==0x0049

#elif IS_GS32F3xx(0x22)

#define XBAR_INPUT_GPIO_MAP_SIZE 				(2)

#endif


/**
 * @brief
 * Prototypes for the APIs.
 */

/**
 * @brief Checks a X-BAR base address.
 * @details
 * This function determines if a X-BAR base address is valid.
 * @param base is the base address of the X-BAR.
 * @return true the base address is valid
 * @return false otherwise.
 */
#ifdef DEBUG
    __STATIC_INLINE bool
    XBAR_isBaseValid(uint32_t base)
    {
        return ((base == OUTPUTXBAR_BASE) ||
                (base == CLBOUTPUTXBAR_BASE) ||
                (base == CLBINPUTXBAR_BASE) ||
                (base == CLBXBAR_BASE) ||
                (base == INPUTXBAR_BASE));
    }
#endif
    /*check: do we need CLBOUTPUTXBAR_BASE & CLBINPUTXBAR_BASE*/

/**
 * @brief Enables the Output X-BAR mux values to be passed to the output signal.
 *
 * @details
 * This function enables the mux values to be passed to the X-BAR output
 * signal. The \e output parameter is a value \b XBAR_OUTPUTy where y is
 * the output number between 1 and 8 inclusive.
 *
 * @param [in]  base    the base address of the X-BAR.
 * @param [in]  output  the X-BAR output being configured.
 * @param [in]  muxes   a bit field of the muxes to be enabled.
 *
 * @remarks
 * - The \e muxes parameter is a bit field of the muxes being enabled where bit
 *   0 represents mux 0, bit 1 represents mux 1 and so on. Defines are provided
 *   in the form of \b XBAR_MUXnn that can be OR'd together to enable several
 *   muxes on an output at the same time. For example, passing this function
 *   ( \b XBAR_MUX04 | \b XBAR_MUX10 ) would enable muxes 4 and 10.
 */
    __STATIC_INLINE void
    XBAR_enableOutputMux(uint32_t base, XBAR_OutputNum output, uint32_t muxes)
    {
        uint16_t enable_offset;


        if(muxes>XBAR_MUX31)
        {

#if IS_GS32F00xx(0x12, 0x30) || IS_GS32F3xx(0x22)
            enable_offset=muxes-XBAR_MUX32;
            if(output >= 8)
            {
            	HWREG(base + XBAR_O_OUTPUT1MUXENABLE32TO64 + (uint16_t)((output - 8) * 4)) |= (1<<enable_offset);
            }
            else
            {
            	HWREG(base + XBAR_O_OUTPUT1MUXENABLE32TO64 + (uint16_t)(output * 4)) |= (1<<enable_offset);
            }
#endif
        }
        else
        {
            if(output >= 8)
            {
            	HWREG(base + XBAR_O_OUTPUT1MUXENABLE + (uint16_t)((output - 8) * 4)) |= (1<<muxes);
            }
            else
            {
            	HWREG(base + XBAR_O_OUTPUT1MUXENABLE + (uint16_t)(output * 4)) |= (1<<muxes);
            }
        }


    }

/**
 * @brief Disables the Output X-BAR mux values from being passed to the output.
 *
 * @details
 * This function disables the mux values from being passed to the X-BAR output
 * signal. The \e output parameter is a value \b XBAR_OUTPUTy where y is
 * the output number between 1 and 8 inclusive.
 *
 * @param [in]  base    the base address of the X-BAR.
 * @param [in]  output  the X-BAR output being configured.
 * @param [in]  muxes   a bit field of the muxes to be disabled.
 *
 * @remarks
 * - The \e muxes parameter is a bit field of the muxes being disabled where bit
 *   0 represents mux 0, bit 1 represents mux 1 and so on. Defines are provided
 *   in the form of \b XBAR_MUXnn that can be OR'd together to disable several
 *   muxes on an output at the same time. For example, passing this function
 *   ( \b XBAR_MUX04 | \b XBAR_MUX10 ) would disable muxes 4 and 10.
 *
 */
    __STATIC_INLINE void
    XBAR_disableOutputMux(uint32_t base, XBAR_OutputNum output, uint32_t muxes)
    {
        uint16_t enable_offset;
        if(muxes>XBAR_MUX31)
        {
#if IS_GS32F00xx(0x12, 0x30) || IS_GS32F3xx(0x22)
            enable_offset=muxes-XBAR_MUX32;
            if(output >= 8)
            {
            	HWREG(base + XBAR_O_OUTPUT1MUXENABLE32TO64 + (uint16_t)((output - 8) * 4)) |= (1<<enable_offset);
            }
            else
            {
            	HWREG(base + XBAR_O_OUTPUT1MUXENABLE32TO64 + (uint16_t)(output * 4))&=~(1<<enable_offset);
            }
#endif
        }
        else
        {
            if(output >= 8)
            {
            	HWREG(base + XBAR_O_OUTPUT1MUXENABLE32TO64 + (uint16_t)((output - 8) * 4)) |= (1<<enable_offset);
            }
            else
            {
            HWREG(base + XBAR_O_OUTPUT1MUXENABLE + (uint16_t)(output * 4))&=~(1<<muxes);
            }
        }
    }

/**
 * @brief Enables or disables the output latch to drive the selected output.
 *
 * @details
 * This function sets the Output X-BAR output signal latch mode. If the
 * \e enable parameter is \b true, the output specified by \e output will be
 * driven by the output latch.
 *
 * @param [in]  base    the base address of the X-BAR.
 * @param [in]  output  the X-BAR output being configured.
 * @param [in]  enable is a flag that determines whether or not the latch is
 * selected to drive the X-BAR output.
 *
 */
    __STATIC_INLINE void
    XBAR_setOutputLatchMode(uint32_t base, XBAR_OutputNum output, bool enable)
    {

        //
        // Check the arguments.
        //
        ASSERT(XBAR_isBaseValid(base));

        //    EALLOW;

        //
        // Set or clear the latch setting bit based on the enable parameter.
        //
        if (enable)
        {
        	if(output >= 8)
        	{
				HWREGH(base + XBAR_O_OUTPUTLATCHENABLE) |=
					0x1U << ((uint16_t)(output - 8));
        	}
        	else
        	{
				HWREGH(base + XBAR_O_OUTPUTLATCHENABLE) |=
					0x1U << ((uint16_t)output);
        	}
        }
        else
        {
        	if(output >= 8)
        	{
                HWREGH(base + XBAR_O_OUTPUTLATCHENABLE) &=
                    ~(0x1U << ((uint16_t)(output - 8)));
        	}
        	else
        	{
				HWREGH(base + XBAR_O_OUTPUTLATCHENABLE) &=
					~(0x1U << ((uint16_t)output));
        	}
        }


    }

/**
 * @brief Returns the status of the output latch.
 *
 * @param [in]  base    the base address of the X-BAR.
 * @param [in]  output  the X-BAR output being checked.
 *
 * @return true the output corresponding to output was triggered.
 * @return false otherwise.
 */
    __STATIC_INLINE bool
    XBAR_getOutputLatchStatus(uint32_t base, XBAR_OutputNum output)
    {

        //
        // Check the arguments.
        //
        ASSERT(XBAR_isBaseValid(base));

        //
        // Get the status of the Output X-BAR output latch.
        //
        if(output >= 8)
        {
        	return ((HWREGH(base + XBAR_O_OUTPUTLATCH) &
        			(0x1U << ((uint16_t)(output - 8)))) != 0U);
        }
        else
        {
			return ((HWREGH(base + XBAR_O_OUTPUTLATCH) &
					 (0x1U << ((uint16_t)output))) != 0U);
        }
    }

/**
 * @brief Clears the output latch for the specified output.
 *
 * @details
 * This function clears the Output X-BAR output latch. The output to be
 * configured is specified by the \e output parameter.
 *
 * @param [in]  base    the base address of the X-BAR.
 * @param [in]  output  the X-BAR output being configured.
 *
 */
    __STATIC_INLINE void
    XBAR_clearOutputLatch(uint32_t base, XBAR_OutputNum output)
    {

        //
        // Check the arguments.
        //
        ASSERT(XBAR_isBaseValid(base));

        //
        // Set the bit that clears the corresponding OUTPUTLATCH bit.
        //
        if(output >= 8)
        {
			HWREGH(base + XBAR_O_OUTPUTLATCHCLR) |=
				0x1U << ((uint16_t)(output - 8));
        }
        else
        {
			HWREGH(base + XBAR_O_OUTPUTLATCHCLR) |=
				0x1U << ((uint16_t)output);
        }
    }

/**
 * @brief Forces the output latch for the specified output.
 *
 * @details
 * This function clears the Output X-BAR output latch. The output to be
 * configured is specified by the \e output parameter.
 *
 * @param [in]  base    the base address of the X-BAR.
 * @param [in]  output  the X-BAR output being configured.
 *
 */
    __STATIC_INLINE void
    XBAR_forceOutputLatch(uint32_t base, XBAR_OutputNum output)
    {

        //
        // Check the arguments.
        //
        ASSERT(XBAR_isBaseValid(base));

        //
        // Set the bit that forces the corresponding OUTPUTLATCH bit.
        //
        if(output >= 8)
        {
			HWREGH(base + XBAR_O_OUTPUTLATCHFRC) =
				0x1U<<((uint16_t)(output - 8));
        }
        else
        {
			HWREGH(base + XBAR_O_OUTPUTLATCHFRC) =
				0x1U<<((uint16_t)output);
        }
    }

/**
 * @brief Configures the polarity of an Output X-BAR output.
 *
 * @details
 * This function inverts the Output X-BAR signal if the \e invert parameter is
 * \b true. If \e invert is \b false, the signal will be passed as is. The
 * \e output parameter is a value \b XBAR_OUTPUTy where y is the output
 * number between 1 and 8 inclusive.
 *
 * @param [in]  base    the base address of the X-BAR.
 * @param [in]  output  the X-BAR output being configured.
 * @param [in]  output  a flag that determines whether the output is active-high or active-low.
 *
 */
    __STATIC_INLINE void
    XBAR_invertOutputSignal(uint32_t base, XBAR_OutputNum output, bool invert)
    {


        //
        // Check the arguments.
        //
        ASSERT(XBAR_isBaseValid(base));

        //    //
        //    // Set or clear the polarity setting bit based on the invert parameter.
        //    //
        //    EALLOW;
        //
        // Set or clear the polarity setting bit based on the invert parameter.
        //
        if (invert)
        {
        	if(output >= 8)
        	{
				HWREGH(base + XBAR_O_OUTPUTINV) |=
					0x1U << ((uint16_t)(output - 8));
        	}
        	else
        	{
				HWREGH(base + XBAR_O_OUTPUTINV) |=
					0x1U << ((uint16_t)output);
        	}
        }
        else
        {
        	if(output >= 8)
        	{
                HWREGH(base + XBAR_O_OUTPUTINV) &=
                    ~(0x1U << ((uint16_t)(output - 8)));
        	}
        	else
        	{
				HWREGH(base + XBAR_O_OUTPUTINV) &=
					~(0x1U << ((uint16_t)output));
        	}
        }

    }

/**
 * @brief Enables the ePWM X-BAR mux values to be passed to an ePWM module.
 *
 * @details
 * This function enables the mux values to be passed to the X-BAR trip
 * signal. The \e trip parameter is a value \b XBAR_TRIPy where y is
 * the number of the trip signal on the ePWM.
 *
 * @param [in]  trip    the X-BAR output being configured.
 * @param [in]  muxes   a bit field of the muxes to be enabled.
 *
 * @remarks
 * - The \e muxes parameter is a bit field of the muxes being enabled where bit
 *   0 represents mux 0, bit 1 represents mux 1 and so on. Defines are provided
 *   in the form of \b XBAR_MUXnn that can be logically OR'd together to
 *   enable several muxes on an output at the same time.
 *
 */
    __STATIC_INLINE void
    XBAR_enableEPWMMux(XBAR_TripNum trip, uint32_t muxes)
    {
        uint16_t enable_offset;
        uint32_t reg_addr;

#if IS_GS32F3xx(0x22)
        if (XBAR_TRIP16<=trip)
        {
            reg_addr=XBAR_EPWM_CFG_REG_BASE+EPWMXBAR_BASE_OFFSET*(uint16_t)(trip/XBAR_TRIP16);//epwmxbar2 muxconfig address
            trip = (XBAR_TripNum)(trip % XBAR_TRIP16);
        }else
        {
            reg_addr=EPWMXBAR_BASE;//epwmxbar1 muxenable address
        }
#else
            reg_addr=EPWMXBAR_BASE;//epwmxbar1 muxenable address
#endif

        if (muxes>XBAR_MUX31)
        {
            enable_offset=muxes-XBAR_MUX32;
            HWREG(reg_addr +XBAR_O_TRIP4MUXENABLE32TO64+(uint16_t)trip*4) |=(1<<enable_offset);
        }
        else
        {
            HWREG(reg_addr + XBAR_O_TRIP4MUXENABLE+(uint16_t)trip * 4) |= (1<<muxes);
        }
    }

/**
 * @brief Disables the ePWM X-BAR mux values to be passed to an ePWM module.
 *
 * @details
 * This function disables the mux values to be passed to the X-BAR trip
 * signal. The \e trip parameter is a value \b XBAR_TRIPy where y is
 * the number of the trip signal on the ePWM.
 *
 * @param [in]  trip    the X-BAR output being configured.
 * @param [in]  muxes   a bit field of the muxes to be disabled.
 *
 * @remarks
 * - The \e muxes parameter is a bit field of the muxes being disabled where bit
 *   0 represents mux 0, bit 1 represents mux 1 and so on. Defines are provided
 *   in the form of \b XBAR_MUXnn that can be logically OR'd together to
 *   disabled several muxes on an output at the same time.
 *
 */
    __STATIC_INLINE void
    XBAR_disableEPWMMux(XBAR_TripNum trip, uint32_t muxes)
    {
        uint16_t enable_offset;
        uint32_t reg_addr;

        #if IS_GS32F00xx(0x30)
        if (XBAR_TRIP16<=trip)
        {
            trip = (XBAR_TripNum)(trip - XBAR_TRIP16);
            reg_addr=EPWMXBAR_BASE+EPWMXBAR_BASE_OFFSET;//epwmxbar2 muxenable address
        }else
        {
            reg_addr=EPWMXBAR_BASE;//epwmxbar1 muxenable address
        }
        #else
            reg_addr=EPWMXBAR_BASE;//epwmxbar1 muxenable address
        #endif

        if (muxes>XBAR_MUX31)
        {
    #if IS_GS32F00xx(0x12, 0x30) || IS_GS32F3xx(0x22)
            enable_offset=muxes-XBAR_MUX32;
            HWREG(reg_addr +XBAR_O_TRIP4MUXENABLE32TO64+(uint16_t)trip*4)&=~(1<<enable_offset);
    #endif
        }
        else
        {
            HWREG(reg_addr + XBAR_O_TRIP4MUXENABLE+(uint16_t)trip * 4)&= ~(1<<muxes);
        }
    }

/**
 * @brief Configures the polarity of an ePWM X-BAR output.
 *
 * @details
 * This function inverts the ePWM X-BAR trip signal if the \e invert
 * parameter is \b true. If \e invert is \b false, the signal will be passed
 * as is. The \e trip parameter is a value \b XBAR_TRIPy where y is
 * the number of the trip signal on the ePWM X-BAR that is being configured.
 *
 * @param [in]  trip    the X-BAR output being configured.
 * @param [in]  invert  a flag that determines whether the output is active-high
 * or active-low.
 *
 */
    __STATIC_INLINE void
    XBAR_invertEPWMSignal(XBAR_TripNum trip, bool invert)
    {
        uint32_t reg_addr;

        #if IS_GS32F00xx(0x30)
        if (XBAR_TRIP16<=trip)
        {
            trip = (XBAR_TripNum)(trip - XBAR_TRIP16);
            reg_addr=EPWMXBAR_BASE+EPWMXBAR_BASE_OFFSET;//epwmxbar2 muxenable address
        }else
        {
            reg_addr=EPWMXBAR_BASE;//epwmxbar1 muxenable address
        }
        #else
            reg_addr=EPWMXBAR_BASE;//epwmxbar1 muxenable address
        #endif

        if (invert)
        {
            HWREGH(reg_addr + XBAR_O_TRIPOUTINV) |=
                0x1U << ((uint16_t)trip);
        }
        else
        {
            HWREGH(reg_addr + XBAR_O_TRIPOUTINV) &=
                ~(0x1U << ((uint16_t)trip ));
        }
    }

/**
 * @brief Sets the GPIO pin for an Input X-BAR input.
 *
 * @details
 * This function configures which GPIO is assigned to an Input X-BAR input.
 * The \e input parameter is a value in the form of a define \b XBAR_INPUTy
 * where y is a the input number for the Input X-BAR.
 *
 * @param [in]  input   the X-BAR input being configured.
 * @param [in]  pin     the identifying number of the pin.
 *
 * @remarks
 * - The pin is specified by its numerical value. For example, GPIO34 is
 *   specified by passing 34 as \e pin.
 */
__STATIC_INLINE void
XBAR_setInputPin(uint32_t base, XBAR_InputNum input, uint16_t pin)
{
	//
	// Check the argument.
	//
	ASSERT((pin <= XBAR_GPIO_MAX_CNT) ||
		   ((pin >= XBAR_NON_GPIO_MIN_CNT) && (pin <= XBAR_NON_GPIO_MAX_CNT)));
	ASSERT(XBAR_isBaseValid(base));


    for (uint8_t i = 0; i < XBAR_INPUT_GPIO_MAP_SIZE; i++) {
        if (pin <= xbar_InputGPIO_map[i].pin) {
        	//
        	// Write the requested pin to the appropriate input select register.
        	//
        	HWREGH(base + XBAR_O_INPUT1SELECT + (uint16_t)(input<<1))
        			= (uint32_t)((int16_t)pin - xbar_InputGPIO_map[i].offset);
        	return;
        }
    }



}

/**
 * @brief Sets the GPIO pin for an ICL X-BAR input.
 *
 * @details
 * This function configures which GPIO is assigned to an ICL X-BAR input.
 * The \e input parameter is a value in the form of a define \b XBAR_INPUTy
 * where y is a the input number for the ICL X-BAR.
 *
 * @param [in]  input   the X-BAR input being configured.
 * @param [in]  pin     the identifying number of the pin.
 *
 * @remarks
 * - The pin is specified by its numerical value. For example, GPIO34 is
 *   specified by passing 34 as \e pin.
 */
#if IS_GS32F00xx(0x30)
    __STATIC_INLINE void XBAR_ICL_SetInputPin(XBAR_InputNum input,XBAR_ICLINPUT signal)
    {

           HWREGH(ICLXBAR_BASE + XBAR_ICL_ICL1SELECT + (uint16_t)(input<<1)) = signal;


    }
#endif
/**
 * @brief Sets the GPIO pin for an ICL X-BAR input.
 *
 * @details
 * This function configures which GPIO is assigned to an MINDB X-BAR input.
 * The \e input parameter is a value in the form of a define \b XBAR_INPUTy
 * where y is a the input number for the MINDB X-BAR.
 *
 * @param [in]  input   the X-BAR input being configured.
 * @param [in]  pin     the identifying number of the pin.
 *
 * @remarks
 * - The pin is specified by its numerical value. For example, GPIO34 is
 *   specified by passing 34 as \e pin.
 */
#if IS_GS32F00xx(0x30)
    __STATIC_INLINE void XBAR_MINDB_SetInputPin(XBAR_InputNum input,XBAR_MINDBINPUT signal)
    {

           HWREGH(MINDBXBAR_BASE + XBAR_MINDB_MDL1SELECT + (uint16_t)(input<<1)) = signal;


    }


//*****************************************************************************
//
//! Selects the input signal for MINDB or ICL X-BAR.
//!
//! \param base specifies the X-BAR base address.
//! \param input is the X-BAR input being configured.
//! \param signal is the input signal to be enabled.
//!
//! The \e base parameter can take base addresses
//! MINDBXBAR_BASE or ICLXBAR_BASE.
//!
//! This function configures which signal is assigned to an MINDB or ICL XBAR.
//!
//! The \e input parameter is a value in the form of a define \b XBAR_INPUTy
//! where y is a the input number for the Input X-BAR.
//!
//! The \e signal parameter inputs are passed through \e XBAR_InputSignal
//! enumumeration.
//! The connections to the MINDB and ICL XBAR corresponding to the \e signal
//! parameter are described in the device reference manual.
//!
//! \return None.
//
//*****************************************************************************
static inline void
XBAR_setInputSignal(uint32_t base, XBAR_InputNum input,
										XBAR_InputSignal inputSignal)
{
	//
	// Check the argument.
	//
	ASSERT((base == MINDBXBAR_BASE) || (base == ICLXBAR_BASE));

	if(base == MINDBXBAR_BASE)
	{
		//
		// Enable the requested signal to the appropriate input select register.
		//
		EALLOW;
		HWREGH(base + XBAR_ICL_ICL1SELECT +
			   (uint16_t)(input<<1)) = (uint16_t)inputSignal;
		EDIS;
	}
	else
	{
		//
		// Enable the requested signal to the appropriate input select register.
		//
		EALLOW;
		HWREGH(base + XBAR_ICL_ICL1SELECT +
			   (uint16_t)(input<<1)) = (uint16_t)inputSignal;
		EDIS;
	}
}
#endif
/**
 * @brief Enables the CLB X-BAR mux values to be passed to an CLB module.
 *
 * @details
 * This function enables the mux values to be passed to the X-BAR auxSignal
 * signal. The \e auxSignal parameter is a value \b XBAR_AUXSIGy where y is
 * the number of the signal on the CLB.
 *
 * @param [in]  auxSignal  the X-BAR output being configured.
 * @param [in]  muxes      a bit field of the muxes to be enabled.
 *
 * @remarks
 * - The \e muxes parameter is a bit field of the muxes being enabled where bit
 *   0 represents mux 0, bit 1 represents mux 1 and so on. Defines are provided
 *   in the form of \b XBAR_MUXnn that can be logically OR'd together to
 *   enable several muxes on an output at the same time.
 */
    __STATIC_INLINE void
    XBAR_enableClbMux(XBAR_AuxSigNum auxSignal, uint32_t muxes)
    {
        uint16_t enable_offset;
        if (muxes>XBAR_MUX31)
        {
     #if IS_GS32F3xx(0x22) || IS_GS32F00xx(0x12)
            enable_offset=muxes-XBAR_MUX32;
            HWREG(XBAR_CLB_EN_REG_BASE+XBAR_O_AUXSIG0MUXENABLE32TO64+ (uint16_t)auxSignal * 4) |=(1<<enable_offset);
    #endif
        }
        else
        {
            HWREG(XBAR_CLB_EN_REG_BASE + (uint16_t)auxSignal*4) |= (1<<muxes);
        }
    }

/**
 * @brief Disables the CLB X-BAR mux values to be passed to an CLB module.
 *
 * @details
 * This function disables the mux values to be passed to the X-BAR auxSignal
 * signal. The \e auxSignal parameter is a value \b XBAR_AUXSIGy where y is
 * the number of the signal on the CLB.
 *
 * @param [in]  auxSignal  the X-BAR output being configured.
 * @param [in]  muxes      a bit field of the muxes to be diabled.
 *
 * @remarks
 * - The \e muxes parameter is a bit field of the muxes being diabled. where bit
 *   0 represents mux 0, bit 1 represents mux 1 and so on. Defines are provided
 *   in the form of \b XBAR_MUXnn that can be logically OR'd together to
 *   diabled several muxes on an output at the same time.
 */
    __STATIC_INLINE void
    XBAR_disableClbMux(XBAR_AuxSigNum auxSignal, uint32_t muxes)
    {
        uint16_t enable_offset;
        if (muxes>XBAR_MUX31)
        {
     #if IS_GS32F3xx(0x22) || IS_GS32F00xx(0x12)
            enable_offset=muxes-XBAR_MUX32;
            HWREG(XBAR_CLB_EN_REG_BASE+XBAR_O_AUXSIG0MUXENABLE32TO64+ (uint16_t)auxSignal * 4)&=~(1<<enable_offset);
    #endif
        }
        else
        {
            HWREG(XBAR_CLB_EN_REG_BASE + (uint16_t)auxSignal*4)&=~(1<<muxes);
        }
    }

/**
 * @brief Configures the polarity of an CLB X-BAR output.
 *
 * @details
 * This function inverts the CLB X-BAR auxSignal signal if the \e invert
 * parameter is \b true. If \e invert is \b false, the signal will be passed
 * as is. The \e auxSignal parameter is a value \b XBAR_AUXSIGy where y is
 * the number of the signal on the CLB X-BAR that is being configured.
 *
 * @param [in]  auxSignal  the X-BAR output being configured.
 * @param [in]  invert     a flag that determines whether the output is active-high
 * or active-low.
 *
 */
    __STATIC_INLINE void
    XBAR_invertClbSignal(XBAR_AuxSigNum auxSignal, bool invert)
    {

        //
        // Set or clear the polarity setting bit based on the invert parameter.
        //
        //    EALLOW;
        uint16_t shift;
        if (auxSignal < XBAR_AUXSIG8)
            shift = auxSignal;
        else
            shift = (auxSignal - 48) / 4U; // 48 is the offset of auxsig8

        if (invert)
        {
            HWREGH(CLBXBAR_BASE + XBAR_O_AUXSIGOUTINV) |=
                (0x1U << shift);
        }
        else
        {
            HWREGH(CLBXBAR_BASE + XBAR_O_AUXSIGOUTINV) &=
                ~(0x1U << shift);
        }

    }

/**
 * @brief INPUTXBAR invert config base 0x1100 and 0x0012
 *
 * @param input xbar input
 * @param invert value
 *
 */
    __STATIC_INLINE void
    XBAR_invertInputSignal(XBAR_InputNum input, bool invert)
    {

        //
        // Set or clear the polarity setting bit based on the invert parameter.
        //
        if (invert)
        {
            HWREGH(INPUTXBAR_BASE + XBAR_INV_SELECT) |= (0x1 << input);
        }
        else
        {
            HWREGH(INPUTXBAR_BASE + XBAR_INV_SELECT) &= ~(0x1 << input);
        }


    }
/**
 * @brief CLBINPUTXBAR invert config base 0x1100 and 0x0012
 *
 * @param input xbar input
 * @param invert value
 *
 */
    __STATIC_INLINE void
    XBAR_ClbInputInvertSignal(XBAR_InputNum input, bool invert)
    {
        if (invert)
        {
            HWREG(CLBINPUTXBAR_BASE + XBAR_CLB_INPUTINV) |= (0x1 << input);
        }
        else
        {
            HWREGH(CLBINPUTXBAR_BASE + XBAR_CLB_INPUTINV) &= ~(0x1 << input);
        }

    }

#if IS_GS32F00xx(0x30)

    /**
      * @brief Set the output of clb
      *
      * @param clbunm  Set the CLB channel to be replaced
      * @param out_clbunm Set the signal to be output
      *
      */
     __STATIC_INLINE void
 	XBAR_Clb_OUTPUT_SEL(XBAR_clb_sel clbunm, clb_out_sel  out_clbunm )
     {

         //
         // Set or clear the polarity setting bit based on the invert parameter.

        HWREGH(INPUTXBAR_BASE + XBAR_PLU1_OUT_SEL) |= ( out_clbunm << clbunm);


     }

     /**
      * @brief Set the output of clb to the default value.
      *
      *
      */
     __STATIC_INLINE void
 	XBAR_Clb_OUTPUT_Reset(void)
     {

         //
         // Set the output of clb to the default value.

        HWREGH(INPUTXBAR_BASE + XBAR_PLU1_OUT_SEL) = 0x0;
        HWREG(INPUTXBAR_BASE + XBAR_PLU2_OUT_SEL) = 0X111111U;

     }
#endif
/**
 * @brief Configures the Output X-BAR mux that determines the signals passed to an output.
 *
 * @details
 * This function configures an Output X-BAR mux. This determines which
 * signal(s) should be passed through the X-BAR to a GPIO. The \e output
 * parameter is a value \b XBAR_OUTPUTy where y is a the output number
 * between 1 and 8 inclusive.
 *
 * @param [in] output     the X-BAR output being configured.
 * @param [in] muxConfig  mux configuration that specifies the signal.
 *
 * @remarks
 * - The \e muxConfig parameter for OUTPUT XBAR is the mux configuration
 *   value that specifies which signal will be passed from the mux. The
 *   values have the format of \b XBAR_OUT_MUXnn_xx where the 'xx' is
 *   the signal and nn is the mux number.
 * - This function may be called for each mux of an output and their values will
 *   be logically OR'd before being passed to the output signal. This means that
 *   this function may be called, for example, with the argumentXBAR_OUT_
 *   MUX00_ECAP1_OUT and then with the argument XBAR_OUT_MUX01_INPUTXBAR1, resulting
 *   in the values of MUX00 and MUX01 being logically OR'd if both are enabled.
 *   Calling the function twice for the same mux on the output will result in
 *   the configuration in the second call overwriting the first.
 */
    extern void
    XBAR_setOutputMuxConfig(uint32_t base, XBAR_OutputNum output, XBAR_OutputMuxConfig muxConfig);
/**
 * @brief Configures the ePWM X-BAR mux that determines the signals passed to an ePWM module.
 *
 * @details
 * This function configures an ePWM X-BAR mux. This determines which signal(s)
 * should be passed through the X-BAR to an ePWM module. The \e trip
 * parameter is a value \b XBAR_TRIPy where y is a the number of the trip
 * signal on the ePWM.
 *
 * @param [in] trip        the X-BAR output being configured.
 * @param [in] muxConfig   mux configuration that specifies the signal.
 *
 * @remarks
 * - The \e muxConfig parameter is the mux configuration value that specifies
 *   which signal will be passed from the mux. The values have the format of
 *   \b XBAR_EPWM_MUXnn_xx where the 'xx' is the signal and nn is the mux
 *   number (0 through 31). The possible values are found in <tt>xbar.h</tt>
 * - This function may be called for each mux of an output and their values will
 *   be logically OR'd before being passed to the output signal. This means that
 *   this function may be called, for example, with the argumentXBAR_OUT_
 *   MUX00_ECAP1_OUT and then with the argument XBAR_OUT_MUX01_INPUTXBAR1, resulting
 *   in the values of MUX00 and MUX01 being logically OR'd if both are enabled.
 *   Calling the function twice for the same mux on the output will result in
 *   the configuration in the second call overwriting the first.
 */
    extern void
    XBAR_setEPWMMuxConfig(XBAR_TripNum trip, XBAR_EPWMMuxConfig muxConfig);

/**
 * @brief Returns the status of the input latch.
 *
 * @param [in] inputFlag  the X-BAR input latch being checked. Values are in the
 * format of /b XBAR_INPUT_FLG_XXXX where "XXXX" is name of the signal.
 *
 * @return true the X-BAR input corresponding to the nputFlag has been triggered.
 * @return false otherwise.
 */
    extern bool
    XBAR_getInputFlagStatus(XBAR_InputFlag inputFlag);

/**
 * @brief Clears the input latch for the specified input latch.
 * @details
 * This function clears the Input X-BAR input latch. The input latch to be
 * cleared is specified by the \e inputFlag parameter.
 *
 * @param [in] inputFlag is the X-BAR input latch being cleared.
 */
    extern void
    XBAR_clearInputFlag(XBAR_InputFlag inputFlag);

/**
 * @brief Configures the CLB X-BAR mux that determines the signals passed to a CLB module.
 *
 * @details
 * This function configures an CLB X-BAR mux. This determines which signal(s)
 * should be passed through the X-BAR to an CLB module. The \e auxSignal
 * parameter is a value \b XBAR_AUXSIGy where y is a the number of the
 * signal on the CLB.
 *
 * @param [in] auxSignal   the X-BAR output being configured.
 * @param [in] muxConfig   mux configuration that specifies the signal.
 *
 * @remarks
 * - The \e muxConfig parameter is the mux configuration value that specifies
 *   which signal will be passed from the mux. The values have the format of
 *   \b XBAR_EPWM_MUXnn_xx where the 'xx' is the signal and nn is the mux
 *   number (0 through 31). The possible values are found in <tt>xbar.h</tt>
 * - This function may be called for each mux of an output and their values will
 *   be logically OR'd before being passed to the output signal. This means that
 *   this function may be called, for example, with the argumentXBAR_OUT_
 *   MUX00_ECAP1_OUT and then with the argument XBAR_OUT_MUX01_INPUTXBAR1, resulting
 *   in the values of MUX00 and MUX01 being logically OR'd if both are enabled.
 *   Calling the function twice for the same mux on the output will result in
 *   the configuration in the second call overwriting the first.
 */
    extern void XBAR_setCLBMuxConfig(XBAR_AuxSigNum auxSignal,
                                     XBAR_CLBMuxConfig muxConfig);

/**
 * Close the Doxygen group.@}
 *
*/

/**
 * @brief Mark the end of the C bindings section for C++ compilers.
 */

#ifdef __cplusplus
}
#endif
#endif

