/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    GlobalVariableDefs.c
*   @brief   
*   @details
*   commit history
*   20240330, Jason, add ECAP, EQEP registers, add #if defined(xxx).
*   20240413, Jason, change CMPSS1Regs to Cmpss1Regs.
*   20240416, Jason, add support for 1.1ES inputxbar, outputxbar, xbar, epwmxbar 
*   20240704, Hezhiyuan, add support for 1.2 and compatibility 1.1
*   20240708, Hezhiyuan, add support for 2.2
*   20240927, Zhengyulong, add APB_COMM_PARA register in lines 454 through 457
*   20250102, Wanwenjuan, modify 2.2 XDMA register in lines 424 through 440,add support for 2.2 xdma
*/

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#if IS_GS32F00xx()
#include "device_gs32f00xx/device_support_gs32f00xx.h"
#include "device_gs32f00xx/hw_memmap_gs32f00xx.h"
#elif IS_GS32F3xx()
#include "device_gs32f3xx/device_support_gs32f3xx.h"
#include "device_gs32f3xx/hw_memmap_gs32f3xx.h"
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */


/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/********************  CMPSS registers *********************/
#if defined(CMPSS1_BASE)
__attribute__ ((section(".cmpss1_regs"))) volatile struct CMPSS_REGS Cmpss1Regs;
volatile struct CMPSS_REGS * const ptrCmpss1Regs = (struct CMPSS_REGS *)CMPSS1_BASE;
#endif
#if defined(CMPSS2_BASE)
__attribute__ ((section(".cmpss2_regs"))) volatile struct CMPSS_REGS Cmpss2Regs;
volatile struct CMPSS_REGS * const ptrCmpss2Regs = (struct CMPSS_REGS *)CMPSS2_BASE;
#endif
#if defined(CMPSS3_BASE)
__attribute__ ((section(".cmpss3_regs"))) volatile struct CMPSS_REGS Cmpss3Regs;
volatile struct CMPSS_REGS * const ptrCmpss3Regs = (struct CMPSS_REGS *)CMPSS3_BASE;
#endif
#if defined(CMPSS4_BASE)
__attribute__ ((section(".cmpss4_regs"))) volatile struct CMPSS_REGS Cmpss4Regs;
volatile struct CMPSS_REGS * const ptrCmpss4Regs = (struct CMPSS_REGS *)CMPSS4_BASE;
#endif
#if defined(CMPSS5_BASE)
__attribute__ ((section(".cmpss5_regs"))) volatile struct CMPSS_REGS Cmpss5Regs;
volatile struct CMPSS_REGS * const ptrCmpss5Regs = (struct CMPSS_REGS *)CMPSS5_BASE;
#endif
#if defined(CMPSS6_BASE)
__attribute__ ((section(".cmpss6_regs"))) volatile struct CMPSS_REGS Cmpss6Regs;
volatile struct CMPSS_REGS * const ptrCmpss6Regs = (struct CMPSS_REGS *)CMPSS6_BASE;
#endif
#if defined(CMPSS7_BASE)
__attribute__ ((section(".cmpss7_regs"))) volatile struct CMPSS_REGS Cmpss7Regs;
volatile struct CMPSS_REGS * const ptrCmpss7Regs = (struct CMPSS_REGS *)CMPSS7_BASE;
#endif
#if defined(CMPSS8_BASE)
__attribute__ ((section(".cmpss8_regs"))) volatile struct CMPSS_REGS Cmpss8Regs;
volatile struct CMPSS_REGS * const ptrCmpss8Regs = (struct CMPSS_REGS *)CMPSS8_BASE;
#endif
#if defined(CMPSS9_BASE)
__attribute__ ((section(".cmpss9_regs"))) volatile struct CMPSS_REGS Cmpss9Regs;
volatile struct CMPSS_REGS * const ptrCmpss9Regs = (struct CMPSS_REGS *)CMPSS9_BASE;
#endif
#if defined(CMPSS10_BASE)
__attribute__ ((section(".cmpss10_regs"))) volatile struct CMPSS_REGS Cmpss10Regs;
volatile struct CMPSS_REGS * const ptrCmpss10Regs = (struct CMPSS_REGS *)CMPSS10_BASE;
#endif
#if defined(CMPSS11_BASE)
__attribute__ ((section(".cmpss11_regs"))) volatile struct CMPSS_REGS Cmpss11Regs;
volatile struct CMPSS_REGS * const ptrCmpss11Regs = (struct CMPSS_REGS *)CMPSS11_BASE;
#endif
#if defined(CMPSS12_BASE)
__attribute__ ((section(".cmpss12_regs"))) volatile struct CMPSS_REGS Cmpss12Regs;
volatile struct CMPSS_REGS * const ptrCmpss12Regs = (struct CMPSS_REGS *)CMPSS12_BASE;
#endif


/********************  EPWM registers *********************/
#if(EPWM_VERSION == 30)
#define EXTEND_OFFSET 0x300
#else
#define EXTEND_OFFSET 0x3FC
#endif
#if defined(EPWM1_BASE)
__attribute__ ((section(".epwm1_regs"))) volatile struct EPWM_REGS EPwm1Regs;
__attribute__ ((section(".epwm1_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm1ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm1Regs = (struct EPWM_REGS *)EPWM1_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm1ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM1_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM2_BASE)
__attribute__ ((section(".epwm2_regs"))) volatile struct EPWM_REGS EPwm2Regs;
__attribute__ ((section(".epwm2_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm2ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm2Regs = (struct EPWM_REGS *)EPWM2_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm2ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM2_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM3_BASE)
__attribute__ ((section(".epwm3_regs"))) volatile struct EPWM_REGS EPwm3Regs;
__attribute__ ((section(".epwm3_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm3ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm3Regs = (struct EPWM_REGS *)EPWM3_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm3ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM3_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM4_BASE)
__attribute__ ((section(".epwm4_regs"))) volatile struct EPWM_REGS EPwm4Regs;
__attribute__ ((section(".epwm4_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm4ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm4Regs = (struct EPWM_REGS *)EPWM4_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm4ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM4_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM5_BASE)
__attribute__ ((section(".epwm5_regs"))) volatile struct EPWM_REGS EPwm5Regs;
__attribute__ ((section(".epwm5_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm5ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm5Regs = (struct EPWM_REGS *)EPWM5_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm5ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM5_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM6_BASE)
__attribute__ ((section(".epwm6_regs"))) volatile struct EPWM_REGS EPwm6Regs;
__attribute__ ((section(".epwm6_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm6ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm6Regs = (struct EPWM_REGS *)EPWM6_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm6ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM6_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM7_BASE)
__attribute__ ((section(".epwm7_regs"))) volatile struct EPWM_REGS EPwm7Regs;
__attribute__ ((section(".epwm7_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm7ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm7Regs = (struct EPWM_REGS *)EPWM7_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm7ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM7_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM8_BASE)
__attribute__ ((section(".epwm8_regs"))) volatile struct EPWM_REGS EPwm8Regs;
__attribute__ ((section(".epwm8_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm8ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm8Regs = (struct EPWM_REGS *)EPWM8_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm8ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM8_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM9_BASE)
__attribute__ ((section(".epwm9_regs"))) volatile struct EPWM_REGS EPwm9Regs;
__attribute__ ((section(".epwm9_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm9ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm9Regs = (struct EPWM_REGS *)EPWM9_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm9ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM9_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM10_BASE)
__attribute__ ((section(".epwm10_regs"))) volatile struct EPWM_REGS EPwm10Regs;
__attribute__ ((section(".epwm10_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm10ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm10Regs = (struct EPWM_REGS *)EPWM10_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm10ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM10_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM11_BASE)
__attribute__ ((section(".epwm11_regs"))) volatile struct EPWM_REGS EPwm11Regs;
__attribute__ ((section(".epwm11_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm11ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm11Regs = (struct EPWM_REGS *)EPWM11_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm11ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM11_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM12_BASE)
__attribute__ ((section(".epwm12_regs"))) volatile struct EPWM_REGS EPwm12Regs;
__attribute__ ((section(".epwm12_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm12ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm12Regs = (struct EPWM_REGS *)EPWM12_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm12ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM12_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM13_BASE)
__attribute__ ((section(".epwm13_regs"))) volatile struct EPWM_REGS EPwm13Regs;
__attribute__ ((section(".epwm13_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm13ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm13Regs = (struct EPWM_REGS *)EPWM13_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm13ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM13_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM14_BASE)
__attribute__ ((section(".epwm14_regs"))) volatile struct EPWM_REGS EPwm14Regs;
__attribute__ ((section(".epwm14_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm14ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm14Regs = (struct EPWM_REGS *)EPWM14_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm14ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM14_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM15_BASE)
__attribute__ ((section(".epwm15_regs"))) volatile struct EPWM_REGS EPwm15Regs;
__attribute__ ((section(".epwm15_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm15ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm15Regs = (struct EPWM_REGS *)EPWM15_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm15ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM15_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM16_BASE)
__attribute__ ((section(".epwm16_regs"))) volatile struct EPWM_REGS EPwm16Regs;
__attribute__ ((section(".epwm16_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm16ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm16Regs = (struct EPWM_REGS *)EPWM16_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm16ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM16_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM17_BASE)
__attribute__ ((section(".epwm17_regs"))) volatile struct EPWM_REGS EPwm17Regs;
__attribute__ ((section(".epwm17_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm17ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm17Regs = (struct EPWM_REGS *)EPWM17_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm17ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM17_BASE + EXTEND_OFFSET);
#endif
#if defined(EPWM18_BASE)
__attribute__ ((section(".epwm18_regs"))) volatile struct EPWM_REGS EPwm18Regs;
__attribute__ ((section(".epwm18_extend_regs"))) volatile struct EPWM_EXTEND_REGS EPwm18ExtRegs;
volatile struct EPWM_REGS * const ptrEPwm18Regs = (struct EPWM_REGS *)EPWM18_BASE;
volatile struct EPWM_EXTEND_REGS * const ptrEPwm18ExtRegs = (struct EPWM_EXTEND_REGS *)(EPWM18_BASE + EXTEND_OFFSET);
#endif

__attribute__ ((section(".epwmtop_regs"))) volatile struct EPWM_TOP_REGS EPwmTopRegs;
volatile struct EPWM_TOP_REGS * const ptrEPwmTopRegs = (struct EPWM_TOP_REGS *)EPWMTOP_BASE;

/********************  ADC registers *********************/
#if defined(ADCA_BASE)
__attribute__ ((section(".adca_regs"))) volatile struct ADC_REGS AdcaRegs;
volatile struct ADC_REGS * const ptrAdcaRegs = (struct ADC_REGS *)ADCA_BASE;
#endif
#if defined(ADCB_BASE)
__attribute__ ((section(".adcb_regs"))) volatile struct ADC_REGS AdcbRegs;
volatile struct ADC_REGS * const ptrAdcbRegs = (struct ADC_REGS *)ADCB_BASE;
#endif
#if defined(ADCC_BASE)
__attribute__ ((section(".adcc_regs"))) volatile struct ADC_REGS AdccRegs;
volatile struct ADC_REGS * const ptrAdccRegs = (struct ADC_REGS *)ADCC_BASE;
#endif
#if defined(ADCD_BASE)
__attribute__ ((section(".adcd_regs"))) volatile struct ADC_REGS AdcdRegs;
volatile struct ADC_REGS * const ptrAdcdRegs = (struct ADC_REGS *)ADCD_BASE;
#endif


/********************  ADC result registers *********************/
#if defined(ADCARESULT_BASE)
__attribute__ ((section(".adca_result_regs"))) volatile struct ADC_RESULT_REGS AdcaResultRegs;
volatile struct ADC_RESULT_REGS * const ptrAdcaResultRegs = (struct ADC_RESULT_REGS *)ADCARESULT_BASE;
#endif
#if defined(ADCBRESULT_BASE)
__attribute__ ((section(".adcb_result_regs"))) volatile struct ADC_RESULT_REGS AdcbResultRegs;
volatile struct ADC_RESULT_REGS * const ptrAdcbResultRegs = (struct ADC_RESULT_REGS *)ADCBRESULT_BASE;
#endif
#if defined(ADCCRESULT_BASE)
__attribute__ ((section(".adcc_result_regs"))) volatile struct ADC_RESULT_REGS AdccResultRegs;
volatile struct ADC_RESULT_REGS * const ptrAdccResultRegs = (struct ADC_RESULT_REGS *)ADCCRESULT_BASE;
#endif
#if defined(ADCDRESULT_BASE)
__attribute__ ((section(".adcd_result_regs"))) volatile struct ADC_RESULT_REGS AdcdResultRegs;
volatile struct ADC_RESULT_REGS * const ptrAdcdResultRegs = (struct ADC_RESULT_REGS *)ADCDRESULT_BASE;
#endif


/********************  ECAP registers *********************/
#if defined(ECAP1_BASE)
__attribute__ ((section(".ecap1_regs"))) volatile struct ECAP_REGS ECap1Regs;
volatile struct ECAP_REGS * const ptrECap1Regs = (struct ECAP_REGS *)ECAP1_BASE;
#endif
#if defined(ECAP2_BASE)
__attribute__ ((section(".ecap2_regs"))) volatile struct ECAP_REGS ECap2Regs;
volatile struct ECAP_REGS * const ptrECap2Regs = (struct ECAP_REGS *)ECAP2_BASE;
#endif
#if defined(ECAP3_BASE)
__attribute__ ((section(".ecap3_regs"))) volatile struct ECAP_REGS ECap3Regs;
volatile struct ECAP_REGS * const ptrECap3Regs = (struct ECAP_REGS *)ECAP3_BASE;
#endif
#if defined(ECAP4_BASE)
__attribute__ ((section(".ecap4_regs"))) volatile struct ECAP_REGS ECap4Regs;
volatile struct ECAP_REGS * const ptrECap4Regs = (struct ECAP_REGS *)ECAP4_BASE;
#endif
#if defined(ECAP5_BASE)
__attribute__ ((section(".ecap5_regs"))) volatile struct ECAP_REGS ECap5Regs;
volatile struct ECAP_REGS * const ptrECap5Regs = (struct ECAP_REGS *)ECAP5_BASE;
#endif
#if defined(ECAP6_BASE)
__attribute__ ((section(".ecap6_regs"))) volatile struct ECAP_REGS ECap6Regs;
volatile struct ECAP_REGS * const ptrECap6Regs = (struct ECAP_REGS *)ECAP6_BASE;
#endif
#if defined(ECAP7_BASE)
__attribute__ ((section(".ecap7_regs"))) volatile struct ECAP_REGS ECap7Regs;
volatile struct ECAP_REGS * const ptrECap7Regs = (struct ECAP_REGS *)ECAP7_BASE;
#endif


/********************  EQEP registers *********************/
#if defined(EQEP1_BASE)
__attribute__ ((section(".eqep1_regs"))) volatile struct EQEP_REGS EQep1Regs;
volatile struct EQEP_REGS * const ptrEQep1Regs = (struct EQEP_REGS *)EQEP1_BASE;
#endif
#if defined(EQEP2_BASE)
__attribute__ ((section(".eqep2_regs"))) volatile struct EQEP_REGS EQep2Regs;
volatile struct EQEP_REGS * const ptrEQep2Regs = (struct EQEP_REGS *)EQEP2_BASE;
#endif
#if defined(EQEP3_BASE)
__attribute__ ((section(".eqep3_regs"))) volatile struct EQEP_REGS EQep3Regs;
volatile struct EQEP_REGS * const ptrEQep3Regs = (struct EQEP_REGS *)EQEP3_BASE;
#endif
#if defined(EQEP4_BASE)
__attribute__ ((section(".eqep4_regs"))) volatile struct EQEP_REGS EQep4Regs;
volatile struct EQEP_REGS * const ptrEQep4Regs = (struct EQEP_REGS *)EQEP4_BASE;
#endif
#if defined(EQEP5_BASE)
__attribute__ ((section(".eqep5_regs"))) volatile struct EQEP_REGS EQep5Regs;
volatile struct EQEP_REGS * const ptrEQep5Regs = (struct EQEP_REGS *)EQEP5_BASE;
#endif
#if defined(EQEP6_BASE)
__attribute__ ((section(".eqep6_regs"))) volatile struct EQEP_REGS EQep6Regs;
volatile struct EQEP_REGS * const ptrEQep6Regs = (struct EQEP_REGS *)EQEP6_BASE;
#endif
/********************  DAC registers *********************/
#if defined(DACA_BASE)
__attribute__ ((section(".daca_regs"))) volatile struct DAC_REGS DacaRegs;
volatile struct DAC_REGS * const ptrDacaRegs = (struct DAC_REGS *)DACA_BASE;
#endif
#if defined(DACB_BASE)
__attribute__ ((section(".dacb_regs"))) volatile struct DAC_REGS DacbRegs;
volatile struct DAC_REGS * const ptrDacbRegs = (struct DAC_REGS *)DACB_BASE;
#endif
#if defined(DACC_BASE)
__attribute__ ((section(".dacc_regs"))) volatile struct DAC_REGS DaccRegs;
volatile struct DAC_REGS * const ptrDaccRegs = (struct DAC_REGS *)DACC_BASE;
#endif

/********************  SDFM registers *********************/
#if defined(SDFM1_BASE)
__attribute__ ((section(".sdfm1_regs"))) volatile struct SDFM_REGS Sdfm1Regs;
volatile struct SDFM_REGS * const ptrSdfm1Regs = (struct SDFM_REGS *)SDFM1_BASE;
#endif
#if defined(SDFM2_BASE)
__attribute__ ((section(".sdfm2_regs"))) volatile struct SDFM_REGS Sdfm2Regs;
volatile struct SDFM_REGS * const ptrSdfm2Regs = (struct SDFM_REGS *)SDFM2_BASE;
#endif

/********************  EPG registers *********************/
#if defined(EPG_BASE)
__attribute__ ((section(".epg_regs"))) volatile struct EPG_REGS EpgRegs;
volatile struct EPG_REGS * const ptrEpgRegs = (struct EPG_REGS *)EPG_BASE;
#endif

/********************  CPUTimer registers *********************/
#if defined(CPUTIMER0_BASE)
__attribute__ ((section(".cputimer0_regs"))) volatile struct CPUTIMER_REGS CpuTimer0Regs;
volatile struct CPUTIMER_REGS * const ptrCpuTimer0Regs = (struct CPUTIMER_REGS *)CPUTIMER0_BASE;
#endif
#if defined(CPUTIMER1_BASE)
__attribute__ ((section(".cputimer1_regs"))) volatile struct CPUTIMER_REGS CpuTimer1Regs;
volatile struct CPUTIMER_REGS * const ptrCpuTimer1Regs = (struct CPUTIMER_REGS *)CPUTIMER1_BASE;
#endif
#if defined(CPUTIMER2_BASE)
__attribute__ ((section(".cputimer2_regs"))) volatile struct CPUTIMER_REGS CpuTimer2Regs;
volatile struct CPUTIMER_REGS * const ptrCpuTimer2Regs = (struct CPUTIMER_REGS *)CPUTIMER2_BASE;
#endif
#if defined(CPUTIMER3_BASE)
__attribute__ ((section(".cputimer3_regs"))) volatile struct CPUTIMER_REGS CpuTimer3Regs;
volatile struct CPUTIMER_REGS * const ptrCpuTimer3Regs = (struct CPUTIMER_REGS *)CPUTIMER3_BASE;
#endif
#if defined(CPUTIMER4_BASE)
__attribute__ ((section(".cputimer4_regs"))) volatile struct CPUTIMER_REGS CpuTimer4Regs;
volatile struct CPUTIMER_REGS * const ptrCpuTimer4Regs = (struct CPUTIMER_REGS *)CPUTIMER4_BASE;
#endif
#if defined(CPUTIMER5_BASE)
__attribute__ ((section(".cputimer5_regs"))) volatile struct CPUTIMER_REGS CpuTimer5Regs;
volatile struct CPUTIMER_REGS * const ptrCpuTimer5Regs = (struct CPUTIMER_REGS *)CPUTIMER5_BASE;
#endif


/********************  XBAR registers *********************/
#if defined(INPUTXBAR_BASE)
__attribute__ ((section(".inputxbar_regs"))) volatile struct INPUT_XBAR_REGS InputXbarRegs;
volatile struct INPUT_XBAR_REGS * const ptrInputXbarRegs = (struct INPUT_XBAR_REGS *)INPUTXBAR_BASE;
#endif
#if defined(CLBINPUTXBAR_BASE)
__attribute__ ((section(".clbinputxbar_regs"))) volatile struct INPUT_XBAR_REGS ClbInputXbarRegs;
volatile struct INPUT_XBAR_REGS * const ptrClbInputXbarRegs = (struct INPUT_XBAR_REGS *)CLBINPUTXBAR_BASE;
#endif
#if defined(XBAR_BASE)
__attribute__ ((section(".xbar_regs"))) volatile struct XBAR_REGS XbarRegs;
volatile struct XBAR_REGS * const ptrXbarRegs = (struct XBAR_REGS *)XBAR_BASE;
#endif

#if defined(CLBOUTPUTXBAR_BASE)
__attribute__ ((section(".clboutputxbar_regs"))) volatile struct CLB_OUTPUTXBAR_REGS ClbOutputXbarRegs;
volatile struct CLB_OUTPUTXBAR_REGS * const ptrClbOutputXbarRegs = (struct CLB_OUTPUTXBAR_REGS *)CLBOUTPUTXBAR_BASE;
#endif
#if defined(CLBOUTPUTXBAR2_BASE)
__attribute__ ((section(".clboutputxbar2_regs"))) volatile struct CLB_OUTPUTXBAR_REGS ClbOutputXbar2Regs;
volatile struct CLB_OUTPUTXBAR_REGS * const ptrClbOutputXbar2Regs = (struct CLB_OUTPUTXBAR_REGS *)CLBOUTPUTXBAR2_BASE;
#endif
#if defined(EPWMXBAR_BASE)
__attribute__ ((section(".epwmxbar_regs"))) volatile struct EPWM_XBAR_REGS EPwmXbarRegs;
volatile struct EPWM_XBAR_REGS * const ptrEPwmXbarRegs = (struct EPWM_XBAR_REGS *)EPWMXBAR_BASE;
#endif

#if defined(OUTPUTXBAR_BASE)
__attribute__ ((section(".outputxbar_regs"))) volatile struct OUTPUT_XBAR_REGS OutputXbarRegs;
volatile struct OUTPUT_XBAR_REGS * const ptrOutputXbarRegs = (struct OUTPUT_XBAR_REGS *)OUTPUTXBAR_BASE;
#endif
#if defined(OUTPUTXBAR2_BASE)
__attribute__ ((section(".outputxbar2_regs"))) volatile struct OUTPUT_XBAR_REGS OutputXbar2Regs;
volatile struct OUTPUT_XBAR_REGS * const ptrOutputXbar2Regs = (struct OUTPUT_XBAR_REGS *)OUTPUTXBAR2_BASE;
#endif
#if defined(CLBXBAR_BASE)
#if IS_GS32F00xx(0x12, 0x30) || IS_GS32F3xx(0x22)
__attribute__ ((section(".clbxbar_regs"))) volatile struct CLB_XBAR_REGS ClbXbarRegs;
volatile struct CLB_XBAR_REGS * const ptrClbXbarRegs = (struct CLB_XBAR_REGS *)CLBXBAR_BASE;
#endif
#endif




/********************  GPIO data registers *********************/
#if defined(GPIOCTRL_BASE)

#if IS_GS32F00xx(0x30)
#if GS32_PART_NUM==0x035 || GS32_PART_NUM==0x027

__attribute__ ((section(".io_cfg_3527_ctrl_regs"))) volatile struct GPIO_CTRL_REGS GpioCtrlRegs;
volatile struct GPIO_CTRL_REGS * const ptrGpioCtrlRegs = (struct GPIO_CTRL_REGS *)GPIOCTRL_BASE;

__attribute__ ((section(".io_cfg_3527_data_regs"))) volatile struct GPIO_DATA_REGS GpioDataRegs;
volatile struct GPIO_DATA_REGS * const ptrGpioDataRegs = (struct GPIO_DATA_REGS *)GPIODATA_BASE;

__attribute__ ((section(".io_cfg_3527_int_regs"))) volatile struct GPIO_INT_REGS GpioIntRegs;
volatile struct GPIO_INT_REGS * const ptrGpioIntRegs = (struct GPIO_INT_REGS *)GPIOINT_BASE;
#else
__attribute__ ((section(".io_cfg_regs"))) volatile struct IO_CFG_PARA_REGS IoCfgPapaRegs ;
volatile struct IO_CFG_PARA_REGS * const ptrIoCfgPapaRegs = (struct IO_CFG_PARA_REGS *)IO_CFG_BASE;

__attribute__ ((section(".io_cfg_ctrl_regs"))) volatile struct GPIO_CTRL_REGS GpioCtrlRegs ;
volatile struct GPIO_CTRL_REGS * const ptrGpioCtrlRegs = (struct GPIO_CTRL_REGS *)GPIOCTRL_BASE;

__attribute__ ((section(".io_cfg_data_regs"))) volatile struct GPIO_DATA_REGS GpioDataRegs ;
volatile struct GPIO_DATA_REGS * const ptrGpioDataRegs = (struct GPIO_DATA_REGS *)GPIODATA_BASE;

__attribute__ ((section(".io_cfg_dataread_regs"))) volatile struct GPIO_DATA_READ_REGS GpioDataReadRegs ;
volatile struct GPIO_DATA_READ_REGS * const ptrGpioDataReadRegs = (struct GPIO_DATA_READ_REGS *)GPIODATAREAD_BASE;

__attribute__ ((section(".io_cfg_int_regs"))) volatile struct GPIO_INT_REGS GpioIntRegs ;
volatile struct GPIO_INT_REGS * const ptrGpioIntRegs = (struct GPIO_INT_REGS *)GPIOINTERRUPT_BASE;

#endif
#else
__attribute__ ((section(".io_cfg_regs"))) volatile struct GPIO_CTRL_REGS GpioCtrlRegs;
volatile struct GPIO_CTRL_REGS * const ptrGpioCtrlRegs = (struct GPIO_CTRL_REGS *)GPIOCTRL_BASE;
#endif  /* IS_GS32F00xx(0x30) */

#endif /* defined(GPIOCTRL_BASE) */
#if defined(GPIO_PORTA_BASE) || defined(GPIO_GROUP0_BASE)
__attribute__ ((section(".gpio_porta_regs"))) volatile struct GPIO_REGS GpioPortaRegs;
volatile struct GPIO_REGS * const ptrGpioPortaRegs = (struct GPIO_REGS *)GPIO_GROUP0_BASE;
#endif
#if defined(GPIO_PORTB_BASE) || defined(GPIO_GROUP1_BASE)
__attribute__ ((section(".gpio_portb_regs"))) volatile struct GPIO_REGS GpioPortbRegs;
volatile struct GPIO_REGS * const ptrGpioPortbRegs = (struct GPIO_REGS *)GPIO_GROUP1_BASE;
#endif
#if defined(GPIO_PORTC_BASE) || defined(GPIO_GROUP2_BASE)
__attribute__ ((section(".gpio_portc_regs"))) volatile struct GPIO_REGS GpioPortcRegs;
volatile struct GPIO_REGS * const ptrGpioPortcRegs = (struct GPIO_REGS *)GPIO_GROUP2_BASE;
#endif
#if defined(GPIO_PORTD_BASE) || defined(GPIO_GROUP3_BASE)
__attribute__ ((section(".gpio_portd_regs"))) volatile struct GPIO_REGS GpioPortdRegs;
volatile struct GPIO_REGS * const ptrGpioPortdRegs = (struct GPIO_REGS *)GPIO_GROUP3_BASE;
#endif
#if defined(GPIO_PORTE_BASE) || defined(GPIO_GROUP4_BASE)
__attribute__ ((section(".gpio_porte_regs"))) volatile struct GPIO_REGS GpioPorteRegs;
volatile struct GPIO_REGS * const ptrGpioPorteRegs = (struct GPIO_REGS *)GPIO_GROUP4_BASE;
#endif
#if defined(GPIO_PORTF_BASE) || defined(GPIO_GROUP5_BASE)
__attribute__ ((section(".gpio_portf_regs"))) volatile struct GPIO_REGS GpioPortfRegs;
volatile struct GPIO_REGS * const ptrGpioPortfRegs = (struct GPIO_REGS *)GPIO_GROUP5_BASE;
#endif
#if defined(GPIO_PORTG_BASE) || defined(GPIO_GROUP6_BASE)
__attribute__ ((section(".gpio_portg_regs"))) volatile struct GPIO_REGS GpioPortgRegs;
volatile struct GPIO_REGS * const ptrGpioPortgRegs = (struct GPIO_REGS *)GPIO_GROUP6_BASE;
#endif
#if defined(GPIO_PORTH_BASE) || defined(GPIO_GROUP7_BASE)
__attribute__ ((section(".gpio_porth_regs"))) volatile struct GPIO_REGS GpioPorthRegs;
volatile struct GPIO_REGS * const ptrGpioPorthRegs = (struct GPIO_REGS *)GPIO_GROUP7_BASE;
#endif
#if defined(GPIO_PORTI_BASE) || defined(GPIO_GROUP8_BASE)
__attribute__ ((section(".gpio_porti_regs"))) volatile struct GPIO_REGS GpioPortiRegs;
volatile struct GPIO_REGS * const ptrGpioPortiRegs = (struct GPIO_REGS *)GPIO_GROUP8_BASE;
#endif
#if defined(GPIO_PORTJ_BASE) || defined(GPIO_GROUP9_BASE)
__attribute__ ((section(".gpio_portj_regs"))) volatile struct GPIO_REGS GpioPortjRegs;
volatile struct GPIO_REGS * const ptrGpioPortjRegs = (struct GPIO_REGS *)GPIO_GROUP9_BASE;
#endif
#if defined(GPIO_PORTK_BASE) || defined(GPIO_GROUP10_BASE)
__attribute__ ((section(".gpio_portk_regs"))) volatile struct GPIO_REGS GpioPortkRegs;
volatile struct GPIO_REGS * const ptrGpioPortkRegs = (struct GPIO_REGS *)GPIO_GROUP10_BASE;
#endif
#if defined(GPIO_PORTL_BASE) || defined(GPIO_GROUP11_BASE)
__attribute__ ((section(".gpio_portl_regs"))) volatile struct GPIO_REGS GpioPortlRegs;
volatile struct GPIO_REGS * const ptrGpioPortlRegs = (struct GPIO_REGS *)GPIO_GROUP11_BASE;
#endif
#if defined(GPIO_PORTM_BASE) || defined(GPIO_GROUP12_BASE)
__attribute__ ((section(".gpio_portm_regs"))) volatile struct GPIO_REGS GpioPortmRegs;
volatile struct GPIO_REGS * const ptrGpioPortmRegs = (struct GPIO_REGS *)GPIO_GROUP12_BASE;
#endif
#if defined(GPIO_PORTN_BASE) || defined(GPIO_GROUP13_BASE)
__attribute__ ((section(".gpio_portn_regs"))) volatile struct GPIO_REGS GpioPortnRegs;
volatile struct GPIO_REGS * const ptrGpioPortnRegs = (struct GPIO_REGS *)GPIO_GROUP13_BASE;
#endif



/*  1.1: GPIO PadConfig and PinMux registers are included in Sysctl_H_Regs */



/********************  Watchdog registers *********************/
#if defined(WD1_BASE)
__attribute__ ((section(".wd1_regs"))) volatile struct WD_REGS Wd1Regs;
volatile struct WD_REGS * const ptrWd1Regs = (struct WD_REGS *)WD1_BASE;
#endif
#if defined(WD2_BASE)
__attribute__ ((section(".wd2_regs"))) volatile struct WD_REGS Wd2Regs;
volatile struct WD_REGS * const ptrWd2Regs = (struct WD_REGS *)WD2_BASE;
#endif

/********************  SysCtl registers *********************/
#if IS_GS32F00xx(0x12)
// __attribute__ ((section(".ahb1_comm_regs"))) volatile struct AHB1_COMM_REGS Ahb1CommPapaRegs;
__attribute__ ((section(".anacfg_regs"))) volatile struct ANALOG_SUBSYS_REGS AnalogSubsysRegs;
volatile struct ANALOG_SUBSYS_REGS * const ptrAnalogSubsysRegs = (struct ANALOG_SUBSYS_REGS *)ANALOGSUBSYS_BASE;
// __attribute__ ((section(".crg_cfg_regs"))) volatile struct CRG_CFG_PAPA_REGS CrgCfgPapaRegs;
__attribute__ ((section(".apbcommpara_regs"))) volatile struct APB_COMM_PARA_REGS ApbCommParaRegs;
volatile struct APB_COMM_PARA_REGS * const ptrApbCommParaRegs = (struct APB_COMM_PARA_REGS *)APB_COMM_PARA_BASE;
// __attribute__ ((section(".subcrg_regs"))) volatile struct SUB_CRG_REGS SubCrgRegs;
// __attribute__ ((section(".sysctl_regs"))) volatile struct SYSCTL_REGS SysCtlRegs;
#elif IS_GS32F3xx(0x22)
__attribute__ ((section(".apbcommpara_regs"))) volatile struct APB_COMM_PARA_REGS ApbCommParaRegs;
volatile struct APB_COMM_PARA_REGS * const ptrApbCommParaRegs = (struct APB_COMM_PARA_REGS *)APB_COMM_PARA_BASE;
#elif IS_GS32F00xx(0x30)
__attribute__ ((section(".anacfg_regs"))) volatile struct ANALOG_SUBSYS_REGS AnalogSubsysRegs;
volatile struct ANALOG_SUBSYS_REGS * const ptrAnalogSubsysRegs = (struct ANALOG_SUBSYS_REGS *)ANALOGSUBSYS_BASE;
#endif

/********************  DMA registers *********************/
#if IS_GS32F00xx(0x12)
__attribute__ ((section(".dma1_ch1_regs"))) volatile struct DMA_CH_REGS Dma1Ch1Regs;
__attribute__ ((section(".dma1_ch2_regs"))) volatile struct DMA_CH_REGS Dma1Ch2Regs;
__attribute__ ((section(".dma1_ch3_regs"))) volatile struct DMA_CH_REGS Dma1Ch3Regs;
__attribute__ ((section(".dma1_ch4_regs"))) volatile struct DMA_CH_REGS Dma1Ch4Regs;
__attribute__ ((section(".dma1_ch5_regs"))) volatile struct DMA_CH_REGS Dma1Ch5Regs;
__attribute__ ((section(".dma1_ch6_regs"))) volatile struct DMA_CH_REGS Dma1Ch6Regs;
__attribute__ ((section(".dma1_ch7_regs"))) volatile struct DMA_CH_REGS Dma1Ch7Regs;
__attribute__ ((section(".dma1_ch8_regs"))) volatile struct DMA_CH_REGS Dma1Ch8Regs;

volatile struct DMA_CH_REGS * const ptrDma1Ch1Regs = (struct DMA_CH_REGS *)DMA1_CH1_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch2Regs = (struct DMA_CH_REGS *)DMA1_CH2_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch3Regs = (struct DMA_CH_REGS *)DMA1_CH3_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch4Regs = (struct DMA_CH_REGS *)DMA1_CH4_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch5Regs = (struct DMA_CH_REGS *)DMA1_CH5_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch6Regs = (struct DMA_CH_REGS *)DMA1_CH6_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch7Regs = (struct DMA_CH_REGS *)DMA1_CH7_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch8Regs = (struct DMA_CH_REGS *)DMA1_CH8_BASE;

__attribute__ ((section(".dma2_ch1_regs"))) volatile struct DMA_CH_REGS Dma2Ch1Regs;
__attribute__ ((section(".dma2_ch2_regs"))) volatile struct DMA_CH_REGS Dma2Ch2Regs;
__attribute__ ((section(".dma2_ch3_regs"))) volatile struct DMA_CH_REGS Dma2Ch3Regs;
__attribute__ ((section(".dma2_ch4_regs"))) volatile struct DMA_CH_REGS Dma2Ch4Regs;
__attribute__ ((section(".dma2_ch5_regs"))) volatile struct DMA_CH_REGS Dma2Ch5Regs;
__attribute__ ((section(".dma2_ch6_regs"))) volatile struct DMA_CH_REGS Dma2Ch6Regs;
__attribute__ ((section(".dma2_ch7_regs"))) volatile struct DMA_CH_REGS Dma2Ch7Regs;
__attribute__ ((section(".dma2_ch8_regs"))) volatile struct DMA_CH_REGS Dma2Ch8Regs;

volatile struct DMA_CH_REGS * const ptrDma2Ch1Regs = (struct DMA_CH_REGS *)DMA2_CH1_BASE;
volatile struct DMA_CH_REGS * const ptrDma2Ch2Regs = (struct DMA_CH_REGS *)DMA2_CH2_BASE;
volatile struct DMA_CH_REGS * const ptrDma2Ch3Regs = (struct DMA_CH_REGS *)DMA2_CH3_BASE;
volatile struct DMA_CH_REGS * const ptrDma2Ch4Regs = (struct DMA_CH_REGS *)DMA2_CH4_BASE;
volatile struct DMA_CH_REGS * const ptrDma2Ch5Regs = (struct DMA_CH_REGS *)DMA2_CH5_BASE;
volatile struct DMA_CH_REGS * const ptrDma2Ch6Regs = (struct DMA_CH_REGS *)DMA2_CH6_BASE;
volatile struct DMA_CH_REGS * const ptrDma2Ch7Regs = (struct DMA_CH_REGS *)DMA2_CH7_BASE;
volatile struct DMA_CH_REGS * const ptrDma2Ch8Regs = (struct DMA_CH_REGS *)DMA2_CH8_BASE;

// __attribute__ ((section(".dma_mux_regs"))) volatile struct  

#elif IS_GS32F3xx(0x22)
__attribute__ ((section(".dma1_ch1_regs"))) volatile XDMA_Channel_TypeDef Dma1Ch1Regs;
__attribute__ ((section(".dma1_ch2_regs"))) volatile XDMA_Channel_TypeDef Dma1Ch2Regs;
__attribute__ ((section(".dma1_ch3_regs"))) volatile XDMA_Channel_TypeDef Dma1Ch3Regs;
__attribute__ ((section(".dma1_ch4_regs"))) volatile XDMA_Channel_TypeDef Dma1Ch4Regs;
__attribute__ ((section(".dma1_ch5_regs"))) volatile XDMA_Channel_TypeDef Dma1Ch5Regs;
__attribute__ ((section(".dma1_ch6_regs"))) volatile XDMA_Channel_TypeDef Dma1Ch6Regs;
__attribute__ ((section(".dma1_ch7_regs"))) volatile XDMA_Channel_TypeDef Dma1Ch7Regs;
__attribute__ ((section(".dma1_ch8_regs"))) volatile XDMA_Channel_TypeDef Dma1Ch8Regs;

volatile XDMA_Channel_TypeDef * const ptrDma1Ch1Regs = (XDMA_Channel_TypeDef *)DMA1_CH1_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma1Ch2Regs = (XDMA_Channel_TypeDef *)DMA1_CH2_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma1Ch3Regs = (XDMA_Channel_TypeDef *)DMA1_CH3_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma1Ch4Regs = (XDMA_Channel_TypeDef *)DMA1_CH4_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma1Ch5Regs = (XDMA_Channel_TypeDef *)DMA1_CH5_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma1Ch6Regs = (XDMA_Channel_TypeDef *)DMA1_CH6_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma1Ch7Regs = (XDMA_Channel_TypeDef *)DMA1_CH7_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma1Ch8Regs = (XDMA_Channel_TypeDef *)DMA1_CH8_BASE;

__attribute__ ((section(".dma2_ch1_regs"))) volatile XDMA_Channel_TypeDef Dma2Ch1Regs;
__attribute__ ((section(".dma2_ch2_regs"))) volatile XDMA_Channel_TypeDef Dma2Ch2Regs;
__attribute__ ((section(".dma2_ch3_regs"))) volatile XDMA_Channel_TypeDef Dma2Ch3Regs;
__attribute__ ((section(".dma2_ch4_regs"))) volatile XDMA_Channel_TypeDef Dma2Ch4Regs;
__attribute__ ((section(".dma2_ch5_regs"))) volatile XDMA_Channel_TypeDef Dma2Ch5Regs;
__attribute__ ((section(".dma2_ch6_regs"))) volatile XDMA_Channel_TypeDef Dma2Ch6Regs;
__attribute__ ((section(".dma2_ch7_regs"))) volatile XDMA_Channel_TypeDef Dma2Ch7Regs;
__attribute__ ((section(".dma2_ch8_regs"))) volatile XDMA_Channel_TypeDef Dma2Ch8Regs;

volatile XDMA_Channel_TypeDef * const ptrDma2Ch1Regs = (XDMA_Channel_TypeDef *)DMA2_CH1_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma2Ch2Regs = (XDMA_Channel_TypeDef *)DMA2_CH2_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma2Ch3Regs = (XDMA_Channel_TypeDef *)DMA2_CH3_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma2Ch4Regs = (XDMA_Channel_TypeDef *)DMA2_CH4_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma2Ch5Regs = (XDMA_Channel_TypeDef *)DMA2_CH5_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma2Ch6Regs = (XDMA_Channel_TypeDef *)DMA2_CH6_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma2Ch7Regs = (XDMA_Channel_TypeDef *)DMA2_CH7_BASE;
volatile XDMA_Channel_TypeDef * const ptrDma2Ch8Regs = (XDMA_Channel_TypeDef *)DMA2_CH8_BASE;

#elif IS_GS32F00xx(0x30)
__attribute__ ((section(".dma1_ch1_regs"))) volatile struct DMA_CH_REGS Dma1Ch1Regs;
__attribute__ ((section(".dma1_ch2_regs"))) volatile struct DMA_CH_REGS Dma1Ch2Regs;
__attribute__ ((section(".dma1_ch3_regs"))) volatile struct DMA_CH_REGS Dma1Ch3Regs;
__attribute__ ((section(".dma1_ch4_regs"))) volatile struct DMA_CH_REGS Dma1Ch4Regs;
__attribute__ ((section(".dma1_ch5_regs"))) volatile struct DMA_CH_REGS Dma1Ch5Regs;
__attribute__ ((section(".dma1_ch6_regs"))) volatile struct DMA_CH_REGS Dma1Ch6Regs;

volatile struct DMA_CH_REGS * const ptrDma1Ch1Regs = (struct DMA_CH_REGS *)DMA_CH1_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch2Regs = (struct DMA_CH_REGS *)DMA_CH2_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch3Regs = (struct DMA_CH_REGS *)DMA_CH3_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch4Regs = (struct DMA_CH_REGS *)DMA_CH4_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch5Regs = (struct DMA_CH_REGS *)DMA_CH5_BASE;
volatile struct DMA_CH_REGS * const ptrDma1Ch6Regs = (struct DMA_CH_REGS *)DMA_CH6_BASE;
#endif


/********************  eFlash registers *********************/
#if IS_GS32F00xx(0x12, 0x30)

// __attribute__ ((section(".flash_icache_regs"))) volatile struct FLASH_ICACHE_REGS FlashICacheRegs;

// __attribute__ ((section(".flash_dcache_regs"))) volatile struct FLASH_DCACHE_REGS FlashDCacheRegs;

__attribute__ ((section(".flash_efc_regs"))) volatile struct  EFLASH_REGS eflashefcRegs;
__attribute__ ((section(".flash_efc2_regs"))) volatile struct  EFLASH_REGS eflashefc2Regs;
volatile struct EFLASH_REGS * const ptreflashefcRegs = (struct EFLASH_REGS *)FLASH_INTERFACE_EFC_BASE;
volatile struct EFLASH_REGS * const ptreflashefc2Regs = (struct EFLASH_REGS *)FLASH_INTERFACE_EFC2_BASE;

#elif IS_GS32F3xx(0x22)
__attribute__ ((section(".flash0_interface_regs"))) volatile struct  EFLASH_REGS eflash0efcRegs;
volatile struct EFLASH_REGS * const ptreflash0efcRegs = (struct EFLASH_REGS *)FLASH_INTERFACE_EFC_BASE;
#endif



/********************  CRC registers *********************/
#if defined(CRC_BASE)
__attribute__ ((section(".crc_regs"))) volatile struct CRC_REGS CrcRegs;
volatile struct CRC_REGS * const ptrCrcRegs = (struct CRC_REGS *)CRC_BASE;
#endif

/********************  SCI registers *********************/
__attribute__ ((section(".scia_regs"))) volatile struct SCI_REGS SciaRegs;
__attribute__ ((section(".scib_regs"))) volatile struct SCI_REGS ScibRegs;

volatile struct SCI_REGS * const ptrSciaRegs = (struct SCI_REGS *)SCIA_BASE;
volatile struct SCI_REGS * const ptrScibRegs = (struct SCI_REGS *)SCIB_BASE;

#if defined(SCIC_BASE)
__attribute__ ((section(".scic_regs"))) volatile struct SCI_REGS ScicRegs;
volatile struct SCI_REGS * const ptrScicRegs = (struct SCI_REGS *)SCIC_BASE;
#endif
#if defined(SCID_BASE)
__attribute__ ((section(".scid_regs"))) volatile struct SCI_REGS ScidRegs;
volatile struct SCI_REGS * const ptrScidRegs = (struct SCI_REGS *)SCID_BASE;
#endif

/********************  SPI registers *********************/
#if defined(SPIA_BASE)
__attribute__ ((section(".spia_regs"))) volatile struct SPI_REGS SpiaRegs;
volatile struct SPI_REGS * const ptrSpiaRegs = (struct SPI_REGS *)SPIA_BASE;
#endif
#if defined(SPIB_BASE)
__attribute__ ((section(".spib_regs"))) volatile struct SPI_REGS SpibRegs;
volatile struct SPI_REGS * const ptrSpibRegs = (struct SPI_REGS *)SPIB_BASE;
#endif
#if defined(SPIC_BASE)
__attribute__ ((section(".spic_regs"))) volatile struct SPI_REGS SpicRegs;
volatile struct SPI_REGS * const ptrSpicRegs = (struct SPI_REGS *)SPIC_BASE;
#endif
#if defined(SPID_BASE)
__attribute__ ((section(".spid_regs"))) volatile struct SPI_REGS SpidRegs;
volatile struct SPI_REGS * const ptrSpidRegs = (struct SPI_REGS *)SPID_BASE;
#endif

/********************  I2C registers *********************/
#if defined(I2CA_BASE)
__attribute__ ((section(".i2ca_regs"))) volatile struct I2C_REGS I2caRegs;
volatile struct I2C_REGS * const ptrI2caRegs = (struct I2C_REGS *)I2CA_BASE;
#endif
#if defined(I2CB_BASE)
__attribute__ ((section(".i2cb_regs"))) volatile struct I2C_REGS I2cbRegs;
volatile struct I2C_REGS * const ptrI2cbRegs = (struct I2C_REGS *)I2CB_BASE;
#endif
#if defined(I2CC_BASE)
__attribute__ ((section(".i2cc_regs"))) volatile struct I2C_REGS I2ccRegs;
volatile struct I2C_REGS * const ptrI2ccRegs = (struct I2C_REGS *)I2CC_BASE;
#endif


/********************  CAN registers *********************/
#if IS_GS32F00xx(0x30)
#if defined(CANA_BASE)
__attribute__ ((section(".cana_regs"))) volatile struct MCAN_REGS McanaRegs;
volatile struct MCAN_REGS * const ptrCanaRegs = (struct MCAN_REGS *)CANA_BASE;
#endif
#if defined(CANB_BASE)
__attribute__ ((section(".canb_regs"))) volatile struct MCAN_REGS McanbRegs;
volatile struct MCAN_REGS * const ptrCanbRegs = (struct MCAN_REGS *)CANB_BASE;
#endif
#else
#if defined(CANA_BASE)
__attribute__ ((section(".cana_regs"))) volatile struct CAN_REGS CanaRegs;
volatile struct CAN_REGS * const ptrCanaRegs = (struct CAN_REGS *)CANA_BASE;
#endif
#if defined(CANB_BASE)
__attribute__ ((section(".canb_regs"))) volatile struct CAN_REGS CanbRegs;
volatile struct CAN_REGS * const ptrCanbRegs = (struct CAN_REGS *)CANB_BASE;
#endif
#if defined(CANC_BASE)
__attribute__ ((section(".canc_regs"))) volatile struct CAN_REGS CancRegs;
volatile struct CAN_REGS * const ptrCancRegs = (struct CAN_REGS *)CANC_BASE;
#endif
#if defined(CAND_BASE)
__attribute__ ((section(".cand_regs"))) volatile struct CAN_REGS CandRegs;
volatile struct CAN_REGS * const ptrCandRegs = (struct CAN_REGS *)CAND_BASE;
#endif
#endif
/********************  LIN registers *********************/
#if defined(LINA_BASE)
__attribute__ ((section(".lina_regs"))) volatile struct LIN_REGS LinaRegs;
volatile struct LIN_REGS * const ptrLinaRegs = (struct LIN_REGS *)LINA_BASE;
#endif
#if defined(LINB_BASE)
__attribute__ ((section(".linb_regs"))) volatile struct LIN_REGS LinbRegs;
volatile struct LIN_REGS * const ptrLinbRegs = (struct LIN_REGS *)LINB_BASE;
#endif
/********************  QSPI registers *********************/
//#if defined(QSPIA_BASE)
//__attribute__ ((section(".qspi_regs"))) volatile struct QSPI_REGS QspiRegs;
//#endif

#ifdef __cplusplus
}
#endif

