/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/*
 * @File adc_ex01_soc_sofrware.c
 *
 * @Title   ADC Software Triggering
 *
 * This example converts some voltages on ADCA and ADCC based on a
 * software trigger.
 *
 * @External Connections:
 * - A0, A1, C2, and C3 should be connected to signals to convert.
 *
 * @Watch Variables
 * - myADC0Result0 - Digital representation of the voltage on pin A0.
 * - myADC0Result1 - Digital representation of the voltage on pin A1.
 * - myADC1Result0 - Digital representation of the voltage on pin C2.
 * - myADC1Result1 - Digital representation of the voltage on pin C3.
 *
 */
#ifdef __cplusplus
extern "C"
{
#endif

/* Include Files */
#include "adc_ex01_board.h"

/* Global Variables */
volatile uint16_t myADC0Result0;
volatile uint16_t myADC0Result1;
volatile uint16_t myADC1Result0;
volatile uint16_t myADC1Result1;

/* Main */
void main(void)
{
    /* Initialize device clock and peripherals */
    Device_init();

    /* Set up ADCs, initializing the SOCs to be triggered by software */
    Board_init();

    /* Enable Global Interrupt */
    EINT;

    /* Loop indefinitely */
    while(1)
    {
        /* Convert, wait for completion, and store results */
    	AdcaRegs.ADCSOCFRC1.bit.SOC0 = 1;
    	AdcaRegs.ADCSOCFRC1.bit.SOC1 = 1;

        /* Wait for ADCA to complete, then acknowledge flag */
    	while(AdcaRegs.ADCINTFLG.bit.ADCINT1 == false)
    	{

        }
    	AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;

    	/* Convert, wait for completion, and store results */
    	AdccRegs.ADCSOCFRC1.bit.SOC0 = 1;
    	AdccRegs.ADCSOCFRC1.bit.SOC1 = 1;

        /* Wait for ADCA to complete, then acknowledge flag */
    	while(AdccRegs.ADCINTFLG.bit.ADCINT1 == false)
    	{

        }
    	AdccRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;

        /* Store results */
    	myADC0Result0 = AdcaResultRegs.ADCRESULT0;
    	myADC0Result1 = AdcaResultRegs.ADCRESULT1;
		myADC1Result0 = AdccResultRegs.ADCRESULT0;
		myADC1Result1 = AdccResultRegs.ADCRESULT1;

    }
}

#ifdef __cplusplus
}
#endif
