/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    adc_ex09_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "adc_ex09_board.h"
#include "cpu.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


/*
 * @brief Board Configurations
 *
 * Initializes the rest of the modules.
 * Call this function in your application if you wish to do all module
 * initialization.
 * If you wish to not use some of the initializations, instead of the
 * Board_init use the individual Module_inits.
 */
void Board_init()
{
	ADC_init();
	INTERRUPT_init();
}

/*
 * ADC Configurations
 */
void ADC_init(){
	myADC0_init();
}
void myADC0_init(){
	/*
	 * @brief ADC Initialization:
	 * 		  Write ADC configurations and power up the ADC.
	 */
	/* Select ADC Reference mode and Reference voltage */
	ADC_setVREF(myADC0_BASE, ADC_REFERENCE_INTERNAL, ADC_REFERENCE_3_3V);

	/* Set trim */
	ADC_setINLTrim(myADC0_BASE);

	/* Configures the analog-to-digital converter module prescaler. */
	ADC_setPrescaler(myADC0_BASE, ADC_CLK_DIV_4_0);

	/* Sets the timing of the end-of-conversion pulse */
	ADC_setInterruptPulseMode(myADC0_BASE, ADC_PULSE_END_OF_CONV);

	/* Powers up the ADCA core. */
	ADC_enableConverter(myADC0_BASE);

	/* Delay for 1ms to allow ADCA time to power up */
	DEVICE_DELAY_US(5000);

	/*
	 * @brief SOC Configuration:
	 * 		  Setup ADC EPWM channel and trigger settings.
	 */
	/* Disables SOC burst mode. */
	ADC_disableBurstMode(myADC0_BASE);

	/* Sets the priority mode of the SOCs. */
	ADC_setSOCPriority(myADC0_BASE, ADC_PRI_ALL_ROUND_ROBIN);

	/*
	 * @brief Start of Conversion 0 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 0
	 * 			Trigger			: ADC_TRIGGER_EPWM1_SOCA
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM1_SOCA, ADC_CH_ADCIN0, 50U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_NONE);

	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_EPWM2_SOCA
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER1, ADC_TRIGGER_EPWM2_SOCA, ADC_CH_ADCIN2, 9U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER1, ADC_INT_SOC_TRIGGER_NONE);

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 1 Configuration
	 * 		Source	: ADC_SOC_NUMBER1
	 * 		Interrupt Source: enabled
	 * 		Continuous Mode	: disabled
	 */
	ADC_setInterruptSource(myADC0_BASE, ADC_INT_NUMBER1, ADC_SOC_NUMBER0);
	ADC_clearInterruptStatus(myADC0_BASE, ADC_INT_NUMBER1);
	ADC_disableContinuousMode(myADC0_BASE, ADC_INT_NUMBER1);
	ADC_enableInterrupt(myADC0_BASE, ADC_INT_NUMBER1);

	/*
	 * ADC Interrupt 2 Configuration
	 * 		Source	: ADC_SOC_NUMBER1
	 * 		Interrupt Source: enabled
	 * 		Continuous Mode	: disabled
	 */
	ADC_setInterruptSource(myADC0_BASE, ADC_INT_NUMBER2, ADC_SOC_NUMBER1);
	ADC_clearInterruptStatus(myADC0_BASE, ADC_INT_NUMBER2);
	ADC_disableContinuousMode(myADC0_BASE, ADC_INT_NUMBER2);
	ADC_enableInterrupt(myADC0_BASE, ADC_INT_NUMBER2);
			
	/*
	 * PPB Configuration: Configure high and low limits detection for ADCPPB
	 *
	 * Post Processing Block 1 Configuration
	 * 		Configures a post-processing block (PPB) in the ADC.
	 * 		PPB Number				: 1
	 * 		SOC/EOC number			: 0
	 * 		Calibration Offset		: 0
	 * 		Reference Offset		: 0
	 * 		Two's Complement		: Disabled
	 * 		Trip High Limit			: 0
	 * 		Trip Low Limit			: 0
	 * 		Clear PPB Event Flags	: Disabled
	 */
	ADC_setupPPB(myADC0_BASE, ADC_PPB_NUMBER1, ADC_SOC_NUMBER0);
	ADC_disablePPBEvent(myADC0_BASE, ADC_PPB_NUMBER1, (ADC_EVT_TRIPHI | ADC_EVT_TRIPLO | ADC_EVT_ZERO));
	ADC_disablePPBEventInterrupt(myADC0_BASE, ADC_PPB_NUMBER1, (ADC_EVT_TRIPHI | ADC_EVT_TRIPLO | ADC_EVT_ZERO));
	ADC_setPPBCalibrationOffset(myADC0_BASE, ADC_PPB_NUMBER1, 0);
	ADC_setPPBReferenceOffset(myADC0_BASE, ADC_PPB_NUMBER1, 0);
	ADC_disablePPBTwosComplement(myADC0_BASE, ADC_PPB_NUMBER1);
	ADC_setPPBTripLimits(myADC0_BASE, ADC_PPB_NUMBER1, 0, 0);
	ADC_disablePPBEventCBCClear(myADC0_BASE, ADC_PPB_NUMBER1);
}

/*
 * INTERRUPT Configurations
 */
void INTERRUPT_init()
{
	Interrupt_register(INT_ADCA1, adcA1ISR);
	Interrupt_enable(INT_ADCA1);

	Interrupt_register(INT_ADCA2, adcA2ISR);
	Interrupt_enable(INT_ADCA2);

}
#ifdef __cplusplus

#endif

