/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "adc_ex11_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{


	ADC_init();
	INTERRUPT_init();


}

//*****************************************************************************
//
// ADC Configurations
//
//*****************************************************************************
void ADC_init(){
	myADC0_init();
}

void myADC0_init(){
	//Set ADC AnaSysctrl
	ADC_setVREF(myADC0_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);
	AdcaRegs.ADCINLTRIM1 = ADC_TRIM_VALUE;
	//
	// Configures the analog-to-digital converter module prescaler.
	//
	AdcaRegs.ADCCTL2.bit.PRESCALE = 6;
	//
	// Sets the timing of the end-of-conversion pulse
	//
	AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
	//
	// Powers up the analog-to-digital converter core.
	//
	AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;
	//
	// Delay for 5ms to allow ADC time to power up
	//
	DEVICE_DELAY_US(5000);
	//
	// SOC Configuration: Setup ADC EPWM channel and trigger settings
	//
	// Enables SOC burst mode.
	//
	AdcaRegs.ADCBURSTCTL.bit.BURST_EN = 1;
	//
	// Set SOC burst mode.
	//
	AdcaRegs.ADCBURSTCTL.bit.TRIGSEL = 5;
	AdcaRegs.ADCBURSTCTL.bit.BURSTSIZE = 3;
	//
	// Sets the priority mode of the SOCs.
	//
	AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 7;
	//
	// Start of Conversion 7 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 7
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN0
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC7CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC7CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC7CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC7 = 0;
	//
	// Start of Conversion 8 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 8
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN1
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC8CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC8CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC8CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC8 = 0;
	//
	// Start of Conversion 9 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 9
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC9CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC9CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC9CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC9 = 0;
	//
	// Start of Conversion 10 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 10
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN0
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC10CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC10CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC10CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC10 = 0;
	//
	// Start of Conversion 11 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 11
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN1
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC11CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC11CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC11CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC11 = 0;
	//
	// Start of Conversion 12 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 12
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC12CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC12CTL.bit.CHSEL = 3;
	AdcaRegs.ADCSOC12CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC12 = 0;
	//
	// Start of Conversion 13 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 13
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN0
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC13CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC13CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC13CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC13 = 0;
	//
	// Start of Conversion 14 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 14
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN1
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC14CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC14CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC14CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC14 = 0;
	//
	// Start of Conversion 15 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 15
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN4
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC15CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC15CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC15CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC15 = 0;
	//
	// ADC Interrupt 1 Configuration
	// 		Source	: ADC_SOC_NUMBER9
	// 		Interrupt Source: enabled
	// 		Continuous Mode	: disabled
	//
	//
	AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 9;
	AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
	AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 0;
	//
	// ADC Interrupt 2 Configuration
	// 		Source	: ADC_SOC_NUMBER12
	// 		Interrupt Source: enabled
	// 		Continuous Mode	: disabled
	//
	//
	AdcaRegs.ADCINTSEL1N2.bit.INT2SEL = 12;
	AdcaRegs.ADCINTSEL1N2.bit.INT2E = 1;
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT2 = 1;
	AdcaRegs.ADCINTSEL1N2.bit.INT2CONT = 0;
	//
	// ADC Interrupt 3 Configuration
	// 		Source	: ADC_SOC_NUMBER15
	// 		Interrupt Source: enabled
	// 		Continuous Mode	: disabled
	//
	//
	AdcaRegs.ADCINTSEL3N4.bit.INT3SEL = 15;
	AdcaRegs.ADCINTSEL3N4.bit.INT3E = 1;
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT3 = 1;
	AdcaRegs.ADCINTSEL3N4.bit.INT3CONT = 0;
}


//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************
void INTERRUPT_init(){

	Interrupt_register(INT_ADCA1, &adcABurstISR);
	Interrupt_enable(INT_ADCA1);

	Interrupt_register(INT_ADCA2, &adcABurstISR);
	Interrupt_enable(INT_ADCA2);

	Interrupt_register(INT_ADCA3, &adcABurstISR);
	Interrupt_enable(INT_ADCA3);
}


#ifdef __cplusplus

#endif
