//////#############################################################################
////  @File adc_ex16_board.c
////  @KeyWords ADC Enhanced Post-Processing
////
////
////	This example show Floating Point Scaling,Offset,Grouped Averaging
////
////  @hardware_requirements
////
////
////  @software_requirements
////           TODO
//// 	   TODO FTDI
////  @ExternalConnection
////
////  @Watch Variables
////
//////#############################################################################
///*
// *   Copyright (c) Gejian Semiconductors 2023
// *   All rights reserved.
// *
// *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// *
// */

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "stdio.h"
#include "adc_ex16_board.h"
#include "printf.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
uint16_t myADC0Result0;
uint16_t myADC0Result1;
float32_t MeanGroup0ADCeResult;
/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
//
// Main
//
void main(void)
{
	//
	// Initialize device clock and peripherals
	//
	Device_init();

	UartPrint_init(LOG_SCI_BASE, 115200);
	//
	// Set up ADCs, initializing the SOCs to be triggered by software
	//
	Board_init();
	AdcaResultRegs.ADCMEANEN.bit.SOC0_MEAN0_EN = 1;
	AdcaResultRegs.ADCMEANEN.bit.SOC1_MEAN0_EN = 1;
#if IS_GS32F3xx(0x22)
	AdcaResultRegs.ADCSCALE1 = 3.5;
	AdcaResultRegs.ADCOFFSET0 = 2;
#endif
	//
	// Enable Global Interrupt
	//
	EINT;

	//
	// Loop indefinitely
	//
	while(1)
	{
		//
		// Convert, wait for completion, and store results
		//
		AdcaRegs.ADCSOCFRC1.all = 0x3;
		//
		// Wait for ADCA to complete, then acknowledge flag
		//
    	while(AdcaRegs.ADCINTFLG.bit.ADCINT1 == false)
    	{

        }
    	AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
		//
		// Store results
		//
    	myADC0Result0 = AdcaResultRegs.ADCRESULT0;
    	myADC0Result1 = AdcaResultRegs.ADCRESULT1;
#if IS_GS32F3xx(0x22)
    	MeanGroup0ADCeResult = AdcaResultRegs.ADC32RESULT1;
#endif
	}
}

#ifdef __cplusplus
}
#endif
