/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "aes.h"

/* Golden: 3A60F1EBCC7604379C2002BCA750D4EDF10AB41455E77516BF339F76F45C75E3 */
uint8_t charArr[260]={0xE6, 0x33, 0xA9, 0x68, 0xD9, 0xA2, 0x54, 0x64, 0xA1, 0xAD, 0xA0, 0x6C, 0x1F, 0xF6, 0x22, 0x54, 0x60, 0xE4, 0xE3, 0x8E, 0xE8, 0x98, 0x91, 0xDD, 0x62, 0xFD, 0xBA, 0xDD, 0x59, 0xCE, 0x15, 0x07,
			0x31, 0x83, 0x1B, 0xFA, 0x48, 0x12, 0x8E, 0xD4, 0xC5, 0xD8, 0xC6, 0x3D, 0xA4, 0xF1, 0xFE, 0x89, 0xDF, 0x78, 0xA2, 0xE0, 0xC1, 0x6C, 0x55, 0x76, 0x05, 0x60, 0x54, 0x4B, 0x75, 0x6D, 0xF8, 0xB4,
			0x47, 0xF9, 0xEE, 0x8F, 0x50, 0x81, 0x8F, 0x3B, 0x75, 0xC5, 0x49, 0x8B, 0xE9, 0x85, 0x5E, 0x04, 0x54, 0x76, 0x37, 0x2C, 0xFD, 0x7B, 0x22, 0x88, 0xC7, 0xA3, 0x80, 0x64, 0xE4, 0x1C, 0x60, 0x08,
			0x48, 0x8A, 0x0D, 0xB0, 0x53, 0x88, 0xA2, 0x4E, 0xA3, 0x88, 0x0C, 0x44, 0xB7, 0x86, 0x4F, 0x2D, 0x96, 0x4B, 0xF0, 0x4F, 0xA1, 0x89, 0x14, 0x81, 0xD4, 0x65, 0xFF, 0x1F, 0x2C, 0xC3, 0xB4, 0xA7,
			0x28, 0xD6, 0xEC, 0xE1, 0x6E, 0xBD, 0x4B, 0x82, 0xC9, 0x52, 0xA2, 0xB0, 0x74, 0xEC, 0xD4, 0xE7, 0xEC, 0xF6, 0x37, 0x8F, 0x84, 0xEC, 0x54, 0x64, 0xC1, 0xD8, 0xD1, 0x8A, 0x65, 0xE0, 0xB5, 0x1F,
			0x58, 0x0C, 0xAE, 0xEB, 0x73, 0x37, 0x1C, 0x45, 0x54, 0xC0, 0xDC, 0x18, 0x75, 0x8D, 0x5E, 0xA6, 0xC0, 0x08, 0x36, 0xEC, 0x4D, 0x19, 0xB4, 0x4F, 0xBA, 0x07, 0x91, 0x9A, 0x65, 0x72, 0xC8, 0x5D,
			0x40, 0xB6, 0x1A, 0x50, 0x36, 0x59, 0xCF, 0x96, 0xE8, 0xA7, 0xF5, 0xD1, 0xA8, 0xC1, 0x8A, 0x1A, 0xD0, 0x2B, 0xF2, 0x71, 0x64, 0x16, 0x2D, 0xB3, 0xB8, 0xA0, 0x8E, 0x93, 0x50, 0x96, 0x11, 0x03,
			0xAB, 0x90, 0xC0, 0xA6, 0x0A, 0xA5, 0x70, 0xC2, 0x3A, 0x1F, 0x93, 0x64, 0xC9, 0x83, 0x7D, 0x6C, 0xF6, 0x81, 0xC9, 0x23, 0xBB, 0xDC, 0x65, 0x3F, 0x09, 0xEF, 0x1D, 0x86, 0x09, 0x37, 0x13, 0xC1,
			0x00, 0x01, 0x00, 0x01,
};

uint8_t hash[32] = {1,2,3,4,5,6,7,8,9,0};

int main(void){

    Device_init();

    UartPrint_init(LOG_SCI_BASE, 110000);
	log_set_level(LOG_DEBUG);
	log_info("Hello SPAcc sha256 hash!\r\n");
	log_info("Core running @ %d MHz.\r\n", DEVICE_SYSCLK_FREQ / 1000000);

	log_info("version %08X %08X %08X %08X\n", HWREG(AES_BASE + AES_O_VERSION), HWREG(AES_BASE + AES_O_VERSION_EXT),
											  HWREG(AES_BASE + AES_O_VERSION_EXT_2), HWREG(AES_BASE + AES_O_VERSION_EXT_3));

	log_info("buff @ 0x%08X, hash @ %08X\r\n", (uint32_t)&charArr[1], (uint32_t)&hash[1]);

	SysCtl_setAesLittleEndianAhb(1);

/*****************************************************************************
 * 12ַֽ
******************************************************************************/
	AES_ConfigParams charConfig;
	charConfig.direction 			= AES_DIRECTION_ENCRYPT;	    // ѡģʽ
	charConfig.srcAddr 				= (uint32_t *)(charArr);	    // ַַ
	charConfig.destAddr 			= (uint32_t *)(hash);			// Ŀַ
	charConfig.packetLength 		= 260;		                    // 4ֽNULLַhash㣬洢ʽΪַĵλȴ洢˳Ϊ"DCBA"
	charConfig.destLength 			= sizeof(hash);		            // SHA-256㷨ַΪ32ֽ
	charConfig.keySize 				= AES_KEY_SIZE_NULL;		    // ѡԿΪ
	charConfig.cipherMode 			= AES_CIPH_MODE_NULL;		    // ѡģʽΪ
	charConfig.cipherAlgorithm 		= AES_CIPH_ALG_NULL;		    // ѡ㷨Ϊ
	charConfig.hashMode 			= AES_HASH_MODE_RAW;		    // ѡhashģʽΪraw
	charConfig.hashAlgorithm 		= AES_HASH_ALG_SHA_256;		    // ѡhash㷨Ϊsha256

	AES_configMode(AES_BASE, &charConfig);

	while(AES_IS_BUSY(AES_BASE));	// Ƿڼ

	log_info("sha256 result/golden of charArr is:\r\n");

	for(int i = 0;i<sizeof(hash);i++){
		printf("%02X",hash[i]);
	}

	printf("\r\n");

	printf("3A60F1EBCC7604379C2002BCA750D4EDF10AB41455E77516BF339F76F45C75E3\r\n");

    while (1) {
    }

    return 0;
}


