/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

#include "gs32_math.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */


/*
__sinpuf32
__cospuf32
__atanpuf32
__sin
__cos
__atan
__atan2puf32
__atan2
__tan
__asin
__sqrt
*/


void Trig_wrap(void)
{
	volatile float   input_f32 = MATH_PI_DIV4;
	volatile float   input_f32_2 = -0.125;
	float result_f;
	volatile uint32_t cycle;

	CPU_clearCycleCnt();
	result_f = __sinpuf32( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__sinpuf32	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __cospuf32( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__cospuf32	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __atanpuf32( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__atanpuf32	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __sin( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__sin		( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __cos( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__cos		( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __tan( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__tan		( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __asin( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__asin	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __acos( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__acos	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __atan( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__atan	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __atan2puf32( input_f32 , input_f32_2 );
	cycle = CPU_getCycleCnt();
	log_info("__atan2puf32	( %f, %f )	= %f		cycle:	%u\n", input_f32 , input_f32_2, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __atan2( input_f32 , input_f32_2 );
	cycle = CPU_getCycleCnt();
	log_info("__atan2	( %f, %f )	= %f		cycle:	%u\n",input_f32 , input_f32_2, result_f, cycle);

}

/*
__ftrunc
__ffract
__fsat
__divf32
__fabs
__fmin
__fmax
__sqsumf
__sqrt
__mpy2pif32
__div2pif32
__fdiv3sqrt
__fmul2
__fdiv2
__fdiv3
__fdiv4
__fmul3sqrt
__fmul2_div3
__fmul3sqrt_div2
__fmul3sqrt_div6
__fdiv3sqrt_mul2
__fmul2pi_neg
__fdiv2pi_neg
__neg1_fadd_const
__neg1_fsub_const
__fadd_one
__fsub_one
__fadd_3sqrt
__fsub_3sqrt
__fadd_pi3rd
__fsub_pi3rd
__neg1_fadd_one
__neg1_fsub_one
__neg1_fadd_3sqrt
__neg1_fsub_3sqrt
__neg1_fadd_pi3rd
__neg1_fsub_pi3rd
*/
void Float_wrap(void)
{
	volatile float   input_f32 = 62.135;
	const float   input_f32_2 = -0.125;
	volatile float   input_f32_3 = 5.7;
	float result_f;
	volatile uint32_t cycle;

	CPU_clearCycleCnt();
	result_f = __ftrunc( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__ftrunc	( %f )	= %f			cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __ffract( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__ffract	( %f )	= %f			cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fsat( input_f32 , input_f32_3 , input_f32_2 );
	cycle = CPU_getCycleCnt();
	log_info("__fsat	( %f , %f , %f )	= %f	cycle:	%u\n", input_f32, input_f32_3, input_f32_2, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __divf32( input_f32 , input_f32_3);
	cycle = CPU_getCycleCnt();
	log_info("__divf32	( %f , %f )	= %f		cycle:	%u\n",input_f32, input_f32_3, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fabs( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fabs	( %f )	= %f				cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fmin( input_f32 , input_f32_2 );
	cycle = CPU_getCycleCnt();
	log_info("__fmin	( %f , %f )	= %f		cycle:	%u\n",input_f32, input_f32_2, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fmax( input_f32 , input_f32_2 );
	cycle = CPU_getCycleCnt();
	log_info("__fmax	( %f , %f )	= %f		cycle:	%u\n",input_f32, input_f32_2, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __sqsumf( input_f32 , input_f32_2 );
	cycle = CPU_getCycleCnt();
	log_info("__sqsumf	( %f , %f )	= %f		cycle:	%u\n",input_f32, input_f32_2, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __sqrt( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__sqrt	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __mpy2pif32( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__mpy2pif32	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __div2pif32( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__div2pif32	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fdiv3sqrt( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fdiv3sqrt	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fmul2( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fmul2	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fdiv2( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fdiv2	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fdiv3( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fdiv3	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fdiv4( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fdiv4	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fmul3sqrt( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fmul3sqrt	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fmul2_div3( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fmul2_div3	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fmul3sqrt_div2( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fmul3sqrt_div2	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fmul3sqrt_div6( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fmul3sqrt_div6	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fdiv3sqrt_mul2( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fdiv3sqrt_mul2	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fmul2pi_neg( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fmul2pi_neg		( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fdiv2pi_neg( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fdiv2pi_neg		( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __neg1_fadd_const( input_f32 , input_f32_2 );
	cycle = CPU_getCycleCnt();
	log_info("__neg1_fadd_const	( %f , %f )	= %f	cycle:	%u\n",input_f32, input_f32_2, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __neg1_fsub_const( input_f32 , input_f32_2 );
	cycle = CPU_getCycleCnt();
	log_info("__neg1_fsub_const	( %f , %f )	= %f	cycle:	%u\n",input_f32, input_f32_2, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fadd_one( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fadd_one	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fsub_one( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fsub_one	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fadd_3sqrt( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fadd_3sqrt	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fsub_3sqrt( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fsub_3sqrt	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fadd_pi3rd( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fadd_pi3rd	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __fsub_pi3rd( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__fsub_pi3rd	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __neg1_fadd_one( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__neg1_fadd_one	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __neg1_fsub_one( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__neg1_fsub_one	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __neg1_fadd_3sqrt( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__neg1_fadd_3sqrt	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __neg1_fsub_3sqrt( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__neg1_fsub_3sqrt	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __neg1_fadd_pi3rd( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__neg1_fadd_pi3rd	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __neg1_fsub_pi3rd( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__neg1_fsub_pi3rd	( %f )	= %f	cycle:	%u\n",input_f32, result_f, cycle);

}


/* Need to add exp_math static library */
void exp_math(void)
{
	volatile float   input_f32 = 7.135;
	volatile float   input_f32_2 = 5.7;
	float result_f;
	volatile uint32_t cycle;

	CPU_clearCycleCnt();
	result_f = __expf32( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__expf32	( %f )	= %f		cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __logf32( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("__logf32	( %f )	= %f		cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = __powf32( input_f32 , input_f32_2 );
	cycle = CPU_getCycleCnt();
	log_info("__powf32	( %f , %f )	= %f	cycle:	%u\n",input_f32, input_f32_2, result_f, cycle);
}
